<?php
/**
 * Business Aarambha Theme Customizer Header Account settings
 *
 * @package Business_Aarambha
 */

class Business_Aarambha_Customize_Header_Account_Fields extends Business_Aarambha_Customize_Base_Field {


    /**
     * Arguments for fields.
     *
     * @return void
     */
    public function init() {
        $this->args = [
            // Grouping Settings
            'business_aarambha_header_account_group_settings' => [
                'type'              => 'group',
                'section'           => 'account',
                'priority'          => 10,
                'choices'           => [
                    'normal'            => array(
                        'tab-title'     => esc_html__( 'General', 'business-aarambha' ),
                        'controls'      => array(
                            'business_aarambha_header_account_note_one',
                            'business_aarambha_header_account_login_text',
                            'business_aarambha_header_account_login_url',
                            'business_aarambha_header_account_note_two',
                            'business_aarambha_header_account_logout_text',
                            'business_aarambha_header_account_logout_url',
                            'business_aarambha_header_account_note_three',
                            'business_aarambha_header_account_url_target'
                        )
                    ),
                    'hover'         => array(
                        'tab-title'     => esc_html__( 'Style', 'business-aarambha' ),
                        'controls'      => array(
                            'business_aarambha_header_account_icon_color',
                            'business_aarambha_header_account_background',
                            'business_aarambha_header_account_padding',
                            'business_aarambha_header_account_margin'
                        )
                    )
                ]
            ],
            // Note One
            'business_aarambha_header_account_note_one' => [
                'type'              => 'heading',
                'label'             => esc_html__( 'LOGIN', 'business-aarambha' ),
                'section'           => 'account',
                'priority'          => 15,
            ],
            // Login Text
            'business_aarambha_header_account_login_text' => [
                'type'              => 'text',
                'default'           => esc_html__( 'My Account', 'business-aarambha' ),
                'sanitize_callback' => 'sanitize_text_field',
                'label'             => esc_html__( 'Text', 'business-aarambha' ),
                'section'           => 'account',
                'priority'          => 20,
            ],
            // Account URL
            'business_aarambha_header_account_login_url' => [
                'type'              => 'url',
                'default'           => '#',
                'sanitize_callback' => 'esc_url_raw',
                'label'             => esc_html__( 'URL', 'business-aarambha' ),
                'section'           => 'account',
                'priority'          => 25,
            ],
            // Note Two
            'business_aarambha_header_account_note_two' => [
                'type'              => 'heading',
                'label'             => esc_html__( 'LOGOUT', 'business-aarambha' ),
                'section'           => 'account',
                'priority'          => 30,
            ],
            // Logout Text
            'business_aarambha_header_account_logout_text' => [
                'type'              => 'text',
                'default'           => esc_html__( 'Log In', 'business-aarambha' ),
                'sanitize_callback' => 'sanitize_text_field',
                'label'             => esc_html__( 'Text', 'business-aarambha' ),
                'section'           => 'account',
                'priority'          => 35,
            ],
            //  Logout URL
            'business_aarambha_header_account_logout_url' => [
                'type'              => 'url',
                'default'           => wp_login_url(),
                'sanitize_callback' => 'esc_url_raw',
                'label'             => esc_html__( 'URL', 'business-aarambha' ),
                'section'           => 'account',
                'priority'          => 40,
            ],
            // Note Three
            'business_aarambha_header_account_note_three' => [
                'type'              => 'heading',
                'label'             => esc_html__( 'SETTINGS', 'business-aarambha' ),
                'section'           => 'account',
                'priority'          => 45,
            ],
            // Link Open
            'business_aarambha_header_account_url_target' => [
                'type'              => 'toggle',
                'default'           => '',
                'section'           => 'account',
                'priority'          => 75,
                'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_toggle' ],
                'label'             => esc_html__( 'Link Open', 'business-aarambha' ),
                'description'       => esc_html__( 'Toggle to enable link open in new window tab.', 'business-aarambha' ),
            ],
            // Icon Color
            'business_aarambha_header_account_icon_color' => [
                'type'              => 'color',
                'default'           => [
                    'color_2'           => 'var(--color-2)'
                ],
                'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_color' ],
                'label'             => esc_html__( 'Account', 'business-aarambha' ),
                'description'       => esc_html__( 'Set account text color.', 'business-aarambha' ),
                'section'           => 'account',
                'colors'            => [
                    'color_1'           => esc_html__( 'Normal', 'business-aarambha' ),
                    'color_2'           => esc_html__( 'Hover', 'business-aarambha' ),
                ],
                'priority'          => 80,
                'inherits'          => [
                    'color_1'           => 'var(--color-link)',
                    'color_2'           => 'var(--color-2)',
                ]
            ],

            // Background
            'business_aarambha_header_account_background' => [
                'type'              => 'color',
                'default'           => [
                    'color_2'           => 'var(--color-bg-3)'
                ],
                'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_color' ],
                'label'             => esc_html__( 'Background', 'business-aarambha' ),
                'description'       => esc_html__( 'Set account background.', 'business-aarambha' ),
                'section'           => 'account',
                'colors'            => [
                    'color_1'           => esc_html__( 'Normal', 'business-aarambha' ),
                    'color_2'           => esc_html__( 'Hover', 'business-aarambha' ),
                ],
                'priority'          => 90,
                'inherits'          => [
                    'color_1'           => 'var(--color-bg-1)',
                    'color_2'           => 'var(--color-bg-3)',
                ]
            ],
		
            // Padding
            'business_aarambha_header_account_padding' => [
                'type'              => 'dimensions',
                'default'           => [
                    'desktop'           => [
                        'side_1'            => '12px',
                        'side_2'            => '18px',
                        'side_3'            => '12px',
                        'side_4'            => '18px',
                        'linked'            => 'off'
                    ]
                ],
                'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_dimensions' ],
                'label'             => esc_html__( 'Padding', 'business-aarambha' ),
                'description'       => esc_html__( 'Set account padding.', 'business-aarambha' ),
                'section'           => 'account',
                'responsive'        => [ 'desktop', 'tablet', 'mobile' ],
                'priority'          => 105,
            ],
            // Margin
            'business_aarambha_header_account_margin' => [
                'type'              => 'dimensions',
                'default'           => '',
                'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_dimensions' ],
                'label'             => esc_html__( 'Margin', 'business-aarambha' ),
                'description'       => esc_html__( 'Set account margin.', 'business-aarambha' ),
                'section'           => 'account',
                'responsive'        => [ 'desktop', 'tablet', 'mobile' ],
                'priority'          => 110,
            ],

        ];
    }

}
new Business_Aarambha_Customize_Header_Account_Fields();
