<?php
/**
 * Business Aarambha Theme Customizer Footer Widget settings
 *
 * @package Business_Aarambha
 */

class Business_Aarambha_Customize_Footer_Widget_Fields extends Business_Aarambha_Customize_Base_Field {

    /**
     * Arguments for fields.
     *
     * @return void
     */
    public function init() {
        $this->args = [
			// Widgets Title
			'business_aarambha_footer_builder_widget_title_typo' => [
				'type'              => 'typography',
				'default'           => '',
				'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_typography' ],
				'label'             => esc_html__( 'Widget Title', 'business-aarambha' ),
				'section'           => 'business_aarambha_footer_builder_widget_section',
				'priority'          => 20,
				'inherits'          => [
					'color_1'           => 'var(--color-heading)',
				],
				'fields'			=> ['colors' => true]
			],
			// Widgets Content
			'business_aarambha_footer_builder_widget_content_typo' => [
				'type'              => 'typography',
				'default'           => '',
				'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_typography' ],
				'label'             => esc_html__( 'Widget Content', 'business-aarambha' ),
				'section'           => 'business_aarambha_footer_builder_widget_section',
				'priority'          => 25,
				'colors'            => [
					'color_1'           => esc_html__( 'Normal', 'business-aarambha' ),
					'color_2'           => esc_html__( 'Hover', 'business-aarambha' ),
				],
				'inherits'          => [
					'color_1'           => 'var(--color-2)',
					'color_2'           => 'var(--color-link-hover)',
				],
				'fields'			=> ['colors' => true]
			],
            // Padding
            'business_aarambha_footer_builder_widget_padding' => [
                'type'              => 'dimensions',
                'default'           => '',
                'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_dimensions' ],
                'label'             => esc_html__( 'Padding', 'business-aarambha' ),
                'description'       => esc_html__( 'Set each footer widgets wrapper padding.', 'business-aarambha' ),
                'section'           => 'business_aarambha_footer_builder_widget_section',
                'priority'          => 30,
                'responsive'        => [ 'desktop', 'tablet', 'mobile' ],
            ],
        ];
    }

}
new Business_Aarambha_Customize_Footer_Widget_Fields();
