<?php
/**
 * Business Aarambha Theme Customizer Footer Menu settings
 *
 * @package Business_Aarambha
 */

class Business_Aarambha_Customize_Footer_Menu_Fields extends Business_Aarambha_Customize_Base_Field {

    /**
     * Arguments for fields.
     *
     * @return void
     */
    public function init() {
        $this->args = [
            // Grouping Settings
            'business_aarambha_footer_menu_group_settings' => [
                'type'              => 'group',
                'section'           => 'footer_menu',
                'priority'          => 10,
                'choices'           => [
                    'normal'            => array(
                        'tab-title'     => esc_html__( 'General', 'business-aarambha' ),
                        'controls'      => array(
                            'business_aarambha_footer_menu_note_one',
                            'business_aarambha_footer_menu_spacing',
                        )
                    ),
                    'hover'         => array(
                        'tab-title'     => esc_html__( 'Style', 'business-aarambha' ),
                        'controls'      => array(
                            'business_aarambha_footer_menu_font_colors',
                            'business_aarambha_footer_menu_background_color',
							'business_aarambha_footer_menu_note_six',
							'business_aarambha_footer_menu_container_padding',
							'business_aarambha_footer_menu_container_margin'
                        )
                    )
                ]
            ],
            // Note One
            'business_aarambha_footer_menu_note_one' => [
                'type'              => 'heading',
                'description'       => sprintf(__( 'To set menu, go to <a data-type="section" data-id="menu_locations" class="customizer-focus"><strong>Footer Menu</strong></a>', 'business-aarambha' )),
                'section'           => 'footer_menu',
                'priority'          => 10,
            ],
            // Items Spacing
            'business_aarambha_footer_menu_spacing' => [
                'type'              => 'range',
                'default'           => '',
                'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_range' ],
                'label'             => esc_html__( 'Menu Spacing', 'business-aarambha' ),
                'description'       => esc_html__( 'Slide to set Menu Spacing.', 'business-aarambha' ),
                'section'           => 'footer_menu',
                'responsive'        => [ 'desktop', 'tablet', 'mobile' ],
                'priority'          => 20
            ],
            // Menu font color
            'business_aarambha_footer_menu_font_colors' => [
                'type'              => 'color',
                'default'           => '',
                'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_color' ],
                'label'             => esc_html__( 'Font Colors', 'business-aarambha' ),
                'description'       => esc_html__( 'Set menu normal and hover colors.', 'business-aarambha' ),
                'section'           => 'footer_menu',
                'colors'            => [
                    'color_1'           => esc_html__( 'Normal', 'business-aarambha' ),
                    'color_2'           => esc_html__( 'Hover', 'business-aarambha' )
                ],
                'priority'          => 35,
                'inherits'            => [
                    'color_1'           => 'var(--color-link)',
                    'color_2'           => 'var(--color-link-hover)',
                ],
            ],
            // Menu Background
            'business_aarambha_footer_menu_background_color' => [
                'type'              => 'color',
                'default'           => '',
                'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_color' ],
                'label'             => esc_html__( 'Background', 'business-aarambha' ),
                'description'       => esc_html__( 'Set menu each item background.', 'business-aarambha' ),
                'section'           => 'footer_menu',
                'colors'            => [
                    'color_1'           => esc_html__( 'Normal', 'business-aarambha' ),
                    'color_2'           => esc_html__( 'Hover', 'business-aarambha' )
                ],
                'priority'          => 40,
                'inherits'            => [
                    'color_1'           => 'var(--color-bg-1)',
                    'color_2'           => 'var(--color-bg-1)',
                ],
            ],
			// Heading four
			'business_aarambha_footer_menu_note_six' => [
				'type'              => 'heading',
				'label'             => esc_html__( 'CONTAINER', 'business-aarambha' ),
				'section'           => 'footer_menu',
				'priority'          => 65,
			],
			// Container Padding
			'business_aarambha_footer_menu_container_padding' => [
				'type'              => 'dimensions',
				'default'           => '',
				'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_dimensions' ],
				'label'             => esc_html__( 'Padding', 'business-aarambha' ),
				'description'       => esc_html__( 'Set Padding to the Footer Menu.', 'business-aarambha' ),
				'section'           => 'footer_menu',
				'responsive'        => [ 'desktop', 'tablet', 'mobile' ],
				'priority'          => 70,
			],
			// Container Margin
			'business_aarambha_footer_menu_container_margin' => [
				'type'              => 'dimensions',
				'default'           => '',
				'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_dimensions' ],
				'label'             => esc_html__( 'Margin', 'business-aarambha' ),
				'description'       => esc_html__( 'Set Margin to the Footer Menu.', 'business-aarambha' ),
				'section'           => 'footer_menu',
				'responsive'        => [ 'desktop', 'tablet', 'mobile' ],
				'priority'          => 75,
			],
        ];
    }

}
new Business_Aarambha_Customize_Footer_Menu_Fields();
