<?php
/**
 * Business Aarambha Theme Customizer Footer Main Row settings
 *
 * @package Business_Aarambha
 */

class Business_Aarambha_Customize_Footer_Main_Row_Fields extends Business_Aarambha_Customize_Base_Field {

    /**
     * Arguments for fields.
     *
     * @return void
     */
    public function init() {
        $this->args = [
            // Grouping Settings
            'business_aarambha_footer_main_row_group_settings' => [
                'type'              => 'group',
                'section'           => 'business_aarambha_footer_main',
                'priority'          => 5,
                'choices'           => [
                    'normal'            => array(
                        'tab-title'     => esc_html__( 'General', 'business-aarambha' ),
                        'controls'      => array(
                            'business_aarambha_footer_main_row_left_col_content_justify',
                            'business_aarambha_footer_main_row_center_col_content_justify',
                            'business_aarambha_footer_main_row_right_col_content_justify'
                        )
                    ),
                    'hover'         => array(
                        'tab-title'     => esc_html__( 'Style', 'business-aarambha' ),
                        'controls'      => array(
                            'business_aarambha_footer_main_row_background_overlay',
                            'business_aarambha_footer_main_row_padding'
                        )
                    )
                ]
            ],
			// Left Column Justify Content
			'business_aarambha_footer_main_row_left_col_content_justify' => [
				'type'              => 'buttonset',
				'default'           => [
					'desktop'   => 'start',
					'tablet'    => 'start',
					'mobile'    => 'start'
				],
				'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_buttonset' ],
				'label'             => esc_html__( 'Left Column', 'business-aarambha' ),
				'description'       => esc_html__( 'Choose position for the content in the Left Column.', 'business-aarambha' ),
				'section'           => 'business_aarambha_footer_main',
				'priority'          => 17,
				'choices'           => [
					'start'     => esc_html__( 'Start', 'business-aarambha' ),
					'center'    => esc_html__( 'Center', 'business-aarambha' ),
					'end'       => esc_html__( 'End', 'business-aarambha' )
				],
				'responsive'        => ['desktop','tablet','mobile'],
			],
			// Center Column Justify Content
			'business_aarambha_footer_main_row_center_col_content_justify' => [
				'type'              => 'buttonset',
				'default'           => [
					'desktop'   => 'center',
					'tablet'    => 'center',
					'mobile'    => 'center'
				],
				'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_buttonset' ],
				'label'             => esc_html__( 'Center Column', 'business-aarambha' ),
				'description'       => esc_html__( 'Choose position for the content in the Center Column.', 'business-aarambha' ),
				'section'           => 'business_aarambha_footer_main',
				'priority'          => 18,
				'choices'           => [
					'start'     => esc_html__( 'Start', 'business-aarambha' ),
					'center'    => esc_html__( 'Center', 'business-aarambha' ),
					'end'       => esc_html__( 'End', 'business-aarambha' )
				],
				'responsive'        => ['desktop','tablet','mobile'],
			],
			// Right Column Justify Content
			'business_aarambha_footer_main_row_right_col_content_justify' => [
				'type'              => 'buttonset',
				'default'           => [
					'desktop'   => 'end',
					'tablet'    => 'end',
					'mobile'    => 'end'
				],
				'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_buttonset' ],
				'label'             => esc_html__( 'Right Column', 'business-aarambha' ),
				'description'       => esc_html__( 'Choose position for the content in the Right Column.', 'business-aarambha' ),
				'section'           => 'business_aarambha_footer_main',
				'priority'          => 19,
				'choices'           => [
					'start'     => esc_html__( 'Start', 'business-aarambha' ),
					'center'    => esc_html__( 'Center', 'business-aarambha' ),
					'end'       => esc_html__( 'End', 'business-aarambha' )
				],
				'responsive'        => ['desktop','tablet','mobile'],
			],
            // Background Overlay
            'business_aarambha_footer_main_row_background_overlay' => [
                'type'              => 'background',
				'default'           => [
					'background'        => 'color',
					'colors'            => [
						'color_1'           => 'rgba(0,0,0,0.22)'
					]
				],
                'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_background' ],
                'label'             => esc_html__( 'Background Overlay', 'business-aarambha' ),
                'description'       => esc_html__( 'Set Background overlay color for main row container.', 'business-aarambha' ),
                'section'           => 'business_aarambha_footer_main',
                'priority'          => 20,
                'inherits'          => [
                    'color_1'           => 'rgba(0,0,0,0.22)'
                ],
                'fields'            => ['colors' => true],
            ],
            // Padding
            'business_aarambha_footer_main_row_padding' => [
                'type'              => 'dimensions',
                'default'           => [
                    'desktop'           => [
                        'side_1'            => '25px',
                        'side_3'            => '25px',
                        'linked'            => 'off'
                    ]
                ],
                'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_dimensions' ],
                'label'             => esc_html__( 'Padding', 'business-aarambha' ),
                'section'           => 'business_aarambha_footer_main',
                'priority'          => 35,
                'description'       => esc_html__( 'Set footer main row padding.', 'business-aarambha' ),
                'responsive'        => [ 'desktop', 'tablet', 'mobile' ]
            ]
        ];
    }

}
new Business_Aarambha_Customize_Footer_Main_Row_Fields();
