<?php
/**
 * Business Aarambha Theme Customizer Footer Back to Top Button settings
 *
 * @package Business_Aarambha
 */

class Business_Aarambha_Customize_Footer_Back_To_Top_Fields extends Business_Aarambha_Customize_Base_Field {

    /**
     * Arguments for fields.
     *
     * @return void
     */
    public function init() {
        $this->args = [
            // Enable
            'business_aarambha_footer_back_to_top_enable' => [
                'type'              => 'toggle',
                'default'           => ['desktop'=>'true'],
                'priority'          => 5,
                'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_toggle' ],
                'label'             => esc_html__( 'Scroll to Top', 'business-aarambha' ),
                'description'       => esc_html__( 'Enable button to scroll to top.', 'business-aarambha' ),
                'section'           => 'business_aarambha_footer_builder_back_to_top_section',
            ]
        ];
    }

}
new Business_Aarambha_Customize_Footer_Back_To_Top_Fields();
