<?php
/**
 * Business Aarambha Theme Customizer
 *
 * @package Business_Aarambha
 */

/**
 * Business_Aarambha_Customizer class
 */
class Business_Aarambha_Customizer {

    /**
     * Setup class.
     *
     */
    public function __construct() {

        add_action( 'customize_register', [ $this, 'business_aarambha_customize_register' ], 10, 1 );

        add_action( 'customize_preview_init', [ $this, 'business_aarambha_customize_preview_js' ], 10 );

        add_action( 'customize_controls_enqueue_scripts', [ $this, 'business_aarambha_customize_js' ] );

        add_action( 'after_setup_theme', [ $this, 'business_aarambha_customize_option_fields' ] );
    }

    /**
     * Add postMessage support for site title and description for the Theme Customizer.
     *
     * @param WP_Customize_Manager $wp_customize Theme Customizer object.
     */
    public function business_aarambha_customize_register( $wp_customize ) {

        $wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
        $wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';

        $wp_customize->remove_control('header_textcolor');
        $wp_customize->remove_control('header_image');

        /** Move default sections to global panel */

        $wp_customize->get_section( 'colors' )->panel           = 'business_aarambha_global_panel';
        $wp_customize->get_section( 'colors' )->priority        = 5;

        $wp_customize->get_section( 'title_tagline' )->panel    = 'business_aarambha_header';
        $wp_customize->get_section( 'title_tagline' )->priority = 35;

        $wp_customize->get_control( 'custom_logo' )->priority   = 15;
        $wp_customize->get_control( 'blogname' )->priority      = 20;
        $wp_customize->get_control( 'blogdescription' )->priority = 25;
        $wp_customize->get_control( 'site_icon' )->priority = 30;
        

        // customizer dir path.
        $customizer_dir = BUSINESS_AARAMBHA_DIR . 'inc/customizer';

        // Selective refresh
        require $customizer_dir . '/selective-refresh.php';

        // Customizer sanitize callback functions
        require_once $customizer_dir . '/Business_Aarambha_Customizer_Sanitize_Callback.php';

        // Custom Section
        require_once $customizer_dir . '/sections/Business_Aarambha_Customize_Custom_Section.php';

        // Load base class for controls.
        require_once $customizer_dir . '/controls/base/Business_Aarambha_Customize_Base_Control.php';
        // Load custom control classes.
        require_once $customizer_dir . '/controls/background/Business_Aarambha_Customize_Background_Control.php';
        require_once $customizer_dir . '/controls/border/Business_Aarambha_Customize_Border_Control.php';
        require_once $customizer_dir . '/controls/box-shadow/Business_Aarambha_Customize_Box_Shadow_Control.php';
        require_once $customizer_dir . '/controls/typography/Business_Aarambha_Customize_Typography_Control.php';
        require_once $customizer_dir . '/controls/sortable/Business_Aarambha_Customize_Sortable_Control.php';
        require_once $customizer_dir . '/controls/group/Business_Aarambha_Customize_Group_Control.php';
        require_once $customizer_dir . '/controls/toggle/Business_Aarambha_Customize_Toggle_Control.php';
        require_once $customizer_dir . '/controls/color/Business_Aarambha_Customize_Color_Control.php';
        require_once $customizer_dir . '/controls/buttonset/Business_Aarambha_Customize_Buttonset_Control.php';
        require_once $customizer_dir . '/controls/range/Business_Aarambha_Customize_Range_Control.php';
        require_once $customizer_dir . '/controls/dimensions/Business_Aarambha_Customize_Dimensions_Control.php';
        require_once $customizer_dir . '/controls/radio-image/Business_Aarambha_Customize_Radio_Image_Control.php';
        require_once $customizer_dir . '/controls/heading/Business_Aarambha_Customize_Heading_Control.php';
        require_once $customizer_dir . '/controls/select/Business_Aarambha_Customize_Select_Control.php';
        require_once $customizer_dir . '/controls/select/Business_Aarambha_Customize_Multi_Select_Control.php';
        require_once $customizer_dir . '/controls/select/Business_Aarambha_Customize_Icon_Select_Control.php';
        require_once $customizer_dir . '/controls/repeater/Business_Aarambha_Customize_Repeater_Control.php';
        require_once $customizer_dir . '/controls/repeater/Business_Aarambha_Customize_Repeater_Setting.php';
        require_once $customizer_dir . '/controls/editor/Business_Aarambha_Customize_Editor_Control.php';

        /**
         * Add Panels
         */
        self::business_aarambha_add_panels( $wp_customize );

        /**
         * Add Sections
         */
        self::business_aarambha_add_sections( $wp_customize );

        /**
         * Add Repeater Fields
         */
        self::business_aarambha_add_repeater_fields( $wp_customize );
    }

    /**
     * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
     */
    public function business_aarambha_customize_preview_js() {

        wp_enqueue_script( 'business-aarambha-customizer-preview', BUSINESS_AARAMBHA_URI . 'assets/js/customizer-preview' . BUSINESS_AARAMBHA_SCRIPT_PREFIX . '.js', array( 'customize-preview' ), BUSINESS_AARAMBHA_VERSION, true );
    }

    /**
     * heme Customizer JS
     */
    public function business_aarambha_customize_js() {

        // Enqueue the style.
        wp_enqueue_style( 'business-aarambha-customize-controls', BUSINESS_AARAMBHA_URI . 'assets/css/customize-controls' . BUSINESS_AARAMBHA_SCRIPT_PREFIX . '.css', null, BUSINESS_AARAMBHA_VERSION, 'all' );

        // Add output of Customizer settings as inline style.
        wp_add_inline_style( 'business-aarambha-customize-controls', Business_Aarambha_Customizer_Inline_Style::css_output('customizer') );

        // Enqueue alpha color picker script
        wp_enqueue_script( 'wp-color-picker-alpha', BUSINESS_AARAMBHA_URI . 'assets/js/wp-color-picker-alpha' . BUSINESS_AARAMBHA_SCRIPT_PREFIX . '.js', [ 'jquery', 'wp-color-picker' ], '2.1.4', true );

        // Enqueue the font awesome style.
        wp_enqueue_style( 'font-awesome', BUSINESS_AARAMBHA_URI .'assets/css/font-awesome' . BUSINESS_AARAMBHA_SCRIPT_PREFIX . '.css', array(), '4.7.0' );

        // Enqueue the scripts.
        wp_enqueue_script( 'business-aarambha-customize-controls', BUSINESS_AARAMBHA_URI . 'assets/js/customize-controls' . BUSINESS_AARAMBHA_SCRIPT_PREFIX . '.js', [ 'customize-base', 'wp-color-picker-alpha', 'jquery-ui-sortable' ], BUSINESS_AARAMBHA_VERSION, true );

        wp_enqueue_script( 'business-aarambha-customizer', BUSINESS_AARAMBHA_URI . 'assets/js/customizer' . BUSINESS_AARAMBHA_SCRIPT_PREFIX . '.js', array( 'jquery', 'customize-controls' ), BUSINESS_AARAMBHA_VERSION, false );
    }

    /**
     * Render the site title for the selective refresh partial.
     *
     * @return void
     */
    public function business_aarambha_customize_partial_blogname() {
        bloginfo( 'name' );
    }

    /**
     * Render the site tagline for the selective refresh partial.
     *
     * @return void
     */
    public function business_aarambha_customize_partial_blogdescription() {
        bloginfo( 'description' );
    }

    /**
     * Include customizer options.
     */
    public function business_aarambha_customize_option_fields() {

        /**
         * Customizer outputs
         */
        require BUSINESS_AARAMBHA_DIR . 'inc/customizer/Business_Aarambha_Customizer_Inline_Style.php';

        /**
         * Base field class.
         */
        require BUSINESS_AARAMBHA_DIR . 'inc/customizer/options/Business_Aarambha_Customize_Base_Field.php';

        /**
         * Global Fields
         */
        require BUSINESS_AARAMBHA_DIR . 'inc/customizer/options/global/Business_Aarambha_Customize_Global_Social_Fields.php';
        require BUSINESS_AARAMBHA_DIR . 'inc/customizer/options/global/Business_Aarambha_Customize_Global_Placeholder_Fields.php';
        require BUSINESS_AARAMBHA_DIR . 'inc/customizer/options/global/Business_Aarambha_Customize_Global_Body_Fields.php';
        require BUSINESS_AARAMBHA_DIR . 'inc/customizer/options/global/Business_Aarambha_Customize_Global_Site_Content_Fields.php';
        require BUSINESS_AARAMBHA_DIR . 'inc/customizer/options/global/Business_Aarambha_Customize_Global_Page_Header_Fields.php';
        require BUSINESS_AARAMBHA_DIR . 'inc/customizer/options/global/Business_Aarambha_Customize_Global_Post_Meta_Fields.php';
        require BUSINESS_AARAMBHA_DIR . 'inc/customizer/options/global/Business_Aarambha_Customize_Global_Sidebar_Fields.php';
        require BUSINESS_AARAMBHA_DIR . 'inc/customizer/options/global/Business_Aarambha_Customize_Global_Typography_Fields.php';
        require BUSINESS_AARAMBHA_DIR . 'inc/customizer/options/global/Business_Aarambha_Customize_Global_Color_Fields.php';

        /**
         * Header Banner
         */
        require BUSINESS_AARAMBHA_DIR . 'inc/customizer/options/banner/Business_Aarambha_Customize_Banner_General_Fields.php';
        require BUSINESS_AARAMBHA_DIR . 'inc/customizer/options/banner/Business_Aarambha_Customize_Banner_Post_Content_Fields.php';
        require BUSINESS_AARAMBHA_DIR . 'inc/customizer/options/banner/Business_Aarambha_Customize_Banner_Post_Title_Fields.php';
        require BUSINESS_AARAMBHA_DIR . 'inc/customizer/options/banner/Business_Aarambha_Customize_Banner_Read_More_Fields.php';

        /**
         * Blog Posts Fields
         */
        require BUSINESS_AARAMBHA_DIR . 'inc/customizer/options/blog-posts/Business_Aarambha_Customize_Blog_Page_Header_Fields.php';
        require BUSINESS_AARAMBHA_DIR . 'inc/customizer/options/blog-posts/Business_Aarambha_Customize_Blog_Posts_Content_Fields.php';
        require BUSINESS_AARAMBHA_DIR . 'inc/customizer/options/blog-posts/Business_Aarambha_Customize_Blog_Post_Featured_Image_Fields.php';
        require BUSINESS_AARAMBHA_DIR . 'inc/customizer/options/blog-posts/Business_Aarambha_Customize_Blog_Post_Title_Fields.php';
        require BUSINESS_AARAMBHA_DIR . 'inc/customizer/options/blog-posts/Business_Aarambha_Customize_Blog_Post_Read_More_Fields.php';
        require BUSINESS_AARAMBHA_DIR . 'inc/customizer/options/blog-posts/Business_Aarambha_Customize_Blog_Pagination_Fields.php';
        require BUSINESS_AARAMBHA_DIR . 'inc/customizer/options/blog-posts/Business_Aarambha_Customize_Blog_Sidebar_Fields.php';

        /**
         * Single Posts Fields
         */
        require BUSINESS_AARAMBHA_DIR . 'inc/customizer/options/single-post/Business_Aarambha_Customize_Single_Post_Content_Fields.php';
        require BUSINESS_AARAMBHA_DIR . 'inc/customizer/options/single-post/Business_Aarambha_Customize_Single_Post_Header_Fields.php';
        require BUSINESS_AARAMBHA_DIR . 'inc/customizer/options/single-post/Business_Aarambha_Customize_Single_Post_Featured_Image_Fields.php';
        require BUSINESS_AARAMBHA_DIR . 'inc/customizer/options/single-post/Business_Aarambha_Customize_Single_Post_Title_Fields.php';
        require BUSINESS_AARAMBHA_DIR . 'inc/customizer/options/single-post/Business_Aarambha_Customize_Single_Post_Sidebar_Fields.php';

        /**
         * Single Page Fields
         */
        require BUSINESS_AARAMBHA_DIR . 'inc/customizer/options/single-page/Business_Aarambha_Customize_Single_Page_Content_Fields.php';
        require BUSINESS_AARAMBHA_DIR . 'inc/customizer/options/single-page/Business_Aarambha_Customize_Single_Page_Header_Fields.php';
        require BUSINESS_AARAMBHA_DIR . 'inc/customizer/options/single-page/Business_Aarambha_Customize_Single_Page_Featured_Image_Fields.php';
        require BUSINESS_AARAMBHA_DIR . 'inc/customizer/options/single-page/Business_Aarambha_Customize_Single_Page_Title_Fields.php';
        require BUSINESS_AARAMBHA_DIR . 'inc/customizer/options/single-page/Business_Aarambha_Customize_Single_Page_Sidebar_Fields.php';
        /**
         * 404 Page Fields
         */
		require BUSINESS_AARAMBHA_DIR . 'inc/customizer/options/404-page/Business_Aarambha_Customize_404_Page_Header_Fields.php';
        require BUSINESS_AARAMBHA_DIR . 'inc/customizer/options/404-page/Business_Aarambha_Customize_404_Page_Content_Fields.php';
    }

    /**
     * Add customizer panels
     *
     * @access public
     * @param object $wp_customize the object.
     * @return void
     */
    public static function business_aarambha_add_panels( $wp_customize ) {

        $panels = [
            'global'        => [
                'title'         => esc_html__( 'Global', 'business-aarambha' ),
                'priority'      => 10,
            ],
            'banner'        => [
                'title'         => esc_html__( 'Header Banner', 'business-aarambha' ),
                'priority'      => 16,
            ],

            'blog_posts'        => [
                'title'         => esc_html__( 'Blog/Archive Posts', 'business-aarambha' ),
                'priority'      => 30,
            ],
            'single_post'       => [
                'title'         => esc_html__( 'Single Post', 'business-aarambha' ),
                'priority'      => 35,
            ],
            'single_page'        => [
                'title'         => esc_html__( 'Single Page', 'business-aarambha' ),
                'priority'      => 55,
            ],
			'404_page'        => [
				'title'         => esc_html__( '404 Page', 'business-aarambha' ),
				'priority'      => 60,
			],
        ];

        foreach ( $panels as $panel_id => $panel_args ) {
            $wp_customize->add_panel( 'business_aarambha_' . str_replace( '-', '_', $panel_id ) . '_panel', $panel_args );
        }
    }

    /**
     * Add customizer sections
     *
     * @access public
     * @param object $wp_customize the object.
     * @return void
     */
    public static function business_aarambha_add_sections( $wp_customize ) {

        $sections = [];

        /*--------------------------------------------------------------
        # Global Sections
        --------------------------------------------------------------*/
        // Typography
        $sections['typography']   = [
            'title'                 => esc_html__( 'Typography', 'business-aarambha' ),
            'panel'                 => 'business_aarambha_global_panel',
            'priority'              => 10
        ];
        // Body
        $sections['body']   = [
            'title'                 => esc_html__( 'Body', 'business-aarambha' ),
            'panel'                 => 'business_aarambha_global_panel',
            'priority'              => 10
        ];
        // Site Content
        $sections['site_content']   = [
            'title'                 => esc_html__( 'Site Content', 'business-aarambha' ),
            'panel'                 => 'business_aarambha_global_panel',
            'priority'              => 15
        ];
        // Page Header
        $sections['page_header']   = [
            'title'                 => esc_html__( 'Page Header', 'business-aarambha' ),
            'panel'                 => 'business_aarambha_global_panel',
            'priority'              => 30
        ];
		// Post Meta
		$sections['post_meta']   = [
			'title'                 => esc_html__( 'Post Meta', 'business-aarambha' ),
			'panel'                 => 'business_aarambha_global_panel',
			'priority'              => 35
		];
        // Sidebar
        $sections['sidebar']   = [
            'title'                 => esc_html__( 'Sidebar', 'business-aarambha' ),
            'panel'                 => 'business_aarambha_global_panel',
            'priority'              => 40
        ];
        // Social
        $sections['social']   = [
            'title'                 => esc_html__( 'Social', 'business-aarambha' ),
            'panel'                 => 'business_aarambha_global_panel',
            'priority'              => 45
        ];

        // Placeholder
        $sections['placeholder']   = [
            'title'                 => esc_html__( 'Placeholder Image', 'business-aarambha' ),
            'panel'                 => 'business_aarambha_global_panel',
            'priority'              => 50
        ];
        /*--------------------------------------------------------------
        # Header Sections
        --------------------------------------------------------------*/
        // Header General
        $sections['header_general']   = [
            'title'                 => esc_html__( 'Header General', 'business-aarambha' ),
            'panel'                 => 'business_aarambha_header_panel',
            'priority'              => 10
        ];

        /*--------------------------------------------------------------
        # Banner Sections
        --------------------------------------------------------------*/
        // General
        $sections['banner_general']   = [
            'title'                 => esc_html__( 'General', 'business-aarambha' ),
            'panel'                 => 'business_aarambha_banner_panel',
            'priority'              => 10
        ];
        // Content
        $sections['banner_post_content']   = [
            'title'                 => esc_html__( 'Post Content', 'business-aarambha' ),
            'panel'                 => 'business_aarambha_banner_panel',
            'priority'              => 15
        ];
        // Post title
        $sections['banner_post_title']   = [
            'title'                 => esc_html__( 'Post Title', 'business-aarambha' ),
            'panel'                 => 'business_aarambha_banner_panel',
            'priority'              => 25
        ];
        // Read More
        $sections['banner_read_more']   = [
            'title'                 => esc_html__( 'Read More', 'business-aarambha' ),
            'panel'                 => 'business_aarambha_banner_panel',
            'priority'              => 40
        ];

        /*--------------------------------------------------------------
        # Blog Posts Sections
        --------------------------------------------------------------*/
        // Page Header
        $sections['blog_page_header']   = [
            'title'                 => esc_html__( 'Page Header', 'business-aarambha' ),
            'panel'                 => 'business_aarambha_blog_posts_panel',
            'priority'              => 10
        ];
        // Featured Image
        $sections['blog_post_featured_image']   = [
            'title'                 => esc_html__( 'Featured Image', 'business-aarambha' ),
            'panel'                 => 'business_aarambha_blog_posts_panel',
            'priority'              => 15
        ];
        // Posts layout
        $sections['blog_posts_layout']   = [
            'title'                 => esc_html__( 'Post Content', 'business-aarambha' ),
            'panel'                 => 'business_aarambha_blog_posts_panel',
            'priority'              => 20
        ];
        // Post title
        $sections['blog_post_title']   = [
            'title'                 => esc_html__( 'Post Title', 'business-aarambha' ),
            'panel'                 => 'business_aarambha_blog_posts_panel',
            'priority'              => 25
        ];
        // Read More
        $sections['blog_post_read_more']   = [
            'title'                 => esc_html__( 'Read More', 'business-aarambha' ),
            'panel'                 => 'business_aarambha_blog_posts_panel',
            'priority'              => 40
        ];
        // Pagination
        $sections['blog_pagination']   = [
            'title'                 => esc_html__( 'Pagination', 'business-aarambha' ),
            'panel'                 => 'business_aarambha_blog_posts_panel',
            'priority'              => 45
        ];
        // Sidebar
        $sections['blog_sidebar']   = [
            'title'                 => esc_html__( 'Sidebar', 'business-aarambha' ),
            'panel'                 => 'business_aarambha_blog_posts_panel',
            'priority'              => 50
        ];

        /*--------------------------------------------------------------
        # Single Post Sections
        --------------------------------------------------------------*/
        // Post Header
        $sections['single_post_header']   = [
            'title'                 => esc_html__( 'Page Header', 'business-aarambha' ),
            'panel'                 => 'business_aarambha_single_post_panel',
            'priority'              => 10
        ];
        // Featured Image
        $sections['single_post_featured_image']   = [
            'title'                 => esc_html__( 'Featured Image', 'business-aarambha' ),
            'panel'                 => 'business_aarambha_single_post_panel',
            'priority'              => 15
        ];
        // Post Content
        $sections['single_post_content']   = [
            'title'                 => esc_html__( 'Post Content', 'business-aarambha' ),
            'panel'                 => 'business_aarambha_single_post_panel',
            'priority'              => 20
        ];
        // Post Title
        $sections['single_post_title']   = [
            'title'                 => esc_html__( 'Post Title', 'business-aarambha' ),
            'panel'                 => 'business_aarambha_single_post_panel',
            'priority'              => 25
        ];
        // Sidebar
        $sections['single_post_sidebar']   = [
            'title'                 => esc_html__( 'Sidebar', 'business-aarambha' ),
            'panel'                 => 'business_aarambha_single_post_panel',
            'priority'              => 30
        ];
        /*--------------------------------------------------------------
        # Single Page Sections
        --------------------------------------------------------------*/
        // Page Header
        $sections['single_page_header']   = [
            'title'                 => esc_html__( 'Page Header', 'business-aarambha' ),
            'panel'                 => 'business_aarambha_single_page_panel',
            'priority'              => 10
        ];
        // Featured Image
        $sections['single_page_featured_image']   = [
            'title'                 => esc_html__( 'Featured Image', 'business-aarambha' ),
            'panel'                 => 'business_aarambha_single_page_panel',
            'priority'              => 15
        ];

        // Page Content
        $sections['single_page_content']   = [
            'title'                 => esc_html__( 'Page Content', 'business-aarambha' ),
            'panel'                 => 'business_aarambha_single_page_panel',
            'priority'              => 20
        ];

        // Page Title
        $sections['single_page_title']   = [
            'title'                 => esc_html__( 'Page Title', 'business-aarambha' ),
            'panel'                 => 'business_aarambha_single_page_panel',
            'priority'              => 25
        ];

        // Sidebar
        $sections['single_page_sidebar']   = [
            'title'                 => esc_html__( 'Sidebar', 'business-aarambha' ),
            'panel'                 => 'business_aarambha_single_page_panel',
            'priority'              => 30
        ];

        /*--------------------------------------------------------------
        # Error Page Sections
        --------------------------------------------------------------*/
        // 404 Page Header
        $sections['404_page_header']   = [
            'title'                 => esc_html__( 'Page Header', 'business-aarambha' ),
			'panel'                 => 'business_aarambha_404_page_panel',
            'priority'              => 10
        ];
		// 404 Page Header
		$sections['404_page_content']   = [
			'title'                 => esc_html__( 'Page Content', 'business-aarambha' ),
			'panel'                 => 'business_aarambha_404_page_panel',
			'priority'              => 15
		];


        // Register sections.
        foreach ( $sections as $section_id => $section_args ) {
            $wp_customize->add_section( 'business_aarambha_' . str_replace( '-', '_', $section_id ) . '_section', $section_args );
        }


        // Register sections.
        $wp_customize->add_section(
            new Business_Aarambha_Customize_Custom_Section(
                $wp_customize,
                'business_aarambha_section_separator_one',
                array(
                    'priority'      => 20,
                    'inline_style'  => 'background:#eee;border-left:0;'
                )
            )
        );
        $wp_customize->add_section(
            new Business_Aarambha_Customize_Custom_Section(
                $wp_customize,
                'business_aarambha_section_separator_two',
                array(
                    'priority'      => 46,
                    'inline_style'  => 'background:#eee;border-left:0;'
                )
            )
        );
        $wp_customize->add_section(
            new Business_Aarambha_Customize_Custom_Section(
                $wp_customize,
                'business_aarambha_section_separator_three',
                array(
                    'priority'      => 65,
                    'inline_style'  => 'background:#eee;border-left:0;'
                )
            )
        );

        // Header Builder
        $wp_customize->add_section(
            new Business_Aarambha_Customize_Custom_Section(
                $wp_customize,
                'business_aarambha_section_separator_five',
                array(
                    'priority'      => 30,
                    'inline_style'  => 'background:#eee;border-left:0;',
                    'panel'         => 'business_aarambha_header',
                )
            )
        );

        // Footer Builder
        $wp_customize->add_section(
            new Business_Aarambha_Customize_Custom_Section(
                $wp_customize,
                'business_aarambha_section_separator_six',
                array(
                    'priority'      => 30,
                    'inline_style'  => 'background:#eee;border-left:0;',
                    'panel'         => 'business_aarambha_footer',
                )
            )
        );
        $wp_customize->add_section(
            new Business_Aarambha_Customize_Custom_Section(
                $wp_customize,
                'business_aarambha_section_separator_seven',
                array(
                    'priority'      => 60,
                    'inline_style'  => 'background:#eee;border-left:0;',
                    'panel'         => 'business_aarambha_footer',
                )
            )
        );
    }


    /**
     * Add customizer repeater fields
     *
     * @access public
     * @param object $wp_customize the object.
     * @return void
     */
    public static function business_aarambha_add_repeater_fields( $wp_customize ) {

        // Global Social Icons
        $wp_customize->add_setting( new Business_Aarambha_Customize_Repeater_Setting(
                $wp_customize,
                'business_aarambha_social_icons',
                [
                    'default'           => [
                        [
                            'network'   => 'facebook',
                            'icon'      => '',
                            'link'      => '#'
                        ],
                        [
                            'network'   => 'twitter',
                            'icon'      => '',
                            'link'      => '#'
                        ]
                    ],
                    'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_repeater'],
                ]
            )
        );
        $wp_customize->add_control( new Business_Aarambha_Customize_Repeater_Control(
                $wp_customize,
                'business_aarambha_social_icons',
                [
                    'section'           => 'business_aarambha_social_section',
                    'priority'          => 15,
                    'fields'            => [
                    	'network'		=> [
                    		'type'			=> 'select',
							'label'			=> esc_html__( 'Select Network', 'business-aarambha' ),
							'choices'		=> Business_Aarambha_Helper::social_network_list()
						],
                        'link'         => [
                            'type'          => 'url',
                            'default'       => '#',
                            'label'         => esc_html__( 'Link', 'business-aarambha' )
                        ],
						'icon'         => [
							'type'          => 'font',
							'label'         => esc_html__( 'Custom Icon', 'business-aarambha' ),
							'description'   => esc_html__( 'To replace the default social icon, Click below input field and choose the icon. Example: fa-facebook-f', 'business-aarambha' )
						]
                    ],
                    'row_label'         => [
                        'type'              => 'field',
                        'value'             => esc_html__( 'Social', 'business-aarambha' ),
                        'field'             => 'network'
                    ],
                ]
            )
        );
    }

}
new Business_Aarambha_Customizer();
