<?php
/**
 * Business Aarambha functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Business_Aarambha
 */

/**
 * Business Aarambha only works in WordPress 5.6 or later.
 */
if ( version_compare( $GLOBALS['wp_version'], '5.6', '<' ) ) {
	require get_template_directory() . '/inc/back-compat.php';
	return;
}

/**
 * Define Constants
 */
if ( ! defined( 'BUSINESS_AARAMBHA_VERSION' ) ) {
	// Replace the version number of the theme on each release.
	define( 'BUSINESS_AARAMBHA_VERSION', '1.0.1' );
}
if ( ! defined( 'BUSINESS_AARAMBHA_DIR' ) ) {
	define( 'BUSINESS_AARAMBHA_DIR', trailingslashit( get_template_directory() ) );
}
if ( ! defined( 'BUSINESS_AARAMBHA_URI' ) ) {
	define( 'BUSINESS_AARAMBHA_URI', trailingslashit( esc_url( get_template_directory_uri() ) ) );
}
if ( ! defined( 'BUSINESS_AARAMBHA_SCRIPT_PREFIX' ) ) {
	define('BUSINESS_AARAMBHA_SCRIPT_PREFIX', ( defined('SCRIPT_DEBUG') && SCRIPT_DEBUG ) ? '' : '.min');
}

if ( ! function_exists( 'business_aarambha_setup' ) ) :
	/**
	 * Sets up theme defaults and registers support for various WordPress features.
	 *
	 * Note that this function is hooked into the after_setup_theme hook, which
	 * runs before the init hook. The init hook is too late for some features, such
	 * as indicating support for post thumbnails.
	 */
	function business_aarambha_setup() {
		/*
		 * Make theme available for translation.
		 * Translations can be filed in the /languages/ directory.
		 * If you're building a theme based on Business Aarambha, use a find and replace
		 * to change 'business-aarambha' to the name of your theme in all the template files.
		 */
		load_theme_textdomain( 'business-aarambha', get_template_directory() . '/languages' );

		// Add default posts and comments RSS feed links to head.
		add_theme_support( 'automatic-feed-links' );

		/*
		 * Let WordPress manage the document title.
		 * By adding theme support, we declare that this theme does not use a
		 * hard-coded <title> tag in the document head, and expect WordPress to
		 * provide it for us.
		 */
		add_theme_support( 'title-tag' );

		/*
		 * Enable support for Post Thumbnails on posts and pages.
		 *
		 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
		 */
		add_theme_support( 'post-thumbnails' );

		/* Image Ratio - 16:9 */
		add_image_size( 'banner-1200-16x9', 1200, 675, true );

		// This theme uses wp_nav_menu() in one location.
		register_nav_menus(
			array(
				'primary-menu'  => esc_html__( 'Primary Menu', 'business-aarambha' ),
				'mobile-menu'   => esc_html__( 'Mobile Menu', 'business-aarambha' ),
				'footer-menu'   => esc_html__( 'Footer Menu', 'business-aarambha' )
			)
		);

		/*
		 * Switch default core markup for search form, comment form, and comments
		 * to output valid HTML5.
		 */
		add_theme_support(
			'html5',
			array(
				'search-form',
				'comment-form',
				'comment-list',
				'gallery',
				'caption',
				'style',
				'script',
			)
		);

		// Add theme support for selective refresh for widgets.
		add_theme_support( 'customize-selective-refresh-widgets' );

		/**
		 * Add support for core custom logo.
		 *
		 * @link https://codex.wordpress.org/Theme_Logo
		 */
		add_theme_support(
			'custom-logo',
			array(
				'height'      => 250,
				'width'       => 250,
				'flex-width'  => true,
				'flex-height' => true,
			)
		);

        // Add support for page excerpt
        add_post_type_support('page', 'excerpt');

        // Add support for Block Styles.
        add_theme_support( 'wp-block-styles' );

        // Add support for full and wide align images.
        add_theme_support('align-wide');

        // Add support for responsive embedded content.
        add_theme_support('responsive-embeds');
	}
endif;
add_action( 'after_setup_theme', 'business_aarambha_setup' );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function business_aarambha_content_width() {
	$GLOBALS['content_width'] = apply_filters( 'business_aarambha_content_width', 640 );
}
add_action( 'after_setup_theme', 'business_aarambha_content_width', 0 );

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function business_aarambha_widgets_init() {
	register_sidebar(
		array(
			'name'          => esc_html__( 'Sidebar', 'business-aarambha' ),
			'id'            => 'sidebar-1',
			'description'   => esc_html__( 'Add widgets here.', 'business-aarambha' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);

    // Widget Sidebar
	for ( $sidebar = 1; $sidebar <= 6; $sidebar++ ) {
		register_sidebar(
			array(
				'name'          => sprintf( esc_html__( 'Footer Sidebar %d ', 'business-aarambha' ), absint($sidebar) ),
				'id'            => 'footer-sidebar-' . absint($sidebar),
				'description'   => esc_html__( 'Display widgets footer section of the site.', 'business-aarambha' ),
				'before_widget' => '<section id="%1$s" class="widget %2$s">',
				'after_widget'  => '</section>',
				'before_title'  => '<h2 class="widget-title">',
				'after_title'   => '</h2>',
			)
		);
	}
}
add_action( 'widgets_init', 'business_aarambha_widgets_init' );

/**
 * Enqueue scripts and styles.
 */
function business_aarambha_scripts() {

	// Font Awesome Style
	wp_enqueue_style( 'font-awesome', BUSINESS_AARAMBHA_URI .'assets/css/font-awesome' . BUSINESS_AARAMBHA_SCRIPT_PREFIX . '.css', array(), '4.7.0' );

    // MeanMenu Style
	wp_enqueue_style( 'meanmenu', BUSINESS_AARAMBHA_URI .'assets/css/meanmenu' . BUSINESS_AARAMBHA_SCRIPT_PREFIX . '.css', array(), '2.0.7' );

	// Slick Style
	wp_enqueue_style( 'slick-theme', BUSINESS_AARAMBHA_URI .'assets/css/slick-theme' . BUSINESS_AARAMBHA_SCRIPT_PREFIX . '.css', null, '1.8.0' );
	wp_enqueue_style( 'slick', BUSINESS_AARAMBHA_URI .'assets/css/slick' . BUSINESS_AARAMBHA_SCRIPT_PREFIX . '.css', null, '1.8.0' );

	// Theme Style
	wp_enqueue_style( 'business-aarambha-style', get_stylesheet_uri(), array(), BUSINESS_AARAMBHA_VERSION );

	// Main Style
	wp_enqueue_style( 'business-aarambha-main-style', BUSINESS_AARAMBHA_URI . 'assets/css/main' . BUSINESS_AARAMBHA_SCRIPT_PREFIX . '.css', null, BUSINESS_AARAMBHA_VERSION, 'all' );

	// Responsive Style
	wp_enqueue_style( 'business-aarambha-responsive', BUSINESS_AARAMBHA_URI . 'assets/css/responsive' . BUSINESS_AARAMBHA_SCRIPT_PREFIX . '.css', null, BUSINESS_AARAMBHA_VERSION, 'all' );

	// Theme inline style
	wp_add_inline_style( 'business-aarambha-style', Business_Aarambha_Customizer_Inline_Style::css_output( 'front-end' ) );

    // Editor inline style
    wp_add_inline_style( 'business-aarambha-style', Business_Aarambha_Customizer_Inline_Style::css_output( 'editor' ) );

	// Enqueue Slick Js
	wp_enqueue_script( 'slick', BUSINESS_AARAMBHA_URI . 'assets/js/slick' . BUSINESS_AARAMBHA_SCRIPT_PREFIX . '.js', [ 'jquery' ], '1.8.0', true );

	// Enqueue MeanMenu Js
	wp_enqueue_script( 'meanmenu', BUSINESS_AARAMBHA_URI . 'assets/js/jquery.meanmenu' . BUSINESS_AARAMBHA_SCRIPT_PREFIX . '.js', [ 'jquery' ], '2.0.7', true );

	// Enqueue theia-sticky-sidebar Js
	$sticky_sidebar = get_theme_mod( 'business_aarambha_sidebar_sticky', '' );
	if ( $sticky_sidebar ) {
		wp_enqueue_script( 'theia-sticky-sidebar', BUSINESS_AARAMBHA_URI . 'assets/js/theia-sticky-sidebar' . BUSINESS_AARAMBHA_SCRIPT_PREFIX . '.js', [ 'jquery' ], '1.7.0', true );
	}

	// Main scripts.
	wp_enqueue_script( 'business-aarambha-script', BUSINESS_AARAMBHA_URI . 'assets/js/script' . BUSINESS_AARAMBHA_SCRIPT_PREFIX . '.js', array( 'jquery' ), BUSINESS_AARAMBHA_VERSION, true );

	// Localized Scripts for the load more posts.
    $banner_type        = get_theme_mod( 'business_aarambha_header_banner_type', ['desktop' => 'banner'] );
    $slider_pagination  = get_theme_mod( 'business_aarambha_header_banner_slider_pagination', ['desktop' => 'true'] );
	$locale = [
		'sticky_sidebar'            => $sticky_sidebar ? true : false,
        'bannerSlider'              => ( $banner_type['desktop'] == 'slider' ) ? true : false,
        'bannerSliderPagination'    => ( $slider_pagination && array_key_exists( 'desktop', $slider_pagination ) ) ? true : false,
	];
	$locale = apply_filters( 'business_aarambha_localize_var', $locale );
	wp_localize_script( 'business-aarambha-script','BUSINESS_AARAMBHA', $locale );

	// Comment Reply
	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'business_aarambha_scripts' );

/**
 * Custom template tags for this theme.
 */
require BUSINESS_AARAMBHA_DIR . 'inc/template-tags.php';

/**
 * Functions which enhance the theme by hooking into WordPress.
 */
require BUSINESS_AARAMBHA_DIR . 'inc/template-functions.php';

/**
 * Google fonts utilities
 */
require BUSINESS_AARAMBHA_DIR . 'inc/classes/Business_Aarambha_Google_Fonts.php';

/**
 * Font Awesome Icon
 */
require BUSINESS_AARAMBHA_DIR . 'inc/classes/Business_Aarambha_Font_Awesome_Icons.php';

/**
 * Breadcrumb
 */
require BUSINESS_AARAMBHA_DIR . 'inc/classes/Business_Aarambha_Breadcrumb.php';

/**
 * Helper Functions
 */
require BUSINESS_AARAMBHA_DIR . 'inc/classes/Business_Aarambha_Helper.php';

/**
 * Customizer additions.
 */
require BUSINESS_AARAMBHA_DIR . 'inc/customizer/Business_Aarambha_Customizer.php';

// Builder
require BUSINESS_AARAMBHA_DIR . 'inc/customizer/builder/Business_Aarambha_Customizer_Builder.php';
require BUSINESS_AARAMBHA_DIR. 'inc/customizer/builder/header/Business_Aarambha_Customizer_Header_Builder.php';
require BUSINESS_AARAMBHA_DIR. 'inc/customizer/builder/footer/Business_Aarambha_Customizer_Footer_Builder.php';


/**
 * Load theme meta box
 */
require BUSINESS_AARAMBHA_DIR . 'inc/meta-boxes/Business_Aarambha_Meta_Boxes.php';


/**
 * Load Jetpack compatibility file.
 */
if ( defined( 'JETPACK__VERSION' ) ) {
	require BUSINESS_AARAMBHA_DIR . 'inc/compatibility/jetpack/jetpack.php';
}

/**
 * Load WooCommerce compatibility file.
 */
if ( class_exists( 'WooCommerce' ) ) {
    require BUSINESS_AARAMBHA_DIR . 'inc/compatibility/woocommerce/woocommerce.php';
}

/**
 * Load hooks file.
 */
require BUSINESS_AARAMBHA_DIR . 'inc/hooks/hooks.php';
require BUSINESS_AARAMBHA_DIR . 'inc/hooks/functions.php';

/**
 * Load plugin recommendations.
 */
require BUSINESS_AARAMBHA_DIR . 'inc/tgm/tgm.php';

/**
 * Gutenberg editor
 */
require BUSINESS_AARAMBHA_DIR . 'inc/Business_Aarambha_Editor_Style.php';
