<?php
/**
 * The template for displaying 404 pages (not found)
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 * @package Business_Aarambha
 */

get_header();
?>

<section class="error-404 not-found">
    <?php
    $content_elements = get_theme_mod(
        'business_aarambha_404_error_page_content_elements',
        ['title','subtitle','button']
    );
    if ( ! empty( $content_elements ) ) :

        $error_image = get_theme_mod(
            'business_aarambha_404_error_image',
            ''
        );
        ?>
        <div class="error-page-content">

            <?php foreach ($content_elements as $key => $value) {
                // image
                if ($value === 'image' && $error_image !== '' ) {
                    ?>
                    <figure>
                        <img src="<?php echo esc_url( $error_image ); ?>" alt="<?php esc_attr_e( '404 Error Image', 'business-aarambha' ); ?>">
                    </figure>
                    <?php
                }
                // title
                if ($value === 'title') {
                    ?>
                    <h2><?php esc_html_e( '404', 'business-aarambha' ); ?></h2>
                    <?php
                }
                // subtitle
                if ($value === 'subtitle') {
                    ?>
                    <h4><?php esc_html_e( 'It looks like nothing was found at this location. Maybe try one of the links below or a search?', 'business-aarambha'); ?></h4>
                    <?php
                }
                // button
                if ($value === 'button') {
                    ?>
                    <a class="box-button home-button" href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php esc_html_e( 'Return Home', 'business-aarambha' ); ?></a>
                    <?php
                }
                // search
                if ($value === 'search') {
                    get_search_form();
                }
            } ?>
            
        </div><!-- .error-page-content -->
    <?php
    endif;
    ?>
</section><!-- .error-404 -->

<?php get_footer(); ?>
