<?php
/**
 * FAQ block
 *
 * @package buddyx
 */

return array(
	'title'      => __( 'FAQ block', 'buddyx' ),
	'categories' => array( 'buddyx-general' ),
	'content'    => '<!-- wp:group {"metadata":{"categories":["buddyx-general"],"patternName":"buddyx/general-faq","name":"FAQ block"},"align":"full","style":{"elements":{"link":{"color":{"text":"var:preset|color|contrastcolor"}}},"spacing":{"padding":{"top":"0","right":"0","bottom":"0","left":"0"}}},"backgroundColor":"contrast","textColor":"contrastcolor","layout":{"type":"constrained"}} -->
    <div class="wp-block-group alignfull has-contrastcolor-color has-contrast-background-color has-text-color has-background has-link-color" style="padding-top:0;padding-right:0;padding-bottom:0;padding-left:0"><!-- wp:cover {"url":"' . esc_url( get_template_directory_uri() ) . '/assets/images/faq-pattern.svg","id":2551,"dimRatio":60,"customOverlayColor":"#00000000","isUserOverlayColor":true,"align":"full","className":"is-style-containbg is-style-color-inherit","style":{"spacing":{"padding":{"top":"7rem","bottom":"7rem","right":"var:preset|spacing|50","left":"var:preset|spacing|50"}}}} -->
    <div class="wp-block-cover alignfull is-style-containbg is-style-color-inherit" style="padding-top:7rem;padding-right:var(--wp--preset--spacing--50);padding-bottom:7rem;padding-left:var(--wp--preset--spacing--50)"><span aria-hidden="true" class="wp-block-cover__background has-background-dim-60 has-background-dim" style="background-color:#00000000"></span><img class="wp-block-cover__image-background wp-image-2551" alt="" src="' . esc_url( get_template_directory_uri() ) . '/assets/images/faq-pattern.svg" data-object-fit="cover"/><div class="wp-block-cover__inner-container"><!-- wp:group {"align":"full","style":{"spacing":{"margin":{"top":"0","bottom":"0"},"padding":{"top":"0","bottom":"0","right":"0","left":"0"}}},"layout":{"type":"constrained"}} -->
    <div class="wp-block-group alignfull" style="margin-top:0;margin-bottom:0;padding-top:0;padding-right:0;padding-bottom:0;padding-left:0"><!-- wp:heading {"textAlign":"center","className":"is-style-default","style":{"spacing":{"padding":{"top":"0","right":"0","bottom":"0","left":"0"},"margin":{"top":"0","bottom":"0","right":"0","left":"0"}},"typography":{"fontStyle":"normal","fontWeight":"300","lineHeight":"1"}},"textColor":"base","fontSize":"big"} -->
    <h2 class="wp-block-heading has-text-align-center is-style-default has-base-color has-text-color has-big-font-size" id="buddyx-unique-wordpress-theme" style="margin-top:0;margin-right:0;margin-bottom:0;margin-left:0;padding-top:0;padding-right:0;padding-bottom:0;padding-left:0;font-style:normal;font-weight:300;line-height:1">FAQ</h2>
    <!-- /wp:heading -->

    <!-- wp:heading {"textAlign":"center","level":3,"className":"is-style-default","style":{"spacing":{"padding":{"top":"0","right":"0","bottom":"0","left":"0"},"margin":{"top":"0","bottom":"var:preset|spacing|70"}},"elements":{"link":{"color":{"text":"var:preset|color|base"}}}},"textColor":"base","fontSize":"max-huge"} -->
    <h3 class="wp-block-heading has-text-align-center is-style-default has-base-color has-text-color has-link-color has-max-huge-font-size" id="buddyx-unique-wordpress-theme" style="margin-top:0;margin-bottom:var(--wp--preset--spacing--70);padding-top:0;padding-right:0;padding-bottom:0;padding-left:0">Frequently Asked Questions</h3>
    <!-- /wp:heading -->

    <!-- wp:group {"align":"wide","style":{"spacing":{"padding":{"right":"4vw","bottom":"0","left":"4vw","top":"1.5vw"}},"color":{"background":"#2undefinede0"},"border":{"radius":"5px","color":"#fafafa14","width":"1px"},"elements":{"link":{"color":{"text":"var:preset|color|white"}}}},"textColor":"white","layout":{"type":"constrained"}} -->
    <div class="wp-block-group alignwide has-border-color has-white-color has-text-color has-background has-link-color" style="border-color:#fafafa14;border-width:1px;border-radius:5px;background-color:#2undefinede0;padding-top:1.5vw;padding-right:4vw;padding-bottom:0;padding-left:4vw"><!-- wp:columns {"align":"wide","style":{"spacing":{"margin":{"bottom":"3rem"}}}} -->
    <div class="wp-block-columns alignwide" style="margin-bottom:3rem"><!-- wp:column {"verticalAlignment":"top","width":"38px"} -->
    <div class="wp-block-column is-vertically-aligned-top" style="flex-basis:38px"><!-- wp:paragraph {"className":"is-style-gradientmask","style":{"typography":{"lineHeight":"1.3"},"spacing":{"padding":{"top":"0","right":"0","bottom":"0","left":"0"}}},"gradient":"creative-btn","fontSize":"big"} -->
    <p class="is-style-gradientmask has-creative-btn-gradient-background has-background has-big-font-size" style="padding-top:0;padding-right:0;padding-bottom:0;padding-left:0;line-height:1.3">01.</p>
    <!-- /wp:paragraph --></div>
    <!-- /wp:column -->

    <!-- wp:column {"width":""} -->
    <div class="wp-block-column"><!-- wp:paragraph {"style":{"typography":{"fontStyle":"normal","fontWeight":"700"},"spacing":{"margin":{"top":"0","bottom":"var:preset|spacing|20"}}},"fontSize":"subheading"} -->
    <p class="has-subheading-font-size" style="margin-top:0;margin-bottom:var(--wp--preset--spacing--20);font-style:normal;font-weight:700">What is BuddyX Theme?</p>
    <!-- /wp:paragraph -->

    <!-- wp:separator {"className":"is-style-wide","style":{"color":{"background":"#fafafa14"}}} -->
    <hr class="wp-block-separator has-text-color has-alpha-channel-opacity has-background is-style-wide" style="background-color:#fafafa14;color:#fafafa14"/>
    <!-- /wp:separator -->

    <!-- wp:paragraph {"style":{"color":{"text":"#a8b8cd"},"typography":{"lineHeight":"1.7","fontSize":"1.1rem"}}} -->
    <p class="has-text-color" style="color:#a8b8cd;font-size:1.1rem;line-height:1.7">BuddyX is a responsive and flexible WordPress theme designed for building social networking sites. It integrates seamlessly with BuddyPress and BuddyBoss, allowing you to create communities, membership sites, learning platforms, and social marketplaces.</p>
    <!-- /wp:paragraph --></div>
    <!-- /wp:column --></div>
    <!-- /wp:columns --></div>
    <!-- /wp:group -->

    <!-- wp:group {"align":"wide","style":{"spacing":{"padding":{"right":"4vw","bottom":"0","left":"4vw","top":"1.5vw"}},"color":{"background":"#2undefinede0"},"border":{"radius":"5px","color":"#fafafa14","width":"1px"},"elements":{"link":{"color":{"text":"var:preset|color|white"}}}},"textColor":"white","layout":{"type":"constrained"}} -->
    <div class="wp-block-group alignwide has-border-color has-white-color has-text-color has-background has-link-color" style="border-color:#fafafa14;border-width:1px;border-radius:5px;background-color:#2undefinede0;padding-top:1.5vw;padding-right:4vw;padding-bottom:0;padding-left:4vw"><!-- wp:columns {"align":"wide","style":{"spacing":{"margin":{"bottom":"3rem"}}}} -->
    <div class="wp-block-columns alignwide" style="margin-bottom:3rem"><!-- wp:column {"verticalAlignment":"top","width":"38px"} -->
    <div class="wp-block-column is-vertically-aligned-top" style="flex-basis:38px"><!-- wp:paragraph {"className":"is-style-gradientmask","style":{"typography":{"lineHeight":"1.3"},"spacing":{"padding":{"top":"0","right":"0","bottom":"0","left":"0"}}},"gradient":"creative-btn","fontSize":"big"} -->
    <p class="is-style-gradientmask has-creative-btn-gradient-background has-background has-big-font-size" style="padding-top:0;padding-right:0;padding-bottom:0;padding-left:0;line-height:1.3">02.</p>
    <!-- /wp:paragraph --></div>
    <!-- /wp:column -->

    <!-- wp:column {"width":""} -->
    <div class="wp-block-column"><!-- wp:paragraph {"style":{"typography":{"fontStyle":"normal","fontWeight":"700"},"spacing":{"margin":{"top":"0","bottom":"var:preset|spacing|20"}}},"fontSize":"subheading"} -->
    <p class="has-subheading-font-size" style="margin-top:0;margin-bottom:var(--wp--preset--spacing--20);font-style:normal;font-weight:700">Can I create an online learning platform with BuddyX?</p>
    <!-- /wp:paragraph -->

    <!-- wp:separator {"className":"is-style-wide","style":{"color":{"background":"#fafafa14"}}} -->
    <hr class="wp-block-separator has-text-color has-alpha-channel-opacity has-background is-style-wide" style="background-color:#fafafa14;color:#fafafa14"/>
    <!-- /wp:separator -->

    <!-- wp:paragraph {"style":{"color":{"text":"#a8b8cd"},"typography":{"lineHeight":"1.7","fontSize":"1.1rem"}}} -->
    <p class="has-text-color" style="color:#a8b8cd;font-size:1.1rem;line-height:1.7">Yes, BuddyX integrates with popular LMS plugins like LearnDash, TutorLMS, and LifterLMS, enabling you to create and sell online courses within a community setting.</p>
    <!-- /wp:paragraph --></div>
    <!-- /wp:column --></div>
    <!-- /wp:columns --></div>
    <!-- /wp:group -->

    <!-- wp:group {"align":"wide","style":{"spacing":{"padding":{"right":"4vw","bottom":"0","left":"4vw","top":"1.5vw"}},"color":{"background":"#2undefinede0"},"border":{"radius":"5px","color":"#fafafa14","width":"1px"},"elements":{"link":{"color":{"text":"var:preset|color|white"}}}},"textColor":"white","layout":{"type":"constrained"}} -->
    <div class="wp-block-group alignwide has-border-color has-white-color has-text-color has-background has-link-color" style="border-color:#fafafa14;border-width:1px;border-radius:5px;background-color:#2undefinede0;padding-top:1.5vw;padding-right:4vw;padding-bottom:0;padding-left:4vw"><!-- wp:columns {"align":"wide","style":{"spacing":{"margin":{"bottom":"3rem"}}}} -->
    <div class="wp-block-columns alignwide" style="margin-bottom:3rem"><!-- wp:column {"verticalAlignment":"top","width":"38px"} -->
    <div class="wp-block-column is-vertically-aligned-top" style="flex-basis:38px"><!-- wp:paragraph {"className":"is-style-gradientmask","style":{"typography":{"lineHeight":"1.3"},"spacing":{"padding":{"top":"0","right":"0","bottom":"0","left":"0"}}},"gradient":"creative-btn","fontSize":"big"} -->
    <p class="is-style-gradientmask has-creative-btn-gradient-background has-background has-big-font-size" style="padding-top:0;padding-right:0;padding-bottom:0;padding-left:0;line-height:1.3">03.</p>
    <!-- /wp:paragraph --></div>
    <!-- /wp:column -->

    <!-- wp:column {"width":""} -->
    <div class="wp-block-column"><!-- wp:paragraph {"style":{"typography":{"fontStyle":"normal","fontWeight":"700"},"spacing":{"margin":{"top":"0","bottom":"var:preset|spacing|20"}}},"fontSize":"subheading"} -->
    <p class="has-subheading-font-size" style="margin-top:0;margin-bottom:var(--wp--preset--spacing--20);font-style:normal;font-weight:700"><strong>Is BuddyX compatible with BuddyPress and BuddyBoss?</strong></p>
    <!-- /wp:paragraph -->

    <!-- wp:separator {"className":"is-style-wide","style":{"color":{"background":"#fafafa14"}}} -->
    <hr class="wp-block-separator has-text-color has-alpha-channel-opacity has-background is-style-wide" style="background-color:#fafafa14;color:#fafafa14"/>
    <!-- /wp:separator -->

    <!-- wp:paragraph {"style":{"color":{"text":"#a8b8cd"},"typography":{"lineHeight":"1.7","fontSize":"1.1rem"}}} -->
    <p class="has-text-color" style="color:#a8b8cd;font-size:1.1rem;line-height:1.7">Absolutely! BuddyX is designed to work flawlessly with both BuddyPress and BuddyBoss, providing you with features like member profiles, activity streams, friend connections, and group management.</p>
    <!-- /wp:paragraph --></div>
    <!-- /wp:column --></div>
    <!-- /wp:columns --></div>
    <!-- /wp:group -->

    <!-- wp:group {"align":"wide","style":{"spacing":{"padding":{"right":"4vw","bottom":"0","left":"4vw","top":"1.5vw"}},"color":{"background":"#2undefinede0"},"border":{"radius":"5px","color":"#fafafa14","width":"1px"},"elements":{"link":{"color":{"text":"var:preset|color|white"}}}},"textColor":"white","layout":{"type":"constrained"}} -->
    <div class="wp-block-group alignwide has-border-color has-white-color has-text-color has-background has-link-color" style="border-color:#fafafa14;border-width:1px;border-radius:5px;background-color:#2undefinede0;padding-top:1.5vw;padding-right:4vw;padding-bottom:0;padding-left:4vw"><!-- wp:columns {"align":"wide","style":{"spacing":{"margin":{"bottom":"3rem"}}}} -->
    <div class="wp-block-columns alignwide" style="margin-bottom:3rem"><!-- wp:column {"verticalAlignment":"top","width":"38px"} -->
    <div class="wp-block-column is-vertically-aligned-top" style="flex-basis:38px"><!-- wp:paragraph {"className":"is-style-gradientmask","style":{"typography":{"lineHeight":"1.3"},"spacing":{"padding":{"top":"0","right":"0","bottom":"0","left":"0"}}},"gradient":"creative-btn","fontSize":"big"} -->
    <p class="is-style-gradientmask has-creative-btn-gradient-background has-background has-big-font-size" style="padding-top:0;padding-right:0;padding-bottom:0;padding-left:0;line-height:1.3">04.</p>
    <!-- /wp:paragraph --></div>
    <!-- /wp:column -->

    <!-- wp:column {"width":""} -->
    <div class="wp-block-column"><!-- wp:paragraph {"style":{"typography":{"fontStyle":"normal","fontWeight":"700"},"spacing":{"margin":{"top":"0","bottom":"var:preset|spacing|20"}}},"fontSize":"subheading"} -->
    <p class="has-subheading-font-size" style="margin-top:0;margin-bottom:var(--wp--preset--spacing--20);font-style:normal;font-weight:700"><strong>Is there support available for BuddyX?</strong></p>
    <!-- /wp:paragraph -->

    <!-- wp:separator {"className":"is-style-wide","style":{"color":{"background":"#fafafa14"}}} -->
    <hr class="wp-block-separator has-text-color has-alpha-channel-opacity has-background is-style-wide" style="background-color:#fafafa14;color:#fafafa14"/>
    <!-- /wp:separator -->

    <!-- wp:paragraph {"style":{"color":{"text":"#a8b8cd"},"typography":{"lineHeight":"1.7","fontSize":"1.1rem"}}} -->
    <p class="has-text-color" style="color:#a8b8cd;font-size:1.1rem;line-height:1.7">Yes, BuddyX provides excellent customer support, including documentation, live chat, and email assistance, to help you set up and customize your site effectively.</p>
    <!-- /wp:paragraph --></div>
    <!-- /wp:column --></div>
    <!-- /wp:columns --></div>
    <!-- /wp:group --></div>
    <!-- /wp:group --></div></div>
    <!-- /wp:cover --></div>
    <!-- /wp:group -->',
);
