<?php
/**
 * The main template file
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package AKB_Blog
 */

get_header();
?>
    <div class="slider-wrapper">
        <div class="swiper btravelSwiper">
            <div class="swiper-wrapper">
                <?php
                $query = new WP_Query( array(
                    'post_type'      => 'post',
                    'posts_per_page' => 5,
                ) );

                if ( $query->have_posts() ) :
                    while ( $query->have_posts() ) : $query->the_post();
                        $thumbnail_url = get_the_post_thumbnail_url( get_the_ID(), 'medium' );
                        ?>
                        <div class="swiper-slide">
                            <div class="swiper-slide-wrapper">
                                <a href="<?php the_permalink(); ?>">
                                    <div class="slide-bg" style="background-image: url('<?php echo esc_url( $thumbnail_url ); ?>');"></div>
                                </a>
                                <div class="slider-item-title">
                                    <a href="<?php the_permalink(); ?>">
                                        <h2><?php the_title(); ?></h2>
                                    </a>
                                </div>
                            </div>
                        </div>
                    <?php
                    endwhile;
                    wp_reset_postdata();
                endif;
                ?>
            </div>

            <!-- Swiper Navigation -->
            <div class="swiper-button-next"></div>
            <div class="swiper-button-prev"></div>

            <!-- Swiper Pagination -->
            <div class="swiper-pagination"></div>
        </div>
    </div>


	<main id="primary" class="site-main">
        <div class="container">
            <div class="row">

                    <?php
                    if ( have_posts() ) :

                        if ( is_home() && ! is_front_page() ) :
                            ?>
                            <header>
                                <h1 class="page-title screen-reader-text"><?php single_post_title(); ?></h1>
                            </header>
                        <?php
                        endif;

                        /* Start the Loop */
                        while ( have_posts() ) :
                            the_post();

                            /*
                             * Include the Post-Type-specific template for the content.
                             * If you want to override this in a child theme, then include a file
                             * called content-___.php (where ___ is the Post Type name) and that will be used instead.
                             */

                        ?>
                            <div class="col-lg-4 col-sm-12">
                            <div class="btravel-blog-post-article">

                               <?php   get_template_part( 'template-parts/content', get_post_type() ); ?>
                            </div>
                            </div>
                        <?php
                       endwhile;

                        get_template_part( 'template-parts/pagination' );

                    else :

                        get_template_part( 'template-parts/content', 'none' );

                    endif;
                    ?>

            </div>
        </div>

	</main><!-- #main -->

<?php

get_footer();
