<?php

/**
 * Enqueue scripts and styles.
 */
function btravel_scripts()
{
    //  bootstrap stylesheet.
    wp_enqueue_style('bootstrap', get_template_directory_uri() . '/assets/css/bootstrap.min.css', [], null);

    //  Fontawesome V5 stylesheet.
    wp_enqueue_style('fontawesome-5', get_template_directory_uri() . '/assets/css/all.min.css', [], null);

    // Web font loaded.
    wp_enqueue_style('travel-blog-fonts', 'https://fonts.googleapis.com/css2?family=Poppins:wght@400;600;700&display=swap', [], null);

    // Swiper css added
    wp_enqueue_style('swiper-css', get_template_directory_uri() . '/assets/css/swiper.min.css', [], null);

    // Theme stylesheet.
    wp_enqueue_style('btravel-style', get_stylesheet_uri(), [], BTRAVEL_VERSION);

    // Add main stylesheet
    wp_enqueue_style('travel-blog-main-style', get_template_directory_uri() . '/assets/css/btravel-style.css', [], BTRAVEL_VERSION);

    // Add responsive stylesheet
    wp_enqueue_style('travel-blog-responsive', get_template_directory_uri() . '/assets/css/responsive.css', [], null);


    /**
     * Load All jQuery Library
     */
    wp_enqueue_script('travel-blog-navigation', get_template_directory_uri() . '/assets/js/navigation.js', [], BTRAVEL_VERSION, true);

    wp_enqueue_script('travel-blog-bootstrap', get_template_directory_uri() . '/assets/js/bootstrap.min.js', [], BTRAVEL_VERSION, true);

    wp_enqueue_script('travel-blog-popper', get_template_directory_uri() . '/assets/js/popper.min.js', [], BTRAVEL_VERSION, true);

    wp_enqueue_script('swiper-js', get_template_directory_uri() . '/assets/js/swiper.min.js', ['jquery'], BTRAVEL_VERSION, true);

    // Add btravel-main js library
    wp_enqueue_script('btravel-scripts-js', get_template_directory_uri() . '/assets/js/btravel-scripts.js', ['jquery'], '', true);


    if (is_singular() && comments_open() && get_option('thread_comments')) {
        wp_enqueue_script('comment-reply');
    }
}

add_action('wp_enqueue_scripts', 'btravel_scripts');


function btravel_customizer()
{
    wp_enqueue_script('btravel-customizer', get_template_directory_uri() . '/assets/js/customizer.js', ['jquery', 'customize-preview'], BTRAVEL_VERSION, true);
}

add_action('customize_preview_init', 'btravel_customizer');