<?php

$args = array(
  'post_type' => 'post',
  'post_status' => 'publish',
  'ignore_sticky_posts' => 1,
  'posts_per_page' => -1, // phpcs:ignore WPThemeReview.CoreFunctionality.PostsPerPage.posts_per_page_posts_per_page

);
?>


<!-- Swiper -->
<div class="btravel-slider-section">
    <div class="btravel-slider swiper tbSwiper">
        <div class="swiper-wrapper">
          <?php $arr_posts = new WP_Query($args);
          if ($arr_posts->have_posts()) :
            while ($arr_posts->have_posts()) :
              $arr_posts->the_post();
              ?>
                <div class="swiper-slide">
                    <div class="slider-image-item"
                         style="background-image: url(<?php echo esc_url(get_the_post_thumbnail_url($post->ID)); ?>)">
                        <div class="slider-content-item">
                            <div class="container">
                                <div class="row">
                                    <div class="col">
                                        <div class="travel-blog-box">
                                            <h3 class="my-3"><a
                                                        href="<?php echo esc_url(get_permalink($post->ID)); ?>"><?php the_title(); ?></a>
                                            </h3>
                                          <?php if ('post' === get_post_type()) :
                                            ?>
                                              <div class="btravel-slider-meta entry-meta">
                                                  <ul>
                                                      <li>
                                                        <?php
                                                        btravel_posted_by(); ?>
                                                      </li>
                                                      <li>
                                                        <?php
                                                        btravel_posted_on(); ?>
                                                      </li>
                                                      <li>
                                                        <?php
                                                        if (!post_password_required() && (comments_open() || get_comments_number())) {
                                                          btravel_comment_by();
                                                        }
                                                        ?>
                                                      </li>
                                                  </ul>
                                              </div><!-- .entry-meta -->
                                          <?php endif; ?>
                                            <p><a class="read-more-btn"
                                                  href="<?php the_permalink(); ?>"><?php echo esc_html__('Read More', 'btravel'); ?>
                                                    <i class="fas fa-chevron-right"></i></a></p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php
            endwhile;
            wp_reset_postdata();
          endif; ?>
        </div>

    </div>
    <!-- Add Navigation -->
    <div class="btravel-slider-navigation slideshow-navigation">
        <div class="slideshow-navigation-button next"><span class="fas fa-chevron-right"></span></div>
        <div class="slideshow-navigation-button prev"><span class="fas fa-chevron-left"></span></div>
    </div>
</div>

<!-- end of hero slider -->

