<?php
$args = array(
    'post_type' => 'post',
    'post_status' => 'publish',
    'posts_per_page' => 3,
    'ignore_sticky_posts' => 1,
    'orderby' => 'comment_count'

);
?>


<!-- Swiper -->
<div class="btravel-popular-post-section">
    <div class="btravel-popular-posts">
        <div class="popular-posts-item">

            <div class="container">
                <div class="row">
                    <div class="col">
                        <h2 class="tb-featured-post-title text-center"><?php echo esc_html('Featured Posts', 'btravel');?></h2>
                    </div>
                </div>
                <div class="row">
                    <?php $arr_posts = new WP_Query($args);
                    if ($arr_posts->have_posts()) :
                        while ($arr_posts->have_posts()) :
                            $arr_posts->the_post();
                            ?>
                            <div class="col-lg-4 col-md-6 col-sm-12">
                                <div class="btravel-popular-post-item">
                                    <div class="travel-blog-bg">
                                        <?php if (has_post_thumbnail()) : ?>
                                            <a href="<?php echo esc_url(get_the_permalink()) ?>"><?php the_post_thumbnail(); ?></a>
                                        <?php
                                        endif; ?>
                                    </div>
                                    <div class="travel-popular-post-box">
                                        <h3 class="my-3"><a
                                                    href="<?php echo esc_url(get_permalink()); ?>"><?php the_title(); ?></a>
                                        </h3>
                                        <?php if ('post' === get_post_type()) :
                                            ?>
                                            <div class="popular-post-meta entry-meta">
                                                <ul>
                                                    <li>
                                                        <?php
                                                        btravel_posted_by(); ?>
                                                    </li>
                                                    <li>
                                                        <?php
                                                        btravel_posted_on(); ?>
                                                    </li>
                                                    <li>
                                                        <?php
                                                        if (!post_password_required() && (comments_open() || get_comments_number())) {
                                                            btravel_comment_by();
                                                        }
                                                        ?>
                                                    </li>
                                                </ul>
                                            </div><!-- .entry-meta -->
                                        <?php endif; ?>
                                        <p><a class="read-more-btn" href="<?php the_permalink();?>"><?php echo esc_html__( 'Read More', 'btravel' ); ?><i class="fas fa-chevron-right"></i></a></p>
                                    </div>
                                </div>
                            </div>
                        <?php
                        endwhile;
                        wp_reset_postdata();
                    endif; ?>
                </div>
            </div>
        </div>

    </div>
</div>

<!-- end of hero slider -->





