<?php

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}


/**
 * Customizer
 *
 * @class   broadnews
 */

if (!function_exists('broadnews_custom_style')) {

    function broadnews_custom_style()
    {

        global $broadnews_google_fonts;



        $primary_color = broadnews_get_option('primary_color');
        $light_primary_color = broadnews_get_option('primary_color_light');
        $broadnews_background_color = get_background_color();
        $light_background_color = '#' . $broadnews_background_color;
        $dark_background_color = broadnews_get_option('dark_background_color');
        $secondary_color = broadnews_get_option('secondary_color');
        $main_navigation_custom_background_color = broadnews_get_option('main_navigation_custom_background_color');
        $category_color_1 = broadnews_get_option('category_color_1');
        $category_color_2 = broadnews_get_option('category_color_2');
        $category_color_3 = broadnews_get_option('category_color_3');
        $site_title_font = $broadnews_google_fonts[broadnews_get_option('site_title_font')];
        $primary_font = $broadnews_google_fonts[broadnews_get_option('primary_font')];
        $secondary_font = $broadnews_google_fonts[broadnews_get_option('secondary_font')];


        ob_start();
?>

        <?php if (!empty($dark_background_color)) : ?>
            body.aft-dark-mode #loader::before{
            border-color: <?php broadnews_esc_custom_style($dark_background_color) ?>;
            }
            body.aft-dark-mode #sidr,
            body.aft-dark-mode,
            body.aft-dark-mode.custom-background,
            body.aft-dark-mode #af-preloader {
            background-color: <?php broadnews_esc_custom_style($dark_background_color) ?>;
            }
        <?php endif; ?>

        <?php if (!empty($light_background_color)) : ?>
            body.aft-light-mode #loader::before{
            border-color: <?php broadnews_esc_custom_style($light_background_color) ?> ;
            }
            body.aft-light-mode #sidr,
            body.aft-light-mode #af-preloader,
            body.aft-light-mode {
            background-color: <?php broadnews_esc_custom_style($light_background_color) ?> ;
            }
        <?php endif; ?>

        <?php if (!empty($light_primary_color)) : ?>

            .aft-light-mode .comment-metadata a,
            .aft-light-mode .fn a,

            body.aft-light-mode .wp-block-latest-posts__post-author,
            body.aft-light-mode .wp-block-latest-posts__post-date,

            body.aft-light-mode .entry-content > [class*="wp-block-"] a.wp-block-file__button:not(.has-text-color):hover,
            body.aft-light-mode .entry-content > [class*="wp-block-"] a.wp-block-button__link:hover,

            body.aft-light-mode .entry-content > [class*="wp-block-"] a:not(.has-text-color),
            body.aft-light-mode .entry-content > ul a, body .entry-content > ul a:visited,
            body.aft-light-mode .entry-content > ol a, body .entry-content > ol a:visited,
            body.aft-light-mode .entry-content > p a,
            body.aft-light-mode .entry-content > p a:visited,
            body.aft-light-mode .entry-content h1:not(.awpa-display-name) a,
            body.aft-light-mode .entry-content h2:not(.awpa-display-name) a,
            body.aft-light-mode .entry-content h3:not(.awpa-display-name) a,
            body.aft-light-mode .entry-content h4:not(.awpa-display-name) a,
            body.aft-light-mode .entry-content h5:not(.awpa-display-name) a,
            body.aft-light-mode .entry-content h6:not(.awpa-display-name) a,

            .aft-light-mode .wp-block-tag-cloud a,
            .aft-light-mode .tagcloud a,

            body.aft-light-mode .aft-see-more a,
            .aft-light-mode legend,

            body.aft-light-mode .woocommerce-info,
            body.aft-light-mode .woocommerce-info a,

            body.aft-light-mode .comment-content > p a,
            body.aft-light-mode .comment-body .reply a,

            .aft-light-mode .aft-main-banner-section.aft-banner-background-default:not(.data-bg) .af-slick-navcontrols .slide-icon,
            .aft-light-mode .aft-main-banner-section.aft-banner-background-default:not(.data-bg) .af-youtube-slider .slide-icon,
            .aft-light-mode .aft-main-banner-section.aft-banner-background-default:not(.data-bg) .aft-yt-video-item-wrapper .slide-icon,

            .aft-light-mode .af-slick-navcontrols .slide-icon,
            .aft-light-mode .af-youtube-slider .slide-icon,
            .aft-light-mode .aft-yt-video-item-wrapper .slide-icon,

            .aft-dark-mode .aft-main-banner-section.aft-banner-background-alternative:not(.data-bg) .aft-main-banner-wrapper .widget-title .heading-line,
            .aft-dark-mode .aft-main-banner-section.aft-banner-background-alternative:not(.data-bg) .af-slick-navcontrols .slide-icon,
            .aft-dark-mode .aft-main-banner-section.aft-banner-background-alternative:not(.data-bg) .af-youtube-slider .slide-icon,
            .aft-dark-mode .aft-main-banner-section.aft-banner-background-alternative:not(.data-bg) .aft-yt-video-item-wrapper .slide-icon,
            .aft-dark-mode .aft-main-banner-section.aft-banner-background-alternative:not(.data-bg) .widget-title .heading-line,
            .aft-dark-mode .aft-main-banner-section.aft-banner-background-alternative:not(.data-bg) .aft-posts-tabs-panel .nav-tabs>li>a,
            .aft-dark-mode .aft-main-banner-section.aft-banner-background-alternative:not(.data-bg) .aft-comment-view-share > span > a,
            .aft-dark-mode .aft-main-banner-section.aft-banner-background-alternative:not(.data-bg) .read-single:not(.grid-design-texts-over-image) .read-details .entry-meta span,
            .aft-dark-mode .aft-main-banner-section.aft-banner-background-alternative:not(.data-bg) .featured-category-item .read-img a,
            .aft-dark-mode .aft-main-banner-section.aft-banner-background-alternative:not(.data-bg) .widget-title,
            .aft-dark-mode .aft-main-banner-section.aft-banner-background-alternative:not(.data-bg) .header-after1,

            .aft-light-mode .aft-main-banner-section.aft-banner-background-default:not(.data-bg) .widget-title .heading-line,
            .aft-light-mode .aft-main-banner-section.aft-banner-background-default:not(.data-bg) .aft-posts-tabs-panel .nav-tabs>li>a,
            .aft-light-mode .aft-main-banner-section.aft-banner-background-default:not(.data-bg) .read-single:not(.grid-design-texts-over-image) .aft-comment-view-share > span > a,
            .aft-light-mode .aft-main-banner-section.aft-banner-background-default:not(.data-bg) .read-single:not(.grid-design-texts-over-image) .read-details .entry-meta span,
            .aft-light-mode .aft-main-banner-section.aft-banner-background-default:not(.data-bg) .featured-category-item .read-img a,
            .aft-light-mode .aft-main-banner-section.aft-banner-background-default:not(.data-bg) .widget-title,
            .aft-light-mode .aft-main-banner-section.aft-banner-background-default:not(.data-bg) .header-after1,

            body.aft-light-mode .page-title,
            body.aft-light-mode h1.entry-title,
            body.aft-light-mode .widget-title,
            body.aft-light-mode .header-after1,
            body.aft-light-mode .broadnews-widget.widget_text a,
            body.aft-light-mode .shop_table a,
            body.aft-light-mode table.cart a,
            body.aft-light-mode .product_meta a,
            body.aft-light-mode.woocommerce div.product p.price,
            body.aft-light-mode.woocommerce div.product span.price,
            body.aft-light-mode.woocommerce div.product form.cart .group_table td.woocommerce-grouped-product-list-item__label a,
            body.aft-light-mode.woocommerce div.product form.cart .variations th,
            body.aft-light-mode .woocommerce-review-link,
            body.aft-light-mode .woocommerce-ordering select,
            body.aft-light-mode.woocommerce div.product form.cart .variations select,
            body.aft-light-mode.woocommerce div.product form.cart .reset_variations,
            body.aft-light-mode.woocommerce #reviews #comments ol.commentlist li .meta,
            body.aft-light-mode.woocommerce nav.woocommerce-pagination ul li .page-numbers,
            body.aft-light-mode.woocommerce div.product .woocommerce-tabs ul.tabs li:not(.active) a,
            body.aft-light-mode .woocommerce-MyAccount-content a,
            body.aft-light-mode .woocommerce-MyAccount-navigation a,
            body.aft-light-mode .woocommerce-form a,
            body.aft-light-mode ul.products .woocommerce-loop-product__title,
            body.aft-light-mode ul.products li.product .price,
            body.aft-light-mode .entry-content > [class*="wp-block-"] .woocommerce a:not(.has-text-color).button:hover,
            body.aft-light-mode pre .woocommerce,
            body.aft-light-mode .wp-block-tag-cloud a,
            body.aft-light-mode .tagcloud a,
            body.aft-light-mode .wp-post-author-meta h4 a,
            body.aft-light-mode .wp-post-author-meta .wp-post-author-meta-more-posts a,
            body.aft-light-mode .wp_post_author_widget .awpa-display-name,
            body.aft-light-mode .af-breadcrumbs a,
            body.aft-light-mode .broadnews-pagination .nav-links .page-numbers,


            body.aft-light-mode .widget-title .heading-line,
            body.aft-light-mode .aft-posts-tabs-panel .nav-tabs>li>a,
            body.aft-light-mode .wp_post_author_widget .widget-title .header-after,
            body.aft-light-mode .widget > ul > li a,
            .aft-light-mode .nav-links a,
            body.aft-light-mode .wp-calendar-nav a,
            body.aft-light-mode mark,

            body.aft-light-mode .aft-posts-tabs-panel .nav-tabs>li>a,
            body.aft-light-mode.single span.tags-links a,
            body.aft-light-mode .page-title,
            body.aft-light-mode h1.entry-title,
            body.aft-light-mode .aft-popular-taxonomies-lists ul li a,
            body.aft-light-mode #wp-calendar thead,
            body.aft-light-mode #wp-calendar tbody,
            body.aft-light-mode #wp-calendar caption,
            body.aft-light-mode h3,
            body.aft-light-mode .aft-readmore-wrapper a.aft-readmore,
            body.aft-light-mode #secondary .broadnews-widget ul[class*="wp-block-"] a,
            body.aft-light-mode #secondary .broadnews-widget ol[class*="wp-block-"] a,
            body.aft-light-mode a.post-edit-link,
            body.aft-light-mode .comment-form a,
            body.aft-light-mode .comment-reply-title a,
            body.aft-light-mode .author-links a,
            body.aft-light-mode .main-navigation ul.children li a,

            body.aft-light-mode .read-details .entry-meta span,
            body.aft-light-mode .aft-comment-view-share > span > a,
            body.aft-light-mode h4.af-author-display-name,
            body.aft-light-mode .wp-block-image figcaption,
            body.aft-light-mode ul.trail-items li a,
            body.aft-light-mode #sidr,
            body.aft-light-mode {
            color: <?php broadnews_esc_custom_style($light_primary_color) ?>;
            }

            body.aft-light-mode .entry-content p.wp-block-tag-cloud a,
            body.aft-light-mode .entry-content p.tagcloud a,
            body.aft-light-mode .entry-content > [class*="wp-block-"].is-style-outline .wp-block-button__link:hover,
            body.aft-light-mode.single .entry-content-wrap .post-excerpt,
            body.aft-light-mode.single-post.aft-single-full-header .post-excerpt,
            body.aft-light-mode .aft-readmore-wrapper a.aft-readmore,
            body.aft-light-mode .wp-post-author-meta .wp-post-author-meta-more-posts a,
            body.aft-light-mode .wp-post-author-meta a,
            body.aft-light-mode.single-post .entry-header .af-post-format i{
            border-color: <?php broadnews_esc_custom_style($light_primary_color) ?>;
            }

            body.aft-light-mode.single .entry-content-wrap .post-excerpt::before,
            body.aft-light-mode.single-post.aft-single-full-header .post-excerpt::before {
            background-color: <?php broadnews_esc_custom_style($light_primary_color) ?>;
            }

        <?php endif; ?>

        <?php if (!empty($primary_color)) : ?>

            .aft-dark-mode .comment-metadata a,
            .aft-dark-mode .fn a,

            body.aft-dark-mode .wp-block-latest-posts__post-author,
            body.aft-dark-mode .wp-block-latest-posts__post-date,

            body.aft-dark-mode .entry-content > [class*="wp-block-"] a.wp-block-file__button:not(.has-text-color):hover,
            body.aft-dark-mode .entry-content > [class*="wp-block-"] a.wp-block-button__link:hover,

            body.aft-dark-mode .entry-content > [class*="wp-block-"] a:not(.has-text-color),
            body.aft-dark-mode .entry-content > ul a, body .entry-content > ul a:visited,
            body.aft-dark-mode .entry-content > ol a, body .entry-content > ol a:visited,
            body.aft-dark-mode .entry-content > p a,
            body.aft-dark-mode .entry-content > p a:visited,
            body.aft-dark-mode .entry-content h1:not(.awpa-display-name) a,
            body.aft-dark-mode .entry-content h2:not(.awpa-display-name) a,
            body.aft-dark-mode .entry-content h3:not(.awpa-display-name) a,
            body.aft-dark-mode .entry-content h4:not(.awpa-display-name) a,
            body.aft-dark-mode .entry-content h5:not(.awpa-display-name) a,
            body.aft-dark-mode .entry-content h6:not(.awpa-display-name) a,

            body.aft-dark-mode .woocommerce-info,
            body.aft-dark-mode .woocommerce-info a,

            body.aft-dark-mode .aft-see-more a,
            body.aft-dark-mode legend,

            .aft-dark-mode .wp-block-tag-cloud a,
            .aft-dark-mode .tagcloud a,

            .aft-light-mode .aft-main-banner-section.aft-banner-background-alternative:not(.data-bg) .af-slick-navcontrols .slide-icon,
            .aft-light-mode .aft-main-banner-section.aft-banner-background-alternative:not(.data-bg) .af-youtube-slider .slide-icon,
            .aft-light-mode .aft-main-banner-section.aft-banner-background-alternative:not(.data-bg) .aft-yt-video-item-wrapper .slide-icon,
            .aft-light-mode .aft-main-banner-section.aft-banner-background-alternative:not(.data-bg) .widget-title .heading-line,
            .aft-light-mode .aft-main-banner-section.aft-banner-background-alternative:not(.data-bg) .aft-posts-tabs-panel .nav-tabs>li>a,
            .aft-light-mode .aft-main-banner-section.aft-banner-background-alternative:not(.data-bg) .aft-comment-view-share > span > a,
            .aft-light-mode .aft-main-banner-section.aft-banner-background-alternative:not(.data-bg) .read-single:not(.grid-design-texts-over-image) .read-details .entry-meta span,
            .aft-light-mode .aft-main-banner-section.aft-banner-background-alternative:not(.data-bg) .featured-category-item .read-img a,
            .aft-light-mode .aft-main-banner-section.aft-banner-background-alternative:not(.data-bg) .widget-title,
            .aft-light-mode .aft-main-banner-section.aft-banner-background-alternative:not(.data-bg) .header-after1,

            .aft-dark-mode .aft-main-banner-section.aft-banner-background-default:not(.data-bg) .af-slick-navcontrols .slide-icon,
            .aft-dark-mode .aft-main-banner-section.aft-banner-background-default:not(.data-bg) .af-youtube-slider .slide-icon,
            .aft-dark-mode .aft-main-banner-section.aft-banner-background-default:not(.data-bg) .aft-yt-video-item-wrapper .slide-icon,

            .aft-dark-mode .aft-main-banner-section.aft-banner-background-default:not(.data-bg) .widget-title .heading-line,
            .aft-dark-mode .aft-main-banner-section.aft-banner-background-default:not(.data-bg) .aft-posts-tabs-panel .nav-tabs>li>a,
            .aft-dark-mode .aft-main-banner-section.aft-banner-background-default:not(.data-bg) .read-single:not(.grid-design-texts-over-image) .aft-comment-view-share > span > a,
            .aft-dark-mode .aft-main-banner-section.aft-banner-background-default:not(.data-bg) .read-single:not(.grid-design-texts-over-image) .read-details .entry-meta span,
            .aft-dark-mode .aft-main-banner-section.aft-banner-background-default:not(.data-bg) .featured-category-item .read-img a,
            .aft-dark-mode .aft-main-banner-section.aft-banner-background-default:not(.data-bg) .widget-title,
            .aft-dark-mode .aft-main-banner-section.aft-banner-background-default:not(.data-bg) .header-after1,

            .aft-dark-mode .af-slick-navcontrols .slide-icon,
            .aft-dark-mode .af-youtube-slider .slide-icon,
            .aft-dark-mode .aft-yt-video-item-wrapper .slide-icon,
            body.aft-dark-mode .broadnews-pagination .nav-links .page-numbers,
            body.aft-dark-mode .widget > ul > li a,
            body.aft-dark-mode .wp-calendar-nav a,

            .aft-dark-mode .wp-post-author-meta .wp-post-author-meta-more-posts a,
            .aft-dark-mode .wp_post_author_widget .awpa-display-name a,

            body.aft-dark-mode mark,
            body.aft-dark-mode .broadnews-widget.widget_text a,
            body.aft-dark-mode .shop_table a,
            body.aft-dark-mode table.cart a,
            body.aft-dark-mode ul.products .woocommerce-loop-product__title,
            body.aft-dark-mode .product_meta a,
            body.aft-dark-mode.woocommerce div.product p.price,
            body.aft-dark-mode.woocommerce div.product span.price,
            body.aft-dark-mode.woocommerce div.product form.cart .group_table td.woocommerce-grouped-product-list-item__label a,
            body.aft-dark-mode.woocommerce div.product form.cart .variations th,
            body.aft-dark-mode .woocommerce-review-link,
            body.aft-dark-mode.woocommerce div.product form.cart .variations select,
            body.aft-dark-mode.woocommerce div.product form.cart .reset_variations,
            body.aft-dark-mode .woocommerce-ordering select,
            body.aft-dark-mode.woocommerce nav.woocommerce-pagination ul li .page-numbers,
            body.aft-dark-mode.woocommerce #reviews #comments ol.commentlist li .meta,
            body.aft-dark-mode.woocommerce div.product .woocommerce-tabs ul.tabs li:not(.active) a,
            body.aft-dark-mode .woocommerce-MyAccount-content a,
            body.aft-dark-mode .woocommerce-MyAccount-navigation a,
            body.aft-dark-mode .woocommerce-error,
            body.aft-dark-mode .woocommerce-form a,
            body.aft-dark-mode .woocommerce-Tabs-panel,
            body.aft-dark-mode .woocommerce-Tabs-panel h2,
            body.aft-dark-mode .woocommerce-terms-and-conditions-wrapper a,
            body.aft-dark-mode ul.products li.product .price,
            body.aft-dark-mode pre .woocommerce,
            body.aft-dark-mode .tagcloud a,
            body.aft-dark-mode .wp_post_author_widget .awpa-display-name,
            body.aft-dark-mode .af-breadcrumbs a,

            body.aft-dark-mode .widget-title .heading-line,
            body.aft-dark-mode .aft-posts-tabs-panel .nav-tabs>li>a,
            body.aft-dark-mode .wp_post_author_widget .widget-title .header-after,

            body.aft-dark-mode .aft-posts-tabs-panel .nav-tabs>li>a,
            body.aft-dark-mode.single span.tags-links a,
            body.aft-dark-mode .page-title,
            body.aft-dark-mode h1.entry-title,
            body.aft-dark-mode ul.trail-items li:after,
            body.aft-dark-mode #wp-calendar thead,
            body.aft-dark-mode #wp-calendar tbody,
            body.aft-dark-mode .entry-meta span,
            body.aft-dark-mode h3,
            body.aft-dark-mode .color-pad #wp-calendar caption,
            body.aft-dark-mode .aft-readmore-wrapper a.aft-readmore,
            body.aft-dark-mode #secondary .broadnews-widget ul[class*="wp-block-"] a,
            body.aft-dark-mode #secondary .broadnews-widget ol[class*="wp-block-"] a,
            body.aft-dark-mode a.post-edit-link,
            body.aft-dark-mode .comment-form a,
            body.aft-dark-mode .comment-reply-title a,
            body.aft-dark-mode .wp-post-author-meta a,
            body.aft-dark-mode .wp-post-author-meta a:visited,
            body.aft-dark-mode .posts-author a,
            body.aft-dark-mode .posts-author a:visited,
            body.aft-dark-mode .author-links a,
            body.aft-dark-mode .nav-links a,
            body.aft-dark-mode .read-details .entry-meta span,
            body.aft-dark-mode .aft-comment-view-share > span > a,
            body.aft-dark-mode h4.af-author-display-name,
            body.aft-dark-mode #wp-calendar caption,
            body.aft-dark-mode .wp-block-image figcaption,
            body.aft-dark-mode ul.trail-items li a,

            body.aft-dark-mode .entry-content > [class*="wp-block-"] a:not(.has-text-color):hover,
            body.aft-dark-mode .entry-content > ol a:hover,
            body.aft-dark-mode .entry-content > ul a:hover,
            body.aft-dark-mode .entry-content > p a:hover,
            body.aft-dark-mode .comment-content > p a,
            body.aft-dark-mode .comment-body .reply a,
            body.aft-dark-mode #sidr,
            body.aft-dark-mode,
            body.aft-dark-mode .color-pad{
            color: <?php broadnews_esc_custom_style($primary_color) ?>;
            }

            body.aft-dark-mode.single span.tags-links a,
            body.aft-dark-mode .single span.tags-links a,
            body.aft-dark-mode .entry-content p.wp-block-tag-cloud a,
            body.aft-dark-mode .entry-content p.tagcloud a,
            body.aft-dark-mode .entry-content > [class*="wp-block-"].is-style-outline .wp-block-button__link:hover,
            body.aft-dark-mode.single .entry-content-wrap .post-excerpt,
            body.aft-dark-mode.single-post.aft-single-full-header .post-excerpt,
            body.aft-dark-mode .aft-readmore-wrapper a.aft-readmore,
            body.aft-dark-mode .wp-post-author-meta .wp-post-author-meta-more-posts a{
            border-color: <?php broadnews_esc_custom_style($primary_color) ?>;
            }
            body.aft-dark-mode.single .entry-content-wrap .post-excerpt::before,
            body.aft-dark-mode.single-post.aft-single-full-header .post-excerpt::before {
            background-color: <?php broadnews_esc_custom_style($primary_color) ?>;
            }

        <?php endif; ?>

        <?php if (!empty($secondary_color)) : ?>

#loader .aft-cube:before,
.wp-block-search .wp-block-search__button,
.woocommerce-account .entry-content .woocommerce-MyAccount-navigation ul li.is-active,

.woocommerce #respond input#submit,
.woocommerce a.button,
.woocommerce button.button,
.woocommerce input.button,
.woocommerce #respond input#submit.alt,
.woocommerce a.button.alt,
.woocommerce button.button.alt,
.woocommerce input.button.alt,

.woocommerce #respond input#submit:hover,
.woocommerce a.button:hover,
.woocommerce button.button:hover,
.woocommerce input.button:hover,

.woocommerce #respond input#submit.alt:hover,
.woocommerce a.button.alt:hover,
.woocommerce button.button.alt:hover,
.woocommerce input.button.alt:hover,

.widget-title-border-top .wp_post_author_widget .widget-title::before,
.widget-title-border-bottom .wp_post_author_widget .widget-title::before,
.widget-title-border-top .heading-line::before,
.widget-title-border-bottom .heading-line::before,
.widget-title-border-top .sub-heading-line::before,
.widget-title-border-bottom .sub-heading-line::before,

body.aft-light-mode .aft-main-banner-section.aft-banner-background-secondary,
body.aft-dark-mode .aft-main-banner-section.aft-banner-background-secondary,

body.widget-title-border-bottom .header-after1 .heading-line-before,
body.widget-title-border-bottom .widget-title .heading-line-before,
body .af-cat-widget-carousel a.broadnews-categories.category-color-1,
a.sidr-class-sidr-button-close,
.aft-posts-tabs-panel .nav-tabs>li>a.active,

.widget-title-border-bottom .sub-heading-line::before,
.widget-title-border-bottom .wp-post-author-wrap .header-after::before,

.widget-title-border-side .wp_post_author_widget .widget-title::before,
.widget-title-border-side .heading-line::before,
.widget-title-border-side .sub-heading-line::before,

.single-post .entry-content-title-featured-wrap .af-post-format i,
.single-post article.post .af-post-format i,

.wc-block-grid__product-add-to-cart.wp-block-button .wp-block-button__link,
#wp-calendar tbody td a::after,

span.heading-line::before,
.wp-post-author-wrap .header-after::before,
body.aft-light-mode button,
body.aft-dark-mode button,
body.aft-dark-mode input[type="button"],
body.aft-dark-mode input[type="reset"],
body.aft-dark-mode input[type="submit"],
body.aft-dark-mode .inner-suscribe input[type=submit],
.af-youtube-slider .af-video-wrap .af-bg-play i,
.af-youtube-video-list .entry-header-yt-video-wrapper .af-yt-video-play i,
body .btn-style1 a:visited,
body .btn-style1 a,
body .broadnews-pagination .nav-links .page-numbers.current,
body .broadnews-load-more-posts a.aft-readmore .load-btn,
body #scroll-up,
body article.sticky .read-single:before,
.read-img .trending-no,
body .trending-posts-vertical .trending-no{
background-color: <?php broadnews_esc_custom_style($secondary_color) ?>;
}

.woocommerce #respond input#submit.disabled,
.woocommerce #respond input#submit:disabled,
.woocommerce #respond input#submit:disabled[disabled],
.woocommerce a.button.disabled,
.woocommerce a.button:disabled,
.woocommerce a.button:disabled[disabled],
.woocommerce button.button.disabled,
.woocommerce button.button:disabled,
.woocommerce button.button:disabled[disabled],
.woocommerce input.button.disabled,
.woocommerce input.button:disabled,
.woocommerce input.button:disabled[disabled] {
background-color: <?php broadnews_esc_custom_style($secondary_color) ?> !important;
}

body .aft-see-more a {
background-image: linear-gradient(120deg, <?php broadnews_esc_custom_style($secondary_color) ?> , <?php broadnews_esc_custom_style($secondary_color) ?>);
}

body.aft-light-mode .comment-body .reply a:hover,
body.aft-dark-mode .comment-body .reply a:hover,

.broadnews_youtube_video_widget .af-youtube-slider-thumbnail .slick-slide.slick-current::before,
.broadnews-widget.widget_text a,
body .aft-see-more a,
mark,
body.aft-light-mode .aft-readmore-wrapper a.aft-readmore:hover,
body.aft-dark-mode .aft-readmore-wrapper a.aft-readmore:hover,
body.aft-dark-mode .grid-design-texts-over-image .aft-readmore-wrapper a.aft-readmore:hover,
body.aft-light-mode .grid-design-texts-over-image .aft-readmore-wrapper a.aft-readmore:hover,

body.single .entry-header .aft-post-excerpt-and-meta .post-excerpt,
body.aft-light-mode.single span.tags-links a:hover,
body.aft-dark-mode.single span.tags-links a:hover,
.broadnews-pagination .nav-links .page-numbers.current,
.aft-light-mode p.awpa-more-posts a:hover,
p.awpa-more-posts a:hover,
.wp-post-author-meta .wp-post-author-meta-more-posts a.awpa-more-posts:hover{
border-color: <?php broadnews_esc_custom_style($secondary_color) ?>;
}

body .entry-content > [class*="wp-block-"] li,

body.aft-dark-mode #secondary .broadnews-widget ul[class*="wp-block-"] a:hover,
body.aft-light-mode #secondary .broadnews-widget ul[class*="wp-block-"] a:hover,
body.aft-dark-mode #secondary .broadnews-widget ol[class*="wp-block-"] a:hover,
body.aft-light-mode #secondary .broadnews-widget ol[class*="wp-block-"] a:hover,

body.aft-light-mode .comment-form a:hover,
body.aft-dark-mode .comment-form a:hover,

#scroll-up::after{
border-bottom-color: <?php broadnews_esc_custom_style($secondary_color) ?>;
}

.page-links a.post-page-numbers,

body.aft-dark-mode .is-style-outline a.wp-block-button__link:not(.has-text-color), 
body.aft-light-mode .is-style-outline a.wp-block-button__link:not(.has-text-color),

body.aft-dark-mode .entry-content > [class*="wp-block-"] a.wp-block-file__button:not(.has-text-color),
body.aft-light-mode .entry-content > [class*="wp-block-"] a.wp-block-file__button:not(.has-text-color),

body.wp-post-author-meta .awpa-display-name a:hover,
.widget_text a ,

body footer.site-footer .wp-post-author-meta .wp-post-author-meta-more-posts a:hover,
body footer.site-footer .wp_post_author_widget .awpa-display-name a:hover,

body .site-footer .secondary-footer a:hover,

body.aft-light-mode p.awpa-website a:hover ,
body.aft-dark-mode p.awpa-website a:hover {
color:<?php broadnews_esc_custom_style($secondary_color) ?>;
}

.woocommerce div.product .product_meta a,
.woocommerce div.product form.cart .reset_variations,
body.aft-light-mode .wp-calendar-nav a,
body.aft-dark-mode .wp-calendar-nav a,
body.aft-light-mode .aft-main-banner-section .aft-popular-taxonomies-lists ul li a:hover,
body.aft-dark-mode .aft-main-banner-section .aft-popular-taxonomies-lists ul li a:hover,
.comment-metadata a:hover,
.fn a:hover,
body.aft-light-mode .broadnews-pagination .nav-links a.page-numbers:hover,
body.aft-dark-mode .broadnews-pagination .nav-links a.page-numbers:hover,
body.aft-light-mode .entry-content p.wp-block-tag-cloud a.tag-cloud-link:hover,
body.aft-dark-mode .entry-content p.wp-block-tag-cloud a.tag-cloud-link:hover,
body footer.site-footer .wp-block-tag-cloud a:hover,
body footer.site-footer .tagcloud a:hover,
body.aft-light-mode .wp-block-tag-cloud a:hover,
body.aft-light-mode .tagcloud a:hover,
body.aft-dark-mode .wp-block-tag-cloud a:hover,
body.aft-dark-mode .tagcloud a:hover,
.aft-dark-mode .wp-post-author-meta .wp-post-author-meta-more-posts a:hover,
body footer.site-footer .wp-post-author-meta .wp-post-author-meta-more-posts a:hover{
border-color: <?php broadnews_esc_custom_style($secondary_color) ?>;
}
<?php endif; ?>

<?php if (!empty($secondary_color)) : ?>
.widget-title-border-side .widget_block .wp-block-search__label::before,
.widget-title-border-side .widget_block .wp-block-group .wp-block-heading::before,
.widget-title-border-top .widget_block .wp-block-search__label::before,
.widget-title-border-top .widget_block .wp-block-group .wp-block-heading::before,
.widget-title-border-bottom .widget_block .wp-block-search__label::before,
.widget-title-border-bottom .widget_block .wp-block-group .wp-block-heading::before,

body .aft-main-banner-section .aft-popular-taxonomies-lists strong::before,

.woocommerce div.product .woocommerce-tabs ul.tabs li.active,

.entry-content form.mc4wp-form input[type=submit],
.inner-suscribe input[type=submit],

body.aft-light-mode .woocommerce-MyAccount-content a.button,
body.aft-dark-mode .woocommerce-MyAccount-content a.button,
body.aft-light-mode.woocommerce-account .addresses .title .edit,
body.aft-dark-mode.woocommerce-account .addresses .title .edit,

.fpsml-front-form.fpsml-template-1 .fpsml-field input[type="submit"],
.fpsml-front-form.fpsml-template-2 .fpsml-field input[type="submit"],
.fpsml-front-form.fpsml-template-3 .fpsml-field input[type="submit"],
.fpsml-front-form.fpsml-template-4 .fpsml-field input[type="submit"],
.fpsml-front-form.fpsml-template-5 .fpsml-field input[type="submit"],

.fpsml-front-form.fpsml-template-1 .qq-upload-button,
.fpsml-front-form.fpsml-template-2 .qq-upload-button,
.fpsml-front-form.fpsml-template-3 .qq-upload-button,
.fpsml-front-form.fpsml-template-4 .qq-upload-button,
.fpsml-front-form.fpsml-template-5 .qq-upload-button,

body.aft-dark-mode #wp-calendar tbody td#today,
body.aft-light-mode #wp-calendar tbody td#today,

.aft-dark-mode .is-style-fill a.wp-block-button__link:not(.has-background), 
.aft-light-mode .is-style-fill a.wp-block-button__link:not(.has-background),

.widget-title-border-top .sub-heading-line::before,
.widget-title-border-bottom .sub-heading-line::before,
.btn-style1 a:visited,
.btn-style1 a, button,
input[type="button"],
input[type="reset"],
input[type="submit"],
body.aft-light-mode.woocommerce nav.woocommerce-pagination ul li .page-numbers.current,
body.aft-dark-mode.woocommerce nav.woocommerce-pagination ul li .page-numbers.current,
.woocommerce-product-search button[type="submit"],
.widget_mc4wp_form_widget input[type=submit],
input.search-submit{
background-color: <?php broadnews_esc_custom_style($secondary_color) ?>;
}


.main-navigation .menu-description,
.woocommerce-product-search button[type="submit"],
input.search-submit,

body.single span.tags-links a:hover,

.aft-dark-mode .featured-category-item .read-img a:hover,
.aft-dark-mode .nav-links a:hover .post-title,

body.aft-dark-mode .entry-content .wp-block-tag-cloud a:hover,
body.aft-dark-mode .entry-content .tagcloud a:hover,
body.aft-light-mode .entry-content .wp-block-tag-cloud a:hover,
body.aft-light-mode .entry-content .tagcloud a:hover,

.aft-dark-mode .read-details .entry-meta span a:hover,
.aft-light-mode .read-details .entry-meta span a:hover,

body.aft-dark-mode .is-style-outline a.wp-block-button__link:not(.has-text-color), 
body.aft-light-mode .is-style-outline a.wp-block-button__link:not(.has-text-color),

body.aft-light-mode.woocommerce nav.woocommerce-pagination ul li .page-numbers.current,
body.aft-dark-mode.woocommerce nav.woocommerce-pagination ul li .page-numbers.current,
body.aft-light-mode.woocommerce nav.woocommerce-pagination ul li .page-numbers:hover,
body.aft-dark-mode.woocommerce nav.woocommerce-pagination ul li .page-numbers:hover,

body ul.trail-items li a:hover,
body .post-edit-link:hover,
body p.logged-in-as a:hover,
body .entry-content > [class*="wp-block-"] a:not(.wp-block-button__link):hover{
border-color: <?php broadnews_esc_custom_style($secondary_color) ?>;
}

body .aft-main-banner-section .aft-popular-taxonomies-lists strong::after {
border-color: transparent transparent transparent <?php broadnews_esc_custom_style($secondary_color) ?>;
}
body.rtl .aft-main-banner-section .aft-popular-taxonomies-lists strong::after {
border-color: transparent <?php broadnews_esc_custom_style($secondary_color) ?> transparent transparent;
}
<?php endif; ?>


        <?php if (!empty($main_navigation_custom_background_color)) : ?>
            body div#main-navigation-bar{
            background-color: <?php broadnews_esc_custom_style($main_navigation_custom_background_color) ?>;
            }
        <?php endif; ?>

        <?php if (!empty($category_color_1)) : ?>
            .widget-title-border-bottom .widget-title.category-color-1 .heading-line-before,
            .widget-title-border-center .widget-title.category-color-1 .heading-line-before,

            body .af-cat-widget-carousel a.broadnews-categories.category-color-1{
            background-color: <?php broadnews_esc_custom_style($category_color_1) ?>;
            }
        <?php endif; ?>

        <?php if (!empty($category_color_2)) : ?>
            .widget-title-border-bottom .widget-title.category-color-2 .heading-line-before,
            .widget-title-border-center .widget-title.category-color-2 .heading-line-before,

            body .af-cat-widget-carousel a.broadnews-categories.category-color-2{
            background-color: <?php broadnews_esc_custom_style($category_color_2) ?>;
            }
        <?php endif; ?>

        <?php if (!empty($category_color_3)) : ?>
            .widget-title-border-bottom .widget-title.category-color-3 .heading-line-before,
            .widget-title-border-center .widget-title.category-color-3 .heading-line-before,

            body .af-cat-widget-carousel a.broadnews-categories.category-color-3{
            background-color: <?php broadnews_esc_custom_style($category_color_3) ?>;
            }
        <?php endif; ?>

        <?php if (!empty($site_title_font)) : ?>
            .site-description,
            .site-title {
            font-family: <?php broadnews_esc_custom_style($site_title_font) ?>;
            }
        <?php endif; ?>

        <?php if (!empty($primary_font)) : ?>

            body p,
            .woocommerce form label,
            .nav-previous h4, .nav-next h4,
            .exclusive-posts .marquee a,
            .widget ul.menu >li,
            .widget ul ul li,
            .widget ul > li,
            .widget ol > li,
            main ul li,
            main ol li,
            p,
            input,
            .wp-block-search__input,
            textarea,
            .read-title h4,
            .broadnews-customizer .post-description,
            .broadnews-widget .post-description{
            font-family: <?php broadnews_esc_custom_style($primary_font) ?>;
            }
        <?php endif; ?>

        <?php if (!empty($secondary_font)) : ?>
            body,
            button,
            select,
            optgroup,
            .widget ul.af-tabs > li a,
            p.awpa-more-posts,
            .post-description .aft-readmore-wrapper,
            input[type="reset"],
            input[type="submit"],
            .cat-links li a,
            .min-read,
            .woocommerce form label.wp-block-search__label,
            .woocommerce ul.order_details li,
            .woocommerce .woocommerce-customer-details address p,
            .woocommerce nav.woocommerce-pagination ul li .page-numbers,
            .af-social-contacts .social-widget-menu .screen-reader-text {
            font-family: <?php broadnews_esc_custom_style($secondary_font) ?>;
            }
        <?php endif; ?>


        .elementor-page .elementor-section.elementor-section-full_width > .elementor-container,
        .elementor-page .elementor-section.elementor-section-boxed > .elementor-container,
        .elementor-default .elementor-section.elementor-section-full_width > .elementor-container,
        .elementor-default .elementor-section.elementor-section-boxed > .elementor-container{
        max-width: 1180px;
        }

        .container-wrapper .elementor {
        max-width: 100%;
        }

        .full-width-content .elementor-section-stretched,
        .align-content-left .elementor-section-stretched,
        .align-content-right .elementor-section-stretched {
        max-width: 100%;
        left: 0 !important;
        }

<?php
        return ob_get_clean();
    }
}

if (!function_exists('broadnews_esc_custom_style(')) {

    function broadnews_esc_custom_style($props)
    {
        echo wp_kses($props, array("\'", '\"'));
    }
}
