<?php
/**
 * Displays main navigation
 *
 * @package Brilliant
 * @since Brilliant 1.1.9
 */

?>

<button id="menu-toggle" on="tap:AMP.setState({ampmenu: !ampmenu})" class="menu-toggle" class="menu-toggle" aria-expanded="false">
	<span class="ei icon_menu"></span>
</button>
<nav id="site-navigation" [class]="ampmenu ? 'main-navigation active' : 'main-navigation'" class="main-navigation" aria-label="<?php esc_attr_e( 'Main Menu', 'brilliant' ); ?>">
	<?php
		wp_nav_menu( array(
			'theme_location'        => 'main_menu',
			'menu_id'               => 'main-menu',
			'menu_class'            => 'main-menu',
			'show_sub_menu_toggles' => true,
			'container'             => false,
			'fallback_cb'           => 'brilliant_fallback_menu'
			) );
		// Main Menu
	?>
</nav>
