<?php
/**
 * Template part for displaying blog posts and featuring the first one.
 *
 * @package Brilliant
 * @since Brilliant 1.0
 */

?>

<?php
$i = 1;
while ( have_posts() ) : the_post(); ?>
	
	<?php if ($i == 1) : ?>
	
		<!-- First Post -->
		<div class="cover">
			<div class="cover-bg" <?php if ( has_post_thumbnail() ) { ?>style="background-image:url(<?php the_post_thumbnail_url('brilliant-fullwidth'); ?>)"<?php } ?>>
				<div class="cover-content">
					<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
						<div class="entry-header">
							<div class="entry-meta">
								<?php brilliant_time_link(); ?>
							</div>
							<h2 class="entry-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>	
						</div><!-- .entry-header -->
				    	<div class="entry-summary">
						    <?php the_excerpt(); ?>
					    </div><!-- .entry-summary -->
				    </article>
				</div>
			</div><!-- .cover-bg -->
		</div><!-- .cover -->
		
		<div id="primary" class="content-area">
			<main id="main" class="site-main" role="main">
				<section class="row posts-loop <?php if ( get_theme_mod('blog_layout', 'blog-layout4') == 'blog-layout4' ) { echo esc_attr('flex-row'); } ?>">
					
	<?php else : ?>
		
		<?php if ( get_theme_mod('blog_layout', 'blog-layout4') == 'blog-layout4' ) { ?>
			<div class="post-wrapper col-6 col-sm-6">
				<?php get_template_part( 'template-parts/content-grid', get_post_format() ); ?>
			</div>
		<?php } else { ?>
			<div class="post-wrapper col-12">
				<?php get_template_part( 'template-parts/content', get_post_format() ); ?>
			</div>
		<?php } ?>

	<?php endif; ?>
	
	<?php $i++; endwhile; ?>
				
				</section><!-- .posts-loop -->
				
				<?php the_posts_navigation(); ?>
				
			</main><!-- #main -->
		</div><!-- #primary -->	
