<?php
/**
 * Template part for displaying single posts.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Brilliant
 * @since Brilliant 1.0
 */

?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

	<?php if ( get_theme_mod('post_featured_image_size', 'overlay') == 'onecolumn' && has_post_thumbnail() && get_theme_mod('post_has_featured_image', 1) ) : ?>
		<figure class="entry-featured-image">
			<?php the_post_thumbnail('brilliant-large'); ?>
		</figure>
	<?php endif; // Featured Image ?>

	<?php if ( get_theme_mod('post_featured_image_size', 'overlay') == 'onecolumn' || ! get_theme_mod('post_has_featured_image', 1) || ! has_post_thumbnail() ) : ?>
		<header class="entry-header">
			<?php the_title( '<h1 class="entry-title"><span>', '</span></h1>' ); ?>
			<div class="entry-meta">
				<?php brilliant_posted_on(); ?>
			</div>
		</header><!-- .entry-header -->
	<?php endif; ?>

	<div class="entry-content is-layout-constrained has-global-padding">
		<?php
			the_content();
			wp_link_pages( array(
				'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'brilliant' ),
				'after'  => '</div>',
			) );
		?>
	</div><!-- .entry-content -->

	<footer class="entry-footer">
		<?php brilliant_entry_footer(); ?>
	</footer><!-- .entry-footer -->

</article><!-- #post-## -->

<?php
	// Author bio.
	if ( get_theme_mod('show_author_bio') && is_single() && get_the_author_meta( 'description' ) ) :
		get_template_part( 'template-parts/author-bio' );
	endif;
?>
