<?php
/**
 * Template part for displaying page content.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Brilliant
 * @since Brilliant 1.0
 */

?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

	<?php if ( get_theme_mod('page_featured_image_size', 'overlay') == 'onecolumn' && has_post_thumbnail() && get_theme_mod('page_has_featured_image', 1) ) : ?>
		<figure class="entry-featured-image">
			<?php if( is_page_template( 'page-templates/fullwidth.php' ) ) {
				the_post_thumbnail('brilliant-fullwidth');
			} else {
				the_post_thumbnail('brilliant-large');
			}
			?>
		</figure>
	<?php endif; // Featured Image ?>

	<?php if ( get_theme_mod('page_featured_image_size', 'overlay') == 'onecolumn' || ! get_theme_mod('page_has_featured_image', 1) || ! has_post_thumbnail() ) : ?>
		<header class="entry-header">
			<?php the_title( '<h1 class="entry-title"><span>', '</span></h1>' ); ?>
		</header><!-- .entry-header -->
	<?php endif; ?>

	<div class="entry-content is-layout-constrained has-global-padding">
		<?php
			the_content();
			wp_link_pages( array(
				'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'brilliant' ),
				'after'  => '</div>',
			) );
		?>
	</div><!-- .entry-content -->

	<footer class="entry-footer">
		<?php
			edit_post_link(
				sprintf(
					/* translators: %s: Name of current post */
					esc_html__( 'Edit %s', 'brilliant' ),
					the_title( '<span class="screen-reader-text">"', '"</span>', false )
				),
				'<span class="edit-link">',
				'</span>'
			);
		?>
	</footer><!-- .entry-footer -->

</article><!-- #post-## -->
