<?php
/**
 * The template for displaying all single posts.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package Brilliant
 * @since Brilliant 1.0
 */

get_header(); ?>

<?php if ( have_posts() ) : ?>
	
	<?php if ( has_post_thumbnail() && get_theme_mod('post_has_featured_image', 1) && get_theme_mod('post_featured_image_size', 'overlay') == 'overlay' ) : ?>
		
		<div class="cover cover-single">
			<div class="cover-bg" style="background-image:url(<?php the_post_thumbnail_url('brilliant-fullwidth'); ?>)">
				<div class="cover-content">
					<div class="entry-header">
						<div class="entry-meta">
							<span class="cat-links"><?php the_category( ', ' ); ?></span>
						</div>
						<?php the_title( '<h1 class="entry-title"><span>', '</span></h1>' ); ?>
						<div class="entry-meta">
							<?php brilliant_posted_on(); ?>
						</div>
					</div><!-- .entry-header -->
				</div>
			</div>
		</div><!-- .cover -->
		
	<?php endif; // Featured Image ?>
	
	<div id="primary" class="content-area">
		<main id="main" class="site-main" role="main">
	
		<?php 
			while ( have_posts() ) : the_post();

				get_template_part( 'template-parts/content', 'single' );
				
				the_post_navigation();
		
				// If comments are open or we have at least one comment, load up the comment template.
				if ( comments_open() || get_comments_number() ) :
					comments_template();
				endif;
				
			endwhile; // End of the loop.
		?>

		</main><!-- #main -->
	</div><!-- #primary -->

<?php endif; ?>

<?php get_sidebar(); ?>
<?php get_footer(); ?>
