<?php
/**
 * Displays the searchform of the theme.
 *
 * @package Brilliant
 * @since Brilliant 1.0
 */
?>

<form role="search" method="get" class="search-form clear" action="<?php echo esc_url( home_url( '/' ) ); ?>">
	<label>
		<span class="screen-reader-text"><?php _ex( 'Search for:', 'label', 'brilliant' ); ?></span>
		<input type="search" id="s" class="search-field" placeholder="<?php echo esc_attr_x( 'Search &hellip;', 'placeholder', 'brilliant' ); ?>" value="<?php echo get_search_query(); ?>" name="s" />
	</label>
	<button type="submit" class="search-submit"><span class="ei icon_search"></span> <span class="screen-reader-text"><?php _ex( 'Search', 'submit button', 'brilliant' ); ?></span></button>
</form>
