<?php
/**
 * The template for displaying search results pages.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#search-result
 *
 * @package Brilliant
 * @since Brilliant 1.0
 */

get_header(); ?>
	
	<?php
	/* Archive Options */
	$archive_layout = get_theme_mod('archive_layout', 'archive-layout2');
	$post_template = brilliant_archive_template();
	$post_column = brilliant_archive_column();
	?>
	
	<section id="primary" class="content-area">
		<main id="main" class="site-main" role="main">

			<header class="page-header">
				<div class="page-header-wrapper">
					<?php if ( have_posts() ) : ?>
						<h1 class="page-title"><?php printf( esc_html__( 'Search Results for: %s', 'brilliant' ), '<strong>' . get_search_query() . '</strong>' ); ?></h1>
					<?php else : ?>
						<h1 class="page-title"><?php _e( 'Nothing Found', 'brilliant' ); ?></h1>
					<?php endif; ?>
				</div>
			</header><!-- .page-header -->
			
			<?php if ( have_posts() ) : ?>
			
				<section class="row posts-loop <?php if ( $archive_layout == 'archive-layout2' ) { echo esc_attr('flex-row'); } ?>">
					<?php
					/* Start the Loop */
					while ( have_posts() ) : the_post();
		
						/**
						 * Run the loop for the search to output the results.
						 * If you want to overload this in a child theme then include a file
						 * called content-search.php and that will be used instead.
						 */ ?>
						<div class="post-wrapper <?php echo $post_column; ?>">
							<?php get_template_part( 'template-parts/' . $post_template ); ?>
						</div>
					<?php endwhile; ?>
				</section>
				
				<?php the_posts_navigation(); ?>
			
			<?php else : ?>

				<p><?php _e( 'Sorry, but nothing matched your search terms. Please try again with some different keywords.', 'brilliant' ); ?></p>
				<?php get_search_form(); ?>

			<?php endif; ?>
			
		</main><!-- #main -->
	</section><!-- #primary -->

<?php get_sidebar(); ?>
<?php get_footer(); ?>
