<?php
/**
 * The main template file.
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Brilliant
 * @since Brilliant 1.0
 */

get_header(); ?>
	
	<?php
	if ( have_posts() ) : ?>

		<?php
		$blog_layout = get_theme_mod('blog_layout', 'blog-layout4');

		if ( is_home() && ! is_paged() && ( $blog_layout == 'blog-layout3' || $blog_layout == 'blog-layout4' ) ) :
			
			get_template_part( 'template-parts/loop-first-overlay' );		
		
		else :
		
		// Blog Options
		$post_template = brilliant_blog_template();
		$post_column = brilliant_blog_column();	
		?>
		
			<div id="primary" class="content-area">
				<main id="main" class="site-main" role="main">
					<section class="row posts-loop <?php if ( $blog_layout == 'blog-layout2' || $blog_layout == 'blog-layout4' ) { echo esc_attr('flex-row'); } ?>">
						
						<?php /* Start the Loop */
						while ( have_posts() ) : the_post(); ?>
							<div class="post-wrapper <?php echo $post_column; ?>">
								<?php get_template_part( 'template-parts/' . $post_template, get_post_format() ); ?>
							</div>
						<?php endwhile; ?>
						
					</section>
					<?php the_posts_navigation(); ?>
				</main><!-- #main -->
			</div><!-- #primary -->
		
		<?php
		endif; ?>
	
	<?php else : ?>

			<?php get_template_part( 'template-parts/content', 'none' ); ?>
		
	<?php endif; ?>

<?php get_sidebar(); ?>
<?php get_footer(); ?>
