<?php
/**
 * Custom template tags for this theme.
 *
 * Eventually, some of the functionality here could be replaced by core features.
 *
 * @package Brilliant
 * @since Brilliant 1.0
 */


if ( ! function_exists( 'brilliant_time_link' ) ) :
/**
 * Prints HTML with the published date.
 */
function brilliant_time_link() {
	$time_string = '<time class="entry-date published updated" datetime="%1$s">%2$s</time>';
	if ( get_the_time( 'U' ) !== get_the_modified_time( 'U' ) ) {
		$time_string = '<time class="entry-date published" datetime="%1$s">%2$s</time><time class="updated" datetime="%3$s">%4$s</time>';
	}

	$time_string = sprintf( $time_string,
		get_the_date( DATE_W3C ),
		get_the_date(),
		get_the_modified_date( DATE_W3C ),
		get_the_modified_date()
	);
	
	printf( '<span class="posted-on"><span class="screen-reader-text">%1$s</span> <a href="%2$s" rel="bookmark">%3$s</a></span>',
		_x( 'Posted on', 'Used before publish date.', 'brilliant' ),
		esc_url( get_permalink() ),
		$time_string
	);
}
endif;


if ( ! function_exists( 'brilliant_author_link' ) ) :
/**
 * Prints HTML with the Author.
 */
function brilliant_author_link() {
	printf( '<span class="byline"><span class="author vcard">'. __( 'by', 'brilliant' ) .' %1$s</span></span>',
		sprintf( '<a class="url fn n" href="%1$s">%2$s</a>',
			esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ),
			esc_html( get_the_author() )
		)
	);
}
endif;


if ( ! function_exists( 'brilliant_author_avatar_link' ) ) :
/**
 * Prints HTML with the Author.
 */
function brilliant_author_avatar_link() {
	printf( '<span class="byline"><span class="author vcard"><span class="screen-reader-text">%1$s</span> <a class="url fn n" href="%2$s">%3$s %4$s</a></span></span>',
		_x( 'Author', 'Used before post author name.', 'brilliant' ),
		esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ),
		get_avatar( get_the_author_meta( 'user_email' ), 20 ),
		get_the_author()
	);
}
endif;


if ( ! function_exists( 'brilliant_posted_on' ) ) :
/**
 * Prints HTML with meta information for the current post-date/time and author.
 */
function brilliant_posted_on() {
	
	brilliant_time_link();
		
	if ( in_the_loop() ) {
		brilliant_author_avatar_link();
	} else {
		global $post;
		$author_id = $post->post_author;
		printf( '<span class="byline"><span class="author vcard"><span class="screen-reader-text">%1$s</span> <a class="url fn n" href="%2$s">%3$s %4$s</a></span></span>',
			_x( 'Author', 'Used before post author name.', 'brilliant' ),
			esc_url( get_author_posts_url( get_the_author_meta( 'ID', $author_id ) ) ),
			get_avatar( get_the_author_meta( 'user_email' ), 20 ),
			get_the_author_meta( 'display_name', $author_id )
		);
	}
		
}
endif;


if ( ! function_exists( 'brilliant_entry_footer' ) ) :
/**
 * Prints HTML with meta information for the categories, tags and comments.
 */
function brilliant_entry_footer() {
	// Hide category and tag text for pages.
	if ( 'post' === get_post_type() ) {
		/* translators: used between list items, there is a space after the comma */
		$categories_list = get_the_category_list( esc_html__( ', ', 'brilliant' ) );
		if ( $categories_list && brilliant_categorized_blog() ) {
			printf( '<span class="cat-links">' . esc_html__( 'Posted in %1$s', 'brilliant' ) . '</span>', $categories_list ); // WPCS: XSS OK.
		}

		/* translators: used between list items, there is a space after the comma */
		$tags_list = get_the_tag_list( '', esc_html__( ', ', 'brilliant' ) );
		if ( $tags_list ) {
			printf( '<span class="tags-link">' . esc_html__( 'Tagged %1$s', 'brilliant' ) . '</span>', $tags_list ); // WPCS: XSS OK.
		}
	}

	if ( is_single() && ! post_password_required() && ( comments_open() || get_comments_number() ) ) {
		echo '<span class="comments-link">';
		/* translators: %s: post title */
		comments_popup_link( sprintf( wp_kses( __( 'Leave a Comment<span class="screen-reader-text"> on %s</span>', 'brilliant' ), array( 'span' => array( 'class' => array() ) ) ), get_the_title() ) );
		echo '</span>';
	}

	edit_post_link(
		sprintf(
			/* translators: %s: Name of current post */
			esc_html__( 'Edit %s', 'brilliant' ),
			the_title( '<span class="screen-reader-text">"', '"</span>', false )
		),
		'<span class="sep">&bull;</span><span class="edit-link">',
		'</span>'
	);
}
endif;


/**
 * Returns true if a blog has more than 1 category.
 *
 * @return bool
 */
function brilliant_categorized_blog() {
	if ( false === ( $all_the_cool_cats = get_transient( 'brilliant_categories' ) ) ) {
		// Create an array of all the categories that are attached to posts.
		$all_the_cool_cats = get_categories( array(
			'fields'     => 'ids',
			'hide_empty' => 1,
			// We only need to know if there is more than one category.
			'number'     => 2,
		) );

		// Count the number of categories that are attached to the posts.
		$all_the_cool_cats = count( $all_the_cool_cats );

		set_transient( 'brilliant_categories', $all_the_cool_cats );
	}

	if ( $all_the_cool_cats > 1 ) {
		// This blog has more than 1 category so brilliant_categorized_blog should return true.
		return true;
	} else {
		// This blog has only 1 category so brilliant_categorized_blog should return false.
		return false;
	}
}
