<?php
/**
 * Brilliant Customizer functionality
 *
 * @package Brilliant
 * @since Brilliant 1.0
 */


/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function brilliant_customize_preview_js() {
	wp_enqueue_script( 'brilliant_customizer', get_template_directory_uri() . '/inc/js/customizer.js', array( 'customize-preview' ), '20161110', true );
}
add_action( 'customize_preview_init', 'brilliant_customize_preview_js' );


/**
 * This function adds some styles to the WordPress Customizer
 */
function brilliant_customizer_styles() {

	$customizer_custom_styles = '.customize-control-brilliant-content {margin: 0;}';

	echo '<style id="brilliant-customizer-css">' . $customizer_custom_styles . '</style>';

}
add_action( 'customize_controls_print_styles', 'brilliant_customizer_styles', 999 );


/**
 * Custom Classes
 */
if ( class_exists( 'WP_Customize_Control' ) ) {

	class Brilliant_Important_Links extends WP_Customize_Control {

		public $type = "brilliant-important-links";

		public function render_content() {
			$important_links = array(
			'upgrade' => array(
			'link' => esc_url('https://www.designlabthemes.com/brilliant-plus-wordpress-theme/?utm_source=WordPress&utm_medium=customizer_link&utm_campaign=brilliant_upsell'),
			'text' => __('Try Brilliant Plus', 'brilliant'),
			),
			'theme' => array(
			'link' => esc_url('https://www.designlabthemes.com/brilliant-wordpress-theme/'),
			'text' => __('Theme Homepage', 'brilliant'),
			),
			'documentation' => array(
			'link' => esc_url('https://www.designlabthemes.com/brilliant-documentation/'),
			'text' => __('Theme Documentation', 'brilliant'),
			),
			'rating' => array(
			'link' => esc_url('https://wordpress.org/support/theme/brilliant/reviews/#new-post'),
			'text' => __('Rate This Theme', 'brilliant'),
			),
			'twitter' => array(
			'link' => esc_url('https://twitter.com/designlabthemes'),
			'text' => __('Follow on Twitter', 'brilliant'),
			)
		);
		foreach ($important_links as $important_link) {
			echo '<p><a class="button" target="_blank" href="' . esc_url( $important_link['link'] ). '" >' . esc_html($important_link['text']) . ' </a></p>';
			}
		}
	}

	class Brilliant_Customize_Plus_Link extends WP_Customize_Control {
		public $type = 'brilliant-plus-version';

		function render_content() {
		$pro_version_text = esc_html( 'Try Brilliant Plus', 'brilliant' );
		$pro_version_link = esc_url( 'https://www.designlabthemes.com/brilliant-plus-wordpress-theme/?utm_source=WordPress&utm_medium=customizer_link&utm_campaign=brilliant_upsell' );

		if ( ! empty( $this->label ) ) {
			echo '<div class="description customize-control-description brilliant-custom-description">';
			echo '<strong>' . esc_html( $this->label ) . '</strong> ';
			echo '<a target="_blank" href="' . esc_url( $pro_version_link ). '" >' . esc_html( $pro_version_text ) . '</a>';
			echo '</div>';
			}
		}
	}

	class Brilliant_Customize_Heading extends WP_Customize_Control {
		public $type = 'brilliant-content';

		function render_content() {
			if ( ! empty( $this->label ) ) {
				echo '<span class="customize-control-title brilliant-custom-title">' . esc_html( $this->label ) . '</span>';
			}
			if ( ! empty( $this->description ) ) {
				echo '<div class="description customize-control-description brilliant-custom-description">' . $this->description . '</div>';
			}
		}
	}

}


/**
 * Theme Settings
 */
function brilliant_theme_customizer( $wp_customize ) {

	// Add postMessage support for site title and description for the Theme Customizer.
	$wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';

	// Set to refresh the Background Color Setting
	$wp_customize->get_setting( 'background_color' )->transport = 'refresh';

	/* Panels */
	$wp_customize->add_panel( 'brilliant_panel', array(
		'title'		=> __( 'Brilliant Settings', 'brilliant' ),
		'priority'	=> 10,
	) );

	/* Sections */
	$wp_customize->add_section('brilliant_links_section', array(
		'priority' => 2,
		'title' => __('Brilliant Links', 'brilliant'),
	) );

	$wp_customize->add_section( 'general_section', array(
		'title'		=> __( 'General', 'brilliant' ),
		'description' => __( 'Main Theme Settings.', 'brilliant' ),
		'priority'	=> 5,
		'panel'		=> 'brilliant_panel',
	) );

	$wp_customize->add_section( 'header_section', array(
		'title'       => __( 'Header', 'brilliant' ),
		'description' => __( 'Settings for Site Header.', 'brilliant' ),
		'priority'    => 10,
		'panel' => 'brilliant_panel',
	) );

	$wp_customize->add_section( 'home_section', array(
		'title'       => __( 'Homepage', 'brilliant' ),
		'priority'    => 15,
		'panel' => 'brilliant_panel',
		'description'	=> __( 'Settings for Blog Homepage.', 'brilliant' ),
	) );

	$wp_customize->add_section( 'archive_section', array(
		'title'       => __( 'Categories & Archives', 'brilliant' ),
		'priority'    => 20,
		'panel' => 'brilliant_panel',
		'description'	=> __( 'Settings for Category, Tag, Search and Archive Pages.', 'brilliant' ),
	) );

	$wp_customize->add_section( 'post_section', array(
		'title'       => __( 'Post', 'brilliant' ),
		'description' => __( 'Settings for Single Post.', 'brilliant' ),
		'priority'    => 25,
		'panel' => 'brilliant_panel',
	) );

	$wp_customize->add_section( 'page_section', array(
		'title'       => __( 'Page', 'brilliant' ),
		'description' => __( 'Settings for Static Page.', 'brilliant' ),
		'priority'    => 30,
		'panel' => 'brilliant_panel',
	) );

	/* Controls */

	// Brilliant Links
	$wp_customize->add_setting('brilliant_links', array(
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'esc_url_raw',
	) );

	$wp_customize->add_control(new Brilliant_Important_Links($wp_customize, 'brilliant_links', array(
		'section' => 'brilliant_links_section',
	) ) );

	// General - Read More Link
	$wp_customize->add_setting( 'show_read_more', array(
		'default' => 1,
		'sanitize_callback' => 'brilliant_sanitize_checkbox',
	) );

	$wp_customize->add_control( 'show_read_more', array(
		'label'    => __( 'Display Read More Link', 'brilliant' ),
		'section'  => 'general_section',
		'type'     => 'checkbox',
	) );

	// General - Pro Link
	$wp_customize->add_setting( 'general_pro_link', array(
		'sanitize_callback' => 'sanitize_text_field',
	) );

	$wp_customize->add_control( new Brilliant_Customize_Plus_Link( $wp_customize, 'general_pro_link', array(
		'label'      => __( 'Need more options?', 'brilliant' ),
		'section'  => 'general_section',
	) ) );

	// Header - Layout
	$wp_customize->add_setting( 'header_layout', array(
		'default' => 'head-center1',
		'sanitize_callback' => 'brilliant_sanitize_choices',
	) );

	$wp_customize->add_control( 'header_layout', array(
		'label'    => __( 'Header Layout', 'brilliant' ),
		'section'  => 'header_section',
		'type'     => 'radio',
		'choices'  => array(
			'head-left1' => __('1: Site Title on the left and Navigation on the right', 'brilliant'),
			'head-center1' => __('2: Site Title centered and Navigation below', 'brilliant'),
	) ) );

	// Header - Pro Link
	$wp_customize->add_setting( 'header_pro_link', array(
		'sanitize_callback' => 'sanitize_text_field',
	) );

	$wp_customize->add_control( new Brilliant_Customize_Plus_Link( $wp_customize, 'header_pro_link', array(
		'label'      => __( 'Need more options?', 'brilliant' ),
		'section'  => 'header_section',
	) ) );

	// Blog - Layout
	$wp_customize->add_setting( 'blog_layout', array(
		'default' => 'blog-layout4',
		'sanitize_callback' => 'brilliant_sanitize_choices',
	) );

	$wp_customize->add_control( 'blog_layout', array(
		'label'    => __( 'Layout', 'brilliant' ),
		'section'  => 'home_section',
		'type'     => 'radio',
		'choices'  => array(
			'blog-layout1' => __('Classic: Large Posts + Sidebar', 'brilliant'),
			'blog-layout2' => __('Grid: Two Columns + Sidebar', 'brilliant'),
			'blog-layout3' => __('First Overlay Post then Large + Sidebar', 'brilliant'),
			'blog-layout4' => __('First Overlay Post then Grid + Sidebar', 'brilliant'),
			),
	) );

	// Blog - Excerpt Length
	$wp_customize->add_setting( 'blog_excerpt_length', array(
		'default' => 25,
		'sanitize_callback' => 'absint',
	) );

	$wp_customize->add_control( 'blog_excerpt_length', array(
		'label'    => __( 'Excerpt length', 'brilliant' ),
		'section'  => 'home_section',
		'type'     => 'number',
	) );

	// Blog - Pro Link
	$wp_customize->add_setting( 'blog_pro_link', array(
		'sanitize_callback' => 'sanitize_text_field',
	) );

	$wp_customize->add_control( new Brilliant_Customize_Plus_Link( $wp_customize, 'blog_pro_link', array(
		'label'      => __( 'Need more options?', 'brilliant' ),
		'section'  => 'home_section',
	) ) );

	// Archives - Layout
	$wp_customize->add_setting( 'archive_layout', array(
        'default' => 'archive-layout2',
        'sanitize_callback' => 'brilliant_sanitize_choices',
    ) );

	$wp_customize->add_control( 'archive_layout', array(
	    'label'    => __( 'Archives Layout', 'brilliant' ),
	    'section'  => 'archive_section',
	    'type'     => 'radio',
		'choices'  => array(
			'archive-layout1' => __('Classic: Large Posts + Sidebar', 'brilliant'),
			'archive-layout2' => __('Grid: Two Columns + Sidebar', 'brilliant'),
			),
	) );

	// Archives - Excerpt Length
	$wp_customize->add_setting( 'archive_excerpt_length', array(
        'default' => 25,
        'sanitize_callback' => 'absint',
    ) );

	$wp_customize->add_control( 'archive_excerpt_length', array(
	    'label'    => __( 'Excerpt length', 'brilliant' ),
	    'section'  => 'archive_section',
	    'type'     => 'number',
	) );

	// Archives - Pro Link
	$wp_customize->add_setting( 'archive_pro_link', array(
		'sanitize_callback' => 'sanitize_text_field',
	) );

	$wp_customize->add_control( new Brilliant_Customize_Plus_Link( $wp_customize, 'archive_pro_link', array(
		'label'      => __( 'Need more options?', 'brilliant' ),
		'section'  => 'archive_section',
	) ) );

	// Post - Featured Image
	$wp_customize->add_setting('post_featured_image', array(
		'sanitize_callback' => 'sanitize_text_field',
	) );

	$wp_customize->add_control(new Brilliant_Customize_Heading($wp_customize, 'post_featured_image', array(
		'label'    => __( 'Featured Image', 'brilliant' ),
		'description' => __( 'Full width images must be at least 1160px', 'brilliant' ),
		'section'  => 'post_section',
	) ) );

	$wp_customize->add_setting( 'post_has_featured_image', array(
        'default' => 1,
        'sanitize_callback' => 'brilliant_sanitize_checkbox',
    ) );

	$wp_customize->add_control( 'post_has_featured_image', array(
	    'label'    => __( 'Display Featured Image', 'brilliant' ),
	    'section'  => 'post_section',
	    'type'     => 'checkbox',
	) );

	$wp_customize->add_setting( 'post_featured_image_size', array(
        'default' => 'overlay',
        'sanitize_callback' => 'brilliant_sanitize_choices',
    ) );

	$wp_customize->add_control( 'post_featured_image_size', array(
	    'description' => __( 'Select style:', 'brilliant' ),
	    'section'  => 'post_section',
	    'type'     => 'radio',
		'choices'  => array(
			'onecolumn' => __('Classic', 'brilliant'),
			'overlay' => __('Cover Image', 'brilliant'),
			),
		'active_callback' => 'brilliant_post_has_featured_image',
	) );

	// Post options
	$wp_customize->add_setting('post_options', array(
		'sanitize_callback' => 'sanitize_text_field',
	) );

	$wp_customize->add_control(new Brilliant_Customize_Heading($wp_customize, 'post_options', array(
		'label'    => __( 'Post Options', 'brilliant' ),
		'section'  => 'post_section',
	) ) );

	$wp_customize->add_setting( 'show_author_bio', array(
        'default' => '',
        'sanitize_callback' => 'brilliant_sanitize_checkbox',
    ) );

	$wp_customize->add_control( 'show_author_bio', array(
	    'label'    => __( 'Display Author Bio', 'brilliant' ),
	    'section'  => 'post_section',
	    'type'     => 'checkbox',
	) );

	// Page - Featured Image
	$wp_customize->add_setting('page_featured_image', array(
		'sanitize_callback' => 'sanitize_text_field',
	) );

	$wp_customize->add_control(new Brilliant_Customize_Heading($wp_customize, 'page_featured_image', array(
		'label'    => __( 'Featured Image', 'brilliant' ),
		'description' => __( 'Full width images must be at least 1160px', 'brilliant' ),
		'section'  => 'page_section',
	) ) );

	$wp_customize->add_setting( 'page_has_featured_image', array(
        'default' => 1,
        'sanitize_callback' => 'brilliant_sanitize_checkbox',
    ) );

	$wp_customize->add_control( 'page_has_featured_image', array(
	    'label'    => __( 'Display Featured Image', 'brilliant' ),
	    'section'  => 'page_section',
	    'type'     => 'checkbox',
	) );

	$wp_customize->add_setting( 'page_featured_image_size', array(
        'default' => 'overlay',
        'sanitize_callback' => 'brilliant_sanitize_choices',
    ) );

	$wp_customize->add_control( 'page_featured_image_size', array(
	    'description' => __( 'Select style:', 'brilliant' ),
	    'section'  => 'page_section',
	    'type'     => 'radio',
		'choices'  => array(
			'onecolumn' => __('Classic', 'brilliant'),
			'overlay' => __('Cover Image', 'brilliant'),
		),
		'active_callback' => 'brilliant_page_has_featured_image',
	) );

	// Logo Max Width (desktop)
	$wp_customize->add_setting( 'logo_width_lg', array(
        'default' => 260,
        'sanitize_callback' => 'absint',
	) );

	$wp_customize->add_control( 'logo_width_lg', array(
        'label' => __( 'Logo Max Width (desktop)', 'brilliant' ),
        'section'  => 'title_tagline',
        'type'     => 'number',
        'priority' => 9,
    ) );

	// Logo Max Width (mobile)
	$wp_customize->add_setting( 'logo_width_sm', array(
        'default' => 180,
        'sanitize_callback' => 'absint',
	) );

	$wp_customize->add_control( 'logo_width_sm', array(
        'label' => __( 'Logo Max Width (mobile)', 'brilliant' ),
        'section'  => 'title_tagline',
        'type'     => 'number',
        'priority' => 9,
    ) );

    // Logo Fullwidth
	$wp_customize->add_setting( 'logo_fullwidth', array(
        'default' => '',
        'sanitize_callback' => 'brilliant_sanitize_checkbox',
    ) );

	$wp_customize->add_control( 'logo_fullwidth', array(
	    'label'    => __( 'Display Fullwidth Logo', 'brilliant' ),
	    'description'    => __( 'If you previously uploaded a Logo, please re-upload it. To center the Logo go to "Theme Settings &raquo; Header" and select "Site Title centered" style.', 'brilliant' ),
	    'section'  => 'title_tagline',
	    'type'     => 'checkbox',
	    'priority' => 9,
	) );

    // Accent Color
	$wp_customize->add_setting( 'accent_color', array(
		'default' => '#e63855',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'accent_color', array(
		'label' => __( 'Accent Color', 'brilliant' ),
		'section' => 'colors',
	) ) );

	// Site Title Color
	$wp_customize->add_setting( 'site_title_color', array(
		'default' => '#000000',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'site_title_color', array(
		'label' => __( 'Site Title', 'brilliant' ),
		'section' => 'colors',
	) ) );

	// Site Tagline Color
	$wp_customize->add_setting( 'site_tagline_color', array(
		'default' => '#666666',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'site_tagline_color', array(
		'label' => __( 'Site Tagline', 'brilliant' ),
		'section' => 'colors',
	) ) );

	// Footer Background
	$wp_customize->add_setting( 'footer_bg', array(
		'default' => '#1b2126',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'footer_bg', array(
		'label' => __( 'Footer background', 'brilliant' ),
		'section' => 'colors',
	) ) );

}
add_action('customize_register', 'brilliant_theme_customizer');


/**
 * Sanitize Checkbox
 *
 */
function brilliant_sanitize_checkbox( $input ) {
    if ( $input == 1 ) {
        return 1;
    } else {
        return '';
    }
}


/**
 * Sanitize Radio Buttons and Select Lists
 *
 */
function brilliant_sanitize_choices( $input, $setting ) {
    global $wp_customize;

    $control = $wp_customize->get_control( $setting->id );

    if ( array_key_exists( $input, $control->choices ) ) {
        return $input;
    } else {
        return $setting->default;
    }
}


/**
 * Checks if Single Post has featured image.
 */
function brilliant_post_has_featured_image( $control ) {
    if ( $control->manager->get_setting('post_has_featured_image')->value() == 1 ) {
		return true;
    } else {
        return false;
    }
}


/**
 * Checks if Page has featured image.
 */
function brilliant_page_has_featured_image( $control ) {
    if ( $control->manager->get_setting('page_has_featured_image')->value() == 1 ) {
		return true;
    } else {
        return false;
    }
}
