<?php
/**
 * Add inline CSS for styles handled by the Theme customizer
 *
 * @package Brilliant
 * @since Brilliant 1.0
 */


/**
 * Get Contrast
 */
function brilliant_get_brightness($hex) {
	// returns brightness value from 0 to 255
	// strip off any leading #
	$hex = str_replace('#', '', $hex);

	$c_r = hexdec(substr($hex, 0, 2));
	$c_g = hexdec(substr($hex, 2, 2));
	$c_b = hexdec(substr($hex, 4, 2));

	return (($c_r * 299) + ($c_g * 587) + ($c_b * 114)) / 1000;
}


/**
 * Set the custom CSS via Customizer options.
 */
function brilliant_custom_css() {
	$logo_w_desktop = esc_attr( get_theme_mod('logo_width_lg', 260) );
	$logo_w_mobile = esc_attr( get_theme_mod('logo_width_sm', 180) );
	$logo_fullwidth = esc_attr( get_theme_mod('logo_fullwidth') );

	$accent_color = esc_attr( get_theme_mod('accent_color') );
	$site_title_color = esc_attr( get_theme_mod('site_title_color') );
	$site_tagline_color = esc_attr( get_theme_mod('site_tagline_color') );
	$footer_bg = esc_attr( get_theme_mod('footer_bg') );

	$theme_css = "";

	// Logo Size
	if ( $logo_fullwidth != '' ) {
		$theme_css .= ".site-logo {max-width: 100%;}";
	} else {
		if ( $logo_w_mobile != '' ) {
			$theme_css .= "
			@media screen and (max-width: 480px) {
			.site-logo {max-width: {$logo_w_mobile}px;}
			}";
		}
		if ( $logo_w_desktop != '' ) {
			$theme_css .= "
			@media screen and (min-width: 481px) {
			.site-logo {max-width: {$logo_w_desktop}px;}
			}";
		}
	}

	// Accent Color
	if ( $accent_color != '' ) {
		$theme_css .= "
		a, a:hover, .site-info a:hover, .entry-content .has-accent-color,
		.widget a:hover, .comment-metadata a:hover, .site-title a:hover, .entry-title a:hover,
		.posts-navigation a:hover, .cover .read-more, .large-post .read-more,
		.main-navigation ul li:hover > a, .main-navigation ul li:focus > a, .main-navigation .woo-cart-link a:hover,
		.main-navigation > ul > li.current_page_item > a, .main-navigation > ul > li.current-menu-item > a,
		.dropdown-toggle:hover, .dropdown-toggle:focus {
			color: {$accent_color};
		}
		button, input[type='button'], input[type='reset'], input[type='submit'], .entry-content .has-accent-background-color,
		.cover .read-more:hover, .large-post .read-more:hover, .sidebar .widget_tag_cloud a:hover, .reply a:hover {
			background-color: {$accent_color};
		}
		.cover .read-more, .large-post .read-more, .reply a {
			border-color: {$accent_color};
		}
		.format-audio .entry-thumbnail:after, .format-gallery .entry-thumbnail:after, .format-image .entry-thumbnail:after, .format-quote .entry-thumbnail:after, .format-video .entry-thumbnail:after {
			border-top-color: {$accent_color};
		}";
		if ( brilliant_get_brightness($accent_color) > 155) {
			$theme_css .= "
			button, input[type='button'], input[type='reset'], input[type='submit'], .cover .read-more:hover, .large-post .read-more:hover, .sidebar .widget_tag_cloud a:hover, .reply a:hover,
			.format-audio .entry-thumbnail:before, .format-gallery .entry-thumbnail:before, .format-image .entry-thumbnail:before, .format-quote .entry-thumbnail:before, .format-video .entry-thumbnail:before {
				color: rgba(0,0,0,.7);
			}";
		}
	}

	// Site Title Color
	if ( $site_title_color != '' ) {
		$theme_css .= "
		.site-title a, .site-title a:hover {color: {$site_title_color};}
		.site-title a:hover {opacity: .7;}
		";
	}

	// Site Tagline Color
	if ( $site_tagline_color != '' ) {
		$theme_css .= ".site-description {color: {$site_tagline_color};}";
	}

	// Footer Background
	if ( $footer_bg != '' ) {
		$theme_css .= " .site-footer {background-color: {$footer_bg};}";

		if ( brilliant_get_brightness($footer_bg) > 155) {
		$theme_css .= "
			.site-footer {
			border-top: 1px solid rgba(0,0,0,.08);
			}
			.site-info, .site-credits,
			.site-footer .widget-area  {
			color: rgba(0,0,0,.7);
			}
			.site-info a, .site-footer .site-info a:hover, .site-footer .widget-title,
			.site-footer .widget a, .site-footer .widget a:hover {
			color: rgba(0,0,0,.8);
			}
			.site-footer .widget-area ul li {
			border-bottom-color: rgba(0,0,0,.05);
			}
			.site-footer .widget_tag_cloud a {
			border-color: rgba(0,0,0,.05);
			background-color: rgba(0,0,0,.05);
			}";
		}
	}

	// Add Custom Styles if Body Background is white
	$background_color = get_background_color();
	if ( $background_color == 'ffffff' ) {
		$theme_css .= "
		.hentry, .no-results, .widget, .related-posts, .posts-navigation, .post-navigation, .comments-area, .author-info {
		box-shadow: none;
		}
		.posts-loop .entry-header, .posts-loop .entry-summary, .posts-loop .entry-footer,
		.entry-header, .entry-content, .entry-footer, .author-info, .comments-area {
		padding-left: 0;padding-right: 0;
		}
		.sidebar .widget {padding: 0;}
		@media screen and (min-width: 600px) {
		.list-post {padding: 0;margin-bottom: 30px;}
		}";
	}

	return $theme_css;
}


/**
 * Enqueue the Customizer styles on the front-end.
 */
function brilliant_custom_style() {
	$custom_css = brilliant_custom_css();
	if ( ! empty($custom_css) ) {
		wp_add_inline_style( 'brilliant-style', $custom_css );
	}
}
add_action( 'wp_enqueue_scripts', 'brilliant_custom_style' );


/**
  * Set the custom CSS via Customizer options.
  */
function brilliant_editor_css() {
	$accent_color = esc_attr( get_theme_mod('accent_color') );

	$editor_css = "";

	// Accent Color
	if ( ! empty( $accent_color ) ) {
		$editor_css .= "
		.editor-styles-wrapper :where(.wp-block a),
		.editor-styles-wrapper :where(.wp-block a:hover),
		.wp-block-freeform.block-library-rich-text__tinymce a
		.wp-block-freeform.block-library-rich-text__tinymce a:hover {
			color: {$accent_color};
		}";
	}

	return $editor_css;
}


/**
 * Enqueue styles for the block-based editor.
 */
function brilliant_editor_style() {
	// Add Google fonts.
	wp_enqueue_style( 'brilliant-fonts', brilliant_fonts_url(), array(), null );
	// Add Editor style.
	wp_enqueue_style( 'brilliant-block-editor-style', get_theme_file_uri( '/inc/css/editor-blocks.css' ) );
	wp_add_inline_style( 'brilliant-block-editor-style', brilliant_editor_css() );
}
add_action( 'enqueue_block_editor_assets', 'brilliant_editor_style' );
