<?php
/**
 * The header for our theme.
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-template-parts
 *
 * @package Brilliant
 * @since Brilliant 1.0
 */

?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<?php if ( is_singular() && pings_open( get_queried_object() ) ) : ?>
	<link rel="pingback" href="<?php echo esc_url( get_bloginfo( 'pingback_url' ) ); ?>">
	<?php endif; ?>
	<?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>

<?php
wp_body_open();
?>

<div id="page" class="site">

	<?php
	// Header Template
	$header_layout = get_theme_mod( 'header_layout', 'head-center1' );
	?>
	<header id="masthead" class="site-header <?php if ( $header_layout == 'head-center1' ) { echo esc_attr('nav-below'); } ?>" role="banner">
		<?php
		if ( $header_layout == 'head-center1' ) {
			get_template_part( 'template-parts/header/logo', 'centered' );
		} else {
			get_template_part( 'template-parts/header/logo', 'left' );
		}
		?>
	</header><!-- .site-header -->

	<div id="content" class="site-content">
		<div class="container">
