<?php
/**
 * The template for displaying the footer.
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-template-parts
 *
 * @package Brilliant
 * @since Brilliant 1.0
 */

?>
		</div><!-- .container -->
	</div><!-- #content -->

	<footer id="colophon" class="site-footer" role="contentinfo">
			
		<div class="widget-area" role="complementary">
			<div class="container">
				<div class="row">
					<div class="col-4 col-md-4" id="footer-area-1">
						<?php if ( is_active_sidebar( 'footer-1' ) ) : ?>
							<?php dynamic_sidebar( 'footer-1' ); ?>
						<?php endif; // end footer widget area 1 ?>
					</div>	
					<div class="col-4 col-md-4" id="footer-area-2">
						<?php if ( is_active_sidebar( 'footer-2' ) ) : ?>
							<?php dynamic_sidebar( 'footer-2' ); ?>
						<?php endif; // end footer widget area 2 ?>
					</div>
					<div class="col-4 col-md-4" id="footer-area-3">
						<?php if ( is_active_sidebar( 'footer-3' ) ) : ?>
							<?php dynamic_sidebar( 'footer-3' ); ?>
						<?php endif; // end footer widget area 3 ?>
					</div>
				</div>
			</div><!-- .container -->
		</div><!-- .widget-area -->
		
		<div class="footer-copy">
			<div class="container">
				<div class="row">
					<div class="col-6 col-sm-12">
						<div class="site-credits"><?php brilliant_credits(); ?></div>
					</div>
					<div class="col-6 col-sm-12">
						<div class="site-info">
							<a href="<?php echo esc_url( __( 'https://wordpress.org/', 'brilliant' ) ); ?>"><?php printf( __( 'Powered by %s', 'brilliant' ), 'WordPress' ); ?></a>
							<span class="sep"> / </span>
							<a href="<?php echo esc_url( __( 'https://www.designlabthemes.com/', 'brilliant' ) ); ?>" rel="nofollow"><?php printf( __( 'Theme by %s', 'brilliant' ), 'Design Lab' ); ?></a>
						</div><!-- .site-info -->
					</div>
				</div>
			</div><!-- .container -->
		</div><!-- .footer-copy -->
		
	</footer><!-- #colophon -->
</div><!-- #page -->

<?php wp_footer(); ?>

</body>
</html>
