<?php
/**
 * The template for displaying archive pages.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Brilliant
 * @since Brilliant 1.0
 */

get_header(); ?>
	
	<?php
	/* Archive Options */
	$archive_layout = get_theme_mod('archive_layout', 'archive-layout2');
	$post_template = brilliant_archive_template();
	$post_column = brilliant_archive_column();
	?>
	
	<div id="primary" class="content-area">
		<main id="main" class="site-main" role="main">
		<?php
		if ( have_posts() ) : ?>
		
			<header class="page-header">
				<div class="page-header-wrapper">
				<?php
					the_archive_title( '<h1 class="page-title">', '</h1>' );
					the_archive_description( '<div class="taxonomy-description">', '</div>' );
				?>
				</div>
			</header><!-- .page-header -->
			
			<section class="row posts-loop <?php if ( $archive_layout == 'archive-layout2' ) { echo esc_attr('flex-row'); } ?>">
				<?php
				/* Start the Loop */
				while ( have_posts() ) : the_post();
	
					/*
					 * Include the Post-Format-specific template for the content.
					 * If you want to override this in a child theme, then include a file
					 * called content-___.php (where ___ is the Post Format name) and that will be used instead.
					 */ ?>
					<div class="post-wrapper <?php echo $post_column; ?>">
						<?php get_template_part( 'template-parts/' . $post_template, get_post_format() ); ?>
					</div>
				<?php endwhile; ?>
			</section>
			
			<?php the_posts_navigation();
				
		else :
		
			get_template_part( 'template-parts/content', 'none' );
		
		endif; ?>
		</main><!-- #main -->
	</div><!-- #primary -->

<?php get_sidebar(); ?>
<?php get_footer(); ?>
