<?php
/**
 * Theme About Page
 *
 * @package Bold Photography Blocks
 * @since 1.0
 */

function bold_photography_blocks_admin_plugin_notice()
{

	$screen = get_current_screen();

	if (! empty($screen->base) && 'appearance_page_bold-photography-blocks-theme' === $screen->base) {
		return false;
	}
?>
	<div class="notice notice-info is-dismissible bold-photography-blocks-admin-notice">
		<div class="bold-photography-blocks-admin-notice-wrapper">
			<h2><?php esc_html_e('Bold Photography Blocks Pro', 'bold-photography-blocks'); ?></h2>
			<p><?php esc_html_e('Get your hands on the WordPress Full Site Editing features. Start building your website with advanced block patterns and custom blocks! Get 65+ block patterns, 27 Templates, and 16 Template Parts that are highly customizable and fully responsive.', 'bold-photography-blocks'); ?></p>

			<a target="_blank" class="button-primary button green" href="<?php echo esc_url('https://catchthemes.com/themes/bold-photography-blocks-pro/'); ?>"><?php esc_html_e('Get Bold Photography Blocks Pro', 'bold-photography-blocks'); ?></a>

			<a class="button" href="<?php echo esc_url(admin_url('themes.php?page=bold-photography-blocks-theme')); ?>"><?php esc_html_e('Theme Info', 'bold-photography-blocks'); ?></a>
		</div>
	</div>
<?php
}
add_action('admin_notices', 'bold_photography_blocks_admin_plugin_notice');

function bold_photography_blocks_theme_page_admin_style( $hook ) {
	// Register theme stylesheet.
	$theme_version = wp_get_theme()->get( 'Version' );

	$version_string = is_string( $theme_version ) ? $theme_version : false;
	wp_enqueue_style(
		'bold-photography-blocks-theme-admin-style',
		get_theme_file_uri( 'assets/css/about-admin.css' ),
		array(),
		$version_string
	);
}
add_action( 'admin_enqueue_scripts', 'bold_photography_blocks_theme_page_admin_style' );

/**
 * Add theme page
 */
function bold_photography_blocks_menu() {
	add_theme_page( esc_html__( 'Bold Photography Blocks', 'bold-photography-blocks' ), esc_html__( 'Bold Photography Blocks', 'bold-photography-blocks' ), 'edit_theme_options', 'bold-photography-blocks-theme', 'bold_photography_blocks_theme_page_display' );
}
add_action( 'admin_menu', 'bold_photography_blocks_menu' );

/**
 * Display About page
 */
function bold_photography_blocks_theme_page_display() {
	$theme = wp_get_theme();
	
	if ( is_child_theme() ) {
		$theme = wp_get_theme()->parent();
	}
	?>
	
	<div id="welcome-panel" class="welcome-panel">
		<div class="welcome-panel-content">
			<div class="welcome-panel-header">
				<h2><?php echo esc_html( $theme->Name ); ?></h2>
				<p><?php esc_html_e( 'Full Site Editing WordPress Theme', 'bold-photography-blocks' ); ?></p>
			</div>
			
			<div class="welcome-panel-column-container">
				<div class="container-wrap">
					<div class="welcome-panel-column two-columns">
						<!-- <div class="welcome-panel-icon-pages"></div> -->
						<div class="welcome-panel-column-content">
							<h3><?php esc_html_e( 'Getting Started with Bold Photography Blocks!', 'bold-photography-blocks' ); ?></h3>
							<p><?php esc_html_e( 'Awesome! Bold Photography Blocks has been installed and activated successfully. Now, you can start building your dream website with a wide range of highly-customizable block patterns, templates, and template parts available in this astounding theme.', 'bold-photography-blocks' ); ?></p>
							<a target="_blank" href="https://catchthemes.com/themes/bold-photography-blocks/#theme-instructions"><?php esc_html_e( 'Theme documentation', 'bold-photography-blocks' ); ?></a>
						</div>
					</div>

					<div class="welcome-panel-column two-columns">
						<div class="welcome-panel-column-content">
							<h3><?php esc_html_e( 'More Features with Bold Photography Blocks Pro Theme', 'bold-photography-blocks' ); ?></h3>
							<p><?php esc_html_e( 'To get more beautiful block patterns and templates, we recommend you upgrade to Bold Photography Blocks. With the pro theme installed, get more options, blocks, block patterns, templates and template parts.', 'bold-photography-blocks' ); ?></p>
							<a target="_blank" class="button green button-primary button-hero green" href="https://catchthemes.com/themes/bold-photography-blocks-pro/"><?php esc_html_e( 'Buy Bold Photography Blocks Pro', 'bold-photography-blocks' ); ?></a>
						</div>
					</div>

				</div>
				<div class="sidebar">
					<div class="welcome-panel-column important-links">
					<!-- <div class="welcome-panel-icon-pages"></div> -->
					<div class="welcome-panel-column-content">
						<h3><?php esc_html_e( 'Important Links', 'bold-photography-blocks' ); ?></h3>
						<a target="_blank" href="<?php echo esc_url( $theme->get( 'ThemeURI' ) ); ?>"><?php esc_html_e( 'Theme Info', 'bold-photography-blocks' ); ?></a>
						<a target="_blank" href="https://fse.catchthemes.com/bold-photography-blocks"><?php esc_html_e( 'View Demo', 'bold-photography-blocks' ); ?></a>
						<a  target="_blank" href="<?php echo esc_url( $theme->get( 'ThemeURI' ) . '/#theme-instructions' ); ?>"><?php esc_html_e( 'Theme Instructions', 'bold-photography-blocks' ); ?></a>
						<a  target="_blank" href="<?php echo esc_url( $theme->get( 'ThemeURI' ) . '/#changelog' ); ?>"><?php esc_html_e( 'Change log', 'bold-photography-blocks' ); ?></a>
						<a target="_blank" href="<?php echo esc_url( 'https://catchthemes.com/support-forum/forum/full-site-editing/' ); ?>"><?php esc_html_e( 'Support', 'bold-photography-blocks' ); ?></a>
					</div>
				</div>

				<div class="welcome-panel-column review">
					<!-- <div class="welcome-panel-icon-pages"></div> -->
					<div class="welcome-panel-column-content">
						<h3><?php esc_html_e( 'Leave us a review', 'bold-photography-blocks' ); ?></h3>
						<p><?php esc_html_e( 'Loved Bold Photography Blocks? Feel free to leave your feedback. Your opinion helps us reach more audiences!', 'bold-photography-blocks' ); ?></p>
						<a href="https://wordpress.org/support/theme/bold-photography-blocks/reviews/" class="button button-primary button-hero" style="text-decoration: none;" target="_blank"><?php esc_html_e( 'Review', 'bold-photography-blocks' ); ?></a>
					</div>
				</div>
				</div>
			</div>
		</div>
	</div>
	<?php
}
