<?php
/**
 * Template Name: Home Custom Page
 */
?>

<?php get_header(); ?>

<main id="main" role="main">
  <?php do_action( 'bodyart_tattoo_designer_above_slider' ); ?>
  <?php if( get_theme_mod('bodyart_tattoo_designer_slider_hide_show', false) != ''){ ?> 
    <section id="slider" class=" mw-100">
        
       <!-- <div class="container"> -->
        <div id="carouselExampleCaptions" class="carousel slide" data-bs-ride="carousel"> 
          <?php $bodyart_tattoo_designer_content_pages = array();
            for ( $count = 1; $count <= 4; $count++ ) {
              $mod = intval( get_theme_mod( 'bodyart_tattoo_designer_slider_page' . $count ));
              if ( 'page-none-selected' != $mod ) {
                $bodyart_tattoo_designer_content_pages[] = $mod;
              }
            }
            if( !empty($bodyart_tattoo_designer_content_pages) ) :
              $args = array(
                'post_type' => 'page',
                'post__in' => $bodyart_tattoo_designer_content_pages,
                'orderby' => 'post__in'
              );
              $query = new WP_Query( $args );
            if ( $query->have_posts() ) :
              $i = 1;
          ?>     
          <div class="carousel-inner" role="listbox">
            <?php  while ( $query->have_posts() ) : $query->the_post(); ?>
              <div <?php if($i == 1){echo 'class="carousel-item active"';} else{ echo 'class="carousel-item"';}?>>     
                  <div class="sliderbg-img">
                    <?php the_post_thumbnail(); ?>                            
                    <div class="s-oly"></div>
                    <div class="slider-content">
                      <h2><?php the_title(); ?></h2>
                      <div class="clearfix"></div>
                    </div>
                 </div>   
                
              </div>
            <?php $i++; endwhile; 
            wp_reset_postdata();?>
          </div>
        </div>
        <?php else : ?> 
          <div class="no-postfound"></div>
        <?php endif;
        endif;?>
        <a class="carousel-control-prev" data-bs-target="#carouselExampleCaptions" data-bs-slide="prev" role="button">
          <span class="carousel-control-prev-icon" aria-hidden="true"><i class="fas fa-caret-left"></i></span><span class="screen-reader-text"><?php esc_html_e( 'Previous', 'bodyart-tattoo-designer' );?></span>
        </a>
        <a class="carousel-control-next" data-bs-target="#carouselExampleCaptions" data-bs-slide="next" role="button">
          <span class="carousel-control-next-icon" aria-hidden="true"><i class="fas fa-caret-right"></i></span><span class="screen-reader-text"><?php esc_html_e( 'Next', 'bodyart-tattoo-designer' );?></span>
        </a>
      <!-- </div> -->
      <div class="clearfix"></div>
    </section>
  <?php }?>

  <?php do_action( 'bodyart_tattoo_designer_below_slider' ); ?>

  <section id="feature-section">
    <div class="container">
      <div class="row">
        <div class="titlebx">
          <?php if(get_theme_mod('bodyart_tattoo_designer_btn_featureheading') != '') { ?>
            <div class="feature-head">
              <h4>
                <?php echo esc_html(get_theme_mod('bodyart_tattoo_designer_btn_featureheading')); ?>
              </h4>
              <div class="num">
                <?php echo esc_html(get_theme_mod('bodyart_tattoo_designer_btn_featurenum')); ?>
                <span><?php echo esc_html(get_theme_mod('bodyart_tattoo_designer_btn_featurenumtext')); ?></span>
              </div>
              <p>
                <?php echo esc_html(get_theme_mod('bodyart_tattoo_designer_btn_featuredescription')); ?>
              </p>
              <div class="headbttn">
                <a href="<?php echo esc_url(get_theme_mod('bodyart_tattoo_designer_feature_btnlink')); ?>">
                  <?php echo esc_html(get_theme_mod('bodyart_tattoo_designer_feature_btntext')); ?>
                </a>
            </div>
            </div>
          <?php } ?>
        </div>
        <div class="feature-single-area">
          <div class="row mr-0">
            <?php 
              $page_ids = array();

              $page1 = get_theme_mod('bodyart_tattoo_designer_feature_selected_page1');
              $page2 = get_theme_mod('bodyart_tattoo_designer_feature_selected_page2');
              $page3 = get_theme_mod('bodyart_tattoo_designer_feature_selected_page3');
              $page4 = get_theme_mod('bodyart_tattoo_designer_feature_selected_page4');

              if ($page1) $page_ids[] = absint($page1);
              if ($page2) $page_ids[] = absint($page2);
              if ($page3) $page_ids[] = absint($page3);
              if ($page4) $page_ids[] = absint($page4);

              if (!empty($page_ids)) {
                  $page_query = new WP_Query(array(
                      'post_type' => 'page',
                      'post__in' => $page_ids,
                      'orderby' => 'post__in',
                  ));

                  $count = 1;

                  while ($page_query->have_posts()) : $page_query->the_post();

                  // Get corresponding icon for each count
                  $icon = get_theme_mod('bodyart_tattoo_designer_feature_page_icon' . $count);
            ?>
                <div class="col-lg-6 col-md-6 col-sm-6 feabx">
                    <div class="feature-box ">
                        <div class="fea-tbx">
                            <a href="<?php the_permalink(); ?>">
                                <h3><?php the_title(); ?></h3>
                            </a>
                            <div class="description"><?php the_excerpt(); ?></div>
                        </div>
                        
                        <div class="icon">
                          <i class="<?php echo esc_attr($icon); ?>"></i>
                        </div>
                        <div class="bttn">
                          <a href="<?php the_permalink(); ?>">
                            <?php esc_html_e( 'Read More', 'bodyart-tattoo-designer' ); ?>
                            <i class="fa-solid fa-arrow-right"></i>
                          </a>                        
                        </div>
                    </div>
                    <div class="clearfix"></div>
                </div>
            <?php 
                  $count++;
                  endwhile;
                  wp_reset_postdata();
              }
            ?>
          </div>

        </div>
      </div>
    </div>
    <div class="clearfix"></div>
  </section>

  <?php do_action( 'bodyart_tattoo_designer_below_feature' ); ?>

  <section id="project-section">
    <div class="container-fluid">
      <div class="project-single-area">
        <div class="row mr-0">
            <?php 
              $page_ids = array();

              $page1 = get_theme_mod('bodyart_tattoo_designer_selected_page1');
              $page2 = get_theme_mod('bodyart_tattoo_designer_selected_page2');
              $page3 = get_theme_mod('bodyart_tattoo_designer_selected_page3');

              if ($page1) $page_ids[] = absint($page1);
              if ($page2) $page_ids[] = absint($page2);
              if ($page3) $page_ids[] = absint($page3);

              if (!empty($page_ids)) {
                  $page_query = new WP_Query(array(
                      'post_type' => 'page',
                      'post__in' => $page_ids,
                      'orderby' => 'post__in', // To maintain the selection order
                  ));

                  while ($page_query->have_posts()) : $page_query->the_post();
              ?>
                  <div class="col-lg-4 col-md-4 col-sm-6 projbx">
                      <div class="project-box ">
                          <div class="project-img">
                              <?php the_post_thumbnail(); ?>
                          </div>
                          <div class="project-content">
                              <a href="<?php the_permalink(); ?>">
                                  <h4><?php the_title(); ?></h4>
                              </a>
                              <div class="description"><?php the_excerpt(); ?></div>
                          </div>
                      </div>
                      <div class="clearfix"></div>
                  </div>
              <?php 
                  endwhile;
                  wp_reset_postdata();
              }
              ?>

          </div>
      </div>
    </div>
    <div class="clearfix"></div>
  </section>

  <?php do_action( 'bodyart_tattoo_designer_below_project' ); ?>

  <?php if( get_theme_mod('bodyart_tattoo_designer_service_category') != ''){ ?>

    <section id="service-section">
      <div class="container">
        <?php if(get_theme_mod('bodyart_tattoo_designer_btn_serviceheading') != '') { ?>
          <div class="service-head">
            <p>
              <?php echo esc_html(get_theme_mod('bodyart_tattoo_designer_btn_servicedescription')); ?>
            </p>
            <h4>
              <?php echo esc_html(get_theme_mod('bodyart_tattoo_designer_btn_serviceheading')); ?>
            </h4>
            
          </div>
        <?php } ?>
        <div class="serbxout">
            <div class="row mr-0">
              <?php 
                  $page_ids = array();

                  $page1 = get_theme_mod('bodyart_tattoo_designer_services_selected_page1');
                  $page2 = get_theme_mod('bodyart_tattoo_designer_services_selected_page2');
                  $page3 = get_theme_mod('bodyart_tattoo_designer_services_selected_page3');
                  $page4 = get_theme_mod('bodyart_tattoo_designer_services_selected_page4');

                  if ($page1) $page_ids[] = absint($page1);
                  if ($page2) $page_ids[] = absint($page2);
                  if ($page3) $page_ids[] = absint($page3);
                  if ($page4) $page_ids[] = absint($page4);

                  if (!empty($page_ids)) {
                      $page_query = new WP_Query(array(
                          'post_type' => 'page',
                          'post__in' => $page_ids,
                          'orderby' => 'post__in', // Maintain selection order
                      ));

                      $count = 1; // Moved outside the loop

                      while ($page_query->have_posts()) : $page_query->the_post();
              ?>
                          <div class="col-lg-12 col-md-12 col-sm-12 serbx">
                              <div class="services-box">
                                  <div class="row">
                                      <div class="single-inbx">
                                          <div class="countbx">
                                              0<?php echo $count; ?>.
                                          </div>
                                          <div class="ser-img">
                                              <?php the_post_thumbnail(); ?>
                                          </div>
                                      </div>
                                      <div class="ser-content">
                                          <a href="<?php the_permalink(); ?>">
                                              <h4><?php the_title(); ?>  <i class="fa-solid fa-arrow-right"></i></h4>
                                          </a>
                                      </div>
                                  </div>
                              </div>
                              <div class="clearfix"></div>
                          </div>
              <?php 
                          $count++; // Increment the counter
                      endwhile;
                      wp_reset_postdata();
                  }
              ?>
            </div>
          </div>

      </div>
      <div class="clearfix"></div>
    </section>

  <?php }?>
  <?php do_action( 'bodyart_tattoo_designer_below_best_sellers' ); ?>

  <!-- <div class="container entry-content py-4">
    <?php while ( have_posts() ) : the_post(); ?>
      <?php the_content(); ?>
    <?php endwhile; // end of the loop. ?>
  </div> -->
</main>
<?php get_footer(); ?>