<?php
/**
 * Blossom Wedding Dynamic Styles
 * 
 * @package Blossom_Wedding
*/

function blossom_wedding_dynamic_css(){
    
    $primary_font    = get_theme_mod( 'primary_font', 'Nunito' );
    $primary_fonts   = blossom_wedding_get_fonts( $primary_font, 'regular' );
    $secondary_font  = get_theme_mod( 'secondary_font', 'Great Vibes' );
    $secondary_fonts = blossom_wedding_get_fonts( $secondary_font, 'regular' );
    $font_size       = get_theme_mod( 'font_size', 18 );
    
    $primary_color    = get_theme_mod( 'primary_color', '#e39696' );
    
    $rgb = blossom_wedding_hex2rgb( blossom_wedding_sanitize_hex_color( $primary_color ) );
     
    $custom_css = '';
    $custom_css .= '
     
    .content-newsletter .blossomthemes-email-newsletter-wrapper.bg-img:after,
    .widget_blossomthemes_email_newsletter_widget .blossomthemes-email-newsletter-wrapper:after{
        ' . 'background: rgba(' . $rgb[0] . ', ' . $rgb[1] . ', ' . $rgb[2] . ', 0.8);' . '
    }
    
    /*Typography*/

    body{
        font-family : ' . wp_kses_post( $primary_fonts['font'] ) . ';
        font-size   : ' . absint( $font_size ) . 'px;        
    }

    button, input, select, optgroup, textarea, blockquote p + span, .site-banner.slider-three .banner-desc, .site-banner.slider-three .banner-item .banner-countdown .countdown-block span, .site-banner.slider-four .banner-item .banner-caption .banner-desc, .moredays-section .moredays-block .moredays-content-wrap .moredays-time .time-type, section.accommodation-section .widget.widget_bttk_icon_text_widget .widget-title {
	    font-family : ' . wp_kses_post( $primary_fonts['font'] ) . ';
	}

	q, blockquote, section[class*="-section"] .widget .widget-title, .section-title, .widget_bttk_testimonial_widget .name, .site-footer .footer-logo, .site-banner .banner-item .banner-caption, .story-section .section-grid-inner article .entry-title, .story-section .story-end .story-end-title, section.countdown-section .countdown-block .countdown-title, .moredays-section .moredays-block .moredays-content-wrap .moredays-time, .officiant-section .man-matron-wrap .officiant-title, .officiant-section .bride-groom-wrap .block-title {
		font-family : ' . wp_kses_post( $secondary_fonts['font'] ) . ';
	}
    
    /*Color Scheme*/
    button, input[type="button"], input[type="reset"], input[type="submit"], .btn-readmore:hover, #back-to-top:hover, .comments-area .comments-title:after, .comment-respond .comment-reply-title:after, .widget-area .widget .widget-title:after, .widget_bttk_author_bio .readmore, .widget_bttk_author_bio .author-socicons li a:hover, .widget_bttk_social_links ul li a:hover, .widget_bttk_custom_categories ul li a:hover .post-count, .widget_bttk_contact_social_links .social-networks li a, .bttk-team-inner-holder ul.social-profile li a:hover, .widget_bttk_posts_category_slider_widget .owl-theme .owl-nav [class*="owl-"]:hover, .widget_bttk_image_text_widget ul li .btn-readmore:hover, .widget_blossomtheme_companion_cta_widget .blossomtheme-cta-container .btn-cta, .widget_blossomtheme_companion_cta_widget .blossomtheme-cta-container .btn-cta + .btn-cta:hover, .tagcloud a:hover, .site-header .container .toggle-btn:hover .toggle-bar, .site-header.header-four .container .toggle-btn:hover .toggle-bar, .site-header.header-five .container .toggle-btn:hover .toggle-bar, .site-header.header-seven .container .toggle-btn:hover .toggle-bar, .site-footer .widget-title span:before, .site-footer .widget_bttk_social_links ul li a:hover, .main-navigation ul li a::after, .rsvp-flag, .pagination .page-numbers.current, .pagination .page-numbers:not(.dots):hover, .posts-navigation .nav-links a:hover, #load-posts a:not(.loading):hover, .author-block .author-content-wrap .author-name:after, .author-block .author-content-wrap .author-social ul li a:hover svg.svg-inline--fa, .additional-post .post-title:after, .site-banner .banner-wrap .owl-dots .owl-dot span, section.cta-section .widget .btn-cta:hover, section.cta-section .widget .btn-cta + .btn-cta, section.gallery-section .button-group button:hover, section.gallery-section .button-group button.is-checked, .blog-section .button-wrap .btn-readmore, .error404 .error-404 .btn-readmore, .single .site-main .article-meta .social-list li a, 
    .site-header.header-four .sticky-header .container .toggle-btn:hover .toggle-bar, .site-header.header-five .sticky-header .container .toggle-btn:hover .toggle-bar, .site-header.header-seven .sticky-header .container .toggle-btn:hover .toggle-bar, 
	.sticky-bar-content.notification-enabled, .sticky-t-bar:not(.active) .close,
	.site-header .container .toggle-btn .toggle-bar {
		background: ' . blossom_wedding_sanitize_hex_color( $primary_color ) . ';
	}

	.comment-respond .comment-form p.comment-form-cookies-consent input[type="checkbox"]:checked + label::before, .widget_blossomthemes_email_newsletter_widget .subscribe-inner-wrap input[type="checkbox"]:checked + .check-mark, section.client-section .owl-nav [class*="owl-"]:hover {
		background-color: ' . blossom_wedding_sanitize_hex_color( $primary_color ) . ';
	}

    a, section[class*="-section"] .widget .widget-title, .section-title, .entry-title a:hover, .entry-meta > span a:hover, #back-to-top, .comment-author a:hover, .comment-metadata a:hover, .comment-body .reply .comment-reply-link:hover, .comment-respond .comment-reply-title a:hover, .widget ul li a:hover, .widget_bttk_popular_post ul li .entry-header .entry-meta > span a:hover, .widget_bttk_pro_recent_post ul li .entry-header .entry-meta > span a:hover, .site-footer .widget_bttk_popular_post ul li .entry-header .entry-meta > span a:hover, .site-footer .widget_bttk_pro_recent_post ul li .entry-header .entry-meta > span a:hover, .widget_bttk_testimonial_widget .name, .widget_blossomthemes_stat_counter_widget .blossomthemes-sc-holder .icon-holder, .widget_bttk_posts_category_slider_widget .carousel-title .cat-links a:hover, .widget_bttk_posts_category_slider_widget .carousel-title .title a:hover, .widget_bttk_icon_text_widget .rtc-itw-inner-holder .icon-holder, .widget_blossomtheme_companion_cta_widget .blossomtheme-cta-container .btn-cta:hover, .widget_blossomtheme_companion_cta_widget .blossomtheme-cta-container .btn-cta + .btn-cta, .site-footer .widget ul li a:hover, .site-footer .widget_bttk_posts_category_slider_widget .carousel-title .title a:hover, .site-footer .footer-b a:hover, .main-navigation ul li:hover > a, .main-navigation ul li.current-menu-item > a, .main-navigation ul li.current_page_item > a, .main-navigation ul li.current-menu-ancestor > a, .main-navigation ul li.current_page_ancestor > a, .main-navigation ul .sub-menu li:hover > a, .main-navigation ul .sub-menu li.current-menu-item > a, .main-navigation ul .sub-menu li.current_page_item > a, .main-navigation ul .sub-menu li.current-menu-ancestor > a, .main-navigation ul .sub-menu li.current_page_ancestor > a, .header-four .main-navigation ul.nav-menu > li:hover > a, .header-four .main-navigation ul.nav-menu > li.current-menu-item > a, .header-four .main-navigation ul.nav-menu > li.current_page_item > a, .header-four .main-navigation ul.nav-menu > li.current-menu-ancestor > a, .header-four .main-navigation ul.nav-menu > li.current_page_ancestor > a, .header-five .main-navigation ul.nav-menu > li:hover > a, .header-five .main-navigation ul.nav-menu > li.current-menu-item > a, .header-five .main-navigation ul.nav-menu > li.current_page_item > a, .header-five .main-navigation ul.nav-menu > li.current-menu-ancestor > a, .header-five .main-navigation ul.nav-menu > li.current_page_ancestor > a, .header-seven .main-navigation ul.nav-menu > li:hover > a, .header-seven .main-navigation ul.nav-menu > li.current-menu-item > a, .header-seven .main-navigation ul.nav-menu > li.current_page_item > a, .header-seven .main-navigation ul.nav-menu > li.current-menu-ancestor > a, .header-seven .main-navigation ul.nav-menu > li.current_page_ancestor > a, .posts-navigation .nav-links a, .post-navigation .nav-links a:hover, .additional-post article .entry-header .entry-meta > span a:hover, .site-banner .banner-item .banner-caption .posted-on a:hover, .story-section .section-grid-inner article:last-child .entry-title, .story-section .story-end, .story-section .story-end .story-end-title, .moredays-section .moredays-block .moredays-content-wrap .moredays-time, .officiant-section .man-matron-wrap .officiant-title, .officiant-section .bride-groom-wrap .block-title, .blog-section article .entry-meta > span a:hover, .blog-section article .btn-readmore, .list-alternate .site-main article .entry-meta > span a:hover, .list-view .site-main article .entry-meta > span a:hover, .list-alternate .site-main article .btn-readmore, .list-view .site-main article .btn-readmore, .classic-view .site-main article .entry-meta > span a:hover, .classic-view .site-main article .btn-readmore, .error404 .error-404 .error-num, .single .site-main .entry-header .byline a:hover, .single .site-main .entry-meta > span.posted-on a:hover, .single .site-main .entry-footer > span.cat-tags a:hover, 
    .site-footer .widget_bttk_popular_post ul li .entry-header .cat-links a:hover, .site-footer .widget_bttk_pro_recent_post ul li .entry-header .cat-links a:hover, .site-footer .widget_bttk_popular_post ul li .entry-header .entry-title a:hover, .site-footer .widget_bttk_pro_recent_post ul li .entry-header .entry-title a:hover, .story-section .section-grid-inner article .entry-title, 
    body.home .header-four .main-navigation ul.nav-menu > li:hover > a, body.home .header-four .main-navigation ul.nav-menu > li.current-menu-item > a, body.home .header-four .main-navigation ul.nav-menu > li.current_page_item > a, body.home .header-four .main-navigation ul.nav-menu > li.current-menu-ancestor > a, body.home .header-four .main-navigation ul.nav-menu > li.current_page_ancestor > a, body.home .header-five .main-navigation ul.nav-menu > li:hover > a, body.home .header-five .main-navigation ul.nav-menu > li.current-menu-item > a, body.home .header-five .main-navigation ul.nav-menu > li.current_page_item > a, body.home .header-five .main-navigation ul.nav-menu > li.current-menu-ancestor > a, body.home .header-five .main-navigation ul.nav-menu > li.current_page_ancestor > a, body.home .header-seven .main-navigation ul.nav-menu > li:hover > a, body.home .header-seven .main-navigation ul.nav-menu > li.current-menu-item > a, body.home .header-seven .main-navigation ul.nav-menu > li.current_page_item > a, body.home .header-seven .main-navigation ul.nav-menu > li.current-menu-ancestor > a, body.home .header-seven .main-navigation ul.nav-menu > li.current_page_ancestor > a, #crumbs a:hover, #crumbs .current a,
	.entry-content a:hover,
	.entry-summary a:hover,
	.page-content a:hover,
	.comment-content a:hover,
	.widget .textwidget a:hover {
	    color: ' . blossom_wedding_sanitize_hex_color( $primary_color ) . ';
	}

	.comment-respond .comment-form p.comment-form-cookies-consent input[type="checkbox"]:checked + label::before, .widget_bttk_social_links ul li a:hover, .widget_blossomthemes_email_newsletter_widget .img-holder, .widget_blossomthemes_email_newsletter_widget .subscribe-inner-wrap input[type="checkbox"]:checked + .check-mark, .widget_bttk_testimonial_widget .bttk-testimonial-inner-holder .img-holder, .widget_bttk_testimonial_widget .bttk-testimonial-inner-holder .img-holder img, .bttk-team-inner-holder ul.social-profile li a:hover, .tagcloud a:hover, .site-footer .widget_bttk_author_bio .author-socicons li a:hover, .site-footer .tagcloud a:hover, .site-footer .bttk-team-inner-holder ul.social-profile li a:hover, .site-footer .widget_bttk_social_links ul li a:hover, .pagination .page-numbers.current, .pagination .page-numbers:not(.dots):hover, .posts-navigation .nav-links a, #load-posts a:not(.loading):hover, .author-block .author-content-wrap .author-social ul li a:hover svg.svg-inline--fa, .moredays-section .moredays-block:before, .officiant-section .officiant-img, .officiant-section .officiant-img img {
		border-color: ' . blossom_wedding_sanitize_hex_color( $primary_color ) . ';
	}

	section[class*="-section"] .widget .widget-title svg .a, svg .a {
		stroke: ' . blossom_wedding_sanitize_hex_color( $primary_color ) . ';
	}

	.post-navigation .nav-links a:hover svg path {
		fill: ' . blossom_wedding_sanitize_hex_color( $primary_color ) . ';
	}

	.rsvp-flag::before, .rsvp-flag::after, .moredays-section .moredays-block .moredays-content-wrap .moredays-time .time-type {
		border-top-color: ' . blossom_wedding_sanitize_hex_color( $primary_color ) . ';
	}

	.moredays-section .moredays-block .moredays-content-wrap .moredays-time .time-type, .single .site-main .entry-footer > span.cat-tags a {
		border-bottom-color: ' . blossom_wedding_sanitize_hex_color( $primary_color ) . ';
	}

    q {
		border-left-color: ' . blossom_wedding_sanitize_hex_color( $primary_color ) . ';
	}

    .comments-area .comments-title, .comment-respond .comment-reply-title, .author-block .author-content-wrap .author-name, .additional-post .post-title, .list-alternate .site-main article, .list-view .site-main article, .classic-view .site-main article {
        ' . 'border-bottom-color: rgba(' . $rgb[0] . ', ' . $rgb[1] . ', ' . $rgb[2] . ', 0.3);' . '
    }

    .widget-area .widget .widget-title {
        ' . 'border-bottom-color: rgba(' . $rgb[0] . ', ' . $rgb[1] . ', ' . $rgb[2] . ', 0.2);' . '
    }

    .archive .page-header {
        ' . 'border-bottom-color: rgba(' . $rgb[0] . ', ' . $rgb[1] . ', ' . $rgb[2] . ', 0.1);' . '
    }

    .officiant-section .bride-groom-wrap .groom-wrap + .bride-wrap {
        ' . 'border-left-color: rgba(' . $rgb[0] . ', ' . $rgb[1] . ', ' . $rgb[2] . ', 0.3);' . '
    }

    .story-section .section-grid:before, .story-section .section-grid-inner:before, .story-section .section-grid-inner:after, section.countdown-section, .moredays-section .section-grid:before, .moredays-section .section-grid-inner:before, .moredays-section .section-grid-inner:after, .officiant-section .bride-groom-wrap:before, .officiant-section .bride-groom-wrap:after {
        ' . 'background: rgba(' . $rgb[0] . ', ' . $rgb[1] . ', ' . $rgb[2] . ', 0.3);' . '
    }

    section.client-section {
        ' . 'background: rgba(' . $rgb[0] . ', ' . $rgb[1] . ', ' . $rgb[2] . ', 0.2);' . '
    }

	@media screen and (max-width: 1024px) {
	
		.main-navigation ul li .submenu-toggle:hover, .main-navigation ul li .submenu-toggle.active, .header-four .main-navigation ul.nav-menu > li:hover > a, .header-four .main-navigation ul.nav-menu > li.current-menu-item > a, .header-four .main-navigation ul.nav-menu > li.current_page_item > a, .header-four .main-navigation ul.nav-menu > li.current-menu-ancestor > a, .header-four .main-navigation ul.nav-menu > li.current_page_ancestor > a, .header-five .main-navigation ul.nav-menu > li:hover > a, .header-five .main-navigation ul.nav-menu > li.current-menu-item > a, .header-five .main-navigation ul.nav-menu > li.current_page_item > a, .header-five .main-navigation ul.nav-menu > li.current-menu-ancestor > a, .header-five .main-navigation ul.nav-menu > li.current_page_ancestor > a, .header-seven .main-navigation ul.nav-menu > li:hover > a, .header-seven .main-navigation ul.nav-menu > li.current-menu-item > a, .header-seven .main-navigation ul.nav-menu > li.current_page_item > a, .header-seven .main-navigation ul.nav-menu > li.current-menu-ancestor > a, .header-seven .main-navigation ul.nav-menu > li.current_page_ancestor > a {
			color: ' . blossom_wedding_sanitize_hex_color( $primary_color ) . ';
		}

	}

	@media screen and (max-width: 767px) {
	
		.btn-primary {
			background: ' . blossom_wedding_sanitize_hex_color( $primary_color ) . ';
		}

		.btn-primary {
			border-color: ' . blossom_wedding_sanitize_hex_color( $primary_color ) . ';
		}

		.btn-primary:hover, .btn-primary:focus {
			color: ' . blossom_wedding_sanitize_hex_color( $primary_color ) . ';
		}

        .story-section .section-grid:before, .moredays-section .section-grid:before {
            ' . 'background: rgba(' . $rgb[0] . ', ' . $rgb[1] . ', ' . $rgb[2] . ', 0.1);' . '
        }

        .blog-section article {
            ' . 'border-bottom-color: rgba(' . $rgb[0] . ', ' . $rgb[1] . ', ' . $rgb[2] . ', 0.3);' . '
        }

	}

	blockquote::before, blockquote::after {
	  background-image: url(' . ' \'data:image/svg+xml; utf-8, <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100"><path fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '" d="M75.6,40.5a20,20,0,1,1-20.1,20,39.989,39.989,0,0,1,40-40A39.31,39.31,0,0,0,75.6,40.5Zm-30.1,20a20,20,0,0,1-40,0h0a39.989,39.989,0,0,1,40-40,39.31,39.31,0,0,0-19.9,20A19.973,19.973,0,0,1,45.5,60.5Z"></path></svg>\'' . ' );
	}

	section.quote-section .widget_media_image .widget-title:before, section.quote-section .widget_media_image .widget-title:after {
        background-image: url(' . ' \'data:image/svg+xml; utf-8, <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100"><path fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '" d="M75.6,40.5a20,20,0,1,1-20.1,20,39.989,39.989,0,0,1,40-40A39.31,39.31,0,0,0,75.6,40.5Zm-30.1,20a20,20,0,0,1-40,0h0a39.989,39.989,0,0,1,40-40,39.31,39.31,0,0,0-19.9,20A19.973,19.973,0,0,1,45.5,60.5Z"></path></svg>\'' . ' );
    }

    .officiant-section .officiant-img:after {
	    background-image: url(' . ' \'data:image/svg+xml; utf-8, <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 86 42"><g transform="translate(-656 -10792.388)"><path fill="%23ffffff" d="M664.613,10794.6c-4.4,3.662-12.847,22.462,0,37.845,15.662-.611,26.674-10.376,27.286-13.673,1.958,5.493,11.379,6.349,14.071,0,0,0,9.789,9.889,27.163,13.673,9.789-14.284,8.32-32.107.612-37.845-10.4,1.831-16.64,3.173-28.387,11.6-3.915-2.563-7.708-3.174-13.459,0C687.127,10802.783,678.073,10795.7,664.613,10794.6Z" transform="translate(-0.003 -0.009)"></path><path fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '" d="M139.971,133.044c-2.03-6.971-5.6-10.135-5.811-10.315a1.634,1.634,0,0,0-1.305-.378c-16.985,2.51-24.252,8.63-27.04,11.972a6.55,6.55,0,0,0-4.967-2.282H95.7a6.551,6.551,0,0,0-4.967,2.282c-2.787-3.341-10.054-9.462-27.039-11.972a1.635,1.635,0,0,0-1.305.378c-.21.18-3.781,3.344-5.811,10.315-1.964,6.115-1.26,16.729,0,20.591,2.03,6.971,5.609,10.125,5.811,10.315a2.016,2.016,0,0,0,1.305.378c16.985-2.51,24.251-8.631,27.039-11.971a6.551,6.551,0,0,0,4.968,2.282h5.144a6.55,6.55,0,0,0,4.967-2.282c2.788,3.341,10.055,9.461,27.04,11.971a1.9,1.9,0,0,0,1.306-.378c.2-.194,3.78-3.344,5.811-10.315A38.89,38.89,0,0,0,139.971,133.044ZM64.038,160.98c-1.447-1.616-5.576-7.15-5.576-17.641S62.6,127.306,64.037,125.7C83.173,128.72,88.464,136.51,89.2,137.764c-.034.27-.057.862-.057.862L77.7,136.033a1.629,1.629,0,1,0-.723,3.176l12.168,2.756v2.747l-12.168,2.756a1.628,1.628,0,0,0,.36,3.217c.12,0,11.808-2.633,11.808-2.633s.023.591.057.861C88.462,150.171,83.17,157.958,64.038,160.98Zm40.107-12.888a3.3,3.3,0,0,1-3.3,3.29H95.7a3.3,3.3,0,0,1-3.3-3.29v-9.506a3.3,3.3,0,0,1,3.3-3.289h5.144a3.3,3.3,0,0,1,3.3,3.289Zm28.37,12.888c-19.136-3.023-24.427-10.813-25.164-12.066.034-.27.058-.861.058-.861s11.688,2.633,11.808,2.633a1.628,1.628,0,0,0,.36-3.217l-12.168-2.756v-2.747l12.169-2.757a1.629,1.629,0,1,0-.723-3.176l-11.446,2.593s-.023-.592-.058-.862c.738-1.256,6.031-9.044,25.163-12.066,1.447,1.616,5.576,7.149,5.576,17.641S133.955,159.372,132.515,160.98Z" transform="translate(600.643 10670.055)"></path></g></svg>\'' . ' );
	}

	.officiant-section .matron-block .officiant-img:after {
	    background-image: url(' . ' \'data:image/svg+xml; utf-8, <svg xmlns="http://www.w3.org/2000/svg" viewBox="-2 0 95 42"><path fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '" d="M84.114,35.77c2.256.873,4.8-1.82,5.677-3.712a7.611,7.611,0,0,0-.437-7.57,5.467,5.467,0,0,0-4.513-2.4,9.176,9.176,0,0,0-4.949,1.674A5,5,0,0,0,75.38,17.21a5.343,5.343,0,0,0-4.731,2.329c.728-1.019-1.165-3.639-1.747-4.367a5.451,5.451,0,0,0-4.222-2.329,7.365,7.365,0,0,0-4.731,1.674C64.607,10.877,62.278,2.652,57.256.469A10.1,10.1,0,0,0,50.7.323a14.923,14.923,0,0,0-2.984,1.165c-.437.218-2.475,1.383-2.475,1.82,0-.437-2.038-1.6-2.475-1.82A11.546,11.546,0,0,0,39.787.323a10.6,10.6,0,0,0-6.551.146c-4.949,2.184-7.351,10.408-2.693,14.048a7.663,7.663,0,0,0-4.731-1.674,5.451,5.451,0,0,0-4.222,2.329c-.582.728-2.475,3.348-1.747,4.367a5.343,5.343,0,0,0-4.731-2.329,4.994,4.994,0,0,0-4.731,4.44A6.951,6.951,0,0,0,10.6,23.76,8.79,8.79,0,0,0,5.65,22.086a5.372,5.372,0,0,0-4.513,2.4A7.6,7.6,0,0,0,.7,32.058c.873,1.82,3.421,4.586,5.677,3.712-2.766,1.165-6.2,4.932-5.1,5.913s1.088-2.691,6.041-2.259c.8-1.092,2.038-1.2,3.275-1.785,10.845-4.877,22.709-6.6,34.646-6.746,11.937.218,24.238,1.869,35.083,6.746,1.237.582,2.1,2.169,5.75,2.705C85.816,38.381,86.953,36.935,84.114,35.77Zm3.421-11.064a5.869,5.869,0,0,1,1.674,4,3.928,3.928,0,0,1-.728,2.548,6.434,6.434,0,0,0-3.13-4.8,7.465,7.465,0,0,0-2.766-1.019,11.315,11.315,0,0,0-2.256.073C82,23.542,85.57,22.741,87.535,24.707Zm-13.1-5.75a4,4,0,0,1,3.348,1.456c.073.073.073.146.146.218a3.8,3.8,0,0,1,.509,1.529c0,.291-.364,1.82-.291,1.965a7.506,7.506,0,0,0-3.712-2.4c-1.456-.437-2.62-.146-4.076-.146A4.642,4.642,0,0,1,74.433,18.956Zm-8.152-3.785a5.16,5.16,0,0,1,3.057,4,4.425,4.425,0,0,1,.073,1.383c0,.218-.364,1.019-.291,1.165a10.452,10.452,0,0,0-5.1-4.949,6.233,6.233,0,0,0-4.44-.146A6.941,6.941,0,0,1,66.281,15.172ZM55.873,1.488c3.785.946,6.769,6.915,3.712,9.9.291-.291-.51-2.329-.655-2.62A8.759,8.759,0,0,0,57.4,6.292a8.363,8.363,0,0,0-5.1-2.839,9.923,9.923,0,0,0-3.275.146c-.655.146-2.4.437-2.839.946A10.24,10.24,0,0,1,55.873,1.488ZM45.246,16.336a3.874,3.874,0,0,0-2.111-.873,3.823,3.823,0,0,0-3.858,2.256,5.037,5.037,0,0,0,.51,4.949c0,.073.073.073.073.146-3.421-2.111-6.332-4.731-6.405-9.462.073-3.567,2.111-6.842,5.823-7.133a5.669,5.669,0,0,1,3.275.655c.873.51,1.456,1.237,1.092,2.256-.291.873-1.165,1.82-2.111,1.674a1.631,1.631,0,0,0-1.019-2.038,1.908,1.908,0,0,0-2.184.873,2.221,2.221,0,0,0,.218,2.4,2.961,2.961,0,0,0,1.82,1.092,5.761,5.761,0,0,0,5.022-1.383,5.761,5.761,0,0,0,5.022,1.383,2.961,2.961,0,0,0,1.82-1.092,2.377,2.377,0,0,0,.218-2.4,1.908,1.908,0,0,0-2.184-.873A1.663,1.663,0,0,0,49.249,10.8c-1.019.218-1.892-.8-2.111-1.674A1.887,1.887,0,0,1,48.23,6.874a5.15,5.15,0,0,1,3.275-.655c3.712.291,5.75,3.567,5.677,6.987-.073,4.731-2.984,7.351-6.405,9.462,0-.073.073-.073.073-.146a4.7,4.7,0,0,0,.51-4.949A3.928,3.928,0,0,0,47.5,15.317a4.6,4.6,0,0,0-2.256,1.019M34.692,1.488A10.056,10.056,0,0,1,44.3,4.545c-.437-.51-2.184-.8-2.839-.946a8.294,8.294,0,0,0-3.275-.146,8.737,8.737,0,0,0-5.1,2.839,9.437,9.437,0,0,0-1.529,2.475c-.146.364-.946,2.329-.655,2.62C27.923,8.4,30.907,2.434,34.692,1.488ZM21.226,19.248a5.16,5.16,0,0,1,3.057-4,6.767,6.767,0,0,1,6.7,1.456,7.116,7.116,0,0,0-4.44.146,10.777,10.777,0,0,0-5.1,4.949c.073-.146-.291-.946-.291-1.165A4.307,4.307,0,0,1,21.226,19.248Zm-8.589,1.31c.073-.073.073-.146.146-.218a4.118,4.118,0,0,1,3.348-1.456,4.538,4.538,0,0,1,4.076,2.548,19.279,19.279,0,0,0-4.076.146,7.505,7.505,0,0,0-3.712,2.4c.146-.146-.291-1.674-.291-1.965A4.369,4.369,0,0,1,12.638,20.558ZM2.011,31.257a4.064,4.064,0,0,1-.728-2.548,6.221,6.221,0,0,1,1.674-4c1.965-1.892,5.532-1.165,7.133.873a11.315,11.315,0,0,0-2.256-.073,7.465,7.465,0,0,0-2.766,1.019A6.289,6.289,0,0,0,2.011,31.257Zm8.3,2.329a2.382,2.382,0,0,0,.728-1.965,2.56,2.56,0,0,0-2.184-2.4c-.655-.146-1.892.437-1.529,1.237a2.114,2.114,0,0,0,.8.8,2.114,2.114,0,0,1,.8.8c.218.582-.291,1.31-.873,1.6A2.281,2.281,0,0,1,5.8,33.441a2.747,2.747,0,0,1-1.237-1.965c-.218-1.6,1.6-2.911,2.911-3.421s2.548-.146,3.93-.291h.146a2.313,2.313,0,0,0,.218.655A4.7,4.7,0,0,0,15.622,31.4,51.4,51.4,0,0,0,10.308,33.587ZM23.7,29.219a8.733,8.733,0,0,1-1.456.218c-1.092.291-2.256.51-3.348.873a1.713,1.713,0,0,1-.582.146c1.092-1.092,1.529-3.057.146-4.149a1.218,1.218,0,0,0-1.092-.291c-.073,0-.146.073-.218.073-.291.146-.655.437-.582.8.073.946,1.31,2.329-.873,2.184a2.327,2.327,0,0,1-1.747-3.421c1.456-2.548,4.44-1.892,6.842-1.747-.437.073,1.019,2.62,1.237,2.839.728.873,1.237,1.82,2.475,2.184A4.8,4.8,0,0,1,23.7,29.219Zm6.624-1.31c1.019-.146,1.165-2.111,1.019-2.766-.218-1.165-.873-2.911-2.111-3.348-.8-.291-2.62.073-2.839,1.019a.9.9,0,0,0,.291,1.019c.364.364.946.364,1.383.728,1.237,1.019-.437,2.329-1.529,2.329a3.028,3.028,0,0,1-2.548-1.456c-1.965-3.421,2.475-5.968,5.168-6.405s3.858,1.6,5.459,3.275A16.727,16.727,0,0,0,37.6,24.852c.655.51,2.4,1.82,3.2,1.82A98.163,98.163,0,0,0,30.325,27.909ZM48.3,21.577c-.946,1.383-2.111,2.62-2.984,4h0c-.873-1.456-2.111-2.62-2.984-4-.582-.873-1.237-1.965-.582-3.057a1.4,1.4,0,0,1,1.747-.582c.873.218,1.31.873,1.892,1.529.51-1.237,2.62-2.4,3.567-.946C49.54,19.539,48.885,20.631,48.3,21.577Zm14.266,2.984c.437-.291,1.019-.364,1.383-.728a1.081,1.081,0,0,0,.291-1.019c-.291-.946-2.038-1.31-2.839-1.019-1.237.437-1.892,2.184-2.111,3.348-.146.728,0,2.62,1.019,2.766-3.494-.582-6.915-.946-10.408-1.237.873.073,2.548-1.31,3.2-1.82A19.741,19.741,0,0,0,56.091,22.3c1.6-1.747,2.766-3.712,5.459-3.275,2.766.437,7.206,3.057,5.168,6.405A3.028,3.028,0,0,1,64.17,26.89C63.006,26.89,61.332,25.58,62.569,24.561ZM74,26.89a.966.966,0,0,0-.582-.8c-.073,0-.146-.073-.218-.073a1.218,1.218,0,0,0-1.092.291c-1.383,1.092-.946,3.057.146,4.149a2.25,2.25,0,0,0-.582-.146c-1.092-.291-2.256-.582-3.348-.873a10.047,10.047,0,0,1-1.456-.218s-.873-.291-.728-.291a5.139,5.139,0,0,0,2.475-2.184c.146-.218,1.674-2.839,1.165-2.766,2.4-.146,5.386-.873,6.842,1.747a2.327,2.327,0,0,1-1.747,3.421C72.614,29.292,73.851,27.909,74,26.89Zm8.443,6.769a1.428,1.428,0,0,1-.873-1.6,1.707,1.707,0,0,1,.8-.8,2.114,2.114,0,0,0,.8-.8c.364-.873-.873-1.383-1.529-1.237a2.7,2.7,0,0,0-2.184,2.4,2.382,2.382,0,0,0,.728,1.965c-1.82-.873-3.639-1.6-5.168-2.184a4.8,4.8,0,0,0,3.858-2.984l.218-.655h.146c1.31.146,2.62-.146,3.93.291s3.13,1.747,2.911,3.421a2.993,2.993,0,0,1-1.237,1.965A2.563,2.563,0,0,1,82.44,33.659Z"/></svg>\'' . ' ); 
	}

  	.search .page-header .search-form .search-submit:hover {
        background-image: url(' . ' \'data:image/svg+xml; utf-8, <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '" d="M508.5 468.9L387.1 347.5c-2.3-2.3-5.3-3.5-8.5-3.5h-13.2c31.5-36.5 50.6-84 50.6-136C416 93.1 322.9 0 208 0S0 93.1 0 208s93.1 208 208 208c52 0 99.5-19.1 136-50.6v13.2c0 3.2 1.3 6.2 3.5 8.5l121.4 121.4c4.7 4.7 12.3 4.7 17 0l22.6-22.6c4.7-4.7 4.7-12.3 0-17zM208 368c-88.4 0-160-71.6-160-160S119.6 48 208 48s160 71.6 160 160-71.6 160-160 160z"></path></svg>\'' . ' ); 
    }

    .classic-view .site-main article .entry-title:after, .single .site-main .entry-header:after {
      background-image: url(' . ' \'data:image/svg+xml; utf-8, <svg xmlns="http://www.w3.org/2000/svg" viewBox="-2 0 86 12"><g transform="translate(-8.2 -9.1)"><path fill="none" stroke="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '" stroke-width="2px" d="M49.2,15.1,14.929,20m0,0c-.3,0-.6.1-.8.1a5,5,0,1,1,4.925-5" transform="translate(0 0)"/><g transform="translate(49.2 10.1)"><path fill="none" stroke="<?php echo blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ); ?>" stroke-width="2px" d="M49,15.1l34.271-4.9m0,0c.3,0,.6-.1.8-.1a5,5,0,1,1-4.925,5" transform="translate(-49 -10.1)"/></g></g></svg>\'' . ' );
    }

    .officiant-section .bride-groom-wrap .bride-wrap .officiant-img::after {
        background-image: url(' . ' \'data:image/svg+xml; utf-8, <svg xmlns="http://www.w3.org/2000/svg" viewBox="-2 0 95 42"><path fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '" d="M84.114,35.77c2.256.873,4.8-1.82,5.677-3.712a7.611,7.611,0,0,0-.437-7.57,5.467,5.467,0,0,0-4.513-2.4,9.176,9.176,0,0,0-4.949,1.674A5,5,0,0,0,75.38,17.21a5.343,5.343,0,0,0-4.731,2.329c.728-1.019-1.165-3.639-1.747-4.367a5.451,5.451,0,0,0-4.222-2.329,7.365,7.365,0,0,0-4.731,1.674C64.607,10.877,62.278,2.652,57.256.469A10.1,10.1,0,0,0,50.7.323a14.923,14.923,0,0,0-2.984,1.165c-.437.218-2.475,1.383-2.475,1.82,0-.437-2.038-1.6-2.475-1.82A11.546,11.546,0,0,0,39.787.323a10.6,10.6,0,0,0-6.551.146c-4.949,2.184-7.351,10.408-2.693,14.048a7.663,7.663,0,0,0-4.731-1.674,5.451,5.451,0,0,0-4.222,2.329c-.582.728-2.475,3.348-1.747,4.367a5.343,5.343,0,0,0-4.731-2.329,4.994,4.994,0,0,0-4.731,4.44A6.951,6.951,0,0,0,10.6,23.76,8.79,8.79,0,0,0,5.65,22.086a5.372,5.372,0,0,0-4.513,2.4A7.6,7.6,0,0,0,.7,32.058c.873,1.82,3.421,4.586,5.677,3.712-2.766,1.165-6.2,4.932-5.1,5.913s1.088-2.691,6.041-2.259c.8-1.092,2.038-1.2,3.275-1.785,10.845-4.877,22.709-6.6,34.646-6.746,11.937.218,24.238,1.869,35.083,6.746,1.237.582,2.1,2.169,5.75,2.705C85.816,38.381,86.953,36.935,84.114,35.77Zm3.421-11.064a5.869,5.869,0,0,1,1.674,4,3.928,3.928,0,0,1-.728,2.548,6.434,6.434,0,0,0-3.13-4.8,7.465,7.465,0,0,0-2.766-1.019,11.315,11.315,0,0,0-2.256.073C82,23.542,85.57,22.741,87.535,24.707Zm-13.1-5.75a4,4,0,0,1,3.348,1.456c.073.073.073.146.146.218a3.8,3.8,0,0,1,.509,1.529c0,.291-.364,1.82-.291,1.965a7.506,7.506,0,0,0-3.712-2.4c-1.456-.437-2.62-.146-4.076-.146A4.642,4.642,0,0,1,74.433,18.956Zm-8.152-3.785a5.16,5.16,0,0,1,3.057,4,4.425,4.425,0,0,1,.073,1.383c0,.218-.364,1.019-.291,1.165a10.452,10.452,0,0,0-5.1-4.949,6.233,6.233,0,0,0-4.44-.146A6.941,6.941,0,0,1,66.281,15.172ZM55.873,1.488c3.785.946,6.769,6.915,3.712,9.9.291-.291-.51-2.329-.655-2.62A8.759,8.759,0,0,0,57.4,6.292a8.363,8.363,0,0,0-5.1-2.839,9.923,9.923,0,0,0-3.275.146c-.655.146-2.4.437-2.839.946A10.24,10.24,0,0,1,55.873,1.488ZM45.246,16.336a3.874,3.874,0,0,0-2.111-.873,3.823,3.823,0,0,0-3.858,2.256,5.037,5.037,0,0,0,.51,4.949c0,.073.073.073.073.146-3.421-2.111-6.332-4.731-6.405-9.462.073-3.567,2.111-6.842,5.823-7.133a5.669,5.669,0,0,1,3.275.655c.873.51,1.456,1.237,1.092,2.256-.291.873-1.165,1.82-2.111,1.674a1.631,1.631,0,0,0-1.019-2.038,1.908,1.908,0,0,0-2.184.873,2.221,2.221,0,0,0,.218,2.4,2.961,2.961,0,0,0,1.82,1.092,5.761,5.761,0,0,0,5.022-1.383,5.761,5.761,0,0,0,5.022,1.383,2.961,2.961,0,0,0,1.82-1.092,2.377,2.377,0,0,0,.218-2.4,1.908,1.908,0,0,0-2.184-.873A1.663,1.663,0,0,0,49.249,10.8c-1.019.218-1.892-.8-2.111-1.674A1.887,1.887,0,0,1,48.23,6.874a5.15,5.15,0,0,1,3.275-.655c3.712.291,5.75,3.567,5.677,6.987-.073,4.731-2.984,7.351-6.405,9.462,0-.073.073-.073.073-.146a4.7,4.7,0,0,0,.51-4.949A3.928,3.928,0,0,0,47.5,15.317a4.6,4.6,0,0,0-2.256,1.019M34.692,1.488A10.056,10.056,0,0,1,44.3,4.545c-.437-.51-2.184-.8-2.839-.946a8.294,8.294,0,0,0-3.275-.146,8.737,8.737,0,0,0-5.1,2.839,9.437,9.437,0,0,0-1.529,2.475c-.146.364-.946,2.329-.655,2.62C27.923,8.4,30.907,2.434,34.692,1.488ZM21.226,19.248a5.16,5.16,0,0,1,3.057-4,6.767,6.767,0,0,1,6.7,1.456,7.116,7.116,0,0,0-4.44.146,10.777,10.777,0,0,0-5.1,4.949c.073-.146-.291-.946-.291-1.165A4.307,4.307,0,0,1,21.226,19.248Zm-8.589,1.31c.073-.073.073-.146.146-.218a4.118,4.118,0,0,1,3.348-1.456,4.538,4.538,0,0,1,4.076,2.548,19.279,19.279,0,0,0-4.076.146,7.505,7.505,0,0,0-3.712,2.4c.146-.146-.291-1.674-.291-1.965A4.369,4.369,0,0,1,12.638,20.558ZM2.011,31.257a4.064,4.064,0,0,1-.728-2.548,6.221,6.221,0,0,1,1.674-4c1.965-1.892,5.532-1.165,7.133.873a11.315,11.315,0,0,0-2.256-.073,7.465,7.465,0,0,0-2.766,1.019A6.289,6.289,0,0,0,2.011,31.257Zm8.3,2.329a2.382,2.382,0,0,0,.728-1.965,2.56,2.56,0,0,0-2.184-2.4c-.655-.146-1.892.437-1.529,1.237a2.114,2.114,0,0,0,.8.8,2.114,2.114,0,0,1,.8.8c.218.582-.291,1.31-.873,1.6A2.281,2.281,0,0,1,5.8,33.441a2.747,2.747,0,0,1-1.237-1.965c-.218-1.6,1.6-2.911,2.911-3.421s2.548-.146,3.93-.291h.146a2.313,2.313,0,0,0,.218.655A4.7,4.7,0,0,0,15.622,31.4,51.4,51.4,0,0,0,10.308,33.587ZM23.7,29.219a8.733,8.733,0,0,1-1.456.218c-1.092.291-2.256.51-3.348.873a1.713,1.713,0,0,1-.582.146c1.092-1.092,1.529-3.057.146-4.149a1.218,1.218,0,0,0-1.092-.291c-.073,0-.146.073-.218.073-.291.146-.655.437-.582.8.073.946,1.31,2.329-.873,2.184a2.327,2.327,0,0,1-1.747-3.421c1.456-2.548,4.44-1.892,6.842-1.747-.437.073,1.019,2.62,1.237,2.839.728.873,1.237,1.82,2.475,2.184A4.8,4.8,0,0,1,23.7,29.219Zm6.624-1.31c1.019-.146,1.165-2.111,1.019-2.766-.218-1.165-.873-2.911-2.111-3.348-.8-.291-2.62.073-2.839,1.019a.9.9,0,0,0,.291,1.019c.364.364.946.364,1.383.728,1.237,1.019-.437,2.329-1.529,2.329a3.028,3.028,0,0,1-2.548-1.456c-1.965-3.421,2.475-5.968,5.168-6.405s3.858,1.6,5.459,3.275A16.727,16.727,0,0,0,37.6,24.852c.655.51,2.4,1.82,3.2,1.82A98.163,98.163,0,0,0,30.325,27.909ZM48.3,21.577c-.946,1.383-2.111,2.62-2.984,4h0c-.873-1.456-2.111-2.62-2.984-4-.582-.873-1.237-1.965-.582-3.057a1.4,1.4,0,0,1,1.747-.582c.873.218,1.31.873,1.892,1.529.51-1.237,2.62-2.4,3.567-.946C49.54,19.539,48.885,20.631,48.3,21.577Zm14.266,2.984c.437-.291,1.019-.364,1.383-.728a1.081,1.081,0,0,0,.291-1.019c-.291-.946-2.038-1.31-2.839-1.019-1.237.437-1.892,2.184-2.111,3.348-.146.728,0,2.62,1.019,2.766-3.494-.582-6.915-.946-10.408-1.237.873.073,2.548-1.31,3.2-1.82A19.741,19.741,0,0,0,56.091,22.3c1.6-1.747,2.766-3.712,5.459-3.275,2.766.437,7.206,3.057,5.168,6.405A3.028,3.028,0,0,1,64.17,26.89C63.006,26.89,61.332,25.58,62.569,24.561ZM74,26.89a.966.966,0,0,0-.582-.8c-.073,0-.146-.073-.218-.073a1.218,1.218,0,0,0-1.092.291c-1.383,1.092-.946,3.057.146,4.149a2.25,2.25,0,0,0-.582-.146c-1.092-.291-2.256-.582-3.348-.873a10.047,10.047,0,0,1-1.456-.218s-.873-.291-.728-.291a5.139,5.139,0,0,0,2.475-2.184c.146-.218,1.674-2.839,1.165-2.766,2.4-.146,5.386-.873,6.842,1.747a2.327,2.327,0,0,1-1.747,3.421C72.614,29.292,73.851,27.909,74,26.89Zm8.443,6.769a1.428,1.428,0,0,1-.873-1.6,1.707,1.707,0,0,1,.8-.8,2.114,2.114,0,0,0,.8-.8c.364-.873-.873-1.383-1.529-1.237a2.7,2.7,0,0,0-2.184,2.4,2.382,2.382,0,0,0,.728,1.965c-1.82-.873-3.639-1.6-5.168-2.184a4.8,4.8,0,0,0,3.858-2.984l.218-.655h.146c1.31.146,2.62-.146,3.93.291s3.13,1.747,2.911,3.421a2.993,2.993,0,0,1-1.237,1.965A2.563,2.563,0,0,1,82.44,33.659Z"/></svg>\'' . ' );
    }

    section.invitation-section .widget:before {
        background-image: url(' . ' \'data:image/svg+xml; utf-8, <svg xmlns="http://www.w3.org/2000/svg" width="225.863" height="312.553" viewBox="0 0 225.863 312.553"><g transform="translate(0.003 0.04)" opacity="0.2"><path d="M0,0V.224A6.359,6.359,0,0,0,1.537,0Z" transform="translate(-0.003 -0.035)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M11.763,10.895a26.528,26.528,0,0,0,7.774-8.859A11.057,11.057,0,0,0,20.478,0H18.721a19.383,19.383,0,0,1-1.7,3.233,28.762,28.762,0,0,1-2.065,2.784c-.664.781-1.44,1.459-2.157,2.19a29.353,29.353,0,0,1-3.031,2.439,31.533,31.533,0,0,1-6.554,3.621A27.933,27.933,0,0,1,0,15.346v1.189a13.065,13.065,0,0,0,2.76-.812,32.722,32.722,0,0,0,9-4.827Z" transform="translate(-0.003 -0.035)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M137.81,9.828a15.4,15.4,0,0,0,3.566.088,20.182,20.182,0,0,0,5.934-1.764,26.455,26.455,0,0,0,4.571-2.835c.67-.531,1.272-1.147,1.972-1.642.355-.262.725-.5,1.1-.739A6.49,6.49,0,0,0,157.2,0h-8.156a15.423,15.423,0,0,1-2.086,3.756,18.939,18.939,0,0,1-2.984,3.071A10.786,10.786,0,0,1,141.6,8.4a15.924,15.924,0,0,1-1.96.9c-.588.249-1.226.332-1.831.534Z" transform="translate(-120.671 -0.035)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M343.684,2.815a5.039,5.039,0,0,0,2.494.208c.382-.155.767-.3,1.146-.468.007-.065.024-.194.032-.259a6.968,6.968,0,0,1-3.51-1.158,23.1,23.1,0,0,0,2.333.586,2.286,2.286,0,0,0,.928-.007,13.273,13.273,0,0,1,2.513.078A16.632,16.632,0,0,0,358,0h-1.467a16.405,16.405,0,0,1-8.417,1.315,2.293,2.293,0,0,1-.5-.1c-.432-.391-.843-.8-1.254-1.214h-6.31c.3.249.59.5.886.753a11.483,11.483,0,0,0,2.748,2.062Z" transform="translate(-297.756 -0.035)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M567.079,4.349c.3-.529.5-1.115.81-1.639a5.046,5.046,0,0,0,.7-2.709H565.2a12.508,12.508,0,0,0,1.214,2.615A9.028,9.028,0,0,1,567.079,4.349Z" transform="translate(-494.9 -0.035)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M656.142,2.442c-.187-.049-.373-.1-.556-.154a4.107,4.107,0,0,0-1.066,1.328c.26.433.547.848.848,1.255a1.922,1.922,0,0,0,1.547-.355,6.13,6.13,0,0,0,.715-.566,2.069,2.069,0,0,0-.866-.174c0-.024,0-.071,0-.095q.42-.045.843-.1c-.039-.142-.075-.285-.111-.427l.4.055a4.485,4.485,0,0,1-.086-.981c.148.34.277.687.417,1.03a2.6,2.6,0,0,0,.494-.893,5.134,5.134,0,0,0,.174-1.258C658.78.5,658.05.5,657.6.3L657.253.3a2.421,2.421,0,0,0-.953,1.662A21.3,21.3,0,0,1,654.516,0h-.667c.673.9,1.585,1.58,2.292,2.442Z" transform="translate(-572.523 -0.035)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M1032.981.256c.021-.065.063-.193.083-.256h-.654c.016.107.05.322.066.429A.6.6,0,0,0,1032.981.256Z" transform="translate(-903.995 -0.035)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M1208.81,0h-1.945a24.956,24.956,0,0,1-4.23,4.117,31.817,31.817,0,0,1-7.2,4.291,30.074,30.074,0,0,1-5.554,1.8,17.388,17.388,0,0,1-1.967.358l-.121.021a37.916,37.916,0,0,1-14.9-.716c-.531-.126-1.055-.275-1.585-.392l-.081-.055a49.892,49.892,0,0,1-8.4-3.1,55.291,55.291,0,0,1-7.843-4.511A24.66,24.66,0,0,1,1152.566,0h-.506c.455.374.919.739,1.381,1.106a56.785,56.785,0,0,0,8.316,5.3c1.332.674,2.679,1.323,4.063,1.887,1.417.587,2.855,1.129,4.316,1.6a47.155,47.155,0,0,0,5.381,1.386,17.187,17.187,0,0,1,2.041.277q1.916.257,3.85.372a28.1,28.1,0,0,0,5.214-.148c.861-.026,1.7-.269,2.56-.269a40.044,40.044,0,0,0,4.257-1.036,39.567,39.567,0,0,0,4.352-1.739c.756-.376,1.493-.791,2.238-1.189A29.679,29.679,0,0,0,1208.81,0Z" transform="translate(-1008.762 -0.035)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M1185.294,1.837A14.947,14.947,0,0,0,1191.426,0h-1.27a15.963,15.963,0,0,1-5.976,1.432A20.525,20.525,0,0,1,1176.028,0h-.779a21.472,21.472,0,0,0,7.435,1.857A12.122,12.122,0,0,0,1185.294,1.837Z" transform="translate(-1029.068 -0.035)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M1322.725,9.1A11.4,11.4,0,0,0,1329.908.95a5.816,5.816,0,0,0,.106-.95h-8.047a4.324,4.324,0,0,0,1.96,2.026,3.724,3.724,0,0,1,.252,1.7,5.564,5.564,0,0,1-2.9,4.648,7.442,7.442,0,0,1-1.874.642,7.449,7.449,0,0,1-.777.175c-.4.106-.8-.136-1.2,0a8.978,8.978,0,0,0,5.3-.093Z" transform="translate(-1153.562 -0.035)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M1608.809,4.408a18.8,18.8,0,0,0,5.829-.78A26,26,0,0,0,1621.546,0h-6.229a14.737,14.737,0,0,1-7.487,4.227c.322.073.648.133.979.182Z" transform="translate(-1407.841 -0.035)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M1685.8,5.021a8.985,8.985,0,0,0,3.378,1.005,16.6,16.6,0,0,0,4.475-.216,18.079,18.079,0,0,0,3.089-.906,7.283,7.283,0,0,1,1.541-.531,3.934,3.934,0,0,0,2.431-1.7A3.071,3.071,0,0,0,1700.887,0h-4.906a10.672,10.672,0,0,1-5.928,4.539A10.591,10.591,0,0,1,1685.8,5.021Z" transform="translate(-1476.112 -0.035)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M691.58,12.833a6.926,6.926,0,0,1-.868.614l.355.239-.271.2a2,2,0,0,1,.516.775c-.311-.155-.535-.637-.914-.53a3.918,3.918,0,0,0,.427,1.652,4.527,4.527,0,0,0,.368.585,4.863,4.863,0,0,0,1.684-.291,4.146,4.146,0,0,0,.1-1.651c-.2-.442-.786-.331-1.077-.652.454-.063,1.066.066,1.352-.4a4.263,4.263,0,0,0,.168-1.5l-.451-.245a3.2,3.2,0,0,0-1.153-.418,3.885,3.885,0,0,0-.828.924,2.387,2.387,0,0,0-.394,1.009,7.07,7.07,0,0,1,.99-.32Z" transform="translate(-604.52 -9.859)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M685.944,28.2a.327.327,0,0,0,0-.6c-.21-.215-.413.116-.558.238C685.51,28.025,685.661,28.442,685.944,28.2Z" transform="translate(-600.14 -24.14)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M222.021,37.628a10.87,10.87,0,0,1-4.238,1.379,6.54,6.54,0,0,1-1.575.012c-.2.019-.393.041-.588.067a15.33,15.33,0,0,0,1.857.633,9.834,9.834,0,0,0,2.214.362q1.088.026,2.177-.017a14.284,14.284,0,0,0,2.345-.392,34.862,34.862,0,0,0,3.648-1.22,3.887,3.887,0,0,0,3.162-2.81,3.043,3.043,0,0,0-.656-2.2,2.847,2.847,0,0,0-2.775-.893,2.622,2.622,0,0,0-1.571,1.136,7.624,7.624,0,0,1-1.093,1.653,10.861,10.861,0,0,1-2.907,2.294Z" transform="translate(-188.803 -28.467)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M671.444,36.14c.259.355.547.687.831,1.022a2.486,2.486,0,0,0,1.749-.792,4.987,4.987,0,0,0-.486-1.985c-.312.128-.337.581-.52.846a7.842,7.842,0,0,1,.155-1.1,4.888,4.888,0,0,0-.67.31c-.442.479-1.3.928-1.059,1.7Z" transform="translate(-587.891 -29.92)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M343.361,35.857a4.422,4.422,0,0,0-1.167-.045,18.32,18.32,0,0,1-2.638.057c-.322,1.055-.818,2.045-1.187,3.084A2.584,2.584,0,0,0,338.5,40.9a5.91,5.91,0,0,0,2.36,1.654,8.256,8.256,0,0,0,1.723.852,4.042,4.042,0,0,0,1.352.065c-.428-1.032-.955-2.021-1.437-3.029.756.8,1.4,1.7,2.1,2.55l.291-.012c.1-.189.21-.377.3-.575a14.879,14.879,0,0,0-.3-4.908,2.022,2.022,0,0,0-1.531-1.638Z" transform="translate(-296.174 -31.373)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M401.036,48.76a9.1,9.1,0,0,0,2.727-1.529,2.169,2.169,0,0,0,.265-2.147,22.548,22.548,0,0,1-.884-2.809c-1.055-.085-2.1-.244-3.158-.308a2.482,2.482,0,0,0-1.917.557,4.506,4.506,0,0,0-.928,2.455,9.136,9.136,0,0,0-.41,2.712c.075.248.157.494.236.741a.988.988,0,0,0,.458-.2c.685-.628,1.391-1.236,2.064-1.878-.471,1.054-1.379,1.857-1.858,2.9,1.152.4,2.326-.131,3.407-.5Z" transform="translate(-347.378 -36.778)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M1553.063,46.85a10.777,10.777,0,0,1,5.141,2.427l.769.714a8.118,8.118,0,0,1,2.271,6.856,6.01,6.01,0,0,1-3.574,4.584,4.182,4.182,0,0,1-1.865.353,4.968,4.968,0,0,1-4.615-2.792,4.218,4.218,0,0,1-.29-2.275,3.773,3.773,0,0,1,2.784-3.12,3.073,3.073,0,0,1,3.521,1.933,2.64,2.64,0,0,1-.352,2.116,2.1,2.1,0,0,1-1.677.9,1.824,1.824,0,0,1-1.692-1.1,1.408,1.408,0,0,1,1.3-1.954c-.393.29-.82.683-.675,1.23a1.051,1.051,0,0,0,1.922.362,1.433,1.433,0,0,0-.356-1.715,1.606,1.606,0,0,0-.989-.373,1.936,1.936,0,0,0-1.908,2.218,2.517,2.517,0,0,0,3.254,1.924,3.454,3.454,0,0,0,1.748-1.547,3.17,3.17,0,0,0-.112-2.843,4.048,4.048,0,0,0-1.692-1.611,4.112,4.112,0,0,0-2.547-.261,5.924,5.924,0,0,0-1.705.863,4.873,4.873,0,0,0-1.277,5.331,5.722,5.722,0,0,0,1.638,2.147,5.934,5.934,0,0,0,4.278,1.245,6.028,6.028,0,0,0,3.312-1.591,6.874,6.874,0,0,0,1.378-1.771,7.472,7.472,0,0,0,.588-5.253,6.769,6.769,0,0,0-.738-1.85,10.9,10.9,0,0,0-1.633-2.285c-.31-.317-.629-.624-.963-.914a11.47,11.47,0,0,0-4.769-2.176,16.23,16.23,0,0,0-8.33.546,11.068,11.068,0,0,0-1.729.724,1.289,1.289,0,0,0-.479.354l.055-.055a7.572,7.572,0,0,1,1.433-.614,16.7,16.7,0,0,1,8.575-.723Z" transform="translate(-1351.075 -40.582)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M951.079,60.248a1.621,1.621,0,0,0,.74.312c-.08-.27-.16-.539-.239-.809.175.228.343.461.516.694l.189-.238c.041-.474.006-.952.009-1.427a.976.976,0,0,0-.551-.376q-.411,0-.817-.036a2.016,2.016,0,0,0-.508,1.371A4.857,4.857,0,0,0,951.079,60.248Z" transform="translate(-832.191 -51.145)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M955.819,63.768a3.516,3.516,0,0,0,.458-.244l-.05.2c-.144.136-.291.271-.432.408l.366.114-.231.053a8.259,8.259,0,0,0,.516.646c-.168-.068-.338-.137-.5-.208l-.152-.138-.129.326-.275.1-.03.387c-.211-.142-.184-.4-.211-.616a3.651,3.651,0,0,0-1.014,1.215c-.167.593.489.791.8,1.154a2.311,2.311,0,0,0,1.06-.542c.316-.26.1-.709-.1-.97l.218-.006a5.435,5.435,0,0,0,.326.469l.267.172a5.753,5.753,0,0,0,1.077-.481c.015-.514.167-1.231-.409-1.5l-.414-.093.378-.239.274-.088c.218-.415.032-.869,0-1.307a1.422,1.422,0,0,0-1.56-.111c-.1.427-.551.847-.33,1.284l.1.019Z" transform="translate(-835.43 -54.561)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M1721.251,72.668a3.8,3.8,0,0,1-1.308.669,9.256,9.256,0,0,1-5.478.123,8.3,8.3,0,0,1-2.625-1.21,9.115,9.115,0,0,0,3.794,3.121,13.954,13.954,0,0,0,4.194,1.18,7.47,7.47,0,0,1,1.459.281,3.589,3.589,0,0,0,2.358-.287,2.343,2.343,0,0,0,.462-3.632A2.354,2.354,0,0,0,1721.251,72.668Z" transform="translate(-1498.913 -63.298)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M943.827,75.095a4.746,4.746,0,0,0,.888-.878c-.261-.022-.517-.041-.776-.065.205-.075.413-.147.617-.231.037-.453-.6-.392-.888-.565a2.008,2.008,0,0,0-.852-.037,3.2,3.2,0,0,0-.425,1.177c.349.376.9,1.088,1.437.6Z" transform="translate(-825.173 -64.21)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M962.507,77.362c-.068.286.274.294.469.243,0-.126,0-.251.006-.376C962.822,77.229,962.515,77.1,962.507,77.362Z" transform="translate(-842.78 -67.63)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M252.056,93.293a11.9,11.9,0,0,0-.986,3.081,10.247,10.247,0,0,1-2.394.684,9.366,9.366,0,0,1-4.526-.453c-.18-.067-.361-.129-.541-.189a12.776,12.776,0,0,1-1.275-.8l-.153.128c.3.359.627.7.959,1.025a10.2,10.2,0,0,0,3.162,2.093,16.545,16.545,0,0,0,2.561.832c.866.209,1.771.2,2.627.458a3.462,3.462,0,0,0,1.75.029c.536-.1.947-.588,1.521-.509.979.109,1.685-.683,2.335-1.286a9.313,9.313,0,0,0,2.113-2.427,5.432,5.432,0,0,0,.092-.71c-1.087.012-2.137.35-3.217.407,1.019-.471,2.092-.811,3.112-1.281-.317-.851-1.316-.986-2.052-1.3-1.1-.17-2.184-.445-3.3-.515a2.029,2.029,0,0,0-1.791.738Z" transform="translate(-212.059 -81.077)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M386.138,99.376a1.2,1.2,0,0,0-.535.557.953.953,0,0,0,.98,1.3.965.965,0,0,0,.5-1.7A1.046,1.046,0,0,0,386.138,99.376Z" transform="translate(-337.566 -87.013)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M1355.3,106.842c-.219.206-.543.083-.808.113a2.347,2.347,0,0,0-2.275,1.707,2.566,2.566,0,0,0,.443,2.2,2.513,2.513,0,0,0,3.641.224,6.287,6.287,0,0,0,.179-8.519,4.656,4.656,0,0,0-2.488-1.343,3.552,3.552,0,0,1,2.316,2.329,3.144,3.144,0,0,1-1.007,3.294Z" transform="translate(-1183.957 -88.665)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M407.415,110.45c1.2-.415,2.1-1.4,3.309-1.794-.076-.734-.187-1.463-.267-2.2a6.405,6.405,0,0,0-.423-1.916,3.181,3.181,0,0,0-.82-.934,4.375,4.375,0,0,0-1.792-.254,15.613,15.613,0,0,0-3.235.184,1.321,1.321,0,0,0-.887.606c.929.59,1.772,1.306,2.728,1.856-1.163-.216-2.164-.947-3.322-1.2a3.333,3.333,0,0,0,.7,2.362,17.506,17.506,0,0,0,1.985,2.664,1.913,1.913,0,0,0,2.03.618Z" transform="translate(-352.568 -90.527)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M83.383,101.882a1.061,1.061,0,0,0,1.814.316,1.389,1.389,0,0,0-.694-2.06,1.8,1.8,0,0,0-2.365,1.117,2.291,2.291,0,0,0,1.378,2.85,3.452,3.452,0,0,0,1.74.107c.459-.3,1.034-.486,1.336-.976a3.243,3.243,0,0,0,.648-2.569A3.714,3.714,0,0,0,84.51,97.9a4.094,4.094,0,0,0-2.851.4,4.849,4.849,0,0,0-2.215,3.251,4.729,4.729,0,0,0,1.7,4.494,5.722,5.722,0,0,0,4.35,1.427,6.141,6.141,0,0,0,4.242-2.513,6.327,6.327,0,0,0,1.341-4.311,8.605,8.605,0,0,0-2.53-5.886,12.778,12.778,0,0,0-1.831-1.515,11.753,11.753,0,0,0-3.487-1.5,17.44,17.44,0,0,0-7.051-.039,12.777,12.777,0,0,0-4.091,1.57c.623-.165,1.174-.515,1.785-.713A15.97,15.97,0,0,1,83,92.018a10.953,10.953,0,0,1,3.525,1.535,9.5,9.5,0,0,1,3.926,5.586,6.754,6.754,0,0,1-.682,4.727,5.846,5.846,0,0,1-3.132,2.686,5.02,5.02,0,0,1-5.1-1.067A4.125,4.125,0,0,1,80.15,103a3.978,3.978,0,0,1,1.321-3.657,3.207,3.207,0,0,1,2.178-.776,2.874,2.874,0,0,1,2.911,2.571,2.273,2.273,0,0,1-2.3,2.435,1.8,1.8,0,0,1-1.654-1.78,2.241,2.241,0,0,1,.554-1.021c.218-.241.566-.2.858-.238a1.133,1.133,0,0,0-.634,1.345Z" transform="translate(-63.126 -80.031)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M943.181,34.955a6.128,6.128,0,0,0-.017,2.066c-.065.087-.128.173-.189.26a5.075,5.075,0,0,0,.088-1.459,9.167,9.167,0,0,0-3.351-7.324,10.216,10.216,0,0,0-1.735-1.123,10.815,10.815,0,0,0-3.251-1.059,16.455,16.455,0,0,0-3.366-.139c-.661.121-1.323.225-1.973.389a9.868,9.868,0,0,0-4.89,3.089,8.111,8.111,0,0,0-1.8,7.547,7.084,7.084,0,0,0,5.354,5.029c.794-.044,1.59.017,2.382-.026a4.272,4.272,0,0,0,2.943-2.183,3.111,3.111,0,0,0,.144-1.921,2.516,2.516,0,0,0-1.49-1.551,2.209,2.209,0,0,0-2.361.534,2.072,2.072,0,0,0-.289,2.051,3.231,3.231,0,0,0,1.656,1.824,6.857,6.857,0,0,1-4.275-1.316,6.341,6.341,0,0,1-2.663-5.186,7.379,7.379,0,0,1,5.9-7.008,8.643,8.643,0,0,1,3.744.071,10.328,10.328,0,0,1,2.3.858,10.5,10.5,0,0,1,3.544,3.011,9.879,9.879,0,0,1,1.7,7.646,12.435,12.435,0,0,1-6.06,8.234,13.955,13.955,0,0,1-3.529,1.406,14.347,14.347,0,0,1-2.406.4,16.289,16.289,0,0,1-10.045-2.561q-.418-.254-.821-.522a38.1,38.1,0,0,1-5.329-4.306,58.413,58.413,0,0,1-10.355-12.613,56.067,56.067,0,0,1-2.8-5.048,2.365,2.365,0,0,0-.357-.428l.3-.087-.174.138c.607.759,1.091,1.607,1.692,2.371a26.1,26.1,0,0,0,2.081,2.409,28.986,28.986,0,0,0,4.061,3.514A20.485,20.485,0,0,0,909.96,33.5c.046.035.139.107.187.142-.287.019-.637-.025-.825.241a5.223,5.223,0,0,0-.541,1.328c.455.372.817,1.044,1.471,1.039a4.055,4.055,0,0,0,1.343-1.008c.062-.131.124-.262.185-.394l-1,.04c.022-.045.067-.136.088-.18a2.175,2.175,0,0,0,.833-.363.891.891,0,0,1-.32-.318l.51.027c-.02-.1-.061-.287-.081-.383a2.939,2.939,0,0,1-.141-.572c.211.295.4.606.595.914.49-.563.261-1.383.295-2.065-.077-.257-.258-.534-.557-.534a5.42,5.42,0,0,0-1.316-.014,7.12,7.12,0,0,0-.6,1.3c.045.177.087.354.123.534-1.179-.845-2.417-1.612-3.521-2.559a27.553,27.553,0,0,1-5.571-6.178,20.519,20.519,0,0,0,5.315,3.934,11.046,11.046,0,0,0,7.013,1.046,8.772,8.772,0,0,0,5.305-3.214,7.122,7.122,0,0,0,1.429-4.376,7.615,7.615,0,0,0-.792-3.733,7.656,7.656,0,0,0-4.546-3.682c-.353-.1-.709-.185-1.062-.274a7.967,7.967,0,0,0-1.343-.077,9.8,9.8,0,0,0-1.8.214,9.219,9.219,0,0,0-5.265,2.63c-.275.275-.571.527-.817.827a5.379,5.379,0,0,0-.82,1.758c.009-.182.02-.363.032-.546a5.73,5.73,0,0,1,1.215-2.178c0-.019-.006-.057-.009-.076l-.277-.009a3.267,3.267,0,0,0-1.654,1.378c-.379,1.223-.285,2.519-.6,3.753l.218-.095a6.272,6.272,0,0,0,2.383-1.87,4.986,4.986,0,0,0,.56-2.8,13.659,13.659,0,0,1,2.182-1.378l.3,0a5.3,5.3,0,0,0-1.3,6.629,4.788,4.788,0,0,0,2.676,2.1,3.558,3.558,0,0,0,2.02-.067,2.976,2.976,0,0,0,1.877-2.623,2.025,2.025,0,0,0-2.776-1.892,1.848,1.848,0,0,0-.861,2.337c.152.378.5.9.974.7.162-.122.483-.284.343-.529-.251-.223-.7-.346-.72-.738-.152-.7.715-1.244,1.327-.991a1.768,1.768,0,0,1,.679.545,1.9,1.9,0,0,1-.391,1.49,1.786,1.786,0,0,1-2.347.376,3.736,3.736,0,0,1-1.578-1.911,4.444,4.444,0,0,1,1.314-4.559,4.177,4.177,0,0,1,3.056-1.148,5.91,5.91,0,0,1,3.952,1.331,6.73,6.73,0,0,1,2.2,5.479,5.827,5.827,0,0,1-1.909,3.863,9.156,9.156,0,0,1-8.018,2.136l-.128-.029a11.521,11.521,0,0,1-4.125-1.79,21.744,21.744,0,0,1-5.294-5.472,29.215,29.215,0,0,0-.947-9.032,18.788,18.788,0,0,1-.392-1.863,5.789,5.789,0,0,1,4.7-.918,3.391,3.391,0,0,1,2.291,1.972,2.5,2.5,0,0,1-.794,2.771,1.953,1.953,0,0,1-1.345.238,2.135,2.135,0,0,0,.458-1.689c-.142-.6-.67-1.233-1.351-1.066a1.472,1.472,0,0,0-.939,2.107,2.547,2.547,0,0,0,2.581,1.346,2.824,2.824,0,0,0,1.839-1.463,3.3,3.3,0,0,0-.143-3.076,4.445,4.445,0,0,0-2.824-1.881,6.93,6.93,0,0,0-2.86.2,16.911,16.911,0,0,0-1.881.8,10.838,10.838,0,0,0-.363-1.442c-.79-2.7-1.692-5.369-2.74-7.978h-2.188a9.544,9.544,0,0,1,1.083,2.556,6.968,6.968,0,0,1-.4,5.132,4.031,4.031,0,0,1-3.223,2.228,7.085,7.085,0,0,1-2.358-.177,6.2,6.2,0,0,1-3.234-2.176,3.8,3.8,0,0,1-.054-4.372,2.632,2.632,0,0,1,2.992-1l.2.1a2.421,2.421,0,0,0-2.268.826,2.535,2.535,0,0,0,1.144,3.612,2.614,2.614,0,0,0,3.22-2.5,3.15,3.15,0,0,0-1.83-2.48c-.257-.117-.526-.208-.791-.3A3.627,3.627,0,0,0,882.675,5.1a4.79,4.79,0,0,0,1.342,3.492,7.015,7.015,0,0,0,4.855,2.276A6.253,6.253,0,0,0,893.6,8.713a9.217,9.217,0,0,0,1.389-2.025,14.789,14.789,0,0,1,.41,7.033,4.5,4.5,0,0,0-1.851,1.9c-.488,1.017-.182,2.158-.255,3.235l.209.014a4.969,4.969,0,0,1,1.363-1.289,5.9,5.9,0,0,0,1.372-1.424,4.171,4.171,0,0,0,.149-2.01l-.258-.112a4.7,4.7,0,0,1-1.5,2.483,5.882,5.882,0,0,0,1.178-2.668,16.618,16.618,0,0,0,.362-4.515c.04.116.078.233.118.35.118.353.242.7.353,1.06a25.8,25.8,0,0,1,1.086,5.053A18.826,18.826,0,0,1,895.3,26.772a13.339,13.339,0,0,1-6.616,5.794,10.472,10.472,0,0,1-3.927.743,10.263,10.263,0,0,1-5.979-1.678,9.993,9.993,0,0,1-4.163-5.5,9.793,9.793,0,0,1,.194-6.222,9.293,9.293,0,0,1,3.492-4.366A8.939,8.939,0,0,1,883.515,14a7.979,7.979,0,0,1,5.714,2.69,6.679,6.679,0,0,1,1.565,4.7,5.624,5.624,0,0,1-4.657,5.007,6.148,6.148,0,0,1-2.05-.136c0-.044-.015-.129-.019-.172a3.62,3.62,0,0,0,2.48-2.571,3.023,3.023,0,0,0-.464-2.208,2.9,2.9,0,0,0-2.692-1.187,2.983,2.983,0,0,0-2.459,2.886,4.445,4.445,0,0,0,2.627,4.264,6.578,6.578,0,0,0,8.451-2.336,7.232,7.232,0,0,0,.831-4.913,8.1,8.1,0,0,0-2.958-4.99,9.982,9.982,0,0,0-6.237-2.149A13.016,13.016,0,0,0,872.6,19.551l-.034.056a10.078,10.078,0,0,0-.347,8.723,4.749,4.749,0,0,1,.357.728,3.28,3.28,0,0,0-1.777.027c-.153.046-.307.093-.458.141a3.113,3.113,0,0,0-1.321,2.494,3.941,3.941,0,0,0,1.164,2.785,8.235,8.235,0,0,0,3.147,1.879,19.578,19.578,0,0,0,7.7.845,20.863,20.863,0,0,0,4.14-.816c.144.031.295.052.443.076l-.367-.016a9.592,9.592,0,0,1-1.8,1.158,16.948,16.948,0,0,1-5.773,1.848,4.8,4.8,0,0,1-.9.015,11.506,11.506,0,0,0-2.825-1.47,5.54,5.54,0,0,0-2.612.106c-1.073.292-1.989.968-3.05,1.29-.014.092-.025.184-.034.277,1.571.233,2.749,1.42,4.212,1.943a4.45,4.45,0,0,0,2.209.3,5.579,5.579,0,0,0,2.253-1.162c-.235-.235-.577-.128-.868-.138a7.736,7.736,0,0,1-2.554-.219,4.03,4.03,0,0,1-1.221-.437,5.98,5.98,0,0,1,1.221.169,7.937,7.937,0,0,0,2.3.1,10.805,10.805,0,0,0,1.256-.382,24.226,24.226,0,0,0,4.646-.909,19.183,19.183,0,0,0,2.193-.929,14.825,14.825,0,0,0,3.429-2.373c.637-.143,1.282-.256,1.9-.46a12.592,12.592,0,0,0,6.912-5.339,1.079,1.079,0,0,1,.439-.595c0,.766.316,1.566-.036,2.295a4.115,4.115,0,0,0,.056,2.58c.6,1.213,1.73,2.044,2.372,3.223.1.179.164.41.391.468.188-1.214.769-2.375.647-3.627a4.354,4.354,0,0,0-.643-2.013,24.158,24.158,0,0,1-1.567-1.965c-.112.225-.219.452-.312.684a5.607,5.607,0,0,0,.113,1.586c.16.682.484,1.309.694,1.974-.152-.259-.3-.519-.46-.77a7.3,7.3,0,0,1-.656-1.837,8.579,8.579,0,0,1,.106-4.136,17.371,17.371,0,0,0,1.246-3.34,62.376,62.376,0,0,1,3.232,5.459,36.131,36.131,0,0,1,1.56,3.562c.022.1.049.2.076.3.143.373.269.753.386,1.134a42.069,42.069,0,0,1,1.806,8.195,15.561,15.561,0,0,1-.194,4.1,8.871,8.871,0,0,1-2.227,4.352,7.564,7.564,0,0,1-2.821,1.734,7.441,7.441,0,0,1-3.628.345A6.493,6.493,0,0,1,892,50.5a5,5,0,0,1-.679-3.242,5.349,5.349,0,0,1,5.264-4.327,4.6,4.6,0,0,1,4.6,3.228,3.224,3.224,0,0,1-1.44,3.618,4.6,4.6,0,0,0-.489-1.96,2.044,2.044,0,0,0-2.434-.873,2.341,2.341,0,0,0-1.369,2.688,3.062,3.062,0,0,0,2.5,2.28,4.46,4.46,0,0,0,4.55-2.208,4.729,4.729,0,0,0,.428-3.555,5.968,5.968,0,0,0-3.635-4,11.187,11.187,0,0,0-3.589-.79,7.2,7.2,0,0,0-5.657,2.621,7.314,7.314,0,0,0-.667,7.1,4.686,4.686,0,0,0,1.541,2.653,5.2,5.2,0,0,1-1.847-2.324l-.256.027a3.122,3.122,0,0,0,.588,2.27c.85.935,2.112,1.318,3.026,2.182A9.918,9.918,0,0,0,891.992,53a3.115,3.115,0,0,0-1.377-1.508,3.024,3.024,0,0,1-.968-.639,8.263,8.263,0,0,1-.447-2.473,6.85,6.85,0,0,1,1.877-4.569,6.647,6.647,0,0,1,2.179-1.453l.036.055a6.275,6.275,0,0,0-1.965,1.694,6.367,6.367,0,0,0-.919,4.656,8.422,8.422,0,0,0,6.921,6.773,10.356,10.356,0,0,0,3.225-.165l.1-.029a8.767,8.767,0,0,0,4.535-2.906,11.319,11.319,0,0,0,2.283-5.91,19.755,19.755,0,0,0-1.24-8.42c2.08,2.188,4.115,4.422,6,6.779a45.525,45.525,0,0,1,4.885,7.354,30.855,30.855,0,0,1,2.016,4.81,23.63,23.63,0,0,1,1,5.64,7.278,7.278,0,0,1-4.9,6.038,7.876,7.876,0,0,1-1.483.337c-.657.068-1.316-.022-1.973.024l.09.362a9.886,9.886,0,0,0,3.27-.157,7.474,7.474,0,0,0,3.373-1.9,16.033,16.033,0,0,0,1.141-1.34,11.218,11.218,0,0,1-3.055,4.97c-.095.026-.189.05-.281.071a5.376,5.376,0,0,0-3.319.663,6.5,6.5,0,0,0-2.219,2.584c-.216.327-.443.648-.646.983a3.265,3.265,0,0,0,.889-.173c1.638-.34,3.516.087,4.947-.981a3.779,3.779,0,0,0,1.42-2.193l-.163-.024a9.41,9.41,0,0,1-2.045,1.234,5.957,5.957,0,0,1-1.79.481c.5-.234,1.01-.463,1.532-.654a5.949,5.949,0,0,0,1-.536,14.308,14.308,0,0,0,1.5-1.4,15.174,15.174,0,0,0,2.372-3.4,15.579,15.579,0,0,1-3.116,6.964,16.2,16.2,0,0,1-6.053,4.784,15.707,15.707,0,0,1-13.823-.464,14.37,14.37,0,0,1-5.29-4.6,9.66,9.66,0,0,1-1.465-7.19,8.641,8.641,0,0,1,11.85-6.3,7.97,7.97,0,0,1,4.6,4.329,8.435,8.435,0,0,1,.573,4.443,6.132,6.132,0,0,1-1.583,3.322,5.543,5.543,0,0,1-6.82.711,3.31,3.31,0,0,1-1.509-2.184,3.112,3.112,0,0,1,.346-2.075,2.184,2.184,0,0,1,1.95-.914,3.582,3.582,0,0,1,1.258.468c.318.087.537-.281.515-.554a2.563,2.563,0,0,0-2.285-1.224,3.614,3.614,0,0,0-2.368.827,2.974,2.974,0,0,0-.889,1.5,4.873,4.873,0,0,0,.928,3.84,5.785,5.785,0,0,0,2.627,1.8,7.438,7.438,0,0,0,3.192.2,5.776,5.776,0,0,0,3.251-1.728,7.7,7.7,0,0,0,2.549-5.984,8.443,8.443,0,0,0-2.681-5.737,10.887,10.887,0,0,0-4.52-2.561,12.607,12.607,0,0,0-4.449-.332,10.773,10.773,0,0,0-7.683,5.034,11.282,11.282,0,0,0-1.268,9.3,14.171,14.171,0,0,0,3.712,6,16.774,16.774,0,0,0,5.494,3.657,18.849,18.849,0,0,0,8.654,1.188,19.2,19.2,0,0,0,5.012-1.3,17.617,17.617,0,0,0,6.842-5.147,18.562,18.562,0,0,0,3.178-5.676,20.258,20.258,0,0,0,.883-8.649,28.709,28.709,0,0,0-1.986-7.933,43.205,43.205,0,0,0-4.273-7.948,8.8,8.8,0,0,1,.937,1,37.729,37.729,0,0,1,8.1,15.868,1.32,1.32,0,0,1-.029.618,26.681,26.681,0,0,1-1.728,3.054A8.567,8.567,0,0,0,922,74.848c.55,1.572,1.493,2.972,2.04,4.546.04.224.21.295.425.294a12.127,12.127,0,0,1,1.821-4.225,18.315,18.315,0,0,0,1.758-3.8,6.946,6.946,0,0,0-.993-5.595c-.2-.3-.418-.573-.636-.852l-.406.012a17.278,17.278,0,0,1,0,4.064c-.09.58-.274,1.139-.413,1.708a11.634,11.634,0,0,1-.726,2.166,9.014,9.014,0,0,1,.321-1.8,12.963,12.963,0,0,0,.189-4.82c-.016-.087-.047-.264-.062-.351a13.884,13.884,0,0,1-.552-2.121,38.235,38.235,0,0,0-6.757-14.134c-.444-.6-.933-1.169-1.414-1.74-.143-.179-.291-.351-.444-.519.047.019.141.056.188.073a26.393,26.393,0,0,0,2.205,1.647,51.13,51.13,0,0,0,6.086,3.658,6.936,6.936,0,0,1,1.271.8,8.511,8.511,0,0,0,1.248.537,26.674,26.674,0,0,0,3.042.458,8.167,8.167,0,0,1-4.739-.662,4.335,4.335,0,0,0-.607-.153,2.328,2.328,0,0,0,.544.911,5.625,5.625,0,0,0,2.287,1.56,10.1,10.1,0,0,0,3.709-.2,9.5,9.5,0,0,1,3.253-.381c-.068-.4-.481-.55-.739-.812a12.373,12.373,0,0,0-2.735-2.234,7.891,7.891,0,0,0-1.972-.652,6.262,6.262,0,0,0-2.565.315,1.79,1.79,0,0,1-1.588-.026c-.7-.374-1.418-.718-2.11-1.108A50.787,50.787,0,0,1,916.3,47a42.21,42.21,0,0,1-3.3-2.824,29.2,29.2,0,0,1-2.921-2.977c-.1-.015-.194-.031-.287-.047l.271-.01a37.187,37.187,0,0,0,6.745,5.281A27.982,27.982,0,0,0,922,48.845a19.946,19.946,0,0,0,5.933,1.116c.841-.08,1.683.055,2.526-.029q.433-.078.873-.143a13.408,13.408,0,0,0,4.406-1.524,15.023,15.023,0,0,0,3.951-3.234,14.23,14.23,0,0,0,3.361-7.685l.16.035a11.81,11.81,0,0,1-.029-2.427ZM894.462,5.846a4.265,4.265,0,0,1-.943,1.945l.143-.157c.107-.46.3-.9.389-1.362a7.588,7.588,0,0,0,.116-1.921A1.386,1.386,0,0,1,894.462,5.846ZM884.227,36.021a19.509,19.509,0,0,1-10.239-.134,7.776,7.776,0,0,1-3.3-1.759A3.346,3.346,0,0,1,869.7,31.1a2.623,2.623,0,0,1,1.3-1.5,2.552,2.552,0,0,1,1.131-.022,1.8,1.8,0,0,1,1.039,1.267c-.318-.261-.643-.6-1.091-.581a1.125,1.125,0,0,0-1.214,1.072,1.362,1.362,0,0,0,1.794,1.336,1.972,1.972,0,0,0,1.146-1.8A15.2,15.2,0,0,0,884.9,35.8C884.677,35.882,884.453,35.959,884.227,36.021Zm17.747,12.261c.04-.159.026-.347.147-.475a5.615,5.615,0,0,1,.092-.659,4.124,4.124,0,0,1-.062,1.08,4.031,4.031,0,0,1-2.662,2.909,3.233,3.233,0,0,1-2.472-.425l.083-.179c0,.041.012.122.017.163l.316.077a3.447,3.447,0,0,0,2.617-.262,4.136,4.136,0,0,0,1.923-2.228Zm4.331-1.394a14.581,14.581,0,0,0,.058-3.576c.053-.157.109-.312.167-.468a16.714,16.714,0,0,1-.024,4.791,9.064,9.064,0,0,1-1.4,3.678,7.867,7.867,0,0,1-7.556,3.432l-.086.025a6.742,6.742,0,0,1-1.7-.529c0-.019,0-.057,0-.076a8.914,8.914,0,0,1,1.4.26,9.435,9.435,0,0,0,3.9-.456,7.642,7.642,0,0,0,3.954-3.246A10.558,10.558,0,0,0,906.306,46.888Zm-9.894,24.726-.053.017a4.117,4.117,0,0,1,.075-2.23,2.627,2.627,0,0,1,2.744-1.611,5.965,5.965,0,0,0-1.388.583A3.55,3.55,0,0,0,896.412,71.613Zm45.829-33.428a4.334,4.334,0,0,1-.419,1.555,7.154,7.154,0,0,1,.1-.95,10.359,10.359,0,0,0-1.678-7.57,10.551,10.551,0,0,0-3.826-3.4,16.984,16.984,0,0,0-1.95-.807c-.31-.091-.627-.139-.94-.205a8.2,8.2,0,0,1,2.812.607,8.827,8.827,0,0,1,4.326,3.008,10.4,10.4,0,0,1,1.576,7.764Z" transform="translate(-760.262 -0.035)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M1575.754,117.914a.645.645,0,0,0-.893-.682.836.836,0,0,0-.361.682.776.776,0,0,0,.68.54C1575.423,118.371,1575.773,118.227,1575.754,117.914Z" transform="translate(-1378.654 -102.64)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M359.538,127.125c.592-.3,1.171-.628,1.775-.9a5.042,5.042,0,0,0,2.153-1.5,2.335,2.335,0,0,0,.19-1.879c-.263-.795-.6-1.564-.858-2.361a3.238,3.238,0,0,0-1.274-1.837c-.241-.111-.251.194-.31.343-.169.644-.377,1.277-.517,1.929-.083-.163-.163-.326-.24-.49.045-.721.063-1.444.046-2.166a2.159,2.159,0,0,0-1.336.7,11.349,11.349,0,0,0-1.758,2.229,9.9,9.9,0,0,0-1,1.863,1.9,1.9,0,0,0,.475,1.707c.8.883,1.916,1.42,2.657,2.368Z" transform="translate(-312.04 -103.585)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M1568.387,132.667c-.55.4-.307,1.478.425,1.465a.813.813,0,0,0,.872-1.071A.857.857,0,0,0,1568.387,132.667Z" transform="translate(-1373.041 -116.058)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M626.163,142.57a6.206,6.206,0,0,0-1.452,1.351.921.921,0,0,0,.077.933c.241.424.529.82.785,1.235.206.162.408.328.613.494.068-.419.117-.841.184-1.26.2.4.029.985.412,1.264a3.625,3.625,0,0,0,.624-.881,3.119,3.119,0,0,0,.52-2.024c-.407-.6-1.189-.725-1.764-1.112Z" transform="translate(-546.923 -124.871)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M1569.135,155.57a1.011,1.011,0,0,0-.443-1.378,1.2,1.2,0,0,0-1.419.384c-.08.461-.124,1.046.336,1.333a1.028,1.028,0,0,0,1.526-.34Z" transform="translate(-1372.284 -134.963)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M644.241,162.573a8.189,8.189,0,0,0,.542-1.877c-.465-.3-.871-.687-1.342-.981a.9.9,0,0,0-.985.042c-.417.347-.771.76-1.153,1.143a1.583,1.583,0,0,0-.338.816,9.05,9.05,0,0,1,1.361-.257c-.428.279-.924.42-1.371.664.151.1.3.193.463.285l-.447.2c.231.41.471.817.687,1.238-.387-.348-.714-.756-1.1-1.108a2.912,2.912,0,0,0-.034,1.9c.107.486.18,1.1.694,1.331.618.209,1.261-.152,1.888-.024a4.757,4.757,0,0,0,.509-2.178,1.162,1.162,0,0,0-.643-.6c.184-.277.552-.2.837-.254a2.3,2.3,0,0,1-1.029-.117c.475.007,1.1.177,1.458-.233Z" transform="translate(-560.729 -139.773)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M604.251,161.437a9.4,9.4,0,0,0-1,1.124,3.711,3.711,0,0,0,1.061,1.953,4.4,4.4,0,0,0,2.733-.874,6.932,6.932,0,0,0-1.33-.526,12.832,12.832,0,0,1,1.5.073,2.142,2.142,0,0,0-.524-.846,16.363,16.363,0,0,0-1.347-1.085c-.367-.061-.815-.137-1.09.18Z" transform="translate(-528.217 -141.186)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M106.029,163.357c.23-.2.466-.474.317-.8a.611.611,0,0,0-.938-.318c-.292.153-.235.544-.18.812C105.381,163.361,105.735,163.344,106.029,163.357Z" transform="translate(-92.103 -142.005)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M637.169,177.041c-.152-.172-.316-.517-.6-.4-.394.047-.387.512-.261.795A.586.586,0,0,0,637.169,177.041Z" transform="translate(-557.099 -154.685)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M1575.063,178.541a1.547,1.547,0,0,0-1.756-1.87,1.428,1.428,0,0,0-1.209,1.5,1.453,1.453,0,0,0,1.768,1.469,1.566,1.566,0,0,0,1.2-1.1Z" transform="translate(-1376.545 -154.699)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M98.782,177.447a.858.858,0,0,0,.088,1.455c.654.34,1.51-.522,1.054-1.148A.79.79,0,0,0,98.782,177.447Z" transform="translate(-86.179 -155.3)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M614.5,184.931c-.386.326-.907.652-.944,1.207a10.48,10.48,0,0,0,.856,1.7,8.537,8.537,0,0,0,1.822-.219c.542-.192.616-.831.613-1.327a6.006,6.006,0,0,0-.206-1.784c-.392.279-.587.743-.973,1.031a6.544,6.544,0,0,0,.545-1.372A3.962,3.962,0,0,0,614.5,184.931Z" transform="translate(-537.245 -161.297)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M1668.493,195.49a12.393,12.393,0,0,1-1.393,0,3.23,3.23,0,0,0-2.435,3.922,3.346,3.346,0,0,0,1.432,1.974,3.838,3.838,0,0,0,2.122.413,3.211,3.211,0,0,0,.275-6.308Z" transform="translate(-1457.512 -171.207)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M97.435,200.081c.2.2.377.465.675.519a.976.976,0,0,0,1.182-.456,1.024,1.024,0,0,0-.5-1.465c-.515-.292-1.041.146-1.372.515C97.422,199.487,97.426,199.785,97.435,200.081Z" transform="translate(-85.309 -173.916)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M1589.678,201.078a2.114,2.114,0,0,0-1.724-.277,1.939,1.939,0,0,0-1.32,1.265,1.975,1.975,0,0,0,1.21,2.459,2.044,2.044,0,0,0,1.611-.108,1.937,1.937,0,0,0,.974-1.669A2.019,2.019,0,0,0,1589.678,201.078Z" transform="translate(-1389.195 -175.787)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M1625.556,211.389a2.374,2.374,0,0,0-2.761,1.52,2.432,2.432,0,0,0,.913,2.8,2.864,2.864,0,0,0,1.677.4,2.688,2.688,0,0,0,2.04-1.983A2.473,2.473,0,0,0,1625.556,211.389Z" transform="translate(-1420.819 -185.079)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M103.178,224.413a3.663,3.663,0,0,0,1.212.026,2.606,2.606,0,0,0,.848-1.159,1.541,1.541,0,0,0-1.417-1.82c-.8.029-1.705.67-1.569,1.559C102.172,223.645,102.714,224.1,103.178,224.413Z" transform="translate(-89.525 -193.948)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M795.574,249.638c.075-.709.089-1.423.163-2.131.149.725.3,1.453.382,2.19a.648.648,0,0,0,.5-.187,8.27,8.27,0,0,0,1.335-2.528,2.311,2.311,0,0,0,.139-1.569c-.244-.6-.906-.817-1.439-1.073-.407-.157-.749-.444-1.162-.58l-.073-.012c-.718.719-1.741,1.182-2.19,2.136-.266.858.371,1.561.791,2.233.4.591.784,1.387,1.556,1.52Z" transform="translate(-694.508 -213.466)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M1225.59,258.8a3.26,3.26,0,0,0,1.294-.045,2.166,2.166,0,0,0,1.126-.5,4.724,4.724,0,0,0-.1-1.659,8.46,8.46,0,0,0-1.607-.3,2.481,2.481,0,0,0-.792,1.29,3.551,3.551,0,0,0-.122.848,3.4,3.4,0,0,0,.94-.6,1.169,1.169,0,0,1,.026.141,5.2,5.2,0,0,0-.766.827Z" transform="translate(-1072.971 -224.445)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M762.046,271.521c-.809.49-1.224,1.4-2.006,1.922.285.705.57,1.412.9,2.1a1.478,1.478,0,0,0,1.328.945,7.839,7.839,0,0,0,1.7-.387c.657-.21,1.522-.361,1.795-1.09-.476-.17-.955-.336-1.444-.459-.008-.058-.021-.174-.029-.233a15.82,15.82,0,0,0,1.73.168c0-.66-.565-1.078-.97-1.519a8.889,8.889,0,0,0-2.134-1.475c-.29.029-.581.027-.869.031Z" transform="translate(-665.504 -237.755)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M42.571,260.831c-.093-.366-.192-.731-.289-1.1-.265-.379-.81-.2-1.209-.26.205-.106.494-.154.586-.4.24-.429-.117-.882-.155-1.323l-.086-.155a2.05,2.05,0,0,0-1.264,0c-.256.175-.358.5-.545.743-.132-.694-1.026-.693-1.544-.486a3.622,3.622,0,0,0-.376,1.086,1.227,1.227,0,0,0,.729.6c0,.053.016.162.021.215-.168-.04-.378-.163-.455.082-.759,0-.692.891-.693,1.418a2.831,2.831,0,0,0,1.081.557c.372-.16.552-.555.8-.848l.111.131c-.124.308-.465.656-.253.994.163.424.659.5.974.771a3.288,3.288,0,0,0,.869-.707c.174-.259.022-.585,0-.865a1.264,1.264,0,0,0,.606.209,1.711,1.711,0,0,0,1.091-.677Z" transform="translate(-32.656 -225.507)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M1220.53,275.314a.475.475,0,0,0-.057.559.586.586,0,0,0,.586-.032.748.748,0,0,0-.189-.56Z" transform="translate(-1068.608 -241.074)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M4.127,285.606a6.983,6.983,0,0,0,.682-4.989,5.986,5.986,0,0,0-2.223-3.31A4.794,4.794,0,0,0,0,276.585v.688a4.452,4.452,0,0,1,1.358.149,4.2,4.2,0,0,1,2.128,1.7,6.343,6.343,0,0,1,.6,4.108A5.357,5.357,0,0,1,2.167,286.5,4.24,4.24,0,0,1,0,287.229V288.5a6.265,6.265,0,0,0,4.127-2.894Z" transform="translate(-0.003 -242.215)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M1228.383,279.263l.3-.129c-.124-.576.082-1.307-.372-1.759a5.007,5.007,0,0,0-1.924-.215l-.214.233c.239.188.488.364.725.556a5.12,5.12,0,0,1-1.019-.292,3.981,3.981,0,0,0,1,1.927c.521.335,1.042-.093,1.506-.32Z" transform="translate(-1073.4 -242.72)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M1210.472,283.041a5.432,5.432,0,0,0-1.005,1.44.562.562,0,0,0,.025.613c.29.367.717.586,1.035.924a3.76,3.76,0,0,0,1.5-.927c-.012-.215-.019-.43-.04-.643-.291-.4-.291-.96-.648-1.315l-.234.005c-.1.3-.178.611-.284.91-.029-.369-.026-.74-.021-1.11l-.226.06Z" transform="translate(-1058.96 -247.781)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M1.927,291.641A2.651,2.651,0,0,0,0,289.32v4.655c.335-.291.766-.434,1.107-.715A2.213,2.213,0,0,0,1.927,291.641Z" transform="translate(-0.003 -253.367)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M811.525,295.624c-.087-.622-.952-.609-1.275-.188a.88.88,0,0,0,.414,1C811.131,296.506,811.657,296.138,811.525,295.624Z" transform="translate(-709.444 -258.46)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M822.171,273.971a1.736,1.736,0,0,0,.509-.728c.26-.745.358-1.535.595-2.287-.609-.419-1.148-.93-1.763-1.341a1.5,1.5,0,0,0-1.774-.093,18.919,18.919,0,0,0-1.726,1.662,2.467,2.467,0,0,0-.529,1.23c.731-.1,1.45-.287,2.185-.363a20.1,20.1,0,0,1-2.091.907c.118.388.522.529.861.672l-.3.032c-.184,0-.368.009-.55.011.091.759.777,1.28.929,2.023a15.327,15.327,0,0,0-1.577-1.7c-.08.152-.158.3-.233.457a6.942,6.942,0,0,0,.134,2.275,6.031,6.031,0,0,0,.46,1.588,1.27,1.27,0,0,0,.881.565c.879.08,1.743-.187,2.623-.151a17.305,17.305,0,0,1,.647-1.947,2.641,2.641,0,0,0,.071-1.087,1.687,1.687,0,0,0-.894-1.037c-.358-.25-.772-.406-1.147-.627.882.02,1.873.425,2.688-.063Z" transform="translate(-715.071 -235.812)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M781.407,309.886a17.383,17.383,0,0,0-.081-2.4c-.082-.178-.168-.351-.253-.524l-.163,0c-.362.532-.774,1.03-1.113,1.577l-.19.042c.034-.034.1-.1.131-.138.215-.674.609-1.279.776-1.97a2.276,2.276,0,0,0-1.312.295,13.013,13.013,0,0,0-2.066,1.425,1.464,1.464,0,0,0-.613,1.2,3.865,3.865,0,0,0,.673,1.439,5.5,5.5,0,0,1,.557,1.112c.81-.126,1.636-.109,2.44-.272a2.187,2.187,0,0,0,.9-.491A2.283,2.283,0,0,0,781.407,309.886Z" transform="translate(-679.933 -268.378)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M0,327.41v2.136A3.706,3.706,0,0,0,0,327.41Z" transform="translate(-0.003 -286.72)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M948.276,347.933a4.564,4.564,0,0,0,.465.891l.175-.012c.627-.845,1.208-1.728,1.891-2.53-.379,1.066-.93,2.066-1.273,3.146a2.693,2.693,0,0,0,2.153-.5,18.014,18.014,0,0,0,2.582-1.782,2.272,2.272,0,0,0,1.05-1.75,3.749,3.749,0,0,0-.81-2.026,9.076,9.076,0,0,1-1.013-1.9c-1.359.3-2.81.127-4.111.667a2.118,2.118,0,0,0-1.207,2.129,29.553,29.553,0,0,0,.1,3.667Z" transform="translate(-830.234 -299.031)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M378.35,344.54a2.165,2.165,0,0,0-1.923,1.153,25.343,25.343,0,0,0-1.347,2.608,4.41,4.41,0,0,0-.479,2.279c.065.331.427.187.622.067.831-.508,1.664-1.011,2.489-1.53-.674.891-1.6,1.56-2.331,2.4a3.922,3.922,0,0,0,2.667.284c.845-.2,1.729-.168,2.559-.433a2.136,2.136,0,0,0,1.465-1.705,28.532,28.532,0,0,0-.037-3.857c-1.306-.192-2.377-1.1-3.684-1.265Z" transform="translate(-327.976 -301.707)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M893.49,349.243a1.735,1.735,0,0,0-1.386-.945,13.022,13.022,0,0,0-3.21.627c-.264.046-.526.1-.786.147-.083,1.231-.49,2.419-.524,3.654a2.061,2.061,0,0,0,.807,1.738,9.708,9.708,0,0,0,2.616.954,4.274,4.274,0,0,0,2.962.19c-.613-.947-1.367-1.792-2.037-2.7l.163.063c.813.728,1.7,1.368,2.519,2.086.1-.106.2-.211.3-.318a7.643,7.643,0,0,0-.539-3.392A12.961,12.961,0,0,0,893.49,349.243Z" transform="translate(-777.183 -304.999)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M361.2,399.532a1.05,1.05,0,0,0-.948-.139,1.146,1.146,0,0,0-.539.593.958.958,0,0,0,.976,1.269.892.892,0,0,0,.845-.637A.917.917,0,0,0,361.2,399.532Z" transform="translate(-314.914 -349.708)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M1187.648,398.43a11.389,11.389,0,0,0-1.117,1.525c-.194.486.159.945.494,1.263a3.793,3.793,0,0,0,1.479,1.121c0-.5-.126-.978-.152-1.471a12.76,12.76,0,0,1,.534,1.3l.238.031a6.588,6.588,0,0,0,.46-1.158,4.926,4.926,0,0,0,.121-1.689c-.389-.756-1.379-.608-2.056-.917Z" transform="translate(-1038.897 -348.906)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M967.737,406.065a14.057,14.057,0,0,1,2.169-1.928c-.255-.713-.524-1.421-.744-2.144a4.663,4.663,0,0,0-1.131-2.086,2.643,2.643,0,0,0-2.38-.291c-.748.221-1.521.328-2.275.525a3.245,3.245,0,0,0-1.744,1.044,18.1,18.1,0,0,0,2.133.955,5,5,0,0,1,.923.443,17.46,17.46,0,0,1-2.514-.452c-.308-.041-.617-.067-.925-.082a1.677,1.677,0,0,0,.184.845,10.4,10.4,0,0,0,2.219,2.509,5.076,5.076,0,0,0,2.3,1.414A2.3,2.3,0,0,0,967.737,406.065Z" transform="translate(-841.687 -349.815)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M942.289,407.132a1.078,1.078,0,0,0,.922,1.31,1.3,1.3,0,0,0,.888-.562,1.186,1.186,0,0,0-.127-1.114,1.331,1.331,0,0,0-1.026-.294A1.462,1.462,0,0,0,942.289,407.132Z" transform="translate(-825.055 -355.933)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M874.748,412.127c-.328,1.235-.061,2.542-.368,3.78,1.054.468,2.047,1.06,3.1,1.54a2.644,2.644,0,0,0,1.629.092c.942-.323,1.412-1.266,1.917-2.047.57-.908,1.371-1.8,1.365-2.929-.078-.087-.158-.173-.235-.257a25.965,25.965,0,0,1-2.963,1.05c.3-.182.608-.358.9-.552.631-.425,1.25-.867,1.9-1.265v-.223a2.059,2.059,0,0,0-1.174-.55,12.481,12.481,0,0,0-3.383-.076,3.742,3.742,0,0,0-2.122.559,2.182,2.182,0,0,0-.563.879Z" transform="translate(-765.622 -359.567)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M1213.718,412.733a15.03,15.03,0,0,0,.154-1.861c-.748-.28-1.439-.907-2.29-.675l-.058.053a5.753,5.753,0,0,0-.93,1.3,2.572,2.572,0,0,0-.353,1.06,11.873,11.873,0,0,1,1.336-.452,10.194,10.194,0,0,1-1.132.777,4.733,4.733,0,0,0,.374.4c.667-.017,1.337,0,2-.076A1.114,1.114,0,0,0,1213.718,412.733Z" transform="translate(-1059.706 -359.164)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M1169.454,420.647c-.583.4-.756,1.128-1.214,1.636a6.854,6.854,0,0,0,1.262,1.571c.45.287.978-.014,1.386-.24.465-.316,1.156-.505,1.3-1.117a5.912,5.912,0,0,1-1.218-.18v-.078a3.583,3.583,0,0,0,1.357-.188,4.765,4.765,0,0,0-1.887-1.271A1.513,1.513,0,0,0,1169.454,420.647Z" transform="translate(-1022.93 -368.326)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M929.765,427.162a2.277,2.277,0,0,0-1.271-.719c0,1.075-.134,2.143-.2,3.215-.281-1.092-.381-2.223-.6-3.329-.459.014-.756.394-1.054.693a19.735,19.735,0,0,0-1.228,2.268,12.754,12.754,0,0,0-.767,2.343,1.81,1.81,0,0,0,.7,1.694c.975.766,2.244,1.039,3.189,1.852,1.034-1.02,2.433-1.671,3.232-2.917a2.815,2.815,0,0,0-.591-2.932C930.7,428.619,930.295,427.845,929.765,427.162Z" transform="translate(-809.623 -373.335)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M545.181,433.858a15.659,15.659,0,0,0,1.947.73c.23-.036.461-.08.692-.124-.316-.668-.808-1.235-1.1-1.914.532.515,1.05,1.046,1.562,1.582.58-.368.3-1.164.31-1.729-.188-.694-.291-1.412-.54-2.086-.178-.386-.406-.845-.861-.94a13.218,13.218,0,0,0-2.872.24c-.039.159-.075.32-.116.48a6.655,6.655,0,0,0-.5,2.479C543.826,433.29,544.563,433.644,545.181,433.858Z" transform="translate(-476.055 -375.967)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M585.76,434.758a17.79,17.79,0,0,0,1.5-1.513l.091.034c-.368.66-.869,1.243-1.172,1.939a2.918,2.918,0,0,0,1.855-.265,8.729,8.729,0,0,0,2.076-1.111,1.169,1.169,0,0,0,.449-1.183c-.2-.835-.627-1.593-.856-2.421-.837.009-1.675-.083-2.513-.034a1.317,1.317,0,0,0-1.168.765,8.1,8.1,0,0,0-.379,1.733,4.35,4.35,0,0,0-.124,1.471,5.362,5.362,0,0,0,.238.583Z" transform="translate(-512.678 -376.716)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M1203.354,432.172c.287-.178.18-.565,0-.782-.2.012-.466-.068-.595.136C1202.4,431.856,1202.994,432.506,1203.354,432.172Z" transform="translate(-1053.061 -377.761)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M1.887,438.692a2.472,2.472,0,0,0-.336-3.166A2.025,2.025,0,0,0,0,435.254v2.25a2.734,2.734,0,0,0,1.6.239A1.728,1.728,0,0,1,0,439.06v.657A2.983,2.983,0,0,0,1.887,438.692Z" transform="translate(-0.003 -381.123)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M1212.37,436.985c-.256-.542-.9-.6-1.418-.711a3.841,3.841,0,0,0-1.488-.058,15.05,15.05,0,0,1,.981,1.246,5.7,5.7,0,0,0-1.331-.933,4.618,4.618,0,0,0,.641,2.426,1.6,1.6,0,0,0,.618.6,14.337,14.337,0,0,0,1.977-.514C1212.294,438.358,1212.635,437.647,1212.37,436.985Z" transform="translate(-1058.706 -381.951)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M1184.788,442.43a8.721,8.721,0,0,0,1.233,1.572c.71-.317,1.613-.343,2.095-1.04a7.457,7.457,0,0,0-.259-1.922,1.884,1.884,0,0,0-.429-.782c-.254.412-.428.866-.67,1.284.061-.5.194-.979.269-1.471a1.879,1.879,0,0,0-1.112.617c-.456.5-1.167,1-1.126,1.743Z" transform="translate(-1037.418 -385.366)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M781.007,443.3q-.442-.366-.878-.739l-.383.01q-.371.332-.721.685l-.2.093c.132-.372.469-.708.409-1.126a2.278,2.278,0,0,0-.925-.791c-.338-.081-.576.28-.843.425-.075.055-.148.109-.221.165a1.47,1.47,0,0,0,.211.963,5.379,5.379,0,0,0,.646.835c.03-.179.06-.357.088-.536l.136,0a.751.751,0,0,0,.361.532l.254.132c-.015.082-.046.248-.062.33a6.78,6.78,0,0,0,.8.249c.261.026.524.034.787.041A3.983,3.983,0,0,0,781.007,443.3Z" transform="translate(-680.563 -386.554)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M764.257,455.382a6.955,6.955,0,0,0,.429,1.037,6.449,6.449,0,0,0,1.226-.106,2.647,2.647,0,0,0,.256-.733,4.575,4.575,0,0,0-.1-1.2c-.2.194-.386.4-.571.6.065-.223.127-.448.193-.67l-.2-.021c.413-.384-.277-.453-.542-.576.252,0,.5-.012.76-.02a2,2,0,0,0-.516-.66c-.25-.211-.524-.514-.889-.428a5.7,5.7,0,0,0-.933.736,3.91,3.91,0,0,0,.549,1.267c.394-.037.785-.111,1.174-.183-.316.277-.933.432-.836.957Z" transform="translate(-668.42 -396.329)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M1378.436,462.259a1.425,1.425,0,0,0-.259-.664c-.8-.669-1.923-.562-2.825-1.015l-.175.216-.052-.009c-.452.816-1.306,1.389-1.53,2.332a1.9,1.9,0,0,0,.845,1.707c.677.613,1.255,1.508,2.245,1.6-.092-.766-.253-1.521-.365-2.284a20.4,20.4,0,0,0,1.015,2.215,3.013,3.013,0,0,0,.825-1.639A8.914,8.914,0,0,0,1378.436,462.259Z" transform="translate(-1202.718 -403.325)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M784.066,462.068c.21-.233-.146-.672-.367-.356C783.434,461.959,783.817,462.2,784.066,462.068Z" transform="translate(-686.142 -404.22)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M786.523,467.989l.27.287c.4.011.8.014,1.208,0a4.468,4.468,0,0,0,.405-1.209c-.116-.111-.229-.223-.341-.333a3.011,3.011,0,0,0-1.352-.479c.116.235.23.473.338.714a3.607,3.607,0,0,0-.664-.485c-.014.243-.016.489-.01.734C786.415,467.479,786.471,467.733,786.523,467.989Z" transform="translate(-688.563 -408.296)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M595,467.322a6.475,6.475,0,0,0-1.474.187,3.79,3.79,0,0,0-2.016.725c.372.525,1.162.473,1.535.993a11.226,11.226,0,0,0-1.889-.307,1.947,1.947,0,0,0,.234.714,9.893,9.893,0,0,0,1.751,2.011,4.609,4.609,0,0,0,.631.5,1.494,1.494,0,0,0,1.715-.275,6.769,6.769,0,0,1,1.559-1.236c-.252-.779-.4-1.591-.72-2.347A1.43,1.43,0,0,0,595,467.322Z" transform="translate(-517.631 -409.225)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M534.773,474.914c.715-.3,1.083-1.025,1.585-1.571a2.718,2.718,0,0,0,.833-1.806c-.718.119-1.376.466-2.1.545.618-.435,1.33-.71,1.977-1.1a5.559,5.559,0,0,0-.444-.461,10.508,10.508,0,0,0-3.637-.3,1.376,1.376,0,0,0-1.1,1.21,18.671,18.671,0,0,1-.33,2.1c.692.417,1.35.888,2.062,1.269A1.756,1.756,0,0,0,534.773,474.914Z" transform="translate(-465.444 -411.731)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M579.3,471.671a.808.808,0,0,0,.988.08.741.741,0,0,0-.307-1.164C579.361,470.344,578.867,471.22,579.3,471.671Z" transform="translate(-507.101 -412.05)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M1413.421,478.758c-.668-.357-1.578-.694-2.238-.141a11.891,11.891,0,0,0-1.443,2.1,2.474,2.474,0,0,0-.351,1.29,16.836,16.836,0,0,0,2.152-.789c-.59.483-1.231.894-1.863,1.316l.119.276c.264.092.529.189.8.271a13.345,13.345,0,0,0,3.1-.157,1.279,1.279,0,0,0,.979-1.057c.131-.815.04-1.646.1-2.465a11.034,11.034,0,0,1-1.353-.641Z" transform="translate(-1234.083 -418.862)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M570.346,486.189a1.312,1.312,0,0,0-.508-.189,9.614,9.614,0,0,1-.127,1.909,9.255,9.255,0,0,1-.389-1.877c-.164.024-.366-.026-.483.122a4.4,4.4,0,0,0-.827,1.35,12.567,12.567,0,0,0-.606,1.735,1.412,1.412,0,0,0,.315,1.44c.688.577,1.617.734,2.342,1.26.483-.364.915-.79,1.388-1.168a2.29,2.29,0,0,0,.9-1.292,2.024,2.024,0,0,0-.384-1.239A10.932,10.932,0,0,0,570.346,486.189Z" transform="translate(-496.777 -425.583)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M1352.339,497.389c.019-.113.035-.228.051-.341-.736-.026-1.465-.134-2.193-.233.777-.149,1.573-.165,2.356-.29-.081-.536-.578-.816-.979-1.1a9.974,9.974,0,0,0-1.4-.765,2.671,2.671,0,0,0-1.853-.348,2.227,2.227,0,0,0-.869.922,13.058,13.058,0,0,1-.927,1.5c.028.281.316.471.455.711.474.649.873,1.452,1.649,1.786.85.238,1.567-.378,2.276-.735A3.576,3.576,0,0,0,1352.339,497.389Z" transform="translate(-1179.034 -432.807)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M5.1,477.58a3.688,3.688,0,0,1,1.545,2.253,2.346,2.346,0,0,1-.257,1.771,1.552,1.552,0,0,1-1.153.652,1.564,1.564,0,0,1-1.412-.391,1.185,1.185,0,0,1,.1-1.363,1.064,1.064,0,0,1,1.1-.24c.428.2.4.725.471,1.119l.425-.012a4.385,4.385,0,0,0,.356-.42,1.133,1.133,0,0,0-.418-.924,1.826,1.826,0,0,0-2.724.088,2.067,2.067,0,0,0-.21,2.011,2.273,2.273,0,0,0,1.392,1.235,3.364,3.364,0,0,0,2.821-.869,3,3,0,0,0,.9-2.06,4.475,4.475,0,0,0-1.306-3.607A5.321,5.321,0,0,0,1,475.678L.73,475.64a7.528,7.528,0,0,1,2.054-1.363,1.418,1.418,0,0,1,.826.075,3.4,3.4,0,0,0,2.877.3,15.456,15.456,0,0,0,2.338-1.412c-1.469-.143-2.758-1.175-4.275-.944a2.915,2.915,0,0,0-1.587,1.119,9.041,9.041,0,0,0,1.095-.165l.022.19A12.009,12.009,0,0,0,0,475.607v2.187a4.736,4.736,0,0,1,5.1-.214Z" transform="translate(-0.003 -413.552)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M1398.017,510.291c-.149.2-.469.377-.358.672a1.283,1.283,0,0,0,.326.581c.279,0,.627.088.822-.177.255-.18.158-.506.155-.769A.934.934,0,0,0,1398.017,510.291Z" transform="translate(-1223.792 -446.834)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M1411.406,517.772c-.621-.21-1.287-.243-1.9-.486a8.649,8.649,0,0,0-1.307-.011l-.253.05c0,.05-.015.149-.021.2a17.083,17.083,0,0,1,1.4,1.625q-.773-.556-1.539-1.116a.927.927,0,0,0-.484-.163,5.833,5.833,0,0,0,.73,3.059,2.1,2.1,0,0,0,1.259,1.406,17.186,17.186,0,0,0,2.823-.708,21.374,21.374,0,0,0,.218-2.667,1.52,1.52,0,0,0-.933-1.187Z" transform="translate(-1232.23 -452.95)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M1375.126,523.643l-.236-.012c-.279.653-.556,1.307-.883,1.938.093-.78.343-1.534.392-2.319a2.774,2.774,0,0,0-1.62.894,13.317,13.317,0,0,0-1.363,1.514,1.384,1.384,0,0,0-.1,1.668c.458.654,1.1,1.149,1.551,1.811.719-.179,1.412-.463,2.127-.668a1.976,1.976,0,0,0,1.1-1.124,3.561,3.561,0,0,0-.106-1.123A6.282,6.282,0,0,0,1375.126,523.643Z" transform="translate(-1200.54 -458.2)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M274.841,616.375a8.893,8.893,0,0,1,.664-1.139,5.854,5.854,0,0,1-.32,1.251c.634,0,1.09-.48,1.607-.774.333-.28.8-.573.733-1.076-.042-.713-.6-1.248-.84-1.9a5.079,5.079,0,0,1-.822.122c-.553.06-1.281.118-1.473.756a14.25,14.25,0,0,0,0,1.9A1.132,1.132,0,0,0,274.841,616.375Z" transform="translate(-240.236 -536.558)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M247.968,623.286a2.938,2.938,0,0,0,1.8.107c-.17-.435-.634-.667-.86-1.075.4.189.748.48,1.161.652a3.135,3.135,0,0,0-.106-1.009c-.254-.582-.323-1.341-.915-1.694a3.44,3.44,0,0,0-1.483.109c-.229.056-.454.118-.68.179-.041.593-.235,1.168-.256,1.763.1.642.826.789,1.338.968Z" transform="translate(-215.955 -543.112)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M285.458,637.516a6.033,6.033,0,0,0-1.5.707c-.136.068-.1.239-.136.363a3.781,3.781,0,0,1,1.119.291,3.593,3.593,0,0,1-1.177.036c.224.822,1.117,1.092,1.663,1.656a1.244,1.244,0,0,0,1.036-.057,8.419,8.419,0,0,0,1.263-1.3c-.34-.52-.424-1.182-.851-1.643-.387-.379-.969-.157-1.423-.055Z" transform="translate(-248.476 -558.114)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M273.539,644.378a4.317,4.317,0,0,0-.2.4,2.649,2.649,0,0,0,.442.465c.147-.1.336-.151.439-.3a.889.889,0,0,0-.091-.633C273.935,644.331,273.712,644.269,273.539,644.378Z" transform="translate(-239.343 -564.202)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M250.377,648.559c.082.486.209.965.277,1.455a6.605,6.605,0,0,1-.577-1.2c-.132.067-.265.134-.4.2-.014-.173-.029-.346-.044-.517a5.741,5.741,0,0,1-1.277.612c.325-.3.669-.573.994-.871-.735-.45-1.637-.073-2.435-.052a2.324,2.324,0,0,0-.611.642,9.647,9.647,0,0,0-.011,1.933c.576.136,1.085.484,1.671.568.412.058.69-.28.92-.563.211-.459.453-.9.663-1.363-.026.586-.272,1.138-.281,1.723a1.183,1.183,0,0,0,.943.994c.374.108.74.244,1.117.341a7.418,7.418,0,0,0,1.139-1.2c.32-.393.067-.9-.2-1.245-.561-.556-1.051-1.348-1.9-1.463Z" transform="translate(-215.623 -567.451)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M947.491,679.338a2.4,2.4,0,0,0,.9-2.366c-.465-1.387-1.674-2.325-2.4-3.562a14.412,14.412,0,0,1-2.4.634,2.7,2.7,0,0,0-2.1,1.254,4.908,4.908,0,0,0-.061,2.422c.07.58.173,1.157.3,1.728a5.783,5.783,0,0,0,.735,1.927,1.214,1.214,0,0,0,.547.4c.461-.981.817-2.01,1.306-2.978-.031,1.052-.394,2.069-.424,3.125a3.112,3.112,0,0,0,1.267-.444A27.377,27.377,0,0,0,947.491,679.338Z" transform="translate(-824.228 -589.682)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M885.35,703.725a6.454,6.454,0,0,0,2.371.648,10.681,10.681,0,0,0,3.288.078c.31-.088.767-.188.784-.585-.889-.739-1.835-1.417-2.668-2.218.5.3,1.031.526,1.549.786a10,10,0,0,0,1.577.7,3.576,3.576,0,0,0-.5-2.312c-.308-.576-.643-1.137-.915-1.73a2.714,2.714,0,0,0-1.739-1.611,5.342,5.342,0,0,0-2.761.664,10.234,10.234,0,0,1-1.666.611,17.119,17.119,0,0,1-.087,2.625A2.517,2.517,0,0,0,885.35,703.725Z" transform="translate(-774.529 -610.731)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M975.833,723.013a2.231,2.231,0,0,0-2.219-.063,15.8,15.8,0,0,0-3.679,2.024,1.493,1.493,0,0,0-.617,1.03c.32.2.723.1,1.08.167.724.118,1.467.1,2.181.284-1.049.2-2.118.25-3.166.449a3.866,3.866,0,0,0,2.041,1.883,8.923,8.923,0,0,0,2.919,1.295,2.266,2.266,0,0,0,1.756-.887c.7-.812,1.221-1.765,1.891-2.6.206-.206-.066-.442-.175-.619C977.1,725.033,976.782,723.786,975.833,723.013Z" transform="translate(-848.75 -632.828)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M624.087,749.47c.1-.284.21-.561.33-.835l-.317-.131c.1-.109.2-.221.3-.326a4.616,4.616,0,0,1-1-.393,8.189,8.189,0,0,1,.939.037l.061-.119a4.506,4.506,0,0,0-1.183-1.166.772.772,0,0,0-.743-.116,5.484,5.484,0,0,0-1.137,1c.2.481.364.973.56,1.455a4.855,4.855,0,0,0,1.618-.1c-.335.313-.915.427-1.02.932-.067.571.355,1.034.534,1.546.582-.077,1.416.23,1.784-.373a3.361,3.361,0,0,0-.017-2.233,6.576,6.576,0,0,1-.71.823Z" transform="translate(-544.056 -653.575)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M948.638,748.093c.114-.055.23-.107.349-.155a1.026,1.026,0,0,0,.4-1.015,1.363,1.363,0,0,0-.48-.687,5.135,5.135,0,0,0-.928-.01,1.843,1.843,0,0,0-.526.688A1.042,1.042,0,0,0,948.638,748.093Z" transform="translate(-829.596 -653.426)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M648.033,758.948c.207.081.3-.184.438-.275-.039-.087-.117-.26-.155-.346-.167-.007-.332-.014-.5-.017-.122.224-.109.622.214.638Z" transform="translate(-567.18 -664.021)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M891.033,764.148c1.438.073,2.737.948,4.2.789a2.34,2.34,0,0,0,1.326-1.177c.174-.567.452-1.095.643-1.656a7.422,7.422,0,0,0,.626-3.755c-.132-.01-.287-.072-.392.039-.8.613-1.591,1.244-2.385,1.867l-.184.062c.632-.667,1.148-1.434,1.753-2.127.119-.153.286-.3.276-.509a2.576,2.576,0,0,0-1.592-.192c-.863.16-1.69.466-2.545.663a4.282,4.282,0,0,0-1.258.473,2.189,2.189,0,0,0-.966,1.994c.065,1.188.389,2.345.5,3.529Z" transform="translate(-779.762 -663.265)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M652.795,763.776a3.055,3.055,0,0,0-1.11-.326c.151.363.342.706.52,1.056-.31-.2-.483-.551-.8-.736a3.138,3.138,0,0,0-.021,1.625c0,.28.213.465.382.659.025.03.073.09.1.118.5,0,1,.01,1.5,0,.158-.571.652-1.113.419-1.733A3.192,3.192,0,0,0,652.795,763.776Z" transform="translate(-570.279 -668.522)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M949.773,770.833c1.138.33,2.328.43,3.482.7.476-1.178,1.49-2.031,1.989-3.194a1.9,1.9,0,0,0-.241-1.754,11.892,11.892,0,0,0-2.3-2.106c-.861-.532-1.716-1.4-2.82-1.164.27,1.153.761,2.239,1.075,3.38-.562-.937-1.148-1.861-1.731-2.784-.336-.077-.461.393-.588.628a12.926,12.926,0,0,0-.423,3.067,7.99,7.99,0,0,0,.029,1.865A2.223,2.223,0,0,0,949.773,770.833Z" transform="translate(-830.238 -668.369)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M262.681,813.532c.06.182.24.261.4.35.452-.6.688-1.342,1.2-1.893-.152.72-.511,1.373-.677,2.091.86.118,1.494-.519,2.133-.973a3.542,3.542,0,0,0,1.363-1.307,1.786,1.786,0,0,0-.131-1.249c-.366-.663-.739-1.323-1.129-1.97a19.4,19.4,0,0,0-2.607.336,1.394,1.394,0,0,0-.815,1.014c-.036.718-.026,1.437-.024,2.156A6.224,6.224,0,0,0,262.681,813.532Z" transform="translate(-229.75 -708.039)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M221.55,822.786a13.111,13.111,0,0,0,2.459.654,2.441,2.441,0,0,0,1.281-.095l.066-.169a18.146,18.146,0,0,1-1.447-1.617c.51.3.965.684,1.473.989a.735.735,0,0,0,.435.072,3.811,3.811,0,0,0-.178-1.411q-.319-.946-.7-1.868a1.415,1.415,0,0,0-.811-.79,4.643,4.643,0,0,0-2.018.251c-.35.161-.809.118-1.1.347-.113.759-.277,1.513-.389,2.273A1.344,1.344,0,0,0,221.55,822.786Z" transform="translate(-193.169 -716.731)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M280.58,845.167a3.916,3.916,0,0,0-2.341.312,5.232,5.232,0,0,0-1.969,1.018c-.007.122-.014.245-.02.369.669.157,1.35.269,2,.485-.708.112-1.425-.009-2.134.08.315.891,1.193,1.317,1.858,1.9a1.969,1.969,0,0,0,2,.6,9.45,9.45,0,0,0,2.074-2.009,6.29,6.29,0,0,0-.457-1.138c-.254-.582-.4-1.318-1.019-1.626Z" transform="translate(-241.777 -740.007)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M261.98,855.121c-.341-.082-.531.214-.713.443a.72.72,0,0,0,.847.83C262.8,856.289,262.729,855.013,261.98,855.121Z" transform="translate(-228.766 -748.779)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M722.627,855.332a7.6,7.6,0,0,0-1.723-.872c-.267.251-.53.507-.8.75-.286.281-.673.612-.573,1.062a3.93,3.93,0,0,0,.786,1.268,2.566,2.566,0,0,0,1.215.959,4.276,4.276,0,0,0-.216-1.555,1.328,1.328,0,0,1,.143.035c.117.435.287.855.412,1.29.73-.3.623-1.258,1-1.843-.009-.371.107-.837-.24-1.093Z" transform="translate(-630.017 -748.212)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M226.418,861.611c.024.749.3,1.464.29,2.217-.274-.626-.537-1.256-.807-1.883a3.507,3.507,0,0,0-.582.449c0-.274,0-.545-.007-.816-.77.113-1.3.762-2.037.978.448-.461.93-.884,1.388-1.333.137-.093.01-.267-.1-.317a4.05,4.05,0,0,0-1.672-.027,7.07,7.07,0,0,0-2.061.408,1.3,1.3,0,0,0-.634,1.019c-.058.86,0,1.72,0,2.581a20.17,20.17,0,0,1,2.278.943c.79.185,1.361-.488,1.739-1.078.281-.4.383-.906.746-1.244.022.87-.59,1.794-.053,2.611.6.935,1.853.9,2.763,1.358l.275.011a9.786,9.786,0,0,1,1.18-1.355,1.824,1.824,0,0,0,.571-1.066c.066-.785-.591-1.351-1.06-1.889-.672-.595-1.25-1.479-2.217-1.565Z" transform="translate(-192.789 -753.765)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M745.757,867.074a5.246,5.246,0,0,1-.651-.333c-.423-.265-.9-.642-1.424-.432a4.79,4.79,0,0,0-1.256,1.5,1.836,1.836,0,0,0-.326,1.025,5.321,5.321,0,0,0,1.317-.509l.111-.005c-.328.286-.7.513-1.047.777-.05.341.413.3.627.409a15.567,15.567,0,0,0,1.72-.019.936.936,0,0,0,.726-.756,8.238,8.238,0,0,0,.2-1.653Z" transform="translate(-649.796 -758.533)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M8.576,881.51a17.386,17.386,0,0,0,1.205-1.765,8.805,8.805,0,0,0,.85-4.2,9.534,9.534,0,0,0-5.2-7.622A13.468,13.468,0,0,0,0,866.53v1.22a8.216,8.216,0,0,1,5.493,1.55A7.969,7.969,0,0,1,8.6,873.748a6.882,6.882,0,0,1,.164,2.3,7.86,7.86,0,0,1-.92,2.779,5.916,5.916,0,0,1-3.881,2.525A5.039,5.039,0,0,1,0,880.384v1.743a6.974,6.974,0,0,0,3.485,1.306,6.447,6.447,0,0,0,5.091-1.923Z" transform="translate(-0.003 -758.781)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M703.693,880.607a1.172,1.172,0,0,0-.615,1.272,17.091,17.091,0,0,0,.97,1.562l.28-.047c.561-.156,1.228-.09,1.693-.488.383-.406.235-1.013.218-1.511a5.055,5.055,0,0,0-.409-1.6l-.254.016c-.185.4-.363.8-.544,1.194a7.071,7.071,0,0,1,.2-1.332l-.359.024c.042-.091.126-.274.167-.366l.075-.192q-.479-.058-.948-.157c.311-.057.625-.114.935-.183l-.184-.28a3.238,3.238,0,0,0-.643-.521c-.593-.253-1.143-.862-1.842-.639a4.242,4.242,0,0,0-1.157,1.254c-.063.144-.2.315-.1.475.2.4.449.781.653,1.183a.95.95,0,0,0,.988.373,8.553,8.553,0,0,0,1.957-.966l.189.106c-.573-.048-.842.549-1.27.821Z" transform="translate(-613.932 -768.223)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M735.367,888.3a1.547,1.547,0,0,0,0,.679l.28.162c.146-.051.292-.1.442-.146a1.807,1.807,0,0,0,0-.708A1.378,1.378,0,0,0,735.367,888.3Z" transform="translate(-643.868 -777.796)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M742.381,896.854c.284-.011.567,0,.851,0q.631-.132,1.263-.254a5.968,5.968,0,0,0,.276-2.051,1.417,1.417,0,0,0-.8-.585,5.2,5.2,0,0,0-2.147-.457l-.035.24c.312.332.593.694.873,1.056-.458-.216-.755-.683-1.239-.837a2.834,2.834,0,0,0,.113,1.2,3.017,3.017,0,0,0,.842,1.685Z" transform="translate(-649.19 -782.397)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M2.33,932.439A2.892,2.892,0,0,0,3.676,930.1a2.87,2.87,0,0,0-1.335-2.444A3.333,3.333,0,0,0,0,927.329v5.689A3.487,3.487,0,0,0,2.33,932.439Z" transform="translate(-0.003 -811.962)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M578.776,1000.8c-.693-.772-1.79-.927-2.662-1.42-.54.547-1.162,1-1.692,1.561a1.482,1.482,0,0,0-.2,1.7,13.143,13.143,0,0,0,1.739,2.213,3.3,3.3,0,0,0,1,.571c.124-.795-.162-1.572-.1-2.366.267.694.445,1.419.743,2.1a3.015,3.015,0,0,0,1.006-1.758C578.838,1002.573,579.379,1001.594,578.776,1000.8Z" transform="translate(-502.648 -875.106)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M546.367,1034.555c-.332.485-.678.959-1.027,1.432,0,.177.157.3.236.455.456.661.692,1.5,1.355,2,.527.374,1.18.1,1.709-.121.979-.5,2.2-.84,2.745-1.884a3.386,3.386,0,0,0-1.23-.178q-.131-.131-.261-.258a9.581,9.581,0,0,0,1.03-.147l.357-.085a3.066,3.066,0,0,0-1.158-1.2,8.936,8.936,0,0,0-2.21-1.019C547.238,1033.506,546.747,1034.075,546.367,1034.555Z" transform="translate(-477.51 -905.029)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M596.759,1050.519a.785.785,0,0,0,1.069.2.76.76,0,0,0-.117-1.06C597.218,1049.185,596.326,1049.983,596.759,1050.519Z" transform="translate(-522.433 -919.003)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M570.748,1067.8c.777-.269,1.616-.262,2.4-.512a1.4,1.4,0,0,0,.852-.907,11.515,11.515,0,0,0-.328-3.275c-.113-.3-.2-.815-.592-.823a18.009,18.009,0,0,0-1,1.93,16.829,16.829,0,0,1,.407-2.095c-.9-.031-1.481.716-2.132,1.212-.485.444-1.192.884-1.154,1.631-.055.687.447,1.223.79,1.765.249.359.5.72.758,1.075Z" transform="translate(-498.399 -930.035)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M120.672,138.395a14.448,14.448,0,0,0-7.19-2.684,23.889,23.889,0,0,0-3.53.093,16.945,16.945,0,0,0-3.248.76,14.307,14.307,0,0,0-3.827,2.021,15.2,15.2,0,0,0-3.955,4.391,13.537,13.537,0,0,0-1.012,2.143,12.452,12.452,0,0,0,2.863,12.957,11.219,11.219,0,0,0,2.615,1.985,10.13,10.13,0,0,0,8.788.57,10.248,10.248,0,0,0,5.2-4.743,8.411,8.411,0,0,0,.749-2.559,8.274,8.274,0,0,0-2.972-7.518,6.783,6.783,0,0,0-5.939-1.4,7.853,7.853,0,0,0-1.486.546,6.136,6.136,0,0,0-3.387,4.76,5.277,5.277,0,0,0,1.519,4.234,5,5,0,0,0,2.686,1.333,4.908,4.908,0,0,0,2.025-.215,3.437,3.437,0,0,0,2.014-2.077,3.393,3.393,0,0,0-1.648-4.1,3.356,3.356,0,0,0-4.676,1.734c-.051.21-.1.425-.152.638a.511.511,0,0,1-.2-.418,3.485,3.485,0,0,1,.489-2.168,4.837,4.837,0,0,1,5.2-2.37,5.415,5.415,0,0,1,3.288,2.311,6.121,6.121,0,0,1,.694,5.689,7.143,7.143,0,0,1-2.075,2.807,7.815,7.815,0,0,1-6.8,1.68,8.538,8.538,0,0,1-4.048-2.266,10.165,10.165,0,0,1-3.033-7.936,10.355,10.355,0,0,1,2.486-5.973,12.184,12.184,0,0,1,5.013-3.689,11.048,11.048,0,0,1,2.331-.7,12.857,12.857,0,0,1,9.073,1.443,16.573,16.573,0,0,1,7.367,18.976,17.886,17.886,0,0,1-3.988,6.879,20.3,20.3,0,0,1-2.2,2.086,17.155,17.155,0,0,1-2.806,1.874,13.176,13.176,0,0,1-2.482,1.2,23.4,23.4,0,0,1-17.983-.729c-.428-.187-.853-.383-1.266-.6a33.173,33.173,0,0,1-5.775-3.8,31.493,31.493,0,0,1-5-5.137,33.164,33.164,0,0,1-4.638-8.289,42.394,42.394,0,0,1-2.865-15.622c1.086.271,2.151-.226,3.23-.294-.024-1.025.662-1.965.412-3a1.792,1.792,0,0,0-1.035-.886,11.292,11.292,0,0,0-2.416-.73l-.085-.261c.791.006,1.583.04,2.375.02a1.414,1.414,0,0,0,1.365-1.174c.277.465.361,1.014.6,1.5a15.932,15.932,0,0,0,3.775,5.545,16.325,16.325,0,0,0,2.715,2.03c.244.152.491.3.746.433a13.841,13.841,0,0,0,3.989,1.337c.777.139,1.562-.058,2.345.026a7.463,7.463,0,0,0,2.97-.439,10.273,10.273,0,0,0,4.428-2.9,10.74,10.74,0,0,0,.718-.912c.071-.106.142-.209.214-.311a16.4,16.4,0,0,0,2.963-.193c.764-.119,1.506-.34,2.261-.5a17.76,17.76,0,0,0,10.743-8.484,15.475,15.475,0,0,0,1.933-7.7,11.231,11.231,0,0,0-13.6-11.2,11.168,11.168,0,0,0-3.011,1.25,11.616,11.616,0,0,0-4.06,4.192,9.058,9.058,0,0,0-.711,7.313,7.6,7.6,0,0,0,1.81,2.83,8.174,8.174,0,0,0,6.136,2.254,7.38,7.38,0,0,0,2.5-.93,5.845,5.845,0,0,0,2.735-3.592,4.987,4.987,0,0,0-.707-3.811,3.285,3.285,0,0,0-4.964-.221,2.253,2.253,0,0,0-.623,1.664c.155.248.459.182.708.213a2.232,2.232,0,0,1,2.474-1.357A2.657,2.657,0,0,1,111.578,120a3.439,3.439,0,0,1-.592,3.254,5.588,5.588,0,0,1-5.794,2.123,5.875,5.875,0,0,1-2.668-1.636,7.945,7.945,0,0,1-2.108-5.616,7.393,7.393,0,0,1,1.343-4.254,9.413,9.413,0,0,1,4.275-3.475,7.52,7.52,0,0,1,3.3-.582,7.212,7.212,0,0,1,3.693.872,8.922,8.922,0,0,1,4.549,5.444,10.738,10.738,0,0,1-.307,6.85,16.216,16.216,0,0,1-9.427,9.522,20.187,20.187,0,0,1-2.679.75l-.639.04a8.755,8.755,0,0,0-3.719-8.8,6.866,6.866,0,0,0-3.162-1.193,14.479,14.479,0,0,0-2.142.026c-.146.04-.289.081-.432.122a7.837,7.837,0,0,0-2.531,1.174,10.243,10.243,0,0,0-1.286,1.279l-.352-.03c-.2-.091-.391-.183-.583-.27a6.843,6.843,0,0,1-2.294-1.531,6.309,6.309,0,0,1-1.569-2.817A26.081,26.081,0,0,1,85,111.785a35.719,35.719,0,0,1,.408-5.341,79.582,79.582,0,0,1,2.421-11c.245.953.363,1.937.624,2.889a17.608,17.608,0,0,0,1.886,4.616,13.665,13.665,0,0,0,2.44,2.972,10.491,10.491,0,0,0,3.259,1.943,8.1,8.1,0,0,0,1.462.372,18.747,18.747,0,0,1,2.259.029,8.132,8.132,0,0,0,4.164-1.581,8.427,8.427,0,0,0,2.855-9.318,6.2,6.2,0,0,0-3.137-3.638,7.175,7.175,0,0,0-2.223-.5,5.019,5.019,0,0,1,2.866.342,6.577,6.577,0,0,1,4.118,5.258,3.767,3.767,0,0,0-.873,2.136c-.08,1.108.575,2.057.917,3.067q.1-.028.209-.049a2,2,0,0,1,.388-1.049,10.564,10.564,0,0,0,1.059-2.006,2.679,2.679,0,0,0-.693-2.571c-.03.456.009.915-.027,1.373a6.486,6.486,0,0,1-.509,1.643l-.071.037a5.376,5.376,0,0,0,.353-1.81,2.062,2.062,0,0,0-.474-1.513,8.607,8.607,0,0,0-1.821-3.548,6.279,6.279,0,0,0-3.339-1.9A7.984,7.984,0,0,0,99.585,93a10.9,10.9,0,0,0-1.327.647A13.121,13.121,0,0,0,96.3,95.34a6.373,6.373,0,0,0-1.815,3.275,5.3,5.3,0,0,0,1.072,4.484A4.349,4.349,0,0,0,97,104.226a5.105,5.105,0,0,0,2.912.384,5.676,5.676,0,0,0,1.342-.546,3.071,3.071,0,0,0,1.3-3.963,2.348,2.348,0,0,0-2.044-1.218,1.911,1.911,0,0,0-1.372.563,2.4,2.4,0,0,0-.57,1.26,3.634,3.634,0,0,0,.536,2.061,2.794,2.794,0,0,1-1.784-.619,3.508,3.508,0,0,1-1.3-3.372,4.748,4.748,0,0,1,2.129-3.288,5.6,5.6,0,0,1,5.1-.47,4.754,4.754,0,0,1,2.9,3.584,6.369,6.369,0,0,1-.263,2.9,6.926,6.926,0,0,1-4.126,4.142,7.871,7.871,0,0,1-4.525.345,7.78,7.78,0,0,1-2.417-1.085,10.841,10.841,0,0,1-3.238-3.616,20.3,20.3,0,0,1-1.755-4.242,46.114,46.114,0,0,1-1.372-5.886,11.338,11.338,0,0,0-.189-1.5,18.931,18.931,0,0,1-.343-3.246,16.189,16.189,0,0,1,.056-2.127,35.022,35.022,0,0,1,.291-4.494c.6.535,1.121,1.149,1.734,1.669a18.812,18.812,0,0,0,1.857,1.382,1.325,1.325,0,0,1,.475.425,12.107,12.107,0,0,1,.678,1.641,6.656,6.656,0,0,1,.29,3.1,14.991,14.991,0,0,0-.607-2.985,2.574,2.574,0,0,0-.937-1.1c-.01.9-.42,1.723-.5,2.61a4.877,4.877,0,0,0,1.17,3.182c.5.527,1.008,1.046,1.458,1.618l.19,0a8.78,8.78,0,0,1,.371-2.911,4.138,4.138,0,0,0-.328-3.227c-.346-.646-1.137-.959-1.28-1.723a13.389,13.389,0,0,0,3.293,1.281,12.857,12.857,0,0,0,6.127-.016c.483-.095.954-.393,1.457-.246a15.034,15.034,0,0,0,4.934.336,15.991,15.991,0,0,0,3.536-.658c.643-.178,1.253-.466,1.912-.591.321-.147.646-.29.968-.435l.219-.095c-.02.111-.062.332-.082.443a4.26,4.26,0,0,0,3.668-.731c1.254-1.027,1.8-2.627,2.87-3.811.163-.2.318-.412.484-.614a21.674,21.674,0,0,0-4.247.438,5.109,5.109,0,0,0-2.031,1.45,22,22,0,0,1-1.621,2.368c.315.052.628.114.942.184l.076.018c0-.056.007-.108.01-.148,1.407-.2,2.417-1.291,3.533-2.056a8.47,8.47,0,0,1-3.571,2.656c.007-.109.019-.294.029-.445l0,0h0c-1.007.153-1.891.731-2.884.957a20.234,20.234,0,0,1-2.965.587c-.92.047-1.842.047-2.761.024a1.922,1.922,0,0,1-1.035-.187c.364-.082.728-.174,1.083-.292a20.264,20.264,0,0,0,5.616-2.352,16.844,16.844,0,0,0,4.033-3.326,6.756,6.756,0,0,0,1.708-3.351,3.5,3.5,0,0,0-.769-2.968,2.641,2.641,0,0,0-2.066-1,2.354,2.354,0,0,0-1.633.546l-.111.076-.188.127a9.819,9.819,0,0,0-3.254-7.311,11.969,11.969,0,0,0-4.645-2.57c-.67-.162-1.343-.322-2.026-.418l-.272-.021a13.684,13.684,0,0,0-3.648.128,12.819,12.819,0,0,0-3,.925A10.643,10.643,0,0,0,93.7,64.287a8.955,8.955,0,0,0-2.863,6.2A7.9,7.9,0,0,0,92.9,76.082a6.331,6.331,0,0,0,3.59,1.927,7.169,7.169,0,0,0,4.55-1.016,5.8,5.8,0,0,0,2.717-4.137,3.773,3.773,0,0,0-2.465-4.045,3.613,3.613,0,0,0-1.774.131A2.95,2.95,0,0,0,98,70.478a3.312,3.312,0,0,0-.157,1.771,4.35,4.35,0,0,0,.644,1.161,3.791,3.791,0,0,0,3.423,1.111,4.9,4.9,0,0,1-5.156,1.241,5.516,5.516,0,0,1-3.708-3.638,6.753,6.753,0,0,1,.209-4.763,8.1,8.1,0,0,1,3.883-4.075,7.413,7.413,0,0,1,2.078-.694,9.333,9.333,0,0,1,6.706,1.22,9.686,9.686,0,0,1,4.356,9.542,10.491,10.491,0,0,1-4.794,7.352,11.2,11.2,0,0,1-3.215,1.376,8.819,8.819,0,0,1-1.893.308,13.435,13.435,0,0,1-3.973-.3,13.771,13.771,0,0,1-4.2-1.743,16.41,16.41,0,0,1-3.178-2.53,12.56,12.56,0,0,1-2.087-2.571,9.865,9.865,0,0,1-1.2-1.809,21.2,21.2,0,0,1-2.194-6.56,7.1,7.1,0,0,1-.22-1.6,11.419,11.419,0,0,0,2.005,3.438c.253.4.263.913.562,1.292a3.043,3.043,0,0,0,2.075,1.274,10.209,10.209,0,0,1,1.791.384c.215.076.425.173.637.262a14.48,14.48,0,0,0-.644-1.476,3.712,3.712,0,0,0-1.667-1.837,3.549,3.549,0,0,0-.6-.313,6.171,6.171,0,0,1-1.641-.253c-.095.091-.189.183-.282.276-.351-.634-.772-1.229-1.1-1.877a15.732,15.732,0,0,1-1.382-4.009,8.662,8.662,0,0,0,2.967,1.391,9.829,9.829,0,0,0,2.55.129A6.635,6.635,0,0,0,91.1,62.841a7.355,7.355,0,0,0,2.093-2.508,5.878,5.878,0,0,0,.545-3.873A4.273,4.273,0,0,0,90.56,53.3a3.311,3.311,0,0,0-2.7.784A3.41,3.41,0,0,0,86.84,57.15a2.688,2.688,0,0,0,2.749,1.828,2.133,2.133,0,0,0,1.789-1.239,2.528,2.528,0,0,0-1.231-3.278,2.621,2.621,0,0,0-2.108.367,2.456,2.456,0,0,1,2.759-.781,3.559,3.559,0,0,1,1.925,1.58,4.087,4.087,0,0,1,.338,3.1,6.451,6.451,0,0,1-2.888,3.682,4.43,4.43,0,0,1-2.985.633,5.559,5.559,0,0,1-3.254-2.115,7.149,7.149,0,0,1-1.409-4.373,22.275,22.275,0,0,1,.84-6.109,48.729,48.729,0,0,1,1.611-5.631c.511-1.379,1.032-2.754,1.587-4.116a24.661,24.661,0,0,0,2.024-6.911,33.006,33.006,0,0,0-.606-9.2,40.183,40.183,0,0,0-2.337-7.574,13.855,13.855,0,0,1,.822,1.386A37.82,37.82,0,0,1,90.88,33.17a22.842,22.842,0,0,1,.112,2.658c-.262.3-.475.633-.729.938-.6.711-1.333,1.3-1.906,2.04a8.022,8.022,0,0,0-1.371,2.656A9.6,9.6,0,0,0,86.623,44c-.07,2.156.943,4.145,1.142,6.268l.388.035a11.733,11.733,0,0,1,2.673-3.756,19.482,19.482,0,0,0,2.306-3.029,6.607,6.607,0,0,0,.646-4.859,9.719,9.719,0,0,0-.694-1.924.8.8,0,0,0-.468-.2,17.714,17.714,0,0,1-.856,3.982,30.962,30.962,0,0,1-1.724,3.335c-.116.114-.229.23-.34.346a16.321,16.321,0,0,0,2.057-6.379,24.448,24.448,0,0,1-.158-3.079,36.64,36.64,0,0,0-1.616-9.626A37.94,37.94,0,0,0,87.2,18.4c-.206-.377-.415-.753-.616-1.133a57.575,57.575,0,0,0,3.987,4.24c.638.667,1.367,1.234,2.037,1.867a17.068,17.068,0,0,1,2.412,2.187A13.62,13.62,0,0,0,99,27.352a14.262,14.262,0,0,1-2.6-.588,9.12,9.12,0,0,1-2.023-1.088c-.174-.106-.359-.2-.541-.287a4.068,4.068,0,0,0,1.127,2.147,5.617,5.617,0,0,0,1.6,1.04c1.628.587,3.378.188,5.056.4.489.05.962.2,1.445.281a2.508,2.508,0,0,0-.547-.845c-.376-.475-.682-1-1.035-1.49a6.365,6.365,0,0,0-3.54-2.547c-1.08-.264-2.2.04-3.28-.16-1.265-1.02-2.5-2.074-3.693-3.183-.937-.914-1.877-1.828-2.751-2.8a50.555,50.555,0,0,1-4.245-5.364A27.2,27.2,0,0,1,81.994,9.68a35.278,35.278,0,0,0,7.121,7.943,25.632,25.632,0,0,0,2.871,2.008,24.409,24.409,0,0,0,3.86,1.866,20.565,20.565,0,0,0,3.687.935c.313.036.627.085.943.111a9.878,9.878,0,0,0,1.272-.027,11.61,11.61,0,0,0,5.285-1.032,14.6,14.6,0,0,0,5.342-3.9,13.27,13.27,0,0,0,3.066-6.177,10.33,10.33,0,0,0-.256-5.118,9.274,9.274,0,0,0-3.733-4.8,1.146,1.146,0,0,1-.652-.476,17.176,17.176,0,0,0,2.947-.192c.588-.062,1.16-.239,1.754-.274.619-.152,1.218-.373,1.82-.582H101.27a10.335,10.335,0,0,0-3.238,1.891A8.088,8.088,0,0,0,95.195,7.8a7.372,7.372,0,0,0,2.786,5.9,6.41,6.41,0,0,0,2.51,1.129,4.818,4.818,0,0,0,4.214-.968,2.823,2.823,0,0,0,.713-2.965,2.612,2.612,0,0,0-1.527-1.419,4.937,4.937,0,0,0-1.142.01,1.789,1.789,0,0,0-1.284,1.106,2.674,2.674,0,0,0,.172,2.167,7.128,7.128,0,0,0,.881,1.1,6.871,6.871,0,0,1-3.194-1.524A6.386,6.386,0,0,1,97.031,7.3,6.386,6.386,0,0,1,99.01,2.644a7.648,7.648,0,0,1,3.521-2A9.675,9.675,0,0,1,105.1.491a7.582,7.582,0,0,1,2.765.721,10.047,10.047,0,0,1,5.9,8.7,9.761,9.761,0,0,1-1.119,4.947,12.231,12.231,0,0,1-4.927,5.02,12.577,12.577,0,0,1-4.177,1.458,14.574,14.574,0,0,1-5.031.01c-.465-.078-.924-.187-1.381-.3a15.434,15.434,0,0,1-3.608-1.484,15.822,15.822,0,0,1-1.986-1.309,22.251,22.251,0,0,1-2.561-2.315c-.632-.616-1.188-1.3-1.766-1.965a65.6,65.6,0,0,1-4.728-6.79A52.081,52.081,0,0,1,78.811-.04h-1.9c.284,1.689.389,3.4.506,5.1a29.114,29.114,0,0,1-.489,7.446,10.076,10.076,0,0,1-3.006,5.26,7.361,7.361,0,0,1-5.966,1.687,6.51,6.51,0,0,1-5.824-5.942A5.039,5.039,0,0,1,67.47,8.564,4.7,4.7,0,0,1,71.551,10.6a3.82,3.82,0,0,1,.632,3.184,3,3,0,0,1-2.019,2.187,9.573,9.573,0,0,0,.016-1.657,2.31,2.31,0,0,0-1.234-1.571,2.534,2.534,0,0,0-1.208-.165,2.56,2.56,0,0,0-1.76,2.178,3.068,3.068,0,0,0,1.73,2.846,4.487,4.487,0,0,0,5.622-1.768,5,5,0,0,0,.423-4.152A6.4,6.4,0,0,0,70.146,7.8a7.474,7.474,0,0,0-4.46-1.041A7.123,7.123,0,0,0,62.338,7.93,7.107,7.107,0,0,0,59.7,14.87a5.435,5.435,0,0,0,.162,1.47c.129.34.277.672.379,1.021a3.875,3.875,0,0,1-.887-2.052l-.213,0A2.963,2.963,0,0,0,59.2,17.64c.551,1.119,1.8,1.637,2.384,2.73l.149.083c.03-.852.3-1.682.249-2.537a3.884,3.884,0,0,0-.568-1.571c-.419-.51-.991-.864-1.4-1.386a16.138,16.138,0,0,1,.009-1.916,6.772,6.772,0,0,1,1.7-3.683A6.424,6.424,0,0,1,65.2,7.4l.177.025A6.363,6.363,0,0,0,63.3,8.514a6.014,6.014,0,0,0-2.01,3.7A8.4,8.4,0,0,0,61.648,16a7.116,7.116,0,0,0,.9,1.831,8.29,8.29,0,0,0,4.836,3.551,9.04,9.04,0,0,0,5.949-.67A9.613,9.613,0,0,0,77.5,16.489a14.361,14.361,0,0,0,1.586-6.081,24.969,24.969,0,0,0-.177-4.468c1.5,2.448,2.974,4.921,4.266,7.488.731,1.433,1.406,2.894,2.011,4.385a35.617,35.617,0,0,1,2.161,7.524,24.462,24.462,0,0,1,.075,7.336,6.488,6.488,0,0,1-2.785,3.776l.039.06a8.49,8.49,0,0,1-2.763,1.149,6.769,6.769,0,0,1-3.686-.265c-.225-.132-.337.109-.346.289.106.067.211.134.318.2a11.468,11.468,0,0,0,2.4.43,7.848,7.848,0,0,0,4.222-1.189c.52-.3.907-.784,1.432-1.081a11.745,11.745,0,0,1-3.88,4.111c-.369.28-.831.006-1.234-.031a4.53,4.53,0,0,0-3.5.535c-1.019.6-1.652,1.639-2.593,2.33.012.075.026.151.042.226,1.314-.214,2.588.28,3.9.261a3.672,3.672,0,0,0,2.209-.394,2.954,2.954,0,0,0,1.516-1.809c-.572.216-1.115.505-1.7.674a6.325,6.325,0,0,1-2.4.2,7.633,7.633,0,0,0,3.607-1.138A11.761,11.761,0,0,0,85.947,37.6l.2-.007c-.34.662-.66,1.333-1.03,1.979a16.248,16.248,0,0,1-9.628,7.451,13.084,13.084,0,0,1-4.095.558,13.342,13.342,0,0,1-5.676-1.02,16.085,16.085,0,0,1-7.272-5.548,10.817,10.817,0,0,1-2.176-6.1,8.9,8.9,0,0,1,2.33-6.324,8.115,8.115,0,0,1,5.015-2.713,9.022,9.022,0,0,1,5.315.843,8.771,8.771,0,0,1,3.835,3.6,8.092,8.092,0,0,1,.745,5.444,6.578,6.578,0,0,1-2.6,4.122,5.812,5.812,0,0,1-4,.748,5.19,5.19,0,0,1-3.377-2.217,3.25,3.25,0,0,1-.328-2.52,2.392,2.392,0,0,1,1.082-1.478,2.512,2.512,0,0,1,1.765-.141c.417.093.67.455,1,.688.159,0,.321-.011.483-.021.06-.139.119-.279.182-.415a2.9,2.9,0,0,0-1.236-1.425,3.615,3.615,0,0,0-2.857-.1A2.839,2.839,0,0,0,62.2,34.192a4.524,4.524,0,0,0-.46,2.83A4.792,4.792,0,0,0,63.291,39.9a6.48,6.48,0,0,0,3.692,1.684,6.727,6.727,0,0,0,2.673-.331A8.282,8.282,0,0,0,74,37.376a7.689,7.689,0,0,0,.469-5.83A9.878,9.878,0,0,0,70.6,26.371a12.166,12.166,0,0,0-3.622-1.678,11.425,11.425,0,0,0-4.166-.236,11.27,11.27,0,0,0-9.3,9.254l-.144.026a32.041,32.041,0,0,0-4.108-4.666,11.414,11.414,0,0,1-.822-1.139c-.178-.249-.471-.374-.667-.606-1.616-1.993-3.291-3.938-5.039-5.816a11.79,11.79,0,0,0-1.19-1.264.728.728,0,0,0-.33.525c.561.581,1.078,1.2,1.622,1.8A90.209,90.209,0,0,1,49.608,31a42.86,42.86,0,0,1,3.722,6.458c.384.764.455,1.632.77,2.422.249.812.734,1.536.912,2.371a18.738,18.738,0,0,1,.638,5.483,7.906,7.906,0,0,1-1.639,3.329,3.9,3.9,0,0,0-1.267-.551c-.643-.148-1.309-.078-1.955-.2a17.525,17.525,0,0,0-2.882.246c-.313.114-.714.272-.733.659.94.573,1.814,1.25,2.751,1.828-.006.012-.021.037-.029.05-1.047-.336-2.031-.846-3.095-1.133q0,.4.011.8c-.037.06-.109.18-.146.241a1.242,1.242,0,0,0-.971-.785c-.292,1.076-.565,2.157-.852,3.234-.073-1.106.046-2.214,0-3.32a5.268,5.268,0,0,0-1.241.613c-.073-.633.611-.966.664-1.572l-.673-.152c-.045-.192-.091-.384-.136-.576l.573-.182a2.97,2.97,0,0,0-1.039-1.22c0-.07,0-.208-.006-.276a2.28,2.28,0,0,0,1.734.612c-.224-1.137-.629-2.238-.764-3.39.425.978.986,1.888,1.414,2.863.348-.049.549-.366.711-.643a12.97,12.97,0,0,0,.662-3c.164-.966.3-2.187-.55-2.883-1.11-.8-2.529-.882-3.788-1.332-.136-.026-.271-.05-.406-.071a29.928,29.928,0,0,1-2.035,2.623,3.243,3.243,0,0,0-.444,1.2c-.534-.3-1.06-.609-1.592-.909a5.086,5.086,0,0,0,1.039-1.416,4.52,4.52,0,0,0,.315-2.035c.031-1.377-.355-2.758,0-4.122a1.355,1.355,0,0,0-.549.33c-.44.419-.947.758-1.4,1.164a5.146,5.146,0,0,0-1.923,5.09c-.083.078-.168.154-.254.229l-.359-.044A5.1,5.1,0,0,0,33.4,42.9a12.134,12.134,0,0,0,.485-1.842A9.226,9.226,0,0,0,33.9,36.23a4.7,4.7,0,0,0-1.307-2.074,4.14,4.14,0,0,0-1.937-.8,3.588,3.588,0,0,0-.878-2.608,4.081,4.081,0,0,0-.384-.333,4.9,4.9,0,0,0-1.422-.622,3.633,3.633,0,0,0-2.464.649,3.334,3.334,0,0,0-1.243,2.317c-.672-.306-1.373-.532-2.059-.8a5.374,5.374,0,0,0-.776-.2c-1.031-.021-2.067.011-3.1-.022-.363-.6-.888-1.277-1.671-1.249a1.984,1.984,0,0,0-2.061,1.52,6.655,6.655,0,0,1-.041.918c-.362.282-.8.437-1.187.685a13.084,13.084,0,0,0-4.32,4.26,20.762,20.762,0,0,0-.94,1.9,10.35,10.35,0,0,0-.534,4.457,8.527,8.527,0,0,0,.853,3A8.27,8.27,0,0,0,12.8,51.186a6.45,6.45,0,0,0,4.765-.01,4.9,4.9,0,0,0,1.413-.872,6.626,6.626,0,0,0,2.337-3.377,5.379,5.379,0,0,0-.954-5.138,4.84,4.84,0,0,0-1.419-1.055,3.689,3.689,0,0,0-3.27.407,2.935,2.935,0,0,0-.816,2.985,2.625,2.625,0,0,0,.991,1.432,3.379,3.379,0,0,0,2.547.469,4.669,4.669,0,0,0,1.968-1.183,4.455,4.455,0,0,1-2.509,3.71,5.126,5.126,0,0,1-2.428.746,5.386,5.386,0,0,1-2.112-.24A7.492,7.492,0,0,1,11.087,47.7,6.925,6.925,0,0,1,9,43.627a8.514,8.514,0,0,1,1.343-5.837,10.369,10.369,0,0,1,2.312-2.275,9.253,9.253,0,0,1,2.778-1.306,4.544,4.544,0,0,0,1.479.152c.414-.053.718-.391,1.116-.485a3.717,3.717,0,0,1,.966.081c.036.281.065.565.1.847A2.315,2.315,0,0,0,21.952,36.5a2.818,2.818,0,0,0,1.422-.923,10.323,10.323,0,0,1,2.939,3.238,10.067,10.067,0,0,1,1.311,5.679c-.332.372-.786.611-1.151.95a11.781,11.781,0,0,0-2.505,2.982,12.826,12.826,0,0,0-1.333,3.506c-.1.414-.01.884-.241,1.259a11.456,11.456,0,0,1-3.253,1.571c-.4.141-.817.2-1.223.307a11.936,11.936,0,0,1-3.37.338,16.221,16.221,0,0,1-2.885-.194A19.47,19.47,0,0,1,4.7,52.592,27.548,27.548,0,0,1,.254,49.06C.223,49,.163,48.893.132,48.837c.447.152.84.42,1.27.606a13.99,13.99,0,0,0,2.939.927l.053.015a.743.743,0,0,0-.408.583c.025-.063.073-.189.1-.251l.01.007a2.352,2.352,0,0,0,1.873.934c1.408.06,2.455-1.117,3.806-1.3,0-.045,0-.137,0-.183-.95-.347-1.764-1.071-2.807-1.137a3.632,3.632,0,0,0-2.5.812A11.677,11.677,0,0,1,0,48.06v2.362c1.1.774,2.075,1.719,3.208,2.454A22.061,22.061,0,0,0,5.23,54.271a17.36,17.36,0,0,0,3.831,1.873c.409.248.54.741.769,1.132a20.953,20.953,0,0,1,1.754,4.354,12.1,12.1,0,0,1-.1,7.6,9.89,9.89,0,0,1-3.8,4.582,7.742,7.742,0,0,1-1.248.582,6.28,6.28,0,0,1-3.335.342A7.6,7.6,0,0,1,0,73.149v2.062a7.843,7.843,0,0,0,4.358,1.316,8.347,8.347,0,0,0,6.631-3.786A10.953,10.953,0,0,0,12.9,65.887a17.512,17.512,0,0,0-.593-3.96,8.953,8.953,0,0,0-.53-1.675,1.134,1.134,0,0,1-.093-.547c.223.422.459.836.675,1.261a28.725,28.725,0,0,1,2.769,7.652c.2.812.27,1.648.452,2.463-.022.16-.045.321-.068.483-.463-.586-1.246-.3-1.872-.259a3.1,3.1,0,0,0-.393,1.53,3.065,3.065,0,0,0,.387.5q.121.16.239.325a1.215,1.215,0,0,0-.724.245,4.084,4.084,0,0,0-.516,1.712c.5.346,1.019,1.01,1.7.739a8.1,8.1,0,0,0,.942-1.126c-.022.524-.5.942-.383,1.476A2.1,2.1,0,0,0,16.3,77.7a8.186,8.186,0,0,0,1.18-.878,4.993,4.993,0,0,0,.134-.673,1.012,1.012,0,0,0,1.182-.3,7.993,7.993,0,0,1,.7-.6c-.147-.573-.1-1.343-.685-1.68-.276-.061-.556-.1-.835-.149l.03-.206a1.159,1.159,0,0,0,.459-.6,3.6,3.6,0,0,0-.3-1.106c-.081-.127-.093-.347-.266-.381a2.611,2.611,0,0,0-1.628.085c-.017.1-.051.291-.068.388-.077-.078-.153-.157-.23-.233a22.768,22.768,0,0,0-.582-3.837,28.046,28.046,0,0,0-2.361-6.615c-.432-.959-1.068-1.8-1.544-2.736a31.609,31.609,0,0,1,1.985,2.584,60.162,60.162,0,0,1,9.059,18.418,29.57,29.57,0,0,1,1.433,8.346A15.407,15.407,0,0,1,22.613,94.2a14.565,14.565,0,0,1-4.554,5.791,20.416,20.416,0,0,1-3.136,1.765c-.556-.133-.711-.815-1.2-1.075A3.655,3.655,0,0,0,8.6,102.272l-.555.025A9.862,9.862,0,0,1,3.519,99.92,9.412,9.412,0,0,1,.57,94.98a10.239,10.239,0,0,1,.4-6.109,7.6,7.6,0,0,1,4.849-4.489A7.792,7.792,0,0,1,8.828,84.1a6.5,6.5,0,0,1,3.841,1.816,6.52,6.52,0,0,1,1.851,4.6,6.411,6.411,0,0,1-.72,3.243,3.859,3.859,0,0,0-.308-1.453,2.588,2.588,0,0,0-1.929-1.493A2.086,2.086,0,0,0,9.388,93a2.442,2.442,0,0,0,1.291,2.116,3,3,0,0,0,2.78.015A5.445,5.445,0,0,0,16.2,91.634a6.538,6.538,0,0,0-.5-4.734,7.537,7.537,0,0,0-6.874-4.2A8.979,8.979,0,0,0,4.1,83.938,11.565,11.565,0,0,0,0,88.307v7.126c.226.577.4,1.173.677,1.731a10.457,10.457,0,0,0,3.59,4.137,11.613,11.613,0,0,0,3.97,1.636q-.118.049-.239.093A12.675,12.675,0,0,1,2.784,100.9,9.469,9.469,0,0,1,0,97.678v1.331a10.859,10.859,0,0,0,3.856,3.4c-.276.266-.542.578-.41.991-.012.08-.039.241-.051.321-.238-.235-.537-.568-.912-.435-.29.184-.547.414-.831.611a2.39,2.39,0,0,0,.325,1.216c.24.318.683.253,1.036.275a4.535,4.535,0,0,0-.851.46,2.474,2.474,0,0,0,.391,1.4c.476-.041,1.142.189,1.432-.325.063-.248.09-.5.129-.749.082.342.159.688.22,1.036a2.288,2.288,0,0,0,1.148.159l.259-.021c.165-.389.3-.789.433-1.189a2.483,2.483,0,0,0-.826-.684,4.856,4.856,0,0,1,1.034.158,2.052,2.052,0,0,0,.648-1.2,2.466,2.466,0,0,0-.848-.8c-.468-.138-.806.289-1.115.562-.02-.061-.06-.183-.078-.244a6.828,6.828,0,0,0,.5-.886,10.862,10.862,0,0,0,2.074.557c.162.035.322.075.483.114a6.972,6.972,0,0,0,3.029,6.3,6.662,6.662,0,0,0,3.352.927,8.7,8.7,0,0,0,4.2-1.42,10.907,10.907,0,0,1-.955,2.887,14,14,0,0,1-1.9,3.137c-.287.376-.8.325-1.214.387a3.419,3.419,0,0,0-1.928.874,16.171,16.171,0,0,0-1.541,2.537,14,14,0,0,1,1.57-.379,5.143,5.143,0,0,0,2.445-.694,3.268,3.268,0,0,0,1.126-1.766l-.185-.111a3.243,3.243,0,0,1-1.729,1.1c.261-.239.567-.419.85-.631.376-.313.614-.751.957-1.1a13.7,13.7,0,0,0,1.111-1.416,5.357,5.357,0,0,1,.765-.231c-.014.087-.041.262-.053.35a16.236,16.236,0,0,1-1.085,3.426,15.433,15.433,0,0,1-1.342,2.682,17,17,0,0,1-2.336,3.13,17.636,17.636,0,0,1-2.338,2.162,14.7,14.7,0,0,1-3.186,1.906,12.054,12.054,0,0,1-2.81.928A14.07,14.07,0,0,1,0,128.884v2.656a12.834,12.834,0,0,0,4.719-.05,14.836,14.836,0,0,0,3.933-1.522c.006.06.02.178.026.236-.315.508-.4,1.167-.9,1.546a3.433,3.433,0,0,0-1.154,1.61,6.418,6.418,0,0,0,.127,3.322,8.6,8.6,0,0,1,.158,2.106c.454-.318.721-.828,1.169-1.157a4.933,4.933,0,0,0,1.719-3.587c.041-.9-.4-1.728-.405-2.623a1.565,1.565,0,0,0-.713.6,4.636,4.636,0,0,0-.723,2.19c-.046-.271-.1-.541-.146-.812a10.919,10.919,0,0,1,1.615-3.621,4.831,4.831,0,0,1,1.163-1.126,13.06,13.06,0,0,0,2.336-1.952c.109.745.057,1.5.116,2.25a38.351,38.351,0,0,1-.066,5.346c-.08.9-.29,1.776-.337,2.676-.055.244-.109.486-.16.734a45.985,45.985,0,0,1-2.516,8.423,19.048,19.048,0,0,1-1.891,3.169,8.987,8.987,0,0,1-4.679,3.239A7.928,7.928,0,0,1,0,152.6v2.127a8.663,8.663,0,0,0,5.546-.708A11.638,11.638,0,0,0,9.27,150.9a13.1,13.1,0,0,0,2.019-3.337,25.857,25.857,0,0,0,1.28-3.958c0,.092.01.277.014.369.071-.061.143-.121.214-.179.113.19.225.382.34.573.012-.1.036-.3.049-.4a68.539,68.539,0,0,1,2.059,12.5c-.027,1.026.163,2.05.055,3.076-.085.912-.021,1.835-.178,2.741a24.556,24.556,0,0,1-1.2,5.459c-.114.073-.229.152-.342.231.027-.193.054-.382.081-.571-.049-.036-.144-.109-.192-.147-.031.2-.062.4-.093.607-.1-.067-.2-.134-.295-.2-.026.141-.051.284-.076.429-.035-.193-.07-.386-.1-.575-.209-.022-.417-.042-.624-.06-.021-.085-.042-.168-.063-.248l-.206-.1c0,.117,0,.236.006.358q-2.989.037-5.979,0c-.032-.083-.1-.25-.131-.335-.163.343-.328.685-.505,1.022-.126-.133-.251-.262-.376-.392-.026.081-.077.244-.1.326-.275,0-.55.012-.823.02-.066.113-.131.229-.2.346-.267.01-.535.016-.8.046-.428.007-.659.517-1.1.481-.667.009-1.333-.021-2,.015v.208c4.448,0,8.9-.024,13.344.012a4.84,4.84,0,0,1-1.1,1.988,8.255,8.255,0,0,1-2.513,1.827,7.782,7.782,0,0,1-5.314.123,7.559,7.559,0,0,1-1.766-.968c-.165-.123-.355,0-.526.04A4.683,4.683,0,0,0,3.943,173.5a7.861,7.861,0,0,0,6.117.1l-.034.311c-.55.355-1.062.762-1.628,1.092a7.543,7.543,0,0,1-3.142,1.065,7.635,7.635,0,0,0-2.281-1.009,5.213,5.213,0,0,0-2.979.42v2.106a9.6,9.6,0,0,1,1.113.56,4.248,4.248,0,0,0,3.59.02,11.137,11.137,0,0,0,.97-.656l-.111-.149c-.256-.144-.554,0-.826,0A6.627,6.627,0,0,1,1.38,176.8a21.317,21.317,0,0,0,2.59.253,5.866,5.866,0,0,0,.955-.108,13.774,13.774,0,0,0,3.847-1.434c-.016-.011-.047-.036-.062-.047a3.861,3.861,0,0,0,1.352-.935c.02.062.039.127.058.2A18.07,18.07,0,0,1,8.8,176.08a19.074,19.074,0,0,1-3.051,2.271,16.839,16.839,0,0,1-3.381,1.475A7.7,7.7,0,0,1,0,180.266v2.892a16.683,16.683,0,0,0,2.676-.715,18.7,18.7,0,0,0,6.474-4.168c.572-.537,1.061-1.152,1.583-1.734.3-.567.893-.971.981-1.637.036.049.073.1.109.154.274-.672.709-1.258,1.037-1.9a28.964,28.964,0,0,0,1.658-3.979q.94-.011,1.882.012a23.746,23.746,0,0,1-.922,4.646,1.655,1.655,0,0,1-.585.966c-1.182.876-2.613,1.353-3.744,2.3-.373.376-.756.744-1.1,1.146A9.766,9.766,0,0,0,8.4,181.689a21.562,21.562,0,0,0-.433,4.357,7.951,7.951,0,0,0-.092,1.469c.369-.049.55-.4.8-.626a17.863,17.863,0,0,1,3.559-2.419c.827-.474,1.59-1.049,2.371-1.593a6.921,6.921,0,0,0,2.414-4.6,5.176,5.176,0,0,0-.208-2.5l-.27.024c-.332.571-.534,1.21-.877,1.777q-.248.442-.517.874a14.692,14.692,0,0,1-2.279,2.551,5.345,5.345,0,0,1-1.276,1.034c.479-.53.957-1.062,1.437-1.591a15.522,15.522,0,0,0,1.58-2.213,15.534,15.534,0,0,0,.689-1.428c.141-.379.2-.784.3-1.172a44.7,44.7,0,0,0,1.55-6.418,7.233,7.233,0,0,0,.06-.782c.164-.743.147-1.509.251-2.259a38.686,38.686,0,0,0-.7-10.058.768.768,0,0,1,.042-.367,50.01,50.01,0,0,0,4.8,9.044,15.905,15.905,0,0,0,.852,1.535c.3.356.618.7.95,1.026s.823.536,1.062.978a7.823,7.823,0,0,1-3.166-2.743l-.241-.035a4.806,4.806,0,0,0,1.525,3.653,8.347,8.347,0,0,0,2.8,1.358,12.437,12.437,0,0,1,2.627.983,3.307,3.307,0,0,0,.705.336,6.972,6.972,0,0,0-.412-1.452c-.093-.3-.2-.591-.285-.891a6.268,6.268,0,0,0-2.453-3.613A6.488,6.488,0,0,0,23.252,165a1.606,1.606,0,0,1-1.061-.542,52.228,52.228,0,0,1-5.248-9.86c.061-.132.122-.26.183-.387.1-.065.205-.124.308-.184a23.69,23.69,0,0,0,9.414,10.048,14.8,14.8,0,0,0,4.117,1.51,15.85,15.85,0,0,0,3.9.215c.78-.143,1.57-.241,2.341-.432a14.924,14.924,0,0,0,5.393-2.687,13.08,13.08,0,0,0,3.36-3.962,9.623,9.623,0,0,0,1.292-4.771,8.887,8.887,0,0,0-2.074-5.87c0-.063.016-.193.022-.257a14.959,14.959,0,0,0,4.565-3.071,1.608,1.608,0,0,1,.878-.378,12.478,12.478,0,0,0,6.886-4.543,15.962,15.962,0,0,0,2.95-6.551c.167-.025.335-.048.5-.071a68.233,68.233,0,0,1,3.684,5.8,45.515,45.515,0,0,1,3.906,11.932c0,.045,0,.133,0,.178a3.293,3.293,0,0,0-1.055,1.162,2.382,2.382,0,0,0,.969,3.036,6.088,6.088,0,0,1-.633,2.258,7.44,7.44,0,0,1-7.152,4.434,6.4,6.4,0,0,1-5.671-3.38,4.937,4.937,0,0,1-.438-3.118,5.365,5.365,0,0,1,7.913-3.4,4.041,4.041,0,0,1,1.977,3.457,3.588,3.588,0,0,1-.831,2.044,3.21,3.21,0,0,1-.638.461q-.026-.31-.049-.612a8.79,8.79,0,0,0-.307-1.011,2.085,2.085,0,0,0-2.56-1.112,2.359,2.359,0,0,0-1.25,3.079,3.134,3.134,0,0,0,2.483,1.879,4.241,4.241,0,0,0,2.286-.353,4.452,4.452,0,0,0,2.4-2.6,5.277,5.277,0,0,0-1.6-5.592,8.339,8.339,0,0,0-.8-.621,10.386,10.386,0,0,0-3.529-1.192,7.966,7.966,0,0,0-3.3.229,7.351,7.351,0,0,0-2.98,1.74,5.912,5.912,0,0,0-1.654,3.067,8.207,8.207,0,0,0,.868,5.4l.31-.036a14.216,14.216,0,0,1-.693-1.934,6.687,6.687,0,0,1,1.945-6.364,4.251,4.251,0,0,1,1.745-1.034,5.549,5.549,0,0,0-2.251,2.38,7.105,7.105,0,0,0,.745,6.809,8.3,8.3,0,0,0,7.887,3.751,9.1,9.1,0,0,0,5.161-2.6A10.3,10.3,0,0,0,70.439,156a6.687,6.687,0,0,0,3.041-.463,5.935,5.935,0,0,0,3.306-3.11,4.576,4.576,0,0,0,.286-2.842,4.072,4.072,0,0,1-.886,2.774,3.188,3.188,0,0,1-3.968.622,2.165,2.165,0,0,1-.173-.4,2.468,2.468,0,0,0-1.674-1.643,23.775,23.775,0,0,0-1.509-5.054c-.882-2.092-1.843-4.15-2.835-6.192a54.831,54.831,0,0,0-5.146-8.5,10.522,10.522,0,0,1,.09-1.372,23.8,23.8,0,0,0-.17-4.24,59.615,59.615,0,0,0-2.674-9.993c-.151-.442-.323-.874-.489-1.309a11.386,11.386,0,0,1,1.108.771,15.438,15.438,0,0,0,6.885,2.528,22.134,22.134,0,0,0,3.093-.081,16.746,16.746,0,0,0,8.125-3.739,26.316,26.316,0,0,0,5.856-6.937c.433-.76.865-1.521,1.231-2.316a30.062,30.062,0,0,0,1.411-3.311c.257-.74.6-1.448.8-2.209a39.456,39.456,0,0,1-1.831,5.842c-.5,1.327-1.071,2.628-1.689,3.906a41.4,41.4,0,0,1-2.794,4.974,15.9,15.9,0,0,1-1.021,1.62c-.348.49-.678,1-1.061,1.459a4.627,4.627,0,0,1-1.255.373,5.687,5.687,0,0,0-2.473,1.111,7.082,7.082,0,0,0-2.264,3.686,15.257,15.257,0,0,0-.609,1.9,6.425,6.425,0,0,0,.845-.419c1.19-.611,2.549-.74,3.776-1.254a6.063,6.063,0,0,0,1.776-1.015,5.322,5.322,0,0,0,1.519-3.368h-.322a10.774,10.774,0,0,1-2,1.929,13.416,13.416,0,0,1-2.144,1.189c.476-.439,1.068-.719,1.572-1.123a6.092,6.092,0,0,0,1.891-2.06,17.4,17.4,0,0,1,1.295-2.039,53.044,53.044,0,0,0,3.679-6.458c.2-.448.408-.892.617-1.336h.072c-.251.989-.447,1.99-.652,2.989-.031.322-.072.643-.128.964a37.925,37.925,0,0,0,.576,13.627c.225,1.151.649,2.253.835,3.412a11.874,11.874,0,0,0,2.019,3.714c.485.665,1.093,1.234,1.554,1.918a11.622,11.622,0,0,1-1.659-1.537,11.977,11.977,0,0,1-1.776-2.223c-.5-.828-.845-1.736-1.274-2.6-.111-.29-.386-.029-.409.167a7.3,7.3,0,0,0,.947,5.563,10.339,10.339,0,0,0,2.454,2.315c1.639,1.183,3.541,2.044,4.883,3.6.01.049.03.143.041.19A13.336,13.336,0,0,1,88.3,138.79a14.763,14.763,0,0,1-2.678-1.882,15.792,15.792,0,0,1-4.564-7.227c-.252-.626.035-1.285.011-1.928-.254-.119-.571-.209-.636-.52a26.074,26.074,0,0,1,.021-8.731,22.364,22.364,0,0,1,1.217-4.423l-.007-.158c-.26.578-.458,1.183-.709,1.766a24.869,24.869,0,0,0-.876,11.472c-.511-.18-.894-.679-1.473-.668a1.4,1.4,0,0,0-1.026.3l-.051-.052a53.119,53.119,0,0,1,3.194-11.368,20.471,20.471,0,0,1,1-2.21,3.425,3.425,0,0,0,.291-.772c-.336.779-.811,1.488-1.136,2.273a44.92,44.92,0,0,0-2.55,6.875c-.393,1.475-.766,2.958-1.082,4.453-.11.485-.142.986-.275,1.467-.243.458-.619.828-.867,1.285a2.643,2.643,0,0,0-.527,1.628q.511-.147,1.02-.306c-.017.132-.032.266-.047.4a1.929,1.929,0,0,0-.505.341c.035.187.274.257.4.392,0,.092-.006.277-.007.369-.152.052-.3.106-.453.162.192.323.445.651.33,1.054-.239-.136-.651-.724-.855-.266a9.742,9.742,0,0,0,.674,3.135c.01.025.03.076.041.1.055,1.3-.043,2.6.106,3.895a41.66,41.66,0,0,0,4.082,16.42,40.228,40.228,0,0,0,2.486,4.235,33.747,33.747,0,0,0,9.233,8.892,27.53,27.53,0,0,0,12.378,4.488c1.664.034,3.331.068,4.994-.024a22.73,22.73,0,0,0,7.418-2.083,21.3,21.3,0,0,0,5.908-4.2,21.542,21.542,0,0,0,2.544-3.039,19.319,19.319,0,0,0,3.093-7.524,18.7,18.7,0,0,0-7.741-18.423Zm-10.965-20.758c-.449-.154-.894.086-1.346.029a2.372,2.372,0,0,1,1.776-.33,3.058,3.058,0,0,1,2.231,2.9,3.642,3.642,0,0,1-.127-.53,3.4,3.4,0,0,0-2.535-2.074Zm-10.7-14.1a3.292,3.292,0,0,0,2.732-1.241l.226,0-.158.107c-.039.246-.264.389-.415.566a2.935,2.935,0,0,1-2.136.934,3.861,3.861,0,0,1-2.606-.962,9.24,9.24,0,0,1-1.04-1.225c.029-.081.06-.162.091-.239-.006.061-.02.184-.026.245a4.4,4.4,0,0,0,3.332,1.81Zm-7.3-.52a10.342,10.342,0,0,0,3.246,3.117,7.67,7.67,0,0,0,5.8.753,8.776,8.776,0,0,0,3.6-1.942,3.394,3.394,0,0,1,.341-.193,7.228,7.228,0,0,1-6.054,2.789,7.506,7.506,0,0,1-4.356-1.353,13.658,13.658,0,0,1-4.8-7.569,21.845,21.845,0,0,0,2.22,4.4Zm13.99-19.735c.095-.026.19-.052.287-.077a7.96,7.96,0,0,0,1.6-1.031,16.382,16.382,0,0,0,4.028-4.5,11.022,11.022,0,0,0,1.443-3.657l.143.029a1.886,1.886,0,0,0,2.213.787,1.433,1.433,0,0,0,.552-1.884,1.2,1.2,0,0,0-1.452-.493,2.149,2.149,0,0,0-.868,1.08,2.078,2.078,0,0,1,.218-1.391,2,2,0,0,1,2.741-.2,2.91,2.91,0,0,1,.984,2.149,5.057,5.057,0,0,1-1.231,3.159,15.317,15.317,0,0,1-3.3,3.038,19.815,19.815,0,0,1-4.533,2.375,12.205,12.205,0,0,1-2.469.807l-.419.031c.016-.056.047-.169.063-.225Zm7.056-67.231a4.184,4.184,0,0,1,.474-.9,14.546,14.546,0,0,0,1.012-3.112,1.925,1.925,0,0,1,.111-.536,13.286,13.286,0,0,0-.085-2.967,10.656,10.656,0,0,0-3.192-5.971,14.353,14.353,0,0,0-1.845-1.414l-.275-.061-.085-.22a9.513,9.513,0,0,1,2.392,1.291,11.707,11.707,0,0,1,2.085,1.975,7.658,7.658,0,0,1,1.366,3,9.635,9.635,0,0,1,.238,2.528,13.193,13.193,0,0,1-.28,1.976c-.085.428-.225.84-.331,1.261-.183.515-.393,1.019-.608,1.521l-.313.58a11.564,11.564,0,0,0-.6,1.021,1.91,1.91,0,0,0-.461.692,1.565,1.565,0,0,1,.394-.667ZM73.094,13.922a3.809,3.809,0,0,1-3.919,3.291,2.789,2.789,0,0,1-2-1.02,3.672,3.672,0,0,0,2.845.652,4.178,4.178,0,0,0,3.077-2.923Zm3.664,2.341a8.051,8.051,0,0,1-6.347,4.531,8.376,8.376,0,0,1-2.871-.213,5.51,5.51,0,0,1-2.261-1.161,9.536,9.536,0,0,0,4.13,1.008,7.636,7.636,0,0,0,5.213-1.947,10.788,10.788,0,0,0,2.958-5.408c.294-1.123.406-2.281.6-3.423a14.008,14.008,0,0,1-1.424,6.612ZM62.387,35.4a2.991,2.991,0,0,1,1.223-1.674,2.907,2.907,0,0,1,2.052-.321c.078.07.153.144.226.223a3.016,3.016,0,0,0-3.366,2.214c-.045-.148-.091-.295-.136-.442Zm-9.08.279a10.568,10.568,0,0,1-.71-1.28c-.461-.784-.9-1.585-1.416-2.333.095.07.188.143.279.22.611.779,1.221,1.561,1.812,2.357a3.208,3.208,0,0,1,.035,1.036Zm11.92,120.6c.01.144.021.291.032.439a3.594,3.594,0,0,1-3.444,2.863,2.718,2.718,0,0,1-1.489-.494,3.988,3.988,0,0,0,2.851-.188,4.08,4.08,0,0,0,2.05-2.621Zm4.025-.062c.027-.127.056-.251.086-.374h.291c-.01.1-.027.295-.037.393a8.4,8.4,0,0,1-2.021,4.334,7.9,7.9,0,0,1-7.319,2.457c.662-.279,1.393-.058,2.076-.229a8.6,8.6,0,0,0,3.474-1.251,8,8,0,0,0,3.45-5.329ZM82.8,60.3a6.077,6.077,0,0,0,2.123,2.458,5.8,5.8,0,0,1-1.94-1.613,1.793,1.793,0,0,1-.313-1.223c.045.124.087.25.131.378ZM54.383,51.583c.2-.3.448-.571.654-.871a4.533,4.533,0,0,1-.526,1.47,1.124,1.124,0,0,1-.128-.6Zm.881.51a11.808,11.808,0,0,1-.636,2.321,2.512,2.512,0,0,1-.056-1.088C54.786,52.906,55.011,52.491,55.263,52.093ZM44,60.877c.123-.071.249-.142.374-.21,1.04-.6,2.322-.72,3.26-1.5a2.124,2.124,0,0,0,.5-2.107,19.311,19.311,0,0,0-.637-2.219c0-.072,0-.216,0-.289.185.169.372.337.551.512.565.915,1.137,2.091,2.324,2.268,1.291.1,2.36-.774,3.487-1.263-.02.053-.06.162-.081.215a16.074,16.074,0,0,1-8.34,7.576,11.349,11.349,0,0,1-1.918.621,10.375,10.375,0,0,0-.558-3.14,2.782,2.782,0,0,0-1.328-1.192c-.18-.046-.362-.085-.542-.122.029.06.085.182.113.241.062.132.127.261.193.392a5.777,5.777,0,0,1,.963,1.928l-.065.012a4.706,4.706,0,0,0-1.029-1.878,5.156,5.156,0,0,1-.85-.609,7.735,7.735,0,0,0-1.233-1.065,8.646,8.646,0,0,0,1.879-1.358,6.316,6.316,0,0,0,1.068,1.384c.638.588,1.265,1.188,1.875,1.8ZM33.2,70.516a3.737,3.737,0,0,0,3.412-2c.042-.142.3-.359.4-.155a3.043,3.043,0,0,1-1.559,1.894,4.494,4.494,0,0,1-3.391.253c-.063-.071-.127-.139-.19-.208a4.528,4.528,0,0,0,1.332.219Zm-3.442-4.631a17.9,17.9,0,0,0,3.32,1.536c.337.092.408.481.629.707a3.507,3.507,0,0,0,1.361.935c-.1.267-.409.313-.636.429a2.964,2.964,0,0,1-1.726.144,3.856,3.856,0,0,1-2.948-3.751Zm5.155-1.719c-.175.06-.348-.088-.516-.128-.6-.259-1.213-.479-1.79-.785a8.628,8.628,0,0,1-1.708-1.025,5.494,5.494,0,0,1,3.688-1.908,5.872,5.872,0,0,1,1.576.045l.029.076A4.344,4.344,0,0,1,38.7,62a6.5,6.5,0,0,1,1.317,2.96,13.9,13.9,0,0,1-5.111-.8Zm-3.793-4.021a5.742,5.742,0,0,1,2.332-1.409,3.62,3.62,0,0,1,.525.167c.017.05.055.149.073.2-1.095-.093-2,.6-2.931,1.045Zm9.39,8.182.229-.01a7.805,7.805,0,0,1-6.625,6.313,4.134,4.134,0,0,1-1.387.133,13.952,13.952,0,0,1-7.691-3.125c2.444,1.443,5.133,2.81,8.049,2.708a2.315,2.315,0,0,1,.812,0,8.163,8.163,0,0,0,3.788-1.649,8.75,8.75,0,0,0,2.825-4.366Zm-.59-6.385a9,9,0,0,0-1.959-1.794,7.824,7.824,0,0,1-1.04-.636,7.972,7.972,0,0,0,1.776-.295,8.466,8.466,0,0,1,1.581,1.172c.372.555.124,1.28.332,1.9a3.5,3.5,0,0,0,1.911,2.131c.1.083.2.173.3.264a12.179,12.179,0,0,1-1.471.177,9.617,9.617,0,0,0-1.432-2.916ZM42.5,53.194a4,4,0,0,1-.241,1.245c-.23.372-.56.667-.822,1.014a3.088,3.088,0,0,0-.52,1.468,4.418,4.418,0,0,1-1.662,1.19,1.987,1.987,0,0,1-1.442.219,7.018,7.018,0,0,0-3.652-.53A3.143,3.143,0,0,1,32.5,54.321,2.058,2.058,0,0,1,34,52.544a2.38,2.38,0,0,1,1.872.351c0,.034.012.1.017.133a.938.938,0,0,0,.6-.154c.47.685.871,1.51,1.688,1.845a2.9,2.9,0,0,0,2.238-.389c.723-.328,1.36-.821,2.082-1.136Zm-10.565.6a9.8,9.8,0,0,0-.292,1.449,2.628,2.628,0,0,1,2.918-3.463,5.317,5.317,0,0,0-1.4.51,3.33,3.33,0,0,0-1.224,1.5Zm10.429-3.164.007.4a6.124,6.124,0,0,1-1.583-.122c.529-.078,1.045-.221,1.576-.279Zm-5.531-7.505a14.747,14.747,0,0,0,1.022-3.113,8.525,8.525,0,0,1-.786,3.472c-.119-.025-.24-.049-.359-.071.031-.072.092-.216.123-.287ZM35.313,44.3l-.075.328a17.513,17.513,0,0,1-5.811,5.65c-.1.053-.2.1-.3.149a37.565,37.565,0,0,0,2.5-3.515A23.241,23.241,0,0,0,32.894,44.3a7.7,7.7,0,0,1,2.419,0Zm-6.561,5.4a17.373,17.373,0,0,0,1.026-3.225,13.163,13.163,0,0,1,.274-1.425,5.6,5.6,0,0,1,2.133-.641c-.419.772-.764,1.586-1.21,2.343A16.669,16.669,0,0,1,28.751,49.7Zm1.48-11.921a1.456,1.456,0,0,0,1.167-.9,1.519,1.519,0,0,0-.289-1.361,1.075,1.075,0,0,0-1.173-.391c-.007-.037-.021-.112-.027-.149a2.224,2.224,0,0,0,.565-.994,2.862,2.862,0,0,1,2.411,1.476,6.264,6.264,0,0,1,.6,3.958,12.223,12.223,0,0,1-.857,3.492,8.752,8.752,0,0,0-2.483.438,21.7,21.7,0,0,0-.224-2.459,12.623,12.623,0,0,0-.933-3.2,2.637,2.637,0,0,0,1.243.093Zm-1.163-1.965v.5c0,.205-.007.41-.012.617a1.47,1.47,0,0,1-.448-1.056C28.763,35.865,28.916,35.842,29.069,35.818Zm-3.643,18.5A13.838,13.838,0,0,0,27.5,51.957a16.391,16.391,0,0,0,2.6-1.4c.55-.362,1.065-.772,1.59-1.17a19.263,19.263,0,0,0,3.876-4.667c.07-.112.142-.221.215-.33a8.6,8.6,0,0,1,5.558,3.717l.045.224a4.765,4.765,0,0,0-2.822-.882,3.128,3.128,0,0,0-1.787,1.615c-.445.753-.915,1.49-1.379,2.23a6.653,6.653,0,0,0-1.435-.152,5.859,5.859,0,0,0-1.524.412c-.132.234-.425.318-.608.511a2.905,2.905,0,0,0-.914,2,4.874,4.874,0,0,0,1.872,4.152c-.368.315-.828.494-1.214.785a7.586,7.586,0,0,0-2.091,2.245c-.621-.53-1.183-1.126-1.751-1.712a10.839,10.839,0,0,1-2.057-3.708,3.085,3.085,0,0,1-.249-1.508ZM18.361,65.093c-.1-.117-.19-.235-.28-.356-.517-.609-1.139-1.126-1.6-1.779a46.057,46.057,0,0,1-2.906-4.191c-.323-.519-.713-1-1-1.54a15.343,15.343,0,0,0,3.9.347,7.479,7.479,0,0,1,2.944,1.342A13.551,13.551,0,0,1,20.9,60.172a9.512,9.512,0,0,1,.988,1.316,6.591,6.591,0,0,0-2.412-2.255,4.2,4.2,0,0,0-1.295-.133,18.02,18.02,0,0,1,1.184,2.347A4.648,4.648,0,0,0,21.893,63.2c.85.216,1.722.323,2.579.5a3.626,3.626,0,0,0-.489-.769c-.7-1.085-.988-2.408-1.85-3.39a3.453,3.453,0,0,0-2.306-1.092c-.705-.027-1.215-.571-1.835-.836a2.3,2.3,0,0,1,.913-.233A14.508,14.508,0,0,0,22.68,56.2a14.067,14.067,0,0,0,3.285,6.453,17.076,17.076,0,0,0,2.447,2.274,7.429,7.429,0,0,0,.27,3.01,6.157,6.157,0,0,0,2.427,3.047,4.886,4.886,0,0,0,3.2.59,4.677,4.677,0,0,0,3.49-3.164c.621,0,1.241.006,1.863.014a7.461,7.461,0,0,1-5.3,4.762,8.473,8.473,0,0,1-4.178-.07,16.276,16.276,0,0,1-5.818-2.957,21.641,21.641,0,0,1-2.148-1.622c-.889-.675-1.653-1.5-2.554-2.159-.422-.442-.866-.861-1.3-1.287ZM9.814,101.7a3,3,0,0,1,2.977-.8,1.8,1.8,0,0,1,1.149.929q-.168-.084-.328-.175a1.894,1.894,0,0,0-2.938.828l-.168.021c-.372.021-.745,0-1.117.035-.092-.353.2-.611.425-.836Zm7.01,64.453a4.761,4.761,0,0,1-.108-.991c.007.364.019.73.03,1.1.035.762-.169,1.511-.167,2.274-.042.211-.09.419-.136.633-.638-.021-1.276-.05-1.916-.024a25.706,25.706,0,0,0,1.08-4.74,41.985,41.985,0,0,0,.238-9.45,36.2,36.2,0,0,1,.979,11.2Zm21.1-2.244a12.638,12.638,0,0,1-3.047.709,13.8,13.8,0,0,1-6.927-1.03,15.7,15.7,0,0,1-4.613-3,15.285,15.285,0,0,1-2.557-3.085,29.514,29.514,0,0,1-3.225-6.944,59.487,59.487,0,0,1-3.24-16.883c-.121-1.077-.062-2.163-.082-3.244a20.861,20.861,0,0,1,.146-3.154c.144.968.154,1.953.345,2.916a29.476,29.476,0,0,0,1.591,5.842,26.124,26.124,0,0,0,2.108,4.3c-.338-.06-.728-.224-1.024.034-.317.243-.728.475-.869.86.16.544.2,1.258.729,1.581a5,5,0,0,0,.958.177,2.9,2.9,0,0,0-.984.7,2.463,2.463,0,0,0,.417,1.627,10.009,10.009,0,0,0,1.627-.029c.087-.1.175-.205.264-.3.111-.045.221-.087.335-.124.208.868,1.239.675,1.906.685.144-.527.535-.99.532-1.547-.192-.577-.823-.77-1.281-1.081.51.035.97.294,1.479.335.678-.163.75-.971.989-1.509a4.707,4.707,0,0,0-1.11-1.034,2.472,2.472,0,0,0-.636.009A11.748,11.748,0,0,0,20.5,141.9l-.211-.129a4.151,4.151,0,0,0,1.156-1.874,2.289,2.289,0,0,0-1.3-1.095,2.269,2.269,0,0,0-1.459,1.243,30.635,30.635,0,0,1-3.315-9.723,14.845,14.845,0,0,1-.243-2.233,18.672,18.672,0,0,0,3.739,7.364,10.813,10.813,0,0,0,4.689,3.091,9.8,9.8,0,0,0,4.37.3,16.643,16.643,0,0,0,1.806-.59,7.53,7.53,0,0,0,3.747-4.005c.193.221.127.525.162.794a11,11,0,0,0,1.194,3.538,3.564,3.564,0,0,0-1.848.209,2.854,2.854,0,0,0-1.473,2.6,3.9,3.9,0,0,0,1.214,2.749,9.224,9.224,0,0,0-3.514,2.431,7.862,7.862,0,0,0-1.493,2.615,8.054,8.054,0,0,0,.093,4.837,6.03,6.03,0,0,0,5.78,4.117,3.111,3.111,0,0,0,2.734-1.685,2.669,2.669,0,0,0-.067-2.271,2.335,2.335,0,0,0-1.53-1.1,2.057,2.057,0,0,0-1.678.368,3.154,3.154,0,0,0-.679,1.744,2.941,2.941,0,0,0,.653,1.988,6.043,6.043,0,0,1-1.694-1.231,6.522,6.522,0,0,1,1.488-10.5c.276-.147.56-.28.846-.408a3.07,3.07,0,0,1,1.1.4,12.533,12.533,0,0,0,2.606.818,18.844,18.844,0,0,0,4.337.286c.511.459.939,1,1.417,1.489a3.023,3.023,0,0,1-1.143.459,26.856,26.856,0,0,1-3.107.554c-.01.075-.029.221-.037.295.154.014.307.025.464.035a23.861,23.861,0,0,0,4.136-.891,14.585,14.585,0,0,1,1.194,2.48,9.484,9.484,0,0,1-.562,7.727,10.931,10.931,0,0,1-5.009,4.718,11.281,11.281,0,0,1-1.131.5ZM33.918,142.13l-.006.049a1.54,1.54,0,0,0,1.489-.055,2.14,2.14,0,0,0,.871-1.715,13.916,13.916,0,0,0,3.552,2.692,17.042,17.042,0,0,0,3.35,1.217,17.712,17.712,0,0,0,4.335.5,16.557,16.557,0,0,1-3.867.957c-.328.012-.718.141-1-.093a12.068,12.068,0,0,0-3.217-1.61,16.575,16.575,0,0,0-2.292-.522,12.141,12.141,0,0,0-3.307.257c-.572.225-.919-.352-1.18-.754a3.083,3.083,0,0,1-.468-2.345,2.161,2.161,0,0,1,1.447-1.5,1.659,1.659,0,0,1,1.317.205,1.409,1.409,0,0,1,.618.94,1.552,1.552,0,0,0-1.481-.413,1.112,1.112,0,0,0-.749.8,1.486,1.486,0,0,0,.586,1.379Zm6.911,3.77a6.569,6.569,0,0,1-1.653-.062,14.7,14.7,0,0,1-4.31-1.029l.088-.128A7.865,7.865,0,0,1,40.829,145.9Zm5.131,4.742a8.279,8.279,0,0,1,.1,6.109,12.011,12.011,0,0,1-4.366,5.779,11.271,11.271,0,0,0,3.883-6.221,10.517,10.517,0,0,0-1.439-7.916c-.011-.073-.031-.219-.041-.292l-.424.116A.247.247,0,0,0,43.9,148c-.392-.5-.816-.968-1.238-1.438l.127-.027a7.181,7.181,0,0,1,1.368,1.447c.091.078.188.159.279.243a10.647,10.647,0,0,1,1.526,2.416Zm.346-4.005a6.832,6.832,0,0,1-1.675.817,5,5,0,0,0-1.005-1,4.4,4.4,0,0,1,.525-.122,28.317,28.317,0,0,0,3.865-.914,11.827,11.827,0,0,1-1.709,1.218ZM58,113.849c-.126-.1-.346-.245-.2-.437a2.275,2.275,0,0,1-.67-.646c-.034-.053-.1-.162-.138-.215.271.168.413.474.662.672a4.361,4.361,0,0,1,.9.892,1.4,1.4,0,0,1-.55-.266ZM85.3,95.464a60.71,60.71,0,0,1-3.306,9.84,21.751,21.751,0,0,1-4.641,6.963,14.836,14.836,0,0,1-10.565,4.207,9.34,9.34,0,0,1-2.826-.371,12.2,12.2,0,0,1-5.24-2.7,10.977,10.977,0,0,1-3.4-6.342,10.082,10.082,0,0,1,5.324-10.012,7.683,7.683,0,0,1,6.364-.244,6.776,6.776,0,0,1,4.183,5.4,6.643,6.643,0,0,1-1.846,5.3,5.213,5.213,0,0,1-2.014,1.418c1.106-1.134.942-3.426-.614-4.079a4.629,4.629,0,0,0-1.412.087,2.365,2.365,0,0,0-1.455,2.38,2.877,2.877,0,0,0,2.7,2.562,5.735,5.735,0,0,1,1.083-.025,2.439,2.439,0,0,0,.985-.134,6.373,6.373,0,0,0,4.3-4.611A7.546,7.546,0,0,0,71.14,98.1a9.776,9.776,0,0,0-3.146-2.167,12.42,12.42,0,0,0-2.287-.633,14.177,14.177,0,0,0-3.351.127,11.712,11.712,0,0,0-8.593,6.916,11.014,11.014,0,0,0,.042,7.229,15.724,15.724,0,0,1,.874,3.335,8.214,8.214,0,0,1-.142,2.48,4.583,4.583,0,0,1-1.918,2.775,5.166,5.166,0,0,1-3.442.614,6.647,6.647,0,0,1-3.576-1.855,4.016,4.016,0,0,1-.917-3.766,3.239,3.239,0,0,1,1.481-1.845,2.644,2.644,0,0,1,1.412-.257,1.933,1.933,0,0,1-.468.312,3.381,3.381,0,0,0-.674.328,2.45,2.45,0,0,0,.689,3.946,1.965,1.965,0,0,0,1.944-.187,2.6,2.6,0,0,0,1.322-2.724,3.417,3.417,0,0,0-2.2-2.184,3.89,3.89,0,0,0-1.9.017,3.956,3.956,0,0,0-2.341,4.462,5.9,5.9,0,0,0,3.135,3.9,8.209,8.209,0,0,0,1.331.522,6.606,6.606,0,0,0,2.582.219,6.343,6.343,0,0,0,4.024-2.358,6.737,6.737,0,0,0,1.183-2l.148.066c.236.878.476,1.756.641,2.653.021.177.035.357.048.537a12.153,12.153,0,0,1-.113,4.33,7.3,7.3,0,0,0-.192,2.81,4.2,4.2,0,0,1-.116-2.8c.011-.112.035-.335.046-.447a2.683,2.683,0,0,0-1.106,2.771c.221,1.117.893,2.1,1.005,3.245.721-1.052,1.646-2.141,1.61-3.5a5.568,5.568,0,0,0-.679-2.231c0-.081,0-.244.006-.326a19.038,19.038,0,0,0,.083-4.07c-.024-.192-.041-.382-.057-.57.215.449.387.917.557,1.386a20.232,20.232,0,0,1,1.488,7.8c-.066.709-.012,1.425-.122,2.131a16.446,16.446,0,0,1-4.72,9.935,11.658,11.658,0,0,1-7.757,3.315c-.393,0-.786.009-1.178-.01a10.242,10.242,0,0,1-7.877-4.546,9.718,9.718,0,0,1-1.167-8.417,9.051,9.051,0,0,1,8.467-6.228,6.415,6.415,0,0,1,1.6.127,7.438,7.438,0,0,1,5.132,3.58,6.083,6.083,0,0,1,.628,4.515,5.768,5.768,0,0,1-2.687,3.429,4.986,4.986,0,0,1-3.728.437,4.979,4.979,0,0,0,1.473-.925,3.122,3.122,0,0,0,.654-3.678,3.369,3.369,0,0,0-1.531-1.322,3.2,3.2,0,0,0-2.687.5,3.673,3.673,0,0,0-.5,4.655,5.446,5.446,0,0,0,3.077,2.217,8.657,8.657,0,0,0,3.126.146,8.663,8.663,0,0,0,2.439-1.066,6.124,6.124,0,0,0,2.317-2.965,7.827,7.827,0,0,0-.47-6.024,9.109,9.109,0,0,0-7.31-4.734,18.431,18.431,0,0,1-2,0,12.193,12.193,0,0,0-3.729.97,13.844,13.844,0,0,0-3.753,2.427,11.341,11.341,0,0,0-1.152,1.23,9.792,9.792,0,0,0-1.963,3.492c-.032-.01-.1-.03-.131-.041a7.207,7.207,0,0,0-.531-1.758,8.178,8.178,0,0,0-3.9-3.958l.03-.042c-.362-.114-.728-.224-1.085-.353a9.057,9.057,0,0,0-6.152-.337,2.314,2.314,0,0,1-.613-.169c.157-.051.311-.107.464-.167a.225.225,0,0,0-.224-.238,3.434,3.434,0,0,0-1.644.134,3.713,3.713,0,0,0-1.215,1.037c-.53.739-1.059,1.478-1.652,2.168.668-.006,1.337.014,2.005-.025a3.408,3.408,0,0,0,1.748-.687,6.257,6.257,0,0,0,1.3-1.675,4.366,4.366,0,0,1,2.78-.261l-.071.182a5.148,5.148,0,0,0-2.791,1.595,5.071,5.071,0,0,0-1.365,3.775,6.591,6.591,0,0,0,.577,1.916,3.71,3.71,0,0,0,2.194,1.754,3.44,3.44,0,0,0,2.4-.355,2.5,2.5,0,0,0,1.1-1.573,2.45,2.45,0,0,0-.592-1.83,1.8,1.8,0,0,0-2.841,2.144l.71-.016.131-.267c-.163-.31-.465-.658-.264-1.02a1,1,0,0,1,1.219-.437,1.06,1.06,0,0,1,.643,1.342,2,2,0,0,1-1.765,1,1.8,1.8,0,0,1-1.383-.909,3.566,3.566,0,0,1-.428-2.61A3.988,3.988,0,0,1,24.6,125.93a4.394,4.394,0,0,1,3.584-.679,5.922,5.922,0,0,1,4.319,5.188,6.9,6.9,0,0,1-1.184,4.314,5.885,5.885,0,0,1-4.048,2.5,9.309,9.309,0,0,1-7.469-2.18,11.606,11.606,0,0,1-3-4.125,20.265,20.265,0,0,1-1.7-7.163,10.844,10.844,0,0,0,1.638-2.692,40.017,40.017,0,0,0,1.985-5.555,7.693,7.693,0,0,0,.425-1.668,5.863,5.863,0,0,1,3.01.377,4.218,4.218,0,0,1,2.73,3.135,2.5,2.5,0,0,1-1.408,2.61,1.76,1.76,0,0,1-1.873-.109l-.045-.146a2.187,2.187,0,0,0,1.2-1.253,1.21,1.21,0,0,0-1.51-1.616,1.913,1.913,0,0,0-.93,1.111,2.454,2.454,0,0,0,.628,2.2,3.155,3.155,0,0,0,.9.59,2.919,2.919,0,0,0,2.638-.647,3.467,3.467,0,0,0,.835-3.691,5.219,5.219,0,0,0-2.664-2.674,6.9,6.9,0,0,0-3.213-.554c.379-1.59.831-3.166,1.062-4.786q.519-2.418.845-4.872.239-.1.478-.183a1.209,1.209,0,0,0-.109-.759c-.509-.842-.928-1.735-1.443-2.574L19.859,100c-.107.154-.214.311-.32.468.014.536-.06,1.068-.057,1.6a11.5,11.5,0,0,1-.162,2.447,7.849,7.849,0,0,1-2.641,4.546,4.261,4.261,0,0,1-3.85.79,6.078,6.078,0,0,1-4.177-5.987c.563-.024,1.128-.015,1.692.012a2.082,2.082,0,0,0,2.722,1.878,2.57,2.57,0,0,0,1.447-.724,2.89,2.89,0,0,0,.556-.962,6.151,6.151,0,0,0,.04-1.192l.32-.132a16.013,16.013,0,0,0,3.989-2.442A15.8,15.8,0,0,0,23.8,93.444a26.156,26.156,0,0,0,.725-12.33,40.472,40.472,0,0,0-1.48-5.836c.007-.075.024-.225.031-.3.387,1.213.856,2.4,1.251,3.608.2.611.407,1.223.571,1.846a53.211,53.211,0,0,1,1.75,9.457c.047,1.292.224,2.584.144,3.878a13.963,13.963,0,0,1-1.148,1.521,5.652,5.652,0,0,0-1.072,4.057c.143,1.378.83,2.615,1.1,3.964l.249-.095c.47-1.564,1.775-2.652,2.581-4.029.23-.371.4-.771.623-1.147a5.119,5.119,0,0,0-.683-4.253l-.246.041c-.006.062-.017.185-.024.248a9.692,9.692,0,0,1-1.407,4.88c.144-.739.483-1.419.657-2.149a6.325,6.325,0,0,0,.192-2.592,15.043,15.043,0,0,1-.192-2.58,49.694,49.694,0,0,0-1.146-8.01c.009-.142.017-.282.027-.422a35.342,35.342,0,0,0,4.752,8.182c.7.852,1.372,1.722,2.128,2.523.576.642,1.213,1.225,1.794,1.862.736.659,1.484,1.306,2.235,1.95.721.573,1.479,1.1,2.142,1.749a15.911,15.911,0,0,0,6.294,2.276,11.628,11.628,0,0,1-3.035-.321A11.671,11.671,0,0,1,38.1,99.518c-.116.037-.41.026-.353.221a5.593,5.593,0,0,0,.739,1.419,7.67,7.67,0,0,0,2.58,2.284,6.409,6.409,0,0,0,2.735.7,42.232,42.232,0,0,0,5.079-.233,14.856,14.856,0,0,1,2.845.236c.06-.307-.174-.509-.366-.7-.762-.738-1.351-1.627-2.039-2.429a9.338,9.338,0,0,0-4.075-3.05,8.378,8.378,0,0,0-2.587-.537,23.2,23.2,0,0,0-2.588.241c-.751-.051-1.652.253-2.269-.32a26.322,26.322,0,0,1-2.09-1.831,33.689,33.689,0,0,1-3.179-3.334,37.079,37.079,0,0,1-4.891-7.544,9.743,9.743,0,0,1-.811-1.886,2.887,2.887,0,0,1,.408.517,25.108,25.108,0,0,0,1.613,2.388,38.828,38.828,0,0,0,4.775,5.415,33.057,33.057,0,0,0,3.458,2.738,27.476,27.476,0,0,0,2.745,1.6A20.162,20.162,0,0,0,44.4,97.066a19.924,19.924,0,0,0,5.386.443A20.334,20.334,0,0,0,54.467,96.5a17.768,17.768,0,0,0,5.917-3.409,24.531,24.531,0,0,0,2.12-2.27,18.472,18.472,0,0,0,3.928-10.384,16.634,16.634,0,0,0-2.99-10.2,12.527,12.527,0,0,0-2.3-2.428,11.521,11.521,0,0,0-5.79-2.458,12.453,12.453,0,0,0-3.734.2,11.444,11.444,0,0,0-5.141,2.61c-.4.448-.81.881-1.184,1.346a11.088,11.088,0,0,0-1.505,10.531,8.554,8.554,0,0,0,3.972,4.426,7.778,7.778,0,0,0,6.607.117,6.282,6.282,0,0,0,3.933-6.13,4.847,4.847,0,0,0-1.445-3.366A4.061,4.061,0,0,0,53.736,73.8a3.4,3.4,0,0,0-2.8,3.529,2.051,2.051,0,0,0,.409,1.036c.218.149.495,0,.725-.047a3.022,3.022,0,0,1,.241-1.782A2.2,2.2,0,0,1,54.6,75.444,3.709,3.709,0,0,1,56.471,76.6a4.212,4.212,0,0,1,.689,3.38,5.7,5.7,0,0,1-3.5,4.21,6.363,6.363,0,0,1-4.413-.234,8.112,8.112,0,0,1-4.5-4.465A9.215,9.215,0,0,1,47.414,69.42a8.4,8.4,0,0,1,5.575-1.887,8.744,8.744,0,0,1,5.9,2.278,10.778,10.778,0,0,1,3.081,4.747A15.844,15.844,0,0,1,44.255,95.232a13.339,13.339,0,0,1-1.707-.361c.527-.095,1.066-.042,1.6-.1.563-.066,1.123-.158,1.685-.241.432-.155.882-.259,1.31-.428a7.856,7.856,0,0,0,2.014-.913,6.2,6.2,0,0,1,1.137-.828,5.967,5.967,0,0,1-2.5,1.975l-.03.243a3.72,3.72,0,0,0,3.5-1.192,18.711,18.711,0,0,0,1.72-2.868c.229-.394.623-.674.786-1.11-1.459.25-3.055.157-4.336,1.017a4.91,4.91,0,0,0-1.958,2.555,1.08,1.08,0,0,1-.511.506,10.79,10.79,0,0,1-3.807.7,4.409,4.409,0,0,1-1.658-.169,7.715,7.715,0,0,0,2.019-.591,7.635,7.635,0,0,0,3.993-4.3,1.551,1.551,0,0,0,.167-.746.9.9,0,0,0-.34-.057A7.116,7.116,0,0,1,42.921,93l-.164.062a6.943,6.943,0,0,1-4.748-.029,25.483,25.483,0,0,1-3.494-2.342,23.836,23.836,0,0,1-3.326-3.273,30.4,30.4,0,0,1-3.149-4.227,68.918,68.918,0,0,1-5.622-11.481,8.273,8.273,0,0,1-.537-1.5,13.93,13.93,0,0,1,1.2,1.064,18.787,18.787,0,0,0,5.7,3.467,13.277,13.277,0,0,0,2.786.651,11.2,11.2,0,0,0,3.3-.113,8.656,8.656,0,0,0,3.56-1.689,8.255,8.255,0,0,0,3.157-5.375,17.185,17.185,0,0,0,3.375-.789A18.107,18.107,0,0,0,54.9,58.687,19.648,19.648,0,0,0,56.9,47.719c-.052-1.219-.358-2.407-.511-3.612a19.041,19.041,0,0,0,2.571,2.725,1.325,1.325,0,0,1,.355.756,8.028,8.028,0,0,1,.359,2.166c-.512,1.259-1.469,2.264-2.075,3.474a8.292,8.292,0,0,0-.738,5.074c.292,2.205,1.643,4.059,2.271,6.162.113-.007.228-.012.343-.017.387-2.095,1.8-3.76,2.795-5.586a11.818,11.818,0,0,0,1.133-2.674,6.981,6.981,0,0,0-1.73-6.237.592.592,0,0,0-.18.5,14.354,14.354,0,0,1-.287,4.266,19.918,19.918,0,0,1-1.168,3.3,8.44,8.44,0,0,1,.364-1.6,14.876,14.876,0,0,0,.469-4.75c-.017-.061-.051-.184-.067-.245C60.4,50.213,60.4,48.9,59.94,47.7l.143-.029a18.083,18.083,0,0,0,8.358,3.154,23.967,23.967,0,0,0,2.959.08,17.626,17.626,0,0,0,11.75-5.356,11.466,11.466,0,0,1,1.018-1.068,10.4,10.4,0,0,1-.5,1.353,51.18,51.18,0,0,0-2.406,7.838,27.582,27.582,0,0,0,.787,11.684,9.055,9.055,0,0,1-1.2.091A5.8,5.8,0,0,0,76.9,67.492a4.156,4.156,0,0,0-.837,2.126,3.015,3.015,0,0,0,3.571,3.306,2.712,2.712,0,0,0,1.547-1.541,1.909,1.909,0,0,0-.246-1.873,1.3,1.3,0,0,0-1.858-.18,1.5,1.5,0,0,0-.26,1.389A2.517,2.517,0,0,0,79.926,71.9c.05.2-.21.226-.331.307a1.882,1.882,0,0,1-1.671-.172,2.537,2.537,0,0,1-1.218-2.549,3.981,3.981,0,0,1,1.3-2.209,5.748,5.748,0,0,1,4.161-1.224c.23,1.092.554,2.161.816,3.246A27.519,27.519,0,0,0,86,76.635a1.333,1.333,0,0,1,.118,1.059,20.649,20.649,0,0,1-.632,2.722,15.154,15.154,0,0,1-2.449,5.007,9.838,9.838,0,0,1-3.565,2.993,9.277,9.277,0,0,1-3.1.912,8.981,8.981,0,0,1-3.363-.266,5.849,5.849,0,0,1-3.7-3.219,6.538,6.538,0,0,1-.04-5.551,6.186,6.186,0,0,1,3.314-2.906,4.553,4.553,0,0,1,3.279.091A4.893,4.893,0,0,1,78.2,79.72a3.535,3.535,0,0,1-.52,3.769,1.786,1.786,0,0,1-2.694-.185,1.012,1.012,0,0,1,.111-1.393.973.973,0,0,1,1.555.2c.184.455-.2.836-.275,1.264.26.046.576.224.807.009.325-.208.266-.629.269-.959A1.793,1.793,0,0,0,74.994,80.9a2.1,2.1,0,0,0-.813,3.092,3.122,3.122,0,0,0,3.312,1.041,3.747,3.747,0,0,0,1.884-1.516,4.79,4.79,0,0,0,.735-3.079,5.58,5.58,0,0,0-4.142-4.556,6.576,6.576,0,0,1,2.56.067c.409.2.549.679.791,1.034a3.133,3.133,0,0,0,1.547,1.384,10.64,10.64,0,0,0,2.969.379c-.224-.393-.583-.683-.82-1.067a14.575,14.575,0,0,0-.889-1.331,2.9,2.9,0,0,0-1.585-1.066,4.109,4.109,0,0,0-1.464.037c.555.488,1.418.566,1.807,1.253-.452-.143-.816-.46-1.258-.621a15.644,15.644,0,0,0-2.978-.647,10.929,10.929,0,0,0-4.008.688,8.372,8.372,0,0,0-3.538,2.171A7.446,7.446,0,0,0,67.066,83.3a7.093,7.093,0,0,0,.612,3,7.933,7.933,0,0,0,2.428,3.151,8.685,8.685,0,0,0,3.487,1.485A10.87,10.87,0,0,0,77,90.727a10.709,10.709,0,0,0,5.985-3.954A18.586,18.586,0,0,0,85.7,81.649c.053-.177.1-.353.159-.527a5.184,5.184,0,0,1,.261-.582c0,.225-.007.452-.024.678-.052.338-.124.675-.189,1.014a29.017,29.017,0,0,1-3.335,9.386,2.51,2.51,0,0,1-.423.632c-.027-.07-.083-.208-.112-.277-.21-.515-.813-.7-1.211-1.047a5.1,5.1,0,0,0-1.229.828,1,1,0,0,0,.009.863,5.126,5.126,0,0,0,.866,1.368l.27.044c.016-.346.04-.692.081-1.034.095.322.173.651.236.981.159-.111.322-.219.483-.327-.067.193-.137.382-.2.577.335-.066.672-.136,1.013-.175a3.194,3.194,0,0,1-.86.47c.4.393.991.394,1.5.55.31,0,.7.046.891-.264a11.959,11.959,0,0,0,.506-1.355c-.484-.351-.869-1.075-1.56-.913a1.555,1.555,0,0,0-.367.234c-.027-.08-.056-.158-.083-.235l.139.052a30.689,30.689,0,0,0,4.116-10.973c.024-.2.045-.407.071-.607.056-.644.137-1.286.221-1.927a20.308,20.308,0,0,1,.065,2.6,22.355,22.355,0,0,1-.122,2.9c.006,1.236-.2,2.463-.279,3.7A63.639,63.639,0,0,1,85.3,95.464ZM54.776,107.526a1.641,1.641,0,0,1-.707-.4,6.8,6.8,0,0,1-.177-2.07,8.218,8.218,0,0,1,2.3-5.378,9.535,9.535,0,0,1,2.362-2.065,10.723,10.723,0,0,0-3.867,7.081,12.5,12.5,0,0,0,.09,2.827Zm1.774-31.833a3.241,3.241,0,0,0-2.2-.83,2.825,2.825,0,0,0-2.566,1.328c-.006-.6.519-1.019.958-1.345a3.009,3.009,0,0,1,3.807.846Zm35.839,51.071a8.073,8.073,0,0,0,5.189-1.529q.007-.194.019-.381a2.738,2.738,0,0,0-1.047.493,7.211,7.211,0,0,1-2.167.769c-.614.092-1.238.04-1.855.071a5.99,5.99,0,0,1,6.155-1.57,7.339,7.339,0,0,1,3.234,2.274,7.885,7.885,0,0,1,1.616,6.5,28.456,28.456,0,0,1-3.021-.06c-.424-.071-.848-.143-1.269-.221.124-.443.347-.855.435-1.306a8.346,8.346,0,0,0,.025-1.422,5.826,5.826,0,0,1,2.137-.7c-.009-.062-.025-.187-.034-.249a7.612,7.612,0,0,1-.9-.433,6.95,6.95,0,0,0-2.641-1.19,2.9,2.9,0,0,1-.988-.366,3.125,3.125,0,0,0-3.511,1.088,4.012,4.012,0,0,1-1.624-.571c-.2-.118-.455-.178-.59-.374.107-.389.32-.959.832-.82Zm6.314,4.079a2.921,2.921,0,0,1-.619,1.913c-.55.04-1.019-.332-1.549-.417.129-.4.531-.654.677-1.061a8.382,8.382,0,0,0,1.491-.435Zm-4.258,3.084a4.219,4.219,0,0,1,.443.289,4.189,4.189,0,0,1-3.343-2.388,16.236,16.236,0,0,0,2.9,2.1Zm-.372-4.01c0-.146.012-.289.021-.43.18,0,.362,0,.545.006a.485.485,0,0,1-.566.424Zm-2.857-1.7a13.84,13.84,0,0,0,2.158.942,4.252,4.252,0,0,0-.155,1.383,21.012,21.012,0,0,1-2.1-1.73,1.359,1.359,0,0,1,.1-.595Zm-1.031,3.445a7.906,7.906,0,0,0-3-3.075,16.683,16.683,0,0,1-2.227-1.374,1.432,1.432,0,0,1-.58-.878,38.31,38.31,0,0,1-.287-17.307,9.624,9.624,0,0,1,.41-1.6c-.007,1.009-.143,2.013-.226,3.018-.026,1.276-.006,2.554.012,3.831A30.207,30.207,0,0,0,86.972,125.6a19.058,19.058,0,0,0,2.887,4.456,6.387,6.387,0,0,0,.335,1.518c0,.024-.006.07-.009.093Zm-.521-4.54c.177.146.356.292.539.433,0,.085,0,.172.012.259a8.487,8.487,0,0,0-.551-.692Zm-.478-1.361a5.989,5.989,0,0,0,1.576.651c-.024.147-.046.3-.067.449-.113.012-.224.027-.335.042-.359-.414-.874-.672-1.174-1.142Zm1.475,6.931a5.494,5.494,0,0,0,4.37,2.654c.614.032,1.2-.21,1.8-.238.139.063.279.136.422.2.524.17,1.041.363,1.569.527a14.6,14.6,0,0,0,3.021.54l.272.1a8.942,8.942,0,0,1-3.7,3.036,9.7,9.7,0,0,1-2.352.73,7.3,7.3,0,0,1-.767.09,10.945,10.945,0,0,1-3.254-.121c-.194-.051-.481-.04-.53-.284.017-1.175-.16-2.343-.142-3.518a9.259,9.259,0,0,0-.71-3.718Z" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M2.111,1131.495a4.275,4.275,0,0,0,2.574-1.294,4.836,4.836,0,0,0,1.468-3.325,6.073,6.073,0,0,0-1.958-4.791,11.525,11.525,0,0,0-1.469-1.384A6.766,6.766,0,0,0,0,1119.49v1.922a5.415,5.415,0,0,1,3.044,1.318,4.843,4.843,0,0,1,1.505,2.912,3.821,3.821,0,0,1-.269,2.016,3.061,3.061,0,0,1-2.9,1.921,8.125,8.125,0,0,0,.549-1.442A2.1,2.1,0,0,0,0,1125.648v4.468a3.943,3.943,0,0,0,2.572.1,5.577,5.577,0,0,0,2.106-1.331A3.96,3.96,0,0,1,0,1130.478v.771a5.93,5.93,0,0,0,2.111.245Z" transform="translate(-0.003 -980.276)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M640.278,1136.84c-.46,0-.921,0-1.381-.019a4.261,4.261,0,0,0-2.326,1.177,4.441,4.441,0,0,0-1.21,2.725,5.266,5.266,0,0,1-1.02.649,5.529,5.529,0,0,1-6.321-1.183,6.005,6.005,0,0,1-1.062-1.524l-.124-.287a9.208,9.208,0,0,1-.558-2.5,8.629,8.629,0,0,0,.48,3.581,8.878,8.878,0,0,0,1.526,2.7,13.445,13.445,0,0,0,1.736,1.639,13.1,13.1,0,0,0,3.7,1.766c.4.086.8.187,1.2.291a11.706,11.706,0,0,0,5.212-.443,7.84,7.84,0,0,0,1.541-.748,4.79,4.79,0,0,0,2.085-3.315,3.81,3.81,0,0,0-1-3.1,4.113,4.113,0,0,0-2.474-1.408Z" transform="translate(-548.36 -994.627)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M37.615,1237.887c-.3-.281-.729-.122-1.086-.092a4.05,4.05,0,0,1-1.169.731c.107.738-.058,1.638.508,2.219.641.377,1.43.173,2.136.248.21.046.417.1.626.153a5.718,5.718,0,0,0-2.222.393,1.527,1.527,0,0,0-.772.56,8.673,8.673,0,0,0,.216,2.071,15.793,15.793,0,0,0,1.84.3,1.108,1.108,0,0,0,.9-.927,3.644,3.644,0,0,0,.389-1.771c.044.106.09.213.137.322a6.828,6.828,0,0,0-.251,2.19.939.939,0,0,0,.828.744,5.467,5.467,0,0,0,1.285.21,3.937,3.937,0,0,0,1.1-1.693c.017-.789-.85-1.017-1.178-1.609.624.216,1.194.7,1.881.662.7-.284.882-1.118,1.326-1.666a7.106,7.106,0,0,0-1.154-1.542c-.73-.424-1.413.269-2.056.54l-.244-.095a5.5,5.5,0,0,0,1.141-1.537.813.813,0,0,0-.21-.888c-.325-.364-.711-.668-1.042-1.026-.656.291-1.491.358-1.922,1-.226.254-.1.612-.072.914-.035.2-.077.393-.122.591a6.079,6.079,0,0,0-.809-1Z" transform="translate(-30.965 -1082.626)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M.393,1300.53a6.079,6.079,0,0,0-.393-.99v7.339a7.251,7.251,0,0,0,.668-2.169A9.116,9.116,0,0,0,.393,1300.53Z" transform="translate(-0.003 -1137.93)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M369.777,1303.671a2.426,2.426,0,0,0-.907-.663c-.925-.127-1.868-.163-2.794-.208-.226.347-.337.754-.547,1.111a4.346,4.346,0,0,0-.709,1.653,1.772,1.772,0,0,0,.8,1.327c.664.438,1.318.894,2.023,1.267a2.1,2.1,0,0,0,1.47.286c-.1-.8-.771-1.442-.9-2.255.358.464.716.927,1.08,1.388.116.133.208.318.4.349a1.041,1.041,0,0,0,.321-.739c.058-.75-.006-1.5,0-2.25A3.672,3.672,0,0,0,369.777,1303.671Z" transform="translate(-319.444 -1140.784)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M410.047,1305.449c-.792.262-1.009,1.2-1.254,1.9a7.6,7.6,0,0,0-.435,2.494,1.38,1.38,0,0,0,.218.581c.6-.542,1.224-1.06,1.8-1.626l.085.076c-.465.606-.888,1.243-1.367,1.839a2.321,2.321,0,0,0,1.932-.082,12.3,12.3,0,0,0,2.137-.841c.137-.2.284-.388.417-.586.219-1.154-.3-2.246-.4-3.378-1.062.02-2.067-.6-3.132-.373Z" transform="translate(-357.564 -1143.061)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M349.687,1347.456a3.752,3.752,0,0,0-.264,1.295c.831.45,1.362,1.313,2.244,1.673.811.289,1.5-.377,2.045-.881a5,5,0,0,1,1.113-1.035,6.463,6.463,0,0,1-.771,1.445,1.736,1.736,0,0,0-.183,1.919,11.18,11.18,0,0,0,2.118,1.734c.178.188.429.111.627,0,.784-.628,1.913-.851,2.4-1.806a2.806,2.806,0,0,0-.144-1.1,10.735,10.735,0,0,0-1.5-2.86,1.034,1.034,0,0,0-.723-.425c-.137.75-.159,1.518-.331,2.263-.165-.71-.155-1.444-.3-2.156a4.649,4.649,0,0,0-.685.308,3.579,3.579,0,0,0,.2-.952,22.071,22.071,0,0,1-2.341.387c.677-.3,1.345-.614,2.016-.925a2.2,2.2,0,0,0-1.505-.847c-.934-.009-1.873-.512-2.8-.173-.815.384-1.011,1.344-1.219,2.133Z" transform="translate(-305.955 -1177.915)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M400.26,1348.947c.117.239.236.479.364.715.224-.015.448-.011.673-.007.045-.011.132-.036.177-.049.146-.229.364-.488.261-.777-.065-.267-.315-.418-.5-.6a1.008,1.008,0,0,0-.98.718Z" transform="translate(-350.476 -1180.562)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M415.343,1352.346a14.52,14.52,0,0,0,1.567,2.391,1.606,1.606,0,0,0,1.442.708c1.072-.114,1.855-.96,2.85-1.3a11.165,11.165,0,0,1-.177-1.649c-.043-.32-.1-.636-.167-.949a1.558,1.558,0,0,0-.407-.79,8.114,8.114,0,0,0-.777-.356,10.248,10.248,0,0,0-3.89.333c-.251.057-.184.33-.187.521l.179.016c.613.369,1.254.7,1.837,1.118-.8-.109-1.513-.531-2.3-.679.007.21.019.422.034.636Z" transform="translate(-363.654 -1182.445)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M192.3,1386.471c-.4-.365-.764-.76-1.144-1.141-.98.541-2.324.629-2.94,1.674-.27,1.05.352,2.014.485,3.033.2.376.359.882.836.98.2-.641.5-1.244.656-1.9.05.748-.194,1.476-.137,2.225a4.193,4.193,0,0,0,.73-.275,15.182,15.182,0,0,0,1.853-1.991c.25-.435.627-.894.5-1.428a2.4,2.4,0,0,0-.842-1.182Z" transform="translate(-164.75 -1213.049)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M152.464,1401.575c-.789.3-1.467.826-2.234,1.174.007.818.155,1.627.185,2.445a2.122,2.122,0,0,0,.72.989,3.851,3.851,0,0,0,1.684.2,4.151,4.151,0,0,0,2.375-.333,15.96,15.96,0,0,0-1.3-1.126,16.347,16.347,0,0,1,1.675.594l.154-.336c-.087-.3-.177-.593-.29-.879a19.1,19.1,0,0,0-1.515-2.238,1.327,1.327,0,0,0-1.458-.489Z" transform="translate(-131.546 -1227.208)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M675.662,1404.592a.822.822,0,0,0-.1-.887l-.4-.166a1.858,1.858,0,0,0-.669.4.991.991,0,0,0,.264.868C675.056,1404.8,675.481,1404.908,675.662,1404.592Z" transform="translate(-590.582 -1228.994)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M656.635,1405.948c.155-.141.312-.279.473-.412a1.04,1.04,0,0,0-.381-1.2c-.313,0-.685-.1-.922.174a.817.817,0,0,0,.108,1.314C656.112,1406,656.391,1405.933,656.635,1405.948Z" transform="translate(-573.987 -1229.678)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M633.7,1413.482a.979.979,0,0,0,.966-1.357,1.018,1.018,0,0,0-1.261-.633,1.207,1.207,0,0,0-.735,1.163c.151.433.515.907,1.03.827Z" transform="translate(-553.977 -1235.918)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M788.478,1407.855a4.364,4.364,0,0,0-1.776.131,5.38,5.38,0,0,1-1.86.241,15.942,15.942,0,0,1-8.925-2.6c-.272-.185-.54-.377-.812-.56a12.642,12.642,0,0,1-2.254-1.986,11.043,11.043,0,0,1-1.192-1.611c-.019.058-.035.121-.05.185a19.161,19.161,0,0,0,.8,2.168,16.413,16.413,0,0,0,.787,1.537,20.875,20.875,0,0,0,3.442,4.242,25.615,25.615,0,0,0,3,2.378,30.133,30.133,0,0,0,3.172,1.8c.792.376,1.426,1.009,2.218,1.388a6.836,6.836,0,0,0,2.994.634,4.929,4.929,0,0,0,1.76-.607,4.877,4.877,0,0,0,1.557-1.674,4.092,4.092,0,0,0-.545-4.213,4.552,4.552,0,0,0-2.317-1.452Z" transform="translate(-675.635 -1227.181)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M197.8,1425.408c.6-.1.906-.692,1.175-1.171.229-.453.552-.847.809-1.282a3.614,3.614,0,0,0-.47-.728l-.024.068a3.678,3.678,0,0,0-1.618-1.841c-.766-.205-1.44.322-2.09.642-.628.356-1.464.623-1.646,1.419.544.086,1.091.155,1.636.229.136-.035.272-.061.409-.092-.014.126-.027.254-.041.383-.01-.041-.032-.126-.042-.167a16.894,16.894,0,0,1-2.142.209c.027.363.368.6.408.955-.205-.106-.442-.346-.677-.17.09.738.325,1.452.406,2.193-.345-.723-.654-1.46-1.019-2.172a1.518,1.518,0,0,0-.539.7,10.2,10.2,0,0,0-.527,3.229,1.317,1.317,0,0,0,.775,1.111,23.112,23.112,0,0,0,2.505.607c.435-.694,1.013-1.289,1.4-2.009a2.146,2.146,0,0,0,.114-1.32,7.709,7.709,0,0,0-1.35-1.373l-.085-.265C196.042,1424.867,196.829,1425.569,197.8,1425.408Z" transform="translate(-167.954 -1243.764)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M665.639,1361.3a12.747,12.747,0,0,0-.275-1.846,16.289,16.289,0,0,0-3.977-7.608,11.265,11.265,0,0,0-1.607-1.443,11.1,11.1,0,0,1,1.216,1.128c.189.192.368.394.54.606a15.651,15.651,0,0,1,2.771,4.662,16.979,16.979,0,0,1,.849,3.136,10.237,10.237,0,0,1-.33,5.038,9.607,9.607,0,0,1-2.581,4.061,7.269,7.269,0,0,1-3.474,1.777,7.649,7.649,0,0,1-3.5-.3,5.417,5.417,0,0,1-2.633-2.115,5.194,5.194,0,0,1-.772-3.426,4.634,4.634,0,0,1,1.878-3.22,3.976,3.976,0,0,1,4.928.363,3.056,3.056,0,0,1,.776,3.014,2.485,2.485,0,0,1-2.169,1.947,2.15,2.15,0,0,1-2.307-1.4,1.883,1.883,0,0,1,.141-1.48,1.442,1.442,0,0,1,1.423-.753,1.3,1.3,0,0,1,1.225.923c-.2-.133-.4-.269-.593-.406a1.142,1.142,0,0,0-1.363.97,1.107,1.107,0,0,0,1.1,1.138,1.573,1.573,0,0,0,1.3-1.09,1.821,1.821,0,0,0-.224-1.295,1.974,1.974,0,0,0-2.345-.731,2.258,2.258,0,0,0-1.43,1.988,2.433,2.433,0,0,0,.465,1.707,3.067,3.067,0,0,0,4.407.437,3.719,3.719,0,0,0,1.218-3.316,3.954,3.954,0,0,0-2.239-3,4.922,4.922,0,0,0-4.045-.022,5.1,5.1,0,0,0-2.791,4.118,10.5,10.5,0,0,0,.114,2.208,6.113,6.113,0,0,0,5.35,4.373c.363.017.728.02,1.092.015a7.007,7.007,0,0,0,3.253-.939,9.584,9.584,0,0,0,1.536-1.144,9.967,9.967,0,0,0,2.773-4.852,10.314,10.314,0,0,0,.294-3.23Z" transform="translate(-570.214 -1182.464)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M609.3,1426.245a3.169,3.169,0,0,0-1.109.035,1.946,1.946,0,0,0-.8.968,1.555,1.555,0,0,0,.848,1.825,1.522,1.522,0,0,0,1.937-.626,1.767,1.767,0,0,0,.032-1.57,2.118,2.118,0,0,0-.906-.632Z" transform="translate(-531.792 -1248.843)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M194.487,1436.564c.254-.2.53-.495.347-.842-.146-.678-1.284-.532-1.294.146a.731.731,0,0,0,.947.7Z" transform="translate(-169.468 -1256.786)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M157.128,1443.347a7.056,7.056,0,0,0-3.455.625,2.026,2.026,0,0,0-.994.714,1.98,1.98,0,0,0-.133,1.189l.04.087a8.865,8.865,0,0,1,.33,1.789l.154.151a10.1,10.1,0,0,1,1.738.322,6.4,6.4,0,0,0,1.363.056,3.121,3.121,0,0,0,1.009-1.513c.15-.918.806-1.826.381-2.764-.632.382-1.167.911-1.832,1.238.44-.5.876-1,1.32-1.5.1-.108.052-.271.081-.4Z" transform="translate(-133.549 -1263.806)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M586.572,1449.633a2.064,2.064,0,0,0-1.246,1.277,3.357,3.357,0,0,0,.07,1.358,2.217,2.217,0,0,0,.847.92,2.283,2.283,0,0,0,1.371.2,2.729,2.729,0,0,0,1.139-.568,3.3,3.3,0,0,0,.429-1.091,2.06,2.06,0,0,0-.726-1.766,1.942,1.942,0,0,0-1.883-.326Z" transform="translate(-512.49 -1269.245)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M585.148,1492.8a2.457,2.457,0,0,0,2.075-.359,2.016,2.016,0,0,0,.846-1.475,4.524,4.524,0,0,0-.1-1.473,2.364,2.364,0,0,0-2.241-1.356,2.4,2.4,0,0,0-2.037,1.183,2.9,2.9,0,0,0-.277,1.149A2.348,2.348,0,0,0,585.148,1492.8Z" transform="translate(-510.848 -1303.061)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M804,1484.967a9.547,9.547,0,0,0-1.642-.292,11.307,11.307,0,0,1-6.707-5.163l-.058-.054a4.216,4.216,0,0,0-.406-.924c-.194-.388-.286-.814-.439-1.214l-.158.053a9.5,9.5,0,0,0,.516,3.681v.089a16.427,16.427,0,0,0,3.977,6.381c.51.488.869,1.1,1.338,1.623a3.587,3.587,0,0,0,2.546,1.052,2.65,2.65,0,0,0,2.687-2.717A2.733,2.733,0,0,0,804,1484.967Z" transform="translate(-695.746 -1293.597)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M767.993,1523.244a9.244,9.244,0,0,1-2.531-4.9,8.221,8.221,0,0,1-.061-3.233,5.91,5.91,0,0,0-1.066,2.454,13.377,13.377,0,0,0-.236,3.755,32.962,32.962,0,0,0,.72,4.044,3.054,3.054,0,0,0,2,2.47,2.792,2.792,0,0,0,1.715-.3,2.3,2.3,0,0,0,.688-3.268c-.29-.473-.847-.642-1.225-1.02Z" transform="translate(-669.04 -1326.686)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M606.191,1523.334a3.26,3.26,0,0,0-1.9,2.386,3.43,3.43,0,0,0,.246,1.927,3.118,3.118,0,0,0,2.172,1.741,9.983,9.983,0,0,0,1.294.045,3.2,3.2,0,0,0,.2-6.258A4.137,4.137,0,0,0,606.191,1523.334Z" transform="translate(-529.1 -1333.704)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M30.511,1627.055c1.185-.307,2.4-.511,3.576-.842a58.35,58.35,0,0,0,7.287-2.518,11.211,11.211,0,0,1,1.026-.5c.883-.369,1.68-.923,2.6-1.212.8-.541,1.663-.988,2.493-1.483.5-.289.985-.583,1.488-.858-.276.1-.545.223-.811.348a21.646,21.646,0,0,0,2.8-1.882,40.669,40.669,0,0,0,12.766-16.173,36.9,36.9,0,0,0,2.876-12.279q.056-2.052,0-4.1a33.676,33.676,0,0,0-5.376-16.65,31.4,31.4,0,0,0-4.9-5.714,14.25,14.25,0,0,0-2.02-1.622l.095-.042c-1.005-.672-1.993-1.371-3.029-2-.287-.157-.573-.312-.862-.464-.876-.418-1.715-.911-2.615-1.277a31.419,31.419,0,0,0-7.877-2.322,17.8,17.8,0,0,0-2.338-.243,28.245,28.245,0,0,0-9.6.725,24.143,24.143,0,0,0-7,2.671,25.653,25.653,0,0,0-4.641,3.452,26.8,26.8,0,0,0-7.4,12.435,21.054,21.054,0,0,0-.683,4.449,24.018,24.018,0,0,0,3.1,13.737,24.791,24.791,0,0,0,2.856,3.652,21.067,21.067,0,0,0,12.032,6.166,21.436,21.436,0,0,0,8.46-.535,17.333,17.333,0,0,0,6.41-3.3,18.009,18.009,0,0,0,4.169-5.186,15.943,15.943,0,0,0,1.852-7.563,16.394,16.394,0,0,0-.153-3,15.219,15.219,0,0,0-1.346-4.359,13.511,13.511,0,0,0-3.842-4.718c-.164-.118-.336-.225-.5-.331a12.528,12.528,0,0,0-2.919-1.613,16.711,16.711,0,0,0-3.669-.937,14.029,14.029,0,0,0-6.176.8,10.812,10.812,0,0,0-5.273,4.2,12.377,12.377,0,0,0-1.473,3.192,9.372,9.372,0,0,0-.469,2.906,8.593,8.593,0,0,0,.47,3.191,9.054,9.054,0,0,0,2.34,3.919,8.474,8.474,0,0,0,5.748,2.554,8.128,8.128,0,0,0,5.58-1.823,7.082,7.082,0,0,0,2.2-3.385,6.791,6.791,0,0,0-.188-3.564,5.679,5.679,0,0,0-4.238-3.437,6.536,6.536,0,0,0-3.1.306,5.607,5.607,0,0,0-2.954,2.672c-.234.392-.316.852-.545,1.249a12.422,12.422,0,0,0-.04,2.183,7.331,7.331,0,0,0,1.05,2.621,6.4,6.4,0,0,1-3.1-4.361,8.062,8.062,0,0,1,1.8-6.881,8.335,8.335,0,0,1,6.64-2.791,10.051,10.051,0,0,1,8.12,3.914,10.569,10.569,0,0,1,2.177,6.744,12.224,12.224,0,0,1-.241,3.115,13.534,13.534,0,0,1-3.982,6.931,15,15,0,0,1-2.363,1.663,16,16,0,0,1-10.308,1.6,17.187,17.187,0,0,1-6.673-2.713,15.231,15.231,0,0,1-2.154-1.758,18,18,0,0,1-5.325-12.694,14.421,14.421,0,0,1,.055-2.875,21.9,21.9,0,0,1,3.811-10.162,23.821,23.821,0,0,1,4.368-4.676,20.967,20.967,0,0,1,4.878-2.912,17.409,17.409,0,0,1,3.963-1.255,24.612,24.612,0,0,1,4.544-.7,29.318,29.318,0,0,1,4.36.114,25.763,25.763,0,0,1,7.26,1.789,27.127,27.127,0,0,1,12.242,9.328,15.665,15.665,0,0,1,1.377,1.975,1.8,1.8,0,0,1,.522.93,4.126,4.126,0,0,1,.765,1.279,29.035,29.035,0,0,1,2.24,6.048c.209,1.412.582,2.8.684,4.225a35.628,35.628,0,0,1,.183,5.478,31.668,31.668,0,0,1-.466,3.985c-.225,1.322-.545,2.628-.9,3.923l-.111-.124a32.658,32.658,0,0,1-2.858,6.82A38.985,38.985,0,0,1,47.1,1617.724a44.2,44.2,0,0,1-11.487,5.615c-1.055.344-2.116.67-3.191.95a6.242,6.242,0,0,1-2.545.375l.269.078a4.956,4.956,0,0,1-1.667.42,52.554,52.554,0,0,1-5.346.741c-2.07.073-4.142.061-6.212.052a28.626,28.626,0,0,1-4.014-.2A56.075,56.075,0,0,1,3.966,1624c-1.34-.347-2.635-.838-3.964-1.213v1.71c.343.106.683.224,1.026.328a59.778,59.778,0,0,0,14.9,3.082c2.032.057,4.065.046,6.1.029a36.836,36.836,0,0,0,4.768-.345c1.068-.106,2.112-.386,3.184-.455.179-.022.359-.042.536-.081Z" transform="translate(-0.004 -1361.687)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M4.541,1533.59a16.775,16.775,0,0,0,.129-16.45,12.294,12.294,0,0,0-1.4-2.095,6.25,6.25,0,0,1-.743-.8c-.078-.205.044-.412.1-.6a24.8,24.8,0,0,0,1.631-9.086,23.284,23.284,0,0,0-.891-5.78c-.111-.362-.215-.724-.3-1.09A21.972,21.972,0,0,0,0,1491.71v27.012a28.8,28.8,0,0,0,1.707-2.868,4.785,4.785,0,0,1,1.177,1.376A15.115,15.115,0,0,1,4.676,1529.8a16.608,16.608,0,0,1-3.205,5.944,9.847,9.847,0,0,1-1.2,1.315c-.01.19-.1.261-.274.213v1.735a19.531,19.531,0,0,0,4.541-5.418Z" transform="translate(-0.002 -1306.197)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M10.212,1889.91a15.179,15.179,0,0,0,2.034-4.958,10.119,10.119,0,0,0-.412-4.493,7.24,7.24,0,0,0-3.437-3.811,7.32,7.32,0,0,0-3.3-.51A6.673,6.673,0,0,0,0,1878.49v9.11c.138.152.285.3.43.448a6.185,6.185,0,0,1-.43,2.541v7.144a19.414,19.414,0,0,0,10.212-7.823Z" transform="translate(-0.003 -1642.802)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M317.82,2144.747a19.8,19.8,0,0,0-3.8-3.606,26.786,26.786,0,0,0-11.069-4.291c-.187-.027-.372-.057-.557-.08-.235.049-.465.116-.7.17a26.731,26.731,0,0,1,5.674,1.317,20.961,20.961,0,0,1,10.338,7.333,17.327,17.327,0,0,1,2.6,5.8,14.35,14.35,0,0,1,.326,3.081,11.9,11.9,0,0,1-1.328,5.867,10.539,10.539,0,0,1-4.979,4.686,9.192,9.192,0,0,1-5.111.746,8.517,8.517,0,0,1-4.8-2.494,8.329,8.329,0,0,1-2.346-5.2,6.759,6.759,0,0,1,3.679-6.183,5.4,5.4,0,0,1,5.383.152,4.776,4.776,0,0,1,2.235,5.046,4.109,4.109,0,0,1-3.146,3,3.209,3.209,0,0,1-3.095-1.3,2.672,2.672,0,0,1,.486-3.693,2.116,2.116,0,0,1,2.235-.222,3.312,3.312,0,0,1-.743.2,1.649,1.649,0,0,0-1.1,1.068,1.737,1.737,0,0,0,1.578,2.285,1.9,1.9,0,0,0,1.916-1.858,2.645,2.645,0,0,0-2.044-2.677,3.487,3.487,0,0,0-2.151.286,3.6,3.6,0,0,0-1.741,2.286,3.959,3.959,0,0,0,.326,2.417,4.363,4.363,0,0,0,3.082,2.342,4.807,4.807,0,0,0,2.615-.333,5.05,5.05,0,0,0,3.077-4.689,6.19,6.19,0,0,0-6.326-6.192,7.061,7.061,0,0,0-4.239,1.415,7.98,7.98,0,0,0-3.039,4.771,23.473,23.473,0,0,0-.015,3.116,9.715,9.715,0,0,0,4.418,6.229,9.181,9.181,0,0,0,4.487,1.325,9.372,9.372,0,0,0,3.312-.391c.3-.1.595-.215.894-.311a11.517,11.517,0,0,0,6.66-7.256,14.293,14.293,0,0,0-.333-9.353,16.9,16.9,0,0,0-2.666-4.82Z" transform="translate(-263.566 -1871.02)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M391.155,2021.946a44.574,44.574,0,0,0,6.987-1.8c.832-.321,1.664-.639,2.482-1,1.485-.674,3.173-.743,4.636-1.478a9.832,9.832,0,0,0,3.64-3.005c.009.04.021.083.034.133a6.924,6.924,0,0,1,.56-1.078,11.091,11.091,0,0,0,.524-1.387c.02.1.058.3.078.4a4.976,4.976,0,0,1,.082-1.481,6.738,6.738,0,0,0-3.2-6.177,7.057,7.057,0,0,0-2.3-.845,17.88,17.88,0,0,0-2.144-.032,6.849,6.849,0,0,0-3.632,1.835q-.382.472-.786.929a15.534,15.534,0,0,1-1.943,3.236,27.622,27.622,0,0,1-5.064,4.708,28.407,28.407,0,0,1-8.351,4.019,16.616,16.616,0,0,1-3.016.755c-.408.3-.957.126-1.424.2a22.6,22.6,0,0,1-4.913-.006l-.016.235c1.091.415,2.153.912,3.28,1.234a19.9,19.9,0,0,0,3.962.825c.261.292.7.134,1.039.2a42.14,42.14,0,0,0,5.045.137c.927-.027,1.848-.128,2.773-.192.545-.189,1.127-.205,1.677-.372Z" transform="translate(-326.94 -1754.923)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M515.477,2152.421a4.583,4.583,0,0,0-5.087.892,7.963,7.963,0,0,1-2.218,1.644,17.553,17.553,0,0,1-5.152,1.937,13.925,13.925,0,0,1-3.382.338,21.442,21.442,0,0,1-3.977-.193,14.394,14.394,0,0,1-3.154-.906c-.243-.094-.49-.185-.736-.255a4.146,4.146,0,0,0,1.117,1.151,19.747,19.747,0,0,0,4.76,2.723,27.093,27.093,0,0,0,10.57,1.782,24.2,24.2,0,0,1,2.865-.075,7.364,7.364,0,0,0,3.993-.465,4.939,4.939,0,0,0,2.479-2.133,4.6,4.6,0,0,0-.622-5.365,5.044,5.044,0,0,0-1.455-1.076Z" transform="translate(-430.604 -1884.379)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M270.087,2247.735a3.4,3.4,0,0,0,.74.04,2.25,2.25,0,0,0,.69-1.039,1.684,1.684,0,0,0-.6-.944,1.078,1.078,0,0,0-1.378.4A1.062,1.062,0,0,0,270.087,2247.735Z" transform="translate(-235.875 -1966.396)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M252.323,2269.076a1.481,1.481,0,0,0-.6-1.555,1.609,1.609,0,0,0-1.754.24,3.265,3.265,0,0,0-.221.246,1.529,1.529,0,0,0,.077,1.388,1.39,1.39,0,0,0,1.7.547A1.594,1.594,0,0,0,252.323,2269.076Z" transform="translate(-218.575 -1985.374)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M531.471,2252.612a3.651,3.651,0,0,0-3.208-.622,9.8,9.8,0,0,1-1.22.3q-1.551.017-3.1-.082a15.29,15.29,0,0,1-6.846-2.6,13.773,13.773,0,0,1-1.348-1,18.819,18.819,0,0,1-2.243-2.454c.039.132.078.269.118.407.175.4.328.815.5,1.221a6.146,6.146,0,0,0,.59,1.144c.008.012.021.037.027.05.16.342.325.687.515,1.016a20.614,20.614,0,0,0,6.289,6.084,22.766,22.766,0,0,0,2.493,1.378,10.159,10.159,0,0,1,1.734.978,5.338,5.338,0,0,0,4.871.78,3.854,3.854,0,0,0,2.363-4A3.961,3.961,0,0,0,531.471,2252.612Z" transform="translate(-449.639 -1966.795)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M236.894,2300.53a1.713,1.713,0,0,0-1.366.667,1.881,1.881,0,0,0-.272,1.672,1.783,1.783,0,0,0,1.649,1.138,1.708,1.708,0,0,0,1.7-1.814,1.905,1.905,0,0,0-1.087-1.606l.226-.067a5.442,5.442,0,0,1-.853.01Z" transform="translate(-205.932 -2014.402)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M231.655,2346.537a2.789,2.789,0,0,0,1.588-1.789,2.5,2.5,0,1,0-4.9-.986,2.838,2.838,0,0,0,.177,1.369,2.6,2.6,0,0,0,1.376,1.352,3.128,3.128,0,0,0,1.761.053Z" transform="translate(-199.918 -2050.37)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M242.6,2391.792a3.193,3.193,0,0,0-1.937-2.24,4.442,4.442,0,0,0-2.009-.172,3.575,3.575,0,0,0-2.182,1.833,3.632,3.632,0,0,0-.23,2.075,3.346,3.346,0,0,0,2.268,2.437,4.2,4.2,0,0,0,1.743.068,3.455,3.455,0,0,0,2.041-1.593,4.016,4.016,0,0,0,.306-2.408Z" transform="translate(-206.825 -2092.181)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M288.347,2427.474a3.918,3.918,0,0,0-2.872,3.178,4.611,4.611,0,0,0,.053,1.677,3.981,3.981,0,0,0,7.609.274,4.36,4.36,0,0,0-.379-3.356,3.992,3.992,0,0,0-4.411-1.772Z" transform="translate(-249.921 -2125.449)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path><path d="M363.649,2427.476a5.749,5.749,0,0,0-2.51-.269,5.123,5.123,0,0,0-2.652,1.088,5.82,5.82,0,0,0-1.286,1.458,6.288,6.288,0,0,0-.668,3.758,5.629,5.629,0,0,0,2.733,3.727,6.257,6.257,0,0,0,1.653.551,7.111,7.111,0,0,0,2.29-.111,5.349,5.349,0,0,0,.44-10.2Z" transform="translate(-312.135 -2125.314)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"></path></g></svg>\'' . ' );
    }

    section.invitation-section .widget:after {
        background-image: url(' . ' \'data:image/svg+xml; utf-8, <svg xmlns="http://www.w3.org/2000/svg" width="244.421" height="342.536" viewBox="0 0 244.421 342.536"><g transform="translate(1037.979 -362.459)" opacity="0.2"><g transform="translate(-1287 356)"><path d="M3386.428,62.86a5.5,5.5,0,0,0,4-.753,5.385,5.385,0,0,0,2.327-5.839,5.33,5.33,0,0,0-5.142-4.046,5.069,5.069,0,0,0-3.04.853,5.579,5.579,0,0,0-1.725,1.857,5.433,5.433,0,0,0-.285,4.723A5.506,5.506,0,0,0,3386.428,62.86Z" transform="translate(-2961.465 -45.754)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3479.573,81.891a4.085,4.085,0,0,0,4.276-2.613,4.046,4.046,0,0,0-2.368-5.156,4.3,4.3,0,0,0-2.52-.091,4.175,4.175,0,0,0-2.735,2.729,4.252,4.252,0,0,0,.452,3.253A4.136,4.136,0,0,0,3479.573,81.891Z" transform="translate(-3043.726 -64.73)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3537.721,129.187a3.245,3.245,0,0,0,5.147-.772,3.29,3.29,0,1,0-5.147.772Z" transform="translate(-3096.787 -108.187)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3557.869,183.765a2.662,2.662,0,0,0-1.3,2.934,2.535,2.535,0,0,0,4.724.552,2.556,2.556,0,0,0-1.035-3.416A2.8,2.8,0,0,0,3557.869,183.765Z" transform="translate(-3114.111 -160.738)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3365.363,211.365a22.058,22.058,0,0,0,5.9,3.531,28.2,28.2,0,0,0,9.743,2.147c.847.134,1.693-.1,2.546-.045.607.025,1.2-.142,1.806-.174-.582-.112-1.164.108-1.75.049a28.5,28.5,0,0,1-11.278-1.938,23.737,23.737,0,0,1-5.55-3.082,17.692,17.692,0,0,1-4.789-5.515,17.159,17.159,0,0,1-1.9-6.071,12.588,12.588,0,0,1,1.627-7.688,10.521,10.521,0,0,1,5.032-4.3,8.794,8.794,0,0,1,7.425.269,8.525,8.525,0,0,1,4.364,5.584,6.793,6.793,0,0,1-1.892,6.371,6.635,6.635,0,0,1-4.1,1.787,5.227,5.227,0,0,1-4.748-2.795,4.261,4.261,0,0,1-.264-3.633,4.106,4.106,0,0,1,3.013-2.477,3.175,3.175,0,0,1,2.929,1.09,2.758,2.758,0,0,1,.643,2.488,2.606,2.606,0,0,1-1.152,1.536,2.35,2.35,0,0,1-2.016.214c.011-.058.036-.177.048-.235.26-.022.521-.042.79-.072a1.762,1.762,0,1,0-1.841-2.963,2.242,2.242,0,0,0-.634,2.239,2.76,2.76,0,0,0,2.354,2,3.268,3.268,0,0,0,2.865-1.3,3.584,3.584,0,0,0,.3-3.885,4.2,4.2,0,0,0-3.531-2.3,5.108,5.108,0,0,0-5.091,3.7,5.868,5.868,0,0,0,1.6,5.724,6.452,6.452,0,0,0,3.188,1.76,7.219,7.219,0,0,0,6.125-1.651,8.136,8.136,0,0,0,2.785-6.57,9.465,9.465,0,0,0-3.444-6.418,9.638,9.638,0,0,0-6.417-2.229,10.924,10.924,0,0,0-6.11,2.236,12.189,12.189,0,0,0-4.622,8.349,26.156,26.156,0,0,0-.026,2.651,17.2,17.2,0,0,0,6.078,11.61Z" transform="translate(-2941.42 -163.35)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3155.056,219.564a3.43,3.43,0,0,0,1.77.463c.985.065,1.877-.517,2.868-.422a15.681,15.681,0,0,1,10.544,3.571,11.358,11.358,0,0,1,2.269,2.5q.077.03.172.063a15.448,15.448,0,0,0-2.585-5,22.877,22.877,0,0,0-8.713-6.64,16.693,16.693,0,0,0-2.347-1.34,4.847,4.847,0,0,0-3.854.07,3.823,3.823,0,0,0-.124,6.732Z" transform="translate(-2760.903 -186.013)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3566.139,239.174a1.725,1.725,0,1,0-3.329.684,1.932,1.932,0,0,0,1.146,1.055A1.774,1.774,0,0,0,3566.139,239.174Z" transform="translate(-3119.532 -207.99)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3555.362,279.979a1.473,1.473,0,0,0,1.154-.894,1.776,1.776,0,0,0-.16-1.295c-.141-.119-.28-.244-.411-.362a1.627,1.627,0,0,0-1.194-.139,1.494,1.494,0,0,0-.9,1.165A1.405,1.405,0,0,0,3555.362,279.979Z" transform="translate(-3111.79 -242.788)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3539.91,303.9a1.122,1.122,0,0,0-.6,1.347c.239.287.5.662.925.649a1.156,1.156,0,0,0,1.035-.529,4.35,4.35,0,0,1,.113-.541c-.043-.144-.08-.289-.109-.433A1.079,1.079,0,0,0,3539.91,303.9Z" transform="translate(-3099.038 -266.044)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3844.6,339.227a9.22,9.22,0,0,0,2.416,1.845c.072-.014.151-.027.236-.04-.149-.081-.28-.164-.423-.233l-.118-.039a5.749,5.749,0,0,1-2.306-2.367,5.676,5.676,0,0,1,.373-5.636,5.763,5.763,0,0,1,2.009-1.707,3.4,3.4,0,0,1,.444-.189c.507-.26.945.256,1.437.335a4.1,4.1,0,0,0,4.616-1.761,4.254,4.254,0,0,0-.917-5.367,4.882,4.882,0,0,0-3.445-.748,6.323,6.323,0,0,0-2.121.886,10.285,10.285,0,0,0-3.005,3.2,11.123,11.123,0,0,0-1.562,5.778A8.4,8.4,0,0,0,3844.6,339.227Z" transform="translate(-3364.307 -283.089)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3123.2,347.223c.5.024,1.01-.017,1.519,0a4.436,4.436,0,0,0,2.716-1.462,11.066,11.066,0,0,1,3.157-2.044,18.313,18.313,0,0,1,8.07-1.75,16.471,16.471,0,0,1,7.673,1.659,17.657,17.657,0,0,0-5.562-3.811,25.365,25.365,0,0,0-7.836-1.979c-.744-.117-1.5-.047-2.243-.137a20.19,20.19,0,0,0-2.484.062c-1.454.093-2.911-.147-4.36.034-.251.083-.5.162-.748.236a5.3,5.3,0,0,0-3.131,2.4,4.644,4.644,0,0,0,3.229,6.789Z" transform="translate(-2731.41 -295.703)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3172.985,415.988a41.18,41.18,0,0,0-9.629,2.916c-1.316.524-2.765.623-4.055,1.221a10.225,10.225,0,0,0-3.213,2.271,6.917,6.917,0,0,0-1.649,2.632,6.664,6.664,0,0,0,1.619,6.874,6.559,6.559,0,0,0,3.395,1.828,7.035,7.035,0,0,0,3.63-.294,6.388,6.388,0,0,0,3.239-2.613,24.9,24.9,0,0,1,1.28-2.322,26.741,26.741,0,0,1,10.911-8.391,25.211,25.211,0,0,1,9.218-2.125,27.683,27.683,0,0,1,3.919.137,24.609,24.609,0,0,0-8-2.465c-.795-.106-1.594-.144-2.385-.254a41.182,41.182,0,0,0-4.911.123A33.322,33.322,0,0,0,3172.985,415.988Z" transform="translate(-2761.767 -363.758)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3370.539,436.2c-1.042-.755-2.161-1.394-3.239-2.092-1.3-.787-2.633-1.508-3.967-2.23a75.009,75.009,0,0,0-7.738-3.5c-.832-.254-1.648-.556-2.467-.843-1.174-.4-2.371-.721-3.565-1.046s-2.407-.567-3.617-.816q-1.007-.173-2-.374c-1.653-.238-3.312-.4-4.972-.553a6.364,6.364,0,0,1-1.3-.081,64.568,64.568,0,0,0-8.423.335c-2.06.256-4.111.593-6.136,1.051a50.94,50.94,0,0,0-14.853,5.8,44.848,44.848,0,0,0-5.827,4.157,42.05,42.05,0,0,0-7.5,8.219,36.867,36.867,0,0,0-6.638,21,33.994,33.994,0,0,0,3.419,15.4,31.1,31.1,0,0,0,7.717,9.97,31.649,31.649,0,0,0,25.612,7.064c1.076-.206,2.145-.457,3.214-.707a25.9,25.9,0,0,0,3.968-1.443c.73-.376,1.471-.738,2.172-1.173a24.3,24.3,0,0,0,4.1-3.081,28.79,28.79,0,0,0,2.477-2.616,27.013,27.013,0,0,0,3.241-4.951,24.3,24.3,0,0,0,2.712-11.358,24.98,24.98,0,0,0-1.493-8.547,23.049,23.049,0,0,0-1.986-4.025,19.477,19.477,0,0,0-3.092-3.751,21.789,21.789,0,0,0-3.511-2.734,23.248,23.248,0,0,0-3.217-1.621,21.76,21.76,0,0,0-3.36-1.036,20.491,20.491,0,0,0-6.262-.4,17.7,17.7,0,0,0-12.921,6.993,17.031,17.031,0,0,0-2.292,16.119,13.947,13.947,0,0,0,17.255,8.136,11.679,11.679,0,0,0,3.761-2.141,8.9,8.9,0,0,0,1.444-1.481,11.576,11.576,0,0,0,2.321-5.018,10.512,10.512,0,0,0-1.05-6.987,9.287,9.287,0,0,0-3.128-3.337,9.5,9.5,0,0,0-2.7-1.1,10.117,10.117,0,0,0-3.358-.153,11.185,11.185,0,0,0-2.131.72,7.117,7.117,0,0,0-3.918,4.523,5.757,5.757,0,0,0,.628,4.326,5.673,5.673,0,0,0,5.8,2.7,5.594,5.594,0,0,0,3.049-1.51,5.74,5.74,0,0,0,1.479-5.783,8.313,8.313,0,0,0-.928-1.867,6.863,6.863,0,0,1,3.341,6.728,8.119,8.119,0,0,1-6.321,7.234,12.832,12.832,0,0,1-3.361.184,10.28,10.28,0,0,1-8.325-5.9,13.142,13.142,0,0,1,1.914-13.39,12.823,12.823,0,0,1,5.189-3.867,16.458,16.458,0,0,1,8.584-.95,11.966,11.966,0,0,1,1.741.359,16.282,16.282,0,0,1,4,1.615,16.956,16.956,0,0,1,1.561.975,16.661,16.661,0,0,1,4.338,4.507,18.125,18.125,0,0,1,2.446,5.99,21.43,21.43,0,0,1,.121,8.711,22.068,22.068,0,0,1-2.931,7.305,23.012,23.012,0,0,1-3.769,4.579,21.758,21.758,0,0,1-3.931,2.9,21.2,21.2,0,0,1-2.433,1.183,17.807,17.807,0,0,1-2.6.858,27.837,27.837,0,0,1-34.145-19.285,33.477,33.477,0,0,1-.158-17.979,35.676,35.676,0,0,1,6.867-13.225,42.385,42.385,0,0,1,19.359-13.206,8.016,8.016,0,0,1,1.57-.575,53.627,53.627,0,0,1,17.584-2.445,47.858,47.858,0,0,1,7.672.759,31.037,31.037,0,0,1,3.984.9c.868.216,1.737.445,2.594.711.5.144.994.277,1.488.439,1.51.5,3,1.061,4.47,1.667,1.184.468,2.325,1.036,3.487,1.555a74,74,0,0,1,8.387,4.732c.934.549,1.771,1.248,2.686,1.833V437.71c-.723-.51-1.475-.973-2.178-1.508Z" transform="translate(-2879.278 -371.86)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3742.169,514.684a8.1,8.1,0,0,1,1.534-1.111,9.219,9.219,0,0,1,4.472-1.221,9.413,9.413,0,0,1,4.361.873,14.985,14.985,0,0,1,2.546,1.549c-.143-.326-.463-.509-.715-.734-.5-.423-1.037-.794-1.561-1.18a14.354,14.354,0,0,0-4.026-1.758,21.391,21.391,0,0,0-2.694-.556,19.626,19.626,0,0,0-4.8.351,18.954,18.954,0,0,0-4.187,1.48c-.5.23-.964.508-1.44.765a18.977,18.977,0,0,0-5.61,4.951,17.732,17.732,0,0,0-2.447,4.653,9.954,9.954,0,0,0-.378,4.5,7.641,7.641,0,0,0,1.254,3.057,6.285,6.285,0,0,0,3.944,2.714c.352.025.7.093,1.06.129a12.655,12.655,0,0,0,1.737-.026,7.216,7.216,0,0,0,3.065-1.264,7.077,7.077,0,0,0,2.84-6.981,7.384,7.384,0,0,0-1.714-3.462c-.124-.158-.32-.3-.292-.522A8.773,8.773,0,0,1,3742.169,514.684Z" transform="translate(-3263.521 -447.048)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M2923.57,654.313c-.229.02-.455.031-.672.051-.57.138-1.151.208-1.717.343-.6.138-1.179.32-1.768.474-.751.208-1.47.5-2.2.769a20.747,20.747,0,0,0-3.048,1.479,22.422,22.422,0,0,0-3.082,2.205,19.412,19.412,0,0,0-4.717,6.02,19.692,19.692,0,0,0-1.143,2.923,17.192,17.192,0,0,0,.071,9.669,15.05,15.05,0,0,0,3.55,6.043c-.017.133-.031.266-.041.4a23.693,23.693,0,0,0-1.045,14.42,23.076,23.076,0,0,0,2.833,6.7q.388.588.8,1.168c.484.719,1.131,1.31,1.621,2.022a14.862,14.862,0,0,0-2.847.551,19.7,19.7,0,0,0-2.823,1.045,16.7,16.7,0,0,0-1.6.841,18.367,18.367,0,0,0-3.52,2.7,16.125,16.125,0,0,0-1.835,2.09,23.49,23.49,0,0,0-3.337,6.306,36.305,36.305,0,0,0-1.768,13.477,4.65,4.65,0,0,1,.087,1.131c-.3-.286-.271-.726-.36-1.1q-.077-.444-.125-.887a37.837,37.837,0,0,1,.646-15.476,6.038,6.038,0,0,1,.613-1.795c1.053-.868,2.358-1.336,3.483-2.1a8.471,8.471,0,0,0,2.475-2.9,10,10,0,0,0,1.1-4.147c.01-.859.084-1.715.164-2.57a4.235,4.235,0,0,0,.093-1.224c-.256-.093-.4.164-.552.3a9.918,9.918,0,0,1-2.411,1.881c-.979.557-1.949,1.128-2.875,1.766a8.759,8.759,0,0,0-2.287,2.182,7.38,7.38,0,0,0-.948,5.585c.118-.005.242-.008.372-.008a20.5,20.5,0,0,1,1.419-2.692,7.1,7.1,0,0,1,1.07-1.323,17.952,17.952,0,0,1,2.521-2.3,20.122,20.122,0,0,0-3.241,4.152c-.205.393-.4.794-.573,1.2-.291,1.331-.759,2.612-1.082,3.936a37.129,37.129,0,0,0-1.132,9.623,34.708,34.708,0,0,0,.586,6.474c.04.326.239.68.037.99a23.245,23.245,0,0,0-1.336-3.08c-.637-1.289-1.333-2.546-2.061-3.785-.036-.06-.106-.179-.141-.238a21.767,21.767,0,0,1-1.729-2.968,11.032,11.032,0,0,0-3.279-2.96c.007-.019.023-.055.031-.072.489.335,1.055.539,1.539.888a7.723,7.723,0,0,1,2.2,2.005c.109.144.218.295.33.447l.27.039a4.789,4.789,0,0,0-1.154-3.265,5.463,5.463,0,0,0-2.18-1.413c-1.115-.457-2.313-.675-3.4-1.2a5.065,5.065,0,0,0-1.039-.531c.218.79.54,1.549.74,2.347a6.5,6.5,0,0,0,2.35,3.589,8.617,8.617,0,0,0,3.076,1.2c.253.06.4.3.549.494.45.663.876,1.343,1.3,2.024.084.147.169.295.264.445a52.932,52.932,0,0,1,4.895,10.891c.1.28.2.562.289.852.158.94.692,1.841.57,2.811a39.382,39.382,0,0,0-1.272-3.764c-.251-.627-.559-1.229-.81-1.855a29.651,29.651,0,0,0-4.023-6.23,21.989,21.989,0,0,0-4.831-4.252c-.353-.231-.719-.434-1.082-.638-.877-.326-1.693-.8-2.594-1.06a13.761,13.761,0,0,0-5.675-.6c-.8.062-1.584.279-2.381.381a14.563,14.563,0,0,0-6.285,3.586,12.641,12.641,0,0,0-3.166,4.88,17.189,17.189,0,0,0-.463,2.773,10.087,10.087,0,0,0,.719,3.887l.032.08a7.831,7.831,0,0,0,1.411,2.212,3.707,3.707,0,0,1-1.016.6,16.862,16.862,0,0,0-1.786,1.082,27.177,27.177,0,0,0-2.248,1.831,12.506,12.506,0,0,0-5.953,3.061l-.023.021a14.279,14.279,0,0,0-3.052,4.1c-.1.178-.193.359-.285.542.058-.057.173-.173.23-.23a13.435,13.435,0,0,0-1.249,3.21c-.072.342-.135.685-.2,1.03a.9.9,0,0,1-.414-.414c-.933-1.368-1.908-2.712-2.728-4.151l-.042-.075a23.918,23.918,0,0,1-1.936-3.809l-.128-.311c-.131-.315-.265-.627-.385-.943-.475-1.177-.852-2.389-1.254-3.592-.052-.281-.1-.561-.151-.838a36.047,36.047,0,0,1-.9-3.706c-.008-.032-.024-.1-.031-.128-.235-.427.2-.658.487-.886l.113-.058a5.743,5.743,0,0,0,.556-1.034,2.477,2.477,0,0,0-1.113-2.649,5.468,5.468,0,0,1,.54-2.111,7.369,7.369,0,0,1,1.684-2.511,7.793,7.793,0,0,1,7.182-1.944,6.68,6.68,0,0,1,3.686,2.534,4.418,4.418,0,0,1,.883,2.343,4.655,4.655,0,0,1-.393,2.523,5.314,5.314,0,0,1-4.073,3.052l-.1.066a5.155,5.155,0,0,1-4.366-1.542,3.565,3.565,0,0,1-.809-3.673,3.023,3.023,0,0,1,1.239-1.552,5.874,5.874,0,0,0,.4,1.7,2.1,2.1,0,0,0,2.511,1.1,2.294,2.294,0,0,0,1.455-2.413,2.983,2.983,0,0,0-2.148-2.468,4.383,4.383,0,0,0-3.922.958,4.728,4.728,0,0,0-1.516,2.59,9.464,9.464,0,0,0-.008,1.525,5.733,5.733,0,0,0,1.141,2.671,6.138,6.138,0,0,0,2.468,1.851,10.024,10.024,0,0,0,3.417.7,13.951,13.951,0,0,0,1.866-.066,8.59,8.59,0,0,0,1.861-.652,7.676,7.676,0,0,0,1.933-1.43,6.815,6.815,0,0,0,1.577-5.577,10.238,10.238,0,0,0-.98-2.775l-.25,0a6.916,6.916,0,0,0,.489,1.37,6.948,6.948,0,0,1-.121,4.557,6.362,6.362,0,0,1-2.437,3.035c-.334.19-.649.505-1.062.443l.387-.077a7.859,7.859,0,0,0,1.789-1.954,7.1,7.1,0,0,0-.687-7.328,8.533,8.533,0,0,0-5.183-3.489,8.031,8.031,0,0,0-3.993.165,8.64,8.64,0,0,0-4.708,3.365,10.7,10.7,0,0,0-1.719,4.293c-.407-.012-.81-.012-1.211-.007l-.1.066a6.135,6.135,0,0,0-.656.093,6.579,6.579,0,0,0-3.653,2.2,5.76,5.76,0,0,0-.873,1.539c-.026.081-.078.243-.1.323a3.907,3.907,0,0,0-.185,1.178c.025.369.058.74.086,1.112l.021.215-.18-.055c.056.073.117.148.185.225a2.782,2.782,0,0,1,.2.464,6.718,6.718,0,0,0-.192-1.224q.008-.321.045-.634c.007-.053.021-.16.029-.214a5.532,5.532,0,0,1,.338-.948,3.251,3.251,0,0,1,3.565-1.618c.4.112.942.223,1.04.7a2.561,2.561,0,0,0,.919,1.361c.273.106.556.2.834.311.005.228.016.458.036.689a30.651,30.651,0,0,0,1.786,5.31c.291.684.606,1.359.907,2.041.225.465.441.934.658,1.407.656,1.383,1.332,2.758,2.07,4.1a54.142,54.142,0,0,0,3.984,6.33c.02,1.147-.066,2.3-.026,3.448a19.641,19.641,0,0,0,.654,4.8c.272,1.393.762,2.735.993,4.138-.019-.205-.032-.405-.042-.606.447,1.8,1.132,3.533,1.7,5.3a14.6,14.6,0,0,0-7.12-3.243,18.538,18.538,0,0,0-3.957-.1,16.914,16.914,0,0,0-5.983,2.237,25.319,25.319,0,0,0-8.986,10.094c-.267.542-.558,1.075-.781,1.637-.621,1.464-1.2,2.947-1.717,4.452a11.953,11.953,0,0,1,.73-2.824c.137-.461.3-.913.458-1.366.336-.9.67-1.8,1.04-2.686a50.686,50.686,0,0,1,3.537-6.976c.782-1.315,1.677-2.555,2.538-3.817,1.093-.41,2.33-.455,3.314-1.147a7.374,7.374,0,0,0,2.393-2.795,3.23,3.23,0,0,0-.235.233,11.281,11.281,0,0,0,.731-1.908c.144-.489.389-.943.5-1.443-.609.179-1.122.58-1.731.758a17.032,17.032,0,0,0-4.1,1.459,4.717,4.717,0,0,0-1.873,2.44,5.117,5.117,0,0,0-.228,1.444c.4-.03.586-.412.825-.682a8.818,8.818,0,0,1,2.63-2.005c0,.264-.245.383-.423.522a6.411,6.411,0,0,0-2.348,2.739,55.907,55.907,0,0,0-4.533,7.573c-.277.595-.54,1.2-.827,1.785a17.446,17.446,0,0,1,.452-2.263c.124-.537.169-1.087.27-1.627.2-1.346.25-2.708.366-4.061a39.993,39.993,0,0,0-.84-9.341c-.256-1.328-.709-2.608-.974-3.934a5.408,5.408,0,0,0-.32-.893,13.955,13.955,0,0,0-1.488-2.494c-.536-.777-1.236-1.423-1.765-2.2a15.932,15.932,0,0,1,2.263,2.205,11.9,11.9,0,0,1,2.335,3.978c.05.231.241.317.463.353a7.809,7.809,0,0,0,.236-2.719,6.423,6.423,0,0,0-2.179-4.383,23.423,23.423,0,0,0-2.76-2.051,12.874,12.874,0,0,1-3.584-2.771l.078-.075a14.719,14.719,0,0,1,4.856,2.581,16.038,16.038,0,0,1,5.329,8.1,12.785,12.785,0,0,1-.153,1.6c.2.1.407.2.607.311l.03.164c.1.775.23,1.549.289,2.331.331,1.336.053,2.725.279,4.069a26.555,26.555,0,0,0,.056-4.065c0-.749-.209-1.486-.154-2.233.133.1.29.2.437.307a1.717,1.717,0,0,0,1.817.274l.194-.026a54.1,54.1,0,0,1-1.842,7.615c-.1.342-.21.682-.341,1.014l.214.247c.172-.557.383-1.1.561-1.656a52.39,52.39,0,0,0,1.872-7.379c.025-.913.843-1.476,1.2-2.259.154-.435.5-.882.272-1.352-.307.111-.606.231-.9.361a.628.628,0,0,1,.473-.743l.053-.1a1.32,1.32,0,0,1-.5-.481l.1-.189a1,1,0,0,0,.078-.734c-.027-.158-.053-.316-.066-.468a1.993,1.993,0,0,1,.759.49l.1-.128a6.391,6.391,0,0,0-.5-2.98,4.536,4.536,0,0,1-.141-2.133c-.043-.79-.068-1.58-.091-2.368,0-.312-.016-.622-.05-.928-.24-.423-.094-.938-.153-1.4a43.176,43.176,0,0,0-1.7-8.483c-.214-.656-.428-1.309-.67-1.953-.265-.75-.591-1.475-.894-2.209a35.858,35.858,0,0,0-3.2-5.674,33.014,33.014,0,0,0-7.331-7.565,29.6,29.6,0,0,0-10.167-5.06,28.663,28.663,0,0,0-5.024-.847c-1.3-.009-2.6-.044-3.892.053a22.429,22.429,0,0,0-11.605,4.524,23.423,23.423,0,0,0-3.745,3.686,20.518,20.518,0,0,0-3.294,6.01,24.1,24.1,0,0,0-.781,3.156,26.445,26.445,0,0,0-.123,4.03,12.313,12.313,0,0,0,.231,1.988,19.389,19.389,0,0,0,3.883,8.543l.154.194a19.818,19.818,0,0,0,5.1,4.265,14.915,14.915,0,0,0,2.655,1.152,19.637,19.637,0,0,0,3.326.689,16.955,16.955,0,0,0,6.966-.989c.557-.213,1.1-.469,1.643-.721a15.445,15.445,0,0,0,5.079-4.39,13.964,13.964,0,0,0,2.47-5.718,24.391,24.391,0,0,1,.017-3.264,10.926,10.926,0,0,0-.526-2.5,13.009,13.009,0,0,0-.822-1.949,12.444,12.444,0,0,0-3.534-4.161,11.451,11.451,0,0,0-5.134-2.12,12.256,12.256,0,0,0-3.974.368,10.14,10.14,0,0,0-6.559,5.9,3.756,3.756,0,0,0-.149.435c-.094.33-.172.663-.248,1a9.03,9.03,0,0,0,.407,4.4,9.218,9.218,0,0,0,1.4,2.358,7.227,7.227,0,0,0,5.885,2.755,7.041,7.041,0,0,0,3.658-1.317,5.972,5.972,0,0,0,2.494-5.151,5.462,5.462,0,0,0-1.223-2.977,4.716,4.716,0,0,0-4.449-1.633,3.47,3.47,0,0,0-2.513,1.94,3.624,3.624,0,0,0-.09,2.639,3.494,3.494,0,0,0,3.1,2.184,3.417,3.417,0,0,0,3.079-1.761,3.057,3.057,0,0,0,.279-.822l.183-.066a5.322,5.322,0,0,1-.1,1.506,4.59,4.59,0,0,1-4.571,3.419,4.54,4.54,0,0,1-3.172-1.157,6.192,6.192,0,0,1-1.434-7.8,7.816,7.816,0,0,1,6.157-3.8,7.615,7.615,0,0,1,5.365,1.506,10.125,10.125,0,0,1,3.635,5.009,9.937,9.937,0,0,1,.429,1.855,10.277,10.277,0,0,1-.474,4.6,11.067,11.067,0,0,1-2.8,4.317,2.229,2.229,0,0,0-.21.209,13.048,13.048,0,0,1-12.212,3.177,13.874,13.874,0,0,1-5.747-3.146,16.752,16.752,0,0,1-5.114-8.467,15.59,15.59,0,0,1-.365-6.027,17.228,17.228,0,0,1,4.26-9.324,17.682,17.682,0,0,1,2.738-2.613,19.919,19.919,0,0,1,5.721-3.158,22.464,22.464,0,0,1,3.582-.937,23.929,23.929,0,0,1,7.571.014,25.646,25.646,0,0,1,5.673,1.6,30.607,30.607,0,0,1,6.249,3.554,32.258,32.258,0,0,1,10.238,12.472c.367.761.7,1.541,1,2.332.178.449.348.9.5,1.363a40.435,40.435,0,0,1,1.854,7.834,10.717,10.717,0,0,1,.19,1.277c.168,1.693.3,3.39.3,5.091h-.03a11.778,11.778,0,0,0-3.189.282c-.054.988-.587,1.891-.531,2.892.245.718,1.024.971,1.658,1.239a13.846,13.846,0,0,0,1.965.515c-.009.072-.025.214-.032.286-.918,0-1.833-.1-2.748-.024a1.674,1.674,0,0,0-.757.59,5.659,5.659,0,0,0-.3.5,16.526,16.526,0,0,0-4.5-7.156,14.07,14.07,0,0,0-8.124-3.756,13.18,13.18,0,0,0-3.661.25,10.514,10.514,0,0,0-5.829,3.725c-.154.21-.292.43-.43.651a24.761,24.761,0,0,0-2.9.146l.088.07a16.283,16.283,0,0,0-4.209,1.085,17.736,17.736,0,0,0-9.028,7.891,15.968,15.968,0,0,0-2,7.908,11.441,11.441,0,0,0,8.3,10.966,10.668,10.668,0,0,0,7.3-.489,12.184,12.184,0,0,0,3.311-2.321,10.628,10.628,0,0,0,3.022-5.657,8.018,8.018,0,0,0-2-6.778,7.882,7.882,0,0,0-6.569-2.48,6.443,6.443,0,0,0-4.776,3.627,4.817,4.817,0,0,0,.443,4.739,2.81,2.81,0,0,0,2.227,1.2,2.958,2.958,0,0,0,3.417-2.567l-.184-.3a4.668,4.668,0,0,0-.522-.019c-.157.175-.277.377-.418.563a2.131,2.131,0,0,1-2.872.461,3.264,3.264,0,0,1-1.192-2,3.449,3.449,0,0,1,.586-2.482,5.561,5.561,0,0,1,6.279-2.279,5.741,5.741,0,0,1,2.4,1.6,8.049,8.049,0,0,1,2.129,5.7,8.4,8.4,0,0,1-2.611,5.655,9.116,9.116,0,0,1-6.157,2.635,8.58,8.58,0,0,1-5.762-2.141,9.14,9.14,0,0,1-3.153-7.134,11.737,11.737,0,0,1,1.25-5.3,16.2,16.2,0,0,1,10.208-8.682,9.938,9.938,0,0,1,2.055-.423c-.023.262-.048.527-.089.791a8.825,8.825,0,0,0,4.883,8.7,7.507,7.507,0,0,0,4.47.508,7.989,7.989,0,0,0,2.554-1.086,12.18,12.18,0,0,0,1.608-1.44c.242.044.486.121.733.189.289.151.582.3.873.453a7.261,7.261,0,0,1,2.289,2.034,16.763,16.763,0,0,1,1.2,3,24.489,24.489,0,0,1,.971,4.856,32.826,32.826,0,0,1,.137,4.11,30.259,30.259,0,0,1-.334,4.461,69.818,69.818,0,0,1-1.642,8.345c-.245,1.057-.521,2.108-.836,3.148a5.619,5.619,0,0,1-.311-1.407,16.892,16.892,0,0,0-3.557-7.95,10.925,10.925,0,0,0-2.956-2.459,9.485,9.485,0,0,0-2.076-.869,9.113,9.113,0,0,0-6.543.877,8.481,8.481,0,0,0-3.991,6.09,15.269,15.269,0,0,0-.061,2,6.947,6.947,0,0,0,3.069,5.184,4.391,4.391,0,0,0,1.848.629c.318.029.642.058.966.081-.016.047-.05.141-.066.188q-.766.022-1.529,0l.07-.107a4.829,4.829,0,0,1-1.535-.4,6.7,6.7,0,0,1-4.039-5.23,6.289,6.289,0,0,0,.846-1.6,5.051,5.051,0,0,0-.156-1.907c-.119-.3-.251-.581-.377-.868a1.77,1.77,0,0,0-.464-1,5.314,5.314,0,0,0-.346,1.008c-.492.912-1.262,1.763-1.282,2.852a2.766,2.766,0,0,0,.752,1.99,10.551,10.551,0,0,1,.214-2.275c.03.148.066.3.111.449a2.4,2.4,0,0,0,.255,1.807,8.035,8.035,0,0,1,.59,1.5,6.764,6.764,0,0,0,3.633,3.893,7.4,7.4,0,0,0,7.12-1.177c.465-.384.893-.812,1.328-1.23a6.461,6.461,0,0,0,1.8-3.336,6.126,6.126,0,0,0-.409-3.344,4.589,4.589,0,0,0-3.121-2.554,4.931,4.931,0,0,0-3.238.473,3.183,3.183,0,0,0-1.637,3.307,2.409,2.409,0,0,0,2.261,1.943,2.079,2.079,0,0,0,2.028-2.319,5.836,5.836,0,0,0-.52-1.573,2.663,2.663,0,0,1,2,.821,3.563,3.563,0,0,1,.978,3.621,5.034,5.034,0,0,1-5.11,3.7,4.924,4.924,0,0,1-4.98-3.83,6.1,6.1,0,0,1,.417-3.484,7.3,7.3,0,0,1,5.8-4.214,7.478,7.478,0,0,1,6.237,2.083,13.183,13.183,0,0,1,3.258,5.02l.077.158c.115.289.213.587.3.891a47.942,47.942,0,0,1,1.277,4.65,15.971,15.971,0,0,1,.544,3.3,20.745,20.745,0,0,1,.424,5.652c.008,1.564-.194,3.117-.269,4.677l-.2-.026-.048-.041a18.881,18.881,0,0,0-3.789-3.227,9.456,9.456,0,0,1-1.054-2.644,6.544,6.544,0,0,1-.03-2.234,11.706,11.706,0,0,0,.5,2.74,4.16,4.16,0,0,0,.745,1.189l.291.02c-.019-.847.434-1.613.43-2.458a4.124,4.124,0,0,0-.334-2c-.438-1.133-1.478-1.843-2.169-2.8l-.267-.025a6.924,6.924,0,0,1-.245,2.274,5.006,5.006,0,0,0,.1,3.664c.323.736,1.159,1.087,1.419,1.863a16.4,16.4,0,0,1-1.58-.694,14.037,14.037,0,0,0-3.04-.838,13.547,13.547,0,0,0-5.1.269,2.045,2.045,0,0,1-1.241.22,13.736,13.736,0,0,0-3.56-.4,18.025,18.025,0,0,0-7.178,1.494,9.588,9.588,0,0,0-.955.469c0,.068.009.206.011.275a15.132,15.132,0,0,0,1.431-.531,16.079,16.079,0,0,1,4.331-1.054c1.236-.07,2.478-.04,3.717-.007l-.063.218a20.709,20.709,0,0,0-4.011,1.294,19.61,19.61,0,0,0-5.614,3.659,10.228,10.228,0,0,0-2.209,2.928,4.151,4.151,0,0,0,.1,4.028,3.434,3.434,0,0,0,1.588,1.295l-.053.17c.47.014.948-.041,1.425-.026a4.629,4.629,0,0,1-1.327-.158,4.213,4.213,0,0,0,1.457,0,3.345,3.345,0,0,0,1.2-.716,9.681,9.681,0,0,0,2.668,6.792,11.55,11.55,0,0,0,4.97,3.084,13.31,13.31,0,0,0,8.436-.175,10.122,10.122,0,0,0,6.127-6.013,11.287,11.287,0,0,0,.314-4.28,7.212,7.212,0,0,0-4.208-5.395,7.062,7.062,0,0,0-5.158.206,6.172,6.172,0,0,0-3.4,3.985,4.29,4.29,0,0,0,.506,3.205,3.027,3.027,0,0,0,3.46,1.4,3.058,3.058,0,0,0,1.845-1.888,2.948,2.948,0,0,0-2.047-3.626,5.129,5.129,0,0,0-2.036-.157,4.261,4.261,0,0,1,1.251-.953,5.546,5.546,0,0,1,6.318,1.075,6.075,6.075,0,0,1,1.563,2.9,6.446,6.446,0,0,1-.257,3.815,8.143,8.143,0,0,1-7.873,5.276,8.924,8.924,0,0,1-6.459-2.465,9.512,9.512,0,0,1-2.967-7.228,8.341,8.341,0,0,1,.408-2.88,10.8,10.8,0,0,1,11.007-7.426,13.149,13.149,0,0,1,7.646,2.567,19.409,19.409,0,0,1,5.769,6.614,19.127,19.127,0,0,1,1.586,4.116,20.666,20.666,0,0,1,.647,3.407c-.515-.705-.836-1.53-1.361-2.228a4.49,4.49,0,0,1-.806-1.3,2.778,2.778,0,0,0-1.927-1.913,28.872,28.872,0,0,1-2.923-.7c.009.044.025.132.033.175q.327.608.6,1.248a3.651,3.651,0,0,0,1.769,1.855,16.905,16.905,0,0,0,2.078.478l.044-.036c.006-.044.019-.132.026-.177-.273-1.054-1.425-1.419-2.223-1.993a2.96,2.96,0,0,1,1.365.678c.4.444.795.9,1.162,1.382a15.608,15.608,0,0,1,2.387,5.424.81.81,0,0,1-.068.362,6.734,6.734,0,0,0-7.035-.878,6.857,6.857,0,0,0-3.637,5.707,4.7,4.7,0,0,0,.738,2.666,3.852,3.852,0,0,0,3.217,1.744,2.886,2.886,0,0,0,2.612-1.453,2.992,2.992,0,0,0,.327-2.841,2.664,2.664,0,0,0-3.753-.958,2.449,2.449,0,0,0-.353,3.33,1.926,1.926,0,0,0,2.208.756,1.239,1.239,0,0,1,.7-.118,2.747,2.747,0,0,1-3.211.275,3.457,3.457,0,0,1-1.7-2.335,5.141,5.141,0,0,1,.409-3.077,6.364,6.364,0,0,1,2.628-2.778,4.616,4.616,0,0,1,3.488-.437,6.16,6.16,0,0,1,3.74,4.081,12.774,12.774,0,0,1,.172,5.176c-.187,1.338-.525,2.648-.835,3.96-.322,1.173-.566,2.367-.948,3.523-.906,2.825-2.142,5.528-3.141,8.319a14.136,14.136,0,0,0-.789,2.907c-.03.617-.137,1.228-.19,1.845a33.332,33.332,0,0,0,.076,5.082c.044.812.2,1.615.279,2.426a47.924,47.924,0,0,0,1.461,5.778c.331,1.012.7,2.014,1.126,2.994-.077-.1-.159-.2-.225-.294-.454-.749-.843-1.534-1.235-2.314a37.814,37.814,0,0,1-3.9-15.542,1.455,1.455,0,0,1,.153-.908,14.988,14.988,0,0,1,1.531-1.795,8.428,8.428,0,0,0,1.873-2.491,8.651,8.651,0,0,0,.811-3.636c.112-2.215-.9-4.264-1.152-6.436-.147.009-.286.022-.42.041a9.212,9.212,0,0,1-2.075,3.115,16.863,16.863,0,0,0-3.282,4.518,7.231,7.231,0,0,0-.418,3.167,8.171,8.171,0,0,0,1.042,3.014l.311-.077a19.73,19.73,0,0,1,.669-3.489,17.667,17.667,0,0,1,1.164-2.508,7.07,7.07,0,0,1,1.026-1.615c-.415,1.068-.969,2.078-1.343,3.164a9.077,9.077,0,0,0-.556,4.074c.084,1.2-.044,2.408.122,3.6.057.493.051.991.108,1.488.021.124.049.256.073.391a37.7,37.7,0,0,0,3.643,12.139c.354.717.734,1.422,1.129,2.12-.108-.1-.214-.2-.31-.3-.433-.5-.865-1-1.3-1.5-.923-1.011-1.91-1.959-2.885-2.918-1-.9-2-1.791-3.057-2.622-.418-.328-.7-.8-1.135-1.1a7.935,7.935,0,0,0-2.271-1.122c-.536-.139-1.056-.328-1.573-.519a8.393,8.393,0,0,1,2.254.437,7.87,7.87,0,0,1,2.09,1,1.478,1.478,0,0,0,.985.432,4.98,4.98,0,0,0-2.4-2.911,7.692,7.692,0,0,0-3.322-.578,10.8,10.8,0,0,1-3.034-.19c-.179-.047-.354-.078-.525-.106,0,.07.011.209.015.279.817.906,1.366,2.015,2.183,2.921a6.206,6.206,0,0,0,2.861,1.692,8.788,8.788,0,0,0,2.363.112c.354.007.775-.1,1.063.184,1.131.846,2.186,1.789,3.231,2.738a55.691,55.691,0,0,1,4.519,4.723c.6.781,1.25,1.522,1.812,2.333.211.308.434.612.671.909.948,1.276,1.761,2.643,2.583,4-.377-.461-.693-.965-1.051-1.437-.576-.79-1.159-1.571-1.789-2.317-.231-.287-.451-.582-.7-.845a33.129,33.129,0,0,0-4.719-4.314,23.428,23.428,0,0,0-6.748-3.49,15.212,15.212,0,0,0-8.865-.224,14.746,14.746,0,0,0-9.3,8.418,18.567,18.567,0,0,0-.541,1.815,12.817,12.817,0,0,0-.278,3.562,8.813,8.813,0,0,0,2.84,5.734l.167.124a6.688,6.688,0,0,0,1.8,1.368,3.154,3.154,0,0,1-1.111.093,15.825,15.825,0,0,0-5.093.935,17.687,17.687,0,0,0-2.256.99,26.482,26.482,0,0,0-3.083,1.978c-.289.3-.621.562-.937.837a21.788,21.788,0,0,0-1.651,1.756q-.33.386-.644.786a19.124,19.124,0,0,0-2.141,3.765,23.329,23.329,0,0,0-1.7,9.415,33.662,33.662,0,0,0,1.395,8.963h.746a26.608,26.608,0,0,1-1.151-7.709,17.373,17.373,0,0,1,.271-3.594,7.16,7.16,0,0,1,2.964-3.784,7.1,7.1,0,0,1,5.069-1.068c.485.092.953.272,1.448.338-.005-.162-.005-.318,0-.471a7.2,7.2,0,0,1-1.205-.28,7.517,7.517,0,0,0-6.607,1.664,4.374,4.374,0,0,1-.555.463,11.951,11.951,0,0,1,.909-1.409,11.466,11.466,0,0,1,3.136-2.866,6.66,6.66,0,0,1,1.751.224,4.49,4.49,0,0,0,2.931-.683,17.449,17.449,0,0,0,2.355-2.144c.077-.123.137-.256.2-.382a9.4,9.4,0,0,1-2.372-.114,6.282,6.282,0,0,0-3.723.179,3.091,3.091,0,0,0-1.634,1.862,8.39,8.39,0,0,0,.908-.363,7.279,7.279,0,0,1,3.444-.54,17.006,17.006,0,0,0-2.342.455,4.292,4.292,0,0,0-1.08.465,13.207,13.207,0,0,0-3.943,3.388l.033.056c-.072.111-.141.225-.2.343l-.3.01a2.9,2.9,0,0,1,.337-.7c.28-.448.494-.932.762-1.386a16.657,16.657,0,0,1,3.509-4.2,16.3,16.3,0,0,1,6.345-3.35,15.578,15.578,0,0,1,9.274.368,16.223,16.223,0,0,1,2.258,1.01,15.6,15.6,0,0,1,2.333,1.534,16.726,16.726,0,0,1,2.606,2.557q.4.5.757,1.026a11.724,11.724,0,0,1,1,1.777,9.611,9.611,0,0,1-.286,8.772,8.742,8.742,0,0,1-5.341,4.118,7.888,7.888,0,0,1-2.148.192,8.4,8.4,0,0,1-2.015-.177,9.254,9.254,0,0,1-5-3.045,7.65,7.65,0,0,1-1.779-5.1,7.026,7.026,0,0,1,2.205-5.35,5.735,5.735,0,0,1,7.114.021,3.845,3.845,0,0,1,1.187,1.728,3.188,3.188,0,0,1-.613,2.958,2.209,2.209,0,0,1-1.731.586,2.552,2.552,0,0,1-1.617-.9c-.2.162-.627.244-.534.581a2.751,2.751,0,0,0,.82,1.133,3.5,3.5,0,0,0,3.322.333,2.891,2.891,0,0,0,1.561-1.52,4.738,4.738,0,0,0,.167-3.035,5.222,5.222,0,0,0-.984-1.868,5.886,5.886,0,0,0-1.057-.973,6.377,6.377,0,0,0-6.505-.555,8.808,8.808,0,0,0-3.048,2.571,7.416,7.416,0,0,0-1.434,3.922,8.9,8.9,0,0,0,2.378,6.52,11.427,11.427,0,0,0,3.994,2.809,14.341,14.341,0,0,0,2.885.792,11.884,11.884,0,0,0,4.251-.357,12.375,12.375,0,0,0,2.887-1.322,11.732,11.732,0,0,0,4.785-6.473,11.082,11.082,0,0,0,.393-3.2l.234.052a7.882,7.882,0,0,0,3.927,2.05,17.615,17.615,0,0,0,3.51.156,10.471,10.471,0,0,0,4.088-1.534,6.677,6.677,0,0,0,1.7-1.42,3.136,3.136,0,0,1-1.292,1.555l-.031.245a2.817,2.817,0,0,0,1.986-.882,6.809,6.809,0,0,0,1.045-2.477,5.4,5.4,0,0,1,.567-1.228c-1.172.365-2.5.633-3.3,1.651a4.982,4.982,0,0,0-.883,2.179c-.068.254-.342.353-.549.466a10.3,10.3,0,0,1-2.34.724,9.072,9.072,0,0,0,1.306-.986,5.943,5.943,0,0,0,1.625-3.011,5.1,5.1,0,0,0-.646-3.34,4.592,4.592,0,0,0-2.141-1.83,2.936,2.936,0,0,0-3.656,1.158,7.1,7.1,0,0,0-.393.892,2.174,2.174,0,0,0,.46,1.652,1.9,1.9,0,0,0,2.168.687,2.912,2.912,0,0,0,1.051-.989,2.348,2.348,0,0,0-.294-1.88c-.331-.189-.913-.044-.943.389a.953.953,0,0,1,.444,1.34,1.1,1.1,0,0,1-1.9-.617,1.855,1.855,0,0,1,1.916-1.637,1.92,1.92,0,0,1,1.054.459,3.617,3.617,0,0,1,1.132,3.727,4.647,4.647,0,0,1-3.932,3.366,5.976,5.976,0,0,1-5.492-2.917,5.413,5.413,0,0,1-.652-1.71,6.456,6.456,0,0,1-.151-1.96,5.755,5.755,0,0,1,.581-2.421,5.614,5.614,0,0,1,1.415-1.826,8.825,8.825,0,0,1,6.959-1.777,9.693,9.693,0,0,1,3,1.019,11.668,11.668,0,0,1,2.205,1.5,14.423,14.423,0,0,1,1.988,2.162c.43.572.859,1.149,1.235,1.763a25.93,25.93,0,0,1,1.414,2.694,5.3,5.3,0,0,1,.276.678,4.856,4.856,0,0,1-.246,1.109,38.114,38.114,0,0,0-.642,9.915,6.213,6.213,0,0,1-3.937.294,3.937,3.937,0,0,1-2.6-2.149,2.518,2.518,0,0,1,.975-3.059,1.977,1.977,0,0,1,1.527-.154c.083.192-.191.28-.26.43a1.7,1.7,0,0,0-.131,2.2,1.27,1.27,0,0,0,1.241.282,1.594,1.594,0,0,0,.827-2.025,2.478,2.478,0,0,0-2.82-1.582,2.955,2.955,0,0,0-2.031,2.044,3.481,3.481,0,0,0,1.143,3.608,5.247,5.247,0,0,0,2.28,1.113,7.319,7.319,0,0,0,3.813-.318c.1,1.447.248,2.893.337,4.342h1.837a5.05,5.05,0,0,1,1.418-1.938,5.825,5.825,0,0,0-1.035,1.938h.709a4.625,4.625,0,0,1,3.6-3.156,6.2,6.2,0,0,1,5.855,3.156h.723a7,7,0,0,0-3.5-3.538,6.05,6.05,0,0,0-3.7-.427,7.051,7.051,0,0,0-3.38,1.826c-.369.274-.586.711-.991.939a15.108,15.108,0,0,1,1.111-6.913,4.377,4.377,0,0,0,2.261-1.562,7.9,7.9,0,0,0,.847-3.164c-.894.745-2.047,1.047-2.967,1.745a2.947,2.947,0,0,0-1.04,2.542l.205.055a5.07,5.07,0,0,1,2.1-2.256,5.705,5.705,0,0,0-1.728,2.238,15.564,15.564,0,0,0-1.093,3.157,10.285,10.285,0,0,1-.3,1.368c-.119-1.282-.231-2.565-.291-3.849a19.522,19.522,0,0,1,2.11-9.149,17.68,17.68,0,0,1,1.082-1.867,16.717,16.717,0,0,1,1.793-2.251c.313-.322.629-.641.964-.94s.7-.583,1.067-.859a13.246,13.246,0,0,1,2.678-1.508,11.592,11.592,0,0,1,9.416.072,10.254,10.254,0,0,1,3.71,2.917c.094.112.178.22.281.35a9.923,9.923,0,0,1,1.258,2.266,8.691,8.691,0,0,1,.659,3.447,9.263,9.263,0,0,1-5.312,8.812,8.911,8.911,0,0,1-6.114.6,7.817,7.817,0,0,1-5.293-4.642,7.124,7.124,0,0,1-.341-3.337,5.576,5.576,0,0,1,6.717-4.54,2.272,2.272,0,0,1,1.1.545,4.026,4.026,0,0,0-1.811.637,3.591,3.591,0,0,0-1.373,1.867,3.322,3.322,0,0,0,.085,1.608,2.918,2.918,0,0,0,2.92,1.914,3,3,0,0,0,2.164-1.352,3.9,3.9,0,0,0,.269-3.657,5.237,5.237,0,0,0-1.393-1.927,6.723,6.723,0,0,0-1.907-1.134,7.826,7.826,0,0,0-3.627-.346l-.113.047a6.273,6.273,0,0,0-3.768,2.375,7.572,7.572,0,0,0-1.316,3.238,8.194,8.194,0,0,0,1.731,6.326,10.141,10.141,0,0,0,6.473,3.626,14.772,14.772,0,0,0,4.579-.225,14.576,14.576,0,0,0,2.5-.848,12.469,12.469,0,0,0,3.868-2.681,10.941,10.941,0,0,0,3-6.219,12.074,12.074,0,0,0-.362-3.7,2.6,2.6,0,0,0,3.523-.813,4.408,4.408,0,0,0,.581-1.423,4.462,4.462,0,0,0-1.372-3.6,9.2,9.2,0,0,0-1.384-1.162,12.012,12.012,0,0,0-1.422-.849,17.959,17.959,0,0,0-3.562-1.375,17.645,17.645,0,0,0-3.054-.6c-1.395-.207-2.807-.066-4.207-.152a5.262,5.262,0,0,1,1.514-.626,16.649,16.649,0,0,1,6.879-.692c.414-.012.7.311.99.563a16.948,16.948,0,0,0,1.434,1.286,5.481,5.481,0,0,0,2.531.765c1.367.1,2.631-.562,3.98-.656l-.094-.27c-1.3-.558-2.18-1.73-3.29-2.561a12.411,12.411,0,0,1-1.178-.576,4.023,4.023,0,0,0-3.508.277l.07.28a7.528,7.528,0,0,1,4.259,1.568,16.834,16.834,0,0,0-3.122-1.09c-.7-.193-1.387.156-2.087.055a17.763,17.763,0,0,0-8.242.9,13.649,13.649,0,0,0-2.417,1.159c-.464.077-.942,0-1.408.032a12.065,12.065,0,0,0-2.817.428,14.544,14.544,0,0,0-1.917.714c-.506.249-1,.527-1.479.818a17.826,17.826,0,0,0-2.714,2.271c.1-.721-.045-1.571.5-2.139.173-.357.294-.734.432-1.1a4.544,4.544,0,0,0-.6-2.913c-.154-.272-.306-.544-.449-.815a6.015,6.015,0,0,1-.752-1.8l-.188-.175a8.089,8.089,0,0,1-.982,2,6.245,6.245,0,0,0-.362,3.057,7.272,7.272,0,0,0,.692,1.489,5.853,5.853,0,0,1,.46.876c.055.116.082.291.236.34.087-.107.16-.226.25-.333a6.18,6.18,0,0,0,.058-3.816l.067-.005a8.709,8.709,0,0,1,.51,2.937c-.06.519-.071,1.045-.172,1.56a12.092,12.092,0,0,1-.349,1.362,2.031,2.031,0,0,1-.388.761,17.3,17.3,0,0,0-1,1.465,11.432,11.432,0,0,0-.846,1.588l-.157.08c-.284-.766-.582-1.525-.851-2.294-.221-.586-.4-1.188-.6-1.777-.178-.515-.326-1.037-.455-1.562a9.763,9.763,0,0,1-.5-2.006c-.093-.459-.2-.914-.254-1.376a15.712,15.712,0,0,1-.255-2.387l-.119-.076a49.578,49.578,0,0,1-.112-7.818c.037.238.081.486.131.733v.012a10.419,10.419,0,0,1,.532-3.834c.009-.024.025-.072.033-.1.015-.047.046-.142.062-.189a10.031,10.031,0,0,1,2-3.589,7.074,7.074,0,0,1,5.65-2.429,6.855,6.855,0,0,1,5.565,2.473,5.611,5.611,0,0,1,1.348,3.357,4.747,4.747,0,0,1-2.862,4.59,5.106,5.106,0,0,1-3.313.549,3.14,3.14,0,0,1-1.491-.552,3.915,3.915,0,0,1-1.611-1.24,3.859,3.859,0,0,1-.836-3.329,2.834,2.834,0,0,1,2.048-2.278,5.971,5.971,0,0,0,.109,2.139,3.063,3.063,0,0,0,1.014,1.006,2.148,2.148,0,0,0,1.4.151,3.392,3.392,0,0,0,1.384-.957c.014-.048.042-.146.056-.194l-.205.249a2.669,2.669,0,0,0-.417-3.436,3.926,3.926,0,0,0-3.575-.943,4.441,4.441,0,0,0-3.025,2.225,5.1,5.1,0,0,0-.527,3.407,6.041,6.041,0,0,0,1.469,2.862,9.726,9.726,0,0,0,3.034,2.051,8.075,8.075,0,0,0,3.771.684,8.444,8.444,0,0,0,2.05-.511,6.085,6.085,0,0,0,2.878-2.253,8.945,8.945,0,0,0,1.1-2.632,22.988,22.988,0,0,0,.049-2.341,8.109,8.109,0,0,0-.182-1.855,7.935,7.935,0,0,0-.835-1.724,4.892,4.892,0,0,1,1.3,2.606l.27.109a3.6,3.6,0,0,0,.053-2.046,5.525,5.525,0,0,0-1.627-1.989,9.4,9.4,0,0,1-1.066-1.19c-.009.077-.023.233-.032.31,0,.724-.225,1.432-.167,2.159a3.369,3.369,0,0,0,.617,1.776c.357.454.858.766,1.233,1.205a5.344,5.344,0,0,1,.039,2.251,6.758,6.758,0,0,1-1.744,3.555,6.85,6.85,0,0,1-3.008,1.838c-.22-.009-.438,0-.648.011a5.652,5.652,0,0,0,2.121-1.054,7.066,7.066,0,0,0,1.253-1.491,7.571,7.571,0,0,0,.9-3.509,9.9,9.9,0,0,0-.383-2.259,10.792,10.792,0,0,0-1-2.137,8.58,8.58,0,0,0-10.059-3.234,9.212,9.212,0,0,0-4.35,3.577,13.815,13.815,0,0,0-1.689,3.689c-.047.643-.264,1.256-.335,1.9a27.221,27.221,0,0,0-.2,2.85c-.046,1.073.137,2.138.2,3.209a9.024,9.024,0,0,1-.524-.851q-.7-1.153-1.378-2.311-.08-.129-.142-.246c-.775-1.337-1.508-2.7-2.226-4.064a40.833,40.833,0,0,1-4.255-12.288,27.749,27.749,0,0,1-.188-4.466,8.646,8.646,0,0,1,.474-3.638,7.181,7.181,0,0,1,1.949-2.477,7.265,7.265,0,0,1,1.717-1.068,7.114,7.114,0,0,1,5.48-.168,1.232,1.232,0,0,0,.14-.308,1.036,1.036,0,0,0-.553-.286,7.76,7.76,0,0,0-6.464.809,6.733,6.733,0,0,0-1.115.877,2.278,2.278,0,0,0-.2.17c0-.041-.005-.122-.008-.163a13.359,13.359,0,0,1,2.326-2.829q.282-.257.582-.5a5.786,5.786,0,0,1,.558-.422c.515-.5,1.249-.259,1.868-.138a4.566,4.566,0,0,0,3.856-1.011,24.9,24.9,0,0,1,1.891-1.8c.008-.078.022-.235.03-.315a8.194,8.194,0,0,1-2.214-.093,10.5,10.5,0,0,0-2.858-.157,3.834,3.834,0,0,0-2.4,1.637,1.073,1.073,0,0,0-.19.541c.176-.065.356-.129.532-.206a6.321,6.321,0,0,1,3.671-.692,6.5,6.5,0,0,1-1.347.263,7.845,7.845,0,0,0-3.348,1.587,12.44,12.44,0,0,0-2.88,2.876c0-.016-.007-.05-.01-.066a8.937,8.937,0,0,1,.676-1.447,16.393,16.393,0,0,1,12.514-8.59c1.115-.056,2.235-.055,3.352,0a15.251,15.251,0,0,1,3.6.85,15.962,15.962,0,0,1,6.309,4.109,12.469,12.469,0,0,1,3.231,5.5,10.782,10.782,0,0,1,.168,2.55,11.145,11.145,0,0,1-.112,2.1,9,9,0,0,1-4.931,6.035,7.8,7.8,0,0,1-3.778.667,8.764,8.764,0,0,1-8.021-5.379,8.892,8.892,0,0,1-.492-3.962,6.588,6.588,0,0,1,3.279-5.073,6.454,6.454,0,0,1,3.485-.437,4.769,4.769,0,0,1,3.727,2.934,3.373,3.373,0,0,1-.415,2.676,2.134,2.134,0,0,1-2.424.744,3.845,3.845,0,0,1-1.123-.736c-.272-.034-.419.258-.6.4a2.771,2.771,0,0,0,.877,1.248,3.239,3.239,0,0,0,5.22-2.468,4.893,4.893,0,0,0-1.452-3.931,6.415,6.415,0,0,0-2.591-1.573,6.492,6.492,0,0,0-4.06.093,8.44,8.44,0,0,0-3.772,3.015,7.543,7.543,0,0,0-1.189,2.76,8.629,8.629,0,0,0,1.01,5.8,10.8,10.8,0,0,0,5.149,4.485,17.664,17.664,0,0,0,2.4.679,12.1,12.1,0,0,0,3.526.083,11.1,11.1,0,0,0,7.772-5.38,12.1,12.1,0,0,0,1.487-3.953c.369.4.668.851,1.02,1.265a34.929,34.929,0,0,0,2.987,3.243,6.906,6.906,0,0,1,.964,1.259c.211.313.573.476.811.772,1.406,1.79,2.926,3.484,4.441,5.182.587.6,1.083,1.282,1.715,1.842l.373-.2c0-.366-.274-.606-.492-.852a79.357,79.357,0,0,1-10.136-13.171c-.485-.886-.955-1.779-1.391-2.689-.618-1.168-.723-2.52-1.3-3.707a12.219,12.219,0,0,1-.987-3.627,20.192,20.192,0,0,1-.189-3.332,6.988,6.988,0,0,1,1.3-2.926c.1-.149.213-.291.326-.432a4.586,4.586,0,0,0,1.337.544,18.332,18.332,0,0,0,3.856.112c.327-.05.656-.107.988-.162.277-.149.64-.271.7-.628-.916-.633-1.868-1.218-2.735-1.912,1.041.346,2.034.825,3.087,1.137,0-.267.011-.531,0-.792a7.369,7.369,0,0,0-1.173-2.194c-.55-.9-1.051-2.013-2.134-2.362-1.392-.317-2.516.724-3.744,1.158a10.61,10.61,0,0,1,1.515-2.49,16.3,16.3,0,0,1,6.132-4.941,8.6,8.6,0,0,1,2.717-.881c.133.838.127,1.7.333,2.528a2.594,2.594,0,0,0,2.163,1.868c-.214-.32-.454-.618-.67-.929a4.672,4.672,0,0,1-.684-1.866,9.434,9.434,0,0,0,1.083,1.986c.224.209.48.387.719.591a6.694,6.694,0,0,0,.954.821c.174.118.35.234.532.357a2.44,2.44,0,0,1-.477.31,7.273,7.273,0,0,0-1.488,1.032c-.713-1.243-1.95-2.037-2.86-3.115a5.248,5.248,0,0,0-.9.384,17.608,17.608,0,0,0-2.595,1.1,1.624,1.624,0,0,0-.813,1.371,6.928,6.928,0,0,0,.422,2.333,11.861,11.861,0,0,0,1.146,2.725c.1.159.2.313.315.474a.609.609,0,0,0,.692.247c.083-.427.2-.845.313-1.261.154-.633.309-1.265.49-1.891a20.647,20.647,0,0,1-.05,2.2,5.514,5.514,0,0,0-.02,1.016,1.976,1.976,0,0,0,.76-.208c.184-.121.357-.253.55-.368a1.166,1.166,0,0,1-.24.693,1.285,1.285,0,0,0-.416.947c.235.041.474.086.719.133.03.185.043.372.072.565-.2.058-.391.119-.575.187a3.134,3.134,0,0,0,.937,1.1c.009.077.025.231.032.308a2.477,2.477,0,0,0-1.566-.562,7.328,7.328,0,0,0,.316,1.662,6.91,6.91,0,0,0,.357,1.192c-.112,0-.22,0-.322,0a11.891,11.891,0,0,0-.532-1.17c-.211-.379-.4-.767-.577-1.159l-.17-.012a3.44,3.44,0,0,0-.92,2.164,2.195,2.195,0,0,1-.091-.221c.117,1.315-.59,2.626-.152,3.926.437,1.067,1.678,1.333,2.678,1.6a18.118,18.118,0,0,0,2.108.5,11.821,11.821,0,0,1,1.739-2.194,6.439,6.439,0,0,1,.427-.606,4,4,0,0,0,.214-.994c.573.209,1.078.563,1.631.825-.025.067-.076.2-.1.267a4.783,4.783,0,0,0-.755.906,3.976,3.976,0,0,0-.461,1.595c-.045,1.652.131,3.306.012,4.959.509-.208.813-.694,1.264-.993a6.556,6.556,0,0,0,2.351-2.755,5.187,5.187,0,0,0,.246-3.122c.623.159,1.28.056,1.911.2a22.76,22.76,0,0,0-.687,4.186,6.7,6.7,0,0,0,.634,3.29,3.559,3.559,0,0,0,2.856,2.019c.18.52.032,1.1.295,1.6a3.961,3.961,0,0,0,.444.835c.009.01.024.03.031.04.1.111.2.224.314.338a3.726,3.726,0,0,0,1.458.739,3.308,3.308,0,0,0,2.571-.47c.125-.1.254-.2.389-.3a3.648,3.648,0,0,0,.883-2.1,1.971,1.971,0,0,1,.531.124c.234.09.465.2.71.285a6.506,6.506,0,0,0,1.52.493c1.1.053,2.2.027,3.3.031a2.212,2.212,0,0,0,1.292,1.213,2.235,2.235,0,0,0,1.676-.254,1.862,1.862,0,0,0,.75-.975,3.9,3.9,0,0,0,.125-1.156,14.11,14.11,0,0,0,4.983-4.158,11.955,11.955,0,0,0,1.724-3.566,10.649,10.649,0,0,0,.282-3.5,8.513,8.513,0,0,0-.95-3.319,8.257,8.257,0,0,0-5.149-4.05,6.683,6.683,0,0,0-3.05-.005,6.787,6.787,0,0,0-4.735,4.878,5.619,5.619,0,0,0,.41,3.944,4.169,4.169,0,0,0,2.317,2.02,2.979,2.979,0,0,0,3.412-.925,3.014,3.014,0,0,0,.483-2.429,2.838,2.838,0,0,0-2.268-2.035,3.682,3.682,0,0,0-1.872.188,7.994,7.994,0,0,0-1.438.917,4.635,4.635,0,0,1,1.779-3.177,5.737,5.737,0,0,1,3.638-1.2,5.551,5.551,0,0,1,3.725,1.469,6.807,6.807,0,0,1,1.91,2.816,8.127,8.127,0,0,1,.358,3.764,8.773,8.773,0,0,1-6.441,7.074,4.88,4.88,0,0,0-1.542-.139,4.118,4.118,0,0,0-.883.454,6.06,6.06,0,0,1-1.163.016,3.686,3.686,0,0,0-.326-1.421,2.291,2.291,0,0,0-1.473-1.17,2.445,2.445,0,0,0-2.085.4l-.23.219c-.038.067-.111.2-.148.27a1.789,1.789,0,0,1-1.174-.781,10.321,10.321,0,0,1-3.265-8.161,17.171,17.171,0,0,0,2.286-1.991,11.3,11.3,0,0,0,2.848-6.655,1.391,1.391,0,0,1,.458-.343,13.483,13.483,0,0,1,7.033-1.922,19.707,19.707,0,0,1,3.6.18,21.6,21.6,0,0,1,3.821,1.09,19.7,19.7,0,0,1,6.085,3.829,6.976,6.976,0,0,1,1.2,1.2l-.276-.057c-.524-.245-1.055-.466-1.587-.682-.545-.1-1.063-.3-1.6-.4-.354-.072-.694-.2-1.044-.256a11.3,11.3,0,0,0-2.354.114,5.28,5.28,0,0,1,2.945-.361l.239.021c-.01-.058-.03-.175-.041-.234a3.3,3.3,0,0,0-1.072-.576,2.143,2.143,0,0,0-1.772-.045,7.122,7.122,0,0,0-1.74.9,8.506,8.506,0,0,1-1.115.337c0,.04.006.119.009.159a14.962,14.962,0,0,1,1.678.837,4.128,4.128,0,0,0,1.965.24,2.278,2.278,0,0,0,1.123-.342c.146-.1.287-.2.434-.3a2.347,2.347,0,0,1,1.358.141,16.544,16.544,0,0,1,2.469,1.093,16.888,16.888,0,0,1,1.911,1.24c.011.076.031.228.042.3-.082.18-.173.357-.249.541a6.437,6.437,0,0,0-4.505,10.475,4.354,4.354,0,0,0,2.546,1.569,6.394,6.394,0,0,0,1.75-.009,9.039,9.039,0,0,0,1.6-.728l.093.229a10.52,10.52,0,0,0,5.514,3.052,14.178,14.178,0,0,0,3.755.244,18.255,18.255,0,0,0,2.295-.459,11.08,11.08,0,0,0,3.509-1.8v-1.566a7.359,7.359,0,0,1-5.481,2.623,9.452,9.452,0,0,1-8.134-3.653,1.972,1.972,0,0,1-.621-1.123,2.872,2.872,0,0,0-1.021-2.353,2.694,2.694,0,0,1-.49-1.688,13.2,13.2,0,0,1,.156-3.178,6.3,6.3,0,0,1,2.505,1.139,10.294,10.294,0,0,1,2.709,2.852,8.95,8.95,0,0,0,1.139,1.4l.445-.027a1.934,1.934,0,0,0,.06-1.269c-.061-.512-.137-1.02-.169-1.532a1.463,1.463,0,0,0-.368-1.061.769.769,0,0,1-.866-.256c-1.131-1.275-2.381-2.433-3.622-3.595-.244-.24-.6-.433-.634-.8a12.943,12.943,0,0,1,3.6-4.048,14.2,14.2,0,0,1,6.928-2.611,34.207,34.207,0,0,1,3.862.041v-.765a24.081,24.081,0,0,0-4.48-.153,14.035,14.035,0,0,0-10.871,6.78,13.679,13.679,0,0,1-1.521-1.25l.211-.257a5.753,5.753,0,0,0,2.729-5.58,3.361,3.361,0,0,0-3.1-2.816,2.814,2.814,0,0,0-2.091.761,2.419,2.419,0,0,0,.2,3.444,1.421,1.421,0,0,0,1.02.313A1.178,1.178,0,0,0,2912,837.5a1.816,1.816,0,0,0-1.006-.942,7.082,7.082,0,0,0-1.2-.031,1.392,1.392,0,0,1,.769-1.1,2.489,2.489,0,0,1,3.251.984,3.107,3.107,0,0,1,.4,1.809,4.938,4.938,0,0,1-1.985,3.859c-.327.238-.642.611-1.082.557a15.624,15.624,0,0,0-2.095-1.709,28.782,28.782,0,0,0-6.033-3.674c-.377-.193-.9-.211-1.115-.617a22.2,22.2,0,0,1-2.51-6.423,10.863,10.863,0,0,1,.885-7.385,9.53,9.53,0,0,1,2.862-3.285,6.564,6.564,0,0,1,3.622-1.313,5.852,5.852,0,0,1,2.117.224,6.84,6.84,0,0,1,4.372,4.475,12.732,12.732,0,0,1,.052,2.11,10.2,10.2,0,0,1-.4,1.8,5.273,5.273,0,0,1-1.646,2.06,4.453,4.453,0,0,1-5.645-.393,3.01,3.01,0,0,1-.739-1.1,2.425,2.425,0,0,1,.158-2.516,2.662,2.662,0,0,1,.546-.4,1.75,1.75,0,0,1,1.961.247,1.125,1.125,0,0,1-.058,1.291,2.094,2.094,0,0,0-.337.468c-.256-.024-.5-.045-.746-.087-.508-.167-.483-.791-.591-1.214a1,1,0,0,0-.694.345c-.148.348.076.692.246.986a1.918,1.918,0,0,0,.9.566,1.88,1.88,0,0,0,1.651-3.314,2.624,2.624,0,0,0-2.919-.242,3.308,3.308,0,0,0-1.766,3.126,4.848,4.848,0,0,0,1.613,3.409,5.344,5.344,0,0,0,3.542,1.269,3.626,3.626,0,0,0,1.932-.372l.223.137a15.39,15.39,0,0,1-2.031,1.31,2.7,2.7,0,0,1-1.286-.365,3.322,3.322,0,0,0-2.244-.109,16.134,16.134,0,0,0-2.323,1.322l-.1.164a11.649,11.649,0,0,1,2.483.743l.072.022a7.947,7.947,0,0,0,1.983.08l.019,0,.319-.178.094-.042.067-.039c.248-.182.486-.377.728-.571,0-.066.006-.2.008-.265a5.523,5.523,0,0,1-2.712.18,8.044,8.044,0,0,0,2.372-.419c.469-.2.952-.377,1.417-.6a9.489,9.489,0,0,0,1.6-1.008,12.4,12.4,0,0,0,2.76-3.375c.071-.147.146-.292.23-.433l.209-.235c.392.19.782.389,1.187.565a1.611,1.611,0,0,0,1.306.156,2.493,2.493,0,0,0,1.124-1.128c.292-.5.632-.969.906-1.478a2.039,2.039,0,0,0,.167-1c-.148-.16-.368.026-.536.037a9.818,9.818,0,0,0-.974.478c-.192.083-.378.169-.556.265a.554.554,0,0,1-.018-.177c.5-.332.993-.69,1.518-.994.087-.127.311-.234.191-.409-.1-.081-.19-.152-.281-.215a20.928,20.928,0,0,0-3.488-.014c-.01-.049-.03-.146-.04-.193-.016-.087-.048-.26-.065-.346,0-.1.006-.3.008-.4a15.475,15.475,0,0,0,2.3.694,2.307,2.307,0,0,0,1.29.045l.144-.1c.015-.045.043-.132.057-.177-.439-.522-.9-1.03-1.318-1.562a9.082,9.082,0,0,1,1.168.772c.256.183.5.468.856.394a4.317,4.317,0,0,0-.081-1.09c.31.159.427.57.8.628a6.691,6.691,0,0,1,.772-1.641c.08.634-.393,1.282-.175,1.872.114.042.236.085.368.129.409-.353.865-.652,1.267-1.015a13.911,13.911,0,0,0,1.261-1.4,1.286,1.286,0,0,0,.245-1.35c-.4-.807-1.187-1.316-1.679-2.056a11.265,11.265,0,0,0-1.772.469c-.514.219-1.154.389-1.372.965-.463.878.316,1.792.07,2.7a6.888,6.888,0,0,0-.979-2.147,5.563,5.563,0,0,0-.522-.546c-1.126-.152-2.072.642-3.173.642a11.927,11.927,0,0,1-.1,1.644c.01.058.029.175.037.234-.084.306-.338-.1-.265-.25-.132-.168-.261-.335-.383-.5a8.11,8.11,0,0,0-5.963-3.285,7.689,7.689,0,0,0-5.045,1.541,9.037,9.037,0,0,0-2.777,3.276,10.84,10.84,0,0,0-1.23,5.341,16.811,16.811,0,0,0,.7,5.03,12.2,12.2,0,0,1,.485,1.685,10.233,10.233,0,0,1-.973-1.652,6.307,6.307,0,0,1-.271-.595,32.8,32.8,0,0,1-1.623-4.275,26.846,26.846,0,0,1-1.1-5.136l.07-.261c.1.1.2.193.317.3.5.021,1.012.011,1.522-.007a5.705,5.705,0,0,0,.444-1.306c.066-.443-.389-.673-.712-.848-.48-.192-.986-.519-1.517-.358.194.311.4.621.6.934-.153-.114-.311-.231-.453-.341s-.281-.211-.412-.312c-.01.1-.031.3-.042.394l-.187-.065c-.025-.083-.072-.25-.1-.333a5.751,5.751,0,0,0-.535.476c-.11.09-.2.189-.3.285a3.387,3.387,0,0,0,.414-1.055,5.581,5.581,0,0,0-1.688.733c-.37.234-.217.716-.2,1.075a8.73,8.73,0,0,0,.391.944,12.4,12.4,0,0,0,1.426-.005,4.83,4.83,0,0,0,.517-.432,6.664,6.664,0,0,0,.117,1.035c.03.306.063.615.08.925a6.555,6.555,0,0,1,.331,1.434,29.34,29.34,0,0,0,2.483,7.214,29.9,29.9,0,0,0,1.631,2.825,41.74,41.74,0,0,1-3.422-4.589,61.781,61.781,0,0,1-7.915-17.149,28.55,28.55,0,0,1-1.26-7.972,15.118,15.118,0,0,1,6.4-12.676,9.841,9.841,0,0,1,2.8-1.458l.141.005a3.763,3.763,0,0,0,.909,1.04,2.657,2.657,0,0,0,2.6.454c.308-.109.617-.221.932-.328a4.168,4.168,0,0,0,1.73-1.785,10.107,10.107,0,0,1,4.731,2.176,9.79,9.79,0,0,1,3.464,6.482,9.253,9.253,0,0,1-1.959,7.122,12.135,12.135,0,0,1-1.289,1.2,1.45,1.45,0,0,1-.652.277c.039.035.085.073.138.117a18.685,18.685,0,0,1-1.83.741,8.055,8.055,0,0,1-2.478.226,6.008,6.008,0,0,1-4.906-2.549,6.694,6.694,0,0,1-.547-7.043,2.951,2.951,0,0,0,2.086,2.826,1.993,1.993,0,0,0,2.183-1.231,2.436,2.436,0,0,0-1.088-3.019,3.175,3.175,0,0,0-2.483-.221,5.533,5.533,0,0,0-2.588,2.434,6.646,6.646,0,0,0-.6,4.382c.065.185.119.372.178.568a7.581,7.581,0,0,0,5.8,5.158,8.431,8.431,0,0,0,2.114.234,9.594,9.594,0,0,0,3-.78,10.335,10.335,0,0,0,3.942-2.954,12.307,12.307,0,0,0,2.7-6.137,9.359,9.359,0,0,0-2.258-7.775,8.6,8.6,0,0,0-2.912-2.164,1.687,1.687,0,0,1,.436-.608,1.688,1.688,0,0,0-.3-.907c.015-.05.042-.151.057-.2.275.326.581.741,1.044.779a3.02,3.02,0,0,0,.831-.6c.157-.1.071-.312.08-.456a1.191,1.191,0,0,0-.588-.957,4.288,4.288,0,0,0-1.485.238,2.576,2.576,0,0,0,.4.429c-.18-.01-.35-.014-.519-.015-.115.083-.217.173-.317.261l-.139.43c-.077-.214-.158-.427-.229-.634a3.87,3.87,0,0,0-.592.795,4.882,4.882,0,0,1-.382.651l-.3-.085a14.739,14.739,0,0,0-1.6-.414c-.239-.051-.471-.1-.7-.154a10.175,10.175,0,0,0-.052-2,7.05,7.05,0,0,0-3.671-4.7,5.047,5.047,0,0,0-2.44-.514,7.18,7.18,0,0,0-4.431,1.422,12.277,12.277,0,0,1,.79-2.551,15.141,15.141,0,0,1,2.254-3.725c.561-.295,1.228-.122,1.8-.368a3.536,3.536,0,0,0,1.856-1.649c.282-.53.525-1.08.825-1.6a11.843,11.843,0,0,1-1.869.4,3.516,3.516,0,0,0-2.632,1.179,6.912,6.912,0,0,0-.539,1.044,2.138,2.138,0,0,0-.043.362,1.373,1.373,0,0,0,.514-.358,4.588,4.588,0,0,1,2.219-1.2c-.479.337-1.027.561-1.491.919a5.985,5.985,0,0,0-.949.969c-.1.1-.2.194-.283.3a14.907,14.907,0,0,0-1.348,1.843,5.872,5.872,0,0,1-.7,1.082,10.1,10.1,0,0,1,.192-1.189,25.994,25.994,0,0,1,1.323-4.317,19.889,19.889,0,0,1,3.094-4.947,17.318,17.318,0,0,1,5.886-4.535c.147-.1.409-.143.318-.4.178.006.356.014.546.029a10.818,10.818,0,0,1,1.093-.367,11.553,11.553,0,0,1,3.754-.506,11.122,11.122,0,0,1,7.941,3.1,10.5,10.5,0,0,1,3.061,6.081,10.179,10.179,0,0,1-1.4,6.61,9.627,9.627,0,0,1-5.6,4.076,11.273,11.273,0,0,1-3.128.213,7.33,7.33,0,0,1-2.9-.7,8.9,8.9,0,0,1-1.957-1.254,7.368,7.368,0,0,1-2.7-5.6,5.926,5.926,0,0,1,1.981-4.755,5.773,5.773,0,0,1,3.83-1.393,4.615,4.615,0,0,1,3.519,1.626,6.529,6.529,0,0,0-1.863.086,3.283,3.283,0,0,0-2.235,2.083,3.346,3.346,0,0,0,.06,1.853,4.23,4.23,0,0,0,.932,1.189,2.89,2.89,0,0,0,2.325.485,3.388,3.388,0,0,0,2.265-1.977,4.834,4.834,0,0,0-.357-4.208,6.868,6.868,0,0,0-4.985-3.157,7.561,7.561,0,0,0-2.52.233A6.942,6.942,0,0,0,2901,773.27a8.872,8.872,0,0,0,.082,4.891,10.03,10.03,0,0,0,2.479,3.814,11.351,11.351,0,0,0,5.712,2.894,15.466,15.466,0,0,0,4.676.068,13.1,13.1,0,0,0,3.673-1.185,10.157,10.157,0,0,0,5.755-8.624c.19.092.384.189.573.3a2.542,2.542,0,0,0,3.2-.294,3.424,3.424,0,0,0,1.059-1.841,5.157,5.157,0,0,0-.332-2.769,12.509,12.509,0,0,0-3.872-4.549,21.14,21.14,0,0,0-5.018-2.843,26.942,26.942,0,0,0-2.578-.8c-.154-.058-.3-.114-.444-.172a1.526,1.526,0,0,1,.823-.153,17.451,17.451,0,0,1,7.834,1.484,12.645,12.645,0,0,1,1.409,2.205,7.516,7.516,0,0,0,.922,1.01,6.172,6.172,0,0,0,1.835.847v-2.229a10.736,10.736,0,0,0-2.84-1.914c-.336-.049-.668-.095-.992-.153a17.624,17.624,0,0,0-10.229-1.653,4.5,4.5,0,0,1-1.731.009c-1.487-.665-3.146-.491-4.727-.51a11.622,11.622,0,0,0-5.564,1.6l0-.287c.078-.162.156-.325.23-.488a1.875,1.875,0,0,1,.539-.9,3.677,3.677,0,0,0,1.34-2.047,11.294,11.294,0,0,0-.342-3.625,8.735,8.735,0,0,1-.008-1.3l-.208-.055a11.861,11.861,0,0,1-1.27,1.3l-.093.085a5.141,5.141,0,0,0-1.395,2.968c-.1,1.016.452,1.958.383,2.974a2.067,2.067,0,0,0,1-1.081,14.964,14.964,0,0,0,.682-2.89,6.085,6.085,0,0,1-.491,3.361c-.117.238-.224.479-.323.724a13.438,13.438,0,0,1-.866,1.5,6.66,6.66,0,0,1-1.561,1.363,10.635,10.635,0,0,0-1.159,1.019c-.256.243-.488.6-.881.572-.071-2.333-.06-4.667-.045-7,.084-.728.162-1.455.291-2.175a8.6,8.6,0,0,0,.225-1.857l.1.119a10.154,10.154,0,0,1,.2-1.092c.22-1.011.469-2.016.769-3.008.832-2.8,1.78-5.7,3.725-7.946a11.076,11.076,0,0,1,.93-.956,8.343,8.343,0,0,1,3.978-2.04,8.107,8.107,0,0,1,4.07.439,7.35,7.35,0,0,1,2.338,1.459,5.7,5.7,0,0,1,1.571,2.068,5.624,5.624,0,0,1-.1,5.359,4.648,4.648,0,0,1-2.235,1.861,3.634,3.634,0,0,1-1.484.357,5.819,5.819,0,0,1-2.754-.338,4.9,4.9,0,0,1-3.009-3.492,4.163,4.163,0,0,1,.34-2.683,2.932,2.932,0,0,1,2.7-1.641,4.721,4.721,0,0,0-.469,1.83,1.976,1.976,0,0,0,1.955,2.076,2.419,2.419,0,0,0,2.255-1.707,3.394,3.394,0,0,0-.216-2.157,4.351,4.351,0,0,0-.891-1.088l-.139-.1a4.528,4.528,0,0,0-1.246-.644,4.638,4.638,0,0,0-3.775.526,5.169,5.169,0,0,0-1.81,6.422,7.058,7.058,0,0,0,1.435,2.24,8.038,8.038,0,0,0,4.947,2.855,6.3,6.3,0,0,0,5.785-1.962,9.312,9.312,0,0,0,.741-.978c.024-.044.07-.132.093-.175a8.709,8.709,0,0,0,1.09-3.067,9.275,9.275,0,0,0,.122-2.862,7.676,7.676,0,0,1,.362,2.773,2.231,2.231,0,0,0,.8-1.893c.025-1.168-.827-2.072-1.266-3.09-.09-.24-.147-.486-.233-.72-.269.19-.277.58-.434.852a3.938,3.938,0,0,0-.558,3.2c.174.718.968,1.234.81,2.021a7.468,7.468,0,0,1-.924,2.265,6.476,6.476,0,0,1-.955,1.194,6.7,6.7,0,0,1-3.38,1.838,6.415,6.415,0,0,1-1.7.109c-.116-.024-.225-.045-.33-.063v-.162a8.821,8.821,0,0,0,1.616-.114,5.406,5.406,0,0,0,2.71-1.673,7.439,7.439,0,0,0,1.5-2.811A9.649,9.649,0,0,0,2918,744.9a9.306,9.306,0,0,0-.749-2.435c-.117-.253-.23-.5-.357-.744a8.951,8.951,0,0,0-1.359-1.718,8.342,8.342,0,0,0-3.024-1.837,10.6,10.6,0,0,0-4.531-.356,11.706,11.706,0,0,0-2.9,1.167,11.982,11.982,0,0,0-3.292,3.024,19.015,19.015,0,0,0-1.929,3.363c-.179.519-.357,1.037-.559,1.547-.188.663-.379,1.326-.53,2a6.589,6.589,0,0,1-.327,1.274c-.649-2.7-1.3-5.4-1.723-8.142q-.041-.147-.067-.287a7.968,7.968,0,0,0-.111-1.345c-.058-.317-.1-.636-.133-.953a37.15,37.15,0,0,1-.065-10.1c.093-.8.3-1.573.378-2.371a22,22,0,0,1,1.882-5.156,7.034,7.034,0,0,1,2.784-2.251,5.307,5.307,0,0,1,.514-.219,6.647,6.647,0,0,1,2.428-.417,6.528,6.528,0,0,1,2.548.371c.822.21,1.432.863,2.235,1.1.057-.4-.3-.593-.572-.776-.295-.184-.592-.359-.9-.516a8.152,8.152,0,0,0-2.586-.761,7.78,7.78,0,0,0-3.814.595c-.22.1-.437.2-.654.29a10.758,10.758,0,0,1,1.551-1.264,11.221,11.221,0,0,1,2.911-1.4c.292-.1.595-.174.9-.254a17.447,17.447,0,0,0,1.969,1.041,7.765,7.765,0,0,0,1.585.132,6.171,6.171,0,0,0,2.9-1.052c.4-.238.824-.418,1.23-.643-.384-.162-.79-.241-1.177-.372-1.549-.656-3.054-1.822-4.834-1.5a5.03,5.03,0,0,0-1.877,1.008c-.267.107-.094.432.154.333a5.664,5.664,0,0,1,2.415.016c-.443.053-.887.056-1.322.127a13.332,13.332,0,0,0-5.341,2.153c-.163.1-.311.208-.466.307a9.172,9.172,0,0,1,1.276-1.406,16.364,16.364,0,0,1,5.166-3.353,15.573,15.573,0,0,1,3.7-1.01,13.616,13.616,0,0,1,2.4-.139,15.478,15.478,0,0,1,2.224.107,8.791,8.791,0,0,1,2.679.654c.6.275,1.265.4,1.866.687a15.834,15.834,0,0,1,2.162,1.27,17.588,17.588,0,0,1,2.9,2.613,14.315,14.315,0,0,1,1.965,2.741c.485.826.816,1.729,1.254,2.581v-7.177a15.565,15.565,0,0,0-1.628-1.785c.539-.122,1.088-.2,1.628-.335V710.49a13.549,13.549,0,0,1-5.3-.026,12.54,12.54,0,0,1-4.148-1.707,13.957,13.957,0,0,1-3.885-3.789,17.279,17.279,0,0,1-2.469-5.388,22.02,22.02,0,0,1-.562-9.122,12.555,12.555,0,0,0,.259-2.1c.022.114.052.229.087.346a7.22,7.22,0,0,1,.186-.961,4.271,4.271,0,0,1,.14-.468,20.523,20.523,0,0,0,2.085.843,17.752,17.752,0,0,0,4.279.561,7.528,7.528,0,0,1,1.764.037,3.366,3.366,0,0,0-.734.657,10.081,10.081,0,0,0-1.7,3.326,7.875,7.875,0,0,0,.952,6.687,8.38,8.38,0,0,0,2.392,2.054,10.939,10.939,0,0,0,1.662.6,4.28,4.28,0,0,0,3.067-.837,4.554,4.554,0,0,0,1.924-3.089v-1.562c-.277-.465-.414-1.284-1.122-1.18-.156.09-.306.18-.449.274a5.034,5.034,0,0,1-.224,2.314,2.791,2.791,0,0,1-2.687,1.782,5.576,5.576,0,0,1-.8-.087,4.455,4.455,0,0,1-2.907-2.126,6.534,6.534,0,0,1-.674-3.482,7.958,7.958,0,0,1,3.367-5.742l.137-.1c.471-.27,1.008-.4,1.5-.631,1.17-.656,2.572-.452,3.858-.414v-1.234c-.379,0-.755,0-1.127-.007.362-.352.744-.683,1.127-1.014v-3.086a7.953,7.953,0,0,1-1.179,1.612,9.389,9.389,0,0,1-2.2,1.866,9.928,9.928,0,0,1-3.883,1.407,11.228,11.228,0,0,1-3.852.129,14.556,14.556,0,0,1-3.987-1.083c-.009-.072-.025-.216-.034-.289.234-.4.383-.843.581-1.263a20.746,20.746,0,0,1,1.547-2.785,9.491,9.491,0,0,0,.821-1.248,12.919,12.919,0,0,0,1.822.781,6.856,6.856,0,0,0,4.223-.174,5.812,5.812,0,0,0,1.781-1.268c.17-.151.332-.437.616-.311-.276.381-.705.658-.848,1.124.2-.026.408-.051.613-.093,1.313-.32,2.688-.316,3.979-.746v-5.968a6.187,6.187,0,0,0-2,2.274c-.607.969-.96,2.066-1.53,3.055-.127-.4.163-.75.292-1.108a5.043,5.043,0,0,0-.23-4.276,19.472,19.472,0,0,1,3.467-1.172v-3.577a11.174,11.174,0,0,0-2-1.389c-.5-.24-1.012-.448-1.52-.659a10.246,10.246,0,0,0-2.207-.439,10.006,10.006,0,0,0-2.6.1,8.793,8.793,0,0,0-3.628,1.551,8.073,8.073,0,0,0-2.861,8.518l-.125.156c-.336.42-.718.8-1.062,1.212a28.541,28.541,0,0,0-3.164,4.984,11.734,11.734,0,0,1-1.29-1.658,14.456,14.456,0,0,1-2.275-8.3,15.245,15.245,0,0,1,1.768-7.022,17.742,17.742,0,0,1,4.667-5.7,19.469,19.469,0,0,1,4.219-2.687,24.852,24.852,0,0,1,3.687-1.369,25.413,25.413,0,0,1,8.386-.968v-.876a35.6,35.6,0,0,0-5.216.144Zm-77.6,81.416c-.1.184-.065.422-.207.582a4.229,4.229,0,0,1-.107.672,3.16,3.16,0,0,1,.144-1.392,3.8,3.8,0,0,1,2.71-2.541,2.745,2.745,0,0,1,1.447.01c.309.09.7.17.841.5a6.448,6.448,0,0,0-2.5-.092A4.105,4.105,0,0,0,2845.967,735.729Zm-4.586.985a8,8,0,0,1,5.346-6.9,6.24,6.24,0,0,1,2.454-.478,5.649,5.649,0,0,1,2.724.59c-.582,0-1.151-.141-1.728-.167a15.584,15.584,0,0,0-2.623.221,8.179,8.179,0,0,0-2.182.929,7.936,7.936,0,0,0-3.529,5.019c-.073.286-.142.573-.2.863l-.258-.007,0-.072Zm.269,5.323-.148-.077c.018-.061.053-.184.072-.245l.165.183c0,.277,0,.556.016.837l.144.194C2841.626,742.709,2841.687,742.341,2841.649,742.036Zm-7.784,20.679c-.02.367-.419.465-.719.425A1.579,1.579,0,0,1,2833.865,762.716Zm-33.117,12.37a3.015,3.015,0,0,0,2.006-.159.766.766,0,0,0-.223.234,3.227,3.227,0,0,1-2.008.275,3.133,3.133,0,0,1-2.147-2.872,3.337,3.337,0,0,0,2.371,2.523Zm8.854-19.96.006-.01a9.32,9.32,0,0,1,2.685-1.9,11.022,11.022,0,0,1,6.993-.652c.072.915.152,1.828.152,2.749a6.806,6.806,0,0,0,.052-1.393l.074.067c-.113,2.018-.228,4.158.67,6.031-.361-.383-.637-.838-1.03-1.188a5.482,5.482,0,0,0-2.708-1.432,7.042,7.042,0,0,0-1.994.124,1.167,1.167,0,0,1-.78-.061,16.864,16.864,0,0,0-5.089-1.182A5.294,5.294,0,0,1,2809.6,755.126Zm6.652,3.577c.153-.027.311-.051.473-.073a4.354,4.354,0,0,1,2.57,2.2A18.687,18.687,0,0,0,2816.255,758.7Zm.541,4.174c-.011.129-.022.261-.034.394-.23-.007-.486.03-.631-.182C2816.339,762.981,2816.544,762.667,2816.8,762.877Zm-3.066-1.513a13.317,13.317,0,0,1-1.6.471,2.916,2.916,0,0,1,.646-1.935c.508.1.978.331,1.484.444.011.048.035.144.046.192A1.585,1.585,0,0,0,2813.729,761.365Zm.331,1.392c-.01.061-.027.184-.036.245-.51.03-1.01.146-1.519.146A4.857,4.857,0,0,1,2814.06,762.757Zm4.821,3.258a8.885,8.885,0,0,0-3.086.254,6.819,6.819,0,0,0-2.7,1.438c.3.386.684,0,.986-.169a7.366,7.366,0,0,1,4.111-1.01c.011.06.032.182.043.241a6.341,6.341,0,0,1-4.265,1.626,5.988,5.988,0,0,1-3.972-1.452,7.58,7.58,0,0,1-2.844-6.083,4.661,4.661,0,0,1,.163-1.576c.741,0,1.485.007,2.229,0,.693.088,1.382.21,2.079.282-.118.3-.243.6-.359.9a4.943,4.943,0,0,0-.19,1.911,6.561,6.561,0,0,1-2.045.669c0,.063,0,.19,0,.254,1.177.485,2.151,1.454,3.457,1.612.572.051,1.035.469,1.615.491a3.4,3.4,0,0,0,1.817-.238,3.585,3.585,0,0,0,1.229-1.006l.227.012c.657.246,1.282.567,1.913.878a2.033,2.033,0,0,1-.408.961Zm.765-1.475a9.976,9.976,0,0,0-2.128-.943c.047-.359.1-.718.111-1.08,0-.075.016-.226.021-.3a17.511,17.511,0,0,1,2.133,1.739c-.047.193-.092.388-.137.585Zm1.889,2.376a9.394,9.394,0,0,0-1.434-.637.51.51,0,0,1,.306-.475,9.812,9.812,0,0,1,1.354,1.235Zm-.981-1.927c.123.026.251.055.383.086a4.866,4.866,0,0,0,.332.582c-.117-.058-.231-.116-.334-.17A1.269,1.269,0,0,1,2820.555,764.988Zm5.086,7.1a16.588,16.588,0,0,0-.427-1.758,28.786,28.786,0,0,0-2.039-4.673,22.709,22.709,0,0,0-1.911-2.758c-.325-.347-.3-.854-.4-1.285l.215.041a8.358,8.358,0,0,0,1.424,1.657c1.12.9,2.48,1.427,3.591,2.336a2,2,0,0,1,.536,1.193,40.219,40.219,0,0,1,.394,15.92c-.115.764-.344,1.5-.458,2.266l-.1.081a15.483,15.483,0,0,1,.113-1.876A36.925,36.925,0,0,0,2825.641,772.087Zm-15.089,17.45a4.674,4.674,0,0,0-1.657,1.132,2.859,2.859,0,0,1,2.6-1.7,3.8,3.8,0,0,1,3.693,2.319A4.08,4.08,0,0,0,2810.552,789.537Zm10.56,4.082a17.585,17.585,0,0,0-2.768-4.8,8.254,8.254,0,0,0-5.108-3.026,7.932,7.932,0,0,0-4.947.841,19.758,19.758,0,0,0-2.23,1.459,9.521,9.521,0,0,1,1.176-1.152,7.854,7.854,0,0,1,6.742-1.435,8.48,8.48,0,0,1,4.72,3.215,15.158,15.158,0,0,1,2.694,5.576C2821.3,794.066,2821.206,793.841,2821.112,793.619Zm-16.97,16.517a16.833,16.833,0,0,0-2.52,2.032,13.935,13.935,0,0,0-3.8,6.3c-.047.19-.087.384-.125.581a.868.868,0,0,1-.417-.361,1.8,1.8,0,0,0-1.945-.521,1.48,1.48,0,0,0-.566,1.927,1.193,1.193,0,0,0,1.677.335c.31-.192.347-.649.714-.771-.029.292-.061.59-.107.883a1.556,1.556,0,0,1-1.481.973,2.257,2.257,0,0,1-2.338-2.082,6.135,6.135,0,0,1,.076-1.743,8.314,8.314,0,0,1,2.384-3.363,19.777,19.777,0,0,1,6.183-3.877,24.916,24.916,0,0,1,2.545-.815,2.953,2.953,0,0,1,.742-.113A10.388,10.388,0,0,1,2804.142,810.137Zm3.274,97.789a12.374,12.374,0,0,0,.3-1.549,2.762,2.762,0,0,1-.213,2.014,2.619,2.619,0,0,1-1.983,1.587,3.035,3.035,0,0,1-1.244-.113,5.994,5.994,0,0,0,1.251-.193A3.259,3.259,0,0,0,2807.416,907.925Zm54.494-12.2a13.075,13.075,0,0,1,2.832,1.6,6.142,6.142,0,0,1,1.04.986,3.982,3.982,0,0,1,.9,1.795,3.025,3.025,0,0,1-.138,1.794.382.382,0,0,1-.213.245,1.925,1.925,0,0,1-2.62.779,2.377,2.377,0,0,1-.782-1.469c.358.428.792.969,1.419.9a1.3,1.3,0,0,0,1.076-.787,1.8,1.8,0,0,0-.394-1.381,1.4,1.4,0,0,0-1.748-.113,2.094,2.094,0,0,0-.883,1.22c-.327-.371-.509-.843-.811-1.229-.353-.547-.821-1-1.213-1.511-.321-.271-.61-.576-.947-.821l.012-.049a18.882,18.882,0,0,0-1.7-1.24l-.02-.046a17.638,17.638,0,0,0-5.177-2.227,19.236,19.236,0,0,1,9.363,1.556Zm-23.9-16.822a3.722,3.722,0,0,1,1.888-2.426,3.2,3.2,0,0,1,3.864.522c-.015.019-.043.057-.057.077a3.637,3.637,0,0,0-3.934-.124,4.885,4.885,0,0,0-1.76,1.95Zm-36.476,13.546c-.494-.249-.968-.532-1.439-.816-.177-.123-.422-.221-.393-.469-.186-.062-.356-.109-.53-.17-.369-.306-.728-.622-1.063-.959a7.757,7.757,0,0,1-2.271-5.9,9.255,9.255,0,0,1,.334-2.843,11.785,11.785,0,0,1,1.985-4.253c-.131.213-.264.424-.377.647a12.158,12.158,0,0,0-1.408,4.616,17.47,17.47,0,0,0,.035,1.942,10.441,10.441,0,0,0,3.026,6.318,6.651,6.651,0,0,1,.524.44,11.806,11.806,0,0,0,1.974,1.458c-.139.005-.276.072-.4-.009Zm31.675-12.792a12.361,12.361,0,0,1,1.385-3.375,8.106,8.106,0,0,1,4.25-3.407,8.414,8.414,0,0,1,3.741-.347,7.08,7.08,0,0,1,3.209,1.335c-.629-.173-1.2-.51-1.833-.657a9.115,9.115,0,0,0-2.867-.271,7.16,7.16,0,0,0-4.909,2.046,10.6,10.6,0,0,0-2.729,4.939,19.405,19.405,0,0,0-.479,2.429,12.726,12.726,0,0,0-.221,1.627,12.773,12.773,0,0,1,.454-4.32Zm-2.163,11.373.077-.017c.208.8.705,1.493.967,2.28.144.348.3.694.445,1.047.169.4.334.8.479,1.22.2.489.393.983.553,1.489.362,1.04.734,2.077,1.04,3.137a13.284,13.284,0,0,1,.711,2.963,24.676,24.676,0,0,0-2.764-5.834c-.34-.511-.657-1.035-1.032-1.516-.287-.374-.569-.751-.857-1.118-.254-.316-.517-.619-.776-.925a20.777,20.777,0,0,0-2.641-2.663l-.04-.208a.855.855,0,0,0,1.039-.061c.189-.343.44-.651.608-1.005a3.325,3.325,0,0,0-.424-.769c-.139-.185-.282-.364-.425-.537a2.9,2.9,0,0,0-2.208.981c.365.073.735.149,1.1.231-.374.044-.746.1-1.111.175.078.134.162.271.25.414l-.468-.1c.011.3.026.6.022.9a4.42,4.42,0,0,1-.4-.917,3.292,3.292,0,0,0-.259.345,4.625,4.625,0,0,0-.429,1.541.757.757,0,0,0,.474.769c.357.138.734.216,1.106.33.465-.465,1.093-.959,1.018-1.694.536.577,1.127,1.1,1.646,1.7.488.5.927,1.047,1.363,1.595q.5.627.953,1.292c.258.369.515.741.751,1.129.4.652.8,1.311,1.156,1.994a15.446,15.446,0,0,1,1.214,2.674,22.468,22.468,0,0,0-3.367-4.08,16.706,16.706,0,0,0-1.606-1.316c-.581-.371-1.167-.735-1.779-1.049a11.582,11.582,0,0,0-3.377-.939c-.584-.02-1.169-.034-1.75-.015a12.811,12.811,0,0,0-2.516.46,12.487,12.487,0,0,0-2.179,1.216,7.374,7.374,0,0,0-1.647,1.769,8.023,8.023,0,0,0-1.125,2.786,1.6,1.6,0,0,1-.525-.642,14.758,14.758,0,0,0-1.149-1.547,17.893,17.893,0,0,0-1.528-1.615,21.724,21.724,0,0,0-2.228-1.708,11.362,11.362,0,0,0-2.167-1.139c-.02-.04-.062-.119-.082-.159a10.6,10.6,0,0,0,3.3-.811,9.986,9.986,0,0,0,2.987-2.224,7.687,7.687,0,0,0,1.2-1.627,3.708,3.708,0,0,0,.389-.994q-.011.226-.007.463c.091-.331.184-.659.29-.981a7.525,7.525,0,0,0,.209-3.678,7.393,7.393,0,0,0-2.273-4.076c-.134-.119-.271-.233-.4-.338a6.092,6.092,0,0,0-4.332-1.2,3.438,3.438,0,0,0-3.188,2.21,3.2,3.2,0,0,0-.055,1.572,2.424,2.424,0,0,0,2.886,1.648,2.106,2.106,0,0,0,1.078-3.116,3.736,3.736,0,0,0-.92-1.218,6.611,6.611,0,0,1,5.1,4.2c.046.149.091.3.149.462l.055.011a7.181,7.181,0,0,1-.19,4.069,7.014,7.014,0,0,1-2.022,2.831,7.514,7.514,0,0,1-6.384,1.739,11.075,11.075,0,0,1-3.067-1.137c-.275-.208-.54-.423-.823-.608a9.8,9.8,0,0,1-3.874-5.573,10.584,10.584,0,0,1-.285-2.523,9.522,9.522,0,0,1,1.266-4.778,7.989,7.989,0,0,1,.525-.948,13.682,13.682,0,0,1,2.892-2.965,12.446,12.446,0,0,1,7.589-2.5,16.948,16.948,0,0,1,3.283.17,15.805,15.805,0,0,1,6.6,2.929,25.873,25.873,0,0,1,4.714,4.672c.139.174.285.352.43.531.973,1.261,1.906,2.557,2.764,3.9A56.838,56.838,0,0,1,2831.049,891.03Zm17.036-32.153a2.6,2.6,0,0,1-2.262,1.019.88.88,0,0,1-.511-.194,3.221,3.221,0,0,0,2.542-1.152,3.565,3.565,0,0,0,.781-2.29A3,3,0,0,1,2848.085,858.877Zm9.654-1.265c.206.053.242.285.351.448a23.142,23.142,0,0,0,1.223,2.164,10.348,10.348,0,0,0,.627.988c-.2-.22-.407-.433-.6-.649-.515-.622-1.011-1.259-1.481-1.911A1.359,1.359,0,0,1,2857.739,857.612Zm56.3-.239c.024-.038.048-.076.073-.113a4.619,4.619,0,0,1,.342-.5,9.915,9.915,0,0,0,3.214,2.914,11.922,11.922,0,0,0,3.388,1.25,7.907,7.907,0,0,1-2.6-.515,3.985,3.985,0,0,1-1.147-.49l-.06.039a9.7,9.7,0,0,1-2.878-1.99C2914.231,857.791,2913.958,857.593,2914.038,857.374Zm-.157-1.417c.009.311-.019.791-.382.893l-.064.027-.016-.108c-.006-.046-.019-.138-.026-.185A7.171,7.171,0,0,1,2913.881,855.957Zm-.417-8.51a1.69,1.69,0,0,1,1.321.425c.122.127.249.264.379.4l-.113.081a7.049,7.049,0,0,0-1.582-.673l-.072-.126Zm-.438,10.18a5.549,5.549,0,0,1-1.271.494,3.623,3.623,0,0,1-3.336-1.146,4.875,4.875,0,0,1-1.234-3.58,5.414,5.414,0,0,1,1.82-4.35,3.889,3.889,0,0,1,2.673-.859c-.069.313-.117.634-.207.944a10.586,10.586,0,0,0-.231,2.024c-.065.485.141,1-.011,1.468-.506.354-1.141.578-1.471,1.141a2.2,2.2,0,0,0,.629,3.021,2.484,2.484,0,0,0,1.234.539,7.448,7.448,0,0,0,1.389-.156C2913.01,857.315,2913.015,857.468,2913.026,857.626Zm-.613-6.474c.006.519.157,1.025.152,1.547l-.449,0a12,12,0,0,1,.081-3.436c.107-.366,0-.908.386-1.116a4.459,4.459,0,0,1-.141,1.267c-.029.576-.046,1.153-.029,1.733Zm-8.7-61.28a13.594,13.594,0,0,1,3.871,1.48,10.3,10.3,0,0,1,3,2.613,7.716,7.716,0,0,1,1.485,3.941,14.344,14.344,0,0,1-.067,3.011,6.585,6.585,0,0,1-.537,1.967c.1-.57.167-1.142.232-1.713a10.686,10.686,0,0,0-.521-4.261,10.412,10.412,0,0,0-4.095-5.321,11.39,11.39,0,0,0-3.763-1.59c-.107-.036-.207-.071-.3-.106C2903.246,789.88,2903.475,789.869,2903.715,789.872Zm12.663-26.937a24.254,24.254,0,0,1,2.61.922,19.329,19.329,0,0,1,6.259,4.145,9.1,9.1,0,0,1,2.067,2.858,4.021,4.021,0,0,1,.094,2.936,2.309,2.309,0,0,1-2.835,1.316,5.1,5.1,0,0,1-.5-.358c-.47-.318-.389-.963-.482-1.45.256.034.306.318.453.494a1.173,1.173,0,0,0,1.489.432,1.462,1.462,0,0,0,.585-.638,1.354,1.354,0,0,0-1.182-1.881,1.879,1.879,0,0,0-1.72.9l-.065.039a15.039,15.039,0,0,0-5.213-8.35c-.641-.48-1.306-.925-1.96-1.382q.189,0,.4.015Zm-9.631-19.05a4.282,4.282,0,0,1,3.129-1.749,3.071,3.071,0,0,1,2.943,1.8,8.058,8.058,0,0,0-1.126-.948,3.789,3.789,0,0,0-4.013.216,2.933,2.933,0,0,0-.993.952c.015-.068.043-.205.058-.272Zm-3.874-1.968a11.219,11.219,0,0,1,2.27-2.117,7.946,7.946,0,0,1,8.059-.439,7.842,7.842,0,0,1,2.473,2.078,12.469,12.469,0,0,0-2.457-1.7,7.847,7.847,0,0,0-6.829-.167,10.4,10.4,0,0,0-3.372,2.648,14.625,14.625,0,0,1-.889,1.3,22,22,0,0,0-1.8,3.479l-.065-.1A15.053,15.053,0,0,1,2902.873,741.917Zm-37.689.114a6.246,6.246,0,0,1-.54-1.758,9.117,9.117,0,0,1,.948-5.706,11.557,11.557,0,0,1,4.074-4.672,11.081,11.081,0,0,0-2.505,2.657,10.671,10.671,0,0,0-1.857,6.727,12.477,12.477,0,0,0,.638,2.862,15.743,15.743,0,0,0,1.121,2.268l-.078.068c-.106-.015-.2-.026-.291-.036A10.835,10.835,0,0,1,2865.184,742.031Zm8.93,7.071a13.107,13.107,0,0,0,2.781-.194c.3-.053.612-.114.919-.185a3.314,3.314,0,0,1,1.214,3.213,2.509,2.509,0,0,1-1.573,1.608,1.848,1.848,0,0,1-1.837-.975c-.005-.07-.016-.21-.021-.28a1.766,1.766,0,0,0,1.07.536,1.365,1.365,0,0,0,1.149-.749c.057-.28.022-.571.053-.849a4.61,4.61,0,0,0-.745-.779,2.4,2.4,0,0,0-1.249.025,3.213,3.213,0,0,0-.345.206,2.556,2.556,0,0,0-.577,1.1q.006.224.029.455l-.24-.049c-.067-.093-.131-.183-.189-.269a9.333,9.333,0,0,0-1.1-.993l-.46-.281c.029-.012.084-.04.113-.053-.748-.4-1.452-.874-2.229-1.214a10.411,10.411,0,0,0-2.535-.989,10.185,10.185,0,0,0-2.382-.428c-.76-.148-1.536-.046-2.294-.163a17.162,17.162,0,0,1,3.4-.853c.537-.068,1.154-.257,1.616.142a12.109,12.109,0,0,0,5.432,2.018Zm-3.651-2.223a1.426,1.426,0,0,1,.991-.124,17.113,17.113,0,0,1,4.86,1.076,3.339,3.339,0,0,1-1.759.274A8.594,8.594,0,0,1,2870.463,746.88Zm-2.306-.929a10.608,10.608,0,0,1-1.1-1.088l.156-.075a.652.652,0,0,1,.154-.052,13.4,13.4,0,0,0,1.019,1.255c.006.04.02.121.026.16C2868.321,746.084,2868.229,746.014,2868.157,745.951Zm-2.967-.177a2.693,2.693,0,0,1,1.4-.541c.2.393.6.636.854,1a17.364,17.364,0,0,0-2.214.417,7.807,7.807,0,0,1-1.748.356l-.144-.04c.618-.391,1.2-.843,1.848-1.187Zm-11.233,34.174c.137.132.115.332.162.51a17.023,17.023,0,0,0-1.677-1.78,7.363,7.363,0,0,1,1.515,1.27Zm-26.142,52.39a5.838,5.838,0,0,0-1.74-1.929,4.361,4.361,0,0,1,1.984,1.654c.224.262.158.626.187.948C2827.992,832.876,2827.963,832.552,2827.814,832.338Zm28.105,8.135a4.809,4.809,0,0,1,.2-.647,7.954,7.954,0,0,1,.323-1,6.318,6.318,0,0,1,.009,1.02,8.9,8.9,0,0,0-.474.833c-.05.121-.083.253-.126.381A1.657,1.657,0,0,1,2855.919,840.473Zm.713,1.215a8.055,8.055,0,0,1-.679.749,11.251,11.251,0,0,1,.539-1.437l.178.067C2856.659,841.269,2856.79,841.519,2856.632,841.688Zm14.112-9.172c-.188-.733,0-1.536-.4-2.219a3.657,3.657,0,0,0-1.785-1.659l-.139-.27a12.351,12.351,0,0,1,1.321-.174c.281.51.4,1.1.691,1.622a7.608,7.608,0,0,0,3.242,3.372,1.193,1.193,0,0,1,.607.44l.019.02a5.337,5.337,0,0,0-1.238.093c-.282.042-.6.168-.85-.011A5.4,5.4,0,0,1,2870.744,832.516Zm4.432-8.861c-.4.31-.516.852-.92,1.146-.112-.558.341-1.017.658-1.422a4.132,4.132,0,0,1,4-.9,4.6,4.6,0,0,0-3.74,1.172Zm4.478.209a3.926,3.926,0,0,1,1.7,2.513,1.486,1.486,0,0,1,.127.889,1.323,1.323,0,0,1-.357-.246c-.464-.23-.886-.536-1.367-.726-.584-.318-1.236-.474-1.832-.756a3.407,3.407,0,0,0-1.259-1.263c-.187-.123-.557-.174-.437-.479A3.235,3.235,0,0,1,2879.654,823.864Zm-4.051,4.821a17.265,17.265,0,0,1,4.649,2.059c-.086.328-.383.527-.619.744a5.378,5.378,0,0,1-3.463,1.319,4.648,4.648,0,0,1-3.4-1.394,5.463,5.463,0,0,1-1.565-3.248,13.355,13.355,0,0,1,4.4.521Zm4.424,4.237a5.339,5.339,0,0,1-2.076,1.355.752.752,0,0,1-.79-.221c.16-.016.327-.03.5-.04a8.614,8.614,0,0,1,.888-.244A7.926,7.926,0,0,0,2880.027,832.922Zm-9.621-8.264a7.819,7.819,0,0,1,3.811-5.331,8.017,8.017,0,0,1,4.189-1.076,13.59,13.59,0,0,1,6.864,2.438c.3.175.536.578.94.44.021.152.107.321,0,.47-.1-.121-.2-.239-.287-.357-2.322-1.348-4.875-2.641-7.634-2.526a7.417,7.417,0,0,0-5.773,2.544,9.917,9.917,0,0,0-1.892,3.492l-.219-.093Zm-1.3,13.706a3.954,3.954,0,0,0,1.177-2.316,5.812,5.812,0,0,1,1.552-1.027,2.227,2.227,0,0,1,1.373-.3.555.555,0,0,0-.432-.177c.195-.013.393-.03.594-.054-.343.3.149.306.309.407a6.879,6.879,0,0,0,3.117.389c.393-.075.648.29.927.506a3.485,3.485,0,0,1,1.011,1.713,3.593,3.593,0,0,1-.352,2.171,2.325,2.325,0,0,1-1.417.949,2.267,2.267,0,0,1-1.61-.362.82.82,0,0,0-.73-.087,10.1,10.1,0,0,0-1.1-1.427,1.742,1.742,0,0,0-1.333-.468,7.215,7.215,0,0,0-1.354.383,6.406,6.406,0,0,1-1.041.628,12.161,12.161,0,0,1-1.174.651C2868.752,839.41,2868.671,838.778,2869.1,838.364Zm10.13.991a6.767,6.767,0,0,0,.275-1.887l.015.077a5.382,5.382,0,0,1,.047,1.775,2.553,2.553,0,0,1-2.69,2.07h-.163c0-.022,0-.07,0-.093a2.754,2.754,0,0,0,.738-.178,3.344,3.344,0,0,0,1.775-1.763Zm-10.475,3.168c-.014-.141-.021-.279-.021-.412.489.005.981,0,1.473.043A4.652,4.652,0,0,1,2868.759,842.523Zm5.617,7.433a14.658,14.658,0,0,0-1.061,3.3,5.743,5.743,0,0,1,.179-1.862,7.157,7.157,0,0,1,.551-1.657c.118-.022.233-.046.366-.058C2874.4,849.747,2874.384,849.887,2874.376,849.956Zm1.422-1.134.032-.056a16.683,16.683,0,0,1,4.073-4.621,5.745,5.745,0,0,1,1.071-.771,10.523,10.523,0,0,1,1.169-.751l-.086.129c-.192.292-.423.556-.641.827a21.421,21.421,0,0,0-1.981,2.883,12.126,12.126,0,0,0-1.138,2.483,8.591,8.591,0,0,1-2.5-.123Zm6.545-5.237c-.176.627-.455,1.219-.6,1.857a16.185,16.185,0,0,0-.551,2.642,5.921,5.921,0,0,1-2.136.656,3.967,3.967,0,0,1,.194-.483,17.194,17.194,0,0,1,3.089-4.672Zm-1.939,12.059a1.273,1.273,0,0,0-.68,1.113,1.433,1.433,0,0,0,1.54,1.423,5.923,5.923,0,0,0-.581,1.022,2.739,2.739,0,0,1-2.332-1.384,5.511,5.511,0,0,1-.651-3.469,2.691,2.691,0,0,0,.108-.953,10.166,10.166,0,0,1,.476-2.491c.072-.226.1-.516.313-.657a9.188,9.188,0,0,0,2.477-.422,14.439,14.439,0,0,0,.584,4.179c.116.5.387.954.483,1.464A2.652,2.652,0,0,0,2880.4,855.645Zm2.167,1.657c-.083.024-.248.073-.331.1l-.053-.037a2.956,2.956,0,0,1-.088-1.141,3.656,3.656,0,0,1,.535.779C2882.616,857.076,2882.585,857.226,2882.57,857.3Zm1.955-12.069-.235.014a6.7,6.7,0,0,1,1.183-2.029A8.7,8.7,0,0,1,2884.526,845.232Zm-.877-4.008a15.087,15.087,0,0,0-3.786,2.246,18,18,0,0,0-4.426,5.278,5.826,5.826,0,0,1-1.894-.549,8.777,8.777,0,0,1-3.624-2.929c-.019-.086-.055-.259-.072-.346a11.58,11.58,0,0,0,1.842.734,2.191,2.191,0,0,0,2.5-1.348c.581-.774.974-1.682,1.56-2.458a6.2,6.2,0,0,0,1.658.117,3.307,3.307,0,0,0,2.7-2.009,4.664,4.664,0,0,0-.4-3.555,3.866,3.866,0,0,0-.949-1.178c-.015-.03-.044-.092-.059-.122l-.339-.107c.012-.1-.03-.261.109-.294a9.2,9.2,0,0,0,1.259-.725l-.018-.011a5.478,5.478,0,0,0,1.922-2.057c.289,0,.444.276.651.445a11.37,11.37,0,0,1,2.662,3.416,7.837,7.837,0,0,1,.9,2.975,15.119,15.119,0,0,0-2.2,2.477Zm7.987-14.415c.079.068.165.139.261.216.813.908,1.741,1.713,2.514,2.662,1.214,1.474,2.285,3.057,3.346,4.645.295.5.6,1,.919,1.483a18.151,18.151,0,0,0-3.409-.28,6.228,6.228,0,0,1-3.062-1.093c-.323-.19-.64-.382-.947-.59a7,7,0,0,1-1.851-2.123,13.438,13.438,0,0,0,2.387,2.065,3.8,3.8,0,0,0,1.209.257l-.01-.129a20.067,20.067,0,0,0-1.345-2.587,4.845,4.845,0,0,0-2.93-1.615,15.4,15.4,0,0,0-1.985-.3,6.939,6.939,0,0,1,.913,1.437,8.411,8.411,0,0,0,1.759,2.963,3.741,3.741,0,0,0,2.448.878c.511.194.93.581,1.436.8-.587.215-1.222.2-1.817.374a23.935,23.935,0,0,0-2.9.963,14.729,14.729,0,0,0-4.449-7.576,16.244,16.244,0,0,0-1.3-1.061c-.016-.6.036-1.2-.015-1.8a5.268,5.268,0,0,0-6.177-4.907,4.649,4.649,0,0,0-3.247,3.125c-.609,0-1.217-.006-1.821-.008a3.794,3.794,0,0,1,.684-1.525,7.629,7.629,0,0,1,4.936-3.366,11.685,11.685,0,0,1,8.046,2,42.79,42.79,0,0,1,5.895,4.576C2891.3,826.462,2891.464,826.635,2891.636,826.809Zm8.447-34.8a3.284,3.284,0,0,1-1.977-.233c-.255-.169-.657-.3-.608-.674a1.965,1.965,0,0,0,2.177.332,3.069,3.069,0,0,0,1.081-1.07c.433.006.869.029,1.31.027A3.465,3.465,0,0,1,2900.083,792.012Zm-2.391-9.125a3.641,3.641,0,0,1,1.815.517,6.245,6.245,0,0,1,2.522,2.585,4.8,4.8,0,0,1,.592,3.067c-.556.009-1.111,0-1.662-.015a2.628,2.628,0,0,0-.54-1.326,2.5,2.5,0,0,0-2.73-.476,2.306,2.306,0,0,0-1.443,2.754l-.291.117a13.5,13.5,0,0,0-3.136,1.7,5.143,5.143,0,0,0-1.031.882,2.02,2.02,0,0,1-.037-.863,17.826,17.826,0,0,1,.233-3.616,9.011,9.011,0,0,1,1.432-3.266,6.153,6.153,0,0,1,2.311-1.835,4.6,4.6,0,0,1,1.965-.22Zm-3.266.165a7.353,7.353,0,0,0-1.418,1.347,15.619,15.619,0,0,0-.855,1.34,2.8,2.8,0,0,1,.057-.9,5.677,5.677,0,0,1,2.215-1.785Zm-.194-10.672a45.84,45.84,0,0,0-2.2,6.554,5.9,5.9,0,0,1-3.447-.608,4.088,4.088,0,0,1-2.246-2.918,2.524,2.524,0,0,1,1.4-2.62,1.857,1.857,0,0,1,1.821.063c0,.066,0,.2,0,.265a1.83,1.83,0,0,0-1.146,1.785,1.156,1.156,0,0,0,1.643.957,1.725,1.725,0,0,0,.885-2.08,2.386,2.386,0,0,0-2.2-1.823,2.861,2.861,0,0,0-2.682,1.631,3.454,3.454,0,0,0,.238,3.533,5.953,5.953,0,0,0,5.511,2.484,89.184,89.184,0,0,0-1.929,9.772c-.154.019-.3.041-.444.065a1.177,1.177,0,0,0,.107.837c.475.79.882,1.618,1.334,2.423.072.2.275.155.45.233-.022.066-.066.2-.088.267a14.853,14.853,0,0,0-3.521,5.5,21.386,21.386,0,0,0-1.039,3.733,29.991,29.991,0,0,0,1.179,14.173l-.23-.169c-.477-1.09-.765-2.251-1.148-3.375-.088-.271-.162-.544-.226-.815a50.853,50.853,0,0,1-1.641-8.983,39.058,39.058,0,0,1-.177-4.248,14.167,14.167,0,0,0,1.673-2.223,5.962,5.962,0,0,0,.257-4.6,15.7,15.7,0,0,1-.728-2.528c-.108-.02-.21-.036-.3-.05-.718,2.122-2.774,3.488-3.348,5.681a5.064,5.064,0,0,0,.778,3.8c.241.061.312-.09.295-.3a7.887,7.887,0,0,1,.571-3.169,4.273,4.273,0,0,1,.839-1.591,16.822,16.822,0,0,1-.633,1.928,6.068,6.068,0,0,0-.15,3.024c.052.878.125,1.758.137,2.641a58.152,58.152,0,0,0,1.131,7.542c-.006.223,0,.453,0,.682-.049-.1-.092-.206-.129-.3-.2-.469-.416-.93-.612-1.4a37.96,37.96,0,0,0-6.217-9.161,37.117,37.117,0,0,0-5.324-4.789,11.425,11.425,0,0,1-.888-.791c-.42-.3-.884-.52-1.315-.795a13.834,13.834,0,0,0-2.965-1.017.806.806,0,0,1,.71-.206,10.044,10.044,0,0,1,2.479.7,17.87,17.87,0,0,1,1.725.867c.3.149.562.429.923.417.159-.428-.183-.8-.363-1.157a7.119,7.119,0,0,0-4.159-3.286,11.729,11.729,0,0,0-2.592-.265,38.453,38.453,0,0,1-6.727.039c-.249.06-.22.321-.039.449,1.061,1.014,1.872,2.249,2.845,3.342a9.463,9.463,0,0,0,2.443,1.922,18.682,18.682,0,0,0,1.795.777c.635.056,1.262.21,1.907.205,1.434.044,2.845-.358,4.281-.27.157.09.318.18.481.284a37.943,37.943,0,0,1,9.835,11.891c.5.894.932,1.824,1.348,2.759a7.051,7.051,0,0,0,.3.67c-.658-.759-1.062-1.7-1.67-2.491a40.721,40.721,0,0,0-5.181-6.145,26.55,26.55,0,0,0-9.014-5.661,17.685,17.685,0,0,0-2.738-.738,21.2,21.2,0,0,0-4.715-.238,17.058,17.058,0,0,0-4.029.672,17.93,17.93,0,0,0-12.777,16.459,16.9,16.9,0,0,0,1.817,8.259c.393.617.729,1.273,1.17,1.862a12.218,12.218,0,0,0,4.138,3.676,11.361,11.361,0,0,0,12.119-.827,10.685,10.685,0,0,0,3.544-4.883,10.921,10.921,0,0,0-.058-7.828,8.643,8.643,0,0,0-4.407-4.565c-.443-.184-.912-.284-1.356-.454a9.765,9.765,0,0,0-4.507.423,6.022,6.022,0,0,0-3.364,2.725,5.39,5.39,0,0,0-.856,2.737,6.744,6.744,0,0,0,.188,2.278,4.427,4.427,0,0,0,.939,1.646,4.289,4.289,0,0,0,2.46,1.5,3.214,3.214,0,0,0,1.833-.214,3.49,3.49,0,0,0,1.914-2.473,3.041,3.041,0,0,0-.393-1.927,2.471,2.471,0,0,0-.707.126,3.784,3.784,0,0,1-.126,1.471,2.053,2.053,0,0,1-1.9,1.419,3.113,3.113,0,0,1-3.034-2.333,11.613,11.613,0,0,1-.018-2.486,5.362,5.362,0,0,1,4.916-4.2,7.857,7.857,0,0,1,7.666,5.482,11.7,11.7,0,0,1,.263,3.817,8.84,8.84,0,0,1-5.34,7.12,10.039,10.039,0,0,1-4.579.509,9.266,9.266,0,0,1-6.084-3.659,12.948,12.948,0,0,1-2.419-6.255,16.544,16.544,0,0,1,1.208-8.667,15.1,15.1,0,0,1,4.271-5.628,9.064,9.064,0,0,1,2.381-1.541c-.157.007-.3.019-.45.032.809-.254,1.506-.761,2.31-1.036a16.145,16.145,0,0,1,9.119-.945,4.536,4.536,0,0,1,1.081.3,6.03,6.03,0,0,1-1.129.029l.086.015a13.6,13.6,0,0,0-4.1,1,5.663,5.663,0,0,0-1.191.617,16.7,16.7,0,0,0-1.832,1.651,7.156,7.156,0,0,1,1.872-2.056c.393-.3.871-.466,1.27-.76l.076-.213a4.37,4.37,0,0,0-2.642.438c-1.436.811-1.884,2.515-2.745,3.809-.187.32-.54.532-.664.883l.055.09c1.251-.282,2.6-.167,3.774-.766a4.3,4.3,0,0,0,2.235-2.338c.172-.3.338-.606.486-.92a11.674,11.674,0,0,1,3.46-.792,15.437,15.437,0,0,1,2.386.011l.085.148c-.134.035-.267.07-.389.112l-.492.014a7.615,7.615,0,0,0-4.645,3.412,5.34,5.34,0,0,0-.867,2.184c.171-.065.372-.114.557-.165a1.679,1.679,0,0,1,.259-.958,7.181,7.181,0,0,1,5-3.865,17.324,17.324,0,0,1,2.76-.075,4.266,4.266,0,0,1,1.354.425,24.091,24.091,0,0,1,3,1.983,28.76,28.76,0,0,1,5.56,5.893,63.253,63.253,0,0,1,6.918,13.41c.217.552.47,1.091.652,1.659a7.423,7.423,0,0,1-.841-.764,26.937,26.937,0,0,0-2.133-1.721,15.75,15.75,0,0,0-6.527-2.815,13.244,13.244,0,0,0-4.2.255,8.526,8.526,0,0,0-6.152,6.866,10.772,10.772,0,0,1-1.645.394,18.01,18.01,0,0,0-6.816,3.239,18.549,18.549,0,0,0-6.706,11.029,24.836,24.836,0,0,0-.267,5.151,25.419,25.419,0,0,0,.459,4.391,20.263,20.263,0,0,0-2.177-2.265,5.279,5.279,0,0,1-.522-.651,6.639,6.639,0,0,1-.3-1.194l-.065.153c-.01-.05-.03-.148-.04-.2a4.189,4.189,0,0,1-.1-1.551c.325-.59.71-1.144,1.015-1.744.034-.047.1-.143.133-.192a8.226,8.226,0,0,0,1.642-3.842,9.071,9.071,0,0,0-.24-3.735,38.465,38.465,0,0,0-1.59-3.86c-.193-.447-.332-.914-.542-1.35l-.315.213a7.794,7.794,0,0,1-1.119,2.735c-.718,1.243-1.539,2.428-2.151,3.729a4.177,4.177,0,0,0-.531,1.637c-.027-.128-.05-.251-.067-.372a8.839,8.839,0,0,0-.017,3.572,8.167,8.167,0,0,0,.906,2.154c.084.138.179.277.28.418s.2.271.3.409c.126,0,.256.005.394.012a14.989,14.989,0,0,1,.378-4.88,18.291,18.291,0,0,1,1.121-3.116c.024.044.052.092.085.144l-.026.046a9.24,9.24,0,0,0-.449,1.46,13.478,13.478,0,0,0-.442,4.8c.016.142.042.294.073.444.049.156.117.316.184.474a25.353,25.353,0,0,0,.568,3.042l-.06.047c-.3-.211-.594-.438-.9-.631l-.057-.036-.087-.053c-.019-.012-.057-.035-.077-.046l-.093-.055-.157-.08-.077-.042a16.611,16.611,0,0,0-3.452-1.478,14.631,14.631,0,0,0-4.234-.835,18.416,18.416,0,0,0-6.533.688c-.184.07-.387.123-.56.2l-.049.019c-.215.081-.408.183-.612.275a18.66,18.66,0,0,0-7.227,5.172c.19-.825.562-1.593.828-2.394.535-1.458,1.04-2.929,1.445-4.428a13.238,13.238,0,0,0,.649-3.005c.075.075.154.152.239.233-.011.149-.017.3-.017.458.092-.582-.109-1.157-.031-1.738a26.054,26.054,0,0,0-.1-5.1,17.4,17.4,0,0,0-.36-2.251,15.9,15.9,0,0,0-.475-2.147c-.03-.18-.051-.354-.072-.529a11.394,11.394,0,0,0,1.492-.138,5.271,5.271,0,0,0,4.264-3.159,3.488,3.488,0,0,0-.869-3.651,2.726,2.726,0,0,0-2.694-.567,2.5,2.5,0,0,0-1.522,2.5,1.72,1.72,0,0,0,.928,1.263,1.311,1.311,0,0,0,1.477-.415,1.581,1.581,0,0,0-.157-1.693,2.91,2.91,0,0,0-.851-.7c.278-.505.99-.5,1.472-.332l-.243-.177q-.3,0-.59.011c.3-.03.6-.051.9-.067.022.272.344.31.53.451a2.581,2.581,0,0,1,.894,3.361,4.366,4.366,0,0,1-2.677,2.3,6.572,6.572,0,0,1-2.578.292,47.733,47.733,0,0,0-1.224-4.693,25.835,25.835,0,0,0-2.738-6.212,9.833,9.833,0,0,1,.281-2.1,18,18,0,0,1,2.681-6.248,11.346,11.346,0,0,1,2.322-2.348,9.515,9.515,0,0,1,8.081-1.5l-.134.06.265.026a6.661,6.661,0,0,1,1.638.883,6.556,6.556,0,0,1,2.416,5.5,5.87,5.87,0,0,1-3.82,5.227,4.546,4.546,0,0,1-5.969-2.992,3.381,3.381,0,0,1,1.063-3.372,1.832,1.832,0,0,1,2.594.767,1.042,1.042,0,0,1-.18.973,1.233,1.233,0,0,1-1.417.312,1.18,1.18,0,0,1,.037-1.578,1.2,1.2,0,0,0-.985-.116,2.052,2.052,0,0,0,.09,1.749,1.791,1.791,0,0,0,1.659.872c1.041.046,1.733-1.027,1.811-1.962a2.529,2.529,0,0,0-2.07-2.342,3.027,3.027,0,0,0-2.177.272,4.338,4.338,0,0,0-2.116,3.574,5.317,5.317,0,0,0,3.646,5.2c.207.039.42.075.636.118-.057.178-.234.2-.393.2a6.452,6.452,0,0,1-2.47-.3c-.447-.5-.658-1.159-1.149-1.616a3.685,3.685,0,0,0-2.419-1.039c-.549-.021-1.094-.02-1.639-.036a29.819,29.819,0,0,1,1.929,2.59,2.5,2.5,0,0,0,1.115.772,2.632,2.632,0,0,0,1.755.119c-.086-.417-.628-.41-.934-.591a4.646,4.646,0,0,1-1.487-1.294,9.762,9.762,0,0,0,1.973,1.212c.342.1.693.189,1.037.3a6.94,6.94,0,0,0,1.836.277,9.657,9.657,0,0,0,2.209-.121,18.526,18.526,0,0,0,2.929-.91,8.16,8.16,0,0,0,4.232-4.773,7.752,7.752,0,0,0,.261-3.237,8.558,8.558,0,0,0-1.946-4.151,8.318,8.318,0,0,0-1.893-1.5,8.758,8.758,0,0,0-3.622-1.018,10.187,10.187,0,0,0-6.507,2.213,13.994,13.994,0,0,0-2.142,2.215,16.6,16.6,0,0,0-.976,1.491,21.933,21.933,0,0,0-2.018,4.61c-.01-.216-.018-.429-.02-.639.286-1.1.382-2.249.7-3.346a28.814,28.814,0,0,1,1.822-5.133,17.511,17.511,0,0,1,1.511-2.756,1.3,1.3,0,0,0,.311.711c.332.239.677.464,1.026.684.439-.351,1.094-.514,1.315-1.08a1.615,1.615,0,0,0-.138-.633,4.693,4.693,0,0,0-.932-1.386l-.117-.095c-.091.172-.167.351-.241.531-.019-.093-.053-.277-.071-.369l-.314-.015-.1-.318-.277.1a4.759,4.759,0,0,1-.831.119,4.213,4.213,0,0,0,1-.541,4.332,4.332,0,0,0-2.2-.466,3.467,3.467,0,0,0-.673,1.7,8.338,8.338,0,0,1,.965.826c.3-.006.609-.024.918-.029a18.8,18.8,0,0,0-1.561,2.755,29.659,29.659,0,0,0-2.407,7.04,20.669,20.669,0,0,0-.354,2.427c-.051.168-.116.331-.167.5-.087-1.081.035-2.162.053-3.24V809.8c-.01-.8.056-1.6.1-2.4.1-1.467.276-2.928.469-4.385.093-.8.306-1.575.332-2.378a56.818,56.818,0,0,1,1.76-6.991,47.154,47.154,0,0,1,3.08-7.81,21.021,21.021,0,0,1,3.268-4.714,15.747,15.747,0,0,1,6.32-4.057,14.11,14.11,0,0,1,1.415-.4,17.2,17.2,0,0,1,4.321-.251,9.334,9.334,0,0,1,3.311.682,11.7,11.7,0,0,1,3.841,2.225,7.183,7.183,0,0,1,2.006,2.647q-.028-.23-.037-.451a8.71,8.71,0,0,0,.459.956,10.172,10.172,0,0,1,1.08,3.28c0,.444.022.889.022,1.337a9.874,9.874,0,0,1-2.572,6.612,8.9,8.9,0,0,1-3.552,2.464,6.492,6.492,0,0,1-1.255.407,9.737,9.737,0,0,1-3.56-.231c-.516-.154-1.009-.369-1.511-.551a7.017,7.017,0,0,1-2.059-1.714,6.494,6.494,0,0,1-1.113-6.321,6.866,6.866,0,0,1,2.642-3.4,2.432,2.432,0,0,1,.918-.483,6.737,6.737,0,0,0-.552.849,2.768,2.768,0,0,0,.413,2.775,2.094,2.094,0,0,0,3.116-.3,2.585,2.585,0,0,0-.519-3.549,4.467,4.467,0,0,0-4.579-.249,6.55,6.55,0,0,0-3.651,5.065,9.169,9.169,0,0,0,.3,3.641,7.806,7.806,0,0,0,2.075,3.133,9.264,9.264,0,0,0,4.518,2.261,11.828,11.828,0,0,0,11.665-5.284,10.615,10.615,0,0,0,1.168-2.667,11.271,11.271,0,0,0-.011-4.984c-.248-.93-.5-1.86-.836-2.763a9.6,9.6,0,0,1-.346-3.9,4.549,4.549,0,0,1,2.111-3.325,5.721,5.721,0,0,1,5.64.267,4.655,4.655,0,0,1,2.077,2.249,3.53,3.53,0,0,1-1.246,4.378,2.8,2.8,0,0,1-2.258.134,3.238,3.238,0,0,0,1.915-.509,2.229,2.229,0,0,0,.533-2.59,2.426,2.426,0,0,0-1.854-1.52,2.612,2.612,0,0,0-2.686,2.643,2.554,2.554,0,0,0,.973,1.87,3.446,3.446,0,0,0,2.21.9,3.949,3.949,0,0,0,1.87-.631,4.342,4.342,0,0,0,1.344-1.959,4.547,4.547,0,0,0-.758-3.993,6.833,6.833,0,0,0-6.921-2.572,7.586,7.586,0,0,0-4.631,4.275,15.686,15.686,0,0,1-.815-3.987,17.92,17.92,0,0,1,.157-3.485l0-.011a7.545,7.545,0,0,0,.246-1.365c.023-.269-.047-.581.174-.789a5.767,5.767,0,0,1,.041,1.358,3.567,3.567,0,0,0-.2,1.121,1.075,1.075,0,0,0,.52-.434,3.5,3.5,0,0,0,.687-1.743c.013-1.343-.941-2.454-1.022-3.775l-.219-.047a11.585,11.585,0,0,0-1.371,2.6,3.148,3.148,0,0,0,.351,2.432,3.072,3.072,0,0,1,.183,1.476,16.155,16.155,0,0,0-.02,3.958l-.034.037c-.3-.682-.525-1.392-.776-2.091-.09-.226-.164-.455-.236-.684a8.3,8.3,0,0,1-.584-1.552,19.625,19.625,0,0,1-.235-7.127,19.174,19.174,0,0,1,1.437-5.061,3.409,3.409,0,0,1,.531-.994,14.308,14.308,0,0,1,.868-1.433,12.65,12.65,0,0,1,5.329-4.6,11.432,11.432,0,0,1,7.94-.5,10.029,10.029,0,0,1,5.7,4.334c.142.236.256.486.385.738a9.554,9.554,0,0,1-.438,9.631,9.408,9.408,0,0,1-5.651,3.933,19.582,19.582,0,0,1-2.871.075,10.072,10.072,0,0,1-1.842-.318,1.133,1.133,0,0,1,.179-.053,7.122,7.122,0,0,1-3.269-2.149,6.278,6.278,0,0,1-1.259-6.175,5.878,5.878,0,0,1,2.661-3,4.828,4.828,0,0,1,3.565-.377,5.535,5.535,0,0,0-1.569,1.095,3.147,3.147,0,0,0-.685,3.157,2.887,2.887,0,0,0,2.857,1.817,2.817,2.817,0,0,0,2.357-1.668,3.815,3.815,0,0,0-.336-3.664,5.368,5.368,0,0,0-2.67-2.059,6.778,6.778,0,0,0-5.677.619,6.1,6.1,0,0,0-2.984,5.453,7.856,7.856,0,0,0,1.18,4.406,8.884,8.884,0,0,0,4.581,3.579,10.85,10.85,0,0,0,5.263.461,13.215,13.215,0,0,0,9.411-6.984,2.652,2.652,0,0,1,.565-1.014,5.424,5.424,0,0,0,.274,1.148,8.222,8.222,0,0,0,3.952,4.472c.636.3,1.306.514,1.967.754a9,9,0,0,0,5.486.1,3.277,3.277,0,0,0,1.429-.591c.383-.248.766-.5,1.164-.721a5.453,5.453,0,0,1-1.728,1.357c-.149.05-.292.1-.432.148l-.31.1-.068.169a2.705,2.705,0,0,0,1.6.04c1.264-.27,1.835-1.536,2.544-2.472.194-.321.615-.51.642-.914-1,.162-2.077-.071-3.018.391a3.888,3.888,0,0,0-1.821,1.815c-.08.124-.156.25-.226.377a8.566,8.566,0,0,1-2.692.179c-.119-.025-.233-.046-.341-.062a10.108,10.108,0,0,0,1.5-.484,5.487,5.487,0,0,0,3.059-4.635,4.706,4.706,0,0,0-1.673-3.577,3.2,3.2,0,0,0-3.358-.272,2.315,2.315,0,0,0-1.317,1.988c.023,1.052.923,2.222,2.068,2.041a1.891,1.891,0,0,0,1.566-2.449.7.7,0,0,0-1.055-.011,1.335,1.335,0,0,1,.282,1.19.975.975,0,0,1-.928.414,1.054,1.054,0,0,1-.74-1.685,1.814,1.814,0,0,1,2.718-.167,3.574,3.574,0,0,1,.72,2.9,4.322,4.322,0,0,1-2.728,3.11,4.411,4.411,0,0,1-3.51-.091,6.246,6.246,0,0,1-3.107-3.186,6.409,6.409,0,0,1-.353-3.189,7.192,7.192,0,0,1,.989-2.724,5.835,5.835,0,0,1,3.344-2.48,9.715,9.715,0,0,1,6.22.577,10.891,10.891,0,0,1,5.075,5.315,20.033,20.033,0,0,1,1.771,7.454,17.787,17.787,0,0,0-1.909,3.387Zm-39.789,44.871a3.418,3.418,0,0,0,3.2.784,2.769,2.769,0,0,0,1.689-1.317,1.765,1.765,0,0,1-.836,1.338,2.813,2.813,0,0,1-2.625.287A3.586,3.586,0,0,1,2854.443,817.252Zm1.863-31.888a1.452,1.452,0,0,1,.758.4,9.171,9.171,0,0,1-.133,3.8,9.606,9.606,0,0,1-2.528,4.131,3.853,3.853,0,0,1-1.016.877,2.725,2.725,0,0,1,.556-.725A10.632,10.632,0,0,0,2856.306,785.364Zm6.555-16.225a8.278,8.278,0,0,1-1.225-.551A10.15,10.15,0,0,1,2862.861,769.139ZM2896.7,755a47.027,47.027,0,0,1,.313,5.548c.032.777.019,1.557.01,2.337-.011.295-.014.591-.012.889a2.285,2.285,0,0,0-.117,1.063c-.047-.226-.09-.448-.122-.672a7.365,7.365,0,0,0-.154-1.3c-.172-.815-.274-1.643-.487-2.447a30.837,30.837,0,0,0-1.577-4.768c-.208-.508-.475-.988-.685-1.491-.312-.586-.607-1.182-.96-1.743-.011-.056-.036-.169-.047-.225.185.106.354.286.593.274a1.148,1.148,0,0,0,.658-.335c.214-.18.434-.353.663-.52-.02-.175-.033-.347-.041-.517h-.035l.053-.177-.065.112a2.829,2.829,0,0,0-.474-1c-.3-.3-.75-.147-1.107-.1a2.663,2.663,0,0,0-1.141.414,3.721,3.721,0,0,1,.656.478c-.287-.036-.553-.077-.826-.132,0,.076.016.23.021.306l-.362-.007a3.6,3.6,0,0,1-.2.92,7.608,7.608,0,0,1-.169-1.014l-.239.032a7.016,7.016,0,0,0-.784,1.146,1.606,1.606,0,0,0-.163,1.024,13.5,13.5,0,0,0,1.208.852c.5-.3,1.205-.529,1.367-1.151l.246.049c.254.724.685,1.37.978,2.078a29.91,29.91,0,0,1,1.4,3.866,20.39,20.39,0,0,1,.608,2.375,18.128,18.128,0,0,1,.42,3.429c-.231-.56-.372-1.149-.556-1.724a14.752,14.752,0,0,0-5.253-7.464,9.473,9.473,0,0,0-5.443-1.628,7.479,7.479,0,0,0-5.014,1.654,15.546,15.546,0,0,0-1.3,1.425,9.271,9.271,0,0,0-.812,1.576c-.287-.371-.223-.866-.311-1.3a10.921,10.921,0,0,0-1.012-2.766l-.134-.179a3.511,3.511,0,0,0,2.26-.51,3.076,3.076,0,0,0,.955-1.281,4.16,4.16,0,0,0-.143-2.556,9.124,9.124,0,0,0-.853-1.345,13.393,13.393,0,0,0,2.187-1.221,8.428,8.428,0,0,0,2.316-2.722,8.7,8.7,0,0,0,.771-4.56c-.015-.065-.045-.193-.061-.258a6.483,6.483,0,0,0-4.333-5.066,4.351,4.351,0,0,0-3.336.19,2.969,2.969,0,0,0-1.457,2.065,2.334,2.334,0,0,0,2.322,2.627c1.072.078,1.8-1,1.886-1.964a3.212,3.212,0,0,0-.634-2.212,7.078,7.078,0,0,1,3.662,5.095l-.039.09c.022.5.015,1,.07,1.5a5.78,5.78,0,0,1-.5,1.881,7.038,7.038,0,0,1-3.895,3.691,8.159,8.159,0,0,1-1.328-.568,16.111,16.111,0,0,0-6.686-.981c-.45-.473-.921-.924-1.355-1.411-.012-.279.277-.3.48-.367a19.688,19.688,0,0,1,3.684-.708c0-.086.01-.259.014-.345a19.452,19.452,0,0,0-4.446.843c-.1-.068-.2-.134-.3-.2a20.213,20.213,0,0,1-.935-1.908c-.1-.28-.183-.562-.262-.843a8.8,8.8,0,0,1-.266-4.352l.029-.141a10.751,10.751,0,0,1,6.845-7.9,13.215,13.215,0,0,1,8.213-.5,15.414,15.414,0,0,1,6.895,3.881,17.721,17.721,0,0,1,3.238,4.3,27.31,27.31,0,0,1,1.479,3.085c.321.71.562,1.454.841,2.183.139.4.28.8.407,1.214a68.774,68.774,0,0,1,2.029,7.925A41.113,41.113,0,0,1,2896.7,755Zm26-54.6a4.341,4.341,0,0,0,5.058-1.861,2.32,2.32,0,0,1-.752,1.445,3.588,3.588,0,0,1-3.419,1.021,4.363,4.363,0,0,1-2.357-1.333A10.249,10.249,0,0,0,2922.692,700.4Zm1.462-23.239a3.7,3.7,0,0,1-3,2.3,4.43,4.43,0,0,1-3.311-.677c.338-.345.677-.69,1.007-1.045a8.368,8.368,0,0,0,.837-.779,2.633,2.633,0,0,0,2.286-.052,2.762,2.762,0,0,0,1.445-2.271c.029-.3.359-.439.627-.458.241.192.257.562.332.85a3.776,3.776,0,0,1-.227,2.133Zm-6.548-7.484a6.669,6.669,0,0,1,2.7-1.381,6.087,6.087,0,0,1,1.882-.2,8.028,8.028,0,0,1,4.189,1.149,1.265,1.265,0,0,0-.059.221,5.7,5.7,0,0,0-1.465.341,23.461,23.461,0,0,0-3.617,1.382l-.2.081a8.474,8.474,0,0,0-1.652.826c-.351.274-.742.486-1.107.735a16.41,16.41,0,0,0-2.606,2.008h-.144a6.149,6.149,0,0,1,2.075-5.166Z" transform="translate(-2435.344 -572.813)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3947.479,698.51a.535.535,0,0,0,.16.576c.277.271.565.532.84.812a12.752,12.752,0,0,1,1.417,1.654v-2.877C3949.08,698.733,3948.287,698.511,3947.479,698.51Z" transform="translate(-3456.455 -611.66)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3015.831,956.829a11.512,11.512,0,0,1,.916,1.11,9.441,9.441,0,0,1,1.509,7.219,10.749,10.749,0,0,0,1.341-7.229,14.314,14.314,0,0,0-.455-2.159,18.5,18.5,0,0,0-.4-1.874,3.276,3.276,0,0,0-1.045-1.391,2.434,2.434,0,0,0-2.35-.2,2.378,2.378,0,0,0-1.188,1.519,2.546,2.546,0,0,0,.281,1.8c.332.539.974.746,1.391,1.205Z" transform="translate(-2639.204 -833.705)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M2939.85,993.618a6.754,6.754,0,0,0,1.85.4,10.6,10.6,0,0,1,3.968,2.021,10.928,10.928,0,0,1,3.449,4.622l.042.124a1.585,1.585,0,0,0,.272.665,8.719,8.719,0,0,0-.326-3.317c-.027-.121-.05-.241-.066-.358a16.375,16.375,0,0,0-3.525-6.076,12.323,12.323,0,0,1-1.144-1.263,4.832,4.832,0,0,0-2.583-1.988,2.886,2.886,0,0,0-3.174,1.586A2.757,2.757,0,0,0,2939.85,993.618Z" transform="translate(-2572.864 -865.485)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3171.69,1001.786a3.408,3.408,0,0,0,2.108-2.037,3.23,3.23,0,0,0-1.377-3.845,3.224,3.224,0,0,0-3.576,5.356,3.7,3.7,0,0,0,2.845.526Z" transform="translate(-2773.532 -871.663)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3205.7,1043.869c-.119-.06-.235-.119-.344-.178a2.461,2.461,0,0,0-2.958,1.052,2.794,2.794,0,0,0-.228,1.828,2.458,2.458,0,0,0,2.552,1.784c.163-.049.34-.088.516-.123.173-.082.354-.162.537-.24a2.786,2.786,0,0,0,.985-1.3A2.414,2.414,0,0,0,3205.7,1043.869Z" transform="translate(-2803.825 -913.771)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3055.635,1061.947a16.077,16.077,0,0,0,5.441,9.323l-.187-.194a13.835,13.835,0,0,1-1.833-2.02,16.411,16.411,0,0,1-3.163-7.374,10.376,10.376,0,0,1,1.313-6.9,7.785,7.785,0,0,1,5.213-3.845,6.1,6.1,0,0,1,5.4,1.547,5.138,5.138,0,0,1,1.029,5.839,4.072,4.072,0,0,1-2.879,2.34,3.875,3.875,0,0,1-3.364-.831,3.1,3.1,0,0,1-.951-3.125,2.575,2.575,0,0,1,2.061-1.989,2.231,2.231,0,0,1,2.43,1.264,1.789,1.789,0,0,1-.944,2.32,1.423,1.423,0,0,1-1.762-.718,2.032,2.032,0,0,0,1.152.2,1.053,1.053,0,0,0,.55-1.591,1.187,1.187,0,0,0-1.728-.144,1.614,1.614,0,0,0-.081,2.3,2,2,0,0,0,2.5.352,2.52,2.52,0,0,0,.565-3.671,3.048,3.048,0,0,0-2.932-1.022,3.458,3.458,0,0,0-2.67,3.34,3.854,3.854,0,0,0,1.425,3.14,4.711,4.711,0,0,0,5.653.138,5.68,5.68,0,0,0,1.181-7.636,6.4,6.4,0,0,0-4.525-2.679,7.36,7.36,0,0,0-3.481.471,8.474,8.474,0,0,0-3.973,3.413,10.721,10.721,0,0,0-1.434,7.755Z" transform="translate(-2675.389 -919.671)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M2890.831,1061.443a4.125,4.125,0,0,0,2.823.478,8.162,8.162,0,0,1,3.561-.285,14.439,14.439,0,0,1,3.775.8,16.21,16.21,0,0,1,6.8,4.313,9.63,9.63,0,0,1,1.224,1.657,8.712,8.712,0,0,0-.812-2.488,17.555,17.555,0,0,0-2.854-4.3,25.025,25.025,0,0,0-7.784-5.732,7.384,7.384,0,0,1-.933-.608,5.741,5.741,0,0,0-2.9-1.2,10.051,10.051,0,0,0-1.964.05,4.363,4.363,0,0,0-1.969,1.315,4.021,4.021,0,0,0-.728,3.862,4.184,4.184,0,0,0,1.761,2.128Z" transform="translate(-2529.528 -922.986)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3597.928,1077.013a17.107,17.107,0,0,0-1.79-.353,10.69,10.69,0,0,0-1.582,2.518c-.164.98.771,1.592,1.408,2.157a2.8,2.8,0,0,0,1.833,1.065c-.114-.744-.347-1.465-.414-2.215.336.666.621,1.358.929,2.039l.2.032c.1-.144.216-.287.331-.429.167-.551.285-1.115.426-1.672a6.372,6.372,0,0,0,.109-2.082C3599.241,1077.4,3598.536,1077.108,3597.928,1077.013Z" transform="translate(-3147.429 -942.773)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3635.062,1086.832a2.076,2.076,0,0,0-1.708.182,4.473,4.473,0,0,0-1,2.251,2.359,2.359,0,0,0-.068,1.787c.588-.432,1.153-.9,1.775-1.284-.42.682-1.183,1.133-1.453,1.9a4.369,4.369,0,0,0,2.6-.261,5.789,5.789,0,0,0,1.617-.7,1.093,1.093,0,0,0,.45-.831c.051-.913-.45-1.75-.4-2.664-.611-.094-1.205-.256-1.807-.378Z" transform="translate(-3180.345 -951.596)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3210.743,1092.238c.053-.123.112-.245.178-.364a2.611,2.611,0,0,0,.071-1.22c-.088-.184-.165-.367-.24-.551-.16-.169-.313-.345-.485-.5a1.965,1.965,0,0,0-2.371,3.133A2.008,2.008,0,0,0,3210.743,1092.238Z" transform="translate(-2808.195 -953.756)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3571.365,1109.5c-.847.6-1.111,1.661-1.791,2.4,0,.042,0,.128,0,.17a12.6,12.6,0,0,0,1.779,2.27c.749.512,1.61-.021,2.293-.393a4.1,4.1,0,0,0,1.878-1.435c-.092-.272-.515-.137-.74-.213a9.2,9.2,0,0,1-1.387-.154.172.172,0,0,1,.213-.168,13.958,13.958,0,0,1,1.692-.108c.1-.015.287-.045.384-.058a3.21,3.21,0,0,0-1.71-1.511A4.2,4.2,0,0,0,3571.365,1109.5Z" transform="translate(-3125.567 -971.505)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3192.25,1123.036a1.54,1.54,0,0,0,2.271-.547,1.572,1.572,0,0,0-.832-2.151,3.729,3.729,0,0,0-1.052,0,3.268,3.268,0,0,0-.77.593c-.082.229-.168.458-.249.688a1.628,1.628,0,0,0,.632,1.419Z" transform="translate(-2794.627 -980.985)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3621.917,1125.8a.727.727,0,0,0,.935-.82c-.207-.27-.461-.565-.838-.489-.119.06-.234.121-.344.182A.718.718,0,0,0,3621.917,1125.8Z" transform="translate(-3171.032 -984.647)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3635.072,1134.313a7,7,0,0,0,2.1-1.015c.154-.077.313-.146.484-.211a11.627,11.627,0,0,0-.3-2.7,1.56,1.56,0,0,0-1.545-1.014,20.994,20.994,0,0,0-2.58.05,4.019,4.019,0,0,0-.56.373c.562.47,1.159.9,1.751,1.335a17.176,17.176,0,0,1-2.122-.9,1.788,1.788,0,0,0,.276,1.454,11.82,11.82,0,0,0,1.291,1.932A1.619,1.619,0,0,0,3635.072,1134.313Z" transform="translate(-3180.443 -988.916)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3598.51,1138.456a8.389,8.389,0,0,0-1.249,1.741,1.347,1.347,0,0,0,.388,1.473c.5.5,1.019.983,1.5,1.5a20.039,20.039,0,0,0,2.249-.879,1.536,1.536,0,0,0,.808-1.019,6.31,6.31,0,0,0-.373-2.174c-.2-.581-.335-1.345-.983-1.582-.214.6-.442,1.19-.677,1.78a2.818,2.818,0,0,0-.152.312c.123-.8.225-1.607.322-2.412C3599.548,1137.255,3599.021,1137.927,3598.51,1138.456Z" transform="translate(-3149.739 -995.783)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3174.463,1142.909c-.282.274-.168.688-.162,1.036.2.211.365.507.678.565a1.017,1.017,0,0,0,1.332-.965,1.157,1.157,0,0,0-.682-1.031A1.09,1.09,0,0,0,3174.463,1142.909Z" transform="translate(-2779.44 -1000.41)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3155.822,1153.614c-.221-.272-.589-.223-.9-.22-.182.218-.5.381-.494.7-.083.379.228.646.45.9.208.01.418.02.637.034.177-.159.352-.322.542-.47C3156.056,1154.232,3156.118,1153.839,3155.822,1153.614Z" transform="translate(-2762.055 -1009.958)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3139.149,1156.427c-.313-.067-.508.206-.683.408,0,.108-.005.325-.006.432.164.159.284.463.566.412a.683.683,0,0,0,.7-.837C3139.552,1156.682,3139.413,1156.408,3139.149,1156.427Z" transform="translate(-2748.081 -1012.609)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3400.961,1156.2a9.717,9.717,0,0,1-1.591.963,2.229,2.229,0,0,0-1.072.994c-.246,1.016.379,1.94.785,2.825a6.055,6.055,0,0,0,1.121,1.58c.133.056.274.111.42.165.158-.618.148-1.262.291-1.882a8.134,8.134,0,0,1,.236,1.636l.122.092a2.67,2.67,0,0,0,.955-.73c.346-.648.713-1.284,1.088-1.914a1.612,1.612,0,0,0,0-1.854A16.321,16.321,0,0,0,3400.961,1156.2Z" transform="translate(-2975.55 -1012.419)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3834.407,1185.607c.34,1.521.26,3.092.481,4.63a3.083,3.083,0,0,0,1.09,1.893,9.244,9.244,0,0,1-2.774,1.575,7.877,7.877,0,0,1-4.14.4,8.626,8.626,0,0,1-3.371-1.286,9.045,9.045,0,0,1-4.051-5.665,8.193,8.193,0,0,1,1.483-6.4,6.788,6.788,0,0,1,2.437-2.009,5.2,5.2,0,0,1,4.247-.047,5.045,5.045,0,0,1,3.218,3.854,3.191,3.191,0,0,1-1.359,2.886,2.16,2.16,0,0,1-3.124-1.169c-.26-.047-.677-.061-.728.274a2.6,2.6,0,0,0,1.411,2.31,4.328,4.328,0,0,0,2.527.356,3.215,3.215,0,0,0,1.795-1.38,4.8,4.8,0,0,0,.514-4.082,5.95,5.95,0,0,0-2.534-3.193,6.533,6.533,0,0,0-4.24-1c-.266.073-.535.132-.795.2a8.154,8.154,0,0,0-3.855,2.1,7.833,7.833,0,0,0-2.262,5.806,9.6,9.6,0,0,0,1.543,5.012,12.584,12.584,0,0,0,2.868,3.069c.41.262.816.54,1.243.785a11.581,11.581,0,0,0,3.2,1.178,16.349,16.349,0,0,0,3.531.044c.705-.168,1.417-.331,2.106-.567.6-.231,1.168-.526,1.748-.8a4.167,4.167,0,0,0-.725,1.106,7.427,7.427,0,0,0-.219,2.748c-.007.712.146,1.412.154,2.123,0,.413,0,.827.012,1.243a27,27,0,0,1,2.77.81v-8.861a9.98,9.98,0,0,1-1.351.411c.448-.335.919-.638,1.351-1v-9.552a23.908,23.908,0,0,0-2.837,1.493c-.451.245-.914.462-1.363.7Zm-2.45.766a2.658,2.658,0,0,1-1.69.228,2.93,2.93,0,0,1-.966-.4,5.312,5.312,0,0,0,1.9.041,3.353,3.353,0,0,0,2.372-2.312A2.941,2.941,0,0,1,3831.957,1186.373Z" transform="translate(-3345.174 -1031.079)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3366.008,1179.729a1.4,1.4,0,0,0-1.215-.2,7.973,7.973,0,0,0-1.521.758c-.328.2-.678.349-1,.545a10.6,10.6,0,0,0,.125,1.321,3.1,3.1,0,0,0,.423,1.881c.522.619,1.413.539,2.147.553a4.913,4.913,0,0,0,2.922-.551,2.366,2.366,0,0,1-.039-.254,13.86,13.86,0,0,1-2.1-1.317.427.427,0,0,1,.363.192c.692.163,1.33.506,2.041.606a2.761,2.761,0,0,0-.661-1.69A9.576,9.576,0,0,0,3366.008,1179.729Z" transform="translate(-2944.043 -1032.801)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3431.537,1187.654c.448-.84.543-1.806.912-2.677a8.955,8.955,0,0,1-1.338-1.091,2.084,2.084,0,0,0-1.474-.751c-.633-.037-1.083.459-1.524.831-.481.394-.851.9-1.3,1.325a2.006,2.006,0,0,0-.613,1.5c.816-.158,1.615-.427,2.445-.506-.709.328-1.41.669-2.121.989.18.516.79.642,1.248.815l.269.049a14.273,14.273,0,0,0,2.338.284,1.365,1.365,0,0,0,1.156-.769Z" transform="translate(-3000.019 -1036)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3413.585,1212.532a1.05,1.05,0,0,0,.143-.9c-.107-.1-.207-.2-.3-.3-.3-.031-.661-.113-.867.162-.335.246-.185.72-.015,1.024A.9.9,0,0,0,3413.585,1212.532Z" transform="translate(-2987.913 -1060.666)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3378.468,1221.934c-.6.517-1.178,1.055-1.769,1.58-.059-.016-.109-.029-.153-.037.243-.082.337-.347.491-.535.289-.417.588-.826.891-1.234-.011-.062-.035-.188-.047-.251a3.254,3.254,0,0,0-1.587.158,18.05,18.05,0,0,0-2.1.767,1.556,1.556,0,0,0-.774,1.6c.1.861.382,1.689.51,2.547a7.208,7.208,0,0,1,1.146.162,4.46,4.46,0,0,0,2.011.2,1.874,1.874,0,0,0,.978-1.184,19.785,19.785,0,0,0,.674-2.4C3378.727,1222.863,3378.924,1222.208,3378.468,1221.934Z" transform="translate(-2953.803 -1069.533)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3418.534,1227.71a5.151,5.151,0,0,0,1.813.275c.42.045.844.068,1.271.085a8.139,8.139,0,0,1,.79-1.612,2.034,2.034,0,0,0,.383-1.556,1.9,1.9,0,0,0-.753-.959,15.459,15.459,0,0,0-1.854-1.19,2.761,2.761,0,0,0-1.7-.418c.184.818.745,1.489.969,2.295-.512-.606-.971-1.254-1.489-1.851-.708,1.051-.31,2.363-.342,3.536A1.671,1.671,0,0,0,3418.534,1227.71Z" transform="translate(-2992.452 -1070.309)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3722.077,1265.508a5.315,5.315,0,0,0-1,1.641,7.576,7.576,0,0,0,1.129,1.573,2.343,2.343,0,0,0,1.75-.457c.378-.235.872-.435.994-.912-.4-.053-.792-.1-1.18-.172a3.283,3.283,0,0,1,1.284-.207c-.086-.174-.167-.347-.244-.517l.454.034a6.6,6.6,0,0,1-.277-1.434c.217.428.407.871.592,1.315l.256-.029a4.583,4.583,0,0,0,.476-1.82c.04-.45.128-1.006-.269-1.327a4.124,4.124,0,0,0-1.418-.42c-.158-.044-.3-.091-.445-.137-.278.429-.617.812-.893,1.241a1.038,1.038,0,0,0,.035,1.264c.33.373.754.648,1.095,1.016a17.021,17.021,0,0,0-1.682-.755,1.117,1.117,0,0,0-.659.1Z" transform="translate(-3258.231 -1105.62)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3762.673,1273.45a4.329,4.329,0,0,0,1.573-.172c.505-.221,1.176-.328,1.422-.892a10.167,10.167,0,0,0-.269-1.935,6.653,6.653,0,0,0-2.2-.259,2.9,2.9,0,0,0-.761,1.473,2.614,2.614,0,0,0-.129,1.358,9.9,9.9,0,0,1,1.161-.761c-.205.25-.42.49-.629.734-.111.131-.284.267-.163.454Z" transform="translate(-3294.299 -1112.218)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3755.635,1295.139a.377.377,0,0,0-.464.464c-.027.407.455.367.732.32l.18-.328C3755.983,1295.4,3755.919,1295.079,3755.635,1295.139Z" transform="translate(-3288.07 -1134.069)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3742.871,1301.3a1.106,1.106,0,0,0,.869.076c.5-.234.965-.539,1.454-.8-.094-.53-.115-1.07-.2-1.6-.069-.346-.367-.552-.6-.784a9.036,9.036,0,0,0-2.508.134c.007.061.021.183.027.244a11.187,11.187,0,0,1,1.049.767c-.432-.147-.841-.344-1.26-.509l-.169-.061c.005.22.017.444.039.668-.174-.152-.32-.295-.488-.435-.156.424-.3.851-.5,1.26a12.829,12.829,0,0,1,.134-1.48,3.028,3.028,0,0,0-1.42,1.1,2.837,2.837,0,0,0-.71,1.244,1.763,1.763,0,0,0,.619.948c.256.24.511.488.764.739.7-.419,1.885-.444,2.052-1.426a12.917,12.917,0,0,0-.4-1.632l.2.075A6.21,6.21,0,0,0,3742.871,1301.3Z" transform="translate(-3273.564 -1136.734)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3058.052,1363.438a4.905,4.905,0,0,0,2.555.31,4.673,4.673,0,0,0,2.193-1.194,4.472,4.472,0,0,0,1.213-2.727,4.67,4.67,0,0,1,3.382-1.1,5.471,5.471,0,0,1,5.359,3.963c.072-.187.141-.376.219-.56a9.6,9.6,0,0,0-1.285-2.973,10.842,10.842,0,0,0-4.611-3.723,19.838,19.838,0,0,0-3.263-.851,13.836,13.836,0,0,0-3.183.133,14.648,14.648,0,0,0-2.239.724,5.287,5.287,0,0,0-2.541,2.658,3.787,3.787,0,0,0,.18,3.422A4.426,4.426,0,0,0,3058.052,1363.438Z" transform="translate(-2675.467 -1186.098)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3914.838,1380.741a3.686,3.686,0,0,0-1.546-2.357,4.62,4.62,0,0,0-2.728.274c-.576.182-1.179.236-1.764.363-.138,1.485-.76,2.95-.474,4.458.208.795.99,1.177,1.668,1.51a17.8,17.8,0,0,1,1.884.493,6.223,6.223,0,0,0,1.753.4,8.626,8.626,0,0,0,.907-.174,2.52,2.52,0,0,0-.148-.41l-.115-.148c-.315-.386-.6-.79-.908-1.178a3.542,3.542,0,0,1-.682-1.007,8.1,8.1,0,0,1,1.016.847c.31.27.646.514.958.79.235.193.461.464.809.418l.092-.053v-1.221c-.088-.795-.367-1.549-.491-2.335C3914.986,1381.183,3914.908,1380.961,3914.838,1380.741Z" transform="translate(-3422.122 -1206.859)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3640.264,1402.369c-.406-.442-1.054-.26-1.581-.292-.4-.087-.414.418-.576.659a.975.975,0,0,0,.055,1.281,3.427,3.427,0,0,1,.919.59,7.025,7.025,0,0,0-1.768-.243,1.291,1.291,0,0,0,.362,2.424,1,1,0,0,0,1.152-.259c.272-.231.532-.479.821-.693,0-.09-.012-.266-.016-.354l-.47.007a.454.454,0,0,1,.468-.286.568.568,0,0,1,.129-.526c-.108-.291-.214-.582-.3-.876.234.289.465.582.73.851A4.08,4.08,0,0,0,3640.264,1402.369Z" transform="translate(-3184.303 -1227.703)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3667.792,1403.267a1.386,1.386,0,0,0-.416.418,5.606,5.606,0,0,0-.106,1.872c.3-.223.581-.484.875-.725-.186.343-.389.675-.581,1.014a2.183,2.183,0,0,0,.977-.157,2.611,2.611,0,0,0,1.214-.84,2.79,2.79,0,0,0-.409-1.606A14.661,14.661,0,0,0,3667.792,1403.267Z" transform="translate(-3211.073 -1228.726)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3663.534,1424.432c-.158.132-.071.34-.068.514.241.053.7.091.631-.295A.321.321,0,0,0,3663.534,1424.432Z" transform="translate(-3207.761 -1247.191)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3964.689,1439.194v-1.464A.983.983,0,0,0,3964.689,1439.194Z" transform="translate(-3471.251 -1258.931)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3903.828,1449.213a2.516,2.516,0,0,0,2.186-.25,3.939,3.939,0,0,0,.961-1.281c.256-.474.542-.93.789-1.409.026-.051.077-.153.1-.205a3.315,3.315,0,0,0,.6-2.279,5.9,5.9,0,0,0-1.455.582c-.4.189-.8.4-1.192.6-.173.036-.342.077-.5.123a12.032,12.032,0,0,1,1.123-.843,15.449,15.449,0,0,0,1.7-1.351c-.163-.137-.326-.272-.494-.387a12.036,12.036,0,0,0-3.549-.134,7.424,7.424,0,0,0-2.384.557,1.917,1.917,0,0,0-.936,1.428c-.06,1.169.133,2.336-.011,3.5C3901.788,1448.305,3902.82,1448.733,3903.828,1449.213Z" transform="translate(-3415.565 -1262.942)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3956.631,1463.366a5.128,5.128,0,0,0,.026,2.348c.3.376.619.825,1.153.848v-7.122c-.168.353-.351.7-.489,1.067A16.622,16.622,0,0,0,3956.631,1463.366Z" transform="translate(-3464.375 -1277.941)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3218.862,1464.3a20.873,20.873,0,0,1-2.317.474c-.115.019-.217.045-.317.07a2.179,2.179,0,0,0-.607.812,3.619,3.619,0,0,0-.062,1.279c.029.2.071.4.106.606a7.5,7.5,0,0,0,.32,1.684c.081.291.209.627.57.637.179-.378.375-.75.531-1.138a4.415,4.415,0,0,1,.439-.843c-.01.18-.014.362-.015.547a7.873,7.873,0,0,0-.381,1.148c-.012.156-.019.315-.021.478l.348.037.113-.126a3.306,3.306,0,0,0,1.119-.713c.581-.552,1.363-.97,1.673-1.748.224-1.132-.764-1.95-1.278-2.84-.08-.123-.153-.245-.221-.365Z" transform="translate(-2815.567 -1282.196)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3234.3,1503.311a3.687,3.687,0,0,0,1.342-1.4c.207-.325.473-.606.684-.928.025-.183-.131-.322-.205-.465-.345-.476-.554-1.029-.872-1.517a1.472,1.472,0,0,0-1.113-.657,5.685,5.685,0,0,0-2.227.8,6.517,6.517,0,0,0-1.262.82l-.252.183c-.027.146-.056.291-.072.44l.264.034q.213,0,.44.011a6.77,6.77,0,0,1,1.525.245,6.653,6.653,0,0,1-1.451.188c-.233.016-.46.029-.683.045a4.223,4.223,0,0,0,.148.433c.214.224.444.435.677.648.576.286,1.118.634,1.684.945A1.89,1.89,0,0,0,3234.3,1503.311Z" transform="translate(-2828.515 -1312.002)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3217.385,1513.356a.7.7,0,0,0-.052-.871c-.173-.224-.5-.183-.735-.134a.661.661,0,1,0,.788,1.005Z" transform="translate(-2816.155 -1324.237)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3209.35,1529.45c.24.745,1.024,1.085,1.7,1.348a4.334,4.334,0,0,0,1.329.48c.531-.5,1.071-.988,1.6-1.491a1.552,1.552,0,0,0-.069-2.1,11.232,11.232,0,0,0-1.912-2.141l-.215-.157-.473-.012c.087.766.194,1.531.25,2.3-.29-.67-.491-1.372-.744-2.054l-.245.021a4.845,4.845,0,0,0-.688,1.157C3209.777,1527.7,3209.162,1528.52,3209.35,1529.45Z" transform="translate(-2810.123 -1335.678)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3940.1,1525.212c.08.435.632.458.95.674a8.966,8.966,0,0,1,2.395,1.962v-2.08a4.054,4.054,0,0,0-1.615-.573,12.339,12.339,0,0,0-1.73.017Z" transform="translate(-3450.008 -1335.496)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3083.726,1648.768a.958.958,0,0,0-.024-1.046c-.261-.452-.584-.863-.862-1.3l-.244.055c-.435.116-.885.154-1.321.251a3.527,3.527,0,0,0-.628.483,8.684,8.684,0,0,0,.15,2.131c.076.3.153.7.522.764a6.192,6.192,0,0,0,.373-.965c.043.153.092.31.144.468a4.108,4.108,0,0,0-.173.573l.412.109c-.1.113-.194.225-.281.343l.156.1c.383.041.771.053,1.16.07,0,.056.005.169.006.225-.229,0-.455,0-.674.007-.185.019-.364.045-.539.08.118.433.562.612.851.916.194.026.386.036.592.052.049.109.1.221.154.337a1.552,1.552,0,0,0,1.083.081,5,5,0,0,0,1.1-1.317c.191-.264-.037-.552-.157-.787a6.284,6.284,0,0,0-.846-1.217,5.4,5.4,0,0,0-2.24.769A7.017,7.017,0,0,0,3083.726,1648.768Z" transform="translate(-2697.448 -1441.663)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3055.656,1652.478c-.563.024-1.1.209-1.659.274-.09.56-.287,1.1-.378,1.656-.01.539.5.871.957,1.021a5.479,5.479,0,0,0,2.044.435c.029-.55-.594-.8-.729-1.3.368.276.721.575,1.1.848a1.681,1.681,0,0,0,.052-.893c-.167-.55-.332-1.1-.531-1.639A1.133,1.133,0,0,0,3055.656,1652.478Z" transform="translate(-2673.793 -1446.965)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3538.01,1661.079a10.991,10.991,0,0,1-1.794-.735,1.965,1.965,0,0,0-1.266-.156,2.6,2.6,0,0,0-.991,1.032,5.8,5.8,0,0,0-.738,1.55l-.094-.384a5.53,5.53,0,0,0,.272-2.286,1.6,1.6,0,0,0-.983-.955c-.56-.238-1.149-.388-1.715-.6l-.455-.127a13.249,13.249,0,0,1-1.259,1.429,1.4,1.4,0,0,0-.182,2.085,13.332,13.332,0,0,0,2.115,2.132,1.4,1.4,0,0,0,.79.255c0-.648-.215-1.271-.2-1.918a7.829,7.829,0,0,1,.7,1.512q.136-.007.295-.007c.022-.047.068-.143.091-.192l.175-.091c.031.205.066.411.112.62.009.05.026.148.035.2.244-.108.488-.219.736-.328l-.131-.029c.5-.193.912-.546,1.424-.71-.311.3-.627.6-.938.894-.223.213-.51.4-.539.738.256.065.516.129.787.18.778-.045,1.551-.157,2.327-.241a1.535,1.535,0,0,0,1.414-1.35C3538.057,1662.759,3537.993,1661.918,3538.01,1661.079Z" transform="translate(-3089.538 -1452.17)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3082.037,1678.75c0-.43-.473-.333-.754-.3a1.57,1.57,0,0,0-.022.684l.313.183C3081.834,1679.243,3082.138,1679.077,3082.037,1678.75Z" transform="translate(-2697.972 -1469.679)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3051.458,1683.317a6.473,6.473,0,0,1,1.436.749,1.107,1.107,0,0,0,.881-.235c.54-.714,1.308-1.421,1.313-2.38-.488.154-.944.384-1.429.54a6.273,6.273,0,0,1,1.043-.753c0-.06.011-.18.015-.241a7.387,7.387,0,0,0-1.709-.216,1.4,1.4,0,0,0-1.264.463A5.652,5.652,0,0,0,3051.458,1683.317Z" transform="translate(-2671.896 -1471.746)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3076.4,1689.635a4.674,4.674,0,0,0,2.029,1.057c.334-.488.9-.751,1.22-1.246a.966.966,0,0,0-.146-1.065c-.48-.638-.938-1.416-1.733-1.682-.014.438.007.877,0,1.317-.169-.352-.271-.729-.407-1.088-.238-.061-.332.264-.444.418A5.052,5.052,0,0,0,3076.4,1689.635Z" transform="translate(-2693.733 -1476.932)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3506.526,1692.417c.234-.166.453-.351.67-.539,0-.065.011-.192.015-.255-.66-.2-1.338-.333-1.989-.556a14.742,14.742,0,0,1,1.978-.055,2.317,2.317,0,0,1-.015-.317,11.724,11.724,0,0,0-2.35-2.023,1.48,1.48,0,0,0-.816-.3,2.208,2.208,0,0,0-1.616.939c-.347.391-.745.736-1.067,1.148-.046.286.178.522.272.782a7.265,7.265,0,0,0,.9,1.831,2.07,2.07,0,0,0,1.764.183A10.885,10.885,0,0,0,3506.526,1692.417Z" transform="translate(-3065.816 -1478.395)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3554.248,1709.434c.132-.1.272-.2.417-.3.018-.244.019-.488.016-.726-.313-.368-1.11-.418-1.24.138a2.51,2.51,0,0,0-.021.514A.854.854,0,0,0,3554.248,1709.434Z" transform="translate(-3111.423 -1495.699)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3775.365,1711.754a3.826,3.826,0,0,0-.139-.938c-.1-.127-.189-.25-.277-.371-.26-.014-.514-.027-.764-.031-.715-.078-.837.786-.744,1.307-.189-.039-.151-.256-.156-.393-.024-.3-.068-.6-.1-.889a3.241,3.241,0,0,0-1.384-.123c-.157.392-.474.761-.409,1.208a3.6,3.6,0,0,0,.437.546,2.816,2.816,0,0,0-.876.041c-.249.371-.582.852-.358,1.307.093.1.213.21.317.32a1.165,1.165,0,0,0,1.211.032l.071-.063c.229-.218.516-.411.6-.736l-.492-.026c.093-.061.19-.121.293-.179.248-.173.24-.51.313-.775.03.07.087.209.116.279.178-.037.367-.07.555-.1a3.1,3.1,0,0,1,.27-.309l.068,0c-.065.208-.141.41-.19.626a4.271,4.271,0,0,0,1.645-.725Z" transform="translate(-3301.518 -1497.596)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3528.772,1720.511a13.221,13.221,0,0,0-.771,1.257c-.124.225-.264.442-.4.662l-.1-.046a13.016,13.016,0,0,1,.445-1.29,2.536,2.536,0,0,0,.166-.795,5.411,5.411,0,0,0-.845.194,15.651,15.651,0,0,0-2.4,1.775,1.6,1.6,0,0,0-.2,1.1,14.7,14.7,0,0,0,1.241,2.454c.711-.034,1.417-.151,2.133-.172a1.451,1.451,0,0,0,1.295-1,26.4,26.4,0,0,0,.016-2.648,2,2,0,0,0-.576-1.5Z" transform="translate(-3086.209 -1506.353)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3568.294,1716.464l-.118-.126c-.438-.575-1.2-.642-1.83-.862a6.194,6.194,0,0,0-2.546-.246c-.1.359.236.576.445.812a14.4,14.4,0,0,1,.969,1.087c-.667-.318-1.167-.981-1.919-1.087-.006.352,0,.705.01,1.058.251.595.454,1.208.672,1.817a1.726,1.726,0,0,0,1.011,1.161c1.009.2,1.949-.344,2.944-.4l.19-.019c.086-1.1.6-2.184.3-3.3A.706.706,0,0,0,3568.294,1716.464Z" transform="translate(-3120.071 -1501.883)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3790.219,1727.553c-.134.373.289.378.53.3C3790.865,1727.493,3790.389,1727.127,3790.219,1727.553Z" transform="translate(-3318.748 -1512.536)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M2822.6,1746.4a2.155,2.155,0,0,0-.842-1.214,8.529,8.529,0,0,0-2.953-.795c-.44-.086-.875-.19-1.317-.235-.474,1.166-1.474,2.011-1.974,3.162a1.8,1.8,0,0,0,.256,1.827,13.613,13.613,0,0,0,2.133,1.965,18.261,18.261,0,0,0,1.586,1.047,2.271,2.271,0,0,0,1.409.25c-.281-1.125-.739-2.2-1.067-3.307.459.622.827,1.306,1.249,1.954.183.264.3.6.581.785a3.593,3.593,0,0,0,.693-.994,3.017,3.017,0,0,0,.2,1.447l.276-.027c.748-.626,1.532-1.205,2.3-1.806-.364.948-1.3,1.544-1.745,2.45.154.067.318.139.481.213,1.464.184,2.809-.557,4.222-.8a2.429,2.429,0,0,0,1.652-1.556,5.527,5.527,0,0,0-.118-2.261c-.129-.685-.2-1.377-.311-2.065a10.289,10.289,0,0,1-1.694-.377,12.87,12.87,0,0,0-1.978-.48,1.9,1.9,0,0,0-1.683.932,12.08,12.08,0,0,0-.949,2.159,7.338,7.338,0,0,1-.525,1.412C2822.448,1748.859,2822.721,1747.636,2822.6,1746.4Z" transform="translate(-2465.182 -1527.245)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3155.025,1788.356a8.7,8.7,0,0,0-1.517.026c-.613.271-.42,1.052-.591,1.577-.129-.5-.035-1.073-.433-1.465a5.934,5.934,0,0,0-1.7-.112c-.152.55-.565,1.037-.45,1.641-.068-.157-.115-.322-.168-.473a2.86,2.86,0,0,0,.091.524c.243.174.5.327.751.505a4.33,4.33,0,0,0,1.491.544c-.146-.359-.318-.7-.47-1.056a5.276,5.276,0,0,1,.623.7c.115-.09.231-.177.356-.26.03.106.091.316.121.422.259-.243.5-.505.74-.766-.083.322-.342.618-.274.964a4.172,4.172,0,0,0,1.705-.9c.469-.59-.178-1.256-.28-1.868Z" transform="translate(-2758.335 -1565.926)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M2783.047,1793.135c-.541.76-1.057,1.537-1.612,2.286-.016.274.27.453.391.685.719,1,1.073,2.358,2.214,2.987,1.281.444,2.484-.445,3.621-.921a12.092,12.092,0,0,0,1.867-1.174,1.787,1.787,0,0,0,.782-1.169,8.546,8.546,0,0,0-1.389-.118l-.177-.04a8.041,8.041,0,0,0-1.081-.156v-.178l-.31-.049a19.673,19.673,0,0,0,2.751-.287,3,3,0,0,0-.355-.776,17.23,17.23,0,0,0-3.042-1.907,3.417,3.417,0,0,0-1.714-.527A2.788,2.788,0,0,0,2783.047,1793.135Z" transform="translate(-2435.465 -1568.951)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3180.132,1807.271a3.906,3.906,0,0,0-2.346.556c.018.052.053.157.072.209l.019.016c.131.118.271.24.421.352l-.547-.036c.123.5.588.76.927,1.1a.978.978,0,0,0,.96.28,4.655,4.655,0,0,0,.975-.826c.207-.153.07-.4.026-.588a3.944,3.944,0,0,0-.506-1.062Z" transform="translate(-2782.484 -1582.49)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3170.447,1810.478c-.138.154-.055.373-.042.559a2.9,2.9,0,0,0,.6,0,2.468,2.468,0,0,0-.011-.459A.442.442,0,0,0,3170.447,1810.478Z" transform="translate(-2776.021 -1585.262)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M2858.847,1814.378a.955.955,0,1,0,.135-1.6.964.964,0,0,0-.136,1.6Z" transform="translate(-2502.93 -1587.209)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M2881.893,1820.477a6.905,6.905,0,0,0-2.908-.794,10.207,10.207,0,0,0-3.015-.034c-.253.132-.75.192-.674.577.822.755,1.759,1.383,2.56,2.167-.846-.434-1.709-.832-2.553-1.267l-.458-.243c-.027.052-.081.158-.107.211a2.6,2.6,0,0,0,.218,1.408c.095.249.2.5.321.74.311.573.638,1.141.923,1.731a3.519,3.519,0,0,0,1.111,1.4,2.4,2.4,0,0,0,1.9.184c1.1-.313,2.106-.891,3.21-1.2a14.29,14.29,0,0,1,.068-2.4A2.981,2.981,0,0,0,2881.893,1820.477Z" transform="translate(-2517.146 -1593.258)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M2824.74,1834.073a12.448,12.448,0,0,0-1.306,1.333,2.392,2.392,0,0,0,.121,2.739c.48.708,1.055,1.346,1.56,2.039.139.163.224.4.427.507.616-.126,1.2-.383,1.837-.455a2.9,2.9,0,0,0,.717.09c-.09-.082-.178-.161-.255-.235a4.554,4.554,0,0,0,1.532-.493,2.048,2.048,0,0,0,.833-1.856,18.085,18.085,0,0,0-.346-2.612,9.976,9.976,0,0,0-.588-2c-.169-.347-.423-.794-.879-.669-.348.963-.776,1.9-1.188,2.836-.02-1.056.357-2.067.415-3.116C2826.39,1832.275,2825.551,1833.261,2824.74,1834.073Z" transform="translate(-2471.909 -1604.317)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3530.413,1894.927c-.07-.495-.178-.981-.251-1.471a8.2,8.2,0,0,1,.557,1.184l.2-.016.184-.019.084.318c.5-.036.857-.458,1.331-.592-.287.322-.633.583-.928.9-.034.158.115.264.269.27a8.4,8.4,0,0,0,1.689-.129,1.088,1.088,0,0,0,1.013-.8c.089-.6.006-1.209.037-1.811-.684-.039-1.215-.642-1.922-.522-.471-.006-.662.511-.878.841-.167.246-.16.8-.573.688.072-.269.169-.527.248-.794.055-.406.153-.919-.218-1.2a4.662,4.662,0,0,0-1.619-.649c-.33-.1-.492.271-.693.453-.271.344-.728.638-.711,1.126a1.107,1.107,0,0,0,.183.634C3529.006,1893.921,3529.491,1894.837,3530.413,1894.927Z" transform="translate(-3089.367 -1655.904)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M2843.117,1903.41a18.529,18.529,0,0,1,2.292-1.3c-.16-.065-.311-.122-.468-.169a4.252,4.252,0,0,0-3.281.749,11.07,11.07,0,0,0-2.205,2.909,4.88,4.88,0,0,1-1.228,1.417l-.108.141c.29.213.652,0,.981.02a10.542,10.542,0,0,0,3.015-.3,5.039,5.039,0,0,0,2.968-2.389,6.074,6.074,0,0,1,1.006-1.484c-.03-.044-.091-.129-.122-.172a3.664,3.664,0,0,0-2.333.6c-.776.423-1.389,1.072-2.128,1.547A13.382,13.382,0,0,1,2843.117,1903.41Z" transform="translate(-2485.099 -1665.345)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3514.016,1912.851c.006-.05.02-.149.026-.2a10.236,10.236,0,0,1-1.329-.371c.452-.035.906-.032,1.363-.04a1.855,1.855,0,0,0-.608-.8c-.458-.3-.869-.667-1.345-.933a1.056,1.056,0,0,0-.785.167,5.171,5.171,0,0,0-1.2,1.265,4.491,4.491,0,0,0,.977,1.907A5.057,5.057,0,0,0,3514.016,1912.851Z" transform="translate(-3073.529 -1672.895)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3946.518,1922.384a7.729,7.729,0,0,0,1.931,4.544l.313-.137c0-1.733-.25-3.518.3-5.2v-5.974c-.628,1.131-1.293,2.243-1.827,3.422a7.329,7.329,0,0,0-.714,3.342Z" transform="translate(-3455.617 -1677.378)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3545.41,1924.225a1.076,1.076,0,0,0-.157-.7,2.13,2.13,0,0,0-.465.012.462.462,0,0,0-.055.777C3544.94,1924.506,3545.191,1924.289,3545.41,1924.225Z" transform="translate(-3103.655 -1684.293)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3554.173,1928.827a5.655,5.655,0,0,0-2.681-.524c.088.539.676.766.871,1.263-.385-.289-.784-.552-1.189-.8a4.146,4.146,0,0,0,.508,2.212.926.926,0,0,0,.807.592,14.4,14.4,0,0,0,1.794-.293,6.173,6.173,0,0,0,.266-2.1c-.129-.119-.251-.239-.375-.349Z" transform="translate(-3109.432 -1688.473)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3528.338,1931.447c-.34.214-.473.618-.739.9a7.314,7.314,0,0,0,.135-1.11,6.642,6.642,0,0,0-1.938,1.218,1.1,1.1,0,0,0-.274,1.153c.291.432.525.9.772,1.36l.184.057c.708-.218,1.61.02,2.118-.654A6.344,6.344,0,0,0,3528.338,1931.447Z" transform="translate(-3086.956 -1691.055)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3674.327,1953.086c.529,0,1.221.184,1.613-.281a4.432,4.432,0,0,0,.33-1.5,5.76,5.76,0,0,0-1.19-.705c-.653-.133-.9.608-1.3.963-.026-.058-.077-.177-.1-.236.1-.172.221-.33.33-.5,0-.271.08-.585-.114-.806a5.166,5.166,0,0,0-1.3-.806,5.319,5.319,0,0,0-1.118,1.011c-.166.221,0,.483.078.709.133.218.266.437.394.666h-.224c-.215-.315-.459-.688-.875-.716-.566.062-.934.562-1.432.784l-.014.007c.147.553.122,1.23.577,1.648a3.927,3.927,0,0,0,2.258-.306,1.925,1.925,0,0,0-.451-.545l.524.025c-.006-.076-.018-.226-.024-.3l.507.093c.005-.266.015-.53.045-.79a4.275,4.275,0,0,1,.272.586l.287.133.138.294c.262-.124.532-.239.807-.347l.156.093a4.324,4.324,0,0,0-.755.464C3673.68,1953.026,3674.118,1953.032,3674.327,1953.086Z" transform="translate(-3212.98 -1706.799)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3695.343,1975.87c-.007.2.211.244.338.361a.531.531,0,0,0,.3-.625l-.332-.167C3695.506,1975.543,3695.291,1975.651,3695.343,1975.87Z" transform="translate(-3235.689 -1729.757)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3902.4,1998.381c0,.131.009.265.02.4.468.351.932.711,1.428,1.027a11.175,11.175,0,0,0,1.872.836,1.324,1.324,0,0,0,1.51-.56,22.047,22.047,0,0,1,1.2-1.933c-.28-.407-.592-.787-.856-1.2a4.139,4.139,0,0,0-1.062-1.16,1.687,1.687,0,0,0-1.636.18,11.818,11.818,0,0,0-2.057,1.244,3.672,3.672,0,0,0-.293.316,2.211,2.211,0,0,0,0,.328c.141,0,.289.007.443.019.531.118,1.146-.005,1.629.282-.586.09-1.179.091-1.761.177C3902.685,1998.353,3902.54,1998.366,3902.4,1998.381Z" transform="translate(-3416.997 -1747.454)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M2409.117,2009.772l.25-.091c.21-.654.556-1.25.807-1.888-.019.787-.321,1.529-.4,2.31.917.044,1.506-.786,2.115-1.345a4.541,4.541,0,0,0,1.248-1.719,1.611,1.611,0,0,0-.54-1.382,9,9,0,0,1-1.241-1.458c-.647.226-1.307.406-1.95.633a1.976,1.976,0,0,0-1.2.949,3.841,3.841,0,0,0-.006,1.391c.276.876.223,1.9.917,2.6Z" transform="translate(-2108.603 -1754.94)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3889.345,2009.56a.682.682,0,0,0-1.05.689c-.006.374.407.471.693.568a3.063,3.063,0,0,0,.571-.362C3889.523,2010.157,3889.665,2009.732,3889.345,2009.56Z" transform="translate(-3404.627 -1759.529)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M2372.012,2021.916c.448.088.9.172,1.345.29a2.836,2.836,0,0,0,1.511.119l.366-.093c-.326-.665-1-1.08-1.353-1.736.653.416,1.228.948,1.912,1.319.262-1.248-.386-2.428-.863-3.535-.214-.428-.518-.912-1.026-.99-1.027-.122-1.933.5-2.919.664,0,.806-.214,1.594-.234,2.4a1.9,1.9,0,0,0,.358,1.044A2.058,2.058,0,0,0,2372.012,2021.916Z" transform="translate(-2075.864 -1766.387)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3884.458,2028.105a2.236,2.236,0,0,0,1.385.678,7.679,7.679,0,0,1,1.51.425c.4-.491.784-1,1.2-1.486a2.181,2.181,0,0,0,.577-1.362,2.135,2.135,0,0,0-.412-.964,6.076,6.076,0,0,1-1-.939,12.239,12.239,0,0,0-1.192-1.024c-.184,0-.363,0-.535.005.058.341.125.684.189,1.029s.109.673.187,1.011l-.168-.1c-.125-.31-.242-.617-.358-.924s-.245-.624-.36-.934c-.594-.015-.674.708-.861,1.131a9.282,9.282,0,0,0-.382,2.455,1.368,1.368,0,0,0,.219,1Z" transform="translate(-3401.095 -1771.78)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M2424.342,2042.618c.672.053,1.338.174,2.018.175,0,.048,0,.143,0,.19a20.2,20.2,0,0,0-2.142.183c.092.547.591.832,1.01,1.123a10.676,10.676,0,0,0,1.358.729,3.033,3.033,0,0,0,1.715.44c.611-.162.942-.755,1.224-1.27a9.934,9.934,0,0,1,.823-1.306c-.765-.772-1.115-1.987-2.173-2.434-.838-.255-1.541.388-2.246.724C2425.3,2041.512,2424.529,2041.855,2424.342,2042.618Z" transform="translate(-2122.683 -1786.629)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3217.661,2046.72a3.865,3.865,0,0,0,.546.54c.125.058.267.121.407.182.011-.045.031-.133.042-.178,0-.623.008-1.246-.011-1.867.012-.042.035-.127.047-.168a6.533,6.533,0,0,1,.286,1.159c.063.347.137.694.205,1.045a1.3,1.3,0,0,0,.653-.406,10.166,10.166,0,0,0,.891-1.846c.3-.78.719-1.781.051-2.5a4.74,4.74,0,0,0-1.68-.795.84.84,0,0,1,.164-.038c-.321-.133-.631-.285-.935-.443-.68.765-1.709,1.233-2.148,2.2-.322.986.525,1.726,1.009,2.473C3217.337,2046.294,3217.49,2046.512,3217.661,2046.72Z" transform="translate(-2816.07 -1787.521)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M2411.733,2055.037c-.03-.713-1.147-.777-1.338-.127-.132.372.135.66.38.9C2411.25,2055.933,2411.845,2055.577,2411.733,2055.037Z" transform="translate(-2110.547 -1798.948)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M2366.371,2062.284c.846.213,1.534.822,2.4,1a1.385,1.385,0,0,0,1.218-.308,6.892,6.892,0,0,0,.913-1.286,3.28,3.28,0,0,0,.81-2.118c-.728.248-1.424.577-2.156.813.641-.466,1.3-.91,1.952-1.362-.152-.128-.3-.249-.448-.366a9.793,9.793,0,0,0-3.3-.048,1.421,1.421,0,0,0-1.261.888,4.328,4.328,0,0,0-.147,1.54,6.05,6.05,0,0,0,.012,1.17c0,.02.008.06.01.081Z" transform="translate(-2071.989 -1802.476)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3248.921,2066.241a2.835,2.835,0,0,0-1.055.822,12.566,12.566,0,0,0-1.468,2.031,5.366,5.366,0,0,0-.088.7c.182-.037.372-.068.559-.113.184-.072.366-.156.557-.226a11.072,11.072,0,0,1,1.109-.293,5.769,5.769,0,0,1-1.1.658,4.189,4.189,0,0,0-.764.425c-.077.24.09.378.3.461a8.891,8.891,0,0,0,3.281.411,1.374,1.374,0,0,0,1.358-.924,22.646,22.646,0,0,0,.371-2.508c-.267-.172-.542-.327-.812-.483A3.135,3.135,0,0,0,3248.921,2066.241Z" transform="translate(-2842.517 -1809.257)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M2406.334,2072.737a1.8,1.8,0,0,0,1.152.82c.669.133,1.322.333,1.977.531.108-.159.215-.32.336-.469.492-.679,1.241-1.256,1.381-2.126.117-.731-.45-1.289-.937-1.74-.646-.572-1.212-1.5-2.183-1.455a21.651,21.651,0,0,1,.345,2.188c-.255-.663-.546-1.31-.8-1.97-.046-.173-.275-.108-.369-.03a3.174,3.174,0,0,0-.622,1.387,8.374,8.374,0,0,0-.277,2.865Z" transform="translate(-2106.989 -1811.063)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3901.119,2075.362a27.328,27.328,0,0,0-4.235.648c-.5.066-1.01-.05-1.5.048-.228.193.128.382.255.513.867.66,1.551,1.531,2.45,2.154a5.658,5.658,0,0,0,3.656,1.035c.861.057,1.632-.439,2.485-.427v-1.1a6.5,6.5,0,0,0-1.458-.625,26.458,26.458,0,0,0-3.028-.458,7.428,7.428,0,0,1,3.523.189c.318.107.642.215.963.334v-1.032A4.59,4.59,0,0,0,3901.119,2075.362Z" transform="translate(-3410.791 -1817.246)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M2844.348,2080.423c-.878-.781-2.067-1.057-3.02-1.724-.167-.086-.368-.325-.54-.131-.606.524-1.243,1.011-1.878,1.5a3.618,3.618,0,0,0-1.425,1.868,2.424,2.424,0,0,0,.372,1.643c.285.521.657.989.955,1.506a6.244,6.244,0,0,0,1.57,1.913c.181.082.369.164.563.245.208-1.034.045-2.115.318-3.14.208,1.047.334,2.11.552,3.157.752-.01,1.108-.774,1.467-1.319a17.437,17.437,0,0,0,1.475-3.418,2.158,2.158,0,0,0-.409-2.1Z" transform="translate(-2484.514 -1819.993)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3023.893,2092.658c-.067-.111-.131-.216-.19-.318-.371.012-.738.021-1.1.024a1.42,1.42,0,0,0-.352,1.143c-.13-.361-.122-.867-.521-1.044a3.089,3.089,0,0,0-1.136-.08,3.534,3.534,0,0,0-.2.4c-.142.317-.382.79-.046,1.066a3.086,3.086,0,0,0,1.521.664c-.113-.246-.22-.483-.326-.725.125.113.248.228.379.347l.353-.02c.027.07.081.21.107.28.1-.146.22-.282.331-.424.02.455.09.908.119,1.367a7.1,7.1,0,0,0,.649.616c.471.4,1.039.028,1.354-.377.076-.085.156-.168.239-.248a5.719,5.719,0,0,0-.585-1.2,6.01,6.01,0,0,0-1.233.221c.223-.153.454-.293.683-.443C3024.364,2093.583,3024.112,2093.028,3023.893,2092.658Z" transform="translate(-2644.505 -1832.116)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3235.607,2095.218c-.02-.251.052-.55-.179-.718-.286-.357-.827-.192-1.1.1,0,.22,0,.445.013.673l.318.3A.9.9,0,0,0,3235.607,2095.218Z" transform="translate(-2832.026 -1833.83)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3244.38,2105.183c-.916-.246-1.745-.862-2.721-.824l-.332.031c.207.664.745,1.153.985,1.8-.537-.372-.91-.923-1.417-1.323l-.208-.026c-.035.06-.1.177-.139.235a11.172,11.172,0,0,0,.522,3.612,2.218,2.218,0,0,0,.642.738,2.655,2.655,0,0,0,1.5.123l.094-.034a5.022,5.022,0,0,1,1.511-.2,21,21,0,0,0,.647-2.782A1.7,1.7,0,0,0,3244.38,2105.183Z" transform="translate(-2837.441 -1842.639)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M2611.124,2107.093a2.992,2.992,0,0,0,.823-1.162,1.077,1.077,0,0,0-.381-.927,10.131,10.131,0,0,1-.792-.924c-.165.041-.327.087-.485.135a3.138,3.138,0,0,0-1.53.731,1.12,1.12,0,0,0-.072,1.08,7.771,7.771,0,0,0,.425,1.485c.031.051.1.152.127.2l.156.061c.162-.412.337-.819.537-1.213.015.5-.154.984-.148,1.488A3.5,3.5,0,0,0,2611.124,2107.093Z" transform="translate(-2284.115 -1842.396)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M2890.917,2113.99c.327-1.261.073-2.581.354-3.85-1.214-.408-2.241-1.234-3.475-1.584a2.861,2.861,0,0,0-1.215-.055,3.987,3.987,0,0,0-1.756,1.775c-.433.719-.961,1.381-1.329,2.139a2.664,2.664,0,0,0-.218,1.438c.6-.178,1.177-.411,1.758-.639a5.086,5.086,0,0,1,1.424-.505,3.441,3.441,0,0,1-.6.46c-.77.416-1.459.957-2.2,1.413,0,.065,0,.194,0,.26a2.272,2.272,0,0,0,.968.48,11.572,11.572,0,0,0,2.455.142,9.161,9.161,0,0,0,2.6-.247A1.83,1.83,0,0,0,2890.917,2113.99Z" transform="translate(-2524.627 -1846.234)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3015.4,2110.032a2.374,2.374,0,0,1,.275.174c.275.179.527.526.907.4.4-.188.646-.6,1.056-.787a2.177,2.177,0,0,0-.512,1.229c.129.138.266.282.4.429a5.918,5.918,0,0,1,.677.4,6.755,6.755,0,0,0,.936-.709,2.642,2.642,0,0,0,0-.532c-.261-.427-.432-1.031-.95-1.192-.027.276-.048.559-.071.841-.043-.211-.09-.425-.123-.631-.118-.107-.23-.21-.34-.311-.2,0-.405.006-.6.009.168-.081.332-.163.508-.239-.018-.055-.054-.164-.072-.219a8.831,8.831,0,0,0-1.4-.266C3015.552,2108.865,3015.491,2109.527,3015.4,2110.032Z" transform="translate(-2640.328 -1846.38)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3191.354,2073.372a4.973,4.973,0,0,1-1.087.967,4.436,4.436,0,0,1,.792-1.412l-.084-.162a2.674,2.674,0,0,0-.781-.162,1.127,1.127,0,0,0,.541-.427c-.228-.138-.454-.272-.683-.393a4.351,4.351,0,0,0-.651-.233l.338-.182a3.372,3.372,0,0,0,1.3.256c-.046-.183-.092-.361-.135-.535a10.315,10.315,0,0,0-1.673-2.029c-.408-.4-.875-.887-1.5-.832a1.833,1.833,0,0,0-1.306.65,11.035,11.035,0,0,1-1.289,1.031,22.933,22.933,0,0,0,.738,2.378,1.92,1.92,0,0,0,.7.8l.147.105a11.491,11.491,0,0,0,2.361-.2c-.353.272-.792.4-1.146.664-.414.268-.922.471-1.131.953a1.58,1.58,0,0,0,.081,1.4,16.558,16.558,0,0,1,.641,1.714c1.164-.046,2.515.488,3.515-.352.055-.112.111-.221.172-.328a8.445,8.445,0,0,0,.326-1.565,4.1,4.1,0,0,0,.135-1.883C3191.654,2073.427,3191.525,2073.292,3191.354,2073.372Z" transform="translate(-2788.955 -1811.002)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3034.1,2110.064a.384.384,0,0,0,.694.018C3034.646,2109.721,3034.24,2109.67,3034.1,2110.064Z" transform="translate(-2656.702 -1847.395)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M2793.228,2117.492c-1,.7-1.714,1.725-2.738,2.4.442,1.031.7,2.131,1.141,3.162a2.318,2.318,0,0,0,1.529,1.444,4.458,4.458,0,0,0,2.154-.225c.524-.149,1.066-.223,1.6-.36a3.672,3.672,0,0,0,1.8-.955c0-.055.008-.165.01-.22-.657-.259-1.287-.575-1.948-.819a3.892,3.892,0,0,1-1.008-.459,4.546,4.546,0,0,1,1.524.223,13.457,13.457,0,0,0,1.934.292c-.076-1.147-1.02-1.938-1.738-2.731a11.349,11.349,0,0,0-2.59-1.994A2.159,2.159,0,0,0,2793.228,2117.492Z" transform="translate(-2443.394 -1853.878)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M2622.907,2130.839c.491-.458.664-1.139,1.137-1.609-.5-.638-.837-1.494-1.659-1.78a4.955,4.955,0,0,0-1.1.467,3.34,3.34,0,0,0-1.267.982l.084.047.113.062c.191.058.392.121.592.187l-.449.135-.352,0a.915.915,0,0,0,.208.473,8.5,8.5,0,0,0,1.478.882,2.585,2.585,0,0,0,1.211.156Z" transform="translate(-2294.119 -1862.859)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M2610.6,2137.4c-.409.353.264,1.045.631.621C2611.684,2137.64,2610.978,2136.926,2610.6,2137.4Z" transform="translate(-2285.769 -1871.434)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M2582.733,2119.012c.547-.251.77-.857,1.093-1.323a2.178,2.178,0,0,0,.373-1.108c-.459.126-.883.347-1.337.48a8.6,8.6,0,0,1,1.154-.833c-.006-.041-.019-.124-.024-.167-.143-.045-.282-.086-.418-.121.143-.087.277-.18.429-.259-.1-.114-.189-.224-.284-.326a2.227,2.227,0,0,1-.633-.832c.279.248.576.478.863.723l.44.063a5.782,5.782,0,0,0-.423-1.69,1.212,1.212,0,0,0-1.958-.985c-.313.056-.626.113-.929.2,0,.8-.33,1.631.046,2.4a5.3,5.3,0,0,0,.617.311,4.307,4.307,0,0,1,.932.249c-.412.045-.822.063-1.23.1a1.255,1.255,0,0,0-.5.225c-.547.576-.166,1.447-.4,2.143.7.311,1.371.907,2.183.756Z" transform="translate(-2259.568 -1849.689)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M2609.652,2150.062a7.647,7.647,0,0,0,1.133-1.562c.2-.643-.327-1.111-.756-1.486a2.334,2.334,0,0,0-1.266-.863,9.738,9.738,0,0,1,.16,1.369c-.2-.414-.351-.847-.512-1.271-.121.058-.284.078-.331.221a5.4,5.4,0,0,0-.438,1.414,2.356,2.356,0,0,0,.08,1.511A9.731,9.731,0,0,0,2609.652,2150.062Z" transform="translate(-2283.215 -1879.233)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M2865.6,2154.35a1.063,1.063,0,0,0-1.2-.935c-.29.16-.637.321-.713.679a1,1,0,0,0,.973,1.3A1.035,1.035,0,0,0,2865.6,2154.35Z" transform="translate(-2507.437 -1885.586)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3450.534,2163.208a1.02,1.02,0,0,0,.909-.93,1.273,1.273,0,0,0-.519-.947q-.457-.022-.9,0a2.411,2.411,0,0,0-.392.412A.97.97,0,0,0,3450.534,2163.208Z" transform="translate(-3020.409 -1892.516)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M2877.5,2174.57a4.531,4.531,0,0,0,2.036-.127,17.1,17.1,0,0,1,2.494-.592,12.1,12.1,0,0,1,.263-1.717,5.6,5.6,0,0,0,.07-2.932,2.808,2.808,0,0,0-1.987-1.363c-1.285-.286-2.535-.944-3.887-.688l-.3.147c.006.047.02.142.026.19.448.48.779,1.06,1.255,1.519l-.106-.009a.941.941,0,0,1,.134.539c-.618-.616-1.348-1.1-2-1.682l-.284.241a9.417,9.417,0,0,0,.769,4.255A4.1,4.1,0,0,0,2877.5,2174.57Z" transform="translate(-2517.539 -1897.571)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M2822.554,2170.748a1.229,1.229,0,0,0-.485-.563c-.563.821-1.133,1.644-1.774,2.406a30.538,30.538,0,0,1,1.166-2.95,1.211,1.211,0,0,0-.709-.112,7.96,7.96,0,0,0-2.418,1.129c-.134.116-.26.24-.384.365-.007-.047-.021-.142-.029-.19a2.193,2.193,0,0,0-.129.254c-.173.047-.335.1-.5.157.112-.005.228-.009.348-.008a4.6,4.6,0,0,0-2.039,2.035,3.126,3.126,0,0,0,.4,1.674,23.383,23.383,0,0,1,1.489,2.657,7.609,7.609,0,0,1,1.117-.148c1.3-.183,2.909-.027,3.832-1.163a6.783,6.783,0,0,0,.365-3.116A6.231,6.231,0,0,0,2822.554,2170.748Z" transform="translate(-2465.382 -1899.683)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3389.475,2178.376a24.31,24.31,0,0,1,2.806,1.109,2.163,2.163,0,0,0,1.756-.073,4.741,4.741,0,0,0,1.464-1.882,15.691,15.691,0,0,0,1.087-2.422,2.677,2.677,0,0,0,.136-1.751,2.565,2.565,0,0,0-1.217.556,11.564,11.564,0,0,1-1.473.811,7,7,0,0,1,1.2-1.31c.229-.27.621-.463.662-.847l-.152-.126a6.1,6.1,0,0,0-2.771-.033c-.587.088-1.178.146-1.762.231a2.179,2.179,0,0,0-1.967,2.329c-.022.953.047,1.906.03,2.861C3389.295,2178.009,3389.2,2178.344,3389.475,2178.376Z" transform="translate(-2967.672 -1902.099)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M2349.1,1948.973a9.175,9.175,0,0,0,4.2,5.116,12.041,12.041,0,0,0,9.348.975,9.635,9.635,0,0,0,5.09-3.561,8.088,8.088,0,0,0,1.531-6.452,7.555,7.555,0,0,0-3.383-4.845,6.124,6.124,0,0,0-5.5-.439,3.766,3.766,0,0,0-2.108,2.078,2.891,2.891,0,0,0,0,1.73c.021.1.045.2.073.3a2.64,2.64,0,0,0,1.56,1.284,2.165,2.165,0,0,0,2.525-1.1,2.838,2.838,0,0,0-.488-2.4c-.229-.416-.733-.55-.972-.948a6.606,6.606,0,0,1,6.737,6.678,7.545,7.545,0,0,1-7.294,7.042,10.093,10.093,0,0,1-9.877-7.519,10.529,10.529,0,0,1,1.058-7.569,13.031,13.031,0,0,1,5.434-5.294,14.1,14.1,0,0,1,6.877-1.55,14.6,14.6,0,0,1,5.009.841,22,22,0,0,1,5.794,3.184,8.044,8.044,0,0,0,1.03.721.747.747,0,0,0-.092.156,4.431,4.431,0,0,1,1.373.973,60.4,60.4,0,0,1,13.8,17.078c.48.883.974,1.76,1.376,2.684-.509-.772-1.028-1.536-1.566-2.286a20.816,20.816,0,0,0-1.367-1.664,29.2,29.2,0,0,0-5.449-4.831,11.23,11.23,0,0,0-2.071-1.239c.219-.052.437-.116.661-.169.427-.376.453-.981.733-1.449a4.687,4.687,0,0,0-1.192-1.037.844.844,0,0,0-.707.139,10.535,10.535,0,0,0-1.115.979c-.265.2.111.445.316.269l.16.244-.444.032a.745.745,0,0,1-.28.539c.063.134.142.279.213.423.009.137.029.285.046.43-.192-.3-.382-.6-.581-.893a3.614,3.614,0,0,0-.271,2.068c.1.279.3.617.646.613a10.893,10.893,0,0,0,1.259.024c.235-.6.7-1.143.553-1.825a33.039,33.039,0,0,1,5.521,4.382c.542.549,1.052,1.132,1.569,1.708a20.224,20.224,0,0,1,1.923,2.592,21.692,21.692,0,0,0-3.826-3.106,12.057,12.057,0,0,0-6.356-2.037,9.33,9.33,0,0,0-6.394,2.214,7.8,7.8,0,0,0-1.213,1.341,8.041,8.041,0,0,0-.914,7.1,7.756,7.756,0,0,0,7.906,4.919c.215-.012.43-.03.654-.046.469-.154.969-.177,1.45-.29a9.82,9.82,0,0,0,3.3-1.49h0c.1-.075.2-.147.306-.218a8.6,8.6,0,0,0,1-.9l.256-.253a5.647,5.647,0,0,0,1.279-2.215,4.117,4.117,0,0,1-1.2,2.547,2.286,2.286,0,0,0-.07.294,2.8,2.8,0,0,0,2.138-2.025c.193-.765.156-1.564.289-2.339,0-.3.256-.609.116-.9a12.309,12.309,0,0,1-1.32.816,3.747,3.747,0,0,0-1.671,1.988,4.66,4.66,0,0,0-.144,1.475l-.152-.092c0,.233-.006.467,0,.705l-.011.021q-.215.182-.425.364c-.311.163-.606.351-.9.542a1.861,1.861,0,0,1-1.029.4,3.672,3.672,0,0,0,.835-.887.664.664,0,0,0,.02.153c.154-.471.484-.857.653-1.322a5.107,5.107,0,0,0-.523-5,4.821,4.821,0,0,0-1.937-1.522,5.3,5.3,0,0,0-2.125-.235,4.11,4.11,0,0,0-1.316.772,2.574,2.574,0,0,0-.868,2.657,2.062,2.062,0,0,0,2.778,1.214,1.891,1.891,0,0,0,.5-2.831l-.2-.213c-.294-.012-.7.024-.811.343-.1.432.539.424.653.781a.849.849,0,0,1-.5,1.137,1.058,1.058,0,0,1-1.5-.96,1.985,1.985,0,0,1,1.014-1.541,2.037,2.037,0,0,1,2.1.333,3.979,3.979,0,0,1,1.234,1.637,4.539,4.539,0,0,1-2.769,5.551,5.324,5.324,0,0,1-2.015.22,5.749,5.749,0,0,1-3.128-.973,6.613,6.613,0,0,1-2.464-6.89,5.218,5.218,0,0,1,.354-.981,7.618,7.618,0,0,1,4.56-3.717,10.1,10.1,0,0,1,8.075.891,17.37,17.37,0,0,1,4.117,3.291c.828.826,1.478,1.8,2.23,2.7.067,1.24-.076,2.488.07,3.728a45.169,45.169,0,0,0,.985,5.708,9.221,9.221,0,0,1,.336,1.74,7.745,7.745,0,0,1-2.817,1.009,4.127,4.127,0,0,1-3.809-1.427,2.492,2.492,0,0,1,.491-3.53,1.941,1.941,0,0,1,1.207-.24,3.729,3.729,0,0,0-.439,1.448,1.631,1.631,0,0,0,.73,1.289,1.344,1.344,0,0,0,1.342-.266,1.633,1.633,0,0,0,.135-2.03,2.416,2.416,0,0,0-3.423-.652,3.119,3.119,0,0,0-1.149,3.082,3.976,3.976,0,0,0,.877,1.646,4.886,4.886,0,0,0,4.035,1.328,6.594,6.594,0,0,0,2.847-1l.286.019c.316,1.59.892,3.116,1.353,4.668l.035-.142a28.145,28.145,0,0,1,.953,2.876c.184.493.381.983.549,1.485a.529.529,0,0,1-.1.751c0,.093.011.277.016.371.686.437,1.4.826,2.074,1.287.377.179.735.55,1.188.481a1.139,1.139,0,0,0-.031-.97c-.42-.816-.867-1.618-1.28-2.438a9.067,9.067,0,0,1-.679-5.324,4.853,4.853,0,0,1,2.125-3.095,4.156,4.156,0,0,1,2.234-.582,5.987,5.987,0,0,1,3.456,1,4.571,4.571,0,0,1,2.223,2.913,3.491,3.491,0,0,1-1.307,3.6c-.117.061-.233.121-.346.182a2.215,2.215,0,0,1-1.417.264c-.323-.047-.743-.05-.891-.4.448.024.9.05,1.352.029a1.713,1.713,0,0,0,.932-.53,2.453,2.453,0,0,0-1.52-3.927,2.8,2.8,0,0,0-2.546,1.714,2.439,2.439,0,0,0,.761,2.743c.131.119.265.242.407.362a3.435,3.435,0,0,0,1.505.608,3.082,3.082,0,0,0,2.785-1.158c.114-.136.238-.262.359-.392a4.321,4.321,0,0,0,.189-4.311,6.886,6.886,0,0,0-5.254-3.585,7.745,7.745,0,0,0-2.184.187,7.459,7.459,0,0,0-4.5,4,17.192,17.192,0,0,1-.534-2.508,14.906,14.906,0,0,1-.121-1.967c-.025-.725.138-1.439.122-2.162a.987.987,0,0,1,.309-.58,7.842,7.842,0,0,0,1.255-1.016,3.691,3.691,0,0,0,.69-1.847c.022-.748-.037-1.5-.037-2.24-.384.253-.623.661-.992.93-.8.632-1.771,1.231-2.074,2.271a2.976,2.976,0,0,0,.051,1.888,1.472,1.472,0,0,0,.382-.734,4.413,4.413,0,0,1,1.3-1.9,7.219,7.219,0,0,0-1,1.82c-.174.485-.213,1.006-.354,1.5l-.007.035a19.164,19.164,0,0,0-.136,3.683c-.014.025-.042.075-.057.1-.248-.639-.439-1.3-.628-1.954a25.093,25.093,0,0,1-.9-4.275,18.881,18.881,0,0,1,2.525-11.421,13.611,13.611,0,0,1,4.936-4.891,11.423,11.423,0,0,1,7.356-1.414,10.389,10.389,0,0,1,5.869,2.939,9.792,9.792,0,0,1,1.923,11.347,9.227,9.227,0,0,1-4.888,4.406,8.491,8.491,0,0,1-5.825.183,9.231,9.231,0,0,0-1.454-.667,6.672,6.672,0,0,1-3.443-5.836,5.473,5.473,0,0,1,3.327-5.141,5.156,5.156,0,0,1,3.382-.225c-.093.223-.35.27-.536.381a3.341,3.341,0,0,0-1.887,2.245,3.116,3.116,0,0,0,.32,2.208,2.9,2.9,0,0,0,3.232,1.22,3.188,3.188,0,0,0,2.076-2.742,4.323,4.323,0,0,0-.74-2.664,5.452,5.452,0,0,0-2.6-1.978,6.7,6.7,0,0,0-7.5,2.152,7.321,7.321,0,0,0-.853,6.681,8.541,8.541,0,0,0,4.311,4.839c.18.09.368.179.56.262a11.271,11.271,0,0,0,8.815-.19,12.642,12.642,0,0,0,6.994-7.2c.18-.55.312-1.113.451-1.672a14.994,14.994,0,0,0-.214-4.289,17.836,17.836,0,0,0-.771-2.015,2.625,2.625,0,0,0,2.612-.625,3.289,3.289,0,0,0,.489-3.791,6.052,6.052,0,0,0-3.31-2.76,15.191,15.191,0,0,0-4.488-1.058c-1.075-.055-2.151-.044-3.224-.032a19.221,19.221,0,0,0-4.95.8c.022-.047.067-.142.089-.19a26.521,26.521,0,0,1,2.44-1.369,17.429,17.429,0,0,1,4.458-1.418,5,5,0,0,1,1.526-.116,18.819,18.819,0,0,0,2.453,1.337,5.371,5.371,0,0,0,3.871-.251,24.359,24.359,0,0,1,2.268-1.021c-.017-.107-.032-.208-.041-.306-1.229-.119-2.205-.966-3.264-1.516a10.4,10.4,0,0,0-1.676-.651,4.826,4.826,0,0,0-2.213.209,3.209,3.209,0,0,0-1.482,1.006l.208.056a8.749,8.749,0,0,1,2.99.157c.365.093.728.194,1.1.265-.154.055-.306.112-.454.169a7.22,7.22,0,0,0-3.073-.182l-.2.065c-.221.087-.437.185-.661.255a18.413,18.413,0,0,0-6.7,1.77,15.305,15.305,0,0,0-3.085,1.96c-.3.224-.536.593-.939.622a12.573,12.573,0,0,0-3.738,1.27,12.721,12.721,0,0,0-4.861,4.6,1.454,1.454,0,0,1-.341.444c-.08-.609-.123-1.223-.2-1.83l.208-.215c.047-.215.115-.424.174-.633a3.428,3.428,0,0,0-.557-2.73,26.171,26.171,0,0,1-2.234-3c-.049-.077-.09-.151-.125-.219l-.066.034a15.461,15.461,0,0,1-.54,2.031,4.862,4.862,0,0,0,.358,3.4,21.491,21.491,0,0,0,1.479,1.857c.081.1.146.287.322.245a5.841,5.841,0,0,0,.219-.609,7.629,7.629,0,0,0-.887-3.682c.209.342.432.679.617,1.041a7.84,7.84,0,0,1,.789,3.418,7.936,7.936,0,0,1-.143,2.023l-.035.154a14.156,14.156,0,0,0-1.3,3.57,2.434,2.434,0,0,1-.669-.832c-.885-1.38-1.723-2.791-2.486-4.24a30.634,30.634,0,0,1-1.71-3.87c-.273-.848-.587-1.683-.816-2.544a39.249,39.249,0,0,1-1.454-6.891,11.724,11.724,0,0,1,.052-3.832,8.933,8.933,0,0,1,2.3-4.895,7.686,7.686,0,0,1,7.175-2.036A6.548,6.548,0,0,1,2400,1931.1a4.843,4.843,0,0,1,.343,4.347,5.331,5.331,0,0,1-2.186,2.491,5.7,5.7,0,0,1-4.01.658,4.74,4.74,0,0,1-3.113-2.363,4.463,4.463,0,0,1-.412-1.523,3.131,3.131,0,0,1,1.587-2.884,4.79,4.79,0,0,0,.4,1.825,2.081,2.081,0,0,0,1.9,1.136,2.172,2.172,0,0,0,2.005-1.81,2.843,2.843,0,0,0-1.616-3.021,4.12,4.12,0,0,0-3.616.149,4.463,4.463,0,0,0-2.3,2.873,5.283,5.283,0,0,0,.246,3.2,6.217,6.217,0,0,0,4.334,3.595,7.859,7.859,0,0,0,4.806.218c.239-.073.475-.158.713-.246a7.466,7.466,0,0,0,1.32-.684,6.365,6.365,0,0,0,1.962-2.015,6.619,6.619,0,0,0,.808-2.642,9.931,9.931,0,0,0-.634-4.339,6.169,6.169,0,0,0-1.385-2.186,4.631,4.631,0,0,1,1.636,2.025l.316.147a11.362,11.362,0,0,0-.027-1.251,3.2,3.2,0,0,0-1.661-1.868,8.946,8.946,0,0,1-1.257-.787,1.71,1.71,0,0,0-.6-.405c.129.7.113,1.417.183,2.126a4.577,4.577,0,0,0,.771,1.527c.474.613,1.276.78,1.828,1.295a13.707,13.707,0,0,1,.426,1.7,6.909,6.909,0,0,1-1.652,5.219,4.6,4.6,0,0,1-2.38,1.56l.208-.136.083-.049a5.765,5.765,0,0,0,1.713-1.561,6.613,6.613,0,0,0,.835-4.786,8.767,8.767,0,0,0-1.264-2.993,8.638,8.638,0,0,0-4.751-3.433,8.515,8.515,0,0,0-6.692,1.052,9.406,9.406,0,0,0-3.96,5.434,15.118,15.118,0,0,0-.521,5.061c.119.76.2,1.528.348,2.285.178,1.149.626,2.233.841,3.373-1.095-1.139-2.156-2.31-3.217-3.479-.984-1.136-1.978-2.263-2.892-3.453a43.616,43.616,0,0,1-4.535-6.8,22.547,22.547,0,0,1-1.954-4.493l-.031.077c-.094-.448-.257-.874-.378-1.312a22.051,22.051,0,0,1-.834-4.3,5.93,5.93,0,0,1,1.055-3.893l.117-.154a7.149,7.149,0,0,1,3.871-2.885,3.577,3.577,0,0,1,1.436-.317c.611-.046,1.224.011,1.838.009-.006-.09-.019-.269-.025-.358a8.082,8.082,0,0,0-4.573.59,7.885,7.885,0,0,0-1.907,1.251,6.145,6.145,0,0,0-1.032,1.182c-.1.115-.19.233-.282.35-.006-.065-.016-.194-.021-.259.358-.694.594-1.447,1-2.117a11.022,11.022,0,0,1,2.059-2.6,8.256,8.256,0,0,1,1.8-.067,4.706,4.706,0,0,0,1.583-.545,4.812,4.812,0,0,0,1.692-1.5c.453-.657.825-1.366,1.306-2l.045-.284c-.262.085-.525.163-.785.24l-.053.076c-.795.04-1.591.051-2.379.143a4.369,4.369,0,0,0-2.712.869,4.017,4.017,0,0,0-1.336,2.153,1.618,1.618,0,0,0,.71-.378,6.909,6.909,0,0,1,3.327-1.352,18.934,18.934,0,0,0-2.367,1.073l-.255.139a16.007,16.007,0,0,0-2.732,3,19.165,19.165,0,0,0-1.053,1.87c-.015.073-.047.22-.062.294a5.418,5.418,0,0,1,.3-1.606,16.2,16.2,0,0,1,8.2-10.191,8.856,8.856,0,0,1,1.046-.517,17.83,17.83,0,0,1,3.946-1.051,13.446,13.446,0,0,1,4.118-.01c.367.037.736.075,1.111.1a17.626,17.626,0,0,1,2.417.687,15.986,15.986,0,0,1,6.029,3.831,9.933,9.933,0,0,1,2.919,7.017,8.657,8.657,0,0,1-.131,1.863,8.917,8.917,0,0,1-3.79,5.631,9.09,9.09,0,0,1-6.668,1.136,8.336,8.336,0,0,1-5.658-3.917,7.825,7.825,0,0,1-.287-7.472,5.494,5.494,0,0,1,6.621-2.463,3.847,3.847,0,0,1,2.573,2.509,2.839,2.839,0,0,1-.508,2.576,2.224,2.224,0,0,1-2.855.264c-.336-.264-.718.163-.667.5a2.767,2.767,0,0,0,1.4,1.1,3.618,3.618,0,0,0,3.406-.841,3.717,3.717,0,0,0,.56-3.875,5.1,5.1,0,0,0-2.338-2.728,6.059,6.059,0,0,0-3.2-.723,5.835,5.835,0,0,0-4.36,1.836,7.987,7.987,0,0,0-2.535,5.85,8.587,8.587,0,0,0,.759,3.149,9.479,9.479,0,0,0,4.326,4.454,11.3,11.3,0,0,0,8.639.74,9.763,9.763,0,0,0,2.111-.984,11.2,11.2,0,0,0,5.348-9.722,12.4,12.4,0,0,0-3.08-8.075,16.908,16.908,0,0,0-9.5-5.734,20.845,20.845,0,0,0-3.829-.346,21.527,21.527,0,0,0-3.642.3,17.654,17.654,0,0,0-10.562,6.555,18.364,18.364,0,0,0-3.164,6.179,21.911,21.911,0,0,0-.453,9.322,30.792,30.792,0,0,0,2.385,7.844c.562,1.261,1.2,2.485,1.871,3.694a29.986,29.986,0,0,0,1.939,3.03,23.417,23.417,0,0,1-2.213-2.549,37.657,37.657,0,0,1-6.732-13.593,2.984,2.984,0,0,1-.2-1.5c.543-1.333,1.521-2.433,2.075-3.761a8.806,8.806,0,0,0-.041-6.49c-.514-1.342-1.316-2.552-1.8-3.906-.109-.242-.155-.633-.514-.5a12.555,12.555,0,0,1-.92,2.565c-.449.832-.935,1.643-1.4,2.469a14.445,14.445,0,0,0-1.406,3.5,7.189,7.189,0,0,0,.658,4.331,6.45,6.45,0,0,0,1.2,1.725l.306-.161a19.472,19.472,0,0,1-.116-3.032,9.814,9.814,0,0,1,.462-2.536,11.949,11.949,0,0,1,.649-1.962c.041-.167.092-.325.144-.484a8.623,8.623,0,0,1-.336,1.857,18.152,18.152,0,0,0-.289,1.836,15.555,15.555,0,0,0,.1,3.09c.389,1.087.519,2.243.848,3.349a38.542,38.542,0,0,0,7.188,14.113c.383.521.888.944,1.233,1.5-.58-.427-1.142-.874-1.728-1.289a53.6,53.6,0,0,0-6.172-3.837,8.591,8.591,0,0,1-1.759-1.029,9.5,9.5,0,0,0-4.5-1.057,10,10,0,0,1,2.024-.072,8.068,8.068,0,0,1,3.006.782c.136-.01.276-.015.42-.017a5.137,5.137,0,0,0-3.276-2.479,11.64,11.64,0,0,0-3.915.447,12.852,12.852,0,0,1-2.75.3,13.059,13.059,0,0,0,1.143,1.047,8.528,8.528,0,0,0,2.87,2.152,5.86,5.86,0,0,0,4.11.151,4.126,4.126,0,0,1,1.091-.225,51.083,51.083,0,0,1,11.975,8.016l.2.19c1.107.974,2.156,2.011,3.168,3.083.168.177.33.366.5.552a15.577,15.577,0,0,0-1.256-1.107q-1.327-1.215-2.753-2.31c-4.3-3.3-9.547-5.637-15.038-5.689a15.64,15.64,0,0,0-5.249.949,14.094,14.094,0,0,0-4.79,3.052,14.479,14.479,0,0,0-4.316,8.45c-.041.267-.09.535-.118.807a9.755,9.755,0,0,0,.369,3.529C2348.995,1948.559,2349.046,1948.763,2349.1,1948.973Zm48.356,27.277a4.437,4.437,0,0,1,.991-2.191c-.034.044-.1.129-.133.172-.109.516-.369.991-.433,1.521a9.665,9.665,0,0,0-.092,1.758,1.426,1.426,0,0,1-.333-1.26Zm11.247-30.816a10.68,10.68,0,0,1,1.756-.259,19.3,19.3,0,0,1,4.345,0,16.346,16.346,0,0,1,3.753.731,7.819,7.819,0,0,1,2.826,1.615,3.339,3.339,0,0,1,1.011,3.115,2.137,2.137,0,0,1-2.137,1.549c-.606-.062-.965-.609-1.32-1.034l.008-.138c.4.146.736.494,1.193.443a1.282,1.282,0,0,0,1.169-1.19,1.509,1.509,0,0,0-1.419-1.322,1.732,1.732,0,0,0-1.474,1.121,4.434,4.434,0,0,0-.142.661,6.6,6.6,0,0,1-.689-.639,11.553,11.553,0,0,0-2.056-1.674,16.507,16.507,0,0,0-6.856-2.439q-.7-.052-1.393-.141A8.194,8.194,0,0,1,2408.7,1945.434Zm-18.409-12.8a4.931,4.931,0,0,1-.432.832,8.291,8.291,0,0,1-.125,1c.01-.111.029-.332.037-.443l-.185-.062.158-.014a3.8,3.8,0,0,1,1.418-2.812,3.119,3.119,0,0,1,3.827-.193,5.466,5.466,0,0,0-1.613-.267A3.8,3.8,0,0,0,2390.294,1932.631Zm-4.8,5.493a5.756,5.756,0,0,1-.04,1.1c-.409-2.809-.4-5.877,1.027-8.413l-.015-.072a9.849,9.849,0,0,1,1.623-1.958,7.715,7.715,0,0,1,7.838-1.559c.091.062.2.139.308.208a10.74,10.74,0,0,0-3.708-.235,7.718,7.718,0,0,0-3.868,1.648,8.233,8.233,0,0,0-2.059,2.53,11.925,11.925,0,0,0-.826,2.427,12.7,12.7,0,0,0-.281,4.32Zm9.82-28.675a2.091,2.091,0,0,1,.387,1.9,2.637,2.637,0,0,1-1.567,2.157,2.841,2.841,0,0,1-1.347.211,5.959,5.959,0,0,0,1.45-.639,3.416,3.416,0,0,0,1.182-1.73A4.033,4.033,0,0,0,2395.312,1909.449Zm-45.593,32.74a4.258,4.258,0,0,1,.325-.864c0-.076.014-.226.019-.3l.148.005c0-.083-.006-.248-.009-.331a1.323,1.323,0,0,0,.206-.491c-.017.117-.03.238-.037.363-.159.152-.065.407-.2.573-.081.259-.143.524-.218.786a13.815,13.815,0,0,0-.27,3.771,13.552,13.552,0,0,0,.306,1.468,10.494,10.494,0,0,0,4.03,5.921,14.443,14.443,0,0,0,1.787,1.065c.3.1.595.228.888.362a1.087,1.087,0,0,1,.534.192,6.991,6.991,0,0,1-2.627-.726,8.085,8.085,0,0,1-4.483-4.352,8.482,8.482,0,0,1-.669-2.473,12.037,12.037,0,0,1,.269-4.965Z" transform="translate(-2056.435 -1661.228)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3907.588,2191.184a4.874,4.874,0,0,0-3.289,1.287,2.92,2.92,0,0,0-.765,2.988,2.371,2.371,0,0,0,2.311,1.617,1.933,1.933,0,0,0,1.859-1.313,2.752,2.752,0,0,0-1.316-2.983q-.19-.056-.362-.1c0-.055-.011-.164-.015-.22a4.877,4.877,0,0,1,1.263.121,7.106,7.106,0,0,1,4.036,2.141v-2.578a8.614,8.614,0,0,0-1.754-.8A6.813,6.813,0,0,0,3907.588,2191.184Z" transform="translate(-3417.87 -1918.663)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3006.488,2227.663c-.025.787-.017,1.576,0,2.365a4.853,4.853,0,0,0,.363.892,16.022,16.022,0,0,0,1.388-1.734c-.182.756-.674,1.4-.819,2.167a2.226,2.226,0,0,0,1.34-.312,12.472,12.472,0,0,0,1.872-1.255,1.9,1.9,0,0,0,.74-1,1.617,1.617,0,0,0-.23-1.1,16.1,16.1,0,0,1-.979-1.771,19.488,19.488,0,0,0-2.612.307A1.528,1.528,0,0,0,3006.488,2227.663Z" transform="translate(-2632.511 -1949.072)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M2970.142,2229.649a2.179,2.179,0,0,0-1.491-.121c-.5.086-1.01.057-1.509.111a17.387,17.387,0,0,0-.708,2.014,1.6,1.6,0,0,0,.28,1.666,15.253,15.253,0,0,0,2.128,1.153,2.742,2.742,0,0,0,1.53.209,21.539,21.539,0,0,0-1.167-2.06c.653.485,1.05,1.229,1.693,1.727a1.745,1.745,0,0,0,.272-.34,9.447,9.447,0,0,0-.25-2.932A2.19,2.19,0,0,0,2970.142,2229.649Z" transform="translate(-2597.359 -1952.178)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3017.079,2269.525a1.331,1.331,0,0,0,1.319-.11c.668-.533,1.119-1.286,1.8-1.8-.286-.632-.551-1.272-.822-1.908a1.789,1.789,0,0,0-1.266-1.127,5.226,5.226,0,0,0-1.78.384,3.055,3.055,0,0,0-1.948,1.06c.69.281,1.418.465,2.1.774-.782-.018-1.553-.189-2.337-.152a1.466,1.466,0,0,0,.256.639c.283.321.562.649.874.948.321.272.663.524,1,.78a6.34,6.34,0,0,0,.795.512Z" transform="translate(-2639.234 -1982.924)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M2573.645,2270.919c-.2-.259-.465-.59-.831-.485a8.745,8.745,0,0,0-1.294.628,8.634,8.634,0,0,0,.272,1.674l.334.156c.413.057.831.1,1.25.142-.413.118-.835.2-1.24.342-.127.066-.25.137-.367.213a4.969,4.969,0,0,0,.116,1.68,7.519,7.519,0,0,0,1.442.346c.66-.117.76-.861,1.008-1.363.031-.261.053-.526.08-.782a8.022,8.022,0,0,1-.955.484,6.412,6.412,0,0,0,.758-.854l-.422-.086q.12-.134.253-.257a6.558,6.558,0,0,1-.719-.627,7.352,7.352,0,0,1,.948.389,1.3,1.3,0,0,1,.423-.424,6.519,6.519,0,0,1,.255-.873c.025.373.026.749.041,1.127a3,3,0,0,0,1.081-1.137,1.2,1.2,0,0,0,.271-1.05,3.867,3.867,0,0,0-1.1-.9,2.609,2.609,0,0,0-1.531.935,4.679,4.679,0,0,0,.647,1.778,3.2,3.2,0,0,0-.057.318A2.475,2.475,0,0,0,2573.645,2270.919Z" transform="translate(-2251.661 -1987.03)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M2952.811,2268.943c-.29.766-.366,1.593-.652,2.363.525.412,1.043.833,1.575,1.241a1.787,1.787,0,0,0,1.565.449c.787-.272,1.219-1.031,1.82-1.555a2.436,2.436,0,0,0,.861-1.5l-.476,0,.077.185c-.287,0-.573-.009-.854-.006-.238.046-.474.1-.7.159l-.225-.1q.547-.222,1.1-.432c.318-.128.637-.262.957-.4-.05-.379-.424-.526-.724-.666a5.172,5.172,0,0,0-1.138-.286,8.727,8.727,0,0,0-2.452-.2A1.562,1.562,0,0,0,2952.811,2268.943Z" transform="translate(-2584.954 -1986.086)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3001.541,2271.454c-.292.343,0,.774.284,1.009l.439.018a1.517,1.517,0,0,0,.524-.549.984.984,0,0,0-.306-.7C3002.158,2271.151,3001.729,2271.113,3001.541,2271.454Z" transform="translate(-2628.086 -1988.709)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3747.293,2278.164a1.891,1.891,0,0,0,.359,1.323,3.4,3.4,0,0,0,1.852-.3c-.225-.139-.443-.269-.665-.391a1.573,1.573,0,0,0,1.185-.248l.451.265c.139.011.285.025.436.04l-.19.315a3.76,3.76,0,0,0,1.371-.006c.378-.322.318-.9.391-1.346-.361-.206-.7-.532-1.139-.468-.17.134-.348.26-.517.389-.015-.256.007-.509-.032-.755a2.191,2.191,0,0,0-1.056-.641,2.089,2.089,0,0,0-.927.818,2.6,2.6,0,0,0,.179.776c-.134-.112-.265-.224-.389-.327C3748.078,2277.508,3747.7,2277.927,3747.293,2278.164Z" transform="translate(-3281.183 -1993.229)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M2992.593,2285.387a5.37,5.37,0,0,0-.783-.836l-.432-.106a21.5,21.5,0,0,1-.1,2.193c0-.036-.014-.108-.019-.144a3.72,3.72,0,0,1-.287-1.356c-.037-.277-.1-.55-.151-.818a1.748,1.748,0,0,0-.905.859,11.177,11.177,0,0,0-1.067,2.565,1.335,1.335,0,0,0,.475,1.491c.534.374,1.167.566,1.724.906.188.087.428.318.628.116a12.066,12.066,0,0,0,1.973-1.76,1.619,1.619,0,0,0,.2-1.037,7.363,7.363,0,0,0-.4-.785C2993.155,2286.252,2992.894,2285.805,2992.593,2285.387Z" transform="translate(-2617.023 -2000.217)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M2594.928,2295.556l-.241-.006c-.113.117-.317.219-.231.418.02.312.4.221.618.207A.612.612,0,0,0,2594.928,2295.556Z" transform="translate(-2271.726 -2010.05)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3767.293,2296.728c.032-.267-.336-.454-.487-.208-.191.127,0,.327.066.47C3767.009,2296.918,3767.283,2296.948,3767.293,2296.728Z" transform="translate(-3298.198 -2010.799)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3757.249,2301.436l-.093-.058c-.169-.075-.332-.143-.491-.2-.2-.018-.4-.039-.588-.055.06.2.137.4.2.611-.116-.076-.2-.131-.293-.2l-.213-.235c-.03.04-.091.121-.121.162l-.078-.014-.256-.082-.174.255c-.021-.07-.065-.209-.086-.279l.05-.235-.359.131-.055.02a3.078,3.078,0,0,0-.942.42l-.01.01c-.315.468.056.98.194,1.443a4.544,4.544,0,0,0,1.112.123l.2-.179a4.729,4.729,0,0,0,.359-1.24l.076-.029a2.908,2.908,0,0,0,.292,1.141,7.233,7.233,0,0,1,1.371.025c.059-.178.116-.356.179-.529a.877.877,0,0,1,.1-.638,2.982,2.982,0,0,0-.371-.362Z" transform="translate(-3286.723 -2014.909)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M2160.043,2331.532a2.436,2.436,0,0,0,1.509-2.652,2.484,2.484,0,0,0-.7-1.3,2.4,2.4,0,0,0-3.785,2.862A2.433,2.433,0,0,0,2160.043,2331.532Z" transform="translate(-1888.498 -2037.493)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M2102.671,2336.047a3.372,3.372,0,0,0,2.75.521,3.413,3.413,0,0,0,2.275-2.122,3.49,3.49,0,0,0-.591-3.026,3.272,3.272,0,0,0-3.676-.975,3.231,3.231,0,0,0-.759,5.6Z" transform="translate(-1839.982 -2040.415)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3700.51,2330.762a1.707,1.707,0,0,0-.923,1.045,1.467,1.467,0,0,0,1.371,1.849,1.3,1.3,0,0,0,1.193-.4,1.639,1.639,0,0,0,.36-1.575A1.533,1.533,0,0,0,3700.51,2330.762Z" transform="translate(-3239.364 -2040.778)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M2201.83,2348.352a2.256,2.256,0,0,0,1.467-.444,2.018,2.018,0,0,0,.588-2.358,2.138,2.138,0,0,0-1.059-1.018,1.946,1.946,0,0,0-2.172.471,2,2,0,0,0-.053,2.673A2.337,2.337,0,0,0,2201.83,2348.352Z" transform="translate(-1926.454 -2052.807)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3900.859,2351.294c.221-.2.539-.093.812-.117a2.321,2.321,0,0,0,2.12-1.262,2.426,2.426,0,0,0-.244-2.505,2.337,2.337,0,0,0-3.112-.654,4.246,4.246,0,0,0-1.7,2,6.942,6.942,0,0,0-.45,3.832,6.318,6.318,0,0,0,1.019,2.508,7.242,7.242,0,0,0,2.193,1.763,4.125,4.125,0,0,1,.784.163c-.138-.061-.28-.123-.407-.177a3.261,3.261,0,0,1-2.126-2.629,3.1,3.1,0,0,1,1.11-2.922Z" transform="translate(-3413.33 -2054.606)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3611.888,2358.8a5.8,5.8,0,0,0-6.224-3.036,5.911,5.911,0,0,0-2.1.85,6.84,6.84,0,0,0-2.943,4.55,7.912,7.912,0,0,0,1.047,5.36c.258.47.594.892.885,1.344.494.555,1.034,1.069,1.572,1.582a13.109,13.109,0,0,0,8.654,2.444c.545-.051,1.092-.119,1.644-.128l.094-.254a17,17,0,0,1-4.406-.034,11.025,11.025,0,0,1-5.03-1.9c-.182-.127-.365-.245-.537-.371a9.466,9.466,0,0,1-3.065-4.217,6.606,6.606,0,0,1,.46-5.829,5.788,5.788,0,0,1,3.849-2.755,5.29,5.29,0,0,1,2.84.3,5.078,5.078,0,0,1,2.667,2.505,4.2,4.2,0,0,1-.235,3.616,3.417,3.417,0,0,1-3.028,1.784,2.915,2.915,0,0,1-2.892-2.322,2.375,2.375,0,0,1,1.656-2.631,1.828,1.828,0,0,1,2.18,1.137,1.6,1.6,0,0,1-.226,1.407,2.319,2.319,0,0,1-.725.335,1.227,1.227,0,0,0-.062-1.8,1.092,1.092,0,0,0-1.659.467,1.544,1.544,0,0,0,1.488,2.031,1.907,1.907,0,0,0,1.892-1.668,2.425,2.425,0,0,0-2.141-2.659,2.784,2.784,0,0,0-2.766,1.522,2.98,2.98,0,0,0-.332,1.852,3.148,3.148,0,0,0,1.608,2.518,3.778,3.778,0,0,0,3.585.3,4.168,4.168,0,0,0,2.561-3.934c.026.207.056.413.1.627a5.457,5.457,0,0,0-.4-3Z" transform="translate(-3152.657 -2062.674)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3713.5,2361.554a1.049,1.049,0,0,0-1.027,1.31c.046.372.388.561.658.771a1.489,1.489,0,0,0,1.141-.376c.262-.275.17-.69.178-1.031C3714.242,2361.9,3713.934,2361.49,3713.5,2361.554Z" transform="translate(-3250.658 -2067.838)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3183.565,2366.505c.036.2.224.014.267-.07.077-.135.154-.269.231-.4l.205.249a1.519,1.519,0,0,0-.234.679,5.121,5.121,0,0,0,2.214-1.144,1.338,1.338,0,0,0,.42-.894,5.438,5.438,0,0,0-.479-.928,6.13,6.13,0,0,1-.382-.685,5.6,5.6,0,0,0-1.948.3,1.277,1.277,0,0,0-.5,1.281C3183.4,2365.425,3183.213,2366.035,3183.565,2366.505Z" transform="translate(-2787.385 -2069.382)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M2221.7,2377.232a1.978,1.978,0,0,0,.483,1.119,1.536,1.536,0,0,0,2.012.119,1.746,1.746,0,0,0,.6-1.646l0-.008c-.126-.184-.245-.374-.368-.549a1.5,1.5,0,0,0-1.668-.468A1.671,1.671,0,0,0,2221.7,2377.232Z" transform="translate(-1945.354 -2080.232)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3716.253,2387.473a3.46,3.46,0,0,0-.008-.761,3.148,3.148,0,0,0-.532-.49c-.667-.141-1.373.629-.938,1.239A.877.877,0,0,0,3716.253,2387.473Z" transform="translate(-3252.593 -2089.429)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3414.018,2389.026c-.328-.241-.591-.555-.9-.806a3.583,3.583,0,0,0-1.118.478c-1.107.575-2.448.984-3.055,2.177-.347,1.409.559,2.671.911,3.982a5.582,5.582,0,0,0,.925,1.565l.16.167c.121.01.248.024.379.041.285-.991.545-1.99.853-2.975.044,1.116-.048,2.233-.022,3.35a1.68,1.68,0,0,0,.868-.315,10.2,10.2,0,0,0,1.728-1.866c.653-1.1,1.73-2.157,1.521-3.541-.436-1.02-1.434-1.579-2.248-2.255Z" transform="translate(-2984.851 -2091.193)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3191.438,2392.562c.422-.434.831-.878,1.261-1.3a6.159,6.159,0,0,0-1.057-1.965,4.4,4.4,0,0,0-2.779.852,2.209,2.209,0,0,0,.5.224,1.853,1.853,0,0,1,.807.346,2.378,2.378,0,0,1-.9-.042l-.543-.035c.19.82,1.017,1.19,1.577,1.73a1.274,1.274,0,0,0,1.131.2Z" transform="translate(-2792.098 -2092.129)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3148.469,2368.756a1.211,1.211,0,0,0-.625.879,8.335,8.335,0,0,0-.275,1.255,10.363,10.363,0,0,0,1.455,1.024c.49.248,1.008-.126,1.332-.479.373-.473,1.005-.884,1.04-1.53a12.835,12.835,0,0,1-1.4.213c.394-.227.832-.362,1.241-.557.25-.146-.17-.323-.272-.367l.382-.225c-.187-.418-.424-.809-.6-1.225.323.291.581.646.883.964a.152.152,0,0,0,.275-.1,5.518,5.518,0,0,0-.27-2.453.887.887,0,0,0-.9-.608c-.51.017-1.01.131-1.518.134a5.958,5.958,0,0,0-.489,1.991c.189.762,1.093.836,1.653,1.225l-.323.025A4.33,4.33,0,0,0,3148.469,2368.756Z" transform="translate(-2756.058 -2071.333)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M2422.718,2395.836a2.512,2.512,0,0,0,2.755-1.193,2.461,2.461,0,0,0-.388-2.912,2.384,2.384,0,0,0-2.82-.458,4.17,4.17,0,0,0-1.959,2.279,5.746,5.746,0,0,0-.291.806,7.3,7.3,0,0,0,.112,3.76c.016.055.047.165.063.221a5.522,5.522,0,0,0,2.407,2.833l.346.024-.359-.353-.132-.122a3.16,3.16,0,0,1-.874-3.27A3.221,3.221,0,0,1,2422.718,2395.836Z" transform="translate(-2118.833 -2093.637)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3180.475,2393.386a.653.653,0,0,0-.154.551c.009.228.289.229.447.338.129-.1.269-.2.411-.294a3.417,3.417,0,0,1,.01-.374A.677.677,0,0,0,3180.475,2393.386Z" transform="translate(-2784.718 -2095.703)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M2130.719,2401.116a6.135,6.135,0,0,0-4.108.545,6.712,6.712,0,0,0-3.4,5.173,9.483,9.483,0,0,0,.142,2.639c.029.133.062.266.1.4a9.732,9.732,0,0,0,2.072,3.671,11.332,11.332,0,0,0,6.742,3.468,15.2,15.2,0,0,0,3.326.128c.526-.056,1.058-.062,1.587-.11a2.967,2.967,0,0,1-.529-.2,14.829,14.829,0,0,1-4.292-.091,10.654,10.654,0,0,1-6.172-3.128,9.66,9.66,0,0,1-1.411-1.9,7.555,7.555,0,0,1-.92-2.1,6.413,6.413,0,0,1,.643-5.069,6.152,6.152,0,0,1,2.073-2.142,5.174,5.174,0,0,1,5.983.365,4.126,4.126,0,0,1,1.643,3.31,3.765,3.765,0,0,1-1.755,3.326,3.11,3.11,0,0,1-3.4.008,2.63,2.63,0,0,1-1.281-1.835,2.342,2.342,0,0,1,1.856-2.676,1.788,1.788,0,0,1,2.062,1.674,1.5,1.5,0,0,1-1.434,1.449c.283-.272.707-.511.708-.954a1.016,1.016,0,0,0-1.082-1.192,1.107,1.107,0,0,0-.97,1.449A1.616,1.616,0,0,0,2131,2408.4a2.056,2.056,0,0,0,1.154-2.713,2.568,2.568,0,0,0-2.877-1.442,3.058,3.058,0,0,0-2.014,1.719,3.277,3.277,0,0,0-.224,1.621,2.908,2.908,0,0,0,.646,1.623,3.943,3.943,0,0,0,1.741,1.287,4.723,4.723,0,0,0,1.688.16,3.593,3.593,0,0,0,2.111-.851c.124-.114.249-.229.377-.341a4.594,4.594,0,0,0,1.34-3.381,5.321,5.321,0,0,0-4.219-4.972Z" transform="translate(-1859.087 -2102.375)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3173.349,2405.857c.213.126.411-.082.582-.194a4.735,4.735,0,0,0,1.053-1,1.245,1.245,0,0,0-.224-1.223c-.408-.48-.612-1.291-1.33-1.371a.705.705,0,1,1-.423-.139,4.046,4.046,0,0,0-1.106,1.81,2.8,2.8,0,0,0-.19,1.184,4.756,4.756,0,0,0,1.637.933Z" transform="translate(-2777.194 -2103.198)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3711.779,2406.523c.218,0,.44,0,.67,0,.128-.223.337-.442.266-.719-.092-.148-.2-.285-.289-.418-.271.017-.621-.118-.81.134-.213.167-.115.452-.131.687Z" transform="translate(-3249.824 -2106.202)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M2235.582,2406.637a1.032,1.032,0,0,0-.685,1.365,1.138,1.138,0,0,0,.806.678,1.2,1.2,0,0,0,1.063-.514.828.828,0,0,1,.129-.385A1.046,1.046,0,0,0,2235.582,2406.637Z" transform="translate(-1956.835 -2107.274)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3360.281,2416.285a32.678,32.678,0,0,1-2.946,1.677,9.682,9.682,0,0,0,.144,1.742,6.224,6.224,0,0,0,.755,2.912,3.993,3.993,0,0,0,1.024.627c.912.113,1.832.02,2.749.043a4.392,4.392,0,0,0,2.411-.417c.1-.078.2-.154.31-.229l-.09-.185c-.635-.4-1.229-.854-1.854-1.264a2.015,2.015,0,0,1-.75-.628,18.453,18.453,0,0,1,1.735.709c.353.156.708.316,1.058.491a4.11,4.11,0,0,0,.5.156,1.716,1.716,0,0,0,0-1.031c-.143-.282-.285-.561-.429-.837-.081-.158-.16-.312-.239-.46a16.673,16.673,0,0,0-2.295-3.044A2.124,2.124,0,0,0,3360.281,2416.285Z" transform="translate(-2939.721 -2115.628)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3447.057,2428.2c-.519.187-1.024.408-1.542.592l-.276.106c.018.586.642.82,1.1,1.022a12.391,12.391,0,0,0,1.246.391,11.762,11.762,0,0,0,4.008.387,5.17,5.17,0,0,0,.755-.593,5,5,0,0,0,.664-1.458c.1-.333.172-.67.246-1.005a1.712,1.712,0,0,1,.254-.73,9.572,9.572,0,0,1,7.359.052,15.92,15.92,0,0,1,1.486.823,3.809,3.809,0,0,0-1.19-1.428,12.027,12.027,0,0,0-4.764-2.545,13.11,13.11,0,0,0-2.128-.407,16.642,16.642,0,0,0-2.1-.32c-.651.01-1.432-.044-1.894.5a3.8,3.8,0,0,0-1.616.218,11.122,11.122,0,0,0-2,1.775c-.679.694-1.541,1.393-1.572,2.45a10.035,10.035,0,0,0,1.6-.163,13.564,13.564,0,0,1,1.617-.281l-.093.214q-.582.192-1.153.4Z" transform="translate(-3016.572 -2121.722)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M2238.768,2432.518a.83.83,0,0,0-.844-1.141c-.292,0-.478.265-.689.427-.012.307-.124.7.146.938A.83.83,0,0,0,2238.768,2432.518Z" transform="translate(-1958.926 -2128.976)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3674.856,2436.188a38.672,38.672,0,0,0-4.662.557,32.358,32.358,0,0,0-9.936,3.638c-.594.327-1.171.679-1.745,1.035a29.847,29.847,0,0,0-2.761,1.974,24.457,24.457,0,0,0-2.508,2.21,29.332,29.332,0,0,0-3.743,4.724c-.22.377-.434.756-.674,1.122-.03.045-.088.137-.118.183-.341.662-.608,1.36-.99,2-.143.409-.313.81-.471,1.217-.159.444-.321.888-.461,1.341-.143.482-.269.971-.418,1.453-.115.572-.247,1.145-.3,1.728-.139,1.256-.264,2.515-.293,3.779a29.855,29.855,0,0,0,.451,4.126,19.077,19.077,0,0,1,.429,2.012,22.056,22.056,0,0,0,1.981,4.606,21.536,21.536,0,0,0,1.989,2.857,22.139,22.139,0,0,0,2.413,2.429,18.643,18.643,0,0,0,5,3h13.961a21.631,21.631,0,0,0,3.63-1.958,14.8,14.8,0,0,0,3.254-3.011,16.04,16.04,0,0,0,3.171-6.947,22.091,22.091,0,0,0,.22-3.39,16.56,16.56,0,0,0-.6-3.642c-.272-.617-.478-1.258-.753-1.871a13.8,13.8,0,0,0-3.833-5.141,3.649,3.649,0,0,1-.91-.628c-.366-.189-.722-.389-1.071-.593a12.519,12.519,0,0,0-7.781-1.3,10.329,10.329,0,0,0-2.121.5c-.348.143-.7.27-1.055.384a8.764,8.764,0,0,0-1.372.772,7.045,7.045,0,0,0-1.063.71,8.367,8.367,0,0,0-.686.572,13.859,13.859,0,0,0-1.219,1.342,11.284,11.284,0,0,0-.875,1.356,10.545,10.545,0,0,0-.467,8.559,9.876,9.876,0,0,0,1.772,2.938,8.646,8.646,0,0,0,3.587,2.3,8.865,8.865,0,0,0,3.712.356,9.2,9.2,0,0,0,2.725-.878,7.43,7.43,0,0,0,2.671-2.346,8.107,8.107,0,0,0,1.01-2.37,7.311,7.311,0,0,0-.488-4.182,5.866,5.866,0,0,0-3.571-3.136,5.735,5.735,0,0,0-3.2.067,7.524,7.524,0,0,0-1.28.693,5.089,5.089,0,0,0-1.224,1.335,6.219,6.219,0,0,0-.606,1.486,3.608,3.608,0,0,0,1.51,3.576c.353.152.7.326,1.071.448a4.139,4.139,0,0,0,2.535-.385,3.884,3.884,0,0,0,1.45-1.79,3.3,3.3,0,0,0-1.13-3.847c-.009-.055-.029-.164-.038-.219a4.373,4.373,0,0,1,2.4,1.768,4.89,4.89,0,0,1,.7,3.468,4.808,4.808,0,0,1-1.861,3,6.25,6.25,0,0,1-2.237,1.027,6.957,6.957,0,0,1-3.085-.078,6.016,6.016,0,0,1-3.169-2.118,7.89,7.89,0,0,1-1.448-6.315,7.452,7.452,0,0,1,1.062-2.666,6.055,6.055,0,0,1,.492-.708,8.505,8.505,0,0,1,1.941-1.739,6.185,6.185,0,0,1,.871-.495,10.321,10.321,0,0,1,10.278.589,11.039,11.039,0,0,1,3.73,4.473,12.635,12.635,0,0,1,.717,9.17,13.226,13.226,0,0,1-2.281,4.449,10.947,10.947,0,0,1-2.309,2.264,16.56,16.56,0,0,1-3.626,2.056,17.011,17.011,0,0,1-3.234.97,26.121,26.121,0,0,1-3.081.29,16.132,16.132,0,0,1-4.15-.551,10.552,10.552,0,0,1-1.346-.384,15.625,15.625,0,0,1-4.115-2.132,17.034,17.034,0,0,1-4.4-4.575,19.714,19.714,0,0,1-3.161-8.732,26.542,26.542,0,0,1-.073-3.668c0-.052.01-.157.012-.21a17.619,17.619,0,0,1,.437-3.025c.08-.406.2-.8.312-1.194.1-.376.228-.743.354-1.108a15.209,15.209,0,0,1,.892-2.231,10.353,10.353,0,0,1,.768-1.49c.112-.233.219-.468.347-.692l.073-.122a26.219,26.219,0,0,1,6.1-6.938,32.774,32.774,0,0,1,6.558-4.091,31.2,31.2,0,0,1,9.109-2.719,21.858,21.858,0,0,1,3.1-.284,46.779,46.779,0,0,1,5.6.128,38.659,38.659,0,0,1,4.476.652v-.859a41.09,41.09,0,0,0-8.078-.929c-.93-.015-1.861.016-2.789,0Z" transform="translate(-3192.289 -2133.192)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M2233.749,2449.816a.64.64,0,1,0,.922.578A.626.626,0,0,0,2233.749,2449.816Z" transform="translate(-1955.587 -2145.054)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3884.11,2456.609c-.354.223-.74.388-1.091.613a12.543,12.543,0,0,0-3.556,3.984,11.505,11.505,0,0,0-1.245,3.938,7.672,7.672,0,0,0,.247,2.967,4.517,4.517,0,0,0,2.6,2.845,4.155,4.155,0,0,0,3.244-.271,3.633,3.633,0,0,0,2.263-2.823,4.423,4.423,0,0,0-.25-2.708,4,4,0,0,0-.581-.976,5.022,5.022,0,0,0-1.407-1.107,4.953,4.953,0,0,1-.136-2.526,5.308,5.308,0,0,1,2.684-3.684,4.443,4.443,0,0,1,2.354-.72v-.61A8.538,8.538,0,0,0,3884.11,2456.609Z" transform="translate(-3395.797 -2150.106)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3424.957,2464.381a1.088,1.088,0,0,0,.67-1.184c-.015-.035-.046-.1-.062-.138-.024.248-.039.5-.06.754q-.01-.4.015-.795a.986.986,0,0,0-1.3-.432,1.055,1.055,0,0,0-.547,1.072A1.008,1.008,0,0,0,3424.957,2464.381Z" transform="translate(-2997.816 -2156.211)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M2002.931,2472.431h.124a2.458,2.458,0,0,0,2.289.024q.157-.086.317-.168a5.888,5.888,0,0,1,2.566-.933,10.351,10.351,0,0,1,4.045.225,3.662,3.662,0,0,1,1.621.709,6.433,6.433,0,0,1,1.03.453c-.05-.079-.152-.233-.2-.311a4.334,4.334,0,0,0-1.05-1.122c-.531-.458-1.133-.816-1.689-1.236-.827-.282-1.573-.759-2.416-1a19.573,19.573,0,0,0-3.6-.728,4.8,4.8,0,0,0-2.667-.023,2.446,2.446,0,0,0-1.229,1.295,5.6,5.6,0,0,0,.014,1.746,3.7,3.7,0,0,0,.721.96C2002.841,2472.35,2002.9,2472.4,2002.931,2472.431Z" transform="translate(-1752.992 -2161.177)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M2853.695,2476.232c-.3-.269-.617-.52-.934-.763-.31.177-.62.351-.921.538-.056.2-.183.42-.084.64.144.387.194.863.562,1.118.095-.234.046-.6.337-.7.009.255,0,.5.012.762.183-.158.379-.3.553-.475A1.487,1.487,0,0,0,2853.695,2476.232Z" transform="translate(-2497.007 -2167.59)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3368.524,2482.607c1.407,0,2.8.424,4.211.211a2.367,2.367,0,0,0,1.615-1.887c.169-.882.373-1.756.553-2.635a3.753,3.753,0,0,0-.2-1.978,2.8,2.8,0,0,0-.971.749c-.531.488-1.085.95-1.606,1.449.591-.975,1.261-1.9,1.938-2.819l-.084-.172a4.009,4.009,0,0,0-2.693.295,19.823,19.823,0,0,0-2.546,1.134,2.31,2.31,0,0,0-1.174,1.231,2.82,2.82,0,0,0,.134,1.878,11.69,11.69,0,0,1,.825,2.541Z" transform="translate(-2948.586 -2167.51)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3430.991,2486.834a2.757,2.757,0,0,0,1.366.22c1-.009,2-.087,3-.016.274-.878.654-1.717.988-2.572a4.32,4.32,0,0,0,.309-2.134l-.08-.172a3.036,3.036,0,0,0-1.361-1.279c-.159-.085-.317-.172-.465-.248-.3-.138-.581-.29-.861-.445a4.519,4.519,0,0,0-2.909-.869,5.333,5.333,0,0,0,.225.617c.392.8.832,1.583,1.144,2.42-.447-.471-.821-1-1.234-1.5-.29-.341-.572-.684-.836-1.04l-.211-.02a3.791,3.791,0,0,0-.495,2.345,22.11,22.11,0,0,0,.465,3.332A2.16,2.16,0,0,0,3430.991,2486.834Z" transform="translate(-3002.981 -2170.94)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M2193.917,2482.786a38.555,38.555,0,0,1,16.571,1.121,45.47,45.47,0,0,1,4.841,1.561,50.615,50.615,0,0,1,6.952,3.248l.256.112c.071-.093.21-.282.281-.376a56.848,56.848,0,0,0-9.447-4.429,46.767,46.767,0,0,0-8.264-2.15,29.244,29.244,0,0,0-4.487-.452c-1.7.143-3.412-.055-5.115.04a38.794,38.794,0,0,0-6.767,1.307c-1.052.358-2.107.715-3.128,1.156-.121.042-.234.093-.347.143a32.939,32.939,0,0,0-9.264,5.966,4.388,4.388,0,0,1-1.259,1.27,7.571,7.571,0,0,0-1.246,1.369c-.626.837-1.276,1.656-1.86,2.524-.292.45-.569.912-.852,1.37q-.463.851-.893,1.721-.573,1.3-1.045,2.643c-.108.3-.223.592-.325.893a28.052,28.052,0,0,0-.756,4.055,18.452,18.452,0,0,0-.079,3.487,21.363,21.363,0,0,0,3.4,10.589c.342.667.9,1.185,1.259,1.843h2.707a19.755,19.755,0,0,1-2.452-3.088,19.474,19.474,0,0,1-2.771-6.916,19.814,19.814,0,0,1-.332-5.678,17.307,17.307,0,0,1,.852-4.222,15.706,15.706,0,0,1,.871-2.486,12.908,12.908,0,0,1,1.38-2.724,23.643,23.643,0,0,1,2.25-3.309,25.92,25.92,0,0,1,2.208-2.35c.449-.445.95-.832,1.423-1.251a31.735,31.735,0,0,1,10.674-5.839A27.518,27.518,0,0,1,2193.917,2482.786Z" transform="translate(-1898.004 -2172.8)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M2837.809,2487.069a3.8,3.8,0,0,0,1.325.265,3.126,3.126,0,0,0,.53-.927,2.5,2.5,0,0,0,.158-.727c-.17.061-.336.127-.5.2l-.076.174c-.056-.03-.106-.053-.151-.072a1.451,1.451,0,0,0,.493-.65l-.309-.014.211-.152c-.183-.19-.353-.378-.512-.578.156.091.313.187.485.272l.245-.012a3.145,3.145,0,0,0-.638-1.223c-.066-.1-.125-.2-.179-.3-.5-.075-.893.262-1.323.445a2.611,2.611,0,0,0,.146,1.2c.251.378.769.315,1.167.391a2.463,2.463,0,0,0-1.223.471A7.669,7.669,0,0,0,2837.809,2487.069Z" transform="translate(-2484.617 -2174.459)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3491.971,2488.19a11.7,11.7,0,0,1,5.033-3.178.542.542,0,0,1,.7-.2,14.9,14.9,0,0,1,3.544-.219,2.949,2.949,0,0,0-1.52-.653,14,14,0,0,0-4.651-.474,19.07,19.07,0,0,0-5.24,1.363c-.688.328-1.479.352-2.148.721a3.489,3.489,0,0,0-1.112.811c-.118.163-.239.323-.347.494a2.953,2.953,0,0,0-.456,1.822,2.783,2.783,0,0,0,4.9,1.427A8.284,8.284,0,0,1,3491.971,2488.19Z" transform="translate(-3052.181 -2174.573)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M2862.791,2490.278l.186-.19.029-.021a6.026,6.026,0,0,1,.331-.955,4.067,4.067,0,0,0-.891-.784c-.4-.125-.714.208-.974.457-.159.179-.322.356-.471.544.229-.008.475,0,.715,0l-.07.2c-.2.037-.407.07-.6.119l-.015.147a2.564,2.564,0,0,0,1.756.485Z" transform="translate(-2505.134 -2178.824)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M2855.273,2496.51c-.159.053-.1.293-.037.413a.421.421,0,0,0,.5-.15C2855.633,2496.618,2855.493,2496.3,2855.273,2496.51Z" transform="translate(-2500.029 -2185.952)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3549.522,2497.719l-.17-.374a14.08,14.08,0,0,0-4.049.316c-.633.131-1.256.3-1.881.449a25.265,25.265,0,0,0-8.723,5.2,13.008,13.008,0,0,1-1.659,1.167,4.422,4.422,0,0,0-.6.489l-.223.214a5.7,5.7,0,0,0-1.448,3.055,5.487,5.487,0,0,0,.387,2.162,5.609,5.609,0,0,0,.736,1.036,4.081,4.081,0,0,0,4.939.555,3.99,3.99,0,0,0,1.178-1.132c.085-.132.174-.261.269-.387.084-.231.168-.46.257-.687a7.64,7.64,0,0,1,.611-2.555,13.862,13.862,0,0,1,1.2-2.45,15.965,15.965,0,0,1,2.281-2.9,18.228,18.228,0,0,1,2.05-1.766,15.83,15.83,0,0,1,3.861-2.054C3548.862,2497.938,3549.188,2497.813,3549.522,2497.719Z" transform="translate(-3091.584 -2186.726)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M2409.77,2501.8a11.109,11.109,0,0,1,3.494-.162,2.744,2.744,0,0,0-.311-.119c-.31-.109-.621-.2-.929-.3l-.146-.043a10.191,10.191,0,0,0-1.427-.088,7.891,7.891,0,0,0-4.829,1.219c.072-.082.148-.162.226-.236a13.921,13.921,0,0,0-2.407,1.794,12.465,12.465,0,0,0-2.971,4.412,22.406,22.406,0,0,0-.559,2.527,8.35,8.35,0,0,0,.133,2.423,5.115,5.115,0,0,0,.595,1.37,4.637,4.637,0,0,0,3.239,2.071,4.693,4.693,0,0,0,3.031-.993c.428-.327.705-.8,1.122-1.143.136-.469.365-.9.525-1.36-.234-.459-.043-1.016-.13-1.512a4.7,4.7,0,0,0-1.261-2.3c-.359-.419-.947-.6-1.213-1.1a5.562,5.562,0,0,1,.8-4.218A5.75,5.75,0,0,1,2409.77,2501.8Z" transform="translate(-2101.369 -2190.015)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M2855.894,2503.072c.361.021.723.06,1.086.112.116-.208.241-.408.363-.611a1,1,0,0,0,.2-.68c-.059-.309-.381-.407-.6-.559a3.819,3.819,0,0,0-.8-.454,2.455,2.455,0,0,0,.133.849,1.524,1.524,0,0,0-.566-.69,4.351,4.351,0,0,0-.162,1.494A1.3,1.3,0,0,0,2855.894,2503.072Z" transform="translate(-2500.351 -2189.84)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3131.47,2519.571a1.946,1.946,0,0,0-.1,1.28,1.919,1.919,0,0,0,.4,1.1,9.815,9.815,0,0,1,.535-.955c-.066.375-.128.75-.162,1.134a2.93,2.93,0,0,0,1.137-.764c.309-.307.7-.658.55-1.144a11.815,11.815,0,0,0-.822-1.085,7.147,7.147,0,0,0-1.538.43Z" transform="translate(-2741.82 -2205.828)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3112.55,2527.679c.257.031.52.077.782.127l.213-.239a2.736,2.736,0,0,1-.465-.636c.316.19.606.422.938.6a4.064,4.064,0,0,0-.114-1.051c-.2-.406-.381-.82-.586-1.218a3.419,3.419,0,0,0-1.774.251,5.191,5.191,0,0,0-.121,1.555C3111.595,2527.517,3112.127,2527.605,3112.55,2527.679Z" transform="translate(-2724.381 -2211.151)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M2015.274,2532.736a12.733,12.733,0,0,1,1.2-.858,11.625,11.625,0,0,1,4.036-1.639,14.4,14.4,0,0,1,2.911-.154,5.5,5.5,0,0,0-1.729-.693,13.858,13.858,0,0,0-4.179-.315,11.485,11.485,0,0,0-2.518.362,31.043,31.043,0,0,0-3.691,1.219,4.044,4.044,0,0,0-2.98,2.094,3.389,3.389,0,0,0-.24,1.786,4.6,4.6,0,0,0,.593,1.119,2.888,2.888,0,0,0,3.1.83,3.088,3.088,0,0,0,1.722-1.766A9.18,9.18,0,0,1,2015.274,2532.736Z" transform="translate(-1758.295 -2214.516)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M2067.826,2544.339l.062,0a16.322,16.322,0,0,1,3.288-1.477,4.1,4.1,0,0,0,1.286-.443,21.832,21.832,0,0,0-3.292-.053,13.412,13.412,0,0,0-1.754.316,20.18,20.18,0,0,0-3.37,1.019c-.514.21-1.008.463-1.515.683a17.19,17.19,0,0,0-4.237,2.694,20.145,20.145,0,0,1-1.96,1.573,7.413,7.413,0,0,1-1.463,1.012,6.7,6.7,0,0,0-1.909,2.985,7.032,7.032,0,0,0-.023,1.851,4.321,4.321,0,0,0,.933,1.741,4.56,4.56,0,0,0,2.215,1.318,4.023,4.023,0,0,0,3.839-1.426,3.941,3.941,0,0,0,.658-1.023,9.67,9.67,0,0,0,.333-1.7,10.046,10.046,0,0,1,1.147-2.784,5.764,5.764,0,0,1,.654-1.183,5.669,5.669,0,0,1,.691-.984,3.79,3.79,0,0,0,.807-.949,1.9,1.9,0,0,1,.547-.69c.6-.516,1.193-1.047,1.821-1.532a6.473,6.473,0,0,0,1.241-.943Z" transform="translate(-1797.538 -2226.131)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3132.042,2544.494c-.239-.07-.393.115-.491.3a.453.453,0,0,0,.624.317C3132.187,2544.9,3132.274,2544.612,3132.042,2544.494Z" transform="translate(-2742.031 -2228.015)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3110.18,2547.321c.109-.29.4-.4.657-.54a.791.791,0,0,0-.771-.37c-.526.057-1.152-.023-1.571.354a13.736,13.736,0,0,0-.264,1.365,4.986,4.986,0,0,0,1.162.769,1.081,1.081,0,0,0,.889-.32,10.145,10.145,0,0,0,.73-1.272c0-.078,0-.234,0-.312C3110.737,2547.115,3110.461,2547.228,3110.18,2547.321Z" transform="translate(-2721.612 -2229.698)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3938.626,2551.743a3.494,3.494,0,0,0-.248.279,12.446,12.446,0,0,0-2.062,3.234c-.223.621-.423,1.249-.638,1.873a15.617,15.617,0,0,0-.205,3.628c.134.75.3,1.493.494,2.234a18.432,18.432,0,0,0,.983,1.968,12.042,12.042,0,0,0,2.422,2.709v-1.289a8.7,8.7,0,0,1-2.7-4.248,5.6,5.6,0,0,1-.365-1.792,10.943,10.943,0,0,1,.09-2.346,5.507,5.507,0,0,1,.3-1.5,11.977,11.977,0,0,1,2.676-4.542v-.947C3939.12,2551.254,3938.862,2551.488,3938.626,2551.743Z" transform="translate(-3445.935 -2233.734)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M2473.616,2574.191a9.485,9.485,0,0,0-1.129-1.512,6.358,6.358,0,0,0-2.611-1.5,8.05,8.05,0,0,0-2.356-.1,5.9,5.9,0,0,0-2.82,1.264,3.216,3.216,0,0,0-.792.807,4.8,4.8,0,0,0-.964,2.769c0,.3,0,.607,0,.914a9.994,9.994,0,0,0,.106-1.764,14.989,14.989,0,0,1-.009,1.514,4.494,4.494,0,0,0,1.764,3.172c.193.1.385.2.588.289a3.816,3.816,0,0,0,4.268-.647,3.335,3.335,0,0,0,.969-2.781,3.429,3.429,0,0,0-1.692-2.259,2.994,2.994,0,0,0-2.4.312,1.972,1.972,0,0,0-.67,2.392,1.6,1.6,0,0,0,2.082.746,1.7,1.7,0,0,0,.916-1.789,3.168,3.168,0,0,0-.644-1.016,1.987,1.987,0,0,1,1.48,1.58,2.21,2.21,0,0,1-1.035,2.35,2.866,2.866,0,0,1-3.281-.112,3.675,3.675,0,0,1-1.047-4.154,3.578,3.578,0,0,1,1.792-1.909,4.744,4.744,0,0,1,3.983-.281,5.024,5.024,0,0,1,2.627,2.506,6.078,6.078,0,0,1-1.735,7.512,7.8,7.8,0,0,1-7.712.985,8.327,8.327,0,0,1-4.649-5.229,9.282,9.282,0,0,1,.138-6.219,11.236,11.236,0,0,1,2.071-3.684,11.4,11.4,0,0,1,2.62-2.373,14.8,14.8,0,0,1,8.723-2.741,19.656,19.656,0,0,1,7.232,1.231,26.077,26.077,0,0,1,4,1.768c.611.354,1.231.7,1.807,1.113.648.434,1.291.879,1.9,1.377a5.259,5.259,0,0,1,.537.483c.041,0,.125,0,.167,0a21.887,21.887,0,0,0-4.233-3.158,31.471,31.471,0,0,0-3.3-1.615,30.061,30.061,0,0,0-4.138-1.255c-.757-.2-1.549-.226-2.306-.416a22.014,22.014,0,0,0-5,.287,15.821,15.821,0,0,0-5.374,2.116,17.654,17.654,0,0,0-3.143,2.693,15.2,15.2,0,0,0-1.371,1.846,15.78,15.78,0,0,0-1.3,3.179,13.251,13.251,0,0,0-.348,3.161,10.643,10.643,0,0,0,2.1,5.591,8.79,8.79,0,0,0,5.409,3.337,8.906,8.906,0,0,0,4.875-.52,9.519,9.519,0,0,0,3.09-2.1,7.442,7.442,0,0,0,1.432-6.717,9.514,9.514,0,0,0-.6-1.437Z" transform="translate(-2151.657 -2244.005)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M2286.324,2626.19a14.927,14.927,0,0,0-2.207-2.57,12.88,12.88,0,0,0-7.264-3.079,12.707,12.707,0,0,0-6.641,1.319,10.246,10.246,0,0,0-3.88,3.224,10.7,10.7,0,0,0-.917,1.464,17.268,17.268,0,0,0-.787,2.142,10.133,10.133,0,0,0,.757,6.923,8.537,8.537,0,0,0,1.81,2.555,8.939,8.939,0,0,0,3.035,1.906,8.059,8.059,0,0,0,4.989.137,7.414,7.414,0,0,0,3.859-2.376,6.792,6.792,0,0,0,.709-7.646,6.492,6.492,0,0,0-2.437-2.3,6.2,6.2,0,0,0-2.61-.536,4.962,4.962,0,0,0-3.306,1.464,4.405,4.405,0,0,0-1.315,2.8,3.558,3.558,0,0,0,1.586,3.114,3.627,3.627,0,0,0,1.916.465,3.246,3.246,0,0,0,2.779-1.52,3.422,3.422,0,0,0,0-3.69,13.084,13.084,0,0,0-.928-1.066,4.315,4.315,0,0,1,3.221,4.314,4.485,4.485,0,0,1-1.376,3.439,5.547,5.547,0,0,1-2.134,1.333,6.2,6.2,0,0,1-2.431.291,5.8,5.8,0,0,1-3.133-1.062,7.446,7.446,0,0,1-2.9-5.489,7.762,7.762,0,0,1,.79-3.963,7.986,7.986,0,0,1,3.45-3.581,10.247,10.247,0,0,1,8.195-.711,9.9,9.9,0,0,1,2.85,1.549,10.6,10.6,0,0,1,2.462,2.719,14.215,14.215,0,0,1,1.4,2.926,13.038,13.038,0,0,1-2.906,12.878h3a15.22,15.22,0,0,0,2.569-5.945,14.508,14.508,0,0,0-.508-8.043,14.121,14.121,0,0,0-1.694-3.386Z" transform="translate(-1982.688 -2294.573)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M2679.841,2633.49a8.441,8.441,0,0,0,2.446-1.932c.006-.173.014-.342.02-.508a2.651,2.651,0,0,0-.567-1.426,7.735,7.735,0,0,1-.678-1.265c-.853.17-1.739.127-2.577.358a1.5,1.5,0,0,0-1.058,1.454,25.669,25.669,0,0,0,.051,2.607,1.987,1.987,0,0,0,.3.61.372.372,0,0,0,.272-.158,9.667,9.667,0,0,1,1.135-1.449,12.606,12.606,0,0,0-.823,2.1A2.436,2.436,0,0,0,2679.841,2633.49Z" transform="translate(-2344.386 -2301.463)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M2689.413,2672.471c.606-.557,1.087-1.239,1.741-1.744-.343-.749-.613-1.531-1-2.256a1.541,1.541,0,0,0-1.325-.818,9.666,9.666,0,0,0-1.637.417,2.9,2.9,0,0,0-1.844,1.042,6.942,6.942,0,0,0,1.229.416.575.575,0,0,1-.514.245c-.32-.036-.637-.05-.952-.057.037.69.653,1.113,1.091,1.575a8.555,8.555,0,0,0,2.009,1.386A1.422,1.422,0,0,0,2689.413,2672.471Z" transform="translate(-2351.122 -2335.867)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M2627.419,2641.43c.412-.419.831-.831,1.215-1.274a1.965,1.965,0,0,0,.484-1.113c-.748.039-1.464.306-2.214.289.693-.257,1.354-.6,2.065-.81.009-.382-.392-.536-.622-.766.221-.019.448-.03.678-.04l-.025-.093a12.932,12.932,0,0,0-.945-1.841c.578.474,1.01,1.1,1.542,1.625a3.813,3.813,0,0,0,.313-.367,11.77,11.77,0,0,0-.409-3.564,1.545,1.545,0,0,0-.853-.912,4.178,4.178,0,0,0-1.615.035,4.97,4.97,0,0,0-1.21.116,7.172,7.172,0,0,0-.731,3.243,5.247,5.247,0,0,0,2.356,1.445l.035.192a7.9,7.9,0,0,0-2.579-.282,1.1,1.1,0,0,0-.949.724c-.281.694-.336,1.454-.582,2.162-.176.342.239.478.444.663.738.5,1.389,1.3,2.347,1.342A2.292,2.292,0,0,0,2627.419,2641.43Z" transform="translate(-2297.027 -2305.074)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M2672.341,2674.237c-.057.3.189.5.367.7a.993.993,0,0,0,.993-.392c-.006-.17-.008-.336,0-.5a1.292,1.292,0,0,0-.649-.488C2672.71,2673.632,2672.316,2673.829,2672.341,2674.237Z" transform="translate(-2339.933 -2341.041)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M2741.27,2590.4a5.259,5.259,0,0,1,.089-1.7c1.087-1.535,2.75-2.645,3.492-4.424.172-.42.313-.851.484-1.27a11.122,11.122,0,0,0,.15-4.11c-.052-.252-.107-.5-.16-.744-.157-.612-.336-1.217-.459-1.835a13.5,13.5,0,0,1-.388-2.011,2.466,2.466,0,0,0-.351.021,10.551,10.551,0,0,1-1.158,1.952c-.816.96-1.639,1.914-2.49,2.845a14.725,14.725,0,0,0-1.641,2.485,6.967,6.967,0,0,0-.568,3.544,3.666,3.666,0,0,0,.058.363,8.126,8.126,0,0,0,.572,1.889c.159.316.245.785.7.768a15.142,15.142,0,0,1,1.034-4.436,18.422,18.422,0,0,1,1.867-3.288,15.627,15.627,0,0,0-1.988,6.6c0,.1.015.306.02.407a43.467,43.467,0,0,0,.848,8.7,39.03,39.03,0,0,0,2.138,6.968h.683a38.764,38.764,0,0,1-2.931-12.722Z" transform="translate(-2397.656 -2254.135)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M2660.445,2689.1a12.005,12.005,0,0,0-.851,2.019,1.585,1.585,0,0,0-.059,1.248,2.613,2.613,0,0,0,1.424,1.072c.373.148.7.382,1.071.551.173.1.325-.08.46-.168a14.227,14.227,0,0,0,1.672-1.458,1.355,1.355,0,0,0,.3-1.2,8.122,8.122,0,0,0-1.031-1.83,2.507,2.507,0,0,0-1.375-1.235,9.533,9.533,0,0,1-.169,2.015c-.172-.664-.253-1.346-.366-2.019C2660.945,2688.085,2660.7,2688.688,2660.445,2689.1Z" transform="translate(-2328.635 -2353.763)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M2672.9,2747.768a8.255,8.255,0,0,0-2.213-1.068,12.109,12.109,0,0,1-1.559-.532,6.386,6.386,0,0,1,1.8.326,8.283,8.283,0,0,1,2.333,1c.376.178.676.6,1.112.613a1.572,1.572,0,0,0-.285-.891,4.879,4.879,0,0,0-2.833-2.411,15.344,15.344,0,0,0-3.515-.249,7.547,7.547,0,0,1-2.6-.311c.016.483.473.756.7,1.142a10.006,10.006,0,0,0,2.4,2.823,5.281,5.281,0,0,0,3.223,1.068,17.83,17.83,0,0,1,1.945,0,34.481,34.481,0,0,1,3.188,2.649h.932q-1.642-1.58-3.424-3c-.448-.34-.743-.838-1.207-1.154Z" transform="translate(-2333.637 -2402.929)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M2855.066,2769.912c.322-.1.638-.214.954-.338a8.929,8.929,0,0,0,1.331-.981.892.892,0,0,0,.172-1.063c-.235-.439-.515-.852-.711-1.309-.78.067-1.692-.041-2.3.545a3.8,3.8,0,0,0-.139.389c-.011.588-.031,1.179-.007,1.77a1.044,1.044,0,0,0,.306.632,9.049,9.049,0,0,1,.842-1.112C2855.4,2768.949,2855.035,2769.374,2855.066,2769.912Z" transform="translate(-2499.312 -2422.175)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M2830.7,2771.743a8.384,8.384,0,0,0,.021-1.413c-.169-.562-.139-1.275-.633-1.669-.646-.354-1.389.036-2.078-.02a5.511,5.511,0,0,0-.511,2.028c.117.509.633.728,1.073.9a2.16,2.16,0,0,0,1.612.429,10.372,10.372,0,0,1-.633-1.294C2829.948,2771.018,2830.144,2771.693,2830.7,2771.743Z" transform="translate(-2475.789 -2424.18)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3329.031,2778.539c.1,0,.207.006.316.015.032-.08.1-.24.131-.32a2.906,2.906,0,0,0-.542-.48l.343-.081c.1-.194.213-.378.328-.562-.029.261-.086.515-.134.777.447-.037.726-.41,1.032-.692.166-.205.423-.4.365-.7a10.725,10.725,0,0,0-.611-.912,1.99,1.99,0,0,0-1.388.5c-.006.245-.019.474-.005.73l-.139-.144a5.859,5.859,0,0,0-.4-.609,10.57,10.57,0,0,0-1.285.31,5.466,5.466,0,0,0-.01,1.389q.321.133.649.282l.426.074c-.449.121-.96-.023-1.335.31-.032.184-.066.369-.094.562-.006.094-.018.285-.024.381h1.926c.109-.218.17-.464.265-.68-.255.057-.479.141-.719.214.009-.037.023-.114.031-.152.158-.092.325-.177.494-.258-.012-.178-.009-.346-.015-.515l-.1-.144c-.108-.141-.207-.267-.31-.4.208.152.422.3.633.458.073.205.117.418.178.638Z" transform="translate(-2912.863 -2430.379)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3088.874,2791.542c-.328-.509-.854.062-1.241.2a18.131,18.131,0,0,0-2.612,1.417h5.749C3090.156,2792.6,3089.433,2792.162,3088.874,2791.542Z" transform="translate(-2701.289 -2444.166)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3350.674,2790.756l.019.183c.25.066.509.127.769.187-.3.035-.6.062-.891.1.2.519.828.613,1.251.9h.454a2.587,2.587,0,0,0,.653-.975,4.671,4.671,0,0,0-.591-.949c-.627-.2-1.164.252-1.664.555Z" transform="translate(-2933.808 -2443.131)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M2862.257,2792.289a2.931,2.931,0,0,0-1.683.213c-.383.174-.917.252-1.062.707.282.077.567.16.86.224a3.51,3.51,0,0,1-.505.187c-.19-.021-.374-.03-.556-.035.025.112.055.228.092.347h3.82c-.275-.567-.407-1.276-.965-1.642Z" transform="translate(-2503.654 -2444.938)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M2851.452,2796.175c-.481.122-.286.957.214.85C2852.227,2796.937,2852.046,2795.9,2851.452,2796.175Z" transform="translate(-2496.531 -2448.363)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M2635.985,2798.777c-.383.108-.746.267-1.124.383H2645.5a19.345,19.345,0,0,0-3.032-.754,13.951,13.951,0,0,0-6.48.371Z" transform="translate(-2307.123 -2450.169)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3344.469,2801.613h.56c-.094-.21-.18-.42-.262-.623A.668.668,0,0,0,3344.469,2801.613Z" transform="translate(-2928.462 -2452.62)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M3349.2,2800.8c.006.21.021.425.046.644h.775C3349.775,2801.194,3349.563,2800.871,3349.2,2800.8Z" transform="translate(-2932.608 -2452.454)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/><path d="M2821.93,2795.293a3.915,3.915,0,0,0,.94-.381c-.121-.112-.239-.219-.353-.322-.51-.138-1.016-.292-1.536-.379-.425-.015-.929-.146-1.284.154a2.677,2.677,0,0,0-.494,1.225l-.053.045h3.754l0-.316-.4.081A1.05,1.05,0,0,1,2821.93,2795.293Z" transform="translate(-2468.489 -2446.648)" fill="' . blossom_wedding_hash_to_percent23( blossom_wedding_sanitize_hex_color( $primary_color ) ) . '"/></g></g></svg>\'' . ' );
    }';

    if( blossom_wedding_is_woocommerce_activated() ) {
        $custom_css .='
        .woocommerce ul.products li.product .price ins,
		.woocommerce div.product p.price ins,
		.woocommerce div.product span.price ins, 
		.woocommerce nav.woocommerce-pagination ul li a:hover,
 		.woocommerce nav.woocommerce-pagination ul li a:focus, 
 		.woocommerce div.product .entry-summary .woocommerce-product-rating .woocommerce-review-link:hover,
 		.woocommerce div.product .entry-summary .woocommerce-product-rating .woocommerce-review-link:focus, 
 		.woocommerce div.product .entry-summary .product_meta .posted_in a:hover,
		.woocommerce div.product .entry-summary .product_meta .posted_in a:focus,
		.woocommerce div.product .entry-summary .product_meta .tagged_as a:hover,
		.woocommerce div.product .entry-summary .product_meta .tagged_as a:focus, 
		.woocommerce-cart #primary .page .entry-content table.shop_table td.product-name a:hover,
 		.woocommerce-cart #primary .page .entry-content table.shop_table td.product-name a:focus, 
 		.widget.woocommerce ul li a:hover, .woocommerce.widget_price_filter .price_slider_amount .button:hover,
 		.woocommerce.widget_price_filter .price_slider_amount .button:focus, 
 		.woocommerce.widget_product_categories ul li.cat-parent .cat-toggle:hover, 
 		.woocommerce ul.product_list_widget li .product-title:hover,
 		.woocommerce ul.product_list_widget li .product-title:focus, 
 		.woocommerce ul.product_list_widget li ins,
 		.woocommerce ul.product_list_widget li ins .amount, 
 		.woocommerce ul.products li.product .price ins, .woocommerce div.product p.price ins, .woocommerce div.product span.price ins,
 		.woocommerce div.product .entry-summary .product_meta .posted_in a:hover, .woocommerce div.product .entry-summary .product_meta .posted_in a:focus, .woocommerce div.product .entry-summary .product_meta .tagged_as a:hover, .woocommerce div.product .entry-summary .product_meta .tagged_as a:focus, 
 		.woocommerce div.product .entry-summary .woocommerce-product-rating .woocommerce-review-link:hover, .woocommerce div.product .entry-summary .woocommerce-product-rating .woocommerce-review-link:focus, 
 		.woocommerce nav.woocommerce-pagination ul li a:hover, .woocommerce nav.woocommerce-pagination ul li a:focus {
			color: ' . blossom_wedding_sanitize_hex_color( $primary_color ) . ';
		}

		.woocommerce ul.products li.product .added_to_cart:hover,
 		.woocommerce ul.products li.product .added_to_cart:focus, 
 		.woocommerce ul.products li.product .add_to_cart_button:hover,
		.woocommerce ul.products li.product .add_to_cart_button:focus,
		.woocommerce ul.products li.product .product_type_external:hover,
		.woocommerce ul.products li.product .product_type_external:focus,
		.woocommerce ul.products li.product .ajax_add_to_cart:hover,
		.woocommerce ul.products li.product .ajax_add_to_cart:focus, 
		.woocommerce ul.products li.product .button.loading,
 		.woocommerce-page ul.products li.product .button.loading, 
 		.woocommerce nav.woocommerce-pagination ul li span.current, 
 		.woocommerce div.product .entry-summary .variations_form .single_variation_wrap .button:hover,
 		.woocommerce div.product .entry-summary .variations_form .single_variation_wrap .button:focus, 
 		.woocommerce div.product form.cart .single_add_to_cart_button:hover,
		.woocommerce div.product form.cart .single_add_to_cart_button:focus,
		.woocommerce div.product .cart .single_add_to_cart_button.alt:hover,
		.woocommerce div.product .cart .single_add_to_cart_button.alt:focus, 
		.woocommerce-cart #primary .page .entry-content table.shop_table td.actions .coupon input[type="submit"]:hover,
 		.woocommerce-cart #primary .page .entry-content table.shop_table td.actions .coupon input[type="submit"]:focus, 
 		.woocommerce-cart #primary .page .entry-content .cart_totals .checkout-button:hover,
 		.woocommerce-cart #primary .page .entry-content .cart_totals .checkout-button:focus, 
 		.woocommerce-checkout .woocommerce .woocommerce-info, 
 		.woocommerce-checkout .woocommerce form.woocommerce-form-login input.button:hover,
		.woocommerce-checkout .woocommerce form.woocommerce-form-login input.button:focus,
		.woocommerce-checkout .woocommerce form.checkout_coupon input.button:hover,
		.woocommerce-checkout .woocommerce form.checkout_coupon input.button:focus,
		.woocommerce form.lost_reset_password input.button:hover,
		.woocommerce form.lost_reset_password input.button:focus,
		.woocommerce .return-to-shop .button:hover,
		.woocommerce .return-to-shop .button:focus,
		.woocommerce #payment #place_order:hover,
		.woocommerce-page #payment #place_order:focus, 
		.woocommerce #respond input#submit:hover, 
		.woocommerce #respond input#submit:focus, 
		.woocommerce a.button:hover, 
		.woocommerce a.button:focus, 
		.woocommerce button.button:hover, 
		.woocommerce button.button:focus, 
		.woocommerce input.button:hover, 
		.woocommerce input.button:focus, 
		.woocommerce #secondary .widget_shopping_cart .buttons .button:hover,
 		.woocommerce #secondary .widget_shopping_cart .buttons .button:focus, 
 		.woocommerce #secondary .widget_price_filter .ui-slider .ui-slider-range, 
 		.woocommerce #secondary .widget_price_filter .price_slider_amount .button,  
 		.woocommerce .woocommerce-message .button:hover,
 		.woocommerce .woocommerce-message .button:focus, 
 		.woocommerce-account .woocommerce-MyAccount-navigation ul li.is-active a, .woocommerce-account .woocommerce-MyAccount-navigation ul li a:hover, 
        .woocommerce ul.products li.product .add_to_cart_button:hover, .woocommerce ul.products li.product .add_to_cart_button:focus, .woocommerce ul.products li.product .product_type_external:hover, .woocommerce ul.products li.product .product_type_external:focus, .woocommerce ul.products li.product .ajax_add_to_cart:hover, .woocommerce ul.products li.product .ajax_add_to_cart:focus, .woocommerce ul.products li.product .product_type_grouped:hover, .woocommerce ul.products li.product .product_type_grouped:focus {
	 		background: ' . blossom_wedding_sanitize_hex_color( $primary_color ) . ';
	 	}

	 	.woocommerce .woocommerce-widget-layered-nav-list .woocommerce-widget-layered-nav-list__item.chosen a::before, 
 		.widget.widget_layered_nav_filters ul li.chosen a:before, 
 		.woocommerce-product-search button[type="submit"]:hover {
	 		background-color: ' . blossom_wedding_sanitize_hex_color( $primary_color ) . ';
	 	}

	 	.woocommerce nav.woocommerce-pagination ul li a:hover,
 		.woocommerce nav.woocommerce-pagination ul li a:focus, 
 		.woocommerce nav.woocommerce-pagination ul li span.current, 
 		.woocommerce .woocommerce-widget-layered-nav-list .woocommerce-widget-layered-nav-list__item a:hover:before, 
 		.woocommerce.widget_layered_nav_filters ul li a:hover:before, 
 		.woocommerce .woocommerce-widget-layered-nav-list .woocommerce-widget-layered-nav-list__item.chosen a::before, 
 		.woocommerce.widget_layered_nav_filters ul li.chosen a:before, 
 		.woocommerce.widget_price_filter .ui-slider .ui-slider-handle, 
 		.woocommerce.widget_price_filter .price_slider_amount .button {
	 		border-color: ' . blossom_wedding_sanitize_hex_color( $primary_color ) . ';
	 	}

	 	.woocommerce div.product .product_title, 
	 	.woocommerce div.product .woocommerce-tabs .panel h2 {
		 	font-family : ' . wp_kses_post( $primary_fonts['font'] ) . ';
		 }

		.woocommerce.widget_shopping_cart ul li a, 
		.woocommerce ul.product_list_widget li .product-title, 
		.woocommerce-order-details .woocommerce-order-details__title, 
		.woocommerce-order-received .woocommerce-column__title, 
		.woocommerce-customer-details .woocommerce-column__title {
		 	font-family : ' . wp_kses_post( $primary_fonts['font'] ) . ';
		}';   
    }
           
    wp_add_inline_style( 'blossom-wedding', $custom_css );
}
add_action( 'wp_enqueue_scripts', 'blossom_wedding_dynamic_css', 99 );

/**
 * Function for sanitizing Hex color 
 */
function blossom_wedding_sanitize_hex_color( $color ){
	if ( '' === $color )
		return '';

    // 3 or 6 hex digits, or the empty string.
	if ( preg_match('|^#([A-Fa-f0-9]{3}){1,2}$|', $color ) )
		return $color;
}

/**
 * convert hex to rgb
 * @link http://bavotasan.com/2011/convert-hex-color-to-rgb-using-php/
*/
function blossom_wedding_hex2rgb($hex) {
   $hex = str_replace("#", "", $hex);

   if(strlen($hex) == 3) {
      $r = hexdec(substr($hex,0,1).substr($hex,0,1));
      $g = hexdec(substr($hex,1,1).substr($hex,1,1));
      $b = hexdec(substr($hex,2,1).substr($hex,2,1));
   } else {
      $r = hexdec(substr($hex,0,2));
      $g = hexdec(substr($hex,2,2));
      $b = hexdec(substr($hex,4,2));
   }
   $rgb = array($r, $g, $b);
   //return implode(",", $rgb); // returns the rgb values separated by commas
   return $rgb; // returns an array with the rgb values
}

/**
 * Convert '#' to '%23'
*/
function blossom_wedding_hash_to_percent23( $color_code ){
    $color_code = str_replace( "#", "%23", $color_code );
    return $color_code;
}