/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./node_modules/@remix-run/router/dist/router.js"
/*!*******************************************************!*\
  !*** ./node_modules/@remix-run/router/dist/router.js ***!
  \*******************************************************/
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AbortedDeferredError: () => (/* binding */ AbortedDeferredError),
/* harmony export */   Action: () => (/* binding */ Action),
/* harmony export */   IDLE_BLOCKER: () => (/* binding */ IDLE_BLOCKER),
/* harmony export */   IDLE_FETCHER: () => (/* binding */ IDLE_FETCHER),
/* harmony export */   IDLE_NAVIGATION: () => (/* binding */ IDLE_NAVIGATION),
/* harmony export */   UNSAFE_DEFERRED_SYMBOL: () => (/* binding */ UNSAFE_DEFERRED_SYMBOL),
/* harmony export */   UNSAFE_DeferredData: () => (/* binding */ DeferredData),
/* harmony export */   UNSAFE_ErrorResponseImpl: () => (/* binding */ ErrorResponseImpl),
/* harmony export */   UNSAFE_convertRouteMatchToUiMatch: () => (/* binding */ convertRouteMatchToUiMatch),
/* harmony export */   UNSAFE_convertRoutesToDataRoutes: () => (/* binding */ convertRoutesToDataRoutes),
/* harmony export */   UNSAFE_decodePath: () => (/* binding */ decodePath),
/* harmony export */   UNSAFE_getResolveToMatches: () => (/* binding */ getResolveToMatches),
/* harmony export */   UNSAFE_invariant: () => (/* binding */ invariant),
/* harmony export */   UNSAFE_warning: () => (/* binding */ warning),
/* harmony export */   createBrowserHistory: () => (/* binding */ createBrowserHistory),
/* harmony export */   createHashHistory: () => (/* binding */ createHashHistory),
/* harmony export */   createMemoryHistory: () => (/* binding */ createMemoryHistory),
/* harmony export */   createPath: () => (/* binding */ createPath),
/* harmony export */   createRouter: () => (/* binding */ createRouter),
/* harmony export */   createStaticHandler: () => (/* binding */ createStaticHandler),
/* harmony export */   data: () => (/* binding */ data),
/* harmony export */   defer: () => (/* binding */ defer),
/* harmony export */   generatePath: () => (/* binding */ generatePath),
/* harmony export */   getStaticContextFromError: () => (/* binding */ getStaticContextFromError),
/* harmony export */   getToPathname: () => (/* binding */ getToPathname),
/* harmony export */   isDataWithResponseInit: () => (/* binding */ isDataWithResponseInit),
/* harmony export */   isDeferredData: () => (/* binding */ isDeferredData),
/* harmony export */   isRouteErrorResponse: () => (/* binding */ isRouteErrorResponse),
/* harmony export */   joinPaths: () => (/* binding */ joinPaths),
/* harmony export */   json: () => (/* binding */ json),
/* harmony export */   matchPath: () => (/* binding */ matchPath),
/* harmony export */   matchRoutes: () => (/* binding */ matchRoutes),
/* harmony export */   normalizePathname: () => (/* binding */ normalizePathname),
/* harmony export */   parsePath: () => (/* binding */ parsePath),
/* harmony export */   redirect: () => (/* binding */ redirect),
/* harmony export */   redirectDocument: () => (/* binding */ redirectDocument),
/* harmony export */   replace: () => (/* binding */ replace),
/* harmony export */   resolvePath: () => (/* binding */ resolvePath),
/* harmony export */   resolveTo: () => (/* binding */ resolveTo),
/* harmony export */   stripBasename: () => (/* binding */ stripBasename)
/* harmony export */ });
/**
 * @remix-run/router v1.23.1
 *
 * Copyright (c) Remix Software Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE.md file in the root directory of this source tree.
 *
 * @license MIT
 */
function _extends() {
  _extends = Object.assign ? Object.assign.bind() : function (target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i];
      for (var key in source) {
        if (Object.prototype.hasOwnProperty.call(source, key)) {
          target[key] = source[key];
        }
      }
    }
    return target;
  };
  return _extends.apply(this, arguments);
}

////////////////////////////////////////////////////////////////////////////////
//#region Types and Constants
////////////////////////////////////////////////////////////////////////////////
/**
 * Actions represent the type of change to a location value.
 */
var Action;
(function (Action) {
  /**
   * A POP indicates a change to an arbitrary index in the history stack, such
   * as a back or forward navigation. It does not describe the direction of the
   * navigation, only that the current index changed.
   *
   * Note: This is the default action for newly created history objects.
   */
  Action["Pop"] = "POP";
  /**
   * A PUSH indicates a new entry being added to the history stack, such as when
   * a link is clicked and a new page loads. When this happens, all subsequent
   * entries in the stack are lost.
   */
  Action["Push"] = "PUSH";
  /**
   * A REPLACE indicates the entry at the current index in the history stack
   * being replaced by a new one.
   */
  Action["Replace"] = "REPLACE";
})(Action || (Action = {}));
const PopStateEventType = "popstate";
/**
 * Memory history stores the current location in memory. It is designed for use
 * in stateful non-browser environments like tests and React Native.
 */
function createMemoryHistory(options) {
  if (options === void 0) {
    options = {};
  }
  let {
    initialEntries = ["/"],
    initialIndex,
    v5Compat = false
  } = options;
  let entries; // Declare so we can access from createMemoryLocation
  entries = initialEntries.map((entry, index) => createMemoryLocation(entry, typeof entry === "string" ? null : entry.state, index === 0 ? "default" : undefined));
  let index = clampIndex(initialIndex == null ? entries.length - 1 : initialIndex);
  let action = Action.Pop;
  let listener = null;
  function clampIndex(n) {
    return Math.min(Math.max(n, 0), entries.length - 1);
  }
  function getCurrentLocation() {
    return entries[index];
  }
  function createMemoryLocation(to, state, key) {
    if (state === void 0) {
      state = null;
    }
    let location = createLocation(entries ? getCurrentLocation().pathname : "/", to, state, key);
    warning(location.pathname.charAt(0) === "/", "relative pathnames are not supported in memory history: " + JSON.stringify(to));
    return location;
  }
  function createHref(to) {
    return typeof to === "string" ? to : createPath(to);
  }
  let history = {
    get index() {
      return index;
    },
    get action() {
      return action;
    },
    get location() {
      return getCurrentLocation();
    },
    createHref,
    createURL(to) {
      return new URL(createHref(to), "http://localhost");
    },
    encodeLocation(to) {
      let path = typeof to === "string" ? parsePath(to) : to;
      return {
        pathname: path.pathname || "",
        search: path.search || "",
        hash: path.hash || ""
      };
    },
    push(to, state) {
      action = Action.Push;
      let nextLocation = createMemoryLocation(to, state);
      index += 1;
      entries.splice(index, entries.length, nextLocation);
      if (v5Compat && listener) {
        listener({
          action,
          location: nextLocation,
          delta: 1
        });
      }
    },
    replace(to, state) {
      action = Action.Replace;
      let nextLocation = createMemoryLocation(to, state);
      entries[index] = nextLocation;
      if (v5Compat && listener) {
        listener({
          action,
          location: nextLocation,
          delta: 0
        });
      }
    },
    go(delta) {
      action = Action.Pop;
      let nextIndex = clampIndex(index + delta);
      let nextLocation = entries[nextIndex];
      index = nextIndex;
      if (listener) {
        listener({
          action,
          location: nextLocation,
          delta
        });
      }
    },
    listen(fn) {
      listener = fn;
      return () => {
        listener = null;
      };
    }
  };
  return history;
}
/**
 * Browser history stores the location in regular URLs. This is the standard for
 * most web apps, but it requires some configuration on the server to ensure you
 * serve the same app at multiple URLs.
 *
 * @see https://github.com/remix-run/history/tree/main/docs/api-reference.md#createbrowserhistory
 */
function createBrowserHistory(options) {
  if (options === void 0) {
    options = {};
  }
  function createBrowserLocation(window, globalHistory) {
    let {
      pathname,
      search,
      hash
    } = window.location;
    return createLocation("", {
      pathname,
      search,
      hash
    },
    // state defaults to `null` because `window.history.state` does
    globalHistory.state && globalHistory.state.usr || null, globalHistory.state && globalHistory.state.key || "default");
  }
  function createBrowserHref(window, to) {
    return typeof to === "string" ? to : createPath(to);
  }
  return getUrlBasedHistory(createBrowserLocation, createBrowserHref, null, options);
}
/**
 * Hash history stores the location in window.location.hash. This makes it ideal
 * for situations where you don't want to send the location to the server for
 * some reason, either because you do cannot configure it or the URL space is
 * reserved for something else.
 *
 * @see https://github.com/remix-run/history/tree/main/docs/api-reference.md#createhashhistory
 */
function createHashHistory(options) {
  if (options === void 0) {
    options = {};
  }
  function createHashLocation(window, globalHistory) {
    let {
      pathname = "/",
      search = "",
      hash = ""
    } = parsePath(window.location.hash.substr(1));
    // Hash URL should always have a leading / just like window.location.pathname
    // does, so if an app ends up at a route like /#something then we add a
    // leading slash so all of our path-matching behaves the same as if it would
    // in a browser router.  This is particularly important when there exists a
    // root splat route (<Route path="*">) since that matches internally against
    // "/*" and we'd expect /#something to 404 in a hash router app.
    if (!pathname.startsWith("/") && !pathname.startsWith(".")) {
      pathname = "/" + pathname;
    }
    return createLocation("", {
      pathname,
      search,
      hash
    },
    // state defaults to `null` because `window.history.state` does
    globalHistory.state && globalHistory.state.usr || null, globalHistory.state && globalHistory.state.key || "default");
  }
  function createHashHref(window, to) {
    let base = window.document.querySelector("base");
    let href = "";
    if (base && base.getAttribute("href")) {
      let url = window.location.href;
      let hashIndex = url.indexOf("#");
      href = hashIndex === -1 ? url : url.slice(0, hashIndex);
    }
    return href + "#" + (typeof to === "string" ? to : createPath(to));
  }
  function validateHashLocation(location, to) {
    warning(location.pathname.charAt(0) === "/", "relative pathnames are not supported in hash history.push(" + JSON.stringify(to) + ")");
  }
  return getUrlBasedHistory(createHashLocation, createHashHref, validateHashLocation, options);
}
function invariant(value, message) {
  if (value === false || value === null || typeof value === "undefined") {
    throw new Error(message);
  }
}
function warning(cond, message) {
  if (!cond) {
    // eslint-disable-next-line no-console
    if (typeof console !== "undefined") console.warn(message);
    try {
      // Welcome to debugging history!
      //
      // This error is thrown as a convenience, so you can more easily
      // find the source for a warning that appears in the console by
      // enabling "pause on exceptions" in your JavaScript debugger.
      throw new Error(message);
      // eslint-disable-next-line no-empty
    } catch (e) {}
  }
}
function createKey() {
  return Math.random().toString(36).substr(2, 8);
}
/**
 * For browser-based histories, we combine the state and key into an object
 */
function getHistoryState(location, index) {
  return {
    usr: location.state,
    key: location.key,
    idx: index
  };
}
/**
 * Creates a Location object with a unique key from the given Path
 */
function createLocation(current, to, state, key) {
  if (state === void 0) {
    state = null;
  }
  let location = _extends({
    pathname: typeof current === "string" ? current : current.pathname,
    search: "",
    hash: ""
  }, typeof to === "string" ? parsePath(to) : to, {
    state,
    // TODO: This could be cleaned up.  push/replace should probably just take
    // full Locations now and avoid the need to run through this flow at all
    // But that's a pretty big refactor to the current test suite so going to
    // keep as is for the time being and just let any incoming keys take precedence
    key: to && to.key || key || createKey()
  });
  return location;
}
/**
 * Creates a string URL path from the given pathname, search, and hash components.
 */
function createPath(_ref) {
  let {
    pathname = "/",
    search = "",
    hash = ""
  } = _ref;
  if (search && search !== "?") pathname += search.charAt(0) === "?" ? search : "?" + search;
  if (hash && hash !== "#") pathname += hash.charAt(0) === "#" ? hash : "#" + hash;
  return pathname;
}
/**
 * Parses a string URL path into its separate pathname, search, and hash components.
 */
function parsePath(path) {
  let parsedPath = {};
  if (path) {
    let hashIndex = path.indexOf("#");
    if (hashIndex >= 0) {
      parsedPath.hash = path.substr(hashIndex);
      path = path.substr(0, hashIndex);
    }
    let searchIndex = path.indexOf("?");
    if (searchIndex >= 0) {
      parsedPath.search = path.substr(searchIndex);
      path = path.substr(0, searchIndex);
    }
    if (path) {
      parsedPath.pathname = path;
    }
  }
  return parsedPath;
}
function getUrlBasedHistory(getLocation, createHref, validateLocation, options) {
  if (options === void 0) {
    options = {};
  }
  let {
    window = document.defaultView,
    v5Compat = false
  } = options;
  let globalHistory = window.history;
  let action = Action.Pop;
  let listener = null;
  let index = getIndex();
  // Index should only be null when we initialize. If not, it's because the
  // user called history.pushState or history.replaceState directly, in which
  // case we should log a warning as it will result in bugs.
  if (index == null) {
    index = 0;
    globalHistory.replaceState(_extends({}, globalHistory.state, {
      idx: index
    }), "");
  }
  function getIndex() {
    let state = globalHistory.state || {
      idx: null
    };
    return state.idx;
  }
  function handlePop() {
    action = Action.Pop;
    let nextIndex = getIndex();
    let delta = nextIndex == null ? null : nextIndex - index;
    index = nextIndex;
    if (listener) {
      listener({
        action,
        location: history.location,
        delta
      });
    }
  }
  function push(to, state) {
    action = Action.Push;
    let location = createLocation(history.location, to, state);
    if (validateLocation) validateLocation(location, to);
    index = getIndex() + 1;
    let historyState = getHistoryState(location, index);
    let url = history.createHref(location);
    // try...catch because iOS limits us to 100 pushState calls :/
    try {
      globalHistory.pushState(historyState, "", url);
    } catch (error) {
      // If the exception is because `state` can't be serialized, let that throw
      // outwards just like a replace call would so the dev knows the cause
      // https://html.spec.whatwg.org/multipage/nav-history-apis.html#shared-history-push/replace-state-steps
      // https://html.spec.whatwg.org/multipage/structured-data.html#structuredserializeinternal
      if (error instanceof DOMException && error.name === "DataCloneError") {
        throw error;
      }
      // They are going to lose state here, but there is no real
      // way to warn them about it since the page will refresh...
      window.location.assign(url);
    }
    if (v5Compat && listener) {
      listener({
        action,
        location: history.location,
        delta: 1
      });
    }
  }
  function replace(to, state) {
    action = Action.Replace;
    let location = createLocation(history.location, to, state);
    if (validateLocation) validateLocation(location, to);
    index = getIndex();
    let historyState = getHistoryState(location, index);
    let url = history.createHref(location);
    globalHistory.replaceState(historyState, "", url);
    if (v5Compat && listener) {
      listener({
        action,
        location: history.location,
        delta: 0
      });
    }
  }
  function createURL(to) {
    // window.location.origin is "null" (the literal string value) in Firefox
    // under certain conditions, notably when serving from a local HTML file
    // See https://bugzilla.mozilla.org/show_bug.cgi?id=878297
    let base = window.location.origin !== "null" ? window.location.origin : window.location.href;
    let href = typeof to === "string" ? to : createPath(to);
    // Treating this as a full URL will strip any trailing spaces so we need to
    // pre-encode them since they might be part of a matching splat param from
    // an ancestor route
    href = href.replace(/ $/, "%20");
    invariant(base, "No window.location.(origin|href) available to create URL for href: " + href);
    return new URL(href, base);
  }
  let history = {
    get action() {
      return action;
    },
    get location() {
      return getLocation(window, globalHistory);
    },
    listen(fn) {
      if (listener) {
        throw new Error("A history only accepts one active listener");
      }
      window.addEventListener(PopStateEventType, handlePop);
      listener = fn;
      return () => {
        window.removeEventListener(PopStateEventType, handlePop);
        listener = null;
      };
    },
    createHref(to) {
      return createHref(window, to);
    },
    createURL,
    encodeLocation(to) {
      // Encode a Location the same way window.location would
      let url = createURL(to);
      return {
        pathname: url.pathname,
        search: url.search,
        hash: url.hash
      };
    },
    push,
    replace,
    go(n) {
      return globalHistory.go(n);
    }
  };
  return history;
}
//#endregion

var ResultType;
(function (ResultType) {
  ResultType["data"] = "data";
  ResultType["deferred"] = "deferred";
  ResultType["redirect"] = "redirect";
  ResultType["error"] = "error";
})(ResultType || (ResultType = {}));
const immutableRouteKeys = new Set(["lazy", "caseSensitive", "path", "id", "index", "children"]);
function isIndexRoute(route) {
  return route.index === true;
}
// Walk the route tree generating unique IDs where necessary, so we are working
// solely with AgnosticDataRouteObject's within the Router
function convertRoutesToDataRoutes(routes, mapRouteProperties, parentPath, manifest) {
  if (parentPath === void 0) {
    parentPath = [];
  }
  if (manifest === void 0) {
    manifest = {};
  }
  return routes.map((route, index) => {
    let treePath = [...parentPath, String(index)];
    let id = typeof route.id === "string" ? route.id : treePath.join("-");
    invariant(route.index !== true || !route.children, "Cannot specify children on an index route");
    invariant(!manifest[id], "Found a route id collision on id \"" + id + "\".  Route " + "id's must be globally unique within Data Router usages");
    if (isIndexRoute(route)) {
      let indexRoute = _extends({}, route, mapRouteProperties(route), {
        id
      });
      manifest[id] = indexRoute;
      return indexRoute;
    } else {
      let pathOrLayoutRoute = _extends({}, route, mapRouteProperties(route), {
        id,
        children: undefined
      });
      manifest[id] = pathOrLayoutRoute;
      if (route.children) {
        pathOrLayoutRoute.children = convertRoutesToDataRoutes(route.children, mapRouteProperties, treePath, manifest);
      }
      return pathOrLayoutRoute;
    }
  });
}
/**
 * Matches the given routes to a location and returns the match data.
 *
 * @see https://reactrouter.com/v6/utils/match-routes
 */
function matchRoutes(routes, locationArg, basename) {
  if (basename === void 0) {
    basename = "/";
  }
  return matchRoutesImpl(routes, locationArg, basename, false);
}
function matchRoutesImpl(routes, locationArg, basename, allowPartial) {
  let location = typeof locationArg === "string" ? parsePath(locationArg) : locationArg;
  let pathname = stripBasename(location.pathname || "/", basename);
  if (pathname == null) {
    return null;
  }
  let branches = flattenRoutes(routes);
  rankRouteBranches(branches);
  let matches = null;
  for (let i = 0; matches == null && i < branches.length; ++i) {
    // Incoming pathnames are generally encoded from either window.location
    // or from router.navigate, but we want to match against the unencoded
    // paths in the route definitions.  Memory router locations won't be
    // encoded here but there also shouldn't be anything to decode so this
    // should be a safe operation.  This avoids needing matchRoutes to be
    // history-aware.
    let decoded = decodePath(pathname);
    matches = matchRouteBranch(branches[i], decoded, allowPartial);
  }
  return matches;
}
function convertRouteMatchToUiMatch(match, loaderData) {
  let {
    route,
    pathname,
    params
  } = match;
  return {
    id: route.id,
    pathname,
    params,
    data: loaderData[route.id],
    handle: route.handle
  };
}
function flattenRoutes(routes, branches, parentsMeta, parentPath) {
  if (branches === void 0) {
    branches = [];
  }
  if (parentsMeta === void 0) {
    parentsMeta = [];
  }
  if (parentPath === void 0) {
    parentPath = "";
  }
  let flattenRoute = (route, index, relativePath) => {
    let meta = {
      relativePath: relativePath === undefined ? route.path || "" : relativePath,
      caseSensitive: route.caseSensitive === true,
      childrenIndex: index,
      route
    };
    if (meta.relativePath.startsWith("/")) {
      invariant(meta.relativePath.startsWith(parentPath), "Absolute route path \"" + meta.relativePath + "\" nested under path " + ("\"" + parentPath + "\" is not valid. An absolute child route path ") + "must start with the combined path of all its parent routes.");
      meta.relativePath = meta.relativePath.slice(parentPath.length);
    }
    let path = joinPaths([parentPath, meta.relativePath]);
    let routesMeta = parentsMeta.concat(meta);
    // Add the children before adding this route to the array, so we traverse the
    // route tree depth-first and child routes appear before their parents in
    // the "flattened" version.
    if (route.children && route.children.length > 0) {
      invariant(
      // Our types know better, but runtime JS may not!
      // @ts-expect-error
      route.index !== true, "Index routes must not have child routes. Please remove " + ("all child routes from route path \"" + path + "\"."));
      flattenRoutes(route.children, branches, routesMeta, path);
    }
    // Routes without a path shouldn't ever match by themselves unless they are
    // index routes, so don't add them to the list of possible branches.
    if (route.path == null && !route.index) {
      return;
    }
    branches.push({
      path,
      score: computeScore(path, route.index),
      routesMeta
    });
  };
  routes.forEach((route, index) => {
    var _route$path;
    // coarse-grain check for optional params
    if (route.path === "" || !((_route$path = route.path) != null && _route$path.includes("?"))) {
      flattenRoute(route, index);
    } else {
      for (let exploded of explodeOptionalSegments(route.path)) {
        flattenRoute(route, index, exploded);
      }
    }
  });
  return branches;
}
/**
 * Computes all combinations of optional path segments for a given path,
 * excluding combinations that are ambiguous and of lower priority.
 *
 * For example, `/one/:two?/three/:four?/:five?` explodes to:
 * - `/one/three`
 * - `/one/:two/three`
 * - `/one/three/:four`
 * - `/one/three/:five`
 * - `/one/:two/three/:four`
 * - `/one/:two/three/:five`
 * - `/one/three/:four/:five`
 * - `/one/:two/three/:four/:five`
 */
function explodeOptionalSegments(path) {
  let segments = path.split("/");
  if (segments.length === 0) return [];
  let [first, ...rest] = segments;
  // Optional path segments are denoted by a trailing `?`
  let isOptional = first.endsWith("?");
  // Compute the corresponding required segment: `foo?` -> `foo`
  let required = first.replace(/\?$/, "");
  if (rest.length === 0) {
    // Intepret empty string as omitting an optional segment
    // `["one", "", "three"]` corresponds to omitting `:two` from `/one/:two?/three` -> `/one/three`
    return isOptional ? [required, ""] : [required];
  }
  let restExploded = explodeOptionalSegments(rest.join("/"));
  let result = [];
  // All child paths with the prefix.  Do this for all children before the
  // optional version for all children, so we get consistent ordering where the
  // parent optional aspect is preferred as required.  Otherwise, we can get
  // child sections interspersed where deeper optional segments are higher than
  // parent optional segments, where for example, /:two would explode _earlier_
  // then /:one.  By always including the parent as required _for all children_
  // first, we avoid this issue
  result.push(...restExploded.map(subpath => subpath === "" ? required : [required, subpath].join("/")));
  // Then, if this is an optional value, add all child versions without
  if (isOptional) {
    result.push(...restExploded);
  }
  // for absolute paths, ensure `/` instead of empty segment
  return result.map(exploded => path.startsWith("/") && exploded === "" ? "/" : exploded);
}
function rankRouteBranches(branches) {
  branches.sort((a, b) => a.score !== b.score ? b.score - a.score // Higher score first
  : compareIndexes(a.routesMeta.map(meta => meta.childrenIndex), b.routesMeta.map(meta => meta.childrenIndex)));
}
const paramRe = /^:[\w-]+$/;
const dynamicSegmentValue = 3;
const indexRouteValue = 2;
const emptySegmentValue = 1;
const staticSegmentValue = 10;
const splatPenalty = -2;
const isSplat = s => s === "*";
function computeScore(path, index) {
  let segments = path.split("/");
  let initialScore = segments.length;
  if (segments.some(isSplat)) {
    initialScore += splatPenalty;
  }
  if (index) {
    initialScore += indexRouteValue;
  }
  return segments.filter(s => !isSplat(s)).reduce((score, segment) => score + (paramRe.test(segment) ? dynamicSegmentValue : segment === "" ? emptySegmentValue : staticSegmentValue), initialScore);
}
function compareIndexes(a, b) {
  let siblings = a.length === b.length && a.slice(0, -1).every((n, i) => n === b[i]);
  return siblings ?
  // If two routes are siblings, we should try to match the earlier sibling
  // first. This allows people to have fine-grained control over the matching
  // behavior by simply putting routes with identical paths in the order they
  // want them tried.
  a[a.length - 1] - b[b.length - 1] :
  // Otherwise, it doesn't really make sense to rank non-siblings by index,
  // so they sort equally.
  0;
}
function matchRouteBranch(branch, pathname, allowPartial) {
  if (allowPartial === void 0) {
    allowPartial = false;
  }
  let {
    routesMeta
  } = branch;
  let matchedParams = {};
  let matchedPathname = "/";
  let matches = [];
  for (let i = 0; i < routesMeta.length; ++i) {
    let meta = routesMeta[i];
    let end = i === routesMeta.length - 1;
    let remainingPathname = matchedPathname === "/" ? pathname : pathname.slice(matchedPathname.length) || "/";
    let match = matchPath({
      path: meta.relativePath,
      caseSensitive: meta.caseSensitive,
      end
    }, remainingPathname);
    let route = meta.route;
    if (!match && end && allowPartial && !routesMeta[routesMeta.length - 1].route.index) {
      match = matchPath({
        path: meta.relativePath,
        caseSensitive: meta.caseSensitive,
        end: false
      }, remainingPathname);
    }
    if (!match) {
      return null;
    }
    Object.assign(matchedParams, match.params);
    matches.push({
      // TODO: Can this as be avoided?
      params: matchedParams,
      pathname: joinPaths([matchedPathname, match.pathname]),
      pathnameBase: normalizePathname(joinPaths([matchedPathname, match.pathnameBase])),
      route
    });
    if (match.pathnameBase !== "/") {
      matchedPathname = joinPaths([matchedPathname, match.pathnameBase]);
    }
  }
  return matches;
}
/**
 * Returns a path with params interpolated.
 *
 * @see https://reactrouter.com/v6/utils/generate-path
 */
function generatePath(originalPath, params) {
  if (params === void 0) {
    params = {};
  }
  let path = originalPath;
  if (path.endsWith("*") && path !== "*" && !path.endsWith("/*")) {
    warning(false, "Route path \"" + path + "\" will be treated as if it were " + ("\"" + path.replace(/\*$/, "/*") + "\" because the `*` character must ") + "always follow a `/` in the pattern. To get rid of this warning, " + ("please change the route path to \"" + path.replace(/\*$/, "/*") + "\"."));
    path = path.replace(/\*$/, "/*");
  }
  // ensure `/` is added at the beginning if the path is absolute
  const prefix = path.startsWith("/") ? "/" : "";
  const stringify = p => p == null ? "" : typeof p === "string" ? p : String(p);
  const segments = path.split(/\/+/).map((segment, index, array) => {
    const isLastSegment = index === array.length - 1;
    // only apply the splat if it's the last segment
    if (isLastSegment && segment === "*") {
      const star = "*";
      // Apply the splat
      return stringify(params[star]);
    }
    const keyMatch = segment.match(/^:([\w-]+)(\??)$/);
    if (keyMatch) {
      const [, key, optional] = keyMatch;
      let param = params[key];
      invariant(optional === "?" || param != null, "Missing \":" + key + "\" param");
      return stringify(param);
    }
    // Remove any optional markers from optional static segments
    return segment.replace(/\?$/g, "");
  })
  // Remove empty segments
  .filter(segment => !!segment);
  return prefix + segments.join("/");
}
/**
 * Performs pattern matching on a URL pathname and returns information about
 * the match.
 *
 * @see https://reactrouter.com/v6/utils/match-path
 */
function matchPath(pattern, pathname) {
  if (typeof pattern === "string") {
    pattern = {
      path: pattern,
      caseSensitive: false,
      end: true
    };
  }
  let [matcher, compiledParams] = compilePath(pattern.path, pattern.caseSensitive, pattern.end);
  let match = pathname.match(matcher);
  if (!match) return null;
  let matchedPathname = match[0];
  let pathnameBase = matchedPathname.replace(/(.)\/+$/, "$1");
  let captureGroups = match.slice(1);
  let params = compiledParams.reduce((memo, _ref, index) => {
    let {
      paramName,
      isOptional
    } = _ref;
    // We need to compute the pathnameBase here using the raw splat value
    // instead of using params["*"] later because it will be decoded then
    if (paramName === "*") {
      let splatValue = captureGroups[index] || "";
      pathnameBase = matchedPathname.slice(0, matchedPathname.length - splatValue.length).replace(/(.)\/+$/, "$1");
    }
    const value = captureGroups[index];
    if (isOptional && !value) {
      memo[paramName] = undefined;
    } else {
      memo[paramName] = (value || "").replace(/%2F/g, "/");
    }
    return memo;
  }, {});
  return {
    params,
    pathname: matchedPathname,
    pathnameBase,
    pattern
  };
}
function compilePath(path, caseSensitive, end) {
  if (caseSensitive === void 0) {
    caseSensitive = false;
  }
  if (end === void 0) {
    end = true;
  }
  warning(path === "*" || !path.endsWith("*") || path.endsWith("/*"), "Route path \"" + path + "\" will be treated as if it were " + ("\"" + path.replace(/\*$/, "/*") + "\" because the `*` character must ") + "always follow a `/` in the pattern. To get rid of this warning, " + ("please change the route path to \"" + path.replace(/\*$/, "/*") + "\"."));
  let params = [];
  let regexpSource = "^" + path.replace(/\/*\*?$/, "") // Ignore trailing / and /*, we'll handle it below
  .replace(/^\/*/, "/") // Make sure it has a leading /
  .replace(/[\\.*+^${}|()[\]]/g, "\\$&") // Escape special regex chars
  .replace(/\/:([\w-]+)(\?)?/g, (_, paramName, isOptional) => {
    params.push({
      paramName,
      isOptional: isOptional != null
    });
    return isOptional ? "/?([^\\/]+)?" : "/([^\\/]+)";
  });
  if (path.endsWith("*")) {
    params.push({
      paramName: "*"
    });
    regexpSource += path === "*" || path === "/*" ? "(.*)$" // Already matched the initial /, just match the rest
    : "(?:\\/(.+)|\\/*)$"; // Don't include the / in params["*"]
  } else if (end) {
    // When matching to the end, ignore trailing slashes
    regexpSource += "\\/*$";
  } else if (path !== "" && path !== "/") {
    // If our path is non-empty and contains anything beyond an initial slash,
    // then we have _some_ form of path in our regex, so we should expect to
    // match only if we find the end of this path segment.  Look for an optional
    // non-captured trailing slash (to match a portion of the URL) or the end
    // of the path (if we've matched to the end).  We used to do this with a
    // word boundary but that gives false positives on routes like
    // /user-preferences since `-` counts as a word boundary.
    regexpSource += "(?:(?=\\/|$))";
  } else ;
  let matcher = new RegExp(regexpSource, caseSensitive ? undefined : "i");
  return [matcher, params];
}
function decodePath(value) {
  try {
    return value.split("/").map(v => decodeURIComponent(v).replace(/\//g, "%2F")).join("/");
  } catch (error) {
    warning(false, "The URL path \"" + value + "\" could not be decoded because it is is a " + "malformed URL segment. This is probably due to a bad percent " + ("encoding (" + error + ")."));
    return value;
  }
}
/**
 * @private
 */
function stripBasename(pathname, basename) {
  if (basename === "/") return pathname;
  if (!pathname.toLowerCase().startsWith(basename.toLowerCase())) {
    return null;
  }
  // We want to leave trailing slash behavior in the user's control, so if they
  // specify a basename with a trailing slash, we should support it
  let startIndex = basename.endsWith("/") ? basename.length - 1 : basename.length;
  let nextChar = pathname.charAt(startIndex);
  if (nextChar && nextChar !== "/") {
    // pathname does not start with basename/
    return null;
  }
  return pathname.slice(startIndex) || "/";
}
const ABSOLUTE_URL_REGEX$1 = /^(?:[a-z][a-z0-9+.-]*:|\/\/)/i;
const isAbsoluteUrl = url => ABSOLUTE_URL_REGEX$1.test(url);
/**
 * Returns a resolved path object relative to the given pathname.
 *
 * @see https://reactrouter.com/v6/utils/resolve-path
 */
function resolvePath(to, fromPathname) {
  if (fromPathname === void 0) {
    fromPathname = "/";
  }
  let {
    pathname: toPathname,
    search = "",
    hash = ""
  } = typeof to === "string" ? parsePath(to) : to;
  let pathname;
  if (toPathname) {
    if (isAbsoluteUrl(toPathname)) {
      pathname = toPathname;
    } else {
      if (toPathname.includes("//")) {
        let oldPathname = toPathname;
        toPathname = toPathname.replace(/\/\/+/g, "/");
        warning(false, "Pathnames cannot have embedded double slashes - normalizing " + (oldPathname + " -> " + toPathname));
      }
      if (toPathname.startsWith("/")) {
        pathname = resolvePathname(toPathname.substring(1), "/");
      } else {
        pathname = resolvePathname(toPathname, fromPathname);
      }
    }
  } else {
    pathname = fromPathname;
  }
  return {
    pathname,
    search: normalizeSearch(search),
    hash: normalizeHash(hash)
  };
}
function resolvePathname(relativePath, fromPathname) {
  let segments = fromPathname.replace(/\/+$/, "").split("/");
  let relativeSegments = relativePath.split("/");
  relativeSegments.forEach(segment => {
    if (segment === "..") {
      // Keep the root "" segment so the pathname starts at /
      if (segments.length > 1) segments.pop();
    } else if (segment !== ".") {
      segments.push(segment);
    }
  });
  return segments.length > 1 ? segments.join("/") : "/";
}
function getInvalidPathError(char, field, dest, path) {
  return "Cannot include a '" + char + "' character in a manually specified " + ("`to." + field + "` field [" + JSON.stringify(path) + "].  Please separate it out to the ") + ("`to." + dest + "` field. Alternatively you may provide the full path as ") + "a string in <Link to=\"...\"> and the router will parse it for you.";
}
/**
 * @private
 *
 * When processing relative navigation we want to ignore ancestor routes that
 * do not contribute to the path, such that index/pathless layout routes don't
 * interfere.
 *
 * For example, when moving a route element into an index route and/or a
 * pathless layout route, relative link behavior contained within should stay
 * the same.  Both of the following examples should link back to the root:
 *
 *   <Route path="/">
 *     <Route path="accounts" element={<Link to=".."}>
 *   </Route>
 *
 *   <Route path="/">
 *     <Route path="accounts">
 *       <Route element={<AccountsLayout />}>       // <-- Does not contribute
 *         <Route index element={<Link to=".."} />  // <-- Does not contribute
 *       </Route
 *     </Route>
 *   </Route>
 */
function getPathContributingMatches(matches) {
  return matches.filter((match, index) => index === 0 || match.route.path && match.route.path.length > 0);
}
// Return the array of pathnames for the current route matches - used to
// generate the routePathnames input for resolveTo()
function getResolveToMatches(matches, v7_relativeSplatPath) {
  let pathMatches = getPathContributingMatches(matches);
  // When v7_relativeSplatPath is enabled, use the full pathname for the leaf
  // match so we include splat values for "." links.  See:
  // https://github.com/remix-run/react-router/issues/11052#issuecomment-1836589329
  if (v7_relativeSplatPath) {
    return pathMatches.map((match, idx) => idx === pathMatches.length - 1 ? match.pathname : match.pathnameBase);
  }
  return pathMatches.map(match => match.pathnameBase);
}
/**
 * @private
 */
function resolveTo(toArg, routePathnames, locationPathname, isPathRelative) {
  if (isPathRelative === void 0) {
    isPathRelative = false;
  }
  let to;
  if (typeof toArg === "string") {
    to = parsePath(toArg);
  } else {
    to = _extends({}, toArg);
    invariant(!to.pathname || !to.pathname.includes("?"), getInvalidPathError("?", "pathname", "search", to));
    invariant(!to.pathname || !to.pathname.includes("#"), getInvalidPathError("#", "pathname", "hash", to));
    invariant(!to.search || !to.search.includes("#"), getInvalidPathError("#", "search", "hash", to));
  }
  let isEmptyPath = toArg === "" || to.pathname === "";
  let toPathname = isEmptyPath ? "/" : to.pathname;
  let from;
  // Routing is relative to the current pathname if explicitly requested.
  //
  // If a pathname is explicitly provided in `to`, it should be relative to the
  // route context. This is explained in `Note on `<Link to>` values` in our
  // migration guide from v5 as a means of disambiguation between `to` values
  // that begin with `/` and those that do not. However, this is problematic for
  // `to` values that do not provide a pathname. `to` can simply be a search or
  // hash string, in which case we should assume that the navigation is relative
  // to the current location's pathname and *not* the route pathname.
  if (toPathname == null) {
    from = locationPathname;
  } else {
    let routePathnameIndex = routePathnames.length - 1;
    // With relative="route" (the default), each leading .. segment means
    // "go up one route" instead of "go up one URL segment".  This is a key
    // difference from how <a href> works and a major reason we call this a
    // "to" value instead of a "href".
    if (!isPathRelative && toPathname.startsWith("..")) {
      let toSegments = toPathname.split("/");
      while (toSegments[0] === "..") {
        toSegments.shift();
        routePathnameIndex -= 1;
      }
      to.pathname = toSegments.join("/");
    }
    from = routePathnameIndex >= 0 ? routePathnames[routePathnameIndex] : "/";
  }
  let path = resolvePath(to, from);
  // Ensure the pathname has a trailing slash if the original "to" had one
  let hasExplicitTrailingSlash = toPathname && toPathname !== "/" && toPathname.endsWith("/");
  // Or if this was a link to the current path which has a trailing slash
  let hasCurrentTrailingSlash = (isEmptyPath || toPathname === ".") && locationPathname.endsWith("/");
  if (!path.pathname.endsWith("/") && (hasExplicitTrailingSlash || hasCurrentTrailingSlash)) {
    path.pathname += "/";
  }
  return path;
}
/**
 * @private
 */
function getToPathname(to) {
  // Empty strings should be treated the same as / paths
  return to === "" || to.pathname === "" ? "/" : typeof to === "string" ? parsePath(to).pathname : to.pathname;
}
/**
 * @private
 */
const joinPaths = paths => paths.join("/").replace(/\/\/+/g, "/");
/**
 * @private
 */
const normalizePathname = pathname => pathname.replace(/\/+$/, "").replace(/^\/*/, "/");
/**
 * @private
 */
const normalizeSearch = search => !search || search === "?" ? "" : search.startsWith("?") ? search : "?" + search;
/**
 * @private
 */
const normalizeHash = hash => !hash || hash === "#" ? "" : hash.startsWith("#") ? hash : "#" + hash;
/**
 * This is a shortcut for creating `application/json` responses. Converts `data`
 * to JSON and sets the `Content-Type` header.
 *
 * @deprecated The `json` method is deprecated in favor of returning raw objects.
 * This method will be removed in v7.
 */
const json = function json(data, init) {
  if (init === void 0) {
    init = {};
  }
  let responseInit = typeof init === "number" ? {
    status: init
  } : init;
  let headers = new Headers(responseInit.headers);
  if (!headers.has("Content-Type")) {
    headers.set("Content-Type", "application/json; charset=utf-8");
  }
  return new Response(JSON.stringify(data), _extends({}, responseInit, {
    headers
  }));
};
class DataWithResponseInit {
  constructor(data, init) {
    this.type = "DataWithResponseInit";
    this.data = data;
    this.init = init || null;
  }
}
/**
 * Create "responses" that contain `status`/`headers` without forcing
 * serialization into an actual `Response` - used by Remix single fetch
 */
function data(data, init) {
  return new DataWithResponseInit(data, typeof init === "number" ? {
    status: init
  } : init);
}
class AbortedDeferredError extends Error {}
class DeferredData {
  constructor(data, responseInit) {
    this.pendingKeysSet = new Set();
    this.subscribers = new Set();
    this.deferredKeys = [];
    invariant(data && typeof data === "object" && !Array.isArray(data), "defer() only accepts plain objects");
    // Set up an AbortController + Promise we can race against to exit early
    // cancellation
    let reject;
    this.abortPromise = new Promise((_, r) => reject = r);
    this.controller = new AbortController();
    let onAbort = () => reject(new AbortedDeferredError("Deferred data aborted"));
    this.unlistenAbortSignal = () => this.controller.signal.removeEventListener("abort", onAbort);
    this.controller.signal.addEventListener("abort", onAbort);
    this.data = Object.entries(data).reduce((acc, _ref2) => {
      let [key, value] = _ref2;
      return Object.assign(acc, {
        [key]: this.trackPromise(key, value)
      });
    }, {});
    if (this.done) {
      // All incoming values were resolved
      this.unlistenAbortSignal();
    }
    this.init = responseInit;
  }
  trackPromise(key, value) {
    if (!(value instanceof Promise)) {
      return value;
    }
    this.deferredKeys.push(key);
    this.pendingKeysSet.add(key);
    // We store a little wrapper promise that will be extended with
    // _data/_error props upon resolve/reject
    let promise = Promise.race([value, this.abortPromise]).then(data => this.onSettle(promise, key, undefined, data), error => this.onSettle(promise, key, error));
    // Register rejection listeners to avoid uncaught promise rejections on
    // errors or aborted deferred values
    promise.catch(() => {});
    Object.defineProperty(promise, "_tracked", {
      get: () => true
    });
    return promise;
  }
  onSettle(promise, key, error, data) {
    if (this.controller.signal.aborted && error instanceof AbortedDeferredError) {
      this.unlistenAbortSignal();
      Object.defineProperty(promise, "_error", {
        get: () => error
      });
      return Promise.reject(error);
    }
    this.pendingKeysSet.delete(key);
    if (this.done) {
      // Nothing left to abort!
      this.unlistenAbortSignal();
    }
    // If the promise was resolved/rejected with undefined, we'll throw an error as you
    // should always resolve with a value or null
    if (error === undefined && data === undefined) {
      let undefinedError = new Error("Deferred data for key \"" + key + "\" resolved/rejected with `undefined`, " + "you must resolve/reject with a value or `null`.");
      Object.defineProperty(promise, "_error", {
        get: () => undefinedError
      });
      this.emit(false, key);
      return Promise.reject(undefinedError);
    }
    if (data === undefined) {
      Object.defineProperty(promise, "_error", {
        get: () => error
      });
      this.emit(false, key);
      return Promise.reject(error);
    }
    Object.defineProperty(promise, "_data", {
      get: () => data
    });
    this.emit(false, key);
    return data;
  }
  emit(aborted, settledKey) {
    this.subscribers.forEach(subscriber => subscriber(aborted, settledKey));
  }
  subscribe(fn) {
    this.subscribers.add(fn);
    return () => this.subscribers.delete(fn);
  }
  cancel() {
    this.controller.abort();
    this.pendingKeysSet.forEach((v, k) => this.pendingKeysSet.delete(k));
    this.emit(true);
  }
  async resolveData(signal) {
    let aborted = false;
    if (!this.done) {
      let onAbort = () => this.cancel();
      signal.addEventListener("abort", onAbort);
      aborted = await new Promise(resolve => {
        this.subscribe(aborted => {
          signal.removeEventListener("abort", onAbort);
          if (aborted || this.done) {
            resolve(aborted);
          }
        });
      });
    }
    return aborted;
  }
  get done() {
    return this.pendingKeysSet.size === 0;
  }
  get unwrappedData() {
    invariant(this.data !== null && this.done, "Can only unwrap data on initialized and settled deferreds");
    return Object.entries(this.data).reduce((acc, _ref3) => {
      let [key, value] = _ref3;
      return Object.assign(acc, {
        [key]: unwrapTrackedPromise(value)
      });
    }, {});
  }
  get pendingKeys() {
    return Array.from(this.pendingKeysSet);
  }
}
function isTrackedPromise(value) {
  return value instanceof Promise && value._tracked === true;
}
function unwrapTrackedPromise(value) {
  if (!isTrackedPromise(value)) {
    return value;
  }
  if (value._error) {
    throw value._error;
  }
  return value._data;
}
/**
 * @deprecated The `defer` method is deprecated in favor of returning raw
 * objects. This method will be removed in v7.
 */
const defer = function defer(data, init) {
  if (init === void 0) {
    init = {};
  }
  let responseInit = typeof init === "number" ? {
    status: init
  } : init;
  return new DeferredData(data, responseInit);
};
/**
 * A redirect response. Sets the status code and the `Location` header.
 * Defaults to "302 Found".
 */
const redirect = function redirect(url, init) {
  if (init === void 0) {
    init = 302;
  }
  let responseInit = init;
  if (typeof responseInit === "number") {
    responseInit = {
      status: responseInit
    };
  } else if (typeof responseInit.status === "undefined") {
    responseInit.status = 302;
  }
  let headers = new Headers(responseInit.headers);
  headers.set("Location", url);
  return new Response(null, _extends({}, responseInit, {
    headers
  }));
};
/**
 * A redirect response that will force a document reload to the new location.
 * Sets the status code and the `Location` header.
 * Defaults to "302 Found".
 */
const redirectDocument = (url, init) => {
  let response = redirect(url, init);
  response.headers.set("X-Remix-Reload-Document", "true");
  return response;
};
/**
 * A redirect response that will perform a `history.replaceState` instead of a
 * `history.pushState` for client-side navigation redirects.
 * Sets the status code and the `Location` header.
 * Defaults to "302 Found".
 */
const replace = (url, init) => {
  let response = redirect(url, init);
  response.headers.set("X-Remix-Replace", "true");
  return response;
};
/**
 * @private
 * Utility class we use to hold auto-unwrapped 4xx/5xx Response bodies
 *
 * We don't export the class for public use since it's an implementation
 * detail, but we export the interface above so folks can build their own
 * abstractions around instances via isRouteErrorResponse()
 */
class ErrorResponseImpl {
  constructor(status, statusText, data, internal) {
    if (internal === void 0) {
      internal = false;
    }
    this.status = status;
    this.statusText = statusText || "";
    this.internal = internal;
    if (data instanceof Error) {
      this.data = data.toString();
      this.error = data;
    } else {
      this.data = data;
    }
  }
}
/**
 * Check if the given error is an ErrorResponse generated from a 4xx/5xx
 * Response thrown from an action/loader
 */
function isRouteErrorResponse(error) {
  return error != null && typeof error.status === "number" && typeof error.statusText === "string" && typeof error.internal === "boolean" && "data" in error;
}

const validMutationMethodsArr = ["post", "put", "patch", "delete"];
const validMutationMethods = new Set(validMutationMethodsArr);
const validRequestMethodsArr = ["get", ...validMutationMethodsArr];
const validRequestMethods = new Set(validRequestMethodsArr);
const redirectStatusCodes = new Set([301, 302, 303, 307, 308]);
const redirectPreserveMethodStatusCodes = new Set([307, 308]);
const IDLE_NAVIGATION = {
  state: "idle",
  location: undefined,
  formMethod: undefined,
  formAction: undefined,
  formEncType: undefined,
  formData: undefined,
  json: undefined,
  text: undefined
};
const IDLE_FETCHER = {
  state: "idle",
  data: undefined,
  formMethod: undefined,
  formAction: undefined,
  formEncType: undefined,
  formData: undefined,
  json: undefined,
  text: undefined
};
const IDLE_BLOCKER = {
  state: "unblocked",
  proceed: undefined,
  reset: undefined,
  location: undefined
};
const ABSOLUTE_URL_REGEX = /^(?:[a-z][a-z0-9+.-]*:|\/\/)/i;
const defaultMapRouteProperties = route => ({
  hasErrorBoundary: Boolean(route.hasErrorBoundary)
});
const TRANSITIONS_STORAGE_KEY = "remix-router-transitions";
//#endregion
////////////////////////////////////////////////////////////////////////////////
//#region createRouter
////////////////////////////////////////////////////////////////////////////////
/**
 * Create a router and listen to history POP navigations
 */
function createRouter(init) {
  const routerWindow = init.window ? init.window : typeof window !== "undefined" ? window : undefined;
  const isBrowser = typeof routerWindow !== "undefined" && typeof routerWindow.document !== "undefined" && typeof routerWindow.document.createElement !== "undefined";
  const isServer = !isBrowser;
  invariant(init.routes.length > 0, "You must provide a non-empty routes array to createRouter");
  let mapRouteProperties;
  if (init.mapRouteProperties) {
    mapRouteProperties = init.mapRouteProperties;
  } else if (init.detectErrorBoundary) {
    // If they are still using the deprecated version, wrap it with the new API
    let detectErrorBoundary = init.detectErrorBoundary;
    mapRouteProperties = route => ({
      hasErrorBoundary: detectErrorBoundary(route)
    });
  } else {
    mapRouteProperties = defaultMapRouteProperties;
  }
  // Routes keyed by ID
  let manifest = {};
  // Routes in tree format for matching
  let dataRoutes = convertRoutesToDataRoutes(init.routes, mapRouteProperties, undefined, manifest);
  let inFlightDataRoutes;
  let basename = init.basename || "/";
  let dataStrategyImpl = init.dataStrategy || defaultDataStrategy;
  let patchRoutesOnNavigationImpl = init.patchRoutesOnNavigation;
  // Config driven behavior flags
  let future = _extends({
    v7_fetcherPersist: false,
    v7_normalizeFormMethod: false,
    v7_partialHydration: false,
    v7_prependBasename: false,
    v7_relativeSplatPath: false,
    v7_skipActionErrorRevalidation: false
  }, init.future);
  // Cleanup function for history
  let unlistenHistory = null;
  // Externally-provided functions to call on all state changes
  let subscribers = new Set();
  // Externally-provided object to hold scroll restoration locations during routing
  let savedScrollPositions = null;
  // Externally-provided function to get scroll restoration keys
  let getScrollRestorationKey = null;
  // Externally-provided function to get current scroll position
  let getScrollPosition = null;
  // One-time flag to control the initial hydration scroll restoration.  Because
  // we don't get the saved positions from <ScrollRestoration /> until _after_
  // the initial render, we need to manually trigger a separate updateState to
  // send along the restoreScrollPosition
  // Set to true if we have `hydrationData` since we assume we were SSR'd and that
  // SSR did the initial scroll restoration.
  let initialScrollRestored = init.hydrationData != null;
  let initialMatches = matchRoutes(dataRoutes, init.history.location, basename);
  let initialMatchesIsFOW = false;
  let initialErrors = null;
  if (initialMatches == null && !patchRoutesOnNavigationImpl) {
    // If we do not match a user-provided-route, fall back to the root
    // to allow the error boundary to take over
    let error = getInternalRouterError(404, {
      pathname: init.history.location.pathname
    });
    let {
      matches,
      route
    } = getShortCircuitMatches(dataRoutes);
    initialMatches = matches;
    initialErrors = {
      [route.id]: error
    };
  }
  // In SPA apps, if the user provided a patchRoutesOnNavigation implementation and
  // our initial match is a splat route, clear them out so we run through lazy
  // discovery on hydration in case there's a more accurate lazy route match.
  // In SSR apps (with `hydrationData`), we expect that the server will send
  // up the proper matched routes so we don't want to run lazy discovery on
  // initial hydration and want to hydrate into the splat route.
  if (initialMatches && !init.hydrationData) {
    let fogOfWar = checkFogOfWar(initialMatches, dataRoutes, init.history.location.pathname);
    if (fogOfWar.active) {
      initialMatches = null;
    }
  }
  let initialized;
  if (!initialMatches) {
    initialized = false;
    initialMatches = [];
    // If partial hydration and fog of war is enabled, we will be running
    // `patchRoutesOnNavigation` during hydration so include any partial matches as
    // the initial matches so we can properly render `HydrateFallback`'s
    if (future.v7_partialHydration) {
      let fogOfWar = checkFogOfWar(null, dataRoutes, init.history.location.pathname);
      if (fogOfWar.active && fogOfWar.matches) {
        initialMatchesIsFOW = true;
        initialMatches = fogOfWar.matches;
      }
    }
  } else if (initialMatches.some(m => m.route.lazy)) {
    // All initialMatches need to be loaded before we're ready.  If we have lazy
    // functions around still then we'll need to run them in initialize()
    initialized = false;
  } else if (!initialMatches.some(m => m.route.loader)) {
    // If we've got no loaders to run, then we're good to go
    initialized = true;
  } else if (future.v7_partialHydration) {
    // If partial hydration is enabled, we're initialized so long as we were
    // provided with hydrationData for every route with a loader, and no loaders
    // were marked for explicit hydration
    let loaderData = init.hydrationData ? init.hydrationData.loaderData : null;
    let errors = init.hydrationData ? init.hydrationData.errors : null;
    // If errors exist, don't consider routes below the boundary
    if (errors) {
      let idx = initialMatches.findIndex(m => errors[m.route.id] !== undefined);
      initialized = initialMatches.slice(0, idx + 1).every(m => !shouldLoadRouteOnHydration(m.route, loaderData, errors));
    } else {
      initialized = initialMatches.every(m => !shouldLoadRouteOnHydration(m.route, loaderData, errors));
    }
  } else {
    // Without partial hydration - we're initialized if we were provided any
    // hydrationData - which is expected to be complete
    initialized = init.hydrationData != null;
  }
  let router;
  let state = {
    historyAction: init.history.action,
    location: init.history.location,
    matches: initialMatches,
    initialized,
    navigation: IDLE_NAVIGATION,
    // Don't restore on initial updateState() if we were SSR'd
    restoreScrollPosition: init.hydrationData != null ? false : null,
    preventScrollReset: false,
    revalidation: "idle",
    loaderData: init.hydrationData && init.hydrationData.loaderData || {},
    actionData: init.hydrationData && init.hydrationData.actionData || null,
    errors: init.hydrationData && init.hydrationData.errors || initialErrors,
    fetchers: new Map(),
    blockers: new Map()
  };
  // -- Stateful internal variables to manage navigations --
  // Current navigation in progress (to be committed in completeNavigation)
  let pendingAction = Action.Pop;
  // Should the current navigation prevent the scroll reset if scroll cannot
  // be restored?
  let pendingPreventScrollReset = false;
  // AbortController for the active navigation
  let pendingNavigationController;
  // Should the current navigation enable document.startViewTransition?
  let pendingViewTransitionEnabled = false;
  // Store applied view transitions so we can apply them on POP
  let appliedViewTransitions = new Map();
  // Cleanup function for persisting applied transitions to sessionStorage
  let removePageHideEventListener = null;
  // We use this to avoid touching history in completeNavigation if a
  // revalidation is entirely uninterrupted
  let isUninterruptedRevalidation = false;
  // Use this internal flag to force revalidation of all loaders:
  //  - submissions (completed or interrupted)
  //  - useRevalidator()
  //  - X-Remix-Revalidate (from redirect)
  let isRevalidationRequired = false;
  // Use this internal array to capture routes that require revalidation due
  // to a cancelled deferred on action submission
  let cancelledDeferredRoutes = [];
  // Use this internal array to capture fetcher loads that were cancelled by an
  // action navigation and require revalidation
  let cancelledFetcherLoads = new Set();
  // AbortControllers for any in-flight fetchers
  let fetchControllers = new Map();
  // Track loads based on the order in which they started
  let incrementingLoadId = 0;
  // Track the outstanding pending navigation data load to be compared against
  // the globally incrementing load when a fetcher load lands after a completed
  // navigation
  let pendingNavigationLoadId = -1;
  // Fetchers that triggered data reloads as a result of their actions
  let fetchReloadIds = new Map();
  // Fetchers that triggered redirect navigations
  let fetchRedirectIds = new Set();
  // Most recent href/match for fetcher.load calls for fetchers
  let fetchLoadMatches = new Map();
  // Ref-count mounted fetchers so we know when it's ok to clean them up
  let activeFetchers = new Map();
  // Fetchers that have requested a delete when using v7_fetcherPersist,
  // they'll be officially removed after they return to idle
  let deletedFetchers = new Set();
  // Store DeferredData instances for active route matches.  When a
  // route loader returns defer() we stick one in here.  Then, when a nested
  // promise resolves we update loaderData.  If a new navigation starts we
  // cancel active deferreds for eliminated routes.
  let activeDeferreds = new Map();
  // Store blocker functions in a separate Map outside of router state since
  // we don't need to update UI state if they change
  let blockerFunctions = new Map();
  // Flag to ignore the next history update, so we can revert the URL change on
  // a POP navigation that was blocked by the user without touching router state
  let unblockBlockerHistoryUpdate = undefined;
  // Initialize the router, all side effects should be kicked off from here.
  // Implemented as a Fluent API for ease of:
  //   let router = createRouter(init).initialize();
  function initialize() {
    // If history informs us of a POP navigation, start the navigation but do not update
    // state.  We'll update our own state once the navigation completes
    unlistenHistory = init.history.listen(_ref => {
      let {
        action: historyAction,
        location,
        delta
      } = _ref;
      // Ignore this event if it was just us resetting the URL from a
      // blocked POP navigation
      if (unblockBlockerHistoryUpdate) {
        unblockBlockerHistoryUpdate();
        unblockBlockerHistoryUpdate = undefined;
        return;
      }
      warning(blockerFunctions.size === 0 || delta != null, "You are trying to use a blocker on a POP navigation to a location " + "that was not created by @remix-run/router. This will fail silently in " + "production. This can happen if you are navigating outside the router " + "via `window.history.pushState`/`window.location.hash` instead of using " + "router navigation APIs.  This can also happen if you are using " + "createHashRouter and the user manually changes the URL.");
      let blockerKey = shouldBlockNavigation({
        currentLocation: state.location,
        nextLocation: location,
        historyAction
      });
      if (blockerKey && delta != null) {
        // Restore the URL to match the current UI, but don't update router state
        let nextHistoryUpdatePromise = new Promise(resolve => {
          unblockBlockerHistoryUpdate = resolve;
        });
        init.history.go(delta * -1);
        // Put the blocker into a blocked state
        updateBlocker(blockerKey, {
          state: "blocked",
          location,
          proceed() {
            updateBlocker(blockerKey, {
              state: "proceeding",
              proceed: undefined,
              reset: undefined,
              location
            });
            // Re-do the same POP navigation we just blocked, after the url
            // restoration is also complete.  See:
            // https://github.com/remix-run/react-router/issues/11613
            nextHistoryUpdatePromise.then(() => init.history.go(delta));
          },
          reset() {
            let blockers = new Map(state.blockers);
            blockers.set(blockerKey, IDLE_BLOCKER);
            updateState({
              blockers
            });
          }
        });
        return;
      }
      return startNavigation(historyAction, location);
    });
    if (isBrowser) {
      // FIXME: This feels gross.  How can we cleanup the lines between
      // scrollRestoration/appliedTransitions persistance?
      restoreAppliedTransitions(routerWindow, appliedViewTransitions);
      let _saveAppliedTransitions = () => persistAppliedTransitions(routerWindow, appliedViewTransitions);
      routerWindow.addEventListener("pagehide", _saveAppliedTransitions);
      removePageHideEventListener = () => routerWindow.removeEventListener("pagehide", _saveAppliedTransitions);
    }
    // Kick off initial data load if needed.  Use Pop to avoid modifying history
    // Note we don't do any handling of lazy here.  For SPA's it'll get handled
    // in the normal navigation flow.  For SSR it's expected that lazy modules are
    // resolved prior to router creation since we can't go into a fallbackElement
    // UI for SSR'd apps
    if (!state.initialized) {
      startNavigation(Action.Pop, state.location, {
        initialHydration: true
      });
    }
    return router;
  }
  // Clean up a router and it's side effects
  function dispose() {
    if (unlistenHistory) {
      unlistenHistory();
    }
    if (removePageHideEventListener) {
      removePageHideEventListener();
    }
    subscribers.clear();
    pendingNavigationController && pendingNavigationController.abort();
    state.fetchers.forEach((_, key) => deleteFetcher(key));
    state.blockers.forEach((_, key) => deleteBlocker(key));
  }
  // Subscribe to state updates for the router
  function subscribe(fn) {
    subscribers.add(fn);
    return () => subscribers.delete(fn);
  }
  // Update our state and notify the calling context of the change
  function updateState(newState, opts) {
    if (opts === void 0) {
      opts = {};
    }
    state = _extends({}, state, newState);
    // Prep fetcher cleanup so we can tell the UI which fetcher data entries
    // can be removed
    let completedFetchers = [];
    let deletedFetchersKeys = [];
    if (future.v7_fetcherPersist) {
      state.fetchers.forEach((fetcher, key) => {
        if (fetcher.state === "idle") {
          if (deletedFetchers.has(key)) {
            // Unmounted from the UI and can be totally removed
            deletedFetchersKeys.push(key);
          } else {
            // Returned to idle but still mounted in the UI, so semi-remains for
            // revalidations and such
            completedFetchers.push(key);
          }
        }
      });
    }
    // Remove any lingering deleted fetchers that have already been removed
    // from state.fetchers
    deletedFetchers.forEach(key => {
      if (!state.fetchers.has(key) && !fetchControllers.has(key)) {
        deletedFetchersKeys.push(key);
      }
    });
    // Iterate over a local copy so that if flushSync is used and we end up
    // removing and adding a new subscriber due to the useCallback dependencies,
    // we don't get ourselves into a loop calling the new subscriber immediately
    [...subscribers].forEach(subscriber => subscriber(state, {
      deletedFetchers: deletedFetchersKeys,
      viewTransitionOpts: opts.viewTransitionOpts,
      flushSync: opts.flushSync === true
    }));
    // Remove idle fetchers from state since we only care about in-flight fetchers.
    if (future.v7_fetcherPersist) {
      completedFetchers.forEach(key => state.fetchers.delete(key));
      deletedFetchersKeys.forEach(key => deleteFetcher(key));
    } else {
      // We already called deleteFetcher() on these, can remove them from this
      // Set now that we've handed the keys off to the data layer
      deletedFetchersKeys.forEach(key => deletedFetchers.delete(key));
    }
  }
  // Complete a navigation returning the state.navigation back to the IDLE_NAVIGATION
  // and setting state.[historyAction/location/matches] to the new route.
  // - Location is a required param
  // - Navigation will always be set to IDLE_NAVIGATION
  // - Can pass any other state in newState
  function completeNavigation(location, newState, _temp) {
    var _location$state, _location$state2;
    let {
      flushSync
    } = _temp === void 0 ? {} : _temp;
    // Deduce if we're in a loading/actionReload state:
    // - We have committed actionData in the store
    // - The current navigation was a mutation submission
    // - We're past the submitting state and into the loading state
    // - The location being loaded is not the result of a redirect
    let isActionReload = state.actionData != null && state.navigation.formMethod != null && isMutationMethod(state.navigation.formMethod) && state.navigation.state === "loading" && ((_location$state = location.state) == null ? void 0 : _location$state._isRedirect) !== true;
    let actionData;
    if (newState.actionData) {
      if (Object.keys(newState.actionData).length > 0) {
        actionData = newState.actionData;
      } else {
        // Empty actionData -> clear prior actionData due to an action error
        actionData = null;
      }
    } else if (isActionReload) {
      // Keep the current data if we're wrapping up the action reload
      actionData = state.actionData;
    } else {
      // Clear actionData on any other completed navigations
      actionData = null;
    }
    // Always preserve any existing loaderData from re-used routes
    let loaderData = newState.loaderData ? mergeLoaderData(state.loaderData, newState.loaderData, newState.matches || [], newState.errors) : state.loaderData;
    // On a successful navigation we can assume we got through all blockers
    // so we can start fresh
    let blockers = state.blockers;
    if (blockers.size > 0) {
      blockers = new Map(blockers);
      blockers.forEach((_, k) => blockers.set(k, IDLE_BLOCKER));
    }
    // Always respect the user flag.  Otherwise don't reset on mutation
    // submission navigations unless they redirect
    let preventScrollReset = pendingPreventScrollReset === true || state.navigation.formMethod != null && isMutationMethod(state.navigation.formMethod) && ((_location$state2 = location.state) == null ? void 0 : _location$state2._isRedirect) !== true;
    // Commit any in-flight routes at the end of the HMR revalidation "navigation"
    if (inFlightDataRoutes) {
      dataRoutes = inFlightDataRoutes;
      inFlightDataRoutes = undefined;
    }
    if (isUninterruptedRevalidation) ; else if (pendingAction === Action.Pop) ; else if (pendingAction === Action.Push) {
      init.history.push(location, location.state);
    } else if (pendingAction === Action.Replace) {
      init.history.replace(location, location.state);
    }
    let viewTransitionOpts;
    // On POP, enable transitions if they were enabled on the original navigation
    if (pendingAction === Action.Pop) {
      // Forward takes precedence so they behave like the original navigation
      let priorPaths = appliedViewTransitions.get(state.location.pathname);
      if (priorPaths && priorPaths.has(location.pathname)) {
        viewTransitionOpts = {
          currentLocation: state.location,
          nextLocation: location
        };
      } else if (appliedViewTransitions.has(location.pathname)) {
        // If we don't have a previous forward nav, assume we're popping back to
        // the new location and enable if that location previously enabled
        viewTransitionOpts = {
          currentLocation: location,
          nextLocation: state.location
        };
      }
    } else if (pendingViewTransitionEnabled) {
      // Store the applied transition on PUSH/REPLACE
      let toPaths = appliedViewTransitions.get(state.location.pathname);
      if (toPaths) {
        toPaths.add(location.pathname);
      } else {
        toPaths = new Set([location.pathname]);
        appliedViewTransitions.set(state.location.pathname, toPaths);
      }
      viewTransitionOpts = {
        currentLocation: state.location,
        nextLocation: location
      };
    }
    updateState(_extends({}, newState, {
      actionData,
      loaderData,
      historyAction: pendingAction,
      location,
      initialized: true,
      navigation: IDLE_NAVIGATION,
      revalidation: "idle",
      restoreScrollPosition: getSavedScrollPosition(location, newState.matches || state.matches),
      preventScrollReset,
      blockers
    }), {
      viewTransitionOpts,
      flushSync: flushSync === true
    });
    // Reset stateful navigation vars
    pendingAction = Action.Pop;
    pendingPreventScrollReset = false;
    pendingViewTransitionEnabled = false;
    isUninterruptedRevalidation = false;
    isRevalidationRequired = false;
    cancelledDeferredRoutes = [];
  }
  // Trigger a navigation event, which can either be a numerical POP or a PUSH
  // replace with an optional submission
  async function navigate(to, opts) {
    if (typeof to === "number") {
      init.history.go(to);
      return;
    }
    let normalizedPath = normalizeTo(state.location, state.matches, basename, future.v7_prependBasename, to, future.v7_relativeSplatPath, opts == null ? void 0 : opts.fromRouteId, opts == null ? void 0 : opts.relative);
    let {
      path,
      submission,
      error
    } = normalizeNavigateOptions(future.v7_normalizeFormMethod, false, normalizedPath, opts);
    let currentLocation = state.location;
    let nextLocation = createLocation(state.location, path, opts && opts.state);
    // When using navigate as a PUSH/REPLACE we aren't reading an already-encoded
    // URL from window.location, so we need to encode it here so the behavior
    // remains the same as POP and non-data-router usages.  new URL() does all
    // the same encoding we'd get from a history.pushState/window.location read
    // without having to touch history
    nextLocation = _extends({}, nextLocation, init.history.encodeLocation(nextLocation));
    let userReplace = opts && opts.replace != null ? opts.replace : undefined;
    let historyAction = Action.Push;
    if (userReplace === true) {
      historyAction = Action.Replace;
    } else if (userReplace === false) ; else if (submission != null && isMutationMethod(submission.formMethod) && submission.formAction === state.location.pathname + state.location.search) {
      // By default on submissions to the current location we REPLACE so that
      // users don't have to double-click the back button to get to the prior
      // location.  If the user redirects to a different location from the
      // action/loader this will be ignored and the redirect will be a PUSH
      historyAction = Action.Replace;
    }
    let preventScrollReset = opts && "preventScrollReset" in opts ? opts.preventScrollReset === true : undefined;
    let flushSync = (opts && opts.flushSync) === true;
    let blockerKey = shouldBlockNavigation({
      currentLocation,
      nextLocation,
      historyAction
    });
    if (blockerKey) {
      // Put the blocker into a blocked state
      updateBlocker(blockerKey, {
        state: "blocked",
        location: nextLocation,
        proceed() {
          updateBlocker(blockerKey, {
            state: "proceeding",
            proceed: undefined,
            reset: undefined,
            location: nextLocation
          });
          // Send the same navigation through
          navigate(to, opts);
        },
        reset() {
          let blockers = new Map(state.blockers);
          blockers.set(blockerKey, IDLE_BLOCKER);
          updateState({
            blockers
          });
        }
      });
      return;
    }
    return await startNavigation(historyAction, nextLocation, {
      submission,
      // Send through the formData serialization error if we have one so we can
      // render at the right error boundary after we match routes
      pendingError: error,
      preventScrollReset,
      replace: opts && opts.replace,
      enableViewTransition: opts && opts.viewTransition,
      flushSync
    });
  }
  // Revalidate all current loaders.  If a navigation is in progress or if this
  // is interrupted by a navigation, allow this to "succeed" by calling all
  // loaders during the next loader round
  function revalidate() {
    interruptActiveLoads();
    updateState({
      revalidation: "loading"
    });
    // If we're currently submitting an action, we don't need to start a new
    // navigation, we'll just let the follow up loader execution call all loaders
    if (state.navigation.state === "submitting") {
      return;
    }
    // If we're currently in an idle state, start a new navigation for the current
    // action/location and mark it as uninterrupted, which will skip the history
    // update in completeNavigation
    if (state.navigation.state === "idle") {
      startNavigation(state.historyAction, state.location, {
        startUninterruptedRevalidation: true
      });
      return;
    }
    // Otherwise, if we're currently in a loading state, just start a new
    // navigation to the navigation.location but do not trigger an uninterrupted
    // revalidation so that history correctly updates once the navigation completes
    startNavigation(pendingAction || state.historyAction, state.navigation.location, {
      overrideNavigation: state.navigation,
      // Proxy through any rending view transition
      enableViewTransition: pendingViewTransitionEnabled === true
    });
  }
  // Start a navigation to the given action/location.  Can optionally provide a
  // overrideNavigation which will override the normalLoad in the case of a redirect
  // navigation
  async function startNavigation(historyAction, location, opts) {
    // Abort any in-progress navigations and start a new one. Unset any ongoing
    // uninterrupted revalidations unless told otherwise, since we want this
    // new navigation to update history normally
    pendingNavigationController && pendingNavigationController.abort();
    pendingNavigationController = null;
    pendingAction = historyAction;
    isUninterruptedRevalidation = (opts && opts.startUninterruptedRevalidation) === true;
    // Save the current scroll position every time we start a new navigation,
    // and track whether we should reset scroll on completion
    saveScrollPosition(state.location, state.matches);
    pendingPreventScrollReset = (opts && opts.preventScrollReset) === true;
    pendingViewTransitionEnabled = (opts && opts.enableViewTransition) === true;
    let routesToUse = inFlightDataRoutes || dataRoutes;
    let loadingNavigation = opts && opts.overrideNavigation;
    let matches = opts != null && opts.initialHydration && state.matches && state.matches.length > 0 && !initialMatchesIsFOW ?
    // `matchRoutes()` has already been called if we're in here via `router.initialize()`
    state.matches : matchRoutes(routesToUse, location, basename);
    let flushSync = (opts && opts.flushSync) === true;
    // Short circuit if it's only a hash change and not a revalidation or
    // mutation submission.
    //
    // Ignore on initial page loads because since the initial hydration will always
    // be "same hash".  For example, on /page#hash and submit a <Form method="post">
    // which will default to a navigation to /page
    if (matches && state.initialized && !isRevalidationRequired && isHashChangeOnly(state.location, location) && !(opts && opts.submission && isMutationMethod(opts.submission.formMethod))) {
      completeNavigation(location, {
        matches
      }, {
        flushSync
      });
      return;
    }
    let fogOfWar = checkFogOfWar(matches, routesToUse, location.pathname);
    if (fogOfWar.active && fogOfWar.matches) {
      matches = fogOfWar.matches;
    }
    // Short circuit with a 404 on the root error boundary if we match nothing
    if (!matches) {
      let {
        error,
        notFoundMatches,
        route
      } = handleNavigational404(location.pathname);
      completeNavigation(location, {
        matches: notFoundMatches,
        loaderData: {},
        errors: {
          [route.id]: error
        }
      }, {
        flushSync
      });
      return;
    }
    // Create a controller/Request for this navigation
    pendingNavigationController = new AbortController();
    let request = createClientSideRequest(init.history, location, pendingNavigationController.signal, opts && opts.submission);
    let pendingActionResult;
    if (opts && opts.pendingError) {
      // If we have a pendingError, it means the user attempted a GET submission
      // with binary FormData so assign here and skip to handleLoaders.  That
      // way we handle calling loaders above the boundary etc.  It's not really
      // different from an actionError in that sense.
      pendingActionResult = [findNearestBoundary(matches).route.id, {
        type: ResultType.error,
        error: opts.pendingError
      }];
    } else if (opts && opts.submission && isMutationMethod(opts.submission.formMethod)) {
      // Call action if we received an action submission
      let actionResult = await handleAction(request, location, opts.submission, matches, fogOfWar.active, {
        replace: opts.replace,
        flushSync
      });
      if (actionResult.shortCircuited) {
        return;
      }
      // If we received a 404 from handleAction, it's because we couldn't lazily
      // discover the destination route so we don't want to call loaders
      if (actionResult.pendingActionResult) {
        let [routeId, result] = actionResult.pendingActionResult;
        if (isErrorResult(result) && isRouteErrorResponse(result.error) && result.error.status === 404) {
          pendingNavigationController = null;
          completeNavigation(location, {
            matches: actionResult.matches,
            loaderData: {},
            errors: {
              [routeId]: result.error
            }
          });
          return;
        }
      }
      matches = actionResult.matches || matches;
      pendingActionResult = actionResult.pendingActionResult;
      loadingNavigation = getLoadingNavigation(location, opts.submission);
      flushSync = false;
      // No need to do fog of war matching again on loader execution
      fogOfWar.active = false;
      // Create a GET request for the loaders
      request = createClientSideRequest(init.history, request.url, request.signal);
    }
    // Call loaders
    let {
      shortCircuited,
      matches: updatedMatches,
      loaderData,
      errors
    } = await handleLoaders(request, location, matches, fogOfWar.active, loadingNavigation, opts && opts.submission, opts && opts.fetcherSubmission, opts && opts.replace, opts && opts.initialHydration === true, flushSync, pendingActionResult);
    if (shortCircuited) {
      return;
    }
    // Clean up now that the action/loaders have completed.  Don't clean up if
    // we short circuited because pendingNavigationController will have already
    // been assigned to a new controller for the next navigation
    pendingNavigationController = null;
    completeNavigation(location, _extends({
      matches: updatedMatches || matches
    }, getActionDataForCommit(pendingActionResult), {
      loaderData,
      errors
    }));
  }
  // Call the action matched by the leaf route for this navigation and handle
  // redirects/errors
  async function handleAction(request, location, submission, matches, isFogOfWar, opts) {
    if (opts === void 0) {
      opts = {};
    }
    interruptActiveLoads();
    // Put us in a submitting state
    let navigation = getSubmittingNavigation(location, submission);
    updateState({
      navigation
    }, {
      flushSync: opts.flushSync === true
    });
    if (isFogOfWar) {
      let discoverResult = await discoverRoutes(matches, location.pathname, request.signal);
      if (discoverResult.type === "aborted") {
        return {
          shortCircuited: true
        };
      } else if (discoverResult.type === "error") {
        let boundaryId = findNearestBoundary(discoverResult.partialMatches).route.id;
        return {
          matches: discoverResult.partialMatches,
          pendingActionResult: [boundaryId, {
            type: ResultType.error,
            error: discoverResult.error
          }]
        };
      } else if (!discoverResult.matches) {
        let {
          notFoundMatches,
          error,
          route
        } = handleNavigational404(location.pathname);
        return {
          matches: notFoundMatches,
          pendingActionResult: [route.id, {
            type: ResultType.error,
            error
          }]
        };
      } else {
        matches = discoverResult.matches;
      }
    }
    // Call our action and get the result
    let result;
    let actionMatch = getTargetMatch(matches, location);
    if (!actionMatch.route.action && !actionMatch.route.lazy) {
      result = {
        type: ResultType.error,
        error: getInternalRouterError(405, {
          method: request.method,
          pathname: location.pathname,
          routeId: actionMatch.route.id
        })
      };
    } else {
      let results = await callDataStrategy("action", state, request, [actionMatch], matches, null);
      result = results[actionMatch.route.id];
      if (request.signal.aborted) {
        return {
          shortCircuited: true
        };
      }
    }
    if (isRedirectResult(result)) {
      let replace;
      if (opts && opts.replace != null) {
        replace = opts.replace;
      } else {
        // If the user didn't explicity indicate replace behavior, replace if
        // we redirected to the exact same location we're currently at to avoid
        // double back-buttons
        let location = normalizeRedirectLocation(result.response.headers.get("Location"), new URL(request.url), basename);
        replace = location === state.location.pathname + state.location.search;
      }
      await startRedirectNavigation(request, result, true, {
        submission,
        replace
      });
      return {
        shortCircuited: true
      };
    }
    if (isDeferredResult(result)) {
      throw getInternalRouterError(400, {
        type: "defer-action"
      });
    }
    if (isErrorResult(result)) {
      // Store off the pending error - we use it to determine which loaders
      // to call and will commit it when we complete the navigation
      let boundaryMatch = findNearestBoundary(matches, actionMatch.route.id);
      // By default, all submissions to the current location are REPLACE
      // navigations, but if the action threw an error that'll be rendered in
      // an errorElement, we fall back to PUSH so that the user can use the
      // back button to get back to the pre-submission form location to try
      // again
      if ((opts && opts.replace) !== true) {
        pendingAction = Action.Push;
      }
      return {
        matches,
        pendingActionResult: [boundaryMatch.route.id, result]
      };
    }
    return {
      matches,
      pendingActionResult: [actionMatch.route.id, result]
    };
  }
  // Call all applicable loaders for the given matches, handling redirects,
  // errors, etc.
  async function handleLoaders(request, location, matches, isFogOfWar, overrideNavigation, submission, fetcherSubmission, replace, initialHydration, flushSync, pendingActionResult) {
    // Figure out the right navigation we want to use for data loading
    let loadingNavigation = overrideNavigation || getLoadingNavigation(location, submission);
    // If this was a redirect from an action we don't have a "submission" but
    // we have it on the loading navigation so use that if available
    let activeSubmission = submission || fetcherSubmission || getSubmissionFromNavigation(loadingNavigation);
    // If this is an uninterrupted revalidation, we remain in our current idle
    // state.  If not, we need to switch to our loading state and load data,
    // preserving any new action data or existing action data (in the case of
    // a revalidation interrupting an actionReload)
    // If we have partialHydration enabled, then don't update the state for the
    // initial data load since it's not a "navigation"
    let shouldUpdateNavigationState = !isUninterruptedRevalidation && (!future.v7_partialHydration || !initialHydration);
    // When fog of war is enabled, we enter our `loading` state earlier so we
    // can discover new routes during the `loading` state.  We skip this if
    // we've already run actions since we would have done our matching already.
    // If the children() function threw then, we want to proceed with the
    // partial matches it discovered.
    if (isFogOfWar) {
      if (shouldUpdateNavigationState) {
        let actionData = getUpdatedActionData(pendingActionResult);
        updateState(_extends({
          navigation: loadingNavigation
        }, actionData !== undefined ? {
          actionData
        } : {}), {
          flushSync
        });
      }
      let discoverResult = await discoverRoutes(matches, location.pathname, request.signal);
      if (discoverResult.type === "aborted") {
        return {
          shortCircuited: true
        };
      } else if (discoverResult.type === "error") {
        let boundaryId = findNearestBoundary(discoverResult.partialMatches).route.id;
        return {
          matches: discoverResult.partialMatches,
          loaderData: {},
          errors: {
            [boundaryId]: discoverResult.error
          }
        };
      } else if (!discoverResult.matches) {
        let {
          error,
          notFoundMatches,
          route
        } = handleNavigational404(location.pathname);
        return {
          matches: notFoundMatches,
          loaderData: {},
          errors: {
            [route.id]: error
          }
        };
      } else {
        matches = discoverResult.matches;
      }
    }
    let routesToUse = inFlightDataRoutes || dataRoutes;
    let [matchesToLoad, revalidatingFetchers] = getMatchesToLoad(init.history, state, matches, activeSubmission, location, future.v7_partialHydration && initialHydration === true, future.v7_skipActionErrorRevalidation, isRevalidationRequired, cancelledDeferredRoutes, cancelledFetcherLoads, deletedFetchers, fetchLoadMatches, fetchRedirectIds, routesToUse, basename, pendingActionResult);
    // Cancel pending deferreds for no-longer-matched routes or routes we're
    // about to reload.  Note that if this is an action reload we would have
    // already cancelled all pending deferreds so this would be a no-op
    cancelActiveDeferreds(routeId => !(matches && matches.some(m => m.route.id === routeId)) || matchesToLoad && matchesToLoad.some(m => m.route.id === routeId));
    pendingNavigationLoadId = ++incrementingLoadId;
    // Short circuit if we have no loaders to run
    if (matchesToLoad.length === 0 && revalidatingFetchers.length === 0) {
      let updatedFetchers = markFetchRedirectsDone();
      completeNavigation(location, _extends({
        matches,
        loaderData: {},
        // Commit pending error if we're short circuiting
        errors: pendingActionResult && isErrorResult(pendingActionResult[1]) ? {
          [pendingActionResult[0]]: pendingActionResult[1].error
        } : null
      }, getActionDataForCommit(pendingActionResult), updatedFetchers ? {
        fetchers: new Map(state.fetchers)
      } : {}), {
        flushSync
      });
      return {
        shortCircuited: true
      };
    }
    if (shouldUpdateNavigationState) {
      let updates = {};
      if (!isFogOfWar) {
        // Only update navigation/actionNData if we didn't already do it above
        updates.navigation = loadingNavigation;
        let actionData = getUpdatedActionData(pendingActionResult);
        if (actionData !== undefined) {
          updates.actionData = actionData;
        }
      }
      if (revalidatingFetchers.length > 0) {
        updates.fetchers = getUpdatedRevalidatingFetchers(revalidatingFetchers);
      }
      updateState(updates, {
        flushSync
      });
    }
    revalidatingFetchers.forEach(rf => {
      abortFetcher(rf.key);
      if (rf.controller) {
        // Fetchers use an independent AbortController so that aborting a fetcher
        // (via deleteFetcher) does not abort the triggering navigation that
        // triggered the revalidation
        fetchControllers.set(rf.key, rf.controller);
      }
    });
    // Proxy navigation abort through to revalidation fetchers
    let abortPendingFetchRevalidations = () => revalidatingFetchers.forEach(f => abortFetcher(f.key));
    if (pendingNavigationController) {
      pendingNavigationController.signal.addEventListener("abort", abortPendingFetchRevalidations);
    }
    let {
      loaderResults,
      fetcherResults
    } = await callLoadersAndMaybeResolveData(state, matches, matchesToLoad, revalidatingFetchers, request);
    if (request.signal.aborted) {
      return {
        shortCircuited: true
      };
    }
    // Clean up _after_ loaders have completed.  Don't clean up if we short
    // circuited because fetchControllers would have been aborted and
    // reassigned to new controllers for the next navigation
    if (pendingNavigationController) {
      pendingNavigationController.signal.removeEventListener("abort", abortPendingFetchRevalidations);
    }
    revalidatingFetchers.forEach(rf => fetchControllers.delete(rf.key));
    // If any loaders returned a redirect Response, start a new REPLACE navigation
    let redirect = findRedirect(loaderResults);
    if (redirect) {
      await startRedirectNavigation(request, redirect.result, true, {
        replace
      });
      return {
        shortCircuited: true
      };
    }
    redirect = findRedirect(fetcherResults);
    if (redirect) {
      // If this redirect came from a fetcher make sure we mark it in
      // fetchRedirectIds so it doesn't get revalidated on the next set of
      // loader executions
      fetchRedirectIds.add(redirect.key);
      await startRedirectNavigation(request, redirect.result, true, {
        replace
      });
      return {
        shortCircuited: true
      };
    }
    // Process and commit output from loaders
    let {
      loaderData,
      errors
    } = processLoaderData(state, matches, loaderResults, pendingActionResult, revalidatingFetchers, fetcherResults, activeDeferreds);
    // Wire up subscribers to update loaderData as promises settle
    activeDeferreds.forEach((deferredData, routeId) => {
      deferredData.subscribe(aborted => {
        // Note: No need to updateState here since the TrackedPromise on
        // loaderData is stable across resolve/reject
        // Remove this instance if we were aborted or if promises have settled
        if (aborted || deferredData.done) {
          activeDeferreds.delete(routeId);
        }
      });
    });
    // Preserve SSR errors during partial hydration
    if (future.v7_partialHydration && initialHydration && state.errors) {
      errors = _extends({}, state.errors, errors);
    }
    let updatedFetchers = markFetchRedirectsDone();
    let didAbortFetchLoads = abortStaleFetchLoads(pendingNavigationLoadId);
    let shouldUpdateFetchers = updatedFetchers || didAbortFetchLoads || revalidatingFetchers.length > 0;
    return _extends({
      matches,
      loaderData,
      errors
    }, shouldUpdateFetchers ? {
      fetchers: new Map(state.fetchers)
    } : {});
  }
  function getUpdatedActionData(pendingActionResult) {
    if (pendingActionResult && !isErrorResult(pendingActionResult[1])) {
      // This is cast to `any` currently because `RouteData`uses any and it
      // would be a breaking change to use any.
      // TODO: v7 - change `RouteData` to use `unknown` instead of `any`
      return {
        [pendingActionResult[0]]: pendingActionResult[1].data
      };
    } else if (state.actionData) {
      if (Object.keys(state.actionData).length === 0) {
        return null;
      } else {
        return state.actionData;
      }
    }
  }
  function getUpdatedRevalidatingFetchers(revalidatingFetchers) {
    revalidatingFetchers.forEach(rf => {
      let fetcher = state.fetchers.get(rf.key);
      let revalidatingFetcher = getLoadingFetcher(undefined, fetcher ? fetcher.data : undefined);
      state.fetchers.set(rf.key, revalidatingFetcher);
    });
    return new Map(state.fetchers);
  }
  // Trigger a fetcher load/submit for the given fetcher key
  function fetch(key, routeId, href, opts) {
    if (isServer) {
      throw new Error("router.fetch() was called during the server render, but it shouldn't be. " + "You are likely calling a useFetcher() method in the body of your component. " + "Try moving it to a useEffect or a callback.");
    }
    abortFetcher(key);
    let flushSync = (opts && opts.flushSync) === true;
    let routesToUse = inFlightDataRoutes || dataRoutes;
    let normalizedPath = normalizeTo(state.location, state.matches, basename, future.v7_prependBasename, href, future.v7_relativeSplatPath, routeId, opts == null ? void 0 : opts.relative);
    let matches = matchRoutes(routesToUse, normalizedPath, basename);
    let fogOfWar = checkFogOfWar(matches, routesToUse, normalizedPath);
    if (fogOfWar.active && fogOfWar.matches) {
      matches = fogOfWar.matches;
    }
    if (!matches) {
      setFetcherError(key, routeId, getInternalRouterError(404, {
        pathname: normalizedPath
      }), {
        flushSync
      });
      return;
    }
    let {
      path,
      submission,
      error
    } = normalizeNavigateOptions(future.v7_normalizeFormMethod, true, normalizedPath, opts);
    if (error) {
      setFetcherError(key, routeId, error, {
        flushSync
      });
      return;
    }
    let match = getTargetMatch(matches, path);
    let preventScrollReset = (opts && opts.preventScrollReset) === true;
    if (submission && isMutationMethod(submission.formMethod)) {
      handleFetcherAction(key, routeId, path, match, matches, fogOfWar.active, flushSync, preventScrollReset, submission);
      return;
    }
    // Store off the match so we can call it's shouldRevalidate on subsequent
    // revalidations
    fetchLoadMatches.set(key, {
      routeId,
      path
    });
    handleFetcherLoader(key, routeId, path, match, matches, fogOfWar.active, flushSync, preventScrollReset, submission);
  }
  // Call the action for the matched fetcher.submit(), and then handle redirects,
  // errors, and revalidation
  async function handleFetcherAction(key, routeId, path, match, requestMatches, isFogOfWar, flushSync, preventScrollReset, submission) {
    interruptActiveLoads();
    fetchLoadMatches.delete(key);
    function detectAndHandle405Error(m) {
      if (!m.route.action && !m.route.lazy) {
        let error = getInternalRouterError(405, {
          method: submission.formMethod,
          pathname: path,
          routeId: routeId
        });
        setFetcherError(key, routeId, error, {
          flushSync
        });
        return true;
      }
      return false;
    }
    if (!isFogOfWar && detectAndHandle405Error(match)) {
      return;
    }
    // Put this fetcher into it's submitting state
    let existingFetcher = state.fetchers.get(key);
    updateFetcherState(key, getSubmittingFetcher(submission, existingFetcher), {
      flushSync
    });
    let abortController = new AbortController();
    let fetchRequest = createClientSideRequest(init.history, path, abortController.signal, submission);
    if (isFogOfWar) {
      let discoverResult = await discoverRoutes(requestMatches, new URL(fetchRequest.url).pathname, fetchRequest.signal, key);
      if (discoverResult.type === "aborted") {
        return;
      } else if (discoverResult.type === "error") {
        setFetcherError(key, routeId, discoverResult.error, {
          flushSync
        });
        return;
      } else if (!discoverResult.matches) {
        setFetcherError(key, routeId, getInternalRouterError(404, {
          pathname: path
        }), {
          flushSync
        });
        return;
      } else {
        requestMatches = discoverResult.matches;
        match = getTargetMatch(requestMatches, path);
        if (detectAndHandle405Error(match)) {
          return;
        }
      }
    }
    // Call the action for the fetcher
    fetchControllers.set(key, abortController);
    let originatingLoadId = incrementingLoadId;
    let actionResults = await callDataStrategy("action", state, fetchRequest, [match], requestMatches, key);
    let actionResult = actionResults[match.route.id];
    if (fetchRequest.signal.aborted) {
      // We can delete this so long as we weren't aborted by our own fetcher
      // re-submit which would have put _new_ controller is in fetchControllers
      if (fetchControllers.get(key) === abortController) {
        fetchControllers.delete(key);
      }
      return;
    }
    // When using v7_fetcherPersist, we don't want errors bubbling up to the UI
    // or redirects processed for unmounted fetchers so we just revert them to
    // idle
    if (future.v7_fetcherPersist && deletedFetchers.has(key)) {
      if (isRedirectResult(actionResult) || isErrorResult(actionResult)) {
        updateFetcherState(key, getDoneFetcher(undefined));
        return;
      }
      // Let SuccessResult's fall through for revalidation
    } else {
      if (isRedirectResult(actionResult)) {
        fetchControllers.delete(key);
        if (pendingNavigationLoadId > originatingLoadId) {
          // A new navigation was kicked off after our action started, so that
          // should take precedence over this redirect navigation.  We already
          // set isRevalidationRequired so all loaders for the new route should
          // fire unless opted out via shouldRevalidate
          updateFetcherState(key, getDoneFetcher(undefined));
          return;
        } else {
          fetchRedirectIds.add(key);
          updateFetcherState(key, getLoadingFetcher(submission));
          return startRedirectNavigation(fetchRequest, actionResult, false, {
            fetcherSubmission: submission,
            preventScrollReset
          });
        }
      }
      // Process any non-redirect errors thrown
      if (isErrorResult(actionResult)) {
        setFetcherError(key, routeId, actionResult.error);
        return;
      }
    }
    if (isDeferredResult(actionResult)) {
      throw getInternalRouterError(400, {
        type: "defer-action"
      });
    }
    // Start the data load for current matches, or the next location if we're
    // in the middle of a navigation
    let nextLocation = state.navigation.location || state.location;
    let revalidationRequest = createClientSideRequest(init.history, nextLocation, abortController.signal);
    let routesToUse = inFlightDataRoutes || dataRoutes;
    let matches = state.navigation.state !== "idle" ? matchRoutes(routesToUse, state.navigation.location, basename) : state.matches;
    invariant(matches, "Didn't find any matches after fetcher action");
    let loadId = ++incrementingLoadId;
    fetchReloadIds.set(key, loadId);
    let loadFetcher = getLoadingFetcher(submission, actionResult.data);
    state.fetchers.set(key, loadFetcher);
    let [matchesToLoad, revalidatingFetchers] = getMatchesToLoad(init.history, state, matches, submission, nextLocation, false, future.v7_skipActionErrorRevalidation, isRevalidationRequired, cancelledDeferredRoutes, cancelledFetcherLoads, deletedFetchers, fetchLoadMatches, fetchRedirectIds, routesToUse, basename, [match.route.id, actionResult]);
    // Put all revalidating fetchers into the loading state, except for the
    // current fetcher which we want to keep in it's current loading state which
    // contains it's action submission info + action data
    revalidatingFetchers.filter(rf => rf.key !== key).forEach(rf => {
      let staleKey = rf.key;
      let existingFetcher = state.fetchers.get(staleKey);
      let revalidatingFetcher = getLoadingFetcher(undefined, existingFetcher ? existingFetcher.data : undefined);
      state.fetchers.set(staleKey, revalidatingFetcher);
      abortFetcher(staleKey);
      if (rf.controller) {
        fetchControllers.set(staleKey, rf.controller);
      }
    });
    updateState({
      fetchers: new Map(state.fetchers)
    });
    let abortPendingFetchRevalidations = () => revalidatingFetchers.forEach(rf => abortFetcher(rf.key));
    abortController.signal.addEventListener("abort", abortPendingFetchRevalidations);
    let {
      loaderResults,
      fetcherResults
    } = await callLoadersAndMaybeResolveData(state, matches, matchesToLoad, revalidatingFetchers, revalidationRequest);
    if (abortController.signal.aborted) {
      return;
    }
    abortController.signal.removeEventListener("abort", abortPendingFetchRevalidations);
    fetchReloadIds.delete(key);
    fetchControllers.delete(key);
    revalidatingFetchers.forEach(r => fetchControllers.delete(r.key));
    let redirect = findRedirect(loaderResults);
    if (redirect) {
      return startRedirectNavigation(revalidationRequest, redirect.result, false, {
        preventScrollReset
      });
    }
    redirect = findRedirect(fetcherResults);
    if (redirect) {
      // If this redirect came from a fetcher make sure we mark it in
      // fetchRedirectIds so it doesn't get revalidated on the next set of
      // loader executions
      fetchRedirectIds.add(redirect.key);
      return startRedirectNavigation(revalidationRequest, redirect.result, false, {
        preventScrollReset
      });
    }
    // Process and commit output from loaders
    let {
      loaderData,
      errors
    } = processLoaderData(state, matches, loaderResults, undefined, revalidatingFetchers, fetcherResults, activeDeferreds);
    // Since we let revalidations complete even if the submitting fetcher was
    // deleted, only put it back to idle if it hasn't been deleted
    if (state.fetchers.has(key)) {
      let doneFetcher = getDoneFetcher(actionResult.data);
      state.fetchers.set(key, doneFetcher);
    }
    abortStaleFetchLoads(loadId);
    // If we are currently in a navigation loading state and this fetcher is
    // more recent than the navigation, we want the newer data so abort the
    // navigation and complete it with the fetcher data
    if (state.navigation.state === "loading" && loadId > pendingNavigationLoadId) {
      invariant(pendingAction, "Expected pending action");
      pendingNavigationController && pendingNavigationController.abort();
      completeNavigation(state.navigation.location, {
        matches,
        loaderData,
        errors,
        fetchers: new Map(state.fetchers)
      });
    } else {
      // otherwise just update with the fetcher data, preserving any existing
      // loaderData for loaders that did not need to reload.  We have to
      // manually merge here since we aren't going through completeNavigation
      updateState({
        errors,
        loaderData: mergeLoaderData(state.loaderData, loaderData, matches, errors),
        fetchers: new Map(state.fetchers)
      });
      isRevalidationRequired = false;
    }
  }
  // Call the matched loader for fetcher.load(), handling redirects, errors, etc.
  async function handleFetcherLoader(key, routeId, path, match, matches, isFogOfWar, flushSync, preventScrollReset, submission) {
    let existingFetcher = state.fetchers.get(key);
    updateFetcherState(key, getLoadingFetcher(submission, existingFetcher ? existingFetcher.data : undefined), {
      flushSync
    });
    let abortController = new AbortController();
    let fetchRequest = createClientSideRequest(init.history, path, abortController.signal);
    if (isFogOfWar) {
      let discoverResult = await discoverRoutes(matches, new URL(fetchRequest.url).pathname, fetchRequest.signal, key);
      if (discoverResult.type === "aborted") {
        return;
      } else if (discoverResult.type === "error") {
        setFetcherError(key, routeId, discoverResult.error, {
          flushSync
        });
        return;
      } else if (!discoverResult.matches) {
        setFetcherError(key, routeId, getInternalRouterError(404, {
          pathname: path
        }), {
          flushSync
        });
        return;
      } else {
        matches = discoverResult.matches;
        match = getTargetMatch(matches, path);
      }
    }
    // Call the loader for this fetcher route match
    fetchControllers.set(key, abortController);
    let originatingLoadId = incrementingLoadId;
    let results = await callDataStrategy("loader", state, fetchRequest, [match], matches, key);
    let result = results[match.route.id];
    // Deferred isn't supported for fetcher loads, await everything and treat it
    // as a normal load.  resolveDeferredData will return undefined if this
    // fetcher gets aborted, so we just leave result untouched and short circuit
    // below if that happens
    if (isDeferredResult(result)) {
      result = (await resolveDeferredData(result, fetchRequest.signal, true)) || result;
    }
    // We can delete this so long as we weren't aborted by our our own fetcher
    // re-load which would have put _new_ controller is in fetchControllers
    if (fetchControllers.get(key) === abortController) {
      fetchControllers.delete(key);
    }
    if (fetchRequest.signal.aborted) {
      return;
    }
    // We don't want errors bubbling up or redirects followed for unmounted
    // fetchers, so short circuit here if it was removed from the UI
    if (deletedFetchers.has(key)) {
      updateFetcherState(key, getDoneFetcher(undefined));
      return;
    }
    // If the loader threw a redirect Response, start a new REPLACE navigation
    if (isRedirectResult(result)) {
      if (pendingNavigationLoadId > originatingLoadId) {
        // A new navigation was kicked off after our loader started, so that
        // should take precedence over this redirect navigation
        updateFetcherState(key, getDoneFetcher(undefined));
        return;
      } else {
        fetchRedirectIds.add(key);
        await startRedirectNavigation(fetchRequest, result, false, {
          preventScrollReset
        });
        return;
      }
    }
    // Process any non-redirect errors thrown
    if (isErrorResult(result)) {
      setFetcherError(key, routeId, result.error);
      return;
    }
    invariant(!isDeferredResult(result), "Unhandled fetcher deferred data");
    // Put the fetcher back into an idle state
    updateFetcherState(key, getDoneFetcher(result.data));
  }
  /**
   * Utility function to handle redirects returned from an action or loader.
   * Normally, a redirect "replaces" the navigation that triggered it.  So, for
   * example:
   *
   *  - user is on /a
   *  - user clicks a link to /b
   *  - loader for /b redirects to /c
   *
   * In a non-JS app the browser would track the in-flight navigation to /b and
   * then replace it with /c when it encountered the redirect response.  In
   * the end it would only ever update the URL bar with /c.
   *
   * In client-side routing using pushState/replaceState, we aim to emulate
   * this behavior and we also do not update history until the end of the
   * navigation (including processed redirects).  This means that we never
   * actually touch history until we've processed redirects, so we just use
   * the history action from the original navigation (PUSH or REPLACE).
   */
  async function startRedirectNavigation(request, redirect, isNavigation, _temp2) {
    let {
      submission,
      fetcherSubmission,
      preventScrollReset,
      replace
    } = _temp2 === void 0 ? {} : _temp2;
    if (redirect.response.headers.has("X-Remix-Revalidate")) {
      isRevalidationRequired = true;
    }
    let location = redirect.response.headers.get("Location");
    invariant(location, "Expected a Location header on the redirect Response");
    location = normalizeRedirectLocation(location, new URL(request.url), basename);
    let redirectLocation = createLocation(state.location, location, {
      _isRedirect: true
    });
    if (isBrowser) {
      let isDocumentReload = false;
      if (redirect.response.headers.has("X-Remix-Reload-Document")) {
        // Hard reload if the response contained X-Remix-Reload-Document
        isDocumentReload = true;
      } else if (ABSOLUTE_URL_REGEX.test(location)) {
        const url = init.history.createURL(location);
        isDocumentReload =
        // Hard reload if it's an absolute URL to a new origin
        url.origin !== routerWindow.location.origin ||
        // Hard reload if it's an absolute URL that does not match our basename
        stripBasename(url.pathname, basename) == null;
      }
      if (isDocumentReload) {
        if (replace) {
          routerWindow.location.replace(location);
        } else {
          routerWindow.location.assign(location);
        }
        return;
      }
    }
    // There's no need to abort on redirects, since we don't detect the
    // redirect until the action/loaders have settled
    pendingNavigationController = null;
    let redirectHistoryAction = replace === true || redirect.response.headers.has("X-Remix-Replace") ? Action.Replace : Action.Push;
    // Use the incoming submission if provided, fallback on the active one in
    // state.navigation
    let {
      formMethod,
      formAction,
      formEncType
    } = state.navigation;
    if (!submission && !fetcherSubmission && formMethod && formAction && formEncType) {
      submission = getSubmissionFromNavigation(state.navigation);
    }
    // If this was a 307/308 submission we want to preserve the HTTP method and
    // re-submit the GET/POST/PUT/PATCH/DELETE as a submission navigation to the
    // redirected location
    let activeSubmission = submission || fetcherSubmission;
    if (redirectPreserveMethodStatusCodes.has(redirect.response.status) && activeSubmission && isMutationMethod(activeSubmission.formMethod)) {
      await startNavigation(redirectHistoryAction, redirectLocation, {
        submission: _extends({}, activeSubmission, {
          formAction: location
        }),
        // Preserve these flags across redirects
        preventScrollReset: preventScrollReset || pendingPreventScrollReset,
        enableViewTransition: isNavigation ? pendingViewTransitionEnabled : undefined
      });
    } else {
      // If we have a navigation submission, we will preserve it through the
      // redirect navigation
      let overrideNavigation = getLoadingNavigation(redirectLocation, submission);
      await startNavigation(redirectHistoryAction, redirectLocation, {
        overrideNavigation,
        // Send fetcher submissions through for shouldRevalidate
        fetcherSubmission,
        // Preserve these flags across redirects
        preventScrollReset: preventScrollReset || pendingPreventScrollReset,
        enableViewTransition: isNavigation ? pendingViewTransitionEnabled : undefined
      });
    }
  }
  // Utility wrapper for calling dataStrategy client-side without having to
  // pass around the manifest, mapRouteProperties, etc.
  async function callDataStrategy(type, state, request, matchesToLoad, matches, fetcherKey) {
    let results;
    let dataResults = {};
    try {
      results = await callDataStrategyImpl(dataStrategyImpl, type, state, request, matchesToLoad, matches, fetcherKey, manifest, mapRouteProperties);
    } catch (e) {
      // If the outer dataStrategy method throws, just return the error for all
      // matches - and it'll naturally bubble to the root
      matchesToLoad.forEach(m => {
        dataResults[m.route.id] = {
          type: ResultType.error,
          error: e
        };
      });
      return dataResults;
    }
    for (let [routeId, result] of Object.entries(results)) {
      if (isRedirectDataStrategyResultResult(result)) {
        let response = result.result;
        dataResults[routeId] = {
          type: ResultType.redirect,
          response: normalizeRelativeRoutingRedirectResponse(response, request, routeId, matches, basename, future.v7_relativeSplatPath)
        };
      } else {
        dataResults[routeId] = await convertDataStrategyResultToDataResult(result);
      }
    }
    return dataResults;
  }
  async function callLoadersAndMaybeResolveData(state, matches, matchesToLoad, fetchersToLoad, request) {
    let currentMatches = state.matches;
    // Kick off loaders and fetchers in parallel
    let loaderResultsPromise = callDataStrategy("loader", state, request, matchesToLoad, matches, null);
    let fetcherResultsPromise = Promise.all(fetchersToLoad.map(async f => {
      if (f.matches && f.match && f.controller) {
        let results = await callDataStrategy("loader", state, createClientSideRequest(init.history, f.path, f.controller.signal), [f.match], f.matches, f.key);
        let result = results[f.match.route.id];
        // Fetcher results are keyed by fetcher key from here on out, not routeId
        return {
          [f.key]: result
        };
      } else {
        return Promise.resolve({
          [f.key]: {
            type: ResultType.error,
            error: getInternalRouterError(404, {
              pathname: f.path
            })
          }
        });
      }
    }));
    let loaderResults = await loaderResultsPromise;
    let fetcherResults = (await fetcherResultsPromise).reduce((acc, r) => Object.assign(acc, r), {});
    await Promise.all([resolveNavigationDeferredResults(matches, loaderResults, request.signal, currentMatches, state.loaderData), resolveFetcherDeferredResults(matches, fetcherResults, fetchersToLoad)]);
    return {
      loaderResults,
      fetcherResults
    };
  }
  function interruptActiveLoads() {
    // Every interruption triggers a revalidation
    isRevalidationRequired = true;
    // Cancel pending route-level deferreds and mark cancelled routes for
    // revalidation
    cancelledDeferredRoutes.push(...cancelActiveDeferreds());
    // Abort in-flight fetcher loads
    fetchLoadMatches.forEach((_, key) => {
      if (fetchControllers.has(key)) {
        cancelledFetcherLoads.add(key);
      }
      abortFetcher(key);
    });
  }
  function updateFetcherState(key, fetcher, opts) {
    if (opts === void 0) {
      opts = {};
    }
    state.fetchers.set(key, fetcher);
    updateState({
      fetchers: new Map(state.fetchers)
    }, {
      flushSync: (opts && opts.flushSync) === true
    });
  }
  function setFetcherError(key, routeId, error, opts) {
    if (opts === void 0) {
      opts = {};
    }
    let boundaryMatch = findNearestBoundary(state.matches, routeId);
    deleteFetcher(key);
    updateState({
      errors: {
        [boundaryMatch.route.id]: error
      },
      fetchers: new Map(state.fetchers)
    }, {
      flushSync: (opts && opts.flushSync) === true
    });
  }
  function getFetcher(key) {
    activeFetchers.set(key, (activeFetchers.get(key) || 0) + 1);
    // If this fetcher was previously marked for deletion, unmark it since we
    // have a new instance
    if (deletedFetchers.has(key)) {
      deletedFetchers.delete(key);
    }
    return state.fetchers.get(key) || IDLE_FETCHER;
  }
  function deleteFetcher(key) {
    let fetcher = state.fetchers.get(key);
    // Don't abort the controller if this is a deletion of a fetcher.submit()
    // in it's loading phase since - we don't want to abort the corresponding
    // revalidation and want them to complete and land
    if (fetchControllers.has(key) && !(fetcher && fetcher.state === "loading" && fetchReloadIds.has(key))) {
      abortFetcher(key);
    }
    fetchLoadMatches.delete(key);
    fetchReloadIds.delete(key);
    fetchRedirectIds.delete(key);
    // If we opted into the flag we can clear this now since we're calling
    // deleteFetcher() at the end of updateState() and we've already handed the
    // deleted fetcher keys off to the data layer.
    // If not, we're eagerly calling deleteFetcher() and we need to keep this
    // Set populated until the next updateState call, and we'll clear
    // `deletedFetchers` then
    if (future.v7_fetcherPersist) {
      deletedFetchers.delete(key);
    }
    cancelledFetcherLoads.delete(key);
    state.fetchers.delete(key);
  }
  function deleteFetcherAndUpdateState(key) {
    let count = (activeFetchers.get(key) || 0) - 1;
    if (count <= 0) {
      activeFetchers.delete(key);
      deletedFetchers.add(key);
      if (!future.v7_fetcherPersist) {
        deleteFetcher(key);
      }
    } else {
      activeFetchers.set(key, count);
    }
    updateState({
      fetchers: new Map(state.fetchers)
    });
  }
  function abortFetcher(key) {
    let controller = fetchControllers.get(key);
    if (controller) {
      controller.abort();
      fetchControllers.delete(key);
    }
  }
  function markFetchersDone(keys) {
    for (let key of keys) {
      let fetcher = getFetcher(key);
      let doneFetcher = getDoneFetcher(fetcher.data);
      state.fetchers.set(key, doneFetcher);
    }
  }
  function markFetchRedirectsDone() {
    let doneKeys = [];
    let updatedFetchers = false;
    for (let key of fetchRedirectIds) {
      let fetcher = state.fetchers.get(key);
      invariant(fetcher, "Expected fetcher: " + key);
      if (fetcher.state === "loading") {
        fetchRedirectIds.delete(key);
        doneKeys.push(key);
        updatedFetchers = true;
      }
    }
    markFetchersDone(doneKeys);
    return updatedFetchers;
  }
  function abortStaleFetchLoads(landedId) {
    let yeetedKeys = [];
    for (let [key, id] of fetchReloadIds) {
      if (id < landedId) {
        let fetcher = state.fetchers.get(key);
        invariant(fetcher, "Expected fetcher: " + key);
        if (fetcher.state === "loading") {
          abortFetcher(key);
          fetchReloadIds.delete(key);
          yeetedKeys.push(key);
        }
      }
    }
    markFetchersDone(yeetedKeys);
    return yeetedKeys.length > 0;
  }
  function getBlocker(key, fn) {
    let blocker = state.blockers.get(key) || IDLE_BLOCKER;
    if (blockerFunctions.get(key) !== fn) {
      blockerFunctions.set(key, fn);
    }
    return blocker;
  }
  function deleteBlocker(key) {
    state.blockers.delete(key);
    blockerFunctions.delete(key);
  }
  // Utility function to update blockers, ensuring valid state transitions
  function updateBlocker(key, newBlocker) {
    let blocker = state.blockers.get(key) || IDLE_BLOCKER;
    // Poor mans state machine :)
    // https://mermaid.live/edit#pako:eNqVkc9OwzAMxl8l8nnjAYrEtDIOHEBIgwvKJTReGy3_lDpIqO27k6awMG0XcrLlnz87nwdonESogKXXBuE79rq75XZO3-yHds0RJVuv70YrPlUrCEe2HfrORS3rubqZfuhtpg5C9wk5tZ4VKcRUq88q9Z8RS0-48cE1iHJkL0ugbHuFLus9L6spZy8nX9MP2CNdomVaposqu3fGayT8T8-jJQwhepo_UtpgBQaDEUom04dZhAN1aJBDlUKJBxE1ceB2Smj0Mln-IBW5AFU2dwUiktt_2Qaq2dBfaKdEup85UV7Yd-dKjlnkabl2Pvr0DTkTreM
    invariant(blocker.state === "unblocked" && newBlocker.state === "blocked" || blocker.state === "blocked" && newBlocker.state === "blocked" || blocker.state === "blocked" && newBlocker.state === "proceeding" || blocker.state === "blocked" && newBlocker.state === "unblocked" || blocker.state === "proceeding" && newBlocker.state === "unblocked", "Invalid blocker state transition: " + blocker.state + " -> " + newBlocker.state);
    let blockers = new Map(state.blockers);
    blockers.set(key, newBlocker);
    updateState({
      blockers
    });
  }
  function shouldBlockNavigation(_ref2) {
    let {
      currentLocation,
      nextLocation,
      historyAction
    } = _ref2;
    if (blockerFunctions.size === 0) {
      return;
    }
    // We ony support a single active blocker at the moment since we don't have
    // any compelling use cases for multi-blocker yet
    if (blockerFunctions.size > 1) {
      warning(false, "A router only supports one blocker at a time");
    }
    let entries = Array.from(blockerFunctions.entries());
    let [blockerKey, blockerFunction] = entries[entries.length - 1];
    let blocker = state.blockers.get(blockerKey);
    if (blocker && blocker.state === "proceeding") {
      // If the blocker is currently proceeding, we don't need to re-check
      // it and can let this navigation continue
      return;
    }
    // At this point, we know we're unblocked/blocked so we need to check the
    // user-provided blocker function
    if (blockerFunction({
      currentLocation,
      nextLocation,
      historyAction
    })) {
      return blockerKey;
    }
  }
  function handleNavigational404(pathname) {
    let error = getInternalRouterError(404, {
      pathname
    });
    let routesToUse = inFlightDataRoutes || dataRoutes;
    let {
      matches,
      route
    } = getShortCircuitMatches(routesToUse);
    // Cancel all pending deferred on 404s since we don't keep any routes
    cancelActiveDeferreds();
    return {
      notFoundMatches: matches,
      route,
      error
    };
  }
  function cancelActiveDeferreds(predicate) {
    let cancelledRouteIds = [];
    activeDeferreds.forEach((dfd, routeId) => {
      if (!predicate || predicate(routeId)) {
        // Cancel the deferred - but do not remove from activeDeferreds here -
        // we rely on the subscribers to do that so our tests can assert proper
        // cleanup via _internalActiveDeferreds
        dfd.cancel();
        cancelledRouteIds.push(routeId);
        activeDeferreds.delete(routeId);
      }
    });
    return cancelledRouteIds;
  }
  // Opt in to capturing and reporting scroll positions during navigations,
  // used by the <ScrollRestoration> component
  function enableScrollRestoration(positions, getPosition, getKey) {
    savedScrollPositions = positions;
    getScrollPosition = getPosition;
    getScrollRestorationKey = getKey || null;
    // Perform initial hydration scroll restoration, since we miss the boat on
    // the initial updateState() because we've not yet rendered <ScrollRestoration/>
    // and therefore have no savedScrollPositions available
    if (!initialScrollRestored && state.navigation === IDLE_NAVIGATION) {
      initialScrollRestored = true;
      let y = getSavedScrollPosition(state.location, state.matches);
      if (y != null) {
        updateState({
          restoreScrollPosition: y
        });
      }
    }
    return () => {
      savedScrollPositions = null;
      getScrollPosition = null;
      getScrollRestorationKey = null;
    };
  }
  function getScrollKey(location, matches) {
    if (getScrollRestorationKey) {
      let key = getScrollRestorationKey(location, matches.map(m => convertRouteMatchToUiMatch(m, state.loaderData)));
      return key || location.key;
    }
    return location.key;
  }
  function saveScrollPosition(location, matches) {
    if (savedScrollPositions && getScrollPosition) {
      let key = getScrollKey(location, matches);
      savedScrollPositions[key] = getScrollPosition();
    }
  }
  function getSavedScrollPosition(location, matches) {
    if (savedScrollPositions) {
      let key = getScrollKey(location, matches);
      let y = savedScrollPositions[key];
      if (typeof y === "number") {
        return y;
      }
    }
    return null;
  }
  function checkFogOfWar(matches, routesToUse, pathname) {
    if (patchRoutesOnNavigationImpl) {
      if (!matches) {
        let fogMatches = matchRoutesImpl(routesToUse, pathname, basename, true);
        return {
          active: true,
          matches: fogMatches || []
        };
      } else {
        if (Object.keys(matches[0].params).length > 0) {
          // If we matched a dynamic param or a splat, it might only be because
          // we haven't yet discovered other routes that would match with a
          // higher score.  Call patchRoutesOnNavigation just to be sure
          let partialMatches = matchRoutesImpl(routesToUse, pathname, basename, true);
          return {
            active: true,
            matches: partialMatches
          };
        }
      }
    }
    return {
      active: false,
      matches: null
    };
  }
  async function discoverRoutes(matches, pathname, signal, fetcherKey) {
    if (!patchRoutesOnNavigationImpl) {
      return {
        type: "success",
        matches
      };
    }
    let partialMatches = matches;
    while (true) {
      let isNonHMR = inFlightDataRoutes == null;
      let routesToUse = inFlightDataRoutes || dataRoutes;
      let localManifest = manifest;
      try {
        await patchRoutesOnNavigationImpl({
          signal,
          path: pathname,
          matches: partialMatches,
          fetcherKey,
          patch: (routeId, children) => {
            if (signal.aborted) return;
            patchRoutesImpl(routeId, children, routesToUse, localManifest, mapRouteProperties);
          }
        });
      } catch (e) {
        return {
          type: "error",
          error: e,
          partialMatches
        };
      } finally {
        // If we are not in the middle of an HMR revalidation and we changed the
        // routes, provide a new identity so when we `updateState` at the end of
        // this navigation/fetch `router.routes` will be a new identity and
        // trigger a re-run of memoized `router.routes` dependencies.
        // HMR will already update the identity and reflow when it lands
        // `inFlightDataRoutes` in `completeNavigation`
        if (isNonHMR && !signal.aborted) {
          dataRoutes = [...dataRoutes];
        }
      }
      if (signal.aborted) {
        return {
          type: "aborted"
        };
      }
      let newMatches = matchRoutes(routesToUse, pathname, basename);
      if (newMatches) {
        return {
          type: "success",
          matches: newMatches
        };
      }
      let newPartialMatches = matchRoutesImpl(routesToUse, pathname, basename, true);
      // Avoid loops if the second pass results in the same partial matches
      if (!newPartialMatches || partialMatches.length === newPartialMatches.length && partialMatches.every((m, i) => m.route.id === newPartialMatches[i].route.id)) {
        return {
          type: "success",
          matches: null
        };
      }
      partialMatches = newPartialMatches;
    }
  }
  function _internalSetRoutes(newRoutes) {
    manifest = {};
    inFlightDataRoutes = convertRoutesToDataRoutes(newRoutes, mapRouteProperties, undefined, manifest);
  }
  function patchRoutes(routeId, children) {
    let isNonHMR = inFlightDataRoutes == null;
    let routesToUse = inFlightDataRoutes || dataRoutes;
    patchRoutesImpl(routeId, children, routesToUse, manifest, mapRouteProperties);
    // If we are not in the middle of an HMR revalidation and we changed the
    // routes, provide a new identity and trigger a reflow via `updateState`
    // to re-run memoized `router.routes` dependencies.
    // HMR will already update the identity and reflow when it lands
    // `inFlightDataRoutes` in `completeNavigation`
    if (isNonHMR) {
      dataRoutes = [...dataRoutes];
      updateState({});
    }
  }
  router = {
    get basename() {
      return basename;
    },
    get future() {
      return future;
    },
    get state() {
      return state;
    },
    get routes() {
      return dataRoutes;
    },
    get window() {
      return routerWindow;
    },
    initialize,
    subscribe,
    enableScrollRestoration,
    navigate,
    fetch,
    revalidate,
    // Passthrough to history-aware createHref used by useHref so we get proper
    // hash-aware URLs in DOM paths
    createHref: to => init.history.createHref(to),
    encodeLocation: to => init.history.encodeLocation(to),
    getFetcher,
    deleteFetcher: deleteFetcherAndUpdateState,
    dispose,
    getBlocker,
    deleteBlocker,
    patchRoutes,
    _internalFetchControllers: fetchControllers,
    _internalActiveDeferreds: activeDeferreds,
    // TODO: Remove setRoutes, it's temporary to avoid dealing with
    // updating the tree while validating the update algorithm.
    _internalSetRoutes
  };
  return router;
}
//#endregion
////////////////////////////////////////////////////////////////////////////////
//#region createStaticHandler
////////////////////////////////////////////////////////////////////////////////
const UNSAFE_DEFERRED_SYMBOL = Symbol("deferred");
function createStaticHandler(routes, opts) {
  invariant(routes.length > 0, "You must provide a non-empty routes array to createStaticHandler");
  let manifest = {};
  let basename = (opts ? opts.basename : null) || "/";
  let mapRouteProperties;
  if (opts != null && opts.mapRouteProperties) {
    mapRouteProperties = opts.mapRouteProperties;
  } else if (opts != null && opts.detectErrorBoundary) {
    // If they are still using the deprecated version, wrap it with the new API
    let detectErrorBoundary = opts.detectErrorBoundary;
    mapRouteProperties = route => ({
      hasErrorBoundary: detectErrorBoundary(route)
    });
  } else {
    mapRouteProperties = defaultMapRouteProperties;
  }
  // Config driven behavior flags
  let future = _extends({
    v7_relativeSplatPath: false,
    v7_throwAbortReason: false
  }, opts ? opts.future : null);
  let dataRoutes = convertRoutesToDataRoutes(routes, mapRouteProperties, undefined, manifest);
  /**
   * The query() method is intended for document requests, in which we want to
   * call an optional action and potentially multiple loaders for all nested
   * routes.  It returns a StaticHandlerContext object, which is very similar
   * to the router state (location, loaderData, actionData, errors, etc.) and
   * also adds SSR-specific information such as the statusCode and headers
   * from action/loaders Responses.
   *
   * It _should_ never throw and should report all errors through the
   * returned context.errors object, properly associating errors to their error
   * boundary.  Additionally, it tracks _deepestRenderedBoundaryId which can be
   * used to emulate React error boundaries during SSr by performing a second
   * pass only down to the boundaryId.
   *
   * The one exception where we do not return a StaticHandlerContext is when a
   * redirect response is returned or thrown from any action/loader.  We
   * propagate that out and return the raw Response so the HTTP server can
   * return it directly.
   *
   * - `opts.requestContext` is an optional server context that will be passed
   *   to actions/loaders in the `context` parameter
   * - `opts.skipLoaderErrorBubbling` is an optional parameter that will prevent
   *   the bubbling of errors which allows single-fetch-type implementations
   *   where the client will handle the bubbling and we may need to return data
   *   for the handling route
   */
  async function query(request, _temp3) {
    let {
      requestContext,
      skipLoaderErrorBubbling,
      dataStrategy
    } = _temp3 === void 0 ? {} : _temp3;
    let url = new URL(request.url);
    let method = request.method;
    let location = createLocation("", createPath(url), null, "default");
    let matches = matchRoutes(dataRoutes, location, basename);
    // SSR supports HEAD requests while SPA doesn't
    if (!isValidMethod(method) && method !== "HEAD") {
      let error = getInternalRouterError(405, {
        method
      });
      let {
        matches: methodNotAllowedMatches,
        route
      } = getShortCircuitMatches(dataRoutes);
      return {
        basename,
        location,
        matches: methodNotAllowedMatches,
        loaderData: {},
        actionData: null,
        errors: {
          [route.id]: error
        },
        statusCode: error.status,
        loaderHeaders: {},
        actionHeaders: {},
        activeDeferreds: null
      };
    } else if (!matches) {
      let error = getInternalRouterError(404, {
        pathname: location.pathname
      });
      let {
        matches: notFoundMatches,
        route
      } = getShortCircuitMatches(dataRoutes);
      return {
        basename,
        location,
        matches: notFoundMatches,
        loaderData: {},
        actionData: null,
        errors: {
          [route.id]: error
        },
        statusCode: error.status,
        loaderHeaders: {},
        actionHeaders: {},
        activeDeferreds: null
      };
    }
    let result = await queryImpl(request, location, matches, requestContext, dataStrategy || null, skipLoaderErrorBubbling === true, null);
    if (isResponse(result)) {
      return result;
    }
    // When returning StaticHandlerContext, we patch back in the location here
    // since we need it for React Context.  But this helps keep our submit and
    // loadRouteData operating on a Request instead of a Location
    return _extends({
      location,
      basename
    }, result);
  }
  /**
   * The queryRoute() method is intended for targeted route requests, either
   * for fetch ?_data requests or resource route requests.  In this case, we
   * are only ever calling a single action or loader, and we are returning the
   * returned value directly.  In most cases, this will be a Response returned
   * from the action/loader, but it may be a primitive or other value as well -
   * and in such cases the calling context should handle that accordingly.
   *
   * We do respect the throw/return differentiation, so if an action/loader
   * throws, then this method will throw the value.  This is important so we
   * can do proper boundary identification in Remix where a thrown Response
   * must go to the Catch Boundary but a returned Response is happy-path.
   *
   * One thing to note is that any Router-initiated Errors that make sense
   * to associate with a status code will be thrown as an ErrorResponse
   * instance which include the raw Error, such that the calling context can
   * serialize the error as they see fit while including the proper response
   * code.  Examples here are 404 and 405 errors that occur prior to reaching
   * any user-defined loaders.
   *
   * - `opts.routeId` allows you to specify the specific route handler to call.
   *   If not provided the handler will determine the proper route by matching
   *   against `request.url`
   * - `opts.requestContext` is an optional server context that will be passed
   *    to actions/loaders in the `context` parameter
   */
  async function queryRoute(request, _temp4) {
    let {
      routeId,
      requestContext,
      dataStrategy
    } = _temp4 === void 0 ? {} : _temp4;
    let url = new URL(request.url);
    let method = request.method;
    let location = createLocation("", createPath(url), null, "default");
    let matches = matchRoutes(dataRoutes, location, basename);
    // SSR supports HEAD requests while SPA doesn't
    if (!isValidMethod(method) && method !== "HEAD" && method !== "OPTIONS") {
      throw getInternalRouterError(405, {
        method
      });
    } else if (!matches) {
      throw getInternalRouterError(404, {
        pathname: location.pathname
      });
    }
    let match = routeId ? matches.find(m => m.route.id === routeId) : getTargetMatch(matches, location);
    if (routeId && !match) {
      throw getInternalRouterError(403, {
        pathname: location.pathname,
        routeId
      });
    } else if (!match) {
      // This should never hit I don't think?
      throw getInternalRouterError(404, {
        pathname: location.pathname
      });
    }
    let result = await queryImpl(request, location, matches, requestContext, dataStrategy || null, false, match);
    if (isResponse(result)) {
      return result;
    }
    let error = result.errors ? Object.values(result.errors)[0] : undefined;
    if (error !== undefined) {
      // If we got back result.errors, that means the loader/action threw
      // _something_ that wasn't a Response, but it's not guaranteed/required
      // to be an `instanceof Error` either, so we have to use throw here to
      // preserve the "error" state outside of queryImpl.
      throw error;
    }
    // Pick off the right state value to return
    if (result.actionData) {
      return Object.values(result.actionData)[0];
    }
    if (result.loaderData) {
      var _result$activeDeferre;
      let data = Object.values(result.loaderData)[0];
      if ((_result$activeDeferre = result.activeDeferreds) != null && _result$activeDeferre[match.route.id]) {
        data[UNSAFE_DEFERRED_SYMBOL] = result.activeDeferreds[match.route.id];
      }
      return data;
    }
    return undefined;
  }
  async function queryImpl(request, location, matches, requestContext, dataStrategy, skipLoaderErrorBubbling, routeMatch) {
    invariant(request.signal, "query()/queryRoute() requests must contain an AbortController signal");
    try {
      if (isMutationMethod(request.method.toLowerCase())) {
        let result = await submit(request, matches, routeMatch || getTargetMatch(matches, location), requestContext, dataStrategy, skipLoaderErrorBubbling, routeMatch != null);
        return result;
      }
      let result = await loadRouteData(request, matches, requestContext, dataStrategy, skipLoaderErrorBubbling, routeMatch);
      return isResponse(result) ? result : _extends({}, result, {
        actionData: null,
        actionHeaders: {}
      });
    } catch (e) {
      // If the user threw/returned a Response in callLoaderOrAction for a
      // `queryRoute` call, we throw the `DataStrategyResult` to bail out early
      // and then return or throw the raw Response here accordingly
      if (isDataStrategyResult(e) && isResponse(e.result)) {
        if (e.type === ResultType.error) {
          throw e.result;
        }
        return e.result;
      }
      // Redirects are always returned since they don't propagate to catch
      // boundaries
      if (isRedirectResponse(e)) {
        return e;
      }
      throw e;
    }
  }
  async function submit(request, matches, actionMatch, requestContext, dataStrategy, skipLoaderErrorBubbling, isRouteRequest) {
    let result;
    if (!actionMatch.route.action && !actionMatch.route.lazy) {
      let error = getInternalRouterError(405, {
        method: request.method,
        pathname: new URL(request.url).pathname,
        routeId: actionMatch.route.id
      });
      if (isRouteRequest) {
        throw error;
      }
      result = {
        type: ResultType.error,
        error
      };
    } else {
      let results = await callDataStrategy("action", request, [actionMatch], matches, isRouteRequest, requestContext, dataStrategy);
      result = results[actionMatch.route.id];
      if (request.signal.aborted) {
        throwStaticHandlerAbortedError(request, isRouteRequest, future);
      }
    }
    if (isRedirectResult(result)) {
      // Uhhhh - this should never happen, we should always throw these from
      // callLoaderOrAction, but the type narrowing here keeps TS happy and we
      // can get back on the "throw all redirect responses" train here should
      // this ever happen :/
      throw new Response(null, {
        status: result.response.status,
        headers: {
          Location: result.response.headers.get("Location")
        }
      });
    }
    if (isDeferredResult(result)) {
      let error = getInternalRouterError(400, {
        type: "defer-action"
      });
      if (isRouteRequest) {
        throw error;
      }
      result = {
        type: ResultType.error,
        error
      };
    }
    if (isRouteRequest) {
      // Note: This should only be non-Response values if we get here, since
      // isRouteRequest should throw any Response received in callLoaderOrAction
      if (isErrorResult(result)) {
        throw result.error;
      }
      return {
        matches: [actionMatch],
        loaderData: {},
        actionData: {
          [actionMatch.route.id]: result.data
        },
        errors: null,
        // Note: statusCode + headers are unused here since queryRoute will
        // return the raw Response or value
        statusCode: 200,
        loaderHeaders: {},
        actionHeaders: {},
        activeDeferreds: null
      };
    }
    // Create a GET request for the loaders
    let loaderRequest = new Request(request.url, {
      headers: request.headers,
      redirect: request.redirect,
      signal: request.signal
    });
    if (isErrorResult(result)) {
      // Store off the pending error - we use it to determine which loaders
      // to call and will commit it when we complete the navigation
      let boundaryMatch = skipLoaderErrorBubbling ? actionMatch : findNearestBoundary(matches, actionMatch.route.id);
      let context = await loadRouteData(loaderRequest, matches, requestContext, dataStrategy, skipLoaderErrorBubbling, null, [boundaryMatch.route.id, result]);
      // action status codes take precedence over loader status codes
      return _extends({}, context, {
        statusCode: isRouteErrorResponse(result.error) ? result.error.status : result.statusCode != null ? result.statusCode : 500,
        actionData: null,
        actionHeaders: _extends({}, result.headers ? {
          [actionMatch.route.id]: result.headers
        } : {})
      });
    }
    let context = await loadRouteData(loaderRequest, matches, requestContext, dataStrategy, skipLoaderErrorBubbling, null);
    return _extends({}, context, {
      actionData: {
        [actionMatch.route.id]: result.data
      }
    }, result.statusCode ? {
      statusCode: result.statusCode
    } : {}, {
      actionHeaders: result.headers ? {
        [actionMatch.route.id]: result.headers
      } : {}
    });
  }
  async function loadRouteData(request, matches, requestContext, dataStrategy, skipLoaderErrorBubbling, routeMatch, pendingActionResult) {
    let isRouteRequest = routeMatch != null;
    // Short circuit if we have no loaders to run (queryRoute())
    if (isRouteRequest && !(routeMatch != null && routeMatch.route.loader) && !(routeMatch != null && routeMatch.route.lazy)) {
      throw getInternalRouterError(400, {
        method: request.method,
        pathname: new URL(request.url).pathname,
        routeId: routeMatch == null ? void 0 : routeMatch.route.id
      });
    }
    let requestMatches = routeMatch ? [routeMatch] : pendingActionResult && isErrorResult(pendingActionResult[1]) ? getLoaderMatchesUntilBoundary(matches, pendingActionResult[0]) : matches;
    let matchesToLoad = requestMatches.filter(m => m.route.loader || m.route.lazy);
    // Short circuit if we have no loaders to run (query())
    if (matchesToLoad.length === 0) {
      return {
        matches,
        // Add a null for all matched routes for proper revalidation on the client
        loaderData: matches.reduce((acc, m) => Object.assign(acc, {
          [m.route.id]: null
        }), {}),
        errors: pendingActionResult && isErrorResult(pendingActionResult[1]) ? {
          [pendingActionResult[0]]: pendingActionResult[1].error
        } : null,
        statusCode: 200,
        loaderHeaders: {},
        activeDeferreds: null
      };
    }
    let results = await callDataStrategy("loader", request, matchesToLoad, matches, isRouteRequest, requestContext, dataStrategy);
    if (request.signal.aborted) {
      throwStaticHandlerAbortedError(request, isRouteRequest, future);
    }
    // Process and commit output from loaders
    let activeDeferreds = new Map();
    let context = processRouteLoaderData(matches, results, pendingActionResult, activeDeferreds, skipLoaderErrorBubbling);
    // Add a null for any non-loader matches for proper revalidation on the client
    let executedLoaders = new Set(matchesToLoad.map(match => match.route.id));
    matches.forEach(match => {
      if (!executedLoaders.has(match.route.id)) {
        context.loaderData[match.route.id] = null;
      }
    });
    return _extends({}, context, {
      matches,
      activeDeferreds: activeDeferreds.size > 0 ? Object.fromEntries(activeDeferreds.entries()) : null
    });
  }
  // Utility wrapper for calling dataStrategy server-side without having to
  // pass around the manifest, mapRouteProperties, etc.
  async function callDataStrategy(type, request, matchesToLoad, matches, isRouteRequest, requestContext, dataStrategy) {
    let results = await callDataStrategyImpl(dataStrategy || defaultDataStrategy, type, null, request, matchesToLoad, matches, null, manifest, mapRouteProperties, requestContext);
    let dataResults = {};
    await Promise.all(matches.map(async match => {
      if (!(match.route.id in results)) {
        return;
      }
      let result = results[match.route.id];
      if (isRedirectDataStrategyResultResult(result)) {
        let response = result.result;
        // Throw redirects and let the server handle them with an HTTP redirect
        throw normalizeRelativeRoutingRedirectResponse(response, request, match.route.id, matches, basename, future.v7_relativeSplatPath);
      }
      if (isResponse(result.result) && isRouteRequest) {
        // For SSR single-route requests, we want to hand Responses back
        // directly without unwrapping
        throw result;
      }
      dataResults[match.route.id] = await convertDataStrategyResultToDataResult(result);
    }));
    return dataResults;
  }
  return {
    dataRoutes,
    query,
    queryRoute
  };
}
//#endregion
////////////////////////////////////////////////////////////////////////////////
//#region Helpers
////////////////////////////////////////////////////////////////////////////////
/**
 * Given an existing StaticHandlerContext and an error thrown at render time,
 * provide an updated StaticHandlerContext suitable for a second SSR render
 */
function getStaticContextFromError(routes, context, error) {
  let newContext = _extends({}, context, {
    statusCode: isRouteErrorResponse(error) ? error.status : 500,
    errors: {
      [context._deepestRenderedBoundaryId || routes[0].id]: error
    }
  });
  return newContext;
}
function throwStaticHandlerAbortedError(request, isRouteRequest, future) {
  if (future.v7_throwAbortReason && request.signal.reason !== undefined) {
    throw request.signal.reason;
  }
  let method = isRouteRequest ? "queryRoute" : "query";
  throw new Error(method + "() call aborted: " + request.method + " " + request.url);
}
function isSubmissionNavigation(opts) {
  return opts != null && ("formData" in opts && opts.formData != null || "body" in opts && opts.body !== undefined);
}
function normalizeTo(location, matches, basename, prependBasename, to, v7_relativeSplatPath, fromRouteId, relative) {
  let contextualMatches;
  let activeRouteMatch;
  if (fromRouteId) {
    // Grab matches up to the calling route so our route-relative logic is
    // relative to the correct source route
    contextualMatches = [];
    for (let match of matches) {
      contextualMatches.push(match);
      if (match.route.id === fromRouteId) {
        activeRouteMatch = match;
        break;
      }
    }
  } else {
    contextualMatches = matches;
    activeRouteMatch = matches[matches.length - 1];
  }
  // Resolve the relative path
  let path = resolveTo(to ? to : ".", getResolveToMatches(contextualMatches, v7_relativeSplatPath), stripBasename(location.pathname, basename) || location.pathname, relative === "path");
  // When `to` is not specified we inherit search/hash from the current
  // location, unlike when to="." and we just inherit the path.
  // See https://github.com/remix-run/remix/issues/927
  if (to == null) {
    path.search = location.search;
    path.hash = location.hash;
  }
  // Account for `?index` params when routing to the current location
  if ((to == null || to === "" || to === ".") && activeRouteMatch) {
    let nakedIndex = hasNakedIndexQuery(path.search);
    if (activeRouteMatch.route.index && !nakedIndex) {
      // Add one when we're targeting an index route
      path.search = path.search ? path.search.replace(/^\?/, "?index&") : "?index";
    } else if (!activeRouteMatch.route.index && nakedIndex) {
      // Remove existing ones when we're not
      let params = new URLSearchParams(path.search);
      let indexValues = params.getAll("index");
      params.delete("index");
      indexValues.filter(v => v).forEach(v => params.append("index", v));
      let qs = params.toString();
      path.search = qs ? "?" + qs : "";
    }
  }
  // If we're operating within a basename, prepend it to the pathname.  If
  // this is a root navigation, then just use the raw basename which allows
  // the basename to have full control over the presence of a trailing slash
  // on root actions
  if (prependBasename && basename !== "/") {
    path.pathname = path.pathname === "/" ? basename : joinPaths([basename, path.pathname]);
  }
  return createPath(path);
}
// Normalize navigation options by converting formMethod=GET formData objects to
// URLSearchParams so they behave identically to links with query params
function normalizeNavigateOptions(normalizeFormMethod, isFetcher, path, opts) {
  // Return location verbatim on non-submission navigations
  if (!opts || !isSubmissionNavigation(opts)) {
    return {
      path
    };
  }
  if (opts.formMethod && !isValidMethod(opts.formMethod)) {
    return {
      path,
      error: getInternalRouterError(405, {
        method: opts.formMethod
      })
    };
  }
  let getInvalidBodyError = () => ({
    path,
    error: getInternalRouterError(400, {
      type: "invalid-body"
    })
  });
  // Create a Submission on non-GET navigations
  let rawFormMethod = opts.formMethod || "get";
  let formMethod = normalizeFormMethod ? rawFormMethod.toUpperCase() : rawFormMethod.toLowerCase();
  let formAction = stripHashFromPath(path);
  if (opts.body !== undefined) {
    if (opts.formEncType === "text/plain") {
      // text only support POST/PUT/PATCH/DELETE submissions
      if (!isMutationMethod(formMethod)) {
        return getInvalidBodyError();
      }
      let text = typeof opts.body === "string" ? opts.body : opts.body instanceof FormData || opts.body instanceof URLSearchParams ?
      // https://html.spec.whatwg.org/multipage/form-control-infrastructure.html#plain-text-form-data
      Array.from(opts.body.entries()).reduce((acc, _ref3) => {
        let [name, value] = _ref3;
        return "" + acc + name + "=" + value + "\n";
      }, "") : String(opts.body);
      return {
        path,
        submission: {
          formMethod,
          formAction,
          formEncType: opts.formEncType,
          formData: undefined,
          json: undefined,
          text
        }
      };
    } else if (opts.formEncType === "application/json") {
      // json only supports POST/PUT/PATCH/DELETE submissions
      if (!isMutationMethod(formMethod)) {
        return getInvalidBodyError();
      }
      try {
        let json = typeof opts.body === "string" ? JSON.parse(opts.body) : opts.body;
        return {
          path,
          submission: {
            formMethod,
            formAction,
            formEncType: opts.formEncType,
            formData: undefined,
            json,
            text: undefined
          }
        };
      } catch (e) {
        return getInvalidBodyError();
      }
    }
  }
  invariant(typeof FormData === "function", "FormData is not available in this environment");
  let searchParams;
  let formData;
  if (opts.formData) {
    searchParams = convertFormDataToSearchParams(opts.formData);
    formData = opts.formData;
  } else if (opts.body instanceof FormData) {
    searchParams = convertFormDataToSearchParams(opts.body);
    formData = opts.body;
  } else if (opts.body instanceof URLSearchParams) {
    searchParams = opts.body;
    formData = convertSearchParamsToFormData(searchParams);
  } else if (opts.body == null) {
    searchParams = new URLSearchParams();
    formData = new FormData();
  } else {
    try {
      searchParams = new URLSearchParams(opts.body);
      formData = convertSearchParamsToFormData(searchParams);
    } catch (e) {
      return getInvalidBodyError();
    }
  }
  let submission = {
    formMethod,
    formAction,
    formEncType: opts && opts.formEncType || "application/x-www-form-urlencoded",
    formData,
    json: undefined,
    text: undefined
  };
  if (isMutationMethod(submission.formMethod)) {
    return {
      path,
      submission
    };
  }
  // Flatten submission onto URLSearchParams for GET submissions
  let parsedPath = parsePath(path);
  // On GET navigation submissions we can drop the ?index param from the
  // resulting location since all loaders will run.  But fetcher GET submissions
  // only run a single loader so we need to preserve any incoming ?index params
  if (isFetcher && parsedPath.search && hasNakedIndexQuery(parsedPath.search)) {
    searchParams.append("index", "");
  }
  parsedPath.search = "?" + searchParams;
  return {
    path: createPath(parsedPath),
    submission
  };
}
// Filter out all routes at/below any caught error as they aren't going to
// render so we don't need to load them
function getLoaderMatchesUntilBoundary(matches, boundaryId, includeBoundary) {
  if (includeBoundary === void 0) {
    includeBoundary = false;
  }
  let index = matches.findIndex(m => m.route.id === boundaryId);
  if (index >= 0) {
    return matches.slice(0, includeBoundary ? index + 1 : index);
  }
  return matches;
}
function getMatchesToLoad(history, state, matches, submission, location, initialHydration, skipActionErrorRevalidation, isRevalidationRequired, cancelledDeferredRoutes, cancelledFetcherLoads, deletedFetchers, fetchLoadMatches, fetchRedirectIds, routesToUse, basename, pendingActionResult) {
  let actionResult = pendingActionResult ? isErrorResult(pendingActionResult[1]) ? pendingActionResult[1].error : pendingActionResult[1].data : undefined;
  let currentUrl = history.createURL(state.location);
  let nextUrl = history.createURL(location);
  // Pick navigation matches that are net-new or qualify for revalidation
  let boundaryMatches = matches;
  if (initialHydration && state.errors) {
    // On initial hydration, only consider matches up to _and including_ the boundary.
    // This is inclusive to handle cases where a server loader ran successfully,
    // a child server loader bubbled up to this route, but this route has
    // `clientLoader.hydrate` so we want to still run the `clientLoader` so that
    // we have a complete version of `loaderData`
    boundaryMatches = getLoaderMatchesUntilBoundary(matches, Object.keys(state.errors)[0], true);
  } else if (pendingActionResult && isErrorResult(pendingActionResult[1])) {
    // If an action threw an error, we call loaders up to, but not including the
    // boundary
    boundaryMatches = getLoaderMatchesUntilBoundary(matches, pendingActionResult[0]);
  }
  // Don't revalidate loaders by default after action 4xx/5xx responses
  // when the flag is enabled.  They can still opt-into revalidation via
  // `shouldRevalidate` via `actionResult`
  let actionStatus = pendingActionResult ? pendingActionResult[1].statusCode : undefined;
  let shouldSkipRevalidation = skipActionErrorRevalidation && actionStatus && actionStatus >= 400;
  let navigationMatches = boundaryMatches.filter((match, index) => {
    let {
      route
    } = match;
    if (route.lazy) {
      // We haven't loaded this route yet so we don't know if it's got a loader!
      return true;
    }
    if (route.loader == null) {
      return false;
    }
    if (initialHydration) {
      return shouldLoadRouteOnHydration(route, state.loaderData, state.errors);
    }
    // Always call the loader on new route instances and pending defer cancellations
    if (isNewLoader(state.loaderData, state.matches[index], match) || cancelledDeferredRoutes.some(id => id === match.route.id)) {
      return true;
    }
    // This is the default implementation for when we revalidate.  If the route
    // provides it's own implementation, then we give them full control but
    // provide this value so they can leverage it if needed after they check
    // their own specific use cases
    let currentRouteMatch = state.matches[index];
    let nextRouteMatch = match;
    return shouldRevalidateLoader(match, _extends({
      currentUrl,
      currentParams: currentRouteMatch.params,
      nextUrl,
      nextParams: nextRouteMatch.params
    }, submission, {
      actionResult,
      actionStatus,
      defaultShouldRevalidate: shouldSkipRevalidation ? false :
      // Forced revalidation due to submission, useRevalidator, or X-Remix-Revalidate
      isRevalidationRequired || currentUrl.pathname + currentUrl.search === nextUrl.pathname + nextUrl.search ||
      // Search params affect all loaders
      currentUrl.search !== nextUrl.search || isNewRouteInstance(currentRouteMatch, nextRouteMatch)
    }));
  });
  // Pick fetcher.loads that need to be revalidated
  let revalidatingFetchers = [];
  fetchLoadMatches.forEach((f, key) => {
    // Don't revalidate:
    //  - on initial hydration (shouldn't be any fetchers then anyway)
    //  - if fetcher won't be present in the subsequent render
    //    - no longer matches the URL (v7_fetcherPersist=false)
    //    - was unmounted but persisted due to v7_fetcherPersist=true
    if (initialHydration || !matches.some(m => m.route.id === f.routeId) || deletedFetchers.has(key)) {
      return;
    }
    let fetcherMatches = matchRoutes(routesToUse, f.path, basename);
    // If the fetcher path no longer matches, push it in with null matches so
    // we can trigger a 404 in callLoadersAndMaybeResolveData.  Note this is
    // currently only a use-case for Remix HMR where the route tree can change
    // at runtime and remove a route previously loaded via a fetcher
    if (!fetcherMatches) {
      revalidatingFetchers.push({
        key,
        routeId: f.routeId,
        path: f.path,
        matches: null,
        match: null,
        controller: null
      });
      return;
    }
    // Revalidating fetchers are decoupled from the route matches since they
    // load from a static href.  They revalidate based on explicit revalidation
    // (submission, useRevalidator, or X-Remix-Revalidate)
    let fetcher = state.fetchers.get(key);
    let fetcherMatch = getTargetMatch(fetcherMatches, f.path);
    let shouldRevalidate = false;
    if (fetchRedirectIds.has(key)) {
      // Never trigger a revalidation of an actively redirecting fetcher
      shouldRevalidate = false;
    } else if (cancelledFetcherLoads.has(key)) {
      // Always mark for revalidation if the fetcher was cancelled
      cancelledFetcherLoads.delete(key);
      shouldRevalidate = true;
    } else if (fetcher && fetcher.state !== "idle" && fetcher.data === undefined) {
      // If the fetcher hasn't ever completed loading yet, then this isn't a
      // revalidation, it would just be a brand new load if an explicit
      // revalidation is required
      shouldRevalidate = isRevalidationRequired;
    } else {
      // Otherwise fall back on any user-defined shouldRevalidate, defaulting
      // to explicit revalidations only
      shouldRevalidate = shouldRevalidateLoader(fetcherMatch, _extends({
        currentUrl,
        currentParams: state.matches[state.matches.length - 1].params,
        nextUrl,
        nextParams: matches[matches.length - 1].params
      }, submission, {
        actionResult,
        actionStatus,
        defaultShouldRevalidate: shouldSkipRevalidation ? false : isRevalidationRequired
      }));
    }
    if (shouldRevalidate) {
      revalidatingFetchers.push({
        key,
        routeId: f.routeId,
        path: f.path,
        matches: fetcherMatches,
        match: fetcherMatch,
        controller: new AbortController()
      });
    }
  });
  return [navigationMatches, revalidatingFetchers];
}
function shouldLoadRouteOnHydration(route, loaderData, errors) {
  // We dunno if we have a loader - gotta find out!
  if (route.lazy) {
    return true;
  }
  // No loader, nothing to initialize
  if (!route.loader) {
    return false;
  }
  let hasData = loaderData != null && loaderData[route.id] !== undefined;
  let hasError = errors != null && errors[route.id] !== undefined;
  // Don't run if we error'd during SSR
  if (!hasData && hasError) {
    return false;
  }
  // Explicitly opting-in to running on hydration
  if (typeof route.loader === "function" && route.loader.hydrate === true) {
    return true;
  }
  // Otherwise, run if we're not yet initialized with anything
  return !hasData && !hasError;
}
function isNewLoader(currentLoaderData, currentMatch, match) {
  let isNew =
  // [a] -> [a, b]
  !currentMatch ||
  // [a, b] -> [a, c]
  match.route.id !== currentMatch.route.id;
  // Handle the case that we don't have data for a re-used route, potentially
  // from a prior error or from a cancelled pending deferred
  let isMissingData = currentLoaderData[match.route.id] === undefined;
  // Always load if this is a net-new route or we don't yet have data
  return isNew || isMissingData;
}
function isNewRouteInstance(currentMatch, match) {
  let currentPath = currentMatch.route.path;
  return (
    // param change for this match, /users/123 -> /users/456
    currentMatch.pathname !== match.pathname ||
    // splat param changed, which is not present in match.path
    // e.g. /files/images/avatar.jpg -> files/finances.xls
    currentPath != null && currentPath.endsWith("*") && currentMatch.params["*"] !== match.params["*"]
  );
}
function shouldRevalidateLoader(loaderMatch, arg) {
  if (loaderMatch.route.shouldRevalidate) {
    let routeChoice = loaderMatch.route.shouldRevalidate(arg);
    if (typeof routeChoice === "boolean") {
      return routeChoice;
    }
  }
  return arg.defaultShouldRevalidate;
}
function patchRoutesImpl(routeId, children, routesToUse, manifest, mapRouteProperties) {
  var _childrenToPatch;
  let childrenToPatch;
  if (routeId) {
    let route = manifest[routeId];
    invariant(route, "No route found to patch children into: routeId = " + routeId);
    if (!route.children) {
      route.children = [];
    }
    childrenToPatch = route.children;
  } else {
    childrenToPatch = routesToUse;
  }
  // Don't patch in routes we already know about so that `patch` is idempotent
  // to simplify user-land code. This is useful because we re-call the
  // `patchRoutesOnNavigation` function for matched routes with params.
  let uniqueChildren = children.filter(newRoute => !childrenToPatch.some(existingRoute => isSameRoute(newRoute, existingRoute)));
  let newRoutes = convertRoutesToDataRoutes(uniqueChildren, mapRouteProperties, [routeId || "_", "patch", String(((_childrenToPatch = childrenToPatch) == null ? void 0 : _childrenToPatch.length) || "0")], manifest);
  childrenToPatch.push(...newRoutes);
}
function isSameRoute(newRoute, existingRoute) {
  // Most optimal check is by id
  if ("id" in newRoute && "id" in existingRoute && newRoute.id === existingRoute.id) {
    return true;
  }
  // Second is by pathing differences
  if (!(newRoute.index === existingRoute.index && newRoute.path === existingRoute.path && newRoute.caseSensitive === existingRoute.caseSensitive)) {
    return false;
  }
  // Pathless layout routes are trickier since we need to check children.
  // If they have no children then they're the same as far as we can tell
  if ((!newRoute.children || newRoute.children.length === 0) && (!existingRoute.children || existingRoute.children.length === 0)) {
    return true;
  }
  // Otherwise, we look to see if every child in the new route is already
  // represented in the existing route's children
  return newRoute.children.every((aChild, i) => {
    var _existingRoute$childr;
    return (_existingRoute$childr = existingRoute.children) == null ? void 0 : _existingRoute$childr.some(bChild => isSameRoute(aChild, bChild));
  });
}
/**
 * Execute route.lazy() methods to lazily load route modules (loader, action,
 * shouldRevalidate) and update the routeManifest in place which shares objects
 * with dataRoutes so those get updated as well.
 */
async function loadLazyRouteModule(route, mapRouteProperties, manifest) {
  if (!route.lazy) {
    return;
  }
  let lazyRoute = await route.lazy();
  // If the lazy route function was executed and removed by another parallel
  // call then we can return - first lazy() to finish wins because the return
  // value of lazy is expected to be static
  if (!route.lazy) {
    return;
  }
  let routeToUpdate = manifest[route.id];
  invariant(routeToUpdate, "No route found in manifest");
  // Update the route in place.  This should be safe because there's no way
  // we could yet be sitting on this route as we can't get there without
  // resolving lazy() first.
  //
  // This is different than the HMR "update" use-case where we may actively be
  // on the route being updated.  The main concern boils down to "does this
  // mutation affect any ongoing navigations or any current state.matches
  // values?".  If not, it should be safe to update in place.
  let routeUpdates = {};
  for (let lazyRouteProperty in lazyRoute) {
    let staticRouteValue = routeToUpdate[lazyRouteProperty];
    let isPropertyStaticallyDefined = staticRouteValue !== undefined &&
    // This property isn't static since it should always be updated based
    // on the route updates
    lazyRouteProperty !== "hasErrorBoundary";
    warning(!isPropertyStaticallyDefined, "Route \"" + routeToUpdate.id + "\" has a static property \"" + lazyRouteProperty + "\" " + "defined but its lazy function is also returning a value for this property. " + ("The lazy route property \"" + lazyRouteProperty + "\" will be ignored."));
    if (!isPropertyStaticallyDefined && !immutableRouteKeys.has(lazyRouteProperty)) {
      routeUpdates[lazyRouteProperty] = lazyRoute[lazyRouteProperty];
    }
  }
  // Mutate the route with the provided updates.  Do this first so we pass
  // the updated version to mapRouteProperties
  Object.assign(routeToUpdate, routeUpdates);
  // Mutate the `hasErrorBoundary` property on the route based on the route
  // updates and remove the `lazy` function so we don't resolve the lazy
  // route again.
  Object.assign(routeToUpdate, _extends({}, mapRouteProperties(routeToUpdate), {
    lazy: undefined
  }));
}
// Default implementation of `dataStrategy` which fetches all loaders in parallel
async function defaultDataStrategy(_ref4) {
  let {
    matches
  } = _ref4;
  let matchesToLoad = matches.filter(m => m.shouldLoad);
  let results = await Promise.all(matchesToLoad.map(m => m.resolve()));
  return results.reduce((acc, result, i) => Object.assign(acc, {
    [matchesToLoad[i].route.id]: result
  }), {});
}
async function callDataStrategyImpl(dataStrategyImpl, type, state, request, matchesToLoad, matches, fetcherKey, manifest, mapRouteProperties, requestContext) {
  let loadRouteDefinitionsPromises = matches.map(m => m.route.lazy ? loadLazyRouteModule(m.route, mapRouteProperties, manifest) : undefined);
  let dsMatches = matches.map((match, i) => {
    let loadRoutePromise = loadRouteDefinitionsPromises[i];
    let shouldLoad = matchesToLoad.some(m => m.route.id === match.route.id);
    // `resolve` encapsulates route.lazy(), executing the loader/action,
    // and mapping return values/thrown errors to a `DataStrategyResult`.  Users
    // can pass a callback to take fine-grained control over the execution
    // of the loader/action
    let resolve = async handlerOverride => {
      if (handlerOverride && request.method === "GET" && (match.route.lazy || match.route.loader)) {
        shouldLoad = true;
      }
      return shouldLoad ? callLoaderOrAction(type, request, match, loadRoutePromise, handlerOverride, requestContext) : Promise.resolve({
        type: ResultType.data,
        result: undefined
      });
    };
    return _extends({}, match, {
      shouldLoad,
      resolve
    });
  });
  // Send all matches here to allow for a middleware-type implementation.
  // handler will be a no-op for unneeded routes and we filter those results
  // back out below.
  let results = await dataStrategyImpl({
    matches: dsMatches,
    request,
    params: matches[0].params,
    fetcherKey,
    context: requestContext
  });
  // Wait for all routes to load here but 'swallow the error since we want
  // it to bubble up from the `await loadRoutePromise` in `callLoaderOrAction` -
  // called from `match.resolve()`
  try {
    await Promise.all(loadRouteDefinitionsPromises);
  } catch (e) {
    // No-op
  }
  return results;
}
// Default logic for calling a loader/action is the user has no specified a dataStrategy
async function callLoaderOrAction(type, request, match, loadRoutePromise, handlerOverride, staticContext) {
  let result;
  let onReject;
  let runHandler = handler => {
    // Setup a promise we can race against so that abort signals short circuit
    let reject;
    // This will never resolve so safe to type it as Promise<DataStrategyResult> to
    // satisfy the function return value
    let abortPromise = new Promise((_, r) => reject = r);
    onReject = () => reject();
    request.signal.addEventListener("abort", onReject);
    let actualHandler = ctx => {
      if (typeof handler !== "function") {
        return Promise.reject(new Error("You cannot call the handler for a route which defines a boolean " + ("\"" + type + "\" [routeId: " + match.route.id + "]")));
      }
      return handler({
        request,
        params: match.params,
        context: staticContext
      }, ...(ctx !== undefined ? [ctx] : []));
    };
    let handlerPromise = (async () => {
      try {
        let val = await (handlerOverride ? handlerOverride(ctx => actualHandler(ctx)) : actualHandler());
        return {
          type: "data",
          result: val
        };
      } catch (e) {
        return {
          type: "error",
          result: e
        };
      }
    })();
    return Promise.race([handlerPromise, abortPromise]);
  };
  try {
    let handler = match.route[type];
    // If we have a route.lazy promise, await that first
    if (loadRoutePromise) {
      if (handler) {
        // Run statically defined handler in parallel with lazy()
        let handlerError;
        let [value] = await Promise.all([
        // If the handler throws, don't let it immediately bubble out,
        // since we need to let the lazy() execution finish so we know if this
        // route has a boundary that can handle the error
        runHandler(handler).catch(e => {
          handlerError = e;
        }), loadRoutePromise]);
        if (handlerError !== undefined) {
          throw handlerError;
        }
        result = value;
      } else {
        // Load lazy route module, then run any returned handler
        await loadRoutePromise;
        handler = match.route[type];
        if (handler) {
          // Handler still runs even if we got interrupted to maintain consistency
          // with un-abortable behavior of handler execution on non-lazy or
          // previously-lazy-loaded routes
          result = await runHandler(handler);
        } else if (type === "action") {
          let url = new URL(request.url);
          let pathname = url.pathname + url.search;
          throw getInternalRouterError(405, {
            method: request.method,
            pathname,
            routeId: match.route.id
          });
        } else {
          // lazy() route has no loader to run.  Short circuit here so we don't
          // hit the invariant below that errors on returning undefined.
          return {
            type: ResultType.data,
            result: undefined
          };
        }
      }
    } else if (!handler) {
      let url = new URL(request.url);
      let pathname = url.pathname + url.search;
      throw getInternalRouterError(404, {
        pathname
      });
    } else {
      result = await runHandler(handler);
    }
    invariant(result.result !== undefined, "You defined " + (type === "action" ? "an action" : "a loader") + " for route " + ("\"" + match.route.id + "\" but didn't return anything from your `" + type + "` ") + "function. Please return a value or `null`.");
  } catch (e) {
    // We should already be catching and converting normal handler executions to
    // DataStrategyResults and returning them, so anything that throws here is an
    // unexpected error we still need to wrap
    return {
      type: ResultType.error,
      result: e
    };
  } finally {
    if (onReject) {
      request.signal.removeEventListener("abort", onReject);
    }
  }
  return result;
}
async function convertDataStrategyResultToDataResult(dataStrategyResult) {
  let {
    result,
    type
  } = dataStrategyResult;
  if (isResponse(result)) {
    let data;
    try {
      let contentType = result.headers.get("Content-Type");
      // Check between word boundaries instead of startsWith() due to the last
      // paragraph of https://httpwg.org/specs/rfc9110.html#field.content-type
      if (contentType && /\bapplication\/json\b/.test(contentType)) {
        if (result.body == null) {
          data = null;
        } else {
          data = await result.json();
        }
      } else {
        data = await result.text();
      }
    } catch (e) {
      return {
        type: ResultType.error,
        error: e
      };
    }
    if (type === ResultType.error) {
      return {
        type: ResultType.error,
        error: new ErrorResponseImpl(result.status, result.statusText, data),
        statusCode: result.status,
        headers: result.headers
      };
    }
    return {
      type: ResultType.data,
      data,
      statusCode: result.status,
      headers: result.headers
    };
  }
  if (type === ResultType.error) {
    if (isDataWithResponseInit(result)) {
      var _result$init3, _result$init4;
      if (result.data instanceof Error) {
        var _result$init, _result$init2;
        return {
          type: ResultType.error,
          error: result.data,
          statusCode: (_result$init = result.init) == null ? void 0 : _result$init.status,
          headers: (_result$init2 = result.init) != null && _result$init2.headers ? new Headers(result.init.headers) : undefined
        };
      }
      // Convert thrown data() to ErrorResponse instances
      return {
        type: ResultType.error,
        error: new ErrorResponseImpl(((_result$init3 = result.init) == null ? void 0 : _result$init3.status) || 500, undefined, result.data),
        statusCode: isRouteErrorResponse(result) ? result.status : undefined,
        headers: (_result$init4 = result.init) != null && _result$init4.headers ? new Headers(result.init.headers) : undefined
      };
    }
    return {
      type: ResultType.error,
      error: result,
      statusCode: isRouteErrorResponse(result) ? result.status : undefined
    };
  }
  if (isDeferredData(result)) {
    var _result$init5, _result$init6;
    return {
      type: ResultType.deferred,
      deferredData: result,
      statusCode: (_result$init5 = result.init) == null ? void 0 : _result$init5.status,
      headers: ((_result$init6 = result.init) == null ? void 0 : _result$init6.headers) && new Headers(result.init.headers)
    };
  }
  if (isDataWithResponseInit(result)) {
    var _result$init7, _result$init8;
    return {
      type: ResultType.data,
      data: result.data,
      statusCode: (_result$init7 = result.init) == null ? void 0 : _result$init7.status,
      headers: (_result$init8 = result.init) != null && _result$init8.headers ? new Headers(result.init.headers) : undefined
    };
  }
  return {
    type: ResultType.data,
    data: result
  };
}
// Support relative routing in internal redirects
function normalizeRelativeRoutingRedirectResponse(response, request, routeId, matches, basename, v7_relativeSplatPath) {
  let location = response.headers.get("Location");
  invariant(location, "Redirects returned/thrown from loaders/actions must have a Location header");
  if (!ABSOLUTE_URL_REGEX.test(location)) {
    let trimmedMatches = matches.slice(0, matches.findIndex(m => m.route.id === routeId) + 1);
    location = normalizeTo(new URL(request.url), trimmedMatches, basename, true, location, v7_relativeSplatPath);
    response.headers.set("Location", location);
  }
  return response;
}
function normalizeRedirectLocation(location, currentUrl, basename) {
  if (ABSOLUTE_URL_REGEX.test(location)) {
    // Strip off the protocol+origin for same-origin + same-basename absolute redirects
    let normalizedLocation = location;
    let url = normalizedLocation.startsWith("//") ? new URL(currentUrl.protocol + normalizedLocation) : new URL(normalizedLocation);
    let isSameBasename = stripBasename(url.pathname, basename) != null;
    if (url.origin === currentUrl.origin && isSameBasename) {
      return url.pathname + url.search + url.hash;
    }
  }
  return location;
}
// Utility method for creating the Request instances for loaders/actions during
// client-side navigations and fetches.  During SSR we will always have a
// Request instance from the static handler (query/queryRoute)
function createClientSideRequest(history, location, signal, submission) {
  let url = history.createURL(stripHashFromPath(location)).toString();
  let init = {
    signal
  };
  if (submission && isMutationMethod(submission.formMethod)) {
    let {
      formMethod,
      formEncType
    } = submission;
    // Didn't think we needed this but it turns out unlike other methods, patch
    // won't be properly normalized to uppercase and results in a 405 error.
    // See: https://fetch.spec.whatwg.org/#concept-method
    init.method = formMethod.toUpperCase();
    if (formEncType === "application/json") {
      init.headers = new Headers({
        "Content-Type": formEncType
      });
      init.body = JSON.stringify(submission.json);
    } else if (formEncType === "text/plain") {
      // Content-Type is inferred (https://fetch.spec.whatwg.org/#dom-request)
      init.body = submission.text;
    } else if (formEncType === "application/x-www-form-urlencoded" && submission.formData) {
      // Content-Type is inferred (https://fetch.spec.whatwg.org/#dom-request)
      init.body = convertFormDataToSearchParams(submission.formData);
    } else {
      // Content-Type is inferred (https://fetch.spec.whatwg.org/#dom-request)
      init.body = submission.formData;
    }
  }
  return new Request(url, init);
}
function convertFormDataToSearchParams(formData) {
  let searchParams = new URLSearchParams();
  for (let [key, value] of formData.entries()) {
    // https://html.spec.whatwg.org/multipage/form-control-infrastructure.html#converting-an-entry-list-to-a-list-of-name-value-pairs
    searchParams.append(key, typeof value === "string" ? value : value.name);
  }
  return searchParams;
}
function convertSearchParamsToFormData(searchParams) {
  let formData = new FormData();
  for (let [key, value] of searchParams.entries()) {
    formData.append(key, value);
  }
  return formData;
}
function processRouteLoaderData(matches, results, pendingActionResult, activeDeferreds, skipLoaderErrorBubbling) {
  // Fill in loaderData/errors from our loaders
  let loaderData = {};
  let errors = null;
  let statusCode;
  let foundError = false;
  let loaderHeaders = {};
  let pendingError = pendingActionResult && isErrorResult(pendingActionResult[1]) ? pendingActionResult[1].error : undefined;
  // Process loader results into state.loaderData/state.errors
  matches.forEach(match => {
    if (!(match.route.id in results)) {
      return;
    }
    let id = match.route.id;
    let result = results[id];
    invariant(!isRedirectResult(result), "Cannot handle redirect results in processLoaderData");
    if (isErrorResult(result)) {
      let error = result.error;
      // If we have a pending action error, we report it at the highest-route
      // that throws a loader error, and then clear it out to indicate that
      // it was consumed
      if (pendingError !== undefined) {
        error = pendingError;
        pendingError = undefined;
      }
      errors = errors || {};
      if (skipLoaderErrorBubbling) {
        errors[id] = error;
      } else {
        // Look upwards from the matched route for the closest ancestor error
        // boundary, defaulting to the root match.  Prefer higher error values
        // if lower errors bubble to the same boundary
        let boundaryMatch = findNearestBoundary(matches, id);
        if (errors[boundaryMatch.route.id] == null) {
          errors[boundaryMatch.route.id] = error;
        }
      }
      // Clear our any prior loaderData for the throwing route
      loaderData[id] = undefined;
      // Once we find our first (highest) error, we set the status code and
      // prevent deeper status codes from overriding
      if (!foundError) {
        foundError = true;
        statusCode = isRouteErrorResponse(result.error) ? result.error.status : 500;
      }
      if (result.headers) {
        loaderHeaders[id] = result.headers;
      }
    } else {
      if (isDeferredResult(result)) {
        activeDeferreds.set(id, result.deferredData);
        loaderData[id] = result.deferredData.data;
        // Error status codes always override success status codes, but if all
        // loaders are successful we take the deepest status code.
        if (result.statusCode != null && result.statusCode !== 200 && !foundError) {
          statusCode = result.statusCode;
        }
        if (result.headers) {
          loaderHeaders[id] = result.headers;
        }
      } else {
        loaderData[id] = result.data;
        // Error status codes always override success status codes, but if all
        // loaders are successful we take the deepest status code.
        if (result.statusCode && result.statusCode !== 200 && !foundError) {
          statusCode = result.statusCode;
        }
        if (result.headers) {
          loaderHeaders[id] = result.headers;
        }
      }
    }
  });
  // If we didn't consume the pending action error (i.e., all loaders
  // resolved), then consume it here.  Also clear out any loaderData for the
  // throwing route
  if (pendingError !== undefined && pendingActionResult) {
    errors = {
      [pendingActionResult[0]]: pendingError
    };
    loaderData[pendingActionResult[0]] = undefined;
  }
  return {
    loaderData,
    errors,
    statusCode: statusCode || 200,
    loaderHeaders
  };
}
function processLoaderData(state, matches, results, pendingActionResult, revalidatingFetchers, fetcherResults, activeDeferreds) {
  let {
    loaderData,
    errors
  } = processRouteLoaderData(matches, results, pendingActionResult, activeDeferreds, false // This method is only called client side so we always want to bubble
  );
  // Process results from our revalidating fetchers
  revalidatingFetchers.forEach(rf => {
    let {
      key,
      match,
      controller
    } = rf;
    let result = fetcherResults[key];
    invariant(result, "Did not find corresponding fetcher result");
    // Process fetcher non-redirect errors
    if (controller && controller.signal.aborted) {
      // Nothing to do for aborted fetchers
      return;
    } else if (isErrorResult(result)) {
      let boundaryMatch = findNearestBoundary(state.matches, match == null ? void 0 : match.route.id);
      if (!(errors && errors[boundaryMatch.route.id])) {
        errors = _extends({}, errors, {
          [boundaryMatch.route.id]: result.error
        });
      }
      state.fetchers.delete(key);
    } else if (isRedirectResult(result)) {
      // Should never get here, redirects should get processed above, but we
      // keep this to type narrow to a success result in the else
      invariant(false, "Unhandled fetcher revalidation redirect");
    } else if (isDeferredResult(result)) {
      // Should never get here, deferred data should be awaited for fetchers
      // in resolveDeferredResults
      invariant(false, "Unhandled fetcher deferred data");
    } else {
      let doneFetcher = getDoneFetcher(result.data);
      state.fetchers.set(key, doneFetcher);
    }
  });
  return {
    loaderData,
    errors
  };
}
function mergeLoaderData(loaderData, newLoaderData, matches, errors) {
  let mergedLoaderData = _extends({}, newLoaderData);
  for (let match of matches) {
    let id = match.route.id;
    if (newLoaderData.hasOwnProperty(id)) {
      if (newLoaderData[id] !== undefined) {
        mergedLoaderData[id] = newLoaderData[id];
      }
    } else if (loaderData[id] !== undefined && match.route.loader) {
      // Preserve existing keys not included in newLoaderData and where a loader
      // wasn't removed by HMR
      mergedLoaderData[id] = loaderData[id];
    }
    if (errors && errors.hasOwnProperty(id)) {
      // Don't keep any loader data below the boundary
      break;
    }
  }
  return mergedLoaderData;
}
function getActionDataForCommit(pendingActionResult) {
  if (!pendingActionResult) {
    return {};
  }
  return isErrorResult(pendingActionResult[1]) ? {
    // Clear out prior actionData on errors
    actionData: {}
  } : {
    actionData: {
      [pendingActionResult[0]]: pendingActionResult[1].data
    }
  };
}
// Find the nearest error boundary, looking upwards from the leaf route (or the
// route specified by routeId) for the closest ancestor error boundary,
// defaulting to the root match
function findNearestBoundary(matches, routeId) {
  let eligibleMatches = routeId ? matches.slice(0, matches.findIndex(m => m.route.id === routeId) + 1) : [...matches];
  return eligibleMatches.reverse().find(m => m.route.hasErrorBoundary === true) || matches[0];
}
function getShortCircuitMatches(routes) {
  // Prefer a root layout route if present, otherwise shim in a route object
  let route = routes.length === 1 ? routes[0] : routes.find(r => r.index || !r.path || r.path === "/") || {
    id: "__shim-error-route__"
  };
  return {
    matches: [{
      params: {},
      pathname: "",
      pathnameBase: "",
      route
    }],
    route
  };
}
function getInternalRouterError(status, _temp5) {
  let {
    pathname,
    routeId,
    method,
    type,
    message
  } = _temp5 === void 0 ? {} : _temp5;
  let statusText = "Unknown Server Error";
  let errorMessage = "Unknown @remix-run/router error";
  if (status === 400) {
    statusText = "Bad Request";
    if (method && pathname && routeId) {
      errorMessage = "You made a " + method + " request to \"" + pathname + "\" but " + ("did not provide a `loader` for route \"" + routeId + "\", ") + "so there is no way to handle the request.";
    } else if (type === "defer-action") {
      errorMessage = "defer() is not supported in actions";
    } else if (type === "invalid-body") {
      errorMessage = "Unable to encode submission body";
    }
  } else if (status === 403) {
    statusText = "Forbidden";
    errorMessage = "Route \"" + routeId + "\" does not match URL \"" + pathname + "\"";
  } else if (status === 404) {
    statusText = "Not Found";
    errorMessage = "No route matches URL \"" + pathname + "\"";
  } else if (status === 405) {
    statusText = "Method Not Allowed";
    if (method && pathname && routeId) {
      errorMessage = "You made a " + method.toUpperCase() + " request to \"" + pathname + "\" but " + ("did not provide an `action` for route \"" + routeId + "\", ") + "so there is no way to handle the request.";
    } else if (method) {
      errorMessage = "Invalid request method \"" + method.toUpperCase() + "\"";
    }
  }
  return new ErrorResponseImpl(status || 500, statusText, new Error(errorMessage), true);
}
// Find any returned redirect errors, starting from the lowest match
function findRedirect(results) {
  let entries = Object.entries(results);
  for (let i = entries.length - 1; i >= 0; i--) {
    let [key, result] = entries[i];
    if (isRedirectResult(result)) {
      return {
        key,
        result
      };
    }
  }
}
function stripHashFromPath(path) {
  let parsedPath = typeof path === "string" ? parsePath(path) : path;
  return createPath(_extends({}, parsedPath, {
    hash: ""
  }));
}
function isHashChangeOnly(a, b) {
  if (a.pathname !== b.pathname || a.search !== b.search) {
    return false;
  }
  if (a.hash === "") {
    // /page -> /page#hash
    return b.hash !== "";
  } else if (a.hash === b.hash) {
    // /page#hash -> /page#hash
    return true;
  } else if (b.hash !== "") {
    // /page#hash -> /page#other
    return true;
  }
  // If the hash is removed the browser will re-perform a request to the server
  // /page#hash -> /page
  return false;
}
function isDataStrategyResult(result) {
  return result != null && typeof result === "object" && "type" in result && "result" in result && (result.type === ResultType.data || result.type === ResultType.error);
}
function isRedirectDataStrategyResultResult(result) {
  return isResponse(result.result) && redirectStatusCodes.has(result.result.status);
}
function isDeferredResult(result) {
  return result.type === ResultType.deferred;
}
function isErrorResult(result) {
  return result.type === ResultType.error;
}
function isRedirectResult(result) {
  return (result && result.type) === ResultType.redirect;
}
function isDataWithResponseInit(value) {
  return typeof value === "object" && value != null && "type" in value && "data" in value && "init" in value && value.type === "DataWithResponseInit";
}
function isDeferredData(value) {
  let deferred = value;
  return deferred && typeof deferred === "object" && typeof deferred.data === "object" && typeof deferred.subscribe === "function" && typeof deferred.cancel === "function" && typeof deferred.resolveData === "function";
}
function isResponse(value) {
  return value != null && typeof value.status === "number" && typeof value.statusText === "string" && typeof value.headers === "object" && typeof value.body !== "undefined";
}
function isRedirectResponse(result) {
  if (!isResponse(result)) {
    return false;
  }
  let status = result.status;
  let location = result.headers.get("Location");
  return status >= 300 && status <= 399 && location != null;
}
function isValidMethod(method) {
  return validRequestMethods.has(method.toLowerCase());
}
function isMutationMethod(method) {
  return validMutationMethods.has(method.toLowerCase());
}
async function resolveNavigationDeferredResults(matches, results, signal, currentMatches, currentLoaderData) {
  let entries = Object.entries(results);
  for (let index = 0; index < entries.length; index++) {
    let [routeId, result] = entries[index];
    let match = matches.find(m => (m == null ? void 0 : m.route.id) === routeId);
    // If we don't have a match, then we can have a deferred result to do
    // anything with.  This is for revalidating fetchers where the route was
    // removed during HMR
    if (!match) {
      continue;
    }
    let currentMatch = currentMatches.find(m => m.route.id === match.route.id);
    let isRevalidatingLoader = currentMatch != null && !isNewRouteInstance(currentMatch, match) && (currentLoaderData && currentLoaderData[match.route.id]) !== undefined;
    if (isDeferredResult(result) && isRevalidatingLoader) {
      // Note: we do not have to touch activeDeferreds here since we race them
      // against the signal in resolveDeferredData and they'll get aborted
      // there if needed
      await resolveDeferredData(result, signal, false).then(result => {
        if (result) {
          results[routeId] = result;
        }
      });
    }
  }
}
async function resolveFetcherDeferredResults(matches, results, revalidatingFetchers) {
  for (let index = 0; index < revalidatingFetchers.length; index++) {
    let {
      key,
      routeId,
      controller
    } = revalidatingFetchers[index];
    let result = results[key];
    let match = matches.find(m => (m == null ? void 0 : m.route.id) === routeId);
    // If we don't have a match, then we can have a deferred result to do
    // anything with.  This is for revalidating fetchers where the route was
    // removed during HMR
    if (!match) {
      continue;
    }
    if (isDeferredResult(result)) {
      // Note: we do not have to touch activeDeferreds here since we race them
      // against the signal in resolveDeferredData and they'll get aborted
      // there if needed
      invariant(controller, "Expected an AbortController for revalidating fetcher deferred result");
      await resolveDeferredData(result, controller.signal, true).then(result => {
        if (result) {
          results[key] = result;
        }
      });
    }
  }
}
async function resolveDeferredData(result, signal, unwrap) {
  if (unwrap === void 0) {
    unwrap = false;
  }
  let aborted = await result.deferredData.resolveData(signal);
  if (aborted) {
    return;
  }
  if (unwrap) {
    try {
      return {
        type: ResultType.data,
        data: result.deferredData.unwrappedData
      };
    } catch (e) {
      // Handle any TrackedPromise._error values encountered while unwrapping
      return {
        type: ResultType.error,
        error: e
      };
    }
  }
  return {
    type: ResultType.data,
    data: result.deferredData.data
  };
}
function hasNakedIndexQuery(search) {
  return new URLSearchParams(search).getAll("index").some(v => v === "");
}
function getTargetMatch(matches, location) {
  let search = typeof location === "string" ? parsePath(location).search : location.search;
  if (matches[matches.length - 1].route.index && hasNakedIndexQuery(search || "")) {
    // Return the leaf index route when index is present
    return matches[matches.length - 1];
  }
  // Otherwise grab the deepest "path contributing" match (ignoring index and
  // pathless layout routes)
  let pathMatches = getPathContributingMatches(matches);
  return pathMatches[pathMatches.length - 1];
}
function getSubmissionFromNavigation(navigation) {
  let {
    formMethod,
    formAction,
    formEncType,
    text,
    formData,
    json
  } = navigation;
  if (!formMethod || !formAction || !formEncType) {
    return;
  }
  if (text != null) {
    return {
      formMethod,
      formAction,
      formEncType,
      formData: undefined,
      json: undefined,
      text
    };
  } else if (formData != null) {
    return {
      formMethod,
      formAction,
      formEncType,
      formData,
      json: undefined,
      text: undefined
    };
  } else if (json !== undefined) {
    return {
      formMethod,
      formAction,
      formEncType,
      formData: undefined,
      json,
      text: undefined
    };
  }
}
function getLoadingNavigation(location, submission) {
  if (submission) {
    let navigation = {
      state: "loading",
      location,
      formMethod: submission.formMethod,
      formAction: submission.formAction,
      formEncType: submission.formEncType,
      formData: submission.formData,
      json: submission.json,
      text: submission.text
    };
    return navigation;
  } else {
    let navigation = {
      state: "loading",
      location,
      formMethod: undefined,
      formAction: undefined,
      formEncType: undefined,
      formData: undefined,
      json: undefined,
      text: undefined
    };
    return navigation;
  }
}
function getSubmittingNavigation(location, submission) {
  let navigation = {
    state: "submitting",
    location,
    formMethod: submission.formMethod,
    formAction: submission.formAction,
    formEncType: submission.formEncType,
    formData: submission.formData,
    json: submission.json,
    text: submission.text
  };
  return navigation;
}
function getLoadingFetcher(submission, data) {
  if (submission) {
    let fetcher = {
      state: "loading",
      formMethod: submission.formMethod,
      formAction: submission.formAction,
      formEncType: submission.formEncType,
      formData: submission.formData,
      json: submission.json,
      text: submission.text,
      data
    };
    return fetcher;
  } else {
    let fetcher = {
      state: "loading",
      formMethod: undefined,
      formAction: undefined,
      formEncType: undefined,
      formData: undefined,
      json: undefined,
      text: undefined,
      data
    };
    return fetcher;
  }
}
function getSubmittingFetcher(submission, existingFetcher) {
  let fetcher = {
    state: "submitting",
    formMethod: submission.formMethod,
    formAction: submission.formAction,
    formEncType: submission.formEncType,
    formData: submission.formData,
    json: submission.json,
    text: submission.text,
    data: existingFetcher ? existingFetcher.data : undefined
  };
  return fetcher;
}
function getDoneFetcher(data) {
  let fetcher = {
    state: "idle",
    formMethod: undefined,
    formAction: undefined,
    formEncType: undefined,
    formData: undefined,
    json: undefined,
    text: undefined,
    data
  };
  return fetcher;
}
function restoreAppliedTransitions(_window, transitions) {
  try {
    let sessionPositions = _window.sessionStorage.getItem(TRANSITIONS_STORAGE_KEY);
    if (sessionPositions) {
      let json = JSON.parse(sessionPositions);
      for (let [k, v] of Object.entries(json || {})) {
        if (v && Array.isArray(v)) {
          transitions.set(k, new Set(v || []));
        }
      }
    }
  } catch (e) {
    // no-op, use default empty object
  }
}
function persistAppliedTransitions(_window, transitions) {
  if (transitions.size > 0) {
    let json = {};
    for (let [k, v] of transitions) {
      json[k] = [...v];
    }
    try {
      _window.sessionStorage.setItem(TRANSITIONS_STORAGE_KEY, JSON.stringify(json));
    } catch (error) {
      warning(false, "Failed to save applied view transitions in sessionStorage (" + error + ").");
    }
  }
}
//#endregion


//# sourceMappingURL=router.js.map


/***/ },

/***/ "./node_modules/react-router-dom/dist/index.js"
/*!*****************************************************!*\
  !*** ./node_modules/react-router-dom/dist/index.js ***!
  \*****************************************************/
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AbortedDeferredError: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.AbortedDeferredError),
/* harmony export */   Await: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.Await),
/* harmony export */   BrowserRouter: () => (/* binding */ BrowserRouter),
/* harmony export */   Form: () => (/* binding */ Form),
/* harmony export */   HashRouter: () => (/* binding */ HashRouter),
/* harmony export */   Link: () => (/* binding */ Link),
/* harmony export */   MemoryRouter: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.MemoryRouter),
/* harmony export */   NavLink: () => (/* binding */ NavLink),
/* harmony export */   Navigate: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.Navigate),
/* harmony export */   NavigationType: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.Action),
/* harmony export */   Outlet: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.Outlet),
/* harmony export */   Route: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.Route),
/* harmony export */   Router: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.Router),
/* harmony export */   RouterProvider: () => (/* binding */ RouterProvider),
/* harmony export */   Routes: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.Routes),
/* harmony export */   ScrollRestoration: () => (/* binding */ ScrollRestoration),
/* harmony export */   UNSAFE_DataRouterContext: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.UNSAFE_DataRouterContext),
/* harmony export */   UNSAFE_DataRouterStateContext: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.UNSAFE_DataRouterStateContext),
/* harmony export */   UNSAFE_ErrorResponseImpl: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.UNSAFE_ErrorResponseImpl),
/* harmony export */   UNSAFE_FetchersContext: () => (/* binding */ FetchersContext),
/* harmony export */   UNSAFE_LocationContext: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.UNSAFE_LocationContext),
/* harmony export */   UNSAFE_NavigationContext: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.UNSAFE_NavigationContext),
/* harmony export */   UNSAFE_RouteContext: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.UNSAFE_RouteContext),
/* harmony export */   UNSAFE_ViewTransitionContext: () => (/* binding */ ViewTransitionContext),
/* harmony export */   UNSAFE_useRouteId: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.UNSAFE_useRouteId),
/* harmony export */   UNSAFE_useScrollRestoration: () => (/* binding */ useScrollRestoration),
/* harmony export */   createBrowserRouter: () => (/* binding */ createBrowserRouter),
/* harmony export */   createHashRouter: () => (/* binding */ createHashRouter),
/* harmony export */   createMemoryRouter: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.createMemoryRouter),
/* harmony export */   createPath: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.createPath),
/* harmony export */   createRoutesFromChildren: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.createRoutesFromChildren),
/* harmony export */   createRoutesFromElements: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.createRoutesFromElements),
/* harmony export */   createSearchParams: () => (/* binding */ createSearchParams),
/* harmony export */   defer: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.defer),
/* harmony export */   generatePath: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.generatePath),
/* harmony export */   isRouteErrorResponse: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.isRouteErrorResponse),
/* harmony export */   json: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.json),
/* harmony export */   matchPath: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.matchPath),
/* harmony export */   matchRoutes: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.matchRoutes),
/* harmony export */   parsePath: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.parsePath),
/* harmony export */   redirect: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.redirect),
/* harmony export */   redirectDocument: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.redirectDocument),
/* harmony export */   renderMatches: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.renderMatches),
/* harmony export */   replace: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.replace),
/* harmony export */   resolvePath: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.resolvePath),
/* harmony export */   unstable_HistoryRouter: () => (/* binding */ HistoryRouter),
/* harmony export */   unstable_usePrompt: () => (/* binding */ usePrompt),
/* harmony export */   useActionData: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.useActionData),
/* harmony export */   useAsyncError: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.useAsyncError),
/* harmony export */   useAsyncValue: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.useAsyncValue),
/* harmony export */   useBeforeUnload: () => (/* binding */ useBeforeUnload),
/* harmony export */   useBlocker: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.useBlocker),
/* harmony export */   useFetcher: () => (/* binding */ useFetcher),
/* harmony export */   useFetchers: () => (/* binding */ useFetchers),
/* harmony export */   useFormAction: () => (/* binding */ useFormAction),
/* harmony export */   useHref: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.useHref),
/* harmony export */   useInRouterContext: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.useInRouterContext),
/* harmony export */   useLinkClickHandler: () => (/* binding */ useLinkClickHandler),
/* harmony export */   useLoaderData: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.useLoaderData),
/* harmony export */   useLocation: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.useLocation),
/* harmony export */   useMatch: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.useMatch),
/* harmony export */   useMatches: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.useMatches),
/* harmony export */   useNavigate: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.useNavigate),
/* harmony export */   useNavigation: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.useNavigation),
/* harmony export */   useNavigationType: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.useNavigationType),
/* harmony export */   useOutlet: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.useOutlet),
/* harmony export */   useOutletContext: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.useOutletContext),
/* harmony export */   useParams: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.useParams),
/* harmony export */   useResolvedPath: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.useResolvedPath),
/* harmony export */   useRevalidator: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.useRevalidator),
/* harmony export */   useRouteError: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.useRouteError),
/* harmony export */   useRouteLoaderData: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.useRouteLoaderData),
/* harmony export */   useRoutes: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.useRoutes),
/* harmony export */   useSearchParams: () => (/* binding */ useSearchParams),
/* harmony export */   useSubmit: () => (/* binding */ useSubmit),
/* harmony export */   useViewTransitionState: () => (/* binding */ useViewTransitionState)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react-dom */ "react-dom");
/* harmony import */ var react_dom__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_dom__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_router__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react-router */ "./node_modules/react-router/dist/index.js");
/* harmony import */ var react_router__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @remix-run/router */ "./node_modules/@remix-run/router/dist/router.js");
/**
 * React Router DOM v6.30.2
 *
 * Copyright (c) Remix Software Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE.md file in the root directory of this source tree.
 *
 * @license MIT
 */







function _extends() {
  _extends = Object.assign ? Object.assign.bind() : function (target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i];
      for (var key in source) {
        if (Object.prototype.hasOwnProperty.call(source, key)) {
          target[key] = source[key];
        }
      }
    }
    return target;
  };
  return _extends.apply(this, arguments);
}
function _objectWithoutPropertiesLoose(source, excluded) {
  if (source == null) return {};
  var target = {};
  var sourceKeys = Object.keys(source);
  var key, i;
  for (i = 0; i < sourceKeys.length; i++) {
    key = sourceKeys[i];
    if (excluded.indexOf(key) >= 0) continue;
    target[key] = source[key];
  }
  return target;
}

const defaultMethod = "get";
const defaultEncType = "application/x-www-form-urlencoded";
function isHtmlElement(object) {
  return object != null && typeof object.tagName === "string";
}
function isButtonElement(object) {
  return isHtmlElement(object) && object.tagName.toLowerCase() === "button";
}
function isFormElement(object) {
  return isHtmlElement(object) && object.tagName.toLowerCase() === "form";
}
function isInputElement(object) {
  return isHtmlElement(object) && object.tagName.toLowerCase() === "input";
}
function isModifiedEvent(event) {
  return !!(event.metaKey || event.altKey || event.ctrlKey || event.shiftKey);
}
function shouldProcessLinkClick(event, target) {
  return event.button === 0 && (
  // Ignore everything but left clicks
  !target || target === "_self") &&
  // Let browser handle "target=_blank" etc.
  !isModifiedEvent(event) // Ignore clicks with modifier keys
  ;
}
/**
 * Creates a URLSearchParams object using the given initializer.
 *
 * This is identical to `new URLSearchParams(init)` except it also
 * supports arrays as values in the object form of the initializer
 * instead of just strings. This is convenient when you need multiple
 * values for a given key, but don't want to use an array initializer.
 *
 * For example, instead of:
 *
 *   let searchParams = new URLSearchParams([
 *     ['sort', 'name'],
 *     ['sort', 'price']
 *   ]);
 *
 * you can do:
 *
 *   let searchParams = createSearchParams({
 *     sort: ['name', 'price']
 *   });
 */
function createSearchParams(init) {
  if (init === void 0) {
    init = "";
  }
  return new URLSearchParams(typeof init === "string" || Array.isArray(init) || init instanceof URLSearchParams ? init : Object.keys(init).reduce((memo, key) => {
    let value = init[key];
    return memo.concat(Array.isArray(value) ? value.map(v => [key, v]) : [[key, value]]);
  }, []));
}
function getSearchParamsForLocation(locationSearch, defaultSearchParams) {
  let searchParams = createSearchParams(locationSearch);
  if (defaultSearchParams) {
    // Use `defaultSearchParams.forEach(...)` here instead of iterating of
    // `defaultSearchParams.keys()` to work-around a bug in Firefox related to
    // web extensions. Relevant Bugzilla tickets:
    // https://bugzilla.mozilla.org/show_bug.cgi?id=1414602
    // https://bugzilla.mozilla.org/show_bug.cgi?id=1023984
    defaultSearchParams.forEach((_, key) => {
      if (!searchParams.has(key)) {
        defaultSearchParams.getAll(key).forEach(value => {
          searchParams.append(key, value);
        });
      }
    });
  }
  return searchParams;
}
// One-time check for submitter support
let _formDataSupportsSubmitter = null;
function isFormDataSubmitterSupported() {
  if (_formDataSupportsSubmitter === null) {
    try {
      new FormData(document.createElement("form"),
      // @ts-expect-error if FormData supports the submitter parameter, this will throw
      0);
      _formDataSupportsSubmitter = false;
    } catch (e) {
      _formDataSupportsSubmitter = true;
    }
  }
  return _formDataSupportsSubmitter;
}
const supportedFormEncTypes = new Set(["application/x-www-form-urlencoded", "multipart/form-data", "text/plain"]);
function getFormEncType(encType) {
  if (encType != null && !supportedFormEncTypes.has(encType)) {
     true ? (0,react_router__WEBPACK_IMPORTED_MODULE_3__.UNSAFE_warning)(false, "\"" + encType + "\" is not a valid `encType` for `<Form>`/`<fetcher.Form>` " + ("and will default to \"" + defaultEncType + "\"")) : 0;
    return null;
  }
  return encType;
}
function getFormSubmissionInfo(target, basename) {
  let method;
  let action;
  let encType;
  let formData;
  let body;
  if (isFormElement(target)) {
    // When grabbing the action from the element, it will have had the basename
    // prefixed to ensure non-JS scenarios work, so strip it since we'll
    // re-prefix in the router
    let attr = target.getAttribute("action");
    action = attr ? (0,react_router__WEBPACK_IMPORTED_MODULE_3__.stripBasename)(attr, basename) : null;
    method = target.getAttribute("method") || defaultMethod;
    encType = getFormEncType(target.getAttribute("enctype")) || defaultEncType;
    formData = new FormData(target);
  } else if (isButtonElement(target) || isInputElement(target) && (target.type === "submit" || target.type === "image")) {
    let form = target.form;
    if (form == null) {
      throw new Error("Cannot submit a <button> or <input type=\"submit\"> without a <form>");
    }
    // <button>/<input type="submit"> may override attributes of <form>
    // When grabbing the action from the element, it will have had the basename
    // prefixed to ensure non-JS scenarios work, so strip it since we'll
    // re-prefix in the router
    let attr = target.getAttribute("formaction") || form.getAttribute("action");
    action = attr ? (0,react_router__WEBPACK_IMPORTED_MODULE_3__.stripBasename)(attr, basename) : null;
    method = target.getAttribute("formmethod") || form.getAttribute("method") || defaultMethod;
    encType = getFormEncType(target.getAttribute("formenctype")) || getFormEncType(form.getAttribute("enctype")) || defaultEncType;
    // Build a FormData object populated from a form and submitter
    formData = new FormData(form, target);
    // If this browser doesn't support the `FormData(el, submitter)` format,
    // then tack on the submitter value at the end.  This is a lightweight
    // solution that is not 100% spec compliant.  For complete support in older
    // browsers, consider using the `formdata-submitter-polyfill` package
    if (!isFormDataSubmitterSupported()) {
      let {
        name,
        type,
        value
      } = target;
      if (type === "image") {
        let prefix = name ? name + "." : "";
        formData.append(prefix + "x", "0");
        formData.append(prefix + "y", "0");
      } else if (name) {
        formData.append(name, value);
      }
    }
  } else if (isHtmlElement(target)) {
    throw new Error("Cannot submit element that is not <form>, <button>, or " + "<input type=\"submit|image\">");
  } else {
    method = defaultMethod;
    action = null;
    encType = defaultEncType;
    body = target;
  }
  // Send body for <Form encType="text/plain" so we encode it into text
  if (formData && encType === "text/plain") {
    body = formData;
    formData = undefined;
  }
  return {
    action,
    method: method.toLowerCase(),
    encType,
    formData,
    body
  };
}

const _excluded = ["onClick", "relative", "reloadDocument", "replace", "state", "target", "to", "preventScrollReset", "viewTransition"],
  _excluded2 = ["aria-current", "caseSensitive", "className", "end", "style", "to", "viewTransition", "children"],
  _excluded3 = ["fetcherKey", "navigate", "reloadDocument", "replace", "state", "method", "action", "onSubmit", "relative", "preventScrollReset", "viewTransition"];
// HEY YOU! DON'T TOUCH THIS VARIABLE!
//
// It is replaced with the proper version at build time via a babel plugin in
// the rollup config.
//
// Export a global property onto the window for React Router detection by the
// Core Web Vitals Technology Report.  This way they can configure the `wappalyzer`
// to detect and properly classify live websites as being built with React Router:
// https://github.com/HTTPArchive/wappalyzer/blob/main/src/technologies/r.json
const REACT_ROUTER_VERSION = "6";
try {
  window.__reactRouterVersion = REACT_ROUTER_VERSION;
} catch (e) {
  // no-op
}
function createBrowserRouter(routes, opts) {
  return (0,react_router__WEBPACK_IMPORTED_MODULE_3__.createRouter)({
    basename: opts == null ? void 0 : opts.basename,
    future: _extends({}, opts == null ? void 0 : opts.future, {
      v7_prependBasename: true
    }),
    history: (0,react_router__WEBPACK_IMPORTED_MODULE_3__.createBrowserHistory)({
      window: opts == null ? void 0 : opts.window
    }),
    hydrationData: (opts == null ? void 0 : opts.hydrationData) || parseHydrationData(),
    routes,
    mapRouteProperties: react_router__WEBPACK_IMPORTED_MODULE_2__.UNSAFE_mapRouteProperties,
    dataStrategy: opts == null ? void 0 : opts.dataStrategy,
    patchRoutesOnNavigation: opts == null ? void 0 : opts.patchRoutesOnNavigation,
    window: opts == null ? void 0 : opts.window
  }).initialize();
}
function createHashRouter(routes, opts) {
  return (0,react_router__WEBPACK_IMPORTED_MODULE_3__.createRouter)({
    basename: opts == null ? void 0 : opts.basename,
    future: _extends({}, opts == null ? void 0 : opts.future, {
      v7_prependBasename: true
    }),
    history: (0,react_router__WEBPACK_IMPORTED_MODULE_3__.createHashHistory)({
      window: opts == null ? void 0 : opts.window
    }),
    hydrationData: (opts == null ? void 0 : opts.hydrationData) || parseHydrationData(),
    routes,
    mapRouteProperties: react_router__WEBPACK_IMPORTED_MODULE_2__.UNSAFE_mapRouteProperties,
    dataStrategy: opts == null ? void 0 : opts.dataStrategy,
    patchRoutesOnNavigation: opts == null ? void 0 : opts.patchRoutesOnNavigation,
    window: opts == null ? void 0 : opts.window
  }).initialize();
}
function parseHydrationData() {
  var _window;
  let state = (_window = window) == null ? void 0 : _window.__staticRouterHydrationData;
  if (state && state.errors) {
    state = _extends({}, state, {
      errors: deserializeErrors(state.errors)
    });
  }
  return state;
}
function deserializeErrors(errors) {
  if (!errors) return null;
  let entries = Object.entries(errors);
  let serialized = {};
  for (let [key, val] of entries) {
    // Hey you!  If you change this, please change the corresponding logic in
    // serializeErrors in react-router-dom/server.tsx :)
    if (val && val.__type === "RouteErrorResponse") {
      serialized[key] = new react_router__WEBPACK_IMPORTED_MODULE_3__.UNSAFE_ErrorResponseImpl(val.status, val.statusText, val.data, val.internal === true);
    } else if (val && val.__type === "Error") {
      // Attempt to reconstruct the right type of Error (i.e., ReferenceError)
      if (val.__subType) {
        let ErrorConstructor = window[val.__subType];
        if (typeof ErrorConstructor === "function") {
          try {
            // @ts-expect-error
            let error = new ErrorConstructor(val.message);
            // Wipe away the client-side stack trace.  Nothing to fill it in with
            // because we don't serialize SSR stack traces for security reasons
            error.stack = "";
            serialized[key] = error;
          } catch (e) {
            // no-op - fall through and create a normal Error
          }
        }
      }
      if (serialized[key] == null) {
        let error = new Error(val.message);
        // Wipe away the client-side stack trace.  Nothing to fill it in with
        // because we don't serialize SSR stack traces for security reasons
        error.stack = "";
        serialized[key] = error;
      }
    } else {
      serialized[key] = val;
    }
  }
  return serialized;
}
const ViewTransitionContext = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createContext({
  isTransitioning: false
});
if (true) {
  ViewTransitionContext.displayName = "ViewTransition";
}
const FetchersContext = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createContext(new Map());
if (true) {
  FetchersContext.displayName = "Fetchers";
}
//#endregion
////////////////////////////////////////////////////////////////////////////////
//#region Components
////////////////////////////////////////////////////////////////////////////////
/**
  Webpack + React 17 fails to compile on any of the following because webpack
  complains that `startTransition` doesn't exist in `React`:
  * import { startTransition } from "react"
  * import * as React from from "react";
    "startTransition" in React ? React.startTransition(() => setState()) : setState()
  * import * as React from from "react";
    "startTransition" in React ? React["startTransition"](() => setState()) : setState()

  Moving it to a constant such as the following solves the Webpack/React 17 issue:
  * import * as React from from "react";
    const START_TRANSITION = "startTransition";
    START_TRANSITION in React ? React[START_TRANSITION](() => setState()) : setState()

  However, that introduces webpack/terser minification issues in production builds
  in React 18 where minification/obfuscation ends up removing the call of
  React.startTransition entirely from the first half of the ternary.  Grabbing
  this exported reference once up front resolves that issue.

  See https://github.com/remix-run/react-router/issues/10579
*/
const START_TRANSITION = "startTransition";
const startTransitionImpl = react__WEBPACK_IMPORTED_MODULE_0__[START_TRANSITION];
const FLUSH_SYNC = "flushSync";
const flushSyncImpl = react_dom__WEBPACK_IMPORTED_MODULE_1__[FLUSH_SYNC];
const USE_ID = "useId";
const useIdImpl = react__WEBPACK_IMPORTED_MODULE_0__[USE_ID];
function startTransitionSafe(cb) {
  if (startTransitionImpl) {
    startTransitionImpl(cb);
  } else {
    cb();
  }
}
function flushSyncSafe(cb) {
  if (flushSyncImpl) {
    flushSyncImpl(cb);
  } else {
    cb();
  }
}
class Deferred {
  constructor() {
    this.status = "pending";
    this.promise = new Promise((resolve, reject) => {
      this.resolve = value => {
        if (this.status === "pending") {
          this.status = "resolved";
          resolve(value);
        }
      };
      this.reject = reason => {
        if (this.status === "pending") {
          this.status = "rejected";
          reject(reason);
        }
      };
    });
  }
}
/**
 * Given a Remix Router instance, render the appropriate UI
 */
function RouterProvider(_ref) {
  let {
    fallbackElement,
    router,
    future
  } = _ref;
  let [state, setStateImpl] = react__WEBPACK_IMPORTED_MODULE_0__.useState(router.state);
  let [pendingState, setPendingState] = react__WEBPACK_IMPORTED_MODULE_0__.useState();
  let [vtContext, setVtContext] = react__WEBPACK_IMPORTED_MODULE_0__.useState({
    isTransitioning: false
  });
  let [renderDfd, setRenderDfd] = react__WEBPACK_IMPORTED_MODULE_0__.useState();
  let [transition, setTransition] = react__WEBPACK_IMPORTED_MODULE_0__.useState();
  let [interruption, setInterruption] = react__WEBPACK_IMPORTED_MODULE_0__.useState();
  let fetcherData = react__WEBPACK_IMPORTED_MODULE_0__.useRef(new Map());
  let {
    v7_startTransition
  } = future || {};
  let optInStartTransition = react__WEBPACK_IMPORTED_MODULE_0__.useCallback(cb => {
    if (v7_startTransition) {
      startTransitionSafe(cb);
    } else {
      cb();
    }
  }, [v7_startTransition]);
  let setState = react__WEBPACK_IMPORTED_MODULE_0__.useCallback((newState, _ref2) => {
    let {
      deletedFetchers,
      flushSync: flushSync,
      viewTransitionOpts: viewTransitionOpts
    } = _ref2;
    newState.fetchers.forEach((fetcher, key) => {
      if (fetcher.data !== undefined) {
        fetcherData.current.set(key, fetcher.data);
      }
    });
    deletedFetchers.forEach(key => fetcherData.current.delete(key));
    let isViewTransitionUnavailable = router.window == null || router.window.document == null || typeof router.window.document.startViewTransition !== "function";
    // If this isn't a view transition or it's not available in this browser,
    // just update and be done with it
    if (!viewTransitionOpts || isViewTransitionUnavailable) {
      if (flushSync) {
        flushSyncSafe(() => setStateImpl(newState));
      } else {
        optInStartTransition(() => setStateImpl(newState));
      }
      return;
    }
    // flushSync + startViewTransition
    if (flushSync) {
      // Flush through the context to mark DOM elements as transition=ing
      flushSyncSafe(() => {
        // Cancel any pending transitions
        if (transition) {
          renderDfd && renderDfd.resolve();
          transition.skipTransition();
        }
        setVtContext({
          isTransitioning: true,
          flushSync: true,
          currentLocation: viewTransitionOpts.currentLocation,
          nextLocation: viewTransitionOpts.nextLocation
        });
      });
      // Update the DOM
      let t = router.window.document.startViewTransition(() => {
        flushSyncSafe(() => setStateImpl(newState));
      });
      // Clean up after the animation completes
      t.finished.finally(() => {
        flushSyncSafe(() => {
          setRenderDfd(undefined);
          setTransition(undefined);
          setPendingState(undefined);
          setVtContext({
            isTransitioning: false
          });
        });
      });
      flushSyncSafe(() => setTransition(t));
      return;
    }
    // startTransition + startViewTransition
    if (transition) {
      // Interrupting an in-progress transition, cancel and let everything flush
      // out, and then kick off a new transition from the interruption state
      renderDfd && renderDfd.resolve();
      transition.skipTransition();
      setInterruption({
        state: newState,
        currentLocation: viewTransitionOpts.currentLocation,
        nextLocation: viewTransitionOpts.nextLocation
      });
    } else {
      // Completed navigation update with opted-in view transitions, let 'er rip
      setPendingState(newState);
      setVtContext({
        isTransitioning: true,
        flushSync: false,
        currentLocation: viewTransitionOpts.currentLocation,
        nextLocation: viewTransitionOpts.nextLocation
      });
    }
  }, [router.window, transition, renderDfd, fetcherData, optInStartTransition]);
  // Need to use a layout effect here so we are subscribed early enough to
  // pick up on any render-driven redirects/navigations (useEffect/<Navigate>)
  react__WEBPACK_IMPORTED_MODULE_0__.useLayoutEffect(() => router.subscribe(setState), [router, setState]);
  // When we start a view transition, create a Deferred we can use for the
  // eventual "completed" render
  react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
    if (vtContext.isTransitioning && !vtContext.flushSync) {
      setRenderDfd(new Deferred());
    }
  }, [vtContext]);
  // Once the deferred is created, kick off startViewTransition() to update the
  // DOM and then wait on the Deferred to resolve (indicating the DOM update has
  // happened)
  react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
    if (renderDfd && pendingState && router.window) {
      let newState = pendingState;
      let renderPromise = renderDfd.promise;
      let transition = router.window.document.startViewTransition(async () => {
        optInStartTransition(() => setStateImpl(newState));
        await renderPromise;
      });
      transition.finished.finally(() => {
        setRenderDfd(undefined);
        setTransition(undefined);
        setPendingState(undefined);
        setVtContext({
          isTransitioning: false
        });
      });
      setTransition(transition);
    }
  }, [optInStartTransition, pendingState, renderDfd, router.window]);
  // When the new location finally renders and is committed to the DOM, this
  // effect will run to resolve the transition
  react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
    if (renderDfd && pendingState && state.location.key === pendingState.location.key) {
      renderDfd.resolve();
    }
  }, [renderDfd, transition, state.location, pendingState]);
  // If we get interrupted with a new navigation during a transition, we skip
  // the active transition, let it cleanup, then kick it off again here
  react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
    if (!vtContext.isTransitioning && interruption) {
      setPendingState(interruption.state);
      setVtContext({
        isTransitioning: true,
        flushSync: false,
        currentLocation: interruption.currentLocation,
        nextLocation: interruption.nextLocation
      });
      setInterruption(undefined);
    }
  }, [vtContext.isTransitioning, interruption]);
  react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
     true ? (0,react_router__WEBPACK_IMPORTED_MODULE_3__.UNSAFE_warning)(fallbackElement == null || !router.future.v7_partialHydration, "`<RouterProvider fallbackElement>` is deprecated when using " + "`v7_partialHydration`, use a `HydrateFallback` component instead") : 0;
    // Only log this once on initial mount
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  let navigator = react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => {
    return {
      createHref: router.createHref,
      encodeLocation: router.encodeLocation,
      go: n => router.navigate(n),
      push: (to, state, opts) => router.navigate(to, {
        state,
        preventScrollReset: opts == null ? void 0 : opts.preventScrollReset
      }),
      replace: (to, state, opts) => router.navigate(to, {
        replace: true,
        state,
        preventScrollReset: opts == null ? void 0 : opts.preventScrollReset
      })
    };
  }, [router]);
  let basename = router.basename || "/";
  let dataRouterContext = react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => ({
    router,
    navigator,
    static: false,
    basename
  }), [router, navigator, basename]);
  let routerFuture = react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => ({
    v7_relativeSplatPath: router.future.v7_relativeSplatPath
  }), [router.future.v7_relativeSplatPath]);
  react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => (0,react_router__WEBPACK_IMPORTED_MODULE_2__.UNSAFE_logV6DeprecationWarnings)(future, router.future), [future, router.future]);
  // The fragment and {null} here are important!  We need them to keep React 18's
  // useId happy when we are server-rendering since we may have a <script> here
  // containing the hydrated server-side staticContext (from StaticRouterProvider).
  // useId relies on the component tree structure to generate deterministic id's
  // so we need to ensure it remains the same on the client even though
  // we don't need the <script> tag
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(react_router__WEBPACK_IMPORTED_MODULE_2__.UNSAFE_DataRouterContext.Provider, {
    value: dataRouterContext
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(react_router__WEBPACK_IMPORTED_MODULE_2__.UNSAFE_DataRouterStateContext.Provider, {
    value: state
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(FetchersContext.Provider, {
    value: fetcherData.current
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(ViewTransitionContext.Provider, {
    value: vtContext
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(react_router__WEBPACK_IMPORTED_MODULE_2__.Router, {
    basename: basename,
    location: state.location,
    navigationType: state.historyAction,
    navigator: navigator,
    future: routerFuture
  }, state.initialized || router.future.v7_partialHydration ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(MemoizedDataRoutes, {
    routes: router.routes,
    future: router.future,
    state: state
  }) : fallbackElement))))), null);
}
// Memoize to avoid re-renders when updating `ViewTransitionContext`
const MemoizedDataRoutes = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.memo(DataRoutes);
function DataRoutes(_ref3) {
  let {
    routes,
    future,
    state
  } = _ref3;
  return (0,react_router__WEBPACK_IMPORTED_MODULE_2__.UNSAFE_useRoutesImpl)(routes, undefined, state, future);
}
/**
 * A `<Router>` for use in web browsers. Provides the cleanest URLs.
 */
function BrowserRouter(_ref4) {
  let {
    basename,
    children,
    future,
    window
  } = _ref4;
  let historyRef = react__WEBPACK_IMPORTED_MODULE_0__.useRef();
  if (historyRef.current == null) {
    historyRef.current = (0,react_router__WEBPACK_IMPORTED_MODULE_3__.createBrowserHistory)({
      window,
      v5Compat: true
    });
  }
  let history = historyRef.current;
  let [state, setStateImpl] = react__WEBPACK_IMPORTED_MODULE_0__.useState({
    action: history.action,
    location: history.location
  });
  let {
    v7_startTransition
  } = future || {};
  let setState = react__WEBPACK_IMPORTED_MODULE_0__.useCallback(newState => {
    v7_startTransition && startTransitionImpl ? startTransitionImpl(() => setStateImpl(newState)) : setStateImpl(newState);
  }, [setStateImpl, v7_startTransition]);
  react__WEBPACK_IMPORTED_MODULE_0__.useLayoutEffect(() => history.listen(setState), [history, setState]);
  react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => (0,react_router__WEBPACK_IMPORTED_MODULE_2__.UNSAFE_logV6DeprecationWarnings)(future), [future]);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(react_router__WEBPACK_IMPORTED_MODULE_2__.Router, {
    basename: basename,
    children: children,
    location: state.location,
    navigationType: state.action,
    navigator: history,
    future: future
  });
}
/**
 * A `<Router>` for use in web browsers. Stores the location in the hash
 * portion of the URL so it is not sent to the server.
 */
function HashRouter(_ref5) {
  let {
    basename,
    children,
    future,
    window
  } = _ref5;
  let historyRef = react__WEBPACK_IMPORTED_MODULE_0__.useRef();
  if (historyRef.current == null) {
    historyRef.current = (0,react_router__WEBPACK_IMPORTED_MODULE_3__.createHashHistory)({
      window,
      v5Compat: true
    });
  }
  let history = historyRef.current;
  let [state, setStateImpl] = react__WEBPACK_IMPORTED_MODULE_0__.useState({
    action: history.action,
    location: history.location
  });
  let {
    v7_startTransition
  } = future || {};
  let setState = react__WEBPACK_IMPORTED_MODULE_0__.useCallback(newState => {
    v7_startTransition && startTransitionImpl ? startTransitionImpl(() => setStateImpl(newState)) : setStateImpl(newState);
  }, [setStateImpl, v7_startTransition]);
  react__WEBPACK_IMPORTED_MODULE_0__.useLayoutEffect(() => history.listen(setState), [history, setState]);
  react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => (0,react_router__WEBPACK_IMPORTED_MODULE_2__.UNSAFE_logV6DeprecationWarnings)(future), [future]);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(react_router__WEBPACK_IMPORTED_MODULE_2__.Router, {
    basename: basename,
    children: children,
    location: state.location,
    navigationType: state.action,
    navigator: history,
    future: future
  });
}
/**
 * A `<Router>` that accepts a pre-instantiated history object. It's important
 * to note that using your own history object is highly discouraged and may add
 * two versions of the history library to your bundles unless you use the same
 * version of the history library that React Router uses internally.
 */
function HistoryRouter(_ref6) {
  let {
    basename,
    children,
    future,
    history
  } = _ref6;
  let [state, setStateImpl] = react__WEBPACK_IMPORTED_MODULE_0__.useState({
    action: history.action,
    location: history.location
  });
  let {
    v7_startTransition
  } = future || {};
  let setState = react__WEBPACK_IMPORTED_MODULE_0__.useCallback(newState => {
    v7_startTransition && startTransitionImpl ? startTransitionImpl(() => setStateImpl(newState)) : setStateImpl(newState);
  }, [setStateImpl, v7_startTransition]);
  react__WEBPACK_IMPORTED_MODULE_0__.useLayoutEffect(() => history.listen(setState), [history, setState]);
  react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => (0,react_router__WEBPACK_IMPORTED_MODULE_2__.UNSAFE_logV6DeprecationWarnings)(future), [future]);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(react_router__WEBPACK_IMPORTED_MODULE_2__.Router, {
    basename: basename,
    children: children,
    location: state.location,
    navigationType: state.action,
    navigator: history,
    future: future
  });
}
if (true) {
  HistoryRouter.displayName = "unstable_HistoryRouter";
}
const isBrowser = typeof window !== "undefined" && typeof window.document !== "undefined" && typeof window.document.createElement !== "undefined";
const ABSOLUTE_URL_REGEX = /^(?:[a-z][a-z0-9+.-]*:|\/\/)/i;
/**
 * The public API for rendering a history-aware `<a>`.
 */
const Link = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.forwardRef(function LinkWithRef(_ref7, ref) {
  let {
      onClick,
      relative,
      reloadDocument,
      replace,
      state,
      target,
      to,
      preventScrollReset,
      viewTransition
    } = _ref7,
    rest = _objectWithoutPropertiesLoose(_ref7, _excluded);
  let {
    basename
  } = react__WEBPACK_IMPORTED_MODULE_0__.useContext(react_router__WEBPACK_IMPORTED_MODULE_2__.UNSAFE_NavigationContext);
  // Rendered into <a href> for absolute URLs
  let absoluteHref;
  let isExternal = false;
  if (typeof to === "string" && ABSOLUTE_URL_REGEX.test(to)) {
    // Render the absolute href server- and client-side
    absoluteHref = to;
    // Only check for external origins client-side
    if (isBrowser) {
      try {
        let currentUrl = new URL(window.location.href);
        let targetUrl = to.startsWith("//") ? new URL(currentUrl.protocol + to) : new URL(to);
        let path = (0,react_router__WEBPACK_IMPORTED_MODULE_3__.stripBasename)(targetUrl.pathname, basename);
        if (targetUrl.origin === currentUrl.origin && path != null) {
          // Strip the protocol/origin/basename for same-origin absolute URLs
          to = path + targetUrl.search + targetUrl.hash;
        } else {
          isExternal = true;
        }
      } catch (e) {
        // We can't do external URL detection without a valid URL
         true ? (0,react_router__WEBPACK_IMPORTED_MODULE_3__.UNSAFE_warning)(false, "<Link to=\"" + to + "\"> contains an invalid URL which will probably break " + "when clicked - please update to a valid URL path.") : 0;
      }
    }
  }
  // Rendered into <a href> for relative URLs
  let href = (0,react_router__WEBPACK_IMPORTED_MODULE_2__.useHref)(to, {
    relative
  });
  let internalOnClick = useLinkClickHandler(to, {
    replace,
    state,
    target,
    preventScrollReset,
    relative,
    viewTransition
  });
  function handleClick(event) {
    if (onClick) onClick(event);
    if (!event.defaultPrevented) {
      internalOnClick(event);
    }
  }
  return (
    /*#__PURE__*/
    // eslint-disable-next-line jsx-a11y/anchor-has-content
    react__WEBPACK_IMPORTED_MODULE_0__.createElement("a", _extends({}, rest, {
      href: absoluteHref || href,
      onClick: isExternal || reloadDocument ? onClick : handleClick,
      ref: ref,
      target: target
    }))
  );
});
if (true) {
  Link.displayName = "Link";
}
/**
 * A `<Link>` wrapper that knows if it's "active" or not.
 */
const NavLink = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.forwardRef(function NavLinkWithRef(_ref8, ref) {
  let {
      "aria-current": ariaCurrentProp = "page",
      caseSensitive = false,
      className: classNameProp = "",
      end = false,
      style: styleProp,
      to,
      viewTransition,
      children
    } = _ref8,
    rest = _objectWithoutPropertiesLoose(_ref8, _excluded2);
  let path = (0,react_router__WEBPACK_IMPORTED_MODULE_2__.useResolvedPath)(to, {
    relative: rest.relative
  });
  let location = (0,react_router__WEBPACK_IMPORTED_MODULE_2__.useLocation)();
  let routerState = react__WEBPACK_IMPORTED_MODULE_0__.useContext(react_router__WEBPACK_IMPORTED_MODULE_2__.UNSAFE_DataRouterStateContext);
  let {
    navigator,
    basename
  } = react__WEBPACK_IMPORTED_MODULE_0__.useContext(react_router__WEBPACK_IMPORTED_MODULE_2__.UNSAFE_NavigationContext);
  let isTransitioning = routerState != null &&
  // Conditional usage is OK here because the usage of a data router is static
  // eslint-disable-next-line react-hooks/rules-of-hooks
  useViewTransitionState(path) && viewTransition === true;
  let toPathname = navigator.encodeLocation ? navigator.encodeLocation(path).pathname : path.pathname;
  let locationPathname = location.pathname;
  let nextLocationPathname = routerState && routerState.navigation && routerState.navigation.location ? routerState.navigation.location.pathname : null;
  if (!caseSensitive) {
    locationPathname = locationPathname.toLowerCase();
    nextLocationPathname = nextLocationPathname ? nextLocationPathname.toLowerCase() : null;
    toPathname = toPathname.toLowerCase();
  }
  if (nextLocationPathname && basename) {
    nextLocationPathname = (0,react_router__WEBPACK_IMPORTED_MODULE_3__.stripBasename)(nextLocationPathname, basename) || nextLocationPathname;
  }
  // If the `to` has a trailing slash, look at that exact spot.  Otherwise,
  // we're looking for a slash _after_ what's in `to`.  For example:
  //
  // <NavLink to="/users"> and <NavLink to="/users/">
  // both want to look for a / at index 6 to match URL `/users/matt`
  const endSlashPosition = toPathname !== "/" && toPathname.endsWith("/") ? toPathname.length - 1 : toPathname.length;
  let isActive = locationPathname === toPathname || !end && locationPathname.startsWith(toPathname) && locationPathname.charAt(endSlashPosition) === "/";
  let isPending = nextLocationPathname != null && (nextLocationPathname === toPathname || !end && nextLocationPathname.startsWith(toPathname) && nextLocationPathname.charAt(toPathname.length) === "/");
  let renderProps = {
    isActive,
    isPending,
    isTransitioning
  };
  let ariaCurrent = isActive ? ariaCurrentProp : undefined;
  let className;
  if (typeof classNameProp === "function") {
    className = classNameProp(renderProps);
  } else {
    // If the className prop is not a function, we use a default `active`
    // class for <NavLink />s that are active. In v5 `active` was the default
    // value for `activeClassName`, but we are removing that API and can still
    // use the old default behavior for a cleaner upgrade path and keep the
    // simple styling rules working as they currently do.
    className = [classNameProp, isActive ? "active" : null, isPending ? "pending" : null, isTransitioning ? "transitioning" : null].filter(Boolean).join(" ");
  }
  let style = typeof styleProp === "function" ? styleProp(renderProps) : styleProp;
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(Link, _extends({}, rest, {
    "aria-current": ariaCurrent,
    className: className,
    ref: ref,
    style: style,
    to: to,
    viewTransition: viewTransition
  }), typeof children === "function" ? children(renderProps) : children);
});
if (true) {
  NavLink.displayName = "NavLink";
}
/**
 * A `@remix-run/router`-aware `<form>`. It behaves like a normal form except
 * that the interaction with the server is with `fetch` instead of new document
 * requests, allowing components to add nicer UX to the page as the form is
 * submitted and returns with data.
 */
const Form = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.forwardRef((_ref9, forwardedRef) => {
  let {
      fetcherKey,
      navigate,
      reloadDocument,
      replace,
      state,
      method = defaultMethod,
      action,
      onSubmit,
      relative,
      preventScrollReset,
      viewTransition
    } = _ref9,
    props = _objectWithoutPropertiesLoose(_ref9, _excluded3);
  let submit = useSubmit();
  let formAction = useFormAction(action, {
    relative
  });
  let formMethod = method.toLowerCase() === "get" ? "get" : "post";
  let submitHandler = event => {
    onSubmit && onSubmit(event);
    if (event.defaultPrevented) return;
    event.preventDefault();
    let submitter = event.nativeEvent.submitter;
    let submitMethod = (submitter == null ? void 0 : submitter.getAttribute("formmethod")) || method;
    submit(submitter || event.currentTarget, {
      fetcherKey,
      method: submitMethod,
      navigate,
      replace,
      state,
      relative,
      preventScrollReset,
      viewTransition
    });
  };
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("form", _extends({
    ref: forwardedRef,
    method: formMethod,
    action: formAction,
    onSubmit: reloadDocument ? onSubmit : submitHandler
  }, props));
});
if (true) {
  Form.displayName = "Form";
}
/**
 * This component will emulate the browser's scroll restoration on location
 * changes.
 */
function ScrollRestoration(_ref10) {
  let {
    getKey,
    storageKey
  } = _ref10;
  useScrollRestoration({
    getKey,
    storageKey
  });
  return null;
}
if (true) {
  ScrollRestoration.displayName = "ScrollRestoration";
}
//#endregion
////////////////////////////////////////////////////////////////////////////////
//#region Hooks
////////////////////////////////////////////////////////////////////////////////
var DataRouterHook;
(function (DataRouterHook) {
  DataRouterHook["UseScrollRestoration"] = "useScrollRestoration";
  DataRouterHook["UseSubmit"] = "useSubmit";
  DataRouterHook["UseSubmitFetcher"] = "useSubmitFetcher";
  DataRouterHook["UseFetcher"] = "useFetcher";
  DataRouterHook["useViewTransitionState"] = "useViewTransitionState";
})(DataRouterHook || (DataRouterHook = {}));
var DataRouterStateHook;
(function (DataRouterStateHook) {
  DataRouterStateHook["UseFetcher"] = "useFetcher";
  DataRouterStateHook["UseFetchers"] = "useFetchers";
  DataRouterStateHook["UseScrollRestoration"] = "useScrollRestoration";
})(DataRouterStateHook || (DataRouterStateHook = {}));
// Internal hooks
function getDataRouterConsoleError(hookName) {
  return hookName + " must be used within a data router.  See https://reactrouter.com/v6/routers/picking-a-router.";
}
function useDataRouterContext(hookName) {
  let ctx = react__WEBPACK_IMPORTED_MODULE_0__.useContext(react_router__WEBPACK_IMPORTED_MODULE_2__.UNSAFE_DataRouterContext);
  !ctx ?  true ? (0,react_router__WEBPACK_IMPORTED_MODULE_3__.UNSAFE_invariant)(false, getDataRouterConsoleError(hookName)) : 0 : void 0;
  return ctx;
}
function useDataRouterState(hookName) {
  let state = react__WEBPACK_IMPORTED_MODULE_0__.useContext(react_router__WEBPACK_IMPORTED_MODULE_2__.UNSAFE_DataRouterStateContext);
  !state ?  true ? (0,react_router__WEBPACK_IMPORTED_MODULE_3__.UNSAFE_invariant)(false, getDataRouterConsoleError(hookName)) : 0 : void 0;
  return state;
}
// External hooks
/**
 * Handles the click behavior for router `<Link>` components. This is useful if
 * you need to create custom `<Link>` components with the same click behavior we
 * use in our exported `<Link>`.
 */
function useLinkClickHandler(to, _temp) {
  let {
    target,
    replace: replaceProp,
    state,
    preventScrollReset,
    relative,
    viewTransition
  } = _temp === void 0 ? {} : _temp;
  let navigate = (0,react_router__WEBPACK_IMPORTED_MODULE_2__.useNavigate)();
  let location = (0,react_router__WEBPACK_IMPORTED_MODULE_2__.useLocation)();
  let path = (0,react_router__WEBPACK_IMPORTED_MODULE_2__.useResolvedPath)(to, {
    relative
  });
  return react__WEBPACK_IMPORTED_MODULE_0__.useCallback(event => {
    if (shouldProcessLinkClick(event, target)) {
      event.preventDefault();
      // If the URL hasn't changed, a regular <a> will do a replace instead of
      // a push, so do the same here unless the replace prop is explicitly set
      let replace = replaceProp !== undefined ? replaceProp : (0,react_router__WEBPACK_IMPORTED_MODULE_3__.createPath)(location) === (0,react_router__WEBPACK_IMPORTED_MODULE_3__.createPath)(path);
      navigate(to, {
        replace,
        state,
        preventScrollReset,
        relative,
        viewTransition
      });
    }
  }, [location, navigate, path, replaceProp, state, target, to, preventScrollReset, relative, viewTransition]);
}
/**
 * A convenient wrapper for reading and writing search parameters via the
 * URLSearchParams interface.
 */
function useSearchParams(defaultInit) {
   true ? (0,react_router__WEBPACK_IMPORTED_MODULE_3__.UNSAFE_warning)(typeof URLSearchParams !== "undefined", "You cannot use the `useSearchParams` hook in a browser that does not " + "support the URLSearchParams API. If you need to support Internet " + "Explorer 11, we recommend you load a polyfill such as " + "https://github.com/ungap/url-search-params.") : 0;
  let defaultSearchParamsRef = react__WEBPACK_IMPORTED_MODULE_0__.useRef(createSearchParams(defaultInit));
  let hasSetSearchParamsRef = react__WEBPACK_IMPORTED_MODULE_0__.useRef(false);
  let location = (0,react_router__WEBPACK_IMPORTED_MODULE_2__.useLocation)();
  let searchParams = react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() =>
  // Only merge in the defaults if we haven't yet called setSearchParams.
  // Once we call that we want those to take precedence, otherwise you can't
  // remove a param with setSearchParams({}) if it has an initial value
  getSearchParamsForLocation(location.search, hasSetSearchParamsRef.current ? null : defaultSearchParamsRef.current), [location.search]);
  let navigate = (0,react_router__WEBPACK_IMPORTED_MODULE_2__.useNavigate)();
  let setSearchParams = react__WEBPACK_IMPORTED_MODULE_0__.useCallback((nextInit, navigateOptions) => {
    const newSearchParams = createSearchParams(typeof nextInit === "function" ? nextInit(searchParams) : nextInit);
    hasSetSearchParamsRef.current = true;
    navigate("?" + newSearchParams, navigateOptions);
  }, [navigate, searchParams]);
  return [searchParams, setSearchParams];
}
function validateClientSideSubmission() {
  if (typeof document === "undefined") {
    throw new Error("You are calling submit during the server render. " + "Try calling submit within a `useEffect` or callback instead.");
  }
}
let fetcherId = 0;
let getUniqueFetcherId = () => "__" + String(++fetcherId) + "__";
/**
 * Returns a function that may be used to programmatically submit a form (or
 * some arbitrary data) to the server.
 */
function useSubmit() {
  let {
    router
  } = useDataRouterContext(DataRouterHook.UseSubmit);
  let {
    basename
  } = react__WEBPACK_IMPORTED_MODULE_0__.useContext(react_router__WEBPACK_IMPORTED_MODULE_2__.UNSAFE_NavigationContext);
  let currentRouteId = (0,react_router__WEBPACK_IMPORTED_MODULE_2__.UNSAFE_useRouteId)();
  return react__WEBPACK_IMPORTED_MODULE_0__.useCallback(function (target, options) {
    if (options === void 0) {
      options = {};
    }
    validateClientSideSubmission();
    let {
      action,
      method,
      encType,
      formData,
      body
    } = getFormSubmissionInfo(target, basename);
    if (options.navigate === false) {
      let key = options.fetcherKey || getUniqueFetcherId();
      router.fetch(key, currentRouteId, options.action || action, {
        preventScrollReset: options.preventScrollReset,
        formData,
        body,
        formMethod: options.method || method,
        formEncType: options.encType || encType,
        flushSync: options.flushSync
      });
    } else {
      router.navigate(options.action || action, {
        preventScrollReset: options.preventScrollReset,
        formData,
        body,
        formMethod: options.method || method,
        formEncType: options.encType || encType,
        replace: options.replace,
        state: options.state,
        fromRouteId: currentRouteId,
        flushSync: options.flushSync,
        viewTransition: options.viewTransition
      });
    }
  }, [router, basename, currentRouteId]);
}
// v7: Eventually we should deprecate this entirely in favor of using the
// router method directly?
function useFormAction(action, _temp2) {
  let {
    relative
  } = _temp2 === void 0 ? {} : _temp2;
  let {
    basename
  } = react__WEBPACK_IMPORTED_MODULE_0__.useContext(react_router__WEBPACK_IMPORTED_MODULE_2__.UNSAFE_NavigationContext);
  let routeContext = react__WEBPACK_IMPORTED_MODULE_0__.useContext(react_router__WEBPACK_IMPORTED_MODULE_2__.UNSAFE_RouteContext);
  !routeContext ?  true ? (0,react_router__WEBPACK_IMPORTED_MODULE_3__.UNSAFE_invariant)(false, "useFormAction must be used inside a RouteContext") : 0 : void 0;
  let [match] = routeContext.matches.slice(-1);
  // Shallow clone path so we can modify it below, otherwise we modify the
  // object referenced by useMemo inside useResolvedPath
  let path = _extends({}, (0,react_router__WEBPACK_IMPORTED_MODULE_2__.useResolvedPath)(action ? action : ".", {
    relative
  }));
  // If no action was specified, browsers will persist current search params
  // when determining the path, so match that behavior
  // https://github.com/remix-run/remix/issues/927
  let location = (0,react_router__WEBPACK_IMPORTED_MODULE_2__.useLocation)();
  if (action == null) {
    // Safe to write to this directly here since if action was undefined, we
    // would have called useResolvedPath(".") which will never include a search
    path.search = location.search;
    // When grabbing search params from the URL, remove any included ?index param
    // since it might not apply to our contextual route.  We add it back based
    // on match.route.index below
    let params = new URLSearchParams(path.search);
    let indexValues = params.getAll("index");
    let hasNakedIndexParam = indexValues.some(v => v === "");
    if (hasNakedIndexParam) {
      params.delete("index");
      indexValues.filter(v => v).forEach(v => params.append("index", v));
      let qs = params.toString();
      path.search = qs ? "?" + qs : "";
    }
  }
  if ((!action || action === ".") && match.route.index) {
    path.search = path.search ? path.search.replace(/^\?/, "?index&") : "?index";
  }
  // If we're operating within a basename, prepend it to the pathname prior
  // to creating the form action.  If this is a root navigation, then just use
  // the raw basename which allows the basename to have full control over the
  // presence of a trailing slash on root actions
  if (basename !== "/") {
    path.pathname = path.pathname === "/" ? basename : (0,react_router__WEBPACK_IMPORTED_MODULE_3__.joinPaths)([basename, path.pathname]);
  }
  return (0,react_router__WEBPACK_IMPORTED_MODULE_3__.createPath)(path);
}
// TODO: (v7) Change the useFetcher generic default from `any` to `unknown`
/**
 * Interacts with route loaders and actions without causing a navigation. Great
 * for any interaction that stays on the same page.
 */
function useFetcher(_temp3) {
  var _route$matches;
  let {
    key
  } = _temp3 === void 0 ? {} : _temp3;
  let {
    router
  } = useDataRouterContext(DataRouterHook.UseFetcher);
  let state = useDataRouterState(DataRouterStateHook.UseFetcher);
  let fetcherData = react__WEBPACK_IMPORTED_MODULE_0__.useContext(FetchersContext);
  let route = react__WEBPACK_IMPORTED_MODULE_0__.useContext(react_router__WEBPACK_IMPORTED_MODULE_2__.UNSAFE_RouteContext);
  let routeId = (_route$matches = route.matches[route.matches.length - 1]) == null ? void 0 : _route$matches.route.id;
  !fetcherData ?  true ? (0,react_router__WEBPACK_IMPORTED_MODULE_3__.UNSAFE_invariant)(false, "useFetcher must be used inside a FetchersContext") : 0 : void 0;
  !route ?  true ? (0,react_router__WEBPACK_IMPORTED_MODULE_3__.UNSAFE_invariant)(false, "useFetcher must be used inside a RouteContext") : 0 : void 0;
  !(routeId != null) ?  true ? (0,react_router__WEBPACK_IMPORTED_MODULE_3__.UNSAFE_invariant)(false, "useFetcher can only be used on routes that contain a unique \"id\"") : 0 : void 0;
  // Fetcher key handling
  // OK to call conditionally to feature detect `useId`
  // eslint-disable-next-line react-hooks/rules-of-hooks
  let defaultKey = useIdImpl ? useIdImpl() : "";
  let [fetcherKey, setFetcherKey] = react__WEBPACK_IMPORTED_MODULE_0__.useState(key || defaultKey);
  if (key && key !== fetcherKey) {
    setFetcherKey(key);
  } else if (!fetcherKey) {
    // We will only fall through here when `useId` is not available
    setFetcherKey(getUniqueFetcherId());
  }
  // Registration/cleanup
  react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
    router.getFetcher(fetcherKey);
    return () => {
      // Tell the router we've unmounted - if v7_fetcherPersist is enabled this
      // will not delete immediately but instead queue up a delete after the
      // fetcher returns to an `idle` state
      router.deleteFetcher(fetcherKey);
    };
  }, [router, fetcherKey]);
  // Fetcher additions
  let load = react__WEBPACK_IMPORTED_MODULE_0__.useCallback((href, opts) => {
    !routeId ?  true ? (0,react_router__WEBPACK_IMPORTED_MODULE_3__.UNSAFE_invariant)(false, "No routeId available for fetcher.load()") : 0 : void 0;
    router.fetch(fetcherKey, routeId, href, opts);
  }, [fetcherKey, routeId, router]);
  let submitImpl = useSubmit();
  let submit = react__WEBPACK_IMPORTED_MODULE_0__.useCallback((target, opts) => {
    submitImpl(target, _extends({}, opts, {
      navigate: false,
      fetcherKey
    }));
  }, [fetcherKey, submitImpl]);
  let FetcherForm = react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => {
    let FetcherForm = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.forwardRef((props, ref) => {
      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(Form, _extends({}, props, {
        navigate: false,
        fetcherKey: fetcherKey,
        ref: ref
      }));
    });
    if (true) {
      FetcherForm.displayName = "fetcher.Form";
    }
    return FetcherForm;
  }, [fetcherKey]);
  // Exposed FetcherWithComponents
  let fetcher = state.fetchers.get(fetcherKey) || react_router__WEBPACK_IMPORTED_MODULE_3__.IDLE_FETCHER;
  let data = fetcherData.get(fetcherKey);
  let fetcherWithComponents = react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => _extends({
    Form: FetcherForm,
    submit,
    load
  }, fetcher, {
    data
  }), [FetcherForm, submit, load, fetcher, data]);
  return fetcherWithComponents;
}
/**
 * Provides all fetchers currently on the page. Useful for layouts and parent
 * routes that need to provide pending/optimistic UI regarding the fetch.
 */
function useFetchers() {
  let state = useDataRouterState(DataRouterStateHook.UseFetchers);
  return Array.from(state.fetchers.entries()).map(_ref11 => {
    let [key, fetcher] = _ref11;
    return _extends({}, fetcher, {
      key
    });
  });
}
const SCROLL_RESTORATION_STORAGE_KEY = "react-router-scroll-positions";
let savedScrollPositions = {};
/**
 * When rendered inside a RouterProvider, will restore scroll positions on navigations
 */
function useScrollRestoration(_temp4) {
  let {
    getKey,
    storageKey
  } = _temp4 === void 0 ? {} : _temp4;
  let {
    router
  } = useDataRouterContext(DataRouterHook.UseScrollRestoration);
  let {
    restoreScrollPosition,
    preventScrollReset
  } = useDataRouterState(DataRouterStateHook.UseScrollRestoration);
  let {
    basename
  } = react__WEBPACK_IMPORTED_MODULE_0__.useContext(react_router__WEBPACK_IMPORTED_MODULE_2__.UNSAFE_NavigationContext);
  let location = (0,react_router__WEBPACK_IMPORTED_MODULE_2__.useLocation)();
  let matches = (0,react_router__WEBPACK_IMPORTED_MODULE_2__.useMatches)();
  let navigation = (0,react_router__WEBPACK_IMPORTED_MODULE_2__.useNavigation)();
  // Trigger manual scroll restoration while we're active
  react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
    window.history.scrollRestoration = "manual";
    return () => {
      window.history.scrollRestoration = "auto";
    };
  }, []);
  // Save positions on pagehide
  usePageHide(react__WEBPACK_IMPORTED_MODULE_0__.useCallback(() => {
    if (navigation.state === "idle") {
      let key = (getKey ? getKey(location, matches) : null) || location.key;
      savedScrollPositions[key] = window.scrollY;
    }
    try {
      sessionStorage.setItem(storageKey || SCROLL_RESTORATION_STORAGE_KEY, JSON.stringify(savedScrollPositions));
    } catch (error) {
       true ? (0,react_router__WEBPACK_IMPORTED_MODULE_3__.UNSAFE_warning)(false, "Failed to save scroll positions in sessionStorage, <ScrollRestoration /> will not work properly (" + error + ").") : 0;
    }
    window.history.scrollRestoration = "auto";
  }, [storageKey, getKey, navigation.state, location, matches]));
  // Read in any saved scroll locations
  if (typeof document !== "undefined") {
    // eslint-disable-next-line react-hooks/rules-of-hooks
    react__WEBPACK_IMPORTED_MODULE_0__.useLayoutEffect(() => {
      try {
        let sessionPositions = sessionStorage.getItem(storageKey || SCROLL_RESTORATION_STORAGE_KEY);
        if (sessionPositions) {
          savedScrollPositions = JSON.parse(sessionPositions);
        }
      } catch (e) {
        // no-op, use default empty object
      }
    }, [storageKey]);
    // Enable scroll restoration in the router
    // eslint-disable-next-line react-hooks/rules-of-hooks
    react__WEBPACK_IMPORTED_MODULE_0__.useLayoutEffect(() => {
      let getKeyWithoutBasename = getKey && basename !== "/" ? (location, matches) => getKey( // Strip the basename to match useLocation()
      _extends({}, location, {
        pathname: (0,react_router__WEBPACK_IMPORTED_MODULE_3__.stripBasename)(location.pathname, basename) || location.pathname
      }), matches) : getKey;
      let disableScrollRestoration = router == null ? void 0 : router.enableScrollRestoration(savedScrollPositions, () => window.scrollY, getKeyWithoutBasename);
      return () => disableScrollRestoration && disableScrollRestoration();
    }, [router, basename, getKey]);
    // Restore scrolling when state.restoreScrollPosition changes
    // eslint-disable-next-line react-hooks/rules-of-hooks
    react__WEBPACK_IMPORTED_MODULE_0__.useLayoutEffect(() => {
      // Explicit false means don't do anything (used for submissions)
      if (restoreScrollPosition === false) {
        return;
      }
      // been here before, scroll to it
      if (typeof restoreScrollPosition === "number") {
        window.scrollTo(0, restoreScrollPosition);
        return;
      }
      // try to scroll to the hash
      if (location.hash) {
        let el = document.getElementById(decodeURIComponent(location.hash.slice(1)));
        if (el) {
          el.scrollIntoView();
          return;
        }
      }
      // Don't reset if this navigation opted out
      if (preventScrollReset === true) {
        return;
      }
      // otherwise go to the top on new locations
      window.scrollTo(0, 0);
    }, [location, restoreScrollPosition, preventScrollReset]);
  }
}
/**
 * Setup a callback to be fired on the window's `beforeunload` event. This is
 * useful for saving some data to `window.localStorage` just before the page
 * refreshes.
 *
 * Note: The `callback` argument should be a function created with
 * `React.useCallback()`.
 */
function useBeforeUnload(callback, options) {
  let {
    capture
  } = options || {};
  react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
    let opts = capture != null ? {
      capture
    } : undefined;
    window.addEventListener("beforeunload", callback, opts);
    return () => {
      window.removeEventListener("beforeunload", callback, opts);
    };
  }, [callback, capture]);
}
/**
 * Setup a callback to be fired on the window's `pagehide` event. This is
 * useful for saving some data to `window.localStorage` just before the page
 * refreshes.  This event is better supported than beforeunload across browsers.
 *
 * Note: The `callback` argument should be a function created with
 * `React.useCallback()`.
 */
function usePageHide(callback, options) {
  let {
    capture
  } = options || {};
  react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
    let opts = capture != null ? {
      capture
    } : undefined;
    window.addEventListener("pagehide", callback, opts);
    return () => {
      window.removeEventListener("pagehide", callback, opts);
    };
  }, [callback, capture]);
}
/**
 * Wrapper around useBlocker to show a window.confirm prompt to users instead
 * of building a custom UI with useBlocker.
 *
 * Warning: This has *a lot of rough edges* and behaves very differently (and
 * very incorrectly in some cases) across browsers if user click addition
 * back/forward navigations while the confirm is open.  Use at your own risk.
 */
function usePrompt(_ref12) {
  let {
    when,
    message
  } = _ref12;
  let blocker = (0,react_router__WEBPACK_IMPORTED_MODULE_2__.useBlocker)(when);
  react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
    if (blocker.state === "blocked") {
      let proceed = window.confirm(message);
      if (proceed) {
        // This timeout is needed to avoid a weird "race" on POP navigations
        // between the `window.history` revert navigation and the result of
        // `window.confirm`
        setTimeout(blocker.proceed, 0);
      } else {
        blocker.reset();
      }
    }
  }, [blocker, message]);
  react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
    if (blocker.state === "blocked" && !when) {
      blocker.reset();
    }
  }, [blocker, when]);
}
/**
 * Return a boolean indicating if there is an active view transition to the
 * given href.  You can use this value to render CSS classes or viewTransitionName
 * styles onto your elements
 *
 * @param href The destination href
 * @param [opts.relative] Relative routing type ("route" | "path")
 */
function useViewTransitionState(to, opts) {
  if (opts === void 0) {
    opts = {};
  }
  let vtContext = react__WEBPACK_IMPORTED_MODULE_0__.useContext(ViewTransitionContext);
  !(vtContext != null) ?  true ? (0,react_router__WEBPACK_IMPORTED_MODULE_3__.UNSAFE_invariant)(false, "`useViewTransitionState` must be used within `react-router-dom`'s `RouterProvider`.  " + "Did you accidentally import `RouterProvider` from `react-router`?") : 0 : void 0;
  let {
    basename
  } = useDataRouterContext(DataRouterHook.useViewTransitionState);
  let path = (0,react_router__WEBPACK_IMPORTED_MODULE_2__.useResolvedPath)(to, {
    relative: opts.relative
  });
  if (!vtContext.isTransitioning) {
    return false;
  }
  let currentPath = (0,react_router__WEBPACK_IMPORTED_MODULE_3__.stripBasename)(vtContext.currentLocation.pathname, basename) || vtContext.currentLocation.pathname;
  let nextPath = (0,react_router__WEBPACK_IMPORTED_MODULE_3__.stripBasename)(vtContext.nextLocation.pathname, basename) || vtContext.nextLocation.pathname;
  // Transition is active if we're going to or coming from the indicated
  // destination.  This ensures that other PUSH navigations that reverse
  // an indicated transition apply.  I.e., on the list view you have:
  //
  //   <NavLink to="/details/1" viewTransition>
  //
  // If you click the breadcrumb back to the list view:
  //
  //   <NavLink to="/list" viewTransition>
  //
  // We should apply the transition because it's indicated as active going
  // from /list -> /details/1 and therefore should be active on the reverse
  // (even though this isn't strictly a POP reverse)
  return (0,react_router__WEBPACK_IMPORTED_MODULE_3__.matchPath)(path.pathname, nextPath) != null || (0,react_router__WEBPACK_IMPORTED_MODULE_3__.matchPath)(path.pathname, currentPath) != null;
}
//#endregion


//# sourceMappingURL=index.js.map


/***/ },

/***/ "./node_modules/react-router/dist/index.js"
/*!*************************************************!*\
  !*** ./node_modules/react-router/dist/index.js ***!
  \*************************************************/
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AbortedDeferredError: () => (/* reexport safe */ _remix_run_router__WEBPACK_IMPORTED_MODULE_1__.AbortedDeferredError),
/* harmony export */   Await: () => (/* binding */ Await),
/* harmony export */   MemoryRouter: () => (/* binding */ MemoryRouter),
/* harmony export */   Navigate: () => (/* binding */ Navigate),
/* harmony export */   NavigationType: () => (/* reexport safe */ _remix_run_router__WEBPACK_IMPORTED_MODULE_1__.Action),
/* harmony export */   Outlet: () => (/* binding */ Outlet),
/* harmony export */   Route: () => (/* binding */ Route),
/* harmony export */   Router: () => (/* binding */ Router),
/* harmony export */   RouterProvider: () => (/* binding */ RouterProvider),
/* harmony export */   Routes: () => (/* binding */ Routes),
/* harmony export */   UNSAFE_DataRouterContext: () => (/* binding */ DataRouterContext),
/* harmony export */   UNSAFE_DataRouterStateContext: () => (/* binding */ DataRouterStateContext),
/* harmony export */   UNSAFE_LocationContext: () => (/* binding */ LocationContext),
/* harmony export */   UNSAFE_NavigationContext: () => (/* binding */ NavigationContext),
/* harmony export */   UNSAFE_RouteContext: () => (/* binding */ RouteContext),
/* harmony export */   UNSAFE_logV6DeprecationWarnings: () => (/* binding */ logV6DeprecationWarnings),
/* harmony export */   UNSAFE_mapRouteProperties: () => (/* binding */ mapRouteProperties),
/* harmony export */   UNSAFE_useRouteId: () => (/* binding */ useRouteId),
/* harmony export */   UNSAFE_useRoutesImpl: () => (/* binding */ useRoutesImpl),
/* harmony export */   createMemoryRouter: () => (/* binding */ createMemoryRouter),
/* harmony export */   createPath: () => (/* reexport safe */ _remix_run_router__WEBPACK_IMPORTED_MODULE_1__.createPath),
/* harmony export */   createRoutesFromChildren: () => (/* binding */ createRoutesFromChildren),
/* harmony export */   createRoutesFromElements: () => (/* binding */ createRoutesFromChildren),
/* harmony export */   defer: () => (/* reexport safe */ _remix_run_router__WEBPACK_IMPORTED_MODULE_1__.defer),
/* harmony export */   generatePath: () => (/* reexport safe */ _remix_run_router__WEBPACK_IMPORTED_MODULE_1__.generatePath),
/* harmony export */   isRouteErrorResponse: () => (/* reexport safe */ _remix_run_router__WEBPACK_IMPORTED_MODULE_1__.isRouteErrorResponse),
/* harmony export */   json: () => (/* reexport safe */ _remix_run_router__WEBPACK_IMPORTED_MODULE_1__.json),
/* harmony export */   matchPath: () => (/* reexport safe */ _remix_run_router__WEBPACK_IMPORTED_MODULE_1__.matchPath),
/* harmony export */   matchRoutes: () => (/* reexport safe */ _remix_run_router__WEBPACK_IMPORTED_MODULE_1__.matchRoutes),
/* harmony export */   parsePath: () => (/* reexport safe */ _remix_run_router__WEBPACK_IMPORTED_MODULE_1__.parsePath),
/* harmony export */   redirect: () => (/* reexport safe */ _remix_run_router__WEBPACK_IMPORTED_MODULE_1__.redirect),
/* harmony export */   redirectDocument: () => (/* reexport safe */ _remix_run_router__WEBPACK_IMPORTED_MODULE_1__.redirectDocument),
/* harmony export */   renderMatches: () => (/* binding */ renderMatches),
/* harmony export */   replace: () => (/* reexport safe */ _remix_run_router__WEBPACK_IMPORTED_MODULE_1__.replace),
/* harmony export */   resolvePath: () => (/* reexport safe */ _remix_run_router__WEBPACK_IMPORTED_MODULE_1__.resolvePath),
/* harmony export */   useActionData: () => (/* binding */ useActionData),
/* harmony export */   useAsyncError: () => (/* binding */ useAsyncError),
/* harmony export */   useAsyncValue: () => (/* binding */ useAsyncValue),
/* harmony export */   useBlocker: () => (/* binding */ useBlocker),
/* harmony export */   useHref: () => (/* binding */ useHref),
/* harmony export */   useInRouterContext: () => (/* binding */ useInRouterContext),
/* harmony export */   useLoaderData: () => (/* binding */ useLoaderData),
/* harmony export */   useLocation: () => (/* binding */ useLocation),
/* harmony export */   useMatch: () => (/* binding */ useMatch),
/* harmony export */   useMatches: () => (/* binding */ useMatches),
/* harmony export */   useNavigate: () => (/* binding */ useNavigate),
/* harmony export */   useNavigation: () => (/* binding */ useNavigation),
/* harmony export */   useNavigationType: () => (/* binding */ useNavigationType),
/* harmony export */   useOutlet: () => (/* binding */ useOutlet),
/* harmony export */   useOutletContext: () => (/* binding */ useOutletContext),
/* harmony export */   useParams: () => (/* binding */ useParams),
/* harmony export */   useResolvedPath: () => (/* binding */ useResolvedPath),
/* harmony export */   useRevalidator: () => (/* binding */ useRevalidator),
/* harmony export */   useRouteError: () => (/* binding */ useRouteError),
/* harmony export */   useRouteLoaderData: () => (/* binding */ useRouteLoaderData),
/* harmony export */   useRoutes: () => (/* binding */ useRoutes)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _remix_run_router__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @remix-run/router */ "./node_modules/@remix-run/router/dist/router.js");
/**
 * React Router v6.30.2
 *
 * Copyright (c) Remix Software Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE.md file in the root directory of this source tree.
 *
 * @license MIT
 */




function _extends() {
  _extends = Object.assign ? Object.assign.bind() : function (target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i];
      for (var key in source) {
        if (Object.prototype.hasOwnProperty.call(source, key)) {
          target[key] = source[key];
        }
      }
    }
    return target;
  };
  return _extends.apply(this, arguments);
}

// Create react-specific types from the agnostic types in @remix-run/router to
// export from react-router
const DataRouterContext = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createContext(null);
if (true) {
  DataRouterContext.displayName = "DataRouter";
}
const DataRouterStateContext = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createContext(null);
if (true) {
  DataRouterStateContext.displayName = "DataRouterState";
}
const AwaitContext = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createContext(null);
if (true) {
  AwaitContext.displayName = "Await";
}

/**
 * A Navigator is a "location changer"; it's how you get to different locations.
 *
 * Every history instance conforms to the Navigator interface, but the
 * distinction is useful primarily when it comes to the low-level `<Router>` API
 * where both the location and a navigator must be provided separately in order
 * to avoid "tearing" that may occur in a suspense-enabled app if the action
 * and/or location were to be read directly from the history instance.
 */

const NavigationContext = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createContext(null);
if (true) {
  NavigationContext.displayName = "Navigation";
}
const LocationContext = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createContext(null);
if (true) {
  LocationContext.displayName = "Location";
}
const RouteContext = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createContext({
  outlet: null,
  matches: [],
  isDataRoute: false
});
if (true) {
  RouteContext.displayName = "Route";
}
const RouteErrorContext = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createContext(null);
if (true) {
  RouteErrorContext.displayName = "RouteError";
}

/**
 * Returns the full href for the given "to" value. This is useful for building
 * custom links that are also accessible and preserve right-click behavior.
 *
 * @see https://reactrouter.com/v6/hooks/use-href
 */
function useHref(to, _temp) {
  let {
    relative
  } = _temp === void 0 ? {} : _temp;
  !useInRouterContext() ?  true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_invariant)(false, // TODO: This error is probably because they somehow have 2 versions of the
  // router loaded. We can help them understand how to avoid that.
  "useHref() may be used only in the context of a <Router> component.") : 0 : void 0;
  let {
    basename,
    navigator
  } = react__WEBPACK_IMPORTED_MODULE_0__.useContext(NavigationContext);
  let {
    hash,
    pathname,
    search
  } = useResolvedPath(to, {
    relative
  });
  let joinedPathname = pathname;

  // If we're operating within a basename, prepend it to the pathname prior
  // to creating the href.  If this is a root navigation, then just use the raw
  // basename which allows the basename to have full control over the presence
  // of a trailing slash on root links
  if (basename !== "/") {
    joinedPathname = pathname === "/" ? basename : (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.joinPaths)([basename, pathname]);
  }
  return navigator.createHref({
    pathname: joinedPathname,
    search,
    hash
  });
}

/**
 * Returns true if this component is a descendant of a `<Router>`.
 *
 * @see https://reactrouter.com/v6/hooks/use-in-router-context
 */
function useInRouterContext() {
  return react__WEBPACK_IMPORTED_MODULE_0__.useContext(LocationContext) != null;
}

/**
 * Returns the current location object, which represents the current URL in web
 * browsers.
 *
 * Note: If you're using this it may mean you're doing some of your own
 * "routing" in your app, and we'd like to know what your use case is. We may
 * be able to provide something higher-level to better suit your needs.
 *
 * @see https://reactrouter.com/v6/hooks/use-location
 */
function useLocation() {
  !useInRouterContext() ?  true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_invariant)(false, // TODO: This error is probably because they somehow have 2 versions of the
  // router loaded. We can help them understand how to avoid that.
  "useLocation() may be used only in the context of a <Router> component.") : 0 : void 0;
  return react__WEBPACK_IMPORTED_MODULE_0__.useContext(LocationContext).location;
}

/**
 * Returns the current navigation action which describes how the router came to
 * the current location, either by a pop, push, or replace on the history stack.
 *
 * @see https://reactrouter.com/v6/hooks/use-navigation-type
 */
function useNavigationType() {
  return react__WEBPACK_IMPORTED_MODULE_0__.useContext(LocationContext).navigationType;
}

/**
 * Returns a PathMatch object if the given pattern matches the current URL.
 * This is useful for components that need to know "active" state, e.g.
 * `<NavLink>`.
 *
 * @see https://reactrouter.com/v6/hooks/use-match
 */
function useMatch(pattern) {
  !useInRouterContext() ?  true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_invariant)(false, // TODO: This error is probably because they somehow have 2 versions of the
  // router loaded. We can help them understand how to avoid that.
  "useMatch() may be used only in the context of a <Router> component.") : 0 : void 0;
  let {
    pathname
  } = useLocation();
  return react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.matchPath)(pattern, (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_decodePath)(pathname)), [pathname, pattern]);
}

/**
 * The interface for the navigate() function returned from useNavigate().
 */

const navigateEffectWarning = "You should call navigate() in a React.useEffect(), not when " + "your component is first rendered.";

// Mute warnings for calls to useNavigate in SSR environments
function useIsomorphicLayoutEffect(cb) {
  let isStatic = react__WEBPACK_IMPORTED_MODULE_0__.useContext(NavigationContext).static;
  if (!isStatic) {
    // We should be able to get rid of this once react 18.3 is released
    // See: https://github.com/facebook/react/pull/26395
    // eslint-disable-next-line react-hooks/rules-of-hooks
    react__WEBPACK_IMPORTED_MODULE_0__.useLayoutEffect(cb);
  }
}

/**
 * Returns an imperative method for changing the location. Used by `<Link>`s, but
 * may also be used by other elements to change the location.
 *
 * @see https://reactrouter.com/v6/hooks/use-navigate
 */
function useNavigate() {
  let {
    isDataRoute
  } = react__WEBPACK_IMPORTED_MODULE_0__.useContext(RouteContext);
  // Conditional usage is OK here because the usage of a data router is static
  // eslint-disable-next-line react-hooks/rules-of-hooks
  return isDataRoute ? useNavigateStable() : useNavigateUnstable();
}
function useNavigateUnstable() {
  !useInRouterContext() ?  true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_invariant)(false, // TODO: This error is probably because they somehow have 2 versions of the
  // router loaded. We can help them understand how to avoid that.
  "useNavigate() may be used only in the context of a <Router> component.") : 0 : void 0;
  let dataRouterContext = react__WEBPACK_IMPORTED_MODULE_0__.useContext(DataRouterContext);
  let {
    basename,
    future,
    navigator
  } = react__WEBPACK_IMPORTED_MODULE_0__.useContext(NavigationContext);
  let {
    matches
  } = react__WEBPACK_IMPORTED_MODULE_0__.useContext(RouteContext);
  let {
    pathname: locationPathname
  } = useLocation();
  let routePathnamesJson = JSON.stringify((0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_getResolveToMatches)(matches, future.v7_relativeSplatPath));
  let activeRef = react__WEBPACK_IMPORTED_MODULE_0__.useRef(false);
  useIsomorphicLayoutEffect(() => {
    activeRef.current = true;
  });
  let navigate = react__WEBPACK_IMPORTED_MODULE_0__.useCallback(function (to, options) {
    if (options === void 0) {
      options = {};
    }
     true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_warning)(activeRef.current, navigateEffectWarning) : 0;

    // Short circuit here since if this happens on first render the navigate
    // is useless because we haven't wired up our history listener yet
    if (!activeRef.current) return;
    if (typeof to === "number") {
      navigator.go(to);
      return;
    }
    let path = (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.resolveTo)(to, JSON.parse(routePathnamesJson), locationPathname, options.relative === "path");

    // If we're operating within a basename, prepend it to the pathname prior
    // to handing off to history (but only if we're not in a data router,
    // otherwise it'll prepend the basename inside of the router).
    // If this is a root navigation, then we navigate to the raw basename
    // which allows the basename to have full control over the presence of a
    // trailing slash on root links
    if (dataRouterContext == null && basename !== "/") {
      path.pathname = path.pathname === "/" ? basename : (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.joinPaths)([basename, path.pathname]);
    }
    (!!options.replace ? navigator.replace : navigator.push)(path, options.state, options);
  }, [basename, navigator, routePathnamesJson, locationPathname, dataRouterContext]);
  return navigate;
}
const OutletContext = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createContext(null);

/**
 * Returns the context (if provided) for the child route at this level of the route
 * hierarchy.
 * @see https://reactrouter.com/v6/hooks/use-outlet-context
 */
function useOutletContext() {
  return react__WEBPACK_IMPORTED_MODULE_0__.useContext(OutletContext);
}

/**
 * Returns the element for the child route at this level of the route
 * hierarchy. Used internally by `<Outlet>` to render child routes.
 *
 * @see https://reactrouter.com/v6/hooks/use-outlet
 */
function useOutlet(context) {
  let outlet = react__WEBPACK_IMPORTED_MODULE_0__.useContext(RouteContext).outlet;
  if (outlet) {
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(OutletContext.Provider, {
      value: context
    }, outlet);
  }
  return outlet;
}

/**
 * Returns an object of key/value pairs of the dynamic params from the current
 * URL that were matched by the route path.
 *
 * @see https://reactrouter.com/v6/hooks/use-params
 */
function useParams() {
  let {
    matches
  } = react__WEBPACK_IMPORTED_MODULE_0__.useContext(RouteContext);
  let routeMatch = matches[matches.length - 1];
  return routeMatch ? routeMatch.params : {};
}

/**
 * Resolves the pathname of the given `to` value against the current location.
 *
 * @see https://reactrouter.com/v6/hooks/use-resolved-path
 */
function useResolvedPath(to, _temp2) {
  let {
    relative
  } = _temp2 === void 0 ? {} : _temp2;
  let {
    future
  } = react__WEBPACK_IMPORTED_MODULE_0__.useContext(NavigationContext);
  let {
    matches
  } = react__WEBPACK_IMPORTED_MODULE_0__.useContext(RouteContext);
  let {
    pathname: locationPathname
  } = useLocation();
  let routePathnamesJson = JSON.stringify((0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_getResolveToMatches)(matches, future.v7_relativeSplatPath));
  return react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.resolveTo)(to, JSON.parse(routePathnamesJson), locationPathname, relative === "path"), [to, routePathnamesJson, locationPathname, relative]);
}

/**
 * Returns the element of the route that matched the current location, prepared
 * with the correct context to render the remainder of the route tree. Route
 * elements in the tree must render an `<Outlet>` to render their child route's
 * element.
 *
 * @see https://reactrouter.com/v6/hooks/use-routes
 */
function useRoutes(routes, locationArg) {
  return useRoutesImpl(routes, locationArg);
}

// Internal implementation with accept optional param for RouterProvider usage
function useRoutesImpl(routes, locationArg, dataRouterState, future) {
  !useInRouterContext() ?  true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_invariant)(false, // TODO: This error is probably because they somehow have 2 versions of the
  // router loaded. We can help them understand how to avoid that.
  "useRoutes() may be used only in the context of a <Router> component.") : 0 : void 0;
  let {
    navigator
  } = react__WEBPACK_IMPORTED_MODULE_0__.useContext(NavigationContext);
  let {
    matches: parentMatches
  } = react__WEBPACK_IMPORTED_MODULE_0__.useContext(RouteContext);
  let routeMatch = parentMatches[parentMatches.length - 1];
  let parentParams = routeMatch ? routeMatch.params : {};
  let parentPathname = routeMatch ? routeMatch.pathname : "/";
  let parentPathnameBase = routeMatch ? routeMatch.pathnameBase : "/";
  let parentRoute = routeMatch && routeMatch.route;
  if (true) {
    // You won't get a warning about 2 different <Routes> under a <Route>
    // without a trailing *, but this is a best-effort warning anyway since we
    // cannot even give the warning unless they land at the parent route.
    //
    // Example:
    //
    // <Routes>
    //   {/* This route path MUST end with /* because otherwise
    //       it will never match /blog/post/123 */}
    //   <Route path="blog" element={<Blog />} />
    //   <Route path="blog/feed" element={<BlogFeed />} />
    // </Routes>
    //
    // function Blog() {
    //   return (
    //     <Routes>
    //       <Route path="post/:id" element={<Post />} />
    //     </Routes>
    //   );
    // }
    let parentPath = parentRoute && parentRoute.path || "";
    warningOnce(parentPathname, !parentRoute || parentPath.endsWith("*"), "You rendered descendant <Routes> (or called `useRoutes()`) at " + ("\"" + parentPathname + "\" (under <Route path=\"" + parentPath + "\">) but the ") + "parent route path has no trailing \"*\". This means if you navigate " + "deeper, the parent won't match anymore and therefore the child " + "routes will never render.\n\n" + ("Please change the parent <Route path=\"" + parentPath + "\"> to <Route ") + ("path=\"" + (parentPath === "/" ? "*" : parentPath + "/*") + "\">."));
  }
  let locationFromContext = useLocation();
  let location;
  if (locationArg) {
    var _parsedLocationArg$pa;
    let parsedLocationArg = typeof locationArg === "string" ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.parsePath)(locationArg) : locationArg;
    !(parentPathnameBase === "/" || ((_parsedLocationArg$pa = parsedLocationArg.pathname) == null ? void 0 : _parsedLocationArg$pa.startsWith(parentPathnameBase))) ?  true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_invariant)(false, "When overriding the location using `<Routes location>` or `useRoutes(routes, location)`, " + "the location pathname must begin with the portion of the URL pathname that was " + ("matched by all parent routes. The current pathname base is \"" + parentPathnameBase + "\" ") + ("but pathname \"" + parsedLocationArg.pathname + "\" was given in the `location` prop.")) : 0 : void 0;
    location = parsedLocationArg;
  } else {
    location = locationFromContext;
  }
  let pathname = location.pathname || "/";
  let remainingPathname = pathname;
  if (parentPathnameBase !== "/") {
    // Determine the remaining pathname by removing the # of URL segments the
    // parentPathnameBase has, instead of removing based on character count.
    // This is because we can't guarantee that incoming/outgoing encodings/
    // decodings will match exactly.
    // We decode paths before matching on a per-segment basis with
    // decodeURIComponent(), but we re-encode pathnames via `new URL()` so they
    // match what `window.location.pathname` would reflect.  Those don't 100%
    // align when it comes to encoded URI characters such as % and &.
    //
    // So we may end up with:
    //   pathname:           "/descendant/a%25b/match"
    //   parentPathnameBase: "/descendant/a%b"
    //
    // And the direct substring removal approach won't work :/
    let parentSegments = parentPathnameBase.replace(/^\//, "").split("/");
    let segments = pathname.replace(/^\//, "").split("/");
    remainingPathname = "/" + segments.slice(parentSegments.length).join("/");
  }
  let matches = (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.matchRoutes)(routes, {
    pathname: remainingPathname
  });
  if (true) {
     true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_warning)(parentRoute || matches != null, "No routes matched location \"" + location.pathname + location.search + location.hash + "\" ") : 0;
     true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_warning)(matches == null || matches[matches.length - 1].route.element !== undefined || matches[matches.length - 1].route.Component !== undefined || matches[matches.length - 1].route.lazy !== undefined, "Matched leaf route at location \"" + location.pathname + location.search + location.hash + "\" " + "does not have an element or Component. This means it will render an <Outlet /> with a " + "null value by default resulting in an \"empty\" page.") : 0;
  }
  let renderedMatches = _renderMatches(matches && matches.map(match => Object.assign({}, match, {
    params: Object.assign({}, parentParams, match.params),
    pathname: (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.joinPaths)([parentPathnameBase,
    // Re-encode pathnames that were decoded inside matchRoutes
    navigator.encodeLocation ? navigator.encodeLocation(match.pathname).pathname : match.pathname]),
    pathnameBase: match.pathnameBase === "/" ? parentPathnameBase : (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.joinPaths)([parentPathnameBase,
    // Re-encode pathnames that were decoded inside matchRoutes
    navigator.encodeLocation ? navigator.encodeLocation(match.pathnameBase).pathname : match.pathnameBase])
  })), parentMatches, dataRouterState, future);

  // When a user passes in a `locationArg`, the associated routes need to
  // be wrapped in a new `LocationContext.Provider` in order for `useLocation`
  // to use the scoped location instead of the global location.
  if (locationArg && renderedMatches) {
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(LocationContext.Provider, {
      value: {
        location: _extends({
          pathname: "/",
          search: "",
          hash: "",
          state: null,
          key: "default"
        }, location),
        navigationType: _remix_run_router__WEBPACK_IMPORTED_MODULE_1__.Action.Pop
      }
    }, renderedMatches);
  }
  return renderedMatches;
}
function DefaultErrorComponent() {
  let error = useRouteError();
  let message = (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.isRouteErrorResponse)(error) ? error.status + " " + error.statusText : error instanceof Error ? error.message : JSON.stringify(error);
  let stack = error instanceof Error ? error.stack : null;
  let lightgrey = "rgba(200,200,200, 0.5)";
  let preStyles = {
    padding: "0.5rem",
    backgroundColor: lightgrey
  };
  let codeStyles = {
    padding: "2px 4px",
    backgroundColor: lightgrey
  };
  let devInfo = null;
  if (true) {
    console.error("Error handled by React Router default ErrorBoundary:", error);
    devInfo = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("p", null, "\uD83D\uDCBF Hey developer \uD83D\uDC4B"), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("p", null, "You can provide a way better UX than this when your app throws errors by providing your own ", /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("code", {
      style: codeStyles
    }, "ErrorBoundary"), " or", " ", /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("code", {
      style: codeStyles
    }, "errorElement"), " prop on your route."));
  }
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("h2", null, "Unexpected Application Error!"), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("h3", {
    style: {
      fontStyle: "italic"
    }
  }, message), stack ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("pre", {
    style: preStyles
  }, stack) : null, devInfo);
}
const defaultErrorElement = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(DefaultErrorComponent, null);
class RenderErrorBoundary extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
  constructor(props) {
    super(props);
    this.state = {
      location: props.location,
      revalidation: props.revalidation,
      error: props.error
    };
  }
  static getDerivedStateFromError(error) {
    return {
      error: error
    };
  }
  static getDerivedStateFromProps(props, state) {
    // When we get into an error state, the user will likely click "back" to the
    // previous page that didn't have an error. Because this wraps the entire
    // application, that will have no effect--the error page continues to display.
    // This gives us a mechanism to recover from the error when the location changes.
    //
    // Whether we're in an error state or not, we update the location in state
    // so that when we are in an error state, it gets reset when a new location
    // comes in and the user recovers from the error.
    if (state.location !== props.location || state.revalidation !== "idle" && props.revalidation === "idle") {
      return {
        error: props.error,
        location: props.location,
        revalidation: props.revalidation
      };
    }

    // If we're not changing locations, preserve the location but still surface
    // any new errors that may come through. We retain the existing error, we do
    // this because the error provided from the app state may be cleared without
    // the location changing.
    return {
      error: props.error !== undefined ? props.error : state.error,
      location: state.location,
      revalidation: props.revalidation || state.revalidation
    };
  }
  componentDidCatch(error, errorInfo) {
    console.error("React Router caught the following error during render", error, errorInfo);
  }
  render() {
    return this.state.error !== undefined ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(RouteContext.Provider, {
      value: this.props.routeContext
    }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(RouteErrorContext.Provider, {
      value: this.state.error,
      children: this.props.component
    })) : this.props.children;
  }
}
function RenderedRoute(_ref) {
  let {
    routeContext,
    match,
    children
  } = _ref;
  let dataRouterContext = react__WEBPACK_IMPORTED_MODULE_0__.useContext(DataRouterContext);

  // Track how deep we got in our render pass to emulate SSR componentDidCatch
  // in a DataStaticRouter
  if (dataRouterContext && dataRouterContext.static && dataRouterContext.staticContext && (match.route.errorElement || match.route.ErrorBoundary)) {
    dataRouterContext.staticContext._deepestRenderedBoundaryId = match.route.id;
  }
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(RouteContext.Provider, {
    value: routeContext
  }, children);
}
function _renderMatches(matches, parentMatches, dataRouterState, future) {
  var _dataRouterState;
  if (parentMatches === void 0) {
    parentMatches = [];
  }
  if (dataRouterState === void 0) {
    dataRouterState = null;
  }
  if (future === void 0) {
    future = null;
  }
  if (matches == null) {
    var _future;
    if (!dataRouterState) {
      return null;
    }
    if (dataRouterState.errors) {
      // Don't bail if we have data router errors so we can render them in the
      // boundary.  Use the pre-matched (or shimmed) matches
      matches = dataRouterState.matches;
    } else if ((_future = future) != null && _future.v7_partialHydration && parentMatches.length === 0 && !dataRouterState.initialized && dataRouterState.matches.length > 0) {
      // Don't bail if we're initializing with partial hydration and we have
      // router matches.  That means we're actively running `patchRoutesOnNavigation`
      // so we should render down the partial matches to the appropriate
      // `HydrateFallback`.  We only do this if `parentMatches` is empty so it
      // only impacts the root matches for `RouterProvider` and no descendant
      // `<Routes>`
      matches = dataRouterState.matches;
    } else {
      return null;
    }
  }
  let renderedMatches = matches;

  // If we have data errors, trim matches to the highest error boundary
  let errors = (_dataRouterState = dataRouterState) == null ? void 0 : _dataRouterState.errors;
  if (errors != null) {
    let errorIndex = renderedMatches.findIndex(m => m.route.id && (errors == null ? void 0 : errors[m.route.id]) !== undefined);
    !(errorIndex >= 0) ?  true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_invariant)(false, "Could not find a matching route for errors on route IDs: " + Object.keys(errors).join(",")) : 0 : void 0;
    renderedMatches = renderedMatches.slice(0, Math.min(renderedMatches.length, errorIndex + 1));
  }

  // If we're in a partial hydration mode, detect if we need to render down to
  // a given HydrateFallback while we load the rest of the hydration data
  let renderFallback = false;
  let fallbackIndex = -1;
  if (dataRouterState && future && future.v7_partialHydration) {
    for (let i = 0; i < renderedMatches.length; i++) {
      let match = renderedMatches[i];
      // Track the deepest fallback up until the first route without data
      if (match.route.HydrateFallback || match.route.hydrateFallbackElement) {
        fallbackIndex = i;
      }
      if (match.route.id) {
        let {
          loaderData,
          errors
        } = dataRouterState;
        let needsToRunLoader = match.route.loader && loaderData[match.route.id] === undefined && (!errors || errors[match.route.id] === undefined);
        if (match.route.lazy || needsToRunLoader) {
          // We found the first route that's not ready to render (waiting on
          // lazy, or has a loader that hasn't run yet).  Flag that we need to
          // render a fallback and render up until the appropriate fallback
          renderFallback = true;
          if (fallbackIndex >= 0) {
            renderedMatches = renderedMatches.slice(0, fallbackIndex + 1);
          } else {
            renderedMatches = [renderedMatches[0]];
          }
          break;
        }
      }
    }
  }
  return renderedMatches.reduceRight((outlet, match, index) => {
    // Only data routers handle errors/fallbacks
    let error;
    let shouldRenderHydrateFallback = false;
    let errorElement = null;
    let hydrateFallbackElement = null;
    if (dataRouterState) {
      error = errors && match.route.id ? errors[match.route.id] : undefined;
      errorElement = match.route.errorElement || defaultErrorElement;
      if (renderFallback) {
        if (fallbackIndex < 0 && index === 0) {
          warningOnce("route-fallback", false, "No `HydrateFallback` element provided to render during initial hydration");
          shouldRenderHydrateFallback = true;
          hydrateFallbackElement = null;
        } else if (fallbackIndex === index) {
          shouldRenderHydrateFallback = true;
          hydrateFallbackElement = match.route.hydrateFallbackElement || null;
        }
      }
    }
    let matches = parentMatches.concat(renderedMatches.slice(0, index + 1));
    let getChildren = () => {
      let children;
      if (error) {
        children = errorElement;
      } else if (shouldRenderHydrateFallback) {
        children = hydrateFallbackElement;
      } else if (match.route.Component) {
        // Note: This is a de-optimized path since React won't re-use the
        // ReactElement since it's identity changes with each new
        // React.createElement call.  We keep this so folks can use
        // `<Route Component={...}>` in `<Routes>` but generally `Component`
        // usage is only advised in `RouterProvider` when we can convert it to
        // `element` ahead of time.
        children = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(match.route.Component, null);
      } else if (match.route.element) {
        children = match.route.element;
      } else {
        children = outlet;
      }
      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(RenderedRoute, {
        match: match,
        routeContext: {
          outlet,
          matches,
          isDataRoute: dataRouterState != null
        },
        children: children
      });
    };
    // Only wrap in an error boundary within data router usages when we have an
    // ErrorBoundary/errorElement on this route.  Otherwise let it bubble up to
    // an ancestor ErrorBoundary/errorElement
    return dataRouterState && (match.route.ErrorBoundary || match.route.errorElement || index === 0) ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(RenderErrorBoundary, {
      location: dataRouterState.location,
      revalidation: dataRouterState.revalidation,
      component: errorElement,
      error: error,
      children: getChildren(),
      routeContext: {
        outlet: null,
        matches,
        isDataRoute: true
      }
    }) : getChildren();
  }, null);
}
var DataRouterHook = /*#__PURE__*/function (DataRouterHook) {
  DataRouterHook["UseBlocker"] = "useBlocker";
  DataRouterHook["UseRevalidator"] = "useRevalidator";
  DataRouterHook["UseNavigateStable"] = "useNavigate";
  return DataRouterHook;
}(DataRouterHook || {});
var DataRouterStateHook = /*#__PURE__*/function (DataRouterStateHook) {
  DataRouterStateHook["UseBlocker"] = "useBlocker";
  DataRouterStateHook["UseLoaderData"] = "useLoaderData";
  DataRouterStateHook["UseActionData"] = "useActionData";
  DataRouterStateHook["UseRouteError"] = "useRouteError";
  DataRouterStateHook["UseNavigation"] = "useNavigation";
  DataRouterStateHook["UseRouteLoaderData"] = "useRouteLoaderData";
  DataRouterStateHook["UseMatches"] = "useMatches";
  DataRouterStateHook["UseRevalidator"] = "useRevalidator";
  DataRouterStateHook["UseNavigateStable"] = "useNavigate";
  DataRouterStateHook["UseRouteId"] = "useRouteId";
  return DataRouterStateHook;
}(DataRouterStateHook || {});
function getDataRouterConsoleError(hookName) {
  return hookName + " must be used within a data router.  See https://reactrouter.com/v6/routers/picking-a-router.";
}
function useDataRouterContext(hookName) {
  let ctx = react__WEBPACK_IMPORTED_MODULE_0__.useContext(DataRouterContext);
  !ctx ?  true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_invariant)(false, getDataRouterConsoleError(hookName)) : 0 : void 0;
  return ctx;
}
function useDataRouterState(hookName) {
  let state = react__WEBPACK_IMPORTED_MODULE_0__.useContext(DataRouterStateContext);
  !state ?  true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_invariant)(false, getDataRouterConsoleError(hookName)) : 0 : void 0;
  return state;
}
function useRouteContext(hookName) {
  let route = react__WEBPACK_IMPORTED_MODULE_0__.useContext(RouteContext);
  !route ?  true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_invariant)(false, getDataRouterConsoleError(hookName)) : 0 : void 0;
  return route;
}

// Internal version with hookName-aware debugging
function useCurrentRouteId(hookName) {
  let route = useRouteContext(hookName);
  let thisRoute = route.matches[route.matches.length - 1];
  !thisRoute.route.id ?  true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_invariant)(false, hookName + " can only be used on routes that contain a unique \"id\"") : 0 : void 0;
  return thisRoute.route.id;
}

/**
 * Returns the ID for the nearest contextual route
 */
function useRouteId() {
  return useCurrentRouteId(DataRouterStateHook.UseRouteId);
}

/**
 * Returns the current navigation, defaulting to an "idle" navigation when
 * no navigation is in progress
 */
function useNavigation() {
  let state = useDataRouterState(DataRouterStateHook.UseNavigation);
  return state.navigation;
}

/**
 * Returns a revalidate function for manually triggering revalidation, as well
 * as the current state of any manual revalidations
 */
function useRevalidator() {
  let dataRouterContext = useDataRouterContext(DataRouterHook.UseRevalidator);
  let state = useDataRouterState(DataRouterStateHook.UseRevalidator);
  return react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => ({
    revalidate: dataRouterContext.router.revalidate,
    state: state.revalidation
  }), [dataRouterContext.router.revalidate, state.revalidation]);
}

/**
 * Returns the active route matches, useful for accessing loaderData for
 * parent/child routes or the route "handle" property
 */
function useMatches() {
  let {
    matches,
    loaderData
  } = useDataRouterState(DataRouterStateHook.UseMatches);
  return react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => matches.map(m => (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_convertRouteMatchToUiMatch)(m, loaderData)), [matches, loaderData]);
}

/**
 * Returns the loader data for the nearest ancestor Route loader
 */
function useLoaderData() {
  let state = useDataRouterState(DataRouterStateHook.UseLoaderData);
  let routeId = useCurrentRouteId(DataRouterStateHook.UseLoaderData);
  if (state.errors && state.errors[routeId] != null) {
    console.error("You cannot `useLoaderData` in an errorElement (routeId: " + routeId + ")");
    return undefined;
  }
  return state.loaderData[routeId];
}

/**
 * Returns the loaderData for the given routeId
 */
function useRouteLoaderData(routeId) {
  let state = useDataRouterState(DataRouterStateHook.UseRouteLoaderData);
  return state.loaderData[routeId];
}

/**
 * Returns the action data for the nearest ancestor Route action
 */
function useActionData() {
  let state = useDataRouterState(DataRouterStateHook.UseActionData);
  let routeId = useCurrentRouteId(DataRouterStateHook.UseLoaderData);
  return state.actionData ? state.actionData[routeId] : undefined;
}

/**
 * Returns the nearest ancestor Route error, which could be a loader/action
 * error or a render error.  This is intended to be called from your
 * ErrorBoundary/errorElement to display a proper error message.
 */
function useRouteError() {
  var _state$errors;
  let error = react__WEBPACK_IMPORTED_MODULE_0__.useContext(RouteErrorContext);
  let state = useDataRouterState(DataRouterStateHook.UseRouteError);
  let routeId = useCurrentRouteId(DataRouterStateHook.UseRouteError);

  // If this was a render error, we put it in a RouteError context inside
  // of RenderErrorBoundary
  if (error !== undefined) {
    return error;
  }

  // Otherwise look for errors from our data router state
  return (_state$errors = state.errors) == null ? void 0 : _state$errors[routeId];
}

/**
 * Returns the happy-path data from the nearest ancestor `<Await />` value
 */
function useAsyncValue() {
  let value = react__WEBPACK_IMPORTED_MODULE_0__.useContext(AwaitContext);
  return value == null ? void 0 : value._data;
}

/**
 * Returns the error from the nearest ancestor `<Await />` value
 */
function useAsyncError() {
  let value = react__WEBPACK_IMPORTED_MODULE_0__.useContext(AwaitContext);
  return value == null ? void 0 : value._error;
}
let blockerId = 0;

/**
 * Allow the application to block navigations within the SPA and present the
 * user a confirmation dialog to confirm the navigation.  Mostly used to avoid
 * using half-filled form data.  This does not handle hard-reloads or
 * cross-origin navigations.
 */
function useBlocker(shouldBlock) {
  let {
    router,
    basename
  } = useDataRouterContext(DataRouterHook.UseBlocker);
  let state = useDataRouterState(DataRouterStateHook.UseBlocker);
  let [blockerKey, setBlockerKey] = react__WEBPACK_IMPORTED_MODULE_0__.useState("");
  let blockerFunction = react__WEBPACK_IMPORTED_MODULE_0__.useCallback(arg => {
    if (typeof shouldBlock !== "function") {
      return !!shouldBlock;
    }
    if (basename === "/") {
      return shouldBlock(arg);
    }

    // If they provided us a function and we've got an active basename, strip
    // it from the locations we expose to the user to match the behavior of
    // useLocation
    let {
      currentLocation,
      nextLocation,
      historyAction
    } = arg;
    return shouldBlock({
      currentLocation: _extends({}, currentLocation, {
        pathname: (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.stripBasename)(currentLocation.pathname, basename) || currentLocation.pathname
      }),
      nextLocation: _extends({}, nextLocation, {
        pathname: (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.stripBasename)(nextLocation.pathname, basename) || nextLocation.pathname
      }),
      historyAction
    });
  }, [basename, shouldBlock]);

  // This effect is in charge of blocker key assignment and deletion (which is
  // tightly coupled to the key)
  react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
    let key = String(++blockerId);
    setBlockerKey(key);
    return () => router.deleteBlocker(key);
  }, [router]);

  // This effect handles assigning the blockerFunction.  This is to handle
  // unstable blocker function identities, and happens only after the prior
  // effect so we don't get an orphaned blockerFunction in the router with a
  // key of "".  Until then we just have the IDLE_BLOCKER.
  react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
    if (blockerKey !== "") {
      router.getBlocker(blockerKey, blockerFunction);
    }
  }, [router, blockerKey, blockerFunction]);

  // Prefer the blocker from `state` not `router.state` since DataRouterContext
  // is memoized so this ensures we update on blocker state updates
  return blockerKey && state.blockers.has(blockerKey) ? state.blockers.get(blockerKey) : _remix_run_router__WEBPACK_IMPORTED_MODULE_1__.IDLE_BLOCKER;
}

/**
 * Stable version of useNavigate that is used when we are in the context of
 * a RouterProvider.
 */
function useNavigateStable() {
  let {
    router
  } = useDataRouterContext(DataRouterHook.UseNavigateStable);
  let id = useCurrentRouteId(DataRouterStateHook.UseNavigateStable);
  let activeRef = react__WEBPACK_IMPORTED_MODULE_0__.useRef(false);
  useIsomorphicLayoutEffect(() => {
    activeRef.current = true;
  });
  let navigate = react__WEBPACK_IMPORTED_MODULE_0__.useCallback(function (to, options) {
    if (options === void 0) {
      options = {};
    }
     true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_warning)(activeRef.current, navigateEffectWarning) : 0;

    // Short circuit here since if this happens on first render the navigate
    // is useless because we haven't wired up our router subscriber yet
    if (!activeRef.current) return;
    if (typeof to === "number") {
      router.navigate(to);
    } else {
      router.navigate(to, _extends({
        fromRouteId: id
      }, options));
    }
  }, [router, id]);
  return navigate;
}
const alreadyWarned$1 = {};
function warningOnce(key, cond, message) {
  if (!cond && !alreadyWarned$1[key]) {
    alreadyWarned$1[key] = true;
     true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_warning)(false, message) : 0;
  }
}

const alreadyWarned = {};
function warnOnce(key, message) {
  if ( true && !alreadyWarned[message]) {
    alreadyWarned[message] = true;
    console.warn(message);
  }
}
const logDeprecation = (flag, msg, link) => warnOnce(flag, "\u26A0\uFE0F React Router Future Flag Warning: " + msg + ". " + ("You can use the `" + flag + "` future flag to opt-in early. ") + ("For more information, see " + link + "."));
function logV6DeprecationWarnings(renderFuture, routerFuture) {
  if ((renderFuture == null ? void 0 : renderFuture.v7_startTransition) === undefined) {
    logDeprecation("v7_startTransition", "React Router will begin wrapping state updates in `React.startTransition` in v7", "https://reactrouter.com/v6/upgrading/future#v7_starttransition");
  }
  if ((renderFuture == null ? void 0 : renderFuture.v7_relativeSplatPath) === undefined && (!routerFuture || routerFuture.v7_relativeSplatPath === undefined)) {
    logDeprecation("v7_relativeSplatPath", "Relative route resolution within Splat routes is changing in v7", "https://reactrouter.com/v6/upgrading/future#v7_relativesplatpath");
  }
  if (routerFuture) {
    if (routerFuture.v7_fetcherPersist === undefined) {
      logDeprecation("v7_fetcherPersist", "The persistence behavior of fetchers is changing in v7", "https://reactrouter.com/v6/upgrading/future#v7_fetcherpersist");
    }
    if (routerFuture.v7_normalizeFormMethod === undefined) {
      logDeprecation("v7_normalizeFormMethod", "Casing of `formMethod` fields is being normalized to uppercase in v7", "https://reactrouter.com/v6/upgrading/future#v7_normalizeformmethod");
    }
    if (routerFuture.v7_partialHydration === undefined) {
      logDeprecation("v7_partialHydration", "`RouterProvider` hydration behavior is changing in v7", "https://reactrouter.com/v6/upgrading/future#v7_partialhydration");
    }
    if (routerFuture.v7_skipActionErrorRevalidation === undefined) {
      logDeprecation("v7_skipActionErrorRevalidation", "The revalidation behavior after 4xx/5xx `action` responses is changing in v7", "https://reactrouter.com/v6/upgrading/future#v7_skipactionerrorrevalidation");
    }
  }
}

/**
  Webpack + React 17 fails to compile on any of the following because webpack
  complains that `startTransition` doesn't exist in `React`:
  * import { startTransition } from "react"
  * import * as React from from "react";
    "startTransition" in React ? React.startTransition(() => setState()) : setState()
  * import * as React from from "react";
    "startTransition" in React ? React["startTransition"](() => setState()) : setState()

  Moving it to a constant such as the following solves the Webpack/React 17 issue:
  * import * as React from from "react";
    const START_TRANSITION = "startTransition";
    START_TRANSITION in React ? React[START_TRANSITION](() => setState()) : setState()

  However, that introduces webpack/terser minification issues in production builds
  in React 18 where minification/obfuscation ends up removing the call of
  React.startTransition entirely from the first half of the ternary.  Grabbing
  this exported reference once up front resolves that issue.

  See https://github.com/remix-run/react-router/issues/10579
*/
const START_TRANSITION = "startTransition";
const startTransitionImpl = react__WEBPACK_IMPORTED_MODULE_0__[START_TRANSITION];

/**
 * Given a Remix Router instance, render the appropriate UI
 */
function RouterProvider(_ref) {
  let {
    fallbackElement,
    router,
    future
  } = _ref;
  let [state, setStateImpl] = react__WEBPACK_IMPORTED_MODULE_0__.useState(router.state);
  let {
    v7_startTransition
  } = future || {};
  let setState = react__WEBPACK_IMPORTED_MODULE_0__.useCallback(newState => {
    if (v7_startTransition && startTransitionImpl) {
      startTransitionImpl(() => setStateImpl(newState));
    } else {
      setStateImpl(newState);
    }
  }, [setStateImpl, v7_startTransition]);

  // Need to use a layout effect here so we are subscribed early enough to
  // pick up on any render-driven redirects/navigations (useEffect/<Navigate>)
  react__WEBPACK_IMPORTED_MODULE_0__.useLayoutEffect(() => router.subscribe(setState), [router, setState]);
  react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
     true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_warning)(fallbackElement == null || !router.future.v7_partialHydration, "`<RouterProvider fallbackElement>` is deprecated when using " + "`v7_partialHydration`, use a `HydrateFallback` component instead") : 0;
    // Only log this once on initial mount
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  let navigator = react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => {
    return {
      createHref: router.createHref,
      encodeLocation: router.encodeLocation,
      go: n => router.navigate(n),
      push: (to, state, opts) => router.navigate(to, {
        state,
        preventScrollReset: opts == null ? void 0 : opts.preventScrollReset
      }),
      replace: (to, state, opts) => router.navigate(to, {
        replace: true,
        state,
        preventScrollReset: opts == null ? void 0 : opts.preventScrollReset
      })
    };
  }, [router]);
  let basename = router.basename || "/";
  let dataRouterContext = react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => ({
    router,
    navigator,
    static: false,
    basename
  }), [router, navigator, basename]);
  react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => logV6DeprecationWarnings(future, router.future), [router, future]);

  // The fragment and {null} here are important!  We need them to keep React 18's
  // useId happy when we are server-rendering since we may have a <script> here
  // containing the hydrated server-side staticContext (from StaticRouterProvider).
  // useId relies on the component tree structure to generate deterministic id's
  // so we need to ensure it remains the same on the client even though
  // we don't need the <script> tag
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(DataRouterContext.Provider, {
    value: dataRouterContext
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(DataRouterStateContext.Provider, {
    value: state
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(Router, {
    basename: basename,
    location: state.location,
    navigationType: state.historyAction,
    navigator: navigator,
    future: {
      v7_relativeSplatPath: router.future.v7_relativeSplatPath
    }
  }, state.initialized || router.future.v7_partialHydration ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(DataRoutes, {
    routes: router.routes,
    future: router.future,
    state: state
  }) : fallbackElement))), null);
}
function DataRoutes(_ref2) {
  let {
    routes,
    future,
    state
  } = _ref2;
  return useRoutesImpl(routes, undefined, state, future);
}
/**
 * A `<Router>` that stores all entries in memory.
 *
 * @see https://reactrouter.com/v6/router-components/memory-router
 */
function MemoryRouter(_ref3) {
  let {
    basename,
    children,
    initialEntries,
    initialIndex,
    future
  } = _ref3;
  let historyRef = react__WEBPACK_IMPORTED_MODULE_0__.useRef();
  if (historyRef.current == null) {
    historyRef.current = (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.createMemoryHistory)({
      initialEntries,
      initialIndex,
      v5Compat: true
    });
  }
  let history = historyRef.current;
  let [state, setStateImpl] = react__WEBPACK_IMPORTED_MODULE_0__.useState({
    action: history.action,
    location: history.location
  });
  let {
    v7_startTransition
  } = future || {};
  let setState = react__WEBPACK_IMPORTED_MODULE_0__.useCallback(newState => {
    v7_startTransition && startTransitionImpl ? startTransitionImpl(() => setStateImpl(newState)) : setStateImpl(newState);
  }, [setStateImpl, v7_startTransition]);
  react__WEBPACK_IMPORTED_MODULE_0__.useLayoutEffect(() => history.listen(setState), [history, setState]);
  react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => logV6DeprecationWarnings(future), [future]);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(Router, {
    basename: basename,
    children: children,
    location: state.location,
    navigationType: state.action,
    navigator: history,
    future: future
  });
}
/**
 * Changes the current location.
 *
 * Note: This API is mostly useful in React.Component subclasses that are not
 * able to use hooks. In functional components, we recommend you use the
 * `useNavigate` hook instead.
 *
 * @see https://reactrouter.com/v6/components/navigate
 */
function Navigate(_ref4) {
  let {
    to,
    replace,
    state,
    relative
  } = _ref4;
  !useInRouterContext() ?  true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_invariant)(false, // TODO: This error is probably because they somehow have 2 versions of
  // the router loaded. We can help them understand how to avoid that.
  "<Navigate> may be used only in the context of a <Router> component.") : 0 : void 0;
  let {
    future,
    static: isStatic
  } = react__WEBPACK_IMPORTED_MODULE_0__.useContext(NavigationContext);
   true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_warning)(!isStatic, "<Navigate> must not be used on the initial render in a <StaticRouter>. " + "This is a no-op, but you should modify your code so the <Navigate> is " + "only ever rendered in response to some user interaction or state change.") : 0;
  let {
    matches
  } = react__WEBPACK_IMPORTED_MODULE_0__.useContext(RouteContext);
  let {
    pathname: locationPathname
  } = useLocation();
  let navigate = useNavigate();

  // Resolve the path outside of the effect so that when effects run twice in
  // StrictMode they navigate to the same place
  let path = (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.resolveTo)(to, (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_getResolveToMatches)(matches, future.v7_relativeSplatPath), locationPathname, relative === "path");
  let jsonPath = JSON.stringify(path);
  react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => navigate(JSON.parse(jsonPath), {
    replace,
    state,
    relative
  }), [navigate, jsonPath, relative, replace, state]);
  return null;
}
/**
 * Renders the child route's element, if there is one.
 *
 * @see https://reactrouter.com/v6/components/outlet
 */
function Outlet(props) {
  return useOutlet(props.context);
}
/**
 * Declares an element that should be rendered at a certain URL path.
 *
 * @see https://reactrouter.com/v6/components/route
 */
function Route(_props) {
   true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_invariant)(false, "A <Route> is only ever to be used as the child of <Routes> element, " + "never rendered directly. Please wrap your <Route> in a <Routes>.") : 0 ;
}
/**
 * Provides location context for the rest of the app.
 *
 * Note: You usually won't render a `<Router>` directly. Instead, you'll render a
 * router that is more specific to your environment such as a `<BrowserRouter>`
 * in web browsers or a `<StaticRouter>` for server rendering.
 *
 * @see https://reactrouter.com/v6/router-components/router
 */
function Router(_ref5) {
  let {
    basename: basenameProp = "/",
    children = null,
    location: locationProp,
    navigationType = _remix_run_router__WEBPACK_IMPORTED_MODULE_1__.Action.Pop,
    navigator,
    static: staticProp = false,
    future
  } = _ref5;
  !!useInRouterContext() ?  true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_invariant)(false, "You cannot render a <Router> inside another <Router>." + " You should never have more than one in your app.") : 0 : void 0;

  // Preserve trailing slashes on basename, so we can let the user control
  // the enforcement of trailing slashes throughout the app
  let basename = basenameProp.replace(/^\/*/, "/");
  let navigationContext = react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => ({
    basename,
    navigator,
    static: staticProp,
    future: _extends({
      v7_relativeSplatPath: false
    }, future)
  }), [basename, future, navigator, staticProp]);
  if (typeof locationProp === "string") {
    locationProp = (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.parsePath)(locationProp);
  }
  let {
    pathname = "/",
    search = "",
    hash = "",
    state = null,
    key = "default"
  } = locationProp;
  let locationContext = react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => {
    let trailingPathname = (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.stripBasename)(pathname, basename);
    if (trailingPathname == null) {
      return null;
    }
    return {
      location: {
        pathname: trailingPathname,
        search,
        hash,
        state,
        key
      },
      navigationType
    };
  }, [basename, pathname, search, hash, state, key, navigationType]);
   true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_warning)(locationContext != null, "<Router basename=\"" + basename + "\"> is not able to match the URL " + ("\"" + pathname + search + hash + "\" because it does not start with the ") + "basename, so the <Router> won't render anything.") : 0;
  if (locationContext == null) {
    return null;
  }
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(NavigationContext.Provider, {
    value: navigationContext
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(LocationContext.Provider, {
    children: children,
    value: locationContext
  }));
}
/**
 * A container for a nested tree of `<Route>` elements that renders the branch
 * that best matches the current location.
 *
 * @see https://reactrouter.com/v6/components/routes
 */
function Routes(_ref6) {
  let {
    children,
    location
  } = _ref6;
  return useRoutes(createRoutesFromChildren(children), location);
}
/**
 * Component to use for rendering lazily loaded data from returning defer()
 * in a loader function
 */
function Await(_ref7) {
  let {
    children,
    errorElement,
    resolve
  } = _ref7;
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(AwaitErrorBoundary, {
    resolve: resolve,
    errorElement: errorElement
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(ResolveAwait, null, children));
}
var AwaitRenderStatus = /*#__PURE__*/function (AwaitRenderStatus) {
  AwaitRenderStatus[AwaitRenderStatus["pending"] = 0] = "pending";
  AwaitRenderStatus[AwaitRenderStatus["success"] = 1] = "success";
  AwaitRenderStatus[AwaitRenderStatus["error"] = 2] = "error";
  return AwaitRenderStatus;
}(AwaitRenderStatus || {});
const neverSettledPromise = new Promise(() => {});
class AwaitErrorBoundary extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
  constructor(props) {
    super(props);
    this.state = {
      error: null
    };
  }
  static getDerivedStateFromError(error) {
    return {
      error
    };
  }
  componentDidCatch(error, errorInfo) {
    console.error("<Await> caught the following error during render", error, errorInfo);
  }
  render() {
    let {
      children,
      errorElement,
      resolve
    } = this.props;
    let promise = null;
    let status = AwaitRenderStatus.pending;
    if (!(resolve instanceof Promise)) {
      // Didn't get a promise - provide as a resolved promise
      status = AwaitRenderStatus.success;
      promise = Promise.resolve();
      Object.defineProperty(promise, "_tracked", {
        get: () => true
      });
      Object.defineProperty(promise, "_data", {
        get: () => resolve
      });
    } else if (this.state.error) {
      // Caught a render error, provide it as a rejected promise
      status = AwaitRenderStatus.error;
      let renderError = this.state.error;
      promise = Promise.reject().catch(() => {}); // Avoid unhandled rejection warnings
      Object.defineProperty(promise, "_tracked", {
        get: () => true
      });
      Object.defineProperty(promise, "_error", {
        get: () => renderError
      });
    } else if (resolve._tracked) {
      // Already tracked promise - check contents
      promise = resolve;
      status = "_error" in promise ? AwaitRenderStatus.error : "_data" in promise ? AwaitRenderStatus.success : AwaitRenderStatus.pending;
    } else {
      // Raw (untracked) promise - track it
      status = AwaitRenderStatus.pending;
      Object.defineProperty(resolve, "_tracked", {
        get: () => true
      });
      promise = resolve.then(data => Object.defineProperty(resolve, "_data", {
        get: () => data
      }), error => Object.defineProperty(resolve, "_error", {
        get: () => error
      }));
    }
    if (status === AwaitRenderStatus.error && promise._error instanceof _remix_run_router__WEBPACK_IMPORTED_MODULE_1__.AbortedDeferredError) {
      // Freeze the UI by throwing a never resolved promise
      throw neverSettledPromise;
    }
    if (status === AwaitRenderStatus.error && !errorElement) {
      // No errorElement, throw to the nearest route-level error boundary
      throw promise._error;
    }
    if (status === AwaitRenderStatus.error) {
      // Render via our errorElement
      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(AwaitContext.Provider, {
        value: promise,
        children: errorElement
      });
    }
    if (status === AwaitRenderStatus.success) {
      // Render children with resolved value
      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(AwaitContext.Provider, {
        value: promise,
        children: children
      });
    }

    // Throw to the suspense boundary
    throw promise;
  }
}

/**
 * @private
 * Indirection to leverage useAsyncValue for a render-prop API on `<Await>`
 */
function ResolveAwait(_ref8) {
  let {
    children
  } = _ref8;
  let data = useAsyncValue();
  let toRender = typeof children === "function" ? children(data) : children;
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, toRender);
}

///////////////////////////////////////////////////////////////////////////////
// UTILS
///////////////////////////////////////////////////////////////////////////////

/**
 * Creates a route config from a React "children" object, which is usually
 * either a `<Route>` element or an array of them. Used internally by
 * `<Routes>` to create a route config from its children.
 *
 * @see https://reactrouter.com/v6/utils/create-routes-from-children
 */
function createRoutesFromChildren(children, parentPath) {
  if (parentPath === void 0) {
    parentPath = [];
  }
  let routes = [];
  react__WEBPACK_IMPORTED_MODULE_0__.Children.forEach(children, (element, index) => {
    if (! /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.isValidElement(element)) {
      // Ignore non-elements. This allows people to more easily inline
      // conditionals in their route config.
      return;
    }
    let treePath = [...parentPath, index];
    if (element.type === react__WEBPACK_IMPORTED_MODULE_0__.Fragment) {
      // Transparently support React.Fragment and its children.
      routes.push.apply(routes, createRoutesFromChildren(element.props.children, treePath));
      return;
    }
    !(element.type === Route) ?  true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_invariant)(false, "[" + (typeof element.type === "string" ? element.type : element.type.name) + "] is not a <Route> component. All component children of <Routes> must be a <Route> or <React.Fragment>") : 0 : void 0;
    !(!element.props.index || !element.props.children) ?  true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_invariant)(false, "An index route cannot have child routes.") : 0 : void 0;
    let route = {
      id: element.props.id || treePath.join("-"),
      caseSensitive: element.props.caseSensitive,
      element: element.props.element,
      Component: element.props.Component,
      index: element.props.index,
      path: element.props.path,
      loader: element.props.loader,
      action: element.props.action,
      errorElement: element.props.errorElement,
      ErrorBoundary: element.props.ErrorBoundary,
      hasErrorBoundary: element.props.ErrorBoundary != null || element.props.errorElement != null,
      shouldRevalidate: element.props.shouldRevalidate,
      handle: element.props.handle,
      lazy: element.props.lazy
    };
    if (element.props.children) {
      route.children = createRoutesFromChildren(element.props.children, treePath);
    }
    routes.push(route);
  });
  return routes;
}

/**
 * Renders the result of `matchRoutes()` into a React element.
 */
function renderMatches(matches) {
  return _renderMatches(matches);
}

function mapRouteProperties(route) {
  let updates = {
    // Note: this check also occurs in createRoutesFromChildren so update
    // there if you change this -- please and thank you!
    hasErrorBoundary: route.ErrorBoundary != null || route.errorElement != null
  };
  if (route.Component) {
    if (true) {
      if (route.element) {
         true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_warning)(false, "You should not include both `Component` and `element` on your route - " + "`Component` will be used.") : 0;
      }
    }
    Object.assign(updates, {
      element: /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(route.Component),
      Component: undefined
    });
  }
  if (route.HydrateFallback) {
    if (true) {
      if (route.hydrateFallbackElement) {
         true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_warning)(false, "You should not include both `HydrateFallback` and `hydrateFallbackElement` on your route - " + "`HydrateFallback` will be used.") : 0;
      }
    }
    Object.assign(updates, {
      hydrateFallbackElement: /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(route.HydrateFallback),
      HydrateFallback: undefined
    });
  }
  if (route.ErrorBoundary) {
    if (true) {
      if (route.errorElement) {
         true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_warning)(false, "You should not include both `ErrorBoundary` and `errorElement` on your route - " + "`ErrorBoundary` will be used.") : 0;
      }
    }
    Object.assign(updates, {
      errorElement: /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(route.ErrorBoundary),
      ErrorBoundary: undefined
    });
  }
  return updates;
}
function createMemoryRouter(routes, opts) {
  return (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.createRouter)({
    basename: opts == null ? void 0 : opts.basename,
    future: _extends({}, opts == null ? void 0 : opts.future, {
      v7_prependBasename: true
    }),
    history: (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.createMemoryHistory)({
      initialEntries: opts == null ? void 0 : opts.initialEntries,
      initialIndex: opts == null ? void 0 : opts.initialIndex
    }),
    hydrationData: opts == null ? void 0 : opts.hydrationData,
    routes,
    mapRouteProperties,
    dataStrategy: opts == null ? void 0 : opts.dataStrategy,
    patchRoutesOnNavigation: opts == null ? void 0 : opts.patchRoutesOnNavigation
  }).initialize();
}


//# sourceMappingURL=index.js.map


/***/ },

/***/ "./src/assets/img/GDPR.jpg"
/*!*********************************!*\
  !*** ./src/assets/img/GDPR.jpg ***!
  \*********************************/
(module, __unused_webpack_exports, __webpack_require__) {

module.exports = __webpack_require__.p + "images/GDPR.fa380937.jpg";

/***/ },

/***/ "./src/assets/img/SEO.jpg"
/*!********************************!*\
  !*** ./src/assets/img/SEO.jpg ***!
  \********************************/
(module, __unused_webpack_exports, __webpack_require__) {

module.exports = __webpack_require__.p + "images/SEO.207b545e.jpg";

/***/ },

/***/ "./src/assets/img/customFonts.jpg"
/*!****************************************!*\
  !*** ./src/assets/img/customFonts.jpg ***!
  \****************************************/
(module, __unused_webpack_exports, __webpack_require__) {

module.exports = __webpack_require__.p + "images/customFonts.d533276c.jpg";

/***/ },

/***/ "./src/assets/img/freevspro.webp"
/*!***************************************!*\
  !*** ./src/assets/img/freevspro.webp ***!
  \***************************************/
(module, __unused_webpack_exports, __webpack_require__) {

module.exports = __webpack_require__.p + "images/freevspro.843ba7e8.webp";

/***/ },

/***/ "./src/assets/img/logo.png"
/*!*********************************!*\
  !*** ./src/assets/img/logo.png ***!
  \*********************************/
(module, __unused_webpack_exports, __webpack_require__) {

module.exports = __webpack_require__.p + "images/logo.4aa79a21.png";

/***/ },

/***/ "./src/assets/img/pluginsSetup.jpg"
/*!*****************************************!*\
  !*** ./src/assets/img/pluginsSetup.jpg ***!
  \*****************************************/
(module, __unused_webpack_exports, __webpack_require__) {

module.exports = __webpack_require__.p + "images/pluginsSetup.80801bfc.jpg";

/***/ },

/***/ "./src/assets/img/recipe-courses.jpg"
/*!*******************************************!*\
  !*** ./src/assets/img/recipe-courses.jpg ***!
  \*******************************************/
(module, __unused_webpack_exports, __webpack_require__) {

module.exports = __webpack_require__.p + "images/recipe-courses.3f5c77d0.jpg";

/***/ },

/***/ "./src/assets/img/recipe-featured.jpg"
/*!********************************************!*\
  !*** ./src/assets/img/recipe-featured.jpg ***!
  \********************************************/
(module, __unused_webpack_exports, __webpack_require__) {

module.exports = __webpack_require__.p + "images/recipe-featured.675ce4d3.jpg";

/***/ },

/***/ "./src/assets/img/salesFunnel.jpg"
/*!****************************************!*\
  !*** ./src/assets/img/salesFunnel.jpg ***!
  \****************************************/
(module, __unused_webpack_exports, __webpack_require__) {

module.exports = __webpack_require__.p + "images/salesFunnel.8041c135.jpg";

/***/ },

/***/ "./src/assets/img/single-recipe.jpg"
/*!******************************************!*\
  !*** ./src/assets/img/single-recipe.jpg ***!
  \******************************************/
(module, __unused_webpack_exports, __webpack_require__) {

module.exports = __webpack_require__.p + "images/single-recipe.b70eb23a.jpg";

/***/ },

/***/ "./src/assets/img/themeClub.jpg"
/*!**************************************!*\
  !*** ./src/assets/img/themeClub.jpg ***!
  \**************************************/
(module, __unused_webpack_exports, __webpack_require__) {

module.exports = __webpack_require__.p + "images/themeClub.9bc864a9.jpg";

/***/ },

/***/ "./src/assets/img/themeInstallation.jpg"
/*!**********************************************!*\
  !*** ./src/assets/img/themeInstallation.jpg ***!
  \**********************************************/
(module, __unused_webpack_exports, __webpack_require__) {

module.exports = __webpack_require__.p + "images/themeInstallation.1e7ee4c3.jpg";

/***/ },

/***/ "./src/assets/img/vipSiteCare.jpg"
/*!****************************************!*\
  !*** ./src/assets/img/vipSiteCare.jpg ***!
  \****************************************/
(module, __unused_webpack_exports, __webpack_require__) {

module.exports = __webpack_require__.p + "images/vipSiteCare.a1588249.jpg";

/***/ },

/***/ "./src/assets/img/vipSupport.jpg"
/*!***************************************!*\
  !*** ./src/assets/img/vipSupport.jpg ***!
  \***************************************/
(module, __unused_webpack_exports, __webpack_require__) {

module.exports = __webpack_require__.p + "images/vipSupport.840a717c.jpg";

/***/ },

/***/ "./src/components/Card/index.jsx"
/*!***************************************!*\
  !*** ./src/components/Card/index.jsx ***!
  \***************************************/
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! .. */ "./src/components/index.js");


function Card({
  cardList,
  cardPlace,
  cardCol
}) {
  const cardListing = card => {
    return card.map((carditem, index) => {
      return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "cw-cardbody",
        key: index
      }, carditem.iconSvg || carditem.imageurl && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "cw-icon"
      }, carditem.iconSvg && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
        className: "cw-icon-svg"
      }, carditem.iconSvg), carditem.imageurl && (cardPlace === 'starter' ? (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
        target: "_blank",
        href: carditem.buttonUrl,
        className: "starter"
      }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("img", {
        src: carditem.imageurl,
        className: "cw-img"
      })) : (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("img", {
        src: carditem.imageurl,
        className: "cw-img"
      }))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "cw-text-wrap"
      }, carditem.heading && (cardPlace === 'starter' ? (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
        href: carditem.buttonUrl,
        className: "starter"
      }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("h3", {
        className: "cw-heading"
      }, carditem.heading)) : (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("h3", {
        className: "cw-heading"
      }, carditem.heading)), carditem.para && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
        className: "cw-text"
      }, carditem.para), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "cw-button"
      }, carditem.buttonUrl && carditem.buttonText && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
        target: "_blank",
        href: carditem.buttonUrl,
        className: "cw-btn"
      }, carditem.buttonText, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(___WEBPACK_IMPORTED_MODULE_1__.Icon, {
        icon: "arrow"
      }))), cardPlace === 'starter' && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "cw-icon-two"
      }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
        target: "_blank",
        href: carditem.buttonUrl,
        className: "icon"
      }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(___WEBPACK_IMPORTED_MODULE_1__.Icon, {
        icon: "preview"
      })))), cardPlace === 'cw-pro' && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "cw-icon-two"
      }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "icon"
      }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(___WEBPACK_IMPORTED_MODULE_1__.Icon, {
        icon: "lock"
      }))));
    });
  };
  const classes = `cw-card ${cardPlace} ${cardCol}`;
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: classes
  }, cardListing(cardList)));
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Card);

/***/ },

/***/ "./src/components/Heading/index.jsx"
/*!******************************************!*\
  !*** ./src/components/Heading/index.jsx ***!
  \******************************************/
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Heading)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! .. */ "./src/components/index.js");


function Heading({
  heading,
  buttonText,
  buttonUrl,
  openInNewTab
}) {
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "cw-settings"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("h2", null, heading), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "cw-button"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
    href: buttonUrl,
    className: "cw-btn",
    target: openInNewTab ? "_blank" : "_self"
  }, buttonText, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(___WEBPACK_IMPORTED_MODULE_1__.Icon, {
    icon: "arrow"
  }))));
}

/***/ },

/***/ "./src/components/Icon/index.jsx"
/*!***************************************!*\
  !*** ./src/components/Icon/index.jsx ***!
  \***************************************/
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);

const icons = {
  globe: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "20",
    height: "20",
    viewBox: "0 0 20 20",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("g", {
    clipPath: "url(#clip0_2386_336)"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M10 1.6665C12.0844 3.94846 13.269 6.90987 13.3333 9.99984C13.269 13.0898 12.0844 16.0512 10 18.3332M10 1.6665C7.9156 3.94846 6.73104 6.90987 6.66667 9.99984C6.73104 13.0898 7.9156 16.0512 10 18.3332M10 1.6665C5.39763 1.6665 1.66667 5.39746 1.66667 9.99984C1.66667 14.6022 5.39763 18.3332 10 18.3332M10 1.6665C14.6024 1.6665 18.3333 5.39746 18.3333 9.99984C18.3333 14.6022 14.6024 18.3332 10 18.3332M2.08335 7.49984H17.9167M2.08334 12.4998H17.9167",
    stroke: "currentColor",
    strokeWidth: "1.67",
    stroklinecap: "round",
    strokeLinejoin: "round"
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("defs", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("clipPath", {
    id: "clip0_2386_336"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    width: "20",
    height: "20"
  })))),
  site: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "33",
    height: "32",
    viewBox: "0 0 33 32",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    x: "0.666687",
    width: "32",
    height: "32",
    rx: "8",
    fill: "url(#paint0_linear_2353_1212)"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M9.16669 13.5H24.1667M14.1667 13.5L14.1667 23.5M13.1667 8.5H20.1667C21.5668 8.5 22.2669 8.5 22.8017 8.77248C23.2721 9.01217 23.6545 9.39462 23.8942 9.86502C24.1667 10.3998 24.1667 11.0999 24.1667 12.5V19.5C24.1667 20.9001 24.1667 21.6002 23.8942 22.135C23.6545 22.6054 23.2721 22.9878 22.8017 23.2275C22.2669 23.5 21.5668 23.5 20.1667 23.5H13.1667C11.7666 23.5 11.0665 23.5 10.5317 23.2275C10.0613 22.9878 9.67885 22.6054 9.43917 22.135C9.16669 21.6002 9.16669 20.9001 9.16669 19.5V12.5C9.16669 11.0999 9.16669 10.3998 9.43917 9.86502C9.67885 9.39462 10.0613 9.01217 10.5317 8.77248C11.0665 8.5 11.7666 8.5 13.1667 8.5Z",
    stroke: "white",
    strokeWidth: "1.67",
    stroklinecap: "round",
    strokeLinejoin: "round"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("defs", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("linearGradient", {
    id: "paint0_linear_2353_1212",
    x1: "3.00165",
    y1: "3.5",
    x2: "30.5016",
    y2: "30",
    gradientUnits: "userSpaceOnUse"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("stop", {
    stopColor: "#5081F5"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("stop", {
    offset: "1",
    stopColor: "#A769F5"
  })))),
  colorsetting: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "32",
    height: "32",
    viewBox: "0 0 32 32",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    width: "32",
    height: "32",
    rx: "8",
    fill: "url(#paint0_linear_2353_1220)"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("g", {
    clipPath: "url(#clip0_2353_1220)"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M7.66669 16C7.66669 20.6024 11.3976 24.3334 16 24.3334C17.3807 24.3334 18.5 23.2141 18.5 21.8334V21.4167C18.5 21.0297 18.5 20.8362 18.5214 20.6737C18.6691 19.5519 19.5519 18.6691 20.6737 18.5214C20.8362 18.5 21.0297 18.5 21.4167 18.5H21.8334C23.2141 18.5 24.3334 17.3807 24.3334 16C24.3334 11.3976 20.6024 7.66669 16 7.66669C11.3976 7.66669 7.66669 11.3976 7.66669 16Z",
    stroke: "white",
    strokeWidth: "1.67",
    stroklinecap: "round",
    strokeLinejoin: "round"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M11.8334 16.8334C12.2936 16.8334 12.6667 16.4603 12.6667 16C12.6667 15.5398 12.2936 15.1667 11.8334 15.1667C11.3731 15.1667 11 15.5398 11 16C11 16.4603 11.3731 16.8334 11.8334 16.8334Z",
    stroke: "white",
    strokeWidth: "1.67",
    stroklinecap: "round",
    strokeLinejoin: "round"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M19.3334 13.5C19.7936 13.5 20.1667 13.1269 20.1667 12.6667C20.1667 12.2064 19.7936 11.8334 19.3334 11.8334C18.8731 11.8334 18.5 12.2064 18.5 12.6667C18.5 13.1269 18.8731 13.5 19.3334 13.5Z",
    stroke: "white",
    strokeWidth: "1.67",
    stroklinecap: "round",
    strokeLinejoin: "round"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M14.3334 12.6667C14.7936 12.6667 15.1667 12.2936 15.1667 11.8334C15.1667 11.3731 14.7936 11 14.3334 11C13.8731 11 13.5 11.3731 13.5 11.8334C13.5 12.2936 13.8731 12.6667 14.3334 12.6667Z",
    stroke: "white",
    strokeWidth: "1.67",
    stroklinecap: "round",
    strokeLinejoin: "round"
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("defs", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("linearGradient", {
    id: "paint0_linear_2353_1220",
    x1: "2.33496",
    y1: "3.5",
    x2: "29.835",
    y2: "30",
    gradientUnits: "userSpaceOnUse"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("stop", {
    stopColor: "#F5B841"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("stop", {
    offset: "1",
    stopColor: "#FF7830"
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("clipPath", {
    id: "clip0_2353_1220"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    width: "20",
    height: "20",
    fill: "white",
    transform: "translate(6 6)"
  })))),
  typographysetting: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "33",
    height: "32",
    viewBox: "0 0 33 32",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    x: "0.333374",
    width: "32",
    height: "32",
    rx: "8",
    fill: "url(#paint0_linear_2353_1228)"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M9.66669 11.8333C9.66669 11.0567 9.66669 10.6685 9.79355 10.3622C9.96271 9.95379 10.2872 9.62934 10.6955 9.46018C11.0018 9.33331 11.3901 9.33331 12.1667 9.33331H20.5C21.2766 9.33331 21.6649 9.33331 21.9712 9.46018C22.3795 9.62934 22.704 9.95379 22.8732 10.3622C23 10.6685 23 11.0567 23 11.8333M13 22.6666H19.6667M14.875 9.33331V22.6666M17.7917 9.33331V22.6666",
    stroke: "white",
    strokeWidth: "1.67",
    stroklinecap: "round",
    strokeLinejoin: "round"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("defs", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("linearGradient", {
    id: "paint0_linear_2353_1228",
    x1: "2.66833",
    y1: "3.5",
    x2: "30.1683",
    y2: "30",
    gradientUnits: "userSpaceOnUse"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("stop", {
    stopColor: "#FF0D76"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("stop", {
    offset: "1",
    stopColor: "#590FB7"
  })))),
  layoutsetting: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "33",
    height: "32",
    viewBox: "0 0 33 32",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    x: "0.666687",
    width: "32",
    height: "32",
    rx: "8",
    fill: "url(#paint0_linear_2353_1237)"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M21.25 15.1667H17.0834M21.25 18.5H17.0834M21.25 11.8333H17.0834M14.1667 8.5L14.1667 23.5M13.1667 8.5H20.1667C21.5668 8.5 22.2669 8.5 22.8017 8.77248C23.2721 9.01217 23.6545 9.39462 23.8942 9.86502C24.1667 10.3998 24.1667 11.0999 24.1667 12.5V19.5C24.1667 20.9001 24.1667 21.6002 23.8942 22.135C23.6545 22.6054 23.2721 22.9878 22.8017 23.2275C22.2669 23.5 21.5668 23.5 20.1667 23.5H13.1667C11.7666 23.5 11.0665 23.5 10.5317 23.2275C10.0613 22.9878 9.67885 22.6054 9.43917 22.135C9.16669 21.6002 9.16669 20.9001 9.16669 19.5V12.5C9.16669 11.0999 9.16669 10.3998 9.43917 9.86502C9.67885 9.39462 10.0613 9.01217 10.5317 8.77248C11.0665 8.5 11.7666 8.5 13.1667 8.5Z",
    stroke: "white",
    strokeWidth: "1.67",
    stroklinecap: "round",
    strokeLinejoin: "round"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("defs", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("linearGradient", {
    id: "paint0_linear_2353_1237",
    x1: "3.00165",
    y1: "3.5",
    x2: "30.5016",
    y2: "30",
    gradientUnits: "userSpaceOnUse"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("stop", {
    stopColor: "#F40076"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("stop", {
    offset: "1",
    stopColor: "#DF98FA"
  })))),
  frontpagesetting: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "32",
    height: "32",
    viewBox: "0 0 32 32",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    width: "32",
    height: "32",
    rx: "8",
    fill: "url(#paint0_linear_2353_1245)"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M24.3334 13.5H7.66669M17.6667 20.5833L19.75 18.5L17.6667 16.4167M14.3334 16.4167L12.25 18.5L14.3334 20.5833M7.66669 12.5L7.66669 19.5C7.66669 20.9001 7.66669 21.6002 7.93917 22.135C8.17885 22.6054 8.56131 22.9878 9.03171 23.2275C9.56649 23.5 10.2666 23.5 11.6667 23.5H20.3334C21.7335 23.5 22.4336 23.5 22.9683 23.2275C23.4387 22.9878 23.8212 22.6054 24.0609 22.135C24.3334 21.6002 24.3334 20.9001 24.3334 19.5V12.5C24.3334 11.0999 24.3334 10.3998 24.0609 9.86502C23.8212 9.39462 23.4387 9.01217 22.9683 8.77248C22.4336 8.5 21.7335 8.5 20.3334 8.5L11.6667 8.5C10.2666 8.5 9.56649 8.5 9.03171 8.77248C8.56131 9.01217 8.17885 9.39462 7.93917 9.86502C7.66669 10.3998 7.66669 11.0999 7.66669 12.5Z",
    stroke: "white",
    strokeWidth: "1.67",
    stroklinecap: "round",
    strokeLinejoin: "round"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("defs", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("linearGradient", {
    id: "paint0_linear_2353_1245",
    x1: "2.33496",
    y1: "3.5",
    x2: "29.835",
    y2: "30",
    gradientUnits: "userSpaceOnUse"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("stop", {
    stopColor: "#AFD759"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("stop", {
    offset: "1",
    stopColor: "#00B3CC"
  })))),
  generalsetting: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "33",
    height: "32",
    viewBox: "0 0 33 32",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    x: "0.333374",
    width: "32",
    height: "32",
    rx: "8",
    fill: "url(#paint0_linear_2353_1253)"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M14.1626 22.1426L14.6497 23.2379C14.7944 23.564 15.0307 23.841 15.3298 24.0355C15.629 24.2299 15.9781 24.3334 16.3348 24.3333C16.6916 24.3334 17.0407 24.2299 17.3398 24.0355C17.639 23.841 17.8752 23.564 18.02 23.2379L18.5071 22.1426C18.6804 21.7539 18.9721 21.4298 19.3404 21.2166C19.711 21.0028 20.1398 20.9117 20.5654 20.9564L21.7571 21.0833C22.1118 21.1208 22.4698 21.0546 22.7876 20.8927C23.1055 20.7308 23.3695 20.4802 23.5478 20.1713C23.7263 19.8625 23.8113 19.5085 23.7926 19.1524C23.7738 18.7962 23.6521 18.4531 23.4422 18.1648L22.7367 17.1953C22.4855 16.8476 22.3512 16.429 22.3534 16C22.3533 15.5721 22.4888 15.1553 22.7404 14.8092L23.4459 13.8398C23.6558 13.5514 23.7775 13.2084 23.7963 12.8522C23.815 12.496 23.73 12.1421 23.5515 11.8333C23.3733 11.5243 23.1092 11.2737 22.7913 11.1118C22.4735 10.9499 22.1155 10.8837 21.7608 10.9213L20.5691 11.0481C20.1435 11.0928 19.7148 11.0017 19.3441 10.7879C18.975 10.5735 18.6833 10.2478 18.5108 9.85737L18.02 8.762C17.8752 8.43594 17.639 8.15889 17.3398 7.96446C17.0407 7.77003 16.6916 7.66657 16.3348 7.66663C15.9781 7.66657 15.629 7.77003 15.3298 7.96446C15.0307 8.15889 14.7944 8.43594 14.6497 8.762L14.1626 9.85737C13.9901 10.2478 13.6983 10.5735 13.3293 10.7879C12.9586 11.0017 12.5298 11.0928 12.1043 11.0481L10.9089 10.9213C10.5542 10.8837 10.1962 10.9499 9.87834 11.1118C9.56049 11.2737 9.29643 11.5243 9.11817 11.8333C8.93969 12.1421 8.85466 12.496 8.87339 12.8522C8.89213 13.2084 9.01383 13.5514 9.22373 13.8398L9.92928 14.8092C10.1809 15.1553 10.3164 15.5721 10.3163 16C10.3164 16.4278 10.1809 16.8447 9.92928 17.1907L9.22373 18.1601C9.01383 18.4485 8.89213 18.7916 8.87339 19.1477C8.85466 19.5039 8.93969 19.8578 9.11817 20.1666C9.2966 20.4754 9.5607 20.7259 9.8785 20.8878C10.1963 21.0496 10.5542 21.1159 10.9089 21.0787L12.1006 20.9518C12.5261 20.9071 12.9549 20.9982 13.3256 21.212C13.696 21.4258 13.9891 21.7516 14.1626 22.1426Z",
    stroke: "white",
    strokeWidth: "1.67",
    stroklinecap: "round",
    strokeLinejoin: "round"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M16.3333 18.5C17.7141 18.5 18.8333 17.3807 18.8333 16C18.8333 14.6192 17.7141 13.5 16.3333 13.5C14.9526 13.5 13.8333 14.6192 13.8333 16C13.8333 17.3807 14.9526 18.5 16.3333 18.5Z",
    stroke: "white",
    strokeWidth: "1.67",
    stroklinecap: "round",
    strokeLinejoin: "round"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("defs", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("linearGradient", {
    id: "paint0_linear_2353_1253",
    x1: "2.66833",
    y1: "3.5",
    x2: "30.1683",
    y2: "30",
    gradientUnits: "userSpaceOnUse"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("stop", {
    stopColor: "#ED7B84"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("stop", {
    offset: "1",
    stopColor: "#9055FF"
  })))),
  instagramsetting: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "33",
    height: "32",
    viewBox: "0 0 33 32",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    x: "0.666687",
    width: "32",
    height: "32",
    rx: "8",
    fill: "url(#paint0_linear_2353_1262)"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M13.1667 7.66663H20.1667C22.8334 7.66663 25 9.83329 25 12.5V19.5C25 20.7818 24.4908 22.0112 23.5844 22.9176C22.678 23.8241 21.4486 24.3333 20.1667 24.3333H13.1667C10.5 24.3333 8.33337 22.1666 8.33337 19.5V12.5C8.33337 11.2181 8.8426 9.9887 9.74902 9.08228C10.6555 8.17585 11.8848 7.66663 13.1667 7.66663ZM13 9.33329C12.2044 9.33329 11.4413 9.64936 10.8787 10.212C10.3161 10.7746 10 11.5376 10 12.3333V19.6666C10 21.325 11.3417 22.6666 13 22.6666H20.3334C21.129 22.6666 21.8921 22.3506 22.4547 21.7879C23.0173 21.2253 23.3334 20.4623 23.3334 19.6666V12.3333C23.3334 10.675 21.9917 9.33329 20.3334 9.33329H13ZM21.0417 10.5833C21.318 10.5833 21.5829 10.693 21.7783 10.8884C21.9736 11.0837 22.0834 11.3487 22.0834 11.625C22.0834 11.9012 21.9736 12.1662 21.7783 12.3615C21.5829 12.5569 21.318 12.6666 21.0417 12.6666C20.7654 12.6666 20.5005 12.5569 20.3051 12.3615C20.1098 12.1662 20 11.9012 20 11.625C20 11.3487 20.1098 11.0837 20.3051 10.8884C20.5005 10.693 20.7654 10.5833 21.0417 10.5833ZM16.6667 11.8333C17.7718 11.8333 18.8316 12.2723 19.613 13.0537C20.3944 13.8351 20.8334 14.8949 20.8334 16C20.8334 17.105 20.3944 18.1648 19.613 18.9462C18.8316 19.7276 17.7718 20.1666 16.6667 20.1666C15.5616 20.1666 14.5018 19.7276 13.7204 18.9462C12.939 18.1648 12.5 17.105 12.5 16C12.5 14.8949 12.939 13.8351 13.7204 13.0537C14.5018 12.2723 15.5616 11.8333 16.6667 11.8333ZM16.6667 13.5C16.0037 13.5 15.3678 13.7634 14.8989 14.2322C14.4301 14.701 14.1667 15.3369 14.1667 16C14.1667 16.663 14.4301 17.2989 14.8989 17.7677C15.3678 18.2366 16.0037 18.5 16.6667 18.5C17.3297 18.5 17.9656 18.2366 18.4345 17.7677C18.9033 17.2989 19.1667 16.663 19.1667 16C19.1667 15.3369 18.9033 14.701 18.4345 14.2322C17.9656 13.7634 17.3297 13.5 16.6667 13.5Z",
    fill: "white"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("defs", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("linearGradient", {
    id: "paint0_linear_2353_1262",
    x1: "3.00165",
    y1: "3.5",
    x2: "30.5016",
    y2: "30",
    gradientUnits: "userSpaceOnUse"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("stop", {
    stopColor: "#E233FF"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("stop", {
    offset: "1",
    stopColor: "#FF6B00"
  })))),
  socialmedia: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "32",
    height: "32",
    viewBox: "0 0 32 32",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    width: "32",
    height: "32",
    rx: "8",
    fill: "url(#paint0_linear_2353_1270)"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M13.1583 17.2583L18.85 20.575M18.8417 11.425L13.1583 14.7416M23.5 10.1666C23.5 11.5473 22.3807 12.6666 21 12.6666C19.6193 12.6666 18.5 11.5473 18.5 10.1666C18.5 8.78591 19.6193 7.66663 21 7.66663C22.3807 7.66663 23.5 8.78591 23.5 10.1666ZM13.5 16C13.5 17.3807 12.3807 18.5 11 18.5C9.61929 18.5 8.5 17.3807 8.5 16C8.5 14.6192 9.61929 13.5 11 13.5C12.3807 13.5 13.5 14.6192 13.5 16ZM23.5 21.8333C23.5 23.214 22.3807 24.3333 21 24.3333C19.6193 24.3333 18.5 23.214 18.5 21.8333C18.5 20.4526 19.6193 19.3333 21 19.3333C22.3807 19.3333 23.5 20.4526 23.5 21.8333Z",
    stroke: "white",
    strokeWidth: "1.67",
    stroklinecap: "round",
    strokeLinejoin: "round"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("defs", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("linearGradient", {
    id: "paint0_linear_2353_1270",
    x1: "2.33496",
    y1: "3.5",
    x2: "29.835",
    y2: "30",
    gradientUnits: "userSpaceOnUse"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("stop", {
    stopColor: "#2F80ED"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("stop", {
    offset: "1",
    stopColor: "#B2FFDA"
  })))),
  footersetting: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "33",
    height: "32",
    viewBox: "0 0 33 32",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    x: "0.333374",
    width: "32",
    height: "32",
    rx: "8",
    fill: "url(#paint0_linear_2353_1278)"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M8.83337 8.5H8.84171M8.83337 16H8.84171M8.83337 19.75H8.84171M8.83337 12.25H8.84171M12.5834 8.5H12.5917M12.5834 16H12.5917M20.0834 8.5H20.0917M20.0834 16H20.0917M16.3334 8.5H16.3417M16.3334 16H16.3417M16.3334 19.75H16.3417M16.3334 12.25H16.3417M23.8334 8.5H23.8417M23.8334 16H23.8417M23.8334 19.75H23.8417M23.8334 12.25H23.8417M23.8334 23.5H8.83337",
    stroke: "white",
    strokeWidth: "1.67",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("defs", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("linearGradient", {
    id: "paint0_linear_2353_1278",
    x1: "2.66833",
    y1: "3.5",
    x2: "30.1683",
    y2: "30",
    gradientUnits: "userSpaceOnUse"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("stop", {
    stopColor: "#DF98FA"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("stop", {
    offset: "1",
    stopColor: "#9055FF"
  })))),
  home: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "20",
    height: "20",
    viewBox: "0 0 20 20",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M2.5 8.80433C2.5 8.3257 2.5 8.08639 2.56169 7.866C2.61633 7.67078 2.70614 7.48716 2.82669 7.32417C2.96278 7.14017 3.15168 6.99324 3.52949 6.69939L9.18141 2.30345C9.47418 2.07574 9.62057 1.96189 9.78221 1.91812C9.92484 1.87951 10.0752 1.87951 10.2178 1.91812C10.3794 1.96189 10.5258 2.07574 10.8186 2.30345L16.4705 6.69939C16.8483 6.99324 17.0372 7.14017 17.1733 7.32417C17.2939 7.48716 17.3837 7.67078 17.4383 7.866C17.5 8.08639 17.5 8.3257 17.5 8.80433V14.8334C17.5 15.7669 17.5 16.2336 17.3183 16.5901C17.1586 16.9037 16.9036 17.1587 16.59 17.3185C16.2335 17.5001 15.7668 17.5001 14.8333 17.5001H5.16667C4.23325 17.5001 3.76654 17.5001 3.41002 17.3185C3.09641 17.1587 2.84144 16.9037 2.68166 16.5901C2.5 16.2336 2.5 15.7669 2.5 14.8334V8.80433Z",
    stroke: "currentColor",
    strokeWidth: "1.67",
    stroklinecap: "round",
    strokeLinejoin: "round"
  })),
  freePro: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "20",
    height: "20",
    viewBox: "0 0 20 20",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("g", {
    clipPath: "url(#clip0_2386_343)"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M10 1.6665L13 4.6665C15 -0.583496 20.5833 4.99984 15.3333 6.99984L18.3333 9.99984L15.3333 12.9998C13.3333 7.74984 7.75001 13.3332 13 15.3332L10 18.3332L7 15.3332C5 20.5832 -0.583328 14.9998 4.66667 12.9998L1.66667 9.99984L4.66667 6.99984C6.66667 12.2498 12.25 6.6665 7 4.6665L10 1.6665Z",
    stroke: "currentColor",
    strokeWidth: "1.67",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("defs", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("clipPath", {
    id: "clip0_2386_343"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    width: "20",
    height: "20",
    fill: "none"
  })))),
  offers: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "20",
    height: "20",
    viewBox: "0 0 20 20",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M6.66667 6.6665H6.67501M1.66667 4.33317L1.66667 8.06193C1.66667 8.46958 1.66667 8.67341 1.71272 8.86522C1.75355 9.03528 1.82089 9.19786 1.91227 9.34698C2.01534 9.51517 2.15947 9.6593 2.44772 9.94755L8.83824 16.3381C9.82829 17.3281 10.3233 17.8231 10.8941 18.0086C11.3962 18.1718 11.9371 18.1718 12.4392 18.0086C13.01 17.8231 13.5051 17.3281 14.4951 16.3381L16.3382 14.4949C17.3283 13.5049 17.8233 13.0099 18.0088 12.439C18.1719 11.9369 18.1719 11.3961 18.0088 10.894C17.8233 10.3231 17.3283 9.82812 16.3382 8.83808L9.94772 2.44755C9.65947 2.1593 9.51534 2.01517 9.34715 1.9121C9.19802 1.82072 9.03545 1.75338 8.86539 1.71255C8.67358 1.6665 8.46975 1.6665 8.0621 1.6665L4.33334 1.6665C3.39992 1.6665 2.93321 1.6665 2.57669 1.84816C2.26308 2.00795 2.00812 2.26292 1.84833 2.57652C1.66667 2.93304 1.66667 3.39975 1.66667 4.33317ZM7.08334 6.6665C7.08334 6.89662 6.89679 7.08317 6.66667 7.08317C6.43655 7.08317 6.25001 6.89662 6.25001 6.6665C6.25001 6.43639 6.43655 6.24984 6.66667 6.24984C6.89679 6.24984 7.08334 6.43639 7.08334 6.6665Z",
    stroke: "currentColor",
    strokeWidth: "1.67",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  })),
  plugins: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "20",
    height: "20",
    viewBox: "0 0 20 20",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M18.7883 4.96168C18.7012 4.87428 18.5977 4.80494 18.4837 4.75762C18.3698 4.7103 18.2476 4.68595 18.1242 4.68595C18.0008 4.68595 17.8787 4.7103 17.7647 4.75762C17.6508 4.80494 17.5473 4.87428 17.4602 4.96168L15 7.42184L12.5781 4.99997L15.0406 2.53825C15.2168 2.36213 15.3157 2.12326 15.3157 1.87418C15.3157 1.62511 15.2168 1.38624 15.0406 1.21012C14.8645 1.034 14.6256 0.935059 14.3766 0.935059C14.1275 0.935059 13.8886 1.034 13.7125 1.21012L11.25 3.67184L9.41329 1.83668C9.32608 1.74948 9.22255 1.6803 9.10861 1.63311C8.99467 1.58591 8.87255 1.56162 8.74922 1.56162C8.50015 1.56162 8.26128 1.66056 8.08516 1.83668C7.90904 2.01281 7.8101 2.25168 7.8101 2.50075C7.8101 2.74982 7.90904 2.98869 8.08516 3.16481L8.35938 3.43747L4.44454 7.35465C4.12528 7.67386 3.87203 8.05283 3.69925 8.46992C3.52647 8.88701 3.43754 9.33405 3.43754 9.78551C3.43754 10.237 3.52647 10.684 3.69925 11.1011C3.87203 11.5182 4.12528 11.8972 4.44454 12.2164L5.45079 13.2226L1.83672 16.8367C1.74952 16.9239 1.68034 17.0274 1.63315 17.1414C1.58595 17.2553 1.56166 17.3774 1.56166 17.5007C1.56166 17.6241 1.58595 17.7462 1.63315 17.8601C1.68034 17.9741 1.74952 18.0776 1.83672 18.1648C2.01284 18.3409 2.25172 18.4399 2.50079 18.4399C2.62411 18.4399 2.74624 18.4156 2.86018 18.3684C2.97412 18.3212 3.07764 18.252 3.16485 18.1648L6.77891 14.5507L7.78516 15.557C8.10437 15.8763 8.48334 16.1295 8.90043 16.3023C9.31752 16.4751 9.76456 16.564 10.216 16.564C10.6675 16.564 11.1145 16.4751 11.5316 16.3023C11.9487 16.1295 12.3277 15.8763 12.6469 15.557L16.5625 11.6406L16.8367 11.9156C16.9239 12.0028 17.0275 12.072 17.1414 12.1192C17.2553 12.1664 17.3775 12.1907 17.5008 12.1907C17.6241 12.1907 17.7462 12.1664 17.8602 12.1192C17.9741 12.072 18.0776 12.0028 18.1648 11.9156C18.2521 11.8284 18.3212 11.7249 18.3684 11.6109C18.4156 11.497 18.4399 11.3749 18.4399 11.2515C18.4399 11.1282 18.4156 11.0061 18.3684 10.8921C18.3212 10.7782 18.2521 10.6747 18.1648 10.5875L16.3281 8.74997L18.7906 6.28825C18.8776 6.20102 18.9466 6.09751 18.9936 5.98361C19.0406 5.86972 19.0646 5.74768 19.0644 5.62448C19.0642 5.50128 19.0397 5.37933 18.9923 5.2656C18.9449 5.15187 18.8756 5.0486 18.7883 4.96168ZM11.3195 14.2297C11.1744 14.3748 11.0022 14.49 10.8125 14.5685C10.6229 14.6471 10.4197 14.6875 10.2145 14.6875C10.0092 14.6875 9.80598 14.6471 9.61637 14.5685C9.42676 14.49 9.25448 14.3748 9.10938 14.2297L5.77032 10.8906C5.62516 10.7455 5.51001 10.5732 5.43145 10.3836C5.35288 10.194 5.31245 9.99076 5.31245 9.78551C5.31245 9.58027 5.35288 9.37704 5.43145 9.18742C5.51001 8.99781 5.62516 8.82553 5.77032 8.68043L9.68751 4.76559L15.2344 10.3125L11.3195 14.2297Z",
    fill: "currentColor"
  })),
  license: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "20",
    height: "20",
    viewBox: "0 0 20 20",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M5.41667 16.6665H4.16667C3.24619 16.6665 2.5 15.9203 2.5 14.9998V3.33317C2.5 2.4127 3.24619 1.6665 4.16667 1.6665H15.8333C16.7538 1.6665 17.5 2.4127 17.5 3.33317V14.9998C17.5 15.9203 16.7538 16.6665 15.8333 16.6665H14.5833M10 15.8332C11.3807 15.8332 12.5 14.7139 12.5 13.3332C12.5 11.9525 11.3807 10.8332 10 10.8332C8.61929 10.8332 7.5 11.9525 7.5 13.3332C7.5 14.7139 8.61929 15.8332 10 15.8332ZM10 15.8332L10.0179 15.833L7.35723 18.4936L5.0002 16.1366L7.51638 13.6204M10 15.8332L12.6607 18.4936L15.0177 16.1366L12.5015 13.6204M7.5 4.99984H12.5M5.83333 7.9165H14.1667",
    stroke: "currentColor",
    strokeWidth: "1.67",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  })),
  arrow: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "13",
    height: "10",
    viewBox: "0 0 13 10",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M1.16669 5H11.8334M11.8334 5L7.83335 1M11.8334 5L7.83335 9",
    stroke: "#6266EA",
    strokeWidth: "1.5",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  })),
  youtube: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "20",
    height: "20",
    viewBox: "0 0 20 20",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    fillRule: "evenodd",
    clipRule: "evenodd",
    d: "M9.99996 3.3335C10.7125 3.3335 11.4433 3.35183 12.1516 3.38183L12.9883 3.42183L13.7891 3.46933L14.5391 3.52016L15.2241 3.5735C15.9675 3.63039 16.667 3.94762 17.1996 4.46936C17.7321 4.99111 18.0636 5.68395 18.1358 6.426L18.1691 6.78016L18.2316 7.5385C18.29 8.32433 18.3333 9.181 18.3333 10.0002C18.3333 10.8193 18.29 11.676 18.2316 12.4618L18.1691 13.2202C18.1583 13.3418 18.1475 13.4593 18.1358 13.5743C18.0636 14.3165 17.732 15.0095 17.1992 15.5312C16.6665 16.053 15.9668 16.3701 15.2233 16.4268L14.54 16.4793L13.79 16.531L12.9883 16.5785L12.1516 16.6185C11.4348 16.6496 10.7174 16.6658 9.99996 16.6668C9.28248 16.6658 8.5651 16.6496 7.84829 16.6185L7.01163 16.5785L6.21079 16.531L5.46079 16.4793L4.77579 16.4268C4.03242 16.3699 3.33292 16.0527 2.80035 15.531C2.26779 15.0092 1.93627 14.3164 1.86413 13.5743L1.83079 13.2202L1.76829 12.4618C1.70457 11.6428 1.67066 10.8217 1.66663 10.0002C1.66663 9.181 1.70996 8.32433 1.76829 7.5385L1.83079 6.78016C1.84163 6.6585 1.85246 6.541 1.86413 6.426C1.93624 5.68408 2.26764 4.99134 2.80004 4.46962C3.33243 3.94789 4.03173 3.63058 4.77496 3.5735L5.45913 3.52016L6.20913 3.46933L7.01079 3.42183L7.84746 3.38183C8.56454 3.35069 9.2822 3.33458 9.99996 3.3335ZM8.33329 7.97933V12.021C8.33329 12.406 8.74996 12.646 9.08329 12.4543L12.5833 10.4335C12.6595 10.3897 12.7227 10.3265 12.7667 10.2504C12.8107 10.1744 12.8338 10.088 12.8338 10.0002C12.8338 9.91229 12.8107 9.82596 12.7667 9.74988C12.7227 9.67381 12.6595 9.61067 12.5833 9.56683L9.08329 7.54683C9.00726 7.50293 8.92101 7.47983 8.83321 7.47984C8.74542 7.47986 8.65917 7.50299 8.58315 7.54691C8.50713 7.59083 8.44402 7.654 8.40016 7.73005C8.3563 7.8061 8.33324 7.89237 8.33329 7.98016V7.97933Z",
    fill: "currentColor"
  })),
  support: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "20",
    height: "20",
    viewBox: "0 0 20 20",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M8.33333 6.66853C8.48016 6.25113 8.76998 5.89917 9.15144 5.67498C9.53291 5.45079 9.98141 5.36884 10.4175 5.44364C10.8536 5.51844 11.2492 5.74517 11.5341 6.08367C11.8191 6.42217 11.975 6.8506 11.9744 7.29306C11.9744 8.54213 10.1008 9.16667 10.1008 9.16667M10.1249 11.6667H10.1333M5.83333 15V16.9463C5.83333 17.3903 5.83333 17.6123 5.92436 17.7263C6.00352 17.8255 6.12356 17.8832 6.25045 17.8831C6.39636 17.8829 6.56973 17.7442 6.91646 17.4668L8.90434 15.8765C9.31043 15.5517 9.51347 15.3892 9.73957 15.2737C9.94017 15.1712 10.1537 15.0963 10.3743 15.051C10.6231 15 10.8831 15 11.4031 15H13.5C14.9001 15 15.6002 15 16.135 14.7275C16.6054 14.4878 16.9878 14.1054 17.2275 13.635C17.5 13.1002 17.5 12.4001 17.5 11V6.5C17.5 5.09987 17.5 4.3998 17.2275 3.86502C16.9878 3.39462 16.6054 3.01217 16.135 2.77248C15.6002 2.5 14.9001 2.5 13.5 2.5H6.5C5.09987 2.5 4.3998 2.5 3.86502 2.77248C3.39462 3.01217 3.01217 3.39462 2.77248 3.86502C2.5 4.3998 2.5 5.09987 2.5 6.5V11.6667C2.5 12.4416 2.5 12.8291 2.58519 13.147C2.81635 14.0098 3.49022 14.6836 4.35295 14.9148C4.67087 15 5.05836 15 5.83333 15Z",
    stroke: "currentColor",
    strokeWidth: "1.67",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  })),
  doc: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "20",
    height: "20",
    viewBox: "0 0 20 20",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    width: "20",
    height: "20",
    fill: "none"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M3.33337 1.6665H10.8334L16.6667 7.49984V18.3332H3.33337V1.6665Z",
    stroke: "currentColor",
    strokeWidth: "1.67",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M10.8334 1.6665V7.49984H16.6667",
    stroke: "currentColor",
    strokeWidth: "1.67",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M6.66663 11.6665H13.3333",
    stroke: "currentColor",
    strokeWidth: "1.67",
    strokeLinecap: "round"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M6.66663 15H9.99996",
    stroke: "currentColor",
    strokeWidth: "1.67",
    strokeLinecap: "round"
  })),
  lock: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "17",
    height: "21",
    viewBox: "0 0 17 21",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M2.82456 21C2.29061 21 1.83352 20.8042 1.45329 20.4125C1.07305 20.0208 0.882935 19.55 0.882935 19V9C0.882935 8.45 1.07305 7.97917 1.45329 7.5875C1.83352 7.19583 2.29061 7 2.82456 7H3.79538V5C3.79538 3.61667 4.26865 2.4375 5.21519 1.4625C6.16174 0.4875 7.30649 0 8.64945 0C9.99241 0 11.1372 0.4875 12.0837 1.4625C13.0302 2.4375 13.5035 3.61667 13.5035 5V7H14.4743C15.0083 7 15.4654 7.19583 15.8456 7.5875C16.2258 7.97917 16.416 8.45 16.416 9V19C16.416 19.55 16.2258 20.0208 15.8456 20.4125C15.4654 20.8042 15.0083 21 14.4743 21H2.82456ZM2.82456 19H14.4743V9H2.82456V19ZM8.64945 16C9.1834 16 9.64049 15.8042 10.0207 15.4125C10.401 15.0208 10.5911 14.55 10.5911 14C10.5911 13.45 10.401 12.9792 10.0207 12.5875C9.64049 12.1958 9.1834 12 8.64945 12C8.1155 12 7.65841 12.1958 7.27817 12.5875C6.89794 12.9792 6.70782 13.45 6.70782 14C6.70782 14.55 6.89794 15.0208 7.27817 15.4125C7.65841 15.8042 8.1155 16 8.64945 16ZM5.73701 7H11.5619V5C11.5619 4.16667 11.2787 3.45833 10.7124 2.875C10.1461 2.29167 9.45846 2 8.64945 2C7.84044 2 7.15278 2.29167 6.58647 2.875C6.02016 3.45833 5.73701 4.16667 5.73701 5V7Z",
    fill: "#D9D9D9"
  })),
  documentation: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "16",
    height: "20",
    viewBox: "0 0 16 20",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M9.66671 9.1665H4.66671M6.33337 12.4998H4.66671M11.3334 5.83317H4.66671M14.6667 5.6665V14.3332C14.6667 15.7333 14.6667 16.4334 14.3942 16.9681C14.1545 17.4385 13.7721 17.821 13.3017 18.0607C12.7669 18.3332 12.0668 18.3332 10.6667 18.3332H5.33337C3.93324 18.3332 3.23318 18.3332 2.6984 18.0607C2.22799 17.821 1.84554 17.4385 1.60586 16.9681C1.33337 16.4334 1.33337 15.7333 1.33337 14.3332V5.6665C1.33337 4.26637 1.33337 3.56631 1.60586 3.03153C1.84554 2.56112 2.22799 2.17867 2.6984 1.93899C3.23318 1.6665 3.93324 1.6665 5.33337 1.6665H10.6667C12.0668 1.6665 12.7669 1.6665 13.3017 1.93899C13.7721 2.17867 14.1545 2.56112 14.3942 3.03153C14.6667 3.56631 14.6667 4.26637 14.6667 5.6665Z",
    stroke: "currentColor",
    strokeWidth: "1.67",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  })),
  supportTwo: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "18",
    height: "14",
    viewBox: "0 0 18 14",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M8.99996 11.1668C9.23607 11.1668 9.43399 11.087 9.59371 10.9272C9.75343 10.7675 9.83329 10.5696 9.83329 10.3335C9.83329 10.0974 9.75343 9.89947 9.59371 9.73975C9.43399 9.58002 9.23607 9.50016 8.99996 9.50016C8.76385 9.50016 8.56593 9.58002 8.40621 9.73975C8.24649 9.89947 8.16662 10.0974 8.16662 10.3335C8.16662 10.5696 8.24649 10.7675 8.40621 10.9272C8.56593 11.087 8.76385 11.1668 8.99996 11.1668ZM8.99996 7.8335C9.23607 7.8335 9.43399 7.75363 9.59371 7.59391C9.75343 7.43419 9.83329 7.23627 9.83329 7.00016C9.83329 6.76405 9.75343 6.56613 9.59371 6.40641C9.43399 6.24669 9.23607 6.16683 8.99996 6.16683C8.76385 6.16683 8.56593 6.24669 8.40621 6.40641C8.24649 6.56613 8.16662 6.76405 8.16662 7.00016C8.16662 7.23627 8.24649 7.43419 8.40621 7.59391C8.56593 7.75363 8.76385 7.8335 8.99996 7.8335ZM8.99996 4.50016C9.23607 4.50016 9.43399 4.4203 9.59371 4.26058C9.75343 4.10086 9.83329 3.90294 9.83329 3.66683C9.83329 3.43072 9.75343 3.2328 9.59371 3.07308C9.43399 2.91336 9.23607 2.8335 8.99996 2.8335C8.76385 2.8335 8.56593 2.91336 8.40621 3.07308C8.24649 3.2328 8.16662 3.43072 8.16662 3.66683C8.16662 3.90294 8.24649 4.10086 8.40621 4.26058C8.56593 4.4203 8.76385 4.50016 8.99996 4.50016ZM15.6666 13.6668H2.33329C1.87496 13.6668 1.4826 13.5036 1.15621 13.1772C0.82982 12.8509 0.666626 12.4585 0.666626 12.0002V8.66683C1.12496 8.66683 1.51732 8.50363 1.84371 8.17725C2.1701 7.85086 2.33329 7.4585 2.33329 7.00016C2.33329 6.54183 2.1701 6.14947 1.84371 5.82308C1.51732 5.49669 1.12496 5.3335 0.666626 5.3335V2.00016C0.666626 1.54183 0.82982 1.14947 1.15621 0.823079C1.4826 0.496691 1.87496 0.333496 2.33329 0.333496H15.6666C16.125 0.333496 16.5173 0.496691 16.8437 0.823079C17.1701 1.14947 17.3333 1.54183 17.3333 2.00016V5.3335C16.875 5.3335 16.4826 5.49669 16.1562 5.82308C15.8298 6.14947 15.6666 6.54183 15.6666 7.00016C15.6666 7.4585 15.8298 7.85086 16.1562 8.17725C16.4826 8.50363 16.875 8.66683 17.3333 8.66683V12.0002C17.3333 12.4585 17.1701 12.8509 16.8437 13.1772C16.5173 13.5036 16.125 13.6668 15.6666 13.6668ZM15.6666 12.0002V9.87516C15.1527 9.56961 14.7465 9.16336 14.4479 8.65641C14.1493 8.14947 14 7.59738 14 7.00016C14 6.40294 14.1493 5.85086 14.4479 5.34391C14.7465 4.83697 15.1527 4.43072 15.6666 4.12516V2.00016H2.33329V4.12516C2.84718 4.43072 3.25343 4.83697 3.55204 5.34391C3.85065 5.85086 3.99996 6.40294 3.99996 7.00016C3.99996 7.59738 3.85065 8.14947 3.55204 8.65641C3.25343 9.16336 2.84718 9.56961 2.33329 9.87516V12.0002H15.6666Z",
    fill: "#F8478D"
  })),
  video: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "22",
    height: "22",
    viewBox: "0 0 22 22",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M11 21C16.5228 21 21 16.5228 21 11C21 5.47715 16.5228 1 11 1C5.47715 1 1 5.47715 1 11C1 16.5228 5.47715 21 11 21Z",
    stroke: "#F8478D",
    strokeWidth: "2",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M8.5 7.96533C8.5 7.48805 8.5 7.24941 8.59974 7.11618C8.68666 7.00007 8.81971 6.92744 8.96438 6.9171C9.13038 6.90525 9.33112 7.03429 9.73261 7.29239L14.4532 10.3271C14.8016 10.551 14.9758 10.663 15.0359 10.8054C15.0885 10.9298 15.0885 11.0702 15.0359 11.1946C14.9758 11.337 14.8016 11.449 14.4532 11.6729L9.73261 14.7076C9.33112 14.9657 9.13038 15.0948 8.96438 15.0829C8.81971 15.0726 8.68666 14.9999 8.59974 14.8838C8.5 14.7506 8.5 14.512 8.5 14.0347V7.96533Z",
    stroke: "#F8478D",
    strokeWidth: "2",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  })),
  arrowtwo: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "8",
    height: "12",
    viewBox: "0 0 8 12",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M1.5 11L6.5 6L1.5 1",
    stroke: "currentColor",
    strokeWidth: "1.67",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  })),
  preview: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "20",
    height: "14",
    viewBox: "0 0 20 14",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M2.01677 7.59415C1.90328 7.41445 1.84654 7.3246 1.81477 7.18602C1.79091 7.08192 1.79091 6.91775 1.81477 6.81366C1.84654 6.67507 1.90328 6.58522 2.01677 6.40552C2.95461 4.92054 5.74617 1.1665 10.0003 1.1665C14.2545 1.1665 17.0461 4.92054 17.9839 6.40552C18.0974 6.58522 18.1541 6.67507 18.1859 6.81366C18.2098 6.91775 18.2098 7.08192 18.1859 7.18602C18.1541 7.3246 18.0974 7.41445 17.9839 7.59415C17.0461 9.07914 14.2545 12.8332 10.0003 12.8332C5.74617 12.8332 2.95461 9.07914 2.01677 7.59415Z",
    stroke: "#F8478D",
    strokeWidth: "1.67",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M10.0003 9.49984C11.381 9.49984 12.5003 8.38055 12.5003 6.99984C12.5003 5.61913 11.381 4.49984 10.0003 4.49984C8.61962 4.49984 7.50034 5.61913 7.50034 6.99984C7.50034 8.38055 8.61962 9.49984 10.0003 9.49984Z",
    stroke: "#F8478D",
    strokeWidth: "1.67",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  })),
  hidePassowrd: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "20",
    height: "20",
    viewBox: "0 0 20 20",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M8.95245 4.2436C9.29113 4.19353 9.64051 4.16667 10.0003 4.16667C14.2545 4.16667 17.0461 7.9207 17.9839 9.40569C18.0974 9.58542 18.1542 9.67528 18.1859 9.81389C18.2098 9.91799 18.2098 10.0822 18.1859 10.1863C18.1541 10.3249 18.097 10.4154 17.9827 10.5963C17.7328 10.9918 17.3518 11.5476 16.8471 12.1504M5.6036 5.59586C3.80187 6.81808 2.57871 8.51615 2.01759 9.4044C1.90357 9.58489 1.84656 9.67514 1.81478 9.81373C1.79091 9.91783 1.7909 10.082 1.81476 10.1861C1.84652 10.3247 1.90328 10.4146 2.01678 10.5943C2.95462 12.0793 5.74618 15.8333 10.0003 15.8333C11.7157 15.8333 13.1932 15.223 14.4074 14.3972M2.50035 2.5L17.5003 17.5M8.23258 8.23223C7.78017 8.68464 7.50035 9.30964 7.50035 10C7.50035 11.3807 8.61964 12.5 10.0003 12.5C10.6907 12.5 11.3157 12.2202 11.7681 11.7678",
    stroke: "#5A5F61",
    strokeWidth: "1.67",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  })),
  minus: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "24",
    height: "24",
    viewBox: "0 0 24 24",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M8 12H16M22 12C22 17.5228 17.5228 22 12 22C6.47715 22 2 17.5228 2 12C2 6.47715 6.47715 2 12 2C17.5228 2 22 6.47715 22 12Z",
    stroke: "#98A2B3",
    strokeWidth: "2",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  })),
  plus: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "24",
    height: "24",
    viewBox: "0 0 24 24",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M12 8V16M8 12H16M22 12C22 17.5228 17.5228 22 12 22C6.47715 22 2 17.5228 2 12C2 6.47715 6.47715 2 12 2C17.5228 2 22 6.47715 22 12Z",
    stroke: "#98A2B3",
    strokeWidth: "2",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  })),
  pluginList: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "48",
    height: "48",
    viewBox: "0 0 48 48",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M10.6715 41.615C11.0288 41.2231 11.2158 40.7053 11.1914 40.1756C11.1671 39.6458 10.9333 39.1474 10.5415 38.79C7.15342 35.7059 4.92693 31.5521 4.23437 27.0232C3.54182 22.4943 4.42519 17.8649 6.73675 13.9092C9.04831 9.95354 12.6479 6.91143 16.9336 5.29163C21.2192 3.67182 25.9311 3.57254 30.2812 5.01037C34.6313 6.44821 38.3558 9.33599 40.832 13.1908C43.3081 17.0456 44.3857 21.6336 43.8845 26.1877C43.3834 30.7417 41.3338 34.9857 38.0787 38.2097C34.8235 41.4338 30.5601 43.4426 26.0015 43.9V35.96C28.5768 35.8569 31.0129 34.7635 32.8015 32.9078C34.5902 31.052 35.5932 28.5774 35.6015 26V22C35.6015 21.4696 35.3908 20.9609 35.0157 20.5858C34.6406 20.2107 34.1319 20 33.6015 20H30.0015V14C30.0015 13.4696 29.7908 12.9609 29.4157 12.5858C29.0406 12.2107 28.5319 12 28.0015 12C27.4711 12 26.9623 12.2107 26.5873 12.5858C26.2122 12.9609 26.0015 13.4696 26.0015 14V20H22.0015V14C22.0015 13.4696 21.7908 12.9609 21.4157 12.5858C21.0406 12.2107 20.5319 12 20.0015 12C19.4711 12 18.9623 12.2107 18.5873 12.5858C18.2122 12.9609 18.0015 13.4696 18.0015 14V20H14.4015C13.8711 20 13.3623 20.2107 12.9873 20.5858C12.6122 20.9609 12.4015 21.4696 12.4015 22V26C12.4097 28.5774 13.4128 31.052 15.2014 32.9078C16.9901 34.7635 19.4262 35.8569 22.0015 35.96V46C22.0015 46.5304 22.2122 47.0391 22.5873 47.4142C22.9623 47.7893 23.4711 48 24.0015 48C29.6024 47.9997 35.0269 46.0404 39.3353 42.4616C43.6437 38.8827 46.5648 33.9097 47.5925 28.4039C48.6203 22.8981 47.69 17.2061 44.9628 12.314C42.2356 7.42186 37.8833 3.63762 32.6596 1.61671C27.436 -0.404199 21.67 -0.534496 16.3604 1.24839C11.0508 3.03127 6.53197 6.61504 3.58657 11.379C0.641169 16.1429 -0.545284 21.787 0.232704 27.3337C1.01069 32.8803 3.70412 37.9802 7.84649 41.75C8.23903 42.1067 8.75717 42.2928 9.28694 42.2675C9.81672 42.2422 10.3148 42.0075 10.6715 41.615ZM16.4015 26V24H31.6015V26C31.6015 27.5913 30.9693 29.1174 29.8441 30.2426C28.7189 31.3679 27.1928 32 25.6015 32H22.4015C20.8102 32 19.2841 31.3679 18.1588 30.2426C17.0336 29.1174 16.4015 27.5913 16.4015 26Z",
    fill: "#F8478D"
  })),
  sidebar: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "33",
    height: "32",
    viewBox: "0 0 33 32",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    x: "0.666672",
    width: "32",
    height: "32",
    rx: "8",
    fill: "url(#paint0_linear_2820_689)"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M19.1667 8.5V23.5M13.1667 8.5H20.1667C21.5668 8.5 22.2669 8.5 22.8016 8.77248C23.2721 9.01217 23.6545 9.39462 23.8942 9.86502C24.1667 10.3998 24.1667 11.0999 24.1667 12.5V19.5C24.1667 20.9001 24.1667 21.6002 23.8942 22.135C23.6545 22.6054 23.2721 22.9878 22.8016 23.2275C22.2669 23.5 21.5668 23.5 20.1667 23.5H13.1667C11.7665 23.5 11.0665 23.5 10.5317 23.2275C10.0613 22.9878 9.67884 22.6054 9.43916 22.135C9.16667 21.6002 9.16667 20.9001 9.16667 19.5V12.5C9.16667 11.0999 9.16667 10.3998 9.43916 9.86502C9.67884 9.39462 10.0613 9.01217 10.5317 8.77248C11.0665 8.5 11.7665 8.5 13.1667 8.5Z",
    stroke: "white",
    strokeWidth: "1.67",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("defs", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("linearGradient", {
    id: "paint0_linear_2820_689",
    x1: "3.00163",
    y1: "3.5",
    x2: "30.5016",
    y2: "30",
    gradientUnits: "userSpaceOnUse"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("stop", {
    stopColor: "#5081F5"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("stop", {
    offset: "1",
    stopColor: "#A769F5"
  })))),
  star: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "116",
    height: "20",
    viewBox: "0 0 116 20",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M9.14319 1.42372C9.53185 0.777902 10.4681 0.777901 10.8568 1.42372L13.0731 5.10651C13.2128 5.33853 13.4405 5.504 13.7043 5.56509L17.8918 6.53491C18.6261 6.70498 18.9154 7.59545 18.4213 8.16466L15.6036 11.4106C15.4261 11.6151 15.3391 11.8828 15.3625 12.1526L15.7342 16.4347C15.7994 17.1857 15.0419 17.736 14.3478 17.442L10.3901 15.7653C10.1408 15.6596 9.85924 15.6596 9.60991 15.7653L5.65216 17.442C4.95813 17.736 4.20065 17.1857 4.26582 16.4347L4.63745 12.1526C4.66087 11.8828 4.57387 11.6151 4.39637 11.4106L1.57871 8.16466C1.0846 7.59545 1.37393 6.70498 2.10824 6.53491L6.29567 5.56509C6.55948 5.504 6.78723 5.33853 6.92685 5.10652L9.14319 1.42372Z",
    fill: "#F9B83A"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M33.1432 1.42372C33.5319 0.777902 34.4681 0.777901 34.8568 1.42372L37.0731 5.10651C37.2128 5.33853 37.4405 5.504 37.7043 5.56509L41.8918 6.53491C42.6261 6.70498 42.9154 7.59545 42.4213 8.16466L39.6036 11.4106C39.4261 11.6151 39.3391 11.8828 39.3625 12.1526L39.7342 16.4347C39.7994 17.1857 39.0419 17.736 38.3478 17.442L34.3901 15.7653C34.1408 15.6596 33.8592 15.6596 33.6099 15.7653L29.6522 17.442C28.9581 17.736 28.2006 17.1857 28.2658 16.4347L28.6375 12.1526C28.6609 11.8828 28.5739 11.6151 28.3964 11.4106L25.5787 8.16466C25.0846 7.59545 25.3739 6.70498 26.1082 6.53491L30.2957 5.56509C30.5595 5.504 30.7872 5.33853 30.9269 5.10652L33.1432 1.42372Z",
    fill: "#F9B83A"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M57.1432 1.42372C57.5319 0.777902 58.4681 0.777901 58.8568 1.42372L61.0731 5.10651C61.2128 5.33853 61.4405 5.504 61.7043 5.56509L65.8918 6.53491C66.6261 6.70498 66.9154 7.59545 66.4213 8.16466L63.6036 11.4106C63.4261 11.6151 63.3391 11.8828 63.3625 12.1526L63.7342 16.4347C63.7994 17.1857 63.0419 17.736 62.3478 17.442L58.3901 15.7653C58.1408 15.6596 57.8592 15.6596 57.6099 15.7653L53.6522 17.442C52.9581 17.736 52.2006 17.1857 52.2658 16.4347L52.6375 12.1526C52.6609 11.8828 52.5739 11.6151 52.3964 11.4106L49.5787 8.16466C49.0846 7.59545 49.3739 6.70498 50.1082 6.53491L54.2957 5.56509C54.5595 5.504 54.7872 5.33853 54.9269 5.10652L57.1432 1.42372Z",
    fill: "#F9B83A"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M81.1432 1.42372C81.5319 0.777902 82.4681 0.777901 82.8568 1.42372L85.0731 5.10651C85.2128 5.33853 85.4405 5.504 85.7043 5.56509L89.8918 6.53491C90.6261 6.70498 90.9154 7.59545 90.4213 8.16466L87.6036 11.4106C87.4261 11.6151 87.3391 11.8828 87.3625 12.1526L87.7342 16.4347C87.7994 17.1857 87.0419 17.736 86.3478 17.442L82.3901 15.7653C82.1408 15.6596 81.8592 15.6596 81.6099 15.7653L77.6522 17.442C76.9581 17.736 76.2006 17.1857 76.2658 16.4347L76.6375 12.1526C76.6609 11.8828 76.5739 11.6151 76.3964 11.4106L73.5787 8.16466C73.0846 7.59545 73.3739 6.70498 74.1082 6.53491L78.2957 5.56509C78.5595 5.504 78.7872 5.33853 78.9269 5.10652L81.1432 1.42372Z",
    fill: "#F9B83A"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M105.143 1.42372C105.532 0.777902 106.468 0.777901 106.857 1.42372L109.073 5.10651C109.213 5.33853 109.441 5.504 109.704 5.56509L113.892 6.53491C114.626 6.70498 114.915 7.59545 114.421 8.16466L111.604 11.4106C111.426 11.6151 111.339 11.8828 111.363 12.1526L111.734 16.4347C111.799 17.1857 111.042 17.736 110.348 17.442L106.39 15.7653C106.141 15.6596 105.859 15.6596 105.61 15.7653L101.652 17.442C100.958 17.736 100.201 17.1857 100.266 16.4347L100.637 12.1526C100.661 11.8828 100.574 11.6151 100.396 11.4106L97.5787 8.16466C97.0846 7.59545 97.3739 6.70498 98.1082 6.53491L102.296 5.56509C102.559 5.504 102.787 5.33853 102.927 5.10652L105.143 1.42372Z",
    fill: "#F9B83A"
  })),
  review: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "20",
    height: "20",
    viewBox: "0 0 20 20",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M7.56246 11.8748L9.99996 10.3957L12.4375 11.8748L11.7916 9.104L13.9583 7.229L11.1041 6.99984L9.99996 4.37484L8.89579 6.99984L6.04163 7.229L8.20829 9.104L7.56246 11.8748ZM1.66663 18.3332V3.33317C1.66663 2.87484 1.82996 2.48262 2.15663 2.1565C2.48329 1.83039 2.87551 1.66706 3.33329 1.6665H16.6666C17.125 1.6665 17.5175 1.82984 17.8441 2.1565C18.1708 2.48317 18.3338 2.87539 18.3333 3.33317V13.3332C18.3333 13.7915 18.1702 14.184 17.8441 14.5107C17.518 14.8373 17.1255 15.0004 16.6666 14.9998H4.99996L1.66663 18.3332ZM4.29163 13.3332H16.6666V3.33317H3.33329V14.2707L4.29163 13.3332Z",
    fill: "currentColor"
  }))
};
const Icon = ({
  icon,
  tooltip,
  label
}) => {
  const Icon = icons[icon];
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, Icon && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(Icon, null), label && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("h3", {
    className: "cwLabel"
  }, label), tooltip && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
    className: "cw-tooltip"
  }, tooltip));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Icon);

/***/ },

/***/ "./src/components/Sidebar/index.jsx"
/*!******************************************!*\
  !*** ./src/components/Sidebar/index.jsx ***!
  \******************************************/
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Icon__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Icon */ "./src/components/Icon/index.jsx");



const Sidebar = ({
  sidebarSettings,
  openInNewTab
}) => {
  const sidebarListing = sidebar => {
    return sidebar.map((sidebaritem, index) => {
      return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "cw-sidebarbody",
        key: index
      }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("h3", null, sidebaritem.heading), sidebaritem.icon && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_Icon__WEBPACK_IMPORTED_MODULE_1__["default"], {
        icon: sidebaritem.icon
      })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, sidebaritem.para), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "cw-button"
      }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
        href: sidebaritem.buttonUrl,
        target: openInNewTab ? "_blank" : "_self",
        className: "cw-button-btn outline"
      }, sidebaritem.imageurl, sidebaritem.buttonText, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_Icon__WEBPACK_IMPORTED_MODULE_1__["default"], {
        icon: "arrowtwo"
      }))));
    });
  };
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "cw-sidebar"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "cw-sidebar-list"
  }, sidebarListing(sidebarSettings))));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Sidebar);

/***/ },

/***/ "./src/components/Tab/index.jsx"
/*!**************************************!*\
  !*** ./src/components/Tab/index.jsx ***!
  \**************************************/
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _useTabs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./useTabs */ "./src/components/Tab/useTabs.jsx");
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! .. */ "./src/components/index.js");
/* harmony import */ var _assets_img_logo_png__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../assets/img/logo.png */ "./src/assets/img/logo.png");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__);





const Tab = ({
  tabsData,
  onChange,
  activeTabTitle
}) => {
  const {
    renderTabs,
    renderContent
  } = (0,_useTabs__WEBPACK_IMPORTED_MODULE_1__["default"])(tabsData, 0, onChange);
  const GetPro = () => {
    return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "get-pro"
    }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("img", {
      src: _assets_img_logo_png__WEBPACK_IMPORTED_MODULE_3__,
      alt: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)('Logo', 'blossom-recipe')
    }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("h3", null, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)('Blossom Recipe Pro', 'blossom-recipe')), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)('Get access to all unlimited features.', 'blossom-recipe')), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
      className: "cw-button-btn primary-btn",
      target: "_blank",
      href: cw_dashboard.get_pro
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)('Get Pro', 'blossom-recipe'))));
  };
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "cw-tabs-container"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "cw-tabs"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "wrapper"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "top"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "logo"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("img", {
    src: _assets_img_logo_png__WEBPACK_IMPORTED_MODULE_3__,
    alt: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)('Logo', 'blossom-recipe')
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("h2", null, cw_dashboard.blog_name)), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "cw-tabs-button"
  }, renderTabs())), GetPro())), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "wrapper"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(___WEBPACK_IMPORTED_MODULE_2__.TabHeader, {
    title: activeTabTitle
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "cw-tabs-content"
  }, renderContent())));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Tab);

/***/ },

/***/ "./src/components/Tab/useTabs.jsx"
/*!****************************************!*\
  !*** ./src/components/Tab/useTabs.jsx ***!
  \****************************************/
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_router_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react-router-dom */ "./node_modules/react-router/dist/index.js");



function useTabs(initialTabs, initialActiveTab = 0, onChange) {
  const tabsRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(initialTabs);
  const [activeTab, setActiveTab] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(initialActiveTab);
  const navigate = (0,react_router_dom__WEBPACK_IMPORTED_MODULE_1__.useNavigate)();
  const handleTabClick = index => {
    if (index !== activeTab) {
      setActiveTab(index);
      const newHash = tabsRef.current[index].title.toLowerCase().replace(/ /g, "-");
      if (onChange) {
        onChange(tabsRef.current[index].title);
      }
      navigate(`/wp-admin/themes.php?page=blossom-recipe-dashboard#${newHash}`);
    }
  };
  const checkHash = () => {
    const hash = window.location.hash.substring(1);
    const tabIndex = tabsRef.current.findIndex(tab => tab.title.toLowerCase().replace(/ /g, "-") === hash);
    if (tabIndex !== -1 && tabIndex !== activeTab) {
      setActiveTab(tabIndex);
      if (onChange) {
        onChange(tabsRef.current[tabIndex].title);
      }
    }
  };
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    checkHash();
    window.addEventListener('hashchange', checkHash);
    return () => {
      window.removeEventListener('hashchange', checkHash);
    };
  }, []);
  const renderTabs = () => {
    return tabsRef.current.map((tab, index) => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("button", {
      key: index,
      onClick: () => handleTabClick(index),
      className: activeTab === index ? 'active-tab' : ''
    }, tab.icon, tab.title));
  };
  const renderContent = () => {
    return tabsRef.current[activeTab].content;
  };
  return {
    renderTabs,
    renderContent
  };
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useTabs);

/***/ },

/***/ "./src/components/TabHeader/index.jsx"
/*!********************************************!*\
  !*** ./src/components/TabHeader/index.jsx ***!
  \********************************************/
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! .. */ "./src/components/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);



const TabHeader = ({
  title
}) => {
  const docLinks = [{
    name: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('View Website', 'blossom-recipe'),
    link: cw_dashboard.website,
    icon: "globe"
  }, {
    name: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('View Tutorials ', 'blossom-recipe'),
    link: cw_dashboard.videotutorial,
    icon: "youtube"
  }, {
    name: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Contact Support', 'blossom-recipe'),
    link: cw_dashboard.support,
    icon: "support"
  }, {
    name: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Docs', 'blossom-recipe'),
    link: cw_dashboard.docmentation,
    icon: "doc"
  }];
  const docLinkListing = () => {
    return docLinks.map((list, index) => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
      key: index,
      href: list.link,
      target: "_blank"
    }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(___WEBPACK_IMPORTED_MODULE_1__.Icon, {
      icon: list.icon,
      tooltip: list.name
    })));
  };
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("header", {
    className: "navbar"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("h1", null, title), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "info"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
    className: "version"
  }, cw_dashboard.theme_version), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "doc-links"
  }, docLinkListing()))));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (TabHeader);

/***/ },

/***/ "./src/components/images.js"
/*!**********************************!*\
  !*** ./src/components/images.js ***!
  \**********************************/
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   GDPR: () => (/* reexport default export from named module */ _assets_img_GDPR_jpg__WEBPACK_IMPORTED_MODULE_2__),
/* harmony export */   SEO: () => (/* reexport default export from named module */ _assets_img_SEO_jpg__WEBPACK_IMPORTED_MODULE_8__),
/* harmony export */   customFonts: () => (/* reexport default export from named module */ _assets_img_customFonts_jpg__WEBPACK_IMPORTED_MODULE_0__),
/* harmony export */   freevspro: () => (/* reexport default export from named module */ _assets_img_freevspro_webp__WEBPACK_IMPORTED_MODULE_1__),
/* harmony export */   logo: () => (/* reexport default export from named module */ _assets_img_logo_png__WEBPACK_IMPORTED_MODULE_3__),
/* harmony export */   pluginsSetup: () => (/* reexport default export from named module */ _assets_img_pluginsSetup_jpg__WEBPACK_IMPORTED_MODULE_4__),
/* harmony export */   recipeCourses: () => (/* reexport default export from named module */ _assets_img_recipe_courses_jpg__WEBPACK_IMPORTED_MODULE_5__),
/* harmony export */   recipeFeatured: () => (/* reexport default export from named module */ _assets_img_recipe_featured_jpg__WEBPACK_IMPORTED_MODULE_6__),
/* harmony export */   salesFunnel: () => (/* reexport default export from named module */ _assets_img_salesFunnel_jpg__WEBPACK_IMPORTED_MODULE_7__),
/* harmony export */   singleRecipe: () => (/* reexport default export from named module */ _assets_img_single_recipe_jpg__WEBPACK_IMPORTED_MODULE_9__),
/* harmony export */   themeClub: () => (/* reexport default export from named module */ _assets_img_themeClub_jpg__WEBPACK_IMPORTED_MODULE_10__),
/* harmony export */   themeInstallation: () => (/* reexport default export from named module */ _assets_img_themeInstallation_jpg__WEBPACK_IMPORTED_MODULE_11__),
/* harmony export */   vipSiteCare: () => (/* reexport default export from named module */ _assets_img_vipSiteCare_jpg__WEBPACK_IMPORTED_MODULE_12__),
/* harmony export */   vipSupport: () => (/* reexport default export from named module */ _assets_img_vipSupport_jpg__WEBPACK_IMPORTED_MODULE_13__)
/* harmony export */ });
/* harmony import */ var _assets_img_customFonts_jpg__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../assets/img/customFonts.jpg */ "./src/assets/img/customFonts.jpg");
/* harmony import */ var _assets_img_freevspro_webp__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../assets/img/freevspro.webp */ "./src/assets/img/freevspro.webp");
/* harmony import */ var _assets_img_GDPR_jpg__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../assets/img/GDPR.jpg */ "./src/assets/img/GDPR.jpg");
/* harmony import */ var _assets_img_logo_png__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../assets/img/logo.png */ "./src/assets/img/logo.png");
/* harmony import */ var _assets_img_pluginsSetup_jpg__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../assets/img/pluginsSetup.jpg */ "./src/assets/img/pluginsSetup.jpg");
/* harmony import */ var _assets_img_recipe_courses_jpg__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../assets/img/recipe-courses.jpg */ "./src/assets/img/recipe-courses.jpg");
/* harmony import */ var _assets_img_recipe_featured_jpg__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../assets/img/recipe-featured.jpg */ "./src/assets/img/recipe-featured.jpg");
/* harmony import */ var _assets_img_salesFunnel_jpg__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../assets/img/salesFunnel.jpg */ "./src/assets/img/salesFunnel.jpg");
/* harmony import */ var _assets_img_SEO_jpg__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../assets/img/SEO.jpg */ "./src/assets/img/SEO.jpg");
/* harmony import */ var _assets_img_single_recipe_jpg__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../assets/img/single-recipe.jpg */ "./src/assets/img/single-recipe.jpg");
/* harmony import */ var _assets_img_themeClub_jpg__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../assets/img/themeClub.jpg */ "./src/assets/img/themeClub.jpg");
/* harmony import */ var _assets_img_themeInstallation_jpg__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../assets/img/themeInstallation.jpg */ "./src/assets/img/themeInstallation.jpg");
/* harmony import */ var _assets_img_vipSiteCare_jpg__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../assets/img/vipSiteCare.jpg */ "./src/assets/img/vipSiteCare.jpg");
/* harmony import */ var _assets_img_vipSupport_jpg__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../assets/img/vipSupport.jpg */ "./src/assets/img/vipSupport.jpg");















/***/ },

/***/ "./src/components/index.js"
/*!*********************************!*\
  !*** ./src/components/index.js ***!
  \*********************************/
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Card: () => (/* reexport safe */ _Card__WEBPACK_IMPORTED_MODULE_4__["default"]),
/* harmony export */   Heading: () => (/* reexport safe */ _Heading__WEBPACK_IMPORTED_MODULE_5__["default"]),
/* harmony export */   Icon: () => (/* reexport safe */ _Icon__WEBPACK_IMPORTED_MODULE_0__["default"]),
/* harmony export */   Sidebar: () => (/* reexport safe */ _Sidebar__WEBPACK_IMPORTED_MODULE_2__["default"]),
/* harmony export */   Tab: () => (/* reexport safe */ _Tab__WEBPACK_IMPORTED_MODULE_1__["default"]),
/* harmony export */   TabHeader: () => (/* reexport safe */ _TabHeader__WEBPACK_IMPORTED_MODULE_3__["default"])
/* harmony export */ });
/* harmony import */ var _Icon__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Icon */ "./src/components/Icon/index.jsx");
/* harmony import */ var _Tab__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Tab */ "./src/components/Tab/index.jsx");
/* harmony import */ var _Sidebar__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Sidebar */ "./src/components/Sidebar/index.jsx");
/* harmony import */ var _TabHeader__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./TabHeader */ "./src/components/TabHeader/index.jsx");
/* harmony import */ var _Card__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./Card */ "./src/components/Card/index.jsx");
/* harmony import */ var _Heading__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./Heading */ "./src/components/Heading/index.jsx");







/***/ },

/***/ "./src/pages/FAQ/index.jsx"
/*!*********************************!*\
  !*** ./src/pages/FAQ/index.jsx ***!
  \*********************************/
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../components */ "./src/components/index.js");




function FAQ() {
  const faqContent = [{
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('What is the difference between Free and Pro?', 'blossom-recipe'),
    description: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Both Free and Pro version of the themes are well-built. However, the Pro version comes with many additional features.', 'blossom-recipe')), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('With the Pro version, you can change the look and feel of your website in seconds. In just a few clicks, you can change the color and typography of your website. The premium version lets you have better control over the theme as it comes with more customization options. Not just that, the theme also has more sections and layout options as compared to the free version. The Pro version is multi-language compatible as well.', 'blossom-recipe')), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
      dangerouslySetInnerHTML: {
        __html: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.sprintf)((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Overall, you will have more control over your website with the Pro version. You can find out more about the difference between Free and Pro versions %s.', 'blossom-recipe'), `<a target="_blank" href=${cw_dashboard.get_pro}>here</a>`)
      }
    }))
  }, {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('What are the advantages of upgrading to the Premium version?', 'blossom-recipe'),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('With Premium version, besides the extra features and frequent updates, you get premium support. If you run into any theme issues, you will get a lot quicker response compared to the free support.', 'blossom-recipe')
  }, {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Upgrading to the Pro version- will I lose my changes?', 'blossom-recipe'),
    description: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('When you upgrade to the Pro theme, your posts, pages, media, categories, and other data will remain intact-- all your data is saved.', 'blossom-recipe')), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('However, since the Pro version comes with added features and settings, you will need to set up the additional features in the customizer. This process is simple and only takes a few minutes.', 'blossom-recipe')), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('The Pro version is built with lots of flexibility in mind for future upgrades. Therefore, it is slightly different than the free theme but extremely flexible and easy-to-use.', 'blossom-recipe')))
  }, {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('How do I change the copyright text?', 'blossom-recipe'),
    description: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
      dangerouslySetInnerHTML: {
        __html: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.sprintf)((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('You can change the copyright text going to %1$s Appearance > Customize > Footer Settings. %2$s However, if you want to hide the author credit text, please %3$s.', 'blossom-recipe'), '<b>', '</b>', `<a target="_blank" href=${cw_dashboard.get_pro}>upgrade to the Pro version</a>`)
      }
    })
  }, {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Why is my theme not working well?', 'blossom-recipe'),
    description: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('If your customizer is not loading properly or you are having issues with the theme, it might be due to the plugin conflict.', 'blossom-recipe')), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
      dangerouslySetInnerHTML: {
        __html: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.sprintf)((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('To solve the issue, deactivate all the plugins first, except the ones recommended by the theme. Then, hard reload your website using %1$s "Ctrl+Shift+R" %2$s on Windows. If the issues are fixed, start activating the plugins one by one, and reload and check your site each time. This will help you find out the plugin that is causing the problem.', 'blossom-recipe'), '<b>', '</b>')
      }
    }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
      dangerouslySetInnerHTML: {
        __html: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.sprintf)((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('If this didn\'t help, please %s.', 'blossom-recipe'), `<a target="_blank" href=${cw_dashboard.support}> contact us here</a>`)
      }
    }))
  }, {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('How can I solve my issues quickly and get faster support?', 'blossom-recipe'),
    description: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Before you send us a support ticket for any issues, please make sure you have updated the theme to the latest version. We might have fixed the bug in the theme update.', 'blossom-recipe')), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('When you submit the support ticket, please try to provide as much details as possible so that we can solve your problem faster. We recommend you to send us a screenshot(s) with issues explained and your website\'s address (URL). You can contact us ', 'blossom-recipe'), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
      href: cw_dashboard.support,
      target: "_blank"
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('here.', 'blossom-recipe'))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Also, you might experience a slower response time during the weekend, so please bear with us.', 'blossom-recipe')))
  }];
  const [openIndex, setOpenIndex] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(0);
  const [height, setHeight] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)('0px');
  const contentRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    setHeight(openIndex !== -1 ? `${contentRef.current.scrollHeight}px` : '0px');
  }, [openIndex]);
  const toggleDescription = index => {
    setOpenIndex(index === openIndex ? -1 : index);
  };
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, faqContent.map((content, index) => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "faq-item",
    key: index
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "faq-title",
    onClick: () => toggleDescription(index)
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("h2", null, content.title), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_2__.Icon, {
    icon: openIndex === index ? 'minus' : 'plus'
  }))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "faq-description",
    ref: openIndex === index ? contentRef : null,
    style: {
      maxHeight: openIndex === index ? height : '0px',
      overflow: 'hidden',
      transition: 'max-height 0.5s ease'
    }
  }, typeof content.description === 'string' ? (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, content.description) : content.description))));
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (FAQ);

/***/ },

/***/ "./src/pages/FreePro/index.jsx"
/*!*************************************!*\
  !*** ./src/pages/FreePro/index.jsx ***!
  \*************************************/
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _assets_img_freevspro_webp__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../assets/img/freevspro.webp */ "./src/assets/img/freevspro.webp");
/* harmony import */ var _components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../components */ "./src/components/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__);




const FreePro = () => {
  const sidebarSettings = [{
    heading: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('We Value Your Feedback!', 'blossom-recipe'),
    icon: "star",
    para: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Your review helps us improve and assists others in making informed choices. Share your thoughts today!", 'blossom-recipe'),
    imageurl: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_2__.Icon, {
      icon: "review"
    }),
    buttonText: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Leave a Review', 'blossom-recipe'),
    buttonUrl: cw_dashboard.review
  }, {
    heading: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Knowledge Base', 'blossom-recipe'),
    para: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Need help using our theme? Visit our well-organized Knowledge Base!", 'blossom-recipe'),
    imageurl: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_2__.Icon, {
      icon: "documentation"
    }),
    buttonText: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Explore', 'blossom-recipe'),
    buttonUrl: cw_dashboard.docmentation
  }, {
    heading: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Need Assistance? ', 'blossom-recipe'),
    para: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("If you need help or have any questions, don't hesitate to contact our support team. We're here to assist you!", 'blossom-recipe'),
    imageurl: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_2__.Icon, {
      icon: "supportTwo"
    }),
    buttonText: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Submit a Ticket', 'blossom-recipe'),
    buttonUrl: cw_dashboard.support
  }];
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "customizer-settings"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "cw-customizer"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("img", {
    className: "freepro",
    src: _assets_img_freevspro_webp__WEBPACK_IMPORTED_MODULE_1__,
    alt: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Free vs Pro image", "blossom-recipe")
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_2__.Sidebar, {
    sidebarSettings: sidebarSettings,
    openInNewTab: true
  })));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (FreePro);

/***/ },

/***/ "./src/pages/Home/index.jsx"
/*!**********************************!*\
  !*** ./src/pages/Home/index.jsx ***!
  \**********************************/
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../components */ "./src/components/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);



const Homepage = () => {
  const cardLists = [{
    iconSvg: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_1__.Icon, {
      icon: "site"
    }),
    heading: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Site Identity', 'blossom-recipe'),
    buttonText: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Customize', 'blossom-recipe'),
    buttonUrl: cw_dashboard.custom_logo
  }, {
    iconSvg: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_1__.Icon, {
      icon: "colorsetting"
    }),
    heading: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Color Settings", 'blossom-recipe'),
    buttonText: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Customize', 'blossom-recipe'),
    buttonUrl: cw_dashboard.colors
  }, {
    iconSvg: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_1__.Icon, {
      icon: "layoutsetting"
    }),
    heading: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Layout Settings", 'blossom-recipe'),
    buttonText: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Customize', 'blossom-recipe'),
    buttonUrl: cw_dashboard.layout
  }, {
    iconSvg: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_1__.Icon, {
      icon: "instagramsetting"
    }),
    heading: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Instagram Settings", 'blossom-recipe'),
    buttonText: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Customize', 'blossom-recipe'),
    buttonUrl: cw_dashboard.instagram
  }, {
    iconSvg: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_1__.Icon, {
      icon: "generalsetting"
    }),
    heading: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("General Settings"),
    buttonText: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Customize', 'blossom-recipe'),
    buttonUrl: cw_dashboard.general
  }, {
    iconSvg: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_1__.Icon, {
      icon: "footersetting"
    }),
    heading: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Footer Settings', 'blossom-recipe'),
    buttonText: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Customize', 'blossom-recipe'),
    buttonUrl: cw_dashboard.footer
  }];
  const proSettings = [{
    heading: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Header Layouts', 'blossom-recipe'),
    para: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Choose from different unique header layouts.', 'blossom-recipe'),
    buttonText: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Learn More', 'blossom-recipe'),
    buttonUrl: cw_dashboard?.get_pro
  }, {
    heading: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Multiple Layouts', 'blossom-recipe'),
    para: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Choose layouts for blogs, banners, posts and more.', 'blossom-recipe'),
    buttonText: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Learn More', 'blossom-recipe'),
    buttonUrl: cw_dashboard?.get_pro
  }, {
    heading: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Multiple Sidebar', 'blossom-recipe'),
    para: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Set different sidebars for posts and pages.', 'blossom-recipe'),
    buttonText: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Learn More', 'blossom-recipe'),
    buttonUrl: cw_dashboard?.get_pro
  }, {
    heading: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Top Bar Settings', 'blossom-recipe'),
    para: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Show a notice or newsletter at the top.', 'blossom-recipe'),
    buttonText: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Learn More', 'blossom-recipe'),
    buttonUrl: cw_dashboard?.get_pro
  }, {
    para: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Boost your website performance with ease.', 'blossom-recipe'),
    heading: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Performance Settings', 'blossom-recipe'),
    buttonText: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Learn More', 'blossom-recipe'),
    buttonUrl: cw_dashboard?.get_pro
  }, {
    para: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Choose typography for different heading tags.', 'blossom-recipe'),
    heading: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Typography Settings', 'blossom-recipe'),
    buttonText: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Learn More', 'blossom-recipe'),
    buttonUrl: cw_dashboard?.get_pro
  }, {
    para: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Import the demo content to kickstart your site.', 'blossom-recipe'),
    heading: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('One Click Demo Import', 'blossom-recipe'),
    buttonText: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Learn More', 'blossom-recipe'),
    buttonUrl: cw_dashboard?.get_pro
  }, {
    para: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Easily place ads on high conversion areas.', 'blossom-recipe'),
    heading: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Advertisement Settings', 'blossom-recipe'),
    buttonText: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Learn More', 'blossom-recipe'),
    buttonUrl: cw_dashboard?.get_pro
  }];
  const sidebarSettings = [{
    heading: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('We Value Your Feedback!', 'blossom-recipe'),
    icon: "star",
    para: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Your review helps us improve and assists others in making informed choices. Share your thoughts today!", 'blossom-recipe'),
    imageurl: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_1__.Icon, {
      icon: "review"
    }),
    buttonText: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Leave a Review', 'blossom-recipe'),
    buttonUrl: cw_dashboard.review
  }, {
    heading: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Knowledge Base', 'blossom-recipe'),
    para: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Need help using our theme? Visit our well-organized Knowledge Base!", 'blossom-recipe'),
    imageurl: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_1__.Icon, {
      icon: "documentation"
    }),
    buttonText: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Explore', 'blossom-recipe'),
    buttonUrl: cw_dashboard.docmentation
  }, {
    heading: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Need Assistance? ', 'blossom-recipe'),
    para: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("If you need help or have any questions, don't hesitate to contact our support team. We're here to assist you!", 'blossom-recipe'),
    imageurl: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_1__.Icon, {
      icon: "supportTwo"
    }),
    buttonText: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Submit a Ticket', 'blossom-recipe'),
    buttonUrl: cw_dashboard.support
  }];
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "customizer-settings"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "cw-customizer"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "video-section"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "cw-settings"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("h2", null, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Blossom Recipe Tutorial', 'blossom-recipe'))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("iframe", {
    src: "https://www.youtube.com/embed/W4572TDQEjY?si=WOu6fTWOyEgD_FJv",
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('How to Start Your First Food Blog In 2023 | Blossom Recipe Free WordPress Theme', 'blossom-recipe'),
    frameBorder: "0",
    allow: "accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share",
    referrerPolicy: "strict-origin-when-cross-origin",
    allowFullScreen: true
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_1__.Heading, {
    heading: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Quick Customizer Settings', 'blossom-recipe'),
    buttonText: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Go To Customizer', 'blossom-recipe'),
    buttonUrl: cw_dashboard?.customizer_url,
    openInNewTab: true
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_1__.Card, {
    cardList: cardLists,
    cardPlace: "customizer",
    cardCol: "three-col"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_1__.Heading, {
    heading: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('More features with Pro version', 'blossom-recipe'),
    buttonText: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Go To Customizer', 'blossom-recipe'),
    buttonUrl: cw_dashboard?.customizer_url,
    openInNewTab: true
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_1__.Card, {
    cardList: proSettings,
    cardPlace: "cw-pro",
    cardCol: "two-col"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "cw-button"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
    href: cw_dashboard?.get_pro,
    target: "_blank",
    className: "cw-button-btn primary-btn long-button"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Learn more about the Pro version', 'blossom-recipe')))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_1__.Sidebar, {
    sidebarSettings: sidebarSettings,
    openInNewTab: true
  })));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Homepage);

/***/ },

/***/ "./src/pages/Offers/index.jsx"
/*!************************************!*\
  !*** ./src/pages/Offers/index.jsx ***!
  \************************************/
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _components_images__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../components/images */ "./src/components/images.js");



const Offers = () => {
  const offerBannerLists = [{
    image: _components_images__WEBPACK_IMPORTED_MODULE_2__.themeClub,
    imageUrl: cw_dashboard.theme_club_upgrade,
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("Theme Club", "blossom-recipe")
  }, {
    image: _components_images__WEBPACK_IMPORTED_MODULE_2__.salesFunnel,
    imageUrl: cw_dashboard.sales_funnel,
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("Sales Funnel", "blossom-recipe")
  }, {
    image: _components_images__WEBPACK_IMPORTED_MODULE_2__.customFonts,
    imageUrl: cw_dashboard.custom_fonts,
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("Custom Fonts", "blossom-recipe")
  }, {
    image: _components_images__WEBPACK_IMPORTED_MODULE_2__.vipSiteCare,
    imageUrl: cw_dashboard.vip_site_care,
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("VIP Site Care", "blossom-recipe")
  }];
  const offerCardLists = [{
    image: _components_images__WEBPACK_IMPORTED_MODULE_2__.themeInstallation,
    imageUrl: cw_dashboard.theme_install,
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("Theme Installation & Setup", "blossom-recipe")
  }, {
    image: _components_images__WEBPACK_IMPORTED_MODULE_2__.GDPR,
    imageUrl: cw_dashboard.gdpr_setup,
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("GDPR Compliance", "blossom-recipe")
  }, {
    image: _components_images__WEBPACK_IMPORTED_MODULE_2__.SEO,
    imageUrl: cw_dashboard.seo_setup,
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("Must Have SEO Setup", "blossom-recipe")
  }, {
    image: _components_images__WEBPACK_IMPORTED_MODULE_2__.pluginsSetup,
    imageUrl: cw_dashboard.plugin_setup,
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("Must Have Plugins Setup", "blossom-recipe")
  }, {
    image: _components_images__WEBPACK_IMPORTED_MODULE_2__.vipSupport,
    imageUrl: cw_dashboard.vip_support,
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("VIP Support", "blossom-recipe")
  }];
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "cw-offer"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "banner-section"
  }, offerBannerLists.map((banner, index) => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
    className: "image-link",
    href: banner.imageUrl,
    key: index,
    target: "_blank"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("img", {
    src: banner.image,
    alt: banner.title
  })))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "card-section"
  }, offerCardLists.map((card, index) => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
    className: "image-link",
    href: card.imageUrl,
    key: index,
    target: "_blank"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("img", {
    src: card.image,
    alt: card.title
  }))))));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Offers);

/***/ },

/***/ "./src/pages/StarterSites/index.jsx"
/*!******************************************!*\
  !*** ./src/pages/StarterSites/index.jsx ***!
  \******************************************/
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../components */ "./src/components/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _components_images__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../components/images */ "./src/components/images.js");




const StarterSites = () => {
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "starter-sites"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "image-wrapper"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "image"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("img", {
    src: _components_images__WEBPACK_IMPORTED_MODULE_3__.singleRecipe,
    alt: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Demo image', 'blossom-recipe')
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "reverse-image"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("img", {
    src: _components_images__WEBPACK_IMPORTED_MODULE_3__.singleRecipe,
    alt: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Demo reverse image', 'blossom-recipe')
  }))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "image"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("img", {
    src: _components_images__WEBPACK_IMPORTED_MODULE_3__.recipeFeatured,
    alt: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Demo image', 'blossom-recipe')
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "reverse-image"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("img", {
    src: _components_images__WEBPACK_IMPORTED_MODULE_3__.recipeFeatured,
    alt: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Demo reverse image', 'blossom-recipe')
  }))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "image"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("img", {
    src: _components_images__WEBPACK_IMPORTED_MODULE_3__.recipeCourses,
    alt: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Demo image', 'blossom-recipe')
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "reverse-image"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("img", {
    src: _components_images__WEBPACK_IMPORTED_MODULE_3__.recipeCourses,
    alt: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Demo reverse image', 'blossom-recipe')
  })))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "text-wrapper"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("h2", null, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('One Click Demo Import', 'blossom-recipe')), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
    dangerouslySetInnerHTML: {
      __html: sprintf((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Get started effortlessly! Use our one-click demo import feature to set up your site instantly with all the sample data and settings. Please note that importing demo content will overwrite your existing site content and settings. %s Not recommended if you have existing content. %s', 'blossom-recipe'), '<b>', '</b>')
    }
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "cw-button"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
    href: cw_dashboard.get_pro,
    target: "_blank",
    className: "cw-button-btn primary-btn"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Get Starter Sites', 'blossom-recipe'), " ", (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_1__.Icon, {
    icon: "arrow"
  }))))));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (StarterSites);

/***/ },

/***/ "./src/pages/UsefulPlugins/index.jsx"
/*!*******************************************!*\
  !*** ./src/pages/UsefulPlugins/index.jsx ***!
  \*******************************************/
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../components */ "./src/components/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__);




const pluginList = [{
  pluginName: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('WP Delicious – Best WordPress Recipe Plugin', 'blossom-recipe'),
  description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("A powerful recipe plugin to create and display recipes for bloggers. SEO optimized and Schema-friendly to rank recipes higher on search engines.", "blossom-recipe"),
  slug: "delicious-recipes"
}, {
  pluginName: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Delisho', 'blossom-recipe'),
  description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("An Elementor Widget and Gutenberg Blocks plugin for WP Delicious that include 10+ widgets and 4 Gutenberg blocks to create beautiful and interactive recipe blogs with a quick drag-and-drop.", "blossom-recipe"),
  slug: "dr-widgets-blocks"
}, {
  pluginName: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('BlossomThemes Toolkit', 'blossom-recipe'),
  description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("BlossomThemes Toolkit provides you necessary widgets for better and effective blogging.", "blossom-recipe"),
  slug: "blossomthemes-toolkit"
}, {
  pluginName: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('BlossomThemes Email Newsletter', 'blossom-recipe'),
  description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Easily add email subscription form to your website using shortcode and widget.", "blossom-recipe"),
  slug: "blossomthemes-email-newsletter"
}, {
  pluginName: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Contact Form 7', 'blossom-recipe'),
  description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Just another contact form plugin. Simple but flexible.", "blossom-recipe"),
  slug: "contact-form-7"
}, {
  pluginName: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Regenerate Thumbnails', 'blossom-recipe'),
  description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Regenerate the thumbnails for one or more of your image uploads. Useful when changing their sizes or your theme.", "blossom-recipe"),
  slug: "regenerate-thumbnails"
}, {
  pluginName: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('AffiliateX – Best Amazon Affiliate WordPress Plugin', 'blossom-recipe'),
  description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Create a professional-looking affiliate websites with highly customizable blocks that help in increasing the conversion rate and boost your affiliate income.", "blossom-recipe"),
  slug: "affiliatex"
}, {
  pluginName: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Smash Balloon Social Photo Feed', 'blossom-recipe'),
  description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Formerly 'Instagram Feed'. Display clean, customizable, and responsive Instagram feeds from multiple accounts. Supports Instagram oEmbeds.", "blossom-recipe"),
  slug: "instagram-feed"
}];
const objectExistsInArray = (obj, array) => {
  return array.some(el => el.slug === obj.slug);
};
const UsefulPlugins = () => {
  const [buttonState, setButtonState] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(() => {
    const initialState = {};
    pluginList.forEach(plugin => {
      initialState[plugin.slug] = 'Install';
    });
    return initialState;
  });
  const [activateUrls, setActivateUrls] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)({});
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useEffect)(() => {
    const activePlugins = cw_dashboard.activePlugins;
    const inactivePlugins = cw_dashboard.inactivePlugins;
    const newButtonState = {};

    // Set state for active plugins
    activePlugins.forEach(plugin => {
      if (objectExistsInArray(plugin, pluginList)) {
        newButtonState[plugin.slug] = 'Activated';
      }
    });

    // Set state for inactive plugins
    inactivePlugins.forEach(plugin => {
      if (objectExistsInArray(plugin, pluginList)) {
        newButtonState[plugin.slug] = 'Activate';
      }
    });
    setButtonState(prevState => ({
      ...prevState,
      ...newButtonState
    }));
    const urls = {};
    inactivePlugins.forEach(plugin => {
      if (objectExistsInArray(plugin, pluginList)) {
        const url = plugin.url.replace(/&amp;/g, '&');
        urls[plugin.slug] = url;
      }
    });
    setActivateUrls(urls);
  }, []);
  const installPlugin = slug => {
    setButtonState(prevState => ({
      ...prevState,
      [slug]: 'Installing...'
    }));
    wp.updates.installPlugin({
      slug: slug,
      success: response => {
        setActivateUrls(prevUrls => ({
          ...prevUrls,
          [slug]: response.activateUrl
        }));
        setButtonState(prevState => ({
          ...prevState,
          [slug]: 'Activate'
        }));
      },
      error: error => {
        console.error(error);
        setButtonState(prevState => ({
          ...prevState,
          [slug]: 'Install'
        }));
      }
    });
  };
  const activatePlugin = async slug => {
    setButtonState(prevState => ({
      ...prevState,
      [slug]: 'Activating...'
    }));
    const url = activateUrls[slug];
    if (url) {
      try {
        const response = await fetch(url, {
          method: 'POST',
          headers: {
            'Content-Type': 'application/x-www-form-urlencoded'
          },
          body: new URLSearchParams({
            _wpnonce: new URL(url).searchParams.get('_wpnonce'),
            action: 'activate',
            plugin: new URL(url).searchParams.get('plugin')
          }).toString()
        });
        if (!response.ok) {
          throw new Error(`HTTP error! status: ${response.status}`);
        }
        setButtonState(prevState => ({
          ...prevState,
          [slug]: 'Activated'
        }));
      } catch (error) {
        setButtonState(prevState => ({
          ...prevState,
          [slug]: 'Activate'
        }));
      }
    }
  };
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "cw-plugin-list-wrapper"
  }, pluginList.map((plugin, index) => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "cw-plugin-list",
    key: index
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "plugin-detail"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "cw-plugin-title"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_1__.Icon, {
    icon: "pluginList",
    label: plugin.pluginName
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
    className: "description"
  }, plugin.description)), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "insert-button"
  }, buttonState[plugin.slug] === 'Install' && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("button", {
    className: "cw-button-btn outline",
    onClick: () => installPlugin(plugin.slug)
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Install', 'blossom-recipe')), buttonState[plugin.slug] === 'Installing...' && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("button", {
    className: "cw-button-btn outline",
    disabled: true
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Installing...', 'blossom-recipe')), buttonState[plugin.slug] === 'Activate' && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("button", {
    className: "cw-button-btn outline",
    onClick: () => activatePlugin(plugin.slug)
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Activate', 'blossom-recipe')), buttonState[plugin.slug] === 'Activating...' && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("button", {
    className: "cw-button-btn outline",
    disabled: true
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Activating...', 'blossom-recipe')), buttonState[plugin.slug] === 'Activated' && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("button", {
    className: "cw-button-btn primary-btn deactivate",
    disabled: true
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Activated', 'blossom-recipe'))))));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (UsefulPlugins);

/***/ },

/***/ "./src/pages/index.js"
/*!****************************!*\
  !*** ./src/pages/index.js ***!
  \****************************/
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../components */ "./src/components/index.js");
/* harmony import */ var _FreePro__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./FreePro */ "./src/pages/FreePro/index.jsx");
/* harmony import */ var _Home__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Home */ "./src/pages/Home/index.jsx");
/* harmony import */ var _Offers__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./Offers */ "./src/pages/Offers/index.jsx");
/* harmony import */ var _UsefulPlugins__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./UsefulPlugins */ "./src/pages/UsefulPlugins/index.jsx");
/* harmony import */ var _FAQ__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./FAQ */ "./src/pages/FAQ/index.jsx");
/* harmony import */ var _StarterSites__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./StarterSites */ "./src/pages/StarterSites/index.jsx");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_8__);










function Dashboard() {
  const [activeTabTitle, setActiveTabTitle] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)('Home');
  const tabsData = [{
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_8__.__)('Home', 'blossom-recipe'),
    icon: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_1__.Icon, {
      icon: "home"
    }),
    content: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_Home__WEBPACK_IMPORTED_MODULE_3__["default"], null)
  }, {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_8__.__)('Starter Sites', 'blossom-recipe'),
    icon: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_1__.Icon, {
      icon: "globe"
    }),
    content: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_StarterSites__WEBPACK_IMPORTED_MODULE_7__["default"], null)
  }, {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_8__.__)('Free vs Pro', 'blossom-recipe'),
    icon: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_1__.Icon, {
      icon: "freePro"
    }),
    content: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_FreePro__WEBPACK_IMPORTED_MODULE_2__["default"], null)
  }, {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_8__.__)('Offers', 'blossom-recipe'),
    icon: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_1__.Icon, {
      icon: "offers"
    }),
    content: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_Offers__WEBPACK_IMPORTED_MODULE_4__["default"], null)
  }, {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_8__.__)('FAQs', 'blossom-recipe'),
    icon: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_1__.Icon, {
      icon: "support"
    }),
    content: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_FAQ__WEBPACK_IMPORTED_MODULE_6__["default"], null)
  }, {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_8__.__)('Useful Plugins', 'blossom-recipe'),
    icon: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_1__.Icon, {
      icon: "plugins"
    }),
    content: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_UsefulPlugins__WEBPACK_IMPORTED_MODULE_5__["default"], null)
  }];
  const handleTabChange = title => {
    setActiveTabTitle(title);
  };
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_1__.Tab, {
    tabsData: tabsData,
    onChange: handleTabChange,
    activeTabTitle: activeTabTitle
  }));
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Dashboard);

/***/ },

/***/ "./src/scss/style.scss"
/*!*****************************!*\
  !*** ./src/scss/style.scss ***!
  \*****************************/
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ },

/***/ "@wordpress/dom-ready"
/*!**********************************!*\
  !*** external ["wp","domReady"] ***!
  \**********************************/
(module) {

module.exports = window["wp"]["domReady"];

/***/ },

/***/ "@wordpress/element"
/*!*********************************!*\
  !*** external ["wp","element"] ***!
  \*********************************/
(module) {

module.exports = window["wp"]["element"];

/***/ },

/***/ "@wordpress/i18n"
/*!******************************!*\
  !*** external ["wp","i18n"] ***!
  \******************************/
(module) {

module.exports = window["wp"]["i18n"];

/***/ },

/***/ "react"
/*!************************!*\
  !*** external "React" ***!
  \************************/
(module) {

module.exports = window["React"];

/***/ },

/***/ "react-dom"
/*!***************************!*\
  !*** external "ReactDOM" ***!
  \***************************/
(module) {

module.exports = window["ReactDOM"];

/***/ }

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Check if module exists (development only)
/******/ 		if (__webpack_modules__[moduleId] === undefined) {
/******/ 			var e = new Error("Cannot find module '" + moduleId + "'");
/******/ 			e.code = 'MODULE_NOT_FOUND';
/******/ 			throw e;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/compat get default export */
/******/ 	(() => {
/******/ 		// getDefaultExport function for compatibility with non-harmony modules
/******/ 		__webpack_require__.n = (module) => {
/******/ 			var getter = module && module.__esModule ?
/******/ 				() => (module['default']) :
/******/ 				() => (module);
/******/ 			__webpack_require__.d(getter, { a: getter });
/******/ 			return getter;
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/publicPath */
/******/ 	(() => {
/******/ 		var scriptUrl;
/******/ 		if (globalThis.importScripts) scriptUrl = globalThis.location + "";
/******/ 		var document = globalThis.document;
/******/ 		if (!scriptUrl && document) {
/******/ 			if (document.currentScript && document.currentScript.tagName.toUpperCase() === 'SCRIPT')
/******/ 				scriptUrl = document.currentScript.src;
/******/ 			if (!scriptUrl) {
/******/ 				var scripts = document.getElementsByTagName("script");
/******/ 				if(scripts.length) {
/******/ 					var i = scripts.length - 1;
/******/ 					while (i > -1 && (!scriptUrl || !/^http(s?):/.test(scriptUrl))) scriptUrl = scripts[i--].src;
/******/ 				}
/******/ 			}
/******/ 		}
/******/ 		// When supporting browsers where an automatic publicPath is not supported you must specify an output.publicPath manually via configuration
/******/ 		// or pass an empty string ("") and set the __webpack_public_path__ variable from your code to use your own logic.
/******/ 		if (!scriptUrl) throw new Error("Automatic publicPath is not supported in this browser");
/******/ 		scriptUrl = scriptUrl.replace(/^blob:/, "").replace(/#.*$/, "").replace(/\?.*$/, "").replace(/\/[^\/]+$/, "/");
/******/ 		__webpack_require__.p = scriptUrl;
/******/ 	})();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry needs to be wrapped in an IIFE because it needs to be isolated against other modules in the chunk.
(() => {
/*!**********************!*\
  !*** ./src/index.js ***!
  \**********************/
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_dom_ready__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/dom-ready */ "@wordpress/dom-ready");
/* harmony import */ var _wordpress_dom_ready__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_dom_ready__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_router_dom__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react-router-dom */ "./node_modules/react-router-dom/dist/index.js");
/* harmony import */ var _pages__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./pages */ "./src/pages/index.js");
/* harmony import */ var _scss_style_scss__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./scss/style.scss */ "./src/scss/style.scss");






_wordpress_dom_ready__WEBPACK_IMPORTED_MODULE_1___default()(() => {
  const root = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.createRoot)(document.getElementById('cw-dashboard'));
  root.render((0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react_router_dom__WEBPACK_IMPORTED_MODULE_3__.BrowserRouter, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_pages__WEBPACK_IMPORTED_MODULE_4__["default"], null))));
});
})();

/******/ })()
;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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