/******/ (function() { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./node_modules/@remix-run/router/dist/router.js":
/*!*******************************************************!*\
  !*** ./node_modules/@remix-run/router/dist/router.js ***!
  \*******************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AbortedDeferredError: function() { return /* binding */ AbortedDeferredError; },
/* harmony export */   Action: function() { return /* binding */ Action; },
/* harmony export */   IDLE_BLOCKER: function() { return /* binding */ IDLE_BLOCKER; },
/* harmony export */   IDLE_FETCHER: function() { return /* binding */ IDLE_FETCHER; },
/* harmony export */   IDLE_NAVIGATION: function() { return /* binding */ IDLE_NAVIGATION; },
/* harmony export */   UNSAFE_DEFERRED_SYMBOL: function() { return /* binding */ UNSAFE_DEFERRED_SYMBOL; },
/* harmony export */   UNSAFE_DeferredData: function() { return /* binding */ DeferredData; },
/* harmony export */   UNSAFE_ErrorResponseImpl: function() { return /* binding */ ErrorResponseImpl; },
/* harmony export */   UNSAFE_convertRouteMatchToUiMatch: function() { return /* binding */ convertRouteMatchToUiMatch; },
/* harmony export */   UNSAFE_convertRoutesToDataRoutes: function() { return /* binding */ convertRoutesToDataRoutes; },
/* harmony export */   UNSAFE_decodePath: function() { return /* binding */ decodePath; },
/* harmony export */   UNSAFE_getResolveToMatches: function() { return /* binding */ getResolveToMatches; },
/* harmony export */   UNSAFE_invariant: function() { return /* binding */ invariant; },
/* harmony export */   UNSAFE_warning: function() { return /* binding */ warning; },
/* harmony export */   createBrowserHistory: function() { return /* binding */ createBrowserHistory; },
/* harmony export */   createHashHistory: function() { return /* binding */ createHashHistory; },
/* harmony export */   createMemoryHistory: function() { return /* binding */ createMemoryHistory; },
/* harmony export */   createPath: function() { return /* binding */ createPath; },
/* harmony export */   createRouter: function() { return /* binding */ createRouter; },
/* harmony export */   createStaticHandler: function() { return /* binding */ createStaticHandler; },
/* harmony export */   defer: function() { return /* binding */ defer; },
/* harmony export */   generatePath: function() { return /* binding */ generatePath; },
/* harmony export */   getStaticContextFromError: function() { return /* binding */ getStaticContextFromError; },
/* harmony export */   getToPathname: function() { return /* binding */ getToPathname; },
/* harmony export */   isDataWithResponseInit: function() { return /* binding */ isDataWithResponseInit; },
/* harmony export */   isDeferredData: function() { return /* binding */ isDeferredData; },
/* harmony export */   isRouteErrorResponse: function() { return /* binding */ isRouteErrorResponse; },
/* harmony export */   joinPaths: function() { return /* binding */ joinPaths; },
/* harmony export */   json: function() { return /* binding */ json; },
/* harmony export */   matchPath: function() { return /* binding */ matchPath; },
/* harmony export */   matchRoutes: function() { return /* binding */ matchRoutes; },
/* harmony export */   normalizePathname: function() { return /* binding */ normalizePathname; },
/* harmony export */   parsePath: function() { return /* binding */ parsePath; },
/* harmony export */   redirect: function() { return /* binding */ redirect; },
/* harmony export */   redirectDocument: function() { return /* binding */ redirectDocument; },
/* harmony export */   replace: function() { return /* binding */ replace; },
/* harmony export */   resolvePath: function() { return /* binding */ resolvePath; },
/* harmony export */   resolveTo: function() { return /* binding */ resolveTo; },
/* harmony export */   stripBasename: function() { return /* binding */ stripBasename; },
/* harmony export */   unstable_data: function() { return /* binding */ data; }
/* harmony export */ });
/**
 * @remix-run/router v1.19.0
 *
 * Copyright (c) Remix Software Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE.md file in the root directory of this source tree.
 *
 * @license MIT
 */
function _extends() {
  _extends = Object.assign ? Object.assign.bind() : function (target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i];
      for (var key in source) {
        if (Object.prototype.hasOwnProperty.call(source, key)) {
          target[key] = source[key];
        }
      }
    }
    return target;
  };
  return _extends.apply(this, arguments);
}

////////////////////////////////////////////////////////////////////////////////
//#region Types and Constants
////////////////////////////////////////////////////////////////////////////////
/**
 * Actions represent the type of change to a location value.
 */
var Action;
(function (Action) {
  /**
   * A POP indicates a change to an arbitrary index in the history stack, such
   * as a back or forward navigation. It does not describe the direction of the
   * navigation, only that the current index changed.
   *
   * Note: This is the default action for newly created history objects.
   */
  Action["Pop"] = "POP";
  /**
   * A PUSH indicates a new entry being added to the history stack, such as when
   * a link is clicked and a new page loads. When this happens, all subsequent
   * entries in the stack are lost.
   */
  Action["Push"] = "PUSH";
  /**
   * A REPLACE indicates the entry at the current index in the history stack
   * being replaced by a new one.
   */
  Action["Replace"] = "REPLACE";
})(Action || (Action = {}));
const PopStateEventType = "popstate";
/**
 * Memory history stores the current location in memory. It is designed for use
 * in stateful non-browser environments like tests and React Native.
 */
function createMemoryHistory(options) {
  if (options === void 0) {
    options = {};
  }
  let {
    initialEntries = ["/"],
    initialIndex,
    v5Compat = false
  } = options;
  let entries; // Declare so we can access from createMemoryLocation
  entries = initialEntries.map((entry, index) => createMemoryLocation(entry, typeof entry === "string" ? null : entry.state, index === 0 ? "default" : undefined));
  let index = clampIndex(initialIndex == null ? entries.length - 1 : initialIndex);
  let action = Action.Pop;
  let listener = null;
  function clampIndex(n) {
    return Math.min(Math.max(n, 0), entries.length - 1);
  }
  function getCurrentLocation() {
    return entries[index];
  }
  function createMemoryLocation(to, state, key) {
    if (state === void 0) {
      state = null;
    }
    let location = createLocation(entries ? getCurrentLocation().pathname : "/", to, state, key);
    warning(location.pathname.charAt(0) === "/", "relative pathnames are not supported in memory history: " + JSON.stringify(to));
    return location;
  }
  function createHref(to) {
    return typeof to === "string" ? to : createPath(to);
  }
  let history = {
    get index() {
      return index;
    },
    get action() {
      return action;
    },
    get location() {
      return getCurrentLocation();
    },
    createHref,
    createURL(to) {
      return new URL(createHref(to), "http://localhost");
    },
    encodeLocation(to) {
      let path = typeof to === "string" ? parsePath(to) : to;
      return {
        pathname: path.pathname || "",
        search: path.search || "",
        hash: path.hash || ""
      };
    },
    push(to, state) {
      action = Action.Push;
      let nextLocation = createMemoryLocation(to, state);
      index += 1;
      entries.splice(index, entries.length, nextLocation);
      if (v5Compat && listener) {
        listener({
          action,
          location: nextLocation,
          delta: 1
        });
      }
    },
    replace(to, state) {
      action = Action.Replace;
      let nextLocation = createMemoryLocation(to, state);
      entries[index] = nextLocation;
      if (v5Compat && listener) {
        listener({
          action,
          location: nextLocation,
          delta: 0
        });
      }
    },
    go(delta) {
      action = Action.Pop;
      let nextIndex = clampIndex(index + delta);
      let nextLocation = entries[nextIndex];
      index = nextIndex;
      if (listener) {
        listener({
          action,
          location: nextLocation,
          delta
        });
      }
    },
    listen(fn) {
      listener = fn;
      return () => {
        listener = null;
      };
    }
  };
  return history;
}
/**
 * Browser history stores the location in regular URLs. This is the standard for
 * most web apps, but it requires some configuration on the server to ensure you
 * serve the same app at multiple URLs.
 *
 * @see https://github.com/remix-run/history/tree/main/docs/api-reference.md#createbrowserhistory
 */
function createBrowserHistory(options) {
  if (options === void 0) {
    options = {};
  }
  function createBrowserLocation(window, globalHistory) {
    let {
      pathname,
      search,
      hash
    } = window.location;
    return createLocation("", {
      pathname,
      search,
      hash
    },
    // state defaults to `null` because `window.history.state` does
    globalHistory.state && globalHistory.state.usr || null, globalHistory.state && globalHistory.state.key || "default");
  }
  function createBrowserHref(window, to) {
    return typeof to === "string" ? to : createPath(to);
  }
  return getUrlBasedHistory(createBrowserLocation, createBrowserHref, null, options);
}
/**
 * Hash history stores the location in window.location.hash. This makes it ideal
 * for situations where you don't want to send the location to the server for
 * some reason, either because you do cannot configure it or the URL space is
 * reserved for something else.
 *
 * @see https://github.com/remix-run/history/tree/main/docs/api-reference.md#createhashhistory
 */
function createHashHistory(options) {
  if (options === void 0) {
    options = {};
  }
  function createHashLocation(window, globalHistory) {
    let {
      pathname = "/",
      search = "",
      hash = ""
    } = parsePath(window.location.hash.substr(1));
    // Hash URL should always have a leading / just like window.location.pathname
    // does, so if an app ends up at a route like /#something then we add a
    // leading slash so all of our path-matching behaves the same as if it would
    // in a browser router.  This is particularly important when there exists a
    // root splat route (<Route path="*">) since that matches internally against
    // "/*" and we'd expect /#something to 404 in a hash router app.
    if (!pathname.startsWith("/") && !pathname.startsWith(".")) {
      pathname = "/" + pathname;
    }
    return createLocation("", {
      pathname,
      search,
      hash
    },
    // state defaults to `null` because `window.history.state` does
    globalHistory.state && globalHistory.state.usr || null, globalHistory.state && globalHistory.state.key || "default");
  }
  function createHashHref(window, to) {
    let base = window.document.querySelector("base");
    let href = "";
    if (base && base.getAttribute("href")) {
      let url = window.location.href;
      let hashIndex = url.indexOf("#");
      href = hashIndex === -1 ? url : url.slice(0, hashIndex);
    }
    return href + "#" + (typeof to === "string" ? to : createPath(to));
  }
  function validateHashLocation(location, to) {
    warning(location.pathname.charAt(0) === "/", "relative pathnames are not supported in hash history.push(" + JSON.stringify(to) + ")");
  }
  return getUrlBasedHistory(createHashLocation, createHashHref, validateHashLocation, options);
}
function invariant(value, message) {
  if (value === false || value === null || typeof value === "undefined") {
    throw new Error(message);
  }
}
function warning(cond, message) {
  if (!cond) {
    // eslint-disable-next-line no-console
    if (typeof console !== "undefined") console.warn(message);
    try {
      // Welcome to debugging history!
      //
      // This error is thrown as a convenience, so you can more easily
      // find the source for a warning that appears in the console by
      // enabling "pause on exceptions" in your JavaScript debugger.
      throw new Error(message);
      // eslint-disable-next-line no-empty
    } catch (e) {}
  }
}
function createKey() {
  return Math.random().toString(36).substr(2, 8);
}
/**
 * For browser-based histories, we combine the state and key into an object
 */
function getHistoryState(location, index) {
  return {
    usr: location.state,
    key: location.key,
    idx: index
  };
}
/**
 * Creates a Location object with a unique key from the given Path
 */
function createLocation(current, to, state, key) {
  if (state === void 0) {
    state = null;
  }
  let location = _extends({
    pathname: typeof current === "string" ? current : current.pathname,
    search: "",
    hash: ""
  }, typeof to === "string" ? parsePath(to) : to, {
    state,
    // TODO: This could be cleaned up.  push/replace should probably just take
    // full Locations now and avoid the need to run through this flow at all
    // But that's a pretty big refactor to the current test suite so going to
    // keep as is for the time being and just let any incoming keys take precedence
    key: to && to.key || key || createKey()
  });
  return location;
}
/**
 * Creates a string URL path from the given pathname, search, and hash components.
 */
function createPath(_ref) {
  let {
    pathname = "/",
    search = "",
    hash = ""
  } = _ref;
  if (search && search !== "?") pathname += search.charAt(0) === "?" ? search : "?" + search;
  if (hash && hash !== "#") pathname += hash.charAt(0) === "#" ? hash : "#" + hash;
  return pathname;
}
/**
 * Parses a string URL path into its separate pathname, search, and hash components.
 */
function parsePath(path) {
  let parsedPath = {};
  if (path) {
    let hashIndex = path.indexOf("#");
    if (hashIndex >= 0) {
      parsedPath.hash = path.substr(hashIndex);
      path = path.substr(0, hashIndex);
    }
    let searchIndex = path.indexOf("?");
    if (searchIndex >= 0) {
      parsedPath.search = path.substr(searchIndex);
      path = path.substr(0, searchIndex);
    }
    if (path) {
      parsedPath.pathname = path;
    }
  }
  return parsedPath;
}
function getUrlBasedHistory(getLocation, createHref, validateLocation, options) {
  if (options === void 0) {
    options = {};
  }
  let {
    window = document.defaultView,
    v5Compat = false
  } = options;
  let globalHistory = window.history;
  let action = Action.Pop;
  let listener = null;
  let index = getIndex();
  // Index should only be null when we initialize. If not, it's because the
  // user called history.pushState or history.replaceState directly, in which
  // case we should log a warning as it will result in bugs.
  if (index == null) {
    index = 0;
    globalHistory.replaceState(_extends({}, globalHistory.state, {
      idx: index
    }), "");
  }
  function getIndex() {
    let state = globalHistory.state || {
      idx: null
    };
    return state.idx;
  }
  function handlePop() {
    action = Action.Pop;
    let nextIndex = getIndex();
    let delta = nextIndex == null ? null : nextIndex - index;
    index = nextIndex;
    if (listener) {
      listener({
        action,
        location: history.location,
        delta
      });
    }
  }
  function push(to, state) {
    action = Action.Push;
    let location = createLocation(history.location, to, state);
    if (validateLocation) validateLocation(location, to);
    index = getIndex() + 1;
    let historyState = getHistoryState(location, index);
    let url = history.createHref(location);
    // try...catch because iOS limits us to 100 pushState calls :/
    try {
      globalHistory.pushState(historyState, "", url);
    } catch (error) {
      // If the exception is because `state` can't be serialized, let that throw
      // outwards just like a replace call would so the dev knows the cause
      // https://html.spec.whatwg.org/multipage/nav-history-apis.html#shared-history-push/replace-state-steps
      // https://html.spec.whatwg.org/multipage/structured-data.html#structuredserializeinternal
      if (error instanceof DOMException && error.name === "DataCloneError") {
        throw error;
      }
      // They are going to lose state here, but there is no real
      // way to warn them about it since the page will refresh...
      window.location.assign(url);
    }
    if (v5Compat && listener) {
      listener({
        action,
        location: history.location,
        delta: 1
      });
    }
  }
  function replace(to, state) {
    action = Action.Replace;
    let location = createLocation(history.location, to, state);
    if (validateLocation) validateLocation(location, to);
    index = getIndex();
    let historyState = getHistoryState(location, index);
    let url = history.createHref(location);
    globalHistory.replaceState(historyState, "", url);
    if (v5Compat && listener) {
      listener({
        action,
        location: history.location,
        delta: 0
      });
    }
  }
  function createURL(to) {
    // window.location.origin is "null" (the literal string value) in Firefox
    // under certain conditions, notably when serving from a local HTML file
    // See https://bugzilla.mozilla.org/show_bug.cgi?id=878297
    let base = window.location.origin !== "null" ? window.location.origin : window.location.href;
    let href = typeof to === "string" ? to : createPath(to);
    // Treating this as a full URL will strip any trailing spaces so we need to
    // pre-encode them since they might be part of a matching splat param from
    // an ancestor route
    href = href.replace(/ $/, "%20");
    invariant(base, "No window.location.(origin|href) available to create URL for href: " + href);
    return new URL(href, base);
  }
  let history = {
    get action() {
      return action;
    },
    get location() {
      return getLocation(window, globalHistory);
    },
    listen(fn) {
      if (listener) {
        throw new Error("A history only accepts one active listener");
      }
      window.addEventListener(PopStateEventType, handlePop);
      listener = fn;
      return () => {
        window.removeEventListener(PopStateEventType, handlePop);
        listener = null;
      };
    },
    createHref(to) {
      return createHref(window, to);
    },
    createURL,
    encodeLocation(to) {
      // Encode a Location the same way window.location would
      let url = createURL(to);
      return {
        pathname: url.pathname,
        search: url.search,
        hash: url.hash
      };
    },
    push,
    replace,
    go(n) {
      return globalHistory.go(n);
    }
  };
  return history;
}
//#endregion

var ResultType;
(function (ResultType) {
  ResultType["data"] = "data";
  ResultType["deferred"] = "deferred";
  ResultType["redirect"] = "redirect";
  ResultType["error"] = "error";
})(ResultType || (ResultType = {}));
const immutableRouteKeys = new Set(["lazy", "caseSensitive", "path", "id", "index", "children"]);
function isIndexRoute(route) {
  return route.index === true;
}
// Walk the route tree generating unique IDs where necessary, so we are working
// solely with AgnosticDataRouteObject's within the Router
function convertRoutesToDataRoutes(routes, mapRouteProperties, parentPath, manifest) {
  if (parentPath === void 0) {
    parentPath = [];
  }
  if (manifest === void 0) {
    manifest = {};
  }
  return routes.map((route, index) => {
    let treePath = [...parentPath, String(index)];
    let id = typeof route.id === "string" ? route.id : treePath.join("-");
    invariant(route.index !== true || !route.children, "Cannot specify children on an index route");
    invariant(!manifest[id], "Found a route id collision on id \"" + id + "\".  Route " + "id's must be globally unique within Data Router usages");
    if (isIndexRoute(route)) {
      let indexRoute = _extends({}, route, mapRouteProperties(route), {
        id
      });
      manifest[id] = indexRoute;
      return indexRoute;
    } else {
      let pathOrLayoutRoute = _extends({}, route, mapRouteProperties(route), {
        id,
        children: undefined
      });
      manifest[id] = pathOrLayoutRoute;
      if (route.children) {
        pathOrLayoutRoute.children = convertRoutesToDataRoutes(route.children, mapRouteProperties, treePath, manifest);
      }
      return pathOrLayoutRoute;
    }
  });
}
/**
 * Matches the given routes to a location and returns the match data.
 *
 * @see https://reactrouter.com/utils/match-routes
 */
function matchRoutes(routes, locationArg, basename) {
  if (basename === void 0) {
    basename = "/";
  }
  return matchRoutesImpl(routes, locationArg, basename, false);
}
function matchRoutesImpl(routes, locationArg, basename, allowPartial) {
  let location = typeof locationArg === "string" ? parsePath(locationArg) : locationArg;
  let pathname = stripBasename(location.pathname || "/", basename);
  if (pathname == null) {
    return null;
  }
  let branches = flattenRoutes(routes);
  rankRouteBranches(branches);
  let matches = null;
  for (let i = 0; matches == null && i < branches.length; ++i) {
    // Incoming pathnames are generally encoded from either window.location
    // or from router.navigate, but we want to match against the unencoded
    // paths in the route definitions.  Memory router locations won't be
    // encoded here but there also shouldn't be anything to decode so this
    // should be a safe operation.  This avoids needing matchRoutes to be
    // history-aware.
    let decoded = decodePath(pathname);
    matches = matchRouteBranch(branches[i], decoded, allowPartial);
  }
  return matches;
}
function convertRouteMatchToUiMatch(match, loaderData) {
  let {
    route,
    pathname,
    params
  } = match;
  return {
    id: route.id,
    pathname,
    params,
    data: loaderData[route.id],
    handle: route.handle
  };
}
function flattenRoutes(routes, branches, parentsMeta, parentPath) {
  if (branches === void 0) {
    branches = [];
  }
  if (parentsMeta === void 0) {
    parentsMeta = [];
  }
  if (parentPath === void 0) {
    parentPath = "";
  }
  let flattenRoute = (route, index, relativePath) => {
    let meta = {
      relativePath: relativePath === undefined ? route.path || "" : relativePath,
      caseSensitive: route.caseSensitive === true,
      childrenIndex: index,
      route
    };
    if (meta.relativePath.startsWith("/")) {
      invariant(meta.relativePath.startsWith(parentPath), "Absolute route path \"" + meta.relativePath + "\" nested under path " + ("\"" + parentPath + "\" is not valid. An absolute child route path ") + "must start with the combined path of all its parent routes.");
      meta.relativePath = meta.relativePath.slice(parentPath.length);
    }
    let path = joinPaths([parentPath, meta.relativePath]);
    let routesMeta = parentsMeta.concat(meta);
    // Add the children before adding this route to the array, so we traverse the
    // route tree depth-first and child routes appear before their parents in
    // the "flattened" version.
    if (route.children && route.children.length > 0) {
      invariant(
      // Our types know better, but runtime JS may not!
      // @ts-expect-error
      route.index !== true, "Index routes must not have child routes. Please remove " + ("all child routes from route path \"" + path + "\"."));
      flattenRoutes(route.children, branches, routesMeta, path);
    }
    // Routes without a path shouldn't ever match by themselves unless they are
    // index routes, so don't add them to the list of possible branches.
    if (route.path == null && !route.index) {
      return;
    }
    branches.push({
      path,
      score: computeScore(path, route.index),
      routesMeta
    });
  };
  routes.forEach((route, index) => {
    var _route$path;
    // coarse-grain check for optional params
    if (route.path === "" || !((_route$path = route.path) != null && _route$path.includes("?"))) {
      flattenRoute(route, index);
    } else {
      for (let exploded of explodeOptionalSegments(route.path)) {
        flattenRoute(route, index, exploded);
      }
    }
  });
  return branches;
}
/**
 * Computes all combinations of optional path segments for a given path,
 * excluding combinations that are ambiguous and of lower priority.
 *
 * For example, `/one/:two?/three/:four?/:five?` explodes to:
 * - `/one/three`
 * - `/one/:two/three`
 * - `/one/three/:four`
 * - `/one/three/:five`
 * - `/one/:two/three/:four`
 * - `/one/:two/three/:five`
 * - `/one/three/:four/:five`
 * - `/one/:two/three/:four/:five`
 */
function explodeOptionalSegments(path) {
  let segments = path.split("/");
  if (segments.length === 0) return [];
  let [first, ...rest] = segments;
  // Optional path segments are denoted by a trailing `?`
  let isOptional = first.endsWith("?");
  // Compute the corresponding required segment: `foo?` -> `foo`
  let required = first.replace(/\?$/, "");
  if (rest.length === 0) {
    // Intepret empty string as omitting an optional segment
    // `["one", "", "three"]` corresponds to omitting `:two` from `/one/:two?/three` -> `/one/three`
    return isOptional ? [required, ""] : [required];
  }
  let restExploded = explodeOptionalSegments(rest.join("/"));
  let result = [];
  // All child paths with the prefix.  Do this for all children before the
  // optional version for all children, so we get consistent ordering where the
  // parent optional aspect is preferred as required.  Otherwise, we can get
  // child sections interspersed where deeper optional segments are higher than
  // parent optional segments, where for example, /:two would explode _earlier_
  // then /:one.  By always including the parent as required _for all children_
  // first, we avoid this issue
  result.push(...restExploded.map(subpath => subpath === "" ? required : [required, subpath].join("/")));
  // Then, if this is an optional value, add all child versions without
  if (isOptional) {
    result.push(...restExploded);
  }
  // for absolute paths, ensure `/` instead of empty segment
  return result.map(exploded => path.startsWith("/") && exploded === "" ? "/" : exploded);
}
function rankRouteBranches(branches) {
  branches.sort((a, b) => a.score !== b.score ? b.score - a.score // Higher score first
  : compareIndexes(a.routesMeta.map(meta => meta.childrenIndex), b.routesMeta.map(meta => meta.childrenIndex)));
}
const paramRe = /^:[\w-]+$/;
const dynamicSegmentValue = 3;
const indexRouteValue = 2;
const emptySegmentValue = 1;
const staticSegmentValue = 10;
const splatPenalty = -2;
const isSplat = s => s === "*";
function computeScore(path, index) {
  let segments = path.split("/");
  let initialScore = segments.length;
  if (segments.some(isSplat)) {
    initialScore += splatPenalty;
  }
  if (index) {
    initialScore += indexRouteValue;
  }
  return segments.filter(s => !isSplat(s)).reduce((score, segment) => score + (paramRe.test(segment) ? dynamicSegmentValue : segment === "" ? emptySegmentValue : staticSegmentValue), initialScore);
}
function compareIndexes(a, b) {
  let siblings = a.length === b.length && a.slice(0, -1).every((n, i) => n === b[i]);
  return siblings ?
  // If two routes are siblings, we should try to match the earlier sibling
  // first. This allows people to have fine-grained control over the matching
  // behavior by simply putting routes with identical paths in the order they
  // want them tried.
  a[a.length - 1] - b[b.length - 1] :
  // Otherwise, it doesn't really make sense to rank non-siblings by index,
  // so they sort equally.
  0;
}
function matchRouteBranch(branch, pathname, allowPartial) {
  if (allowPartial === void 0) {
    allowPartial = false;
  }
  let {
    routesMeta
  } = branch;
  let matchedParams = {};
  let matchedPathname = "/";
  let matches = [];
  for (let i = 0; i < routesMeta.length; ++i) {
    let meta = routesMeta[i];
    let end = i === routesMeta.length - 1;
    let remainingPathname = matchedPathname === "/" ? pathname : pathname.slice(matchedPathname.length) || "/";
    let match = matchPath({
      path: meta.relativePath,
      caseSensitive: meta.caseSensitive,
      end
    }, remainingPathname);
    let route = meta.route;
    if (!match && end && allowPartial && !routesMeta[routesMeta.length - 1].route.index) {
      match = matchPath({
        path: meta.relativePath,
        caseSensitive: meta.caseSensitive,
        end: false
      }, remainingPathname);
    }
    if (!match) {
      return null;
    }
    Object.assign(matchedParams, match.params);
    matches.push({
      // TODO: Can this as be avoided?
      params: matchedParams,
      pathname: joinPaths([matchedPathname, match.pathname]),
      pathnameBase: normalizePathname(joinPaths([matchedPathname, match.pathnameBase])),
      route
    });
    if (match.pathnameBase !== "/") {
      matchedPathname = joinPaths([matchedPathname, match.pathnameBase]);
    }
  }
  return matches;
}
/**
 * Returns a path with params interpolated.
 *
 * @see https://reactrouter.com/utils/generate-path
 */
function generatePath(originalPath, params) {
  if (params === void 0) {
    params = {};
  }
  let path = originalPath;
  if (path.endsWith("*") && path !== "*" && !path.endsWith("/*")) {
    warning(false, "Route path \"" + path + "\" will be treated as if it were " + ("\"" + path.replace(/\*$/, "/*") + "\" because the `*` character must ") + "always follow a `/` in the pattern. To get rid of this warning, " + ("please change the route path to \"" + path.replace(/\*$/, "/*") + "\"."));
    path = path.replace(/\*$/, "/*");
  }
  // ensure `/` is added at the beginning if the path is absolute
  const prefix = path.startsWith("/") ? "/" : "";
  const stringify = p => p == null ? "" : typeof p === "string" ? p : String(p);
  const segments = path.split(/\/+/).map((segment, index, array) => {
    const isLastSegment = index === array.length - 1;
    // only apply the splat if it's the last segment
    if (isLastSegment && segment === "*") {
      const star = "*";
      // Apply the splat
      return stringify(params[star]);
    }
    const keyMatch = segment.match(/^:([\w-]+)(\??)$/);
    if (keyMatch) {
      const [, key, optional] = keyMatch;
      let param = params[key];
      invariant(optional === "?" || param != null, "Missing \":" + key + "\" param");
      return stringify(param);
    }
    // Remove any optional markers from optional static segments
    return segment.replace(/\?$/g, "");
  })
  // Remove empty segments
  .filter(segment => !!segment);
  return prefix + segments.join("/");
}
/**
 * Performs pattern matching on a URL pathname and returns information about
 * the match.
 *
 * @see https://reactrouter.com/utils/match-path
 */
function matchPath(pattern, pathname) {
  if (typeof pattern === "string") {
    pattern = {
      path: pattern,
      caseSensitive: false,
      end: true
    };
  }
  let [matcher, compiledParams] = compilePath(pattern.path, pattern.caseSensitive, pattern.end);
  let match = pathname.match(matcher);
  if (!match) return null;
  let matchedPathname = match[0];
  let pathnameBase = matchedPathname.replace(/(.)\/+$/, "$1");
  let captureGroups = match.slice(1);
  let params = compiledParams.reduce((memo, _ref, index) => {
    let {
      paramName,
      isOptional
    } = _ref;
    // We need to compute the pathnameBase here using the raw splat value
    // instead of using params["*"] later because it will be decoded then
    if (paramName === "*") {
      let splatValue = captureGroups[index] || "";
      pathnameBase = matchedPathname.slice(0, matchedPathname.length - splatValue.length).replace(/(.)\/+$/, "$1");
    }
    const value = captureGroups[index];
    if (isOptional && !value) {
      memo[paramName] = undefined;
    } else {
      memo[paramName] = (value || "").replace(/%2F/g, "/");
    }
    return memo;
  }, {});
  return {
    params,
    pathname: matchedPathname,
    pathnameBase,
    pattern
  };
}
function compilePath(path, caseSensitive, end) {
  if (caseSensitive === void 0) {
    caseSensitive = false;
  }
  if (end === void 0) {
    end = true;
  }
  warning(path === "*" || !path.endsWith("*") || path.endsWith("/*"), "Route path \"" + path + "\" will be treated as if it were " + ("\"" + path.replace(/\*$/, "/*") + "\" because the `*` character must ") + "always follow a `/` in the pattern. To get rid of this warning, " + ("please change the route path to \"" + path.replace(/\*$/, "/*") + "\"."));
  let params = [];
  let regexpSource = "^" + path.replace(/\/*\*?$/, "") // Ignore trailing / and /*, we'll handle it below
  .replace(/^\/*/, "/") // Make sure it has a leading /
  .replace(/[\\.*+^${}|()[\]]/g, "\\$&") // Escape special regex chars
  .replace(/\/:([\w-]+)(\?)?/g, (_, paramName, isOptional) => {
    params.push({
      paramName,
      isOptional: isOptional != null
    });
    return isOptional ? "/?([^\\/]+)?" : "/([^\\/]+)";
  });
  if (path.endsWith("*")) {
    params.push({
      paramName: "*"
    });
    regexpSource += path === "*" || path === "/*" ? "(.*)$" // Already matched the initial /, just match the rest
    : "(?:\\/(.+)|\\/*)$"; // Don't include the / in params["*"]
  } else if (end) {
    // When matching to the end, ignore trailing slashes
    regexpSource += "\\/*$";
  } else if (path !== "" && path !== "/") {
    // If our path is non-empty and contains anything beyond an initial slash,
    // then we have _some_ form of path in our regex, so we should expect to
    // match only if we find the end of this path segment.  Look for an optional
    // non-captured trailing slash (to match a portion of the URL) or the end
    // of the path (if we've matched to the end).  We used to do this with a
    // word boundary but that gives false positives on routes like
    // /user-preferences since `-` counts as a word boundary.
    regexpSource += "(?:(?=\\/|$))";
  } else ;
  let matcher = new RegExp(regexpSource, caseSensitive ? undefined : "i");
  return [matcher, params];
}
function decodePath(value) {
  try {
    return value.split("/").map(v => decodeURIComponent(v).replace(/\//g, "%2F")).join("/");
  } catch (error) {
    warning(false, "The URL path \"" + value + "\" could not be decoded because it is is a " + "malformed URL segment. This is probably due to a bad percent " + ("encoding (" + error + ")."));
    return value;
  }
}
/**
 * @private
 */
function stripBasename(pathname, basename) {
  if (basename === "/") return pathname;
  if (!pathname.toLowerCase().startsWith(basename.toLowerCase())) {
    return null;
  }
  // We want to leave trailing slash behavior in the user's control, so if they
  // specify a basename with a trailing slash, we should support it
  let startIndex = basename.endsWith("/") ? basename.length - 1 : basename.length;
  let nextChar = pathname.charAt(startIndex);
  if (nextChar && nextChar !== "/") {
    // pathname does not start with basename/
    return null;
  }
  return pathname.slice(startIndex) || "/";
}
/**
 * Returns a resolved path object relative to the given pathname.
 *
 * @see https://reactrouter.com/utils/resolve-path
 */
function resolvePath(to, fromPathname) {
  if (fromPathname === void 0) {
    fromPathname = "/";
  }
  let {
    pathname: toPathname,
    search = "",
    hash = ""
  } = typeof to === "string" ? parsePath(to) : to;
  let pathname = toPathname ? toPathname.startsWith("/") ? toPathname : resolvePathname(toPathname, fromPathname) : fromPathname;
  return {
    pathname,
    search: normalizeSearch(search),
    hash: normalizeHash(hash)
  };
}
function resolvePathname(relativePath, fromPathname) {
  let segments = fromPathname.replace(/\/+$/, "").split("/");
  let relativeSegments = relativePath.split("/");
  relativeSegments.forEach(segment => {
    if (segment === "..") {
      // Keep the root "" segment so the pathname starts at /
      if (segments.length > 1) segments.pop();
    } else if (segment !== ".") {
      segments.push(segment);
    }
  });
  return segments.length > 1 ? segments.join("/") : "/";
}
function getInvalidPathError(char, field, dest, path) {
  return "Cannot include a '" + char + "' character in a manually specified " + ("`to." + field + "` field [" + JSON.stringify(path) + "].  Please separate it out to the ") + ("`to." + dest + "` field. Alternatively you may provide the full path as ") + "a string in <Link to=\"...\"> and the router will parse it for you.";
}
/**
 * @private
 *
 * When processing relative navigation we want to ignore ancestor routes that
 * do not contribute to the path, such that index/pathless layout routes don't
 * interfere.
 *
 * For example, when moving a route element into an index route and/or a
 * pathless layout route, relative link behavior contained within should stay
 * the same.  Both of the following examples should link back to the root:
 *
 *   <Route path="/">
 *     <Route path="accounts" element={<Link to=".."}>
 *   </Route>
 *
 *   <Route path="/">
 *     <Route path="accounts">
 *       <Route element={<AccountsLayout />}>       // <-- Does not contribute
 *         <Route index element={<Link to=".."} />  // <-- Does not contribute
 *       </Route
 *     </Route>
 *   </Route>
 */
function getPathContributingMatches(matches) {
  return matches.filter((match, index) => index === 0 || match.route.path && match.route.path.length > 0);
}
// Return the array of pathnames for the current route matches - used to
// generate the routePathnames input for resolveTo()
function getResolveToMatches(matches, v7_relativeSplatPath) {
  let pathMatches = getPathContributingMatches(matches);
  // When v7_relativeSplatPath is enabled, use the full pathname for the leaf
  // match so we include splat values for "." links.  See:
  // https://github.com/remix-run/react-router/issues/11052#issuecomment-1836589329
  if (v7_relativeSplatPath) {
    return pathMatches.map((match, idx) => idx === pathMatches.length - 1 ? match.pathname : match.pathnameBase);
  }
  return pathMatches.map(match => match.pathnameBase);
}
/**
 * @private
 */
function resolveTo(toArg, routePathnames, locationPathname, isPathRelative) {
  if (isPathRelative === void 0) {
    isPathRelative = false;
  }
  let to;
  if (typeof toArg === "string") {
    to = parsePath(toArg);
  } else {
    to = _extends({}, toArg);
    invariant(!to.pathname || !to.pathname.includes("?"), getInvalidPathError("?", "pathname", "search", to));
    invariant(!to.pathname || !to.pathname.includes("#"), getInvalidPathError("#", "pathname", "hash", to));
    invariant(!to.search || !to.search.includes("#"), getInvalidPathError("#", "search", "hash", to));
  }
  let isEmptyPath = toArg === "" || to.pathname === "";
  let toPathname = isEmptyPath ? "/" : to.pathname;
  let from;
  // Routing is relative to the current pathname if explicitly requested.
  //
  // If a pathname is explicitly provided in `to`, it should be relative to the
  // route context. This is explained in `Note on `<Link to>` values` in our
  // migration guide from v5 as a means of disambiguation between `to` values
  // that begin with `/` and those that do not. However, this is problematic for
  // `to` values that do not provide a pathname. `to` can simply be a search or
  // hash string, in which case we should assume that the navigation is relative
  // to the current location's pathname and *not* the route pathname.
  if (toPathname == null) {
    from = locationPathname;
  } else {
    let routePathnameIndex = routePathnames.length - 1;
    // With relative="route" (the default), each leading .. segment means
    // "go up one route" instead of "go up one URL segment".  This is a key
    // difference from how <a href> works and a major reason we call this a
    // "to" value instead of a "href".
    if (!isPathRelative && toPathname.startsWith("..")) {
      let toSegments = toPathname.split("/");
      while (toSegments[0] === "..") {
        toSegments.shift();
        routePathnameIndex -= 1;
      }
      to.pathname = toSegments.join("/");
    }
    from = routePathnameIndex >= 0 ? routePathnames[routePathnameIndex] : "/";
  }
  let path = resolvePath(to, from);
  // Ensure the pathname has a trailing slash if the original "to" had one
  let hasExplicitTrailingSlash = toPathname && toPathname !== "/" && toPathname.endsWith("/");
  // Or if this was a link to the current path which has a trailing slash
  let hasCurrentTrailingSlash = (isEmptyPath || toPathname === ".") && locationPathname.endsWith("/");
  if (!path.pathname.endsWith("/") && (hasExplicitTrailingSlash || hasCurrentTrailingSlash)) {
    path.pathname += "/";
  }
  return path;
}
/**
 * @private
 */
function getToPathname(to) {
  // Empty strings should be treated the same as / paths
  return to === "" || to.pathname === "" ? "/" : typeof to === "string" ? parsePath(to).pathname : to.pathname;
}
/**
 * @private
 */
const joinPaths = paths => paths.join("/").replace(/\/\/+/g, "/");
/**
 * @private
 */
const normalizePathname = pathname => pathname.replace(/\/+$/, "").replace(/^\/*/, "/");
/**
 * @private
 */
const normalizeSearch = search => !search || search === "?" ? "" : search.startsWith("?") ? search : "?" + search;
/**
 * @private
 */
const normalizeHash = hash => !hash || hash === "#" ? "" : hash.startsWith("#") ? hash : "#" + hash;
/**
 * This is a shortcut for creating `application/json` responses. Converts `data`
 * to JSON and sets the `Content-Type` header.
 */
const json = function json(data, init) {
  if (init === void 0) {
    init = {};
  }
  let responseInit = typeof init === "number" ? {
    status: init
  } : init;
  let headers = new Headers(responseInit.headers);
  if (!headers.has("Content-Type")) {
    headers.set("Content-Type", "application/json; charset=utf-8");
  }
  return new Response(JSON.stringify(data), _extends({}, responseInit, {
    headers
  }));
};
class DataWithResponseInit {
  constructor(data, init) {
    this.type = "DataWithResponseInit";
    this.data = data;
    this.init = init || null;
  }
}
/**
 * Create "responses" that contain `status`/`headers` without forcing
 * serialization into an actual `Response` - used by Remix single fetch
 */
function data(data, init) {
  return new DataWithResponseInit(data, typeof init === "number" ? {
    status: init
  } : init);
}
class AbortedDeferredError extends Error {}
class DeferredData {
  constructor(data, responseInit) {
    this.pendingKeysSet = new Set();
    this.subscribers = new Set();
    this.deferredKeys = [];
    invariant(data && typeof data === "object" && !Array.isArray(data), "defer() only accepts plain objects");
    // Set up an AbortController + Promise we can race against to exit early
    // cancellation
    let reject;
    this.abortPromise = new Promise((_, r) => reject = r);
    this.controller = new AbortController();
    let onAbort = () => reject(new AbortedDeferredError("Deferred data aborted"));
    this.unlistenAbortSignal = () => this.controller.signal.removeEventListener("abort", onAbort);
    this.controller.signal.addEventListener("abort", onAbort);
    this.data = Object.entries(data).reduce((acc, _ref2) => {
      let [key, value] = _ref2;
      return Object.assign(acc, {
        [key]: this.trackPromise(key, value)
      });
    }, {});
    if (this.done) {
      // All incoming values were resolved
      this.unlistenAbortSignal();
    }
    this.init = responseInit;
  }
  trackPromise(key, value) {
    if (!(value instanceof Promise)) {
      return value;
    }
    this.deferredKeys.push(key);
    this.pendingKeysSet.add(key);
    // We store a little wrapper promise that will be extended with
    // _data/_error props upon resolve/reject
    let promise = Promise.race([value, this.abortPromise]).then(data => this.onSettle(promise, key, undefined, data), error => this.onSettle(promise, key, error));
    // Register rejection listeners to avoid uncaught promise rejections on
    // errors or aborted deferred values
    promise.catch(() => {});
    Object.defineProperty(promise, "_tracked", {
      get: () => true
    });
    return promise;
  }
  onSettle(promise, key, error, data) {
    if (this.controller.signal.aborted && error instanceof AbortedDeferredError) {
      this.unlistenAbortSignal();
      Object.defineProperty(promise, "_error", {
        get: () => error
      });
      return Promise.reject(error);
    }
    this.pendingKeysSet.delete(key);
    if (this.done) {
      // Nothing left to abort!
      this.unlistenAbortSignal();
    }
    // If the promise was resolved/rejected with undefined, we'll throw an error as you
    // should always resolve with a value or null
    if (error === undefined && data === undefined) {
      let undefinedError = new Error("Deferred data for key \"" + key + "\" resolved/rejected with `undefined`, " + "you must resolve/reject with a value or `null`.");
      Object.defineProperty(promise, "_error", {
        get: () => undefinedError
      });
      this.emit(false, key);
      return Promise.reject(undefinedError);
    }
    if (data === undefined) {
      Object.defineProperty(promise, "_error", {
        get: () => error
      });
      this.emit(false, key);
      return Promise.reject(error);
    }
    Object.defineProperty(promise, "_data", {
      get: () => data
    });
    this.emit(false, key);
    return data;
  }
  emit(aborted, settledKey) {
    this.subscribers.forEach(subscriber => subscriber(aborted, settledKey));
  }
  subscribe(fn) {
    this.subscribers.add(fn);
    return () => this.subscribers.delete(fn);
  }
  cancel() {
    this.controller.abort();
    this.pendingKeysSet.forEach((v, k) => this.pendingKeysSet.delete(k));
    this.emit(true);
  }
  async resolveData(signal) {
    let aborted = false;
    if (!this.done) {
      let onAbort = () => this.cancel();
      signal.addEventListener("abort", onAbort);
      aborted = await new Promise(resolve => {
        this.subscribe(aborted => {
          signal.removeEventListener("abort", onAbort);
          if (aborted || this.done) {
            resolve(aborted);
          }
        });
      });
    }
    return aborted;
  }
  get done() {
    return this.pendingKeysSet.size === 0;
  }
  get unwrappedData() {
    invariant(this.data !== null && this.done, "Can only unwrap data on initialized and settled deferreds");
    return Object.entries(this.data).reduce((acc, _ref3) => {
      let [key, value] = _ref3;
      return Object.assign(acc, {
        [key]: unwrapTrackedPromise(value)
      });
    }, {});
  }
  get pendingKeys() {
    return Array.from(this.pendingKeysSet);
  }
}
function isTrackedPromise(value) {
  return value instanceof Promise && value._tracked === true;
}
function unwrapTrackedPromise(value) {
  if (!isTrackedPromise(value)) {
    return value;
  }
  if (value._error) {
    throw value._error;
  }
  return value._data;
}
const defer = function defer(data, init) {
  if (init === void 0) {
    init = {};
  }
  let responseInit = typeof init === "number" ? {
    status: init
  } : init;
  return new DeferredData(data, responseInit);
};
/**
 * A redirect response. Sets the status code and the `Location` header.
 * Defaults to "302 Found".
 */
const redirect = function redirect(url, init) {
  if (init === void 0) {
    init = 302;
  }
  let responseInit = init;
  if (typeof responseInit === "number") {
    responseInit = {
      status: responseInit
    };
  } else if (typeof responseInit.status === "undefined") {
    responseInit.status = 302;
  }
  let headers = new Headers(responseInit.headers);
  headers.set("Location", url);
  return new Response(null, _extends({}, responseInit, {
    headers
  }));
};
/**
 * A redirect response that will force a document reload to the new location.
 * Sets the status code and the `Location` header.
 * Defaults to "302 Found".
 */
const redirectDocument = (url, init) => {
  let response = redirect(url, init);
  response.headers.set("X-Remix-Reload-Document", "true");
  return response;
};
/**
 * A redirect response that will perform a `history.replaceState` instead of a
 * `history.pushState` for client-side navigation redirects.
 * Sets the status code and the `Location` header.
 * Defaults to "302 Found".
 */
const replace = (url, init) => {
  let response = redirect(url, init);
  response.headers.set("X-Remix-Replace", "true");
  return response;
};
/**
 * @private
 * Utility class we use to hold auto-unwrapped 4xx/5xx Response bodies
 *
 * We don't export the class for public use since it's an implementation
 * detail, but we export the interface above so folks can build their own
 * abstractions around instances via isRouteErrorResponse()
 */
class ErrorResponseImpl {
  constructor(status, statusText, data, internal) {
    if (internal === void 0) {
      internal = false;
    }
    this.status = status;
    this.statusText = statusText || "";
    this.internal = internal;
    if (data instanceof Error) {
      this.data = data.toString();
      this.error = data;
    } else {
      this.data = data;
    }
  }
}
/**
 * Check if the given error is an ErrorResponse generated from a 4xx/5xx
 * Response thrown from an action/loader
 */
function isRouteErrorResponse(error) {
  return error != null && typeof error.status === "number" && typeof error.statusText === "string" && typeof error.internal === "boolean" && "data" in error;
}

const validMutationMethodsArr = ["post", "put", "patch", "delete"];
const validMutationMethods = new Set(validMutationMethodsArr);
const validRequestMethodsArr = ["get", ...validMutationMethodsArr];
const validRequestMethods = new Set(validRequestMethodsArr);
const redirectStatusCodes = new Set([301, 302, 303, 307, 308]);
const redirectPreserveMethodStatusCodes = new Set([307, 308]);
const IDLE_NAVIGATION = {
  state: "idle",
  location: undefined,
  formMethod: undefined,
  formAction: undefined,
  formEncType: undefined,
  formData: undefined,
  json: undefined,
  text: undefined
};
const IDLE_FETCHER = {
  state: "idle",
  data: undefined,
  formMethod: undefined,
  formAction: undefined,
  formEncType: undefined,
  formData: undefined,
  json: undefined,
  text: undefined
};
const IDLE_BLOCKER = {
  state: "unblocked",
  proceed: undefined,
  reset: undefined,
  location: undefined
};
const ABSOLUTE_URL_REGEX = /^(?:[a-z][a-z0-9+.-]*:|\/\/)/i;
const defaultMapRouteProperties = route => ({
  hasErrorBoundary: Boolean(route.hasErrorBoundary)
});
const TRANSITIONS_STORAGE_KEY = "remix-router-transitions";
//#endregion
////////////////////////////////////////////////////////////////////////////////
//#region createRouter
////////////////////////////////////////////////////////////////////////////////
/**
 * Create a router and listen to history POP navigations
 */
function createRouter(init) {
  const routerWindow = init.window ? init.window : typeof window !== "undefined" ? window : undefined;
  const isBrowser = typeof routerWindow !== "undefined" && typeof routerWindow.document !== "undefined" && typeof routerWindow.document.createElement !== "undefined";
  const isServer = !isBrowser;
  invariant(init.routes.length > 0, "You must provide a non-empty routes array to createRouter");
  let mapRouteProperties;
  if (init.mapRouteProperties) {
    mapRouteProperties = init.mapRouteProperties;
  } else if (init.detectErrorBoundary) {
    // If they are still using the deprecated version, wrap it with the new API
    let detectErrorBoundary = init.detectErrorBoundary;
    mapRouteProperties = route => ({
      hasErrorBoundary: detectErrorBoundary(route)
    });
  } else {
    mapRouteProperties = defaultMapRouteProperties;
  }
  // Routes keyed by ID
  let manifest = {};
  // Routes in tree format for matching
  let dataRoutes = convertRoutesToDataRoutes(init.routes, mapRouteProperties, undefined, manifest);
  let inFlightDataRoutes;
  let basename = init.basename || "/";
  let dataStrategyImpl = init.unstable_dataStrategy || defaultDataStrategy;
  let patchRoutesOnMissImpl = init.unstable_patchRoutesOnMiss;
  // Config driven behavior flags
  let future = _extends({
    v7_fetcherPersist: false,
    v7_normalizeFormMethod: false,
    v7_partialHydration: false,
    v7_prependBasename: false,
    v7_relativeSplatPath: false,
    v7_skipActionErrorRevalidation: false
  }, init.future);
  // Cleanup function for history
  let unlistenHistory = null;
  // Externally-provided functions to call on all state changes
  let subscribers = new Set();
  // Externally-provided object to hold scroll restoration locations during routing
  let savedScrollPositions = null;
  // Externally-provided function to get scroll restoration keys
  let getScrollRestorationKey = null;
  // Externally-provided function to get current scroll position
  let getScrollPosition = null;
  // One-time flag to control the initial hydration scroll restoration.  Because
  // we don't get the saved positions from <ScrollRestoration /> until _after_
  // the initial render, we need to manually trigger a separate updateState to
  // send along the restoreScrollPosition
  // Set to true if we have `hydrationData` since we assume we were SSR'd and that
  // SSR did the initial scroll restoration.
  let initialScrollRestored = init.hydrationData != null;
  let initialMatches = matchRoutes(dataRoutes, init.history.location, basename);
  let initialErrors = null;
  if (initialMatches == null && !patchRoutesOnMissImpl) {
    // If we do not match a user-provided-route, fall back to the root
    // to allow the error boundary to take over
    let error = getInternalRouterError(404, {
      pathname: init.history.location.pathname
    });
    let {
      matches,
      route
    } = getShortCircuitMatches(dataRoutes);
    initialMatches = matches;
    initialErrors = {
      [route.id]: error
    };
  }
  // In SPA apps, if the user provided a patchRoutesOnMiss implementation and
  // our initial match is a splat route, clear them out so we run through lazy
  // discovery on hydration in case there's a more accurate lazy route match.
  // In SSR apps (with `hydrationData`), we expect that the server will send
  // up the proper matched routes so we don't want to run lazy discovery on
  // initial hydration and want to hydrate into the splat route.
  if (initialMatches && !init.hydrationData) {
    let fogOfWar = checkFogOfWar(initialMatches, dataRoutes, init.history.location.pathname);
    if (fogOfWar.active) {
      initialMatches = null;
    }
  }
  let initialized;
  if (!initialMatches) {
    initialized = false;
    initialMatches = [];
    // If partial hydration and fog of war is enabled, we will be running
    // `patchRoutesOnMiss` during hydration so include any partial matches as
    // the initial matches so we can properly render `HydrateFallback`'s
    if (future.v7_partialHydration) {
      let fogOfWar = checkFogOfWar(null, dataRoutes, init.history.location.pathname);
      if (fogOfWar.active && fogOfWar.matches) {
        initialMatches = fogOfWar.matches;
      }
    }
  } else if (initialMatches.some(m => m.route.lazy)) {
    // All initialMatches need to be loaded before we're ready.  If we have lazy
    // functions around still then we'll need to run them in initialize()
    initialized = false;
  } else if (!initialMatches.some(m => m.route.loader)) {
    // If we've got no loaders to run, then we're good to go
    initialized = true;
  } else if (future.v7_partialHydration) {
    // If partial hydration is enabled, we're initialized so long as we were
    // provided with hydrationData for every route with a loader, and no loaders
    // were marked for explicit hydration
    let loaderData = init.hydrationData ? init.hydrationData.loaderData : null;
    let errors = init.hydrationData ? init.hydrationData.errors : null;
    let isRouteInitialized = m => {
      // No loader, nothing to initialize
      if (!m.route.loader) {
        return true;
      }
      // Explicitly opting-in to running on hydration
      if (typeof m.route.loader === "function" && m.route.loader.hydrate === true) {
        return false;
      }
      // Otherwise, initialized if hydrated with data or an error
      return loaderData && loaderData[m.route.id] !== undefined || errors && errors[m.route.id] !== undefined;
    };
    // If errors exist, don't consider routes below the boundary
    if (errors) {
      let idx = initialMatches.findIndex(m => errors[m.route.id] !== undefined);
      initialized = initialMatches.slice(0, idx + 1).every(isRouteInitialized);
    } else {
      initialized = initialMatches.every(isRouteInitialized);
    }
  } else {
    // Without partial hydration - we're initialized if we were provided any
    // hydrationData - which is expected to be complete
    initialized = init.hydrationData != null;
  }
  let router;
  let state = {
    historyAction: init.history.action,
    location: init.history.location,
    matches: initialMatches,
    initialized,
    navigation: IDLE_NAVIGATION,
    // Don't restore on initial updateState() if we were SSR'd
    restoreScrollPosition: init.hydrationData != null ? false : null,
    preventScrollReset: false,
    revalidation: "idle",
    loaderData: init.hydrationData && init.hydrationData.loaderData || {},
    actionData: init.hydrationData && init.hydrationData.actionData || null,
    errors: init.hydrationData && init.hydrationData.errors || initialErrors,
    fetchers: new Map(),
    blockers: new Map()
  };
  // -- Stateful internal variables to manage navigations --
  // Current navigation in progress (to be committed in completeNavigation)
  let pendingAction = Action.Pop;
  // Should the current navigation prevent the scroll reset if scroll cannot
  // be restored?
  let pendingPreventScrollReset = false;
  // AbortController for the active navigation
  let pendingNavigationController;
  // Should the current navigation enable document.startViewTransition?
  let pendingViewTransitionEnabled = false;
  // Store applied view transitions so we can apply them on POP
  let appliedViewTransitions = new Map();
  // Cleanup function for persisting applied transitions to sessionStorage
  let removePageHideEventListener = null;
  // We use this to avoid touching history in completeNavigation if a
  // revalidation is entirely uninterrupted
  let isUninterruptedRevalidation = false;
  // Use this internal flag to force revalidation of all loaders:
  //  - submissions (completed or interrupted)
  //  - useRevalidator()
  //  - X-Remix-Revalidate (from redirect)
  let isRevalidationRequired = false;
  // Use this internal array to capture routes that require revalidation due
  // to a cancelled deferred on action submission
  let cancelledDeferredRoutes = [];
  // Use this internal array to capture fetcher loads that were cancelled by an
  // action navigation and require revalidation
  let cancelledFetcherLoads = new Set();
  // AbortControllers for any in-flight fetchers
  let fetchControllers = new Map();
  // Track loads based on the order in which they started
  let incrementingLoadId = 0;
  // Track the outstanding pending navigation data load to be compared against
  // the globally incrementing load when a fetcher load lands after a completed
  // navigation
  let pendingNavigationLoadId = -1;
  // Fetchers that triggered data reloads as a result of their actions
  let fetchReloadIds = new Map();
  // Fetchers that triggered redirect navigations
  let fetchRedirectIds = new Set();
  // Most recent href/match for fetcher.load calls for fetchers
  let fetchLoadMatches = new Map();
  // Ref-count mounted fetchers so we know when it's ok to clean them up
  let activeFetchers = new Map();
  // Fetchers that have requested a delete when using v7_fetcherPersist,
  // they'll be officially removed after they return to idle
  let deletedFetchers = new Set();
  // Store DeferredData instances for active route matches.  When a
  // route loader returns defer() we stick one in here.  Then, when a nested
  // promise resolves we update loaderData.  If a new navigation starts we
  // cancel active deferreds for eliminated routes.
  let activeDeferreds = new Map();
  // Store blocker functions in a separate Map outside of router state since
  // we don't need to update UI state if they change
  let blockerFunctions = new Map();
  // Map of pending patchRoutesOnMiss() promises (keyed by path/matches) so
  // that we only kick them off once for a given combo
  let pendingPatchRoutes = new Map();
  // Flag to ignore the next history update, so we can revert the URL change on
  // a POP navigation that was blocked by the user without touching router state
  let ignoreNextHistoryUpdate = false;
  // Initialize the router, all side effects should be kicked off from here.
  // Implemented as a Fluent API for ease of:
  //   let router = createRouter(init).initialize();
  function initialize() {
    // If history informs us of a POP navigation, start the navigation but do not update
    // state.  We'll update our own state once the navigation completes
    unlistenHistory = init.history.listen(_ref => {
      let {
        action: historyAction,
        location,
        delta
      } = _ref;
      // Ignore this event if it was just us resetting the URL from a
      // blocked POP navigation
      if (ignoreNextHistoryUpdate) {
        ignoreNextHistoryUpdate = false;
        return;
      }
      warning(blockerFunctions.size === 0 || delta != null, "You are trying to use a blocker on a POP navigation to a location " + "that was not created by @remix-run/router. This will fail silently in " + "production. This can happen if you are navigating outside the router " + "via `window.history.pushState`/`window.location.hash` instead of using " + "router navigation APIs.  This can also happen if you are using " + "createHashRouter and the user manually changes the URL.");
      let blockerKey = shouldBlockNavigation({
        currentLocation: state.location,
        nextLocation: location,
        historyAction
      });
      if (blockerKey && delta != null) {
        // Restore the URL to match the current UI, but don't update router state
        ignoreNextHistoryUpdate = true;
        init.history.go(delta * -1);
        // Put the blocker into a blocked state
        updateBlocker(blockerKey, {
          state: "blocked",
          location,
          proceed() {
            updateBlocker(blockerKey, {
              state: "proceeding",
              proceed: undefined,
              reset: undefined,
              location
            });
            // Re-do the same POP navigation we just blocked
            init.history.go(delta);
          },
          reset() {
            let blockers = new Map(state.blockers);
            blockers.set(blockerKey, IDLE_BLOCKER);
            updateState({
              blockers
            });
          }
        });
        return;
      }
      return startNavigation(historyAction, location);
    });
    if (isBrowser) {
      // FIXME: This feels gross.  How can we cleanup the lines between
      // scrollRestoration/appliedTransitions persistance?
      restoreAppliedTransitions(routerWindow, appliedViewTransitions);
      let _saveAppliedTransitions = () => persistAppliedTransitions(routerWindow, appliedViewTransitions);
      routerWindow.addEventListener("pagehide", _saveAppliedTransitions);
      removePageHideEventListener = () => routerWindow.removeEventListener("pagehide", _saveAppliedTransitions);
    }
    // Kick off initial data load if needed.  Use Pop to avoid modifying history
    // Note we don't do any handling of lazy here.  For SPA's it'll get handled
    // in the normal navigation flow.  For SSR it's expected that lazy modules are
    // resolved prior to router creation since we can't go into a fallbackElement
    // UI for SSR'd apps
    if (!state.initialized) {
      startNavigation(Action.Pop, state.location, {
        initialHydration: true
      });
    }
    return router;
  }
  // Clean up a router and it's side effects
  function dispose() {
    if (unlistenHistory) {
      unlistenHistory();
    }
    if (removePageHideEventListener) {
      removePageHideEventListener();
    }
    subscribers.clear();
    pendingNavigationController && pendingNavigationController.abort();
    state.fetchers.forEach((_, key) => deleteFetcher(key));
    state.blockers.forEach((_, key) => deleteBlocker(key));
  }
  // Subscribe to state updates for the router
  function subscribe(fn) {
    subscribers.add(fn);
    return () => subscribers.delete(fn);
  }
  // Update our state and notify the calling context of the change
  function updateState(newState, opts) {
    if (opts === void 0) {
      opts = {};
    }
    state = _extends({}, state, newState);
    // Prep fetcher cleanup so we can tell the UI which fetcher data entries
    // can be removed
    let completedFetchers = [];
    let deletedFetchersKeys = [];
    if (future.v7_fetcherPersist) {
      state.fetchers.forEach((fetcher, key) => {
        if (fetcher.state === "idle") {
          if (deletedFetchers.has(key)) {
            // Unmounted from the UI and can be totally removed
            deletedFetchersKeys.push(key);
          } else {
            // Returned to idle but still mounted in the UI, so semi-remains for
            // revalidations and such
            completedFetchers.push(key);
          }
        }
      });
    }
    // Iterate over a local copy so that if flushSync is used and we end up
    // removing and adding a new subscriber due to the useCallback dependencies,
    // we don't get ourselves into a loop calling the new subscriber immediately
    [...subscribers].forEach(subscriber => subscriber(state, {
      deletedFetchers: deletedFetchersKeys,
      unstable_viewTransitionOpts: opts.viewTransitionOpts,
      unstable_flushSync: opts.flushSync === true
    }));
    // Remove idle fetchers from state since we only care about in-flight fetchers.
    if (future.v7_fetcherPersist) {
      completedFetchers.forEach(key => state.fetchers.delete(key));
      deletedFetchersKeys.forEach(key => deleteFetcher(key));
    }
  }
  // Complete a navigation returning the state.navigation back to the IDLE_NAVIGATION
  // and setting state.[historyAction/location/matches] to the new route.
  // - Location is a required param
  // - Navigation will always be set to IDLE_NAVIGATION
  // - Can pass any other state in newState
  function completeNavigation(location, newState, _temp) {
    var _location$state, _location$state2;
    let {
      flushSync
    } = _temp === void 0 ? {} : _temp;
    // Deduce if we're in a loading/actionReload state:
    // - We have committed actionData in the store
    // - The current navigation was a mutation submission
    // - We're past the submitting state and into the loading state
    // - The location being loaded is not the result of a redirect
    let isActionReload = state.actionData != null && state.navigation.formMethod != null && isMutationMethod(state.navigation.formMethod) && state.navigation.state === "loading" && ((_location$state = location.state) == null ? void 0 : _location$state._isRedirect) !== true;
    let actionData;
    if (newState.actionData) {
      if (Object.keys(newState.actionData).length > 0) {
        actionData = newState.actionData;
      } else {
        // Empty actionData -> clear prior actionData due to an action error
        actionData = null;
      }
    } else if (isActionReload) {
      // Keep the current data if we're wrapping up the action reload
      actionData = state.actionData;
    } else {
      // Clear actionData on any other completed navigations
      actionData = null;
    }
    // Always preserve any existing loaderData from re-used routes
    let loaderData = newState.loaderData ? mergeLoaderData(state.loaderData, newState.loaderData, newState.matches || [], newState.errors) : state.loaderData;
    // On a successful navigation we can assume we got through all blockers
    // so we can start fresh
    let blockers = state.blockers;
    if (blockers.size > 0) {
      blockers = new Map(blockers);
      blockers.forEach((_, k) => blockers.set(k, IDLE_BLOCKER));
    }
    // Always respect the user flag.  Otherwise don't reset on mutation
    // submission navigations unless they redirect
    let preventScrollReset = pendingPreventScrollReset === true || state.navigation.formMethod != null && isMutationMethod(state.navigation.formMethod) && ((_location$state2 = location.state) == null ? void 0 : _location$state2._isRedirect) !== true;
    // Commit any in-flight routes at the end of the HMR revalidation "navigation"
    if (inFlightDataRoutes) {
      dataRoutes = inFlightDataRoutes;
      inFlightDataRoutes = undefined;
    }
    if (isUninterruptedRevalidation) ; else if (pendingAction === Action.Pop) ; else if (pendingAction === Action.Push) {
      init.history.push(location, location.state);
    } else if (pendingAction === Action.Replace) {
      init.history.replace(location, location.state);
    }
    let viewTransitionOpts;
    // On POP, enable transitions if they were enabled on the original navigation
    if (pendingAction === Action.Pop) {
      // Forward takes precedence so they behave like the original navigation
      let priorPaths = appliedViewTransitions.get(state.location.pathname);
      if (priorPaths && priorPaths.has(location.pathname)) {
        viewTransitionOpts = {
          currentLocation: state.location,
          nextLocation: location
        };
      } else if (appliedViewTransitions.has(location.pathname)) {
        // If we don't have a previous forward nav, assume we're popping back to
        // the new location and enable if that location previously enabled
        viewTransitionOpts = {
          currentLocation: location,
          nextLocation: state.location
        };
      }
    } else if (pendingViewTransitionEnabled) {
      // Store the applied transition on PUSH/REPLACE
      let toPaths = appliedViewTransitions.get(state.location.pathname);
      if (toPaths) {
        toPaths.add(location.pathname);
      } else {
        toPaths = new Set([location.pathname]);
        appliedViewTransitions.set(state.location.pathname, toPaths);
      }
      viewTransitionOpts = {
        currentLocation: state.location,
        nextLocation: location
      };
    }
    updateState(_extends({}, newState, {
      actionData,
      loaderData,
      historyAction: pendingAction,
      location,
      initialized: true,
      navigation: IDLE_NAVIGATION,
      revalidation: "idle",
      restoreScrollPosition: getSavedScrollPosition(location, newState.matches || state.matches),
      preventScrollReset,
      blockers
    }), {
      viewTransitionOpts,
      flushSync: flushSync === true
    });
    // Reset stateful navigation vars
    pendingAction = Action.Pop;
    pendingPreventScrollReset = false;
    pendingViewTransitionEnabled = false;
    isUninterruptedRevalidation = false;
    isRevalidationRequired = false;
    cancelledDeferredRoutes = [];
  }
  // Trigger a navigation event, which can either be a numerical POP or a PUSH
  // replace with an optional submission
  async function navigate(to, opts) {
    if (typeof to === "number") {
      init.history.go(to);
      return;
    }
    let normalizedPath = normalizeTo(state.location, state.matches, basename, future.v7_prependBasename, to, future.v7_relativeSplatPath, opts == null ? void 0 : opts.fromRouteId, opts == null ? void 0 : opts.relative);
    let {
      path,
      submission,
      error
    } = normalizeNavigateOptions(future.v7_normalizeFormMethod, false, normalizedPath, opts);
    let currentLocation = state.location;
    let nextLocation = createLocation(state.location, path, opts && opts.state);
    // When using navigate as a PUSH/REPLACE we aren't reading an already-encoded
    // URL from window.location, so we need to encode it here so the behavior
    // remains the same as POP and non-data-router usages.  new URL() does all
    // the same encoding we'd get from a history.pushState/window.location read
    // without having to touch history
    nextLocation = _extends({}, nextLocation, init.history.encodeLocation(nextLocation));
    let userReplace = opts && opts.replace != null ? opts.replace : undefined;
    let historyAction = Action.Push;
    if (userReplace === true) {
      historyAction = Action.Replace;
    } else if (userReplace === false) ; else if (submission != null && isMutationMethod(submission.formMethod) && submission.formAction === state.location.pathname + state.location.search) {
      // By default on submissions to the current location we REPLACE so that
      // users don't have to double-click the back button to get to the prior
      // location.  If the user redirects to a different location from the
      // action/loader this will be ignored and the redirect will be a PUSH
      historyAction = Action.Replace;
    }
    let preventScrollReset = opts && "preventScrollReset" in opts ? opts.preventScrollReset === true : undefined;
    let flushSync = (opts && opts.unstable_flushSync) === true;
    let blockerKey = shouldBlockNavigation({
      currentLocation,
      nextLocation,
      historyAction
    });
    if (blockerKey) {
      // Put the blocker into a blocked state
      updateBlocker(blockerKey, {
        state: "blocked",
        location: nextLocation,
        proceed() {
          updateBlocker(blockerKey, {
            state: "proceeding",
            proceed: undefined,
            reset: undefined,
            location: nextLocation
          });
          // Send the same navigation through
          navigate(to, opts);
        },
        reset() {
          let blockers = new Map(state.blockers);
          blockers.set(blockerKey, IDLE_BLOCKER);
          updateState({
            blockers
          });
        }
      });
      return;
    }
    return await startNavigation(historyAction, nextLocation, {
      submission,
      // Send through the formData serialization error if we have one so we can
      // render at the right error boundary after we match routes
      pendingError: error,
      preventScrollReset,
      replace: opts && opts.replace,
      enableViewTransition: opts && opts.unstable_viewTransition,
      flushSync
    });
  }
  // Revalidate all current loaders.  If a navigation is in progress or if this
  // is interrupted by a navigation, allow this to "succeed" by calling all
  // loaders during the next loader round
  function revalidate() {
    interruptActiveLoads();
    updateState({
      revalidation: "loading"
    });
    // If we're currently submitting an action, we don't need to start a new
    // navigation, we'll just let the follow up loader execution call all loaders
    if (state.navigation.state === "submitting") {
      return;
    }
    // If we're currently in an idle state, start a new navigation for the current
    // action/location and mark it as uninterrupted, which will skip the history
    // update in completeNavigation
    if (state.navigation.state === "idle") {
      startNavigation(state.historyAction, state.location, {
        startUninterruptedRevalidation: true
      });
      return;
    }
    // Otherwise, if we're currently in a loading state, just start a new
    // navigation to the navigation.location but do not trigger an uninterrupted
    // revalidation so that history correctly updates once the navigation completes
    startNavigation(pendingAction || state.historyAction, state.navigation.location, {
      overrideNavigation: state.navigation
    });
  }
  // Start a navigation to the given action/location.  Can optionally provide a
  // overrideNavigation which will override the normalLoad in the case of a redirect
  // navigation
  async function startNavigation(historyAction, location, opts) {
    // Abort any in-progress navigations and start a new one. Unset any ongoing
    // uninterrupted revalidations unless told otherwise, since we want this
    // new navigation to update history normally
    pendingNavigationController && pendingNavigationController.abort();
    pendingNavigationController = null;
    pendingAction = historyAction;
    isUninterruptedRevalidation = (opts && opts.startUninterruptedRevalidation) === true;
    // Save the current scroll position every time we start a new navigation,
    // and track whether we should reset scroll on completion
    saveScrollPosition(state.location, state.matches);
    pendingPreventScrollReset = (opts && opts.preventScrollReset) === true;
    pendingViewTransitionEnabled = (opts && opts.enableViewTransition) === true;
    let routesToUse = inFlightDataRoutes || dataRoutes;
    let loadingNavigation = opts && opts.overrideNavigation;
    let matches = matchRoutes(routesToUse, location, basename);
    let flushSync = (opts && opts.flushSync) === true;
    let fogOfWar = checkFogOfWar(matches, routesToUse, location.pathname);
    if (fogOfWar.active && fogOfWar.matches) {
      matches = fogOfWar.matches;
    }
    // Short circuit with a 404 on the root error boundary if we match nothing
    if (!matches) {
      let {
        error,
        notFoundMatches,
        route
      } = handleNavigational404(location.pathname);
      completeNavigation(location, {
        matches: notFoundMatches,
        loaderData: {},
        errors: {
          [route.id]: error
        }
      }, {
        flushSync
      });
      return;
    }
    // Short circuit if it's only a hash change and not a revalidation or
    // mutation submission.
    //
    // Ignore on initial page loads because since the initial load will always
    // be "same hash".  For example, on /page#hash and submit a <Form method="post">
    // which will default to a navigation to /page
    if (state.initialized && !isRevalidationRequired && isHashChangeOnly(state.location, location) && !(opts && opts.submission && isMutationMethod(opts.submission.formMethod))) {
      completeNavigation(location, {
        matches
      }, {
        flushSync
      });
      return;
    }
    // Create a controller/Request for this navigation
    pendingNavigationController = new AbortController();
    let request = createClientSideRequest(init.history, location, pendingNavigationController.signal, opts && opts.submission);
    let pendingActionResult;
    if (opts && opts.pendingError) {
      // If we have a pendingError, it means the user attempted a GET submission
      // with binary FormData so assign here and skip to handleLoaders.  That
      // way we handle calling loaders above the boundary etc.  It's not really
      // different from an actionError in that sense.
      pendingActionResult = [findNearestBoundary(matches).route.id, {
        type: ResultType.error,
        error: opts.pendingError
      }];
    } else if (opts && opts.submission && isMutationMethod(opts.submission.formMethod)) {
      // Call action if we received an action submission
      let actionResult = await handleAction(request, location, opts.submission, matches, fogOfWar.active, {
        replace: opts.replace,
        flushSync
      });
      if (actionResult.shortCircuited) {
        return;
      }
      // If we received a 404 from handleAction, it's because we couldn't lazily
      // discover the destination route so we don't want to call loaders
      if (actionResult.pendingActionResult) {
        let [routeId, result] = actionResult.pendingActionResult;
        if (isErrorResult(result) && isRouteErrorResponse(result.error) && result.error.status === 404) {
          pendingNavigationController = null;
          completeNavigation(location, {
            matches: actionResult.matches,
            loaderData: {},
            errors: {
              [routeId]: result.error
            }
          });
          return;
        }
      }
      matches = actionResult.matches || matches;
      pendingActionResult = actionResult.pendingActionResult;
      loadingNavigation = getLoadingNavigation(location, opts.submission);
      flushSync = false;
      // No need to do fog of war matching again on loader execution
      fogOfWar.active = false;
      // Create a GET request for the loaders
      request = createClientSideRequest(init.history, request.url, request.signal);
    }
    // Call loaders
    let {
      shortCircuited,
      matches: updatedMatches,
      loaderData,
      errors
    } = await handleLoaders(request, location, matches, fogOfWar.active, loadingNavigation, opts && opts.submission, opts && opts.fetcherSubmission, opts && opts.replace, opts && opts.initialHydration === true, flushSync, pendingActionResult);
    if (shortCircuited) {
      return;
    }
    // Clean up now that the action/loaders have completed.  Don't clean up if
    // we short circuited because pendingNavigationController will have already
    // been assigned to a new controller for the next navigation
    pendingNavigationController = null;
    completeNavigation(location, _extends({
      matches: updatedMatches || matches
    }, getActionDataForCommit(pendingActionResult), {
      loaderData,
      errors
    }));
  }
  // Call the action matched by the leaf route for this navigation and handle
  // redirects/errors
  async function handleAction(request, location, submission, matches, isFogOfWar, opts) {
    if (opts === void 0) {
      opts = {};
    }
    interruptActiveLoads();
    // Put us in a submitting state
    let navigation = getSubmittingNavigation(location, submission);
    updateState({
      navigation
    }, {
      flushSync: opts.flushSync === true
    });
    if (isFogOfWar) {
      let discoverResult = await discoverRoutes(matches, location.pathname, request.signal);
      if (discoverResult.type === "aborted") {
        return {
          shortCircuited: true
        };
      } else if (discoverResult.type === "error") {
        let {
          boundaryId,
          error
        } = handleDiscoverRouteError(location.pathname, discoverResult);
        return {
          matches: discoverResult.partialMatches,
          pendingActionResult: [boundaryId, {
            type: ResultType.error,
            error
          }]
        };
      } else if (!discoverResult.matches) {
        let {
          notFoundMatches,
          error,
          route
        } = handleNavigational404(location.pathname);
        return {
          matches: notFoundMatches,
          pendingActionResult: [route.id, {
            type: ResultType.error,
            error
          }]
        };
      } else {
        matches = discoverResult.matches;
      }
    }
    // Call our action and get the result
    let result;
    let actionMatch = getTargetMatch(matches, location);
    if (!actionMatch.route.action && !actionMatch.route.lazy) {
      result = {
        type: ResultType.error,
        error: getInternalRouterError(405, {
          method: request.method,
          pathname: location.pathname,
          routeId: actionMatch.route.id
        })
      };
    } else {
      let results = await callDataStrategy("action", request, [actionMatch], matches);
      result = results[0];
      if (request.signal.aborted) {
        return {
          shortCircuited: true
        };
      }
    }
    if (isRedirectResult(result)) {
      let replace;
      if (opts && opts.replace != null) {
        replace = opts.replace;
      } else {
        // If the user didn't explicity indicate replace behavior, replace if
        // we redirected to the exact same location we're currently at to avoid
        // double back-buttons
        let location = normalizeRedirectLocation(result.response.headers.get("Location"), new URL(request.url), basename);
        replace = location === state.location.pathname + state.location.search;
      }
      await startRedirectNavigation(request, result, {
        submission,
        replace
      });
      return {
        shortCircuited: true
      };
    }
    if (isDeferredResult(result)) {
      throw getInternalRouterError(400, {
        type: "defer-action"
      });
    }
    if (isErrorResult(result)) {
      // Store off the pending error - we use it to determine which loaders
      // to call and will commit it when we complete the navigation
      let boundaryMatch = findNearestBoundary(matches, actionMatch.route.id);
      // By default, all submissions to the current location are REPLACE
      // navigations, but if the action threw an error that'll be rendered in
      // an errorElement, we fall back to PUSH so that the user can use the
      // back button to get back to the pre-submission form location to try
      // again
      if ((opts && opts.replace) !== true) {
        pendingAction = Action.Push;
      }
      return {
        matches,
        pendingActionResult: [boundaryMatch.route.id, result]
      };
    }
    return {
      matches,
      pendingActionResult: [actionMatch.route.id, result]
    };
  }
  // Call all applicable loaders for the given matches, handling redirects,
  // errors, etc.
  async function handleLoaders(request, location, matches, isFogOfWar, overrideNavigation, submission, fetcherSubmission, replace, initialHydration, flushSync, pendingActionResult) {
    // Figure out the right navigation we want to use for data loading
    let loadingNavigation = overrideNavigation || getLoadingNavigation(location, submission);
    // If this was a redirect from an action we don't have a "submission" but
    // we have it on the loading navigation so use that if available
    let activeSubmission = submission || fetcherSubmission || getSubmissionFromNavigation(loadingNavigation);
    // If this is an uninterrupted revalidation, we remain in our current idle
    // state.  If not, we need to switch to our loading state and load data,
    // preserving any new action data or existing action data (in the case of
    // a revalidation interrupting an actionReload)
    // If we have partialHydration enabled, then don't update the state for the
    // initial data load since it's not a "navigation"
    let shouldUpdateNavigationState = !isUninterruptedRevalidation && (!future.v7_partialHydration || !initialHydration);
    // When fog of war is enabled, we enter our `loading` state earlier so we
    // can discover new routes during the `loading` state.  We skip this if
    // we've already run actions since we would have done our matching already.
    // If the children() function threw then, we want to proceed with the
    // partial matches it discovered.
    if (isFogOfWar) {
      if (shouldUpdateNavigationState) {
        let actionData = getUpdatedActionData(pendingActionResult);
        updateState(_extends({
          navigation: loadingNavigation
        }, actionData !== undefined ? {
          actionData
        } : {}), {
          flushSync
        });
      }
      let discoverResult = await discoverRoutes(matches, location.pathname, request.signal);
      if (discoverResult.type === "aborted") {
        return {
          shortCircuited: true
        };
      } else if (discoverResult.type === "error") {
        let {
          boundaryId,
          error
        } = handleDiscoverRouteError(location.pathname, discoverResult);
        return {
          matches: discoverResult.partialMatches,
          loaderData: {},
          errors: {
            [boundaryId]: error
          }
        };
      } else if (!discoverResult.matches) {
        let {
          error,
          notFoundMatches,
          route
        } = handleNavigational404(location.pathname);
        return {
          matches: notFoundMatches,
          loaderData: {},
          errors: {
            [route.id]: error
          }
        };
      } else {
        matches = discoverResult.matches;
      }
    }
    let routesToUse = inFlightDataRoutes || dataRoutes;
    let [matchesToLoad, revalidatingFetchers] = getMatchesToLoad(init.history, state, matches, activeSubmission, location, future.v7_partialHydration && initialHydration === true, future.v7_skipActionErrorRevalidation, isRevalidationRequired, cancelledDeferredRoutes, cancelledFetcherLoads, deletedFetchers, fetchLoadMatches, fetchRedirectIds, routesToUse, basename, pendingActionResult);
    // Cancel pending deferreds for no-longer-matched routes or routes we're
    // about to reload.  Note that if this is an action reload we would have
    // already cancelled all pending deferreds so this would be a no-op
    cancelActiveDeferreds(routeId => !(matches && matches.some(m => m.route.id === routeId)) || matchesToLoad && matchesToLoad.some(m => m.route.id === routeId));
    pendingNavigationLoadId = ++incrementingLoadId;
    // Short circuit if we have no loaders to run
    if (matchesToLoad.length === 0 && revalidatingFetchers.length === 0) {
      let updatedFetchers = markFetchRedirectsDone();
      completeNavigation(location, _extends({
        matches,
        loaderData: {},
        // Commit pending error if we're short circuiting
        errors: pendingActionResult && isErrorResult(pendingActionResult[1]) ? {
          [pendingActionResult[0]]: pendingActionResult[1].error
        } : null
      }, getActionDataForCommit(pendingActionResult), updatedFetchers ? {
        fetchers: new Map(state.fetchers)
      } : {}), {
        flushSync
      });
      return {
        shortCircuited: true
      };
    }
    if (shouldUpdateNavigationState) {
      let updates = {};
      if (!isFogOfWar) {
        // Only update navigation/actionNData if we didn't already do it above
        updates.navigation = loadingNavigation;
        let actionData = getUpdatedActionData(pendingActionResult);
        if (actionData !== undefined) {
          updates.actionData = actionData;
        }
      }
      if (revalidatingFetchers.length > 0) {
        updates.fetchers = getUpdatedRevalidatingFetchers(revalidatingFetchers);
      }
      updateState(updates, {
        flushSync
      });
    }
    revalidatingFetchers.forEach(rf => {
      if (fetchControllers.has(rf.key)) {
        abortFetcher(rf.key);
      }
      if (rf.controller) {
        // Fetchers use an independent AbortController so that aborting a fetcher
        // (via deleteFetcher) does not abort the triggering navigation that
        // triggered the revalidation
        fetchControllers.set(rf.key, rf.controller);
      }
    });
    // Proxy navigation abort through to revalidation fetchers
    let abortPendingFetchRevalidations = () => revalidatingFetchers.forEach(f => abortFetcher(f.key));
    if (pendingNavigationController) {
      pendingNavigationController.signal.addEventListener("abort", abortPendingFetchRevalidations);
    }
    let {
      loaderResults,
      fetcherResults
    } = await callLoadersAndMaybeResolveData(state.matches, matches, matchesToLoad, revalidatingFetchers, request);
    if (request.signal.aborted) {
      return {
        shortCircuited: true
      };
    }
    // Clean up _after_ loaders have completed.  Don't clean up if we short
    // circuited because fetchControllers would have been aborted and
    // reassigned to new controllers for the next navigation
    if (pendingNavigationController) {
      pendingNavigationController.signal.removeEventListener("abort", abortPendingFetchRevalidations);
    }
    revalidatingFetchers.forEach(rf => fetchControllers.delete(rf.key));
    // If any loaders returned a redirect Response, start a new REPLACE navigation
    let redirect = findRedirect([...loaderResults, ...fetcherResults]);
    if (redirect) {
      if (redirect.idx >= matchesToLoad.length) {
        // If this redirect came from a fetcher make sure we mark it in
        // fetchRedirectIds so it doesn't get revalidated on the next set of
        // loader executions
        let fetcherKey = revalidatingFetchers[redirect.idx - matchesToLoad.length].key;
        fetchRedirectIds.add(fetcherKey);
      }
      await startRedirectNavigation(request, redirect.result, {
        replace
      });
      return {
        shortCircuited: true
      };
    }
    // Process and commit output from loaders
    let {
      loaderData,
      errors
    } = processLoaderData(state, matches, matchesToLoad, loaderResults, pendingActionResult, revalidatingFetchers, fetcherResults, activeDeferreds);
    // Wire up subscribers to update loaderData as promises settle
    activeDeferreds.forEach((deferredData, routeId) => {
      deferredData.subscribe(aborted => {
        // Note: No need to updateState here since the TrackedPromise on
        // loaderData is stable across resolve/reject
        // Remove this instance if we were aborted or if promises have settled
        if (aborted || deferredData.done) {
          activeDeferreds.delete(routeId);
        }
      });
    });
    // During partial hydration, preserve SSR errors for routes that don't re-run
    if (future.v7_partialHydration && initialHydration && state.errors) {
      Object.entries(state.errors).filter(_ref2 => {
        let [id] = _ref2;
        return !matchesToLoad.some(m => m.route.id === id);
      }).forEach(_ref3 => {
        let [routeId, error] = _ref3;
        errors = Object.assign(errors || {}, {
          [routeId]: error
        });
      });
    }
    let updatedFetchers = markFetchRedirectsDone();
    let didAbortFetchLoads = abortStaleFetchLoads(pendingNavigationLoadId);
    let shouldUpdateFetchers = updatedFetchers || didAbortFetchLoads || revalidatingFetchers.length > 0;
    return _extends({
      matches,
      loaderData,
      errors
    }, shouldUpdateFetchers ? {
      fetchers: new Map(state.fetchers)
    } : {});
  }
  function getUpdatedActionData(pendingActionResult) {
    if (pendingActionResult && !isErrorResult(pendingActionResult[1])) {
      // This is cast to `any` currently because `RouteData`uses any and it
      // would be a breaking change to use any.
      // TODO: v7 - change `RouteData` to use `unknown` instead of `any`
      return {
        [pendingActionResult[0]]: pendingActionResult[1].data
      };
    } else if (state.actionData) {
      if (Object.keys(state.actionData).length === 0) {
        return null;
      } else {
        return state.actionData;
      }
    }
  }
  function getUpdatedRevalidatingFetchers(revalidatingFetchers) {
    revalidatingFetchers.forEach(rf => {
      let fetcher = state.fetchers.get(rf.key);
      let revalidatingFetcher = getLoadingFetcher(undefined, fetcher ? fetcher.data : undefined);
      state.fetchers.set(rf.key, revalidatingFetcher);
    });
    return new Map(state.fetchers);
  }
  // Trigger a fetcher load/submit for the given fetcher key
  function fetch(key, routeId, href, opts) {
    if (isServer) {
      throw new Error("router.fetch() was called during the server render, but it shouldn't be. " + "You are likely calling a useFetcher() method in the body of your component. " + "Try moving it to a useEffect or a callback.");
    }
    if (fetchControllers.has(key)) abortFetcher(key);
    let flushSync = (opts && opts.unstable_flushSync) === true;
    let routesToUse = inFlightDataRoutes || dataRoutes;
    let normalizedPath = normalizeTo(state.location, state.matches, basename, future.v7_prependBasename, href, future.v7_relativeSplatPath, routeId, opts == null ? void 0 : opts.relative);
    let matches = matchRoutes(routesToUse, normalizedPath, basename);
    let fogOfWar = checkFogOfWar(matches, routesToUse, normalizedPath);
    if (fogOfWar.active && fogOfWar.matches) {
      matches = fogOfWar.matches;
    }
    if (!matches) {
      setFetcherError(key, routeId, getInternalRouterError(404, {
        pathname: normalizedPath
      }), {
        flushSync
      });
      return;
    }
    let {
      path,
      submission,
      error
    } = normalizeNavigateOptions(future.v7_normalizeFormMethod, true, normalizedPath, opts);
    if (error) {
      setFetcherError(key, routeId, error, {
        flushSync
      });
      return;
    }
    let match = getTargetMatch(matches, path);
    pendingPreventScrollReset = (opts && opts.preventScrollReset) === true;
    if (submission && isMutationMethod(submission.formMethod)) {
      handleFetcherAction(key, routeId, path, match, matches, fogOfWar.active, flushSync, submission);
      return;
    }
    // Store off the match so we can call it's shouldRevalidate on subsequent
    // revalidations
    fetchLoadMatches.set(key, {
      routeId,
      path
    });
    handleFetcherLoader(key, routeId, path, match, matches, fogOfWar.active, flushSync, submission);
  }
  // Call the action for the matched fetcher.submit(), and then handle redirects,
  // errors, and revalidation
  async function handleFetcherAction(key, routeId, path, match, requestMatches, isFogOfWar, flushSync, submission) {
    interruptActiveLoads();
    fetchLoadMatches.delete(key);
    function detectAndHandle405Error(m) {
      if (!m.route.action && !m.route.lazy) {
        let error = getInternalRouterError(405, {
          method: submission.formMethod,
          pathname: path,
          routeId: routeId
        });
        setFetcherError(key, routeId, error, {
          flushSync
        });
        return true;
      }
      return false;
    }
    if (!isFogOfWar && detectAndHandle405Error(match)) {
      return;
    }
    // Put this fetcher into it's submitting state
    let existingFetcher = state.fetchers.get(key);
    updateFetcherState(key, getSubmittingFetcher(submission, existingFetcher), {
      flushSync
    });
    let abortController = new AbortController();
    let fetchRequest = createClientSideRequest(init.history, path, abortController.signal, submission);
    if (isFogOfWar) {
      let discoverResult = await discoverRoutes(requestMatches, path, fetchRequest.signal);
      if (discoverResult.type === "aborted") {
        return;
      } else if (discoverResult.type === "error") {
        let {
          error
        } = handleDiscoverRouteError(path, discoverResult);
        setFetcherError(key, routeId, error, {
          flushSync
        });
        return;
      } else if (!discoverResult.matches) {
        setFetcherError(key, routeId, getInternalRouterError(404, {
          pathname: path
        }), {
          flushSync
        });
        return;
      } else {
        requestMatches = discoverResult.matches;
        match = getTargetMatch(requestMatches, path);
        if (detectAndHandle405Error(match)) {
          return;
        }
      }
    }
    // Call the action for the fetcher
    fetchControllers.set(key, abortController);
    let originatingLoadId = incrementingLoadId;
    let actionResults = await callDataStrategy("action", fetchRequest, [match], requestMatches);
    let actionResult = actionResults[0];
    if (fetchRequest.signal.aborted) {
      // We can delete this so long as we weren't aborted by our own fetcher
      // re-submit which would have put _new_ controller is in fetchControllers
      if (fetchControllers.get(key) === abortController) {
        fetchControllers.delete(key);
      }
      return;
    }
    // When using v7_fetcherPersist, we don't want errors bubbling up to the UI
    // or redirects processed for unmounted fetchers so we just revert them to
    // idle
    if (future.v7_fetcherPersist && deletedFetchers.has(key)) {
      if (isRedirectResult(actionResult) || isErrorResult(actionResult)) {
        updateFetcherState(key, getDoneFetcher(undefined));
        return;
      }
      // Let SuccessResult's fall through for revalidation
    } else {
      if (isRedirectResult(actionResult)) {
        fetchControllers.delete(key);
        if (pendingNavigationLoadId > originatingLoadId) {
          // A new navigation was kicked off after our action started, so that
          // should take precedence over this redirect navigation.  We already
          // set isRevalidationRequired so all loaders for the new route should
          // fire unless opted out via shouldRevalidate
          updateFetcherState(key, getDoneFetcher(undefined));
          return;
        } else {
          fetchRedirectIds.add(key);
          updateFetcherState(key, getLoadingFetcher(submission));
          return startRedirectNavigation(fetchRequest, actionResult, {
            fetcherSubmission: submission
          });
        }
      }
      // Process any non-redirect errors thrown
      if (isErrorResult(actionResult)) {
        setFetcherError(key, routeId, actionResult.error);
        return;
      }
    }
    if (isDeferredResult(actionResult)) {
      throw getInternalRouterError(400, {
        type: "defer-action"
      });
    }
    // Start the data load for current matches, or the next location if we're
    // in the middle of a navigation
    let nextLocation = state.navigation.location || state.location;
    let revalidationRequest = createClientSideRequest(init.history, nextLocation, abortController.signal);
    let routesToUse = inFlightDataRoutes || dataRoutes;
    let matches = state.navigation.state !== "idle" ? matchRoutes(routesToUse, state.navigation.location, basename) : state.matches;
    invariant(matches, "Didn't find any matches after fetcher action");
    let loadId = ++incrementingLoadId;
    fetchReloadIds.set(key, loadId);
    let loadFetcher = getLoadingFetcher(submission, actionResult.data);
    state.fetchers.set(key, loadFetcher);
    let [matchesToLoad, revalidatingFetchers] = getMatchesToLoad(init.history, state, matches, submission, nextLocation, false, future.v7_skipActionErrorRevalidation, isRevalidationRequired, cancelledDeferredRoutes, cancelledFetcherLoads, deletedFetchers, fetchLoadMatches, fetchRedirectIds, routesToUse, basename, [match.route.id, actionResult]);
    // Put all revalidating fetchers into the loading state, except for the
    // current fetcher which we want to keep in it's current loading state which
    // contains it's action submission info + action data
    revalidatingFetchers.filter(rf => rf.key !== key).forEach(rf => {
      let staleKey = rf.key;
      let existingFetcher = state.fetchers.get(staleKey);
      let revalidatingFetcher = getLoadingFetcher(undefined, existingFetcher ? existingFetcher.data : undefined);
      state.fetchers.set(staleKey, revalidatingFetcher);
      if (fetchControllers.has(staleKey)) {
        abortFetcher(staleKey);
      }
      if (rf.controller) {
        fetchControllers.set(staleKey, rf.controller);
      }
    });
    updateState({
      fetchers: new Map(state.fetchers)
    });
    let abortPendingFetchRevalidations = () => revalidatingFetchers.forEach(rf => abortFetcher(rf.key));
    abortController.signal.addEventListener("abort", abortPendingFetchRevalidations);
    let {
      loaderResults,
      fetcherResults
    } = await callLoadersAndMaybeResolveData(state.matches, matches, matchesToLoad, revalidatingFetchers, revalidationRequest);
    if (abortController.signal.aborted) {
      return;
    }
    abortController.signal.removeEventListener("abort", abortPendingFetchRevalidations);
    fetchReloadIds.delete(key);
    fetchControllers.delete(key);
    revalidatingFetchers.forEach(r => fetchControllers.delete(r.key));
    let redirect = findRedirect([...loaderResults, ...fetcherResults]);
    if (redirect) {
      if (redirect.idx >= matchesToLoad.length) {
        // If this redirect came from a fetcher make sure we mark it in
        // fetchRedirectIds so it doesn't get revalidated on the next set of
        // loader executions
        let fetcherKey = revalidatingFetchers[redirect.idx - matchesToLoad.length].key;
        fetchRedirectIds.add(fetcherKey);
      }
      return startRedirectNavigation(revalidationRequest, redirect.result);
    }
    // Process and commit output from loaders
    let {
      loaderData,
      errors
    } = processLoaderData(state, state.matches, matchesToLoad, loaderResults, undefined, revalidatingFetchers, fetcherResults, activeDeferreds);
    // Since we let revalidations complete even if the submitting fetcher was
    // deleted, only put it back to idle if it hasn't been deleted
    if (state.fetchers.has(key)) {
      let doneFetcher = getDoneFetcher(actionResult.data);
      state.fetchers.set(key, doneFetcher);
    }
    abortStaleFetchLoads(loadId);
    // If we are currently in a navigation loading state and this fetcher is
    // more recent than the navigation, we want the newer data so abort the
    // navigation and complete it with the fetcher data
    if (state.navigation.state === "loading" && loadId > pendingNavigationLoadId) {
      invariant(pendingAction, "Expected pending action");
      pendingNavigationController && pendingNavigationController.abort();
      completeNavigation(state.navigation.location, {
        matches,
        loaderData,
        errors,
        fetchers: new Map(state.fetchers)
      });
    } else {
      // otherwise just update with the fetcher data, preserving any existing
      // loaderData for loaders that did not need to reload.  We have to
      // manually merge here since we aren't going through completeNavigation
      updateState({
        errors,
        loaderData: mergeLoaderData(state.loaderData, loaderData, matches, errors),
        fetchers: new Map(state.fetchers)
      });
      isRevalidationRequired = false;
    }
  }
  // Call the matched loader for fetcher.load(), handling redirects, errors, etc.
  async function handleFetcherLoader(key, routeId, path, match, matches, isFogOfWar, flushSync, submission) {
    let existingFetcher = state.fetchers.get(key);
    updateFetcherState(key, getLoadingFetcher(submission, existingFetcher ? existingFetcher.data : undefined), {
      flushSync
    });
    let abortController = new AbortController();
    let fetchRequest = createClientSideRequest(init.history, path, abortController.signal);
    if (isFogOfWar) {
      let discoverResult = await discoverRoutes(matches, path, fetchRequest.signal);
      if (discoverResult.type === "aborted") {
        return;
      } else if (discoverResult.type === "error") {
        let {
          error
        } = handleDiscoverRouteError(path, discoverResult);
        setFetcherError(key, routeId, error, {
          flushSync
        });
        return;
      } else if (!discoverResult.matches) {
        setFetcherError(key, routeId, getInternalRouterError(404, {
          pathname: path
        }), {
          flushSync
        });
        return;
      } else {
        matches = discoverResult.matches;
        match = getTargetMatch(matches, path);
      }
    }
    // Call the loader for this fetcher route match
    fetchControllers.set(key, abortController);
    let originatingLoadId = incrementingLoadId;
    let results = await callDataStrategy("loader", fetchRequest, [match], matches);
    let result = results[0];
    // Deferred isn't supported for fetcher loads, await everything and treat it
    // as a normal load.  resolveDeferredData will return undefined if this
    // fetcher gets aborted, so we just leave result untouched and short circuit
    // below if that happens
    if (isDeferredResult(result)) {
      result = (await resolveDeferredData(result, fetchRequest.signal, true)) || result;
    }
    // We can delete this so long as we weren't aborted by our our own fetcher
    // re-load which would have put _new_ controller is in fetchControllers
    if (fetchControllers.get(key) === abortController) {
      fetchControllers.delete(key);
    }
    if (fetchRequest.signal.aborted) {
      return;
    }
    // We don't want errors bubbling up or redirects followed for unmounted
    // fetchers, so short circuit here if it was removed from the UI
    if (deletedFetchers.has(key)) {
      updateFetcherState(key, getDoneFetcher(undefined));
      return;
    }
    // If the loader threw a redirect Response, start a new REPLACE navigation
    if (isRedirectResult(result)) {
      if (pendingNavigationLoadId > originatingLoadId) {
        // A new navigation was kicked off after our loader started, so that
        // should take precedence over this redirect navigation
        updateFetcherState(key, getDoneFetcher(undefined));
        return;
      } else {
        fetchRedirectIds.add(key);
        await startRedirectNavigation(fetchRequest, result);
        return;
      }
    }
    // Process any non-redirect errors thrown
    if (isErrorResult(result)) {
      setFetcherError(key, routeId, result.error);
      return;
    }
    invariant(!isDeferredResult(result), "Unhandled fetcher deferred data");
    // Put the fetcher back into an idle state
    updateFetcherState(key, getDoneFetcher(result.data));
  }
  /**
   * Utility function to handle redirects returned from an action or loader.
   * Normally, a redirect "replaces" the navigation that triggered it.  So, for
   * example:
   *
   *  - user is on /a
   *  - user clicks a link to /b
   *  - loader for /b redirects to /c
   *
   * In a non-JS app the browser would track the in-flight navigation to /b and
   * then replace it with /c when it encountered the redirect response.  In
   * the end it would only ever update the URL bar with /c.
   *
   * In client-side routing using pushState/replaceState, we aim to emulate
   * this behavior and we also do not update history until the end of the
   * navigation (including processed redirects).  This means that we never
   * actually touch history until we've processed redirects, so we just use
   * the history action from the original navigation (PUSH or REPLACE).
   */
  async function startRedirectNavigation(request, redirect, _temp2) {
    let {
      submission,
      fetcherSubmission,
      replace
    } = _temp2 === void 0 ? {} : _temp2;
    if (redirect.response.headers.has("X-Remix-Revalidate")) {
      isRevalidationRequired = true;
    }
    let location = redirect.response.headers.get("Location");
    invariant(location, "Expected a Location header on the redirect Response");
    location = normalizeRedirectLocation(location, new URL(request.url), basename);
    let redirectLocation = createLocation(state.location, location, {
      _isRedirect: true
    });
    if (isBrowser) {
      let isDocumentReload = false;
      if (redirect.response.headers.has("X-Remix-Reload-Document")) {
        // Hard reload if the response contained X-Remix-Reload-Document
        isDocumentReload = true;
      } else if (ABSOLUTE_URL_REGEX.test(location)) {
        const url = init.history.createURL(location);
        isDocumentReload =
        // Hard reload if it's an absolute URL to a new origin
        url.origin !== routerWindow.location.origin ||
        // Hard reload if it's an absolute URL that does not match our basename
        stripBasename(url.pathname, basename) == null;
      }
      if (isDocumentReload) {
        if (replace) {
          routerWindow.location.replace(location);
        } else {
          routerWindow.location.assign(location);
        }
        return;
      }
    }
    // There's no need to abort on redirects, since we don't detect the
    // redirect until the action/loaders have settled
    pendingNavigationController = null;
    let redirectHistoryAction = replace === true || redirect.response.headers.has("X-Remix-Replace") ? Action.Replace : Action.Push;
    // Use the incoming submission if provided, fallback on the active one in
    // state.navigation
    let {
      formMethod,
      formAction,
      formEncType
    } = state.navigation;
    if (!submission && !fetcherSubmission && formMethod && formAction && formEncType) {
      submission = getSubmissionFromNavigation(state.navigation);
    }
    // If this was a 307/308 submission we want to preserve the HTTP method and
    // re-submit the GET/POST/PUT/PATCH/DELETE as a submission navigation to the
    // redirected location
    let activeSubmission = submission || fetcherSubmission;
    if (redirectPreserveMethodStatusCodes.has(redirect.response.status) && activeSubmission && isMutationMethod(activeSubmission.formMethod)) {
      await startNavigation(redirectHistoryAction, redirectLocation, {
        submission: _extends({}, activeSubmission, {
          formAction: location
        }),
        // Preserve this flag across redirects
        preventScrollReset: pendingPreventScrollReset
      });
    } else {
      // If we have a navigation submission, we will preserve it through the
      // redirect navigation
      let overrideNavigation = getLoadingNavigation(redirectLocation, submission);
      await startNavigation(redirectHistoryAction, redirectLocation, {
        overrideNavigation,
        // Send fetcher submissions through for shouldRevalidate
        fetcherSubmission,
        // Preserve this flag across redirects
        preventScrollReset: pendingPreventScrollReset
      });
    }
  }
  // Utility wrapper for calling dataStrategy client-side without having to
  // pass around the manifest, mapRouteProperties, etc.
  async function callDataStrategy(type, request, matchesToLoad, matches) {
    try {
      let results = await callDataStrategyImpl(dataStrategyImpl, type, request, matchesToLoad, matches, manifest, mapRouteProperties);
      return await Promise.all(results.map((result, i) => {
        if (isRedirectHandlerResult(result)) {
          let response = result.result;
          return {
            type: ResultType.redirect,
            response: normalizeRelativeRoutingRedirectResponse(response, request, matchesToLoad[i].route.id, matches, basename, future.v7_relativeSplatPath)
          };
        }
        return convertHandlerResultToDataResult(result);
      }));
    } catch (e) {
      // If the outer dataStrategy method throws, just return the error for all
      // matches - and it'll naturally bubble to the root
      return matchesToLoad.map(() => ({
        type: ResultType.error,
        error: e
      }));
    }
  }
  async function callLoadersAndMaybeResolveData(currentMatches, matches, matchesToLoad, fetchersToLoad, request) {
    let [loaderResults, ...fetcherResults] = await Promise.all([matchesToLoad.length ? callDataStrategy("loader", request, matchesToLoad, matches) : [], ...fetchersToLoad.map(f => {
      if (f.matches && f.match && f.controller) {
        let fetcherRequest = createClientSideRequest(init.history, f.path, f.controller.signal);
        return callDataStrategy("loader", fetcherRequest, [f.match], f.matches).then(r => r[0]);
      } else {
        return Promise.resolve({
          type: ResultType.error,
          error: getInternalRouterError(404, {
            pathname: f.path
          })
        });
      }
    })]);
    await Promise.all([resolveDeferredResults(currentMatches, matchesToLoad, loaderResults, loaderResults.map(() => request.signal), false, state.loaderData), resolveDeferredResults(currentMatches, fetchersToLoad.map(f => f.match), fetcherResults, fetchersToLoad.map(f => f.controller ? f.controller.signal : null), true)]);
    return {
      loaderResults,
      fetcherResults
    };
  }
  function interruptActiveLoads() {
    // Every interruption triggers a revalidation
    isRevalidationRequired = true;
    // Cancel pending route-level deferreds and mark cancelled routes for
    // revalidation
    cancelledDeferredRoutes.push(...cancelActiveDeferreds());
    // Abort in-flight fetcher loads
    fetchLoadMatches.forEach((_, key) => {
      if (fetchControllers.has(key)) {
        cancelledFetcherLoads.add(key);
        abortFetcher(key);
      }
    });
  }
  function updateFetcherState(key, fetcher, opts) {
    if (opts === void 0) {
      opts = {};
    }
    state.fetchers.set(key, fetcher);
    updateState({
      fetchers: new Map(state.fetchers)
    }, {
      flushSync: (opts && opts.flushSync) === true
    });
  }
  function setFetcherError(key, routeId, error, opts) {
    if (opts === void 0) {
      opts = {};
    }
    let boundaryMatch = findNearestBoundary(state.matches, routeId);
    deleteFetcher(key);
    updateState({
      errors: {
        [boundaryMatch.route.id]: error
      },
      fetchers: new Map(state.fetchers)
    }, {
      flushSync: (opts && opts.flushSync) === true
    });
  }
  function getFetcher(key) {
    if (future.v7_fetcherPersist) {
      activeFetchers.set(key, (activeFetchers.get(key) || 0) + 1);
      // If this fetcher was previously marked for deletion, unmark it since we
      // have a new instance
      if (deletedFetchers.has(key)) {
        deletedFetchers.delete(key);
      }
    }
    return state.fetchers.get(key) || IDLE_FETCHER;
  }
  function deleteFetcher(key) {
    let fetcher = state.fetchers.get(key);
    // Don't abort the controller if this is a deletion of a fetcher.submit()
    // in it's loading phase since - we don't want to abort the corresponding
    // revalidation and want them to complete and land
    if (fetchControllers.has(key) && !(fetcher && fetcher.state === "loading" && fetchReloadIds.has(key))) {
      abortFetcher(key);
    }
    fetchLoadMatches.delete(key);
    fetchReloadIds.delete(key);
    fetchRedirectIds.delete(key);
    deletedFetchers.delete(key);
    cancelledFetcherLoads.delete(key);
    state.fetchers.delete(key);
  }
  function deleteFetcherAndUpdateState(key) {
    if (future.v7_fetcherPersist) {
      let count = (activeFetchers.get(key) || 0) - 1;
      if (count <= 0) {
        activeFetchers.delete(key);
        deletedFetchers.add(key);
      } else {
        activeFetchers.set(key, count);
      }
    } else {
      deleteFetcher(key);
    }
    updateState({
      fetchers: new Map(state.fetchers)
    });
  }
  function abortFetcher(key) {
    let controller = fetchControllers.get(key);
    invariant(controller, "Expected fetch controller: " + key);
    controller.abort();
    fetchControllers.delete(key);
  }
  function markFetchersDone(keys) {
    for (let key of keys) {
      let fetcher = getFetcher(key);
      let doneFetcher = getDoneFetcher(fetcher.data);
      state.fetchers.set(key, doneFetcher);
    }
  }
  function markFetchRedirectsDone() {
    let doneKeys = [];
    let updatedFetchers = false;
    for (let key of fetchRedirectIds) {
      let fetcher = state.fetchers.get(key);
      invariant(fetcher, "Expected fetcher: " + key);
      if (fetcher.state === "loading") {
        fetchRedirectIds.delete(key);
        doneKeys.push(key);
        updatedFetchers = true;
      }
    }
    markFetchersDone(doneKeys);
    return updatedFetchers;
  }
  function abortStaleFetchLoads(landedId) {
    let yeetedKeys = [];
    for (let [key, id] of fetchReloadIds) {
      if (id < landedId) {
        let fetcher = state.fetchers.get(key);
        invariant(fetcher, "Expected fetcher: " + key);
        if (fetcher.state === "loading") {
          abortFetcher(key);
          fetchReloadIds.delete(key);
          yeetedKeys.push(key);
        }
      }
    }
    markFetchersDone(yeetedKeys);
    return yeetedKeys.length > 0;
  }
  function getBlocker(key, fn) {
    let blocker = state.blockers.get(key) || IDLE_BLOCKER;
    if (blockerFunctions.get(key) !== fn) {
      blockerFunctions.set(key, fn);
    }
    return blocker;
  }
  function deleteBlocker(key) {
    state.blockers.delete(key);
    blockerFunctions.delete(key);
  }
  // Utility function to update blockers, ensuring valid state transitions
  function updateBlocker(key, newBlocker) {
    let blocker = state.blockers.get(key) || IDLE_BLOCKER;
    // Poor mans state machine :)
    // https://mermaid.live/edit#pako:eNqVkc9OwzAMxl8l8nnjAYrEtDIOHEBIgwvKJTReGy3_lDpIqO27k6awMG0XcrLlnz87nwdonESogKXXBuE79rq75XZO3-yHds0RJVuv70YrPlUrCEe2HfrORS3rubqZfuhtpg5C9wk5tZ4VKcRUq88q9Z8RS0-48cE1iHJkL0ugbHuFLus9L6spZy8nX9MP2CNdomVaposqu3fGayT8T8-jJQwhepo_UtpgBQaDEUom04dZhAN1aJBDlUKJBxE1ceB2Smj0Mln-IBW5AFU2dwUiktt_2Qaq2dBfaKdEup85UV7Yd-dKjlnkabl2Pvr0DTkTreM
    invariant(blocker.state === "unblocked" && newBlocker.state === "blocked" || blocker.state === "blocked" && newBlocker.state === "blocked" || blocker.state === "blocked" && newBlocker.state === "proceeding" || blocker.state === "blocked" && newBlocker.state === "unblocked" || blocker.state === "proceeding" && newBlocker.state === "unblocked", "Invalid blocker state transition: " + blocker.state + " -> " + newBlocker.state);
    let blockers = new Map(state.blockers);
    blockers.set(key, newBlocker);
    updateState({
      blockers
    });
  }
  function shouldBlockNavigation(_ref4) {
    let {
      currentLocation,
      nextLocation,
      historyAction
    } = _ref4;
    if (blockerFunctions.size === 0) {
      return;
    }
    // We ony support a single active blocker at the moment since we don't have
    // any compelling use cases for multi-blocker yet
    if (blockerFunctions.size > 1) {
      warning(false, "A router only supports one blocker at a time");
    }
    let entries = Array.from(blockerFunctions.entries());
    let [blockerKey, blockerFunction] = entries[entries.length - 1];
    let blocker = state.blockers.get(blockerKey);
    if (blocker && blocker.state === "proceeding") {
      // If the blocker is currently proceeding, we don't need to re-check
      // it and can let this navigation continue
      return;
    }
    // At this point, we know we're unblocked/blocked so we need to check the
    // user-provided blocker function
    if (blockerFunction({
      currentLocation,
      nextLocation,
      historyAction
    })) {
      return blockerKey;
    }
  }
  function handleNavigational404(pathname) {
    let error = getInternalRouterError(404, {
      pathname
    });
    let routesToUse = inFlightDataRoutes || dataRoutes;
    let {
      matches,
      route
    } = getShortCircuitMatches(routesToUse);
    // Cancel all pending deferred on 404s since we don't keep any routes
    cancelActiveDeferreds();
    return {
      notFoundMatches: matches,
      route,
      error
    };
  }
  function handleDiscoverRouteError(pathname, discoverResult) {
    return {
      boundaryId: findNearestBoundary(discoverResult.partialMatches).route.id,
      error: getInternalRouterError(400, {
        type: "route-discovery",
        pathname,
        message: discoverResult.error != null && "message" in discoverResult.error ? discoverResult.error : String(discoverResult.error)
      })
    };
  }
  function cancelActiveDeferreds(predicate) {
    let cancelledRouteIds = [];
    activeDeferreds.forEach((dfd, routeId) => {
      if (!predicate || predicate(routeId)) {
        // Cancel the deferred - but do not remove from activeDeferreds here -
        // we rely on the subscribers to do that so our tests can assert proper
        // cleanup via _internalActiveDeferreds
        dfd.cancel();
        cancelledRouteIds.push(routeId);
        activeDeferreds.delete(routeId);
      }
    });
    return cancelledRouteIds;
  }
  // Opt in to capturing and reporting scroll positions during navigations,
  // used by the <ScrollRestoration> component
  function enableScrollRestoration(positions, getPosition, getKey) {
    savedScrollPositions = positions;
    getScrollPosition = getPosition;
    getScrollRestorationKey = getKey || null;
    // Perform initial hydration scroll restoration, since we miss the boat on
    // the initial updateState() because we've not yet rendered <ScrollRestoration/>
    // and therefore have no savedScrollPositions available
    if (!initialScrollRestored && state.navigation === IDLE_NAVIGATION) {
      initialScrollRestored = true;
      let y = getSavedScrollPosition(state.location, state.matches);
      if (y != null) {
        updateState({
          restoreScrollPosition: y
        });
      }
    }
    return () => {
      savedScrollPositions = null;
      getScrollPosition = null;
      getScrollRestorationKey = null;
    };
  }
  function getScrollKey(location, matches) {
    if (getScrollRestorationKey) {
      let key = getScrollRestorationKey(location, matches.map(m => convertRouteMatchToUiMatch(m, state.loaderData)));
      return key || location.key;
    }
    return location.key;
  }
  function saveScrollPosition(location, matches) {
    if (savedScrollPositions && getScrollPosition) {
      let key = getScrollKey(location, matches);
      savedScrollPositions[key] = getScrollPosition();
    }
  }
  function getSavedScrollPosition(location, matches) {
    if (savedScrollPositions) {
      let key = getScrollKey(location, matches);
      let y = savedScrollPositions[key];
      if (typeof y === "number") {
        return y;
      }
    }
    return null;
  }
  function checkFogOfWar(matches, routesToUse, pathname) {
    if (patchRoutesOnMissImpl) {
      if (!matches) {
        let fogMatches = matchRoutesImpl(routesToUse, pathname, basename, true);
        return {
          active: true,
          matches: fogMatches || []
        };
      } else {
        let leafRoute = matches[matches.length - 1].route;
        if (leafRoute.path && (leafRoute.path === "*" || leafRoute.path.endsWith("/*"))) {
          // If we matched a splat, it might only be because we haven't yet fetched
          // the children that would match with a higher score, so let's fetch
          // around and find out
          let partialMatches = matchRoutesImpl(routesToUse, pathname, basename, true);
          return {
            active: true,
            matches: partialMatches
          };
        }
      }
    }
    return {
      active: false,
      matches: null
    };
  }
  async function discoverRoutes(matches, pathname, signal) {
    let partialMatches = matches;
    let route = partialMatches.length > 0 ? partialMatches[partialMatches.length - 1].route : null;
    while (true) {
      let isNonHMR = inFlightDataRoutes == null;
      let routesToUse = inFlightDataRoutes || dataRoutes;
      try {
        await loadLazyRouteChildren(patchRoutesOnMissImpl, pathname, partialMatches, routesToUse, manifest, mapRouteProperties, pendingPatchRoutes, signal);
      } catch (e) {
        return {
          type: "error",
          error: e,
          partialMatches
        };
      } finally {
        // If we are not in the middle of an HMR revalidation and we changed the
        // routes, provide a new identity so when we `updateState` at the end of
        // this navigation/fetch `router.routes` will be a new identity and
        // trigger a re-run of memoized `router.routes` dependencies.
        // HMR will already update the identity and reflow when it lands
        // `inFlightDataRoutes` in `completeNavigation`
        if (isNonHMR) {
          dataRoutes = [...dataRoutes];
        }
      }
      if (signal.aborted) {
        return {
          type: "aborted"
        };
      }
      let newMatches = matchRoutes(routesToUse, pathname, basename);
      let matchedSplat = false;
      if (newMatches) {
        let leafRoute = newMatches[newMatches.length - 1].route;
        if (leafRoute.index) {
          // If we found an index route, we can stop
          return {
            type: "success",
            matches: newMatches
          };
        }
        if (leafRoute.path && leafRoute.path.length > 0) {
          if (leafRoute.path === "*") {
            // If we found a splat route, we can't be sure there's not a
            // higher-scoring route down some partial matches trail so we need
            // to check that out
            matchedSplat = true;
          } else {
            // If we found a non-splat route, we can stop
            return {
              type: "success",
              matches: newMatches
            };
          }
        }
      }
      let newPartialMatches = matchRoutesImpl(routesToUse, pathname, basename, true);
      // If we are no longer partially matching anything, this was either a
      // legit splat match above, or it's a 404.  Also avoid loops if the
      // second pass results in the same partial matches
      if (!newPartialMatches || partialMatches.map(m => m.route.id).join("-") === newPartialMatches.map(m => m.route.id).join("-")) {
        return {
          type: "success",
          matches: matchedSplat ? newMatches : null
        };
      }
      partialMatches = newPartialMatches;
      route = partialMatches[partialMatches.length - 1].route;
      if (route.path === "*") {
        // The splat is still our most accurate partial, so run with it
        return {
          type: "success",
          matches: partialMatches
        };
      }
    }
  }
  function _internalSetRoutes(newRoutes) {
    manifest = {};
    inFlightDataRoutes = convertRoutesToDataRoutes(newRoutes, mapRouteProperties, undefined, manifest);
  }
  function patchRoutes(routeId, children) {
    let isNonHMR = inFlightDataRoutes == null;
    let routesToUse = inFlightDataRoutes || dataRoutes;
    patchRoutesImpl(routeId, children, routesToUse, manifest, mapRouteProperties);
    // If we are not in the middle of an HMR revalidation and we changed the
    // routes, provide a new identity and trigger a reflow via `updateState`
    // to re-run memoized `router.routes` dependencies.
    // HMR will already update the identity and reflow when it lands
    // `inFlightDataRoutes` in `completeNavigation`
    if (isNonHMR) {
      dataRoutes = [...dataRoutes];
      updateState({});
    }
  }
  router = {
    get basename() {
      return basename;
    },
    get future() {
      return future;
    },
    get state() {
      return state;
    },
    get routes() {
      return dataRoutes;
    },
    get window() {
      return routerWindow;
    },
    initialize,
    subscribe,
    enableScrollRestoration,
    navigate,
    fetch,
    revalidate,
    // Passthrough to history-aware createHref used by useHref so we get proper
    // hash-aware URLs in DOM paths
    createHref: to => init.history.createHref(to),
    encodeLocation: to => init.history.encodeLocation(to),
    getFetcher,
    deleteFetcher: deleteFetcherAndUpdateState,
    dispose,
    getBlocker,
    deleteBlocker,
    patchRoutes,
    _internalFetchControllers: fetchControllers,
    _internalActiveDeferreds: activeDeferreds,
    // TODO: Remove setRoutes, it's temporary to avoid dealing with
    // updating the tree while validating the update algorithm.
    _internalSetRoutes
  };
  return router;
}
//#endregion
////////////////////////////////////////////////////////////////////////////////
//#region createStaticHandler
////////////////////////////////////////////////////////////////////////////////
const UNSAFE_DEFERRED_SYMBOL = Symbol("deferred");
function createStaticHandler(routes, opts) {
  invariant(routes.length > 0, "You must provide a non-empty routes array to createStaticHandler");
  let manifest = {};
  let basename = (opts ? opts.basename : null) || "/";
  let mapRouteProperties;
  if (opts != null && opts.mapRouteProperties) {
    mapRouteProperties = opts.mapRouteProperties;
  } else if (opts != null && opts.detectErrorBoundary) {
    // If they are still using the deprecated version, wrap it with the new API
    let detectErrorBoundary = opts.detectErrorBoundary;
    mapRouteProperties = route => ({
      hasErrorBoundary: detectErrorBoundary(route)
    });
  } else {
    mapRouteProperties = defaultMapRouteProperties;
  }
  // Config driven behavior flags
  let future = _extends({
    v7_relativeSplatPath: false,
    v7_throwAbortReason: false
  }, opts ? opts.future : null);
  let dataRoutes = convertRoutesToDataRoutes(routes, mapRouteProperties, undefined, manifest);
  /**
   * The query() method is intended for document requests, in which we want to
   * call an optional action and potentially multiple loaders for all nested
   * routes.  It returns a StaticHandlerContext object, which is very similar
   * to the router state (location, loaderData, actionData, errors, etc.) and
   * also adds SSR-specific information such as the statusCode and headers
   * from action/loaders Responses.
   *
   * It _should_ never throw and should report all errors through the
   * returned context.errors object, properly associating errors to their error
   * boundary.  Additionally, it tracks _deepestRenderedBoundaryId which can be
   * used to emulate React error boundaries during SSr by performing a second
   * pass only down to the boundaryId.
   *
   * The one exception where we do not return a StaticHandlerContext is when a
   * redirect response is returned or thrown from any action/loader.  We
   * propagate that out and return the raw Response so the HTTP server can
   * return it directly.
   *
   * - `opts.requestContext` is an optional server context that will be passed
   *   to actions/loaders in the `context` parameter
   * - `opts.skipLoaderErrorBubbling` is an optional parameter that will prevent
   *   the bubbling of errors which allows single-fetch-type implementations
   *   where the client will handle the bubbling and we may need to return data
   *   for the handling route
   */
  async function query(request, _temp3) {
    let {
      requestContext,
      skipLoaderErrorBubbling,
      unstable_dataStrategy
    } = _temp3 === void 0 ? {} : _temp3;
    let url = new URL(request.url);
    let method = request.method;
    let location = createLocation("", createPath(url), null, "default");
    let matches = matchRoutes(dataRoutes, location, basename);
    // SSR supports HEAD requests while SPA doesn't
    if (!isValidMethod(method) && method !== "HEAD") {
      let error = getInternalRouterError(405, {
        method
      });
      let {
        matches: methodNotAllowedMatches,
        route
      } = getShortCircuitMatches(dataRoutes);
      return {
        basename,
        location,
        matches: methodNotAllowedMatches,
        loaderData: {},
        actionData: null,
        errors: {
          [route.id]: error
        },
        statusCode: error.status,
        loaderHeaders: {},
        actionHeaders: {},
        activeDeferreds: null
      };
    } else if (!matches) {
      let error = getInternalRouterError(404, {
        pathname: location.pathname
      });
      let {
        matches: notFoundMatches,
        route
      } = getShortCircuitMatches(dataRoutes);
      return {
        basename,
        location,
        matches: notFoundMatches,
        loaderData: {},
        actionData: null,
        errors: {
          [route.id]: error
        },
        statusCode: error.status,
        loaderHeaders: {},
        actionHeaders: {},
        activeDeferreds: null
      };
    }
    let result = await queryImpl(request, location, matches, requestContext, unstable_dataStrategy || null, skipLoaderErrorBubbling === true, null);
    if (isResponse(result)) {
      return result;
    }
    // When returning StaticHandlerContext, we patch back in the location here
    // since we need it for React Context.  But this helps keep our submit and
    // loadRouteData operating on a Request instead of a Location
    return _extends({
      location,
      basename
    }, result);
  }
  /**
   * The queryRoute() method is intended for targeted route requests, either
   * for fetch ?_data requests or resource route requests.  In this case, we
   * are only ever calling a single action or loader, and we are returning the
   * returned value directly.  In most cases, this will be a Response returned
   * from the action/loader, but it may be a primitive or other value as well -
   * and in such cases the calling context should handle that accordingly.
   *
   * We do respect the throw/return differentiation, so if an action/loader
   * throws, then this method will throw the value.  This is important so we
   * can do proper boundary identification in Remix where a thrown Response
   * must go to the Catch Boundary but a returned Response is happy-path.
   *
   * One thing to note is that any Router-initiated Errors that make sense
   * to associate with a status code will be thrown as an ErrorResponse
   * instance which include the raw Error, such that the calling context can
   * serialize the error as they see fit while including the proper response
   * code.  Examples here are 404 and 405 errors that occur prior to reaching
   * any user-defined loaders.
   *
   * - `opts.routeId` allows you to specify the specific route handler to call.
   *   If not provided the handler will determine the proper route by matching
   *   against `request.url`
   * - `opts.requestContext` is an optional server context that will be passed
   *    to actions/loaders in the `context` parameter
   */
  async function queryRoute(request, _temp4) {
    let {
      routeId,
      requestContext,
      unstable_dataStrategy
    } = _temp4 === void 0 ? {} : _temp4;
    let url = new URL(request.url);
    let method = request.method;
    let location = createLocation("", createPath(url), null, "default");
    let matches = matchRoutes(dataRoutes, location, basename);
    // SSR supports HEAD requests while SPA doesn't
    if (!isValidMethod(method) && method !== "HEAD" && method !== "OPTIONS") {
      throw getInternalRouterError(405, {
        method
      });
    } else if (!matches) {
      throw getInternalRouterError(404, {
        pathname: location.pathname
      });
    }
    let match = routeId ? matches.find(m => m.route.id === routeId) : getTargetMatch(matches, location);
    if (routeId && !match) {
      throw getInternalRouterError(403, {
        pathname: location.pathname,
        routeId
      });
    } else if (!match) {
      // This should never hit I don't think?
      throw getInternalRouterError(404, {
        pathname: location.pathname
      });
    }
    let result = await queryImpl(request, location, matches, requestContext, unstable_dataStrategy || null, false, match);
    if (isResponse(result)) {
      return result;
    }
    let error = result.errors ? Object.values(result.errors)[0] : undefined;
    if (error !== undefined) {
      // If we got back result.errors, that means the loader/action threw
      // _something_ that wasn't a Response, but it's not guaranteed/required
      // to be an `instanceof Error` either, so we have to use throw here to
      // preserve the "error" state outside of queryImpl.
      throw error;
    }
    // Pick off the right state value to return
    if (result.actionData) {
      return Object.values(result.actionData)[0];
    }
    if (result.loaderData) {
      var _result$activeDeferre;
      let data = Object.values(result.loaderData)[0];
      if ((_result$activeDeferre = result.activeDeferreds) != null && _result$activeDeferre[match.route.id]) {
        data[UNSAFE_DEFERRED_SYMBOL] = result.activeDeferreds[match.route.id];
      }
      return data;
    }
    return undefined;
  }
  async function queryImpl(request, location, matches, requestContext, unstable_dataStrategy, skipLoaderErrorBubbling, routeMatch) {
    invariant(request.signal, "query()/queryRoute() requests must contain an AbortController signal");
    try {
      if (isMutationMethod(request.method.toLowerCase())) {
        let result = await submit(request, matches, routeMatch || getTargetMatch(matches, location), requestContext, unstable_dataStrategy, skipLoaderErrorBubbling, routeMatch != null);
        return result;
      }
      let result = await loadRouteData(request, matches, requestContext, unstable_dataStrategy, skipLoaderErrorBubbling, routeMatch);
      return isResponse(result) ? result : _extends({}, result, {
        actionData: null,
        actionHeaders: {}
      });
    } catch (e) {
      // If the user threw/returned a Response in callLoaderOrAction for a
      // `queryRoute` call, we throw the `HandlerResult` to bail out early
      // and then return or throw the raw Response here accordingly
      if (isHandlerResult(e) && isResponse(e.result)) {
        if (e.type === ResultType.error) {
          throw e.result;
        }
        return e.result;
      }
      // Redirects are always returned since they don't propagate to catch
      // boundaries
      if (isRedirectResponse(e)) {
        return e;
      }
      throw e;
    }
  }
  async function submit(request, matches, actionMatch, requestContext, unstable_dataStrategy, skipLoaderErrorBubbling, isRouteRequest) {
    let result;
    if (!actionMatch.route.action && !actionMatch.route.lazy) {
      let error = getInternalRouterError(405, {
        method: request.method,
        pathname: new URL(request.url).pathname,
        routeId: actionMatch.route.id
      });
      if (isRouteRequest) {
        throw error;
      }
      result = {
        type: ResultType.error,
        error
      };
    } else {
      let results = await callDataStrategy("action", request, [actionMatch], matches, isRouteRequest, requestContext, unstable_dataStrategy);
      result = results[0];
      if (request.signal.aborted) {
        throwStaticHandlerAbortedError(request, isRouteRequest, future);
      }
    }
    if (isRedirectResult(result)) {
      // Uhhhh - this should never happen, we should always throw these from
      // callLoaderOrAction, but the type narrowing here keeps TS happy and we
      // can get back on the "throw all redirect responses" train here should
      // this ever happen :/
      throw new Response(null, {
        status: result.response.status,
        headers: {
          Location: result.response.headers.get("Location")
        }
      });
    }
    if (isDeferredResult(result)) {
      let error = getInternalRouterError(400, {
        type: "defer-action"
      });
      if (isRouteRequest) {
        throw error;
      }
      result = {
        type: ResultType.error,
        error
      };
    }
    if (isRouteRequest) {
      // Note: This should only be non-Response values if we get here, since
      // isRouteRequest should throw any Response received in callLoaderOrAction
      if (isErrorResult(result)) {
        throw result.error;
      }
      return {
        matches: [actionMatch],
        loaderData: {},
        actionData: {
          [actionMatch.route.id]: result.data
        },
        errors: null,
        // Note: statusCode + headers are unused here since queryRoute will
        // return the raw Response or value
        statusCode: 200,
        loaderHeaders: {},
        actionHeaders: {},
        activeDeferreds: null
      };
    }
    // Create a GET request for the loaders
    let loaderRequest = new Request(request.url, {
      headers: request.headers,
      redirect: request.redirect,
      signal: request.signal
    });
    if (isErrorResult(result)) {
      // Store off the pending error - we use it to determine which loaders
      // to call and will commit it when we complete the navigation
      let boundaryMatch = skipLoaderErrorBubbling ? actionMatch : findNearestBoundary(matches, actionMatch.route.id);
      let context = await loadRouteData(loaderRequest, matches, requestContext, unstable_dataStrategy, skipLoaderErrorBubbling, null, [boundaryMatch.route.id, result]);
      // action status codes take precedence over loader status codes
      return _extends({}, context, {
        statusCode: isRouteErrorResponse(result.error) ? result.error.status : result.statusCode != null ? result.statusCode : 500,
        actionData: null,
        actionHeaders: _extends({}, result.headers ? {
          [actionMatch.route.id]: result.headers
        } : {})
      });
    }
    let context = await loadRouteData(loaderRequest, matches, requestContext, unstable_dataStrategy, skipLoaderErrorBubbling, null);
    return _extends({}, context, {
      actionData: {
        [actionMatch.route.id]: result.data
      }
    }, result.statusCode ? {
      statusCode: result.statusCode
    } : {}, {
      actionHeaders: result.headers ? {
        [actionMatch.route.id]: result.headers
      } : {}
    });
  }
  async function loadRouteData(request, matches, requestContext, unstable_dataStrategy, skipLoaderErrorBubbling, routeMatch, pendingActionResult) {
    let isRouteRequest = routeMatch != null;
    // Short circuit if we have no loaders to run (queryRoute())
    if (isRouteRequest && !(routeMatch != null && routeMatch.route.loader) && !(routeMatch != null && routeMatch.route.lazy)) {
      throw getInternalRouterError(400, {
        method: request.method,
        pathname: new URL(request.url).pathname,
        routeId: routeMatch == null ? void 0 : routeMatch.route.id
      });
    }
    let requestMatches = routeMatch ? [routeMatch] : pendingActionResult && isErrorResult(pendingActionResult[1]) ? getLoaderMatchesUntilBoundary(matches, pendingActionResult[0]) : matches;
    let matchesToLoad = requestMatches.filter(m => m.route.loader || m.route.lazy);
    // Short circuit if we have no loaders to run (query())
    if (matchesToLoad.length === 0) {
      return {
        matches,
        // Add a null for all matched routes for proper revalidation on the client
        loaderData: matches.reduce((acc, m) => Object.assign(acc, {
          [m.route.id]: null
        }), {}),
        errors: pendingActionResult && isErrorResult(pendingActionResult[1]) ? {
          [pendingActionResult[0]]: pendingActionResult[1].error
        } : null,
        statusCode: 200,
        loaderHeaders: {},
        activeDeferreds: null
      };
    }
    let results = await callDataStrategy("loader", request, matchesToLoad, matches, isRouteRequest, requestContext, unstable_dataStrategy);
    if (request.signal.aborted) {
      throwStaticHandlerAbortedError(request, isRouteRequest, future);
    }
    // Process and commit output from loaders
    let activeDeferreds = new Map();
    let context = processRouteLoaderData(matches, matchesToLoad, results, pendingActionResult, activeDeferreds, skipLoaderErrorBubbling);
    // Add a null for any non-loader matches for proper revalidation on the client
    let executedLoaders = new Set(matchesToLoad.map(match => match.route.id));
    matches.forEach(match => {
      if (!executedLoaders.has(match.route.id)) {
        context.loaderData[match.route.id] = null;
      }
    });
    return _extends({}, context, {
      matches,
      activeDeferreds: activeDeferreds.size > 0 ? Object.fromEntries(activeDeferreds.entries()) : null
    });
  }
  // Utility wrapper for calling dataStrategy server-side without having to
  // pass around the manifest, mapRouteProperties, etc.
  async function callDataStrategy(type, request, matchesToLoad, matches, isRouteRequest, requestContext, unstable_dataStrategy) {
    let results = await callDataStrategyImpl(unstable_dataStrategy || defaultDataStrategy, type, request, matchesToLoad, matches, manifest, mapRouteProperties, requestContext);
    return await Promise.all(results.map((result, i) => {
      if (isRedirectHandlerResult(result)) {
        let response = result.result;
        // Throw redirects and let the server handle them with an HTTP redirect
        throw normalizeRelativeRoutingRedirectResponse(response, request, matchesToLoad[i].route.id, matches, basename, future.v7_relativeSplatPath);
      }
      if (isResponse(result.result) && isRouteRequest) {
        // For SSR single-route requests, we want to hand Responses back
        // directly without unwrapping
        throw result;
      }
      return convertHandlerResultToDataResult(result);
    }));
  }
  return {
    dataRoutes,
    query,
    queryRoute
  };
}
//#endregion
////////////////////////////////////////////////////////////////////////////////
//#region Helpers
////////////////////////////////////////////////////////////////////////////////
/**
 * Given an existing StaticHandlerContext and an error thrown at render time,
 * provide an updated StaticHandlerContext suitable for a second SSR render
 */
function getStaticContextFromError(routes, context, error) {
  let newContext = _extends({}, context, {
    statusCode: isRouteErrorResponse(error) ? error.status : 500,
    errors: {
      [context._deepestRenderedBoundaryId || routes[0].id]: error
    }
  });
  return newContext;
}
function throwStaticHandlerAbortedError(request, isRouteRequest, future) {
  if (future.v7_throwAbortReason && request.signal.reason !== undefined) {
    throw request.signal.reason;
  }
  let method = isRouteRequest ? "queryRoute" : "query";
  throw new Error(method + "() call aborted: " + request.method + " " + request.url);
}
function isSubmissionNavigation(opts) {
  return opts != null && ("formData" in opts && opts.formData != null || "body" in opts && opts.body !== undefined);
}
function normalizeTo(location, matches, basename, prependBasename, to, v7_relativeSplatPath, fromRouteId, relative) {
  let contextualMatches;
  let activeRouteMatch;
  if (fromRouteId) {
    // Grab matches up to the calling route so our route-relative logic is
    // relative to the correct source route
    contextualMatches = [];
    for (let match of matches) {
      contextualMatches.push(match);
      if (match.route.id === fromRouteId) {
        activeRouteMatch = match;
        break;
      }
    }
  } else {
    contextualMatches = matches;
    activeRouteMatch = matches[matches.length - 1];
  }
  // Resolve the relative path
  let path = resolveTo(to ? to : ".", getResolveToMatches(contextualMatches, v7_relativeSplatPath), stripBasename(location.pathname, basename) || location.pathname, relative === "path");
  // When `to` is not specified we inherit search/hash from the current
  // location, unlike when to="." and we just inherit the path.
  // See https://github.com/remix-run/remix/issues/927
  if (to == null) {
    path.search = location.search;
    path.hash = location.hash;
  }
  // Add an ?index param for matched index routes if we don't already have one
  if ((to == null || to === "" || to === ".") && activeRouteMatch && activeRouteMatch.route.index && !hasNakedIndexQuery(path.search)) {
    path.search = path.search ? path.search.replace(/^\?/, "?index&") : "?index";
  }
  // If we're operating within a basename, prepend it to the pathname.  If
  // this is a root navigation, then just use the raw basename which allows
  // the basename to have full control over the presence of a trailing slash
  // on root actions
  if (prependBasename && basename !== "/") {
    path.pathname = path.pathname === "/" ? basename : joinPaths([basename, path.pathname]);
  }
  return createPath(path);
}
// Normalize navigation options by converting formMethod=GET formData objects to
// URLSearchParams so they behave identically to links with query params
function normalizeNavigateOptions(normalizeFormMethod, isFetcher, path, opts) {
  // Return location verbatim on non-submission navigations
  if (!opts || !isSubmissionNavigation(opts)) {
    return {
      path
    };
  }
  if (opts.formMethod && !isValidMethod(opts.formMethod)) {
    return {
      path,
      error: getInternalRouterError(405, {
        method: opts.formMethod
      })
    };
  }
  let getInvalidBodyError = () => ({
    path,
    error: getInternalRouterError(400, {
      type: "invalid-body"
    })
  });
  // Create a Submission on non-GET navigations
  let rawFormMethod = opts.formMethod || "get";
  let formMethod = normalizeFormMethod ? rawFormMethod.toUpperCase() : rawFormMethod.toLowerCase();
  let formAction = stripHashFromPath(path);
  if (opts.body !== undefined) {
    if (opts.formEncType === "text/plain") {
      // text only support POST/PUT/PATCH/DELETE submissions
      if (!isMutationMethod(formMethod)) {
        return getInvalidBodyError();
      }
      let text = typeof opts.body === "string" ? opts.body : opts.body instanceof FormData || opts.body instanceof URLSearchParams ?
      // https://html.spec.whatwg.org/multipage/form-control-infrastructure.html#plain-text-form-data
      Array.from(opts.body.entries()).reduce((acc, _ref5) => {
        let [name, value] = _ref5;
        return "" + acc + name + "=" + value + "\n";
      }, "") : String(opts.body);
      return {
        path,
        submission: {
          formMethod,
          formAction,
          formEncType: opts.formEncType,
          formData: undefined,
          json: undefined,
          text
        }
      };
    } else if (opts.formEncType === "application/json") {
      // json only supports POST/PUT/PATCH/DELETE submissions
      if (!isMutationMethod(formMethod)) {
        return getInvalidBodyError();
      }
      try {
        let json = typeof opts.body === "string" ? JSON.parse(opts.body) : opts.body;
        return {
          path,
          submission: {
            formMethod,
            formAction,
            formEncType: opts.formEncType,
            formData: undefined,
            json,
            text: undefined
          }
        };
      } catch (e) {
        return getInvalidBodyError();
      }
    }
  }
  invariant(typeof FormData === "function", "FormData is not available in this environment");
  let searchParams;
  let formData;
  if (opts.formData) {
    searchParams = convertFormDataToSearchParams(opts.formData);
    formData = opts.formData;
  } else if (opts.body instanceof FormData) {
    searchParams = convertFormDataToSearchParams(opts.body);
    formData = opts.body;
  } else if (opts.body instanceof URLSearchParams) {
    searchParams = opts.body;
    formData = convertSearchParamsToFormData(searchParams);
  } else if (opts.body == null) {
    searchParams = new URLSearchParams();
    formData = new FormData();
  } else {
    try {
      searchParams = new URLSearchParams(opts.body);
      formData = convertSearchParamsToFormData(searchParams);
    } catch (e) {
      return getInvalidBodyError();
    }
  }
  let submission = {
    formMethod,
    formAction,
    formEncType: opts && opts.formEncType || "application/x-www-form-urlencoded",
    formData,
    json: undefined,
    text: undefined
  };
  if (isMutationMethod(submission.formMethod)) {
    return {
      path,
      submission
    };
  }
  // Flatten submission onto URLSearchParams for GET submissions
  let parsedPath = parsePath(path);
  // On GET navigation submissions we can drop the ?index param from the
  // resulting location since all loaders will run.  But fetcher GET submissions
  // only run a single loader so we need to preserve any incoming ?index params
  if (isFetcher && parsedPath.search && hasNakedIndexQuery(parsedPath.search)) {
    searchParams.append("index", "");
  }
  parsedPath.search = "?" + searchParams;
  return {
    path: createPath(parsedPath),
    submission
  };
}
// Filter out all routes below any caught error as they aren't going to
// render so we don't need to load them
function getLoaderMatchesUntilBoundary(matches, boundaryId) {
  let boundaryMatches = matches;
  if (boundaryId) {
    let index = matches.findIndex(m => m.route.id === boundaryId);
    if (index >= 0) {
      boundaryMatches = matches.slice(0, index);
    }
  }
  return boundaryMatches;
}
function getMatchesToLoad(history, state, matches, submission, location, isInitialLoad, skipActionErrorRevalidation, isRevalidationRequired, cancelledDeferredRoutes, cancelledFetcherLoads, deletedFetchers, fetchLoadMatches, fetchRedirectIds, routesToUse, basename, pendingActionResult) {
  let actionResult = pendingActionResult ? isErrorResult(pendingActionResult[1]) ? pendingActionResult[1].error : pendingActionResult[1].data : undefined;
  let currentUrl = history.createURL(state.location);
  let nextUrl = history.createURL(location);
  // Pick navigation matches that are net-new or qualify for revalidation
  let boundaryId = pendingActionResult && isErrorResult(pendingActionResult[1]) ? pendingActionResult[0] : undefined;
  let boundaryMatches = boundaryId ? getLoaderMatchesUntilBoundary(matches, boundaryId) : matches;
  // Don't revalidate loaders by default after action 4xx/5xx responses
  // when the flag is enabled.  They can still opt-into revalidation via
  // `shouldRevalidate` via `actionResult`
  let actionStatus = pendingActionResult ? pendingActionResult[1].statusCode : undefined;
  let shouldSkipRevalidation = skipActionErrorRevalidation && actionStatus && actionStatus >= 400;
  let navigationMatches = boundaryMatches.filter((match, index) => {
    let {
      route
    } = match;
    if (route.lazy) {
      // We haven't loaded this route yet so we don't know if it's got a loader!
      return true;
    }
    if (route.loader == null) {
      return false;
    }
    if (isInitialLoad) {
      if (typeof route.loader !== "function" || route.loader.hydrate) {
        return true;
      }
      return state.loaderData[route.id] === undefined && (
      // Don't re-run if the loader ran and threw an error
      !state.errors || state.errors[route.id] === undefined);
    }
    // Always call the loader on new route instances and pending defer cancellations
    if (isNewLoader(state.loaderData, state.matches[index], match) || cancelledDeferredRoutes.some(id => id === match.route.id)) {
      return true;
    }
    // This is the default implementation for when we revalidate.  If the route
    // provides it's own implementation, then we give them full control but
    // provide this value so they can leverage it if needed after they check
    // their own specific use cases
    let currentRouteMatch = state.matches[index];
    let nextRouteMatch = match;
    return shouldRevalidateLoader(match, _extends({
      currentUrl,
      currentParams: currentRouteMatch.params,
      nextUrl,
      nextParams: nextRouteMatch.params
    }, submission, {
      actionResult,
      actionStatus,
      defaultShouldRevalidate: shouldSkipRevalidation ? false :
      // Forced revalidation due to submission, useRevalidator, or X-Remix-Revalidate
      isRevalidationRequired || currentUrl.pathname + currentUrl.search === nextUrl.pathname + nextUrl.search ||
      // Search params affect all loaders
      currentUrl.search !== nextUrl.search || isNewRouteInstance(currentRouteMatch, nextRouteMatch)
    }));
  });
  // Pick fetcher.loads that need to be revalidated
  let revalidatingFetchers = [];
  fetchLoadMatches.forEach((f, key) => {
    // Don't revalidate:
    //  - on initial load (shouldn't be any fetchers then anyway)
    //  - if fetcher won't be present in the subsequent render
    //    - no longer matches the URL (v7_fetcherPersist=false)
    //    - was unmounted but persisted due to v7_fetcherPersist=true
    if (isInitialLoad || !matches.some(m => m.route.id === f.routeId) || deletedFetchers.has(key)) {
      return;
    }
    let fetcherMatches = matchRoutes(routesToUse, f.path, basename);
    // If the fetcher path no longer matches, push it in with null matches so
    // we can trigger a 404 in callLoadersAndMaybeResolveData.  Note this is
    // currently only a use-case for Remix HMR where the route tree can change
    // at runtime and remove a route previously loaded via a fetcher
    if (!fetcherMatches) {
      revalidatingFetchers.push({
        key,
        routeId: f.routeId,
        path: f.path,
        matches: null,
        match: null,
        controller: null
      });
      return;
    }
    // Revalidating fetchers are decoupled from the route matches since they
    // load from a static href.  They revalidate based on explicit revalidation
    // (submission, useRevalidator, or X-Remix-Revalidate)
    let fetcher = state.fetchers.get(key);
    let fetcherMatch = getTargetMatch(fetcherMatches, f.path);
    let shouldRevalidate = false;
    if (fetchRedirectIds.has(key)) {
      // Never trigger a revalidation of an actively redirecting fetcher
      shouldRevalidate = false;
    } else if (cancelledFetcherLoads.has(key)) {
      // Always mark for revalidation if the fetcher was cancelled
      cancelledFetcherLoads.delete(key);
      shouldRevalidate = true;
    } else if (fetcher && fetcher.state !== "idle" && fetcher.data === undefined) {
      // If the fetcher hasn't ever completed loading yet, then this isn't a
      // revalidation, it would just be a brand new load if an explicit
      // revalidation is required
      shouldRevalidate = isRevalidationRequired;
    } else {
      // Otherwise fall back on any user-defined shouldRevalidate, defaulting
      // to explicit revalidations only
      shouldRevalidate = shouldRevalidateLoader(fetcherMatch, _extends({
        currentUrl,
        currentParams: state.matches[state.matches.length - 1].params,
        nextUrl,
        nextParams: matches[matches.length - 1].params
      }, submission, {
        actionResult,
        actionStatus,
        defaultShouldRevalidate: shouldSkipRevalidation ? false : isRevalidationRequired
      }));
    }
    if (shouldRevalidate) {
      revalidatingFetchers.push({
        key,
        routeId: f.routeId,
        path: f.path,
        matches: fetcherMatches,
        match: fetcherMatch,
        controller: new AbortController()
      });
    }
  });
  return [navigationMatches, revalidatingFetchers];
}
function isNewLoader(currentLoaderData, currentMatch, match) {
  let isNew =
  // [a] -> [a, b]
  !currentMatch ||
  // [a, b] -> [a, c]
  match.route.id !== currentMatch.route.id;
  // Handle the case that we don't have data for a re-used route, potentially
  // from a prior error or from a cancelled pending deferred
  let isMissingData = currentLoaderData[match.route.id] === undefined;
  // Always load if this is a net-new route or we don't yet have data
  return isNew || isMissingData;
}
function isNewRouteInstance(currentMatch, match) {
  let currentPath = currentMatch.route.path;
  return (
    // param change for this match, /users/123 -> /users/456
    currentMatch.pathname !== match.pathname ||
    // splat param changed, which is not present in match.path
    // e.g. /files/images/avatar.jpg -> files/finances.xls
    currentPath != null && currentPath.endsWith("*") && currentMatch.params["*"] !== match.params["*"]
  );
}
function shouldRevalidateLoader(loaderMatch, arg) {
  if (loaderMatch.route.shouldRevalidate) {
    let routeChoice = loaderMatch.route.shouldRevalidate(arg);
    if (typeof routeChoice === "boolean") {
      return routeChoice;
    }
  }
  return arg.defaultShouldRevalidate;
}
/**
 * Idempotent utility to execute patchRoutesOnMiss() to lazily load route
 * definitions and update the routes/routeManifest
 */
async function loadLazyRouteChildren(patchRoutesOnMissImpl, path, matches, routes, manifest, mapRouteProperties, pendingRouteChildren, signal) {
  let key = [path, ...matches.map(m => m.route.id)].join("-");
  try {
    let pending = pendingRouteChildren.get(key);
    if (!pending) {
      pending = patchRoutesOnMissImpl({
        path,
        matches,
        patch: (routeId, children) => {
          if (!signal.aborted) {
            patchRoutesImpl(routeId, children, routes, manifest, mapRouteProperties);
          }
        }
      });
      pendingRouteChildren.set(key, pending);
    }
    if (pending && isPromise(pending)) {
      await pending;
    }
  } finally {
    pendingRouteChildren.delete(key);
  }
}
function patchRoutesImpl(routeId, children, routesToUse, manifest, mapRouteProperties) {
  if (routeId) {
    var _route$children;
    let route = manifest[routeId];
    invariant(route, "No route found to patch children into: routeId = " + routeId);
    let dataChildren = convertRoutesToDataRoutes(children, mapRouteProperties, [routeId, "patch", String(((_route$children = route.children) == null ? void 0 : _route$children.length) || "0")], manifest);
    if (route.children) {
      route.children.push(...dataChildren);
    } else {
      route.children = dataChildren;
    }
  } else {
    let dataChildren = convertRoutesToDataRoutes(children, mapRouteProperties, ["patch", String(routesToUse.length || "0")], manifest);
    routesToUse.push(...dataChildren);
  }
}
/**
 * Execute route.lazy() methods to lazily load route modules (loader, action,
 * shouldRevalidate) and update the routeManifest in place which shares objects
 * with dataRoutes so those get updated as well.
 */
async function loadLazyRouteModule(route, mapRouteProperties, manifest) {
  if (!route.lazy) {
    return;
  }
  let lazyRoute = await route.lazy();
  // If the lazy route function was executed and removed by another parallel
  // call then we can return - first lazy() to finish wins because the return
  // value of lazy is expected to be static
  if (!route.lazy) {
    return;
  }
  let routeToUpdate = manifest[route.id];
  invariant(routeToUpdate, "No route found in manifest");
  // Update the route in place.  This should be safe because there's no way
  // we could yet be sitting on this route as we can't get there without
  // resolving lazy() first.
  //
  // This is different than the HMR "update" use-case where we may actively be
  // on the route being updated.  The main concern boils down to "does this
  // mutation affect any ongoing navigations or any current state.matches
  // values?".  If not, it should be safe to update in place.
  let routeUpdates = {};
  for (let lazyRouteProperty in lazyRoute) {
    let staticRouteValue = routeToUpdate[lazyRouteProperty];
    let isPropertyStaticallyDefined = staticRouteValue !== undefined &&
    // This property isn't static since it should always be updated based
    // on the route updates
    lazyRouteProperty !== "hasErrorBoundary";
    warning(!isPropertyStaticallyDefined, "Route \"" + routeToUpdate.id + "\" has a static property \"" + lazyRouteProperty + "\" " + "defined but its lazy function is also returning a value for this property. " + ("The lazy route property \"" + lazyRouteProperty + "\" will be ignored."));
    if (!isPropertyStaticallyDefined && !immutableRouteKeys.has(lazyRouteProperty)) {
      routeUpdates[lazyRouteProperty] = lazyRoute[lazyRouteProperty];
    }
  }
  // Mutate the route with the provided updates.  Do this first so we pass
  // the updated version to mapRouteProperties
  Object.assign(routeToUpdate, routeUpdates);
  // Mutate the `hasErrorBoundary` property on the route based on the route
  // updates and remove the `lazy` function so we don't resolve the lazy
  // route again.
  Object.assign(routeToUpdate, _extends({}, mapRouteProperties(routeToUpdate), {
    lazy: undefined
  }));
}
// Default implementation of `dataStrategy` which fetches all loaders in parallel
function defaultDataStrategy(opts) {
  return Promise.all(opts.matches.map(m => m.resolve()));
}
async function callDataStrategyImpl(dataStrategyImpl, type, request, matchesToLoad, matches, manifest, mapRouteProperties, requestContext) {
  let routeIdsToLoad = matchesToLoad.reduce((acc, m) => acc.add(m.route.id), new Set());
  let loadedMatches = new Set();
  // Send all matches here to allow for a middleware-type implementation.
  // handler will be a no-op for unneeded routes and we filter those results
  // back out below.
  let results = await dataStrategyImpl({
    matches: matches.map(match => {
      let shouldLoad = routeIdsToLoad.has(match.route.id);
      // `resolve` encapsulates the route.lazy, executing the
      // loader/action, and mapping return values/thrown errors to a
      // HandlerResult.  Users can pass a callback to take fine-grained control
      // over the execution of the loader/action
      let resolve = handlerOverride => {
        loadedMatches.add(match.route.id);
        return shouldLoad ? callLoaderOrAction(type, request, match, manifest, mapRouteProperties, handlerOverride, requestContext) : Promise.resolve({
          type: ResultType.data,
          result: undefined
        });
      };
      return _extends({}, match, {
        shouldLoad,
        resolve
      });
    }),
    request,
    params: matches[0].params,
    context: requestContext
  });
  // Throw if any loadRoute implementations not called since they are what
  // ensures a route is fully loaded
  matches.forEach(m => invariant(loadedMatches.has(m.route.id), "`match.resolve()` was not called for route id \"" + m.route.id + "\". " + "You must call `match.resolve()` on every match passed to " + "`dataStrategy` to ensure all routes are properly loaded."));
  // Filter out any middleware-only matches for which we didn't need to run handlers
  return results.filter((_, i) => routeIdsToLoad.has(matches[i].route.id));
}
// Default logic for calling a loader/action is the user has no specified a dataStrategy
async function callLoaderOrAction(type, request, match, manifest, mapRouteProperties, handlerOverride, staticContext) {
  let result;
  let onReject;
  let runHandler = handler => {
    // Setup a promise we can race against so that abort signals short circuit
    let reject;
    // This will never resolve so safe to type it as Promise<HandlerResult> to
    // satisfy the function return value
    let abortPromise = new Promise((_, r) => reject = r);
    onReject = () => reject();
    request.signal.addEventListener("abort", onReject);
    let actualHandler = ctx => {
      if (typeof handler !== "function") {
        return Promise.reject(new Error("You cannot call the handler for a route which defines a boolean " + ("\"" + type + "\" [routeId: " + match.route.id + "]")));
      }
      return handler({
        request,
        params: match.params,
        context: staticContext
      }, ...(ctx !== undefined ? [ctx] : []));
    };
    let handlerPromise;
    if (handlerOverride) {
      handlerPromise = handlerOverride(ctx => actualHandler(ctx));
    } else {
      handlerPromise = (async () => {
        try {
          let val = await actualHandler();
          return {
            type: "data",
            result: val
          };
        } catch (e) {
          return {
            type: "error",
            result: e
          };
        }
      })();
    }
    return Promise.race([handlerPromise, abortPromise]);
  };
  try {
    let handler = match.route[type];
    if (match.route.lazy) {
      if (handler) {
        // Run statically defined handler in parallel with lazy()
        let handlerError;
        let [value] = await Promise.all([
        // If the handler throws, don't let it immediately bubble out,
        // since we need to let the lazy() execution finish so we know if this
        // route has a boundary that can handle the error
        runHandler(handler).catch(e => {
          handlerError = e;
        }), loadLazyRouteModule(match.route, mapRouteProperties, manifest)]);
        if (handlerError !== undefined) {
          throw handlerError;
        }
        result = value;
      } else {
        // Load lazy route module, then run any returned handler
        await loadLazyRouteModule(match.route, mapRouteProperties, manifest);
        handler = match.route[type];
        if (handler) {
          // Handler still runs even if we got interrupted to maintain consistency
          // with un-abortable behavior of handler execution on non-lazy or
          // previously-lazy-loaded routes
          result = await runHandler(handler);
        } else if (type === "action") {
          let url = new URL(request.url);
          let pathname = url.pathname + url.search;
          throw getInternalRouterError(405, {
            method: request.method,
            pathname,
            routeId: match.route.id
          });
        } else {
          // lazy() route has no loader to run.  Short circuit here so we don't
          // hit the invariant below that errors on returning undefined.
          return {
            type: ResultType.data,
            result: undefined
          };
        }
      }
    } else if (!handler) {
      let url = new URL(request.url);
      let pathname = url.pathname + url.search;
      throw getInternalRouterError(404, {
        pathname
      });
    } else {
      result = await runHandler(handler);
    }
    invariant(result.result !== undefined, "You defined " + (type === "action" ? "an action" : "a loader") + " for route " + ("\"" + match.route.id + "\" but didn't return anything from your `" + type + "` ") + "function. Please return a value or `null`.");
  } catch (e) {
    // We should already be catching and converting normal handler executions to
    // HandlerResults and returning them, so anything that throws here is an
    // unexpected error we still need to wrap
    return {
      type: ResultType.error,
      result: e
    };
  } finally {
    if (onReject) {
      request.signal.removeEventListener("abort", onReject);
    }
  }
  return result;
}
async function convertHandlerResultToDataResult(handlerResult) {
  let {
    result,
    type
  } = handlerResult;
  if (isResponse(result)) {
    let data;
    try {
      let contentType = result.headers.get("Content-Type");
      // Check between word boundaries instead of startsWith() due to the last
      // paragraph of https://httpwg.org/specs/rfc9110.html#field.content-type
      if (contentType && /\bapplication\/json\b/.test(contentType)) {
        if (result.body == null) {
          data = null;
        } else {
          data = await result.json();
        }
      } else {
        data = await result.text();
      }
    } catch (e) {
      return {
        type: ResultType.error,
        error: e
      };
    }
    if (type === ResultType.error) {
      return {
        type: ResultType.error,
        error: new ErrorResponseImpl(result.status, result.statusText, data),
        statusCode: result.status,
        headers: result.headers
      };
    }
    return {
      type: ResultType.data,
      data,
      statusCode: result.status,
      headers: result.headers
    };
  }
  if (type === ResultType.error) {
    if (isDataWithResponseInit(result)) {
      var _result$init2;
      if (result.data instanceof Error) {
        var _result$init;
        return {
          type: ResultType.error,
          error: result.data,
          statusCode: (_result$init = result.init) == null ? void 0 : _result$init.status
        };
      }
      // Convert thrown unstable_data() to ErrorResponse instances
      result = new ErrorResponseImpl(((_result$init2 = result.init) == null ? void 0 : _result$init2.status) || 500, undefined, result.data);
    }
    return {
      type: ResultType.error,
      error: result,
      statusCode: isRouteErrorResponse(result) ? result.status : undefined
    };
  }
  if (isDeferredData(result)) {
    var _result$init3, _result$init4;
    return {
      type: ResultType.deferred,
      deferredData: result,
      statusCode: (_result$init3 = result.init) == null ? void 0 : _result$init3.status,
      headers: ((_result$init4 = result.init) == null ? void 0 : _result$init4.headers) && new Headers(result.init.headers)
    };
  }
  if (isDataWithResponseInit(result)) {
    var _result$init5, _result$init6;
    return {
      type: ResultType.data,
      data: result.data,
      statusCode: (_result$init5 = result.init) == null ? void 0 : _result$init5.status,
      headers: (_result$init6 = result.init) != null && _result$init6.headers ? new Headers(result.init.headers) : undefined
    };
  }
  return {
    type: ResultType.data,
    data: result
  };
}
// Support relative routing in internal redirects
function normalizeRelativeRoutingRedirectResponse(response, request, routeId, matches, basename, v7_relativeSplatPath) {
  let location = response.headers.get("Location");
  invariant(location, "Redirects returned/thrown from loaders/actions must have a Location header");
  if (!ABSOLUTE_URL_REGEX.test(location)) {
    let trimmedMatches = matches.slice(0, matches.findIndex(m => m.route.id === routeId) + 1);
    location = normalizeTo(new URL(request.url), trimmedMatches, basename, true, location, v7_relativeSplatPath);
    response.headers.set("Location", location);
  }
  return response;
}
function normalizeRedirectLocation(location, currentUrl, basename) {
  if (ABSOLUTE_URL_REGEX.test(location)) {
    // Strip off the protocol+origin for same-origin + same-basename absolute redirects
    let normalizedLocation = location;
    let url = normalizedLocation.startsWith("//") ? new URL(currentUrl.protocol + normalizedLocation) : new URL(normalizedLocation);
    let isSameBasename = stripBasename(url.pathname, basename) != null;
    if (url.origin === currentUrl.origin && isSameBasename) {
      return url.pathname + url.search + url.hash;
    }
  }
  return location;
}
// Utility method for creating the Request instances for loaders/actions during
// client-side navigations and fetches.  During SSR we will always have a
// Request instance from the static handler (query/queryRoute)
function createClientSideRequest(history, location, signal, submission) {
  let url = history.createURL(stripHashFromPath(location)).toString();
  let init = {
    signal
  };
  if (submission && isMutationMethod(submission.formMethod)) {
    let {
      formMethod,
      formEncType
    } = submission;
    // Didn't think we needed this but it turns out unlike other methods, patch
    // won't be properly normalized to uppercase and results in a 405 error.
    // See: https://fetch.spec.whatwg.org/#concept-method
    init.method = formMethod.toUpperCase();
    if (formEncType === "application/json") {
      init.headers = new Headers({
        "Content-Type": formEncType
      });
      init.body = JSON.stringify(submission.json);
    } else if (formEncType === "text/plain") {
      // Content-Type is inferred (https://fetch.spec.whatwg.org/#dom-request)
      init.body = submission.text;
    } else if (formEncType === "application/x-www-form-urlencoded" && submission.formData) {
      // Content-Type is inferred (https://fetch.spec.whatwg.org/#dom-request)
      init.body = convertFormDataToSearchParams(submission.formData);
    } else {
      // Content-Type is inferred (https://fetch.spec.whatwg.org/#dom-request)
      init.body = submission.formData;
    }
  }
  return new Request(url, init);
}
function convertFormDataToSearchParams(formData) {
  let searchParams = new URLSearchParams();
  for (let [key, value] of formData.entries()) {
    // https://html.spec.whatwg.org/multipage/form-control-infrastructure.html#converting-an-entry-list-to-a-list-of-name-value-pairs
    searchParams.append(key, typeof value === "string" ? value : value.name);
  }
  return searchParams;
}
function convertSearchParamsToFormData(searchParams) {
  let formData = new FormData();
  for (let [key, value] of searchParams.entries()) {
    formData.append(key, value);
  }
  return formData;
}
function processRouteLoaderData(matches, matchesToLoad, results, pendingActionResult, activeDeferreds, skipLoaderErrorBubbling) {
  // Fill in loaderData/errors from our loaders
  let loaderData = {};
  let errors = null;
  let statusCode;
  let foundError = false;
  let loaderHeaders = {};
  let pendingError = pendingActionResult && isErrorResult(pendingActionResult[1]) ? pendingActionResult[1].error : undefined;
  // Process loader results into state.loaderData/state.errors
  results.forEach((result, index) => {
    let id = matchesToLoad[index].route.id;
    invariant(!isRedirectResult(result), "Cannot handle redirect results in processLoaderData");
    if (isErrorResult(result)) {
      let error = result.error;
      // If we have a pending action error, we report it at the highest-route
      // that throws a loader error, and then clear it out to indicate that
      // it was consumed
      if (pendingError !== undefined) {
        error = pendingError;
        pendingError = undefined;
      }
      errors = errors || {};
      if (skipLoaderErrorBubbling) {
        errors[id] = error;
      } else {
        // Look upwards from the matched route for the closest ancestor error
        // boundary, defaulting to the root match.  Prefer higher error values
        // if lower errors bubble to the same boundary
        let boundaryMatch = findNearestBoundary(matches, id);
        if (errors[boundaryMatch.route.id] == null) {
          errors[boundaryMatch.route.id] = error;
        }
      }
      // Clear our any prior loaderData for the throwing route
      loaderData[id] = undefined;
      // Once we find our first (highest) error, we set the status code and
      // prevent deeper status codes from overriding
      if (!foundError) {
        foundError = true;
        statusCode = isRouteErrorResponse(result.error) ? result.error.status : 500;
      }
      if (result.headers) {
        loaderHeaders[id] = result.headers;
      }
    } else {
      if (isDeferredResult(result)) {
        activeDeferreds.set(id, result.deferredData);
        loaderData[id] = result.deferredData.data;
        // Error status codes always override success status codes, but if all
        // loaders are successful we take the deepest status code.
        if (result.statusCode != null && result.statusCode !== 200 && !foundError) {
          statusCode = result.statusCode;
        }
        if (result.headers) {
          loaderHeaders[id] = result.headers;
        }
      } else {
        loaderData[id] = result.data;
        // Error status codes always override success status codes, but if all
        // loaders are successful we take the deepest status code.
        if (result.statusCode && result.statusCode !== 200 && !foundError) {
          statusCode = result.statusCode;
        }
        if (result.headers) {
          loaderHeaders[id] = result.headers;
        }
      }
    }
  });
  // If we didn't consume the pending action error (i.e., all loaders
  // resolved), then consume it here.  Also clear out any loaderData for the
  // throwing route
  if (pendingError !== undefined && pendingActionResult) {
    errors = {
      [pendingActionResult[0]]: pendingError
    };
    loaderData[pendingActionResult[0]] = undefined;
  }
  return {
    loaderData,
    errors,
    statusCode: statusCode || 200,
    loaderHeaders
  };
}
function processLoaderData(state, matches, matchesToLoad, results, pendingActionResult, revalidatingFetchers, fetcherResults, activeDeferreds) {
  let {
    loaderData,
    errors
  } = processRouteLoaderData(matches, matchesToLoad, results, pendingActionResult, activeDeferreds, false // This method is only called client side so we always want to bubble
  );
  // Process results from our revalidating fetchers
  for (let index = 0; index < revalidatingFetchers.length; index++) {
    let {
      key,
      match,
      controller
    } = revalidatingFetchers[index];
    invariant(fetcherResults !== undefined && fetcherResults[index] !== undefined, "Did not find corresponding fetcher result");
    let result = fetcherResults[index];
    // Process fetcher non-redirect errors
    if (controller && controller.signal.aborted) {
      // Nothing to do for aborted fetchers
      continue;
    } else if (isErrorResult(result)) {
      let boundaryMatch = findNearestBoundary(state.matches, match == null ? void 0 : match.route.id);
      if (!(errors && errors[boundaryMatch.route.id])) {
        errors = _extends({}, errors, {
          [boundaryMatch.route.id]: result.error
        });
      }
      state.fetchers.delete(key);
    } else if (isRedirectResult(result)) {
      // Should never get here, redirects should get processed above, but we
      // keep this to type narrow to a success result in the else
      invariant(false, "Unhandled fetcher revalidation redirect");
    } else if (isDeferredResult(result)) {
      // Should never get here, deferred data should be awaited for fetchers
      // in resolveDeferredResults
      invariant(false, "Unhandled fetcher deferred data");
    } else {
      let doneFetcher = getDoneFetcher(result.data);
      state.fetchers.set(key, doneFetcher);
    }
  }
  return {
    loaderData,
    errors
  };
}
function mergeLoaderData(loaderData, newLoaderData, matches, errors) {
  let mergedLoaderData = _extends({}, newLoaderData);
  for (let match of matches) {
    let id = match.route.id;
    if (newLoaderData.hasOwnProperty(id)) {
      if (newLoaderData[id] !== undefined) {
        mergedLoaderData[id] = newLoaderData[id];
      }
    } else if (loaderData[id] !== undefined && match.route.loader) {
      // Preserve existing keys not included in newLoaderData and where a loader
      // wasn't removed by HMR
      mergedLoaderData[id] = loaderData[id];
    }
    if (errors && errors.hasOwnProperty(id)) {
      // Don't keep any loader data below the boundary
      break;
    }
  }
  return mergedLoaderData;
}
function getActionDataForCommit(pendingActionResult) {
  if (!pendingActionResult) {
    return {};
  }
  return isErrorResult(pendingActionResult[1]) ? {
    // Clear out prior actionData on errors
    actionData: {}
  } : {
    actionData: {
      [pendingActionResult[0]]: pendingActionResult[1].data
    }
  };
}
// Find the nearest error boundary, looking upwards from the leaf route (or the
// route specified by routeId) for the closest ancestor error boundary,
// defaulting to the root match
function findNearestBoundary(matches, routeId) {
  let eligibleMatches = routeId ? matches.slice(0, matches.findIndex(m => m.route.id === routeId) + 1) : [...matches];
  return eligibleMatches.reverse().find(m => m.route.hasErrorBoundary === true) || matches[0];
}
function getShortCircuitMatches(routes) {
  // Prefer a root layout route if present, otherwise shim in a route object
  let route = routes.length === 1 ? routes[0] : routes.find(r => r.index || !r.path || r.path === "/") || {
    id: "__shim-error-route__"
  };
  return {
    matches: [{
      params: {},
      pathname: "",
      pathnameBase: "",
      route
    }],
    route
  };
}
function getInternalRouterError(status, _temp5) {
  let {
    pathname,
    routeId,
    method,
    type,
    message
  } = _temp5 === void 0 ? {} : _temp5;
  let statusText = "Unknown Server Error";
  let errorMessage = "Unknown @remix-run/router error";
  if (status === 400) {
    statusText = "Bad Request";
    if (type === "route-discovery") {
      errorMessage = "Unable to match URL \"" + pathname + "\" - the `unstable_patchRoutesOnMiss()` " + ("function threw the following error:\n" + message);
    } else if (method && pathname && routeId) {
      errorMessage = "You made a " + method + " request to \"" + pathname + "\" but " + ("did not provide a `loader` for route \"" + routeId + "\", ") + "so there is no way to handle the request.";
    } else if (type === "defer-action") {
      errorMessage = "defer() is not supported in actions";
    } else if (type === "invalid-body") {
      errorMessage = "Unable to encode submission body";
    }
  } else if (status === 403) {
    statusText = "Forbidden";
    errorMessage = "Route \"" + routeId + "\" does not match URL \"" + pathname + "\"";
  } else if (status === 404) {
    statusText = "Not Found";
    errorMessage = "No route matches URL \"" + pathname + "\"";
  } else if (status === 405) {
    statusText = "Method Not Allowed";
    if (method && pathname && routeId) {
      errorMessage = "You made a " + method.toUpperCase() + " request to \"" + pathname + "\" but " + ("did not provide an `action` for route \"" + routeId + "\", ") + "so there is no way to handle the request.";
    } else if (method) {
      errorMessage = "Invalid request method \"" + method.toUpperCase() + "\"";
    }
  }
  return new ErrorResponseImpl(status || 500, statusText, new Error(errorMessage), true);
}
// Find any returned redirect errors, starting from the lowest match
function findRedirect(results) {
  for (let i = results.length - 1; i >= 0; i--) {
    let result = results[i];
    if (isRedirectResult(result)) {
      return {
        result,
        idx: i
      };
    }
  }
}
function stripHashFromPath(path) {
  let parsedPath = typeof path === "string" ? parsePath(path) : path;
  return createPath(_extends({}, parsedPath, {
    hash: ""
  }));
}
function isHashChangeOnly(a, b) {
  if (a.pathname !== b.pathname || a.search !== b.search) {
    return false;
  }
  if (a.hash === "") {
    // /page -> /page#hash
    return b.hash !== "";
  } else if (a.hash === b.hash) {
    // /page#hash -> /page#hash
    return true;
  } else if (b.hash !== "") {
    // /page#hash -> /page#other
    return true;
  }
  // If the hash is removed the browser will re-perform a request to the server
  // /page#hash -> /page
  return false;
}
function isPromise(val) {
  return typeof val === "object" && val != null && "then" in val;
}
function isHandlerResult(result) {
  return result != null && typeof result === "object" && "type" in result && "result" in result && (result.type === ResultType.data || result.type === ResultType.error);
}
function isRedirectHandlerResult(result) {
  return isResponse(result.result) && redirectStatusCodes.has(result.result.status);
}
function isDeferredResult(result) {
  return result.type === ResultType.deferred;
}
function isErrorResult(result) {
  return result.type === ResultType.error;
}
function isRedirectResult(result) {
  return (result && result.type) === ResultType.redirect;
}
function isDataWithResponseInit(value) {
  return typeof value === "object" && value != null && "type" in value && "data" in value && "init" in value && value.type === "DataWithResponseInit";
}
function isDeferredData(value) {
  let deferred = value;
  return deferred && typeof deferred === "object" && typeof deferred.data === "object" && typeof deferred.subscribe === "function" && typeof deferred.cancel === "function" && typeof deferred.resolveData === "function";
}
function isResponse(value) {
  return value != null && typeof value.status === "number" && typeof value.statusText === "string" && typeof value.headers === "object" && typeof value.body !== "undefined";
}
function isRedirectResponse(result) {
  if (!isResponse(result)) {
    return false;
  }
  let status = result.status;
  let location = result.headers.get("Location");
  return status >= 300 && status <= 399 && location != null;
}
function isValidMethod(method) {
  return validRequestMethods.has(method.toLowerCase());
}
function isMutationMethod(method) {
  return validMutationMethods.has(method.toLowerCase());
}
async function resolveDeferredResults(currentMatches, matchesToLoad, results, signals, isFetcher, currentLoaderData) {
  for (let index = 0; index < results.length; index++) {
    let result = results[index];
    let match = matchesToLoad[index];
    // If we don't have a match, then we can have a deferred result to do
    // anything with.  This is for revalidating fetchers where the route was
    // removed during HMR
    if (!match) {
      continue;
    }
    let currentMatch = currentMatches.find(m => m.route.id === match.route.id);
    let isRevalidatingLoader = currentMatch != null && !isNewRouteInstance(currentMatch, match) && (currentLoaderData && currentLoaderData[match.route.id]) !== undefined;
    if (isDeferredResult(result) && (isFetcher || isRevalidatingLoader)) {
      // Note: we do not have to touch activeDeferreds here since we race them
      // against the signal in resolveDeferredData and they'll get aborted
      // there if needed
      let signal = signals[index];
      invariant(signal, "Expected an AbortSignal for revalidating fetcher deferred result");
      await resolveDeferredData(result, signal, isFetcher).then(result => {
        if (result) {
          results[index] = result || results[index];
        }
      });
    }
  }
}
async function resolveDeferredData(result, signal, unwrap) {
  if (unwrap === void 0) {
    unwrap = false;
  }
  let aborted = await result.deferredData.resolveData(signal);
  if (aborted) {
    return;
  }
  if (unwrap) {
    try {
      return {
        type: ResultType.data,
        data: result.deferredData.unwrappedData
      };
    } catch (e) {
      // Handle any TrackedPromise._error values encountered while unwrapping
      return {
        type: ResultType.error,
        error: e
      };
    }
  }
  return {
    type: ResultType.data,
    data: result.deferredData.data
  };
}
function hasNakedIndexQuery(search) {
  return new URLSearchParams(search).getAll("index").some(v => v === "");
}
function getTargetMatch(matches, location) {
  let search = typeof location === "string" ? parsePath(location).search : location.search;
  if (matches[matches.length - 1].route.index && hasNakedIndexQuery(search || "")) {
    // Return the leaf index route when index is present
    return matches[matches.length - 1];
  }
  // Otherwise grab the deepest "path contributing" match (ignoring index and
  // pathless layout routes)
  let pathMatches = getPathContributingMatches(matches);
  return pathMatches[pathMatches.length - 1];
}
function getSubmissionFromNavigation(navigation) {
  let {
    formMethod,
    formAction,
    formEncType,
    text,
    formData,
    json
  } = navigation;
  if (!formMethod || !formAction || !formEncType) {
    return;
  }
  if (text != null) {
    return {
      formMethod,
      formAction,
      formEncType,
      formData: undefined,
      json: undefined,
      text
    };
  } else if (formData != null) {
    return {
      formMethod,
      formAction,
      formEncType,
      formData,
      json: undefined,
      text: undefined
    };
  } else if (json !== undefined) {
    return {
      formMethod,
      formAction,
      formEncType,
      formData: undefined,
      json,
      text: undefined
    };
  }
}
function getLoadingNavigation(location, submission) {
  if (submission) {
    let navigation = {
      state: "loading",
      location,
      formMethod: submission.formMethod,
      formAction: submission.formAction,
      formEncType: submission.formEncType,
      formData: submission.formData,
      json: submission.json,
      text: submission.text
    };
    return navigation;
  } else {
    let navigation = {
      state: "loading",
      location,
      formMethod: undefined,
      formAction: undefined,
      formEncType: undefined,
      formData: undefined,
      json: undefined,
      text: undefined
    };
    return navigation;
  }
}
function getSubmittingNavigation(location, submission) {
  let navigation = {
    state: "submitting",
    location,
    formMethod: submission.formMethod,
    formAction: submission.formAction,
    formEncType: submission.formEncType,
    formData: submission.formData,
    json: submission.json,
    text: submission.text
  };
  return navigation;
}
function getLoadingFetcher(submission, data) {
  if (submission) {
    let fetcher = {
      state: "loading",
      formMethod: submission.formMethod,
      formAction: submission.formAction,
      formEncType: submission.formEncType,
      formData: submission.formData,
      json: submission.json,
      text: submission.text,
      data
    };
    return fetcher;
  } else {
    let fetcher = {
      state: "loading",
      formMethod: undefined,
      formAction: undefined,
      formEncType: undefined,
      formData: undefined,
      json: undefined,
      text: undefined,
      data
    };
    return fetcher;
  }
}
function getSubmittingFetcher(submission, existingFetcher) {
  let fetcher = {
    state: "submitting",
    formMethod: submission.formMethod,
    formAction: submission.formAction,
    formEncType: submission.formEncType,
    formData: submission.formData,
    json: submission.json,
    text: submission.text,
    data: existingFetcher ? existingFetcher.data : undefined
  };
  return fetcher;
}
function getDoneFetcher(data) {
  let fetcher = {
    state: "idle",
    formMethod: undefined,
    formAction: undefined,
    formEncType: undefined,
    formData: undefined,
    json: undefined,
    text: undefined,
    data
  };
  return fetcher;
}
function restoreAppliedTransitions(_window, transitions) {
  try {
    let sessionPositions = _window.sessionStorage.getItem(TRANSITIONS_STORAGE_KEY);
    if (sessionPositions) {
      let json = JSON.parse(sessionPositions);
      for (let [k, v] of Object.entries(json || {})) {
        if (v && Array.isArray(v)) {
          transitions.set(k, new Set(v || []));
        }
      }
    }
  } catch (e) {
    // no-op, use default empty object
  }
}
function persistAppliedTransitions(_window, transitions) {
  if (transitions.size > 0) {
    let json = {};
    for (let [k, v] of transitions) {
      json[k] = [...v];
    }
    try {
      _window.sessionStorage.setItem(TRANSITIONS_STORAGE_KEY, JSON.stringify(json));
    } catch (error) {
      warning(false, "Failed to save applied view transitions in sessionStorage (" + error + ").");
    }
  }
}
//#endregion


//# sourceMappingURL=router.js.map


/***/ }),

/***/ "./src/dashboard/components/Card/index.jsx":
/*!*************************************************!*\
  !*** ./src/dashboard/components/Card/index.jsx ***!
  \*************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! .. */ "./src/dashboard/components/index.js");


function Card({
  cardList,
  cardPlace,
  cardCol
}) {
  const cardListing = card => {
    return card.map((carditem, index) => {
      return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "cw-cardbody",
        key: index
      }, carditem.iconSvg || carditem.imageurl && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "cw-icon"
      }, carditem.iconSvg && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
        className: "cw-icon-svg"
      }, carditem.iconSvg), carditem.imageurl && (cardPlace === 'starter' ? (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
        target: "_blank",
        href: carditem.buttonUrl,
        className: "starter"
      }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("img", {
        src: carditem.imageurl,
        className: "cw-img"
      })) : (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("img", {
        src: carditem.imageurl,
        className: "cw-img"
      }))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "cw-text-wrap"
      }, carditem.heading && (cardPlace === 'starter' ? (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
        target: "_blank",
        href: carditem.buttonUrl,
        className: "starter"
      }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("h3", {
        className: "cw-heading"
      }, carditem.heading)) : (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("h3", {
        className: "cw-heading"
      }, carditem.heading)), carditem.para && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
        className: "cw-text"
      }, carditem.para), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "cw-button"
      }, carditem.buttonUrl && carditem.buttonText && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
        target: "_blank",
        href: carditem.buttonUrl,
        className: "cw-btn"
      }, carditem.buttonText, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(___WEBPACK_IMPORTED_MODULE_1__.Icon, {
        icon: "arrow"
      }))), cardPlace === 'starter' && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "cw-icon-two"
      }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
        target: "_blank",
        href: carditem.buttonUrl,
        className: "icon"
      }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(___WEBPACK_IMPORTED_MODULE_1__.Icon, {
        icon: "preview"
      })))), cardPlace === 'cw-pro' && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "cw-icon-two"
      }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "icon"
      }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(___WEBPACK_IMPORTED_MODULE_1__.Icon, {
        icon: "lock"
      }))));
    });
  };
  const classes = `cw-card ${cardPlace} ${cardCol}`;
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: classes
  }, cardListing(cardList)));
}
/* harmony default export */ __webpack_exports__["default"] = (Card);

/***/ }),

/***/ "./src/dashboard/components/Heading/index.jsx":
/*!****************************************************!*\
  !*** ./src/dashboard/components/Heading/index.jsx ***!
  \****************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": function() { return /* binding */ Heading; }
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! .. */ "./src/dashboard/components/index.js");


function Heading({
  heading,
  buttonText,
  buttonUrl,
  openInNewTab
}) {
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "cw-settings"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("h2", null, heading), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "cw-button"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
    href: buttonUrl,
    className: "cw-btn",
    target: openInNewTab ? "_blank" : "_self"
  }, buttonText, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(___WEBPACK_IMPORTED_MODULE_1__.Icon, {
    icon: "arrow"
  }))));
}

/***/ }),

/***/ "./src/dashboard/components/Icon/index.jsx":
/*!*************************************************!*\
  !*** ./src/dashboard/components/Icon/index.jsx ***!
  \*************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);

const icons = {
  globe: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "20",
    height: "20",
    viewBox: "0 0 20 20",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("g", {
    clipPath: "url(#clip0_2386_336)"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M10 1.6665C12.0844 3.94846 13.269 6.90987 13.3333 9.99984C13.269 13.0898 12.0844 16.0512 10 18.3332M10 1.6665C7.9156 3.94846 6.73104 6.90987 6.66667 9.99984C6.73104 13.0898 7.9156 16.0512 10 18.3332M10 1.6665C5.39763 1.6665 1.66667 5.39746 1.66667 9.99984C1.66667 14.6022 5.39763 18.3332 10 18.3332M10 1.6665C14.6024 1.6665 18.3333 5.39746 18.3333 9.99984C18.3333 14.6022 14.6024 18.3332 10 18.3332M2.08335 7.49984H17.9167M2.08334 12.4998H17.9167",
    stroke: "currentColor",
    strokeWidth: "1.67",
    stroklinecap: "round",
    strokeLinejoin: "round"
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("defs", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("clipPath", {
    id: "clip0_2386_336"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    width: "20",
    height: "20"
  })))),
  site: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "33",
    height: "32",
    viewBox: "0 0 33 32",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    x: "0.666687",
    width: "32",
    height: "32",
    rx: "8",
    fill: "url(#paint0_linear_2353_1212)"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M9.16669 13.5H24.1667M14.1667 13.5L14.1667 23.5M13.1667 8.5H20.1667C21.5668 8.5 22.2669 8.5 22.8017 8.77248C23.2721 9.01217 23.6545 9.39462 23.8942 9.86502C24.1667 10.3998 24.1667 11.0999 24.1667 12.5V19.5C24.1667 20.9001 24.1667 21.6002 23.8942 22.135C23.6545 22.6054 23.2721 22.9878 22.8017 23.2275C22.2669 23.5 21.5668 23.5 20.1667 23.5H13.1667C11.7666 23.5 11.0665 23.5 10.5317 23.2275C10.0613 22.9878 9.67885 22.6054 9.43917 22.135C9.16669 21.6002 9.16669 20.9001 9.16669 19.5V12.5C9.16669 11.0999 9.16669 10.3998 9.43917 9.86502C9.67885 9.39462 10.0613 9.01217 10.5317 8.77248C11.0665 8.5 11.7666 8.5 13.1667 8.5Z",
    stroke: "white",
    strokeWidth: "1.67",
    stroklinecap: "round",
    strokeLinejoin: "round"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("defs", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("linearGradient", {
    id: "paint0_linear_2353_1212",
    x1: "3.00165",
    y1: "3.5",
    x2: "30.5016",
    y2: "30",
    gradientUnits: "userSpaceOnUse"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("stop", {
    stopColor: "#5081F5"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("stop", {
    offset: "1",
    stopColor: "#A769F5"
  })))),
  colorsetting: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "32",
    height: "32",
    viewBox: "0 0 32 32",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    width: "32",
    height: "32",
    rx: "8",
    fill: "url(#paint0_linear_2353_1220)"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("g", {
    clipPath: "url(#clip0_2353_1220)"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M7.66669 16C7.66669 20.6024 11.3976 24.3334 16 24.3334C17.3807 24.3334 18.5 23.2141 18.5 21.8334V21.4167C18.5 21.0297 18.5 20.8362 18.5214 20.6737C18.6691 19.5519 19.5519 18.6691 20.6737 18.5214C20.8362 18.5 21.0297 18.5 21.4167 18.5H21.8334C23.2141 18.5 24.3334 17.3807 24.3334 16C24.3334 11.3976 20.6024 7.66669 16 7.66669C11.3976 7.66669 7.66669 11.3976 7.66669 16Z",
    stroke: "white",
    strokeWidth: "1.67",
    stroklinecap: "round",
    strokeLinejoin: "round"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M11.8334 16.8334C12.2936 16.8334 12.6667 16.4603 12.6667 16C12.6667 15.5398 12.2936 15.1667 11.8334 15.1667C11.3731 15.1667 11 15.5398 11 16C11 16.4603 11.3731 16.8334 11.8334 16.8334Z",
    stroke: "white",
    strokeWidth: "1.67",
    stroklinecap: "round",
    strokeLinejoin: "round"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M19.3334 13.5C19.7936 13.5 20.1667 13.1269 20.1667 12.6667C20.1667 12.2064 19.7936 11.8334 19.3334 11.8334C18.8731 11.8334 18.5 12.2064 18.5 12.6667C18.5 13.1269 18.8731 13.5 19.3334 13.5Z",
    stroke: "white",
    strokeWidth: "1.67",
    stroklinecap: "round",
    strokeLinejoin: "round"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M14.3334 12.6667C14.7936 12.6667 15.1667 12.2936 15.1667 11.8334C15.1667 11.3731 14.7936 11 14.3334 11C13.8731 11 13.5 11.3731 13.5 11.8334C13.5 12.2936 13.8731 12.6667 14.3334 12.6667Z",
    stroke: "white",
    strokeWidth: "1.67",
    stroklinecap: "round",
    strokeLinejoin: "round"
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("defs", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("linearGradient", {
    id: "paint0_linear_2353_1220",
    x1: "2.33496",
    y1: "3.5",
    x2: "29.835",
    y2: "30",
    gradientUnits: "userSpaceOnUse"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("stop", {
    stopColor: "#F5B841"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("stop", {
    offset: "1",
    stopColor: "#FF7830"
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("clipPath", {
    id: "clip0_2353_1220"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    width: "20",
    height: "20",
    fill: "white",
    transform: "translate(6 6)"
  })))),
  typographysetting: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "33",
    height: "32",
    viewBox: "0 0 33 32",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    x: "0.333374",
    width: "32",
    height: "32",
    rx: "8",
    fill: "url(#paint0_linear_2353_1228)"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M9.66669 11.8333C9.66669 11.0567 9.66669 10.6685 9.79355 10.3622C9.96271 9.95379 10.2872 9.62934 10.6955 9.46018C11.0018 9.33331 11.3901 9.33331 12.1667 9.33331H20.5C21.2766 9.33331 21.6649 9.33331 21.9712 9.46018C22.3795 9.62934 22.704 9.95379 22.8732 10.3622C23 10.6685 23 11.0567 23 11.8333M13 22.6666H19.6667M14.875 9.33331V22.6666M17.7917 9.33331V22.6666",
    stroke: "white",
    strokeWidth: "1.67",
    stroklinecap: "round",
    strokeLinejoin: "round"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("defs", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("linearGradient", {
    id: "paint0_linear_2353_1228",
    x1: "2.66833",
    y1: "3.5",
    x2: "30.1683",
    y2: "30",
    gradientUnits: "userSpaceOnUse"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("stop", {
    stopColor: "#FF0D76"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("stop", {
    offset: "1",
    stopColor: "#590FB7"
  })))),
  layoutsetting: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "33",
    height: "32",
    viewBox: "0 0 33 32",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    x: "0.666687",
    width: "32",
    height: "32",
    rx: "8",
    fill: "url(#paint0_linear_2353_1237)"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M21.25 15.1667H17.0834M21.25 18.5H17.0834M21.25 11.8333H17.0834M14.1667 8.5L14.1667 23.5M13.1667 8.5H20.1667C21.5668 8.5 22.2669 8.5 22.8017 8.77248C23.2721 9.01217 23.6545 9.39462 23.8942 9.86502C24.1667 10.3998 24.1667 11.0999 24.1667 12.5V19.5C24.1667 20.9001 24.1667 21.6002 23.8942 22.135C23.6545 22.6054 23.2721 22.9878 22.8017 23.2275C22.2669 23.5 21.5668 23.5 20.1667 23.5H13.1667C11.7666 23.5 11.0665 23.5 10.5317 23.2275C10.0613 22.9878 9.67885 22.6054 9.43917 22.135C9.16669 21.6002 9.16669 20.9001 9.16669 19.5V12.5C9.16669 11.0999 9.16669 10.3998 9.43917 9.86502C9.67885 9.39462 10.0613 9.01217 10.5317 8.77248C11.0665 8.5 11.7666 8.5 13.1667 8.5Z",
    stroke: "white",
    strokeWidth: "1.67",
    stroklinecap: "round",
    strokeLinejoin: "round"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("defs", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("linearGradient", {
    id: "paint0_linear_2353_1237",
    x1: "3.00165",
    y1: "3.5",
    x2: "30.5016",
    y2: "30",
    gradientUnits: "userSpaceOnUse"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("stop", {
    stopColor: "#F40076"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("stop", {
    offset: "1",
    stopColor: "#DF98FA"
  })))),
  frontpagesetting: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "32",
    height: "32",
    viewBox: "0 0 32 32",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    width: "32",
    height: "32",
    rx: "8",
    fill: "url(#paint0_linear_2353_1245)"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M24.3334 13.5H7.66669M17.6667 20.5833L19.75 18.5L17.6667 16.4167M14.3334 16.4167L12.25 18.5L14.3334 20.5833M7.66669 12.5L7.66669 19.5C7.66669 20.9001 7.66669 21.6002 7.93917 22.135C8.17885 22.6054 8.56131 22.9878 9.03171 23.2275C9.56649 23.5 10.2666 23.5 11.6667 23.5H20.3334C21.7335 23.5 22.4336 23.5 22.9683 23.2275C23.4387 22.9878 23.8212 22.6054 24.0609 22.135C24.3334 21.6002 24.3334 20.9001 24.3334 19.5V12.5C24.3334 11.0999 24.3334 10.3998 24.0609 9.86502C23.8212 9.39462 23.4387 9.01217 22.9683 8.77248C22.4336 8.5 21.7335 8.5 20.3334 8.5L11.6667 8.5C10.2666 8.5 9.56649 8.5 9.03171 8.77248C8.56131 9.01217 8.17885 9.39462 7.93917 9.86502C7.66669 10.3998 7.66669 11.0999 7.66669 12.5Z",
    stroke: "white",
    strokeWidth: "1.67",
    stroklinecap: "round",
    strokeLinejoin: "round"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("defs", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("linearGradient", {
    id: "paint0_linear_2353_1245",
    x1: "2.33496",
    y1: "3.5",
    x2: "29.835",
    y2: "30",
    gradientUnits: "userSpaceOnUse"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("stop", {
    stopColor: "#AFD759"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("stop", {
    offset: "1",
    stopColor: "#00B3CC"
  })))),
  generalsetting: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "33",
    height: "32",
    viewBox: "0 0 33 32",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    x: "0.333374",
    width: "32",
    height: "32",
    rx: "8",
    fill: "url(#paint0_linear_2353_1253)"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M14.1626 22.1426L14.6497 23.2379C14.7944 23.564 15.0307 23.841 15.3298 24.0355C15.629 24.2299 15.9781 24.3334 16.3348 24.3333C16.6916 24.3334 17.0407 24.2299 17.3398 24.0355C17.639 23.841 17.8752 23.564 18.02 23.2379L18.5071 22.1426C18.6804 21.7539 18.9721 21.4298 19.3404 21.2166C19.711 21.0028 20.1398 20.9117 20.5654 20.9564L21.7571 21.0833C22.1118 21.1208 22.4698 21.0546 22.7876 20.8927C23.1055 20.7308 23.3695 20.4802 23.5478 20.1713C23.7263 19.8625 23.8113 19.5085 23.7926 19.1524C23.7738 18.7962 23.6521 18.4531 23.4422 18.1648L22.7367 17.1953C22.4855 16.8476 22.3512 16.429 22.3534 16C22.3533 15.5721 22.4888 15.1553 22.7404 14.8092L23.4459 13.8398C23.6558 13.5514 23.7775 13.2084 23.7963 12.8522C23.815 12.496 23.73 12.1421 23.5515 11.8333C23.3733 11.5243 23.1092 11.2737 22.7913 11.1118C22.4735 10.9499 22.1155 10.8837 21.7608 10.9213L20.5691 11.0481C20.1435 11.0928 19.7148 11.0017 19.3441 10.7879C18.975 10.5735 18.6833 10.2478 18.5108 9.85737L18.02 8.762C17.8752 8.43594 17.639 8.15889 17.3398 7.96446C17.0407 7.77003 16.6916 7.66657 16.3348 7.66663C15.9781 7.66657 15.629 7.77003 15.3298 7.96446C15.0307 8.15889 14.7944 8.43594 14.6497 8.762L14.1626 9.85737C13.9901 10.2478 13.6983 10.5735 13.3293 10.7879C12.9586 11.0017 12.5298 11.0928 12.1043 11.0481L10.9089 10.9213C10.5542 10.8837 10.1962 10.9499 9.87834 11.1118C9.56049 11.2737 9.29643 11.5243 9.11817 11.8333C8.93969 12.1421 8.85466 12.496 8.87339 12.8522C8.89213 13.2084 9.01383 13.5514 9.22373 13.8398L9.92928 14.8092C10.1809 15.1553 10.3164 15.5721 10.3163 16C10.3164 16.4278 10.1809 16.8447 9.92928 17.1907L9.22373 18.1601C9.01383 18.4485 8.89213 18.7916 8.87339 19.1477C8.85466 19.5039 8.93969 19.8578 9.11817 20.1666C9.2966 20.4754 9.5607 20.7259 9.8785 20.8878C10.1963 21.0496 10.5542 21.1159 10.9089 21.0787L12.1006 20.9518C12.5261 20.9071 12.9549 20.9982 13.3256 21.212C13.696 21.4258 13.9891 21.7516 14.1626 22.1426Z",
    stroke: "white",
    strokeWidth: "1.67",
    stroklinecap: "round",
    strokeLinejoin: "round"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M16.3333 18.5C17.7141 18.5 18.8333 17.3807 18.8333 16C18.8333 14.6192 17.7141 13.5 16.3333 13.5C14.9526 13.5 13.8333 14.6192 13.8333 16C13.8333 17.3807 14.9526 18.5 16.3333 18.5Z",
    stroke: "white",
    strokeWidth: "1.67",
    stroklinecap: "round",
    strokeLinejoin: "round"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("defs", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("linearGradient", {
    id: "paint0_linear_2353_1253",
    x1: "2.66833",
    y1: "3.5",
    x2: "30.1683",
    y2: "30",
    gradientUnits: "userSpaceOnUse"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("stop", {
    stopColor: "#ED7B84"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("stop", {
    offset: "1",
    stopColor: "#9055FF"
  })))),
  instagramsetting: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "33",
    height: "32",
    viewBox: "0 0 33 32",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    x: "0.666687",
    width: "32",
    height: "32",
    rx: "8",
    fill: "url(#paint0_linear_2353_1262)"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M13.1667 7.66663H20.1667C22.8334 7.66663 25 9.83329 25 12.5V19.5C25 20.7818 24.4908 22.0112 23.5844 22.9176C22.678 23.8241 21.4486 24.3333 20.1667 24.3333H13.1667C10.5 24.3333 8.33337 22.1666 8.33337 19.5V12.5C8.33337 11.2181 8.8426 9.9887 9.74902 9.08228C10.6555 8.17585 11.8848 7.66663 13.1667 7.66663ZM13 9.33329C12.2044 9.33329 11.4413 9.64936 10.8787 10.212C10.3161 10.7746 10 11.5376 10 12.3333V19.6666C10 21.325 11.3417 22.6666 13 22.6666H20.3334C21.129 22.6666 21.8921 22.3506 22.4547 21.7879C23.0173 21.2253 23.3334 20.4623 23.3334 19.6666V12.3333C23.3334 10.675 21.9917 9.33329 20.3334 9.33329H13ZM21.0417 10.5833C21.318 10.5833 21.5829 10.693 21.7783 10.8884C21.9736 11.0837 22.0834 11.3487 22.0834 11.625C22.0834 11.9012 21.9736 12.1662 21.7783 12.3615C21.5829 12.5569 21.318 12.6666 21.0417 12.6666C20.7654 12.6666 20.5005 12.5569 20.3051 12.3615C20.1098 12.1662 20 11.9012 20 11.625C20 11.3487 20.1098 11.0837 20.3051 10.8884C20.5005 10.693 20.7654 10.5833 21.0417 10.5833ZM16.6667 11.8333C17.7718 11.8333 18.8316 12.2723 19.613 13.0537C20.3944 13.8351 20.8334 14.8949 20.8334 16C20.8334 17.105 20.3944 18.1648 19.613 18.9462C18.8316 19.7276 17.7718 20.1666 16.6667 20.1666C15.5616 20.1666 14.5018 19.7276 13.7204 18.9462C12.939 18.1648 12.5 17.105 12.5 16C12.5 14.8949 12.939 13.8351 13.7204 13.0537C14.5018 12.2723 15.5616 11.8333 16.6667 11.8333ZM16.6667 13.5C16.0037 13.5 15.3678 13.7634 14.8989 14.2322C14.4301 14.701 14.1667 15.3369 14.1667 16C14.1667 16.663 14.4301 17.2989 14.8989 17.7677C15.3678 18.2366 16.0037 18.5 16.6667 18.5C17.3297 18.5 17.9656 18.2366 18.4345 17.7677C18.9033 17.2989 19.1667 16.663 19.1667 16C19.1667 15.3369 18.9033 14.701 18.4345 14.2322C17.9656 13.7634 17.3297 13.5 16.6667 13.5Z",
    fill: "white"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("defs", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("linearGradient", {
    id: "paint0_linear_2353_1262",
    x1: "3.00165",
    y1: "3.5",
    x2: "30.5016",
    y2: "30",
    gradientUnits: "userSpaceOnUse"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("stop", {
    stopColor: "#E233FF"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("stop", {
    offset: "1",
    stopColor: "#FF6B00"
  })))),
  socialmedia: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "32",
    height: "32",
    viewBox: "0 0 32 32",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    width: "32",
    height: "32",
    rx: "8",
    fill: "url(#paint0_linear_2353_1270)"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M13.1583 17.2583L18.85 20.575M18.8417 11.425L13.1583 14.7416M23.5 10.1666C23.5 11.5473 22.3807 12.6666 21 12.6666C19.6193 12.6666 18.5 11.5473 18.5 10.1666C18.5 8.78591 19.6193 7.66663 21 7.66663C22.3807 7.66663 23.5 8.78591 23.5 10.1666ZM13.5 16C13.5 17.3807 12.3807 18.5 11 18.5C9.61929 18.5 8.5 17.3807 8.5 16C8.5 14.6192 9.61929 13.5 11 13.5C12.3807 13.5 13.5 14.6192 13.5 16ZM23.5 21.8333C23.5 23.214 22.3807 24.3333 21 24.3333C19.6193 24.3333 18.5 23.214 18.5 21.8333C18.5 20.4526 19.6193 19.3333 21 19.3333C22.3807 19.3333 23.5 20.4526 23.5 21.8333Z",
    stroke: "white",
    strokeWidth: "1.67",
    stroklinecap: "round",
    strokeLinejoin: "round"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("defs", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("linearGradient", {
    id: "paint0_linear_2353_1270",
    x1: "2.33496",
    y1: "3.5",
    x2: "29.835",
    y2: "30",
    gradientUnits: "userSpaceOnUse"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("stop", {
    stopColor: "#2F80ED"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("stop", {
    offset: "1",
    stopColor: "#B2FFDA"
  })))),
  footersetting: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "33",
    height: "32",
    viewBox: "0 0 33 32",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    x: "0.333374",
    width: "32",
    height: "32",
    rx: "8",
    fill: "url(#paint0_linear_2353_1278)"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M8.83337 8.5H8.84171M8.83337 16H8.84171M8.83337 19.75H8.84171M8.83337 12.25H8.84171M12.5834 8.5H12.5917M12.5834 16H12.5917M20.0834 8.5H20.0917M20.0834 16H20.0917M16.3334 8.5H16.3417M16.3334 16H16.3417M16.3334 19.75H16.3417M16.3334 12.25H16.3417M23.8334 8.5H23.8417M23.8334 16H23.8417M23.8334 19.75H23.8417M23.8334 12.25H23.8417M23.8334 23.5H8.83337",
    stroke: "white",
    strokeWidth: "1.67",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("defs", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("linearGradient", {
    id: "paint0_linear_2353_1278",
    x1: "2.66833",
    y1: "3.5",
    x2: "30.1683",
    y2: "30",
    gradientUnits: "userSpaceOnUse"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("stop", {
    stopColor: "#DF98FA"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("stop", {
    offset: "1",
    stopColor: "#9055FF"
  })))),
  home: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "20",
    height: "20",
    viewBox: "0 0 20 20",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M2.5 8.80433C2.5 8.3257 2.5 8.08639 2.56169 7.866C2.61633 7.67078 2.70614 7.48716 2.82669 7.32417C2.96278 7.14017 3.15168 6.99324 3.52949 6.69939L9.18141 2.30345C9.47418 2.07574 9.62057 1.96189 9.78221 1.91812C9.92484 1.87951 10.0752 1.87951 10.2178 1.91812C10.3794 1.96189 10.5258 2.07574 10.8186 2.30345L16.4705 6.69939C16.8483 6.99324 17.0372 7.14017 17.1733 7.32417C17.2939 7.48716 17.3837 7.67078 17.4383 7.866C17.5 8.08639 17.5 8.3257 17.5 8.80433V14.8334C17.5 15.7669 17.5 16.2336 17.3183 16.5901C17.1586 16.9037 16.9036 17.1587 16.59 17.3185C16.2335 17.5001 15.7668 17.5001 14.8333 17.5001H5.16667C4.23325 17.5001 3.76654 17.5001 3.41002 17.3185C3.09641 17.1587 2.84144 16.9037 2.68166 16.5901C2.5 16.2336 2.5 15.7669 2.5 14.8334V8.80433Z",
    stroke: "currentColor",
    strokeWidth: "1.67",
    stroklinecap: "round",
    strokeLinejoin: "round"
  })),
  freePro: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "20",
    height: "20",
    viewBox: "0 0 20 20",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("g", {
    clipPath: "url(#clip0_2386_343)"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M10 1.6665L13 4.6665C15 -0.583496 20.5833 4.99984 15.3333 6.99984L18.3333 9.99984L15.3333 12.9998C13.3333 7.74984 7.75001 13.3332 13 15.3332L10 18.3332L7 15.3332C5 20.5832 -0.583328 14.9998 4.66667 12.9998L1.66667 9.99984L4.66667 6.99984C6.66667 12.2498 12.25 6.6665 7 4.6665L10 1.6665Z",
    stroke: "currentColor",
    strokeWidth: "1.67",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("defs", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("clipPath", {
    id: "clip0_2386_343"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    width: "20",
    height: "20",
    fill: "none"
  })))),
  offers: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "20",
    height: "20",
    viewBox: "0 0 20 20",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M6.66667 6.6665H6.67501M1.66667 4.33317L1.66667 8.06193C1.66667 8.46958 1.66667 8.67341 1.71272 8.86522C1.75355 9.03528 1.82089 9.19786 1.91227 9.34698C2.01534 9.51517 2.15947 9.6593 2.44772 9.94755L8.83824 16.3381C9.82829 17.3281 10.3233 17.8231 10.8941 18.0086C11.3962 18.1718 11.9371 18.1718 12.4392 18.0086C13.01 17.8231 13.5051 17.3281 14.4951 16.3381L16.3382 14.4949C17.3283 13.5049 17.8233 13.0099 18.0088 12.439C18.1719 11.9369 18.1719 11.3961 18.0088 10.894C17.8233 10.3231 17.3283 9.82812 16.3382 8.83808L9.94772 2.44755C9.65947 2.1593 9.51534 2.01517 9.34715 1.9121C9.19802 1.82072 9.03545 1.75338 8.86539 1.71255C8.67358 1.6665 8.46975 1.6665 8.0621 1.6665L4.33334 1.6665C3.39992 1.6665 2.93321 1.6665 2.57669 1.84816C2.26308 2.00795 2.00812 2.26292 1.84833 2.57652C1.66667 2.93304 1.66667 3.39975 1.66667 4.33317ZM7.08334 6.6665C7.08334 6.89662 6.89679 7.08317 6.66667 7.08317C6.43655 7.08317 6.25001 6.89662 6.25001 6.6665C6.25001 6.43639 6.43655 6.24984 6.66667 6.24984C6.89679 6.24984 7.08334 6.43639 7.08334 6.6665Z",
    stroke: "currentColor",
    strokeWidth: "1.67",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  })),
  plugins: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "20",
    height: "20",
    viewBox: "0 0 20 20",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M18.7883 4.96168C18.7012 4.87428 18.5977 4.80494 18.4837 4.75762C18.3698 4.7103 18.2476 4.68595 18.1242 4.68595C18.0008 4.68595 17.8787 4.7103 17.7647 4.75762C17.6508 4.80494 17.5473 4.87428 17.4602 4.96168L15 7.42184L12.5781 4.99997L15.0406 2.53825C15.2168 2.36213 15.3157 2.12326 15.3157 1.87418C15.3157 1.62511 15.2168 1.38624 15.0406 1.21012C14.8645 1.034 14.6256 0.935059 14.3766 0.935059C14.1275 0.935059 13.8886 1.034 13.7125 1.21012L11.25 3.67184L9.41329 1.83668C9.32608 1.74948 9.22255 1.6803 9.10861 1.63311C8.99467 1.58591 8.87255 1.56162 8.74922 1.56162C8.50015 1.56162 8.26128 1.66056 8.08516 1.83668C7.90904 2.01281 7.8101 2.25168 7.8101 2.50075C7.8101 2.74982 7.90904 2.98869 8.08516 3.16481L8.35938 3.43747L4.44454 7.35465C4.12528 7.67386 3.87203 8.05283 3.69925 8.46992C3.52647 8.88701 3.43754 9.33405 3.43754 9.78551C3.43754 10.237 3.52647 10.684 3.69925 11.1011C3.87203 11.5182 4.12528 11.8972 4.44454 12.2164L5.45079 13.2226L1.83672 16.8367C1.74952 16.9239 1.68034 17.0274 1.63315 17.1414C1.58595 17.2553 1.56166 17.3774 1.56166 17.5007C1.56166 17.6241 1.58595 17.7462 1.63315 17.8601C1.68034 17.9741 1.74952 18.0776 1.83672 18.1648C2.01284 18.3409 2.25172 18.4399 2.50079 18.4399C2.62411 18.4399 2.74624 18.4156 2.86018 18.3684C2.97412 18.3212 3.07764 18.252 3.16485 18.1648L6.77891 14.5507L7.78516 15.557C8.10437 15.8763 8.48334 16.1295 8.90043 16.3023C9.31752 16.4751 9.76456 16.564 10.216 16.564C10.6675 16.564 11.1145 16.4751 11.5316 16.3023C11.9487 16.1295 12.3277 15.8763 12.6469 15.557L16.5625 11.6406L16.8367 11.9156C16.9239 12.0028 17.0275 12.072 17.1414 12.1192C17.2553 12.1664 17.3775 12.1907 17.5008 12.1907C17.6241 12.1907 17.7462 12.1664 17.8602 12.1192C17.9741 12.072 18.0776 12.0028 18.1648 11.9156C18.2521 11.8284 18.3212 11.7249 18.3684 11.6109C18.4156 11.497 18.4399 11.3749 18.4399 11.2515C18.4399 11.1282 18.4156 11.0061 18.3684 10.8921C18.3212 10.7782 18.2521 10.6747 18.1648 10.5875L16.3281 8.74997L18.7906 6.28825C18.8776 6.20102 18.9466 6.09751 18.9936 5.98361C19.0406 5.86972 19.0646 5.74768 19.0644 5.62448C19.0642 5.50128 19.0397 5.37933 18.9923 5.2656C18.9449 5.15187 18.8756 5.0486 18.7883 4.96168ZM11.3195 14.2297C11.1744 14.3748 11.0022 14.49 10.8125 14.5685C10.6229 14.6471 10.4197 14.6875 10.2145 14.6875C10.0092 14.6875 9.80598 14.6471 9.61637 14.5685C9.42676 14.49 9.25448 14.3748 9.10938 14.2297L5.77032 10.8906C5.62516 10.7455 5.51001 10.5732 5.43145 10.3836C5.35288 10.194 5.31245 9.99076 5.31245 9.78551C5.31245 9.58027 5.35288 9.37704 5.43145 9.18742C5.51001 8.99781 5.62516 8.82553 5.77032 8.68043L9.68751 4.76559L15.2344 10.3125L11.3195 14.2297Z",
    fill: "currentColor"
  })),
  license: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "20",
    height: "20",
    viewBox: "0 0 20 20",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M5.41667 16.6665H4.16667C3.24619 16.6665 2.5 15.9203 2.5 14.9998V3.33317C2.5 2.4127 3.24619 1.6665 4.16667 1.6665H15.8333C16.7538 1.6665 17.5 2.4127 17.5 3.33317V14.9998C17.5 15.9203 16.7538 16.6665 15.8333 16.6665H14.5833M10 15.8332C11.3807 15.8332 12.5 14.7139 12.5 13.3332C12.5 11.9525 11.3807 10.8332 10 10.8332C8.61929 10.8332 7.5 11.9525 7.5 13.3332C7.5 14.7139 8.61929 15.8332 10 15.8332ZM10 15.8332L10.0179 15.833L7.35723 18.4936L5.0002 16.1366L7.51638 13.6204M10 15.8332L12.6607 18.4936L15.0177 16.1366L12.5015 13.6204M7.5 4.99984H12.5M5.83333 7.9165H14.1667",
    stroke: "currentColor",
    strokeWidth: "1.67",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  })),
  arrow: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "13",
    height: "10",
    viewBox: "0 0 13 10",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M1.16669 5H11.8334M11.8334 5L7.83335 1M11.8334 5L7.83335 9",
    stroke: "#6266EA",
    strokeWidth: "1.5",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  })),
  youtube: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "20",
    height: "20",
    viewBox: "0 0 20 20",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    fillRule: "evenodd",
    clipRule: "evenodd",
    d: "M9.99996 3.3335C10.7125 3.3335 11.4433 3.35183 12.1516 3.38183L12.9883 3.42183L13.7891 3.46933L14.5391 3.52016L15.2241 3.5735C15.9675 3.63039 16.667 3.94762 17.1996 4.46936C17.7321 4.99111 18.0636 5.68395 18.1358 6.426L18.1691 6.78016L18.2316 7.5385C18.29 8.32433 18.3333 9.181 18.3333 10.0002C18.3333 10.8193 18.29 11.676 18.2316 12.4618L18.1691 13.2202C18.1583 13.3418 18.1475 13.4593 18.1358 13.5743C18.0636 14.3165 17.732 15.0095 17.1992 15.5312C16.6665 16.053 15.9668 16.3701 15.2233 16.4268L14.54 16.4793L13.79 16.531L12.9883 16.5785L12.1516 16.6185C11.4348 16.6496 10.7174 16.6658 9.99996 16.6668C9.28248 16.6658 8.5651 16.6496 7.84829 16.6185L7.01163 16.5785L6.21079 16.531L5.46079 16.4793L4.77579 16.4268C4.03242 16.3699 3.33292 16.0527 2.80035 15.531C2.26779 15.0092 1.93627 14.3164 1.86413 13.5743L1.83079 13.2202L1.76829 12.4618C1.70457 11.6428 1.67066 10.8217 1.66663 10.0002C1.66663 9.181 1.70996 8.32433 1.76829 7.5385L1.83079 6.78016C1.84163 6.6585 1.85246 6.541 1.86413 6.426C1.93624 5.68408 2.26764 4.99134 2.80004 4.46962C3.33243 3.94789 4.03173 3.63058 4.77496 3.5735L5.45913 3.52016L6.20913 3.46933L7.01079 3.42183L7.84746 3.38183C8.56454 3.35069 9.2822 3.33458 9.99996 3.3335ZM8.33329 7.97933V12.021C8.33329 12.406 8.74996 12.646 9.08329 12.4543L12.5833 10.4335C12.6595 10.3897 12.7227 10.3265 12.7667 10.2504C12.8107 10.1744 12.8338 10.088 12.8338 10.0002C12.8338 9.91229 12.8107 9.82596 12.7667 9.74988C12.7227 9.67381 12.6595 9.61067 12.5833 9.56683L9.08329 7.54683C9.00726 7.50293 8.92101 7.47983 8.83321 7.47984C8.74542 7.47986 8.65917 7.50299 8.58315 7.54691C8.50713 7.59083 8.44402 7.654 8.40016 7.73005C8.3563 7.8061 8.33324 7.89237 8.33329 7.98016V7.97933Z",
    fill: "currentColor"
  })),
  support: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "20",
    height: "20",
    viewBox: "0 0 20 20",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M8.33333 6.66853C8.48016 6.25113 8.76998 5.89917 9.15144 5.67498C9.53291 5.45079 9.98141 5.36884 10.4175 5.44364C10.8536 5.51844 11.2492 5.74517 11.5341 6.08367C11.8191 6.42217 11.975 6.8506 11.9744 7.29306C11.9744 8.54213 10.1008 9.16667 10.1008 9.16667M10.1249 11.6667H10.1333M5.83333 15V16.9463C5.83333 17.3903 5.83333 17.6123 5.92436 17.7263C6.00352 17.8255 6.12356 17.8832 6.25045 17.8831C6.39636 17.8829 6.56973 17.7442 6.91646 17.4668L8.90434 15.8765C9.31043 15.5517 9.51347 15.3892 9.73957 15.2737C9.94017 15.1712 10.1537 15.0963 10.3743 15.051C10.6231 15 10.8831 15 11.4031 15H13.5C14.9001 15 15.6002 15 16.135 14.7275C16.6054 14.4878 16.9878 14.1054 17.2275 13.635C17.5 13.1002 17.5 12.4001 17.5 11V6.5C17.5 5.09987 17.5 4.3998 17.2275 3.86502C16.9878 3.39462 16.6054 3.01217 16.135 2.77248C15.6002 2.5 14.9001 2.5 13.5 2.5H6.5C5.09987 2.5 4.3998 2.5 3.86502 2.77248C3.39462 3.01217 3.01217 3.39462 2.77248 3.86502C2.5 4.3998 2.5 5.09987 2.5 6.5V11.6667C2.5 12.4416 2.5 12.8291 2.58519 13.147C2.81635 14.0098 3.49022 14.6836 4.35295 14.9148C4.67087 15 5.05836 15 5.83333 15Z",
    stroke: "currentColor",
    strokeWidth: "1.67",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  })),
  doc: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "20",
    height: "20",
    viewBox: "0 0 20 20",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    width: "20",
    height: "20",
    fill: "none"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M3.33337 1.6665H10.8334L16.6667 7.49984V18.3332H3.33337V1.6665Z",
    stroke: "currentColor",
    strokeWidth: "1.67",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M10.8334 1.6665V7.49984H16.6667",
    stroke: "currentColor",
    strokeWidth: "1.67",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M6.66663 11.6665H13.3333",
    stroke: "currentColor",
    strokeWidth: "1.67",
    strokeLinecap: "round"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M6.66663 15H9.99996",
    stroke: "currentColor",
    strokeWidth: "1.67",
    strokeLinecap: "round"
  })),
  lock: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "17",
    height: "21",
    viewBox: "0 0 17 21",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M2.82456 21C2.29061 21 1.83352 20.8042 1.45329 20.4125C1.07305 20.0208 0.882935 19.55 0.882935 19V9C0.882935 8.45 1.07305 7.97917 1.45329 7.5875C1.83352 7.19583 2.29061 7 2.82456 7H3.79538V5C3.79538 3.61667 4.26865 2.4375 5.21519 1.4625C6.16174 0.4875 7.30649 0 8.64945 0C9.99241 0 11.1372 0.4875 12.0837 1.4625C13.0302 2.4375 13.5035 3.61667 13.5035 5V7H14.4743C15.0083 7 15.4654 7.19583 15.8456 7.5875C16.2258 7.97917 16.416 8.45 16.416 9V19C16.416 19.55 16.2258 20.0208 15.8456 20.4125C15.4654 20.8042 15.0083 21 14.4743 21H2.82456ZM2.82456 19H14.4743V9H2.82456V19ZM8.64945 16C9.1834 16 9.64049 15.8042 10.0207 15.4125C10.401 15.0208 10.5911 14.55 10.5911 14C10.5911 13.45 10.401 12.9792 10.0207 12.5875C9.64049 12.1958 9.1834 12 8.64945 12C8.1155 12 7.65841 12.1958 7.27817 12.5875C6.89794 12.9792 6.70782 13.45 6.70782 14C6.70782 14.55 6.89794 15.0208 7.27817 15.4125C7.65841 15.8042 8.1155 16 8.64945 16ZM5.73701 7H11.5619V5C11.5619 4.16667 11.2787 3.45833 10.7124 2.875C10.1461 2.29167 9.45846 2 8.64945 2C7.84044 2 7.15278 2.29167 6.58647 2.875C6.02016 3.45833 5.73701 4.16667 5.73701 5V7Z",
    fill: "#D9D9D9"
  })),
  documentation: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "16",
    height: "20",
    viewBox: "0 0 16 20",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M9.66671 9.1665H4.66671M6.33337 12.4998H4.66671M11.3334 5.83317H4.66671M14.6667 5.6665V14.3332C14.6667 15.7333 14.6667 16.4334 14.3942 16.9681C14.1545 17.4385 13.7721 17.821 13.3017 18.0607C12.7669 18.3332 12.0668 18.3332 10.6667 18.3332H5.33337C3.93324 18.3332 3.23318 18.3332 2.6984 18.0607C2.22799 17.821 1.84554 17.4385 1.60586 16.9681C1.33337 16.4334 1.33337 15.7333 1.33337 14.3332V5.6665C1.33337 4.26637 1.33337 3.56631 1.60586 3.03153C1.84554 2.56112 2.22799 2.17867 2.6984 1.93899C3.23318 1.6665 3.93324 1.6665 5.33337 1.6665H10.6667C12.0668 1.6665 12.7669 1.6665 13.3017 1.93899C13.7721 2.17867 14.1545 2.56112 14.3942 3.03153C14.6667 3.56631 14.6667 4.26637 14.6667 5.6665Z",
    stroke: "currentColor",
    strokeWidth: "1.67",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  })),
  supportTwo: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "18",
    height: "14",
    viewBox: "0 0 18 14",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M8.99996 11.1668C9.23607 11.1668 9.43399 11.087 9.59371 10.9272C9.75343 10.7675 9.83329 10.5696 9.83329 10.3335C9.83329 10.0974 9.75343 9.89947 9.59371 9.73975C9.43399 9.58002 9.23607 9.50016 8.99996 9.50016C8.76385 9.50016 8.56593 9.58002 8.40621 9.73975C8.24649 9.89947 8.16662 10.0974 8.16662 10.3335C8.16662 10.5696 8.24649 10.7675 8.40621 10.9272C8.56593 11.087 8.76385 11.1668 8.99996 11.1668ZM8.99996 7.8335C9.23607 7.8335 9.43399 7.75363 9.59371 7.59391C9.75343 7.43419 9.83329 7.23627 9.83329 7.00016C9.83329 6.76405 9.75343 6.56613 9.59371 6.40641C9.43399 6.24669 9.23607 6.16683 8.99996 6.16683C8.76385 6.16683 8.56593 6.24669 8.40621 6.40641C8.24649 6.56613 8.16662 6.76405 8.16662 7.00016C8.16662 7.23627 8.24649 7.43419 8.40621 7.59391C8.56593 7.75363 8.76385 7.8335 8.99996 7.8335ZM8.99996 4.50016C9.23607 4.50016 9.43399 4.4203 9.59371 4.26058C9.75343 4.10086 9.83329 3.90294 9.83329 3.66683C9.83329 3.43072 9.75343 3.2328 9.59371 3.07308C9.43399 2.91336 9.23607 2.8335 8.99996 2.8335C8.76385 2.8335 8.56593 2.91336 8.40621 3.07308C8.24649 3.2328 8.16662 3.43072 8.16662 3.66683C8.16662 3.90294 8.24649 4.10086 8.40621 4.26058C8.56593 4.4203 8.76385 4.50016 8.99996 4.50016ZM15.6666 13.6668H2.33329C1.87496 13.6668 1.4826 13.5036 1.15621 13.1772C0.82982 12.8509 0.666626 12.4585 0.666626 12.0002V8.66683C1.12496 8.66683 1.51732 8.50363 1.84371 8.17725C2.1701 7.85086 2.33329 7.4585 2.33329 7.00016C2.33329 6.54183 2.1701 6.14947 1.84371 5.82308C1.51732 5.49669 1.12496 5.3335 0.666626 5.3335V2.00016C0.666626 1.54183 0.82982 1.14947 1.15621 0.823079C1.4826 0.496691 1.87496 0.333496 2.33329 0.333496H15.6666C16.125 0.333496 16.5173 0.496691 16.8437 0.823079C17.1701 1.14947 17.3333 1.54183 17.3333 2.00016V5.3335C16.875 5.3335 16.4826 5.49669 16.1562 5.82308C15.8298 6.14947 15.6666 6.54183 15.6666 7.00016C15.6666 7.4585 15.8298 7.85086 16.1562 8.17725C16.4826 8.50363 16.875 8.66683 17.3333 8.66683V12.0002C17.3333 12.4585 17.1701 12.8509 16.8437 13.1772C16.5173 13.5036 16.125 13.6668 15.6666 13.6668ZM15.6666 12.0002V9.87516C15.1527 9.56961 14.7465 9.16336 14.4479 8.65641C14.1493 8.14947 14 7.59738 14 7.00016C14 6.40294 14.1493 5.85086 14.4479 5.34391C14.7465 4.83697 15.1527 4.43072 15.6666 4.12516V2.00016H2.33329V4.12516C2.84718 4.43072 3.25343 4.83697 3.55204 5.34391C3.85065 5.85086 3.99996 6.40294 3.99996 7.00016C3.99996 7.59738 3.85065 8.14947 3.55204 8.65641C3.25343 9.16336 2.84718 9.56961 2.33329 9.87516V12.0002H15.6666Z",
    fill: "#F8478D"
  })),
  video: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "22",
    height: "22",
    viewBox: "0 0 22 22",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M11 21C16.5228 21 21 16.5228 21 11C21 5.47715 16.5228 1 11 1C5.47715 1 1 5.47715 1 11C1 16.5228 5.47715 21 11 21Z",
    stroke: "#F8478D",
    strokeWidth: "2",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M8.5 7.96533C8.5 7.48805 8.5 7.24941 8.59974 7.11618C8.68666 7.00007 8.81971 6.92744 8.96438 6.9171C9.13038 6.90525 9.33112 7.03429 9.73261 7.29239L14.4532 10.3271C14.8016 10.551 14.9758 10.663 15.0359 10.8054C15.0885 10.9298 15.0885 11.0702 15.0359 11.1946C14.9758 11.337 14.8016 11.449 14.4532 11.6729L9.73261 14.7076C9.33112 14.9657 9.13038 15.0948 8.96438 15.0829C8.81971 15.0726 8.68666 14.9999 8.59974 14.8838C8.5 14.7506 8.5 14.512 8.5 14.0347V7.96533Z",
    stroke: "#F8478D",
    strokeWidth: "2",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  })),
  arrowtwo: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "8",
    height: "12",
    viewBox: "0 0 8 12",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M1.5 11L6.5 6L1.5 1",
    stroke: "currentColor",
    strokeWidth: "1.67",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  })),
  preview: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "20",
    height: "14",
    viewBox: "0 0 20 14",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M2.01677 7.59415C1.90328 7.41445 1.84654 7.3246 1.81477 7.18602C1.79091 7.08192 1.79091 6.91775 1.81477 6.81366C1.84654 6.67507 1.90328 6.58522 2.01677 6.40552C2.95461 4.92054 5.74617 1.1665 10.0003 1.1665C14.2545 1.1665 17.0461 4.92054 17.9839 6.40552C18.0974 6.58522 18.1541 6.67507 18.1859 6.81366C18.2098 6.91775 18.2098 7.08192 18.1859 7.18602C18.1541 7.3246 18.0974 7.41445 17.9839 7.59415C17.0461 9.07914 14.2545 12.8332 10.0003 12.8332C5.74617 12.8332 2.95461 9.07914 2.01677 7.59415Z",
    stroke: "#F8478D",
    strokeWidth: "1.67",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M10.0003 9.49984C11.381 9.49984 12.5003 8.38055 12.5003 6.99984C12.5003 5.61913 11.381 4.49984 10.0003 4.49984C8.61962 4.49984 7.50034 5.61913 7.50034 6.99984C7.50034 8.38055 8.61962 9.49984 10.0003 9.49984Z",
    stroke: "#F8478D",
    strokeWidth: "1.67",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  })),
  hidePassowrd: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "20",
    height: "20",
    viewBox: "0 0 20 20",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M8.95245 4.2436C9.29113 4.19353 9.64051 4.16667 10.0003 4.16667C14.2545 4.16667 17.0461 7.9207 17.9839 9.40569C18.0974 9.58542 18.1542 9.67528 18.1859 9.81389C18.2098 9.91799 18.2098 10.0822 18.1859 10.1863C18.1541 10.3249 18.097 10.4154 17.9827 10.5963C17.7328 10.9918 17.3518 11.5476 16.8471 12.1504M5.6036 5.59586C3.80187 6.81808 2.57871 8.51615 2.01759 9.4044C1.90357 9.58489 1.84656 9.67514 1.81478 9.81373C1.79091 9.91783 1.7909 10.082 1.81476 10.1861C1.84652 10.3247 1.90328 10.4146 2.01678 10.5943C2.95462 12.0793 5.74618 15.8333 10.0003 15.8333C11.7157 15.8333 13.1932 15.223 14.4074 14.3972M2.50035 2.5L17.5003 17.5M8.23258 8.23223C7.78017 8.68464 7.50035 9.30964 7.50035 10C7.50035 11.3807 8.61964 12.5 10.0003 12.5C10.6907 12.5 11.3157 12.2202 11.7681 11.7678",
    stroke: "#5A5F61",
    strokeWidth: "1.67",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  })),
  minus: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "24",
    height: "24",
    viewBox: "0 0 24 24",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M8 12H16M22 12C22 17.5228 17.5228 22 12 22C6.47715 22 2 17.5228 2 12C2 6.47715 6.47715 2 12 2C17.5228 2 22 6.47715 22 12Z",
    stroke: "#98A2B3",
    strokeWidth: "2",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  })),
  plus: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "24",
    height: "24",
    viewBox: "0 0 24 24",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M12 8V16M8 12H16M22 12C22 17.5228 17.5228 22 12 22C6.47715 22 2 17.5228 2 12C2 6.47715 6.47715 2 12 2C17.5228 2 22 6.47715 22 12Z",
    stroke: "#98A2B3",
    strokeWidth: "2",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  })),
  pluginList: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "48",
    height: "48",
    viewBox: "0 0 48 48",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M10.6715 41.615C11.0288 41.2231 11.2158 40.7053 11.1914 40.1756C11.1671 39.6458 10.9333 39.1474 10.5415 38.79C7.15342 35.7059 4.92693 31.5521 4.23437 27.0232C3.54182 22.4943 4.42519 17.8649 6.73675 13.9092C9.04831 9.95354 12.6479 6.91143 16.9336 5.29163C21.2192 3.67182 25.9311 3.57254 30.2812 5.01037C34.6313 6.44821 38.3558 9.33599 40.832 13.1908C43.3081 17.0456 44.3857 21.6336 43.8845 26.1877C43.3834 30.7417 41.3338 34.9857 38.0787 38.2097C34.8235 41.4338 30.5601 43.4426 26.0015 43.9V35.96C28.5768 35.8569 31.0129 34.7635 32.8015 32.9078C34.5902 31.052 35.5932 28.5774 35.6015 26V22C35.6015 21.4696 35.3908 20.9609 35.0157 20.5858C34.6406 20.2107 34.1319 20 33.6015 20H30.0015V14C30.0015 13.4696 29.7908 12.9609 29.4157 12.5858C29.0406 12.2107 28.5319 12 28.0015 12C27.4711 12 26.9623 12.2107 26.5873 12.5858C26.2122 12.9609 26.0015 13.4696 26.0015 14V20H22.0015V14C22.0015 13.4696 21.7908 12.9609 21.4157 12.5858C21.0406 12.2107 20.5319 12 20.0015 12C19.4711 12 18.9623 12.2107 18.5873 12.5858C18.2122 12.9609 18.0015 13.4696 18.0015 14V20H14.4015C13.8711 20 13.3623 20.2107 12.9873 20.5858C12.6122 20.9609 12.4015 21.4696 12.4015 22V26C12.4097 28.5774 13.4128 31.052 15.2014 32.9078C16.9901 34.7635 19.4262 35.8569 22.0015 35.96V46C22.0015 46.5304 22.2122 47.0391 22.5873 47.4142C22.9623 47.7893 23.4711 48 24.0015 48C29.6024 47.9997 35.0269 46.0404 39.3353 42.4616C43.6437 38.8827 46.5648 33.9097 47.5925 28.4039C48.6203 22.8981 47.69 17.2061 44.9628 12.314C42.2356 7.42186 37.8833 3.63762 32.6596 1.61671C27.436 -0.404199 21.67 -0.534496 16.3604 1.24839C11.0508 3.03127 6.53197 6.61504 3.58657 11.379C0.641169 16.1429 -0.545284 21.787 0.232704 27.3337C1.01069 32.8803 3.70412 37.9802 7.84649 41.75C8.23903 42.1067 8.75717 42.2928 9.28694 42.2675C9.81672 42.2422 10.3148 42.0075 10.6715 41.615ZM16.4015 26V24H31.6015V26C31.6015 27.5913 30.9693 29.1174 29.8441 30.2426C28.7189 31.3679 27.1928 32 25.6015 32H22.4015C20.8102 32 19.2841 31.3679 18.1588 30.2426C17.0336 29.1174 16.4015 27.5913 16.4015 26Z",
    fill: "#F8478D"
  })),
  sidebar: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "33",
    height: "32",
    viewBox: "0 0 33 32",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    x: "0.666672",
    width: "32",
    height: "32",
    rx: "8",
    fill: "url(#paint0_linear_2820_689)"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M19.1667 8.5V23.5M13.1667 8.5H20.1667C21.5668 8.5 22.2669 8.5 22.8016 8.77248C23.2721 9.01217 23.6545 9.39462 23.8942 9.86502C24.1667 10.3998 24.1667 11.0999 24.1667 12.5V19.5C24.1667 20.9001 24.1667 21.6002 23.8942 22.135C23.6545 22.6054 23.2721 22.9878 22.8016 23.2275C22.2669 23.5 21.5668 23.5 20.1667 23.5H13.1667C11.7665 23.5 11.0665 23.5 10.5317 23.2275C10.0613 22.9878 9.67884 22.6054 9.43916 22.135C9.16667 21.6002 9.16667 20.9001 9.16667 19.5V12.5C9.16667 11.0999 9.16667 10.3998 9.43916 9.86502C9.67884 9.39462 10.0613 9.01217 10.5317 8.77248C11.0665 8.5 11.7665 8.5 13.1667 8.5Z",
    stroke: "white",
    strokeWidth: "1.67",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("defs", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("linearGradient", {
    id: "paint0_linear_2820_689",
    x1: "3.00163",
    y1: "3.5",
    x2: "30.5016",
    y2: "30",
    gradientUnits: "userSpaceOnUse"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("stop", {
    stopColor: "#5081F5"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("stop", {
    offset: "1",
    stopColor: "#A769F5"
  })))),
  star: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "116",
    height: "20",
    viewBox: "0 0 116 20",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M9.14319 1.42372C9.53185 0.777902 10.4681 0.777901 10.8568 1.42372L13.0731 5.10651C13.2128 5.33853 13.4405 5.504 13.7043 5.56509L17.8918 6.53491C18.6261 6.70498 18.9154 7.59545 18.4213 8.16466L15.6036 11.4106C15.4261 11.6151 15.3391 11.8828 15.3625 12.1526L15.7342 16.4347C15.7994 17.1857 15.0419 17.736 14.3478 17.442L10.3901 15.7653C10.1408 15.6596 9.85924 15.6596 9.60991 15.7653L5.65216 17.442C4.95813 17.736 4.20065 17.1857 4.26582 16.4347L4.63745 12.1526C4.66087 11.8828 4.57387 11.6151 4.39637 11.4106L1.57871 8.16466C1.0846 7.59545 1.37393 6.70498 2.10824 6.53491L6.29567 5.56509C6.55948 5.504 6.78723 5.33853 6.92685 5.10652L9.14319 1.42372Z",
    fill: "#F9B83A"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M33.1432 1.42372C33.5319 0.777902 34.4681 0.777901 34.8568 1.42372L37.0731 5.10651C37.2128 5.33853 37.4405 5.504 37.7043 5.56509L41.8918 6.53491C42.6261 6.70498 42.9154 7.59545 42.4213 8.16466L39.6036 11.4106C39.4261 11.6151 39.3391 11.8828 39.3625 12.1526L39.7342 16.4347C39.7994 17.1857 39.0419 17.736 38.3478 17.442L34.3901 15.7653C34.1408 15.6596 33.8592 15.6596 33.6099 15.7653L29.6522 17.442C28.9581 17.736 28.2006 17.1857 28.2658 16.4347L28.6375 12.1526C28.6609 11.8828 28.5739 11.6151 28.3964 11.4106L25.5787 8.16466C25.0846 7.59545 25.3739 6.70498 26.1082 6.53491L30.2957 5.56509C30.5595 5.504 30.7872 5.33853 30.9269 5.10652L33.1432 1.42372Z",
    fill: "#F9B83A"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M57.1432 1.42372C57.5319 0.777902 58.4681 0.777901 58.8568 1.42372L61.0731 5.10651C61.2128 5.33853 61.4405 5.504 61.7043 5.56509L65.8918 6.53491C66.6261 6.70498 66.9154 7.59545 66.4213 8.16466L63.6036 11.4106C63.4261 11.6151 63.3391 11.8828 63.3625 12.1526L63.7342 16.4347C63.7994 17.1857 63.0419 17.736 62.3478 17.442L58.3901 15.7653C58.1408 15.6596 57.8592 15.6596 57.6099 15.7653L53.6522 17.442C52.9581 17.736 52.2006 17.1857 52.2658 16.4347L52.6375 12.1526C52.6609 11.8828 52.5739 11.6151 52.3964 11.4106L49.5787 8.16466C49.0846 7.59545 49.3739 6.70498 50.1082 6.53491L54.2957 5.56509C54.5595 5.504 54.7872 5.33853 54.9269 5.10652L57.1432 1.42372Z",
    fill: "#F9B83A"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M81.1432 1.42372C81.5319 0.777902 82.4681 0.777901 82.8568 1.42372L85.0731 5.10651C85.2128 5.33853 85.4405 5.504 85.7043 5.56509L89.8918 6.53491C90.6261 6.70498 90.9154 7.59545 90.4213 8.16466L87.6036 11.4106C87.4261 11.6151 87.3391 11.8828 87.3625 12.1526L87.7342 16.4347C87.7994 17.1857 87.0419 17.736 86.3478 17.442L82.3901 15.7653C82.1408 15.6596 81.8592 15.6596 81.6099 15.7653L77.6522 17.442C76.9581 17.736 76.2006 17.1857 76.2658 16.4347L76.6375 12.1526C76.6609 11.8828 76.5739 11.6151 76.3964 11.4106L73.5787 8.16466C73.0846 7.59545 73.3739 6.70498 74.1082 6.53491L78.2957 5.56509C78.5595 5.504 78.7872 5.33853 78.9269 5.10652L81.1432 1.42372Z",
    fill: "#F9B83A"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M105.143 1.42372C105.532 0.777902 106.468 0.777901 106.857 1.42372L109.073 5.10651C109.213 5.33853 109.441 5.504 109.704 5.56509L113.892 6.53491C114.626 6.70498 114.915 7.59545 114.421 8.16466L111.604 11.4106C111.426 11.6151 111.339 11.8828 111.363 12.1526L111.734 16.4347C111.799 17.1857 111.042 17.736 110.348 17.442L106.39 15.7653C106.141 15.6596 105.859 15.6596 105.61 15.7653L101.652 17.442C100.958 17.736 100.201 17.1857 100.266 16.4347L100.637 12.1526C100.661 11.8828 100.574 11.6151 100.396 11.4106L97.5787 8.16466C97.0846 7.59545 97.3739 6.70498 98.1082 6.53491L102.296 5.56509C102.559 5.504 102.787 5.33853 102.927 5.10652L105.143 1.42372Z",
    fill: "#F9B83A"
  })),
  review: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "20",
    height: "20",
    viewBox: "0 0 20 20",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M7.56246 11.8748L9.99996 10.3957L12.4375 11.8748L11.7916 9.104L13.9583 7.229L11.1041 6.99984L9.99996 4.37484L8.89579 6.99984L6.04163 7.229L8.20829 9.104L7.56246 11.8748ZM1.66663 18.3332V3.33317C1.66663 2.87484 1.82996 2.48262 2.15663 2.1565C2.48329 1.83039 2.87551 1.66706 3.33329 1.6665H16.6666C17.125 1.6665 17.5175 1.82984 17.8441 2.1565C18.1708 2.48317 18.3338 2.87539 18.3333 3.33317V13.3332C18.3333 13.7915 18.1702 14.184 17.8441 14.5107C17.518 14.8373 17.1255 15.0004 16.6666 14.9998H4.99996L1.66663 18.3332ZM4.29163 13.3332H16.6666V3.33317H3.33329V14.2707L4.29163 13.3332Z",
    fill: "currentColor"
  }))
};
const Icon = ({
  icon,
  tooltip,
  label
}) => {
  const Icon = icons[icon];
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, Icon && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(Icon, null), label && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("h3", {
    className: "cwLabel"
  }, label), tooltip && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
    className: "cw-tooltip"
  }, tooltip));
};
/* harmony default export */ __webpack_exports__["default"] = (Icon);

/***/ }),

/***/ "./src/dashboard/components/Sidebar/index.jsx":
/*!****************************************************!*\
  !*** ./src/dashboard/components/Sidebar/index.jsx ***!
  \****************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Icon__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Icon */ "./src/dashboard/components/Icon/index.jsx");



const Sidebar = ({
  sidebarSettings,
  openInNewTab
}) => {
  const sidebarListing = sidebar => {
    return sidebar.map((sidebaritem, index) => {
      return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "cw-sidebarbody",
        key: index
      }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("h3", null, sidebaritem.heading), sidebaritem.icon && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_Icon__WEBPACK_IMPORTED_MODULE_1__["default"], {
        icon: sidebaritem.icon
      })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, sidebaritem.para), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "cw-button"
      }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
        href: sidebaritem.buttonUrl,
        target: openInNewTab ? "_blank" : "_self",
        className: "cw-button-btn outline"
      }, sidebaritem.imageurl, sidebaritem.buttonText, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_Icon__WEBPACK_IMPORTED_MODULE_1__["default"], {
        icon: "arrowtwo"
      }))));
    });
  };
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "cw-sidebar"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "cw-sidebar-list"
  }, sidebarListing(sidebarSettings))));
};
/* harmony default export */ __webpack_exports__["default"] = (Sidebar);

/***/ }),

/***/ "./src/dashboard/components/TabHeader/index.jsx":
/*!******************************************************!*\
  !*** ./src/dashboard/components/TabHeader/index.jsx ***!
  \******************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! .. */ "./src/dashboard/components/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);



const TabHeader = ({
  title
}) => {
  const docLinks = [{
    name: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('View Website', 'blossom-floral'),
    link: cw_dashboard.website,
    icon: "globe"
  }, {
    name: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('View Tutorials ', 'blossom-floral'),
    link: cw_dashboard.videotutorial,
    icon: "youtube"
  }, {
    name: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Contact Support', 'blossom-floral'),
    link: cw_dashboard.support,
    icon: "support"
  }, {
    name: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Docs', 'blossom-floral'),
    link: cw_dashboard.docmentation,
    icon: "doc"
  }];
  const docLinkListing = () => {
    return docLinks.map((list, index) => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
      key: index,
      href: list.link,
      target: "_blank"
    }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(___WEBPACK_IMPORTED_MODULE_1__.Icon, {
      icon: list.icon,
      tooltip: list.name
    })));
  };
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("header", {
    className: "navbar"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("h1", null, title), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "info"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
    className: "version"
  }, cw_dashboard.theme_version), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "doc-links"
  }, docLinkListing()))));
};
/* harmony default export */ __webpack_exports__["default"] = (TabHeader);

/***/ }),

/***/ "./src/dashboard/components/Tab/index.jsx":
/*!************************************************!*\
  !*** ./src/dashboard/components/Tab/index.jsx ***!
  \************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _useTabs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./useTabs */ "./src/dashboard/components/Tab/useTabs.jsx");
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! .. */ "./src/dashboard/components/index.js");
/* harmony import */ var _assets_img_logo_png__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../assets/img/logo.png */ "./src/dashboard/assets/img/logo.png");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__);





const Tab = ({
  tabsData,
  onChange,
  activeTabTitle
}) => {
  const {
    renderTabs,
    renderContent
  } = (0,_useTabs__WEBPACK_IMPORTED_MODULE_1__["default"])(tabsData, 0, onChange);
  const GetPro = () => {
    return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "get-pro"
    }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("h3", null, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)('Blossom Floral Pro', 'blossom-floral')), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)('Get access to all unlimited features.', 'blossom-floral')), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
      className: "cw-button-btn primary-btn",
      target: "_blank",
      href: cw_dashboard.get_pro
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)('Get Pro'))));
  };
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "cw-tabs-container"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "cw-tabs"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "wrapper"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "top"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "logo"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("img", {
    src: _assets_img_logo_png__WEBPACK_IMPORTED_MODULE_3__,
    alt: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)('Logo', 'blossom-floral')
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "cw-tabs-button"
  }, renderTabs())), GetPro())), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "wrapper"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(___WEBPACK_IMPORTED_MODULE_2__.TabHeader, {
    title: activeTabTitle
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "cw-tabs-content"
  }, renderContent())));
};
/* harmony default export */ __webpack_exports__["default"] = (Tab);

/***/ }),

/***/ "./src/dashboard/components/Tab/useTabs.jsx":
/*!**************************************************!*\
  !*** ./src/dashboard/components/Tab/useTabs.jsx ***!
  \**************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_router_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react-router-dom */ "./node_modules/react-router/dist/index.js");



function useTabs(initialTabs, initialActiveTab = 0, onChange) {
  const tabsRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(initialTabs);
  const [activeTab, setActiveTab] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(initialActiveTab);
  const navigate = (0,react_router_dom__WEBPACK_IMPORTED_MODULE_1__.useNavigate)();
  const handleTabClick = index => {
    if (index !== activeTab) {
      setActiveTab(index);
      const newHash = tabsRef.current[index].title.toLowerCase().replace(/ /g, "-");
      if (onChange) {
        onChange(tabsRef.current[index].title);
      }
      navigate(`/wp-admin/themes.php?page=blossom-floral-dashboard#${newHash}`);
    }
  };
  const checkHash = () => {
    const hash = window.location.hash.substring(1);
    const tabIndex = tabsRef.current.findIndex(tab => tab.title.toLowerCase().replace(/ /g, "-") === hash);
    if (tabIndex !== -1 && tabIndex !== activeTab) {
      setActiveTab(tabIndex);
      if (onChange) {
        onChange(tabsRef.current[tabIndex].title);
      }
    }
  };
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    checkHash();
    window.addEventListener('hashchange', checkHash);
    return () => {
      window.removeEventListener('hashchange', checkHash);
    };
  }, []);
  const renderTabs = () => {
    return tabsRef.current.map((tab, index) => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("button", {
      key: index,
      onClick: () => handleTabClick(index),
      className: activeTab === index ? 'active-tab' : ''
    }, tab.icon, tab.title));
  };
  const renderContent = () => {
    return tabsRef.current[activeTab].content;
  };
  return {
    renderTabs,
    renderContent
  };
}
/* harmony default export */ __webpack_exports__["default"] = (useTabs);

/***/ }),

/***/ "./src/dashboard/components/images.js":
/*!********************************************!*\
  !*** ./src/dashboard/components/images.js ***!
  \********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   GDPR: function() { return /* reexport default export from named module */ _assets_img_GDPR_jpg__WEBPACK_IMPORTED_MODULE_2__; },
/* harmony export */   SEO: function() { return /* reexport default export from named module */ _assets_img_SEO_jpg__WEBPACK_IMPORTED_MODULE_6__; },
/* harmony export */   aboutPage: function() { return /* reexport default export from named module */ _assets_img_Blossom_Floral_About_png__WEBPACK_IMPORTED_MODULE_12__; },
/* harmony export */   customFonts: function() { return /* reexport default export from named module */ _assets_img_customFonts_jpg__WEBPACK_IMPORTED_MODULE_0__; },
/* harmony export */   fashionPage: function() { return /* reexport default export from named module */ _assets_img_Blossom_Floral_Fashion_png__WEBPACK_IMPORTED_MODULE_13__; },
/* harmony export */   freevspro: function() { return /* reexport default export from named module */ _assets_img_freevspro_webp__WEBPACK_IMPORTED_MODULE_1__; },
/* harmony export */   homePage: function() { return /* reexport default export from named module */ _assets_img_Blossom_Floral_Home_png__WEBPACK_IMPORTED_MODULE_11__; },
/* harmony export */   logo: function() { return /* reexport default export from named module */ _assets_img_logo_png__WEBPACK_IMPORTED_MODULE_3__; },
/* harmony export */   pluginsSetup: function() { return /* reexport default export from named module */ _assets_img_pluginsSetup_jpg__WEBPACK_IMPORTED_MODULE_4__; },
/* harmony export */   salesFunnel: function() { return /* reexport default export from named module */ _assets_img_salesFunnel_jpg__WEBPACK_IMPORTED_MODULE_5__; },
/* harmony export */   themeClub: function() { return /* reexport default export from named module */ _assets_img_themeClub_jpg__WEBPACK_IMPORTED_MODULE_7__; },
/* harmony export */   themeInstallation: function() { return /* reexport default export from named module */ _assets_img_themeInstallation_jpg__WEBPACK_IMPORTED_MODULE_8__; },
/* harmony export */   vipSiteCare: function() { return /* reexport default export from named module */ _assets_img_vipSiteCare_jpg__WEBPACK_IMPORTED_MODULE_9__; },
/* harmony export */   vipSupport: function() { return /* reexport default export from named module */ _assets_img_vipSupport_jpg__WEBPACK_IMPORTED_MODULE_10__; }
/* harmony export */ });
/* harmony import */ var _assets_img_customFonts_jpg__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../assets/img/customFonts.jpg */ "./src/dashboard/assets/img/customFonts.jpg");
/* harmony import */ var _assets_img_freevspro_webp__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../assets/img/freevspro.webp */ "./src/dashboard/assets/img/freevspro.webp");
/* harmony import */ var _assets_img_GDPR_jpg__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../assets/img/GDPR.jpg */ "./src/dashboard/assets/img/GDPR.jpg");
/* harmony import */ var _assets_img_logo_png__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../assets/img/logo.png */ "./src/dashboard/assets/img/logo.png");
/* harmony import */ var _assets_img_pluginsSetup_jpg__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../assets/img/pluginsSetup.jpg */ "./src/dashboard/assets/img/pluginsSetup.jpg");
/* harmony import */ var _assets_img_salesFunnel_jpg__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../assets/img/salesFunnel.jpg */ "./src/dashboard/assets/img/salesFunnel.jpg");
/* harmony import */ var _assets_img_SEO_jpg__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../assets/img/SEO.jpg */ "./src/dashboard/assets/img/SEO.jpg");
/* harmony import */ var _assets_img_themeClub_jpg__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../assets/img/themeClub.jpg */ "./src/dashboard/assets/img/themeClub.jpg");
/* harmony import */ var _assets_img_themeInstallation_jpg__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../assets/img/themeInstallation.jpg */ "./src/dashboard/assets/img/themeInstallation.jpg");
/* harmony import */ var _assets_img_vipSiteCare_jpg__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../assets/img/vipSiteCare.jpg */ "./src/dashboard/assets/img/vipSiteCare.jpg");
/* harmony import */ var _assets_img_vipSupport_jpg__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../assets/img/vipSupport.jpg */ "./src/dashboard/assets/img/vipSupport.jpg");
/* harmony import */ var _assets_img_Blossom_Floral_Home_png__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../assets/img/Blossom Floral Home.png */ "./src/dashboard/assets/img/Blossom Floral Home.png");
/* harmony import */ var _assets_img_Blossom_Floral_About_png__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../assets/img/Blossom Floral About.png */ "./src/dashboard/assets/img/Blossom Floral About.png");
/* harmony import */ var _assets_img_Blossom_Floral_Fashion_png__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../assets/img/Blossom Floral Fashion.png */ "./src/dashboard/assets/img/Blossom Floral Fashion.png");















/***/ }),

/***/ "./src/dashboard/components/index.js":
/*!*******************************************!*\
  !*** ./src/dashboard/components/index.js ***!
  \*******************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Card: function() { return /* reexport safe */ _Card__WEBPACK_IMPORTED_MODULE_4__["default"]; },
/* harmony export */   Heading: function() { return /* reexport safe */ _Heading__WEBPACK_IMPORTED_MODULE_5__["default"]; },
/* harmony export */   Icon: function() { return /* reexport safe */ _Icon__WEBPACK_IMPORTED_MODULE_0__["default"]; },
/* harmony export */   Sidebar: function() { return /* reexport safe */ _Sidebar__WEBPACK_IMPORTED_MODULE_2__["default"]; },
/* harmony export */   Tab: function() { return /* reexport safe */ _Tab__WEBPACK_IMPORTED_MODULE_1__["default"]; },
/* harmony export */   TabHeader: function() { return /* reexport safe */ _TabHeader__WEBPACK_IMPORTED_MODULE_3__["default"]; }
/* harmony export */ });
/* harmony import */ var _Icon__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Icon */ "./src/dashboard/components/Icon/index.jsx");
/* harmony import */ var _Tab__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Tab */ "./src/dashboard/components/Tab/index.jsx");
/* harmony import */ var _Sidebar__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Sidebar */ "./src/dashboard/components/Sidebar/index.jsx");
/* harmony import */ var _TabHeader__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./TabHeader */ "./src/dashboard/components/TabHeader/index.jsx");
/* harmony import */ var _Card__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./Card */ "./src/dashboard/components/Card/index.jsx");
/* harmony import */ var _Heading__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./Heading */ "./src/dashboard/components/Heading/index.jsx");







/***/ }),

/***/ "./src/dashboard/pages/FAQ/index.jsx":
/*!*******************************************!*\
  !*** ./src/dashboard/pages/FAQ/index.jsx ***!
  \*******************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../components */ "./src/dashboard/components/index.js");




function FAQ() {
  const faqContent = [{
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('What is the difference between Free and Pro?', 'blossom-floral'),
    description: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Both Free and Pro version of the themes are well-built. However, the Pro version comes with many additional features.', 'blossom-floral')), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('With the Pro version, you can change the look and feel of your website in seconds. In just a few clicks, you can change the color and typography of your website. The premium version lets you have better control over the theme as it comes with more customization options. Not just that, the theme also has more sections and layout options as compared to the free version. The Pro version is multi-language compatible as well.', 'blossom-floral')), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
      dangerouslySetInnerHTML: {
        __html: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.sprintf)((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Overall, you will have more control over your website with the Pro version. You can find out more about the difference between Free and Pro versions %s.', 'blossom-floral'), `<a target="_blank" href=${cw_dashboard.get_pro}>here</a>`)
      }
    }))
  }, {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('What are the advantages of upgrading to the Premium version?', 'blossom-floral'),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('With Premium version, besides the extra features and frequent updates, you get premium support. If you run into any theme issues, you will get a lot quicker response compared to the free support.', 'blossom-floral')
  }, {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Upgrading to the Pro version- will I lose my changes?', 'blossom-floral'),
    description: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('When you upgrade to the Pro theme, your posts, pages, media, categories, and other data will remain intact-- all your data is saved.', 'blossom-floral')), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('However, since the Pro version comes with added features and settings, you will need to set up the additional features in the customizer. This process is simple and only takes a few minutes.', 'blossom-floral')), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('The Pro version is built with lots of flexibility in mind for future upgrades. Therefore, it is slightly different than the free theme but extremely flexible and easy-to-use.', 'blossom-floral')))
  }, {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('How do I change the copyright text?', 'blossom-floral'),
    description: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
      dangerouslySetInnerHTML: {
        __html: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.sprintf)((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('You can change the copyright text going to %1$s Appearance > Customize > Footer Settings. %2$s However, if you want to hide the author credit text, please %3$s.', 'blossom-floral'), '<b>', '</b>', `<a target="_blank" href=${cw_dashboard.get_pro}>upgrade to the Pro version</a>`)
      }
    })
  }, {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Why is my theme not working well?', 'blossom-floral'),
    description: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('If your customizer is not loading properly or you are having issues with the theme, it might be due to the plugin conflict.', 'blossom-floral')), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
      dangerouslySetInnerHTML: {
        __html: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.sprintf)((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('To solve the issue, deactivate all the plugins first, except the ones recommended by the theme. Then, hard reload your website using %1$s "Ctrl+Shift+R" %2$s on Windows. If the issues are fixed, start activating the plugins one by one, and reload and check your site each time. This will help you find out the plugin that is causing the problem.', 'blossom-floral'), '<b>', '</b>')
      }
    }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
      dangerouslySetInnerHTML: {
        __html: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.sprintf)((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('If this didn\'t help, please %s.', 'blossom-floral'), `<a target="_blank" href=${cw_dashboard.support}> contact us here</a>`)
      }
    }))
  }, {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('How can I solve my issues quickly and get faster support?', 'blossom-floral'),
    description: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Before you send us a support ticket for any issues, please make sure you have updated the theme to the latest version. We might have fixed the bug in the theme update.', 'blossom-floral')), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('When you submit the support ticket, please try to provide as much details as possible so that we can solve your problem faster. We recommend you to send us a screenshot(s) with issues explained and your website\'s address (URL). You can contact us ', 'blossom-floral'), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
      href: cw_dashboard.support,
      target: "_blank"
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('here.', 'blossom-floral'))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Also, you might experience a slower response time during the weekend, so please bear with us.', 'blossom-floral')))
  }];
  const [openIndex, setOpenIndex] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(0);
  const [height, setHeight] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)('0px');
  const contentRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    setHeight(openIndex !== -1 ? `${contentRef.current.scrollHeight}px` : '0px');
  }, [openIndex]);
  const toggleDescription = index => {
    setOpenIndex(index === openIndex ? -1 : index);
  };
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, faqContent.map((content, index) => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "faq-item",
    key: index
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "faq-title",
    onClick: () => toggleDescription(index)
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("h2", null, content.title), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_2__.Icon, {
    icon: openIndex === index ? 'minus' : 'plus'
  }))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "faq-description",
    ref: openIndex === index ? contentRef : null,
    style: {
      maxHeight: openIndex === index ? height : '0px',
      overflow: 'hidden',
      transition: 'max-height 0.5s ease'
    }
  }, typeof content.description === 'string' ? (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, content.description) : content.description))));
}
/* harmony default export */ __webpack_exports__["default"] = (FAQ);

/***/ }),

/***/ "./src/dashboard/pages/FreePro/index.jsx":
/*!***********************************************!*\
  !*** ./src/dashboard/pages/FreePro/index.jsx ***!
  \***********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _assets_img_freevspro_webp__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../assets/img/freevspro.webp */ "./src/dashboard/assets/img/freevspro.webp");
/* harmony import */ var _components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../components */ "./src/dashboard/components/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__);




const FreePro = () => {
  const sidebarSettings = [{
    heading: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('We Value Your Feedback!', 'blossom-floral'),
    icon: "star",
    para: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Your review helps us improve and assists others in making informed choices. Share your thoughts today!", 'blossom-floral'),
    imageurl: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_2__.Icon, {
      icon: "review"
    }),
    buttonText: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Leave a Review', 'blossom-floral'),
    buttonUrl: cw_dashboard.review
  }, {
    heading: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Knowledge Base', 'blossom-floral'),
    para: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Need help using our theme? Visit our well-organized Knowledge Base!", 'blossom-floral'),
    imageurl: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_2__.Icon, {
      icon: "documentation"
    }),
    buttonText: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Explore', 'blossom-floral'),
    buttonUrl: cw_dashboard.docmentation
  }, {
    heading: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Need Assistance? ', 'blossom-floral'),
    para: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("If you need help or have any questions, don't hesitate to contact our support team. We're here to assist you!", 'blossom-floral'),
    imageurl: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_2__.Icon, {
      icon: "supportTwo"
    }),
    buttonText: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Submit a Ticket', 'blossom-floral'),
    buttonUrl: cw_dashboard.support
  }];
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "customizer-settings"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "cw-customizer"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("img", {
    className: "freepro",
    src: _assets_img_freevspro_webp__WEBPACK_IMPORTED_MODULE_1__,
    alt: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Free vs Pro image", "blossom-floral")
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_2__.Sidebar, {
    sidebarSettings: sidebarSettings,
    openInNewTab: true
  })));
};
/* harmony default export */ __webpack_exports__["default"] = (FreePro);

/***/ }),

/***/ "./src/dashboard/pages/Home/index.jsx":
/*!********************************************!*\
  !*** ./src/dashboard/pages/Home/index.jsx ***!
  \********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../components */ "./src/dashboard/components/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);



const Homepage = () => {
  const cardLists = [{
    iconSvg: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_1__.Icon, {
      icon: "site"
    }),
    heading: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Site Identity', 'blossom-floral'),
    buttonText: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Customize', 'blossom-floral'),
    buttonUrl: cw_dashboard.custom_logo
  }, {
    iconSvg: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_1__.Icon, {
      icon: "colorsetting"
    }),
    heading: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Color Settings", 'blossom-floral'),
    buttonText: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Customize', 'blossom-floral'),
    buttonUrl: cw_dashboard.colors
  }, {
    iconSvg: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_1__.Icon, {
      icon: "layoutsetting"
    }),
    heading: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Layout Settings", 'blossom-floral'),
    buttonText: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Customize', 'blossom-floral'),
    buttonUrl: cw_dashboard.layout
  }, {
    iconSvg: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_1__.Icon, {
      icon: "frontpagesetting"
    }),
    heading: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Frontpage Settings", 'blossom-floral'),
    buttonText: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Customize', 'blossom-floral'),
    buttonUrl: cw_dashboard.front
  }, {
    iconSvg: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_1__.Icon, {
      icon: "generalsetting"
    }),
    heading: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("General Settings"),
    buttonText: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Customize', 'blossom-floral'),
    buttonUrl: cw_dashboard.general
  }, {
    iconSvg: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_1__.Icon, {
      icon: "footersetting"
    }),
    heading: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Footer Settings', 'blossom-floral'),
    buttonText: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Customize', 'blossom-floral'),
    buttonUrl: cw_dashboard.footer
  }];
  const proSettings = [{
    heading: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Header Layouts', 'blossom-floral'),
    para: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Choose from different unique header layouts.', 'blossom-floral'),
    buttonText: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Learn More', 'blossom-floral'),
    buttonUrl: cw_dashboard?.get_pro
  }, {
    heading: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Multiple Layouts', 'blossom-floral'),
    para: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Choose layouts for blogs, banners, posts and more.', 'blossom-floral'),
    buttonText: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Learn More', 'blossom-floral'),
    buttonUrl: cw_dashboard?.get_pro
  }, {
    heading: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Multiple Sidebar', 'blossom-floral'),
    para: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Set different sidebars for posts and pages.', 'blossom-floral'),
    buttonText: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Learn More', 'blossom-floral'),
    buttonUrl: cw_dashboard?.get_pro
  }, {
    heading: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Top Bar Settings', 'blossom-floral'),
    para: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Show a notice or newsletter at the top.', 'blossom-floral'),
    buttonText: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Learn More', 'blossom-floral'),
    buttonUrl: cw_dashboard?.get_pro
  }, {
    para: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Boost your website performance with ease.', 'blossom-floral'),
    heading: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Performance Settings', 'blossom-floral'),
    buttonText: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Learn More', 'blossom-floral'),
    buttonUrl: cw_dashboard?.get_pro
  }, {
    para: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Choose typography for different heading tags.', 'blossom-floral'),
    heading: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Typography Settings', 'blossom-floral'),
    buttonText: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Learn More', 'blossom-floral'),
    buttonUrl: cw_dashboard?.get_pro
  }, {
    para: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Import the demo content to kickstart your site.', 'blossom-floral'),
    heading: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('One Click Demo Import', 'blossom-floral'),
    buttonText: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Learn More', 'blossom-floral'),
    buttonUrl: cw_dashboard?.get_pro
  }];
  const sidebarSettings = [{
    heading: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('We Value Your Feedback!', 'blossom-floral'),
    icon: "star",
    para: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Your review helps us improve and assists others in making informed choices. Share your thoughts today!", 'blossom-floral'),
    imageurl: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_1__.Icon, {
      icon: "review"
    }),
    buttonText: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Leave a Review', 'blossom-floral'),
    buttonUrl: cw_dashboard.review
  }, {
    heading: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Knowledge Base', 'blossom-floral'),
    para: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Need help using our theme? Visit our well-organized Knowledge Base!", 'blossom-floral'),
    imageurl: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_1__.Icon, {
      icon: "documentation"
    }),
    buttonText: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Explore', 'blossom-floral'),
    buttonUrl: cw_dashboard.docmentation
  }, {
    heading: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Need Assistance? ', 'blossom-floral'),
    para: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("If you need help or have any questions, don't hesitate to contact our support team. We're here to assist you!", 'blossom-floral'),
    imageurl: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_1__.Icon, {
      icon: "supportTwo"
    }),
    buttonText: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Submit a Ticket', 'blossom-floral'),
    buttonUrl: cw_dashboard.support
  }];
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "customizer-settings"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "cw-customizer"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "video-section"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "cw-settings"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("h2", null, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Blossom Floral Tutorial', 'blossom-floral'))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("iframe", {
    src: "https://www.youtube.com/embed/dhkUg3iTgbg?si=K8AYNHEN_x7bwsKR",
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('How To Start A Blog in 2023 | Blossom Floral Video Tutorial', 'blossom-floral'),
    frameBorder: "0",
    allow: "accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share",
    referrerPolicy: "strict-origin-when-cross-origin",
    allowFullScreen: true
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_1__.Heading, {
    heading: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Quick Customizer Settings', 'blossom-floral'),
    buttonText: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Go To Customizer', 'blossom-floral'),
    buttonUrl: cw_dashboard?.customizer_url,
    openInNewTab: true
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_1__.Card, {
    cardList: cardLists,
    cardPlace: "customizer",
    cardCol: "three-col"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_1__.Heading, {
    heading: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('More features with Pro version', 'blossom-floral'),
    buttonText: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Go To Customizer', 'blossom-floral'),
    buttonUrl: cw_dashboard?.customizer_url,
    openInNewTab: true
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_1__.Card, {
    cardList: proSettings,
    cardPlace: "cw-pro",
    cardCol: "two-col"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "cw-button"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
    href: cw_dashboard?.get_pro,
    target: "_blank",
    className: "cw-button-btn primary-btn long-button"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Learn more about the Pro version', 'blossom-floral')))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_1__.Sidebar, {
    sidebarSettings: sidebarSettings,
    openInNewTab: true
  })));
};
/* harmony default export */ __webpack_exports__["default"] = (Homepage);

/***/ }),

/***/ "./src/dashboard/pages/Offers/index.jsx":
/*!**********************************************!*\
  !*** ./src/dashboard/pages/Offers/index.jsx ***!
  \**********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _components_images__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../components/images */ "./src/dashboard/components/images.js");



const Offers = () => {
  const offerBannerLists = [{
    image: _components_images__WEBPACK_IMPORTED_MODULE_2__.themeClub,
    imageUrl: cw_dashboard.theme_club_upgrade,
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("Theme Club", "blossom-floral")
  }, {
    image: _components_images__WEBPACK_IMPORTED_MODULE_2__.salesFunnel,
    imageUrl: cw_dashboard.sales_funnel,
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("Sales Funnel", "blossom-floral")
  }, {
    image: _components_images__WEBPACK_IMPORTED_MODULE_2__.customFonts,
    imageUrl: cw_dashboard.custom_fonts,
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("Custom Fonts", "blossom-floral")
  }, {
    image: _components_images__WEBPACK_IMPORTED_MODULE_2__.vipSiteCare,
    imageUrl: cw_dashboard.vip_site_care,
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("VIP Site Care", "blossom-floral")
  }];
  const offerCardLists = [{
    image: _components_images__WEBPACK_IMPORTED_MODULE_2__.themeInstallation,
    imageUrl: cw_dashboard.theme_install,
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("Theme Installation & Setup", "blossom-floral")
  }, {
    image: _components_images__WEBPACK_IMPORTED_MODULE_2__.GDPR,
    imageUrl: cw_dashboard.gdpr_setup,
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("GDPR Compliance", "blossom-floral")
  }, {
    image: _components_images__WEBPACK_IMPORTED_MODULE_2__.SEO,
    imageUrl: cw_dashboard.seo_setup,
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("Must Have SEO Setup", "blossom-floral")
  }, {
    image: _components_images__WEBPACK_IMPORTED_MODULE_2__.pluginsSetup,
    imageUrl: cw_dashboard.plugin_setup,
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("Must Have Plugins Setup", "blossom-floral")
  }, {
    image: _components_images__WEBPACK_IMPORTED_MODULE_2__.vipSupport,
    imageUrl: cw_dashboard.vip_support,
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("VIP Support", "blossom-floral")
  }];
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "cw-offer"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "banner-section"
  }, offerBannerLists.map((banner, index) => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
    className: "image-link",
    href: banner.imageUrl,
    key: index,
    target: "_blank"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("img", {
    src: banner.image,
    alt: banner.title
  })))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "card-section"
  }, offerCardLists.map((card, index) => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
    className: "image-link",
    href: card.imageUrl,
    key: index,
    target: "_blank"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("img", {
    src: card.image,
    alt: card.title
  }))))));
};
/* harmony default export */ __webpack_exports__["default"] = (Offers);

/***/ }),

/***/ "./src/dashboard/pages/StarterSites/index.jsx":
/*!****************************************************!*\
  !*** ./src/dashboard/pages/StarterSites/index.jsx ***!
  \****************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../components */ "./src/dashboard/components/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _components_images__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../components/images */ "./src/dashboard/components/images.js");




const StarterSites = () => {
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "starter-sites"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "image-wrapper"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "image"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("img", {
    src: _components_images__WEBPACK_IMPORTED_MODULE_3__.aboutPage,
    alt: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Demo image', 'blossom-floral')
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "reverse-image"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("img", {
    src: _components_images__WEBPACK_IMPORTED_MODULE_3__.aboutPage,
    alt: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Demo reverse image', 'blossom-floral')
  }))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "image"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("img", {
    src: _components_images__WEBPACK_IMPORTED_MODULE_3__.homePage,
    alt: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Demo image', 'blossom-floral')
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "reverse-image"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("img", {
    src: _components_images__WEBPACK_IMPORTED_MODULE_3__.homePage,
    alt: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Demo reverse image', 'blossom-floral')
  }))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "image"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("img", {
    src: _components_images__WEBPACK_IMPORTED_MODULE_3__.fashionPage,
    alt: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Demo image', 'blossom-floral')
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "reverse-image"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("img", {
    src: _components_images__WEBPACK_IMPORTED_MODULE_3__.fashionPage,
    alt: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Demo reverse image', 'blossom-floral')
  })))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "text-wrapper"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("h2", null, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('One Click Demo Import', 'blossom-floral')), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
    dangerouslySetInnerHTML: {
      __html: sprintf((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Get started effortlessly! Use our one-click demo import feature to set up your site instantly with all the sample data and settings. Please note that importing demo content will overwrite your existing site content and settings. %s Not recommended if you have existing content. %s', 'blossom-floral'), '<b>', '</b>')
    }
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "cw-button"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
    href: cw_dashboard.get_pro,
    target: "_blank",
    className: "cw-button-btn primary-btn"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Get Starter Sites', 'blossom-floral'), " ", (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_1__.Icon, {
    icon: "arrow"
  }))))));
};
/* harmony default export */ __webpack_exports__["default"] = (StarterSites);

/***/ }),

/***/ "./src/dashboard/pages/UsefulPlugins/index.jsx":
/*!*****************************************************!*\
  !*** ./src/dashboard/pages/UsefulPlugins/index.jsx ***!
  \*****************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../components */ "./src/dashboard/components/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__);




const pluginList = [{
  pluginName: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('BlossomThemes Toolkit', 'blossom-floral'),
  description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("BlossomThemes Toolkit provides you necessary widgets for better and effective blogging.", "blossom-floral"),
  slug: "blossomthemes-toolkit"
}, {
  pluginName: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('BlossomThemes Email Newsletter', 'blossom-floral'),
  description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Easily add email subscription form to your website using shortcode and widget.", "blossom-floral"),
  slug: "blossomthemes-email-newsletter"
}, {
  pluginName: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Contact Form 7', 'blossom-floral'),
  description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Just another contact form plugin. Simple but flexible.", "blossom-floral"),
  slug: "contact-form-7"
}, {
  pluginName: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("WooCommerce", "blossom-floral"),
  description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Everything you need to launch an online store in days and keep it growing for years. From your first sale to millions in revenue, Woo is with you.", "blossom-floral"),
  slug: "woocommerce"
}, {
  pluginName: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Regenerate Thumbnails', 'blossom-floral'),
  description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Regenerate the thumbnails for one or more of your image uploads. Useful when changing their sizes or your theme.", "blossom-floral"),
  slug: "regenerate-thumbnails"
}, {
  pluginName: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Smash Balloon Social Photo Feed', 'blossom-floral'),
  description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Formerly 'Instagram Feed'. Display clean, customizable, and responsive Instagram feeds from multiple accounts. Supports Instagram oEmbeds.", "blossom-floral"),
  slug: "instagram-feed"
}];
const objectExistsInArray = (obj, array) => {
  return array.some(el => el.slug === obj.slug);
};
const UsefulPlugins = () => {
  const [buttonState, setButtonState] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(() => {
    const initialState = {};
    pluginList.forEach(plugin => {
      initialState[plugin.slug] = 'Install';
    });
    return initialState;
  });
  const [activateUrls, setActivateUrls] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)({});
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useEffect)(() => {
    const activePlugins = cw_dashboard.activePlugins;
    const inactivePlugins = cw_dashboard.inactivePlugins;
    const newButtonState = {};

    // Set state for active plugins
    activePlugins.forEach(plugin => {
      if (objectExistsInArray(plugin, pluginList)) {
        newButtonState[plugin.slug] = 'Activated';
      }
    });

    // Set state for inactive plugins
    inactivePlugins.forEach(plugin => {
      if (objectExistsInArray(plugin, pluginList)) {
        newButtonState[plugin.slug] = 'Activate';
      }
    });
    setButtonState(prevState => ({
      ...prevState,
      ...newButtonState
    }));
    const urls = {};
    inactivePlugins.forEach(plugin => {
      if (objectExistsInArray(plugin, pluginList)) {
        const url = plugin.url.replace(/&amp;/g, '&');
        urls[plugin.slug] = url;
      }
    });
    setActivateUrls(urls);
  }, []);
  const installPlugin = slug => {
    setButtonState(prevState => ({
      ...prevState,
      [slug]: 'Installing...'
    }));
    wp.updates.installPlugin({
      slug: slug,
      success: response => {
        setActivateUrls(prevUrls => ({
          ...prevUrls,
          [slug]: response.activateUrl
        }));
        setButtonState(prevState => ({
          ...prevState,
          [slug]: 'Activate'
        }));
      },
      error: error => {
        console.error(error);
        setButtonState(prevState => ({
          ...prevState,
          [slug]: 'Install'
        }));
      }
    });
  };
  const activatePlugin = async slug => {
    setButtonState(prevState => ({
      ...prevState,
      [slug]: 'Activating...'
    }));
    const url = activateUrls[slug];
    if (url) {
      try {
        const response = await fetch(url, {
          method: 'POST',
          headers: {
            'Content-Type': 'application/x-www-form-urlencoded'
          },
          body: new URLSearchParams({
            _wpnonce: new URL(url).searchParams.get('_wpnonce'),
            action: 'activate',
            plugin: new URL(url).searchParams.get('plugin')
          }).toString()
        });
        if (!response.ok) {
          throw new Error(`HTTP error! status: ${response.status}`);
        }
        setButtonState(prevState => ({
          ...prevState,
          [slug]: 'Activated'
        }));
      } catch (error) {
        setButtonState(prevState => ({
          ...prevState,
          [slug]: 'Activate'
        }));
      }
    }
  };
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "cw-plugin-list-wrapper"
  }, pluginList.map((plugin, index) => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "cw-plugin-list",
    key: index
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "plugin-detail"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "cw-plugin-title"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_1__.Icon, {
    icon: "pluginList",
    label: plugin.pluginName
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
    className: "description"
  }, plugin.description)), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "insert-button"
  }, buttonState[plugin.slug] === 'Install' && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("button", {
    className: "cw-button-btn outline",
    onClick: () => installPlugin(plugin.slug)
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Install', 'blossom-floral')), buttonState[plugin.slug] === 'Installing...' && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("button", {
    className: "cw-button-btn outline",
    disabled: true
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Installing...', 'blossom-floral')), buttonState[plugin.slug] === 'Activate' && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("button", {
    className: "cw-button-btn outline",
    onClick: () => activatePlugin(plugin.slug)
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Activate', 'blossom-floral')), buttonState[plugin.slug] === 'Activating...' && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("button", {
    className: "cw-button-btn outline",
    disabled: true
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Activating...', 'blossom-floral')), buttonState[plugin.slug] === 'Activated' && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("button", {
    className: "cw-button-btn primary-btn deactivate",
    disabled: true
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Activated', 'blossom-floral'))))));
};
/* harmony default export */ __webpack_exports__["default"] = (UsefulPlugins);

/***/ }),

/***/ "./src/dashboard/pages/index.js":
/*!**************************************!*\
  !*** ./src/dashboard/pages/index.js ***!
  \**************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../components */ "./src/dashboard/components/index.js");
/* harmony import */ var _FreePro__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./FreePro */ "./src/dashboard/pages/FreePro/index.jsx");
/* harmony import */ var _Home__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Home */ "./src/dashboard/pages/Home/index.jsx");
/* harmony import */ var _Offers__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./Offers */ "./src/dashboard/pages/Offers/index.jsx");
/* harmony import */ var _UsefulPlugins__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./UsefulPlugins */ "./src/dashboard/pages/UsefulPlugins/index.jsx");
/* harmony import */ var _FAQ__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./FAQ */ "./src/dashboard/pages/FAQ/index.jsx");
/* harmony import */ var _StarterSites__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./StarterSites */ "./src/dashboard/pages/StarterSites/index.jsx");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_8__);










function Dashboard() {
  const [activeTabTitle, setActiveTabTitle] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)('Home');
  const tabsData = [{
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_8__.__)('Home', 'blossom-floral'),
    icon: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_1__.Icon, {
      icon: "home"
    }),
    content: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_Home__WEBPACK_IMPORTED_MODULE_3__["default"], null)
  }, {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_8__.__)('Starter Sites', 'blossom-floral'),
    icon: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_1__.Icon, {
      icon: "globe"
    }),
    content: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_StarterSites__WEBPACK_IMPORTED_MODULE_7__["default"], null)
  }, {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_8__.__)('Free vs Pro', 'blossom-floral'),
    icon: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_1__.Icon, {
      icon: "freePro"
    }),
    content: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_FreePro__WEBPACK_IMPORTED_MODULE_2__["default"], null)
  }, {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_8__.__)('Offers', 'blossom-floral'),
    icon: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_1__.Icon, {
      icon: "offers"
    }),
    content: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_Offers__WEBPACK_IMPORTED_MODULE_4__["default"], null)
  }, {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_8__.__)('FAQs', 'blossom-floral'),
    icon: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_1__.Icon, {
      icon: "support"
    }),
    content: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_FAQ__WEBPACK_IMPORTED_MODULE_6__["default"], null)
  }, {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_8__.__)('Useful Plugins', 'blossom-floral'),
    icon: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_1__.Icon, {
      icon: "plugins"
    }),
    content: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_UsefulPlugins__WEBPACK_IMPORTED_MODULE_5__["default"], null)
  }];
  const handleTabChange = title => {
    setActiveTabTitle(title);
  };
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_1__.Tab, {
    tabsData: tabsData,
    onChange: handleTabChange,
    activeTabTitle: activeTabTitle
  }));
}
/* harmony default export */ __webpack_exports__["default"] = (Dashboard);

/***/ }),

/***/ "./src/dashboard/scss/style.scss":
/*!***************************************!*\
  !*** ./src/dashboard/scss/style.scss ***!
  \***************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),

/***/ "./node_modules/react-router-dom/dist/index.js":
/*!*****************************************************!*\
  !*** ./node_modules/react-router-dom/dist/index.js ***!
  \*****************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AbortedDeferredError: function() { return /* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.AbortedDeferredError; },
/* harmony export */   Await: function() { return /* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.Await; },
/* harmony export */   BrowserRouter: function() { return /* binding */ BrowserRouter; },
/* harmony export */   Form: function() { return /* binding */ Form; },
/* harmony export */   HashRouter: function() { return /* binding */ HashRouter; },
/* harmony export */   Link: function() { return /* binding */ Link; },
/* harmony export */   MemoryRouter: function() { return /* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.MemoryRouter; },
/* harmony export */   NavLink: function() { return /* binding */ NavLink; },
/* harmony export */   Navigate: function() { return /* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.Navigate; },
/* harmony export */   NavigationType: function() { return /* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.Action; },
/* harmony export */   Outlet: function() { return /* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.Outlet; },
/* harmony export */   Route: function() { return /* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.Route; },
/* harmony export */   Router: function() { return /* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.Router; },
/* harmony export */   RouterProvider: function() { return /* binding */ RouterProvider; },
/* harmony export */   Routes: function() { return /* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.Routes; },
/* harmony export */   ScrollRestoration: function() { return /* binding */ ScrollRestoration; },
/* harmony export */   UNSAFE_DataRouterContext: function() { return /* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.UNSAFE_DataRouterContext; },
/* harmony export */   UNSAFE_DataRouterStateContext: function() { return /* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.UNSAFE_DataRouterStateContext; },
/* harmony export */   UNSAFE_ErrorResponseImpl: function() { return /* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.UNSAFE_ErrorResponseImpl; },
/* harmony export */   UNSAFE_FetchersContext: function() { return /* binding */ FetchersContext; },
/* harmony export */   UNSAFE_LocationContext: function() { return /* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.UNSAFE_LocationContext; },
/* harmony export */   UNSAFE_NavigationContext: function() { return /* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.UNSAFE_NavigationContext; },
/* harmony export */   UNSAFE_RouteContext: function() { return /* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.UNSAFE_RouteContext; },
/* harmony export */   UNSAFE_ViewTransitionContext: function() { return /* binding */ ViewTransitionContext; },
/* harmony export */   UNSAFE_useRouteId: function() { return /* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.UNSAFE_useRouteId; },
/* harmony export */   UNSAFE_useScrollRestoration: function() { return /* binding */ useScrollRestoration; },
/* harmony export */   createBrowserRouter: function() { return /* binding */ createBrowserRouter; },
/* harmony export */   createHashRouter: function() { return /* binding */ createHashRouter; },
/* harmony export */   createMemoryRouter: function() { return /* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.createMemoryRouter; },
/* harmony export */   createPath: function() { return /* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.createPath; },
/* harmony export */   createRoutesFromChildren: function() { return /* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.createRoutesFromChildren; },
/* harmony export */   createRoutesFromElements: function() { return /* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.createRoutesFromElements; },
/* harmony export */   createSearchParams: function() { return /* binding */ createSearchParams; },
/* harmony export */   defer: function() { return /* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.defer; },
/* harmony export */   generatePath: function() { return /* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.generatePath; },
/* harmony export */   isRouteErrorResponse: function() { return /* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.isRouteErrorResponse; },
/* harmony export */   json: function() { return /* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.json; },
/* harmony export */   matchPath: function() { return /* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.matchPath; },
/* harmony export */   matchRoutes: function() { return /* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.matchRoutes; },
/* harmony export */   parsePath: function() { return /* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.parsePath; },
/* harmony export */   redirect: function() { return /* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.redirect; },
/* harmony export */   redirectDocument: function() { return /* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.redirectDocument; },
/* harmony export */   renderMatches: function() { return /* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.renderMatches; },
/* harmony export */   replace: function() { return /* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.replace; },
/* harmony export */   resolvePath: function() { return /* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.resolvePath; },
/* harmony export */   unstable_HistoryRouter: function() { return /* binding */ HistoryRouter; },
/* harmony export */   unstable_usePrompt: function() { return /* binding */ usePrompt; },
/* harmony export */   unstable_useViewTransitionState: function() { return /* binding */ useViewTransitionState; },
/* harmony export */   useActionData: function() { return /* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.useActionData; },
/* harmony export */   useAsyncError: function() { return /* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.useAsyncError; },
/* harmony export */   useAsyncValue: function() { return /* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.useAsyncValue; },
/* harmony export */   useBeforeUnload: function() { return /* binding */ useBeforeUnload; },
/* harmony export */   useBlocker: function() { return /* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.useBlocker; },
/* harmony export */   useFetcher: function() { return /* binding */ useFetcher; },
/* harmony export */   useFetchers: function() { return /* binding */ useFetchers; },
/* harmony export */   useFormAction: function() { return /* binding */ useFormAction; },
/* harmony export */   useHref: function() { return /* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.useHref; },
/* harmony export */   useInRouterContext: function() { return /* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.useInRouterContext; },
/* harmony export */   useLinkClickHandler: function() { return /* binding */ useLinkClickHandler; },
/* harmony export */   useLoaderData: function() { return /* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.useLoaderData; },
/* harmony export */   useLocation: function() { return /* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.useLocation; },
/* harmony export */   useMatch: function() { return /* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.useMatch; },
/* harmony export */   useMatches: function() { return /* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.useMatches; },
/* harmony export */   useNavigate: function() { return /* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.useNavigate; },
/* harmony export */   useNavigation: function() { return /* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.useNavigation; },
/* harmony export */   useNavigationType: function() { return /* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.useNavigationType; },
/* harmony export */   useOutlet: function() { return /* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.useOutlet; },
/* harmony export */   useOutletContext: function() { return /* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.useOutletContext; },
/* harmony export */   useParams: function() { return /* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.useParams; },
/* harmony export */   useResolvedPath: function() { return /* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.useResolvedPath; },
/* harmony export */   useRevalidator: function() { return /* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.useRevalidator; },
/* harmony export */   useRouteError: function() { return /* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.useRouteError; },
/* harmony export */   useRouteLoaderData: function() { return /* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.useRouteLoaderData; },
/* harmony export */   useRoutes: function() { return /* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.useRoutes; },
/* harmony export */   useSearchParams: function() { return /* binding */ useSearchParams; },
/* harmony export */   useSubmit: function() { return /* binding */ useSubmit; }
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react-dom */ "react-dom");
/* harmony import */ var react_dom__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_dom__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_router__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react-router */ "./node_modules/react-router/dist/index.js");
/* harmony import */ var react_router__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @remix-run/router */ "./node_modules/@remix-run/router/dist/router.js");
/**
 * React Router DOM v6.26.0
 *
 * Copyright (c) Remix Software Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE.md file in the root directory of this source tree.
 *
 * @license MIT
 */







function _extends() {
  _extends = Object.assign ? Object.assign.bind() : function (target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i];
      for (var key in source) {
        if (Object.prototype.hasOwnProperty.call(source, key)) {
          target[key] = source[key];
        }
      }
    }
    return target;
  };
  return _extends.apply(this, arguments);
}
function _objectWithoutPropertiesLoose(source, excluded) {
  if (source == null) return {};
  var target = {};
  var sourceKeys = Object.keys(source);
  var key, i;
  for (i = 0; i < sourceKeys.length; i++) {
    key = sourceKeys[i];
    if (excluded.indexOf(key) >= 0) continue;
    target[key] = source[key];
  }
  return target;
}

const defaultMethod = "get";
const defaultEncType = "application/x-www-form-urlencoded";
function isHtmlElement(object) {
  return object != null && typeof object.tagName === "string";
}
function isButtonElement(object) {
  return isHtmlElement(object) && object.tagName.toLowerCase() === "button";
}
function isFormElement(object) {
  return isHtmlElement(object) && object.tagName.toLowerCase() === "form";
}
function isInputElement(object) {
  return isHtmlElement(object) && object.tagName.toLowerCase() === "input";
}
function isModifiedEvent(event) {
  return !!(event.metaKey || event.altKey || event.ctrlKey || event.shiftKey);
}
function shouldProcessLinkClick(event, target) {
  return event.button === 0 && (
  // Ignore everything but left clicks
  !target || target === "_self") &&
  // Let browser handle "target=_blank" etc.
  !isModifiedEvent(event) // Ignore clicks with modifier keys
  ;
}
/**
 * Creates a URLSearchParams object using the given initializer.
 *
 * This is identical to `new URLSearchParams(init)` except it also
 * supports arrays as values in the object form of the initializer
 * instead of just strings. This is convenient when you need multiple
 * values for a given key, but don't want to use an array initializer.
 *
 * For example, instead of:
 *
 *   let searchParams = new URLSearchParams([
 *     ['sort', 'name'],
 *     ['sort', 'price']
 *   ]);
 *
 * you can do:
 *
 *   let searchParams = createSearchParams({
 *     sort: ['name', 'price']
 *   });
 */
function createSearchParams(init) {
  if (init === void 0) {
    init = "";
  }
  return new URLSearchParams(typeof init === "string" || Array.isArray(init) || init instanceof URLSearchParams ? init : Object.keys(init).reduce((memo, key) => {
    let value = init[key];
    return memo.concat(Array.isArray(value) ? value.map(v => [key, v]) : [[key, value]]);
  }, []));
}
function getSearchParamsForLocation(locationSearch, defaultSearchParams) {
  let searchParams = createSearchParams(locationSearch);
  if (defaultSearchParams) {
    // Use `defaultSearchParams.forEach(...)` here instead of iterating of
    // `defaultSearchParams.keys()` to work-around a bug in Firefox related to
    // web extensions. Relevant Bugzilla tickets:
    // https://bugzilla.mozilla.org/show_bug.cgi?id=1414602
    // https://bugzilla.mozilla.org/show_bug.cgi?id=1023984
    defaultSearchParams.forEach((_, key) => {
      if (!searchParams.has(key)) {
        defaultSearchParams.getAll(key).forEach(value => {
          searchParams.append(key, value);
        });
      }
    });
  }
  return searchParams;
}
// One-time check for submitter support
let _formDataSupportsSubmitter = null;
function isFormDataSubmitterSupported() {
  if (_formDataSupportsSubmitter === null) {
    try {
      new FormData(document.createElement("form"),
      // @ts-expect-error if FormData supports the submitter parameter, this will throw
      0);
      _formDataSupportsSubmitter = false;
    } catch (e) {
      _formDataSupportsSubmitter = true;
    }
  }
  return _formDataSupportsSubmitter;
}
const supportedFormEncTypes = new Set(["application/x-www-form-urlencoded", "multipart/form-data", "text/plain"]);
function getFormEncType(encType) {
  if (encType != null && !supportedFormEncTypes.has(encType)) {
     true ? (0,react_router__WEBPACK_IMPORTED_MODULE_2__.UNSAFE_warning)(false, "\"" + encType + "\" is not a valid `encType` for `<Form>`/`<fetcher.Form>` " + ("and will default to \"" + defaultEncType + "\"")) : 0;
    return null;
  }
  return encType;
}
function getFormSubmissionInfo(target, basename) {
  let method;
  let action;
  let encType;
  let formData;
  let body;
  if (isFormElement(target)) {
    // When grabbing the action from the element, it will have had the basename
    // prefixed to ensure non-JS scenarios work, so strip it since we'll
    // re-prefix in the router
    let attr = target.getAttribute("action");
    action = attr ? (0,react_router__WEBPACK_IMPORTED_MODULE_2__.stripBasename)(attr, basename) : null;
    method = target.getAttribute("method") || defaultMethod;
    encType = getFormEncType(target.getAttribute("enctype")) || defaultEncType;
    formData = new FormData(target);
  } else if (isButtonElement(target) || isInputElement(target) && (target.type === "submit" || target.type === "image")) {
    let form = target.form;
    if (form == null) {
      throw new Error("Cannot submit a <button> or <input type=\"submit\"> without a <form>");
    }
    // <button>/<input type="submit"> may override attributes of <form>
    // When grabbing the action from the element, it will have had the basename
    // prefixed to ensure non-JS scenarios work, so strip it since we'll
    // re-prefix in the router
    let attr = target.getAttribute("formaction") || form.getAttribute("action");
    action = attr ? (0,react_router__WEBPACK_IMPORTED_MODULE_2__.stripBasename)(attr, basename) : null;
    method = target.getAttribute("formmethod") || form.getAttribute("method") || defaultMethod;
    encType = getFormEncType(target.getAttribute("formenctype")) || getFormEncType(form.getAttribute("enctype")) || defaultEncType;
    // Build a FormData object populated from a form and submitter
    formData = new FormData(form, target);
    // If this browser doesn't support the `FormData(el, submitter)` format,
    // then tack on the submitter value at the end.  This is a lightweight
    // solution that is not 100% spec compliant.  For complete support in older
    // browsers, consider using the `formdata-submitter-polyfill` package
    if (!isFormDataSubmitterSupported()) {
      let {
        name,
        type,
        value
      } = target;
      if (type === "image") {
        let prefix = name ? name + "." : "";
        formData.append(prefix + "x", "0");
        formData.append(prefix + "y", "0");
      } else if (name) {
        formData.append(name, value);
      }
    }
  } else if (isHtmlElement(target)) {
    throw new Error("Cannot submit element that is not <form>, <button>, or " + "<input type=\"submit|image\">");
  } else {
    method = defaultMethod;
    action = null;
    encType = defaultEncType;
    body = target;
  }
  // Send body for <Form encType="text/plain" so we encode it into text
  if (formData && encType === "text/plain") {
    body = formData;
    formData = undefined;
  }
  return {
    action,
    method: method.toLowerCase(),
    encType,
    formData,
    body
  };
}

const _excluded = ["onClick", "relative", "reloadDocument", "replace", "state", "target", "to", "preventScrollReset", "unstable_viewTransition"],
  _excluded2 = ["aria-current", "caseSensitive", "className", "end", "style", "to", "unstable_viewTransition", "children"],
  _excluded3 = ["fetcherKey", "navigate", "reloadDocument", "replace", "state", "method", "action", "onSubmit", "relative", "preventScrollReset", "unstable_viewTransition"];
// HEY YOU! DON'T TOUCH THIS VARIABLE!
//
// It is replaced with the proper version at build time via a babel plugin in
// the rollup config.
//
// Export a global property onto the window for React Router detection by the
// Core Web Vitals Technology Report.  This way they can configure the `wappalyzer`
// to detect and properly classify live websites as being built with React Router:
// https://github.com/HTTPArchive/wappalyzer/blob/main/src/technologies/r.json
const REACT_ROUTER_VERSION = "6";
try {
  window.__reactRouterVersion = REACT_ROUTER_VERSION;
} catch (e) {
  // no-op
}
function createBrowserRouter(routes, opts) {
  return (0,react_router__WEBPACK_IMPORTED_MODULE_2__.createRouter)({
    basename: opts == null ? void 0 : opts.basename,
    future: _extends({}, opts == null ? void 0 : opts.future, {
      v7_prependBasename: true
    }),
    history: (0,react_router__WEBPACK_IMPORTED_MODULE_2__.createBrowserHistory)({
      window: opts == null ? void 0 : opts.window
    }),
    hydrationData: (opts == null ? void 0 : opts.hydrationData) || parseHydrationData(),
    routes,
    mapRouteProperties: react_router__WEBPACK_IMPORTED_MODULE_3__.UNSAFE_mapRouteProperties,
    unstable_dataStrategy: opts == null ? void 0 : opts.unstable_dataStrategy,
    unstable_patchRoutesOnMiss: opts == null ? void 0 : opts.unstable_patchRoutesOnMiss,
    window: opts == null ? void 0 : opts.window
  }).initialize();
}
function createHashRouter(routes, opts) {
  return (0,react_router__WEBPACK_IMPORTED_MODULE_2__.createRouter)({
    basename: opts == null ? void 0 : opts.basename,
    future: _extends({}, opts == null ? void 0 : opts.future, {
      v7_prependBasename: true
    }),
    history: (0,react_router__WEBPACK_IMPORTED_MODULE_2__.createHashHistory)({
      window: opts == null ? void 0 : opts.window
    }),
    hydrationData: (opts == null ? void 0 : opts.hydrationData) || parseHydrationData(),
    routes,
    mapRouteProperties: react_router__WEBPACK_IMPORTED_MODULE_3__.UNSAFE_mapRouteProperties,
    unstable_dataStrategy: opts == null ? void 0 : opts.unstable_dataStrategy,
    unstable_patchRoutesOnMiss: opts == null ? void 0 : opts.unstable_patchRoutesOnMiss,
    window: opts == null ? void 0 : opts.window
  }).initialize();
}
function parseHydrationData() {
  var _window;
  let state = (_window = window) == null ? void 0 : _window.__staticRouterHydrationData;
  if (state && state.errors) {
    state = _extends({}, state, {
      errors: deserializeErrors(state.errors)
    });
  }
  return state;
}
function deserializeErrors(errors) {
  if (!errors) return null;
  let entries = Object.entries(errors);
  let serialized = {};
  for (let [key, val] of entries) {
    // Hey you!  If you change this, please change the corresponding logic in
    // serializeErrors in react-router-dom/server.tsx :)
    if (val && val.__type === "RouteErrorResponse") {
      serialized[key] = new react_router__WEBPACK_IMPORTED_MODULE_2__.UNSAFE_ErrorResponseImpl(val.status, val.statusText, val.data, val.internal === true);
    } else if (val && val.__type === "Error") {
      // Attempt to reconstruct the right type of Error (i.e., ReferenceError)
      if (val.__subType) {
        let ErrorConstructor = window[val.__subType];
        if (typeof ErrorConstructor === "function") {
          try {
            // @ts-expect-error
            let error = new ErrorConstructor(val.message);
            // Wipe away the client-side stack trace.  Nothing to fill it in with
            // because we don't serialize SSR stack traces for security reasons
            error.stack = "";
            serialized[key] = error;
          } catch (e) {
            // no-op - fall through and create a normal Error
          }
        }
      }
      if (serialized[key] == null) {
        let error = new Error(val.message);
        // Wipe away the client-side stack trace.  Nothing to fill it in with
        // because we don't serialize SSR stack traces for security reasons
        error.stack = "";
        serialized[key] = error;
      }
    } else {
      serialized[key] = val;
    }
  }
  return serialized;
}
const ViewTransitionContext = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createContext({
  isTransitioning: false
});
if (true) {
  ViewTransitionContext.displayName = "ViewTransition";
}
const FetchersContext = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createContext(new Map());
if (true) {
  FetchersContext.displayName = "Fetchers";
}
//#endregion
////////////////////////////////////////////////////////////////////////////////
//#region Components
////////////////////////////////////////////////////////////////////////////////
/**
  Webpack + React 17 fails to compile on any of the following because webpack
  complains that `startTransition` doesn't exist in `React`:
  * import { startTransition } from "react"
  * import * as React from from "react";
    "startTransition" in React ? React.startTransition(() => setState()) : setState()
  * import * as React from from "react";
    "startTransition" in React ? React["startTransition"](() => setState()) : setState()

  Moving it to a constant such as the following solves the Webpack/React 17 issue:
  * import * as React from from "react";
    const START_TRANSITION = "startTransition";
    START_TRANSITION in React ? React[START_TRANSITION](() => setState()) : setState()

  However, that introduces webpack/terser minification issues in production builds
  in React 18 where minification/obfuscation ends up removing the call of
  React.startTransition entirely from the first half of the ternary.  Grabbing
  this exported reference once up front resolves that issue.

  See https://github.com/remix-run/react-router/issues/10579
*/
const START_TRANSITION = "startTransition";
const startTransitionImpl = react__WEBPACK_IMPORTED_MODULE_0__[START_TRANSITION];
const FLUSH_SYNC = "flushSync";
const flushSyncImpl = react_dom__WEBPACK_IMPORTED_MODULE_1__[FLUSH_SYNC];
const USE_ID = "useId";
const useIdImpl = react__WEBPACK_IMPORTED_MODULE_0__[USE_ID];
function startTransitionSafe(cb) {
  if (startTransitionImpl) {
    startTransitionImpl(cb);
  } else {
    cb();
  }
}
function flushSyncSafe(cb) {
  if (flushSyncImpl) {
    flushSyncImpl(cb);
  } else {
    cb();
  }
}
class Deferred {
  constructor() {
    this.status = "pending";
    this.promise = new Promise((resolve, reject) => {
      this.resolve = value => {
        if (this.status === "pending") {
          this.status = "resolved";
          resolve(value);
        }
      };
      this.reject = reason => {
        if (this.status === "pending") {
          this.status = "rejected";
          reject(reason);
        }
      };
    });
  }
}
/**
 * Given a Remix Router instance, render the appropriate UI
 */
function RouterProvider(_ref) {
  let {
    fallbackElement,
    router,
    future
  } = _ref;
  let [state, setStateImpl] = react__WEBPACK_IMPORTED_MODULE_0__.useState(router.state);
  let [pendingState, setPendingState] = react__WEBPACK_IMPORTED_MODULE_0__.useState();
  let [vtContext, setVtContext] = react__WEBPACK_IMPORTED_MODULE_0__.useState({
    isTransitioning: false
  });
  let [renderDfd, setRenderDfd] = react__WEBPACK_IMPORTED_MODULE_0__.useState();
  let [transition, setTransition] = react__WEBPACK_IMPORTED_MODULE_0__.useState();
  let [interruption, setInterruption] = react__WEBPACK_IMPORTED_MODULE_0__.useState();
  let fetcherData = react__WEBPACK_IMPORTED_MODULE_0__.useRef(new Map());
  let {
    v7_startTransition
  } = future || {};
  let optInStartTransition = react__WEBPACK_IMPORTED_MODULE_0__.useCallback(cb => {
    if (v7_startTransition) {
      startTransitionSafe(cb);
    } else {
      cb();
    }
  }, [v7_startTransition]);
  let setState = react__WEBPACK_IMPORTED_MODULE_0__.useCallback((newState, _ref2) => {
    let {
      deletedFetchers,
      unstable_flushSync: flushSync,
      unstable_viewTransitionOpts: viewTransitionOpts
    } = _ref2;
    deletedFetchers.forEach(key => fetcherData.current.delete(key));
    newState.fetchers.forEach((fetcher, key) => {
      if (fetcher.data !== undefined) {
        fetcherData.current.set(key, fetcher.data);
      }
    });
    let isViewTransitionUnavailable = router.window == null || router.window.document == null || typeof router.window.document.startViewTransition !== "function";
    // If this isn't a view transition or it's not available in this browser,
    // just update and be done with it
    if (!viewTransitionOpts || isViewTransitionUnavailable) {
      if (flushSync) {
        flushSyncSafe(() => setStateImpl(newState));
      } else {
        optInStartTransition(() => setStateImpl(newState));
      }
      return;
    }
    // flushSync + startViewTransition
    if (flushSync) {
      // Flush through the context to mark DOM elements as transition=ing
      flushSyncSafe(() => {
        // Cancel any pending transitions
        if (transition) {
          renderDfd && renderDfd.resolve();
          transition.skipTransition();
        }
        setVtContext({
          isTransitioning: true,
          flushSync: true,
          currentLocation: viewTransitionOpts.currentLocation,
          nextLocation: viewTransitionOpts.nextLocation
        });
      });
      // Update the DOM
      let t = router.window.document.startViewTransition(() => {
        flushSyncSafe(() => setStateImpl(newState));
      });
      // Clean up after the animation completes
      t.finished.finally(() => {
        flushSyncSafe(() => {
          setRenderDfd(undefined);
          setTransition(undefined);
          setPendingState(undefined);
          setVtContext({
            isTransitioning: false
          });
        });
      });
      flushSyncSafe(() => setTransition(t));
      return;
    }
    // startTransition + startViewTransition
    if (transition) {
      // Interrupting an in-progress transition, cancel and let everything flush
      // out, and then kick off a new transition from the interruption state
      renderDfd && renderDfd.resolve();
      transition.skipTransition();
      setInterruption({
        state: newState,
        currentLocation: viewTransitionOpts.currentLocation,
        nextLocation: viewTransitionOpts.nextLocation
      });
    } else {
      // Completed navigation update with opted-in view transitions, let 'er rip
      setPendingState(newState);
      setVtContext({
        isTransitioning: true,
        flushSync: false,
        currentLocation: viewTransitionOpts.currentLocation,
        nextLocation: viewTransitionOpts.nextLocation
      });
    }
  }, [router.window, transition, renderDfd, fetcherData, optInStartTransition]);
  // Need to use a layout effect here so we are subscribed early enough to
  // pick up on any render-driven redirects/navigations (useEffect/<Navigate>)
  react__WEBPACK_IMPORTED_MODULE_0__.useLayoutEffect(() => router.subscribe(setState), [router, setState]);
  // When we start a view transition, create a Deferred we can use for the
  // eventual "completed" render
  react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
    if (vtContext.isTransitioning && !vtContext.flushSync) {
      setRenderDfd(new Deferred());
    }
  }, [vtContext]);
  // Once the deferred is created, kick off startViewTransition() to update the
  // DOM and then wait on the Deferred to resolve (indicating the DOM update has
  // happened)
  react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
    if (renderDfd && pendingState && router.window) {
      let newState = pendingState;
      let renderPromise = renderDfd.promise;
      let transition = router.window.document.startViewTransition(async () => {
        optInStartTransition(() => setStateImpl(newState));
        await renderPromise;
      });
      transition.finished.finally(() => {
        setRenderDfd(undefined);
        setTransition(undefined);
        setPendingState(undefined);
        setVtContext({
          isTransitioning: false
        });
      });
      setTransition(transition);
    }
  }, [optInStartTransition, pendingState, renderDfd, router.window]);
  // When the new location finally renders and is committed to the DOM, this
  // effect will run to resolve the transition
  react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
    if (renderDfd && pendingState && state.location.key === pendingState.location.key) {
      renderDfd.resolve();
    }
  }, [renderDfd, transition, state.location, pendingState]);
  // If we get interrupted with a new navigation during a transition, we skip
  // the active transition, let it cleanup, then kick it off again here
  react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
    if (!vtContext.isTransitioning && interruption) {
      setPendingState(interruption.state);
      setVtContext({
        isTransitioning: true,
        flushSync: false,
        currentLocation: interruption.currentLocation,
        nextLocation: interruption.nextLocation
      });
      setInterruption(undefined);
    }
  }, [vtContext.isTransitioning, interruption]);
  react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
     true ? (0,react_router__WEBPACK_IMPORTED_MODULE_2__.UNSAFE_warning)(fallbackElement == null || !router.future.v7_partialHydration, "`<RouterProvider fallbackElement>` is deprecated when using " + "`v7_partialHydration`, use a `HydrateFallback` component instead") : 0;
    // Only log this once on initial mount
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  let navigator = react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => {
    return {
      createHref: router.createHref,
      encodeLocation: router.encodeLocation,
      go: n => router.navigate(n),
      push: (to, state, opts) => router.navigate(to, {
        state,
        preventScrollReset: opts == null ? void 0 : opts.preventScrollReset
      }),
      replace: (to, state, opts) => router.navigate(to, {
        replace: true,
        state,
        preventScrollReset: opts == null ? void 0 : opts.preventScrollReset
      })
    };
  }, [router]);
  let basename = router.basename || "/";
  let dataRouterContext = react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => ({
    router,
    navigator,
    static: false,
    basename
  }), [router, navigator, basename]);
  let routerFuture = react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => ({
    v7_relativeSplatPath: router.future.v7_relativeSplatPath
  }), [router.future.v7_relativeSplatPath]);
  // The fragment and {null} here are important!  We need them to keep React 18's
  // useId happy when we are server-rendering since we may have a <script> here
  // containing the hydrated server-side staticContext (from StaticRouterProvider).
  // useId relies on the component tree structure to generate deterministic id's
  // so we need to ensure it remains the same on the client even though
  // we don't need the <script> tag
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(react_router__WEBPACK_IMPORTED_MODULE_3__.UNSAFE_DataRouterContext.Provider, {
    value: dataRouterContext
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(react_router__WEBPACK_IMPORTED_MODULE_3__.UNSAFE_DataRouterStateContext.Provider, {
    value: state
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(FetchersContext.Provider, {
    value: fetcherData.current
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(ViewTransitionContext.Provider, {
    value: vtContext
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(react_router__WEBPACK_IMPORTED_MODULE_3__.Router, {
    basename: basename,
    location: state.location,
    navigationType: state.historyAction,
    navigator: navigator,
    future: routerFuture
  }, state.initialized || router.future.v7_partialHydration ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(MemoizedDataRoutes, {
    routes: router.routes,
    future: router.future,
    state: state
  }) : fallbackElement))))), null);
}
// Memoize to avoid re-renders when updating `ViewTransitionContext`
const MemoizedDataRoutes = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.memo(DataRoutes);
function DataRoutes(_ref3) {
  let {
    routes,
    future,
    state
  } = _ref3;
  return (0,react_router__WEBPACK_IMPORTED_MODULE_3__.UNSAFE_useRoutesImpl)(routes, undefined, state, future);
}
/**
 * A `<Router>` for use in web browsers. Provides the cleanest URLs.
 */
function BrowserRouter(_ref4) {
  let {
    basename,
    children,
    future,
    window
  } = _ref4;
  let historyRef = react__WEBPACK_IMPORTED_MODULE_0__.useRef();
  if (historyRef.current == null) {
    historyRef.current = (0,react_router__WEBPACK_IMPORTED_MODULE_2__.createBrowserHistory)({
      window,
      v5Compat: true
    });
  }
  let history = historyRef.current;
  let [state, setStateImpl] = react__WEBPACK_IMPORTED_MODULE_0__.useState({
    action: history.action,
    location: history.location
  });
  let {
    v7_startTransition
  } = future || {};
  let setState = react__WEBPACK_IMPORTED_MODULE_0__.useCallback(newState => {
    v7_startTransition && startTransitionImpl ? startTransitionImpl(() => setStateImpl(newState)) : setStateImpl(newState);
  }, [setStateImpl, v7_startTransition]);
  react__WEBPACK_IMPORTED_MODULE_0__.useLayoutEffect(() => history.listen(setState), [history, setState]);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(react_router__WEBPACK_IMPORTED_MODULE_3__.Router, {
    basename: basename,
    children: children,
    location: state.location,
    navigationType: state.action,
    navigator: history,
    future: future
  });
}
/**
 * A `<Router>` for use in web browsers. Stores the location in the hash
 * portion of the URL so it is not sent to the server.
 */
function HashRouter(_ref5) {
  let {
    basename,
    children,
    future,
    window
  } = _ref5;
  let historyRef = react__WEBPACK_IMPORTED_MODULE_0__.useRef();
  if (historyRef.current == null) {
    historyRef.current = (0,react_router__WEBPACK_IMPORTED_MODULE_2__.createHashHistory)({
      window,
      v5Compat: true
    });
  }
  let history = historyRef.current;
  let [state, setStateImpl] = react__WEBPACK_IMPORTED_MODULE_0__.useState({
    action: history.action,
    location: history.location
  });
  let {
    v7_startTransition
  } = future || {};
  let setState = react__WEBPACK_IMPORTED_MODULE_0__.useCallback(newState => {
    v7_startTransition && startTransitionImpl ? startTransitionImpl(() => setStateImpl(newState)) : setStateImpl(newState);
  }, [setStateImpl, v7_startTransition]);
  react__WEBPACK_IMPORTED_MODULE_0__.useLayoutEffect(() => history.listen(setState), [history, setState]);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(react_router__WEBPACK_IMPORTED_MODULE_3__.Router, {
    basename: basename,
    children: children,
    location: state.location,
    navigationType: state.action,
    navigator: history,
    future: future
  });
}
/**
 * A `<Router>` that accepts a pre-instantiated history object. It's important
 * to note that using your own history object is highly discouraged and may add
 * two versions of the history library to your bundles unless you use the same
 * version of the history library that React Router uses internally.
 */
function HistoryRouter(_ref6) {
  let {
    basename,
    children,
    future,
    history
  } = _ref6;
  let [state, setStateImpl] = react__WEBPACK_IMPORTED_MODULE_0__.useState({
    action: history.action,
    location: history.location
  });
  let {
    v7_startTransition
  } = future || {};
  let setState = react__WEBPACK_IMPORTED_MODULE_0__.useCallback(newState => {
    v7_startTransition && startTransitionImpl ? startTransitionImpl(() => setStateImpl(newState)) : setStateImpl(newState);
  }, [setStateImpl, v7_startTransition]);
  react__WEBPACK_IMPORTED_MODULE_0__.useLayoutEffect(() => history.listen(setState), [history, setState]);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(react_router__WEBPACK_IMPORTED_MODULE_3__.Router, {
    basename: basename,
    children: children,
    location: state.location,
    navigationType: state.action,
    navigator: history,
    future: future
  });
}
if (true) {
  HistoryRouter.displayName = "unstable_HistoryRouter";
}
const isBrowser = typeof window !== "undefined" && typeof window.document !== "undefined" && typeof window.document.createElement !== "undefined";
const ABSOLUTE_URL_REGEX = /^(?:[a-z][a-z0-9+.-]*:|\/\/)/i;
/**
 * The public API for rendering a history-aware `<a>`.
 */
const Link = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.forwardRef(function LinkWithRef(_ref7, ref) {
  let {
      onClick,
      relative,
      reloadDocument,
      replace,
      state,
      target,
      to,
      preventScrollReset,
      unstable_viewTransition
    } = _ref7,
    rest = _objectWithoutPropertiesLoose(_ref7, _excluded);
  let {
    basename
  } = react__WEBPACK_IMPORTED_MODULE_0__.useContext(react_router__WEBPACK_IMPORTED_MODULE_3__.UNSAFE_NavigationContext);
  // Rendered into <a href> for absolute URLs
  let absoluteHref;
  let isExternal = false;
  if (typeof to === "string" && ABSOLUTE_URL_REGEX.test(to)) {
    // Render the absolute href server- and client-side
    absoluteHref = to;
    // Only check for external origins client-side
    if (isBrowser) {
      try {
        let currentUrl = new URL(window.location.href);
        let targetUrl = to.startsWith("//") ? new URL(currentUrl.protocol + to) : new URL(to);
        let path = (0,react_router__WEBPACK_IMPORTED_MODULE_2__.stripBasename)(targetUrl.pathname, basename);
        if (targetUrl.origin === currentUrl.origin && path != null) {
          // Strip the protocol/origin/basename for same-origin absolute URLs
          to = path + targetUrl.search + targetUrl.hash;
        } else {
          isExternal = true;
        }
      } catch (e) {
        // We can't do external URL detection without a valid URL
         true ? (0,react_router__WEBPACK_IMPORTED_MODULE_2__.UNSAFE_warning)(false, "<Link to=\"" + to + "\"> contains an invalid URL which will probably break " + "when clicked - please update to a valid URL path.") : 0;
      }
    }
  }
  // Rendered into <a href> for relative URLs
  let href = (0,react_router__WEBPACK_IMPORTED_MODULE_3__.useHref)(to, {
    relative
  });
  let internalOnClick = useLinkClickHandler(to, {
    replace,
    state,
    target,
    preventScrollReset,
    relative,
    unstable_viewTransition
  });
  function handleClick(event) {
    if (onClick) onClick(event);
    if (!event.defaultPrevented) {
      internalOnClick(event);
    }
  }
  return (
    /*#__PURE__*/
    // eslint-disable-next-line jsx-a11y/anchor-has-content
    react__WEBPACK_IMPORTED_MODULE_0__.createElement("a", _extends({}, rest, {
      href: absoluteHref || href,
      onClick: isExternal || reloadDocument ? onClick : handleClick,
      ref: ref,
      target: target
    }))
  );
});
if (true) {
  Link.displayName = "Link";
}
/**
 * A `<Link>` wrapper that knows if it's "active" or not.
 */
const NavLink = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.forwardRef(function NavLinkWithRef(_ref8, ref) {
  let {
      "aria-current": ariaCurrentProp = "page",
      caseSensitive = false,
      className: classNameProp = "",
      end = false,
      style: styleProp,
      to,
      unstable_viewTransition,
      children
    } = _ref8,
    rest = _objectWithoutPropertiesLoose(_ref8, _excluded2);
  let path = (0,react_router__WEBPACK_IMPORTED_MODULE_3__.useResolvedPath)(to, {
    relative: rest.relative
  });
  let location = (0,react_router__WEBPACK_IMPORTED_MODULE_3__.useLocation)();
  let routerState = react__WEBPACK_IMPORTED_MODULE_0__.useContext(react_router__WEBPACK_IMPORTED_MODULE_3__.UNSAFE_DataRouterStateContext);
  let {
    navigator,
    basename
  } = react__WEBPACK_IMPORTED_MODULE_0__.useContext(react_router__WEBPACK_IMPORTED_MODULE_3__.UNSAFE_NavigationContext);
  let isTransitioning = routerState != null &&
  // Conditional usage is OK here because the usage of a data router is static
  // eslint-disable-next-line react-hooks/rules-of-hooks
  useViewTransitionState(path) && unstable_viewTransition === true;
  let toPathname = navigator.encodeLocation ? navigator.encodeLocation(path).pathname : path.pathname;
  let locationPathname = location.pathname;
  let nextLocationPathname = routerState && routerState.navigation && routerState.navigation.location ? routerState.navigation.location.pathname : null;
  if (!caseSensitive) {
    locationPathname = locationPathname.toLowerCase();
    nextLocationPathname = nextLocationPathname ? nextLocationPathname.toLowerCase() : null;
    toPathname = toPathname.toLowerCase();
  }
  if (nextLocationPathname && basename) {
    nextLocationPathname = (0,react_router__WEBPACK_IMPORTED_MODULE_2__.stripBasename)(nextLocationPathname, basename) || nextLocationPathname;
  }
  // If the `to` has a trailing slash, look at that exact spot.  Otherwise,
  // we're looking for a slash _after_ what's in `to`.  For example:
  //
  // <NavLink to="/users"> and <NavLink to="/users/">
  // both want to look for a / at index 6 to match URL `/users/matt`
  const endSlashPosition = toPathname !== "/" && toPathname.endsWith("/") ? toPathname.length - 1 : toPathname.length;
  let isActive = locationPathname === toPathname || !end && locationPathname.startsWith(toPathname) && locationPathname.charAt(endSlashPosition) === "/";
  let isPending = nextLocationPathname != null && (nextLocationPathname === toPathname || !end && nextLocationPathname.startsWith(toPathname) && nextLocationPathname.charAt(toPathname.length) === "/");
  let renderProps = {
    isActive,
    isPending,
    isTransitioning
  };
  let ariaCurrent = isActive ? ariaCurrentProp : undefined;
  let className;
  if (typeof classNameProp === "function") {
    className = classNameProp(renderProps);
  } else {
    // If the className prop is not a function, we use a default `active`
    // class for <NavLink />s that are active. In v5 `active` was the default
    // value for `activeClassName`, but we are removing that API and can still
    // use the old default behavior for a cleaner upgrade path and keep the
    // simple styling rules working as they currently do.
    className = [classNameProp, isActive ? "active" : null, isPending ? "pending" : null, isTransitioning ? "transitioning" : null].filter(Boolean).join(" ");
  }
  let style = typeof styleProp === "function" ? styleProp(renderProps) : styleProp;
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(Link, _extends({}, rest, {
    "aria-current": ariaCurrent,
    className: className,
    ref: ref,
    style: style,
    to: to,
    unstable_viewTransition: unstable_viewTransition
  }), typeof children === "function" ? children(renderProps) : children);
});
if (true) {
  NavLink.displayName = "NavLink";
}
/**
 * A `@remix-run/router`-aware `<form>`. It behaves like a normal form except
 * that the interaction with the server is with `fetch` instead of new document
 * requests, allowing components to add nicer UX to the page as the form is
 * submitted and returns with data.
 */
const Form = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.forwardRef((_ref9, forwardedRef) => {
  let {
      fetcherKey,
      navigate,
      reloadDocument,
      replace,
      state,
      method = defaultMethod,
      action,
      onSubmit,
      relative,
      preventScrollReset,
      unstable_viewTransition
    } = _ref9,
    props = _objectWithoutPropertiesLoose(_ref9, _excluded3);
  let submit = useSubmit();
  let formAction = useFormAction(action, {
    relative
  });
  let formMethod = method.toLowerCase() === "get" ? "get" : "post";
  let submitHandler = event => {
    onSubmit && onSubmit(event);
    if (event.defaultPrevented) return;
    event.preventDefault();
    let submitter = event.nativeEvent.submitter;
    let submitMethod = (submitter == null ? void 0 : submitter.getAttribute("formmethod")) || method;
    submit(submitter || event.currentTarget, {
      fetcherKey,
      method: submitMethod,
      navigate,
      replace,
      state,
      relative,
      preventScrollReset,
      unstable_viewTransition
    });
  };
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("form", _extends({
    ref: forwardedRef,
    method: formMethod,
    action: formAction,
    onSubmit: reloadDocument ? onSubmit : submitHandler
  }, props));
});
if (true) {
  Form.displayName = "Form";
}
/**
 * This component will emulate the browser's scroll restoration on location
 * changes.
 */
function ScrollRestoration(_ref10) {
  let {
    getKey,
    storageKey
  } = _ref10;
  useScrollRestoration({
    getKey,
    storageKey
  });
  return null;
}
if (true) {
  ScrollRestoration.displayName = "ScrollRestoration";
}
//#endregion
////////////////////////////////////////////////////////////////////////////////
//#region Hooks
////////////////////////////////////////////////////////////////////////////////
var DataRouterHook;
(function (DataRouterHook) {
  DataRouterHook["UseScrollRestoration"] = "useScrollRestoration";
  DataRouterHook["UseSubmit"] = "useSubmit";
  DataRouterHook["UseSubmitFetcher"] = "useSubmitFetcher";
  DataRouterHook["UseFetcher"] = "useFetcher";
  DataRouterHook["useViewTransitionState"] = "useViewTransitionState";
})(DataRouterHook || (DataRouterHook = {}));
var DataRouterStateHook;
(function (DataRouterStateHook) {
  DataRouterStateHook["UseFetcher"] = "useFetcher";
  DataRouterStateHook["UseFetchers"] = "useFetchers";
  DataRouterStateHook["UseScrollRestoration"] = "useScrollRestoration";
})(DataRouterStateHook || (DataRouterStateHook = {}));
// Internal hooks
function getDataRouterConsoleError(hookName) {
  return hookName + " must be used within a data router.  See https://reactrouter.com/routers/picking-a-router.";
}
function useDataRouterContext(hookName) {
  let ctx = react__WEBPACK_IMPORTED_MODULE_0__.useContext(react_router__WEBPACK_IMPORTED_MODULE_3__.UNSAFE_DataRouterContext);
  !ctx ?  true ? (0,react_router__WEBPACK_IMPORTED_MODULE_2__.UNSAFE_invariant)(false, getDataRouterConsoleError(hookName)) : 0 : void 0;
  return ctx;
}
function useDataRouterState(hookName) {
  let state = react__WEBPACK_IMPORTED_MODULE_0__.useContext(react_router__WEBPACK_IMPORTED_MODULE_3__.UNSAFE_DataRouterStateContext);
  !state ?  true ? (0,react_router__WEBPACK_IMPORTED_MODULE_2__.UNSAFE_invariant)(false, getDataRouterConsoleError(hookName)) : 0 : void 0;
  return state;
}
// External hooks
/**
 * Handles the click behavior for router `<Link>` components. This is useful if
 * you need to create custom `<Link>` components with the same click behavior we
 * use in our exported `<Link>`.
 */
function useLinkClickHandler(to, _temp) {
  let {
    target,
    replace: replaceProp,
    state,
    preventScrollReset,
    relative,
    unstable_viewTransition
  } = _temp === void 0 ? {} : _temp;
  let navigate = (0,react_router__WEBPACK_IMPORTED_MODULE_3__.useNavigate)();
  let location = (0,react_router__WEBPACK_IMPORTED_MODULE_3__.useLocation)();
  let path = (0,react_router__WEBPACK_IMPORTED_MODULE_3__.useResolvedPath)(to, {
    relative
  });
  return react__WEBPACK_IMPORTED_MODULE_0__.useCallback(event => {
    if (shouldProcessLinkClick(event, target)) {
      event.preventDefault();
      // If the URL hasn't changed, a regular <a> will do a replace instead of
      // a push, so do the same here unless the replace prop is explicitly set
      let replace = replaceProp !== undefined ? replaceProp : (0,react_router__WEBPACK_IMPORTED_MODULE_2__.createPath)(location) === (0,react_router__WEBPACK_IMPORTED_MODULE_2__.createPath)(path);
      navigate(to, {
        replace,
        state,
        preventScrollReset,
        relative,
        unstable_viewTransition
      });
    }
  }, [location, navigate, path, replaceProp, state, target, to, preventScrollReset, relative, unstable_viewTransition]);
}
/**
 * A convenient wrapper for reading and writing search parameters via the
 * URLSearchParams interface.
 */
function useSearchParams(defaultInit) {
   true ? (0,react_router__WEBPACK_IMPORTED_MODULE_2__.UNSAFE_warning)(typeof URLSearchParams !== "undefined", "You cannot use the `useSearchParams` hook in a browser that does not " + "support the URLSearchParams API. If you need to support Internet " + "Explorer 11, we recommend you load a polyfill such as " + "https://github.com/ungap/url-search-params.") : 0;
  let defaultSearchParamsRef = react__WEBPACK_IMPORTED_MODULE_0__.useRef(createSearchParams(defaultInit));
  let hasSetSearchParamsRef = react__WEBPACK_IMPORTED_MODULE_0__.useRef(false);
  let location = (0,react_router__WEBPACK_IMPORTED_MODULE_3__.useLocation)();
  let searchParams = react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() =>
  // Only merge in the defaults if we haven't yet called setSearchParams.
  // Once we call that we want those to take precedence, otherwise you can't
  // remove a param with setSearchParams({}) if it has an initial value
  getSearchParamsForLocation(location.search, hasSetSearchParamsRef.current ? null : defaultSearchParamsRef.current), [location.search]);
  let navigate = (0,react_router__WEBPACK_IMPORTED_MODULE_3__.useNavigate)();
  let setSearchParams = react__WEBPACK_IMPORTED_MODULE_0__.useCallback((nextInit, navigateOptions) => {
    const newSearchParams = createSearchParams(typeof nextInit === "function" ? nextInit(searchParams) : nextInit);
    hasSetSearchParamsRef.current = true;
    navigate("?" + newSearchParams, navigateOptions);
  }, [navigate, searchParams]);
  return [searchParams, setSearchParams];
}
function validateClientSideSubmission() {
  if (typeof document === "undefined") {
    throw new Error("You are calling submit during the server render. " + "Try calling submit within a `useEffect` or callback instead.");
  }
}
let fetcherId = 0;
let getUniqueFetcherId = () => "__" + String(++fetcherId) + "__";
/**
 * Returns a function that may be used to programmatically submit a form (or
 * some arbitrary data) to the server.
 */
function useSubmit() {
  let {
    router
  } = useDataRouterContext(DataRouterHook.UseSubmit);
  let {
    basename
  } = react__WEBPACK_IMPORTED_MODULE_0__.useContext(react_router__WEBPACK_IMPORTED_MODULE_3__.UNSAFE_NavigationContext);
  let currentRouteId = (0,react_router__WEBPACK_IMPORTED_MODULE_3__.UNSAFE_useRouteId)();
  return react__WEBPACK_IMPORTED_MODULE_0__.useCallback(function (target, options) {
    if (options === void 0) {
      options = {};
    }
    validateClientSideSubmission();
    let {
      action,
      method,
      encType,
      formData,
      body
    } = getFormSubmissionInfo(target, basename);
    if (options.navigate === false) {
      let key = options.fetcherKey || getUniqueFetcherId();
      router.fetch(key, currentRouteId, options.action || action, {
        preventScrollReset: options.preventScrollReset,
        formData,
        body,
        formMethod: options.method || method,
        formEncType: options.encType || encType,
        unstable_flushSync: options.unstable_flushSync
      });
    } else {
      router.navigate(options.action || action, {
        preventScrollReset: options.preventScrollReset,
        formData,
        body,
        formMethod: options.method || method,
        formEncType: options.encType || encType,
        replace: options.replace,
        state: options.state,
        fromRouteId: currentRouteId,
        unstable_flushSync: options.unstable_flushSync,
        unstable_viewTransition: options.unstable_viewTransition
      });
    }
  }, [router, basename, currentRouteId]);
}
// v7: Eventually we should deprecate this entirely in favor of using the
// router method directly?
function useFormAction(action, _temp2) {
  let {
    relative
  } = _temp2 === void 0 ? {} : _temp2;
  let {
    basename
  } = react__WEBPACK_IMPORTED_MODULE_0__.useContext(react_router__WEBPACK_IMPORTED_MODULE_3__.UNSAFE_NavigationContext);
  let routeContext = react__WEBPACK_IMPORTED_MODULE_0__.useContext(react_router__WEBPACK_IMPORTED_MODULE_3__.UNSAFE_RouteContext);
  !routeContext ?  true ? (0,react_router__WEBPACK_IMPORTED_MODULE_2__.UNSAFE_invariant)(false, "useFormAction must be used inside a RouteContext") : 0 : void 0;
  let [match] = routeContext.matches.slice(-1);
  // Shallow clone path so we can modify it below, otherwise we modify the
  // object referenced by useMemo inside useResolvedPath
  let path = _extends({}, (0,react_router__WEBPACK_IMPORTED_MODULE_3__.useResolvedPath)(action ? action : ".", {
    relative
  }));
  // If no action was specified, browsers will persist current search params
  // when determining the path, so match that behavior
  // https://github.com/remix-run/remix/issues/927
  let location = (0,react_router__WEBPACK_IMPORTED_MODULE_3__.useLocation)();
  if (action == null) {
    // Safe to write to this directly here since if action was undefined, we
    // would have called useResolvedPath(".") which will never include a search
    path.search = location.search;
    // When grabbing search params from the URL, remove any included ?index param
    // since it might not apply to our contextual route.  We add it back based
    // on match.route.index below
    let params = new URLSearchParams(path.search);
    if (params.has("index") && params.get("index") === "") {
      params.delete("index");
      path.search = params.toString() ? "?" + params.toString() : "";
    }
  }
  if ((!action || action === ".") && match.route.index) {
    path.search = path.search ? path.search.replace(/^\?/, "?index&") : "?index";
  }
  // If we're operating within a basename, prepend it to the pathname prior
  // to creating the form action.  If this is a root navigation, then just use
  // the raw basename which allows the basename to have full control over the
  // presence of a trailing slash on root actions
  if (basename !== "/") {
    path.pathname = path.pathname === "/" ? basename : (0,react_router__WEBPACK_IMPORTED_MODULE_2__.joinPaths)([basename, path.pathname]);
  }
  return (0,react_router__WEBPACK_IMPORTED_MODULE_2__.createPath)(path);
}
// TODO: (v7) Change the useFetcher generic default from `any` to `unknown`
/**
 * Interacts with route loaders and actions without causing a navigation. Great
 * for any interaction that stays on the same page.
 */
function useFetcher(_temp3) {
  var _route$matches;
  let {
    key
  } = _temp3 === void 0 ? {} : _temp3;
  let {
    router
  } = useDataRouterContext(DataRouterHook.UseFetcher);
  let state = useDataRouterState(DataRouterStateHook.UseFetcher);
  let fetcherData = react__WEBPACK_IMPORTED_MODULE_0__.useContext(FetchersContext);
  let route = react__WEBPACK_IMPORTED_MODULE_0__.useContext(react_router__WEBPACK_IMPORTED_MODULE_3__.UNSAFE_RouteContext);
  let routeId = (_route$matches = route.matches[route.matches.length - 1]) == null ? void 0 : _route$matches.route.id;
  !fetcherData ?  true ? (0,react_router__WEBPACK_IMPORTED_MODULE_2__.UNSAFE_invariant)(false, "useFetcher must be used inside a FetchersContext") : 0 : void 0;
  !route ?  true ? (0,react_router__WEBPACK_IMPORTED_MODULE_2__.UNSAFE_invariant)(false, "useFetcher must be used inside a RouteContext") : 0 : void 0;
  !(routeId != null) ?  true ? (0,react_router__WEBPACK_IMPORTED_MODULE_2__.UNSAFE_invariant)(false, "useFetcher can only be used on routes that contain a unique \"id\"") : 0 : void 0;
  // Fetcher key handling
  // OK to call conditionally to feature detect `useId`
  // eslint-disable-next-line react-hooks/rules-of-hooks
  let defaultKey = useIdImpl ? useIdImpl() : "";
  let [fetcherKey, setFetcherKey] = react__WEBPACK_IMPORTED_MODULE_0__.useState(key || defaultKey);
  if (key && key !== fetcherKey) {
    setFetcherKey(key);
  } else if (!fetcherKey) {
    // We will only fall through here when `useId` is not available
    setFetcherKey(getUniqueFetcherId());
  }
  // Registration/cleanup
  react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
    router.getFetcher(fetcherKey);
    return () => {
      // Tell the router we've unmounted - if v7_fetcherPersist is enabled this
      // will not delete immediately but instead queue up a delete after the
      // fetcher returns to an `idle` state
      router.deleteFetcher(fetcherKey);
    };
  }, [router, fetcherKey]);
  // Fetcher additions
  let load = react__WEBPACK_IMPORTED_MODULE_0__.useCallback((href, opts) => {
    !routeId ?  true ? (0,react_router__WEBPACK_IMPORTED_MODULE_2__.UNSAFE_invariant)(false, "No routeId available for fetcher.load()") : 0 : void 0;
    router.fetch(fetcherKey, routeId, href, opts);
  }, [fetcherKey, routeId, router]);
  let submitImpl = useSubmit();
  let submit = react__WEBPACK_IMPORTED_MODULE_0__.useCallback((target, opts) => {
    submitImpl(target, _extends({}, opts, {
      navigate: false,
      fetcherKey
    }));
  }, [fetcherKey, submitImpl]);
  let FetcherForm = react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => {
    let FetcherForm = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.forwardRef((props, ref) => {
      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(Form, _extends({}, props, {
        navigate: false,
        fetcherKey: fetcherKey,
        ref: ref
      }));
    });
    if (true) {
      FetcherForm.displayName = "fetcher.Form";
    }
    return FetcherForm;
  }, [fetcherKey]);
  // Exposed FetcherWithComponents
  let fetcher = state.fetchers.get(fetcherKey) || react_router__WEBPACK_IMPORTED_MODULE_2__.IDLE_FETCHER;
  let data = fetcherData.get(fetcherKey);
  let fetcherWithComponents = react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => _extends({
    Form: FetcherForm,
    submit,
    load
  }, fetcher, {
    data
  }), [FetcherForm, submit, load, fetcher, data]);
  return fetcherWithComponents;
}
/**
 * Provides all fetchers currently on the page. Useful for layouts and parent
 * routes that need to provide pending/optimistic UI regarding the fetch.
 */
function useFetchers() {
  let state = useDataRouterState(DataRouterStateHook.UseFetchers);
  return Array.from(state.fetchers.entries()).map(_ref11 => {
    let [key, fetcher] = _ref11;
    return _extends({}, fetcher, {
      key
    });
  });
}
const SCROLL_RESTORATION_STORAGE_KEY = "react-router-scroll-positions";
let savedScrollPositions = {};
/**
 * When rendered inside a RouterProvider, will restore scroll positions on navigations
 */
function useScrollRestoration(_temp4) {
  let {
    getKey,
    storageKey
  } = _temp4 === void 0 ? {} : _temp4;
  let {
    router
  } = useDataRouterContext(DataRouterHook.UseScrollRestoration);
  let {
    restoreScrollPosition,
    preventScrollReset
  } = useDataRouterState(DataRouterStateHook.UseScrollRestoration);
  let {
    basename
  } = react__WEBPACK_IMPORTED_MODULE_0__.useContext(react_router__WEBPACK_IMPORTED_MODULE_3__.UNSAFE_NavigationContext);
  let location = (0,react_router__WEBPACK_IMPORTED_MODULE_3__.useLocation)();
  let matches = (0,react_router__WEBPACK_IMPORTED_MODULE_3__.useMatches)();
  let navigation = (0,react_router__WEBPACK_IMPORTED_MODULE_3__.useNavigation)();
  // Trigger manual scroll restoration while we're active
  react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
    window.history.scrollRestoration = "manual";
    return () => {
      window.history.scrollRestoration = "auto";
    };
  }, []);
  // Save positions on pagehide
  usePageHide(react__WEBPACK_IMPORTED_MODULE_0__.useCallback(() => {
    if (navigation.state === "idle") {
      let key = (getKey ? getKey(location, matches) : null) || location.key;
      savedScrollPositions[key] = window.scrollY;
    }
    try {
      sessionStorage.setItem(storageKey || SCROLL_RESTORATION_STORAGE_KEY, JSON.stringify(savedScrollPositions));
    } catch (error) {
       true ? (0,react_router__WEBPACK_IMPORTED_MODULE_2__.UNSAFE_warning)(false, "Failed to save scroll positions in sessionStorage, <ScrollRestoration /> will not work properly (" + error + ").") : 0;
    }
    window.history.scrollRestoration = "auto";
  }, [storageKey, getKey, navigation.state, location, matches]));
  // Read in any saved scroll locations
  if (typeof document !== "undefined") {
    // eslint-disable-next-line react-hooks/rules-of-hooks
    react__WEBPACK_IMPORTED_MODULE_0__.useLayoutEffect(() => {
      try {
        let sessionPositions = sessionStorage.getItem(storageKey || SCROLL_RESTORATION_STORAGE_KEY);
        if (sessionPositions) {
          savedScrollPositions = JSON.parse(sessionPositions);
        }
      } catch (e) {
        // no-op, use default empty object
      }
    }, [storageKey]);
    // Enable scroll restoration in the router
    // eslint-disable-next-line react-hooks/rules-of-hooks
    react__WEBPACK_IMPORTED_MODULE_0__.useLayoutEffect(() => {
      let getKeyWithoutBasename = getKey && basename !== "/" ? (location, matches) => getKey( // Strip the basename to match useLocation()
      _extends({}, location, {
        pathname: (0,react_router__WEBPACK_IMPORTED_MODULE_2__.stripBasename)(location.pathname, basename) || location.pathname
      }), matches) : getKey;
      let disableScrollRestoration = router == null ? void 0 : router.enableScrollRestoration(savedScrollPositions, () => window.scrollY, getKeyWithoutBasename);
      return () => disableScrollRestoration && disableScrollRestoration();
    }, [router, basename, getKey]);
    // Restore scrolling when state.restoreScrollPosition changes
    // eslint-disable-next-line react-hooks/rules-of-hooks
    react__WEBPACK_IMPORTED_MODULE_0__.useLayoutEffect(() => {
      // Explicit false means don't do anything (used for submissions)
      if (restoreScrollPosition === false) {
        return;
      }
      // been here before, scroll to it
      if (typeof restoreScrollPosition === "number") {
        window.scrollTo(0, restoreScrollPosition);
        return;
      }
      // try to scroll to the hash
      if (location.hash) {
        let el = document.getElementById(decodeURIComponent(location.hash.slice(1)));
        if (el) {
          el.scrollIntoView();
          return;
        }
      }
      // Don't reset if this navigation opted out
      if (preventScrollReset === true) {
        return;
      }
      // otherwise go to the top on new locations
      window.scrollTo(0, 0);
    }, [location, restoreScrollPosition, preventScrollReset]);
  }
}
/**
 * Setup a callback to be fired on the window's `beforeunload` event. This is
 * useful for saving some data to `window.localStorage` just before the page
 * refreshes.
 *
 * Note: The `callback` argument should be a function created with
 * `React.useCallback()`.
 */
function useBeforeUnload(callback, options) {
  let {
    capture
  } = options || {};
  react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
    let opts = capture != null ? {
      capture
    } : undefined;
    window.addEventListener("beforeunload", callback, opts);
    return () => {
      window.removeEventListener("beforeunload", callback, opts);
    };
  }, [callback, capture]);
}
/**
 * Setup a callback to be fired on the window's `pagehide` event. This is
 * useful for saving some data to `window.localStorage` just before the page
 * refreshes.  This event is better supported than beforeunload across browsers.
 *
 * Note: The `callback` argument should be a function created with
 * `React.useCallback()`.
 */
function usePageHide(callback, options) {
  let {
    capture
  } = options || {};
  react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
    let opts = capture != null ? {
      capture
    } : undefined;
    window.addEventListener("pagehide", callback, opts);
    return () => {
      window.removeEventListener("pagehide", callback, opts);
    };
  }, [callback, capture]);
}
/**
 * Wrapper around useBlocker to show a window.confirm prompt to users instead
 * of building a custom UI with useBlocker.
 *
 * Warning: This has *a lot of rough edges* and behaves very differently (and
 * very incorrectly in some cases) across browsers if user click addition
 * back/forward navigations while the confirm is open.  Use at your own risk.
 */
function usePrompt(_ref12) {
  let {
    when,
    message
  } = _ref12;
  let blocker = (0,react_router__WEBPACK_IMPORTED_MODULE_3__.useBlocker)(when);
  react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
    if (blocker.state === "blocked") {
      let proceed = window.confirm(message);
      if (proceed) {
        // This timeout is needed to avoid a weird "race" on POP navigations
        // between the `window.history` revert navigation and the result of
        // `window.confirm`
        setTimeout(blocker.proceed, 0);
      } else {
        blocker.reset();
      }
    }
  }, [blocker, message]);
  react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
    if (blocker.state === "blocked" && !when) {
      blocker.reset();
    }
  }, [blocker, when]);
}
/**
 * Return a boolean indicating if there is an active view transition to the
 * given href.  You can use this value to render CSS classes or viewTransitionName
 * styles onto your elements
 *
 * @param href The destination href
 * @param [opts.relative] Relative routing type ("route" | "path")
 */
function useViewTransitionState(to, opts) {
  if (opts === void 0) {
    opts = {};
  }
  let vtContext = react__WEBPACK_IMPORTED_MODULE_0__.useContext(ViewTransitionContext);
  !(vtContext != null) ?  true ? (0,react_router__WEBPACK_IMPORTED_MODULE_2__.UNSAFE_invariant)(false, "`unstable_useViewTransitionState` must be used within `react-router-dom`'s `RouterProvider`.  " + "Did you accidentally import `RouterProvider` from `react-router`?") : 0 : void 0;
  let {
    basename
  } = useDataRouterContext(DataRouterHook.useViewTransitionState);
  let path = (0,react_router__WEBPACK_IMPORTED_MODULE_3__.useResolvedPath)(to, {
    relative: opts.relative
  });
  if (!vtContext.isTransitioning) {
    return false;
  }
  let currentPath = (0,react_router__WEBPACK_IMPORTED_MODULE_2__.stripBasename)(vtContext.currentLocation.pathname, basename) || vtContext.currentLocation.pathname;
  let nextPath = (0,react_router__WEBPACK_IMPORTED_MODULE_2__.stripBasename)(vtContext.nextLocation.pathname, basename) || vtContext.nextLocation.pathname;
  // Transition is active if we're going to or coming from the indicated
  // destination.  This ensures that other PUSH navigations that reverse
  // an indicated transition apply.  I.e., on the list view you have:
  //
  //   <NavLink to="/details/1" unstable_viewTransition>
  //
  // If you click the breadcrumb back to the list view:
  //
  //   <NavLink to="/list" unstable_viewTransition>
  //
  // We should apply the transition because it's indicated as active going
  // from /list -> /details/1 and therefore should be active on the reverse
  // (even though this isn't strictly a POP reverse)
  return (0,react_router__WEBPACK_IMPORTED_MODULE_2__.matchPath)(path.pathname, nextPath) != null || (0,react_router__WEBPACK_IMPORTED_MODULE_2__.matchPath)(path.pathname, currentPath) != null;
}
//#endregion


//# sourceMappingURL=index.js.map


/***/ }),

/***/ "./node_modules/react-router/dist/index.js":
/*!*************************************************!*\
  !*** ./node_modules/react-router/dist/index.js ***!
  \*************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AbortedDeferredError: function() { return /* reexport safe */ _remix_run_router__WEBPACK_IMPORTED_MODULE_1__.AbortedDeferredError; },
/* harmony export */   Await: function() { return /* binding */ Await; },
/* harmony export */   MemoryRouter: function() { return /* binding */ MemoryRouter; },
/* harmony export */   Navigate: function() { return /* binding */ Navigate; },
/* harmony export */   NavigationType: function() { return /* reexport safe */ _remix_run_router__WEBPACK_IMPORTED_MODULE_1__.Action; },
/* harmony export */   Outlet: function() { return /* binding */ Outlet; },
/* harmony export */   Route: function() { return /* binding */ Route; },
/* harmony export */   Router: function() { return /* binding */ Router; },
/* harmony export */   RouterProvider: function() { return /* binding */ RouterProvider; },
/* harmony export */   Routes: function() { return /* binding */ Routes; },
/* harmony export */   UNSAFE_DataRouterContext: function() { return /* binding */ DataRouterContext; },
/* harmony export */   UNSAFE_DataRouterStateContext: function() { return /* binding */ DataRouterStateContext; },
/* harmony export */   UNSAFE_LocationContext: function() { return /* binding */ LocationContext; },
/* harmony export */   UNSAFE_NavigationContext: function() { return /* binding */ NavigationContext; },
/* harmony export */   UNSAFE_RouteContext: function() { return /* binding */ RouteContext; },
/* harmony export */   UNSAFE_mapRouteProperties: function() { return /* binding */ mapRouteProperties; },
/* harmony export */   UNSAFE_useRouteId: function() { return /* binding */ useRouteId; },
/* harmony export */   UNSAFE_useRoutesImpl: function() { return /* binding */ useRoutesImpl; },
/* harmony export */   createMemoryRouter: function() { return /* binding */ createMemoryRouter; },
/* harmony export */   createPath: function() { return /* reexport safe */ _remix_run_router__WEBPACK_IMPORTED_MODULE_1__.createPath; },
/* harmony export */   createRoutesFromChildren: function() { return /* binding */ createRoutesFromChildren; },
/* harmony export */   createRoutesFromElements: function() { return /* binding */ createRoutesFromChildren; },
/* harmony export */   defer: function() { return /* reexport safe */ _remix_run_router__WEBPACK_IMPORTED_MODULE_1__.defer; },
/* harmony export */   generatePath: function() { return /* reexport safe */ _remix_run_router__WEBPACK_IMPORTED_MODULE_1__.generatePath; },
/* harmony export */   isRouteErrorResponse: function() { return /* reexport safe */ _remix_run_router__WEBPACK_IMPORTED_MODULE_1__.isRouteErrorResponse; },
/* harmony export */   json: function() { return /* reexport safe */ _remix_run_router__WEBPACK_IMPORTED_MODULE_1__.json; },
/* harmony export */   matchPath: function() { return /* reexport safe */ _remix_run_router__WEBPACK_IMPORTED_MODULE_1__.matchPath; },
/* harmony export */   matchRoutes: function() { return /* reexport safe */ _remix_run_router__WEBPACK_IMPORTED_MODULE_1__.matchRoutes; },
/* harmony export */   parsePath: function() { return /* reexport safe */ _remix_run_router__WEBPACK_IMPORTED_MODULE_1__.parsePath; },
/* harmony export */   redirect: function() { return /* reexport safe */ _remix_run_router__WEBPACK_IMPORTED_MODULE_1__.redirect; },
/* harmony export */   redirectDocument: function() { return /* reexport safe */ _remix_run_router__WEBPACK_IMPORTED_MODULE_1__.redirectDocument; },
/* harmony export */   renderMatches: function() { return /* binding */ renderMatches; },
/* harmony export */   replace: function() { return /* reexport safe */ _remix_run_router__WEBPACK_IMPORTED_MODULE_1__.replace; },
/* harmony export */   resolvePath: function() { return /* reexport safe */ _remix_run_router__WEBPACK_IMPORTED_MODULE_1__.resolvePath; },
/* harmony export */   useActionData: function() { return /* binding */ useActionData; },
/* harmony export */   useAsyncError: function() { return /* binding */ useAsyncError; },
/* harmony export */   useAsyncValue: function() { return /* binding */ useAsyncValue; },
/* harmony export */   useBlocker: function() { return /* binding */ useBlocker; },
/* harmony export */   useHref: function() { return /* binding */ useHref; },
/* harmony export */   useInRouterContext: function() { return /* binding */ useInRouterContext; },
/* harmony export */   useLoaderData: function() { return /* binding */ useLoaderData; },
/* harmony export */   useLocation: function() { return /* binding */ useLocation; },
/* harmony export */   useMatch: function() { return /* binding */ useMatch; },
/* harmony export */   useMatches: function() { return /* binding */ useMatches; },
/* harmony export */   useNavigate: function() { return /* binding */ useNavigate; },
/* harmony export */   useNavigation: function() { return /* binding */ useNavigation; },
/* harmony export */   useNavigationType: function() { return /* binding */ useNavigationType; },
/* harmony export */   useOutlet: function() { return /* binding */ useOutlet; },
/* harmony export */   useOutletContext: function() { return /* binding */ useOutletContext; },
/* harmony export */   useParams: function() { return /* binding */ useParams; },
/* harmony export */   useResolvedPath: function() { return /* binding */ useResolvedPath; },
/* harmony export */   useRevalidator: function() { return /* binding */ useRevalidator; },
/* harmony export */   useRouteError: function() { return /* binding */ useRouteError; },
/* harmony export */   useRouteLoaderData: function() { return /* binding */ useRouteLoaderData; },
/* harmony export */   useRoutes: function() { return /* binding */ useRoutes; }
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _remix_run_router__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @remix-run/router */ "./node_modules/@remix-run/router/dist/router.js");
/**
 * React Router v6.26.0
 *
 * Copyright (c) Remix Software Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE.md file in the root directory of this source tree.
 *
 * @license MIT
 */




function _extends() {
  _extends = Object.assign ? Object.assign.bind() : function (target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i];
      for (var key in source) {
        if (Object.prototype.hasOwnProperty.call(source, key)) {
          target[key] = source[key];
        }
      }
    }
    return target;
  };
  return _extends.apply(this, arguments);
}

// Create react-specific types from the agnostic types in @remix-run/router to
// export from react-router
const DataRouterContext = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createContext(null);
if (true) {
  DataRouterContext.displayName = "DataRouter";
}
const DataRouterStateContext = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createContext(null);
if (true) {
  DataRouterStateContext.displayName = "DataRouterState";
}
const AwaitContext = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createContext(null);
if (true) {
  AwaitContext.displayName = "Await";
}

/**
 * A Navigator is a "location changer"; it's how you get to different locations.
 *
 * Every history instance conforms to the Navigator interface, but the
 * distinction is useful primarily when it comes to the low-level `<Router>` API
 * where both the location and a navigator must be provided separately in order
 * to avoid "tearing" that may occur in a suspense-enabled app if the action
 * and/or location were to be read directly from the history instance.
 */

const NavigationContext = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createContext(null);
if (true) {
  NavigationContext.displayName = "Navigation";
}
const LocationContext = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createContext(null);
if (true) {
  LocationContext.displayName = "Location";
}
const RouteContext = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createContext({
  outlet: null,
  matches: [],
  isDataRoute: false
});
if (true) {
  RouteContext.displayName = "Route";
}
const RouteErrorContext = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createContext(null);
if (true) {
  RouteErrorContext.displayName = "RouteError";
}

/**
 * Returns the full href for the given "to" value. This is useful for building
 * custom links that are also accessible and preserve right-click behavior.
 *
 * @see https://reactrouter.com/hooks/use-href
 */
function useHref(to, _temp) {
  let {
    relative
  } = _temp === void 0 ? {} : _temp;
  !useInRouterContext() ?  true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_invariant)(false, // TODO: This error is probably because they somehow have 2 versions of the
  // router loaded. We can help them understand how to avoid that.
  "useHref() may be used only in the context of a <Router> component.") : 0 : void 0;
  let {
    basename,
    navigator
  } = react__WEBPACK_IMPORTED_MODULE_0__.useContext(NavigationContext);
  let {
    hash,
    pathname,
    search
  } = useResolvedPath(to, {
    relative
  });
  let joinedPathname = pathname;

  // If we're operating within a basename, prepend it to the pathname prior
  // to creating the href.  If this is a root navigation, then just use the raw
  // basename which allows the basename to have full control over the presence
  // of a trailing slash on root links
  if (basename !== "/") {
    joinedPathname = pathname === "/" ? basename : (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.joinPaths)([basename, pathname]);
  }
  return navigator.createHref({
    pathname: joinedPathname,
    search,
    hash
  });
}

/**
 * Returns true if this component is a descendant of a `<Router>`.
 *
 * @see https://reactrouter.com/hooks/use-in-router-context
 */
function useInRouterContext() {
  return react__WEBPACK_IMPORTED_MODULE_0__.useContext(LocationContext) != null;
}

/**
 * Returns the current location object, which represents the current URL in web
 * browsers.
 *
 * Note: If you're using this it may mean you're doing some of your own
 * "routing" in your app, and we'd like to know what your use case is. We may
 * be able to provide something higher-level to better suit your needs.
 *
 * @see https://reactrouter.com/hooks/use-location
 */
function useLocation() {
  !useInRouterContext() ?  true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_invariant)(false, // TODO: This error is probably because they somehow have 2 versions of the
  // router loaded. We can help them understand how to avoid that.
  "useLocation() may be used only in the context of a <Router> component.") : 0 : void 0;
  return react__WEBPACK_IMPORTED_MODULE_0__.useContext(LocationContext).location;
}

/**
 * Returns the current navigation action which describes how the router came to
 * the current location, either by a pop, push, or replace on the history stack.
 *
 * @see https://reactrouter.com/hooks/use-navigation-type
 */
function useNavigationType() {
  return react__WEBPACK_IMPORTED_MODULE_0__.useContext(LocationContext).navigationType;
}

/**
 * Returns a PathMatch object if the given pattern matches the current URL.
 * This is useful for components that need to know "active" state, e.g.
 * `<NavLink>`.
 *
 * @see https://reactrouter.com/hooks/use-match
 */
function useMatch(pattern) {
  !useInRouterContext() ?  true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_invariant)(false, // TODO: This error is probably because they somehow have 2 versions of the
  // router loaded. We can help them understand how to avoid that.
  "useMatch() may be used only in the context of a <Router> component.") : 0 : void 0;
  let {
    pathname
  } = useLocation();
  return react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.matchPath)(pattern, (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_decodePath)(pathname)), [pathname, pattern]);
}

/**
 * The interface for the navigate() function returned from useNavigate().
 */

const navigateEffectWarning = "You should call navigate() in a React.useEffect(), not when " + "your component is first rendered.";

// Mute warnings for calls to useNavigate in SSR environments
function useIsomorphicLayoutEffect(cb) {
  let isStatic = react__WEBPACK_IMPORTED_MODULE_0__.useContext(NavigationContext).static;
  if (!isStatic) {
    // We should be able to get rid of this once react 18.3 is released
    // See: https://github.com/facebook/react/pull/26395
    // eslint-disable-next-line react-hooks/rules-of-hooks
    react__WEBPACK_IMPORTED_MODULE_0__.useLayoutEffect(cb);
  }
}

/**
 * Returns an imperative method for changing the location. Used by `<Link>`s, but
 * may also be used by other elements to change the location.
 *
 * @see https://reactrouter.com/hooks/use-navigate
 */
function useNavigate() {
  let {
    isDataRoute
  } = react__WEBPACK_IMPORTED_MODULE_0__.useContext(RouteContext);
  // Conditional usage is OK here because the usage of a data router is static
  // eslint-disable-next-line react-hooks/rules-of-hooks
  return isDataRoute ? useNavigateStable() : useNavigateUnstable();
}
function useNavigateUnstable() {
  !useInRouterContext() ?  true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_invariant)(false, // TODO: This error is probably because they somehow have 2 versions of the
  // router loaded. We can help them understand how to avoid that.
  "useNavigate() may be used only in the context of a <Router> component.") : 0 : void 0;
  let dataRouterContext = react__WEBPACK_IMPORTED_MODULE_0__.useContext(DataRouterContext);
  let {
    basename,
    future,
    navigator
  } = react__WEBPACK_IMPORTED_MODULE_0__.useContext(NavigationContext);
  let {
    matches
  } = react__WEBPACK_IMPORTED_MODULE_0__.useContext(RouteContext);
  let {
    pathname: locationPathname
  } = useLocation();
  let routePathnamesJson = JSON.stringify((0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_getResolveToMatches)(matches, future.v7_relativeSplatPath));
  let activeRef = react__WEBPACK_IMPORTED_MODULE_0__.useRef(false);
  useIsomorphicLayoutEffect(() => {
    activeRef.current = true;
  });
  let navigate = react__WEBPACK_IMPORTED_MODULE_0__.useCallback(function (to, options) {
    if (options === void 0) {
      options = {};
    }
     true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_warning)(activeRef.current, navigateEffectWarning) : 0;

    // Short circuit here since if this happens on first render the navigate
    // is useless because we haven't wired up our history listener yet
    if (!activeRef.current) return;
    if (typeof to === "number") {
      navigator.go(to);
      return;
    }
    let path = (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.resolveTo)(to, JSON.parse(routePathnamesJson), locationPathname, options.relative === "path");

    // If we're operating within a basename, prepend it to the pathname prior
    // to handing off to history (but only if we're not in a data router,
    // otherwise it'll prepend the basename inside of the router).
    // If this is a root navigation, then we navigate to the raw basename
    // which allows the basename to have full control over the presence of a
    // trailing slash on root links
    if (dataRouterContext == null && basename !== "/") {
      path.pathname = path.pathname === "/" ? basename : (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.joinPaths)([basename, path.pathname]);
    }
    (!!options.replace ? navigator.replace : navigator.push)(path, options.state, options);
  }, [basename, navigator, routePathnamesJson, locationPathname, dataRouterContext]);
  return navigate;
}
const OutletContext = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createContext(null);

/**
 * Returns the context (if provided) for the child route at this level of the route
 * hierarchy.
 * @see https://reactrouter.com/hooks/use-outlet-context
 */
function useOutletContext() {
  return react__WEBPACK_IMPORTED_MODULE_0__.useContext(OutletContext);
}

/**
 * Returns the element for the child route at this level of the route
 * hierarchy. Used internally by `<Outlet>` to render child routes.
 *
 * @see https://reactrouter.com/hooks/use-outlet
 */
function useOutlet(context) {
  let outlet = react__WEBPACK_IMPORTED_MODULE_0__.useContext(RouteContext).outlet;
  if (outlet) {
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(OutletContext.Provider, {
      value: context
    }, outlet);
  }
  return outlet;
}

/**
 * Returns an object of key/value pairs of the dynamic params from the current
 * URL that were matched by the route path.
 *
 * @see https://reactrouter.com/hooks/use-params
 */
function useParams() {
  let {
    matches
  } = react__WEBPACK_IMPORTED_MODULE_0__.useContext(RouteContext);
  let routeMatch = matches[matches.length - 1];
  return routeMatch ? routeMatch.params : {};
}

/**
 * Resolves the pathname of the given `to` value against the current location.
 *
 * @see https://reactrouter.com/hooks/use-resolved-path
 */
function useResolvedPath(to, _temp2) {
  let {
    relative
  } = _temp2 === void 0 ? {} : _temp2;
  let {
    future
  } = react__WEBPACK_IMPORTED_MODULE_0__.useContext(NavigationContext);
  let {
    matches
  } = react__WEBPACK_IMPORTED_MODULE_0__.useContext(RouteContext);
  let {
    pathname: locationPathname
  } = useLocation();
  let routePathnamesJson = JSON.stringify((0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_getResolveToMatches)(matches, future.v7_relativeSplatPath));
  return react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.resolveTo)(to, JSON.parse(routePathnamesJson), locationPathname, relative === "path"), [to, routePathnamesJson, locationPathname, relative]);
}

/**
 * Returns the element of the route that matched the current location, prepared
 * with the correct context to render the remainder of the route tree. Route
 * elements in the tree must render an `<Outlet>` to render their child route's
 * element.
 *
 * @see https://reactrouter.com/hooks/use-routes
 */
function useRoutes(routes, locationArg) {
  return useRoutesImpl(routes, locationArg);
}

// Internal implementation with accept optional param for RouterProvider usage
function useRoutesImpl(routes, locationArg, dataRouterState, future) {
  !useInRouterContext() ?  true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_invariant)(false, // TODO: This error is probably because they somehow have 2 versions of the
  // router loaded. We can help them understand how to avoid that.
  "useRoutes() may be used only in the context of a <Router> component.") : 0 : void 0;
  let {
    navigator
  } = react__WEBPACK_IMPORTED_MODULE_0__.useContext(NavigationContext);
  let {
    matches: parentMatches
  } = react__WEBPACK_IMPORTED_MODULE_0__.useContext(RouteContext);
  let routeMatch = parentMatches[parentMatches.length - 1];
  let parentParams = routeMatch ? routeMatch.params : {};
  let parentPathname = routeMatch ? routeMatch.pathname : "/";
  let parentPathnameBase = routeMatch ? routeMatch.pathnameBase : "/";
  let parentRoute = routeMatch && routeMatch.route;
  if (true) {
    // You won't get a warning about 2 different <Routes> under a <Route>
    // without a trailing *, but this is a best-effort warning anyway since we
    // cannot even give the warning unless they land at the parent route.
    //
    // Example:
    //
    // <Routes>
    //   {/* This route path MUST end with /* because otherwise
    //       it will never match /blog/post/123 */}
    //   <Route path="blog" element={<Blog />} />
    //   <Route path="blog/feed" element={<BlogFeed />} />
    // </Routes>
    //
    // function Blog() {
    //   return (
    //     <Routes>
    //       <Route path="post/:id" element={<Post />} />
    //     </Routes>
    //   );
    // }
    let parentPath = parentRoute && parentRoute.path || "";
    warningOnce(parentPathname, !parentRoute || parentPath.endsWith("*"), "You rendered descendant <Routes> (or called `useRoutes()`) at " + ("\"" + parentPathname + "\" (under <Route path=\"" + parentPath + "\">) but the ") + "parent route path has no trailing \"*\". This means if you navigate " + "deeper, the parent won't match anymore and therefore the child " + "routes will never render.\n\n" + ("Please change the parent <Route path=\"" + parentPath + "\"> to <Route ") + ("path=\"" + (parentPath === "/" ? "*" : parentPath + "/*") + "\">."));
  }
  let locationFromContext = useLocation();
  let location;
  if (locationArg) {
    var _parsedLocationArg$pa;
    let parsedLocationArg = typeof locationArg === "string" ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.parsePath)(locationArg) : locationArg;
    !(parentPathnameBase === "/" || ((_parsedLocationArg$pa = parsedLocationArg.pathname) == null ? void 0 : _parsedLocationArg$pa.startsWith(parentPathnameBase))) ?  true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_invariant)(false, "When overriding the location using `<Routes location>` or `useRoutes(routes, location)`, " + "the location pathname must begin with the portion of the URL pathname that was " + ("matched by all parent routes. The current pathname base is \"" + parentPathnameBase + "\" ") + ("but pathname \"" + parsedLocationArg.pathname + "\" was given in the `location` prop.")) : 0 : void 0;
    location = parsedLocationArg;
  } else {
    location = locationFromContext;
  }
  let pathname = location.pathname || "/";
  let remainingPathname = pathname;
  if (parentPathnameBase !== "/") {
    // Determine the remaining pathname by removing the # of URL segments the
    // parentPathnameBase has, instead of removing based on character count.
    // This is because we can't guarantee that incoming/outgoing encodings/
    // decodings will match exactly.
    // We decode paths before matching on a per-segment basis with
    // decodeURIComponent(), but we re-encode pathnames via `new URL()` so they
    // match what `window.location.pathname` would reflect.  Those don't 100%
    // align when it comes to encoded URI characters such as % and &.
    //
    // So we may end up with:
    //   pathname:           "/descendant/a%25b/match"
    //   parentPathnameBase: "/descendant/a%b"
    //
    // And the direct substring removal approach won't work :/
    let parentSegments = parentPathnameBase.replace(/^\//, "").split("/");
    let segments = pathname.replace(/^\//, "").split("/");
    remainingPathname = "/" + segments.slice(parentSegments.length).join("/");
  }
  let matches = (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.matchRoutes)(routes, {
    pathname: remainingPathname
  });
  if (true) {
     true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_warning)(parentRoute || matches != null, "No routes matched location \"" + location.pathname + location.search + location.hash + "\" ") : 0;
     true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_warning)(matches == null || matches[matches.length - 1].route.element !== undefined || matches[matches.length - 1].route.Component !== undefined || matches[matches.length - 1].route.lazy !== undefined, "Matched leaf route at location \"" + location.pathname + location.search + location.hash + "\" " + "does not have an element or Component. This means it will render an <Outlet /> with a " + "null value by default resulting in an \"empty\" page.") : 0;
  }
  let renderedMatches = _renderMatches(matches && matches.map(match => Object.assign({}, match, {
    params: Object.assign({}, parentParams, match.params),
    pathname: (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.joinPaths)([parentPathnameBase,
    // Re-encode pathnames that were decoded inside matchRoutes
    navigator.encodeLocation ? navigator.encodeLocation(match.pathname).pathname : match.pathname]),
    pathnameBase: match.pathnameBase === "/" ? parentPathnameBase : (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.joinPaths)([parentPathnameBase,
    // Re-encode pathnames that were decoded inside matchRoutes
    navigator.encodeLocation ? navigator.encodeLocation(match.pathnameBase).pathname : match.pathnameBase])
  })), parentMatches, dataRouterState, future);

  // When a user passes in a `locationArg`, the associated routes need to
  // be wrapped in a new `LocationContext.Provider` in order for `useLocation`
  // to use the scoped location instead of the global location.
  if (locationArg && renderedMatches) {
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(LocationContext.Provider, {
      value: {
        location: _extends({
          pathname: "/",
          search: "",
          hash: "",
          state: null,
          key: "default"
        }, location),
        navigationType: _remix_run_router__WEBPACK_IMPORTED_MODULE_1__.Action.Pop
      }
    }, renderedMatches);
  }
  return renderedMatches;
}
function DefaultErrorComponent() {
  let error = useRouteError();
  let message = (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.isRouteErrorResponse)(error) ? error.status + " " + error.statusText : error instanceof Error ? error.message : JSON.stringify(error);
  let stack = error instanceof Error ? error.stack : null;
  let lightgrey = "rgba(200,200,200, 0.5)";
  let preStyles = {
    padding: "0.5rem",
    backgroundColor: lightgrey
  };
  let codeStyles = {
    padding: "2px 4px",
    backgroundColor: lightgrey
  };
  let devInfo = null;
  if (true) {
    console.error("Error handled by React Router default ErrorBoundary:", error);
    devInfo = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("p", null, "\uD83D\uDCBF Hey developer \uD83D\uDC4B"), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("p", null, "You can provide a way better UX than this when your app throws errors by providing your own ", /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("code", {
      style: codeStyles
    }, "ErrorBoundary"), " or", " ", /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("code", {
      style: codeStyles
    }, "errorElement"), " prop on your route."));
  }
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("h2", null, "Unexpected Application Error!"), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("h3", {
    style: {
      fontStyle: "italic"
    }
  }, message), stack ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("pre", {
    style: preStyles
  }, stack) : null, devInfo);
}
const defaultErrorElement = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(DefaultErrorComponent, null);
class RenderErrorBoundary extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
  constructor(props) {
    super(props);
    this.state = {
      location: props.location,
      revalidation: props.revalidation,
      error: props.error
    };
  }
  static getDerivedStateFromError(error) {
    return {
      error: error
    };
  }
  static getDerivedStateFromProps(props, state) {
    // When we get into an error state, the user will likely click "back" to the
    // previous page that didn't have an error. Because this wraps the entire
    // application, that will have no effect--the error page continues to display.
    // This gives us a mechanism to recover from the error when the location changes.
    //
    // Whether we're in an error state or not, we update the location in state
    // so that when we are in an error state, it gets reset when a new location
    // comes in and the user recovers from the error.
    if (state.location !== props.location || state.revalidation !== "idle" && props.revalidation === "idle") {
      return {
        error: props.error,
        location: props.location,
        revalidation: props.revalidation
      };
    }

    // If we're not changing locations, preserve the location but still surface
    // any new errors that may come through. We retain the existing error, we do
    // this because the error provided from the app state may be cleared without
    // the location changing.
    return {
      error: props.error !== undefined ? props.error : state.error,
      location: state.location,
      revalidation: props.revalidation || state.revalidation
    };
  }
  componentDidCatch(error, errorInfo) {
    console.error("React Router caught the following error during render", error, errorInfo);
  }
  render() {
    return this.state.error !== undefined ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(RouteContext.Provider, {
      value: this.props.routeContext
    }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(RouteErrorContext.Provider, {
      value: this.state.error,
      children: this.props.component
    })) : this.props.children;
  }
}
function RenderedRoute(_ref) {
  let {
    routeContext,
    match,
    children
  } = _ref;
  let dataRouterContext = react__WEBPACK_IMPORTED_MODULE_0__.useContext(DataRouterContext);

  // Track how deep we got in our render pass to emulate SSR componentDidCatch
  // in a DataStaticRouter
  if (dataRouterContext && dataRouterContext.static && dataRouterContext.staticContext && (match.route.errorElement || match.route.ErrorBoundary)) {
    dataRouterContext.staticContext._deepestRenderedBoundaryId = match.route.id;
  }
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(RouteContext.Provider, {
    value: routeContext
  }, children);
}
function _renderMatches(matches, parentMatches, dataRouterState, future) {
  var _dataRouterState;
  if (parentMatches === void 0) {
    parentMatches = [];
  }
  if (dataRouterState === void 0) {
    dataRouterState = null;
  }
  if (future === void 0) {
    future = null;
  }
  if (matches == null) {
    var _future;
    if (!dataRouterState) {
      return null;
    }
    if (dataRouterState.errors) {
      // Don't bail if we have data router errors so we can render them in the
      // boundary.  Use the pre-matched (or shimmed) matches
      matches = dataRouterState.matches;
    } else if ((_future = future) != null && _future.v7_partialHydration && parentMatches.length === 0 && !dataRouterState.initialized && dataRouterState.matches.length > 0) {
      // Don't bail if we're initializing with partial hydration and we have
      // router matches.  That means we're actively running `patchRoutesOnMiss`
      // so we should render down the partial matches to the appropriate
      // `HydrateFallback`.  We only do this if `parentMatches` is empty so it
      // only impacts the root matches for `RouterProvider` and no descendant
      // `<Routes>`
      matches = dataRouterState.matches;
    } else {
      return null;
    }
  }
  let renderedMatches = matches;

  // If we have data errors, trim matches to the highest error boundary
  let errors = (_dataRouterState = dataRouterState) == null ? void 0 : _dataRouterState.errors;
  if (errors != null) {
    let errorIndex = renderedMatches.findIndex(m => m.route.id && (errors == null ? void 0 : errors[m.route.id]) !== undefined);
    !(errorIndex >= 0) ?  true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_invariant)(false, "Could not find a matching route for errors on route IDs: " + Object.keys(errors).join(",")) : 0 : void 0;
    renderedMatches = renderedMatches.slice(0, Math.min(renderedMatches.length, errorIndex + 1));
  }

  // If we're in a partial hydration mode, detect if we need to render down to
  // a given HydrateFallback while we load the rest of the hydration data
  let renderFallback = false;
  let fallbackIndex = -1;
  if (dataRouterState && future && future.v7_partialHydration) {
    for (let i = 0; i < renderedMatches.length; i++) {
      let match = renderedMatches[i];
      // Track the deepest fallback up until the first route without data
      if (match.route.HydrateFallback || match.route.hydrateFallbackElement) {
        fallbackIndex = i;
      }
      if (match.route.id) {
        let {
          loaderData,
          errors
        } = dataRouterState;
        let needsToRunLoader = match.route.loader && loaderData[match.route.id] === undefined && (!errors || errors[match.route.id] === undefined);
        if (match.route.lazy || needsToRunLoader) {
          // We found the first route that's not ready to render (waiting on
          // lazy, or has a loader that hasn't run yet).  Flag that we need to
          // render a fallback and render up until the appropriate fallback
          renderFallback = true;
          if (fallbackIndex >= 0) {
            renderedMatches = renderedMatches.slice(0, fallbackIndex + 1);
          } else {
            renderedMatches = [renderedMatches[0]];
          }
          break;
        }
      }
    }
  }
  return renderedMatches.reduceRight((outlet, match, index) => {
    // Only data routers handle errors/fallbacks
    let error;
    let shouldRenderHydrateFallback = false;
    let errorElement = null;
    let hydrateFallbackElement = null;
    if (dataRouterState) {
      error = errors && match.route.id ? errors[match.route.id] : undefined;
      errorElement = match.route.errorElement || defaultErrorElement;
      if (renderFallback) {
        if (fallbackIndex < 0 && index === 0) {
          warningOnce("route-fallback", false, "No `HydrateFallback` element provided to render during initial hydration");
          shouldRenderHydrateFallback = true;
          hydrateFallbackElement = null;
        } else if (fallbackIndex === index) {
          shouldRenderHydrateFallback = true;
          hydrateFallbackElement = match.route.hydrateFallbackElement || null;
        }
      }
    }
    let matches = parentMatches.concat(renderedMatches.slice(0, index + 1));
    let getChildren = () => {
      let children;
      if (error) {
        children = errorElement;
      } else if (shouldRenderHydrateFallback) {
        children = hydrateFallbackElement;
      } else if (match.route.Component) {
        // Note: This is a de-optimized path since React won't re-use the
        // ReactElement since it's identity changes with each new
        // React.createElement call.  We keep this so folks can use
        // `<Route Component={...}>` in `<Routes>` but generally `Component`
        // usage is only advised in `RouterProvider` when we can convert it to
        // `element` ahead of time.
        children = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(match.route.Component, null);
      } else if (match.route.element) {
        children = match.route.element;
      } else {
        children = outlet;
      }
      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(RenderedRoute, {
        match: match,
        routeContext: {
          outlet,
          matches,
          isDataRoute: dataRouterState != null
        },
        children: children
      });
    };
    // Only wrap in an error boundary within data router usages when we have an
    // ErrorBoundary/errorElement on this route.  Otherwise let it bubble up to
    // an ancestor ErrorBoundary/errorElement
    return dataRouterState && (match.route.ErrorBoundary || match.route.errorElement || index === 0) ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(RenderErrorBoundary, {
      location: dataRouterState.location,
      revalidation: dataRouterState.revalidation,
      component: errorElement,
      error: error,
      children: getChildren(),
      routeContext: {
        outlet: null,
        matches,
        isDataRoute: true
      }
    }) : getChildren();
  }, null);
}
var DataRouterHook = /*#__PURE__*/function (DataRouterHook) {
  DataRouterHook["UseBlocker"] = "useBlocker";
  DataRouterHook["UseRevalidator"] = "useRevalidator";
  DataRouterHook["UseNavigateStable"] = "useNavigate";
  return DataRouterHook;
}(DataRouterHook || {});
var DataRouterStateHook = /*#__PURE__*/function (DataRouterStateHook) {
  DataRouterStateHook["UseBlocker"] = "useBlocker";
  DataRouterStateHook["UseLoaderData"] = "useLoaderData";
  DataRouterStateHook["UseActionData"] = "useActionData";
  DataRouterStateHook["UseRouteError"] = "useRouteError";
  DataRouterStateHook["UseNavigation"] = "useNavigation";
  DataRouterStateHook["UseRouteLoaderData"] = "useRouteLoaderData";
  DataRouterStateHook["UseMatches"] = "useMatches";
  DataRouterStateHook["UseRevalidator"] = "useRevalidator";
  DataRouterStateHook["UseNavigateStable"] = "useNavigate";
  DataRouterStateHook["UseRouteId"] = "useRouteId";
  return DataRouterStateHook;
}(DataRouterStateHook || {});
function getDataRouterConsoleError(hookName) {
  return hookName + " must be used within a data router.  See https://reactrouter.com/routers/picking-a-router.";
}
function useDataRouterContext(hookName) {
  let ctx = react__WEBPACK_IMPORTED_MODULE_0__.useContext(DataRouterContext);
  !ctx ?  true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_invariant)(false, getDataRouterConsoleError(hookName)) : 0 : void 0;
  return ctx;
}
function useDataRouterState(hookName) {
  let state = react__WEBPACK_IMPORTED_MODULE_0__.useContext(DataRouterStateContext);
  !state ?  true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_invariant)(false, getDataRouterConsoleError(hookName)) : 0 : void 0;
  return state;
}
function useRouteContext(hookName) {
  let route = react__WEBPACK_IMPORTED_MODULE_0__.useContext(RouteContext);
  !route ?  true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_invariant)(false, getDataRouterConsoleError(hookName)) : 0 : void 0;
  return route;
}

// Internal version with hookName-aware debugging
function useCurrentRouteId(hookName) {
  let route = useRouteContext(hookName);
  let thisRoute = route.matches[route.matches.length - 1];
  !thisRoute.route.id ?  true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_invariant)(false, hookName + " can only be used on routes that contain a unique \"id\"") : 0 : void 0;
  return thisRoute.route.id;
}

/**
 * Returns the ID for the nearest contextual route
 */
function useRouteId() {
  return useCurrentRouteId(DataRouterStateHook.UseRouteId);
}

/**
 * Returns the current navigation, defaulting to an "idle" navigation when
 * no navigation is in progress
 */
function useNavigation() {
  let state = useDataRouterState(DataRouterStateHook.UseNavigation);
  return state.navigation;
}

/**
 * Returns a revalidate function for manually triggering revalidation, as well
 * as the current state of any manual revalidations
 */
function useRevalidator() {
  let dataRouterContext = useDataRouterContext(DataRouterHook.UseRevalidator);
  let state = useDataRouterState(DataRouterStateHook.UseRevalidator);
  return react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => ({
    revalidate: dataRouterContext.router.revalidate,
    state: state.revalidation
  }), [dataRouterContext.router.revalidate, state.revalidation]);
}

/**
 * Returns the active route matches, useful for accessing loaderData for
 * parent/child routes or the route "handle" property
 */
function useMatches() {
  let {
    matches,
    loaderData
  } = useDataRouterState(DataRouterStateHook.UseMatches);
  return react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => matches.map(m => (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_convertRouteMatchToUiMatch)(m, loaderData)), [matches, loaderData]);
}

/**
 * Returns the loader data for the nearest ancestor Route loader
 */
function useLoaderData() {
  let state = useDataRouterState(DataRouterStateHook.UseLoaderData);
  let routeId = useCurrentRouteId(DataRouterStateHook.UseLoaderData);
  if (state.errors && state.errors[routeId] != null) {
    console.error("You cannot `useLoaderData` in an errorElement (routeId: " + routeId + ")");
    return undefined;
  }
  return state.loaderData[routeId];
}

/**
 * Returns the loaderData for the given routeId
 */
function useRouteLoaderData(routeId) {
  let state = useDataRouterState(DataRouterStateHook.UseRouteLoaderData);
  return state.loaderData[routeId];
}

/**
 * Returns the action data for the nearest ancestor Route action
 */
function useActionData() {
  let state = useDataRouterState(DataRouterStateHook.UseActionData);
  let routeId = useCurrentRouteId(DataRouterStateHook.UseLoaderData);
  return state.actionData ? state.actionData[routeId] : undefined;
}

/**
 * Returns the nearest ancestor Route error, which could be a loader/action
 * error or a render error.  This is intended to be called from your
 * ErrorBoundary/errorElement to display a proper error message.
 */
function useRouteError() {
  var _state$errors;
  let error = react__WEBPACK_IMPORTED_MODULE_0__.useContext(RouteErrorContext);
  let state = useDataRouterState(DataRouterStateHook.UseRouteError);
  let routeId = useCurrentRouteId(DataRouterStateHook.UseRouteError);

  // If this was a render error, we put it in a RouteError context inside
  // of RenderErrorBoundary
  if (error !== undefined) {
    return error;
  }

  // Otherwise look for errors from our data router state
  return (_state$errors = state.errors) == null ? void 0 : _state$errors[routeId];
}

/**
 * Returns the happy-path data from the nearest ancestor `<Await />` value
 */
function useAsyncValue() {
  let value = react__WEBPACK_IMPORTED_MODULE_0__.useContext(AwaitContext);
  return value == null ? void 0 : value._data;
}

/**
 * Returns the error from the nearest ancestor `<Await />` value
 */
function useAsyncError() {
  let value = react__WEBPACK_IMPORTED_MODULE_0__.useContext(AwaitContext);
  return value == null ? void 0 : value._error;
}
let blockerId = 0;

/**
 * Allow the application to block navigations within the SPA and present the
 * user a confirmation dialog to confirm the navigation.  Mostly used to avoid
 * using half-filled form data.  This does not handle hard-reloads or
 * cross-origin navigations.
 */
function useBlocker(shouldBlock) {
  let {
    router,
    basename
  } = useDataRouterContext(DataRouterHook.UseBlocker);
  let state = useDataRouterState(DataRouterStateHook.UseBlocker);
  let [blockerKey, setBlockerKey] = react__WEBPACK_IMPORTED_MODULE_0__.useState("");
  let blockerFunction = react__WEBPACK_IMPORTED_MODULE_0__.useCallback(arg => {
    if (typeof shouldBlock !== "function") {
      return !!shouldBlock;
    }
    if (basename === "/") {
      return shouldBlock(arg);
    }

    // If they provided us a function and we've got an active basename, strip
    // it from the locations we expose to the user to match the behavior of
    // useLocation
    let {
      currentLocation,
      nextLocation,
      historyAction
    } = arg;
    return shouldBlock({
      currentLocation: _extends({}, currentLocation, {
        pathname: (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.stripBasename)(currentLocation.pathname, basename) || currentLocation.pathname
      }),
      nextLocation: _extends({}, nextLocation, {
        pathname: (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.stripBasename)(nextLocation.pathname, basename) || nextLocation.pathname
      }),
      historyAction
    });
  }, [basename, shouldBlock]);

  // This effect is in charge of blocker key assignment and deletion (which is
  // tightly coupled to the key)
  react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
    let key = String(++blockerId);
    setBlockerKey(key);
    return () => router.deleteBlocker(key);
  }, [router]);

  // This effect handles assigning the blockerFunction.  This is to handle
  // unstable blocker function identities, and happens only after the prior
  // effect so we don't get an orphaned blockerFunction in the router with a
  // key of "".  Until then we just have the IDLE_BLOCKER.
  react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
    if (blockerKey !== "") {
      router.getBlocker(blockerKey, blockerFunction);
    }
  }, [router, blockerKey, blockerFunction]);

  // Prefer the blocker from `state` not `router.state` since DataRouterContext
  // is memoized so this ensures we update on blocker state updates
  return blockerKey && state.blockers.has(blockerKey) ? state.blockers.get(blockerKey) : _remix_run_router__WEBPACK_IMPORTED_MODULE_1__.IDLE_BLOCKER;
}

/**
 * Stable version of useNavigate that is used when we are in the context of
 * a RouterProvider.
 */
function useNavigateStable() {
  let {
    router
  } = useDataRouterContext(DataRouterHook.UseNavigateStable);
  let id = useCurrentRouteId(DataRouterStateHook.UseNavigateStable);
  let activeRef = react__WEBPACK_IMPORTED_MODULE_0__.useRef(false);
  useIsomorphicLayoutEffect(() => {
    activeRef.current = true;
  });
  let navigate = react__WEBPACK_IMPORTED_MODULE_0__.useCallback(function (to, options) {
    if (options === void 0) {
      options = {};
    }
     true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_warning)(activeRef.current, navigateEffectWarning) : 0;

    // Short circuit here since if this happens on first render the navigate
    // is useless because we haven't wired up our router subscriber yet
    if (!activeRef.current) return;
    if (typeof to === "number") {
      router.navigate(to);
    } else {
      router.navigate(to, _extends({
        fromRouteId: id
      }, options));
    }
  }, [router, id]);
  return navigate;
}
const alreadyWarned = {};
function warningOnce(key, cond, message) {
  if (!cond && !alreadyWarned[key]) {
    alreadyWarned[key] = true;
     true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_warning)(false, message) : 0;
  }
}

/**
  Webpack + React 17 fails to compile on any of the following because webpack
  complains that `startTransition` doesn't exist in `React`:
  * import { startTransition } from "react"
  * import * as React from from "react";
    "startTransition" in React ? React.startTransition(() => setState()) : setState()
  * import * as React from from "react";
    "startTransition" in React ? React["startTransition"](() => setState()) : setState()

  Moving it to a constant such as the following solves the Webpack/React 17 issue:
  * import * as React from from "react";
    const START_TRANSITION = "startTransition";
    START_TRANSITION in React ? React[START_TRANSITION](() => setState()) : setState()

  However, that introduces webpack/terser minification issues in production builds
  in React 18 where minification/obfuscation ends up removing the call of
  React.startTransition entirely from the first half of the ternary.  Grabbing
  this exported reference once up front resolves that issue.

  See https://github.com/remix-run/react-router/issues/10579
*/
const START_TRANSITION = "startTransition";
const startTransitionImpl = react__WEBPACK_IMPORTED_MODULE_0__[START_TRANSITION];

/**
 * Given a Remix Router instance, render the appropriate UI
 */
function RouterProvider(_ref) {
  let {
    fallbackElement,
    router,
    future
  } = _ref;
  let [state, setStateImpl] = react__WEBPACK_IMPORTED_MODULE_0__.useState(router.state);
  let {
    v7_startTransition
  } = future || {};
  let setState = react__WEBPACK_IMPORTED_MODULE_0__.useCallback(newState => {
    if (v7_startTransition && startTransitionImpl) {
      startTransitionImpl(() => setStateImpl(newState));
    } else {
      setStateImpl(newState);
    }
  }, [setStateImpl, v7_startTransition]);

  // Need to use a layout effect here so we are subscribed early enough to
  // pick up on any render-driven redirects/navigations (useEffect/<Navigate>)
  react__WEBPACK_IMPORTED_MODULE_0__.useLayoutEffect(() => router.subscribe(setState), [router, setState]);
  react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
     true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_warning)(fallbackElement == null || !router.future.v7_partialHydration, "`<RouterProvider fallbackElement>` is deprecated when using " + "`v7_partialHydration`, use a `HydrateFallback` component instead") : 0;
    // Only log this once on initial mount
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  let navigator = react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => {
    return {
      createHref: router.createHref,
      encodeLocation: router.encodeLocation,
      go: n => router.navigate(n),
      push: (to, state, opts) => router.navigate(to, {
        state,
        preventScrollReset: opts == null ? void 0 : opts.preventScrollReset
      }),
      replace: (to, state, opts) => router.navigate(to, {
        replace: true,
        state,
        preventScrollReset: opts == null ? void 0 : opts.preventScrollReset
      })
    };
  }, [router]);
  let basename = router.basename || "/";
  let dataRouterContext = react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => ({
    router,
    navigator,
    static: false,
    basename
  }), [router, navigator, basename]);

  // The fragment and {null} here are important!  We need them to keep React 18's
  // useId happy when we are server-rendering since we may have a <script> here
  // containing the hydrated server-side staticContext (from StaticRouterProvider).
  // useId relies on the component tree structure to generate deterministic id's
  // so we need to ensure it remains the same on the client even though
  // we don't need the <script> tag
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(DataRouterContext.Provider, {
    value: dataRouterContext
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(DataRouterStateContext.Provider, {
    value: state
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(Router, {
    basename: basename,
    location: state.location,
    navigationType: state.historyAction,
    navigator: navigator,
    future: {
      v7_relativeSplatPath: router.future.v7_relativeSplatPath
    }
  }, state.initialized || router.future.v7_partialHydration ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(DataRoutes, {
    routes: router.routes,
    future: router.future,
    state: state
  }) : fallbackElement))), null);
}
function DataRoutes(_ref2) {
  let {
    routes,
    future,
    state
  } = _ref2;
  return useRoutesImpl(routes, undefined, state, future);
}
/**
 * A `<Router>` that stores all entries in memory.
 *
 * @see https://reactrouter.com/router-components/memory-router
 */
function MemoryRouter(_ref3) {
  let {
    basename,
    children,
    initialEntries,
    initialIndex,
    future
  } = _ref3;
  let historyRef = react__WEBPACK_IMPORTED_MODULE_0__.useRef();
  if (historyRef.current == null) {
    historyRef.current = (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.createMemoryHistory)({
      initialEntries,
      initialIndex,
      v5Compat: true
    });
  }
  let history = historyRef.current;
  let [state, setStateImpl] = react__WEBPACK_IMPORTED_MODULE_0__.useState({
    action: history.action,
    location: history.location
  });
  let {
    v7_startTransition
  } = future || {};
  let setState = react__WEBPACK_IMPORTED_MODULE_0__.useCallback(newState => {
    v7_startTransition && startTransitionImpl ? startTransitionImpl(() => setStateImpl(newState)) : setStateImpl(newState);
  }, [setStateImpl, v7_startTransition]);
  react__WEBPACK_IMPORTED_MODULE_0__.useLayoutEffect(() => history.listen(setState), [history, setState]);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(Router, {
    basename: basename,
    children: children,
    location: state.location,
    navigationType: state.action,
    navigator: history,
    future: future
  });
}
/**
 * Changes the current location.
 *
 * Note: This API is mostly useful in React.Component subclasses that are not
 * able to use hooks. In functional components, we recommend you use the
 * `useNavigate` hook instead.
 *
 * @see https://reactrouter.com/components/navigate
 */
function Navigate(_ref4) {
  let {
    to,
    replace,
    state,
    relative
  } = _ref4;
  !useInRouterContext() ?  true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_invariant)(false, // TODO: This error is probably because they somehow have 2 versions of
  // the router loaded. We can help them understand how to avoid that.
  "<Navigate> may be used only in the context of a <Router> component.") : 0 : void 0;
  let {
    future,
    static: isStatic
  } = react__WEBPACK_IMPORTED_MODULE_0__.useContext(NavigationContext);
   true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_warning)(!isStatic, "<Navigate> must not be used on the initial render in a <StaticRouter>. " + "This is a no-op, but you should modify your code so the <Navigate> is " + "only ever rendered in response to some user interaction or state change.") : 0;
  let {
    matches
  } = react__WEBPACK_IMPORTED_MODULE_0__.useContext(RouteContext);
  let {
    pathname: locationPathname
  } = useLocation();
  let navigate = useNavigate();

  // Resolve the path outside of the effect so that when effects run twice in
  // StrictMode they navigate to the same place
  let path = (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.resolveTo)(to, (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_getResolveToMatches)(matches, future.v7_relativeSplatPath), locationPathname, relative === "path");
  let jsonPath = JSON.stringify(path);
  react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => navigate(JSON.parse(jsonPath), {
    replace,
    state,
    relative
  }), [navigate, jsonPath, relative, replace, state]);
  return null;
}
/**
 * Renders the child route's element, if there is one.
 *
 * @see https://reactrouter.com/components/outlet
 */
function Outlet(props) {
  return useOutlet(props.context);
}
/**
 * Declares an element that should be rendered at a certain URL path.
 *
 * @see https://reactrouter.com/components/route
 */
function Route(_props) {
   true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_invariant)(false, "A <Route> is only ever to be used as the child of <Routes> element, " + "never rendered directly. Please wrap your <Route> in a <Routes>.") : 0 ;
}
/**
 * Provides location context for the rest of the app.
 *
 * Note: You usually won't render a `<Router>` directly. Instead, you'll render a
 * router that is more specific to your environment such as a `<BrowserRouter>`
 * in web browsers or a `<StaticRouter>` for server rendering.
 *
 * @see https://reactrouter.com/router-components/router
 */
function Router(_ref5) {
  let {
    basename: basenameProp = "/",
    children = null,
    location: locationProp,
    navigationType = _remix_run_router__WEBPACK_IMPORTED_MODULE_1__.Action.Pop,
    navigator,
    static: staticProp = false,
    future
  } = _ref5;
  !!useInRouterContext() ?  true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_invariant)(false, "You cannot render a <Router> inside another <Router>." + " You should never have more than one in your app.") : 0 : void 0;

  // Preserve trailing slashes on basename, so we can let the user control
  // the enforcement of trailing slashes throughout the app
  let basename = basenameProp.replace(/^\/*/, "/");
  let navigationContext = react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => ({
    basename,
    navigator,
    static: staticProp,
    future: _extends({
      v7_relativeSplatPath: false
    }, future)
  }), [basename, future, navigator, staticProp]);
  if (typeof locationProp === "string") {
    locationProp = (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.parsePath)(locationProp);
  }
  let {
    pathname = "/",
    search = "",
    hash = "",
    state = null,
    key = "default"
  } = locationProp;
  let locationContext = react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => {
    let trailingPathname = (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.stripBasename)(pathname, basename);
    if (trailingPathname == null) {
      return null;
    }
    return {
      location: {
        pathname: trailingPathname,
        search,
        hash,
        state,
        key
      },
      navigationType
    };
  }, [basename, pathname, search, hash, state, key, navigationType]);
   true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_warning)(locationContext != null, "<Router basename=\"" + basename + "\"> is not able to match the URL " + ("\"" + pathname + search + hash + "\" because it does not start with the ") + "basename, so the <Router> won't render anything.") : 0;
  if (locationContext == null) {
    return null;
  }
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(NavigationContext.Provider, {
    value: navigationContext
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(LocationContext.Provider, {
    children: children,
    value: locationContext
  }));
}
/**
 * A container for a nested tree of `<Route>` elements that renders the branch
 * that best matches the current location.
 *
 * @see https://reactrouter.com/components/routes
 */
function Routes(_ref6) {
  let {
    children,
    location
  } = _ref6;
  return useRoutes(createRoutesFromChildren(children), location);
}
/**
 * Component to use for rendering lazily loaded data from returning defer()
 * in a loader function
 */
function Await(_ref7) {
  let {
    children,
    errorElement,
    resolve
  } = _ref7;
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(AwaitErrorBoundary, {
    resolve: resolve,
    errorElement: errorElement
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(ResolveAwait, null, children));
}
var AwaitRenderStatus = /*#__PURE__*/function (AwaitRenderStatus) {
  AwaitRenderStatus[AwaitRenderStatus["pending"] = 0] = "pending";
  AwaitRenderStatus[AwaitRenderStatus["success"] = 1] = "success";
  AwaitRenderStatus[AwaitRenderStatus["error"] = 2] = "error";
  return AwaitRenderStatus;
}(AwaitRenderStatus || {});
const neverSettledPromise = new Promise(() => {});
class AwaitErrorBoundary extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
  constructor(props) {
    super(props);
    this.state = {
      error: null
    };
  }
  static getDerivedStateFromError(error) {
    return {
      error
    };
  }
  componentDidCatch(error, errorInfo) {
    console.error("<Await> caught the following error during render", error, errorInfo);
  }
  render() {
    let {
      children,
      errorElement,
      resolve
    } = this.props;
    let promise = null;
    let status = AwaitRenderStatus.pending;
    if (!(resolve instanceof Promise)) {
      // Didn't get a promise - provide as a resolved promise
      status = AwaitRenderStatus.success;
      promise = Promise.resolve();
      Object.defineProperty(promise, "_tracked", {
        get: () => true
      });
      Object.defineProperty(promise, "_data", {
        get: () => resolve
      });
    } else if (this.state.error) {
      // Caught a render error, provide it as a rejected promise
      status = AwaitRenderStatus.error;
      let renderError = this.state.error;
      promise = Promise.reject().catch(() => {}); // Avoid unhandled rejection warnings
      Object.defineProperty(promise, "_tracked", {
        get: () => true
      });
      Object.defineProperty(promise, "_error", {
        get: () => renderError
      });
    } else if (resolve._tracked) {
      // Already tracked promise - check contents
      promise = resolve;
      status = "_error" in promise ? AwaitRenderStatus.error : "_data" in promise ? AwaitRenderStatus.success : AwaitRenderStatus.pending;
    } else {
      // Raw (untracked) promise - track it
      status = AwaitRenderStatus.pending;
      Object.defineProperty(resolve, "_tracked", {
        get: () => true
      });
      promise = resolve.then(data => Object.defineProperty(resolve, "_data", {
        get: () => data
      }), error => Object.defineProperty(resolve, "_error", {
        get: () => error
      }));
    }
    if (status === AwaitRenderStatus.error && promise._error instanceof _remix_run_router__WEBPACK_IMPORTED_MODULE_1__.AbortedDeferredError) {
      // Freeze the UI by throwing a never resolved promise
      throw neverSettledPromise;
    }
    if (status === AwaitRenderStatus.error && !errorElement) {
      // No errorElement, throw to the nearest route-level error boundary
      throw promise._error;
    }
    if (status === AwaitRenderStatus.error) {
      // Render via our errorElement
      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(AwaitContext.Provider, {
        value: promise,
        children: errorElement
      });
    }
    if (status === AwaitRenderStatus.success) {
      // Render children with resolved value
      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(AwaitContext.Provider, {
        value: promise,
        children: children
      });
    }

    // Throw to the suspense boundary
    throw promise;
  }
}

/**
 * @private
 * Indirection to leverage useAsyncValue for a render-prop API on `<Await>`
 */
function ResolveAwait(_ref8) {
  let {
    children
  } = _ref8;
  let data = useAsyncValue();
  let toRender = typeof children === "function" ? children(data) : children;
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, toRender);
}

///////////////////////////////////////////////////////////////////////////////
// UTILS
///////////////////////////////////////////////////////////////////////////////

/**
 * Creates a route config from a React "children" object, which is usually
 * either a `<Route>` element or an array of them. Used internally by
 * `<Routes>` to create a route config from its children.
 *
 * @see https://reactrouter.com/utils/create-routes-from-children
 */
function createRoutesFromChildren(children, parentPath) {
  if (parentPath === void 0) {
    parentPath = [];
  }
  let routes = [];
  react__WEBPACK_IMPORTED_MODULE_0__.Children.forEach(children, (element, index) => {
    if (! /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.isValidElement(element)) {
      // Ignore non-elements. This allows people to more easily inline
      // conditionals in their route config.
      return;
    }
    let treePath = [...parentPath, index];
    if (element.type === react__WEBPACK_IMPORTED_MODULE_0__.Fragment) {
      // Transparently support React.Fragment and its children.
      routes.push.apply(routes, createRoutesFromChildren(element.props.children, treePath));
      return;
    }
    !(element.type === Route) ?  true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_invariant)(false, "[" + (typeof element.type === "string" ? element.type : element.type.name) + "] is not a <Route> component. All component children of <Routes> must be a <Route> or <React.Fragment>") : 0 : void 0;
    !(!element.props.index || !element.props.children) ?  true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_invariant)(false, "An index route cannot have child routes.") : 0 : void 0;
    let route = {
      id: element.props.id || treePath.join("-"),
      caseSensitive: element.props.caseSensitive,
      element: element.props.element,
      Component: element.props.Component,
      index: element.props.index,
      path: element.props.path,
      loader: element.props.loader,
      action: element.props.action,
      errorElement: element.props.errorElement,
      ErrorBoundary: element.props.ErrorBoundary,
      hasErrorBoundary: element.props.ErrorBoundary != null || element.props.errorElement != null,
      shouldRevalidate: element.props.shouldRevalidate,
      handle: element.props.handle,
      lazy: element.props.lazy
    };
    if (element.props.children) {
      route.children = createRoutesFromChildren(element.props.children, treePath);
    }
    routes.push(route);
  });
  return routes;
}

/**
 * Renders the result of `matchRoutes()` into a React element.
 */
function renderMatches(matches) {
  return _renderMatches(matches);
}

function mapRouteProperties(route) {
  let updates = {
    // Note: this check also occurs in createRoutesFromChildren so update
    // there if you change this -- please and thank you!
    hasErrorBoundary: route.ErrorBoundary != null || route.errorElement != null
  };
  if (route.Component) {
    if (true) {
      if (route.element) {
         true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_warning)(false, "You should not include both `Component` and `element` on your route - " + "`Component` will be used.") : 0;
      }
    }
    Object.assign(updates, {
      element: /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(route.Component),
      Component: undefined
    });
  }
  if (route.HydrateFallback) {
    if (true) {
      if (route.hydrateFallbackElement) {
         true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_warning)(false, "You should not include both `HydrateFallback` and `hydrateFallbackElement` on your route - " + "`HydrateFallback` will be used.") : 0;
      }
    }
    Object.assign(updates, {
      hydrateFallbackElement: /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(route.HydrateFallback),
      HydrateFallback: undefined
    });
  }
  if (route.ErrorBoundary) {
    if (true) {
      if (route.errorElement) {
         true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_warning)(false, "You should not include both `ErrorBoundary` and `errorElement` on your route - " + "`ErrorBoundary` will be used.") : 0;
      }
    }
    Object.assign(updates, {
      errorElement: /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(route.ErrorBoundary),
      ErrorBoundary: undefined
    });
  }
  return updates;
}
function createMemoryRouter(routes, opts) {
  return (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.createRouter)({
    basename: opts == null ? void 0 : opts.basename,
    future: _extends({}, opts == null ? void 0 : opts.future, {
      v7_prependBasename: true
    }),
    history: (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.createMemoryHistory)({
      initialEntries: opts == null ? void 0 : opts.initialEntries,
      initialIndex: opts == null ? void 0 : opts.initialIndex
    }),
    hydrationData: opts == null ? void 0 : opts.hydrationData,
    routes,
    mapRouteProperties,
    unstable_dataStrategy: opts == null ? void 0 : opts.unstable_dataStrategy,
    unstable_patchRoutesOnMiss: opts == null ? void 0 : opts.unstable_patchRoutesOnMiss
  }).initialize();
}


//# sourceMappingURL=index.js.map


/***/ }),

/***/ "./src/dashboard/assets/img/Blossom Floral About.png":
/*!***********************************************************!*\
  !*** ./src/dashboard/assets/img/Blossom Floral About.png ***!
  \***********************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

module.exports = __webpack_require__.p + "images/Blossom Floral About.c0a7ad71.png";

/***/ }),

/***/ "./src/dashboard/assets/img/Blossom Floral Fashion.png":
/*!*************************************************************!*\
  !*** ./src/dashboard/assets/img/Blossom Floral Fashion.png ***!
  \*************************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

module.exports = __webpack_require__.p + "images/Blossom Floral Fashion.9738a2e2.png";

/***/ }),

/***/ "./src/dashboard/assets/img/Blossom Floral Home.png":
/*!**********************************************************!*\
  !*** ./src/dashboard/assets/img/Blossom Floral Home.png ***!
  \**********************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

module.exports = __webpack_require__.p + "images/Blossom Floral Home.d198c3bc.png";

/***/ }),

/***/ "./src/dashboard/assets/img/GDPR.jpg":
/*!*******************************************!*\
  !*** ./src/dashboard/assets/img/GDPR.jpg ***!
  \*******************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

module.exports = __webpack_require__.p + "images/GDPR.fa380937.jpg";

/***/ }),

/***/ "./src/dashboard/assets/img/SEO.jpg":
/*!******************************************!*\
  !*** ./src/dashboard/assets/img/SEO.jpg ***!
  \******************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

module.exports = __webpack_require__.p + "images/SEO.207b545e.jpg";

/***/ }),

/***/ "./src/dashboard/assets/img/customFonts.jpg":
/*!**************************************************!*\
  !*** ./src/dashboard/assets/img/customFonts.jpg ***!
  \**************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

module.exports = __webpack_require__.p + "images/customFonts.d533276c.jpg";

/***/ }),

/***/ "./src/dashboard/assets/img/freevspro.webp":
/*!*************************************************!*\
  !*** ./src/dashboard/assets/img/freevspro.webp ***!
  \*************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

module.exports = __webpack_require__.p + "images/freevspro.e2a29c71.webp";

/***/ }),

/***/ "./src/dashboard/assets/img/logo.png":
/*!*******************************************!*\
  !*** ./src/dashboard/assets/img/logo.png ***!
  \*******************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

module.exports = __webpack_require__.p + "images/logo.f9095132.png";

/***/ }),

/***/ "./src/dashboard/assets/img/pluginsSetup.jpg":
/*!***************************************************!*\
  !*** ./src/dashboard/assets/img/pluginsSetup.jpg ***!
  \***************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

module.exports = __webpack_require__.p + "images/pluginsSetup.80801bfc.jpg";

/***/ }),

/***/ "./src/dashboard/assets/img/salesFunnel.jpg":
/*!**************************************************!*\
  !*** ./src/dashboard/assets/img/salesFunnel.jpg ***!
  \**************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

module.exports = __webpack_require__.p + "images/salesFunnel.8041c135.jpg";

/***/ }),

/***/ "./src/dashboard/assets/img/themeClub.jpg":
/*!************************************************!*\
  !*** ./src/dashboard/assets/img/themeClub.jpg ***!
  \************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

module.exports = __webpack_require__.p + "images/themeClub.9bc864a9.jpg";

/***/ }),

/***/ "./src/dashboard/assets/img/themeInstallation.jpg":
/*!********************************************************!*\
  !*** ./src/dashboard/assets/img/themeInstallation.jpg ***!
  \********************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

module.exports = __webpack_require__.p + "images/themeInstallation.1e7ee4c3.jpg";

/***/ }),

/***/ "./src/dashboard/assets/img/vipSiteCare.jpg":
/*!**************************************************!*\
  !*** ./src/dashboard/assets/img/vipSiteCare.jpg ***!
  \**************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

module.exports = __webpack_require__.p + "images/vipSiteCare.a1588249.jpg";

/***/ }),

/***/ "./src/dashboard/assets/img/vipSupport.jpg":
/*!*************************************************!*\
  !*** ./src/dashboard/assets/img/vipSupport.jpg ***!
  \*************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

module.exports = __webpack_require__.p + "images/vipSupport.840a717c.jpg";

/***/ }),

/***/ "react":
/*!************************!*\
  !*** external "React" ***!
  \************************/
/***/ (function(module) {

module.exports = window["React"];

/***/ }),

/***/ "react-dom":
/*!***************************!*\
  !*** external "ReactDOM" ***!
  \***************************/
/***/ (function(module) {

module.exports = window["ReactDOM"];

/***/ }),

/***/ "@wordpress/dom-ready":
/*!**********************************!*\
  !*** external ["wp","domReady"] ***!
  \**********************************/
/***/ (function(module) {

module.exports = window["wp"]["domReady"];

/***/ }),

/***/ "@wordpress/element":
/*!*********************************!*\
  !*** external ["wp","element"] ***!
  \*********************************/
/***/ (function(module) {

module.exports = window["wp"]["element"];

/***/ }),

/***/ "@wordpress/i18n":
/*!******************************!*\
  !*** external ["wp","i18n"] ***!
  \******************************/
/***/ (function(module) {

module.exports = window["wp"]["i18n"];

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/compat get default export */
/******/ 	!function() {
/******/ 		// getDefaultExport function for compatibility with non-harmony modules
/******/ 		__webpack_require__.n = function(module) {
/******/ 			var getter = module && module.__esModule ?
/******/ 				function() { return module['default']; } :
/******/ 				function() { return module; };
/******/ 			__webpack_require__.d(getter, { a: getter });
/******/ 			return getter;
/******/ 		};
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/define property getters */
/******/ 	!function() {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = function(exports, definition) {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/global */
/******/ 	!function() {
/******/ 		__webpack_require__.g = (function() {
/******/ 			if (typeof globalThis === 'object') return globalThis;
/******/ 			try {
/******/ 				return this || new Function('return this')();
/******/ 			} catch (e) {
/******/ 				if (typeof window === 'object') return window;
/******/ 			}
/******/ 		})();
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	!function() {
/******/ 		__webpack_require__.o = function(obj, prop) { return Object.prototype.hasOwnProperty.call(obj, prop); }
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	!function() {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = function(exports) {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/publicPath */
/******/ 	!function() {
/******/ 		var scriptUrl;
/******/ 		if (__webpack_require__.g.importScripts) scriptUrl = __webpack_require__.g.location + "";
/******/ 		var document = __webpack_require__.g.document;
/******/ 		if (!scriptUrl && document) {
/******/ 			if (document.currentScript)
/******/ 				scriptUrl = document.currentScript.src;
/******/ 			if (!scriptUrl) {
/******/ 				var scripts = document.getElementsByTagName("script");
/******/ 				if(scripts.length) {
/******/ 					var i = scripts.length - 1;
/******/ 					while (i > -1 && (!scriptUrl || !/^http(s?):/.test(scriptUrl))) scriptUrl = scripts[i--].src;
/******/ 				}
/******/ 			}
/******/ 		}
/******/ 		// When supporting browsers where an automatic publicPath is not supported you must specify an output.publicPath manually via configuration
/******/ 		// or pass an empty string ("") and set the __webpack_public_path__ variable from your code to use your own logic.
/******/ 		if (!scriptUrl) throw new Error("Automatic publicPath is not supported in this browser");
/******/ 		scriptUrl = scriptUrl.replace(/#.*$/, "").replace(/\?.*$/, "").replace(/\/[^\/]+$/, "/");
/******/ 		__webpack_require__.p = scriptUrl;
/******/ 	}();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
/*!********************************!*\
  !*** ./src/dashboard/index.js ***!
  \********************************/
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_dom_ready__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/dom-ready */ "@wordpress/dom-ready");
/* harmony import */ var _wordpress_dom_ready__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_dom_ready__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_router_dom__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react-router-dom */ "./node_modules/react-router-dom/dist/index.js");
/* harmony import */ var _pages__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./pages */ "./src/dashboard/pages/index.js");
/* harmony import */ var _scss_style_scss__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./scss/style.scss */ "./src/dashboard/scss/style.scss");






_wordpress_dom_ready__WEBPACK_IMPORTED_MODULE_1___default()(() => {
  const root = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.createRoot)(document.getElementById('cw-dashboard'));
  root.render((0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react_router_dom__WEBPACK_IMPORTED_MODULE_5__.BrowserRouter, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_pages__WEBPACK_IMPORTED_MODULE_3__["default"], null))));
});
/******/ })()
;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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