<?php
/**
 * The Template Name: Home Page
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site will use a
 * different template.
 *
 * @package Blood Donation Campaign
 */

get_header(); ?>

<div id="content" >
    
    <?php
        $blood_donation_campaign_hidepageboxes = get_theme_mod('blood_donation_campaign_slider', false);
        $blood_donation_campaign_catData = get_theme_mod('blood_donation_campaign_slider_cat');
        if ($blood_donation_campaign_hidepageboxes && $blood_donation_campaign_catData) { ?>
        <section id="slider-cat" class="position-relative">
            <div class="owl-carousel m-0">
                <?php
                    $blood_donation_campaign_page_query = new WP_Query(
                        array(
                            'category_name' => esc_attr($blood_donation_campaign_catData),
                        )
                    );
                    while ($blood_donation_campaign_page_query->have_posts()) : $blood_donation_campaign_page_query->the_post(); ?>
                        <div class="slider-content position-relative">
                            <div class="container">
                                <div class="text-content text-lg-start text-md-start text-center wow zoomInLeft" data-wow-delay=".25s">
                                    <h1 class="slider-title text-capitalize mb-3"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h1>
                                    <p class="slider-excerpt mb-4"><?php echo esc_html(get_the_excerpt()); ?></p>
                                    <div class="sliderbtn">
                                        <?php 
                                            $blood_donation_campaign_button_text = get_theme_mod('blood_donation_campaign_button_text', 'Donate Now');
                                            $blood_donation_campaign_button_link_slider = get_theme_mod('blood_donation_campaign_button_link_slider', ''); 
                                            if (empty($blood_donation_campaign_button_link_slider)) {
                                                $blood_donation_campaign_button_link_slider = esc_url(get_permalink());
                                            }
                                            if ($blood_donation_campaign_button_text || !empty($blood_donation_campaign_button_link_slider)) { ?>
                                            <?php if(get_theme_mod('blood_donation_campaign_button_text', 'Donate Now') != ''){ ?>
                                                <a href="<?php echo esc_url($blood_donation_campaign_button_link_slider); ?>" class="post-btn text-capitalize">
                                                    <span class="button-text position-relative"><?php echo esc_html($blood_donation_campaign_button_text); ?></span>
                                                    <span class="screen-reader-text"><?php echo esc_html($blood_donation_campaign_button_text); ?></span><i class="fa-solid fa-arrow-right ms-1"></i>
                                                </a>
                                            <?php } ?>
                                        <?php } ?>
                                    </div>
                                </div>
                            </div>
                            <div class="slider-img position-absolute wow zoomIn" data-wow-delay=".25s">
                                <?php if(has_post_thumbnail()){
                                    the_post_thumbnail('full', array('class' => 'post-image'));
                                } else { ?>
                                    <img src="<?php echo esc_url(get_template_directory_uri()); ?>/images/post-img.png" alt="<?php echo esc_attr( 'slider', 'blood-donation-campaign'); ?>"/>
                                <?php } ?>
                            </div>   
                        </div>
                    <?php endwhile;
                    wp_reset_postdata();
                ?>
            </div>
            <img src="<?php echo esc_url(get_template_directory_uri()); ?>/images/slider-design.png" class="slider-left-img position-absolute" alt="<?php echo esc_attr('Image', 'blood-donation-campaign'); ?>"/>

        </section>
    <?php } ?>

    <!-- Offer Section -->
    <?php
        $blood_donation_campaign_hide_camp_section = get_theme_mod('blood_donation_campaign_disabled_camp_section', false);
        if ($blood_donation_campaign_hide_camp_section){ ?>
        <section id="camp-section" class="py-5 mb-5">
            <div class="container">
                <div class="row mb-4 wow fadeInDown" data-wow-delay=".4s">
                    <div class="col-xxl-9 col-xl-8 col-lg-7 col-md-7 col-12 align-self-center">
                        <div class="blog-bx text-lg-start text-md-start text-center">
                            <?php if (get_theme_mod('blood_donation_campaign_camp_title') != "") { ?>
                                <h2 class="camp-title text-capitalize d-inline position-relative"><?php echo esc_html(get_theme_mod('blood_donation_campaign_camp_title')); ?></h2>
                            <?php } ?>
                            <?php if (get_theme_mod('blood_donation_campaign_camp_text') != "") { ?>
                                <p class="camp-text mt-2 mb-0"><?php echo esc_html(get_theme_mod('blood_donation_campaign_camp_text')); ?></p>
                            <?php }?>
                        </div> 
                    </div>
                    <div class="col-xxl-3 col-xl-4 col-lg-5 col-md-5 col-12 align-self-center text-lg-end text-md-end text-center camp-btn">
                        <?php if ( get_theme_mod('blood_donation_campaign_donation_camp_btn_text') || get_theme_mod('blood_donation_campaign_donation_camp_btn_url')) { ?>  
                            <a href="<?php echo esc_url(get_theme_mod ('blood_donation_campaign_donation_camp_btn_url')); ?>" class="text-capitalize position-relative"><span class="camp-btn-text"><?php echo esc_html(get_theme_mod ('blood_donation_campaign_donation_camp_btn_text')); ?></span><i class="fa-solid fa-arrow-right ms-1"></i></a>
                        <?php }?>
                    </div>
                </div>
                <div class="owl-carousel m-0 wow zoomIn" data-wow-delay=".25s">
                    <?php
                        for ($blood_donation_campaign_i=1; $blood_donation_campaign_i <= 6; $blood_donation_campaign_i++) { 

                        $blood_donation_campaign_camp_location_text = get_theme_mod('blood_donation_campaign_location_text'.$blood_donation_campaign_i);
                        $blood_donation_campaign_camp_date_text = get_theme_mod('blood_donation_campaign_add_date_text'.$blood_donation_campaign_i);
                        $blood_donation_campaign_camp_time = get_theme_mod('blood_donation_campaign_add_time_text'.$blood_donation_campaign_i);
                        $blood_donation_campaign_postData=  get_theme_mod('blood_donation_campaign_select_post'.$blood_donation_campaign_i);
                        if($blood_donation_campaign_postData){ ?>
                        <?php
                            $blood_donation_campaign_args = array(
                                'p' => esc_html($blood_donation_campaign_postData ,'blood-donation-campaign'),
                                'posts_per_page' => 6,
                                'post_type' => 'post'
                            );
                            $blood_donation_campaign_query = new WP_Query( $blood_donation_campaign_args );
                            if ( $blood_donation_campaign_query->have_posts() ) :
                            while ( $blood_donation_campaign_query->have_posts() ) : $blood_donation_campaign_query->the_post(); ?>
                                <div class="camp-box position-relative">
                                    <div class="camp-img m-0">
                                        <?php if(has_post_thumbnail()){
                                            the_post_thumbnail('full');
                                            } else{?>
                                            <img src="<?php echo esc_url(get_template_directory_uri()); ?>/images/post-img.png" alt="<?php echo esc_attr( 'post-image', 'blood-donation-campaign'); ?>"/>
                                        <?php } ?>
                                    </div>
                                    <div class="camp-details position-absolute">
                                        <div class="camp-inner-details px-4 py-1 position-relative">
                                            <h5 class="post-head text-capitalize mb-3 mt-2"><a href="<?php the_permalink(); ?>" rel="bookmark"><?php the_title(); ?></a></h5>    
                                            <?php if ($blood_donation_campaign_camp_location_text){ ?>
                                                <p class="camp-location text-capitalize mb-2"><i class="fa-solid fa-location-dot me-2"></i><?php echo esc_html($blood_donation_campaign_camp_location_text); ?></p>
                                            <?php }?>

                                            <?php if ($blood_donation_campaign_camp_date_text){ ?>
                                                <p class="camp-text text-capitalize mb-2"><i class="fa-solid fa-calendar-days me-2"></i><?php echo esc_html($blood_donation_campaign_camp_date_text); ?></p>
                                            <?php }?>

                                            <?php if ($blood_donation_campaign_camp_time){ ?>
                                                <p class="camp-text text-capitalize mb-2"><i class="fa-solid fa-clock me-2"></i><?php echo esc_html($blood_donation_campaign_camp_time); ?></p>
                                            <?php }?>
                                        </div> 
                                    </div>
                                </div>
                        <?php endwhile;
                        wp_reset_postdata();
                        endif; ?>
                    <?php }}?>
                </div>
            </div>
        </section>
    <?php } ?>
</div>
<?php get_footer(); ?>