<?php
/**
 * @package Blood Donation Campaign
 */
?>

<?php
    $blood_donation_campaign_post_date = esc_html(get_the_date());
    
    $blood_donation_campaign_author_name = esc_html(get_the_author());

    $blood_donation_campaign_single_post_show_date     = get_theme_mod('blood_donation_campaign_single_post_date', true);
    $blood_donation_campaign_single_post_show_comments = get_theme_mod('blood_donation_campaign_single_post_comment', true);
    $blood_donation_campaign_single_post_show_author   = get_theme_mod('blood_donation_campaign_single_post_author', true);
    $blood_donation_campaign_single_post_show_time     = get_theme_mod('blood_donation_campaign_single_post_time', true);

    $blood_donation_campaign_post_id = get_the_ID();
    $blood_donation_campaign_camp_location_text = '';
    $blood_donation_campaign_camp_date_text = '';
    $blood_donation_campaign_camp_time = '';

    for ($blood_donation_campaign_i=1; $blood_donation_campaign_i <= 6; $blood_donation_campaign_i++) {
        $blood_donation_campaign_postData = get_theme_mod('blood_donation_campaign_select_post'.$blood_donation_campaign_i);
        if ( intval( $blood_donation_campaign_postData ) === $blood_donation_campaign_post_id ) {
            $blood_donation_campaign_camp_location_text = get_theme_mod('blood_donation_campaign_location_text'.$blood_donation_campaign_i);
            $blood_donation_campaign_camp_date_text = get_theme_mod('blood_donation_campaign_add_date_text'.$blood_donation_campaign_i);
            $blood_donation_campaign_camp_time = get_theme_mod('blood_donation_campaign_add_time_text'.$blood_donation_campaign_i);
        }
    }
?>

<article class="wow zoomIn" data-wow-duration="2s" id="post-<?php the_ID(); ?>" <?php post_class('single-post'); ?>>
    
    <?php 
    $blood_donation_campaign_designation = get_post_meta($post->ID, 'blood_donation_campaign_designation', true);
    
    if ($blood_donation_campaign_designation) : ?>
        <p class="serv-content"><?php echo esc_html($blood_donation_campaign_designation); ?></p>
    <?php endif; ?>
    <?php if (has_post_thumbnail() ){ ?>
        <div class="post-thumb">
           <?php the_post_thumbnail(); ?>
        </div>
    <?php } ?>
    <?php if ('post' == get_post_type()) : ?>
        <?php if ( $blood_donation_campaign_single_post_show_date || $blood_donation_campaign_single_post_show_comments || $blood_donation_campaign_single_post_show_author || $blood_donation_campaign_single_post_show_time ) : ?>
            <div class="postmeta">
                <?php if ($blood_donation_campaign_single_post_show_date) : ?>
                <div class="post-date">
                    <i class="fas fa-calendar-alt"></i> &nbsp;<?php echo esc_html($blood_donation_campaign_post_date); ?>
                </div>
                <?php endif; ?>
                <?php if ($blood_donation_campaign_single_post_show_comments) : ?>
                <div class="post-comment">&nbsp;
                    <span><?php echo esc_html(get_theme_mod('blood_donation_campaign_single_post_metabox_seperator', '|'));?></span>
                    <i class="fa fa-comment"></i> &nbsp; <?php comments_number(); ?>
                </div>
                <?php endif; ?>
                <?php if ($blood_donation_campaign_single_post_show_author) : ?>
                    <div class="post-author">&nbsp;
                        <span><?php echo esc_html(get_theme_mod('blood_donation_campaign_single_post_metabox_seperator', '|'));?></span>
                        <i class="fas fa-user"></i> &nbsp; <?php echo esc_html($blood_donation_campaign_author_name); ?>
                    </div>
                <?php endif; ?>
                <?php if ($blood_donation_campaign_single_post_show_time) : ?>
                    <div class="post-time">&nbsp;
                        <span><?php echo esc_html(get_theme_mod('blood_donation_campaign_single_post_metabox_seperator', '|'));?></span>
                        <i class="fas fa-clock"></i> &nbsp; <?php echo get_the_time(); ?>
                    </div>
                <?php endif; ?>
            </div> 
        <?php endif; ?>
    <?php endif; ?>
    <div class="entry-content">
        <?php the_content(); ?>
        <?php
            wp_link_pages( array(
                'before' => '<div class="page-links">' . __( 'Pages:', 'blood-donation-campaign' ),
                'after'  => '</div>',
            ) );
        ?>
        <div class="tags"><?php the_tags(); ?></div>
    </div>
    <?php if ($blood_donation_campaign_camp_location_text || $blood_donation_campaign_camp_date_text || $blood_donation_campaign_camp_time){ ?>
        <div class="camp-details py-2 px-3 my-3">
            <p class="camp-text my-2"><i class="fa-solid fa-location-dot me-2"></i><?php echo esc_html($blood_donation_campaign_camp_location_text); ?></p>
            <p class="camp-text my-2 text-capitalize"><i class="fa-solid fa-calendar-days me-2"></i><?php echo esc_html($blood_donation_campaign_camp_date_text); ?></p>
            <p class="camp-text my-2 text-capitalize"><i class="fa-solid fa-clock me-2"></i><?php echo esc_html($blood_donation_campaign_camp_time); ?></p>
        </div>
    <?php }?>
    <footer class="entry-meta">
        <?php edit_post_link( __( 'Edit', 'blood-donation-campaign' ), '<span class="edit-link">', '</span>' ); ?>
    </footer>
</article>