<?php
/**
 * The Sidebar containing the main widget areas.
 *
 * @package Blood Donation Campaign
 */
?>

<div id="sidebar" class="wow zoomInUp delay-1000" data-wow-duration="2s">    
    <?php if ( ! dynamic_sidebar( 'sidebar-1' ) ) : ?>
        <aside role="complementary" aria-label="<?php esc_attr_e('sidebar1', 'blood-donation-campaign'); ?>" id="search" class="widget">
            <h3 class="widget-title"><?php esc_html_e( 'Search', 'blood-donation-campaign' ); ?></h3>
            <?php get_search_form(); ?>
        </aside>
        <aside role="complementary" aria-label="<?php esc_attr_e('sidebar2', 'blood-donation-campaign'); ?>" id="archives" class="widget">
            <h3 class="widget-title"><?php esc_html_e( 'Archives', 'blood-donation-campaign' ); ?></h3>
            <ul>
                <?php wp_get_archives( array( 'type' => 'monthly' ) ); ?>
            </ul>
        </aside>
        <aside role="complementary" aria-label="<?php esc_attr_e('sidebar3', 'blood-donation-campaign'); ?>" id="categories" class="widget"> 
            <h3 class="widget-title"><?php esc_html_e( 'Categories', 'blood-donation-campaign' ); ?></h3>          
            <ul>
                <?php wp_list_categories('title_li=');  ?>
            </ul>
        </aside>
        <aside role="complementary" aria-label="<?php esc_attr_e('sidebar4', 'blood-donation-campaign'); ?>" id="meta" class="widget">
            <h3 class="widget-title"><?php esc_html_e( 'Meta', 'blood-donation-campaign' ); ?></h3>
            <ul>
                <?php wp_register(); ?>
                <li><?php wp_loginout(); ?></li>
                <?php wp_meta(); ?>
            </ul>
        </aside>
    <?php endif; // end sidebar widget area ?>  
</div>