<?php
/**
 * Upgrade to pro options
 */
function blood_donation_campaign_upgrade_pro_options( $wp_customize ) {

	$wp_customize->add_section(
		'upgrade_premium',
		array(
			'title'    => esc_html__( 'About Blood Donation Campaign', 'blood-donation-campaign' ),
			'priority' => 1,
		)
	);

	class Blood_Donation_Campaign_Pro_Button_Customize_Control extends WP_Customize_Control {
		public $type = 'upgrade_premium';

		function render_content() {
			?>
			<div class="pro_info">
				<ul>
					<li><a class="upgrade-to-pro pro-btn" href="<?php echo esc_url( BLOOD_DONATION_CAMPAIGN_PREMIUM_PAGE ); ?>" target="_blank"><i class="dashicons dashicons-cart"></i><?php esc_html_e( 'Upgrade Pro', 'blood-donation-campaign' ); ?> </a></li>

					<li><a class="upgrade-to-pro" href="<?php echo esc_url( BLOOD_DONATION_CAMPAIGN_PRO_DEMO ); ?>" target="_blank"><i class="dashicons dashicons-awards"></i><?php esc_html_e( 'Premium Demo', 'blood-donation-campaign' ); ?> </a></li>
					
					<li><a class="upgrade-to-pro" href="<?php echo esc_url( BLOOD_DONATION_CAMPAIGN_REVIEW ); ?>" target="_blank"><i class="dashicons dashicons-star-filled"></i><?php esc_html_e( 'Rate Us', 'blood-donation-campaign' ); ?> </a></li>
					
					<li><a class="upgrade-to-pro" href="<?php echo esc_url( BLOOD_DONATION_CAMPAIGN_SUPPORT ); ?>" target="_blank"><i class="dashicons dashicons-lightbulb"></i><?php esc_html_e( 'Support Forum', 'blood-donation-campaign' ); ?> </a></li>	
					
					<li><a class="upgrade-to-pro" href="<?php echo esc_url( BLOOD_DONATION_CAMPAIGN_THEME_PAGE ); ?>" target="_blank"><i class="dashicons dashicons-admin-appearance"></i><?php esc_html_e( 'Theme Page', 'blood-donation-campaign' ); ?> </a></li>
				
					<li><a class="upgrade-to-pro" href="<?php echo esc_url( BLOOD_DONATION_CAMPAIGN_THEME_DOCUMENTATION ); ?>" target="_blank"><i class="dashicons dashicons-visibility"></i><?php esc_html_e( 'Theme Documentation', 'blood-donation-campaign' ); ?> </a></li>
				</ul>
			</div>
			<?php
		}
	}

	$wp_customize->add_setting(
		'pro_info_buttons',
		array(
			'capability'        => 'edit_theme_options',
			'sanitize_callback' => 'blood_donation_campaign_sanitize_text',
		)
	);

	$wp_customize->add_control(
		new Blood_Donation_Campaign_Pro_Button_Customize_Control(
			$wp_customize,
			'pro_info_buttons',
			array(
				'section' => 'upgrade_premium',
			)
		)
	);
}
add_action( 'customize_register', 'blood_donation_campaign_upgrade_pro_options' );
