<div class="theme-offer">
   <?php
        // Check if the demo import has been completed
        $blood_donation_campaign_demo_import_completed = get_option('blood_donation_campaign_demo_import_completed', false);

        // If the demo import is completed, display the "View Site" button
        if ($blood_donation_campaign_demo_import_completed) {
            echo '<br>';
            echo '<div class="success">Demo Import Successful</div>';
            echo '<br>';
            echo '<hr>';
            echo '<br>';
            echo '<span>' . esc_html__( 'You can now visit your site or customize it further.', 'blood-donation-campaign' ) . '</span>';
            echo '<br>';
            echo '<br>';
            echo '<br>';
            echo '<div class="view-site-btn">';
            echo '<a href="' . esc_url(home_url()) . '" class="button button-primary button-large" style="margin-top: 10px;" target="_blank">View Site</a>';
            echo '<a href="' . esc_url( admin_url('customize.php') ) . '" class="button button-primary button-large" style="margin-top: 10px;" target="_blank">Customize Demo Content</a>';
            echo '</div>';
        }
    if ( isset( $_POST['submit'] ) ) {
        echo '<div class="plugin-notice">';
            // Check if Classic Blog Grid plugin is installed
            if (!is_plugin_active('classic-blog-grid/classic-blog-grid.php')) {
                // Plugin slug and file path for Classic Blog Grid
                $blood_donation_campaign_plugin_slug = 'classic-blog-grid';
                $blood_donation_campaign_plugin_file = 'classic-blog-grid/classic-blog-grid.php';
            
                // Check if Classic Blog Grid is installed and activated
                if ( ! is_plugin_active( $blood_donation_campaign_plugin_file ) ) {
            
                    // Check if Classic Blog Grid is installed
                    $blood_donation_campaign_installed_plugins = get_plugins();
                    if ( ! isset( $blood_donation_campaign_installed_plugins[ $blood_donation_campaign_plugin_file ] ) ) {
            
                        // Include necessary files to install plugins
                        include_once( ABSPATH . 'wp-admin/includes/plugin-install.php' );
                        include_once( ABSPATH . 'wp-admin/includes/file.php' );
                        include_once( ABSPATH . 'wp-admin/includes/misc.php' );
                        include_once( ABSPATH . 'wp-admin/includes/class-wp-upgrader.php' );
            
                        // Download and install Classic Blog Grid
                        $blood_donation_campaign_upgrader = new Plugin_Upgrader();
                        $blood_donation_campaign_upgrader->install( 'https://downloads.wordpress.org/plugin/classic-blog-grid.latest-stable.zip' );
                    }
            
                    // Activate the Classic Blog Grid plugin after installation (if needed)
                    activate_plugin( $blood_donation_campaign_plugin_file );
                }
            }
        echo '</div>';
        // ------- Create Main Menu --------
        $blood_donation_campaign_menuname = 'Primary Menu'; 
        $blood_donation_campaign_bpmenulocation = 'primary';
        $blood_donation_campaign_menu_exists = wp_get_nav_menu_object($blood_donation_campaign_menuname);

        if (!$blood_donation_campaign_menu_exists) {
            // Create a new menu
            $blood_donation_campaign_menu_id = wp_create_nav_menu($blood_donation_campaign_menuname);

            // Define pages to be created
            $blood_donation_campaign_pages = array(
                'home' => array(
                    'title' => 'Home',
                    'template' => '/templates/template-home-page.php'
                ),
                'about-us' => array(
                    'title' => 'About Us',
                    'content' => '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry standard dummy text ever since the 1500, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960 with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.</p>'
                ),
                'why-donate' => array(
                    'title' => 'Why Donate',
                    'content' => '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry standard dummy text ever since the 1500, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960 with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.</p>'
                ),
                'register' => array(
                    'title' => 'Register',
                    'content' => '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry standard dummy text ever since the 1500, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960 with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.</p>'
                ),
                'stories' => array(
                    'title' => 'Stories',
                    'content' => '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry standard dummy text ever since the 1500, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960 with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.</p>'
                ),
                'blog' => array(
                    'title' => 'Blog',
                    'content' => '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry standard dummy text ever since the 1500, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960 with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.</p>'
                ),
                'request-blood' => array(
                    'title' => 'Request Blood',
                    'content' => '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry standard dummy text ever since the 1500, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960 with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.</p>'
                ),
            );

            $blood_donation_campaign_page_ids = array();

            // Loop through the pages and create them if they don’t exist
            foreach ($blood_donation_campaign_pages as $blood_donation_campaign_slug => $blood_donation_campaign_data) {
                $blood_donation_campaign_existing_page = get_page_by_path($blood_donation_campaign_slug);

                if ($blood_donation_campaign_existing_page) {
                    // If the page already exists, use its ID
                    $blood_donation_campaign_page_id = $blood_donation_campaign_existing_page->ID;
                } else {
                    // Create a new page
                    $blood_donation_campaign_page_data = array(
                        'post_type'    => 'page',
                        'post_title'   => $blood_donation_campaign_data['title'],
                        'post_content' => isset($blood_donation_campaign_data['content']) ? $blood_donation_campaign_data['content'] : '',
                        'post_status'  => 'publish',
                        'post_author'  => get_current_user_id(), // Set author dynamically
                        'post_name'    => $blood_donation_campaign_slug,
                    );

                    $blood_donation_campaign_page_id = wp_insert_post($blood_donation_campaign_page_data);

                    // Assign custom page template if specified
                    if (!empty($blood_donation_campaign_data['template'])) {
                        update_post_meta($blood_donation_campaign_page_id, '_wp_page_template', $blood_donation_campaign_data['template']);
                    }
                }

                // Store the page IDs
                $blood_donation_campaign_page_ids[$blood_donation_campaign_slug] = $blood_donation_campaign_page_id;
            }

            // Set homepage and blog page
            update_option('page_for_posts', $blood_donation_campaign_page_ids['blog']);
            update_option('page_on_front', $blood_donation_campaign_page_ids['home']);
            update_option('show_on_front', 'page');

            // Define menu items
            $blood_donation_campaign_menu_items = array(
                'home',
                'about-us',
                'why-donate',
                'register',
                'stories',
                'blog',
                'request-blood'
            );

            // Add menu items dynamically
            foreach ($blood_donation_campaign_menu_items as $blood_donation_campaign_slug) {
                wp_update_nav_menu_item($blood_donation_campaign_menu_id, 0, array(
                    'menu-item-title' => esc_html($blood_donation_campaign_pages[$blood_donation_campaign_slug]['title']),
                    'menu-item-url' => get_permalink($blood_donation_campaign_page_ids[$blood_donation_campaign_slug]),
                    'menu-item-status' => 'publish',
                    'menu-item-object-id' => $blood_donation_campaign_page_ids[$blood_donation_campaign_slug],
                    'menu-item-object' => 'page',
                    'menu-item-type' => 'post_type',
                ));
            }

            // Assign menu to theme location
            $blood_donation_campaign_locations = get_theme_mod('nav_menu_locations', array());
            $blood_donation_campaign_locations[$blood_donation_campaign_bpmenulocation] = $blood_donation_campaign_menu_id;
            set_theme_mod('nav_menu_locations', $blood_donation_campaign_locations);
        }

        //Logo
        set_theme_mod( 'blood_donation_campaign_the_custom_logo', esc_url( get_template_directory_uri().'/images/Logo.png'));

        //Header Section
        set_theme_mod('blood_donation_campaign_enable_topbar', true);        
        set_theme_mod('blood_donation_campaign_phone_number', '+1234567890');
        set_theme_mod('blood_donation_campaign_email_address', 'lifeflow@example.com');
        set_theme_mod('blood_donation_campaign_topbar_text', 'Urgent Need for O- Blood This Week - Every Drop Counts.');
        set_theme_mod('blood_donation_campaign_facebook_url', 'https://www.facebook.com/');
        set_theme_mod('blood_donation_campaign_instagram_url', 'https://www.instagram.com/');
        set_theme_mod('blood_donation_campaign_twitter_url', 'https://www.twitter.com/');
        set_theme_mod('blood_donation_campaign_youtube_url', 'https://www.youtube.com/');
        set_theme_mod('blood_donation_campaign_pinterest_url', 'https://www.pinterest.com/');
        set_theme_mod('blood_donation_campaign_header_btn_text', 'Contact Us');
        set_theme_mod('blood_donation_campaign_header_btn_url', '#');
        
        //Slider Section
        set_theme_mod('blood_donation_campaign_slider', true);   
        set_theme_mod('blood_donation_campaign_button_text', 'Donate Now');
        $blood_donation_campaign_featured_category_id = wp_create_category('Slider');
        set_theme_mod('blood_donation_campaign_slider_cat', 'Slider');
        
        $blood_donation_campaign_titles = array(
            'Give Blood, Save Lives',
            'Donate Today, Be a Hero Tomorrow',
            'Your Blood Can Bring Hope'
        );

        $blood_donation_campaign_contents = array(
            '<p>Be the reason someone smiles today. Every drop counts and can save lives.</p>',
            '<p>Your small act of kindness can make a huge difference. Donate blood and be a hero!</p>',
            '<p>One donation can give someone another chance at life. Be that hope.</p>'
        );

        for ($blood_donation_campaign_i = 0; $blood_donation_campaign_i < 2; $blood_donation_campaign_i++) { 
            
            set_theme_mod(
                'blood_donation_campaign_title' . ($blood_donation_campaign_i + 1),
                $blood_donation_campaign_titles[$blood_donation_campaign_i]
            );

            // Create post
            $blood_donation_campaign_my_post = array(
                'post_title'    => wp_strip_all_tags($blood_donation_campaign_titles[$blood_donation_campaign_i]),
                'post_content'  => $blood_donation_campaign_contents[$blood_donation_campaign_i],
                'post_status'   => 'publish',
                'post_type'     => 'post',
                'post_category' => array($blood_donation_campaign_featured_category_id),
            );

            $blood_donation_campaign_post_id = wp_insert_post($blood_donation_campaign_my_post);

            if (!is_wp_error($blood_donation_campaign_post_id)) {
                // Set featured image
                $blood_donation_campaign_image_url = get_template_directory_uri() . '/images/slider' . ($blood_donation_campaign_i + 1) . '.png';
                $blood_donation_campaign_image_id  = media_sideload_image($blood_donation_campaign_image_url, $blood_donation_campaign_post_id, null, 'id');
                
                if (!is_wp_error($blood_donation_campaign_image_id)) {
                    set_post_thumbnail($blood_donation_campaign_post_id, $blood_donation_campaign_image_id);
                } else {
                    error_log('Failed to set post thumbnail for post ID: ' . $blood_donation_campaign_post_id);
                }
            } else {
                error_log('Failed to create post: ' . print_r($blood_donation_campaign_post_id, true));
            }
        }

        //Our Services
        set_theme_mod('blood_donation_campaign_disabled_camp_section', true);  
        set_theme_mod('blood_donation_campaign_camp_title', 'Upcoming Blood Donation Camps');
        set_theme_mod('blood_donation_campaign_camp_text', 'Join a camp near you and become a lifesaver.');
        set_theme_mod('blood_donation_campaign_donation_camp_btn_text', 'Request a Camp in Your Area');
        set_theme_mod('blood_donation_campaign_donation_camp_btn_url', '#');
     
        // Titles (added 3 more)
        $blood_donation_campaign_service_titles = array(
            'University Blood Drive',
            'Community Health Center Blood Donation',
            'Corporate Office Blood Donation Camp',
            'Downtown City Blood Drive',
            'Red Cross Mega Donation Camp',
            'Tech Park Community Blood Drive'
        );

        // Contents (added 3 more)
        $blood_donation_campaign_service_contents = array(
            'Join us for the annual University Blood Drive. Help save lives and support patients in need at UCSF hospitals.',
            'Our Community Health Center is organizing a blood donation camp to ensure timely availability of blood for emergencies.',
            'The Corporate Office is hosting a donation camp. Employees and locals are welcome to participate and make a difference.',
            'Participate in the Downtown City donation drive to support emergency medical needs.',
            'A Mega Blood Donation Camp organized by the Red Cross. Everyone is encouraged to join.',
            'Tech Park is hosting a community blood drive for employees and neighbors.'
        );

        // Locations (added 3 more)
        $blood_donation_campaign_locations = array(
            'UCSF Medical Campus, 500 Parnassus Ave, San Francisco, USA',
            'Community Health Center, 123 Main Street, Los Angeles, USA',
            'Corporate Park, 45 Silicon Valley Blvd, San Jose, USA',
            'Downtown Hall, 22 Market Street, San Diego, USA',
            'Red Cross Center, 88 Relief Ave, Sacramento, USA',
            'Tech Park Block A, 12 Innovation Way, Austin, USA'
        );

        // Dates (added 3 more)
        $blood_donation_campaign_dates = array(
            'July 18, 2025 (Sunday)',
            'August 10, 2025 (Monday)',
            'September 5, 2025 (Friday)',
            'October 15, 2025 (Wednesday)',
            'November 20, 2025 (Thursday)',
            'December 10, 2025 (Monday)'
        );

        // Times (added 3 more)
        $blood_donation_campaign_times = array(
            '11:00 AM - 5:00 PM',
            '10:00 AM - 4:00 PM',
            '09:00 AM - 3:00 PM',
            '12:00 PM - 6:00 PM',
            '08:00 AM - 2:00 PM',
            '01:00 PM - 7:00 PM'
        );

        // Images (added 3 more)
        $blood_donation_campaign_image_urls = array(
            get_template_directory_uri() . '/images/service1.png',
            get_template_directory_uri() . '/images/service2.png',
            get_template_directory_uri() . '/images/service3.png',
            get_template_directory_uri() . '/images/service4.png',
            get_template_directory_uri() . '/images/service5.png',
            get_template_directory_uri() . '/images/service6.png'
        );

        // Loop to create posts
        $blood_donation_campaign_total_posts = count($blood_donation_campaign_service_titles);

        for ($blood_donation_campaign_i = 0; $blood_donation_campaign_i < $blood_donation_campaign_total_posts; $blood_donation_campaign_i++) {

            $blood_donation_campaign_title   = $blood_donation_campaign_service_titles[$blood_donation_campaign_i];
            $blood_donation_campaign_content = $blood_donation_campaign_service_contents[$blood_donation_campaign_i];

            // Create post
            $blood_donation_campaign_post_id = wp_insert_post(array(
                'post_title'   => wp_strip_all_tags($blood_donation_campaign_title),
                'post_content' => $blood_donation_campaign_content,
                'post_status'  => 'publish',
                'post_type'    => 'post',
            ));

            if ($blood_donation_campaign_post_id && !is_wp_error($blood_donation_campaign_post_id)) {

                // Save customizer values for each post
                set_theme_mod('blood_donation_campaign_location_text' . ($blood_donation_campaign_i + 1), $blood_donation_campaign_locations[$blood_donation_campaign_i]);
                set_theme_mod('blood_donation_campaign_add_date_text' . ($blood_donation_campaign_i + 1), $blood_donation_campaign_dates[$blood_donation_campaign_i]);
                set_theme_mod('blood_donation_campaign_add_time_text' . ($blood_donation_campaign_i + 1), $blood_donation_campaign_times[$blood_donation_campaign_i]);

                // Save post ID in customizer
                set_theme_mod('blood_donation_campaign_select_post' . ($blood_donation_campaign_i + 1), $blood_donation_campaign_post_id);

                // Featured image
                $blood_donation_campaign_image_url = $blood_donation_campaign_image_urls[$blood_donation_campaign_i];
                $blood_donation_campaign_image_id  = media_sideload_image($blood_donation_campaign_image_url, $blood_donation_campaign_post_id, null, 'id');

                if (!is_wp_error($blood_donation_campaign_image_id)) {
                    set_post_thumbnail($blood_donation_campaign_post_id, $blood_donation_campaign_image_id);
                }
            }
        }

        // Show success message and the "View Site" button
        update_option('blood_donation_campaign_demo_import_completed', true);
        echo '<br>';
        echo '<div class="success">Demo Import Successful</div>';
        echo '<br>';
        echo '<hr>';
        echo '<br>';
        echo '<span>' . esc_html__( 'You can now visit your site or customize it further.', 'blood-donation-campaign' ) . '</span>';
        echo '<br>';
    }
     ?>
    <ul>
        <li>
        <?php 
        // Check if the form is submitted
        if ( !isset( $_POST['submit'] ) ) : ?>
            <!-- Show demo importer form only if it's not submitted -->
            <?php if (!get_option('blood_donation_campaign_demo_import_completed')) : ?>
                <span><?php echo esc_html( 'Click on the below content to get demo content installed.', 'blood-donation-campaign' ); ?></span>
                <br><br>
                <hr><br>
                <b class="note"><?php echo esc_html('Note :', 'blood-donation-campaign' ); ?></b><br><br>
                <small><b><?php echo esc_html('Please take a backup if your website is already live with data. This importer will overwrite existing data.', 'blood-donation-campaign' ); ?></b></small><br><br>
                <form id="demo-importer-form" action="" method="POST" onsubmit="return runDemoImport();">
                    <input type="submit" name="submit" value="<?php echo esc_attr('Run Importer','blood-donation-campaign'); ?>" class="button button-primary button-large">
                </form>
                <script type="text/javascript">
                    function runDemoImport() {
                        if (confirm('Do you really want to do this?')) {
                            document.getElementById('demo-import-loader').style.display = 'block';
                            return true;
                        }
                        return false;
                    }
                </script>
             <?php endif; ?>
         <?php 
        endif; 

        // Show "View Site" button after form submission
        if ( isset( $_POST['submit'] ) ) {
        echo '<div class="view-site-btn">';
        echo '<a href="' . esc_url(home_url()) . '" class="button button-primary button-large" style="margin-top: 10px;" target="_blank">View Site</a>';
        echo '<a href="' . esc_url( admin_url('customize.php') ) . '" class="button button-primary button-large" style="margin-top: 10px;" target="_blank">Customize Demo Content</a>';
        echo '</div>';
        }
        ?>
        </li>
    </ul>
 </div>



 