<?php
/**
 * Blood Donation Campaign Theme Customizer
 *
 * @package Blood Donation Campaign
 */

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function blood_donation_campaign_customize_register( $wp_customize ) {

	function blood_donation_campaign_sanitize_dropdown_pages( $page_id, $setting ) {
  		$page_id = absint( $page_id );
  		return ( 'publish' == get_post_status( $page_id ) ? $page_id : $setting->default );
	}

	$wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';

	wp_enqueue_style('blood-donation-campaign-customize-controls', trailingslashit(esc_url(get_template_directory_uri())).'/css/customize-controls.css');

	// Enable / Disable Logo
	$wp_customize->add_setting('blood_donation_campaign_logo_enable',array(
		'default' => true,
		'sanitize_callback' => 'blood_donation_campaign_sanitize_checkbox',
	));
	$wp_customize->add_control( 'blood_donation_campaign_logo_enable', array(
		'settings' => 'blood_donation_campaign_logo_enable',
		'section'   => 'title_tagline',
		'label'     => __('Enable Logo','blood-donation-campaign'),
		'type'      => 'checkbox'
	));

	//Logo
    $wp_customize->add_setting('blood_donation_campaign_logo_width', array(
        'default' => 200,
        'transport' => 'refresh',
        'sanitize_callback' => 'blood_donation_campaign_sanitize_integer'
    ));
    $wp_customize->add_control(new Blood_Donation_Campaign_Slider_Custom_Control($wp_customize, 'blood_donation_campaign_logo_width', array(
    	'label'          => __( 'Logo Width', 'blood-donation-campaign'),
        'section' => 'title_tagline',
        'settings' => 'blood_donation_campaign_logo_width',
        'input_attrs' => array(
            'step' => 1,
            'min' => 0,
            'max' => 200,
        ),
    )));

	// color site title
	$wp_customize->add_setting('blood_donation_campaign_sitetitle_color',array(
		'default' => '',
		'sanitize_callback' => 'blood_donation_campaign_sanitize_hex_color',
		'capability' => 'edit_theme_options',
	));

	$wp_customize->add_control( 'blood_donation_campaign_sitetitle_color', array(
	   'settings' => 'blood_donation_campaign_sitetitle_color',
	   'section'   => 'title_tagline',
	   'label' => __('Site Title Color', 'blood-donation-campaign'),
	   'type'      => 'color'
	));

	$wp_customize->add_setting('blood_donation_campaign_title_enable',array(
		'default' => false,
		'sanitize_callback' => 'blood_donation_campaign_sanitize_checkbox',
	));
	$wp_customize->add_control( 'blood_donation_campaign_title_enable', array(
	   'settings' => 'blood_donation_campaign_title_enable',
	   'section'   => 'title_tagline',
	   'label'     => __('Enable Site Title','blood-donation-campaign'),
	   'type'      => 'checkbox'
	));

	// color site tagline
	$wp_customize->add_setting('blood_donation_campaign_sitetagline_color',array(
		'default' => '',
		'sanitize_callback' => 'blood_donation_campaign_sanitize_hex_color',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'blood_donation_campaign_sitetagline_color', array(
	   'settings' => 'blood_donation_campaign_sitetagline_color',
	   'section'   => 'title_tagline',
	   'label' => __('Site Tagline Color', 'blood-donation-campaign'),
	   'type'      => 'color'
	));

	$wp_customize->add_setting('blood_donation_campaign_tagline_enable',array(
		'default' => false,
		'sanitize_callback' => 'blood_donation_campaign_sanitize_checkbox',
	));
	$wp_customize->add_control( 'blood_donation_campaign_tagline_enable', array(
	   'settings' => 'blood_donation_campaign_tagline_enable',
	   'section'   => 'title_tagline',
	   'label'     => __('Enable Site Tagline','blood-donation-campaign'),
	   'type'      => 'checkbox'
	));

	// woocommerce section
	$wp_customize->add_section('blood_donation_campaign_woocommerce_page_settings', array(
		'title'    => __('WooCommerce Page Settings', 'blood-donation-campaign'),
		'priority' => null,
		'panel'    => 'woocommerce',
	));

	$wp_customize->add_setting('blood_donation_campaign_shop_page_sidebar',array(
		'default' => false,
		'sanitize_callback'	=> 'blood_donation_campaign_sanitize_checkbox'
	 ));
	 $wp_customize->add_control('blood_donation_campaign_shop_page_sidebar',array(
		'type' => 'checkbox',
		'label' => __(' Check To Enable Shop page sidebar','blood-donation-campaign'),
		'section' => 'blood_donation_campaign_woocommerce_page_settings',
	 ));

    // shop page sidebar alignment
    $wp_customize->add_setting('blood_donation_campaign_shop_page_sidebar_position', array(
		'default'           => 'Right Sidebar',
		'sanitize_callback' => 'blood_donation_campaign_sanitize_choices',
	));
	$wp_customize->add_control('blood_donation_campaign_shop_page_sidebar_position',array(
		'type'           => 'radio',
		'label'          => __('Shop Page Sidebar', 'blood-donation-campaign'),
		'section'        => 'blood_donation_campaign_woocommerce_page_settings',
		'choices'        => array(
			'Left Sidebar'  => __('Left Sidebar', 'blood-donation-campaign'),
			'Right Sidebar' => __('Right Sidebar', 'blood-donation-campaign'),
		),
	));	 

	$wp_customize->add_setting('blood_donation_campaign_wooproducts_nav',array(
		'default' => 'Yes',
		'sanitize_callback'	=> 'blood_donation_campaign_sanitize_choices'
	 ));
	 $wp_customize->add_control('blood_donation_campaign_wooproducts_nav',array(
		'type' => 'select',
		'label' => __('Shop Page Products Navigation','blood-donation-campaign'),
		'choices' => array(
			 'Yes' => __('Yes','blood-donation-campaign'),
			 'No' => __('No','blood-donation-campaign'),
		 ),
		'section' => 'blood_donation_campaign_woocommerce_page_settings',
	 ));

	 $wp_customize->add_setting( 'blood_donation_campaign_single_page_sidebar',array(
		'default' => false,
		'sanitize_callback'	=> 'blood_donation_campaign_sanitize_checkbox'
    ) );
    $wp_customize->add_control('blood_donation_campaign_single_page_sidebar',array(
    	'type' => 'checkbox',
       	'label' => __('Check To Enable Single Product Page Sidebar','blood-donation-campaign'),
		'section' => 'blood_donation_campaign_woocommerce_page_settings'
    ));

	// single product page sidebar alignment
    $wp_customize->add_setting('blood_donation_campaign_single_product_page_layout', array(
		'default'           => 'Right Sidebar',
		'sanitize_callback' => 'blood_donation_campaign_sanitize_choices',
	));
	$wp_customize->add_control('blood_donation_campaign_single_product_page_layout',array(
		'type'           => 'radio',
		'label'          => __('Single product Page Sidebar', 'blood-donation-campaign'),
		'section'        => 'blood_donation_campaign_woocommerce_page_settings',
		'choices'        => array(
			'Left Sidebar'  => __('Left Sidebar', 'blood-donation-campaign'),
			'Right Sidebar' => __('Right Sidebar', 'blood-donation-campaign'),
		),
	));

	$wp_customize->add_setting('blood_donation_campaign_related_product_enable',array(
		'default' => true,
		'sanitize_callback'	=> 'blood_donation_campaign_sanitize_checkbox'
	));
	$wp_customize->add_control('blood_donation_campaign_related_product_enable',array(
		'type' => 'checkbox',
		'label' => __('Check To Enable Related product','blood-donation-campaign'),
		'section' => 'blood_donation_campaign_woocommerce_page_settings',
	));

	$wp_customize->add_setting( 'blood_donation_campaign_woo_product_img_border_radius', array(
        'default'              => '0',
        'transport'            => 'refresh',
        'sanitize_callback'    => 'blood_donation_campaign_sanitize_integer'
    ) );
    $wp_customize->add_control(new Blood_Donation_Campaign_Slider_Custom_Control( $wp_customize, 'blood_donation_campaign_woo_product_img_border_radius',array(
		'label'	=> esc_html__('Woo Product Img Border Radius','blood-donation-campaign'),
		'section'=> 'blood_donation_campaign_woocommerce_page_settings',
		'settings'=>'blood_donation_campaign_woo_product_img_border_radius',
		'input_attrs' => array(
            'step'             => 1,
			'min'              => 0,
			'max'              => 100,
        ),
	)));

	// Add a setting for number of products per row
    $wp_customize->add_setting('blood_donation_campaign_products_per_row', array(
	    'default'   => '4',
	    'transport' => 'refresh',
	    'sanitize_callback' => 'blood_donation_campaign_sanitize_integer'  
    ));

   	$wp_customize->add_control('blood_donation_campaign_products_per_row', array(
	   'label'    => __('Products Per Row', 'blood-donation-campaign'),
	   'section'  => 'blood_donation_campaign_woocommerce_page_settings',
	   'settings' => 'blood_donation_campaign_products_per_row',
	   'type'     => 'select',
	   'choices'  => array(
			'2' => '2',
			'3' => '3',
			'4' => '4',
	  ),
   	) );
   
   	// Add a setting for the number of products per page
	$wp_customize->add_setting('blood_donation_campaign_products_per_page', array(
		'default'   => '8',
		'transport' => 'refresh',
		'sanitize_callback' => 'blood_donation_campaign_sanitize_integer'
	));

	$wp_customize->add_control('blood_donation_campaign_products_per_page', array(
		'label'    => __('Products Per Page', 'blood-donation-campaign'),
		'section'  => 'blood_donation_campaign_woocommerce_page_settings',
		'settings' => 'blood_donation_campaign_products_per_page',
		'type'     => 'number',
		'input_attrs' => array(
			'min'  => 1,
			'step' => 1,
		),
	));

	//Theme Options
	$wp_customize->add_panel( 'blood_donation_campaign_panel_area', array(
		'priority' => 10,
		'capability' => 'edit_theme_options',
		'title' => __( 'Theme Options Panel', 'blood-donation-campaign' ),
	) );

	//Site Layout Section
	$wp_customize->add_section('blood_donation_campaign_site_layoutsec',array(
		'title'	=> __('Manage Site Layout Section ','blood-donation-campaign'),
		'description' => __('<p class="sec-title">Manage Site Layout Section</p>','blood-donation-campaign'),
		'priority'	=> 1,
		'panel' => 'blood_donation_campaign_panel_area',
	));

	$wp_customize->add_setting('blood_donation_campaign_preloader',array(
		'default' => false,
		'sanitize_callback' => 'blood_donation_campaign_sanitize_checkbox',
	));
	$wp_customize->add_control( 'blood_donation_campaign_preloader', array(
	   'section'   => 'blood_donation_campaign_site_layoutsec',
	   'label'	=> __('Check to Show preloader','blood-donation-campaign'),
	   'type'      => 'checkbox'
 	));		

	$wp_customize->add_setting('blood_donation_campaign_box_layout',array(
		'default' => false,
		'sanitize_callback' => 'blood_donation_campaign_sanitize_checkbox',
	));
	$wp_customize->add_control( 'blood_donation_campaign_box_layout', array(
	   'section'   => 'blood_donation_campaign_site_layoutsec',
	   'label'	=> __('Check to Show Box Layout','blood-donation-campaign'),
	   'type'      => 'checkbox'
 	));

	// Add Settings and Controls for Page Layout
    $wp_customize->add_setting('blood_donation_campaign_sidebar_page_layout',array(
		'default' => 'full',
	 	'sanitize_callback' => 'blood_donation_campaign_sanitize_choices'
	));
	$wp_customize->add_control('blood_donation_campaign_sidebar_page_layout',array(
		'type' => 'radio',
		'label'     => __('Theme Page Sidebar Position', 'blood-donation-campaign'),
		'section' => 'blood_donation_campaign_site_layoutsec',
		'choices' => array(
			'full' => __('Full','blood-donation-campaign'),
			'left' => __('Left','blood-donation-campaign'),
			'right' => __('Right','blood-donation-campaign'),
		),
	));

	$wp_customize->add_setting( 'blood_donation_campaign_site_layoutsec_settings_upgraded_features',array(
		'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control('blood_donation_campaign_site_layoutsec_settings_upgraded_features', array(
		'type'=> 'hidden',
		'description' => "<span class='customizer-upgraded-features'>Unlock Premium Customization Features:
		<a target='_blank' href='". esc_url(BLOOD_DONATION_CAMPAIGN_PREMIUM_PAGE) ." '>Upgrade to Pro</a></span>",
		'section' => 'blood_donation_campaign_site_layoutsec'
	));

	//Global Color
	$wp_customize->add_section('blood_donation_campaign_global_color', array(
		'title'    => __('Manage Global Color Section', 'blood-donation-campaign'),
		'panel'    => 'blood_donation_campaign_panel_area',
	));

	$wp_customize->add_setting('blood_donation_campaign_first_color', array(
		'default'           => '#A41214',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'blood_donation_campaign_first_color', array(
		'label'    => __('Theme Color One', 'blood-donation-campaign'),
		'section'  => 'blood_donation_campaign_global_color',
		'settings' => 'blood_donation_campaign_first_color',
	)));

	$wp_customize->add_setting('blood_donation_campaign_second_color', array(
		'default'           => '#B79455',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'blood_donation_campaign_second_color', array(
		'label'    => __('Theme Color Two', 'blood-donation-campaign'),
		'section'  => 'blood_donation_campaign_global_color',
		'settings' => 'blood_donation_campaign_second_color',
	)));

	$wp_customize->add_setting( 'blood_donation_campaign_global_color_settings_upgraded_features',array(
		'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control('blood_donation_campaign_global_color_settings_upgraded_features', array(
		'type'=> 'hidden',
		'description' => "<span class='customizer-upgraded-features'>Unlock Premium Customization Features:
		<a target='_blank' href='". esc_url(BLOOD_DONATION_CAMPAIGN_PREMIUM_PAGE) ." '>Upgrade to Pro</a></span>",
		'section' => 'blood_donation_campaign_global_color'
	));

	// Header Section
	$wp_customize->add_section('blood_donation_campaign_topbar_section',array(
	    'title' => __('Manage Header Section','blood-donation-campaign'),
	    'description' => __('<p class="sec-title">Manage Header Section</p>', 'blood-donation-campaign'),
	    'priority'  => null,
	    'panel' => 'blood_donation_campaign_panel_area',
	));	

	$wp_customize->add_setting('blood_donation_campaign_enable_topbar',array(
		'default' => false,
		'sanitize_callback' => 'blood_donation_campaign_sanitize_checkbox',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'blood_donation_campaign_enable_topbar', array(
	   'settings' => 'blood_donation_campaign_enable_topbar',
	   'section'   => 'blood_donation_campaign_topbar_section',
	   'label'     => __('Check To Enable This Section','blood-donation-campaign'),
	   'type'      => 'checkbox'
	));

 	$wp_customize->add_setting('blood_donation_campaign_phone_number',array(
		'default' => '',
		'sanitize_callback' => 'blood_donation_campaign_sanitize_phone_number',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'blood_donation_campaign_phone_number', array(
	   'settings' => 'blood_donation_campaign_phone_number',
	   'section'   => 'blood_donation_campaign_topbar_section',
	   'label' => __('Add Phone Number', 'blood-donation-campaign'),
	   'type'      => 'text'
	));

 	$wp_customize->add_setting('blood_donation_campaign_email_address',array(
		'default' => '',
		'sanitize_callback' => 'sanitize_email',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'blood_donation_campaign_email_address', array(
	   'settings' => 'blood_donation_campaign_email_address',
	   'section'   => 'blood_donation_campaign_topbar_section',
	   'label' => __('Add Email Address', 'blood-donation-campaign'),
	   'type'      => 'text'
	));

	$wp_customize->add_setting('blood_donation_campaign_topbar_text', array(
	    'default'           => '',
	    'sanitize_callback' => 'sanitize_text_field',
	    'capability'        => 'edit_theme_options',
	));
	$wp_customize->add_control('blood_donation_campaign_topbar_text', array(
	    'settings' => 'blood_donation_campaign_topbar_text',
	    'section'  => 'blood_donation_campaign_topbar_section',
	    'label'    => __('Add Topbar Text', 'blood-donation-campaign'),
	    'type'     => 'text',
	));

	$wp_customize->add_setting('blood_donation_campaign_facebook_url',array(
		'default' => '',
		'sanitize_callback' => 'esc_url_raw',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'blood_donation_campaign_facebook_url', array(
	   'settings' => 'blood_donation_campaign_facebook_url',
	   'section'   => 'blood_donation_campaign_topbar_section',
	   'label' => __('Add Facebook URL', 'blood-donation-campaign'),
	   'type'      => 'url'
	));

	$wp_customize->add_setting('blood_donation_campaign_instagram_url',array(
		'default' => '',
		'sanitize_callback' => 'esc_url_raw',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'blood_donation_campaign_instagram_url', array(
	   'settings' => 'blood_donation_campaign_instagram_url',
	   'section'   => 'blood_donation_campaign_topbar_section',
	   'label' => __('Add Instagram URL', 'blood-donation-campaign'),
	   'type'      => 'url'
	));

	$wp_customize->add_setting('blood_donation_campaign_twitter_url',array(
		'default' => '',
		'sanitize_callback' => 'esc_url_raw',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'blood_donation_campaign_twitter_url', array(
	   'settings' => 'blood_donation_campaign_twitter_url',
	   'section'   => 'blood_donation_campaign_topbar_section',
	   'label' => __('Add Twitter URL', 'blood-donation-campaign'),
	   'type'      => 'url'
	));

	$wp_customize->add_setting('blood_donation_campaign_youtube_url',array(
		'default' => '',
		'sanitize_callback' => 'esc_url_raw',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'blood_donation_campaign_youtube_url', array(
	   'settings' => 'blood_donation_campaign_youtube_url',
	   'section'   => 'blood_donation_campaign_topbar_section',
	   'label' => __('Add Youtube URL', 'blood-donation-campaign'),
	   'type'      => 'url'
	));

	$wp_customize->add_setting('blood_donation_campaign_pinterest_url',array(
		'default' => '',
		'sanitize_callback' => 'esc_url_raw',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'blood_donation_campaign_pinterest_url', array(
	   'settings' => 'blood_donation_campaign_pinterest_url',
	   'section'   => 'blood_donation_campaign_topbar_section',
	   'label' => __('Add Pinterest URL', 'blood-donation-campaign'),
	   'type'      => 'url'
	));

	$wp_customize->add_setting('blood_donation_campaign_header_btn_text',array(
		'default' => '',
		'sanitize_callback' => 'sanitize_text_field',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'blood_donation_campaign_header_btn_text', array(
	   'settings' => 'blood_donation_campaign_header_btn_text',
	   'section'   => 'blood_donation_campaign_topbar_section',
	   'label' => __('Add Button Text', 'blood-donation-campaign'),
	   'type'      => 'text'
	));

	$wp_customize->add_setting('blood_donation_campaign_header_btn_url',array(
		'default' => '',
		'sanitize_callback' => 'esc_url_raw',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'blood_donation_campaign_header_btn_url', array(
	   'settings' => 'blood_donation_campaign_header_btn_url',
	   'section'   => 'blood_donation_campaign_topbar_section',
	   'label' => __('Add Button URL', 'blood-donation-campaign'),
	   'type'      => 'url'
	));

	$wp_customize->add_setting('blood_donation_campaign_stickyheader',array(
		'default' => false,
		'sanitize_callback' => 'blood_donation_campaign_sanitize_checkbox',
	));
	$wp_customize->add_control( 'blood_donation_campaign_stickyheader', array(
	   'section'   => 'blood_donation_campaign_topbar_section',
	   'label'	=> __('Check To Show Sticky Header','blood-donation-campaign'),
	   'type'      => 'checkbox'
 	));

	// Menu Text Transform
    $wp_customize->add_setting( 'blood_donation_campaign_menu_text_transform', array(
        'default'           => 'Capitalize',
		'transport' => 'refresh',
		'sanitize_callback' => 'blood_donation_campaign_sanitize_choices'
    ));

    $wp_customize->add_control( 'blood_donation_campaign_menu_text_transform', array(
        'label'    => __( 'Menu Text Transform', 'blood-donation-campaign' ),
        'section'  => 'blood_donation_campaign_topbar_section',
        'type'     => 'select',
        'choices'  => array(
			'None'       => __( 'None', 'blood-donation-campaign' ),
            'Capitalize' => __( 'Capitalize', 'blood-donation-campaign' ),
            'Uppercase'  => __( 'Uppercase', 'blood-donation-campaign' ),
            'Lowercase'  => __( 'Lowercase', 'blood-donation-campaign' ),
        ),
    ));

	$wp_customize->add_setting( 'blood_donation_campaign_topbar_settings_upgraded_features',array(
		'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control('blood_donation_campaign_topbar_settings_upgraded_features', array(
		'type'=> 'hidden',
		'description' => "<span class='customizer-upgraded-features'>Unlock Premium Customization Features:
		<a target='_blank' href='". esc_url(BLOOD_DONATION_CAMPAIGN_PREMIUM_PAGE) ." '>Upgrade to Pro</a></span>",
		'section' => 'blood_donation_campaign_topbar_section'
	));

	// Slider Section
	$wp_customize->add_section('blood_donation_campaign_slider_section',array(
	    'title' => __('Manage Slider Section','blood-donation-campaign'),
	    'priority'  => null,
	    'description'	=> __('<p class="sec-title">Manage Slider Section</p> Select Post Category from the Dropdowns for slider, Also use the given image dimension (1100 x 550).','blood-donation-campaign'),
	    'panel' => 'blood_donation_campaign_panel_area',
	));	

	$wp_customize->add_setting('blood_donation_campaign_slider',array(
		'default' => false,
		'sanitize_callback' => 'blood_donation_campaign_sanitize_checkbox',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'blood_donation_campaign_slider', array(
		'settings' => 'blood_donation_campaign_slider',
		'section'   => 'blood_donation_campaign_slider_section',
		'label'     => __('Check To Enable This Section','blood-donation-campaign'),
		'type'      => 'checkbox'
	));

	$blood_donation_campaign_categories = get_categories();
	$blood_donation_campaign_cat_post = array();
	$blood_donation_campaign_cat_post['0'] = 'Select';

	foreach ($blood_donation_campaign_categories as $blood_donation_campaign_category) {
	    $blood_donation_campaign_cat_post[$blood_donation_campaign_category->slug] = $blood_donation_campaign_category->name;
	}

	$wp_customize->add_setting('blood_donation_campaign_slider_cat', array(
	    'default' => '0',
	    'sanitize_callback' => 'blood_donation_campaign_sanitize_choices',
	));

	$wp_customize->add_control('blood_donation_campaign_slider_cat', array(
	    'type'    => 'select',
	    'choices' => $blood_donation_campaign_cat_post,
	    'label'   => __('Select Category to display Latest Post', 'blood-donation-campaign'),
	    'section' => 'blood_donation_campaign_slider_section',
	));

	$wp_customize->add_setting('blood_donation_campaign_button_text',array(
		'default' => 'Donate Now',
		'sanitize_callback' => 'sanitize_text_field',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'blood_donation_campaign_button_text', array(
	   'settings' => 'blood_donation_campaign_button_text',
	   'section'   => 'blood_donation_campaign_slider_section',
	   'label' => __('Add Button Text', 'blood-donation-campaign'),
	   'type'      => 'text'
	));

	$wp_customize->add_setting('blood_donation_campaign_button_link_slider',array(
        'default'=> '',
        'sanitize_callback' => 'esc_url_raw'
    ));
    $wp_customize->add_control('blood_donation_campaign_button_link_slider',array(
        'label' => esc_html__('Add Button Link','blood-donation-campaign'),
        'section'=> 'blood_donation_campaign_slider_section',
        'type'=> 'url'
    ));

	$wp_customize->add_setting( 'blood_donation_campaign_slider_settings_upgraded_features',array(
		'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control('blood_donation_campaign_slider_settings_upgraded_features', array(
		'type'=> 'hidden',
		'description' => "<span class='customizer-upgraded-features'>Unlock Premium Customization Features:
		<a target='_blank' href='". esc_url(BLOOD_DONATION_CAMPAIGN_PREMIUM_PAGE) ." '>Upgrade to Pro</a></span>",
		'section' => 'blood_donation_campaign_slider_section'
	));

	// Donation Camp Section
	$wp_customize->add_section('blood_donation_campaign_donation_camp_section', array(
	    'title'       => __('Manage Donation Camp Section', 'blood-donation-campaign'),
	    'description' => __('<p class="sec-title">Manage Donation Camp Section</p>', 'blood-donation-campaign'),
	    'priority'    => null,
	    'panel'       => 'blood_donation_campaign_panel_area',
	));

	$wp_customize->add_setting('blood_donation_campaign_disabled_camp_section', array(
	    'default'           => false,
	    'sanitize_callback' => 'blood_donation_campaign_sanitize_checkbox',
	    'capability'        => 'edit_theme_options',
	));
	$wp_customize->add_control('blood_donation_campaign_disabled_camp_section', array(
	    'settings' => 'blood_donation_campaign_disabled_camp_section',
	    'section'  => 'blood_donation_campaign_donation_camp_section',
	    'label'    => __('Check To Enable Section', 'blood-donation-campaign'),
	    'type'     => 'checkbox',
	));

	$wp_customize->add_setting('blood_donation_campaign_camp_title', array(
	    'default'           => '',
	    'sanitize_callback' => 'sanitize_text_field',
	    'capability'        => 'edit_theme_options',
	));
	$wp_customize->add_control('blood_donation_campaign_camp_title', array(
	    'settings' => 'blood_donation_campaign_camp_title',
	    'section'  => 'blood_donation_campaign_donation_camp_section',
	    'label'    => __('Add Section Title', 'blood-donation-campaign'),
	    'type'     => 'text',
	));

	$wp_customize->add_setting('blood_donation_campaign_camp_text', array(
	    'default'           => '',
	    'sanitize_callback' => 'sanitize_text_field',
	    'capability'        => 'edit_theme_options',
	));
	$wp_customize->add_control('blood_donation_campaign_camp_text', array(
	    'settings' => 'blood_donation_campaign_camp_text',
	    'section'  => 'blood_donation_campaign_donation_camp_section',
	    'label'    => __('Add Section Text', 'blood-donation-campaign'),
	    'type'     => 'text',
	));

	$wp_customize->add_setting('blood_donation_campaign_donation_camp_btn_text',array(
		'default' => '',
		'sanitize_callback' => 'sanitize_text_field',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'blood_donation_campaign_donation_camp_btn_text', array(
	   'settings' => 'blood_donation_campaign_donation_camp_btn_text',
	   'section'   => 'blood_donation_campaign_donation_camp_section',
	   'label' => __('Add Button Text', 'blood-donation-campaign'),
	   'type'      => 'text'
	));

	$wp_customize->add_setting('blood_donation_campaign_donation_camp_btn_url',array(
		'default' => '',
		'sanitize_callback' => 'esc_url_raw',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'blood_donation_campaign_donation_camp_btn_url', array(
	   'settings' => 'blood_donation_campaign_donation_camp_btn_url',
	   'section'   => 'blood_donation_campaign_donation_camp_section',
	   'label' => __('Add Button URL', 'blood-donation-campaign'),
	   'type'      => 'url'
	));

	$blood_donation_campaign_args = array('numberposts' => -1);
	$blood_donation_campaign_post_list = get_posts($blood_donation_campaign_args);
	$blood_donation_campaign_i = 0;
	$blood_donation_campaign_pst[]='Select';
	foreach($blood_donation_campaign_post_list as $blood_donation_campaign_post){
		$blood_donation_campaign_pst[$blood_donation_campaign_post->ID] = $blood_donation_campaign_post->post_title;
	}

	for ( $blood_donation_campaign_i = 1; $blood_donation_campaign_i <= 6; $blood_donation_campaign_i++ ) {
		$wp_customize->add_setting('blood_donation_campaign_select_post'.$blood_donation_campaign_i,array(
			'sanitize_callback' => 'blood_donation_campaign_sanitize_choices',
		));
		$wp_customize->add_control('blood_donation_campaign_select_post'.$blood_donation_campaign_i,array(
			'type'    => 'select',
			'choices' => $blood_donation_campaign_pst,
			'label' => __('Select Post','blood-donation-campaign'),
			'section' => 'blood_donation_campaign_donation_camp_section',
		));

		$wp_customize->add_setting('blood_donation_campaign_location_text'.$blood_donation_campaign_i, array(
		    'default'           => '',
		    'sanitize_callback' => 'sanitize_text_field',
		    'capability'        => 'edit_theme_options',
		));
		$wp_customize->add_control('blood_donation_campaign_location_text'.$blood_donation_campaign_i, array(
		    'settings' => 'blood_donation_campaign_location_text'.$blood_donation_campaign_i,
		    'section'  => 'blood_donation_campaign_donation_camp_section',
		    'label'    => __('Add Camp Location', 'blood-donation-campaign'),
		    'type'     => 'text',
		));

		$wp_customize->add_setting('blood_donation_campaign_add_date_text'.$blood_donation_campaign_i, array(
		    'default'           => '',
		    'sanitize_callback' => 'sanitize_text_field',
		    'capability'        => 'edit_theme_options',
		));
		$wp_customize->add_control('blood_donation_campaign_add_date_text'.$blood_donation_campaign_i, array(
		    'settings' => 'blood_donation_campaign_add_date_text'.$blood_donation_campaign_i,
		    'section'  => 'blood_donation_campaign_donation_camp_section',
		    'label'    => __('Add Camp Date', 'blood-donation-campaign'),
		    'type'     => 'text',
		));

		$wp_customize->add_setting('blood_donation_campaign_add_time_text'.$blood_donation_campaign_i, array(
		    'default'           => '',
		    'sanitize_callback' => 'sanitize_text_field',
		    'capability'        => 'edit_theme_options',
		));
		$wp_customize->add_control('blood_donation_campaign_add_time_text'.$blood_donation_campaign_i, array(
		    'settings' => 'blood_donation_campaign_add_time_text'.$blood_donation_campaign_i,
		    'section'  => 'blood_donation_campaign_donation_camp_section',
		    'label'    => __('Add Camp Time', 'blood-donation-campaign'),
		    'type'     => 'text',
		));
	}

	$wp_customize->add_setting( 'blood_donation_campaign_camp_settings_upgraded_features',array(
		'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control('blood_donation_campaign_camp_settings_upgraded_features', array(
		'type'=> 'hidden',
		'description' => "<span class='customizer-upgraded-features'>Unlock Premium Customization Features:
		<a target='_blank' href='". esc_url(BLOOD_DONATION_CAMPAIGN_PREMIUM_PAGE) ." '>Upgrade to Pro</a></span>",
		'section' => 'blood_donation_campaign_donation_camp_section'
	));

	//Blog post
	$wp_customize->add_section('blood_donation_campaign_blog_post_settings',array(
        'title' => __('Manage Post Section', 'blood-donation-campaign'),
        'priority' => null,
        'panel' => 'blood_donation_campaign_panel_area'
    ) );

	$wp_customize->add_setting('blood_donation_campaign_metafields_date', array(
	    'default' => true,
	    'sanitize_callback' => 'blood_donation_campaign_sanitize_checkbox',
	));
	$wp_customize->add_control('blood_donation_campaign_metafields_date', array(
	    'settings' => 'blood_donation_campaign_metafields_date', 
	    'section'   => 'blood_donation_campaign_blog_post_settings',
	    'label'     => __('Check to Enable Date', 'blood-donation-campaign'),
	    'type'      => 'checkbox',
	));

	$wp_customize->add_setting('blood_donation_campaign_metafields_comments', array(
		'default' => true,
		'sanitize_callback' => 'blood_donation_campaign_sanitize_checkbox',
	));	
	$wp_customize->add_control('blood_donation_campaign_metafields_comments', array(
		'settings' => 'blood_donation_campaign_metafields_comments',
		'section'  => 'blood_donation_campaign_blog_post_settings',
		'label'    => __('Check to Enable Comments', 'blood-donation-campaign'),
		'type'     => 'checkbox',
	));

	$wp_customize->add_setting('blood_donation_campaign_metafields_author', array(
		'default' => true,
		'sanitize_callback' => 'blood_donation_campaign_sanitize_checkbox',
	));
	$wp_customize->add_control('blood_donation_campaign_metafields_author', array(
		'settings' => 'blood_donation_campaign_metafields_author',
		'section'  => 'blood_donation_campaign_blog_post_settings',
		'label'    => __('Check to Enable Author', 'blood-donation-campaign'),
		'type'     => 'checkbox',
	));		

	$wp_customize->add_setting('blood_donation_campaign_metafields_time', array(
		'default' => true,
		'sanitize_callback' => 'blood_donation_campaign_sanitize_checkbox',
	));
	$wp_customize->add_control('blood_donation_campaign_metafields_time', array(
		'settings' => 'blood_donation_campaign_metafields_time',
		'section'  => 'blood_donation_campaign_blog_post_settings',
		'label'    => __('Check to Enable Time', 'blood-donation-campaign'),
		'type'     => 'checkbox',
	));	

	$wp_customize->add_setting('blood_donation_campaign_metabox_seperator',array(
		'default' => '|',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('blood_donation_campaign_metabox_seperator',array(
		'type' => 'text',
		'label' => __('Metabox Seperator','blood-donation-campaign'),
		'description' => __('Ex: "/", "|", "-", ...','blood-donation-campaign'),
		'section' => 'blood_donation_campaign_blog_post_settings'
	)); 

    // Add Settings and Controls for Post Layout
	$wp_customize->add_setting('blood_donation_campaign_sidebar_post_layout',array(
		'default' => 'right',
		'sanitize_callback' => 'blood_donation_campaign_sanitize_choices'
	));
	$wp_customize->add_control('blood_donation_campaign_sidebar_post_layout',array(
		'type' => 'radio',
		'label'     => __('Theme Post Sidebar Position', 'blood-donation-campaign'),
		'description'   => __('This option work for blog page, archive page and search page.', 'blood-donation-campaign'),
		'section' => 'blood_donation_campaign_blog_post_settings',
		'choices' => array(
			'full' => __('Full','blood-donation-campaign'),
			'left' => __('Left','blood-donation-campaign'),
			'right' => __('Right','blood-donation-campaign'),
			'three-column' => __('Three Columns','blood-donation-campaign'),
			'four-column' => __('Four Columns','blood-donation-campaign'),
			'grid' => __('Grid Layout','blood-donation-campaign')
     ),
	) );

	$wp_customize->add_setting('blood_donation_campaign_blog_post_description_option',array(
    	'default'   => 'Excerpt Content', 
        'sanitize_callback' => 'blood_donation_campaign_sanitize_choices'
	));
	$wp_customize->add_control('blood_donation_campaign_blog_post_description_option',array(
        'type' => 'radio',
        'label' => __('Post Description Length','blood-donation-campaign'),
        'section' => 'blood_donation_campaign_blog_post_settings',
        'choices' => array(
            'No Content' => __('No Content','blood-donation-campaign'),
            'Excerpt Content' => __('Excerpt Content','blood-donation-campaign'),
            'Full Content' => __('Full Content','blood-donation-campaign'),
        ),
	) );

	$wp_customize->add_setting('blood_donation_campaign_blog_post_thumb',array(
        'sanitize_callback' => 'blood_donation_campaign_sanitize_checkbox',
        'default'           => 1,
    ));
    $wp_customize->add_control('blood_donation_campaign_blog_post_thumb',array(
        'type'        => 'checkbox',
        'label'       => esc_html__('Show / Hide Blog Post Thumbnail', 'blood-donation-campaign'),
        'section'     => 'blood_donation_campaign_blog_post_settings',
    ));

	$wp_customize->add_setting( 'blood_donation_campaign_blog_post_settings_upgraded_features',array(
		'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control('blood_donation_campaign_blog_post_settings_upgraded_features', array(
		'type'=> 'hidden',
		'description' => "<span class='customizer-upgraded-features'>Unlock Premium Customization Features:
		<a target='_blank' href='". esc_url(BLOOD_DONATION_CAMPAIGN_PREMIUM_PAGE) ." '>Upgrade to Pro</a></span>",
		'section' => 'blood_donation_campaign_blog_post_settings'
	));

	//Single Post Settings
	$wp_customize->add_section('blood_donation_campaign_single_post_settings',array(
		'title' => __('Manage Single Post Section', 'blood-donation-campaign'),
		'priority' => null,
		'panel' => 'blood_donation_campaign_panel_area'
	));

	$wp_customize->add_setting('blood_donation_campaign_single_post_date',array(
		'default' => true,
		'sanitize_callback'	=> 'blood_donation_campaign_sanitize_checkbox'
	));
	$wp_customize->add_control('blood_donation_campaign_single_post_date',array(
		'type' => 'checkbox',
		'label' => __('Enable / Disable Date ','blood-donation-campaign'),
		'section' => 'blood_donation_campaign_single_post_settings'
	));	

	$wp_customize->add_setting('blood_donation_campaign_single_post_author',array(
		'default' => true,
		'sanitize_callback'	=> 'blood_donation_campaign_sanitize_checkbox'
	));
	$wp_customize->add_control('blood_donation_campaign_single_post_author',array(
		'type' => 'checkbox',
		'label' => __('Enable / Disable Author','blood-donation-campaign'),
		'section' => 'blood_donation_campaign_single_post_settings'
	));

	$wp_customize->add_setting('blood_donation_campaign_single_post_comment',array(
		'default' => true,
		'sanitize_callback'	=> 'blood_donation_campaign_sanitize_checkbox'
	));
	$wp_customize->add_control('blood_donation_campaign_single_post_comment',array(
		'type' => 'checkbox',
		'label' => __('Enable / Disable Comments','blood-donation-campaign'),
		'section' => 'blood_donation_campaign_single_post_settings'
	));	

	$wp_customize->add_setting('blood_donation_campaign_single_post_time',array(
		'default' => true,
		'sanitize_callback'	=> 'blood_donation_campaign_sanitize_checkbox'
	));
	$wp_customize->add_control('blood_donation_campaign_single_post_time',array(
		'type' => 'checkbox',
		'label' => __('Enable / Disable Time','blood-donation-campaign'),
		'section' => 'blood_donation_campaign_single_post_settings'
	));	

	$wp_customize->add_setting('blood_donation_campaign_single_post_metabox_seperator',array(
		'default' => '|',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('blood_donation_campaign_single_post_metabox_seperator',array(
		'type' => 'text',
		'label' => __('Metabox Seperator','blood-donation-campaign'),
		'description' => __('Ex: "/", "|", "-", ...','blood-donation-campaign'),
		'section' => 'blood_donation_campaign_single_post_settings'
	)); 

	$wp_customize->add_setting('blood_donation_campaign_sidebar_single_post_layout',array(
    	'default' => 'right',
    	 'sanitize_callback' => 'blood_donation_campaign_sanitize_choices'
	));
	$wp_customize->add_control('blood_donation_campaign_sidebar_single_post_layout',array(
   		'type' => 'radio',
    	'label'     => __('Single post sidebar layout', 'blood-donation-campaign'),
     	'section' => 'blood_donation_campaign_single_post_settings',
     	'choices' => array(
			'full' => __('Full','blood-donation-campaign'),
			'left' => __('Left','blood-donation-campaign'),
			'right' => __('Right','blood-donation-campaign'),
     ),
	));

	$wp_customize->add_setting( 'blood_donation_campaign_single_post_settings_upgraded_features',array(
		'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control('blood_donation_campaign_single_post_settings_upgraded_features', array(
		'type'=> 'hidden',
		'description' => "<span class='customizer-upgraded-features'>Unlock Premium Customization Features:
		<a target='_blank' href='". esc_url(BLOOD_DONATION_CAMPAIGN_PREMIUM_PAGE) ." '>Upgrade to Pro</a></span>",
		'section' => 'blood_donation_campaign_single_post_settings'
	));

	//Page Settings
	$wp_customize->add_section('blood_donation_campaign_page_settings',array(
		'title' => __('Manage Page Section', 'blood-donation-campaign'),
		'priority' => null,
		'panel' => 'blood_donation_campaign_panel_area'
	));

	// Add Settings and Controls for Page Layout
	$wp_customize->add_setting('blood_donation_campaign_sidebar_page_layout',array(
		'default' => 'full',
			'sanitize_callback' => 'blood_donation_campaign_sanitize_choices'
	));
	$wp_customize->add_control('blood_donation_campaign_sidebar_page_layout',array(
		'type' => 'radio',
		'label'     => __('Theme Page Sidebar Position', 'blood-donation-campaign'),
		'section' => 'blood_donation_campaign_page_settings',
		'choices' => array(
			'left' => __('Left','blood-donation-campaign'),
			'right' => __('Right','blood-donation-campaign'),
			'full' => __('No Sidebar','blood-donation-campaign')
	),
	));	

	$wp_customize->add_setting( 'blood_donation_campaign_page_settings_upgraded_features',array(
		'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control('blood_donation_campaign_page_settings_upgraded_features', array(
		'type'=> 'hidden',
		'description' => "<span class='customizer-upgraded-features'>Unlock Premium Customization Features:
		<a target='_blank' href='". esc_url(BLOOD_DONATION_CAMPAIGN_PREMIUM_PAGE) ." '>Upgrade to Pro</a></span>",
		'section' => 'blood_donation_campaign_page_settings'
	));

	// 404 Page Settings
	$wp_customize->add_section('blood_donation_campaign_page_not_found', array(
		'title'	=> __('Manage 404 Page Section','blood-donation-campaign'),
		'priority'	=> null,
		'panel' => 'blood_donation_campaign_panel_area',
	));
	
	$wp_customize->add_setting('blood_donation_campaign_page_not_found_heading',array(
		'default'=> __('404 Not Found','blood-donation-campaign'),
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('blood_donation_campaign_page_not_found_heading',array(
		'label'	=> __('404 Heading','blood-donation-campaign'),
		'section'=> 'blood_donation_campaign_page_not_found',
		'type'=> 'text'
	));

	$wp_customize->add_setting('blood_donation_campaign_page_not_found_content',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));

	$wp_customize->add_control('blood_donation_campaign_page_not_found_content',array(
		'label'	=> __('404 Text','blood-donation-campaign'),
		'input_attrs' => array(
			'placeholder' => __( 'Looks like you have taken a wrong turn.....Don\'t worry... it happens to the best of us.', 'blood-donation-campaign' ),
		),
		'section'=> 'blood_donation_campaign_page_not_found',
		'type'=> 'text'
	));

	$wp_customize->add_setting('blood_donation_campaign_page_not_found_btn',array(
		'default' => 'Homepage',
		'sanitize_callback' => 'sanitize_text_field',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'blood_donation_campaign_page_not_found_btn', array(
	   'settings' => 'blood_donation_campaign_page_not_found_btn',
	   'section'   => 'blood_donation_campaign_page_not_found',
	   'label' => __('404 Button', 'blood-donation-campaign'),
	   'type'      => 'text'
	));

	$wp_customize->add_setting( 'blood_donation_campaign_not_found_settings_upgraded_features',array(
		'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control('blood_donation_campaign_not_found_settings_upgraded_features', array(
		'type'=> 'hidden',
		'description' => "<span class='customizer-upgraded-features'>Unlock Premium Customization Features:
		<a target='_blank' href='". esc_url(BLOOD_DONATION_CAMPAIGN_PREMIUM_PAGE) ." '>Upgrade to Pro</a></span>",
		'section' => 'blood_donation_campaign_page_not_found'
	));

	// Footer Section
	$wp_customize->add_section('blood_donation_campaign_footer', array(
		'title'	=> __('Manage Footer Section','blood-donation-campaign'),
		'description'	=> __('<p class="sec-title">Manage Footer Section</p>','blood-donation-campaign'),
		'priority'	=> null,
		'panel' => 'blood_donation_campaign_panel_area',
	));

	$wp_customize->add_setting('blood_donation_campaign_footer_widget', array(
	    'default' => true,
	    'sanitize_callback' => 'blood_donation_campaign_sanitize_checkbox',
	));
	$wp_customize->add_control('blood_donation_campaign_footer_widget', array(
	    'settings' => 'blood_donation_campaign_footer_widget',
	    'section'   => 'blood_donation_campaign_footer',
	    'label'     => __('Check to Enable Footer Widget', 'blood-donation-campaign'),
	    'type'      => 'checkbox',
	));

	//  footer bg color
	$wp_customize->add_setting('blood_donation_campaign_footerbg_color',array(
		'default' => '',
		'sanitize_callback' => 'blood_donation_campaign_sanitize_hex_color',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'blood_donation_campaign_footerbg_color', array(
		'settings' => 'blood_donation_campaign_footerbg_color',
		'section'   => 'blood_donation_campaign_footer',
		'label' => __('Footer Background Color', 'blood-donation-campaign'),
		'type'      => 'color'
	));

	$wp_customize->add_setting('blood_donation_campaign_footer_bg_image',array(
        'default'   => '',
        'sanitize_callback' => 'esc_url_raw',
    ));
    $wp_customize->add_control( new WP_Customize_Image_Control($wp_customize,'blood_donation_campaign_footer_bg_image',array(
        'label' => __('Footer Background Image','blood-donation-campaign'),
        'section' => 'blood_donation_campaign_footer',
    )));

	$wp_customize->add_setting('blood_donation_campaign_footer_img_position',array(
		'default' => 'center center',
		'transport' => 'refresh',
		'sanitize_callback' => 'blood_donation_campaign_sanitize_choices'
	));
	$wp_customize->add_control('blood_donation_campaign_footer_img_position',array(
		'type' => 'select',
		'label' => __('Footer Image Position','blood-donation-campaign'),
		'section' => 'blood_donation_campaign_footer',
		'choices' 	=> array(
			'center center'   => esc_html__( 'Center', 'blood-donation-campaign' ),
			'center top'   => esc_html__( 'Top', 'blood-donation-campaign' ),
			'left center'   => esc_html__( 'Left', 'blood-donation-campaign' ),
			'right center'   => esc_html__( 'Right', 'blood-donation-campaign' ),
			'center bottom'   => esc_html__( 'Bottom', 'blood-donation-campaign' ),
		),
	));	

	$wp_customize->add_setting('blood_donation_campaign_footer_widget_areas',array(
		'default'           => 4,
		'sanitize_callback' => 'blood_donation_campaign_sanitize_choices',
	));
	$wp_customize->add_control('blood_donation_campaign_footer_widget_areas',array(
		'type'        => 'radio',
		'section' => 'blood_donation_campaign_footer',
		'label'       => __('Footer widget area', 'blood-donation-campaign'),
		'choices' => array(
		   '1'     => __('One', 'blood-donation-campaign'),
		   '2'     => __('Two', 'blood-donation-campaign'),
		   '3'     => __('Three', 'blood-donation-campaign'),
		   '4'     => __('Four', 'blood-donation-campaign')
		),
	));

	$wp_customize->add_setting('blood_donation_campaign_copyright_line',array(
		'default' => '',
		'sanitize_callback' => 'sanitize_text_field',
	));
	$wp_customize->add_control( 'blood_donation_campaign_copyright_line', array(
	   'section' 	=> 'blood_donation_campaign_footer',
	   'label'	 	=> __('Copyright Line','blood-donation-campaign'),
	   'type'    	=> 'text',
	   'priority' 	=> null,
    ));

	$wp_customize->add_setting('blood_donation_campaign_copyright_link',array(
    	'default' => '',
		'sanitize_callback' => 'sanitize_text_field',
	));
	$wp_customize->add_control( 'blood_donation_campaign_copyright_link', array(
	   'section' 	=> 'blood_donation_campaign_footer',
	   'label'	 	=> __('Copyright Link','blood-donation-campaign'),
	   'type'    	=> 'text',
	   'priority' 	=> null,
    ));

	//  footer title color
	$wp_customize->add_setting('blood_donation_campaign_footertitle_color',array(
		'default' => '',
		'sanitize_callback' => 'blood_donation_campaign_sanitize_hex_color',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'blood_donation_campaign_footertitle_color', array(
	   'settings' => 'blood_donation_campaign_footertitle_color',
	   'section'   => 'blood_donation_campaign_footer',
	   'label' => __('Title Color', 'blood-donation-campaign'),
	   'type'      => 'color'
	));

	//  footer list color
	$wp_customize->add_setting('blood_donation_campaign_footerlist_color',array(
		'default' => '',
		'sanitize_callback' => 'blood_donation_campaign_sanitize_hex_color',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'blood_donation_campaign_footerlist_color', array(
	   'settings' => 'blood_donation_campaign_footerlist_color',
	   'section'   => 'blood_donation_campaign_footer',
	   'label' => __('List Color', 'blood-donation-campaign'),
	   'type'      => 'color'
	));

	$wp_customize->add_setting('blood_donation_campaign_scroll_hide', array(
        'default' => true,
        'sanitize_callback' => 'blood_donation_campaign_sanitize_checkbox'
    ));
    $wp_customize->add_control( new WP_Customize_Control($wp_customize,'blood_donation_campaign_scroll_hide',array(
        'label'          => __( 'Check To Show Scroll To Top', 'blood-donation-campaign' ),
        'section'        => 'blood_donation_campaign_footer',
        'settings'       => 'blood_donation_campaign_scroll_hide',
        'type'           => 'checkbox',
    )));

	$wp_customize->add_setting('blood_donation_campaign_scroll_position',array(
        'default' => 'Right',
        'sanitize_callback' => 'blood_donation_campaign_sanitize_choices'
    ));
    $wp_customize->add_control('blood_donation_campaign_scroll_position',array(
        'type' => 'radio',
        'section' => 'blood_donation_campaign_footer',
        'label'	 	=> __('Scroll To Top Positions','blood-donation-campaign'),
        'choices' => array(
            'Right' => __('Right','blood-donation-campaign'),
            'Left' => __('Left','blood-donation-campaign'),
            'Center' => __('Center','blood-donation-campaign')
        ),
    ) );

	$wp_customize->add_setting('blood_donation_campaign_scroll_text',array(
		'default'	=> __('TOP','blood-donation-campaign'),
		'sanitize_callback'	=> 'sanitize_text_field',
	));	
	$wp_customize->add_control('blood_donation_campaign_scroll_text',array(
		'label'	=> __('Scroll To Top Button Text','blood-donation-campaign'),
		'section'	=> 'blood_donation_campaign_footer',
		'type'		=> 'text'
	));

	$wp_customize->add_setting( 'blood_donation_campaign_scroll_top_shape', array(
		'default'           => 'circle',
		'sanitize_callback' => 'sanitize_text_field',
	) );
	
	$wp_customize->add_control( 'blood_donation_campaign_scroll_top_shape', array(
		'label'    => __( 'Scroll to Top Button Shape', 'blood-donation-campaign' ),
		'section'  => 'blood_donation_campaign_footer',
		'settings' => 'blood_donation_campaign_scroll_top_shape',
		'type'     => 'radio',
		'choices'  => array(
			'box'        => __( 'Box', 'blood-donation-campaign' ),
			'curved' => __( 'Curved', 'blood-donation-campaign'),
			'circle'     => __( 'Circle', 'blood-donation-campaign' ),
		),
	) );

	$wp_customize->add_setting( 'blood_donation_campaign_scroll_top_settings_upgraded_features',array(
		'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control('blood_donation_campaign_scroll_top_settings_upgraded_features', array(
		'type'=> 'hidden',
		'description' => "<span class='customizer-upgraded-features'>Unlock Premium Customization Features:
		<a target='_blank' href='". esc_url(BLOOD_DONATION_CAMPAIGN_PREMIUM_PAGE) ." '>Upgrade to Pro</a></span>",
		'section' => 'blood_donation_campaign_footer'
	));

	// Footer Social Section
	$wp_customize->add_section('blood_donation_campaign_footer_social_icons', array(
		'title'	=> __('Manage Footer Social Section','blood-donation-campaign'),
		'description'	=> __('<p class="sec-title">Manage Footer Social Section</p>','blood-donation-campaign'),
		'priority'	=> null,
		'panel' => 'blood_donation_campaign_panel_area',
	));

	$wp_customize->add_setting('blood_donation_campaign_footer_facebook_link',array(
		'default' => '',
		'sanitize_callback' => 'esc_url_raw',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'blood_donation_campaign_footer_facebook_link', array(
		'settings' => 'blood_donation_campaign_footer_facebook_link',
		'section'   => 'blood_donation_campaign_footer_social_icons',
		'label' => __('Facebook Link', 'blood-donation-campaign'),
		'type'      => 'url'
	));

	$wp_customize->add_setting('blood_donation_campaign_footer_instagram_link',array(
		'default' => '',
		'sanitize_callback' => 'esc_url_raw',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'blood_donation_campaign_footer_instagram_link', array(
		'settings' => 'blood_donation_campaign_footer_instagram_link',
		'section'   => 'blood_donation_campaign_footer_social_icons',
		'label' => __('Instagram Link', 'blood-donation-campaign'),
		'type'      => 'url'
	));

	$wp_customize->add_setting('blood_donation_campaign_footer_pinterest_link',array(
		'default' => '',
		'sanitize_callback' => 'esc_url_raw',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'blood_donation_campaign_footer_pinterest_link', array(
		'settings' => 'blood_donation_campaign_footer_pinterest_link',
		'section'   => 'blood_donation_campaign_footer_social_icons',
		'label' => __('Pinterest Link', 'blood-donation-campaign'),
		'type'      => 'url'
	));

	$wp_customize->add_setting('blood_donation_campaign_footer_twitter_link',array(
		'default' => '',
		'sanitize_callback' => 'esc_url_raw',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'blood_donation_campaign_footer_twitter_link', array(
		'settings' => 'blood_donation_campaign_footer_twitter_link',
		'section'   => 'blood_donation_campaign_footer_social_icons',
		'label' => __('Twitter Link', 'blood-donation-campaign'),
		'type'      => 'url'
	));

	$wp_customize->add_setting('blood_donation_campaign_footer_youtube_link',array(
		'default' => '',
		'sanitize_callback' => 'esc_url_raw',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'blood_donation_campaign_footer_youtube_link', array(
		'settings' => 'blood_donation_campaign_footer_youtube_link',
		'section'   => 'blood_donation_campaign_footer_social_icons',
		'label' => __('Youtube Link', 'blood-donation-campaign'),
		'type'      => 'url'
	));

	$wp_customize->add_setting( 'blood_donation_campaign_social_settings_upgraded_features',array(
		'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control('blood_donation_campaign_social_settings_upgraded_features', array(
		'type'=> 'hidden',
		'description' => "<span class='customizer-upgraded-features'>Unlock Premium Customization Features:
		<a target='_blank' href='". esc_url(BLOOD_DONATION_CAMPAIGN_PREMIUM_PAGE) ." '>Upgrade to Pro</a></span>",
		'section' => 'blood_donation_campaign_footer_social_icons'
	));

	// Google Fonts
	$wp_customize->add_section( 'blood_donation_campaign_google_fonts_section', array(
		'title'       => __( 'Google Fonts', 'blood-donation-campaign' ),
		'priority'    => 24,
	) );

	$font_choices = array(
		'' => 'No Fonts',
		'Kaushan Script:' => 'Kaushan Script',
		'Emilys Candy:' => 'Emilys Candy',
		'Poppins:0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900' => 'Poppins',
		'Source Sans Pro:400,700,400italic,700italic' => 'Source Sans Pro',
		'Open Sans:400italic,700italic,400,700' => 'Open Sans',
		'Oswald:400,700' => 'Oswald',
		'Playfair Display:400,700,400italic' => 'Playfair Display',
		'Montserrat:400,700' => 'Montserrat',
		'Raleway:400,700' => 'Raleway',
		'Droid Sans:400,700' => 'Droid Sans',
		'Lato:400,700,400italic,700italic' => 'Lato',
		'Arvo:400,700,400italic,700italic' => 'Arvo',
		'Lora:400,700,400italic,700italic' => 'Lora',
		'Merriweather:400,300italic,300,400italic,700,700italic' => 'Merriweather',
		'Oxygen:400,300,700' => 'Oxygen',
		'PT Serif:400,700' => 'PT Serif',
		'PT Sans:400,700,400italic,700italic' => 'PT Sans',
		'PT Sans Narrow:400,700' => 'PT Sans Narrow',
		'Cabin:400,700,400italic' => 'Cabin',
		'Fjalla One:400' => 'Fjalla One',
		'Francois One:400' => 'Francois One',
		'Josefin Sans:400,300,600,700' => 'Josefin Sans',
		'Libre Baskerville:400,400italic,700' => 'Libre Baskerville',
		'Arimo:400,700,400italic,700italic' => 'Arimo',
		'Ubuntu:400,700,400italic,700italic' => 'Ubuntu',
		'Bitter:400,700,400italic' => 'Bitter',
		'Droid Serif:400,700,400italic,700italic' => 'Droid Serif',
		'Roboto:400,400italic,700,700italic' => 'Roboto',
		'Open Sans Condensed:700,300italic,300' => 'Open Sans Condensed',
		'Roboto Condensed:400italic,700italic,400,700' => 'Roboto Condensed',
		'Roboto Slab:400,700' => 'Roboto Slab',
		'Yanone Kaffeesatz:400,700' => 'Yanone Kaffeesatz',
		'Rokkitt:400' => 'Rokkitt',
	);

	$wp_customize->add_setting( 'blood_donation_campaign_headings_fonts', array(
		'sanitize_callback' => 'blood_donation_campaign_sanitize_fonts',
	));
	$wp_customize->add_control( 'blood_donation_campaign_headings_fonts', array(
		'type' => 'select',
		'description' => __('Select your desired font for the headings.', 'blood-donation-campaign'),
		'section' => 'blood_donation_campaign_google_fonts_section',
		'choices' => $font_choices
	));

	$wp_customize->add_setting( 'blood_donation_campaign_body_fonts', array(
		'sanitize_callback' => 'blood_donation_campaign_sanitize_fonts'
	));
	$wp_customize->add_control( 'blood_donation_campaign_body_fonts', array(
		'type' => 'select',
		'description' => __( 'Select your desired font for the body.', 'blood-donation-campaign' ),
		'section' => 'blood_donation_campaign_google_fonts_section',
		'choices' => $font_choices
	));
  
}
add_action( 'customize_register', 'blood_donation_campaign_customize_register' );

/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function blood_donation_campaign_customize_preview_js() {
	wp_enqueue_script( 'blood_donation_campaign_customizer', esc_url(get_template_directory_uri()) . '/js/customize-preview.js', array( 'customize-preview' ), '20161510', true );
}
add_action( 'customize_preview_init', 'blood_donation_campaign_customize_preview_js' );
