<?php
/**
 * @package Blood Donation Campaign
 * Setup the WordPress core custom header feature.
 *
 * @uses blood_donation_campaign_header_style()
 */
function blood_donation_campaign_custom_header_setup() {
	add_theme_support( 'custom-header', apply_filters( 'blood_donation_campaign_custom_header_args', array(
		'default-text-color'     => 'fff',
		'width'                  => 2500,
		'height'                 => 300,
		'wp-head-callback'       => 'blood_donation_campaign_header_style',
	) ) );
}
add_action( 'after_setup_theme', 'blood_donation_campaign_custom_header_setup' );

if ( ! function_exists( 'blood_donation_campaign_header_style' ) ) :
/**
 * Styles the header image and text displayed on the blog
 *
 * @see blood_donation_campaign_custom_header_setup().
 */
function blood_donation_campaign_header_style() {
    $blood_donation_campaign_header_image = get_header_image() ?: get_template_directory_uri() . '/images/headerimg.png';

    $blood_donation_campaign_custom_css = "
        .box-image .single-page-img {
            background-image: url('{$blood_donation_campaign_header_image}');
            background-repeat: no-repeat;
            background-position: center bottom;
            background-size: cover !important;
            height: 300px;
        }

        h1.site-title a, p.site-title a {
            color: " . esc_attr(get_theme_mod('blood_donation_campaign_sitetitle_color')) . " !important;
        }

        .site-description {
            color: " . esc_attr(get_theme_mod('blood_donation_campaign_sitetagline_color')) . " !important;
        }

        .main-nav ul li a {
            color: " . esc_attr(get_theme_mod('blood_donation_campaign_menu_color')) . " !important;
        }

        .main-nav a:hover {
            color: " . esc_attr(get_theme_mod('blood_donation_campaign_menuhrv_color')) . " !important;
        }

        .main-nav ul ul a {
            color: " . esc_attr(get_theme_mod('blood_donation_campaign_submenu_color')) . " !important;
        }

        .main-nav ul ul a:hover {
            color: " . esc_attr(get_theme_mod('blood_donation_campaign_submenuhrv_color')) . " !important;
        }

        #footer h3 {
            color: " . esc_attr(get_theme_mod('blood_donation_campaign_footertitle_color')) . " !important;
        }

        #footer ul li a {
            color: " . esc_attr(get_theme_mod('blood_donation_campaign_footerlist_color')) . ";
        }

        #footer {
            background-color: " . esc_attr(get_theme_mod('blood_donation_campaign_footerbg_color')) . ";
        }
    ";

    // Attach to your main stylesheet (make sure this handle matches the one you registered)
    wp_add_inline_style('blood-donation-campaign-style', $blood_donation_campaign_custom_css);
}
endif;
add_action('wp_enqueue_scripts', 'blood_donation_campaign_header_style');