<?php
/*
 * @package Blood Donation Campaign
 */


 function blood_donation_campaign_admin_enqueue_scripts() {
    wp_enqueue_style( 'blood-donation-campaign-admin-style', esc_url( get_template_directory_uri() ).'/css/addon.css' );

    // Admin notice code START
	wp_register_script('blood-donation-campaign-notice', esc_url(get_template_directory_uri()) . '/js/notice.js', array('jquery'), time(), true);
	wp_enqueue_script('blood-donation-campaign-notice');
	// Admin notice code END
}
add_action( 'admin_enqueue_scripts', 'blood_donation_campaign_admin_enqueue_scripts' );

function blood_donation_campaign_theme_info_menu_link() {

    $blood_donation_campaign_theme = wp_get_theme();
    add_theme_page(
        /* translators: 1: Theme name. */
        sprintf( esc_html__( 'Welcome to %1$s', 'blood-donation-campaign' ), $blood_donation_campaign_theme->get( 'Name' )),
        esc_html__( 'Theme Demo Import', 'blood-donation-campaign' ),
        'edit_theme_options',
        'blood-donation-campaign',
        'blood_donation_campaign_theme_info_page'
    );
}
add_action( 'admin_menu', 'blood_donation_campaign_theme_info_menu_link' );

function blood_donation_campaign_theme_info_page() {

    $blood_donation_campaign_theme = wp_get_theme();
    ?>
<div class="wrap theme-info-wrap">
    <h1><?php printf( esc_html__( 'Welcome to %1$s', 'blood-donation-campaign' ), esc_html($blood_donation_campaign_theme->get( 'Name' ))); ?>
    </h1>
    <p class="theme-description">
    <?php esc_html_e( 'Do you want to configure this theme? Look no further, our easy-to-follow theme documentation will walk you through it.', 'blood-donation-campaign' ); ?>
    </p>
    <div class="columns-wrapper clearfix theme-demo">
        <div class="column column-quarter clearfix start-box"> 
            <div class="demo-import">
                <div class="theme-name">
                    <h2><?php echo esc_html( $blood_donation_campaign_theme->get( 'Name' ) ); ?></h2>
                    <p class="version"><?php esc_html_e( 'Version', 'blood-donation-campaign' ); ?>: <?php echo esc_html( wp_get_theme()->get( 'Version' ) ); ?></p>	
                </div>
                <?php
                    $blood_donation_campaign_demo_content_file = apply_filters(
                        'blood_donation_campaign_demo_content_path',
                        get_parent_theme_file_path( '/inc/demo-content.php' )
                    );
                    require $blood_donation_campaign_demo_content_file;             
                ?>               
                <div id="demo-import-loader">
                    <img src="<?php echo esc_url(get_template_directory_uri() . '/images/status.gif'); ?>" alt="<?php echo esc_attr( 'Loading...', 'blood-donation-campaign'); ?>" />
                </div>
            </div>
        </div>
        <div class="column column-half clearfix">
            <div class="important-link">
                <div class="main-box columns-wrapper clearfix">

                    <div class="themelink column column-half column-border clearfix">
                        <p><strong><?php esc_html_e( 'Free Theme Documentation', 'blood-donation-campaign' ); ?></strong></p>
                        <p><?php esc_html_e( 'Need more details? Please check our full documentation for detailed theme setup.', 'blood-donation-campaign' ); ?></p>
                        <a href="<?php echo esc_url( BLOOD_DONATION_CAMPAIGN_THEME_DOCUMENTATION ); ?>" target="_blank">
                        <?php esc_html_e( 'Documentation', 'blood-donation-campaign' ); ?>
                        </a>
                    </div>

                    <div class="themelink column column-half column-padding clearfix">
                        <p><strong><?php esc_html_e( 'Need Help?', 'blood-donation-campaign' ); ?></strong></p>
                        <p><?php esc_html_e( 'Go to our support forum to help you out in case of queries and doubts regarding our theme.', 'blood-donation-campaign' ); ?></p>
                        <a href="<?php echo esc_url( BLOOD_DONATION_CAMPAIGN_SUPPORT ); ?>" target="_blank">
                        <?php esc_html_e( 'Contact Us', 'blood-donation-campaign' ); ?>
                        </a>
                    </div>
                </div>
                <hr>
                <div class="main-box columns-wrapper clearfix">

                    <div class="themelink column column-half column-border clearfix">
                        <p><strong><?php esc_html_e( 'Pro version of our theme', 'blood-donation-campaign' ); ?></strong></p>
                        <p><?php esc_html_e( 'Are you excited for our theme? Then we will proceed for pro version of theme.', 'blood-donation-campaign' ); ?></p>
                        <a class="get-premium" href="<?php echo esc_url( BLOOD_DONATION_CAMPAIGN_PREMIUM_PAGE ); ?>" target="_blank">
                        <?php esc_html_e( 'Get Premium', 'blood-donation-campaign' ); ?>
                        </a>
                    </div>

                    <div class="themelink column column-half column-padding clearfix">
                        <p><strong><?php esc_html_e( 'Leave us a review', 'blood-donation-campaign' ); ?></strong></p>
                        <p><?php esc_html_e( 'Are you enjoying our theme? We would love to hear your feedback.', 'blood-donation-campaign' ); ?></p>
                        <a href="<?php echo esc_url( BLOOD_DONATION_CAMPAIGN_REVIEW ); ?>" target="_blank">
                        <?php esc_html_e( 'Rate This Theme', 'blood-donation-campaign' ); ?>
                        </a>
                    </div>

                </div>
            </div>
        </div>
        <div class="column column-quarter clearfix start-box"> 
            <div class="bundle-info">
                <img src="<?php echo esc_url( get_template_directory_uri().'/images/bundle.png'); ?>" alt="<?php echo esc_attr( 'screenshot', 'blood-donation-campaign'); ?>" class="bundle-image"/>
                <div class="bundle-content themelink">
                    <h3><?php esc_html_e( 'WordPress Theme Bundle', 'blood-donation-campaign' ); ?></h3>
                    <small><b><?php esc_html_e( 'Get access to a collection of 100+ stunning WordPress themes for just $99 — featuring designs for every business niche!', 'blood-donation-campaign' ); ?></small></b>
                    <a class="get-premium" href="<?php echo esc_url( BLOOD_DONATION_CAMPAIGN_BUNDLE_PAGE ); ?>" target="_blank">
                    <?php esc_html_e( 'Get Bundle at 20% OFF', 'blood-donation-campaign' ); ?>
                    </a>
                </div>
            </div>
        </div>
    </div>
    <div id="getting-started">
        <div class="section">
            <h3><?php 
            /* translators: %s: Theme name. */
            printf( esc_html__( 'Getting started with %s', 'blood-donation-campaign' ),
            esc_html($blood_donation_campaign_theme->get( 'Name' ))); ?></h3>
            <div class="columns-wrapper clearfix">
                <div class="column column-half clearfix">
                    <div class="section themelink">
                        <div class="">
                            <a class="" href="<?php echo esc_url( BLOOD_DONATION_CAMPAIGN_PREMIUM_PAGE ); ?>" target="_blank"><?php esc_html_e( 'Get Premium', 'blood-donation-campaign' ); ?></a>
                            <a href="<?php echo esc_url( BLOOD_DONATION_CAMPAIGN_PRO_DEMO ); ?>" target="_blank"><?php esc_html_e( 'View Demo', 'blood-donation-campaign' ); ?></a>
                            <a class="get-premium" href="<?php echo esc_url( BLOOD_DONATION_CAMPAIGN_BUNDLE_PAGE ); ?>" target="_blank"><?php esc_html_e( 'Bundle of 100+ Themes at $99', 'blood-donation-campaign' ); ?></a>
                        </div>
                        <div class="theme-description-1"><?php echo esc_html($blood_donation_campaign_theme->get( 'Description' )); ?></div>
                    </div>
                </div>
                <div class="column column-half clearfix">
                    <img src="<?php echo esc_url( $blood_donation_campaign_theme->get_screenshot() ); ?>" alt="<?php echo esc_attr( 'screenshot', 'blood-donation-campaign'); ?>"/>
                </div>
            </div>
        </div>
    </div>
    <hr>
    <div id="theme-author">
      <p><?php
        /* translators: 1: Theme name, 2: Author name, 3: Call to action text. */
        printf( esc_html__( '%1$s is proudly brought to you by %2$s. If you like this theme, %3$s :)', 'blood-donation-campaign' ),
            esc_html($blood_donation_campaign_theme->get( 'Name' )),
            '<a target="_blank" href="' . esc_url( 'https://www.theclassictemplates.com/', 'blood-donation-campaign' ) . '">classictemplate</a>',
            '<a target="_blank" href="' . esc_url(BLOOD_DONATION_CAMPAIGN_REVIEW ) . '" title="' . esc_attr__( 'Rate it', 'blood-donation-campaign' ) . '">' . esc_html_x( 'rate it', 'If you like this theme, rate it', 'blood-donation-campaign' ) . '</a>'
        );
        ?></p>
    </div>
</div>
<?php
}
?>