<?php
/**
 * The Header for our theme.
 *
 * Displays all of the <head> section and everything up till <div class="container">
 *
 * @package Blood Donation Campaign
 */
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1">
<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>

<?php if ( function_exists( 'wp_body_open' ) ) {
  wp_body_open();
} else {
  do_action( 'wp_body_open' );
} ?>

<?php if ( get_theme_mod('blood_donation_campaign_preloader', false) != "") { ?>
  <div id="preloader">
    <div id="status">&nbsp;</div>
  </div>
<?php }?>

<a class="screen-reader-text skip-link" href="#content"><?php esc_html_e( 'Skip to content', 'blood-donation-campaign' ); ?></a>

<div id="pageholder" <?php if( get_theme_mod( 'blood_donation_campaign_box_layout', false) != "" ) { echo 'class="boxlayout"'; } ?>>

<div class="mainhead<?php if( get_theme_mod( 'blood_donation_campaign_stickyheader', false) == 1) { ?> is-sticky-on"<?php } else { ?>close-sticky <?php } ?>">
  <div class="main-header">
    <?php if ( get_theme_mod('blood_donation_campaign_enable_topbar', false)) { ?>
      <div class="topbar">
        <div class="container">
          <div class="row">
            <div class="col-xxl-9 col-xl-9 col-lg-9 col-md-9 col-12 topbar-left">
              <div class="row py-2">
                <div class="col-xxl-2 col-xl-2 col-lg-2 col-md-5 col-sm-6 col-12 align-self-center top-phone">
                  <?php if ( get_theme_mod('blood_donation_campaign_phone_number')) { ?>
                    <a class="phone-no" href="tel:<?php echo esc_attr( get_theme_mod('blood_donation_campaign_phone_number')); ?>"><i class="fa-solid fa-phone-volume me-2"></i><?php echo esc_html(get_theme_mod ('blood_donation_campaign_phone_number')); ?></a>
                  <?php } ?>
                </div>
                <div class="col-xxl-3 col-xl-3 col-lg-3 col-md-7 col-sm-6 col-12 align-self-center top-mail text-center">
                  <?php if ( get_theme_mod('blood_donation_campaign_email_address')) { ?>
                    <a class="mail" href="mailto:<?php echo esc_attr( get_theme_mod('blood_donation_campaign_email_address') ); ?>"><i class="fa-solid fa-envelope me-2"></i><?php echo esc_html(get_theme_mod ('blood_donation_campaign_email_address')); ?></a>
                  <?php } ?>
                </div>
                <div class="col-xxl-7 col-xl-7 col-lg-7 col-md-12 col-sm-12 col-12 align-self-center top-main-text">
                  <?php if (get_theme_mod('blood_donation_campaign_topbar_text') != "") { ?>
                    <p class="topbar-text mb-0 text-capitalize"><i class="fa-solid fa-bullhorn me-2"></i><?php echo esc_html(get_theme_mod('blood_donation_campaign_topbar_text')); ?></p>
                  <?php } ?>
                </div>
              </div>
            </div>
            <div class="col-xxl-3 col-xl-3 col-lg-3 col-md-3 col-12 d-flex justify-content-lg-end justify-content-md-end justify-content-center gap-3 align-items-center header-social-icons">
              <?php if ( get_theme_mod('blood_donation_campaign_facebook_url')) { ?>
                <a href="<?php echo esc_url(get_theme_mod ('blood_donation_campaign_facebook_url')); ?>" target="_blank" class="text-capitalize"><i class="fa-brands fa-facebook"></i></a>
              <?php }?>
              <?php if ( get_theme_mod('blood_donation_campaign_instagram_url')) { ?>
                <a href="<?php echo esc_url(get_theme_mod ('blood_donation_campaign_instagram_url')); ?>" target="_blank" class="text-capitalize"><i class="fa-brands fa-square-instagram"></i></a>
              <?php }?>
              <?php if ( get_theme_mod('blood_donation_campaign_twitter_url')) { ?>
                <a href="<?php echo esc_url(get_theme_mod ('blood_donation_campaign_twitter_url')); ?>" target="_blank" class="text-capitalize"><i class="fa-brands fa-square-x-twitter"></i></a>
              <?php }?>
              <?php if ( get_theme_mod('blood_donation_campaign_youtube_url')) { ?>
                <a href="<?php echo esc_url(get_theme_mod ('blood_donation_campaign_youtube_url')); ?>" target="_blank" class="text-capitalize"><i class="fa-brands fa-square-youtube"></i></a>
              <?php }?>
              <?php if ( get_theme_mod('blood_donation_campaign_pinterest_url')) { ?>
                <a href="<?php echo esc_url(get_theme_mod ('blood_donation_campaign_pinterest_url')); ?>" target="_blank" class="text-capitalize"><i class="fa-brands fa-pinterest"></i></a>
              <?php }?>
            </div>
          </div>
        </div>
      </div>
    <?php }?>
    <div class="bottom-header">
      <div class="container">
        <div class="row">
          <div class="col-xxl-2 col-xl-2 col-lg-2 col-md-4 col-sm-12 col-12 logo-box py-1 text-lg-start text-md-start text-center">
            <div class="logo">
              <?php if (get_theme_mod('blood_donation_campaign_logo_enable', true)) { ?>
                <?php blood_donation_campaign_the_custom_logo(); ?>
              <?php } ?>
              <div class="site-branding-text">
                <?php if (get_theme_mod('blood_donation_campaign_title_enable', false)) { ?>
                  <?php if (is_front_page() && is_home()) : ?>
                    <h1 class="site-title"><a href="<?php echo esc_url(home_url('/')); ?>"><?php bloginfo('name'); ?></a></h1>
                  <?php else : ?>
                    <p class="site-title"><a href="<?php echo esc_url(home_url('/')); ?>"><?php bloginfo('name'); ?></a></p>
                  <?php endif; ?>
                <?php } ?>
                <?php $blood_donation_campaign_description = get_bloginfo('description', 'display');
                if ($blood_donation_campaign_description || is_customize_preview()) : ?>
                  <?php if (get_theme_mod('blood_donation_campaign_tagline_enable', false)) { ?>
                    <span class="site-description"><?php echo esc_html($blood_donation_campaign_description); ?></span>
                  <?php } ?>
                <?php endif; ?>
              </div>
            </div>
          </div>
          <div class="col-xxl-8 col-xl-8 col-lg-8 col-md-3 col-sm-6 col-12 main-menu-box text-center align-self-center">
            <div class="menu-sec">
              <div class="toggle-nav text-center">
                <?php if (has_nav_menu('primary')) { ?>
                  <button role="tab"><?php esc_html_e('Menu', 'blood-donation-campaign'); ?></button>
                <?php } ?>
              </div>
              <div id="mySidenav" class="nav sidenav">
                <nav id="site-navigation" class="main-nav" role="navigation" aria-label="<?php esc_attr_e('Top Menu', 'blood-donation-campaign'); ?>">
                  <ul class="mobile_nav">
                    <?php wp_nav_menu(array(
                      'theme_location' => 'primary',
                      'container_class' => 'main-menu',
                      'items_wrap' => '%3$s',
                      'fallback_cb' => 'wp_page_menu',
                    )); ?>
                  </ul>
                  <a href="javascript:void(0)" class="close-button"><?php esc_html_e('CLOSE', 'blood-donation-campaign'); ?></a>
                </nav>
              </div>
            </div>
          </div>
          <div class="col-xxl-2 col-xl-2 col-lg-2 col-md-5 col-sm-6 col-12 align-self-center header-btn text-lg-end text-md-end text-center">
            <?php if ( get_theme_mod('blood_donation_campaign_header_btn_text') || get_theme_mod('blood_donation_campaign_header_btn_url')) { ?>  
              <a href="<?php echo esc_url(get_theme_mod ('blood_donation_campaign_header_btn_url')); ?>" class="text-capitalize position-relative"><?php echo esc_html(get_theme_mod ('blood_donation_campaign_header_btn_text')); ?></a>
            <?php }?>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>