<?php
/**
 * The template for displaying the footer.
 *
 * Contains the closing of the #content div and all content after
 *
 * @package Blood Donation Campaign
 */
?>
<div id="footer">
  <?php 
    $blood_donation_campaign_footer_widget_enabled = get_theme_mod('blood_donation_campaign_footer_widget', true);
    if ($blood_donation_campaign_footer_widget_enabled !== false && $blood_donation_campaign_footer_widget_enabled !== '') { ?>
    <?php 
        $blood_donation_campaign_widget_areas = get_theme_mod('blood_donation_campaign_footer_widget_areas', '4');
        if ($blood_donation_campaign_widget_areas == '3') {
            $blood_donation_campaign_cols = 'col-lg-4 col-md-6';
        } elseif ($blood_donation_campaign_widget_areas == '4') {
            $blood_donation_campaign_cols = 'col-lg-3 col-md-6';
        } elseif ($blood_donation_campaign_widget_areas == '2') {
            $blood_donation_campaign_cols = 'col-lg-6 col-md-6';
        } else {
            $blood_donation_campaign_cols = 'col-lg-12 col-md-12';
        }
    ?>
    <div class="footer-widget">
        <div class="container">
          <div class="row wow bounceInUp delay-3000" data-wow-duration="2s">
            <!-- Footer 1 -->
            <div class="<?php echo esc_attr($blood_donation_campaign_cols); ?> footer-block">
                <?php if (is_active_sidebar('footer-1')) : ?>
                    <?php dynamic_sidebar('footer-1'); ?>
                <?php else : ?>
                    <aside id="categories" class="widget py-3" role="complementary" aria-label="<?php esc_attr_e('footer1', 'blood-donation-campaign'); ?>">
                        <h3 class="widget-title"><?php esc_html_e('Categories', 'blood-donation-campaign'); ?></h3>
                        <ul>
                            <?php wp_list_categories('title_li='); ?>
                        </ul>
                    </aside>
                <?php endif; ?>
            </div>

            <!-- Footer 2 -->
            <div class="<?php echo esc_attr($blood_donation_campaign_cols); ?> footer-block">
                <?php if (is_active_sidebar('footer-2')) : ?>
                    <?php dynamic_sidebar('footer-2'); ?>
                <?php else : ?>
                    <aside id="archives" class="widget py-3" role="complementary" aria-label="<?php esc_attr_e('footer2', 'blood-donation-campaign'); ?>">
                        <h3 class="widget-title"><?php esc_html_e('Archives', 'blood-donation-campaign'); ?></h3>
                        <ul>
                            <?php wp_get_archives(array('type' => 'monthly')); ?>
                        </ul>
                    </aside>
                <?php endif; ?>
            </div>

            <!-- Footer 3 -->
            <div class="<?php echo esc_attr($blood_donation_campaign_cols); ?> footer-block">
                <?php if (is_active_sidebar('footer-3')) : ?>
                    <?php dynamic_sidebar('footer-3'); ?>
                <?php else : ?>
                    <aside id="meta" class="widget py-3" role="complementary" aria-label="<?php esc_attr_e('footer3', 'blood-donation-campaign'); ?>">
                        <h3 class="widget-title"><?php esc_html_e('Meta', 'blood-donation-campaign'); ?></h3>
                        <ul>
                            <?php wp_register(); ?>
                            <li><?php wp_loginout(); ?></li>
                            <?php wp_meta(); ?>
                        </ul>
                    </aside>
                <?php endif; ?>
            </div>

            <!-- Footer 4 -->
            <div class="<?php echo esc_attr($blood_donation_campaign_cols); ?> footer-block">
                <?php if (is_active_sidebar('footer-4')) : ?>
                    <?php dynamic_sidebar('footer-4'); ?>
                <?php else : ?>
                    <aside id="search-widget" class="widget py-3" role="complementary" aria-label="<?php esc_attr_e('footer4', 'blood-donation-campaign'); ?>">
                        <h3 class="widget-title"><?php esc_html_e('Search', 'blood-donation-campaign'); ?></h3>
                        <?php the_widget('WP_Widget_Search'); ?>
                    </aside>
                <?php endif; ?>
            </div>
          </div>
        </div>
    </div>

    <?php } ?>
    <div class="clear"></div>
    <div class="copywrap text-center">
        <?php $blood_donation_campaign_social_links_present = get_theme_mod('blood_donation_campaign_footer_facebook_link') || get_theme_mod('blood_donation_campaign_footer_instagram_link') || get_theme_mod('blood_donation_campaign_footer_pinterest_link') || get_theme_mod('blood_donation_campaign_footer_twitter_link') || get_theme_mod('blood_donation_campaign_footer_youtube_link'); ?>
        <div class="container copywrap-info <?php echo $blood_donation_campaign_social_links_present ? '' : 'center-content'; ?>">
            <p>
                <a href="<?php 
                $blood_donation_campaign_copyright_link = get_theme_mod('blood_donation_campaign_copyright_link', '');
                if (empty($blood_donation_campaign_copyright_link)) {
                    echo esc_url('https://www.theclassictemplates.com/products/blood-donation-campaign');
                } else {
                    echo esc_url($blood_donation_campaign_copyright_link);
                } ?>" target="_blank">
                <?php echo esc_html(get_theme_mod('blood_donation_campaign_copyright_line', __('Blood Donation Campaign Theme', 'blood-donation-campaign'))); ?>
                </a> 
                <?php echo esc_html('By Classic Templates', 'blood-donation-campaign'); ?>
            </p>
            <?php if ( $blood_donation_campaign_social_links_present ) { ?>
                <div class="footer-social d-flex gap-3">
                    <?php if ( get_theme_mod('blood_donation_campaign_footer_facebook_link') ) { ?>
                        <a title="<?php echo esc_attr('facebook', 'blood-donation-campaign'); ?>" target="_blank" href="<?php echo esc_url(get_theme_mod('blood_donation_campaign_footer_facebook_link')); ?>"><i class="fa-brands fa-facebook-f"></i></a> 
                    <?php } ?>
                    <?php if ( get_theme_mod('blood_donation_campaign_footer_instagram_link') ) { ?> 
                        <a title="<?php echo esc_attr('instagram', 'blood-donation-campaign'); ?>" target="_blank" href="<?php echo esc_url(get_theme_mod('blood_donation_campaign_footer_instagram_link')); ?>"><i class="fa-brands fa-instagram"></i></a>
                    <?php } ?>
                    <?php if ( get_theme_mod('blood_donation_campaign_footer_pinterest_link') ) { ?>
                        <a title="<?php echo esc_attr('pinterest', 'blood-donation-campaign'); ?>" target="_blank" href="<?php echo esc_url(get_theme_mod('blood_donation_campaign_footer_pinterest_link')); ?>"><i class="fa-brands fa-pinterest"></i></a>
                    <?php } ?>
                    <?php if ( get_theme_mod('blood_donation_campaign_footer_twitter_link') ) { ?> 
                        <a title="<?php echo esc_attr('twitter', 'blood-donation-campaign'); ?>" target="_blank" href="<?php echo esc_url(get_theme_mod('blood_donation_campaign_footer_twitter_link')); ?>"><i class="fa-brands fa-twitter"></i></a>
                    <?php } ?>
                    <?php if ( get_theme_mod('blood_donation_campaign_footer_youtube_link') ) { ?>
                        <a title="<?php echo esc_attr('youtube', 'blood-donation-campaign'); ?>" target="_blank" href="<?php echo esc_url(get_theme_mod('blood_donation_campaign_footer_youtube_link')); ?>"><i class="fa-brands fa-youtube"></i></a>
                    <?php } ?>
                </div>
            <?php } ?>
        </div>
    </div>
</div>

<?php if(get_theme_mod('blood_donation_campaign_scroll_hide',true)){ ?>
    <a id="button"><?php echo esc_html( get_theme_mod('blood_donation_campaign_scroll_text',__('TOP', 'blood-donation-campaign' )) ); ?></a>
<?php } ?>
  
<?php wp_footer(); ?>
</body>
</html>
