<?php
/**
 * The template for displaying 404 pages (Not Found).
 *
 * @package Blood Donation Campaign
 */

get_header(); ?>

<div class="container">
    <div id="content" class="contentsecwrap">
        <section class="site-main page-not-found">
            <header class="page-header">
                <h1 class="entry-title">
                    <?php echo esc_html(get_theme_mod('blood_donation_campaign_page_not_found_heading',__('404 Not Found','blood-donation-campaign')));?>
                </h1>
            </header>
            <div class="page-content">
                <p>
                    <?php echo esc_html(get_theme_mod('blood_donation_campaign_page_not_found_content',__( 'Looks like you have taken a wrong turn.....Don\'t worry... it happens to the best of us.', 'blood-donation-campaign' ))); ?>
                </p>
                <?php if( get_theme_mod('blood_donation_campaign_page_not_found_btn','Homepage') != ''){ ?>
                    <div class="not-found-btn mt-3 mb-4 mx-0">
                        <a href="<?php echo esc_url( home_url() ); ?>" class="button py-2 px-3"><?php echo esc_html(get_theme_mod('blood_donation_campaign_page_not_found_btn',__('Homepage','blood-donation-campaign')));?><span class="screen-reader-text"><?php echo esc_html(get_theme_mod('blood_donation_campaign_page_not_found_btn',__('Homepage','blood-donation-campaign')));?></span></a>
                    </div>
                <?php } ?>
            </div>
        </section>
        <div class="clear"></div>
    </div>
</div>

<?php get_footer(); ?>
