<?php
/**
 * Header Cart Widget icon.
 *
 * @package Blogun
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$blogun_cart_count = WC()->cart->get_cart_contents_count();
$blogun_cart_icon  = apply_filters( 'blogun_wc_cart_widget_icon', 'shopping-bag' );

?>
<a href="<?php echo esc_url( wc_get_cart_url() ); ?>" class="blogun-cart">
	<?php echo blogun()->icons->get_svg( $blogun_cart_icon ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
	<?php if ( $blogun_cart_count > 0 ) { ?>
		<span class="blogun-cart-count"><?php echo esc_html( $blogun_cart_count ); ?></span>
	<?php } ?>
</a>
