<?php
/**
 * Header Cart Widget dropdown header.
 *
 * @package Blogun
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$blogun_cart_count    = WC()->cart->get_cart_contents_count();
$blogun_cart_subtotal = WC()->cart->get_cart_subtotal();

?>
<div class="wc-cart-widget-header">
	<span class="blogun-cart-count">
		<?php
		/* translators: %s: the number of cart items; */
		echo wp_kses_post( sprintf( _n( '%s item', '%s items', $blogun_cart_count, 'blogun' ), $blogun_cart_count ) );
		?>
	</span>

	<span class="blogun-cart-subtotal">
		<?php
		/* translators: %s is the cart subtotal. */
		echo wp_kses_post( sprintf( __( 'Subtotal: %s', 'blogun' ), '<span>' . $blogun_cart_subtotal . '</span>' ) );
		?>
	</span>
</div>
