<?php
/**
 * The template for displaying Hero Hover Slider.
 *
 * @package     Blogun
 * @author      Peregrine Themes
 * @since       1.0.0
 */

$blogun_ticker_categories = ! empty( $blogun_ticker_categories ) ? implode( ', ', $blogun_ticker_categories ) : '';

// Setup Hero posts.
$blogun_args = array(
	'post_type'           => 'post',
	'post_status'         => 'publish',
	'posts_per_page'      => blogun_option( 'ticker_post_number' ), // phpcs:ignore WordPress.WP.PostsPerPage.posts_per_page_posts_per_page
	'ignore_sticky_posts' => true,
	'tax_query'           => array( // phpcs:ignore WordPress.DB.SlowDBQuery.slow_db_query_tax_query
		array(
			'taxonomy' => 'post_format',
			'field'    => 'slug',
			'terms'    => array( 'post-format-quote' ),
			'operator' => 'NOT IN',
		),
	),
);

$blogun_ticker_categories = blogun_option( 'ticker_category' );

if ( ! empty( $blogun_ticker_categories ) ) {
	$blogun_args['category_name'] = implode( ', ', $blogun_ticker_categories );
}

$blogun_args = apply_filters( 'blogun_ticker_query_args', $blogun_args );

$blogun_posts = new WP_Query( $blogun_args );

// No posts found.
if ( ! $blogun_posts->have_posts() ) {
	return;
}

$blogun_ticker_items_html = '';

$blogun_ticker_elements = (array) blogun_option( 'ticker_elements' );

while ( $blogun_posts->have_posts() ) :
	$blogun_posts->the_post();

	// Post items HTML markup.
	ob_start();
	?>
	<div class="ticker-slide-item">

		<?php if ( get_the_post_thumbnail_url( get_the_ID(), 'full' ) ) { ?>
		<div class="ticker-slider-backgrounds">
			<a href="<?php echo esc_url( blogun_entry_get_permalink() ); ?>">
				<div class="ticker-slide-bg" style="background-image:url(<?php echo esc_url( get_the_post_thumbnail_url( get_the_ID(), 'full' ) ); ?>)"></div>
			</a>
		</div><!-- END .ticker-slider-items -->
		<?php } ?>

		<div class="slide-inner">				

			<?php if ( get_the_title() ) { ?>
				<h6><a href="<?php echo esc_url( blogun_entry_get_permalink() ); ?>"><?php the_title(); ?></a></h6>
			<?php } ?>

			<?php if ( isset( $blogun_ticker_elements['meta'] ) && $blogun_ticker_elements['meta'] ) { ?>
				<div class="entry-meta">
					<div class="entry-meta-elements">
						<?php
						blogun_entry_meta_date(
							array(
								'show_modified'   => false,
								'published_label' => '',
							)
						);
						?>
					</div>
				</div><!-- END .entry-meta -->
			<?php } ?>

		</div><!-- END .slide-inner -->
	</div><!-- END .ticker-slide-item -->
	<?php
	$blogun_ticker_items_html .= ob_get_clean();
endwhile;

// Restore original Post Data.
wp_reset_postdata();

// Hero container.
$blogun_ticker_container = blogun_option( 'ticker_container' );
$blogun_ticker_container = 'full-width' === $blogun_ticker_container ? 'blogun-container blogun-container__wide' : 'blogun-container';

$blogun_ticker_title = blogun()->options->get( 'blogun_ticker_title' );

?>

<div class="blogun-ticker-slider">

	<div class="blogun-ticker-container <?php echo esc_attr( $blogun_ticker_container ); ?>">
		<div class="blogun-flex-row">
			<div class="col-xs-12">
				<div class="ticker-slider-items">
					<?php if ( $blogun_ticker_title ) : ?>
					<div class="ticker-title">
						<span class="icon">
							<i class="fas fa-bolt"></i>
						</span>
						<span class="title"><?php echo esc_html( $blogun_ticker_title ); ?></span>
					</div>
					<?php endif; ?>
					<?php
						$ticker_direction = 'left';
						$ticker_dir       = 'ltr';
					if ( is_rtl() ) {
						$ticker_direction = 'right';
						$ticker_dir       = 'ltr';
					}
					?>
					<div class="ticker-slider-box">
						<div class="ticker-slider-wrap" direction="<?php echo esc_attr( $ticker_direction ); ?>" dir="<?php echo esc_attr( $ticker_dir ); ?>">
							<?php echo wp_kses_post( $blogun_ticker_items_html ); ?>
						</div>
					</div>
					<div class="ticker-slider-controls">
						<button class="ticker-slider-pause"><i class="fas fa-pause"></i></button>
					</div>
				</div>
			</div>
		</div><!-- END .ticker-slider-items -->
	</div>
</div><!-- END .blogun-ticker-slider -->
