<?php
/**
 * The template for displaying Hero Hover Slider.
 *
 * @package     Blogun
 * @author      Peregrine Themes
 * @since       1.0.0
 */

$blogun_pyml_categories = ! empty( $blogun_pyml_categories ) ? implode( ', ', $blogun_pyml_categories ) : '';

// Setup Hero posts.
$blogun_args = array(
	'post_type'           => 'post',
	'post_status'         => 'publish',
	'posts_per_page'      => blogun_option( 'pyml_post_number' ), // phpcs:ignore WordPress.WP.PostsPerPage.posts_per_page_posts_per_page
	'ignore_sticky_posts' => true,
	'tax_query'           => array( // phpcs:ignore WordPress.DB.SlowDBQuery.slow_db_query_tax_query
		array(
			'taxonomy' => 'post_format',
			'field'    => 'slug',
			'terms'    => array( 'post-format-quote' ),
			'operator' => 'NOT IN',
		),
	),
);

$blogun_pyml_categories = blogun_option( 'pyml_category' );

if ( ! empty( $blogun_pyml_categories ) ) {
	$blogun_args['category_name'] = implode( ', ', $blogun_pyml_categories );
}

$blogun_args = apply_filters( 'blogun_pyml_query_args', $blogun_args );

$blogun_posts = new WP_Query( $blogun_args );

// No posts found.
if ( ! $blogun_posts->have_posts() ) {
	return;
}

// $blogun_pyml_bgs_html   = '';
$blogun_pyml_items_html = '';

$blogun_pyml_elements = (array) blogun_option( 'pyml_elements' );

$blogun_pyml_posts_carousel = blogun_option( 'pyml_posts_carousel' );

$blogun_posts_per_page = 'col-md-' . ceil( esc_attr( 12 / $blogun_args['posts_per_page'] ) ) . ' col-sm-12 col-xs-12';

while ( $blogun_posts->have_posts() ) :
	$blogun_posts->the_post();

	// Background images HTML markup.
	// $blogun_pyml_bgs_html .= '<div class="pyml-slide-bg" style="background-image:url(' . get_the_post_thumbnail_url( get_the_ID(), 'full' ) . ')"></div>';

	// Post items HTML markup.
	ob_start();
	?>
	<div class="<?php echo $blogun_posts_per_page; ?>">
		<div class="pyml-slide-item">

			<div class="pyml-slider-backgrounds">
				<a href="<?php echo esc_url( blogun_entry_get_permalink() ); ?>">
					<div class="pyml-slide-bg" style="background-image:url(<?php echo esc_url( get_the_post_thumbnail_url( get_the_ID(), 'full' ) ); ?>)"></div>
				</a>
				<?php if ( isset( $blogun_pyml_elements['category'] ) && $blogun_pyml_elements['category'] ) { ?>
					<div class="post-category">
						<?php blogun_entry_meta_category( ' ', false ); ?>
					</div>
				<?php } ?>
			</div><!-- END .pyml-slider-items -->

			<div class="slide-inner">				

				<?php if ( get_the_title() ) { ?>
					<h6><a href="<?php echo esc_url( blogun_entry_get_permalink() ); ?>"><?php the_title(); ?></a></h6>
				<?php } ?>

				<?php if ( isset( $blogun_pyml_elements['meta'] ) && $blogun_pyml_elements['meta'] ) { ?>
					<div class="entry-meta">
						<div class="entry-meta-elements">
							<?php
							blogun_entry_meta_author();

							blogun_entry_meta_date(
								array(
									'show_modified'   => false,
									'published_label' => '',
								)
							);
							?>
						</div>
					</div><!-- END .entry-meta -->
				<?php } ?>

			</div><!-- END .slide-inner -->
		</div><!-- END .pyml-slide-item -->
	</div><!-- END .pyml-slider-item-wrapper -->
	<?php
	$blogun_pyml_items_html .= ob_get_clean();
endwhile;

// Restore original Post Data.
wp_reset_postdata();

// Hero container.
$blogun_pyml_container = blogun_option( 'pyml_container' );
$blogun_pyml_container = 'full-width' === $blogun_pyml_container ? 'blogun-container blogun-container__wide' : 'blogun-container';

$blogun_pyml_title = blogun()->options->get( 'blogun_pyml_title' );

?>

<div class="blogun-pyml-slider">

	<div class="blogun-pyml-container <?php echo esc_attr( $blogun_pyml_container ); ?>">
		<div class="blogun-flex-row">
			<div class="col-xs-12">
				<div class="pyml-slider-items">
					<div class="h4 widget-title">
						<?php if ( $blogun_pyml_title ) : ?>
						<span><?php echo esc_html( $blogun_pyml_title ); ?></span>
						<?php endif; ?>
					</div>

					<div class="blogun-flex-row gy-4">
						<?php echo wp_kses_post( $blogun_pyml_items_html ); ?>
					</div>
				</div>
			</div>
		</div><!-- END .pyml-slider-items -->
	</div>
</div><!-- END .blogun-pyml-slider -->
