<?php
/**
 * The template for displaying scroll to top button.
 *
 * @package     Blogun
 * @author      Peregrine Themes
 * @since       1.0.0
 */

?>

<a href="#" id="blogun-scroll-top" class="blogun-smooth-scroll" title="<?php esc_attr_e( 'Scroll to Top', 'blogun' ); ?>" <?php blogun_scroll_top_classes(); ?>>
	<span class="blogun-scroll-icon" aria-hidden="true">
		<?php echo blogun()->icons->get_svg( 'chevron-up', array( 'class' => 'top-icon' ) ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
		<?php echo blogun()->icons->get_svg( 'chevron-up' ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
	</span>
	<span class="screen-reader-text"><?php esc_html_e( 'Scroll to Top', 'blogun' ); ?></span>
</a><!-- END #blogun-scroll-to-top -->
