<?php
/**
 * The template for displaying Hero Hover Slider.
 *
 * @package     Blogun
 * @author      Peregrine Themes
 * @since       1.0.0
 */

$blogun_hero_categories = ! empty( $blogun_hero_categories ) ? implode( ', ', $blogun_hero_categories ) : '';

$hero_hover_slider_post_number_count = blogun_option( 'hero_hover_slider_post_number' ) >= 2 ? 2 : 1;

// Setup Hero posts.
$blogun_args = array(
	'post_type'           => 'post',
	'post_status'         => 'publish',
	'posts_per_page'      => $hero_hover_slider_post_number_count, // phpcs:ignore WordPress.WP.PostsPerPage.posts_per_page_posts_per_page
	'ignore_sticky_posts' => true,
	'tax_query'           => array( // phpcs:ignore WordPress.DB.SlowDBQuery.slow_db_query_tax_query
		array(
			'taxonomy' => 'post_format',
			'field'    => 'slug',
			'terms'    => array( 'post-format-quote' ),
			'operator' => 'NOT IN',
		),
	),
);

$blogun_hero_categories = blogun_option( 'hero_hover_slider_category' );

if ( ! empty( $blogun_hero_categories ) ) {
	$blogun_args['category_name'] = implode( ', ', $blogun_hero_categories );
}

$blogun_args = apply_filters( 'blogun_hero_hover_slider_query_args', $blogun_args );

$blogun_posts = new WP_Query( $blogun_args );

// No posts found.
if ( ! $blogun_posts->have_posts() ) {
	return;
}

$blogun_hero_bgs_html   = '';
$blogun_hero_items_html = '';

$blogun_hero_elements = (array) blogun_option( 'hero_hover_slider_elements' );
$blogun_hero_readmore = isset( $blogun_hero_elements['read_more'] ) && $blogun_hero_elements['read_more'] ? ' blogun-hero-readmore' : '';

while ( $blogun_posts->have_posts() ) :
	$blogun_posts->the_post();

	// Background images HTML markup.
	$blogun_hero_bgs_html .= '<div class="hover-slide-bg" data-background="' . get_the_post_thumbnail_url( get_the_ID(), 'full' ) . '"></div>';

	// Post items HTML markup.
	ob_start();
	?>
	<div class="col-xs-<?php echo esc_attr( 12 / $blogun_args['posts_per_page'] ); ?> hover-slider-item-wrapper<?php echo esc_attr( $blogun_hero_readmore ); ?>">
		<div class="hover-slide-item">
			<div class="slide-inner">

				<?php if ( isset( $blogun_hero_elements['category'] ) && $blogun_hero_elements['category'] ) { ?>
					<div class="post-category">
						<?php blogun_entry_meta_category( ' ', false ); ?>
					</div>
				<?php } ?>

				<?php if ( get_the_title() ) { ?>
					<h3><a href="<?php echo esc_url( blogun_entry_get_permalink() ); ?>"><?php the_title(); ?></a></h3>
				<?php } ?>

				<?php if ( isset( $blogun_hero_elements['meta'] ) && $blogun_hero_elements['meta'] ) { ?>
					<div class="entry-meta">
						<div class="entry-meta-elements">
							<?php
							blogun_entry_meta_author();

							blogun_entry_meta_date(
								array(
									'show_modified'   => false,
									'published_label' => '',
								)
							);
							?>
						</div>
					</div><!-- END .entry-meta -->
				<?php } ?>

				<?php if ( $blogun_hero_readmore ) { ?>
					<a href="<?php echo esc_url( blogun_entry_get_permalink() ); ?>" class="read-more blogun-btn btn-small btn-outline btn-uppercase" role="button"><span><?php esc_html_e( 'Continue Reading', 'blogun' ); ?></span></a>
				<?php } ?>

			</div><!-- END .slide-inner -->
		</div><!-- END .hover-slide-item -->
	</div><!-- END .hover-slider-item-wrapper -->
	<?php
	$blogun_hero_items_html .= ob_get_clean();
endwhile;

// Restore original Post Data.
wp_reset_postdata();

// Hero container.
$blogun_hero_container = blogun_option( 'hero_hover_slider_container' );
$blogun_hero_container = 'full-width' === $blogun_hero_container ? 'blogun-container blogun-container__wide' : 'blogun-container';

// Hero overlay.
$blogun_hero_overlay = absint( blogun_option( 'hero_hover_slider_overlay' ) );
?>

<div class="blogun-hover-slider slider-overlay-<?php echo esc_attr( $blogun_hero_overlay ); ?>">
	<div class="hover-slider-backgrounds">

		<?php echo wp_kses_post( $blogun_hero_bgs_html ); ?>

	</div><!-- END .hover-slider-items -->

	<div class="blogun-hero-container <?php echo esc_attr( $blogun_hero_container ); ?>">
		<div class="blogun-flex-row hover-slider-items">

			<?php echo wp_kses_post( $blogun_hero_items_html ); ?>

		</div><!-- END .hover-slider-items -->
	</div>

	<div class="blogun-spinner visible">
		<div></div>
		<div></div>
	</div>
</div><!-- END .blogun-hover-slider -->
